import ES5 = require('./es5');
import type { PropertyKey as ESPropertyKey } from './index';

interface ES2015 {
    readonly 'Abstract Equality Comparison': typeof import('./2015/AbstractEqualityComparison');
    readonly 'Abstract Relational Comparison': typeof import('./2015/AbstractRelationalComparison');
    readonly 'Strict Equality Comparison': typeof import('./2015/StrictEqualityComparison');
    readonly AdvanceStringIndex: typeof import('./2015/AdvanceStringIndex');
    readonly ArrayCreate: typeof import('./2015/ArrayCreate');
    readonly ArraySetLength: typeof import('./2015/ArraySetLength');
    readonly ArraySpeciesCreate: typeof import('./2015/ArraySpeciesCreate');
    readonly Call: typeof import('./2015/Call');
    readonly CanonicalNumericIndexString: typeof import('./2015/CanonicalNumericIndexString');
    readonly CompletePropertyDescriptor: typeof import('./2015/CompletePropertyDescriptor');
    readonly CreateDataProperty: typeof import('./2015/CreateDataProperty');
    readonly CreateDataPropertyOrThrow: typeof import('./2015/CreateDataPropertyOrThrow');
    readonly CreateHTML: typeof import('./2015/CreateHTML');
    readonly CreateIterResultObject: typeof import('./2015/CreateIterResultObject');
    readonly CreateListFromArrayLike: typeof import('./2015/CreateListFromArrayLike');
    readonly CreateMethodProperty: typeof import('./2015/CreateMethodProperty');
    readonly DateFromTime: typeof import('./2015/DateFromTime');
    readonly Day: typeof import('./2015/Day');
    readonly DayFromYear: typeof import('./2015/DayFromYear');
    readonly DaysInYear: typeof import('./2015/DaysInYear');
    readonly DayWithinYear: typeof import('./2015/DayWithinYear');
    readonly DefinePropertyOrThrow: typeof import('./2015/DefinePropertyOrThrow');
    readonly DeletePropertyOrThrow: typeof import('./2015/DeletePropertyOrThrow');
    readonly EnumerableOwnNames: typeof import('./2015/EnumerableOwnNames');
    readonly FromPropertyDescriptor: typeof import('./2015/FromPropertyDescriptor');
    readonly Get: typeof import('./2015/Get');
    readonly GetIterator: typeof import('./2015/GetIterator');
    readonly GetMethod: typeof import('./2015/GetMethod');
    readonly GetOwnPropertyKeys: typeof import('./2015/GetOwnPropertyKeys');
    readonly GetPrototypeFromConstructor: typeof import('./2015/GetPrototypeFromConstructor');
    readonly GetSubstitution: typeof import('./2015/GetSubstitution');
    readonly GetV: typeof import('./2015/GetV');
    readonly HasOwnProperty: typeof import('./2015/HasOwnProperty');
    readonly HasProperty: typeof import('./2015/HasProperty');
    readonly HourFromTime: typeof import('./2015/HourFromTime');
    readonly InLeapYear: typeof import('./2015/InLeapYear');
    readonly InstanceofOperator: typeof import('./2015/InstanceofOperator');
    readonly Invoke: typeof import('./2015/Invoke');
    readonly IsAccessorDescriptor: typeof import('./2015/IsAccessorDescriptor');
    readonly IsArray: typeof import('./2015/IsArray');
    readonly IsCallable: typeof import('./2015/IsCallable');
    readonly IsConcatSpreadable: typeof import('./2015/IsConcatSpreadable');
    readonly IsConstructor: typeof import('./2015/IsConstructor');
    readonly IsDataDescriptor: typeof import('./2015/IsDataDescriptor');
    readonly IsExtensible: typeof import('./2015/IsExtensible');
    readonly IsGenericDescriptor: typeof import('./2015/IsGenericDescriptor');
    readonly IsInteger: typeof import('./2015/IsInteger');
    readonly IsPromise: typeof import('./2015/IsPromise');
    readonly IsPropertyDescriptor: typeof import('./2015/IsPropertyDescriptor');
    readonly IsPropertyKey: typeof import('./2015/IsPropertyKey');
    readonly IsRegExp: typeof import('./2015/IsRegExp');
    readonly IteratorClose: typeof import('./2015/IteratorClose');
    readonly IteratorComplete: typeof import('./2015/IteratorComplete');
    readonly IteratorNext: typeof import('./2015/IteratorNext');
    readonly IteratorStep: typeof import('./2015/IteratorStep');
    readonly IteratorValue: typeof import('./2015/IteratorValue');
    readonly MakeDate: typeof import('./2015/MakeDate');
    readonly MakeDay: typeof import('./2015/MakeDay');
    readonly MakeTime: typeof import('./2015/MakeTime');
    readonly MinFromTime: typeof import('./2015/MinFromTime');
    readonly modulo: typeof import('./2015/modulo');
    readonly MonthFromTime: typeof import('./2015/MonthFromTime');
    readonly msFromTime: typeof import('./2015/msFromTime');
    readonly ObjectCreate: typeof import('./2015/ObjectCreate');
    readonly OrdinaryDefineOwnProperty: typeof import('./2015/OrdinaryDefineOwnProperty');
    readonly OrdinaryGetOwnProperty: typeof import('./2015/OrdinaryGetOwnProperty');
    readonly OrdinaryHasInstance: typeof import('./2015/OrdinaryHasInstance');
    readonly OrdinaryHasProperty: typeof import('./2015/OrdinaryHasProperty');
    readonly RegExpExec: typeof import('./2015/RegExpExec');
    readonly RequireObjectCoercible: typeof import('./2015/RequireObjectCoercible');
    readonly SameValue: typeof import('./2015/SameValue');
    readonly SameValueZero: typeof import('./2015/SameValueZero');
    readonly SecFromTime: typeof import('./2015/SecFromTime');
    readonly Set: typeof import('./2015/Set');
    readonly SetFunctionName: typeof import('./2015/SetFunctionName');
    readonly SetIntegrityLevel: typeof import('./2015/SetIntegrityLevel');
    readonly SpeciesConstructor: typeof import('./2015/SpeciesConstructor');
    readonly SymbolDescriptiveString: typeof import('./2015/SymbolDescriptiveString');
    readonly TestIntegrityLevel: typeof import('./2015/TestIntegrityLevel');
    readonly thisBooleanValue: typeof import('./2015/thisBooleanValue');
    readonly thisNumberValue: typeof import('./2015/thisNumberValue');
    readonly thisStringValue: typeof import('./2015/thisStringValue');
    readonly thisTimeValue: typeof import('./2015/thisTimeValue');
    readonly TimeClip: typeof import('./2015/TimeClip');
    readonly TimeFromYear: typeof import('./2015/TimeFromYear');
    readonly TimeWithinDay: typeof import('./2015/TimeWithinDay');
    readonly ToBoolean: typeof import('./2015/ToBoolean');
    readonly ToDateString: typeof import('./2015/ToDateString');
    readonly ToInt16: typeof import('./2015/ToInt16');
    readonly ToInt32: typeof import('./2015/ToInt32');
    readonly ToInt8: typeof import('./2015/ToInt8');
    readonly ToInteger: typeof import('./2015/ToInteger');
    readonly ToLength: typeof import('./2015/ToLength');
    readonly ToNumber: typeof import('./2015/ToNumber');
    readonly ToObject: typeof import('./2015/ToObject');
    readonly ToPrimitive: typeof import('./2015/ToPrimitive');
    readonly ToPropertyDescriptor: typeof import('./2015/ToPropertyDescriptor');
    readonly ToPropertyKey: typeof import('./2015/ToPropertyKey');
    readonly ToString: typeof import('./2015/ToString');
    readonly ToUint16: typeof import('./2015/ToUint16');
    readonly ToUint32: typeof import('./2015/ToUint32');
    readonly ToUint8: typeof import('./2015/ToUint8');
    readonly ToUint8Clamp: typeof import('./2015/ToUint8Clamp');
    readonly Type: typeof import('./2015/Type');
    readonly ValidateAndApplyPropertyDescriptor: typeof import('./2015/ValidateAndApplyPropertyDescriptor');
    readonly WeekDay: typeof import('./2015/WeekDay');
    readonly YearFromTime: typeof import('./2015/YearFromTime');
}

declare namespace ES2015 {
    type PropertyKey = ESPropertyKey;

    // Re-export types from previous versions
    // - ES5:
    type GenericDescriptor = ES5.GenericDescriptor;
    type AccessorDescriptor<T = unknown> = ES5.AccessorDescriptor<T>;
    type DataDescriptor<T = unknown> = ES5.DataDescriptor<T>;
    type PropertyDescriptor<T = unknown> = ES5.PropertyDescriptor<T>;
}

declare const ES2015: ES2015;
export = ES2015;
