package pinyin

// ----
// 词典文件来源 https://github.com/overtrue/pinyin/blob/master/data/
// ----

var (
	// dict 词典
	dict = []string{
		"踉踉跄跄", "	liang4	liang4	qiang4	qiang4",
		"可逆反应", "	ke3	ni4	fan3	ying4",
		"口腹之累", "	kou3	fu4	zhi1	lei3",
		"质疑问难", "	zhi4	yi2	wen4	nan4",
		"收入差距", "	shou1	ru4	cha1	ju4",
		"直言贾祸", "	zhi2	yan2	gu3	huo4",
		"刻鹄成鹜", "	ke4	hu2	cheng2	wu4",
		"克尽厥职", "	ke4	jin4	jue2	zhi2",
		"收支差额", "	shou1	zhi1	cha1	e2",
		"首足异处", "	shou3	zu2	yi4	chu3",
		"置之高阁", "	zhi4	zhi1	gao1	ge2",
		"还珠合浦", "	huan2	zhu1	he2	pu3",
		"认贼作子", "	ren4	zei2	zuo4	zi3",
		"患难夫妻", "	huan4	nan4	fu1	qi1",
		"课嘴撩牙", "	ke4	zui3	liao2	ya2",
		"认贼为子", "	ren4	zei2	wei2	zi3",
		"还朴反古", "	huan2	pu3	fan3	gu3",
		"长安棋局", "	chang2	an1	qi2	ju2",
		"看不习惯", "	kan1	bu4	xi2	guan4",
		"只鸡樽酒", "	zhi1	ji1	zun1	jiu3",
		"华亭鹤唳", "	hua4	ting2	he4	li4",
		"芝麻开花", "	zhi1	ma	kai1	hua1",
		"破涕为笑", "	po4	ti4	wei2	xiao4",
		"陟罚臧否", "	zhi4	fa2	zang1	pi3",
		"知识分子", "	zhi1	shi2	fen4	zi3",
		"知识宝库", "	zhi1	shi	bao3	ku4",
		"认贼为父", "	ren4	zei2	wei2	fu4",
		"苦苦相逼", "	ku3	ku3	xiang4	bi1",
		"至当不易", "	zhi4	dang4	bu4	yi4",
		"数米而炊", "	shu3	mi3	er2	chui1",
		"稚齿婑媠", "	zhi4	chi3	wo3	tuo3",
		"差之毫厘", "	cha1	zhi1	hao2	li2",
		"科学知识", "	ke1	xue2	zhi1	shi",
		"差三错四", "	cha1	san1	cuo4	si4",
		"画龙刻鹄", "	hua4	long2	ke4	hu2",
		"会计分录", "	kuai4	ji4	fen1	lu4",
		"化害为利", "	hua4	hai4	wei2	li4",
		"辙乱旗靡", "	zhe2	luan4	qi2	mi3",
		"画荻和丸", "	hua4	di2	huo4	wan2",
		"测量记录", "	ce4	liang2	ji4	lu4",
		"会计信息", "	kuai4	ji4	xin4	xi1",
		"看在眼里", "	kan4	zai4	yan3	li",
		"只轮无反", "	zhi1	lun2	wu2	fan3",
		"数米量柴", "	shu3	mi3	er2	chai2",
		"尽其所有", "	jin4	qi2	suo3	you3",
		"耻与哙伍", "	chi3	yu2	kuai4	wu3",
		"子宫内膜", "	zi3	gong1	nei4	mo2",
		"温情脉脉", "	wen1	qing2	mo4	mo4",
		"简丝数米", "	jian3	si1	shu3	mi3",
		"救苦救难", "	jiu4	ku3	jiu4	nan4",
		"三灾八难", "	san1	zai1	ba1	nan4",
		"救黥医劓", "	jiu4	qing2	yi1	yi4",
		"身单力薄", "	shen1	dan1	li4	bo2",
		"竭尽心力", "	jie2	jin4	xin1	li4",
		"九行八业", "	jiu3	hang2	ba1	ye4",
		"泊松分布", "	bo2	song1	fen1	bu4",
		"称体裁衣", "	chen4	ti3	cai2	yi1",
		"解衣磅礴", "	jie3	yi1	pang2	bo2",
		"设计要求", "	she4	ji4	yao1	qiu2",
		"解衣卸甲", "	jie3	yi1	xie4	jia3",
		"竭智尽力", "	jie2	zhi4	jin4	li4",
		"尽瘁至死", "	jin4	cui4	zhi4	si3",
		"山雨欲来", "	shan1	yu3	yu4	lai2",
		"齿牙为祸", "	chi3	ya2	wei2	huo4",
		"齿牙为猾", "	chi3	ya2	wei2	hua2",
		"只轮不反", "	zhi1	lun2	bu4	fan3",
		"混水摸鱼", "	hun2	shui3	mo1	yu2",
		"朝云暮雨", "	zhao1	yun2	mu4	yu3",
		"逐物不还", "	zhu2	wu4	bu4	huan2",
		"独生子女", "	du2	sheng1	zi3	nv3",
		"深信不疑", "	shen1	xin4	bu4	yi2",
		"租赁合同", "	zu1	lin4	he2	tong",
		"甚而至于", "	shen4	er2	zhi4	yu2",
		"杀鸡为黍", "	sha1	ji1	wei2	shu3",
		"经史子集", "	jing1	shi3	zi3	ji2",
		"煞费心机", "	sha4	fei4	xin1	ji1",
		"见义必为", "	jian4	yi4	bi4	wei2",
		"混为一谈", "	hun4	wei2	yi1	tan2",
		"子曰诗云", "	zi3	yue4	shi1	yun2",
		"扫眉才子", "	sao3	mei2	cai2	zi3",
		"九垓八埏", "	jiu3	gai1	ba1	yan2",
		"自我调节", "	zi4	wo3	tiao2	jie2",
		"金鳷擘海", "	jin1	zhi1	bo4	hai3",
		"子孙万代", "	zi3	sun1	wan4	dai4",
		"子孙后代", "	zi3	sun1	hou4	dai4",
		"指腹为婚", "	zhi3	fu4	wei2	hun1",
		"尽职尽责", "	jin4	zhi2	jin4	ze2",
		"尽态极妍", "	jin4	tai4	ji2	yan2",
		"安身为乐", "	an1	shen1	wei2	le4",
		"见素抱朴", "	xian4	su4	bao4	pu3",
		"阿房宫赋", "	e1	pang2	gong1	fu4",
		"屙金溺银", "	e1	jin1	niao4	yin2",
		"遐迩著闻", "	xia2	er3	zhu4	wen2",
		"阿党比周", "	e1	dang3	bi3	zhou1",
		"朵颐大嚼", "	duo3	yi1	da4	jiao2",
		"误作非为", "	wu4	zuo4	fei1	wei2",
		"系统设计", "	xi4	tong3	she4	ji4",
		"倒峡泻河", "	dao3	xia2	xie4	he2",
		"阿谀逢迎", "	e1	yu2	feng2	ying2",
		"捣虚批吭", "	dao3	xu1	pi1	hang2",
		"攀藤附葛", "	pan1	teng2	fu4	ge3",
		"晰毛辨发", "	xi1	mao2	bian4	fa4",
		"多文为富", "	duo1	wen2	wei2	fu4",
		"垂头搨翼", "	chui2	tou2	da2	yi4",
		"画荻教子", "	hua4	di2	jiao4	zi3",
		"倡而不和", "	chang4	er2	bu4	he4",
		"攫为己有", "	jue2	wei2	ji3	you3",
		"细高挑儿", "	xi4	gao1	tiao3	er2",
		"披发文身", "	pi1	fa4	wen2	shen1",
		"当回事儿", "	dang4	hui2	shi4	r",
		"捧心西子", "	peng3	xin1	xi1	zi3",
		"捱三顶五", "	ai1	san1	ding3	wu3",
		"捱三顶四", "	ai1	san1	ding3	si4",
		"爱人好士", "	ai4	ren2	hao4	shi4",
		"旁指曲谕", "	pang2	zhi3	qu3	yu4",
		"无下箸处", "	wu2	xia4	zhu4	chu3",
		"跑马卖解", "	pao3	ma3	mai4	xie4",
		"挨冻受饿", "	ai2	dong4	shou4	e4",
		"顿开茅塞", "	dun4	kai1	mao2	se4",
		"睹著知微", "	du3	zhu4	zhi1	wei1",
		"睹微知著", "	du3	wei1	zhi1	zhu4",
		"开锣喝道", "	kai1	luo2	he4	dao4",
		"倒载干戈", "	dao4	zai4	gan1	ge1",
		"阿平绝倒", "	a1	ping2	jue2	dao3",
		"无为之治", "	wu2	wei2	zhi1	zhi4",
		"同心一意", "	tong2	xin1	yi1	yi4",
		"批风抹月", "	pi1	feng1	mo4	yue4",
		"鼠疫杆菌", "	shu3	yi4	gan3	jun1",
		"污水处理", "	wu1	shui3	chu3	li3",
		"货而不售", "	huo	er	bu	shou",
		"绝子绝孙", "	jue2	zi3	jue2	sun1",
		"捐躯赴难", "	juan1	qu1	fu4	nan4",
		"日新月著", "	ri4	xin1	yue4	zhu4",
		"积谗糜骨", "	ji1	chan2	mei2	gu3",
		"琴瑟不调", "	qin2	se4	bu4	tiao2",
		"竹篱茅舍", "	zhu2	li2	mao2	she4",
		"绝对误差", "	jue2	dui4	wu4	cha1",
		"豁然开悟", "	huo4	ran2	kai1	wu4",
		"几不欲生", "	ji1	bu4	yu4	sheng1",
		"基本要求", "	ji1	ben3	yao1	qiu2",
		"基本电荷", "	ji1	ben3	dian4	he4",
		"什伍东西", "	shi2	wu3	dong1	xi1",
		"十魔九难", "	shi2	mo2	jiu3	nan4",
		"铢积寸累", "	zhu1	ji1	cun4	lei3",
		"用得其所", "	yong4	de	qi2	suo3",
		"什袭而藏", "	shi2	xi1	er2	cang2",
		"珠还合浦", "	zhu1	huan2	he2	pu3",
		"什袭以藏", "	shi2	xi2	yi3	cang2",
		"男子篮球", "	nan2	zi3	lan2	qiu2",
		"豁然确斯", "	huo4	ran2	que4	si1",
		"日省月课", "	ri4	xing3	yue4	ke4",
		"积德累善", "	ji1	de2	lei3	shan4",
		"玩儿花招", "	wan2	r	hua1	zhao1",
		"昼度夜思", "	zhou4	duo2	ye4	si1",
		"事与心违", "	shi4	yu4	xin1	wei2",
		"均匀分布", "	jun1	yun2	fen1	bu4",
		"发奋有为", "	fa1	fen4	you3	wei2",
		"日进斗金", "	ri4	jin4	dou3	jin1",
		"画地为牢", "	hua4	di4	wei2	lao2",
		"白马王子", "	bai2	ma3	wang2	zi3",
		"魂不着体", "	hun2	bu4	zhuo2	ti3",
		"君子好逑", "	jun1	zi3	hao3	qiu2",
		"君子三戒", "	jun1	zi3	san1	jie4",
		"益觉困难", "	yi4	jue2	kun4	nan",
		"玩儿得转", "	wan2	r	de2	zhuan4",
		"诗云子曰", "	shi1	yun2	zi3	yue4",
		"尽心尽力", "	jin4	xin1	jin4	li4",
		"晦盲否塞", "	hui4	mang2	pi3	se4",
		"百度知道", "	bai3	du4	zhi1	dao",
		"尽心竭力", "	jin4	xin1	jie2	li4",
		"豁然顿悟", "	huo4	ran2	dun4	wu4",
		"急功好利", "	ji2	gong1	hao4	li4",
		"朱盘玉敦", "	zhu1	pan2	yu4	dui4",
		"活跃分子", "	huo2	yue4	fen4	zi3",
		"设心处虑", "	she4	xin1	chu3	lv4",
		"爱生恶死", "	ai4	sheng1	wu4	si3",
		"桂子兰孙", "	gui4	zi3	lan2	sun1",
		"鱼书雁帖", "	yu2	shu1	yan4	tie3",
		"与世沉浮", "	yu2	shi4	chen2	fu2",
		"思所逐之", "	si	shuo	zhu	zi",
		"不当人子", "	bu4	dang1	ren2	zi3",
		"过甚其辞", "	guo4	shen4	qi2	ci2",
		"诱掖后进", "	you4	ye4	hou4	jin4",
		"燎发摧枯", "	liao3	fa4	cui1	ku1",
		"过都历块", "	guo4	du1	li4	kuai4",
		"舌下含服", "	she2	xia4	han2	fu4",
		"不足为怪", "	bu4	zu2	wei2	guai4",
		"不差累黍", "	bu4	cha1	lei3	shu3",
		"舞台音乐", "	wu3	tai2	yin1	yue4",
		"有人家儿", "	you3	ren2	jia1	er2",
		"撩云拨雨", "	liao2	yun2	bo1	yu3",
		"波属云委", "	bo1	zhu3	yun2	wei3",
		"桂折一枝", "	gui4	she2	yi1	zhi1",
		"苦尽甘来", "	ku3	jin4	gan1	lai2",
		"拨云撩雨", "	bo1	yun2	liao2	yu3",
		"财殚力尽", "	cai2	dan1	li4	jin4",
		"麇至沓来", "	qun2	zhi4	ta4	lai2",
		"茅塞顿开", "	mao2	se4	dun4	kai1",
		"哺糟啜醨", "	bu3	zao1	chuo4	li2",
		"蠡测管窥", "	li3	ce4	guan3	kui1",
		"贼臣逆子", "	zei2	chen2	ni4	zi3",
		"不足为凭", "	bu4	zu2	wei2	ping2",
		"凿龟数策", "	zao2	gui1	shu3	ce4",
		"总理衙门", "	zong3	li3	ya2	men",
		"臧否人物", "	zang1	pi3	ren2	wu4",
		"河清难俟", "	he2	qing1	nan2	si4",
		"载驰载驱", "	zai3	chi2	zai3	qu1",
		"云朝雨暮", "	yun2	zhao1	yu3	mu4",
		"河落海干", "	he2	luo4	hai3	gan1",
		"罐头起子", "	guan4	tou	qi3	zi",
		"合浦珠还", "	he2	pu3	zhu1	huan2",
		"置之不问", "	zhi4	zhi1	bu4	wen4",
		"置之度外", "	zhi4	zhi1	du4	wai4",
		"合浦还珠", "	he2	pu3	huan2	zhu1",
		"罗锅儿桥", "	luo2	guo1	r	qiao2",
		"云泥之差", "	yun2	ni2	zhi1	cha1",
		"河南坠子", "	he2	nan2	zhui4	zi3",
		"圭角不露", "	gui1	jiao3	bu4	lu4",
		"拨雨撩云", "	bo1	yu3	liao2	yun2",
		"绿林好汉", "	lu4	lin2	hao3	han4",
		"积累毒性", "	ji1	lei3	du2	xing4",
		"水尽鹅飞", "	shui3	jin4	e2	fei1",
		"气势磅礴", "	qi4	shi4	pang2	bo2",
		"立地成佛", "	li4	di4	cheng2	fo2",
		"财务会计", "	cai2	wu4	kuai4	ji4",
		"朝发暮至", "	zhao1	fa1	mu4	zhi4",
		"积极反应", "	ji1	ji2	fan3	ying4",
		"粪金龟子", "	fen4	jin1	gui1	zi3",
		"朝不保暮", "	zhao1	bu4	bao3	mu4",
		"材优干济", "	cai2	you1	gan4	ji3",
		"优游自若", "	you1	you2	zi4	ruo4",
		"热闹非凡", "	re4	nao	fei1	fan2",
		"重足一迹", "	chong2	zu2	yi1	ji4",
		"朝闻夕死", "	zhao1	wen2	xi1	si3",
		"鹄形菜色", "	hu2	xing2	cai4	se4",
		"朝三暮二", "	zhao1	san1	mu4	er4",
		"劳务合同", "	lao2	wu4	he2	tong",
		"笃信好学", "	du3	xin4	hao4	xue2",
		"乐尽悲来", "	le4	jin4	bei1	lai2",
		"去甚去泰", "	qu4	shen4	qu4	tai4",
		"优游卒岁", "	you1	you2	zu2	sui4",
		"拨嘴撩牙", "	bo1	zui3	liao2	ya2",
		"于今为烈", "	yu2	jin1	wei2	lie4",
		"力有未逮", "	li4	you3	wei4	dai4",
		"曲尽其妙", "	qu1	jin4	qi2	miao4",
		"俟河之清", "	si4	he2	zhi1	qing1",
		"离子反应", "	li2	zi3	fan3	ying4",
		"舆论哗然", "	yu2	lun4	hua2	ran2",
		"自找麻烦", "	zi4	zhao3	ma2	fan",
		"自由散漫", "	zi4	you2	san3	man4",
		"好丹非素", "	hao4	dan1	fei1	su4",
		"去太去甚", "	qu4	tai	qu4	shen4",
		"不见舆薪", "	bu2	jian4	yu2	xin1",
		"兴都库什", "	xing1	du1	ku4	shi2",
		"连鬓胡子", "	lian2	bin4	hu2	zi3",
		"与时消息", "	yu3	shi2	xiao1	xi",
		"与此同时", "	yu2	ci3	tong2	shi2",
		"兴利除弊", "	xing1	li4	chu2	bi4",
		"于家为国", "	yu2	jia1	wei2	guo2",
		"兴安运河", "	xing1	an1	yun4	he2",
		"鬻鸡为凤", "	yu4	ji1	wei2	feng4",
		"没齿无怨", "	mo4	chi3	wu2	yuan4",
		"翘足而待", "	qiao2	zu2	er2	dai4",
		"金尽裘敝", "	jin1	jin4	qiu2	bi4",
		"狼子野心", "	lang2	zi3	ye3	xin1",
		"积岁累月", "	ji1	sui4	lei3	yue4",
		"技术要求", "	ji4	shu4	yao1	qiu2",
		"肌肉萎缩", "	ji1	rou4	wei3	suo1",
		"物尽其用", "	wu4	jin4	qi2	yong4",
		"肉薄骨并", "	rou4	bo2	gu3	bing4",
		"日月入怀", "	ri4	yue4	ru4	huai2",
		"主要部分", "	zhu3	yao4	bu4	fen",
		"奇偶校验", "	ji1	ou3	jiao4	yan4",
		"爆冷门儿", "	bao4	leng3	men2	r",
		"燕太子丹", "	yan1	tai4	zi3	dan1",
		"漠然置之", "	mo4	ran2	zhi4	zhi1",
		"无的放矢", "	wu2	di4	fang4	shi3",
		"橘化为枳", "	ju2	hua4	wei2	zhi3",
		"擢发莫数", "	zhuo2	fa4	mo4	shu3",
		"三邻四舍", "	san1	lin2	si4	she4",
		"剪发杜门", "	jian3	fa4	du4	men2",
		"三大差别", "	san1	da4	cha1	bie2",
		"居不重席", "	ju1	bu4	chong2	xi2",
		"鞠为茂草", "	ju1	wei2	mao4	cao3",
		"聚米为山", "	ju4	mi3	wei2	shan1",
		"家无担石", "	jia1	wu2	dan4	shi2",
		"独立钻石", "	du2	li4	zuan4	shi2",
		"浮云朝露", "	fu2	yun2	zhao1	lu4",
		"罪恶昭著", "	zui4	e4	zhao1	zhu4",
		"蛇心佛口", "	she2	xin1	fo2	kou3",
		"钻心刺骨", "	zuan4	xin1	ci4	gu3",
		"折腰五斗", "	she2	yao1	wu3	dou4",
		"淋漓尽致", "	lin2	li2	jin4	zhi4",
		"淡泊名利", "	dan4	bo2	ming2	li4",
		"淡泊寡味", "	dan4	bo2	gua3	wei4",
		"肩摩毂接", "	jian1	mo2	gu1	jie1",
		"如登春台", "	ru2	de2	chun1	tai2",
		"汉藏语系", "	han4	zang4	yu3	xi4",
		"无能为力", "	wu2	neng2	wei2	li4",
		"骥子龙文", "	ji4	zi3	long2	wen2",
		"积铢累寸", "	ji1	zhu1	lei3	cun4",
		"煞费苦心", "	sha4	fei4	ku3	xin1",
		"入理切情", "	ru4	li3	qie1	qing2",
		"拽耙扶犁", "	zhuai1	pa2	fu2	li2",
		"拽布披麻", "	zhuai4	bu4	pi1	ma2",
		"灰不溜秋", "	hui1	bu	liu1	qiu1",
		"炭疽杆菌", "	tan4	ju1	gan3	jun1",
		"赫赫之功", "	he4	he4	zhi4	gong1",
		"鱼游燋釜", "	yu2	you2	zhuo2	fu3",
		"不肖子孙", "	bu4	xiao4	zi3	sun1",
		"群居穴处", "	qun2	ju1	xue2	chu3",
		"好问决疑", "	hao4	wen4	jue2	yi2",
		"理论知识", "	li3	lun4	zhi1	shi",
		"解甲倒戈", "	jie3	jia3	dao3	ge1",
		"好事之徒", "	hao4	shi4	zhi1	tu2",
		"玉卮无当", "	yu4	zhi1	wu2	dang4",
		"处理方法", "	chu3	li3	fang1	fa3",
		"听而不闻", "	ting1	er2	bu2	wen2",
		"老鼠尾巴", "	lao3	shu3	wei3	ba",
		"肉毒杆菌", "	rou4	du2	gan3	jun1",
		"胡作非为", "	hu2	zuo4	fei1	wei2",
		"脉轮理论", "	mai4	lun2	li3	lun4",
		"处理系统", "	chu3	li3	xi4	tong3",
		"不露圭角", "	bu4	lu4	gui1	jiao3",
		"好骑者堕", "	hao4	qi2	zhe3	duo4",
		"聚酯树脂", "	ju4	zhi3	shu4	zhi1",
		"脊索动物", "	ji3	suo3	dong4	wu4",
		"考波什堡", "	kao3	bo1	shi2	bao3",
		"呵壁问天", "	he1	bi4	wen4	tian1",
		"无业闲散", "	wu2	ye4	xian2	san3",
		"塞翁得马", "	sai4	weng1	de2	ma3",
		"举措不当", "	ju3	cuo4	bu4	dang4",
		"三差五错", "	san1	cha1	wu3	cuo4",
		"三不拗六", "	san1	bu4	niu4	liu4",
		"为所欲为", "	wei2	suo3	yu4	wei2",
		"为时不晚", "	wei2	shi2	bu4	wan3",
		"为时已晚", "	wei2	shi2	yi3	wan3",
		"假模假式", "	jia3	mu2	jia3	shi4",
		"架肩击毂", "	jia4	jian1	ji1	gu1",
		"鞠躬君子", "	ju1	gong1	jun1	zi3",
		"老少无欺", "	lao3	shao4	wu2	qi1",
		"无所作为", "	wu2	suo3	zuo4	wei2",
		"聚合反应", "	ju4	he2	fan3	ying4",
		"假日经济", "	jia4	ri4	jing1	ji4",
		"朝夷暮跖", "	zhao1	yi2	mu4	zhi2",
		"口似悬河", "	kou3	si4	xuan2	he2",
		"鹤发童颜", "	he4	fa4	tong2	yan2",
		"离鸾别鹄", "	li2	luan2	bie2	hu2",
		"河伯为患", "	he2	bo2	wei2	huan4",
		"挨山塞海", "	ai1	shan1	se4	hai3",
		"阿世盗名", "	e1	shi4	dao4	ming2",
		"率马以骥", "	shuai4	ma3	yi3	ji4",
		"临深履薄", "	lin2	shen1	lv3	bo2",
		"冰解的破", "	bing1	jie3	di4	po4",
		"狗颠屁股", "	gou3	dian1	pi4	gu",
		"姑射神人", "	gu1	ye4	shen2	ren2",
		"因树为屋", "	yin1	shu4	wei2	wu1",
		"伯乐相马", "	bo2	le4	xiang4	ma3",
		"广譬曲谕", "	guang3	pi4	qu3	yu4",
		"萎靡不振", "	wei3	mi3	bu4	zhen4",
		"薄技在身", "	bo2	ji4	zai4	shen1",
		"观者如堵", "	guan1	zhe3	ru2	du3",
		"绿林豪杰", "	lu4	lin2	hao2	jie2",
		"肆意妄为", "	si4	yi4	wang4	wei2",
		"波骇云属", "	bo1	hai4	yun2	zhu3",
		"裘弊金尽", "	qiu2	bi4	jin1	jin4",
		"应答如流", "	ying4	da2	ru2	liu2",
		"鼓乐齐鸣", "	gu3	yue4	qi2	ming2",
		"引以为戒", "	yin3	yi3	wei2	jie4",
		"蒙古大夫", "	meng3	gu3	dai4	fu",
		"引以为豪", "	yin3	yi3	wei2	hao2",
		"狗屁倒灶", "	gou3	pi4	dao3	zao4",
		"一之已甚", "	yi1	zhi1	yi3	shen4",
		"流行歌曲", "	liu2	xing2	ge1	qu3",
		"虚心好学", "	xu1	xin1	hao4	xue2",
		"故态复还", "	gu4	tai4	fu4	huan2",
		"苏打饼干", "	su1	da2	bing3	gan1",
		"故事片儿", "	gu4	shi4	pian1	er",
		"七十二行", "	qi1	shi2	er4	hang2",
		"孤鸾寡鹄", "	gu1	luan2	gua3	hu2",
		"因祸为福", "	yin1	huo4	wei2	fu2",
		"孤鸿寡鹄", "	gu1	hong2	gua3	hu2",
		"处理能力", "	chu3	li3	neng2	li4",
		"古调不弹", "	gu3	diao4	bu4	tan2",
		"以珠弹雀", "	yi3	zhu1	tan2	que4",
		"夙兴夜处", "	su4	xing1	ye4	chu3",
		"孤臣孽子", "	gu1	chen2	nie4	zi3",
		"露红烟绿", "	lu4	hong2	yan1	lv4",
		"随风而靡", "	sui2	feng1	er2	mi3",
		"啜食吐哺", "	chuo4	shi2	tu3	bu3",
		"融为一体", "	rong2	wei2	yi1	ti3",
		"衣租食税", "	yi4	zu1	shi2	shui4",
		"蛮横无理", "	man2	heng4	wu2	li3",
		"引以为耻", "	yin3	yi3	wei2	chi3",
		"吹弹得破", "	chui1	tan2	de2	po4",
		"背曲腰弯", "	bei4	qu3	yao1	wan1",
		"一日三省", "	yi1	ri4	san1	xing3",
		"一目数行", "	yi1	mu4	shu4	hang2",
		"岗头泽底", "	gang1	tou2	ze2	di3",
		"衣马轻肥", "	yi4	ma3	qing1	fei2",
		"弥缝其阙", "	mi2	feng2	qi2	que4",
		"蜜里调油", "	mi4	li3	tiao2	you2",
		"以利累形", "	yi3	li4	lei3	xing2",
		"调三窝四", "	tiao2	san1	wo1	si4",
		"遗老遗少", "	yi2	lao3	yi2	shao4",
		"绰有余裕", "	chuo4	you3	yu2	yu4",
		"没头没尾", "	mei2	tou2	mo4	wei3",
		"亲力亲为", "	qin1	li4	qin1	wei2",
		"视为畏途", "	shi4	wei2	wei4	tu2",
		"躬自菲薄", "	gong1	zi4	fei3	bo2",
		"此唱彼和", "	ci3	chang4	bi3	he4",
		"蹙蹙靡骋", "	cu4	cu4	mi3	cheng3",
		"亿兆一心", "	yi4	zhao4	yi1	xin1",
		"掠美市恩", "	lue3	mei3	shi4	en1",
		"沓来麕至", "	ta4	lai2	you3	zhi4",
		"门殚户尽", "	men2	dan1	hu4	jin4",
		"奔走呼号", "	ben1	zou3	hu1	hao2",
		"薄利多销", "	bo2	li4	duo1	xiao1",
		"一头儿沉", "	yi1	tou	er	chen2",
		"吹弹歌舞", "	chui1	tan2	ge1	wu3",
		"屏气慑息", "	bing3	qi4	she4	xi1",
		"寡鹄孤鸾", "	gua3	hu2	gu1	luan2",
		"挂席为门", "	gua4	xi2	wei2	men2",
		"调和分析", "	tiao2	he2	fen1	xi1",
		"情凄意切", "	qing2	qi1	yi4	qie1",
		"绿林豪士", "	lu4	lin2	hao2	shi4",
		"亲密无间", "	qin1	mi4	wu2	jian4",
		"寸积铢累", "	cun4	ji1	zhu1	lei3",
		"依头缕当", "	yi1	tou2	lv3	dang4",
		"观衅伺隙", "	guan1	xin4	si4	xi4",
		"贪惏无餍", "	tan1	lin2	wu2	yan4",
		"避军三舍", "	bi4	jun1	san1	she4",
		"以是为恨", "	yi3	shi4	wei2	hen4",
		"各自为战", "	ge4	zi4	wei2	zhan4",
		"碧波万顷", "	bi4	bo1	wan4	qing3",
		"毛发倒竖", "	mao2	fa1	dao3	shu4",
		"弹丝品竹", "	tan2	si1	pin3	zhu2",
		"以苦为荣", "	yi3	ku3	wei2	rong2",
		"谋为不轨", "	mou2	wei2	bu4	gui3",
		"衣裳钩儿", "	yi1	shang	gou1	r",
		"起重葫芦", "	qi3	chong2	hu2	lu",
		"大难临头", "	da4	nan4	lin2	tou2",
		"费尽心思", "	fei4	jin4	xin1	si",
		"大处着墨", "	da4	chu4	zhuo2	mo4",
		"质子轰击", "	zhi4	zi3	hong1	ji1",
		"大行大市", "	da4	hang2	da4	shi4",
		"赤子之心", "	chi4	zi3	zhi1	xin1",
		"赤字累累", "	chi4	zi4	lei3	lei3",
		"绵力薄材", "	mian2	li4	bo2	cai2",
		"起飞弹射", "	qi3	fei1	tan2	she4",
		"以古为镜", "	yi3	gu3	wei2	jing4",
		"一干人犯", "	yi1	gan1	ren2	fan4",
		"大辂椎轮", "	da4	lu4	zhui1	lun2",
		"费尽心机", "	fei4	jin4	xin1	ji1",
		"一蹶不兴", "	yi1	jue3	bu4	xing1",
		"叨在知己", "	tao1	zai4	zhi1	ji3",
		"逃灾避难", "	tao2	zai1	bi4	nan4",
		"哑子做梦", "	ya3	zi3	zuo4	meng4",
		"哑子寻梦", "	ya3	zi3	xun2	meng4",
		"以古为鉴", "	yi3	gu3	wei2	jian4",
		"霓裳羽衣", "	ni2	chang2	yu3	yi1",
		"芽孢杆菌", "	ya2	bao1	gan3	jun1",
		"父严子孝", "	fu4	yan2	zi3	xiao4",
		"福为祸始", "	fu2	wei2	huo4	shi3",
		"浮收勒索", "	fu2	shou1	le4	suo3",
		"浮收勒折", "	fu2	shou1	le4	she2",
		"浮皮潦草", "	fu2	pi2	liao2	cao3",
		"名流巨子", "	ming2	liu2	ju4	zi3",
		"仰事俯畜", "	yang3	shi4	fu3	xu4",
		"迄今为止", "	qi4	jin1	wei2	zhi3",
		"伏而咶天", "	fu2	er2	shi4	tian1",
		"近似等级", "	jin4	si4	deng3	ji2",
		"豪气干云", "	hao2	qi4	gan1	yun2",
		"身体部分", "	shen1	ti3	bu4	fen4",
		"切理厌心", "	qie1	li3	yan4	xin1",
		"衣锦夜行", "	yi4	jin3	ye4	xing2",
		"诸子十家", "	zhu1	zi3	shi2	jia1",
		"诸子百家", "	zhu1	zi3	bai3	jia1",
		"一还一报", "	yi1	huan2	yi1	bao4",
		"绵薄之力", "	mian2	bo2	zhi1	li4",
		"撮科打哄", "	cuo1	ke1	da3	hong4",
		"哑子托梦", "	ya3	zi3	tuo1	meng4",
		"没食子酸", "	mei2	si4	zi3	suan1",
		"岩栖穴处", "	yan2	qi1	xue2	chu3",
		"凤靡鸾吪", "	feng4	mi3	luan2	e2",
		"舍身饲虎", "	she4	shen1	si4	hu3",
		"莫此为甚", "	mo4	ci3	wei2	shen4",
		"抹粉施脂", "	mo4	fen3	shi1	zhi1",
		"提高认识", "	ti2	gao1	ren4	shi",
		"燕市悲歌", "	yan1	shi4	bei1	ge1",
		"燕雀处屋", "	yan4	que4	chu3	wu1",
		"没世不忘", "	mo4	shi4	bu4	wang4",
		"道德认识", "	dao4	de2	ren4	shi",
		"言气卑弱", "	yan	qi	bei	ruo",
		"佛头加秽", "	fo2	tou2	jia1	hui4",
		"摸门不着", "	mo1	men2	bu4	zhao2",
		"脉脉含情", "	mo4	mo4	han2	qing2",
		"风禾尽起", "	feng1	he2	jin4	qi3",
		"岩居穴处", "	yan2	ju1	xue2	chu3",
		"燕金募秀", "	yan1	jin1	mu4	xiu4",
		"燕驾越毂", "	yan1	jia4	yue4	gu1",
		"风号雨泣", "	feng1	hao2	yu3	qi4",
		"燕歌赵舞", "	yan1	ge1	zhao4	wu3",
		"眼饧耳热", "	yan3	xing2	er3	re4",
		"特殊要求", "	te4	shu1	yao1	qiu2",
		"天覆地载", "	tian1	fu4	di4	zai3",
		"匪伊朝夕", "	fei3	yi2	zhao1	xi1",
		"分液漏斗", "	fen1	ye4	lou4	dou3",
		"炫玉贾石", "	xuan4	yu4	gu3	shi2",
		"分毫不差", "	fen1	hao2	bu4	cha1",
		"玄酒瓠脯", "	xuan2	jiu3	hu4	fu3",
		"恬不为意", "	tian2	bu4	wei2	yi4",
		"摸头不着", "	mo1	tou2	bu4	zhao2",
		"奋发有为", "	fen4	fa1	you3	wei2",
		"虚应故事", "	xu1	ying4	gu4	shi4",
		"莫为已甚", "	mo4	wei2	yi3	shen4",
		"佛心蛇口", "	fo2	xin1	she2	kou3",
		"飞檐走脊", "	fei1	yan2	zou3	ji3",
		"莫知所为", "	mo4	zhi1	suo3	wei2",
		"重足而立", "	chong2	zu2	er2	li4",
		"墨汁未干", "	mo4	zhi1	wei4	gan1",
		"重眼皮儿", "	chong2	yan3	pi2	r",
		"退避三舍", "	tui4	bi4	san1	she4",
		"弹丸黑子", "	dan4	wan2	hei1	zi3",
		"奉公不阿", "	feng4	gong1	bu4	e1",
		"落后分子", "	luo4	hou4	fen1	zi3",
		"攒三集五", "	cuan2	san1	ji2	wu3",
		"拔本塞源", "	ba2	ben3	se4	yuan2",
		"为鬼为蜮", "	wei2	gui3	wei2	yu4",
		"头半天儿", "	tou2	ban4	tian1	r",
		"为裘为箕", "	wei2	qiu2	wei2	ji1",
		"唯邻是卜", "	wei2	lin2	shi4	bu3",
		"托物寓兴", "	tuo1	wu4	yu4	xing1",
		"为虺弗摧", "	wei2	hui3	fu2	cui1",
		"高高手儿", "	gao1	gao1	shou3	r",
		"高能粒子", "	gao1	neng2	li4	zi3",
		"瓦查尿溺", "	wa3	cha2	niao4	ni4",
		"外合里应", "	wai4	he2	li3	ying4",
		"鞠躬尽力", "	ju1	gong1	jin4	li4",
		"帏薄不修", "	wei2	bao2	bu4	xiu1",
		"预备知识", "	yu4	bei4	zhi1	shi",
		"为期不远", "	wei2	qi1	bu4	yuan3",
		"关门弟子", "	guan1	men2	di4	zi3",
		"调剂余缺", "	tiao2	ji4	yu2	que1",
		"钻木取火", "	zuan4	mu4	qu3	huo3",
		"犯而不校", "	fan4	er2	bu4	jiao4",
		"脑脊髓炎", "	nao3	ji3	sui3	yan2",
		"高丽棒子", "	gao1	li2	bang4	zi",
		"非都会郡", "	fei1	du1	hui4	jun4",
		"叨陪末座", "	tao1	pei2	mo4	zuo4",
		"鼎折餗覆", "	ding3	she2	su4	fu4",
		"万夫不当", "	wan4	fu1	bu4	dang1",
		"颠仆流离", "	dian1	pu2	liu2	li2",
		"七行俱下", "	qi1	hang2	ju4	xia4",
		"奇技淫巧", "	qi2	ji4	yin2	qiao3",
		"饿莩载道", "	e4	piao3	zai4	dao4",
		"饿莩遍野", "	e4	piao3	bian4	ye3",
		"讫情尽意", "	qi4	qing2	jin4	yi4",
		"起偃为竖", "	qi3	yan3	wei2	shu4",
		"铺胸纳地", "	pu1	xiong1	na4	di4",
		"非异人任", "	fei1	yi4	ren2	ren4",
		"电子杂志", "	dian4	zi3	za2	zhi4",
		"鼎折覆餗", "	ding3	she2	fu4	su4",
		"涤故更新", "	di2	gu4	geng1	xin1",
		"为蛇画足", "	wei2	she2	hua4	zu2",
		"味如嚼蜡", "	wei4	ru2	jiao2	la4",
		"铺锦列绣", "	pu1	jin3	lie4	xiu4",
		"蒲柳之质", "	pu2	liu3	zhi1	zhi4",
		"惟日为岁", "	wei2	ri4	wei2	sui4",
		"挠直为曲", "	nao2	zhi2	wei2	qu1",
		"八难三灾", "	ba1	nan4	san1	zai1",
		"万夫莫当", "	wan4	fu1	mo4	dang1",
		"白发丹心", "	bai2	fa4	dan1	xin1",
		"千载一日", "	qian1	zai3	yi1	ri4",
		"南贩北贾", "	nan2	fan4	bei3	gu3",
		"反应速度", "	fan3	ying4	su4	du4",
		"百辞莫辩", "	bai3	ci2	mo4	bian4",
		"银行业务", "	yin2	hang2	ye4	wu4",
		"铺天盖地", "	pu1	tian1	gai4	di4",
		"道尽途殚", "	dao4	jin4	tu2	dan1",
		"铺盖卷儿", "	pu1	gai4	juan3	er2",
		"蹈厉之志", "	dao3	li4	zhi1	zhi4",
		"暮雨朝云", "	mu4	yu3	zhao1	yun2",
		"兴家立业", "	xing1	jia1	li4	ye4",
		"行号卧泣", "	xing2	hao2	wo4	qi4",
		"反劳为逸", "	fan3	lao2	wei2	yi4",
		"铁板茄子", "	tie3	ban3	qie2	zi",
		"铁杆粉丝", "	tie3	gan3	fen3	si1",
		"番窠倒臼", "	fan1	ke1	dao3	jiu4",
		"难割难舍", "	nan2	ge1	nan2	she4",
		"都头异姓", "	du1	tou2	yi4	xing4",
		"拿糖作醋", "	na2	tang2	zuo4	cu4",
		"犯罪分子", "	fan4	zui4	fen1	zi3",
		"逆臣贼子", "	ni4	chen2	zei2	zi3",
		"儿女亲家", "	er2	nv3	qing4	jia1",
		"孝子慈孙", "	xiao4	zi3	ci2	sun1",
		"小眼薄皮", "	xiao3	yan3	bo2	pi2",
		"难进易退", "	nan	jin	yi	tui",
		"前徒倒戈", "	qian2	tu2	dao3	ge1",
		"八斗之才", "	ba1	dou3	zhi1	cai2",
		"小姑独处", "	xiao3	gu1	du2	chu3",
		"法定假日", "	fa3	ding4	jia4	ri4",
		"二竖为虐", "	er4	shu4	wei2	nue4",
		"调三斡四", "	tiao2	san1	wo4	si4",
		"白发偕老", "	bai2	fa4	xie2	lao3",
		"逆子贼臣", "	ni4	zi3	zei2	chen2",
		"孽子孤臣", "	nie4	zi3	gu1	chen2",
		"繁花似锦", "	fan2	hua1	si4	jin3",
		"千载奇遇", "	qian1	zai3	qi2	yu4",
		"暮虢朝虞", "	mu4	guo2	zhao1	yu2",
		"千载一遇", "	qian1	zai3	yi1	yu4",
		"沐猴衣冠", "	mu4	hou2	yi1	guan4",
		"白发朱颜", "	bai2	fa4	zhu1	yan2",
		"气吞牛斗", "	qi4	tun1	niu2	dou3",
		"欺行霸市", "	qi1	hang2	ba4	shi4",
		"视为知己", "	shi4	wei2	zhi1	ji3",
		"东猎西渔", "	dong1	lie4	xi1	yu2",
		"等离子态", "	deng3	li2	zi3	tai4",
		"电子学系", "	dian4	zi3	xue2	xi4",
		"丽池卡登", "	li2	chi2	ka3	deng1",
		"咸津津儿", "	xian2	jin1	jin1	r",
		"屠门大嚼", "	tu2	men2	da4	jiao2",
		"头会箕赋", "	tou2	kuai4	ji1	fu4",
		"撇呆打堕", "	pie3	dai1	da3	duo4",
		"鸠摩罗什", "	jiu1	mo2	luo2	shi2",
		"电子货币", "	dian4	zi3	huo4	bi4",
		"文子文孙", "	wen2	zi3	wen2	sun1",
		"电子游戏", "	dian4	zi3	you2	xi4",
		"平铺直叙", "	ping2	pu1	zhi2	xu4",
		"东扶西倒", "	dong1	fu2	xi1	dao3",
		"吞言咽理", "	tun1	yan2	yan1	li3",
		"破觚为圜", "	po4	gu1	wei2	yuan2",
		"破坏荷载", "	po4	huai4	he4	zai4",
		"破家为国", "	po4	jia1	wei2	guo2",
		"品竹弹丝", "	pin3	zhu2	tan2	si1",
		"麦盖提县", "	mai4	ge3	ti2	xian4",
		"前仆后踣", "	qian2	pu2	hou4	bo2",
		"难以应付", "	nan2	yi3	ying4	fu4",
		"以微知著", "	yi3	wei1	zhi1	zhu4",
		"攒三聚五", "	cuan2	san1	ju4	wu3",
		"以言为讳", "	yi3	yan2	wei2	hui4",
		"贪财好色", "	tan1	cai2	hao4	se4",
		"里应外合", "	li3	ying4	wai4	he2",
		"西塞山区", "	xi1	sai4	shan1	qu1",
		"一无长物", "	yi1	wu2	chang2	wu4",
		"西子捧心", "	xi1	zi3	peng3	xin1",
		"履薄临深", "	lv3	bo2	lin2	shen1",
		"变贪厉薄", "	bian3	tan1	li4	bo2",
		"片词只句", "	pian4	ci2	zhi1	ju4",
		"以退为进", "	yi3	tui4	wei2	jin4",
		"琴瑟调和", "	qin2	se4	tiao2	he2",
		"伺瑕导蠙", "	si4	xia2	dao3	pin2",
		"倒持干戈", "	dao3	chi2	gan1	ge1",
		"倒持戈矛", "	dao3	chi2	ge1	mao2",
		"倒置干戈", "	dao4	zhi4	gan1	ge1",
		"斗南一人", "	dou3	nan2	yi1	ren2",
		"涡轮增压", "	wo1	lun2	zeng1	ya4",
		"破矩为圆", "	po4	ju3	wei2	yuan2",
		"杂和面儿", "	za2	huo	mian4	er",
		"风靡一时", "	feng1	mi3	yi1	shi2",
		"递兴递废", "	di4	xing1	di4	fei4",
		"默诵佛号", "	mo4	song4	fo2	hao4",
		"被山带河", "	pi1	shan1	dai4	he2",
		"屋舍俨然", "	wu1	she4	yan3	ran2",
		"破崖绝角", "	po4	ya2	jue2	jiao3",
		"霍林郭勒", "	huo4	lin2	guo1	le4",
		"惊叹不已", "	jing1	tan4	bu4	yi3",
		"电子信息", "	dian4	zi3	xin4	xi1",
		"七颠八倒", "	qi1	dian1	ba1	dao3",
		"莞尔而笑", "	wan3	er3	er2	xiao4",
		"只鸡斗酒", "	zhi1	ji1	dou3	jiu3",
		"莞尔一笑", "	wan3	er3	yi1	xiao4",
		"颠覆分子", "	dian1	fu4	fen4	zi3",
		"忘恩失义", "	wang4	en1	shi1	yi4",
		"王八羔子", "	wang2	ba1	gao1	zi3",
		"栖风宿雨", "	qi1	feng1	xiu3	yu3",
		"起根由头", "	qi3	gen1	you2	tou",
		"七病八倒", "	qi1	bing4	ba1	dao3",
		"风雨欲来", "	feng1	yu3	yu4	lai2",
		"五尺童子", "	wu3	chi3	tong2	zi3",
		"隐身草儿", "	yin3	shen1	cao3	r",
		"阿拉善盟", "	a	la1	shan4	meng2",
		"批吭捣虚", "	pi1	hang2	dao3	xu1",
		"阿松森岛", "	a	song1	sen1	dao3",
		"阿森松岛", "	a	sen1	song1	dao3",
		"读书得间", "	du2	shu1	de2	jian4",
		"无能为役", "	wu2	neng2	wei2	yi4",
		"阿空加瓜", "	a	kong1	jia1	gua1",
		"笃实好学", "	du3	shi2	hao4	xue2",
		"杜门自守", "	du4	men2	zi4	shou4",
		"杜门面壁", "	du4	men2	mian	bi4",
		"被褐怀珠", "	pi1	he4	huai2	zhu1",
		"无颠无倒", "	wu2	dian1	wu2	dao3",
		"批砉导窾", "	pi1	hua1	dao3	tao2",
		"头出头没", "	tou2	chu1	tou2	mo4",
		"否极阳回", "	pi3	ji2	yang2	hui2",
		"五方杂处", "	wu3	fang1	za2	chu3",
		"童颜鹤发", "	tong2	yan2	he4	fa4",
		"斗挹箕扬", "	dou3	yi4	ji1	yang2",
		"五斗折腰", "	wu3	dou3	zhe2	yao1",
		"无动为大", "	wu2	dong4	wei2	da4",
		"窥间伺隙", "	kui1	jian4	si4	xi4",
		"朝不谋夕", "	zhao1	bu4	mou2	xi1",
		"敷衍搪塞", "	fu1	yan3	tang2	se4",
		"枫桥夜泊", "	feng1	qiao2	ye4	bo2",
		"孟什维克", "	meng4	shi2	wei2	ke4",
		"啦啦队长", "	la1	la1	dui4	zhang3",
		"名我固当", "	ming	wo	gu	dang",
		"佛头着粪", "	fo2	tou2	zhuo2	fen4",
		"摸不着边", "	mo1	bu4	zhuo2	bian1",
		"奉为楷模", "	feng4	wei2	kai3	mo2",
		"蜂扇蚁聚", "	feng1	shan1	yi3	ju4",
		"风流才子", "	feng1	liu2	cai2	zi3",
		"分风劈流", "	fen1	feng1	pi3	liu2",
		"鸣锣喝道", "	ming2	luo2	he4	dao4",
		"丰富知识", "	feng1	fu4	zhi1	shi",
		"蜂攒蚁聚", "	feng1	cuan2	yi3	ju4",
		"蜂攒蚁集", "	feng1	cuan2	yi3	ji2",
		"凤雏麟子", "	feng4	chu2	lin2	zi3",
		"风驰草靡", "	feng1	chi2	cao3	mi3",
		"没世难忘", "	mo4	shi4	nan2	wang4",
		"唾面自干", "	tuo4	mian4	zi4	gan1",
		"膏唇岐舌", "	gao4	chun2	qi2	she2",
		"工作态度", "	gong1	zuo4	tai4	du",
		"分外妖娆", "	fen4	wai4	yao1	rao2",
		"狗续侯冠", "	gou3	xu4	hou4	guan4",
		"功薄蝉翼", "	gong1	bo2	chan2	yi4",
		"尖酸刻薄", "	jian1	suan1	ke4	bo2",
		"顾曲周郎", "	gu4	qu3	zhou1	lang2",
		"鼓角齐鸣", "	gu3	jiao3	qi2	ming2",
		"故技重演", "	gu4	ji4	chong2	yan3",
		"古调单弹", "	gu3	diao4	dan1	tan2",
		"狗追耗子", "	gou3	zhui1	hao4	zi3",
		"钩章棘句", "	gou1	zhang1	ji2	ju4",
		"功夫片儿", "	gong1	fu1	pian1	er",
		"公共服务", "	gong1	gong4	fu2	wu4",
		"小里小气", "	xiao3	li	xiao3	qi4",
		"工作任务", "	gong1	zuo4	ren4	wu",
		"公正不阿", "	gong1	zheng4	bu4	e1",
		"工业会计", "	gong1	ye4	kuai4	ji4",
		"供认不讳", "	gong4	ren4	bu4	hui4",
		"哗啦一声", "	hua1	la1	yi1	sheng1",
		"乱作胡为", "	luan4	zuo4	hu2	wei2",
		"落草为寇", "	luo4	cao3	wei2	kou4",
		"帝王切开", "	di4	wang2	qie1	kai1",
		"缝缝补补", "	feng2	feng2	bu3	bu3",
		"埋三怨四", "	man2	san1	yuan4	si4",
		"以疏间亲", "	yi3	shu1	jian4	qin1",
		"详尽无遗", "	xiang2	jin4	wu2	yi2",
		"词项逻辑", "	ci2	xiang4	luo2	ji",
		"一日之长", "	yi1	ri4	zhi1	chang2",
		"任人唯亲", "	ren4	ren2	wei2	qin1",
		"一时千载", "	yi1	shi2	qian1	zai3",
		"设身处地", "	she4	shen1	chu3	di4",
		"仰屋著书", "	yang3	wu1	zhu4	shu1",
		"以眼还眼", "	yi3	yan3	huan2	yan3",
		"以人为镜", "	yi3	ren2	wei2	jing4",
		"扯纤拉烟", "	che3	qian4	la1	yan1",
		"有失厚道", "	you3	shi1	hou4	dao",
		"有求必应", "	you3	qiu2	bi4	ying4",
		"觅食行为", "	mi4	shi2	xing2	wei2",
		"一网尽扫", "	yi1	wang3	jin4	sao3",
		"有缘无分", "	you3	yuan2	wu2	fen4",
		"令人发指", "	ling4	ren2	fa4	zhi3",
		"要买人心", "	yao1	mai3	ren2	xin1",
		"有头有尾", "	you3	tou2	you3	wei3",
		"诛尽杀绝", "	zhu1	jin4	sha1	jue2",
		"黄发儿齿", "	huang2	fa4	er2	chi3",
		"蒙蒙细雨", "	meng1	meng1	xi4	yu3",
		"干将莫邪", "	gan1	jiang4	mo4	ye2",
		"福为祸先", "	fu2	wei2	huo4	xian1",
		"靡靡之声", "	mi3	mi3	zhi1	sheng1",
		"敢作敢为", "	gan3	zuo4	gan3	wei2",
		"敢为敢做", "	gan3	wei2	gan3	zuo4",
		"棉花套子", "	mian2	hua1	tao4	zi3",
		"干卿底事", "	gan1	qing1	di3	shi4",
		"干名采誉", "	gan1	ming2	cai3	yu4",
		"父债子还", "	fu4	zhai4	zi3	huan2",
		"面谩腹诽", "	mian4	man4	fu4	fei3",
		"称家有无", "	chen4	jia1	you3	wu2",
		"甘分随时", "	gan1	fen4	sui2	shi2",
		"左邻右舍", "	zuo3	lin2	you4	she4",
		"甘处下流", "	gan1	chu3	xia4	liu2",
		"喇叭水仙", "	la1	ba1	shui3	xian1",
		"勉为其难", "	mian3	wei2	qi2	nan2",
		"善自为谋", "	shan4	zi4	wei2	mou2",
		"邈处欿视", "	miao3	chu3	ji1	shi4",
		"干戈扰攘", "	gan1	ge1	rao3	rang3",
		"貌似强大", "	mao4	si4	qiang2	da4",
		"膏粱子弟", "	gao1	liang2	zi3	di4",
		"一言中的", "	yi1	yan2	zhong1	di4",
		"平均误差", "	ping2	jun1	wu4	cha1",
		"难以为情", "	nan2	yi3	wei2	qing2",
		"内省不疚", "	nei4	xing3	bu4	jiu4",
		"难更仆数", "	nan2	geng1	pu2	shu3",
		"分兵把口", "	fen4	bing1	ba3	kou3",
		"咬文嚼字", "	yao3	wen2	jiao2	zi4",
		"培训要求", "	pei2	xun4	yao1	qiu2",
		"东邻西舍", "	dong1	lin2	xi1	she4",
		"品竹调丝", "	pin3	zhu2	tiao2	si1",
		"弹痕累累", "	dan4	hen2	lei2	lei2",
		"难乎为情", "	nan2	hu1	wei2	qing2",
		"凭虚公子", "	ping2	xu1	gong1	zi3",
		"弹道导弹", "	dan4	dao4	dao3	dan4",
		"刁钻刻薄", "	diao1	zuan1	ke4	bo2",
		"铺眉蒙眼", "	pu1	mei2	meng2	yan3",
		"雕蚶镂蛤", "	diao1	han1	lou4	ge2",
		"东飘西泊", "	dong1	piao1	xi1	bo2",
		"仆仆风尘", "	pu2	pu2	feng1	chen2",
		"暴腮龙门", "	pu4	sai1	long2	men2",
		"几可乱真", "	ji1	ke3	luan4	zhen1",
		"反间之计", "	fan3	jian4	zhi1	ji4",
		"七返还丹", "	qi1	fan3	huan2	dan1",
		"发引千钧", "	fa4	yin3	qian1	jun1",
		"攀花折柳", "	pan1	hua1	she2	liu3",
		"攀藤揽葛", "	pan1	teng2	lan3	ge3",
		"庞眉白发", "	pang2	mei2	bai2	fa4",
		"引以为荣", "	yin3	yi3	wei2	rong2",
		"引吭高歌", "	yin3	hang2	gao1	ge1",
		"度德量力", "	duo2	de2	liang4	li4",
		"庞眉皓发", "	pang2	mei2	hao4	fa4",
		"泥名失实", "	ni4	ming2	shi1	shi2",
		"费尽心血", "	fei4	jin4	xin1	xue4",
		"反目为仇", "	fan3	mu4	wei2	chou2",
		"飞将数奇", "	fei1	jiang4	shu4	ji1",
		"非分之财", "	fei1	fen4	zhi1	cai2",
		"方正不阿", "	fang1	zheng4	bu4	e1",
		"暮暮朝朝", "	mu4	mu4	zhao1	zhao1",
		"方差分析", "	fang1	cha1	fen1	xi1",
		"反应迅速", "	fan3	ying4	xun4	su4",
		"不遗寸长", "	bu4	yi2	cun4	chang2",
		"南郭处士", "	nan2	guo1	chu3	shi4",
		"电子音乐", "	dian4	zi3	yin1	yue4",
		"电子设备", "	dian4	zi3	she4	bei4",
		"锚固长度", "	mao2	gu4	chang2	du4",
		"谩辞哗说", "	man4	ci2	hua2	shuo1",
		"斗榫合缝", "	dou3	sun3	he2	feng4",
		"古为今用", "	gu3	wei2	jin1	yong4",
		"带薪休假", "	dai4	xin1	xiu1	jia4",
		"分内之事", "	fen4	nei4	zhi1	shi4",
		"洛阳才子", "	luo4	yang2	cai2	zi3",
		"马咽车阗", "	ma3	yan1	che1	tian2",
		"买卖合同", "	mai3	mai4	he2	tong",
		"麦丘之祝", "	mai4	qiu1	zhi1	zhu4",
		"更仆难尽", "	geng4	pu2	nan2	jin4",
		"东歪西倒", "	dong1	wai1	xi1	dao3",
		"嗜血杆菌", "	shi4	xue4	gan3	jun1",
		"更难仆数", "	geng1	nan2	pu2	shu4",
		"满堂喝彩", "	man3	tang2	he4	cai3",
		"各自为政", "	ge4	zi4	wei2	zheng4",
		"尨眉皓发", "	manɡ2	mei2	hao4	fa4",
		"各取所长", "	ge4	qu3	suo3	chang2",
		"毛发之功", "	mao2	fa4	zhi1	gong1",
		"告朔饩羊", "	gu4	shuo4	xi4	yang2",
		"漂泊无定", "	piao1	bo2	wu2	ding4",
		"东西易面", "	dong1	xi	yi4	mian4",
		"电子词典", "	dian4	zi3	ci2	dian3",
		"睹物兴情", "	du3	wu4	xing1	qing2",
		"君子之交", "	jun1	zi3	zhi1	jiao1",
		"铺眉苫眼", "	pu1	mei2	shan4	yan3",
		"断子绝孙", "	duan4	zi3	jue2	sun1",
		"冬裘夏葛", "	dong1	qiu2	xia4	ge3",
		"披发缨冠", "	pi1	fa1	ying1	guan4",
		"和睦相处", "	he2	mu4	xiang1	chu3",
		"独有千秋", "	du2	you4	qian1	qiu1",
		"弱不禁风", "	ruo4	bu4	jin1	feng1",
		"读书种子", "	du2	shu1	zhong3	zi3",
		"东踅西倒", "	dong1	xue2	xi1	dao3",
		"和尚打伞", "	he2	shang	da3	san3",
		"否往泰来", "	pi3	wang3	tai4	lai2",
		"漂母进饭", "	piao1	mu3	jin4	fan4",
		"强词夺理", "	qiang3	ci2	duo2	li3",
		"否终复泰", "	pi3	zhong1	fu4	tai4",
		"否终则泰", "	pi3	zhong1	ze2	tai4",
		"斗酒学士", "	dou3	jiu3	xue2	shi4",
		"骈拇枝指", "	pian2	mu3	zhi1	zhi3",
		"意兴索然", "	yi4	xing1	suo3	ran2",
		"以水济水", "	yi3	shui3	ji3	shui3",
		"度长絜大", "	du4	chang2	xie2	da4",
		"钻故纸堆", "	zuan4	gu4	zhi3	dui1",
		"间不容发", "	jian1	bu4	rong2	fa4",
		"开发银行", "	kai1	fa1	yin2	hang2",
		"开卷有益", "	kai1	juan4	you3	yi4",
		"闭卷考试", "	bi4	juan4	kao3	shi4",
		"无为自成", "	wu2	wei2	zi4	cheng2",
		"整齐划一", "	zheng3	qi2	hua2	yi1",
		"这还了得", "	zhe4	hai2	liao3	de2",
		"心驰魏阙", "	xin1	chi2	wei4	que4",
		"晏子春秋", "	yan4	zi3	chun1	qiu1",
		"无为而成", "	wu2	wei2	er2	cheng2",
		"寻行数墨", "	xun2	hang2	shu3	mo4",
		"压倒元白", "	ya1	dao3	yuan2	bai2",
		"压卷之作", "	ya1	juan4	zhi1	zuo4",
		"燕岱之石", "	yan1	dai4	zhi1	shi2",
		"言颠语倒", "	yan2	dian1	yu3	dao3",
		"偃革为轩", "	yan3	ge2	wei2	xuan1",
		"酸不溜秋", "	suan1	bu	liu1	qiu1",
		"眼观六路", "	yan3	guan1	liu4	lu4",
		"间接宾语", "	jian4	jie1	bin1	yu3",
		"敷衍了事", "	fu1	yan3	liao3	shi4",
		"都会传奇", "	du1	hui4	chuan2	qi2",
		"随声附和", "	sui2	sheng1	fu4	he4",
		"长安大学", "	chang2	an1	da4	xue2",
		"倒果为因", "	dao4	guo3	wei2	yin1",
		"校园歌曲", "	xiao4	yuan2	ge1	qu3",
		"斜纹软呢", "	xie2	wen2	ruan3	ni2",
		"胁肩累足", "	xie2	jian1	lei3	zu2",
		"数珠念佛", "	shu3	zhu1	nian4	fo2",
		"闭上嘴巴", "	bi4	shang	zui3	ba1",
		"离子交换", "	li2	zi3	jiao1	huan4",
		"恶恶从短", "	wu4	wu4	cong2	duan3",
		"无声无臭", "	wu2	sheng1	wu2	xiu4",
		"无缝天衣", "	wu2	feng2	tian1	yi1",
		"无间是非", "	wu2	jian4	shi4	fei1",
		"无尽无穷", "	wu2	jin4	wu2	qiong2",
		"乌面鹄形", "	wu1	mian4	hu2	xing2",
		"阿里山乡", "	a	li3	shan1	xiang1",
		"阿谀奉承", "	e1	yu2	feng4	cheng2",
		"长途跋涉", "	chang2	tu2	ba2	she4",
		"舞衫歌扇", "	wu3	shan1	ge1	shan4",
		"炫石为玉", "	xuan4	shi2	wei2	yu4",
		"逻辑演算", "	luo2	ji	yan3	suan4",
		"倒买倒卖", "	dao3	mai3	dao3	mai4",
		"雪山太子", "	xue3	shan1	tai4	zi3",
		"信以为真", "	xin4	yi3	wei2	zhen1",
		"兴微继绝", "	xing1	wei1	ji4	jue2",
		"量子力学", "	liang4	zi3	li4	xue2",
		"量力而为", "	liang4	li4	er2	wei2",
		"行侠好义", "	xing2	xia2	hao4	yi4",
		"兴云致雨", "	xing1	yun2	zhi4	yu3",
		"袖里乾坤", "	xiu4	li3	qian2	kun1",
		"明智之举", "	ming2	zhi4	zhi1	ju3",
		"花花公子", "	hua1	hua1	gong1	zi3",
		"形式逻辑", "	xing2	shi4	luo2	ji",
		"花旗银行", "	hua1	qi2	yin2	hang2",
		"褚小杯大", "	zhu3	xiao3	bei1	da4",
		"犹未为晚", "	you2	wei4	wei2	wan3",
		"狼号鬼哭", "	lang2	hao2	gui3	ku1",
		"三更半夜", "	san1	geng1	ban4	ye4",
		"属垣有耳", "	zhu3	yuan2	you3	er3",
		"物资供应", "	wu4	zi1	gong1	ying4",
		"爵士音乐", "	jue2	shi4	yin1	yue4",
		"针线活儿", "	zhen1	xian4	huo2	r",
		"宿雨餐风", "	xiu3	yu3	can1	feng1",
		"适度微调", "	shi4	du4	wei1	tiao2",
		"心在魏阙", "	xin1	zai4	wei4	que4",
		"佛蒙特州", "	fo2	meng2	te4	zhou1",
		"偃武兴文", "	yan3	wu3	xing1	wen2",
		"逼人太甚", "	bi1	ren2	tai4	shen4",
		"进退为难", "	jin4	tui4	wei2	nan2",
		"曲终奏雅", "	qu3	zhong1	zou4	ya3",
		"曲肱而枕", "	qu3	gong1	er2	zhen3",
		"燕跃鹄踊", "	yan4	yue4	hu2	yong3",
		"都市传奇", "	du1	shi4	chuan2	qi2",
		"重码词频", "	chong2	ma3	ci2	pin2",
		"省身克己", "	xing3	shen1	ke4	ji3",
		"性别差异", "	xing4	bie2	cha1	yi4",
		"日本银行", "	ri4	ben3	yin2	hang2",
		"兴讹造讪", "	xing1	e2	zao4	shan4",
		"日电电子", "	ri4	dian4	dian4	zi3",
		"兴废继绝", "	xing1	fei4	ji4	jue2",
		"兴利除害", "	xing1	li4	chu2	hai4",
		"键盘乐器", "	jian4	pan2	yue4	qi4",
		"兴如嚼蜡", "	xing4	ru2	jiao2	la4",
		"相与为一", "	xiang1	yu3	wei2	yi1",
		"长期以来", "	chang2	qi1	yi3	lai2",
		"一叶扁舟", "	yi1	ye4	pian1	zhou1",
		"引以为鉴", "	yin3	yi3	wei2	jian4",
		"衣锦荣归", "	yi4	jin3	rong2	gui1",
		"处世之道", "	chu3	shi4	zhi1	dao4",
		"人模狗样", "	ren2	mu2	gou3	yang4",
		"人情味儿", "	ren2	qing2	wei4	er2",
		"未卜先知", "	wei4	bu3	xian1	zhi1",
		"蔚为大观", "	wei4	wei2	da4	guan1",
		"亹亹不倦", "	tan1	wei3	bu4	juan4",
		"蓬头散发", "	peng2	tou2	san4	fa4",
		"著书立说", "	zhu4	shu1	li4	shuo1",
		"一重一掩", "	yi1	chong2	yi1	yan3",
		"应付票据", "	ying4	fu4	piao4	ju4",
		"处世原则", "	chu3	shi4	yuan2	ze2",
		"交通阻塞", "	jiao1	tong1	zu3	se4",
		"鹰觑鹘望", "	ying1	qu4	hu2	wang4",
		"亚曼牙乡", "	ya4	man4	ya2	xiang1",
		"华纳兄弟", "	hua4	na4	xiong1	di4",
		"用词不当", "	yong4	ci2	bu4	dang4",
		"二重母音", "	er4	chong2	mu3	yin1",
		"洋里洋气", "	yang2	li	yang2	qi4",
		"一曲阳关", "	yi1	qu3	yang2	guan1",
		"有的放矢", "	you3	di4	fang4	shi3",
		"轻嘴薄舌", "	qing1	zui3	bo2	she2",
		"认识不能", "	ren4	shi	bu4	neng2",
		"以人为鉴", "	yi3	ren2	wei2	jian4",
		"更仆难数", "	geng1	pu2	nan2	shu3",
		"摇滚音乐", "	yao2	gun3	yin1	yue4",
		"瑶台银阙", "	yao2	tai2	yin2	que4",
		"鹞子翻身", "	yao4	zi3	fan1	shen1",
		"辐射对称", "	fu2	she4	dui4	chen4",
		"轻浪浮薄", "	qing1	lang4	fu2	bo2",
		"异常处理", "	yi4	chang2	chu3	li3",
		"以毛相马", "	yi3	mao2	xiang4	ma3",
		"誓死不降", "	shi4	si3	bu4	xiang2",
		"占为己有", "	zhan4	wei2	ji3	you3",
		"遗臭万载", "	yi2	chou4	wan4	zai3",
		"赶尽杀绝", "	gan3	jin4	sha1	jue2",
		"走漏消息", "	zou3	lou4	xiao1	xi",
		"贸易顺差", "	mao4	yi4	shun4	cha1",
		"买椟还珠", "	mai3	du2	huan2	zhu1",
		"以规为瑱", "	yi3	gui1	wei2	tian4",
		"庄稼户儿", "	zhuang1	jia	hu4	r",
		"杏仁豆腐", "	xing4	ren2	dou4	fu",
		"相女配夫", "	xiang4	nv3	pei4	fu1",
		"长足进步", "	chang2	zu2	jin4	bu4",
		"朝鲜字母", "	chao2	xian3	zi4	mu3",
		"人谁无过", "	ren2	shei2	wu2	guo4",
		"朝闻夕改", "	zhao1	wen2	xi1	gai3",
		"褎然举首", "	you4	ran2	ju3	shou3",
		"燕子衔食", "	yan4	zi3	xian2	shi2",
		"燕昭好马", "	yan1	zhao1	hao3	ma3",
		"数码相机", "	shu4	ma3	xiang4	ji1",
		"长途汽车", "	chang2	tu2	qi4	che1",
		"假假若是", "	jia3	jia4	ruo4	shi4",
		"一坐尽倾", "	yi1	zuo4	jin4	qing1",
		"值得敬佩", "	zhi2	de	jing4	pei4",
		"夕惕朝乾", "	xi1	ti4	zhao1	qian2",
		"蹊田夺牛", "	xi1	tian2	duo2	niu2",
		"斗筲之器", "	dou3	shao1	zhi1	qi4",
		"借花献佛", "	jie4	hua1	xian4	fo2",
		"借腹生子", "	jie4	fu4	sheng1	zi3",
		"先自隗始", "	xian1	zi4	wei3	shi3",
		"相差无几", "	xiang1	cha1	wu2	ji3",
		"人鱼小姐", "	ren2	yu2	xiao3	jie",
		"一坐尽惊", "	yi1	zuo4	jin4	jing1",
		"有借无还", "	you3	jie4	wu2	huan2",
		"什么时候", "	shen2	me	shi2	hou4",
		"交通堵塞", "	jiao1	tong1	du3	se4",
		"一朝千里", "	yi1	zhao1	qian1	li3",
		"处之泰然", "	chu3	zhi1	tai4	ran2",
		"饮马投钱", "	yin4	ma3	tou2	qian2",
		"朝乾夕惕", "	zhao1	qian2	xi1	ti4",
		"一朝之忿", "	yi1	zhao1	zhi1	fen4",
		"朝日新闻", "	zhao1	ri4	xin1	wen2",
		"朝朝暮暮", "	zhao1	zhao1	mu4	mu4",
		"行为主义", "	xing2	wei2	zhu3	yi4",
		"朝阳地区", "	zhao1	yang2	di4	qu1",
		"什么地方", "	shen2	me	di4	fang",
		"朝气蓬勃", "	zhao1	qi4	peng2	bo2",
		"什锦果盘", "	shi2	jin3	guo3	pan2",
		"处事原则", "	chu3	shi4	yuan2	ze2",
		"朝秦暮楚", "	zhao1	qin2	mu4	chu3",
		"朝花夕拾", "	zhao1	hua1	xi1	shi1",
		"朝过夕改", "	zhao1	guo4	xi1	gai3",
		"一掷乾坤", "	yi1	zhi4	qian2	kun1",
		"多财善贾", "	duo1	cai2	shan4	gu3",
		"度己以绳", "	duo2	ji3	yi3	sheng2",
		"精疲力尽", "	jing1	pi2	li4	jin4",
		"措置得当", "	cuo4	zhi4	de2	dang4",
		"日省月试", "	ri4	xing3	yue4	shi4",
		"除害兴利", "	chu2	hai4	xing1	li4",
		"重熙累绩", "	chong2	xi1	lei3	ji4",
		"心神不属", "	xin1	shen2	bu4	zhu3",
		"应急措施", "	ying4	ji2	cuo4	shi1",
		"日朘月削", "	ri4	juan1	yue4	xue1",
		"心急火燎", "	xin1	ji2	huo3	liao3",
		"且住为佳", "	qie3	zhu4	wei2	jia1",
		"日长似岁", "	ri4	chang2	si4	sui4",
		"琴瑟失调", "	qin2	se4	shi1	tiao2",
		"心宽体胖", "	xin1	kuan1	ti3	pan2",
		"只说不做", "	zhi1	shuo1	bu4	zuo4",
		"存亡未卜", "	cun2	wang2	wei4	bu3",
		"只言片语", "	zhi1	yan2	pian4	yu3",
		"乾乾翼翼", "	qian2	qian2	yi4	yi4",
		"切树倒根", "	qie1	shu4	dao3	gen1",
		"各尽所能", "	ge4	jin4	suo3	neng2",
		"合同各方", "	he2	tong	ge4	fang1",
		"倒三颠四", "	dao3	san1	dian1	si4",
		"日省月修", "	ri4	xing3	yue4	xiu1",
		"日削月朘", "	ri4	xue1	yue4	juan1",
		"合众为一", "	he2	zhong4	wei2	yi1",
		"敲骨剥髓", "	qiao1	gu3	bao1	sui3",
		"成佛作祖", "	cheng2	fo2	zuo4	zu3",
		"殚诚毕虑", "	dan1	cheng2	bi4	lv4",
		"三尺童子", "	san1	chi3	tong2	zi3",
		"青山一发", "	qing1	shan1	yi1	fa4",
		"千载一弹", "	qian1	zai3	yi1	dan4",
		"另辟蹊径", "	ling4	pi4	xi1	jing4",
		"应急出口", "	ying4	ji2	chu1	kou3",
		"重起炉灶", "	chong2	qi3	lu2	zao4",
		"寝丘之志", "	qin3	qiu1	zhi1	zhi4",
		"成吉思汗", "	cheng2	ji2	si1	han2",
		"德薄能鲜", "	de2	bo2	neng2	xian3",
		"重熙累叶", "	chong2	xi1	lei3	ye4",
		"箪食壶浆", "	dan1	si4	hu2	jiang1",
		"恶名昭著", "	e4	ming2	zhao1	zhu4",
		"重纰貤缪", "	chong2	pi1	yi2	miu4",
		"危若朝露", "	wei1	ruo4	zhao1	lu4",
		"危如累卵", "	wei1	ru2	lei3	luan3",
		"千磨百折", "	qian1	mo2	bai3	she2",
		"重理旧业", "	chong2	li3	jiu4	ye4",
		"情至意尽", "	qing2	zhi4	yi4	jin4",
		"青灯古佛", "	qing1	deng1	gu3	fo2",
		"千载一会", "	qian1	zai3	yi1	hui4",
		"重规袭矩", "	chong2	gui1	xi2	ju3",
		"肉山脯林", "	rou4	shan1	fu3	lin2",
		"轻财好义", "	qing1	cai2	hao4	yi4",
		"人自为战", "	ren2	zi4	wei2	zhan4",
		"应对如流", "	ying4	dui4	ru2	liu2",
		"古典音乐", "	gu3	dian3	yin1	yue4",
		"微电子学", "	wei1	dian4	zi3	xue2",
		"口干舌燥", "	kou3	gan1	she2	zao4",
		"日以为常", "	ri4	yi3	wei2	chang2",
		"啛啛喳喳", "	cui4	cui4	cha1	cha1",
		"重规沓矩", "	chong2	gui1	ta4	ju3",
		"千载一时", "	qian1	zai3	yi1	shi2",
		"处理程序", "	chu3	li3	cheng2	xu4",
		"汝成人耶", "	nu	cheng	ren	ye",
		"淡然置之", "	dan4	ran2	zhi4	zhi1",
		"黑更半夜", "	hei1	geng1	ban4	ye4",
		"后翻筋斗", "	hou4	fan1	jin1	dou3",
		"大局为重", "	da4	ju2	wei2	zhong4",
		"洒扫应对", "	sa3	sao4	ying4	dui4",
		"所作所为", "	suo3	zuo4	suo3	wei2",
		"攒锋聚镝", "	cuan2	feng1	ju4	di2",
		"重新组合", "	chong2	xin1	zu3	he2",
		"所向披靡", "	suo3	xiang4	pi1	mi3",
		"道在人为", "	dao4	zai4	ren2	wei2",
		"应接不暇", "	ying4	jie1	bu4	xia2",
		"大事铺张", "	da4	shi4	pu1	zhang1",
		"曲学诐行", "	qu3	xue2	hao3	xing2",
		"切近的当", "	qie1	jin4	de	dang1",
		"千载难遇", "	qian1	zai3	nan2	yu4",
		"代表大会", "	dai4	biao3	da4	hui4",
		"口不应心", "	kou3	bu4	ying4	xin1",
		"爱乐乐团", "	ai4	yue4	yue4	tuan2",
		"词穷理尽", "	ci2	qiong2	li3	jin4",
		"塞翁之马", "	sai4	weng1	zhi1	ma3",
		"出处进退", "	chu1	chu3	jin4	tui4",
		"敲诈勒索", "	qiao1	zha4	le4	suo3",
		"出没不常", "	chu1	mo4	bu4	chang2",
		"大相国寺", "	da4	xiang4	guo2	si4",
		"倒因为果", "	dao3	yin1	wei2	guo3",
		"反动分子", "	fan3	dong4	fen4	zi3",
		"儋石之储", "	dan4	shi2	zhi1	chu3",
		"乐尽哀生", "	le4	jin4	ai1	sheng1",
		"澄沙汰砾", "	deng4	sha1	tai4	li4",
		"才轻德薄", "	cai2	qing1	de2	bo2",
		"朝齑暮盐", "	zhao1	ji1	mu4	yan2",
		"才夸八斗", "	cai2	kua1	ba1	dou3",
		"累块积苏", "	lei3	kuai4	ji1	su1",
		"老师宿儒", "	lao3	shi1	xiu3	ru2",
		"称心如意", "	chen4	xin1	ru2	yi4",
		"稻荷寿司", "	dao4	he4	shou4	si1",
		"累累如珠", "	lei3	lei3	ru2	zhu1",
		"情见力屈", "	qing2	xian4	li4	qu1",
		"累苏积块", "	lei3	su1	ji1	kuai4",
		"重游故地", "	chong2	you2	gu4	di4",
		"将伯之呼", "	qiang1	bo2	zhi1	hu1",
		"触目兴叹", "	chu4	mu4	xing1	tan4",
		"抽筋剥皮", "	chou1	jin1	bao1	pi2",
		"千金之子", "	qian1	jin1	zhi1	zi3",
		"复兴时代", "	fu4	xing1	shi2	dai4",
		"求神问卜", "	qiu2	shen2	wen4	bu3",
		"强食自爱", "	qiang3	shi2	zi4	ai4",
		"横无忌惮", "	heng4	wu2	ji4	dan4",
		"财竭力尽", "	cai2	jie2	li4	jin4",
		"倒绷孩儿", "	dao4	beng1	hai2	er2",
		"积德累功", "	ji1	de2	lei3	gong1",
		"累计折旧", "	lei3	ji4	zhe2	jiu4",
		"朝发夕至", "	zhao1	fa1	xi1	zhi4",
		"壶里乾坤", "	hu2	li3	qian2	kun1",
		"粘皮著骨", "	nian2	pi2	zhu4	gu3",
		"窝阔台汗", "	wo1	kuo4	tai2	han2",
		"互教互学", "	hu4	jiao1	hu4	xue2",
		"昭德塞违", "	zhao1	de2	se4	wei2",
		"互为表里", "	hu4	wei2	biao3	li3",
		"纷至沓来", "	fen1	zhi4	ta4	lai2",
		"结核杆菌", "	jie2	he2	gan3	jun1",
		"老白干儿", "	lao3	bai2	gan1	er2",
		"出处殊途", "	chu1	chu3	shu1	tu2",
		"笑口弥勒", "	xiao4	kou3	mi2	le4",
		"任人摆布", "	ren4	ren2	bai3	bu4",
		"横蛮无理", "	heng4	man2	wu2	li3",
		"热核反应", "	re4	he2	fan3	ying4",
		"触处机来", "	chu4	chu3	ji1	lai2",
		"澜倒波随", "	lan2	dao3	bo1	sui2",
		"瞪目哆口", "	deng4	mu4	chi3	kou3",
		"强得易贫", "	qiang3	de2	yi4	pin2",
		"箪食瓢饮", "	dan1	si4	piao2	yin3",
		"同归于尽", "	tong2	gui1	yu2	jin4",
		"人民公仆", "	ren2	min2	gong1	pu2",
		"求过于供", "	qiu2	guo4	yu2	gong4",
		"陈力就列", "	chen2	li4	jiu4	lie4",
		"求神拜佛", "	qiu2	shen2	bai4	fo2",
		"泣数行下", "	qi4	shu4	hang2	xia4",
		"应用物理", "	ying4	yong4	wu4	li3",
		"赤绳系足", "	chi4	sheng2	ji4	zu2",
		"苫眼铺眉", "	shan1	yan3	pu1	mei2",
		"处尊居显", "	chu3	zun1	ju1	xian3",
		"称心满意", "	chen4	xin1	man3	yi4",
		"曲眉丰颊", "	qu3	mei2	feng1	jia2",
		"尺二冤家", "	chi3	er4	yuan1	jia",
		"思觉失调", "	si1	jue2	shi1	tiao2",
		"扎实推进", "	zha1	shi	tui1	jin4",
		"千里之志", "	qian1	li3	zhi1	zhi4",
		"强自取折", "	qiang2	zi4	qu3	she2",
		"重足累息", "	chong2	zu2	lei4	xi1",
		"性别角色", "	xing4	bie2	jue2	se4",
		"淡然处之", "	dan4	ran2	chu3	zhi1",
		"半夜三更", "	ban4	ye4	san1	geng1",
		"情见乎辞", "	qing2	xian4	hu1	ci2",
		"倾心尽力", "	qing1	xin1	jin4	li4",
		"厚死薄生", "	hou4	si3	bo2	sheng1",
		"三老五更", "	san1	lao3	wu3	geng1",
		"翘首企足", "	qiao2	shou3	qi3	zu2",
		"强而后可", "	qiang3	er2	hou4	ke3",
		"鹑衣鹄面", "	chun2	yi1	hu2	mian4",
		"瞪眼咋舌", "	deng4	yan3	ze2	she2",
		"吃着不尽", "	chi1	zhuo2	bu4	jin4",
		"应机立断", "	ying4	ji1	li4	duan4",
		"抵死谩生", "	di3	si3	man4	sheng1",
		"原子爆弹", "	yuan2	zi3	bao4	dan4",
		"穷不失义", "	qiong2	bu4	shi1	yi4",
		"应县木塔", "	ying4	xian4	mu4	ta3",
		"反兴奋剂", "	fan3	xing1	fen4	ji4",
		"反动势力", "	fan3	dong4	shi4	li",
		"诞谩不经", "	dan4	man4	bu4	jing1",
		"人事不省", "	ren2	shi4	bu4	xing3",
		"半身不遂", "	ban4	shen1	bu4	sui2",
		"请自隗始", "	qing3	zi4	wei3	shi3",
		"了不可见", "	liao3	bu4	ke3	jian4",
		"守正不阿", "	shou3	zheng4	bu4	e1",
		"逆施倒行", "	ni4	shi1	dao3	xing2",
		"奏鸣曲式", "	zou4	ming2	qu3	shi4",
		"谨毛失貌", "	jin3	mao2	shi1	mao4",
		"尽其所能", "	jin4	qi2	suo3	neng2",
		"天竺牡丹", "	tian1	zhu2	mu3	dan",
		"进退出处", "	jin4	tui4	chu1	chu3",
		"经纶济世", "	jing	lun	ji	shi",
		"经史百子", "	jing1	shi3	bai3	zi3",
		"将门虎子", "	jiang4	men2	hu3	zi3",
		"精义入神", "	jing	yi	ru	shen",
		"还我河山", "	huan2	wo3	he2	shan1",
		"尽付东流", "	jin4	fu4	dong1	liu2",
		"积以为常", "	ji1	yi3	wei2	chang2",
		"举世混浊", "	ju3	shi4	hun2	zhuo2",
		"娱乐场所", "	yu2	le4	chang2	suo3",
		"火急火燎", "	huo3	ji2	huo3	liao3",
		"倔头倔脑", "	jue4	tou	jue4	nao3",
		"婚生子女", "	hun1	sheng1	zi3	nv3",
		"多灾多难", "	duo1	zai1	duo1	nan4",
		"魂飞魄丧", "	hun2	fei1	po4	sang1",
		"见义敢为", "	jian4	yi4	gan3	wei2",
		"浇风薄俗", "	jiao1	feng1	bo2	su2",
		"君子协定", "	jun1	zi3	xie2	ding4",
		"戟指嚼舌", "	ji3	zhi3	jiao2	she2",
		"捡洋落儿", "	jian3	yang2	la4	er2",
		"佳人薄命", "	jia1	ren2	bo2	ming4",
		"鞠躬屏气", "	ju1	gong1	bing3	qi4",
		"好为人师", "	hao4	wei2	ren2	shi1",
		"好酒贪杯", "	hao4	jiu3	tan1	bei1",
		"好高骛远", "	hao4	gao1	wu4	yuan3",
		"如数家珍", "	ru2	shu3	jia1	zhen1",
		"钜人长德", "	ju4	ren2	chang2	de2",
		"举措失当", "	ju3	cuo4	shi1	dang4",
		"太阳黑子", "	tai4	yang2	hei1	zi3",
		"基因重组", "	ji1	yin1	chong2	zu3",
		"大处着眼", "	da4	chu4	zhuo2	yan3",
		"尖嘴薄舌", "	jian1	zui3	bo2	she2",
		"解除合同", "	jie3	chu2	he2	tong",
		"解衣盘磅", "	jie3	yi1	pan2	pang2",
		"教一识百", "	jiao1	yi1	shi2	bai3",
		"嚼铁咀金", "	jiao2	tie3	ju3	jin1",
		"教书育人", "	jiao1	shu1	yu4	ren2",
		"君子固穷", "	jun1	zi3	gu4	qiong2",
		"开户银行", "	kai1	hu4	yin2	hang2",
		"间不容息", "	jian4	bu4	rong2	xi1",
		"鼓衰力尽", "	gu3	shuai1	li4	jin4",
		"积功兴业", "	ji1	gong1	xing1	ye4",
		"急公好施", "	ji2	gong1	hao4	shi1",
		"疾风甚雨", "	ji2	feng1	shen4	yu3",
		"抉奥阐幽", "	jue2	ao4	chan3	you1",
		"激薄停浇", "	ji1	bo2	ting2	jiao1",
		"饥寒交切", "	ji1	han2	jiao1	qie1",
		"吐蕃王朝", "	tu3	bo1	wang2	chao2",
		"流血漂橹", "	liu2	xie3	piao1	lu3",
		"黏黏糊糊", "	nian2	nian2	hu1	hu1",
		"计尽力穷", "	ji4	jin4	li4	qiong2",
		"年谊世好", "	nian2	yi4	shi4	hao4",
		"康巴藏区", "	kang1	ba1	zang4	qu1",
		"宁折不弯", "	ning4	zhe2	bu4	wan1",
		"扼腕长叹", "	e4	wan4	chang2	tan4",
		"廊坊地区", "	lang2	fang2	di4	qu1",
		"峨峨汤汤", "	e2	e2	shang1	shang1",
		"夺人所好", "	duo2	ren2	suo3	hao4",
		"怒涛澎湃", "	nu4	tao1	peng2	pai4",
		"大便干燥", "	da4	bian4	gan1	zao4",
		"豁然省悟", "	huo4	ran2	xing3	wu4",
		"看家本事", "	kan1	jia1	ben3	shi4",
		"吉凶未卜", "	ji2	xiong1	wei4	bu3",
		"回干就湿", "	hui2	gan1	jiu4	shi1",
		"看守内阁", "	kan1	shou3	nei4	ge2",
		"子宫颈癌", "	zi3	gong1	jing3	ai2",
		"黄口孺子", "	huang2	kou3	ru2	zi3",
		"恪尽职守", "	ke4	jin4	zhi2	shou3",
		"没齿难忘", "	mo4	chi3	nan2	wang4",
		"还珠买椟", "	huan2	zhu1	mai3	du2",
		"回天倒日", "	hui2	tian1	dao3	ri4",
		"倔强倨傲", "	jue2	jiang4	ju4	ao4",
		"积累经验", "	ji1	lei3	jing1	yan4",
		"祸为福先", "	huo4	wei2	fu2	xian1",
		"箕山之志", "	ji1	shan1	zhi1	zhi4",
		"计穷虑尽", "	ji4	qiong2	lv4	jin4",
		"句子成分", "	ju4	zi	cheng2	fen4",
		"计穷力尽", "	ji4	qiong2	li4	jin4",
		"极情尽致", "	ji2	qing2	jin4	zhi4",
		"积年累岁", "	ji1	nian2	lei3	sui4",
		"卷甲韬戈", "	juan4	jia3	tao1	ge1",
		"居不重茵", "	ju1	bu4	chong2	yin1",
		"久要不忘", "	jiu3	yao1	bu4	wang4",
		"累教不改", "	lei3	jiao4	bu4	gai3",
		"胡作乱为", "	hu2	zuo4	luan4	wei2",
		"哗世取名", "	hua2	shi4	qu3	ming2",
		"哗世动俗", "	hua2	shi4	dong4	su2",
		"画蛇著足", "	hua4	she2	zhuo2	zu2",
		"化合反应", "	hua4	he2	fan3	ying4",
		"红颜白发", "	hong2	yan2	bai2	fa4",
		"花攒锦聚", "	hua1	cuan2	jin3	ju4",
		"花簇锦攒", "	hua1	cu4	jin3	cuan2",
		"会计核算", "	kuai4	ji4	he2	suan4",
		"塞翁失马", "	sai4	weng1	shi1	ma3",
		"怀敌附远", "	huai2	di2	fu4	yuan3",
		"快心遂意", "	kuai4	xin1	sui2	yi4",
		"字里行间", "	zi4	li3	hang2	jian1",
		"揆理度情", "	kui2	li3	duo2	qing2",
		"揆情度理", "	kui2	qing2	duo2	li3",
		"花攒锦簇", "	hua1	cuan2	jin3	cu4",
		"口轻舌薄", "	kou3	qing1	she2	bo2",
		"好学不倦", "	hao4	xue2	bu4	juan4",
		"礼让为国", "	li3	rang4	wei2	guo2",
		"花朝月夜", "	hua1	zhao1	yue4	ye4",
		"淮橘为枳", "	huai2	ju2	wei2	zhi3",
		"刿心鉥肾", "	gui4	xin1	xu4	shen4",
		"李广不侯", "	li3	guang3	bu4	hou4",
		"横行无忌", "	heng2	xing2	wu2	ji4",
		"横行不法", "	heng2	xing2	bu4	fa3",
		"擂天倒地", "	lei2	tian1	dao3	di4",
		"累土至山", "	lei3	tu3	zhi4	shan1",
		"鸿鹄之志", "	hong2	hu2	zhi1	zhi4",
		"累足成步", "	lei3	zu2	cheng2	bu4",
		"客户应用", "	ke4	hu4	ying4	yong4",
		"合同管理", "	he2	tong	guan3	li3",
		"历尽艰辛", "	li4	jin4	jian1	xin1",
		"苦尽甜来", "	ku3	jin4	tian2	lai2",
		"河梁之谊", "	he2	liang2	zhi4	yi2",
		"合两为一", "	he2	liang3	wei2	yi1",
		"赫赫之光", "	he4	he4	zhi4	guang1",
		"横倒竖卧", "	heng2	dao3	shu4	wo4",
		"历精为治", "	li4	jing1	wei2	zhi4",
		"洪炉燎发", "	hong2	lu2	liao2	fa4",
		"腊尽春回", "	la4	jin4	chun1	hui2",
		"口血未干", "	kou3	xue4	wei4	gan1",
		"刿鉥肝肾", "	gui4	xu4	gan1	shen4",
		"桂折兰摧", "	gui4	she2	lan2	cui1",
		"好吃懒做", "	hao4	chi1	lan3	zuo4",
		"过为已甚", "	guo4	wei2	yi3	shen4",
		"宁缺勿滥", "	ning4	que1	wu4	lan4",
		"宁缺毋滥", "	ning4	que1	wu2	lan4",
		"鬼蜮伎俩", "	gui3	yu4	ji4	liang3",
		"图像处理", "	tu2	xiang4	chu3	li3",
		"国定假日", "	guo2	ding4	jia4	ri4",
		"敛色屏气", "	lian3	se4	bing3	qi4",
		"含混不清", "	han2	hun2	bu4	qing1",
		"量力度德", "	liang4	li4	duo2	de2",
		"行间字里", "	hang2	jian1	zi4	li3",
		"礼为情貌", "	li3	wei2	qing2	mao4",
		"对称破缺", "	dui4	chen4	po4	que1",
		"空调机组", "	kong1	tiao2	ji1	zu3",
		"还珠返璧", "	huan2	zhu1	fan3	bi4",
		"女性厌恶", "	nu:3	xing4	yan4	wu4",
		"大兴安岭", "	da4	xing1	an1	ling3",
		"好久不见", "	hao3	jiu3	bu	jian4",
		"大腹便便", "	da4	fu4	pian2	pian2",
		"间接推理", "	jian4	jie1	tui1	li3",
		"宁左勿右", "	ning4	zuo3	wu4	you4",
		"察微知著", "	cha2	wei1	zhi1	zhu4",
		"专心一意", "	zhuan1	xin1	yi1	yi4",
		"管理会计", "	guan3	li3	kuai4	ji4",
		"劣迹昭着", "	lie4	ji4	zhao1	zhe",
		"劣迹昭著", "	lie4	ji4	zhao1	zhu4",
		"裂眦嚼齿", "	lie4	zi4	jiao2	chi3",
		"临敌易将", "	lin2	di2	yi4	jiang4",
		"射频干扰", "	she4	pin2	gan1	rao3",
		"临难不恐", "	lin2	nan4	bu4	kong3",
		"凌波仙子", "	ling2	bo1	xian1	zi3",
		"领导班子", "	ling2	dao3	ban1	zi3",
		"冠绝一时", "	guan4	jue2	yi1	shi2",
		"里挑外撅", "	li3	tiao3	wai4	jue1",
		"冠屦倒施", "	guan4	ju4	dao3	shi1",
		"对牛弹琴", "	dui4	niu2	tan2	qin2",
		"麟子凤雏", "	lin2	zi3	feng4	chu2",
		"毫无用处", "	hao2	wu2	yong4	chu",
		"规旋矩折", "	gui1	xuan2	ju3	she2",
		"过而能改", "	guo4	er2	neng2	gai3",
		"立身处世", "	li4	shen1	chu3	shi4",
		"好善乐施", "	hao4	shan4	le4	shi1",
		"滔滔不尽", "	tao1	tao1	bu4	jin4",
		"敏而好学", "	min3	er2	hao4	xue2",
		"抓破脸子", "	zhua1	po4	lian3	zi3",
		"普什图语", "	pu3	shi2	tu2	yu3",
		"的一确二", "	di2	yi1	que4	er4",
		"柴立不阿", "	chai2	li4	bu4	e1",
		"魂不附体", "	hun2	bu4	fu4	ti3",
		"业余爱好", "	ye4	yu2	ai4	hao4",
		"无与为比", "	wu2	yu3	wei2	bi3",
		"一鼻子灰", "	yi1	bi2	zi3	hui1",
		"走背字儿", "	zou3	bei4	zi4	r",
		"佛洛伊德", "	fo2	luo4	yi1	de2",
		"易地而处", "	yi4	di4	er2	chu3",
		"呆似木鸡", "	dai1	si4	mu4	ji1",
		"佛罗里达", "	fo2	luo2	li3	da2",
		"偃旗仆鼓", "	yan3	qi2	pu2	gu3",
		"悉索薄赋", "	xi1	suo3	bo2	fu4",
		"太子河区", "	tai4	zi3	he2	qu1",
		"值得一提", "	zhi2	de	yi1	ti2",
		"贝塔粒子", "	bei4	ta3	li4	zi3",
		"四季豆腐", "	si4	ji4	dou4	fu",
		"薄胎瓷器", "	bo2	tai1	ci2	qi4",
		"低音喇叭", "	di1	yin1	la3	ba",
		"巴勒斯坦", "	ba1	le4	si1	tan3",
		"一字不差", "	yi1	zi4	bu4	cha1",
		"可疑分子", "	ke3	yi2	fen4	zi3",
		"豁达大度", "	huo4	da2	da4	du4",
		"如金似玉", "	ru2	jin1	si4	yu4",
		"参差不一", "	cen1	ci1	bu4	yi1",
		"暴衣露盖", "	pu4	yi1	lu4	gai4",
		"自给有余", "	zi4	ji3	you3	yu2",
		"耶鲁大学", "	ye1	lu3	da4	xue2",
		"打闷葫芦", "	da3	men4	hu2	lu",
		"咸丝丝儿", "	xian2	si1	si1	r",
		"塞哥维亚", "	se4	ge1	wei2	ya4",
		"仆仆亟拜", "	pu2	pu2	ji2	bai4",
		"仆仆道途", "	pu2	pu2	dao4	tu2",
		"赫鲁雪夫", "	he4	lu3	xue3	fu",
		"妇人孺子", "	fu4	ren2	ru2	zi3",
		"夫子自道", "	fu1	zi3	zi4	dao4",
		"萨哈罗夫", "	sa4	ha3	luo2	fu1",
		"萨哈诺夫", "	sa4	ha3	nuo4	fu1",
		"赛普勒斯", "	sai4	pu3	le4	si1",
		"基本粒子", "	ji1	ben3	li4	zi3",
		"大头娃娃", "	da4	tou2	wa2	wa",
		"达到目的", "	da2	dao4	mu4	di4",
		"故甚其词", "	gu4	shen4	qi2	ci2",
		"咖啡馆儿", "	ka1	fei1	guan3	r",
		"如鱼似水", "	ru2	yu2	si4	shui3",
		"指鹿为马", "	zhi3	lu4	wei2	ma3",
		"红得发紫", "	hong2	de	fa1	zi3",
		"积日累久", "	ji1	ri4	lei3	jiu3",
		"卡文迪什", "	ka3	wen2	di2	shi2",
		"济济一堂", "	ji3	ji3	yi1	tang2",
		"否极泰来", "	pi3	ji2	tai4	lai2",
		"如拾地芥", "	ru2	shi2	di4	jie4",
		"湮没无闻", "	yan1	mo4	wu2	wen2",
		"不尽人意", "	bu4	jin4	ren2	yi4",
		"胡作胡为", "	hu2	zuo4	hu2	wei2",
		"济宁地区", "	ji3	ning2	di4	qu1",
		"左宜右有", "	zuo3	yi2	you4	fu2",
		"坐地自划", "	zuo4	di4	zi4	hua2",
		"百思莫解", "	bai3	si1	mo4	jie3",
		"孤行一意", "	gu1	xing2	yi1	yi4",
		"眦裂发指", "	zi4	lie4	fa4	zhi3",
		"积时累日", "	ji1	shi2	lei3	ri4",
		"厚古薄今", "	hou4	gu3	bo2	jin1",
		"累及无辜", "	lei3	ji2	wu2	gu1",
		"不可究诘", "	bu4	ke3	jiu1	jie2",
		"析骸易子", "	xi1	hai2	yi4	zi3",
		"呼来喝去", "	hu1	lai2	he4	qu4",
		"大雅君子", "	da4	ya3	jun1	zi3",
		"葫芦依样", "	hu2	lu	yi1	yang4",
		"模糊数学", "	mo2	hu	shu4	xue2",
		"击石弹丝", "	ji1	shi2	tan2	si1",
		"模糊不清", "	mo2	hu	bu4	qing1",
		"如痴似醉", "	ru2	chi1	si4	zui4",
		"一丘之貉", "	yi1	qiu1	zhi1	he2",
		"孤文只义", "	gu1	wen2	zhi1	yi4",
		"半部论语", "	ban4	bu4	lun2	yu3",
		"咭咭呱呱", "	ji1	ji1	gua1	gua1",
		"一暴十寒", "	yi1	pu4	shi2	han2",
		"白日衣绣", "	bai2	ri4	yi4	xiu4",
		"百堕俱举", "	bai3	hui1	ju4	ju3",
		"人足家给", "	ren2	zu2	jia1	ji3",
		"扳不倒儿", "	ban1	bu4	dao3	er2",
		"呼幺喝六", "	hu1	yao1	he4	liu4",
		"耶利米书", "	ye1	li4	mi3	shu1",
		"严了眼儿", "	yan2	le	yan3	r",
		"字纸篓子", "	zi4	zhi3	lou3	zi",
		"齐眉穗儿", "	qi2	mei2	sui4	r",
		"婀娜多姿", "	e1	nuo2	duo1	zi1",
		"不绝如发", "	bu4	jue2	ru2	fa4",
		"包袱皮儿", "	bao1	fu2	pi2	er",
		"刻鹄类鹜", "	ke4	hu2	lei4	wu4",
		"草字头儿", "	cao3	zi4	tou2	r",
		"库尔勒市", "	ku4	er3	le4	shi4",
		"倒打一耙", "	dao4	da3	yi1	pa2",
		"柏蒂切利", "	bo2	di4	qie4	li4",
		"漫无目的", "	man4	wu2	mu4	di4",
		"负担不起", "	fu4	dan1	bu	qi3",
		"泥而不滓", "	nie4	er2	bu4	zi3",
		"凡夫俗子", "	fan2	fu1	su2	zi3",
		"刻薄寡恩", "	ke4	bo2	gua3	en1",
		"茄子河区", "	qie2	zi	he2	qu1",
		"泥多佛大", "	ni2	duo1	fo2	da4",
		"哈德逊河", "	ha1	de2	xun4	he2",
		"舍利子塔", "	she4	li4	zi	ta3",
		"离本趣末", "	li2	ben3	qu1	mo4",
		"心细如发", "	xin1	xi4	ru2	fa4",
		"阿意取容", "	e1	yi4	qu3	rong2",
		"岁聿其莫", "	sui4	yu4	qi2	mu4",
		"聚米为谷", "	ju4	mi3	wei2	gu3",
		"贝尔格勒", "	bei4	er3	ge2	le4",
		"阿赖耶识", "	a1	lai4	ye1	shi2",
		"合而为一", "	he2	er2	wei2	yi1",
		"何足为奇", "	he2	zu2	wei2	qi2",
		"削发披缁", "	xue1	fa4	pi1	zi1",
		"阿世媚俗", "	e1	shi4	mei4	su2",
		"子虚乌有", "	zi3	xu1	wu1	you3",
		"学习目的", "	xue2	xi2	mu4	di4",
		"杜塞道夫", "	du4	se4	dao4	fu1",
		"德布勒森", "	de2	bu4	le4	sen1",
		"须弥芥子", "	xu1	mi2	jie4	zi3",
		"泥足巨人", "	ni2	zu2	ju4	ren2",
		"私淑弟子", "	si1	shu1	di4	zi3",
		"搭把手儿", "	da1	ba3	shou3	r",
		"子母扣儿", "	zi3	mu3	kou4	er2",
		"乌德勒支", "	wu1	de2	le4	zhi1",
		"巴甫洛夫", "	ba1	fu3	luo4	fu1",
		"合二为一", "	he2	er4	wei2	yi1",
		"分丝析缕", "	fen1	si1	xi1	lv3",
		"企业倒闭", "	qi3	ye4	dao3	bi4",
		"临崖勒马", "	lin2	ya2	le4	ma3",
		"济南地区", "	ji3	nan2	di4	qu1",
		"阿谀取容", "	e1	yu2	qu3	rong2",
		"爱素好古", "	ai4	su4	hao4	gu3",
		"八字帖儿", "	ba1	zi4	tie3	er2",
		"不足为法", "	bu4	zu2	wei2	fa3",
		"不足为据", "	bu4	zu2	wei2	ju4",
		"过一会儿", "	guo4	yi1	hui4	r",
		"不以为奇", "	bu4	yi3	wei2	qi2",
		"一览无遗", "	yi1	lai3	wu2	yi2",
		"一心一意", "	yi1	xin1	yi1	yi4",
		"不足为意", "	bu4	zu2	wei2	yi4",
		"布鲁塞尔", "	bu4	lu3	sai4	er3",
		"妻梅子鹤", "	qi1	men2	zi3	he4",
		"得马折足", "	de2	ma3	she2	zu2",
		"几何拓扑", "	ji3	he2	tuo4	pu1",
		"打马虎眼", "	da3	ma3	hu	yan3",
		"大吃大喝", "	da4	chi1	da4	he4",
		"跗萼载韡", "	fu1	e4	zai3	wei3",
		"历历可数", "	li4	li4	ke3	shu3",
		"嘁哩喀喳", "	qi1	li3	ka1	cha1",
		"矮子看戏", "	ai3	zi3	kan4	xi4",
		"粪土不如", "	fen4	tu2	bu4	ru2",
		"哈佛大学", "	ha1	fo2	da4	xue2",
		"呢喃细语", "	ni2	nan2	xi4	yu3",
		"遂迷不寤", "	sui2	mi2	bu4	wu4",
		"不足部分", "	bu4	zu2	bu4	fen",
		"何乐不为", "	he2	le4	bu4	wei2",
		"不以为意", "	bu4	yi3	wei2	yi4",
		"泰极而否", "	tai4	ji2	er2	pi3",
		"葛瑞格尔", "	ge3	rui4	ge2	er3",
		"毫不客气", "	hao2	bu4	ke4	qi",
		"曲霉毒素", "	qu3	mei2	du2	su4",
		"大难不死", "	da4	nan4	bu4	si3",
		"葡萄干儿", "	pu2	tao	gan1	r",
		"聱牙诘屈", "	ao2	ya2	jie2	qu1",
		"囤积居奇", "	tun2	ji1	ju1	qi2",
		"帕特丽夏", "	pa4	te4	li2	xia4",
		"艾哈迈德", "	ai4	ha3	mai4	de2",
		"为德不卒", "	wei2	de2	bu4	zu2",
		"似有如无", "	si4	you3	ru2	wu2",
		"伺瑕抵隙", "	si4	xia2	di3	xi4",
		"日薄西山", "	ri4	bo2	xi1	shan1",
		"如花似锦", "	ru2	hua1	si4	jin3",
		"鹤子梅妻", "	he4	zi3	mei2	qi1",
		"木头人儿", "	mu4	tou2	ren2	er",
		"发指眦裂", "	fa4	zhi3	zi4	lie4",
		"哩哩罗罗", "	li1	li1	luo1	luo1",
		"骨头节儿", "	gu2	tou	jie2	er2",
		"不差毫厘", "	bu4	cha1	hao2	li2",
		"扒耳搔腮", "	pa2	er3	sao1	sai1",
		"撒都该人", "	sa1	du1	gai1	ren2",
		"高音喇叭", "	gao1	yin1	la3	ba",
		"火妻灰子", "	huo3	qi1	hui1	zi3",
		"狗拿耗子", "	gou3	na2	hao4	zi3",
		"哩哩啰啰", "	li1	li	luo1	luo1",
		"吉卜赛人", "	ji2	bu3	sai4	ren2",
		"独辟蹊径", "	du2	pi4	xi1	jing4",
		"披头散发", "	pi1	tou2	san4	fa4",
		"独山子区", "	du2	shan1	zi3	qu1",
		"号寒啼饥", "	hao2	han2	ti2	ji1",
		"庆父不死", "	qing4	fu3	bu4	si3",
		"不可数集", "	bu4	ke3	shuo4	ji2",
		"独具只眼", "	du2	ju4	zhi1	yan3",
		"不以为然", "	bu4	yi3	wei2	ran2",
		"厚德载福", "	hou4	de2	zai3	fu2",
		"拉卜楞寺", "	la1	bu3	leng4	si4",
		"掳人勒赎", "	lu3	ren2	le4	shu2",
		"富得流油", "	fu4	de	liu2	you2",
		"好逸恶劳", "	hao4	yi4	wu4	lao2",
		"积累基金", "	ji1	lei3	ji1	jin1",
		"鼓起勇气", "	gu3	qi3	yong3	qi4",
		"不是滋味", "	bu2	shi4	zi1	wei4",
		"助桀为恶", "	zhu4	jie2	wei2	e4",
		"只骑不反", "	zhi1	qi2	bu4	fan3",
		"不是味儿", "	bu2	shi4	wei4	er2",
		"子孝父慈", "	zi3	xiao4	fu4	ci2",
		"难乎为继", "	nan2	hu1	wei2	ji4",
		"不拔之志", "	bu4	ba2	zhi1	zhi4",
		"子子孙孙", "	zi3	zi3	sun1	sun1",
		"蔽日干云", "	bi4	ri4	gan1	yun2",
		"比物属事", "	bi3	wu4	zhu3	shi4",
		"置之不顾", "	zhi4	zhi1	bu4	gu4",
		"豁人耳目", "	huo4	ren2	er3	mu4",
		"差异分析", "	cha1	yi4	fen1	xi1",
		"厚今薄古", "	hou4	jin1	bo2	gu3",
		"骨头架子", "	gu2	tou	jia4	zi",
		"之子于归", "	zhi1	zi3	yu2	gui1",
		"好语似珠", "	hao3	yu3	si4	zhu1",
		"刿目鉥心", "	gui4	mu4	xu4	xin1",
		"莫可究诘", "	mo4	ke3	jiu1	jie2",
		"脾气暴躁", "	pi2	qi	bao4	zao4",
		"靡有孑遗", "	mi3	you3	jie2	yi2",
		"靡靡之音", "	mi3	mi3	zhi1	yin1",
		"背碑覆局", "	bei4	bei1	fu4	ju2",
		"著于竹帛", "	zhu4	yu2	zhu2	bo2",
		"一饮而尽", "	yi1	yin3	er2	jin4",
		"子为父隐", "	zi3	wei2	fu4	yin3",
		"比什凯克", "	bi3	shi2	kai3	ke4",
		"不切实际", "	bu4	qie1	shi2	ji4",
		"主要目的", "	zhu3	yao4	mu4	di4",
		"不足为训", "	bu4	zu2	wei2	xun4",
		"鲍子知我", "	bao4	zi3	zhi1	wo3",
		"气息奄奄", "	qi4	xi1	yan1	yan1",
		"电荷耦合", "	dian4	he4	ou3	he2",
		"仁义君子", "	ren2	yi4	jun1	zi3",
		"丢三落四", "	diu1	san1	la4	si4",
		"原子武器", "	yuan2	zi3	wu3	qi4",
		"墨迹未干", "	mo4	ji4	wei4	gan1",
		"挨打受气", "	ai2	da3	shou4	qi4",
		"马萨诸塞", "	ma3	sa4	zhu1	sai4",
		"白眼珠儿", "	bai2	yan3	zhu1	r",
		"吼三喝四", "	hou3	san1	he4	si4",
		"驽马十舍", "	nu2	ma3	shi2	she4",
		"父慈子孝", "	fu4	ci2	zi3	xiao4",
		"目眦尽裂", "	mu4	zi4	jin4	lie4",
		"清辞丽曲", "	qing1	ci2	li4	qu3",
		"难以为继", "	nan2	yi3	wei2	ji4",
		"不差什么", "	bu4	cha4	shi2	mo3",
		"温切斯特", "	wen1	qie1	si1	te4",
		"互不干涉", "	hu4	bu4	gan1	she4",
		"匹马只轮", "	pi3	ma3	zhi1	lun2",
		"没有意思", "	mei2	you3	yi4	si",
		"为仁不富", "	wei2	ren2	bu4	fu4",
		"热热闹闹", "	re4	re4	nao1	nao",
		"安分知足", "	an1	fen4	zhi1	zu2",
		"击排冒没", "	ji1	pai2	mao4	mo4",
		"为富不仁", "	wei2	fu4	bu4	ren2",
		"比佛利山", "	bi3	fo2	li4	shan1",
		"挨打受骂", "	ai2	da3	shou4	ma4",
		"及时处理", "	ji2	shi2	chu3	li3",
		"各行各业", "	ge4	hang2	ge4	ye4",
		"只眼独具", "	zhi1	yan3	du2	ju4",
		"呢呢痴痴", "	ni2	ni2	chi1	chi1",
		"七老八倒", "	qi1	lao3	ba1	dao3",
		"暴衣露冠", "	pu4	yi1	lu4	guan4",
		"雷扎耶湖", "	lei2	zha2	ye1	hu2",
		"子母炸弹", "	zi3	mu3	zha4	dan4",
		"日乾夕惕", "	ri4	qian2	xi1	ti4",
		"日甚一日", "	ri4	shen4	yi1	ri4",
		"如履薄冰", "	ru2	lv3	bo2	bing1",
		"一朝一夕", "	yi1	zhao1	yi1	xi1",
		"卸磨杀驴", "	xie4	mo4	sha1	lv2",
		"朝不及夕", "	zhao1	bu4	ji2	xi1",
		"化腐为奇", "	hua4	fu3	wei2	qi2",
		"波流茅靡", "	bo1	liu2	mao2	mi3",
		"别开一格", "	bie2	kai1	yi2	ge2",
		"寡凫单鹄", "	gua3	fu2	dan1	hu2",
		"电子伏特", "	dian4	zi3	fu2	te4",
		"如切如磋", "	ru2	qie1	ru2	cuo1",
		"否极泰回", "	pi3	ji2	tai4	hui2",
		"披发左衽", "	pi1	fa4	zuo3	ren4",
		"子母炮弹", "	zi3	mu3	pao4	dan4",
		"白费力气", "	bai2	fei4	li4	qi",
		"如龙似虎", "	ru2	long2	si4	hu3",
		"彬彬济济", "	bin1	bin1	ji3	ji3",
		"不可揆度", "	bu4	ke3	kui2	duo2",
		"呼天吁地", "	hu1	tian1	yu4	di4",
		"积素累旧", "	ji1	su4	lei3	jiu4",
		"含含糊糊", "	han2	han2	hu	hu1",
		"卜夜卜昼", "	bu3	ye4	bu3	zhou4",
		"弃甲倒戈", "	qi4	jia3	dao3	ge1",
		"播糠眯目", "	bo1	kang1	mi3	mu4",
		"扑杀此獠", "	pu1	sha1	ci3	lao3",
		"不亦善夫", "	bu4	yi	shan4	fu1",
		"如花似月", "	ru2	hua1	si4	yue4",
		"气克斗牛", "	qi4	ke4	dou3	niu2",
		"一模一样", "	yi1	mu2	yi1	yang4",
		"不随以止", "	bu	shui	yi	zi",
		"一分为二", "	yi1	fen1	wei2	er4",
		"椎髻布衣", "	zhui1	ji4	bu4	yi1",
		"朝斯夕斯", "	zhao1	si1	xi1	si1",
		"苞苴竿牍", "	bao1	ju1	gan1	du2",
		"尽力而为", "	jin4	li4	er2	wei2",
		"积日累月", "	ji1	ri4	lei3	yue4",
		"皮包骨头", "	pi2	bao1	gu2	tou",
		"鼻口部分", "	bi2	kou3	bu4	fen4",
		"目空余子", "	mu4	kong1	yu2	zi3",
		"指头肚儿", "	zhi3	tou	du4	er",
		"青紫被体", "	qing1	zi3	pi1	ti3",
		"属辞比事", "	zhu3	ci2	bi3	shi4",
		"不差毫发", "	bu4	cha1	hao2	fa4",
		"避祸求福", "	bi4	huo4	qiu2	fu4",
		"至矣尽矣", "	zhi4	yi3	jin4	yi3",
		"余勇可贾", "	yu2	yong3	ke3	gu3",
		"史蒂文斯", "	shi3	di4	wen2	si1",
		"积德累仁", "	ji1	de2	lei3	ren2",
		"朱干玉戚", "	zhu1	gan1	yu4	qi1",
		"宁死不屈", "	ning4	si3	bu4	qu1",
		"母慈子孝", "	mu3	ci2	zi3	xiao4",
		"下不为例", "	xia4	bu4	wei2	li4",
		"黑芝麻糊", "	hei1	zhi1	ma	hu2",
		"好问则裕", "	hao4	wen4	ze2	yu4",
		"属毛离里", "	zhu3	mao2	li2	li3",
		"吆五喝六", "	yao1	wu3	he4	liu4",
		"厚味腊毒", "	hou4	wei4	xi1	du2",
		"卑礼厚币", "	bei1	li3	hou4	bi4",
		"好善恶恶", "	hao3	shan4	wu4	e4",
		"不识起倒", "	bu4	shi2	qi3	dao3",
		"气动葫芦", "	qi4	dong4	hu2	lu",
		"激进分子", "	ji1	jin4	fen4	zi3",
		"皮诺切特", "	pi2	nuo4	qie1	te4",
		"不以为耻", "	bu4	yi3	wei2	chi3",
		"呱嗒板儿", "	gua1	da1	ban3	er2",
		"宏都拉斯", "	hong2	du1	la1	si1",
		"骑驴倒堕", "	qi2	lv2	dao3	duo4",
		"积日累岁", "	ji1	ri4	lei3	sui4",
		"虎珀拾芥", "	hu3	po4	shi2	jie4",
		"插入因子", "	cha1	ru4	yin1	zi3",
		"惠子知我", "	hui4	zi3	zhi1	wo3",
		"如花似朵", "	ru2	hua1	si4	duo3",
		"一意孤行", "	yi1	yi4	gu1	xing2",
		"何所不为", "	he2	suo3	bu4	wei2",
		"豁然大悟", "	huo4	ran2	da4	wu4",
		"八大胡同", "	ba1	da4	hu2	tong4",
		"号啕大哭", "	hao2	tao2	da4	ku1",
		"自以为然", "	zi4	yi3	wei2	ran2",
		"没人味儿", "	mei2	ren2	wei4	r",
		"贝克勒尔", "	bei4	ke4	le4	er3",
		"村夫俗子", "	cun1	fu1	su2	zi3",
		"默而识之", "	mo4	er2	zhi4	zhi1",
		"德勒巴克", "	de2	le4	ba1	ke4",
		"吧唧吧唧", "	ba1	ji	ba1	ji",
		"第一义谛", "	di4	yi1	yi4	di4",
		"嘀里嘟噜", "	di1	li3	du1	lu1",
		"滴滴答答", "	di1	di1	da1	da1",
		"乐乐呵呵", "	le4	le4	he1	he1",
		"蹀儿鸭子", "	die2	r	ya1	zi",
		"忍饥挨饿", "	ren3	ji1	ai2	e4",
		"遗妻弃子", "	yi2	qi1	qi4	zi3",
		"七子八婿", "	qi1	zi3	ba1	xu4",
		"百色起义", "	bo2	se4	qi3	yi4",
		"迪斯科吧", "	di2	si1	ke1	ba1",
		"不易一字", "	bu4	yi4	yi1	zi4",
		"迷离马虎", "	mi2	li2	ma3	hu",
		"迷迷糊糊", "	mi2	mi	hu1	hu1",
		"马路牙子", "	ma3	lu4	ya2	zi3",
		"扎尔达里", "	za1	er3	da2	li3",
		"阿多尼斯", "	a	duo1	ni2	si1",
		"扎鲁特旗", "	za1	lu3	te4	qi2",
		"提拉米苏", "	di1	la1	mi3	su1",
		"古希腊语", "	gu3	xi1	la4	yu3",
		"阿弥陀佛", "	e1	mi2	tuo2	fo2",
		"孤立子波", "	gu1	li4	zi3	bo1",
		"格格不吐", "	ge1	ge1	bu4	tu3",
		"格格不纳", "	ge1	ge1	bu4	na4",
		"子女玉帛", "	zi3	nv3	yu4	bo2",
		"法不阿贵", "	fa3	bu4	e1	gui4",
		"一古脑儿", "	yi1	gu3	nao3	r",
		"茶叶末儿", "	cha2	ye4	mo4	r",
		"计日而俟", "	ji4	ri4	er2	si4",
		"一字不易", "	yi1	zi4	bu4	yi4",
		"糊糊涂涂", "	hu1	hu1	tu2	tu2",
		"哩哩啦啦", "	li	li	la1	la1",
		"的黎波里", "	di4	li2	bo1	li3",
		"莫扎里拉", "	mo4	za1	li3	la1",
		"那不勒斯", "	na4	bu4	le4	si1",
		"那曲地区", "	na4	qu3	di4	qu1",
		"哪儿的话", "	na3	r	de	hua4",
		"嗳气呕逆", "	ai4	qi4	ou3	ni4",
		"劈里啪啦", "	pi1	li	pa1	la1",
		"可歌可泣", "	ke3	ge1	ke3	qi4",
		"阿富汗语", "	a	fu4	han4	yu3",
		"阿得莱德", "	a	de2	lai2	de2",
		"第比利斯", "	di4	bi4	li4	si1",
		"叽哩咕噜", "	ji1	li	gu1	lu1",
		"阿尔泰语", "	a	er3	tai4	yu3",
		"阿尔瓦雷", "	a	er3	wa3	lei2",
		"阿尔盖达", "	a	er3	gai4	da2",
		"勒斯波斯", "	le4	si1	bo1	si1",
		"头儿脑儿", "	tou2	r	nao3	r",
		"墨子泣丝", "	mo4	zi3	qi4	si1",
		"马路沿儿", "	ma3	lu4	yan2	r",
		"目无余子", "	mu4	wu2	yu2	zi3",
		"霹雳啪啦", "	pi1	li4	pa1	la1",
		"卡拉季奇", "	ka3	la1	ji4	ji1",
		"模模糊糊", "	mo2	mo2	hu	hu1",
		"彼得格勒", "	bi3	de2	ge2	le4",
		"克拉科夫", "	ke4	la1	ke1	fu1",
		"克孜勒苏", "	ke4	zi1	le4	su1",
		"薄物细故", "	bo2	wu4	xi4	gu4",
		"噼里啪啦", "	pi1	li3	pa1	la1",
		"弥勒菩萨", "	mi2	le4	pu2	sa4",
		"认死理儿", "	ren4	si3	li3	r",
		"卡拉奇那", "	ka3	la1	ji1	na4",
		"阿尔卑斯", "	a	er3	bei1	si1",
		"阿德莱德", "	a	de2	lai2	de2",
		"阿美尼亚", "	a	mei3	ni2	ya4",
		"阿德雷德", "	a	de2	lei2	de2",
		"阿加迪尔", "	a	jia1	di2	er3",
		"阿利坎特", "	a	li4	kan3	te4",
		"阿伦达尔", "	a	lun2	da2	er3",
		"阿克伦河", "	a	ke4	lun2	he2",
		"阿克苏市", "	a	ke4	su1	shi4",
		"阿拉伯文", "	a	la1	bo2	wen2",
		"阿摩司书", "	a	mo2	si1	shu1",
		"阿美恩斯", "	a	mei3	en1	si1",
		"卡波耶拉", "	ka3	bo1	ye1	la1",
		"喀啦喀啦", "	ka1	la1	ka1	la1",
		"阿金库尔", "	a	jin1	ku4	er3",
		"阿拉尔市", "	a	la1	er3	shi4",
		"阿特金斯", "	a	te4	jin1	si1",
		"批哩啪啦", "	pi1	li	pa1	la",
		"鸡蛋壳儿", "	ji1	dan4	ke2	r",
		"卡尔扎伊", "	ka3	er3	za1	yi1",
		"阿普尔顿", "	a	pu3	er3	dun4",
		"疙疙瘩瘩", "	ge1	ge1	da1	da2",
		"粒子物理", "	li4	zi3	wu4	li3",
		"闭目塞耳", "	bi4	mu4	se4	er3",
		"阿拉法特", "	a	la1	fa3	te4",
		"阿尔卡特", "	a	er3	ka3	te4",
		"阿里巴巴", "	a	li3	ba1	ba1",
		"阿耳戈斯", "	a	er3	ge1	si1",
		"阿瓦里德", "	a	wa3	li3	de2",
		"阿穆尔河", "	a	mu4	er3	he2",
		"阿斯马拉", "	a	si1	ma3	la1",
		"阿斯塔纳", "	a	si1	ta3	na4",
		"阿丽亚娜", "	a	li4	ya4	na4",
		"打哈哈儿", "	da3	ha1	ha	r",
		"阿尔伯特", "	a	er3	bo2	te4",
		"阿拉巴马", "	a	la1	ba1	ma3",
		"阿拉塔斯", "	a	la1	ta3	si1",
		"阿拉米语", "	a	la1	mi3	yu3",
		"阿斯伯格", "	a	si1	bo2	ge2",
		"阿格尼迪", "	a	ge2	ni2	di2",
		"无恶不为", "	wu2	e4	bu4	wei2",
		"可泣可歌", "	ke3	qi4	ke3	ge1",
		"呵佛骂祖", "	he1	fo2	ma4	zu3",
		"阿尔萨斯", "	a	er3	sa4	si1",
		"阿尔伯塔", "	a	er3	bo2	ta3",
		"与物无忤", "	yu3	wu4	wu2	wu3",
		"阿奇里斯", "	a	qi2	li3	si1",
		"阿瓦鲁阿", "	a	wa3	lu3	a1",
		"苦不唧儿", "	ku3	bu	ji1	r",
		"阿兹特克", "	a	zi1	te4	ke4",
		"不大离儿", "	bu4	da4	li2	r",
		"挨饥抵饿", "	ai2	ji1	di3	e4",
		"阿卡迪亚", "	a	ka3	di2	ya4",
		"厄勒布鲁", "	e	le4	bu4	lu3",
		"阿卜杜拉", "	a	bu3	du4	la1",
		"阿布哈兹", "	a	bu4	ha1	zi1",
		"阿里地区", "	a	li3	di4	qu1",
		"阿布扎比", "	a	bu4	za1	bi3",
		"阿布达比", "	a	bu4	da2	bi3",
		"阿姆哈拉", "	a	mu3	ha1	la1",
		"纳德阿里", "	na4	de2	a	li3",
		"双重标准", "	shuang1	chong2	biao1	zhun3",
		"阿克苏河", "	a	ke4	su1	he2",
		"阿迪达斯", "	a	di2	da2	si1",
		"阿达比尔", "	a	da2	bi3	er3",
		"阿时趋俗", "	e1	shi2	qu1	su2",
		"如饥似渴", "	ru2	ji1	si4	ke3",
		"计日以俟", "	ji4	ri4	yi3	si4",
		"巴克科思", "	ba1	ke4	ke1	si1",
		"差不离儿", "	cha4	bu4	li2	r",
		"呼不给吸", "	hu1	bu4	ji3	xi1",
		"击其不意", "	ji1	qi2	bu4	yi4",
		"鸡皮鹤发", "	ji1	pi2	he4	fa4",
		"大麻哈鱼", "	da4	ma2	ha3	yu2",
		"耶稣基督", "	ye1	su1	ji1	du1",
		"叽叽哇哇", "	ji1	ji1	wa1	wa1",
		"胳臂箍儿", "	ge1	bei	gu1	r",
		"自给自足", "	zi4	ji3	zi4	zu2",
		"格拉斯哥", "	ge2	la1	si1	ge1",
		"巴耶利巴", "	ba1	ye1	li4	ba1",
		"巴尔的摩", "	ba1	er3	di4	mo2",
		"一笔抹摋", "	yi1	bi3	mo4	sa4",
		"负固不服", "	fu4	gu4	bu4	fu2",
		"一大早儿", "	yi1	da4	zao3	r",
		"耶哥尼雅", "	ye1	ge1	ni2	ya3",
		"欲取姑与", "	yu4	qu3	gu1	yu3",
		"一口气儿", "	yi1	kou3	qi4	r",
		"以利亚撒", "	yi3	li4	ya4	sa3",
		"希腊字母", "	xi1	la4	zi4	mu3",
		"一语破的", "	yi1	yu3	po4	di4",
		"福斯塔夫", "	fu2	si1	ta3	fu1",
		"密密麻麻", "	mi4	mi4	ma1	mɑ",
		"鹤发鸡皮", "	he4	fa4	ji1	pi2",
		"萨格勒布", "	sa4	ge2	le4	bu4",
		"乌尔都语", "	wu1	er3	du1	yu3",
		"握发吐哺", "	wo4	fa4	tu3	bu3",
		"无以塞责", "	wu2	yi3	se4	ze2",
		"乌衣子弟", "	wu1	yi1	zi3	di4",
		"呜呜咽咽", "	wu1	wu1	ye4	ye4",
		"科纳克里", "	ke1	na4	ke4	li3",
		"不起眼儿", "	bu4	qi3	yan3	r",
		"傻大个儿", "	sha3	da4	ge4	r",
		"诃佛诋巫", "	he1	fo2	di3	wu1",
		"科迪勒拉", "	ke1	di2	le4	la1",
		"余子碌碌", "	yu2	zi3	lu4	lu4",
		"饿虎之蹊", "	e4	hu3	zhi1	xi1",
		"父析子荷", "	fu4	xi1	zi3	he2",
		"一发破的", "	yi1	fa1	po4	di4",
		"依撒意亚", "	yi1	sa1	yi4	ya4",
		"塔塔儿人", "	ta3	ta3	r	ren2",
		"不可移易", "	bu4	ke3	yi2	yi4",
		"敷衍塞责", "	fu1	yan3	se4	ze2",
		"阿育吠陀", "	a	yu4	fei4	tuo2",
		"三臡八菹", "	san1	ni2	ba1	zu1",
		"喀喇沁旗", "	ka1	la1	qin4	qi2",
		"阿瓦提县", "	a	wa3	ti2	xian4",
		"色厉胆薄", "	se4	li4	dan3	bo2",
		"打击乐器", "	da3	ji1	yue4	qi4",
		"克什米尔", "	ke4	shi2	mi3	er3",
		"只字不提", "	zhi1	zi4	bu4	ti2",
		"刻木为鹄", "	ke4	mu4	wei2	hu2",
		"喀什地区", "	ka1	shi2	di4	qu1",
		"小媳妇儿", "	xiao3	xi2	fu	r",
		"喀什噶尔", "	ka1	shi2	ga2	er3",
		"刻木为吏", "	ke4	mu4	wei2	li4",
		"刻足适屦", "	ke4	zu2	shi4	ju4",
		"集体宿舍", "	ji2	ti3	su4	she4",
		"无地自处", "	wu2	di4	zi4	chu3",
		"泥古不化", "	ni4	gu3	bu4	hua4",
		"奥西娜斯", "	ao4	xi1	nuo2	si1",
		"支吾其词", "	zhi1	wu1	qi2	ci2",
		"除恶务尽", "	chu2	e4	wu4	jin4",
		"如花似玉", "	ru2	hua1	si4	yu4",
		"胳膊腕子", "	ge1	bo	wan4	zi3",
		"毒泷恶雾", "	du2	long2	e4	wu4",
		"阿尔衮琴", "	a	er3	gun3	qin2",
		"克莱斯勒", "	ke4	lai2	si1	le4",
		"阿图什市", "	a	tu2	shi2	shi4",
		"刻薄寡思", "	ke4	bo2	gua3	si1",
		"鹘入鸦群", "	hu2	ru4	ya1	qun2",
		"靡颜腻理", "	mi3	yan2	ni4	li3",
		"入土为安", "	ru4	tu2	wei2	an1",
		"磁单极子", "	ci2	dan1	ji2	zi3",
		"蠹居棋处", "	du4	ju1	qi2	chu3",
		"赍志而没", "	ji1	zhi4	er2	mo4",
		"日居月诸", "	ri4	ji1	yue4	zh",
		"糊涂一时", "	hu2	tu	yi1	shi2",
		"入不敷出", "	ru4	bu4	fu1	chu1",
		"阿合奇县", "	a	he2	qi2	xian4",
		"阿尔都塞", "	a	er3	dou1	sai1",
		"看得过儿", "	kan4	de	guo4	r",
		"阿非利加", "	a	fei1	li4	jia1",
		"即心即佛", "	ji2	xin1	ji2	fo2",
		"高足弟子", "	gao1	zu2	di4	zi3",
		"一仆二主", "	yi1	pu2	er4	zhu3",
		"目不暇给", "	mu4	bu4	xia2	ji3",
		"厚此薄彼", "	hou4	ci3	bo2	bi3",
		"科尼赛克", "	ke1	ni2	sai4	ke4",
		"居礼夫人", "	ju1	li3	fu1	ren",
		"日不暇给", "	ri4	bu4	xia2	ji3",
		"画虎刻鹄", "	hua4	hu3	ke4	hu2",
		"阿克赛钦", "	a	ke4	sai4	qin1",
		"阿其所好", "	e1	qi2	suo3	hao4",
		"螺丝起子", "	luo2	si1	qi3	zi3",
		"阿勒泰市", "	a	le4	tai4	shi4",
		"厚积薄发", "	hou4	ji1	bo2	fa1",
		"敌特分子", "	di2	te4	fen4	zi3",
		"握发吐飧", "	wo4	fa4	tu3	sun1",
		"吁咈都俞", "	yu4	fu2	dou1	yu2",
		"积极分子", "	ji1	ji2	fen4	zi3",
		"稀里哗啦", "	xi1	li3	hua1	la1",
		"诘屈聱牙", "	jie2	qu1	ao2	ya2",
		"予取予夺", "	yu2	qu3	yu2	duo2",
		"予取予求", "	yu2	qu3	yu2	qiu2",
		"予取予携", "	yu2	qu3	yu2	xie2",
		"厄勒海峡", "	e	le4	hai3	xia2",
		"泰西大儒", "	tai4	xi1	da4	ru2",
		"膏腴子弟", "	gao1	yu2	zi3	di4",
		"包袱底儿", "	bao1	fu2	di3	er2",
		"梅妻鹤子", "	mei2	qi1	he4	zi3",
		"呼卢喝雉", "	hu1	lu2	he4	zhi4",
		"我黼子佩", "	wo3	fu3	zi3	pei4",
		"我负子戴", "	wo3	fu4	zi3	dai4",
		"不足为虑", "	bu4	zu2	wei2	lv4",
		"高歌一曲", "	gao1	ge1	yi1	qu3",
		"虚与委蛇", "	xu1	yu3	wei1	yi2",
		"胡子拉碴", "	hu2	zi3	la1	cha1",
		"毛发丝粟", "	mao2	fa4	si1	su4",
		"秘鲁苦蘵", "	bi4	lu3	ku3	zhi2",
		"第二个人", "	di4	er4	ge	ren2",
		"热毛子马", "	re4	mao2	zi3	ma3",
		"懒得搭理", "	lan3	de	da1	li3",
		"群雌粥粥", "	qun2	ci2	yu4	yu4",
		"扎格罗斯", "	za1	ge2	luo2	si1",
		"人莫予毒", "	ren2	mo4	yu2	du2",
		"故家子弟", "	gu4	jia1	zi3	di4",
		"居里夫人", "	ju1	li3	fu1	ren",
		"模糊逻辑", "	mo2	hu	luo2	ji",
		"遭遇不偶", "	zao1	yu4	bu4	ou3",
		"塞拉耶佛", "	se4	la1	ye1	fo2",
		"结发夫妻", "	jie2	fa4	fu1	qi1",
		"曲突移薪", "	qu3	tu1	yi2	xin1",
		"叽里呱啦", "	ji1	li3	gua1	la1",
		"以苦为乐", "	yi3	ku3	wei2	le4",
		"铆足劲儿", "	mao3	zu2	jin4	r",
		"以蠡测海", "	yi3	li3	ce4	hai3",
		"失而复得", "	shi1	er2	fu4	de",
		"绕弯子儿", "	rao4	wan1	zi3	r",
		"以鹿为马", "	yi3	lu4	wei2	ma3",
		"时移俗易", "	shi2	yi2	su2	yi4",
		"纨绔子弟", "	wan2	ku4	zi3	di4",
		"核子医学", "	he2	zi3	yi1	xue2",
		"母以子贵", "	mu3	yi3	zi3	gui4",
		"马拉喀什", "	ma3	la1	ka1	shi2",
		"扞格不入", "	han4	ge2	bu4	ru4",
		"绿林起义", "	lu4	lin2	qi3	yi4",
		"碌碌无为", "	lu4	lu4	wu2	wei2",
		"狗玩儿的", "	gou3	wan2	r	de",
		"不可分割", "	bu4	ke3	fen1	ge1",
		"勒维纳斯", "	le4	wei2	na4	si1",
		"博物君子", "	bo2	wu4	jun1	zi3",
		"撒马尔罕", "	sa3	ma3	er3	han3",
		"过河卒子", "	guo4	he2	zu2	zi3",
		"哇哩哇啦", "	wa1	li3	wa1	la1",
		"吐哺握发", "	tu3	bu3	wo4	fa4",
		"除恶务本", "	chu2	e4	wu4	ben3",
		"曲不离口", "	qu3	bu4	li2	kou3",
		"卖妻鬻子", "	mai4	qi1	yu4	zi3",
		"不计其数", "	bu4	ji4	qi2	shu4",
		"参差不齐", "	cen1	ci1	bu4	qi2",
		"勒哈费尔", "	le4	ha1	fei4	er3",
		"异议分子", "	yi4	yi4	fen4	zi3",
		"妻离子散", "	qi1	li2	zi3	san4",
		"不拔一毛", "	bu4	ba2	yi4	mao2",
		"去本趋末", "	qu4	ben3	qu1	mo4",
		"吱哩哇啦", "	zhi1	li1	wa1	la1",
		"纨裤子弟", "	wan2	ku4	zi3	di4",
		"亚麻子油", "	ya4	ma2	zi3	you2",
		"皈依佛法", "	gui1	yi1	fo2	fa3",
		"积露为波", "	ji1	lu4	wei2	bo1",
		"曲学阿世", "	qu3	xue2	a1	shi4",
		"撒马尔干", "	sa3	ma3	er3	gan4",
		"依阿取容", "	yi1	e1	qu3	rong2",
		"压压脚儿", "	ya1	ya	jiao3	r",
		"爱民如子", "	ai4	min2	ru2	zi3",
		"徒子徒孙", "	tu2	zi3	tu2	sun1",
		"兔起鹘落", "	tu4	qi3	hu2	luo4",
		"以斯帖记", "	yi3	si1	tie3	ji4",
		"误人子弟", "	wu4	ren2	zi3	di4",
		"格子花呢", "	ge2	zi	hua1	ni2",
		"姿态婀娜", "	zi1	tai4	e1	nuo2",
		"格洛斯特", "	ge2	luo4	si1	te4",
		"格洛纳斯", "	ge2	luo4	na4	si1",
		"慕古薄今", "	mu4	gu3	bo2	jin1",
		"铁哥们儿", "	tie3	ge1	men	r",
		"拭目以俟", "	shi4	mu4	yi3	si4",
		"不足为奇", "	bu4	zu2	wei2	qi2",
		"洗发水儿", "	xi3	fa4	shui3	r",
		"为法自弊", "	wei2	fa3	zi4	bi4",
		"法尔卡什", "	fa3	er3	ka3	shi2",
		"喜不自禁", "	xi3	bu4	zi4	jin1",
		"阿尔加维", "	a	er3	jia1	wei2",
		"擘肌分理", "	bo4	ji1	fen1	li3",
		"疾不可为", "	ji2	bu4	ke3	wei2",
		"易子而食", "	yi4	zi3	er2	shi2",
		"以耳为目", "	yi3	er3	wei2	mu4",
		"塞浦路斯", "	sai4	pu3	lu4	si1",
		"拿印把儿", "	na2	yin4	ba4	er",
		"服务态度", "	fu2	wu4	tai4	du",
		"狐狸尾巴", "	hu2	li	wei3	ba",
		"易卜拉辛", "	yi4	bu3	la1	xin1",
		"罗马尼亚", "	luo1	ma3	ni2	ya4",
		"木骨都束", "	mu4	gu3	du1	shu4",
		"一呵而就", "	yi1	he1	er2	jiu4",
		"细细地流", "	xi4	xi4	de	liu2",
		"不对劲儿", "	bu4	dui4	jin4	r",
		"闭门塞户", "	bi4	kou3	se4	hu4",
		"词不逮意", "	ci2	bu4	dai4	yi4",
		"词不逮理", "	ci2	bu4	dai4	li3",
		"干戈四起", "	gan1	ge1	si4	qi3",
		"至死靡它", "	zhi4	si3	mi3	ta1",
		"不对碴儿", "	bu4	dui4	cha2	r",
		"认死扣儿", "	ren4	si3	kou4	r",
		"唏哩哗啦", "	xi1	li1	hua1	la1",
		"六枝特区", "	lu4	zhi1	te4	qu1",
		"不知起倒", "	bu4	zhi1	qi3	dao3",
		"不禁不由", "	bu4	jin1	bu4	you2",
		"一发千钧", "	yi1	fa4	qian1	jun1",
		"引以为憾", "	yin3	yi3	wei2	han4",
		"几乎完全", "	ji1	hu1	wan2	quan2",
		"分子杂交", "	fen1	zi3	za2	jiao1",
		"含情脉脉", "	han2	qing2	mo4	mo4",
		"氧乙炔炬", "	yang3	yi3	que1	ju4",
		"偏差距离", "	pian1	cha1	ju4	li2",
		"书不尽言", "	shu1	bu4	jin4	yan2",
		"塞韦里诺", "	sai4	wei2	li3	nuo4",
		"一呼百应", "	yi1	hu1	bai3	ying4",
		"弹射座椅", "	tan2	she4	zuo4	yi3",
		"含糊不清", "	han2	hu	bu4	qing1",
		"夙兴夜寐", "	su4	xing1	ye4	mei4",
		"一吐为快", "	yi1	tu3	wei2	kuai4",
		"孤家寡人", "	gu1	jia1	gua3	ren2",
		"有好奇心", "	you3	hao4	qi2	xin1",
		"有子存焉", "	you3	zi3	cun2	yan1",
		"有朝一日", "	you3	zhao1	yi1	ri4",
		"全军覆没", "	quan2	jun1	fu4	mo4",
		"朝露溘至", "	zhao1	lu4	ke4	zhi4",
		"大动干戈", "	da4	dong4	gan1	ge1",
		"数理逻辑", "	shu4	li3	luo2	ji",
		"有头无尾", "	you3	tou2	wu2	wei3",
		"乌踆兔走", "	wu1	cun2	tu4	zou3",
		"神不附体", "	shen2	bu4	fu4	ti3",
		"信而好古", "	xin4	er2	hao4	gu3",
		"恫疑虚猲", "	dong4	yi2	xu1	ge2",
		"恫疑虚喝", "	dong4	yi2	xu1	he4",
		"干云蔽日", "	gan1	yun2	bi4	ri4",
		"公子哥儿", "	gong1	zi3	ge1	er2",
		"处理办法", "	chu3	li3	ban4	fa3",
		"嗓子眼儿", "	sang3	zi	yan3	r",
		"跑堂儿的", "	pao3	tang2	r	de",
		"瞰瑕伺隙", "	kan4	xia2	si4	xi4",
		"离本徼末", "	li2	ben3	yao1	mo4",
		"出处语默", "	chu1	chu3	yu3	mo4",
		"刚直不阿", "	gang1	zhi2	bu4	e1",
		"身体发肤", "	shen1	ti3	fa4	fu1",
		"亚塞拜然", "	ya4	se4	bai4	ran2",
		"丑类恶物", "	chou3	lei4	e4	wu4",
		"节骨眼儿", "	jie1	gu	yan3	er",
		"五尺竖子", "	wu3	chi3	shu4	zi3",
		"一劳永逸", "	yi1	lao2	yong3	yi4",
		"张掖地区", "	zhang1	ye4	di4	qu1",
		"出奇划策", "	chu1	qi2	hua2	ce4",
		"孙子兵法", "	sun1	zi3	bing1	fa3",
		"彼唱此和", "	bi3	chang4	ci3	he4",
		"彬彬君子", "	bin1	bin1	jun1	zi3",
		"一小阵儿", "	yi1	xiao3	zhen4	r",
		"值得品味", "	zhi2	de	pin3	wei4",
		"一小部分", "	yi1	xiao3	bu4	fen4",
		"广安地区", "	guang3	an1	di4	qu1",
		"沉不住气", "	chen2	bu2	zhu4	qi4",
		"沉得住气", "	chen2	de	zhu4	qi4",
		"多劳多得", "	duo1	lao2	duo1	de",
		"往心里去", "	wang3	xin1	li	qu4",
		"沐猴而冠", "	mu4	hou2	er2	guan4",
		"木管乐器", "	mu4	guan3	yue4	qi4",
		"会计制度", "	kuai4	ji4	zhi4	du4",
		"值得信赖", "	zhi2	de	xin4	lai4",
		"分而治之", "	fen1	er2	zhi4	zhi1",
		"柔情脉脉", "	rou2	qing2	mo4	mo4",
		"人尽其才", "	ren2	jin4	qi2	cai2",
		"不为酒困", "	bu4	wei2	jiu3	kun4",
		"凸面部分", "	tu1	mian4	bu4	fen4",
		"借方差额", "	jie4	fang1	cha1	e2",
		"孑孑为义", "	jie2	jie2	wei2	yi4",
		"和记黄埔", "	he2	ji4	huang2	pu3",
		"挑三窝四", "	tiao3	san1	wo1	si4",
		"咬舌自尽", "	yao3	she2	zi4	jin4",
		"一干二净", "	yi1	gan1	er4	jing4",
		"孔子家语", "	kong3	zi3	jia1	yu3",
		"克什克腾", "	ke4	shi2	ke4	teng2",
		"压轴好戏", "	ya1	zhou4	hao3	xi4",
		"朝三暮四", "	zhao1	san1	mu4	si4",
		"没齿不忘", "	mo4	chi3	bu4	wang4",
		"安步当车", "	an1	bu4	dang4	che1",
		"厦门大学", "	xia4	men2	da4	xue2",
		"一唱一和", "	yi1	chang4	yi1	he4",
		"安分守己", "	an1	fen4	shou3	ji3",
		"倒背手儿", "	dao4	bei4	shou3	r",
		"曾外祖母", "	zeng1	wai4	zu3	mu3",
		"曾外祖父", "	zeng1	wai4	zu3	fu4",
		"水磨沟区", "	shui3	mo4	gou1	qu1",
		"多那太罗", "	duo1	na3	tai4	luo2",
		"往泥里踩", "	wang3	ni4	li3	cai3",
		"言不尽意", "	yan2	bu4	jin4	yi4",
		"梨俱吠陀", "	li2	ju1	fei4	tuo2",
		"新式拚法", "	xin1	shi4	pin1	fa3",
		"感激不尽", "	gan3	ji1	bu4	jin4",
		"落魄不偶", "	luo	tuo	bu	ou",
		"新斯科舍", "	xin1	si1	ke1	she4",
		"动嘴皮儿", "	dong4	zui3	pi2	r",
		"精子密度", "	jing1	zi3	mi4	du4",
		"应付自如", "	ying4	fu4	zi4	ru2",
		"右翼分子", "	you4	yi4	fen1	zi3",
		"扎欧扎翁", "	za1	ou1	za1	weng1",
		"扎马鲁丁", "	za1	ma3	lu3	ding1",
		"德薄才疏", "	de2	bo2	cai2	shu1",
		"落拓不羁", "	luo4	tuo4	bu4	ji1",
		"爱丽思泉", "	ai4	li2	si1	quan2",
		"丢卒保车", "	diu1	zu2	bao3	ju1",
		"结结巴巴", "	jie1	jie1	ba1	ba1",
		"日积月累", "	ri4	ji1	yue4	lei3",
		"干戈载戢", "	gan4	ge1	zai3	ji2",
		"绝大部分", "	jue2	da4	bu4	fen",
		"络腮胡子", "	luo4	sai1	hu2	zi3",
		"依样葫芦", "	yi1	yang4	hu2	lu",
		"糖醋里脊", "	tang2	cu4	li3	ji3",
		"逻辑思维", "	luo2	ji	si1	wei2",
		"锡林郭勒", "	xi1	lin2	guo1	le4",
		"纽几内亚", "	niu3	ji1	nei4	ya4",
		"分离分子", "	fen1	li2	fen4	zi3",
		"没金饮羽", "	mo4	jin1	yin3	yu3",
		"数以万计", "	shu3	yi3	wan4	ji4",
		"引以为傲", "	yin3	yi3	wei2	ao4",
		"纶音佛语", "	lun2	yin1	fo2	yu3",
		"东抹西涂", "	dong1	mo4	xi1	tu2",
		"纳什维尔", "	na4	shi2	wei2	er3",
		"弹拨乐器", "	tan2	bo1	yue4	qi4",
		"实逼处此", "	shi2	bi1	chu3	ci3",
		"引喻失义", "	yin3	yu4	shi1	yi4",
		"人给家足", "	ren2	ji3	jia1	zu2",
		"心里踏实", "	xin1	li	ta1	shi",
		"五侯蜡烛", "	wu3	hou4	la4	zhu2",
		"纳粹分子", "	na4	cui4	fen4	zi3",
		"素食主义", "	su4	shi2	zhu3	yi4",
		"人才济济", "	ren2	cai2	ji3	ji3",
		"应付裕如", "	ying4	fu4	yu4	ru2",
		"处心积虑", "	chu3	xin1	ji1	lv4",
		"视民如子", "	shi4	min2	ru2	zi3",
		"推枯折腐", "	tui1	ku1	she2	fu3",
		"奥维耶多", "	ao4	wei2	ye1	duo1",
		"二道贩子", "	er4	dao4	fan4	zi3",
		"等一会儿", "	deng3	yi1	hui4	r",
		"等一下儿", "	deng3	yi1	xia4	r",
		"为民父母", "	wei2	min2	fu4	mu3",
		"恶不去善", "	wu4	bu4	qu4	shan4",
		"膏车秣马", "	gao4	che1	mo4	ma3",
		"奥切诺斯", "	ao4	qie1	nuo4	si1",
		"高义薄云", "	gao1	yi4	bo2	yun2",
		"个别差异", "	ge4	bie2	cha1	yi4",
		"分析处理", "	fen1	xi1	chu3	li3",
		"等离子体", "	deng3	li2	zi3	ti3",
		"二十八宿", "	er4	shi2	ba1	xiu4",
		"唐突西子", "	tang2	tu1	xi1	zi3",
		"悬崖勒马", "	xuan2	ya2	le4	ma3",
		"泪眼模糊", "	lei4	yan3	mo2	hu",
		"森海塞尔", "	sen1	hai3	se4	er3",
		"有机分子", "	you3	ji1	fen1	zi3",
		"蜜月假期", "	mi4	yue4	jia4	qi1",
		"累土聚沙", "	lei3	tu3	ju4	sha1",
		"梨园子弟", "	li2	yuan2	zi3	di4",
		"筋疲力尽", "	jin1	pi2	li4	jin4",
		"以意为之", "	yi3	yi4	wei2	zhi1",
		"会计科目", "	kuai4	ji4	ke1	mu4",
		"扎马剌丁", "	za1	ma3	la2	ding1",
		"无理要求", "	wu2	li3	yao1	qiu2",
		"细胞因子", "	xi4	bao1	yin1	zi3",
		"细磨刀石", "	xi4	mo4	dao1	shi2",
		"因敌为资", "	yin1	di2	wei2	zi1",
		"恶居下流", "	wu4	ju1	xia4	liu2",
		"犁牛之子", "	li2	niu2	zhi1	zi3",
		"无尽无休", "	wu2	jin4	wu2	xiu1",
		"无间可伺", "	wu2	jian1	ke3	si4",
		"高干子弟", "	gao1	gan4	zi3	di4",
		"无后为大", "	wu2	hou4	wei2	da4",
		"具体地说", "	ju4	ti3	de	shuo1",
		"五侯七贵", "	wu3	hou4	qi1	gui4",
		"力尽筋疲", "	li4	jin4	jin1	pi2",
		"淫词艳曲", "	yin2	ci2	yan4	qu3",
		"曲高和寡", "	qu3	gao1	he4	gua3",
		"五斗米道", "	wu3	dou3	mi3	dao4",
		"数据处理", "	shu4	ju4	chu3	li3",
		"嘉柏隆里", "	jia1	bo2	long2	li3",
		"参差错落", "	cen1	ci1	cuo4	luo4",
		"家给民足", "	jia1	ji3	min2	zu2",
		"各有所好", "	ge4	you3	suo3	hao4",
		"松巴哇岛", "	song1	ba1	wa1	dao3",
		"一盘散沙", "	yi1	pan2	san3	sha1",
		"一目了然", "	yi1	mu4	liao3	ran2",
		"一目十行", "	yi1	mu4	shi2	hang2",
		"一网打尽", "	yi1	wang3	da3	jin4",
		"忍俊不禁", "	ren3	jun4	bu4	jin1",
		"国际关系", "	guo2	ji4	guan1	xi4",
		"拨弦乐器", "	bo1	xian2	yue4	qi4",
		"佛口蛇心", "	fo2	kou3	she2	xin1",
		"俄勒冈州", "	e	le4	gang1	zhou1",
		"悲歌当哭", "	bei1	ge1	dang4	ku1",
		"情不自禁", "	qing2	bu4	zi4	jin1",
		"嗳腐吞酸", "	ai4	fu3	tun1	suan1",
		"哩溜歪斜", "	li	liu1	wai1	xie2",
		"伽马射线", "	ga1	ma3	she4	xian4",
		"不可估量", "	bu4	ke3	gu1	liang",
		"失败主义", "	shi1	bai4	zhu3	yi4",
		"伸缩喇叭", "	shen1	suo1	la3	ba",
		"子弹火车", "	zi3	dan4	huo3	che1",
		"带电粒子", "	dai4	dian4	li4	zi3",
		"可数名词", "	ke3	shu3	ming2	ci2",
		"倒戈卸甲", "	dao3	ge1	xie4	jia3",
		"剃发留辫", "	ti4	fa4	liu2	bian4",
		"拉开架势", "	la1	kai1	jia4	shi",
		"天雨路滑", "	tian1	yu4	lu4	hua2",
		"前途未卜", "	qian2	tu2	wei4	bu3",
		"子宫肌瘤", "	zi3	gong1	ji1	liu2",
		"殒身不恤", "	yun3	shen1	bu2	xu4",
		"侯门似海", "	hou2	men2	si4	hai3",
		"列别杰夫", "	lie4	bie4	jie2	fu1",
		"气鸣乐器", "	qi4	ming2	yue4	qi4",
		"信号处理", "	xin4	hao4	chu3	li3",
		"杜松子酒", "	du4	song1	zi3	jiu3",
		"大有作为", "	da4	you3	zuo4	wei2",
		"一气呵成", "	yi1	qi4	he1	cheng2",
		"室町幕府", "	shi4	ting3	mu4	fu3",
		"心肌梗塞", "	xin1	ji1	geng3	se4",
		"心里有数", "	xin1	li	you3	shu4",
		"曲麻莱县", "	qu3	ma2	lai2	xian4",
		"列宁格勒", "	lie4	ning2	ge2	le4",
		"嗳气吞酸", "	ai4	qi4	tun1	suan1",
		"意犹未尽", "	yi4	you2	wei4	jin4",
		"急公好义", "	ji2	gong1	hao4	yi4",
		"切理会心", "	qie1	li3	hui4	xin1",
		"啰里啰嗦", "	luo1	li	luo1	suo",
		"罗曼带克", "	luo1	man4	dai4	ke4",
		"佛朗机炮", "	fo2	lang3	ji1	pao4",
		"柔佛海峡", "	rou2	fo2	hai3	xia2",
		"佛兰芒语", "	fo2	lan2	mang2	yu3",
		"互为因果", "	hu4	wei2	yin1	guo4",
		"一一对应", "	yi1	yi1	dui4	ying4",
		"贫嘴薄舌", "	pin2	zui3	bo2	she2",
		"大煞风趣", "	da4	sha4	feng1	qu4",
		"四大名著", "	si4	da4	ming2	zhu4",
		"一成不易", "	yi1	cheng2	bu4	yi4",
		"面似靴皮", "	mian4	si4	xue1	pi2",
		"大肆铺张", "	da4	si4	pu1	zhang1",
		"改曲易调", "	gai3	qu3	yi4	diao4",
		"义薄云天", "	yi4	bo2	yun2	tian1",
		"改口沓舌", "	gai3	kou3	ta4	she2",
		"改恶为善", "	gai3	e4	wei2	shan4",
		"抱法处势", "	bao4	fa3	chu3	shi4",
		"右派分子", "	you4	pai4	fen4	zi3",
		"恣意妄为", "	zi4	yi4	wang4	wei2",
		"步罡踏斗", "	bu4	gang1	ta4	dou3",
		"不干不净", "	bu4	gan1	bu4	jing4",
		"昌都地区", "	chang1	du1	di4	qu1",
		"步步为营", "	bu4	bu4	wei2	ying2",
		"助人为乐", "	zhu4	ren2	wei2	le4",
		"步斗踏罡", "	bu4	dou3	ta4	gang1",
		"核战斗部", "	he2	zhan4	dou3	bu4",
		"任人宰割", "	ren4	ren2	zai3	ge1",
		"夷为平地", "	yi2	wei2	ping2	di4",
		"暴虎冯河", "	bao4	hu3	ping2	he2",
		"托勒密王", "	tuo1	le4	mi4	wang2",
		"死海古卷", "	si3	hai3	gu3	juan4",
		"太仆寺卿", "	tai4	pu2	si4	qing1",
		"各奔东西", "	ge4	ben4	dong1	xi1",
		"恐怖分子", "	kong3	bu4	fen4	zi",
		"恐怖片儿", "	kong3	bu4	pian1	r",
		"四海为家", "	si4	hai3	wei2	jia1",
		"四方台区", "	si4	fang1	tai2	qu1",
		"是非曲直", "	shi4	fei1	qu3	zhi2",
		"太子太保", "	tai4	zi3	tai4	bao3",
		"佳人才子", "	jia1	ren2	cai2	zi3",
		"到此为止", "	dao4	ci3	wei2	zhi3",
		"封妻荫子", "	feng1	qi1	yin4	zi3",
		"朝不保夕", "	zhao1	bu4	bao3	xi1",
		"爱丽舍宫", "	ai4	li4	she4	gong1",
		"不怀好意", "	bu4	huai2	hao4	yi4",
		"慈悲为本", "	ci2	bei1	wei2	ben3",
		"反客为主", "	fan3	ke4	wei2	zhu3",
		"人际关系", "	ren2	ji4	guan1	xi4",
		"不是东西", "	bu4	shi4	dong1	xi",
		"嘎嘎小姐", "	ga1	ga1	xiao3	jie",
		"反叛分子", "	fan3	pan4	fen4	zi3",
		"勉力而为", "	mian3	li4	er2	wei2",
		"仁人君子", "	ren2	ren2	jun1	zi3",
		"以人为本", "	yi3	ren2	wei2	ben3",
		"棋高一着", "	qi2	gao1	yi1	zhao1",
		"找台阶儿", "	zhao3	tai2	jie1	r",
		"印度音乐", "	yin4	du4	yin1	yue4",
		"南箕北斗", "	nan2	ji1	bei3	dou3",
		"妄自菲薄", "	wang4	zi4	fei3	bo2",
		"打家劫舍", "	da3	jia1	jie2	she4",
		"乳臭未干", "	ru3	xiu4	wei4	gan1",
		"不为已甚", "	bu4	wei2	yi3	shen4",
		"仁至义尽", "	ren2	zhi4	yi4	jin4",
		"小苏打粉", "	xiao3	su1	da2	fen3",
		"文书处理", "	wen2	shu1	chu3	li3",
		"动弹不得", "	dong4	tan	bu4	de2",
		"嘉兴地区", "	jia1	xing1	di4	qu1",
		"投其所好", "	tou2	qi2	suo3	hao4",
		"斗酒只鸡", "	dou3	jiu3	zhi1	ji1",
		"五行八作", "	wu3	hang2	ba1	zuo4",
		"技术知识", "	ji4	shu4	zhi1	shi",
		"化敌为友", "	hua4	di2	wei2	you3",
		"文艺复兴", "	wen2	yi4	fu4	xing1",
		"斜愣眼儿", "	xie2	leng	yan3	r",
		"哲人其萎", "	zhe2	ren2	qi2	wei3",
		"化为乌有", "	hua4	wei2	wu1	you3",
		"人尽其材", "	ren2	jin4	qi2	cai2",
		"不为人知", "	bu4	wei2	ren2	zhi1",
		"令狐德棻", "	ling2	hu2	de2	fen1",
		"代数拓扑", "	dai4	shu4	tuo4	pu1",
		"受冻挨饿", "	shou4	dong4	ai2	e4",
		"委靡不振", "	wei3	mi3	bu4	zhen4",
		"委内瑞拉", "	wei3	nei4	rui4	la1",
		"危如朝露", "	wei1	ru2	zhao1	lu4",
		"小菜碟儿", "	xiao3	cai4	die2	r",
		"拓扑结构", "	tuo4	pu1	jie2	gou4",
		"一语中的", "	yi1	yu3	zhong1	di4",
		"才子佳人", "	cai2	zi3	jia1	ren2",
		"才高八斗", "	cai2	gao1	ba1	dou3",
		"干脆利落", "	gan1	cui4	li4	luo4",
		"堆案盈几", "	dui1	an4	ying2	ji1",
		"巨海扇蛤", "	ju4	hai3	shan4	ge2",
		"核电荷数", "	he2	dian4	he4	shu4",
		"一言难尽", "	yi1	yan2	nan2	jin4",
		"别具只眼", "	bie2	ju4	zhi1	yan3",
		"林荫大道", "	lin2	yin4	da4	dao4",
		"手板葫芦", "	shou3	ban3	hu2	lu",
		"搞花样儿", "	gao3	hua1	yang4	r",
		"母音调和", "	mu3	yin1	tiao2	he2",
		"枯草杆菌", "	ku1	cao3	gan3	jun1",
		"怎么得了", "	zen3	me	de2	liao3",
		"巴塞隆纳", "	ba1	sai4	long2	na4",
		"希腊神话", "	xi1	la4	shen2	hua4",
		"供大于求", "	gong4	da4	yu2	qiu2",
		"利他行为", "	li4	ta1	xing2	wei2",
		"卑鄙龌龊", "	bei1	bi3	wo4	chuo4",
		"极端分子", "	ji2	duan1	fen4	zi3",
		"小时候儿", "	xiao3	shi2	hou	r",
		"数不过来", "	shu3	bu4	guo4	lai2",
		"打躬作揖", "	da3	gong1	zuo1	yi1",
		"乙种粒子", "	yi3	zhong3	li4	zi3",
		"启应祈祷", "	qi3	ying4	qi2	dao3",
		"好自为之", "	hao4	zi4	wei2	zhi1",
		"棒子面儿", "	bang4	zi	mian4	r",
		"扼襟控咽", "	e4	jin1	kong4	yan1",
		"尺寸过大", "	chi3	cun	guo4	da4",
		"千钧一发", "	qian1	jun1	yi1	fa4",
		"戴高帽子", "	dai4	gao1	mao4	zi3",
		"败子回头", "	bai4	zi3	hui2	tou2",
		"原子序数", "	yuan2	zi3	xu4	shu4",
		"并不在乎", "	bing4	bu4	zai4	hu",
		"极深研几", "	ji2	shen1	yan2	ji1",
		"极为庞大", "	ji2	wei2	pang2	da4",
		"好大喜功", "	hao4	da4	xi3	gong1",
		"丫头片子", "	ya1	tou	pian1	zi",
		"手扳葫芦", "	shou3	ban1	hu2	lu",
		"横竖劲儿", "	heng2	shu4	jin4	r",
		"委肉虎蹊", "	wei3	rou4	hu3	xi1",
		"喀拉汗国", "	ka1	la1	han2	guo2",
		"批亢抵巇", "	pi1	gang1	di3	xi1",
		"路易十六", "	lu4	yi4	shi2	liu4",
		"塞拉利昂", "	sai4	la1	li4	ang2",
		"以邻为壑", "	yi3	lin2	wei2	he4",
		"干巴利落", "	gan1	ba1	li4	luo4",
		"昆都仑区", "	kun1	du1	lun2	qu1",
		"羿射九日", "	yi4	she4	jiu3	ri4",
		"干巴利脆", "	gan1	ba1	li4	cui4",
		"多哈回合", "	duo1	ha1	hui2	he2",
		"无为自化", "	wu2	wei2	zi4	hua4",
		"网路特务", "	wang3	lu4	te4	wu",
		"物稀为贵", "	wu4	xi1	wei2	gui4",
		"以为后图", "	yi3	wei2	hou4	tu2",
		"无为而治", "	wu2	wei2	er2	zhi4",
		"绿林豪客", "	lu4	lin2	hao2	ke4",
		"詈夷为跖", "	li4	yi2	wei2	zhi2",
		"偶一为之", "	ou3	yi1	wei2	zhi1",
		"经济体系", "	jing1	ji4	ti3	xi4",
		"大大咧咧", "	da4	da4	lie1	lie1",
		"地区差价", "	di4	qu1	cha1	jia4",
		"鲁难未已", "	lu3	nan4	wei4	yi3",
		"以牙还牙", "	yi3	ya2	huan2	ya2",
		"一夕一朝", "	yi1	xi1	yi1	zhao1",
		"符号逻辑", "	fu2	hao4	luo2	ji",
		"临难不惧", "	lin2	nan4	bu4	ju3",
		"耶稣会士", "	ye1	su1	hui4	shi4",
		"束蒲为脯", "	shu4	pu2	wei2	pu2",
		"大而无当", "	da4	er2	wu2	dang4",
		"附肤落毛", "	fu4	fu1	luo4	mao2",
		"耳鼻咽喉", "	er3	bi2	yan1	hou2",
		"服服帖帖", "	fu2	fu	tie1	tie1",
		"打打闹闹", "	da2	da3	nao4	nao4",
		"佛山地区", "	fo2	shan1	di4	qu1",
		"以书为御", "	yi3	shu1	wei2	yu4",
		"昭披耶河", "	zhao1	pi1	ye1	he2",
		"值得注意", "	zhi2	de	zhu4	yi4",
		"符合要求", "	fu2	he2	yao1	qiu2",
		"耶律大石", "	ye1	lu:4	da4	shi2",
		"以己度人", "	yi3	ji3	duo2	ren2",
		"罗切斯特", "	luo2	qie1	si1	te4",
		"移天易日", "	yi2	tian1	yi4	ri4",
		"易俗移风", "	yi4	su2	yi2	feng1",
		"格物致知", "	ge2	wu4	zhi4	zhi1",
		"夹起尾巴", "	jia1	qi3	wei3	ba",
		"耶酥会士", "	ye1	su1	hui4	shi4",
		"巴马干酪", "	ba1	ma3	gan1	lao4",
		"一谦四益", "	yi1	qian1	si4	yi4",
		"差不多的", "	cha4	bu	duo1	de",
		"差一点儿", "	cha4	yi1	dian3	r",
		"一切万物", "	yi1	qie1	wan4	wu4",
		"视为儿戏", "	shi4	wei2	er2	xi4",
		"丝毫不差", "	si1	hao2	bu4	cha1",
		"恶迹昭著", "	e4	ji4	zhao1	zhu4",
		"凯撒肋雅", "	kai3	sa1	lei4	ya3",
		"须发皆白", "	xu1	fa4	jie1	bai2",
		"绿林大盗", "	lu4	lin2	da4	dao4",
		"死亡无日", "	si3	wang2	wu2	ri4",
		"与时俱进", "	yu3	shi2	ju1	jin4",
		"伺瑕导隙", "	si4	xia2	dao3	xi4",
		"法家拂士", "	fa3	jia1	bi4	shi4",
		"羞与为伍", "	xiu1	yu3	wei2	wu3",
		"倒持太阿", "	dao3	chi2	tai4	a1",
		"羞人答答", "	xiu1	ren2	da1	da1",
		"布干维尔", "	bu4	gan1	wei2	er3",
		"岂弟君子", "	kai3	ti4	jun1	zi3",
		"一目五行", "	yi1	mu4	wu3	hang2",
		"砥砺琢磨", "	di3	li4	zhuo2	mo2",
		"多子多福", "	duo1	zi3	duo1	fu2",
		"藉资挹注", "	jie4	zi1	yi4	zhu4",
		"石头子儿", "	shi2	tou	zi3	er",
		"一脚不移", "	yi1	jiao3	bu4	yi2",
		"骂骂咧咧", "	ma4	ma4	lie1	lie1",
		"意念移物", "	yi4	nian4	yi2	wu4",
		"置之死地", "	zhi4	zhi1	si3	di4",
		"加利肋亚", "	jia1	li4	lei4	ya4",
		"置之不理", "	zhi4	zhi1	bu4	li3",
		"吾自有处", "	wu	zi	you	chu",
		"时移世易", "	shi2	yi2	shi4	yi4",
		"一劳久逸", "	yi1	lao2	jiu3	yi4",
		"恶紫夺朱", "	wu4	zi3	duo2	zhu1",
		"加勒比海", "	jia1	le4	bi3	hai3",
		"五子登科", "	wu3	zi3	deng1	ke1",
		"实与有力", "	shi2	yu4	you3	li4",
		"加德满都", "	jia1	de2	man3	du1",
		"萨摩耶犬", "	sa4	mo2	ye1	quan3",
		"加里肋亚", "	jia1	li3	lei4	ya4",
		"耶路撒冷", "	ye1	lu4	sa1	leng3",
		"聊以塞责", "	liao2	yi3	se4	ze2",
		"似醉如痴", "	si4	zui4	ru2	chi1",
		"财殚力痡", "	cai2	dan1	li4	pu1",
		"只鸡絮酒", "	zhi1	ji1	xu4	jiu3",
		"不对茬儿", "	bu2	dui4	cha2	er2",
		"不用客气", "	bu4	yong4	ke4	qi",
		"投机倒把", "	tou2	ji1	dao3	ba3",
		"鹤处鸡群", "	he4	chu3	ji1	qun2",
		"毕毕剥剥", "	bi4	bi4	bao1	bao1",
		"朱颜绿发", "	zhu1	yan2	lv4	fa4",
		"拖拖沓沓", "	tuo1	tuo1	ta4	ta4",
		"爱莫之助", "	ai4	mo4	zhi1	zhu4",
		"蒿子秆儿", "	hao1	zi3	gan3	er2",
		"吉电子伏", "	ji2	dian4	zi3	fu2",
		"刿鉥心腑", "	gui4	xu4	xin1	fu3",
		"画地为狱", "	hua4	di4	wei2	yu4",
		"朱颜鹤发", "	zhu1	yan2	he4	fa4",
		"千里一曲", "	qian1	li3	yi1	qu3",
		"才疏德薄", "	cai2	shu1	de2	bo2",
		"取之不尽", "	qu3	zhi1	bu4	jin4",
		"狐藉虎威", "	hu2	jie4	hu3	wei1",
		"曲曲折折", "	qu1	qu1	zhe2	she2",
		"一哄而起", "	yi1	hong4	er2	qi3",
		"无以为报", "	wu2	yi3	wei2	bao4",
		"一年四季", "	yi4	nian2	si4	ji4",
		"一般贸易", "	yi1	ban1	mao4	yi4",
		"世界屋脊", "	shi4	jie4	wu1	ji3",
		"不足齿数", "	bu4	zu2	chi3	shu3",
		"不足为道", "	bu4	zu2	wei2	dao4",
		"家给人足", "	jia1	ji3	ren2	zu2",
		"掎挈伺诈", "	ji3	qie4	si4	zha4",
		"鸡毛掸子", "	ji1	mao2	dan3	zi3",
		"鹤发松姿", "	he4	fa4	song1	zi1",
		"泥古拘方", "	ni4	gu3	ju1	fang1",
		"止戈为武", "	zhi3	ge1	wei2	wu3",
		"曲意迎合", "	qu3	yi4	ying2	he2",
		"不置可否", "	bu4	zhi4	ke3	fou3",
		"呲牙咧嘴", "	zi1	ya2	lie3	zui3",
		"被褐怀玉", "	pi1	he4	huai2	yu4",
		"泥古非今", "	ni4	gu3	fei1	jin1",
		"洛克菲勒", "	luo4	ke4	fei1	le4",
		"男子气概", "	nan2	zi3	qi4	gai4",
		"不当得利", "	bu4	dang4	de	li4",
		"否去泰来", "	pi3	qu4	tai4	lai2",
		"据为己有", "	ju4	wei2	ji3	you3",
		"大拇指头", "	da4	mu3	zhi3	tou",
		"金发碧眼", "	jin1	fa4	bi4	yan3",
		"父为子隐", "	fu4	wei2	zi3	yin3",
		"服务行业", "	fu2	wu4	hang2	ye4",
		"移风易俗", "	yi2	feng1	yi4	su2",
		"梨园弟子", "	li2	yuan2	di4	zi3",
		"一佛出世", "	yi1	fo2	chu1	shi4",
		"似是而非", "	si4	shi4	er2	fei1",
		"功不可没", "	gong1	bu4	ke3	mo4",
		"一毫不差", "	yi1	hao2	bu4	cha1",
		"覆亡无日", "	fu4	wang2	wu2	ri4",
		"一定不易", "	yi1	ding4	bu4	yi4",
		"攒眉蹙额", "	cuan2	mei	cu4	e2",
		"书不尽意", "	shu1	bu4	jin4	yi4",
		"恶迹昭着", "	e4	ji4	zhao1	zhe",
		"恰如其分", "	qia4	ru2	qi2	fen4",
		"大有可为", "	da4	you3	ke3	wei2",
		"投河自尽", "	tou2	he2	zi4	jin4",
		"大气磅礴", "	da4	qi4	pang2	bo2",
		"大璞不完", "	tai4	bu2	bu4	wan2",
		"嗳气腐臭", "	ai4	qi4	fu3	chou4",
		"头足异处", "	tou2	zu2	yi4	chu3",
		"纪律处分", "	ji4	lv4	chu3	fen4",
		"福孙荫子", "	fu2	sun1	yin4	zi3",
		"哈巴河县", "	ha1	ba1	he2	xian4",
		"卑鄙无耻", "	bei1	bi3	wu2	chi3",
		"无所不为", "	wu2	suo3	bu4	wei2",
		"畸流洽客", "	ji1	liu2	qia4	ke4",
		"孺子可教", "	ru2	zi3	ke3	jiao4",
		"伺瑕抵蠙", "	si4	xia2	di3	pin2",
		"集腋为裘", "	ji2	ye4	wei2	qiu2",
		"嗳气酸腐", "	ai4	qi4	suan1	fu3",
		"失去意识", "	shi1	qu4	yi4	shi2",
		"喷薄欲出", "	pen1	bo2	yu4	chu1",
		"低音提琴", "	di1	yin1	ti2	qin2",
		"俯拾地芥", "	fu3	shi2	di4	jie4",
		"解衣衣人", "	jie4	yi1	yi1	ren2",
		"头没杯案", "	tou2	mo4	bei1	an4",
		"投袂荷戈", "	tou2	mei4	he4	ge1",
		"万柏林区", "	wan4	bo2	lin2	qu1",
		"浮名薄利", "	fu2	ming2	bo2	li4",
		"负气斗狠", "	fu4	qi4	dou3	hen3",
		"布隆伯格", "	bu4	long1	bo2	ge2",
		"羞羞答答", "	xiu1	xiu1	da1	da1",
		"少儿不宜", "	shao4	er2	bu4	yi2",
		"没世无闻", "	mo4	shi4	wu2	wen2",
		"渔阳鞞鼓", "	yu3	yang2	pi2	gu3",
		"苏州码子", "	su1	zhou1	ma3	zi3",
		"闭目塞听", "	bi4	mu4	se4	ting1",
		"闭门塞窦", "	bi4	kou3	se4	dou4",
		"歙漆阿胶", "	she4	qi1	e1	jiao1",
		"文似其人", "	wen2	si4	qi2	ren2",
		"桃蹊柳曲", "	tao2	qi1	liu3	qu3",
		"朝露暮霭", "	zhao1	lu4	mu4	ai3",
		"笃学好古", "	du3	xue2	hao4	gu3",
		"靡靡之乐", "	mi3	mi3	zhi1	yue4",
		"业余教育", "	ye4	yu2	jiao4	yu4",
		"门单户薄", "	men2	dan1	hu4	bo2",
		"斗绝一隅", "	dou3	jue2	yi1	yu2",
		"娱妻弄子", "	yu2	qi1	nong4	zi3",
		"数一数二", "	shu3	yi1	shu3	er4",
		"御史大夫", "	yu4	shi3	dai4	fu1",
		"西格蒙德", "	xi1	ge2	meng1	de2",
		"吁天呼地", "	yu4	tian1	hu1	di4",
		"外孙女儿", "	wai4	sun1	nu:3	r",
		"尼勒克县", "	ni2	le4	ke4	xian4",
		"孝子爱日", "	xiao4	zi3	ai4	ri4",
		"手拉葫芦", "	shou3	la1	hu2	lu",
		"裸子植物", "	luo3	zi3	zhi2	wu4",
		"居民点儿", "	ju1	min2	dian3	r",
		"毓子孕孙", "	yu4	zi3	yun4	sun1",
		"阿克塞县", "	a	ke4	sai4	xian4",
		"阿什拉维", "	a	shen2	la1	wei2",
		"帷薄不修", "	wei2	bo2	bu4	xiu1",
		"谓予不信", "	wei4	yu2	bu4	xin4",
		"郁郁累累", "	yu4	yu4	lei3	lei3",
		"读书君子", "	du2	shu1	jun1	zi3",
		"阿图什县", "	a	tu2	shi2	xian4",
		"卑辞厚币", "	bei1	ci2	hou4	bi4",
		"阿克陶县", "	a	ke4	tao2	xian4",
		"尺布斗粟", "	chi3	bu4	dou3	su4",
		"为恶不悛", "	wei2	e4	bu4	quan1",
		"斗米尺布", "	dou3	mi3	chi3	bu4",
		"血肉模糊", "	xue4	rou4	mo2	hu",
		"神乎其技", "	shen2	hu1	qi2	ji4",
		"未为不可", "	wei4	wei2	bu4	ke3",
		"优游自得", "	you1	you2	zi4	de2",
		"屈指可数", "	qu1	zhi3	ke3	shu3",
		"吃里扒外", "	chi1	li3	pa2	wai4",
		"绨袍之义", "	ti4	pao2	zhi1	yi4",
		"如胶似漆", "	ru2	jiao1	si4	qi1",
		"衣单食薄", "	yi1	dan1	shi2	bo2",
		"阿旺曲培", "	a	wang4	qu1	pei2",
		"克仑特罗", "	ke4	lun2	te4	luo1",
		"阿旺曲沛", "	a	wang4	qu3	pei4",
		"允许误差", "	yun3	xu3	wu4	cha1",
		"砚水壶儿", "	yan4	shui3	hu2	r",
		"运移时易", "	yun4	yi2	shi2	yi4",
		"靡衣偷食", "	mi3	yi1	tou1	shi2",
		"如法炮制", "	ru2	fa3	pao2	zhi4",
		"载入史册", "	zai3	ru4	shi3	ce4",
		"扫地以尽", "	sao3	di4	yi3	jin4",
		"石河子市", "	shi2	he2	zi3	shi4",
		"阿尔山市", "	a	er3	shan1	shi4",
		"凿坏以遁", "	zao2	pi1	yi3	dun4",
		"打心眼里", "	da3	xin1	yan3	li",
		"泽被后世", "	ze2	pi1	hou4	shi4",
		"味如鸡肋", "	wei4	ru2	ji1	lei4",
		"如狼似虎", "	ru2	lang2	si4	hu3",
		"踏踏实实", "	ta1	ta1	shi	shi2",
		"大吃苦头", "	da4	chi1	ku3	tou",
		"阿苏火山", "	a	su1	huo3	shan1",
		"极右分子", "	ji2	you4	fen4	zi3",
		"为非作恶", "	wei2	fei1	zuo4	e4",
		"朝不虑夕", "	zhao1	bu4	lv4	xi1",
		"扫地俱尽", "	sao3	di4	ju4	jin4",
		"乐府诗集", "	yue4	fu3	shi1	ji2",
		"好色之徒", "	hao4	se4	zhi1	tu2",
		"阿肯色州", "	a	ken3	se4	zhou1",
		"小步舞曲", "	xiao3	bu4	wu3	qu3",
		"啼饥号寒", "	ti2	ji1	hao2	han2",
		"看不过去", "	kan4	bu	guo4	qu",
		"乐山大佛", "	le4	shan1	da4	fo2",
		"三闾大夫", "	san1	lv2	dai4	fu1",
		"斗粟尺布", "	dou3	su4	chi3	bu4",
		"小日本儿", "	xiao3	ri4	ben3	r",
		"卜昼卜夜", "	bu3	zhou4	bu3	ye4",
		"咳珠唾玉", "	ke2	zhu1	tuo4	yu4",
		"如其所好", "	ru2	qi2	suo3	hao4",
		"脊柱后凸", "	ji3	zhu4	hou4	tu1",
		"杜默为诗", "	du4	mo4	wei2	shi1",
		"塞尔维亚", "	sai4	er3	wei2	ya4",
		"别太客气", "	bie2	tai4	ke4	qi",
		"列缺霹雳", "	lie4	que1	pi1	li4",
		"大不列蹀", "	da4	bu	lie	die",
		"这早晚儿", "	zhe4	zao3	wan3	r",
		"赫鲁晓夫", "	he4	lu3	xiao3	fu",
		"赞叹不已", "	zan4	tan4	bu4	yi3",
		"劳筋苦骨", "	lao2	jin1	ku3	gu3",
		"纷纭杂沓", "	fen1	yun2	za2	ta4",
		"曼切斯特", "	man4	qie1	si1	te4",
		"发秃齿豁", "	fa4	tu1	chi3	huo4",
		"大陆漂移", "	da4	lu4	piao1	yi2",
		"曲靖地区", "	qu3	jing4	di4	qu1",
		"必和必拓", "	bi4	huo2	bi4	tuo4",
		"过去分词", "	guo4	qu4	fen4	ci2",
		"荆棘塞途", "	jing1	ji2	se4	tu2",
		"分子医学", "	fen1	zi3	yi1	xue2",
		"浮白载笔", "	fu2	bai2	zai3	bi3",
		"巴塞罗那", "	ba1	sai4	luo2	na4",
		"丝恩发怨", "	si1	en1	fa4	yuan4",
		"来日大难", "	lai2	ri4	da4	nan4",
		"逐次近似", "	zhu2	ci4	jin4	si4",
		"倒戢干戈", "	dao3	ji2	gan1	ge1",
		"拉枯折朽", "	la1	ku1	she2	xiu3",
		"贫富差距", "	pin2	fu4	cha1	ju4",
		"须眉男子", "	xu1	mei2	nan2	zi3",
		"自繇自在", "	zi4	you2	zi4	zai",
		"贩夫走卒", "	fan4	fu1	zou3	fu2",
		"畜妻养子", "	xu4	qi1	yang3	zi3",
		"似漆如胶", "	si4	qi1	ru2	jiao1",
		"杜莎夫人", "	du4	suo1	fu1	ren",
		"自怨自艾", "	zi4	yuan4	zi4	yi4",
		"四马攒蹄", "	si4	ma3	cuan2	ti2",
		"自以为是", "	zi4	yi3	wei2	shi4",
		"弟男子侄", "	di4	nan2	zi3	zhi2",
		"巴巴结结", "	ba1	ba1	jie1	jie1",
		"出臭子儿", "	chu1	chou4	zi3	r",
		"似水如鱼", "	si4	shui3	ru2	yu2",
		"贸易逆差", "	mao4	yi4	ni4	cha1",
		"卷席而居", "	juan4	xi2	er2	ju1",
		"大兴土木", "	da4	xing1	tu3	mu4",
		"太阿倒持", "	tai4	e1	dao4	chi2",
		"牢什古子", "	lao2	shi2	gu3	zi",
		"胳臂肘儿", "	ge1	bei	zhou3	r",
		"四邻八舍", "	si4	lin2	ba1	she4",
		"代客泊车", "	dai4	ke4	bo2	che1",
		"刻意为之", "	ke4	yi4	wei2	zhi1",
		"穴居野处", "	xue2	ju1	ye3	chu3",
		"削木为吏", "	xue1	mu4	wei2	li4",
		"逻辑错误", "	luo2	ji	cuo4	wu4",
		"金吾不禁", "	jin1	wu2	bu4	jin4",
		"二三君子", "	er4	san1	jun1	zi3",
		"寻瑕伺隙", "	xun2	xia2	si4	xi4",
		"尽如人意", "	jin4	ru2	ren2	yi4",
		"倒霉蛋儿", "	dao3	mei2	dan4	r",
		"竖起耳朵", "	shu4	qi3	er3	duo",
		"儿童歌曲", "	er2	tong2	ge1	qu3",
		"宴安酖毒", "	yan4	an1	dan1	du2",
		"雁泊人户", "	yan4	bo2	ren2	hu4",
		"单鹄寡凫", "	dan1	hu2	gua3	fu2",
		"淡而不厌", "	dan4	er2	bu4	yan4",
		"胆大如斗", "	dan3	da4	ru2	dou3",
		"典妻鬻子", "	dian3	qi1	yu4	zi3",
		"偃革倒戈", "	yan3	ge2	dao3	ge1",
		"箪食壶酒", "	dan1	si4	hu2	jiu3",
		"四不拗六", "	si4	bu4	niu4	liu4",
		"似非而是", "	si4	fei1	er2	shi4",
		"蒙帕纳斯", "	meng3	pa4	na4	si1",
		"阿世取容", "	e1	shi4	qu3	rong2",
		"眼犄角儿", "	yan3	ji1	jue2	er2",
		"胳膊肘子", "	ge1	bo	zhou3	zi3",
		"菲食薄衣", "	fei3	shi2	bo2	yi1",
		"差额选举", "	cha1	e2	xuan3	ju3",
		"胡椒薄荷", "	hu2	jiao1	bo4	he",
		"阿谀谄媚", "	e1	yu2	chan3	mei4",
		"通都大邑", "	tong1	du1	da4	yi4",
		"释迦牟尼", "	shi4	jia1	mu4	ni2",
		"恶湿居下", "	wu4	shi1	ju1	xia4",
		"腐败分子", "	fu3	bai4	fen1	zi3",
		"佛眼佛心", "	fo2	yan3	fo2	xin1",
		"大溪豆干", "	da4	xi1	dou4	gan1",
		"言无不尽", "	yan2	wu2	bu4	jin4",
		"了无惧色", "	liao3	wu1	ju3	se4",
		"四子王旗", "	si4	zi3	wang2	qi2",
		"佛罗伦萨", "	fo2	luo2	lun2	sa4",
		"未知数儿", "	wei4	zhi1	shu4	r",
		"佛法僧目", "	fo2	fa3	seng1	mu4",
		"著作权法", "	zhu4	zuo4	quan2	fa3",
		"六安地区", "	lu4	an1	di4	qu1",
		"归心似箭", "	gui1	xin1	si4	jian4",
		"各奔前程", "	ge4	ben4	qian2	cheng2",
		"受洗命名", "	shou4	xi3	ming4	ming2",
		"少男少女", "	shao4	nan2	shao4	nu:3",
		"论黄数黑", "	lun4	huang2	shu3	hei1",
		"心潮澎湃", "	xin1	chao2	peng2	pai4",
		"各显所长", "	ge4	xian3	suo3	chang2",
		"鸾只凤单", "	luan2	zhi1	feng4	dan1",
		"心电感应", "	xin1	dian4	gan3	ying4",
		"心灵感应", "	xin1	ling2	gan3	ying4",
		"乱葬岗子", "	luan4	zang4	gang3	zi3",
		"商业行为", "	shang1	ye4	xing2	wei2",
		"千载一圣", "	qian1	zai3	yi1	sheng4",
		"倒箧倾囊", "	dao3	qie4	qing1	nang2",
		"攻过箴阙", "	gong1	guo4	zhen1	que4",
		"其应若响", "	qi2	ying4	ruo4	xiang3",
		"高风劲节", "	gao1	feng1	jing4	jie2",
		"颠倒乾坤", "	dian1	dao3	qian2	kun1",
		"蒙古人种", "	meng3	gu3	ren2	zhong3",
		"当着不着", "	dang1	zhuo2	bu4	zhuo2",
		"电子邮箱", "	dian4	zi3	you2	xiang1",
		"磨盘两圆", "	mo4	pan2	liang3	yuan2",
		"梦魂颠倒", "	meng4	hun2	dian1	dao3",
		"东量西折", "	dong1	liang4	xi1	she2",
		"缝纫车间", "	feng2	ren4	che1	jian1",
		"绕梁之音", "	rao3	liang2	zhi1	yin1",
		"愁多夜长", "	chou2	duo1	ye4	chang2",
		"横行直走", "	heng2	xing2	zhi2	zou3",
		"原子质量", "	yuan2	zi3	zhi4	liang4",
		"横殃飞祸", "	heng4	yang1	fei1	huo4",
		"应用数学", "	ying4	yong4	shu4	xue2",
		"凤楼龙阙", "	feng4	lou2	long2	que4",
		"人头攒动", "	ren2	tou2	cuan2	dong4",
		"应运而生", "	ying4	yun4	er2	sheng1",
		"任性妄为", "	ren4	xing4	wang4	wei2",
		"瓶沈簪折", "	ping2	shen3	zan1	she2",
		"横征暴赋", "	heng4	zheng1	bao4	fu4",
		"应用软体", "	ying4	yong4	ruan3	ti3",
		"重纸累札", "	chong2	zhi3	lei4	zha2",
		"红不棱登", "	hong2	bu4	leng1	deng1",
		"老之将至", "	lao3	zhi1	jiang1	zhi4",
		"鸿鹄将至", "	hong2	hu2	jiang1	zhi4",
		"强干弱枝", "	qiang2	gan1	ruo4	zhi1",
		"鸾漂凤泊", "	luan2	piao1	feng4	bo2",
		"横抢武夺", "	heng4	qiang3	wu3	duo2",
		"流觞曲水", "	liu2	shang1	qu3	shui3",
		"抢购一空", "	qiang1	gou4	yi1	kong1",
		"怒目相向", "	nu4	mu4	xiang1	xiang4",
		"寡见鲜闻", "	gua3	jian4	xian3	wen2",
		"厝火燎原", "	cuo4	huo3	liao3	yuan2",
		"寸有所长", "	cun4	you3	suo3	chang2",
		"寡廉鲜耻", "	gua3	lian2	xian3	chi3",
		"流水游龙", "	liu2	shui3	you2	long2",
		"只争朝夕", "	zhi3	zheng1	zhao1	xi1",
		"六畜兴旺", "	liu4	chu4	xing1	wang4",
		"更仆难终", "	geng1	pu2	nan2	zhong1",
		"凌霄之志", "	ling2	xiao1	zhi1	zhi4",
		"电子手表", "	dian4	zi3	shou3	biao3",
		"患难之交", "	huan4	nan4	zhi1	jiao1",
		"零零散散", "	ling2	ling2	san3	san3",
		"弃短就长", "	qi4	duan3	jiu4	chang2",
		"榱栋崩折", "	cui1	dong4	beng1	she2",
		"榱崩栋折", "	cui1	beng1	dong4	she2",
		"观者成堵", "	guan1	zhe3	cheng2	du3",
		"裂冠毁冕", "	lie4	guan4	hui3	mian3",
		"倒山倾海", "	dao3	shan1	qing1	hai3",
		"功遂身退", "	gong1	sui2	shen1	tui4",
		"前程似锦", "	qian2	cheng2	si4	jin3",
		"少说为佳", "	shao3	shuo1	wei2	jia1",
		"满天星斗", "	man3	tian1	xing1	dou3",
		"前功尽废", "	qian2	gong1	jin4	fei4",
		"签订合同", "	qian1	ding4	he2	tong",
		"高山反应", "	gao1	shan1	fan3	ying4",
		"前功尽灭", "	qian2	gong1	jin4	mie4",
		"更阑人静", "	geng1	lan2	ren2	jing3",
		"昧旦晨兴", "	mei4	dan4	chun2	xing1",
		"满腔热枕", "	man3	qiang1	re4	chen2",
		"公共管理", "	gong1	gong4	guan3	li3",
		"合众银行", "	he2	zhong4	yin2	hang2",
		"潜孔钻机", "	qian2	kong3	zuan4	ji1",
		"更深夜静", "	geng1	shen1	ye4	jing4",
		"更生霉素", "	geng1	sheng1	mei2	su4",
		"吉人天相", "	ji2	ren2	tian1	xiang4",
		"更弦改辙", "	geng1	xian2	gai3	zhe2",
		"马瘦毛长", "	ma3	shou4	mao2	chang2",
		"尺短寸长", "	chi3	duan3	cu4	chang2",
		"捋袖揎拳", "	luo1	xiu4	xuan1	quan2",
		"弹尽粮绝", "	dan4	jin4	liang2	jue2",
		"凤泊鸾漂", "	feng4	bo2	luan2	piao1",
		"光杆司令", "	guang1	gan3	si1	ling4",
		"好行小惠", "	hao4	xing2	xiao3	hui4",
		"传为美谈", "	chuan2	wei2	mei3	tan2",
		"传为佳话", "	chuan2	wei2	jia1	hua4",
		"好谋善断", "	hao4	mou2	shan4	duan4",
		"铺床叠被", "	pu1	chuang2	die2	bei4",
		"形单影只", "	xing2	dan1	ying3	zhi1",
		"地久天长", "	di4	jiu3	tian1	chang2",
		"传柄移藉", "	chuan2	bing3	yi2	jie4",
		"秋行夏令", "	qiu1	xing2	xia4	ling2",
		"呵欠连天", "	he1	qian4	lian2	tian1",
		"连车平斗", "	lian2	che1	ping2	dou3",
		"酩酊烂醉", "	ming3	ding3	lan4	zui4",
		"鼎铛有耳", "	ding3	cheng1	you3	er3",
		"曲水流觞", "	qu3	shui3	liu2	shang1",
		"处实效功", "	chu3	shi2	xiao4	gong1",
		"楞眉横眼", "	leng4	mei2	heng2	yan3",
		"累月经年", "	lei3	yue4	jing1	nian2",
		"力能扛鼎", "	li4	neng2	gang1	ding3",
		"冥行擿埴", "	ming2	xing2	zhi4	zhi2",
		"好梦不长", "	hao3	meng4	bu4	chang2",
		"刁钻促搯", "	diao1	zuan4	cu4	chao1",
		"干干净净", "	gan4	gan1	jing4	jing4",
		"伤痕累累", "	shang1	hen2	lei2	lei2",
		"谋臣武将", "	mou2	chen2	wu3	jiang4",
		"温衾扇枕", "	wen1	qin1	shan1	zhen3",
		"变态反应", "	bian4	tai4	fan3	ying4",
		"直柄钻头", "	zhi2	bing3	zuan4	tou2",
		"电子信箱", "	dian4	zi3	xin4	xiang1",
		"蜗杆传动", "	wo1	gan3	chuan2	dong4",
		"散兵游勇", "	san3	bing1	you2	yong3",
		"植发穿冠", "	zhi2	fa4	chuan1	guan4",
		"月中折桂", "	yue4	zhong1	she2	gui4",
		"反应时间", "	fan3	ying4	shi2	jian1",
		"传道受业", "	chuan2	dao4	shou4	ye4",
		"植发冲冠", "	zhi2	fa4	chong1	guan4",
		"云合响应", "	yun2	he2	xiang3	ying4",
		"文子同升", "	wen2	zi3	tong2	sheng1",
		"影只形单", "	ying3	zhi1	xing2	dan1",
		"十里长亭", "	shi2	li3	chang2	ting2",
		"狼艰狈蹶", "	lang2	jian1	bei4	jue3",
		"行号巷哭", "	xing2	hao2	xiang4	ku1",
		"敛容屏气", "	lian3	rong2	bing3	qi4",
		"行行蛇蚓", "	hang2	hang2	she2	yin3",
		"吹拉弹唱", "	chui1	la1	tan2	chang4",
		"日短心长", "	ri4	duan3	xin1	chang2",
		"商业银行", "	shang1	ye4	yin2	hang2",
		"日久天长", "	ri4	jiu3	tian1	chang2",
		"浪子宰相", "	lang4	zi3	zai3	xiang4",
		"重生父母", "	chong2	sheng1	fu4	mu3",
		"东墙处子", "	dong1	qiang2	chu3	zi3",
		"卷土重来", "	juan3	tu3	chong2	lai2",
		"老老少少", "	lao3	lao3	shao4	shao4",
		"弹性模量", "	tan2	xing4	mo2	liang4",
		"重明继焰", "	chong2	ming2	ji4	yan4",
		"充类至尽", "	chong1	lei4	zhi4	jin4",
		"垂死挣扎", "	chui2	si3	zheng1	zha2",
		"重金袭汤", "	chong2	jin1	xi2	tang1",
		"重金兼紫", "	chong2	jin1	jian1	zi3",
		"冲击钻头", "	chong1	ji1	zuan4	tou2",
		"戎马倥偬", "	rong2	ma3	kong3	zong3",
		"后生小子", "	hou4	sheng1	xiao3	zi3",
		"喟然长叹", "	kui4	ran2	chang2	tan4",
		"喉长气短", "	hou2	chang2	qi4	duan3",
		"却老还童", "	que4	lao3	huan2	tong2",
		"重手累足", "	chong2	shou3	lei3	zu2",
		"横恩滥赏", "	heng4	en1	lan4	shang3",
		"吹花嚼蕊", "	chui1	hua1	jiao2	rui3",
		"改行为善", "	gai3	xing2	wei2	shan4",
		"扛鼎拔山", "	gang1	ding3	ba2	shan1",
		"了身达命", "	liao3	shen1	da2	ming4",
		"了然于胸", "	liao3	ran2	yu2	xiong1",
		"感应电流", "	gan3	ying4	dian4	liu2",
		"了了可见", "	liao3	liao3	ke3	jian4",
		"桂子飘香", "	gui4	zi3	piao1	xiang1",
		"撩蜂吃螫", "	liao2	feng1	chi1	shi4",
		"干霄凌云", "	gan1	xiao1	ling2	yun2",
		"了不长进", "	liao3	bu4	zhang3	jin3",
		"擎天之柱", "	qing2	tian1	zhi1	zhu4",
		"琼楼金阙", "	qiong2	lou2	jin1	que4",
		"两世为人", "	liang3	shi4	wei2	ren2",
		"国之干城", "	guo2	zhi1	gan1	cheng2",
		"电子元件", "	dian4	zi3	yuan2	jian4",
		"影像处理", "	ying3	xiang4	chu3	li3",
		"海相沉积", "	hai3	xiang4	chen2	ji1",
		"穷途潦倒", "	qiong2	tu2	liao2	dao3",
		"反败为胜", "	fan3	bai4	wei2	sheng4",
		"穷理尽性", "	qiong2	li3	jin4	xing4",
		"电子天平", "	dian4	zi3	tian1	ping2",
		"受降仪式", "	shou4	xiang2	yi2	shi4",
		"一箭上垛", "	yi1	jian4	shang4	duo4",
		"喙长三尺", "	hui4	chang2	san1	chi3",
		"黄干黑廋", "	huang2	gan1	hei1	sou1",
		"黄冠草服", "	huang2	guan4	cao3	fu2",
		"黄冠草履", "	huang2	guan4	cao3	lv3",
		"栋折榱坏", "	dong4	she2	cui1	huai4",
		"黄雀伺蝉", "	huang2	que4	si4	chan2",
		"骈兴错出", "	pian2	xing1	cuo4	chu1",
		"戒奢宁俭", "	jie4	she1	ning4	jian1",
		"空腹便便", "	kong1	fu4	pian2	pian2",
		"借尸还阳", "	jie4	shi1	huan2	yang2",
		"还元返本", "	huan2	yuan2	fan3	ben3",
		"盛水不漏", "	cheng2	shui3	bu4	lou4",
		"长念却虑", "	chang2	nian4	que4	lv4",
		"分分秒秒", "	fen4	fen1	miao3	miao3",
		"长篇大论", "	chang2	pian1	da4	lun4",
		"翩翩公子", "	pian1	pian1	gong1	zi3",
		"毁钟为铎", "	hui3	zhong1	wei2	duo2",
		"镌脾琢肾", "	juan1	pi2	zhuo2	shen4",
		"看清形势", "	kan1	qing1	xing2	shi4",
		"溘然长往", "	ke4	ran2	chang2	wang3",
		"斗量筲计", "	dou3	liang2	shao1	ji4",
		"诘戎治兵", "	jie2	rong2	zhi4	bing1",
		"强人所难", "	qiang3	ren2	suo3	nan2",
		"深切著明", "	shen1	qie4	zhu4	ming2",
		"天长日久", "	tian1	chang2	ri4	jiu3",
		"江翻海倒", "	jiang1	fan1	hai3	dao3",
		"静影沉璧", "	jing	ying	chen	bi",
		"参商之虞", "	shen1	shang1	zhi1	yu2",
		"经验教训", "	jing1	yan4	jiao4	xun",
		"天人感应", "	tian1	ren2	gan3	ying4",
		"径行直遂", "	jing4	xing2	zhi2	sui2",
		"长绳系日", "	chang2	sheng2	ji4	ri4",
		"千载难逢", "	qian1	zai3	nan2	feng2",
		"鸟面鹄形", "	niao3	mian4	hu2	xing2",
		"身无长处", "	shen1	wu2	chang2	chu4",
		"返本还源", "	fan3	ben3	huan2	yuan2",
		"短叹长吁", "	duan3	tan4	chang2	xu1",
		"声应气求", "	sheng1	ying4	qi4	qiu2",
		"旁引曲证", "	pang2	yin3	qu3	zheng4",
		"度长絜短", "	du4	chang2	xie2	duan3",
		"沉谋重虑", "	chen2	mou2	chong2	lv4",
		"魂颠梦倒", "	hun2	dian1	meng4	dao3",
		"充分利用", "	chong1	fen4	li4	yong4",
		"江淹才尽", "	jiang1	yan1	cai2	jin4",
		"乘肥衣轻", "	cheng2	fei2	yi4	qing1",
		"斗方名士", "	dou3	fang1	ming2	shi4",
		"绝长继短", "	jue2	chang2	ji4	duan3",
		"倔头强脑", "	jue4	tou2	jiang4	nao3",
		"撅坑撅堑", "	jue2	keng1	jue2	qian4",
		"截长补短", "	jie2	chang2	bu3	duan3",
		"藉草枕块", "	jie4	cao3	zhen3	kuai4",
		"教猱升木", "	jiao1	nao2	sheng1	mu4",
		"称德度功", "	cheng1	de2	duo2	gong1",
		"成本会计", "	cheng2	ben3	kuai4	ji4",
		"绝长补短", "	jue2	chang2	bu3	duan3",
		"绝长续短", "	jue2	chang2	xu4	duan3",
		"山鸣谷应", "	shan1	ming2	gu3	ying4",
		"截铁斩钉", "	jie2	tie3	zhan3	ding4",
		"舍短取长", "	she3	duan3	qu3	chang2",
		"乘利席胜", "	cheng2	li4	xi2	sheng4",
		"长篇大套", "	chang2	pian1	da4	tao4",
		"活剥生吞", "	huo2	bao1	sheng1	tun1",
		"干扁豆角", "	gan1	bian3	dou4	jiao3",
		"昏镜重磨", "	hun1	jing4	chong2	mo2",
		"山行海宿", "	shan1	xing2	hai3	xiu3",
		"框架结构", "	kuang4	jia4	jie2	gou4",
		"撒豆成兵", "	sa3	dou4	cheng2	bing1",
		"狂风怒号", "	kuang2	feng1	nu4	hao2",
		"冲冠眦裂", "	chong1	guan4	zi4	lie4",
		"鹄形鸟面", "	hu2	xing2	niao3	mian4",
		"鹄峙鸾翔", "	hu2	zhi4	luan2	xiang2",
		"竭诚尽节", "	jie2	cheng2	jin4	jie2",
		"东山之志", "	dong1	shan1	zhi1	zhi4",
		"若崩厥角", "	ruo4	beng1	jue2	jiao3",
		"充分发展", "	chong1	fen4	fa1	zhan3",
		"房贷银行", "	fang2	dai4	yin2	hang2",
		"兜肚连肠", "	dou1	du3	lian2	chang2",
		"重关击柝", "	chong2	guan1	ji1	tuo4",
		"还年却老", "	huan2	nian2	que4	lao3",
		"什锦炒面", "	shi2	jin3	chao3	mian4",
		"三差两错", "	san1	cha1	liang3	cuo4",
		"重复使用", "	chong2	fu4	shi3	yong4",
		"三长四短", "	san1	chang2	si4	duan3",
		"坏裳为裤", "	huai4	shang	wei2	ku4",
		"杀出重围", "	sha1	chu1	chong2	wei2",
		"盘水加剑", "	pan	shui	jia	jian",
		"静电干扰", "	jing4	dian4	gan1	rao3",
		"长谈阔论", "	chang2	tan2	kuo4	lun4",
		"广寒仙子", "	guang3	han2	xian1	zi3",
		"长途车站", "	chang2	tu2	che1	zhan4",
		"大人先生", "	da4	ren2	xian1	sheng",
		"掂斤抹两", "	dian1	jin1	mo4	liang3",
		"户限为穿", "	hu4	xian4	wei2	chuan1",
		"高原反应", "	gao1	yuan2	fan3	ying4",
		"长途飞行", "	chang2	tu2	fei1	xing2",
		"神哗鬼叫", "	shen2	hua2	gui3	jiao4",
		"家道从容", "	jia1	dao4	cong1	rong2",
		"尽诚竭节", "	jin4	cheng2	jie2	jie2",
		"承销利差", "	cheng2	xiao1	li4	cha1",
		"颠乾倒坤", "	dian1	qian1	dao3	kun1",
		"甲冠天下", "	jia3	guan4	tian1	xia4",
		"好景不长", "	hao3	jing3	bu4	chang2",
		"挟势弄权", "	jia1	shi4	nong4	quan2",
		"奉子成婚", "	feng4	zi3	cheng2	hun1",
		"家长里短", "	jia1	chang2	li3	duan3",
		"津关险塞", "	jin1	guan1	xian3	sai4",
		"挟主行令", "	jia1	zhu3	xing2	ling4",
		"斗筲穿窬", "	dou3	shao1	chuan1	yu2",
		"龙楼凤阙", "	long2	lou2	feng4	que4",
		"龙兴凤举", "	long2	xing1	feng4	ju3",
		"间接经验", "	jian4	jie1	jing1	yan4",
		"颠倒衣裳", "	dian1	dao3	yi1	chang2",
		"啜菽饮水", "	chuo4	shu1	yin3	shui3",
		"倾肠倒肚", "	qing1	chang2	dao4	du3",
		"悄然无声", "	qiao3	ran2	wu2	sheng1",
		"掂梢折本", "	dian1	shao1	she2	ben3",
		"共为唇齿", "	gong4	wei2	chun2	chi3",
		"鸾凤和鸣", "	luan2	feng4	he4	ming2",
		"强食靡角", "	qiang3	shi2	mi2	jiao3",
		"当务始终", "	dang	wu	shi	zhong",
		"颠倒阴阳", "	dian1	dao3	yin1	yang2",
		"弹冠结绶", "	tan2	guan1	jie2	shou4",
		"颠颠倒倒", "	dian1	dian1	dao3	dao3",
		"顾虑重重", "	gu4	lv4	chong2	chong2",
		"党豺为虐", "	dang3	chai2	wei2	nue4",
		"梦撒撩丁", "	meng4	sa1	liao2	ding1",
		"猛将如云", "	meng3	jiang4	ru2	yun2",
		"强作解人", "	qiang3	zuo4	jie3	ren2",
		"电力供应", "	dian4	li4	gong1	ying4",
		"股票行情", "	gu3	piao4	hang2	qing2",
		"龙兴云属", "	long2	xing1	yun2	shu3",
		"旧雨重逢", "	jiu4	yu3	chong2	feng2",
		"年轻有为", "	nian2	qing1	you3	wei2",
		"能不称官", "	neng2	bu4	chen4	guan1",
		"发上指冠", "	fa4	shang4	zhi3	guan1",
		"翻黄倒皂", "	fan1	huang2	dao3	zao4",
		"锦囊还矢", "	jin3	nang2	huan2	shi3",
		"发植穿冠", "	fa4	zhi2	chuan1	guan1",
		"内部调整", "	nei4	bu4	tiao2	zheng3",
		"动态更新", "	dong4	tai4	geng1	xin1",
		"强嘴拗舌", "	jiang4	zui3	niu4	she2",
		"盛必虑衰", "	sheng4	bi4	lv4	shuai1",
		"捻土为香", "	nian3	tu3	wei2	xiang1",
		"动词重叠", "	dong4	ci2	chong2	die2",
		"长枕大被", "	chang2	zhen3	da4	bei4",
		"遁迹黄冠", "	dun4	ji4	huang2	guan4",
		"强嘴硬牙", "	jiang4	zui3	ying4	ya2",
		"顿足椎胸", "	dun4	zu2	zhui1	xiong1",
		"生理反应", "	sheng1	li3	fan3	ying4",
		"声求气应", "	sheng1	qiu2	qi4	ying4",
		"天长地久", "	tian1	chang2	di4	jiu3",
		"声势显赫", "	sheng1	shi4	xian3	he4",
		"发短心长", "	fa4	duan3	xin1	chang2",
		"侔色揣称", "	mou2	se4	chuai3	chen4",
		"参辰卯酉", "	shen1	chen2	mao3	you3",
		"强迫劳动", "	qiang3	po4	lao2	dong4",
		"车削加工", "	che1	xiao1	jia1	gong1",
		"袅袅娜娜", "	niao3	niao3	nuo2	nuo2",
		"皮相之见", "	pi2	xiang4	zhi1	jian4",
		"化学成分", "	hua4	xue2	cheng2	fen4",
		"命名系统", "	ming4	ming2	xi4	tong3",
		"竭忠尽智", "	jie2	zhong1	jin4	zhi4",
		"居轴处中", "	ju1	zhou2	chu3	zhong1",
		"焦唇干肺", "	jiao1	chun2	gan1	fei4",
		"急景凋年", "	ji2	ying3	diao1	nian2",
		"蛇鼠横行", "	she2	shu3	heng2	xing2",
		"非分之想", "	fei1	fen4	zhi1	xiang3",
		"卷甲衔枚", "	juan4	jia3	xian2	mei2",
		"卷甲束兵", "	juan4	jia3	shu4	bing1",
		"吵吵闹闹", "	chao1	chao	nao4	nao4",
		"长枕大衾", "	chang2	zhen3	da4	qin1",
		"极限量规", "	ji2	xian4	liang2	gui1",
		"汇丰银行", "	hui4	feng1	yin2	hang2",
		"舌咽神经", "	she2	yan1	shen2	jing1",
		"竭智尽忠", "	jie2	zhi4	jin4	zhong1",
		"长斋绣佛", "	chang2	zhai1	xiu4	fo2",
		"电子空间", "	dian4	zi3	kong1	jian1",
		"翻江倒海", "	fan1	jiang1	dao3	hai3",
		"长篇累牍", "	chang2	pian1	lei3	du2",
		"率土宅心", "	shuai4	tu3	zhai2	xin1",
		"盈千累万", "	ying2	qian1	lei3	wan4",
		"缠绵蕴藉", "	chan2	mian2	yun4	jie4",
		"搀行夺市", "	chan1	hang2	duo2	shi4",
		"层见错出", "	ceng2	xian4	cuo4	chu1",
		"勇冠三军", "	yong3	guan4	san1	jun1",
		"沧浪老人", "	cang1	lang2	lao3	ren2",
		"竖子成名", "	shu4	zi3	cheng2	ming2",
		"应变无方", "	ying4	bian4	wu2	fang1",
		"残军败将", "	can2	jun1	bai4	jiang4",
		"钻天觅缝", "	zuan4	tian1	mi4	feng2",
		"束椽为柱", "	shu4	chuan2	wei2	zhu4",
		"天长地老", "	tian1	chang2	di4	lao3",
		"泊船瓜洲", "	bo2	chuan2	gua1	zhou1",
		"苦难深重", "	ku3	nan4	shen1	zhong4",
		"银行存款", "	yin2	hang2	cun2	kuan3",
		"朝鲜半岛", "	chao2	xian3	ban4	dao3",
		"转嗔为喜", "	zhuan3	chen1	wei2	xi3",
		"陂湖禀量", "	bei1	hu2	bing3	liang2",
		"长才短驭", "	chang2	cai2	duan3	yu4",
		"数白论黄", "	shu3	bai2	lun4	huang2",
		"有三有俩", "	you3	san1	you3	liang3",
		"用其所长", "	yong4	qi2	suo3	chang2",
		"友好相处", "	you3	hao3	xiang1	chu3",
		"二重下标", "	er4	chong2	xia4	biao1",
		"深源地震", "	shen1	yuan2	di4	zhen4",
		"薪尽火传", "	xin1	jin4	huo3	chuan2",
		"饮水啜菽", "	yin3	shui3	chuo4	shu1",
		"钻洞觅缝", "	zuan4	dong4	mi4	feng2",
		"蓝田种玉", "	lan2	tian2	zhong4	yu4",
		"双柑斗酒", "	shuai4	gan1	dou3	jiu3",
		"油炸圈饼", "	you2	zha2	quan1	bing3",
		"长材茂学", "	chang2	cai2	mao4	xue2",
		"长驾远驭", "	chang2	jia4	yuan3	yu4",
		"应用化学", "	ying4	yong4	hua4	xue2",
		"万古长青", "	wan4	gu3	chang2	qing1",
		"洋场恶少", "	yang2	chang3	e4	shao4",
		"万应灵丹", "	wan4	ying4	ling2	dan1",
		"应时对景", "	ying4	shi2	dui4	jing3",
		"长春不老", "	chang2	chun2	bu4	lao3",
		"收拾收拾", "	shou1	shi	shou1	shi",
		"烧香拜佛", "	shao1	xiang1	bai4	fo2",
		"切片检查", "	qie1	pian4	jian3	cha2",
		"拳头产品", "	quan2	tou	chan3	pin3",
		"银行贷款", "	yin2	hang2	dai4	kuan3",
		"挑灯夜战", "	tiao3	deng1	ye4	zhan4",
		"水刑逼供", "	shui3	xing2	bi1	gong4",
		"朝鲜海峡", "	chao2	xian3	hai3	xia2",
		"温室效应", "	wen1	shi4	xiao4	ying4",
		"弹空说嘴", "	tan2	kong1	shuo1	zui3",
		"兵不由将", "	bing1	bu4	you2	jiang4",
		"人种差别", "	ren2	zhong3	cha1	bie2",
		"银行汇票", "	yin2	hang2	hui4	piao4",
		"转辗反侧", "	zhuan3	zhan3	fan3	ce4",
		"挑战者号", "	tiao3	zhan4	zhe3	hao4",
		"民穷财尽", "	min2	qiong2	cai2	jin4",
		"摽梅之年", "	biao4	men2	zhi1	nian2",
		"火烧火燎", "	huo3	shao1	huo3	liao3",
		"弹冠振衿", "	tan2	guan1	zhen4	jin1",
		"辩证逻辑", "	bian4	zheng4	luo2	ji",
		"炎性反应", "	yan2	xing4	fan3	ying4",
		"损军折将", "	sun3	jun1	zhe2	jiang4",
		"膀胱气化", "	pang2	guang1	qi4	hua4",
		"屏气凝神", "	bing3	qi4	ning2	shen2",
		"摒弃前嫌", "	bing4	qi4	qian2	xian2",
		"谈言微中", "	tan2	yan2	wei1	zhong4",
		"白衣卿相", "	bai2	yi1	qing1	xiang4",
		"事后聪明", "	shi4	hou4	cong1	ming",
		"转愁为喜", "	zhuan3	chou2	wei2	xi3",
		"杠杆收购", "	gang4	gan3	shou1	gou4",
		"著作等身", "	zhu4	zuo4	deng3	shen1",
		"逾墙钻穴", "	yu2	qiang2	zuan4	xue2",
		"歪打正着", "	wai1	da3	zheng4	zhao2",
		"蟏蛸满室", "	xiao1	shao1	man3	shi4",
		"特种警察", "	te4	zhong4	jing3	cha2",
		"杼柚之空", "	zhu4	zhou2	zhi1	kong1",
		"褎然冠首", "	you4	ran2	guan4	shou3",
		"白手兴家", "	bai2	shou3	xing1	jia1",
		"白首为郎", "	bai2	shou3	wei2	lang2",
		"百兽率舞", "	bai3	shou4	shuai4	wu3",
		"伴食宰相", "	ban4	shi2	zai3	xiang4",
		"松松散散", "	song1	song1	san3	san3",
		"鼻孔撩天", "	bi2	kong3	liao2	tian1",
		"人行横道", "	ren2	xing2	heng2	dao4",
		"水浒后传", "	shui3	hu3	hou4	zhuan4",
		"薮中荆曲", "	sou3	zhong1	jing1	qu3",
		"不遑宁处", "	bu4	huang2	ning2	chu3",
		"不良反应", "	bu4	liang2	fan3	ying4",
		"长夜难明", "	chang2	ye4	nan2	ming2",
		"鬼使神差", "	gui3	shi3	shen2	chai1",
		"调频电台", "	tiao2	pin2	dian4	tai2",
		"诱掖奖劝", "	you4	ye4	jiang3	quan4",
		"行侠仗义", "	xing4	xia2	zhang4	yi4",
		"挑牙料唇", "	tiao3	ya2	liao4	chun2",
		"拔山扛鼎", "	ba2	shan1	gang1	ding3",
		"龙生九子", "	long2	sheng1	jiu3	zi3",
		"铢两悉称", "	zhu1	liang3	xi1	chen4",
		"鱼与熊掌", "	yu2	yu3	xiong2	zhang3",
		"兴妖作怪", "	xing1	yao1	zuo4	guai4",
		"朝阳产业", "	zhao1	yang2	chan3	ye4",
		"兴奋高潮", "	xing1	fen4	gao1	chao2",
		"高高兴兴", "	gao1	gao1	xing4	xing1",
		"公诸同好", "	gong1	zhu1	tong2	hao4",
		"终焉之志", "	zhong1	yan1	zhi1	zhi4",
		"高空弹跳", "	gao1	kong1	tan2	tiao4",
		"外公切线", "	wai4	gong1	qie1	xian4",
		"众怨之的", "	zhong4	yuan4	zhi1	di4",
		"臭味相投", "	xiu4	wei4	xiang1	tou2",
		"插不上手", "	cha1	bu	shang4	shou3",
		"白发千丈", "	bai2	fa4	qian1	zhang4",
		"意味深长", "	yi4	wei4	shen1	chang2",
		"调养身体", "	tiao2	yang3	shen1	ti3",
		"一字长城", "	yi1	zi4	chang2	cheng2",
		"牵羊担酒", "	qian1	yang2	dan4	jiu3",
		"败军之将", "	bai4	jun1	zhi1	jiang4",
		"调朱弄粉", "	tiao2	zhu1	nong4	fen3",
		"切中要害", "	qie1	zhong1	yao4	hai4",
		"调脂弄粉", "	tiao2	zhi1	nong4	fen3",
		"卫满朝鲜", "	wei4	man3	chao2	xian3",
		"援助之手", "	yuan2	zhu4	zhi1	shou3",
		"暗箭中人", "	an4	jian4	zhong4	ren2",
		"了如指掌", "	liao3	ru2	zhi3	zhang3",
		"调风变俗", "	tiao2	feng1	bian4	su2",
		"著述等身", "	zhu4	shu4	deng3	shen1",
		"天下为公", "	tian1	xia4	wei2	gong1",
		"主要成分", "	zhu3	yao4	cheng2	fen4",
		"卫氏朝鲜", "	wei4	shi4	chao2	xian3",
		"狼狈为奸", "	lang2	bei4	wei2	jian1",
		"了却此生", "	liao3	que4	ci3	sheng1",
		"天下为笼", "	tian1	xia4	wei2	long2",
		"筑坛拜将", "	zhu4	tan2	bai4	jiang4",
		"自奉甚俭", "	zi4	feng4	shen4	jian3",
		"中间部分", "	zhong1	jian1	bu4	fen",
		"招降纳叛", "	zhao1	xiang2	na4	pan4",
		"钻山塞海", "	zuan4	shan1	sai1	hai3",
		"当世之冠", "	dang1	shi4	zhi1	guan4",
		"黄埔军校", "	huang2	pu3	jun1	xiao4",
		"麟角凤觜", "	lin2	jiao3	feng4	zui3",
		"衣锦还乡", "	yi4	jin3	huan2	xiang1",
		"天道好还", "	tian1	dao4	hao3	huan2",
		"占风望气", "	zhan1	feng1	wang4	qi4",
		"挂在嘴上", "	gua4	zai	zui3	shang",
		"水果罐头", "	shui3	guo3	guan4	tou2",
		"裁长补短", "	cai2	chang2	bu3	duan3",
		"黑汗王朝", "	hei1	han2	wang2	chao2",
		"钻坚研微", "	zuan4	jian1	yan2	wei1",
		"不胜杯杓", "	bu4	sheng4	bei1	shao2",
		"水宿风餐", "	shui3	xiu3	feng1	can1",
		"沉没成本", "	chen2	mo4	cheng2	ben3",
		"解发佯狂", "	jie3	fa4	yang2	kuang2",
		"着着失败", "	zhuo2	zhuo2	shi1	bai4",
		"不甚了了", "	bu4	shen4	liao3	liao3",
		"招揽生意", "	zhao1	lan3	sheng1	yi",
		"止咳糖浆", "	zhi3	ke2	tang2	jiang1",
		"痛自创艾", "	tong4	zi4	chuang1	yi4",
		"公共关系", "	gong1	gong4	guan1	xi4",
		"令人兴奋", "	ling4	ren2	xing1	fen4",
		"公共开支", "	gong1	gong4	kai1	zhi1",
		"见闻有限", "	jian4	wen2	you3	xian4",
		"重铬酸钾", "	chong2	ge4	suan1	jia3",
		"公共设施", "	gong1	gong4	she4	shi1",
		"逾墙钻蠙", "	yu2	qiang2	zuan4	pin2",
		"高村正彦", "	gao1	cun1	zheng1	yan4",
		"调嘴调舌", "	tiao2	zui3	diao4	she2",
		"鸾飘凤泊", "	luan2	piao1	feng4	bo2",
		"调嘴弄舌", "	tiao2	zui3	nong4	she2",
		"鼎铛玉石", "	ding3	cheng1	yu4	shi2",
		"铁板钉钉", "	tie3	ban3	ding4	ding1",
		"安常守分", "	an1	chang2	shou3	fen4",
		"恫瘝在抱", "	tong1	guan1	zai4	bao4",
		"安常处顺", "	an1	chang2	chu3	shun4",
		"铢量寸度", "	zhu1	liang2	cun4	duo2",
		"矮人观场", "	ai3	ren2	guan1	chang2",
		"同恶相助", "	tong2	wu4	xiang1	zhu4",
		"下旋削球", "	xia4	xuan2	xiao1	qiu2",
		"天地长久", "	tian1	di4	chang2	jiu3",
		"公共团体", "	gong1	gong4	tuan2	ti3",
		"识明智审", "	shi2	ming2	zhi4	shen3",
		"惟肖惟妙", "	wei2	xiao1	wei2	miao4",
		"翻箱倒箧", "	fan1	xiang1	dao3	qie4",
		"智穷才尽", "	zhi4	qiong2	cai2	jin4",
		"真相大白", "	zhen1	xiang4	da4	bai2",
		"眼不转睛", "	yan3	bu4	zhuan4	jing1",
		"月落参横", "	yue4	luo4	shen1	heng2",
		"质量要求", "	zhi4	liang4	yao1	qiu2",
		"支链反应", "	zhi1	lian4	fan3	ying4",
		"止咳平喘", "	zhi3	ke2	ping2	chuan3",
		"先王之乐", "	xian1	wang2	zhi1	yue4",
		"聪明过头", "	cong1	ming	guo4	tou2",
		"月经失调", "	yue4	jing1	shi1	tiao2",
		"音乐光碟", "	yin1	yue4	guang1	die2",
		"腰椎间盘", "	yao1	zhui1	jian1	pan2",
		"雨顺风调", "	yu3	shun4	feng1	tiao2",
		"刓方为圆", "	shu1	fang1	wei2	yuan2",
		"万古长春", "	wan4	gu3	chang2	chun1",
		"尽释前嫌", "	jin4	shi4	qian2	xian2",
		"万箭攒心", "	wan4	jian4	cuan2	xin1",
		"风调雨顺", "	feng1	tiao2	yu3	shun4",
		"凶相毕露", "	xiong1	xiang4	bi4	lu4",
		"衣轻乘肥", "	yi4	qing1	cheng2	fei2",
		"占风使帆", "	zhan1	feng1	shi3	fan1",
		"相依为命", "	xiang1	yi1	wei2	ming4",
		"宿水餐风", "	xiu3	shui3	can1	feng1",
		"红泥月亮", "	hong2	ni2	yue4	liang",
		"郢书燕说", "	ying3	shu1	yan1	shuo1",
		"兴妖作乱", "	xing1	yao1	zuo4	luan4",
		"饶舌调唇", "	rao2	she2	tiao2	chun2",
		"数黄道黑", "	shu	huang	dao	hei",
		"云集响应", "	yun2	ji2	xiang3	ying4",
		"置水之情", "	zhi4	shui3	zhi1	qing2",
		"相向突击", "	xiang1	xiang4	tu1	ji1",
		"青年旅舍", "	qing1	nian2	lu:3	she4",
		"委曲成全", "	wei3	qu3	cheng2	quan2",
		"为人正直", "	wei2	ren2	zheng4	zhi2",
		"光阴似箭", "	guang1	yin1	si4	jian4",
		"相对位置", "	xiang1	dui4	wei4	zhi",
		"语境效应", "	yu3	jing4	xiao4	ying4",
		"鸢肩鹄颈", "	yuan1	jian1	hu2	jing3",
		"青藏公路", "	qing1	zang4	gong1	lu4",
		"直接了当", "	zhi2	jie1	liao3	dang4",
		"万头攒动", "	wan4	tou2	cuan2	dong4",
		"两肋插刀", "	liang3	lei4	cha1	dao1",
		"形只影单", "	xing2	zhi1	ying3	dan1",
		"一长半短", "	yi1	chang2	ban4	duan3",
		"间谍活动", "	jian4	die2	huo2	dong4",
		"神差鬼使", "	shen2	chai1	gui3	shi3",
		"真命天子", "	zhen1	ming4	tian1	zi3",
		"神魂颠倒", "	shen2	hun2	dian1	dao3",
		"位置效应", "	wei4	zhi4	xiao4	ying4",
		"真龙天子", "	zhen1	long2	tian1	zi3",
		"间接证据", "	jian4	jie1	zheng4	ju4",
		"贞观之治", "	zhen1	guan1	zhi1	zhi4",
		"折长补短", "	zhe2	chang2	bu3	duan3",
		"正冠李下", "	zheng4	guan4	li3	xia4",
		"长途电话", "	chang2	tu2	dian4	hua4",
		"间歇训练", "	jian4	xie1	xun4	lian4",
		"充分考虑", "	chong1	fen4	kao3	lu:4",
		"超敏反应", "	chao1	min3	fan3	ying4",
		"似曾相识", "	si4	ceng2	xiang1	shi2",
		"翻箱倒柜", "	fan1	xiang1	dao3	gui4",
		"调研人员", "	tiao2	yan2	ren2	yuan2",
		"伴随效应", "	ban4	sui2	xiao4	ying4",
		"车载斗量", "	che1	zai4	dou3	liang2",
		"蒸沙为饭", "	zheng1	sha1	wei2	fan4",
		"音乐之声", "	yin1	yue4	zhi1	sheng1",
		"访问方式", "	fang3	wen4	fang1	shi4",
		"两性差距", "	liang3	xing4	cha1	ju4",
		"直截了当", "	zhi2	jie2	liao3	dang4",
		"枉口嚼舌", "	wang3	kou3	jiao2	she2",
		"头晕脑涨", "	tou2	yun1	nao3	zhang4",
		"汪洋闳肆", "	wang1	yang2	hong2	si4",
		"望子成才", "	wang4	zi3	cheng2	cai2",
		"头昏脑涨", "	tou2	hun1	nao3	zhang4",
		"预防接种", "	yu4	fang2	jie1	zhong4",
		"直捷了当", "	zhi2	jie2	liao3	dang4",
		"正式合同", "	zheng4	shi4	he2	tong",
		"两侧对称", "	liang3	ce4	dui4	chen4",
		"数见不鲜", "	shuo4	jian4	bu4	xian1",
		"置换反应", "	zhi4	huan4	fan3	ying4",
		"调和振动", "	tiao2	he2	zhen4	dong4",
		"似鸟恐龙", "	si4	niao3	kong3	long2",
		"应用系统", "	ying4	yong4	xi4	tong3",
		"五陵年少", "	wu3	ling2	nian2	shao4",
		"执鞭随蹬", "	zhi2	bian1	sui2	deng4",
		"阿甘正传", "	a	gan1	zheng4	zhuan4",
		"战争贩子", "	zhan4	zheng1	fan4	zi3",
		"行政干预", "	xing2	zheng4	gan1	yu4",
		"遥相呼应", "	yao2	xiang1	hu1	ying4",
		"朝乾夕愓", "	zhao1	qian2	xi1	dang4",
		"长辔远驭", "	chang2	pei4	yuan3	yu4",
		"更有甚者", "	geng4	you3	shen4	zhe3",
		"长袖善舞", "	chang2	xiu4	shan4	wu3",
		"科学种田", "	ke1	xue2	zhong4	tian2",
		"一鞭先著", "	yi1	bian1	xian1	zhuo2",
		"长生不死", "	chang2	sheng1	bu1	si3",
		"辗转反侧", "	zhan3	zhuan3	fan3	ce4",
		"斗转星移", "	dou3	zhuan3	xing1	yi2",
		"夜静更深", "	ye4	jing4	geng1	shen1",
		"倒海翻江", "	dao3	hai3	fan1	jiang1",
		"朝夕相处", "	zhao1	xi1	xiang1	chu3",
		"长乐公主", "	chang2	le4	gong1	zhu3",
		"先我着鞭", "	xian1	wo3	zhuo2	bian1",
		"闲言长语", "	xian2	yan2	chang2	yu3",
		"长期饭票", "	chang2	qi1	fan4	piao4",
		"长期共存", "	chang2	qi1	gong4	cun2",
		"更新换代", "	geng1	xin1	huan4	dai4",
		"相时而动", "	xiang4	shi2	er2	dong4",
		"数黑论黄", "	shu3	hei1	lun4	huang2",
		"羊肠九曲", "	yang2	chang2	jiu3	qu3",
		"长乐未央", "	chang2	le4	wei4	yang1",
		"心长发短", "	xin1	chang2	fa4	duan3",
		"摇头晃脑", "	yao2	tou2	huang4	nao3",
		"小子后生", "	xiao3	zi3	hou4	sheng1",
		"长命富贵", "	chang2	ming4	fu4	gui4",
		"长吁短叹", "	chang2	xu1	duan3	tan4",
		"朝梁暮晋", "	zhao1	liang2	mu4	jin4",
		"转浑天仪", "	zhuan4	hun2	tian1	yi2",
		"中箭落马", "	zhong4	jian4	luo4	ma3",
		"转弯抹角", "	zhuan3	wan1	mo4	jiao3",
		"管弦乐队", "	guan3	xian2	yue4	dui4",
		"心长力短", "	xin1	chang2	li4	duan3",
		"铁血宰相", "	tie3	xue4	zai3	xiang4",
		"朝穿暮塞", "	zhao1	chuan1	mu4	sai1",
		"遥呼相应", "	yao2	hu1	xiang1	ying4",
		"咬钉嚼铁", "	yao3	ding1	jiao2	tie3",
		"朝成夕毁", "	zhao1	cheng2	xi1	hui3",
		"镜框舞台", "	jing4	kuang4	wu3	tai2",
		"返老还童", "	fan3	lao3	huan2	tong2",
		"链式反应", "	lian4	shi4	fan3	ying4",
		"铺张浪费", "	pu1	zhang1	lang4	fei4",
		"夜长梦多", "	ye4	chang2	meng4	duo1",
		"兆载永劫", "	zhao4	zai3	yong3	jie2",
		"燕石妄珍", "	yan1	shi2	wang4	zhen1",
		"保角对应", "	bao3	jiao3	dui4	ying4",
		"重文轻武", "	chong2	wen2	qing1	wu3",
		"退耕还林", "	tui4	geng1	huan2	lin2",
		"曾参杀人", "	zeng1	shen1	sha1	ren2",
		"悬梁自尽", "	xuan2	liang2	zi4	jin4",
		"朝成暮毁", "	zhao1	cheng2	mu4	hui3",
		"逐行扫描", "	zhu2	hang2	sao3	miao2",
		"金融杠杆", "	jin1	rong2	gang4	gan3",
		"金帐汗国", "	jin1	zhang4	han2	guo2",
		"连锁反应", "	lian2	suo3	fan3	ying4",
		"酒精中毒", "	jiu3	jing1	zhong4	du2",
		"精尽人亡", "	jing1	jin4	ren2	wang2",
		"游手好闲", "	you2	shou3	hao4	xian2",
		"言为心声", "	yan2	wei2	xin1	sheng1",
		"揎拳捋袖", "	xuan1	quan2	luo1	xiu4",
		"网路应用", "	wang3	lu4	ying4	yong4",
		"星移斗转", "	xing1	yi2	dou3	zhuan3",
		"侵权行为", "	qin1	quan2	xing2	wei2",
		"行政处罚", "	xing2	zheng4	chu3	fa2",
		"斩将夺旗", "	zhan3	jiang4	duo2	qi2",
		"斩钉切铁", "	zhan3	ding1	qie1	tie3",
		"返还占有", "	fan3	huan2	zhan4	you3",
		"压电效应", "	ya1	dian4	xiao4	ying4",
		"金蝉脱壳", "	jin1	chan2	tuo1	qiao4",
		"轩轩甚得", "	xuan1	xuan1	shen4	de2",
		"延颈跂踵", "	yan2	jing3	qi3	zhong3",
		"来日方长", "	lai2	ri4	fang1	chang2",
		"重新开始", "	chong2	xin1	kai1	shi3",
		"重新造林", "	chong2	xin1	zao4	lin2",
		"使徒行传", "	shi3	tu2	xing2	zhuan4",
		"重新统一", "	chong2	xin1	tong3	yi1",
		"重新启动", "	chong2	xin1	qi3	dong4",
		"重修旧好", "	chong2	xiu1	jiu4	hao3",
		"压良为贱", "	ya1	liang2	wei2	jian4",
		"璇霄丹阙", "	xuan2	xiao1	dan1	que4",
		"重新做人", "	chong2	xin1	zuo4	ren2",
		"重整旗鼓", "	chong2	zheng3	qi2	gu3",
		"经年累月", "	jing1	nian2	lei3	yue4",
		"乍暖还寒", "	zha4	nuan3	huan2	han2",
		"细水长流", "	xi4	shui3	chang2	liu2",
		"乡村音乐", "	xiang1	cun1	yin1	yue4",
		"重庆大学", "	chong2	qing4	da4	xue2",
		"豁然贯通", "	huo4	ran2	guan4	tong1",
		"斗量车载", "	dou3	liang2	che1	zai4",
		"经济力量", "	jing1	ji4	li4	liang",
		"长绳系景", "	chang2	sheng2	xi4	jing3",
		"短中取长", "	duan3	zhong1	qu3	chang2",
		"话长说短", "	hua4	chang2	shuo1	duan3",
		"生拉硬拽", "	sheng1	la1	ying4	zhuai4",
		"深中肯綮", "	shen1	zhong1	ken3	qing4",
		"坑绷拐骗", "	keng1	beng1	guai3	pian4",
		"质量效应", "	zhi4	liang4	xiao4	ying4",
		"众星攒月", "	zhong4	xing1	cuan2	yue4",
		"冲动行为", "	chong1	dong4	xing2	wei2",
		"神霄绛阙", "	shen2	xiao1	jiang4	que4",
		"自坏长城", "	zi4	huai4	chang2	cheng2",
		"兢兢乾乾", "	jing1	jing1	qian2	qian2",
		"外强中干", "	wai4	qiang2	zhong1	gan1",
		"逞性妄为", "	cheng3	xing4	wang4	wei2",
		"参横斗转", "	shen1	heng2	dou3	zhuan3",
		"双重国籍", "	shuang1	chong2	guo2	ji2",
		"双重人格", "	shuang1	chong2	ren2	ge2",
		"成为笑柄", "	cheng2	wei2	xiao4	bing3",
		"转败为成", "	zhuan3	bai4	wei2	cheng2",
		"创巨痛深", "	chuang1	ju4	tong4	shen1",
		"纸短情长", "	zhi3	duan3	qing2	chang2",
		"乘胜逐北", "	cheng2	sheng4	zhu2	bei3",
		"下风方向", "	xia4	feng1	fang1	xiang4",
		"水穷山尽", "	shui3	qiong2	shan1	jin4",
		"说短论长", "	shuo1	duan3	lun4	chang2",
		"率由旧章", "	shuai4	you2	jiu4	zhang1",
		"少成若性", "	shao4	cheng2	ruo4	xing4",
		"长往远引", "	chang2	wang3	yuan3	yin3",
		"长线产品", "	chang2	xian4	chan3	pin3",
		"持枪抢劫", "	chi2	qiang1	qiang1	jie2",
		"正中要害", "	zheng4	zhong4	yao4	hai4",
		"沉着痛快", "	chen2	zhuo2	tong4	kuai4",
		"产生偏差", "	chan3	sheng1	pian1	cha1",
		"众啄同音", "	zhong4	zhou4	tong2	yin1",
		"侜张为幻", "	zhou1	zhang1	wei2	huan4",
		"铢称寸量", "	zhu1	cheng1	cun4	liang2",
		"鞭长驾远", "	bian1	chang2	jia4	yuan3",
		"重光累洽", "	chong2	guang1	lei4	qia4",
		"水尽山穷", "	shui3	jin4	shan1	qiong2",
		"将门有将", "	jiang4	men2	you3	jiang4",
		"源远流长", "	yuan2	yuan3	liu2	chang2",
		"霜行草宿", "	shuang1	xing2	cao3	xiu3",
		"拽巷啰街", "	zhuai4	xiang4	luo2	jie1",
		"正当防卫", "	zheng4	dang4	fang2	wei4",
		"强颜欢笑", "	qiang3	yan2	huan1	xiao4",
		"恒生银行", "	heng2	sheng1	yin2	hang2",
		"说长道短", "	shuo1	chang2	dao4	duan3",
		"对证命名", "	dui4	zheng4	ming4	ming2",
		"心手相应", "	xin1	shou3	xiang1	ying4",
		"旋转乾坤", "	xuan2	zhuan3	qian2	kun1",
		"兴师动众", "	xing1	shi1	dong4	zhong4",
		"双栖双宿", "	shuang1	qi1	shuang1	su4",
		"板上钉钉", "	ban3	shang4	ding4	ding1",
		"当轴处中", "	dang1	zhou2	chu3	zhong1",
		"官方网站", "	guan1	fang1	wang3	zhan4",
		"史传小说", "	shi3	zhuan4	xiao3	shuo1",
		"说岳全传", "	shuo1	yue4	quan2	zhuan4",
		"寸善片长", "	cun4	shan4	pian4	chang2",
		"行险侥幸", "	xing2	xian3	jiao3	xing4",
		"量身定制", "	liang2	shen1	ding4	zhi4",
		"明窗净几", "	ming2	chuang1	jing4	ji1",
		"长山山脉", "	chang2	shan1	shan1	mai4",
		"姓甚名谁", "	xing4	shen4	ming2	shui2",
		"龙荒蛮甸", "	long2	huang1	man2	dian4",
		"旧景重现", "	jiu4	jing3	chong2	xian4",
		"锥处囊中", "	zhui1	chu3	nang2	zhong1",
		"草率收兵", "	cao3	shuai4	shou1	bing1",
		"穷愁潦倒", "	qiong2	chou2	liao2	dao3",
		"瞬态响应", "	shun4	tai4	xiang3	ying4",
		"横抢硬夺", "	heng4	qiang3	ying4	duo2",
		"洞中肯綮", "	dong4	zhong1	ken3	qing4",
		"晃晃悠悠", "	huang4	huang3	you1	you1",
		"论长说短", "	lun4	chang2	shuo1	duan3",
		"五行相生", "	wu3	hang2	xiang1	sheng1",
		"漂蓬断梗", "	piao1	peng2	duan4	geng3",
		"少年老成", "	shao4	nian2	lao3	cheng2",
		"翩翩少年", "	pian1	pian1	shao4	nian2",
		"汹涌澎湃", "	xiong1	yong3	peng2	pai4",
		"微创手术", "	wei1	chuang1	shou3	shu4",
		"言归正传", "	yan2	gui1	zheng4	zhuan4",
		"亲水长廊", "	qin1	shui3	chang2	lang2",
		"长生久视", "	chang2	sheng1	jiu3	shi4",
		"营养成分", "	ying2	yang3	cheng2	fen4",
		"长江三峡", "	chang2	jiang1	san1	xia2",
		"长话短说", "	chang2	hua4	duan3	shuo1",
		"嫌长道短", "	xian2	chang2	dao4	duan3",
		"说短道长", "	shuo1	duan3	dao4	chang2",
		"说长论短", "	shuo1	chang2	lun4	duan3",
		"山穷水尽", "	shan1	qiong2	shui3	jin4",
		"养虺成蛇", "	yang3	hui3	cheng2	she2",
		"长远目标", "	chang2	yuan3	mu4	biao1",
		"浓抹淡妆", "	nong2	mo4	dan4	zhuang1",
		"斜行横阵", "	xie2	xing2	heng2	zhen4",
		"迎接挑战", "	ying2	jie1	tiao3	zhan4",
		"化整为零", "	hua4	zheng3	wei2	ling2",
		"不明真相", "	bu4	ming2	zhen1	xiang4",
		"小时了了", "	xiao3	shi2	liao3	liao3",
		"详星拜斗", "	xiang2	xing1	bai4	dou3",
		"参回斗转", "	shen1	hui2	dou3	zhuan3",
		"多言数穷", "	duo1	yan2	shuo4	qiong2",
		"雕肝琢肾", "	diao1	gan1	zhuo2	shen4",
		"顺人应天", "	shun4	ren2	ying4	tian1",
		"适应环境", "	shi4	ying4	huan2	jing4",
		"长命百岁", "	chang2	ming4	bai3	sui4",
		"师直为壮", "	shi1	zhi2	wei2	zhuang4",
		"长林丰草", "	chang2	lin2	feng1	cao3",
		"博采众长", "	bo2	cai3	zhong4	chang2",
		"钟鸣漏尽", "	zhong1	ming2	lou4	jin4",
		"弃短用长", "	qi4	duan3	yong4	chang2",
		"扬长补短", "	yang2	chang2	bu3	duan3",
		"十载寒窗", "	shi2	zai3	han2	chuang1",
		"重温旧梦", "	chong2	wen1	jiu4	meng4",
		"蝉联冠军", "	chan2	lian2	guan4	jun1",
		"赌长较短", "	du3	chang2	jiao4	duan3",
		"长才广度", "	chang2	cai2	guang3	du4",
		"重碳酸盐", "	chong2	tan4	suan1	yan2",
		"蝉喘雷干", "	chan2	chuan3	lei2	gan1",
		"昼短夜长", "	zhou4	duan3	ye4	chang2",
		"测量元件", "	ce4	liang2	yuan2	jian4",
		"草率从事", "	cao3	shuai4	cong2	shi4",
		"悬石程书", "	xuan2	dan4	cheng2	shu1",
		"浓妆淡抹", "	nong2	zhuang1	dan4	mo4",
		"重碳酸钙", "	chong2	tan4	suan1	gai4",
		"虚晃一枪", "	xiu4	huang4	yi1	qiang1",
		"手足重茧", "	shou3	zu2	chong2	jian3",
		"长年累月", "	chang2	nian2	lei3	yue4",
		"晨昏定省", "	chen2	hun1	ding4	xing3",
		"深山长谷", "	shen1	shan1	chang2	gu3",
		"昏定晨省", "	hun1	ding4	chen2	xing3",
		"强迫观念", "	qiang3	po4	guan1	nian4",
		"长岛冰茶", "	chang2	dao3	bing1	cha2",
		"深仇宿怨", "	shen1	chou2	xiu3	yuan4",
		"鉴真和尚", "	jian4	zhen1	he2	shang",
		"中坚力量", "	zhong1	jian1	li4	liang",
		"书归正传", "	shu1	gui1	zheng4	zhuan4",
		"整躬率物", "	zheng3	gong1	shuai4	wu4",
		"振兴中华", "	zhen4	xing1	zhong1	hua2",
		"校短推长", "	xiao4	duan3	tui1	chang2",
		"沉着应战", "	chen2	zhuo2	ying4	zhan4",
		"首尾相应", "	shou3	wei3	xiang1	ying4",
		"长篇连载", "	chang2	pian1	lian2	zai3",
		"阆苑琼楼", "	lang4	yuan4	qiong2	lou2",
		"还乡昼锦", "	huan2	xiang1	zhou4	jin3",
		"昏镜重明", "	hun1	jing4	chong2	ming2",
		"重峦复嶂", "	chong2	luan2	fu4	zhang4",
		"长算远略", "	chang2	suan4	yuan3	lue4",
		"水中著盐", "	shui3	zhong1	zhuo2	yan2",
		"秤斤注两", "	cheng1	jin1	zhu4	liang3",
		"火耕水种", "	huo3	geng1	shui3	zhong4",
		"山长水阔", "	shan1	chang2	shui3	kuo4",
		"水中捉月", "	shui	zhong	zhuo	yue",
		"说长话短", "	shuo1	chang2	hua4	duan3",
		"山阴乘兴", "	shan1	yin1	cheng2	xing1",
		"长春新碱", "	chang2	chun1	xin1	jian3",
		"重建家园", "	chong2	jian4	jia1	yuan2",
		"遁世长往", "	dun4	shi4	chang2	wang3",
		"解弦更张", "	jie3	xian2	geng1	zhang1",
		"水宿山行", "	shui3	xiu3	shan1	xing2",
		"相去甚远", "	xiang1	qu4	shen4	yuan3",
		"日月重光", "	ri4	yue4	chong2	guang1",
		"逼良为娼", "	bi1	liang2	wei2	chang1",
		"事实真相", "	shi4	shi2	zhen1	xiang4",
		"进行性交", "	jin4	xing2	xing4	jiao1",
		"钻坚仰高", "	zuan4	jian1	yang3	gao1",
		"膀胱结石", "	pang2	guang1	jie2	shi2",
		"政治斗争", "	zheng4	zhi4	dou4	zheng1",
		"推广应用", "	tui1	guang3	ying4	yong4",
		"窗明几净", "	chuang1	ming2	ji1	jing4",
		"使羊将狼", "	shi3	yang2	jiang4	lang2",
		"正中己怀", "	zheng4	zhong4	ji3	huai2",
		"长颈鸟喙", "	chang2	jing3	niao3	hui4",
		"困难重重", "	kun4	nan2	chong2	chong2",
		"应用程式", "	ying4	yong4	cheng2	shi4",
		"朝阳鸣凤", "	zhao1	yang2	ming2	feng4",
		"中央银行", "	zhong1	yang1	yin2	hang2",
		"应用软件", "	ying4	yong4	ruan3	jian4",
		"改弦更张", "	gai3	xian2	geng1	zhang1",
		"彰明较著", "	zhang1	ming2	jiao4	zhu4",
		"重新评价", "	chong2	xin1	ping2	jia4",
		"重生爷娘", "	chong2	sheng1	ye2	niang2",
		"广文先生", "	guang3	wen2	xian1	sheng",
		"光电效应", "	guang1	dian4	xiao4	ying4",
		"调神畅情", "	tiao2	shen2	chang4	qing2",
		"正身率下", "	zheng4	shen1	shuai4	xia4",
		"山崩钟应", "	shan1	beng1	zhong1	ying4",
		"调停两用", "	tiao2	ting2	liang3	yong4",
		"争短论长", "	zheng1	duan3	lun4	chang2",
		"穷形尽相", "	qiong2	xing2	jin4	xiang4",
		"抢风航行", "	qiang1	feng1	hang2	xing2",
		"圣经外传", "	sheng4	jing1	wai4	zhuan4",
		"重新调整", "	chong2	xin1	tiao2	zheng3",
		"公共行政", "	gong1	gong4	xing2	zheng4",
		"算命先生", "	suan4	ming4	xian1	sheng",
		"笑脸相迎", "	xiao4	lian3	xiang4	ying2",
		"横行直撞", "	heng2	xing2	zhi2	zhuang4",
		"穿着讲究", "	chuan1	zhuo2	jiang3	jiu",
		"王侯将相", "	wang2	hou2	jiang4	xiang4",
		"逞娇呈美", "	cheng3	jiao1	cheng2	mei3",
		"蒙头转向", "	meng1	tou2	zhuan4	xiang4",
		"青灯黄卷", "	qing1	deng1	huang2	juan4",
		"堂皇冠冕", "	tang2	huang2	guan4	mian3",
		"率尔成章", "	shuai4	er3	cheng2	zhang1",
		"重新装修", "	chong2	xin1	zhuang1	xiu1",
		"庄严宝相", "	zhuang1	yan2	bao3	xiang4",
		"唱筹量沙", "	chang4	chou2	liang2	sha1",
		"胸中万卷", "	xiong1	zhong1	wan4	juan4",
		"兴衰成败", "	xing1	shuai1	cheng2	bai4",
		"盛衰兴废", "	sheng4	shuai1	xing1	fei4",
		"萍飘蓬转", "	ping2	piao1	peng2	zhuan4",
		"双足重茧", "	shuang1	zu2	chong2	jian3",
		"长盛不衰", "	chang2	sheng4	bu4	shuai1",
		"长亭短亭", "	chang2	ting2	duan3	ting2",
		"争长论短", "	zheng1	chang2	lun4	duan3",
		"赤诚相见", "	chi4	cheng2	xiang4	jian4",
		"兵多将广", "	bing1	duo1	jiang4	guang3",
		"黄卷青灯", "	huang2	juan4	qing1	deng1",
		"道长争短", "	dao4	chang2	zheng1	duan3",
		"防火长城", "	fang2	huo3	chang2	cheng2",
		"承平盛世", "	cheng2	ping2	sheng4	shi4",
		"黄钟长弃", "	huang2	zhong1	chang2	qi4",
		"转轮圣王", "	zhuan4	lun2	sheng4	wang2",
		"甚嚣尘上", "	shen4	xiao1	chen2	shang4",
		"壮发冲冠", "	zhuang4	fa1	chong1	guan4",
		"逞强好胜", "	cheng3	qiang2	hao4	sheng4",
		"拳脚相向", "	quan2	jiao3	xiang1	xiang4",
		"长江天堑", "	chang2	jiang1	tian1	qian4",
		"条条框框", "	tiao2	tiao2	kuang4	kuang4",
		"勉勉强强", "	mian3	mian3	qiang3	qiang2",
		"同声相应", "	tong2	sheng1	xiang1	ying4",
		"争强好胜", "	zheng1	qiang2	hao4	sheng4",
		"争长竞短", "	zheng1	chang2	jing4	duan3",
		"圣君贤相", "	sheng4	jing1	xian2	xiang4",
		"圣经贤传", "	sheng4	jing1	xian2	zhuan4",
		"山中宰相", "	shan1	zhong1	zai3	xiang4",
		"精兵强将", "	jing1	bing1	qiang2	jiang4",
		"竞短争长", "	jing4	duan3	zheng1	chang2",
		"正邪相争", "	zheng4	xie2	xiang1	zheng1",
		"校短量长", "	jiao4	duan3	liang2	chang2",
		"率尔操觚", "	shuai4	er3	cao1	gu1",
		"账房先生", "	zhang4	fang2	xian1	sheng",
		"短中抽长", "	duan3	zhong1	chou1	chang2",
		"长长短短", "	chang2	chang2	duan3	duan3",
		"中山狼传", "	zhong1	shan1	lang2	zhuan4",
		"上当受骗", "	shang4	dang4	shou4	pian4",
		"生肖属相", "	sheng1	xiao4	shu3	xiang4",
		"长城饭店", "	chang2	cheng2	fan4	dian4",
		"蒸气重整", "	zheng1	qi4	chong2	zheng3",
		"遣兵调将", "	qian3	bing1	diao4	jiang4",
		"山长水远", "	shan1	chang2	shui3	yuan3",
		"三长两短", "	san1	chang2	liang3	duan3",
		"车载船装", "	che1	zai3	chuan2	zhuang1",
		"铢两相称", "	zhu1	liang3	xiang1	chen4",
		"更长梦短", "	geng1	chang2	meng4	duan3",
		"着手成春", "	zhuo2	shou3	cheng2	chun1",
		"项背相望", "	xiang4	bei4	xiang1	wang4",
		"朝鲜战争", "	chao2	xian3	zhan4	zheng1",
		"敩学相长", "	zuan4	xue2	xiang1	chang2",
		"长篇小说", "	chang2	pian1	xiao3	shuo1",
		"善善从长", "	shan4	shan4	cong2	chang2",
		"乘风兴浪", "	cheng2	feng1	xing1	lang4",
		"扇枕温被", "	shan1	zhen3	wen1	chuang2",
		"说长说短", "	shuo1	chang2	shuo1	duan3",
		"长荣航空", "	chang2	rong2	hang2	kong1",
		"九转功成", "	jiu3	zhuan4	gong1	cheng2",
		"正中下怀", "	zheng4	zhong4	xia4	huai2",
		"调兵遣将", "	diao4	bing1	qian3	jiang4",
		"天兵天将", "	tian1	bing1	tian1	jiang4",
		"丧尽天良", "	sang4	jin4	tian1	liang2",
		"一长两短", "	yi1	chang2	liang3	duan3",
		"电动转盘", "	dian4	dong4	zhuan4	pan2",
		"寸长片善", "	cun4	chang2	pian4	shan4",
		"发上冲冠", "	fa4	shang4	chong1	guan1",
		"较长絜短", "	jiao4	chang2	xie2	duan3",
		"彰明昭着", "	zhang1	ming2	zhao1	zhe",
		"长虺成蛇", "	zhang3	hui3	cheng2	she2",
		"洋为中用", "	yang2	wei2	zhong1	yong4",
		"浩浩汤汤", "	hao4	hao4	shang1	shang1",
		"寸量铢称", "	cun4	liang2	zhu1	cheng1",
		"山峦重叠", "	shan1	luan2	chong2	die2",
		"乘胜追击", "	cheng2	sheng4	zhui1	ji1",
		"过关斩将", "	guo4	guan1	zhan3	jiang4",
		"还魂橡胶", "	huan2	hun2	xiang4	jiao1",
		"传为笑柄", "	chuan2	wei2	xiao4	bing3",
		"连中三元", "	lian2	zhong4	san1	yuan2",
		"彰明昭著", "	zhang1	ming2	zhao1	zhu4",
		"多口相声", "	duo1	kou3	xiang4	sheng",
		"雀屏中选", "	que4	ping2	zhong4	xuan3",
		"单口相声", "	dan1	kou3	xiang4	sheng",
		"相切相磋", "	xiang1	qie1	xiang1	cuo1",
		"公共零点", "	gong1	gong4	ling2	dian3",
		"降妖捉怪", "	xiang2	yao1	zhuo1	guai4",
		"山高水长", "	shan1	gao1	shui3	chang2",
		"干城之将", "	gan1	cheng2	zhi1	jiang4",
		"工商银行", "	gong1	shang1	yin2	hang2",
		"心长绠短", "	xin1	chang2	geng3	duan3",
		"梦想颠倒", "	meng4	xiang3	dian1	dao3",
		"心事重重", "	xin1	shi4	chong2	chong2",
		"面折庭争", "	mian4	she2	ting2	zheng1",
		"凤鸣朝阳", "	feng4	ming2	zhao1	yang2",
		"顶踵尽捐", "	ding3	zhong3	jin4	juan1",
		"膏粱年少", "	gao1	liang2	nian2	shao4",
		"交响乐团", "	jiao1	xiang3	yue4	tuan2",
		"香花供养", "	xiang1	hua1	gong4	yang3",
		"东方将白", "	dong	fang	jiang	bai",
		"鸣凤朝阳", "	ming2	feng4	zhao1	yang2",
		"长平之战", "	chang2	ping2	zhi1	zhan4",
		"宏观调控", "	hong2	guan1	tiao2	kong4",
		"相貌堂堂", "	xiang4	mao4	tang2	tang2",
		"相门有相", "	xiang4	men2	you3	xiang4",
		"东窗消息", "	dong1	chuang1	xiao1	xi",
		"仰天长叹", "	yang3	tian1	chang2	tan4",
		"轰动效应", "	hong1	dong4	xiao4	ying4",
		"兴兵动众", "	xing1	bing1	dong4	zhong4",
		"滚滚长江", "	gun3	gun3	chang2	jiang1",
		"反正还淳", "	fan3	zheng4	huan2	chun2",
		"运动健将", "	yun4	dong4	jian4	jiang4",
		"羊瘙痒症", "	yang2	sao4	yang3	zheng4",
		"旋乾转坤", "	xuan2	qian2	zhuan3	kun1",
		"响应时间", "	xiang3	ying4	shi2	jian1",
		"受到影响", "	shou4	dao4	ying3	xiang3",
		"正宫娘娘", "	zheng1	gong1	niang2	niang2",
		"晕头转向", "	yun1	tou2	zhuan4	xiang4",
		"造谣中伤", "	zao4	yao2	zhong4	shang1",
		"方领圆冠", "	fang1	ling3	yuan2	guan4",
		"斗转参横", "	dou3	zhuan3	shen1	heng2",
		"缅甸联邦", "	mian3	dian4	lian2	bang1",
		"作善降祥", "	zuo4	shan4	jiang4	xiang2",
		"长街短巷", "	chang2	jie1	duan3	xiang4",
		"重峦叠嶂", "	chong2	luan2	die2	zhang4",
		"转轮手枪", "	zhuan4	lun2	shou3	qiang1",
		"水远山长", "	shui3	yuan3	shan1	chang2",
		"仰天长啸", "	yang3	tian1	chang2	xiao4",
		"广种薄收", "	guang3	zhong4	bo2	shou1",
		"广为流传", "	guang3	wei2	liu2	chuan2",
		"康乾盛世", "	kang1	qian2	sheng4	shi4",
		"公共交通", "	gong1	gong4	jiao1	tong1",
		"公共卫生", "	gong1	gong4	wei4	sheng1",
		"传风扇火", "	chuan2	feng1	shan1	huo3",
		"衡短论长", "	heng2	duan3	lun4	chang2",
		"楞手楞脚", "	leng4	shou3	leng4	jiao3",
		"应天承运", "	ying4	tian1	cheng2	yun4",
		"笼鸟槛猿", "	long2	niao3	jian4	yuan2",
		"公共场所", "	gong1	gong4	chang3	suo3",
		"摇摇晃晃", "	yao2	yao2	huang4	huang4",
		"转败为胜", "	zhuan3	bai4	wei2	sheng4",
		"沸沸汤汤", "	fei4	fei4	shang1	shang1",
		"跌跌跄跄", "	die1	die1	qiang4	qiang4",
		"较短絜长", "	jiao4	duan3	xie2	chang2",
		"情长纸短", "	qing2	chang2	zhi3	duan3",
		"对口相声", "	dui4	kou3	xiang4	sheng",
		"青春年少", "	qing1	chun1	nian2	shao4",
		"学有专长", "	xue2	you3	zhuan1	chang2",
		"远涉重洋", "	yuan3	she4	chong2	yang2",
		"从长商议", "	cong2	chang2	shang1	yi4",
		"弹冠相庆", "	tan2	guan1	xiang1	qing4",
		"长安少年", "	chang2	an1	shao4	nian2",
		"斗升之水", "	dou3	sheng1	zhi1	shui3",
		"虱处裈中", "	shi1	chu3	kun1	zhong1",
		"将遇良才", "	jiang4	yu4	liang2	cai2",
		"鉴影度形", "	jian4	ying3	duo2	xing2",
		"将功折过", "	jiang1	gong1	she2	guo4",
		"残兵败将", "	can2	bing1	bai4	jiang4",
		"拽象拖犀", "	zhuai4	xiang4	tuo1	xi1",
		"转败为功", "	zhuan3	bai4	wei2	gong1",
		"氧炔吹管", "	yang3	que1	chui1	guan3",
		"惊起梁尘", "	jing1	qi3	liang2	chen2",
		"静电感应", "	jing4	dian4	gan3	ying4",
		"进贤兴功", "	jin4	xian2	xing1	gong1",
		"满口应承", "	man3	kou3	ying4	cheng2",
		"气贯长虹", "	qi4	guan4	chang2	hong2",
		"着人先鞭", "	zhuo2	ren2	xian1	bian1",
		"进退消长", "	jin4	tui4	xiao1	chang2",
		"将相之器", "	jiang4	xiang4	zhi1	qi4",
		"交响乐队", "	jiao1	xiang3	yue4	dui4",
		"确定效应", "	que4	ding4	xiao4	ying4",
		"神成为人", "	shen2	cheng2	wei2	ren2",
		"哗众取宠", "	hua2	zhong4	qu3	chong3",
		"见性成佛", "	jian4	xing4	cheng2	fo2",
		"嚼齿穿龈", "	jiao2	chi3	chuan1	yin2",
		"鸾颠凤倒", "	luan2	dian1	feng4	dao3",
		"清史列传", "	qing1	shi3	lie4	zhuan4",
		"开疆拓境", "	kai1	jiang1	tuo4	jing4",
		"亢音高唱", "	gang1	yin1	gao1	chang4",
		"不见经传", "	bu4	jian4	jing1	zhuan4",
		"简切了当", "	jian3	qie4	liao3	dang4",
		"天旋地转", "	tian1	xuan2	di4	zhuan4",
		"水浒全传", "	shui3	hu3	quan2	zhuan4",
		"嚼穿龈血", "	jiao2	chuan1	yin2	xue4",
		"清风劲节", "	qing1	feng1	jing4	jie2",
		"永贞内禅", "	yong3	zhen1	nei4	shan4",
		"间见层出", "	jian4	xian4	ceng2	chu1",
		"较短比长", "	jiao4	duan3	bi3	chang2",
		"沅江九肋", "	yuan2	jiang1	jiu3	lei4",
		"嚼腭搥床", "	jiao2	e4	chui2	chuang2",
		"嘴快舌长", "	zui3	kuai4	she2	chang2",
		"阶跃响应", "	jie1	yue4	xiang3	ying4",
		"作浪兴风", "	zuo4	lang4	xing1	feng1",
		"法轮常转", "	fa3	lun2	chang2	zhuan4",
		"江郎才尽", "	jiang1	lang2	cai2	jin4",
		"兴风作浪", "	xing1	feng1	zuo4	lang4",
		"少先队员", "	shao4	xian1	dui4	yuan2",
		"知疼着痒", "	zhi1	teng2	zhao2	yang3",
		"专家评价", "	zhuan1	jia1	ping2	jia4",
		"更型换代", "	geng1	xing2	huan4	dai4",
		"少管闲事", "	shao4	guan3	xian2	shi4",
		"论短道长", "	lun4	duan3	dao4	chang2",
		"尝尽心酸", "	chang2	jin4	xin1	suan1",
		"乱箭攒心", "	luan4	jian4	cuan2	xin1",
		"旧调重弹", "	jiu4	diao4	chong2	tan2",
		"应用卫星", "	ying4	yong4	wei4	xing1",
		"贞松劲柏", "	zhen1	song1	jing4	bai3",
		"羊瘙痒病", "	yang2	sao4	yang3	bing4",
		"了若指掌", "	liao3	ruo4	zhi3	zhang3",
		"条件反应", "	tiao2	jian4	fan3	ying4",
		"管弦乐团", "	guan3	xian2	yue4	tuan2",
		"朝梁暮陈", "	zhao1	liang2	mu4	chen2",
		"朝梁暮周", "	zhao1	liang2	mu4	zhou1",
		"横行天下", "	heng2	xing2	tian1	xia4",
		"空中少爷", "	kong1	zhong1	shao4	ye",
		"简单明了", "	jian3	dan1	ming2	liao3",
		"中国银行", "	zhong1	guo2	yin2	hang2",
		"应用程序", "	ying4	yong4	cheng2	xu4",
		"应天顺人", "	ying4	tian1	shun4	ren2",
		"语长心重", "	yu3	chang2	xin1	zhong4",
		"鼋鸣鳖应", "	yuan2	ming2	bie1	ying4",
		"漏尽钟鸣", "	lou4	jin4	zhong1	ming2",
		"语短情长", "	yu3	duan3	qing2	chang2",
		"拱手而降", "	gong3	shou4	er2	xiang2",
		"臭名昭著", "	chou4	ming2	zhao1	zhu4",
		"对称空间", "	dui4	chen4	kong1	jian1",
		"聪明绝顶", "	cong1	ming	jue2	ding3",
		"联调联试", "	lian2	tiao2	lian2	shi4",
		"惯用伎俩", "	guan4	yong4	ji4	liang3",
		"广东音乐", "	guang3	dong1	yin1	yue4",
		"应天顺民", "	ying4	tian1	shun4	min2",
		"广陵散绝", "	guang3	ling2	san3	jue2",
		"遇难成祥", "	yu4	nan4	cheng2	xiang2",
		"岳镇渊渟", "	yue4	zhen4	yuan1	ting1",
		"有效成分", "	you3	xiao4	cheng2	fen4",
		"交通银行", "	jiao1	tong1	yin2	hang2",
		"万里长江", "	wan4	li3	chang2	jiang1",
		"梗泛萍漂", "	geng3	fan4	ping2	piao1",
		"万里长城", "	wan4	li3	chang2	cheng2",
		"更令明号", "	geng1	ling4	ming2	hao4",
		"子孙娘娘", "	zi3	sun1	niang2	niang",
		"毁冠裂裳", "	hui3	guan1	lie4	chang2",
		"横征苛敛", "	heng4	zheng1	ke1	lian3",
		"词长效应", "	ci2	chang2	xiao4	ying4",
		"名声籍甚", "	ming2	sheng1	ji2	shen4",
		"封豕长蛇", "	feng1	shi3	chang2	she2",
		"语重心长", "	yu3	zhong4	xin1	chang2",
		"灭景追风", "	mie4	ying3	zhui1	feng1",
		"常年累月", "	chang2	nian2	lei3	yue4",
		"风尘肮脏", "	feng1	chen2	ang1	zang1",
		"丰草长林", "	feng1	cao3	chang2	lin2",
		"月亮女神", "	yue4	liang	nu:3	shen2",
		"以升量石", "	yi3	sheng1	liang2	dan4",
		"望子成龙", "	wang4	zi3	cheng2	long2",
		"槁项黄馘", "	gao3	xiang4	huang2	xu4",
		"讯框中继", "	xun4	kuang4	zhong1	ji4",
		"粉妆玉琢", "	fen3	zhuang1	yu4	zhuo2",
		"饮马长江", "	yin3	ma3	chang2	jiang1",
		"飞流短长", "	fei1	liu2	duan3	chang2",
		"改姓更名", "	gai3	xing4	geng1	ming2",
		"粘胶纤维", "	nian2	jiao1	xian1	wei2",
		"更深人静", "	geng1	shen1	ren2	jing4",
		"装模作样", "	zhuang1	mu2	zuo4	yang4",
		"望洋兴叹", "	wang4	yang2	xing1	tan4",
		"发踊冲冠", "	fa4	yong3	chong1	guan1",
		"阴凝坚冰", "	yin1	ning2	jian1	bing1",
		"山公倒载", "	shan1	gong1	dao3	zai3",
		"多难兴邦", "	duo1	nan4	xing1	bang1",
		"豆重榆瞑", "	dou4	chong2	yu2	ming2",
		"乜斜缠帐", "	nie4	xie2	chan2	zhang4",
		"藤野先生", "	teng2	ye3	xian1	sheng",
		"孽障种子", "	nie4	zhang4	zhong3	zi3",
		"蒸发空调", "	zheng1	fa1	kong1	tiao2",
		"恩甚怨生", "	en1	shen4	yuan4	sheng1",
		"转变抹角", "	zhuan3	bian4	mo4	jiao3",
		"明白了当", "	ming2	bai2	liao3	dang4",
		"藏传佛教", "	zang4	chuan2	fo2	jiao4",
		"告老还乡", "	gao4	lao3	huan2	xiang1",
		"藏茴香果", "	zang4	hui2	xiang1	guo3",
		"袅娜娉婷", "	niao3	nuo2	ping1	ting2",
		"转来转去", "	zhuan4	lai2	zhuan4	qu4",
		"夜长梦短", "	ye4	chang2	meng4	duan3",
		"商业应用", "	shang1	ye4	ying4	yong4",
		"捻捻转儿", "	nian3	nian3	zhuan4	er2",
		"说来话长", "	shuo1	lai2	hua4	chang2",
		"借面吊丧", "	jie4	mian4	diao4	sang1",
		"更高性能", "	geng1	gao1	xing4	neng2",
		"扛鼎抃牛", "	gang1	ding3	bian4	niu2",
		"钧天广乐", "	jun1	tian1	guang3	yue4",
		"生意兴隆", "	sheng1	yi4	xing1	long2",
		"拘神遣将", "	ju1	shen2	qian3	jiang4",
		"率兽食人", "	shuai4	shou4	shi2	ren2",
		"正义斗争", "	zheng4	yi4	dou4	zheng1",
		"简截了当", "	jian3	jie2	liao3	dang4",
		"旧梦重温", "	jiu4	meng4	chong2	wen1",
		"产前检查", "	chan3	qian2	jian3	cha2",
		"钟鼎人家", "	zhong1	ding3	ren2	jia",
		"矿物成分", "	kuang4	wu4	cheng2	fen4",
		"众好众恶", "	zhong4	hao4	zhong4	wu4",
		"旷日长久", "	kuang4	ri4	chang2	jiu3",
		"破镜重圆", "	po4	jing4	chong2	yuan2",
		"化零为整", "	hua4	ling2	wei2	zheng3",
		"子癫前症", "	zi3	dian1	qian2	zheng4",
		"睡眠失调", "	shui4	mian2	shi1	tiao2",
		"睡回笼觉", "	shui4	hui2	long2	jiao4",
		"盈箱累箧", "	ying2	xiang1	lei3	qie4",
		"黄发垂髫", "	huang2	fa4	chui2	tiao2",
		"妙语横生", "	miao4	yu3	heng4	sheng1",
		"倦鸟知还", "	juan4	niao3	zhi1	huan2",
		"反戈相向", "	fan3	ge1	xiang1	xiang4",
		"商人银行", "	shang1	ren2	yin2	hang2",
		"贫穷潦倒", "	pin2	qiong2	liao2	dao3",
		"繁荣兴旺", "	fan2	rong2	xing1	wang4",
		"差分方程", "	cha1	fen1	fang1	cheng2",
		"变徵之声", "	bian4	zhi3	zhi1	sheng1",
		"论长道短", "	lun4	chang2	dao4	duan3",
		"膏场绣浍", "	gao1	chang2	xiu4	kuai4",
		"蜚短流长", "	fei1	duan3	liu2	chang2",
		"虾兵蟹将", "	xia1	bing1	xie4	jiang4",
		"方寸万重", "	fang1	cun4	wan4	chong2",
		"昼长夜短", "	zhou4	chang2	ye4	duan3",
		"干劲冲天", "	gan1	jin4	chong1	tian1",
		"朝鲜太宗", "	chao2	xian3	tai4	zong1",
		"长鸣都尉", "	chang2	ming2	dou1	wei4",
		"敛声屏气", "	lian3	sheng1	bing3	qi4",
		"应付账款", "	ying4	fu4	zhang4	kuan3",
		"众口难调", "	zhong4	kou3	nan2	tiao2",
		"众毛攒裘", "	zhong4	mao2	cuan2	qiu2",
		"大中学生", "	da4	zhong1	xue2	sheng",
		"种植园主", "	zhong4	zhi2	yuan2	zhu3",
		"中信银行", "	zhong1	xin4	yin2	hang2",
		"学生运动", "	xue2	sheng	yun4	dong4",
		"数短论长", "	shu3	duan3	lun4	chang2",
		"攒零合整", "	cuan2	ling2	he2	zheng3",
		"掸邦高原", "	shan4	bang1	gao1	yuan2",
		"出将入相", "	chu1	jiang4	ru4	xiang4",
		"撩是生非", "	liao2	shi4	sheng1	fei1",
		"败将残兵", "	bai4	jiang4	can2	bing1",
		"颠鸾倒凤", "	dian1	luan2	dao3	feng4",
		"王贡弹冠", "	wang2	gong4	dan4	guan4",
		"挑唇料嘴", "	tiao3	chun2	liao4	zui3",
		"清都绛阙", "	qing1	dou1	jiang4	que4",
		"从容应对", "	cong2	rong2	ying4	dui4",
		"全息照相", "	quan2	xi1	zhao4	xiang4",
		"青藏高原", "	qing1	zang4	gao1	yuan2",
		"调唇弄舌", "	tiao2	chun2	nong4	she2",
		"调风弄月", "	tiao2	feng1	nong4	yue4",
		"软件调试", "	ruan3	jian4	tiao2	shi4",
		"从长计较", "	cong2	chang2	ji4	jiao4",
		"扬长避短", "	yang2	chang2	bi4	duan3",
		"调良稳泛", "	tiao2	liang2	wen3	fan4",
		"拔刀相向", "	ba2	dao1	xiang1	xiang4",
		"人丁兴旺", "	ren2	ding1	xing1	wang4",
		"全能冠军", "	quan2	neng2	guan4	jun1",
		"成年累月", "	cheng2	nian2	lei3	yue4",
		"揣合逢迎", "	chuai3	he2	feng2	ying2",
		"重山复水", "	chong2	shan1	fu4	shui3",
		"铜盘重肉", "	tong2	pan2	zhong4	rou4",
		"万里长征", "	wan4	li3	chang2	zheng1",
		"川渟岳峙", "	chuan1	ting1	yue4	zhi4",
		"传授知识", "	chuan2	shou4	zhi1	shi",
		"穿红着绿", "	chuan1	hong2	zhuo2	lv4",
		"重熙累盛", "	chong2	xi1	lei3	sheng4",
		"飞短流长", "	fei1	duan3	liu2	chang2",
		"忘啜废枕", "	wang4	chuo4	fei4	zhen3",
		"公共财产", "	gong1	gong4	cai2	chan3",
		"黄花姑娘", "	huang2	hua1	gu1	niang",
		"餐桌转盘", "	can1	zhuo1	zhuan4	pan2",
		"应召女郎", "	ying4	zhao4	nu:3	lang2",
		"重裀列鼎", "	chong2	yin1	lie4	ding3",
		"鹰击长空", "	ying1	ji1	chang2	kong1",
		"鸟尽弓藏", "	niao3	jin4	gong1	cang2",
		"应天顺时", "	ying4	tian1	shun4	shi2",
		"应用平台", "	ying4	yong4	ping2	tai2",
		"感应线圈", "	gan3	ying4	xian4	quan1",
		"危机重重", "	wei1	ji1	chong2	chong2",
		"重山复岭", "	chong2	shan1	fu4	ling3",
		"长材小试", "	chang2	cai2	xiao3	shi4",
		"量子场论", "	liang4	zi3	chang3	lun4",
		"率以为常", "	shuai4	yi3	wei2	chang2",
		"剪切形变", "	jian3	qie1	xing2	bian4",
		"剂量效应", "	ji4	liang4	xiao4	ying4",
		"承销价差", "	cheng2	xiao1	jia4	cha1",
		"远渡重洋", "	yuan3	du4	chong2	yang2",
		"保长对应", "	bao3	chang2	dui4	ying4",
		"对称中心", "	dui4	chen4	zhong1	xin1",
		"彷徨失措", "	pang2	huang2	shi1	cuo4",
		"炮凤烹龙", "	pao2	feng4	peng1	long2",
		"重新审视", "	chong2	xin1	shen3	shi4",
		"手下败将", "	shou3	xia4	bai4	jiang4",
		"前缘未了", "	qian2	yuan2	wei4	liao3",
		"旁通曲畅", "	pang2	tong1	qu3	chang4",
		"雕章琢句", "	diao1	zhang1	zhuo2	ju4",
		"烹龙炮凤", "	peng1	long2	pao2	feng4",
		"断还归宗", "	duan4	huan2	gui1	zong1",
		"长安道上", "	chang2	an1	dao4	shang4",
		"娉婷袅娜", "	ping1	ting2	niao3	nuo2",
		"长蛇封豕", "	chang2	she2	feng1	shi3",
		"为好成歉", "	wei2	hao3	cheng2	qian4",
		"传为笑谈", "	chuan2	wei2	xiao4	tan2",
		"刀耕火种", "	dao1	geng1	huo3	zhong4",
		"调舌弄唇", "	tiao2	she2	nong4	chun2",
		"援交小姐", "	yuan2	jiao1	xiao3	jie",
		"顺应不良", "	shun4	ying4	bu4	liang2",
		"顺应天时", "	shun4	ying4	tian1	shi2",
		"颂声载道", "	song4	sheng1	zai3	dao4",
		"穷困潦倒", "	qiong2	kun4	liao2	dao3",
		"往渚还汀", "	wang3	zhu3	huan2	ting1",
		"穷年累世", "	qiong2	nian2	lei3	shi4",
		"洞鉴废兴", "	dong4	jian4	fei4	xing1",
		"穷年累月", "	qiong2	nian2	lei3	yue4",
		"枉口诳舌", "	wang3	kou3	kuang2	she2",
		"床头金尽", "	chuang2	tou2	jin1	jin4",
		"兵微将寡", "	bing1	wei1	jiang4	gua3",
		"成败兴废", "	cheng2	bai4	xing1	fei4",
		"春秋三传", "	chun1	qiu1	san1	zhuan4",
		"率土同庆", "	shuai4	tu3	tong2	qing4",
		"弹性形变", "	tan2	xing4	xing2	bian4",
		"重见天日", "	chong2	jian4	tian1	ri4",
		"戎事倥偬", "	rong2	shi4	kong3	zong3",
		"憨豆先生", "	han1	dou4	xian1	sheng",
		"报应不爽", "	bao4	ying4	bu4	shuang3",
		"强死强活", "	qiang3	si3	qiang3	huo2",
		"弓长岭区", "	gong1	chang2	ling3	qu1",
		"万象更新", "	wan4	xiang4	geng1	xin1",
		"傀儡政权", "	kui3	lei3	zheng4	quan2",
		"强的松龙", "	qiang2	di2	song1	long2",
		"陪唱小姐", "	pei2	chang4	xiao3	jie",
		"强弓劲弩", "	qiang2	gong1	jing4	nu3",
		"天宝当年", "	tian	bao	dang	nian",
		"抢劫银行", "	qiang3	jie2	yin2	hang2",
		"百舍重趼", "	bai3	she4	chong2	jian3",
		"连蒙带骗", "	lian2	meng1	dai4	pian4",
		"三旨相公", "	san1	zhi3	xiang4	gong1",
		"淡妆轻抹", "	dan4	zhuang1	qing1	mo4",
		"云窗雾槛", "	yun2	chuang1	wu4	jian4",
		"道长论短", "	dao4	chang2	lun4	duan3",
		"电光朝露", "	dian4	guang1	zhao1	lu4",
		"代为说项", "	dai4	wei2	shuo1	xiang4",
		"翘首引领", "	qiao2	shou3	yin3	ling3",
		"持人长短", "	chi2	ren2	chang2	duan3",
		"扭转乾坤", "	niu3	zhuan3	qian2	kun1",
		"黑白相间", "	hei1	bai2	xiang1	jian4",
		"电子工程", "	dian4	zi3	gong1	cheng2",
		"网络应用", "	wang3	luo4	ying4	yong4",
		"福寿绵长", "	fu2	shou4	mian2	chang2",
		"朗朗乾坤", "	lang3	lang3	qian2	kun1",
		"泪干肠断", "	lei4	gan1	chang2	duan4",
		"佹形僪状", "	gui3	xing2	yu4	zhuang4",
		"中兴新村", "	zhong1	xing1	xin1	cun1",
		"中规中矩", "	zhong4	gui1	zhong4	ju3",
		"织田信长", "	zhi1	tian2	xin4	chang2",
		"过分强调", "	guo4	fen4	qiang2	diao4",
		"粮尽援绝", "	liang2	jin4	yuan2	jue2",
		"朝成暮遍", "	zhao1	cheng2	mu4	bian4",
		"海水难量", "	hai3	shui3	nan2	liang2",
		"九九重阳", "	jiu3	jiu3	chong2	yang2",
		"牛头刨床", "	niu2	tou2	bao4	chuang2",
		"梁上君子", "	liang2	shang4	jun1	zi3",
		"斩将搴旗", "	zhan3	jiang4	qian1	qi2",
		"久别重逢", "	jiu3	bie2	chong2	feng2",
		"连街倒巷", "	lian2	jie1	dao3	xiang4",
		"张脉偾兴", "	zhang1	mai4	fen4	xing1",
		"精灵宝钻", "	jing1	ling2	bao3	zuan4",
		"切中时病", "	qie4	zhong4	shi2	bing4",
		"电子手帐", "	dian4	zi3	shou3	zhang4",
		"两样东西", "	liang3	yang4	dong1	xi",
		"五言长城", "	wu3	yan2	chang2	cheng2",
		"登台拜将", "	deng1	tai2	bai4	jiang4",
		"千了百当", "	qian1	liao3	bai3	dang4",
		"长生不老", "	chang2	sheng1	bu4	lao3",
		"上好下甚", "	shang4	hao3	xia4	shen4",
		"长生禄位", "	chang2	sheng1	lu4	wei4",
		"山溜穿石", "	shan1	liu4	chuan1	shi2",
		"搴旗斩将", "	qian1	qi2	zhan3	jiang4",
		"倒箧倾筐", "	dao3	qie4	qing1	kuang1",
		"千乘之国", "	qian1	sheng4	zhi1	guo2",
		"长江流域", "	chang2	jiang1	liu2	yu4",
		"长风破浪", "	chang2	feng1	po4	lang4",
		"吃亏上当", "	chi1	kui1	shang4	dang4",
		"倒凤颠鸾", "	dao3	feng4	dian1	luan2",
		"间谍软件", "	jian4	die2	ruan3	jian4",
		"夏虫朝菌", "	xia4	chong2	zhao1	jun1",
		"超超玄著", "	chao1	chao1	xuan2	zhu4",
		"拜将封侯", "	bai4	jiang4	feng1	hou2",
		"拣佛烧香", "	jian3	fo2	shao1	xiang1",
		"强词夺正", "	qiang3	ci2	duo2	zheng4",
		"成都平原", "	cheng2	du1	ping2	yuan2",
		"问长问短", "	wen4	chang2	wen4	duan3",
		"损兵折将", "	sun3	bing1	zhe2	jiang4",
		"唯唯连声", "	wei3	wei3	lian2	sheng1",
		"村生泊长", "	cun1	sheng1	bo2	chang2",
		"百舍重茧", "	bai3	she4	chong2	jian3",
		"百了千当", "	bai3	liao3	qian1	dang1",
		"旦种暮成", "	dan4	zhong4	mu4	cheng2",
		"寸长尺短", "	cun4	chang2	chi3	duan3",
		"倒裳索领", "	dao4	chang2	suo3	ling3",
		"秤平斗满", "	cheng4	ping2	dou3	man3",
		"升斗小民", "	sheng1	dou3	xiao3	min2",
		"登坛拜将", "	deng1	tan2	bai4	jiang4",
		"标准偏差", "	biao1	zhun3	pian1	cha1",
		"帝王将相", "	di4	wang2	jiang4	xiang4",
		"相得甚欢", "	xiang1	de2	shen4	huan1",
		"想出风头", "	xiang3	chu1	feng1	tou",
		"长柄勺子", "	chang2	bing3	shao2	zi",
		"表里相应", "	biao3	li3	xiang1	ying4",
		"长荣海运", "	chang2	rong2	hai3	yun4",
		"从严惩处", "	cong2	yan2	cheng2	chu3",
		"同侪审查", "	tong2	chai2	shen3	cha2",
		"更姓改物", "	geng1	xing4	gai3	wu4",
		"失惊倒怪", "	shi1	jing1	dao3	guai4",
		"荷枪实弹", "	he4	qiang1	shi2	dan4",
		"朝种暮获", "	zhao1	zhong3	mu4	hu4",
		"扣壶长吟", "	kou4	hu2	chang2	yin2",
		"一针见血", "	yi1	zhen1	jian4	xie3",
		"率土之滨", "	shuai4	tu3	zhi1	bin1",
		"枕席还师", "	zhen3	xi2	huan2	shi1",
		"三占从二", "	san1	zhan1	cong2	er4",
		"世界银行", "	shi4	jie4	yin2	hang2",
		"朝奏夕召", "	zhao1	zou4	xi1	zhao4",
		"朝奏暮召", "	zhao1	zou4	mu4	zhao4",
		"率由旧则", "	shuai4	you2	jiu4	ze2",
		"子宫后倾", "	zi3	gong1	hou4	qing1",
		"率土归心", "	shuai4	tu3	gui1	xin1",
		"朝钟暮鼓", "	zhao1	zhong1	mu4	gu3",
		"子宫脱垂", "	zi3	gong1	tuo1	chui2",
		"会计人员", "	kuai4	ji4	ren2	yuan2",
		"正冠纳履", "	zheng4	guan4	na4	lv3",
		"抒情散文", "	shu1	qing2	san3	wen2",
		"大肠杆菌", "	da4	chang2	gan3	jun1",
		"知人善任", "	zhi1	ren2	shan4	ren4",
		"看家本领", "	kan1	jia1	ben3	ling3",
		"书缺有间", "	shu1	que1	you3	jian4",
		"会计报表", "	kuai4	ji4	bao4	biao3",
		"缊褐瓢箪", "	yun4	he4	piao2	dan1",
		"人造草坪", "	ren2	zao4	cao3	ping2",
		"日中为市", "	ri4	zhong1	wei2	shi4",
		"是非颠倒", "	shi4	fei1	dian1	dao3",
		"三藏法师", "	san1	zang4	fa3	shi1",
		"毁家纾难", "	hui3	jia1	shu1	nan4",
		"食不重味", "	shi2	bu4	chong2	wei4",
		"一言为重", "	yi1	yan2	wei2	zhong4",
		"一走了之", "	yi1	zou3	liao3	zhi1",
		"上半部分", "	shang4	ban4	bu4	fen4",
		"诗书发冢", "	shi1	shu1	fa4	zhong3",
		"生发未燥", "	sheng1	fa4	wei4	zao4",
		"桑户棬枢", "	sang1	hu4	juan4	shu1",
		"指导思想", "	zhi2	dao3	si1	xiang3",
		"三十六行", "	san1	shi2	liu4	hang2",
		"开疆拓宇", "	kai1	jiang1	tuo4	yu3",
		"不治之症", "	bu4	zhi4	zhi1	zheng4",
		"斫雕为朴", "	zhuo2	diao1	wei2	pu3",
		"口尚乳臭", "	kou3	shang4	ru3	xiu4",
		"智尽能索", "	zhi4	jin4	neng2	suo3",
		"口燥唇干", "	kou3	zao4	chun2	gan1",
		"人类行为", "	ren2	lei4	xing2	wei2",
		"化为泡影", "	hua4	wei2	pao1	ying3",
		"大洋中脊", "	da4	yang2	zhong1	ji3",
		"糠豆不赡", "	kang	dou	bu	shan",
		"左支右调", "	zuo3	zhi1	you4	tiao2",
		"悬首吴阙", "	xuan2	shou3	wu2	que4",
		"兴妖作孽", "	xing1	yao1	zuo4	nie4",
		"秀出班行", "	xiu4	chu1	ban1	hang2",
		"公共事业", "	gong1	gong4	shi4	ye4",
		"公共假期", "	gong1	gong4	jia4	qi1",
		"公共厕所", "	gong1	gong4	ce4	suo3",
		"刑讯逼供", "	xing2	xun4	bi1	gong4",
		"悬鼓待椎", "	xuan2	gu3	dai4	zhui1",
		"轩鹤冠猴", "	xuan1	he4	guan4	hou2",
		"供不应求", "	gong1	bu4	ying4	qiu2",
		"学生宿舍", "	xue2	sheng1	su4	she4",
		"片长末技", "	pian4	chang2	mo4	ji4",
		"埙篪相和", "	xun1	chi2	xiang1	he4",
		"公共汽车", "	gong1	gong4	qi4	che1",
		"唱高调儿", "	chang4	gao1	diao4	r",
		"没收财产", "	mo4	shou1	cai2	chan3",
		"万古长存", "	wan4	gu3	chang2	cun2",
		"兴文匽武", "	xing1	wen2	diao4	wu3",
		"形孤影只", "	xing2	gu1	ying3	zhi1",
		"七长八短", "	qi1	chang2	ba1	duan3",
		"王孙公子", "	wang2	sun1	gong1	zi3",
		"地壳运动", "	di4	qiao4	yun4	dong4",
		"理论框架", "	li3	lun4	kuang4	jia4",
		"指雁为羹", "	zhi3	yan4	wei2	geng1",
		"咳唾成珠", "	ke2	tuo4	cheng2	zhu1",
		"抗颜为师", "	kang4	yan2	wei2	shi1",
		"直言切谏", "	zhi2	yan2	qie1	jian4",
		"厚养薄葬", "	hou4	yang3	bo2	zang4",
		"指天为誓", "	zhi3	tian1	wei2	shi4",
		"知疼着热", "	zhi1	teng2	zhao2	re4",
		"认影为头", "	ren4	ying3	wei2	tou2",
		"人心丧尽", "	ren2	xin1	sang4	jin4",
		"溘然长逝", "	ke4	ran2	chang2	shi4",
		"指树为姓", "	zhi3	shu4	wei2	xing4",
		"数往知来", "	shu3	wang3	zhi1	lai2",
		"三省吾身", "	san1	xing3	wu2	shen1",
		"原子半径", "	yuan2	zi3	ban4	jing4",
		"转灾为福", "	zhuan3	zai1	wei2	fu2",
		"只身孤影", "	zhi1	shen1	gu1	ying3",
		"刻章琢句", "	ke4	zhang1	zhuo2	ju4",
		"指山说磨", "	zhi3	shan1	shuo1	mo4",
		"人烟浩穰", "	ren2	yan1	hao4	rang3",
		"不揣冒昧", "	bu4	chuai3	mao4	mei4",
		"化学反应", "	hua4	xue2	fan3	ying4",
		"鸠形鹄面", "	jiu1	xing2	hu2	mian4",
		"三陪小姐", "	san1	pei2	xiao3	jie",
		"筑舍道傍", "	zhu4	she4	dao4	bang4",
		"气冲斗牛", "	qi4	chong1	dou3	niu2",
		"钻穴逾垣", "	zuan4	xue2	yu2	yuan2",
		"尽入彀中", "	jin4	ru4	gou4	zhong1",
		"詹言曲说", "	zhan1	yan2	qu3	shuo1",
		"埋天怨地", "	man2	tian1	yuan4	di4",
		"累卵之危", "	lei3	luan3	zhi1	wei1",
		"参辰日月", "	shen1	chen2	ri4	yue4",
		"斩尽杀绝", "	zhan3	jin4	sha1	jue2",
		"贼子乱臣", "	zei2	zi3	luan4	chen2",
		"钻头就锁", "	zuan4	tou2	jiu4	suo3",
		"尽美尽善", "	jin4	mei3	jin4	shan4",
		"醉山颓倒", "	zui4	shan1	tui2	dao3",
		"善为说辞", "	shan4	wei2	shuo1	ci2",
		"斩将刈旗", "	zhan3	jiang4	yi4	qi2",
		"累瓦结绳", "	lei3	wa3	jie2	sheng2",
		"累屋重架", "	lei3	wu1	chong2	jia4",
		"似箭在弦", "	si4	jian4	zai4	xian2",
		"曾不惨然", "	zeng	bu	chan	ran",
		"白喉杆菌", "	bai2	hou2	gan3	jun1",
		"尽其所长", "	jin4	qi2	suo3	chang2",
		"桑土绸缪", "	sang1	tu3	chou2	miu4",
		"人多阙少", "	ren2	duo1	que4	shao3",
		"思潮澎湃", "	si1	chao2	peng2	pai4",
		"沾沾自好", "	zhan1	zhan1	zi4	hao4",
		"日朘月减", "	ri4	juan1	yue4	jian3",
		"诘屈磝碻", "	jie2	qu1	bing4	zhou4",
		"一了百了", "	yi1	liao3	bai3	liao3",
		"少不经事", "	shao4	bu4	jing1	shi4",
		"死亡枕藉", "	si3	wang2	zhen3	jie4",
		"十字转门", "	shi2	zi4	zhuan4	men2",
		"贼臣乱子", "	zei2	chen2	luan4	zi3",
		"少年得志", "	shao4	nian2	de2	zhi4",
		"少小无猜", "	shao4	xiao3	wu2	cai1",
		"励精更始", "	li4	jing1	geng1	shi3",
		"舍身为国", "	she3	shen1	wei2	guo2",
		"揭箧担囊", "	jie1	qie4	dan1	nang2",
		"丹瑞大将", "	dan1	rui4	da4	jiang4",
		"松柏之志", "	song1	bai3	zhi1	zhi4",
		"反应堆芯", "	fan3	ying4	dui1	xin1",
		"月没参横", "	yue4	mo4	shen1	heng2",
		"折箭为誓", "	she2	jian4	wei2	shi4",
		"作舍道边", "	zuo4	she4	dao4	bian1",
		"累见不鲜", "	lei3	jian4	bu4	xian3",
		"立党为公", "	li4	dang3	wei4	gong1",
		"肆虐横行", "	si4	nue4	heng2	xing2",
		"长幼有序", "	zhang3	you4	you3	xu4",
		"旧话重提", "	jiu4	hua4	chong2	ti2",
		"如应斯响", "	ru2	ying4	si1	xiang3",
		"捐身徇义", "	juan1	shen1	xun4	yi4",
		"印象主义", "	yin4	xiang4	zhu3	yi4",
		"转忧为喜", "	zhuan3	you1	wei2	xi3",
		"一笑了之", "	yi1	xiao4	liao3	zhi1",
		"识微知著", "	shi2	wei1	zhi1	zhuo2",
		"日引月长", "	ri4	yin3	yue4	chang2",
		"杼柚其空", "	zhu4	zhou2	qi2	kong1",
		"杼柚空虚", "	zhu4	zhou2	kong1	xu1",
		"祝咽祝哽", "	zhu4	yan1	zhu4	geng3",
		"世界冠军", "	shi4	jie4	guan4	jun1",
		"理性知识", "	li3	xing4	zhi1	shi",
		"圈牢养物", "	juan4	lao2	yang3	wu4",
		"开疆拓土", "	kai1	jiang1	tuo4	tu3",
		"褚小怀大", "	zhu3	xiao3	huai2	da4",
		"一身两役", "	yi1	shen1	liang3	yi4",
		"日月参辰", "	ri4	yue4	shen1	chen2",
		"祝鮀之佞", "	zhu4	tuo2	zhi1	ning4",
		"尸居龙见", "	shi1	ju1	long2	xian4",
		"什袭珍藏", "	shi2	xi2	zhen1	cang2",
		"助天为虐", "	zhu4	tian1	wei2	nue4",
		"融洽无间", "	rong2	qia4	wu2	jian4",
		"柱石之坚", "	zhu4	shi2	zhi1	jian1",
		"收旗卷伞", "	shou1	qi2	juan4	san3",
		"转祸为福", "	zhuan3	huo4	wei2	fu2",
		"日久岁长", "	ri4	jiu3	sui4	chang2",
		"逐机应变", "	zhu2	ji1	ying4	bian4",
		"珠宫贝阙", "	zhu1	gong1	bei4	que4",
		"卷帙浩繁", "	juan4	zhi4	hao4	fan2",
		"助纣为虐", "	zhu4	zhou4	wei2	nue4",
		"多钱善贾", "	duo1	qian2	shan4	gu3",
		"神武挂冠", "	shen2	wu3	gua4	guan4",
		"劳动合同", "	lao2	dong4	he2	tong",
		"多重国籍", "	duo1	chong2	guo2	ji2",
		"身无长物", "	shen1	wu2	chang2	wu4",
		"日长一线", "	ri4	chang2	yi1	xian4",
		"适应能力", "	shi4	ying4	neng2	li4",
		"深切著白", "	shen1	qie4	zhu4	bai2",
		"不了了之", "	bu4	liao3	liao3	zhi1",
		"人自为政", "	ren2	zi4	wei2	zheng4",
		"审曲面埶", "	shen3	qu3	mian4	xin1",
		"人中狮子", "	ren2	zhong1	shi1	zi3",
		"种瓜得瓜", "	zhong4	gua1	de2	gua1",
		"种豆得豆", "	zhong4	dou4	de2	dou4",
		"审曲面势", "	shen3	qu3	mian4	shi4",
		"专横跋扈", "	zhuan1	heng4	ba2	hu4",
		"白苋紫茄", "	bai2	xian4	zi3	qie2",
		"信息灵通", "	xin4	xi	ling2	tong1",
		"内线消息", "	nei4	xian4	xiao1	xi",
		"云兴霞蔚", "	yun2	xing1	xia2	wei4",
		"弹斤估两", "	tan2	jin1	gu1	liang3",
		"因缘为市", "	yin1	yuan2	wei2	shi4",
		"应答如响", "	ying4	da2	ru2	xiang3",
		"令原之戚", "	ling2	yuan2	zhi1	qi1",
		"陵劲淬砺", "	ling2	jing4	cui4	li4",
		"弹丸脱手", "	tan2	wan2	tuo1	shou3",
		"临难铸兵", "	lin2	nan4	zhu4	bing1",
		"临难苟免", "	lin2	nan4	gou3	mian3",
		"临机应变", "	lin2	ji1	ying4	bian4",
		"应用技术", "	ying4	yong4	ji4	shu4",
		"应弦而倒", "	ying4	xian2	er2	dao3",
		"流年似水", "	liu2	nian2	si4	shui3",
		"钦差大臣", "	qin1	chai1	da4	chen2",
		"挈瓶之知", "	qie4	ping2	zhi1	zhi4",
		"引为鉴戒", "	yin3	wei2	jian4	jie4",
		"弹性蛋白", "	tan2	xing4	dan4	bai2",
		"人间佛教", "	ren2	jian1	fo2	jiao4",
		"人车混行", "	ren2	che1	hun2	xing2",
		"印累绶若", "	yin4	lei2	shou4	ruo4",
		"搂头盖脸", "	lou1	tou2	gai4	lian3",
		"淫言媟语", "	yin2	yan2	liang3	yu3",
		"凌云之志", "	ling2	yun2	zhi1	zhi4",
		"铜筋铁肋", "	tong2	jin1	tie3	lei4",
		"人满为患", "	ren2	man3	wei2	huan4",
		"呷醋节帅", "	xia1	cu4	jie2	shuai4",
		"啮血为盟", "	nie4	xue4	wei2	meng2",
		"煞有介事", "	sha4	you3	jie4	shi4",
		"先睹为快", "	xian1	du3	wei2	kuai4",
		"一言为定", "	yi1	yan2	wei2	ding4",
		"破愁为笑", "	po4	chou2	wei2	xiao4",
		"攀蟾折桂", "	pan1	chan2	she2	gui4",
		"系统更新", "	xi4	tong3	geng1	xin1",
		"农业银行", "	nong2	ye4	yin2	hang2",
		"倭黑猩猩", "	wo1	hei1	xing1	xing",
		"为山止篑", "	wei2	shan1	zhi3	kui4",
		"衣被群生", "	yi4	bei4	qun2	sheng1",
		"熬更守夜", "	ao2	geng1	shou3	ye4",
		"牛听弹琴", "	niu2	ting1	tan2	qin2",
		"借尸还魂", "	jie4	shi1	huan2	hun2",
		"显露头角", "	xian3	lu4	tou2	jiao3",
		"凶神恶煞", "	xiong1	shen2	e4	sha4",
		"相对误差", "	xiang1	dui4	wu4	cha1",
		"掊斗折衡", "	pou3	dou3	zhe2	heng2",
		"扭亏为盈", "	niu3	kui1	wei2	ying2",
		"松筠之节", "	song1	jun1	zhi1	jie2",
		"漏尽更阑", "	lou4	jin4	geng1	lan2",
		"人民银行", "	ren2	min2	yin2	hang2",
		"内助之贤", "	nei4	zhu4	zhi1	xian2",
		"游闲公子", "	you2	xian2	gong1	zi3",
		"围魏救赵", "	wei2	wei4	jiu4	zhao4",
		"量才而为", "	liang4	cai2	er2	wei2",
		"弹冠振衣", "	tan2	guan1	zhen4	yi1",
		"了无生趣", "	liao3	wu2	sheng1	qu4",
		"燎如观火", "	liao3	ru2	guan1	huo3",
		"事危累卵", "	shi4	wei1	lei3	luan3",
		"撩火加油", "	liao2	huo3	jia1	you2",
		"玉尺量才", "	yu4	chi3	liang2	cai2",
		"撩蜂剔蝎", "	liao2	feng1	ti4	xie1",
		"优游涵泳", "	you1	you2	han2	yong3",
		"语笑喧哗", "	yu3	xiao4	xuan1	hua2",
		"情见势屈", "	qing2	xian4	shi4	qu1",
		"清静无为", "	qing1	jing4	wu2	wei2",
		"索尽枯肠", "	suo3	jin4	ku1	chang2",
		"请假回家", "	qing3	jia4	hui2	jia1",
		"痛深恶绝", "	tong4	shen1	wu4	jue2",
		"因果报应", "	yin1	guo3	bao4	ying4",
		"韬光俟奋", "	tao1	guang1	si4	fen4",
		"调和阴阳", "	tiao2	he2	yin1	yang2",
		"调和鼎鼐", "	tiao2	he2	ding3	nai4",
		"裂裳裹足", "	lie4	chang2	guo3	zu2",
		"情绪反应", "	qing2	xu4	fan3	ying4",
		"袒裼裸裎", "	tan3	xi1	luo3	cheng2",
		"情深似海", "	qing2	shen1	si4	hai3",
		"笼络人心", "	long3	luo4	ren2	xin1",
		"龙举云兴", "	long2	ju3	yun2	xing1",
		"贪小便宜", "	tan1	xiao3	pian2	yi",
		"什一奉献", "	shi2	yi1	feng4	xian4",
		"瓮尽杯干", "	weng4	jin4	bei1	gan1",
		"埒才角妙", "	lie4	cai2	jue2	miao4",
		"连编累牍", "	lian2	bian1	lei3	du2",
		"团体冠军", "	tuan2	ti3	guan4	jun1",
		"羽扇纶巾", "	yu3	shan4	guan1	jin1",
		"取长补短", "	qu3	chang2	bu3	duan3",
		"渊涓蠖濩", "	yuan1	juan1	huo4	hu4",
		"蠡酌管窥", "	li3	zhuo2	guan3	kui1",
		"青林黑塞", "	qing1	lin2	hei1	sai4",
		"例行差事", "	li4	xing2	chai1	shi4",
		"玉质金相", "	yu4	zhi4	jin1	xiang4",
		"燕京啤酒", "	yan1	jing1	pi2	jiu3",
		"远不间亲", "	yuan3	bu4	jian4	qin1",
		"燕京大学", "	yan1	jing1	da4	xue2",
		"送子观音", "	song4	zi3	guan1	yin1",
		"地方停车", "	di4	fang	ting2	che1",
		"充分就业", "	chong1	fen4	jiu4	ye4",
		"普天率土", "	pu3	tian1	shuai4	tu3",
		"万家生佛", "	wan4	jia1	sheng1	fo2",
		"千差万别", "	qian1	cha1	wan4	bie2",
		"液晶电视", "	ye4	jing1	dian4	shi4",
		"咬姜呷醋", "	yao3	jiang1	xia1	cu4",
		"棋输先着", "	qi2	shu1	xian1	zhao1",
		"明珠弹雀", "	ming2	zhu1	tan2	que4",
		"千了万当", "	qian1	le	wan4	dang4",
		"燕处焚巢", "	yan4	chu3	fen2	chao2",
		"燕处危巢", "	yan4	chu3	wei1	chao2",
		"公共道德", "	gong1	gong4	dao4	de2",
		"其应如响", "	qi2	ying4	ru2	xiang3",
		"乾端坤倪", "	qian2	duan1	kun1	ni2",
		"民事调解", "	min2	shi4	tiao2	jie3",
		"抟沙嚼蜡", "	tuan2	sha1	jiao2	la4",
		"万别千差", "	wan4	bie2	qian1	cha1",
		"燕骏千金", "	yan1	jun4	qian1	jin1",
		"前功尽弃", "	qian2	gong1	jin4	qi4",
		"磨砻镌切", "	mo2	long2	juan1	qie1",
		"乾嘉学派", "	qian2	jia1	xue2	pai4",
		"言笑晏晏", "	yan2	xiao4	yan4	yan4",
		"严刑逼供", "	yan2	xing2	bi1	gong4",
		"同型配子", "	tong2	xing2	pei4	zi3",
		"妖由人兴", "	yao1	you2	ren2	xing1",
		"咬血为盟", "	yao3	xue4	wei2	meng2",
		"夜静更阑", "	ye4	jing4	geng1	lan2",
		"望闻问切", "	wang4	wen2	wen4	qie1",
		"兴亡祸福", "	xing1	wang2	huo4	fu2",
		"杀彘教子", "	sha1	zhi4	jiao4	zi3",
		"哭丧着脸", "	ku1	sang1	zhe	lian3",
		"行为不端", "	xing2	wei2	bu4	duan1",
		"行为不检", "	xing2	wei2	bu4	jian3",
		"行为规范", "	xing2	wei2	gui1	fan4",
		"行为能力", "	xing2	wei2	neng2	li4",
		"晚食当肉", "	wan3	shi2	dang4	rou4",
		"兴亡继绝", "	xing1	wang2	ji4	jue2",
		"公共秩序", "	gong1	gong4	zhi4	xu4",
		"同恶相恤", "	tong2	wu4	xiang1	xu4",
		"言必有中", "	yan2	bi4	you3	zhong4",
		"图穷匕见", "	tu2	qiong2	bi3	xian4",
		"燕昭市骏", "	yan1	zhao1	shi4	jun4",
		"言之过甚", "	yan2	zhi1	guo4	shen4",
		"佛朗机铳", "	fo2	lang3	ji1	chong4",
		"头童齿豁", "	tou2	tong2	chi3	huo4",
		"冤家对头", "	yuan1	jia	dui4	tou2",
		"明月入怀", "	ming2	yue4	ru4	huai2",
		"要价还价", "	yao4	jia4	huan2	jia4",
		"无穷无尽", "	wu2	qiong2	wu2	jin4",
		"铺张扬厉", "	pu1	zhang1	yang2	li4",
		"免疫反应", "	mian3	yi4	fan3	ying4",
		"相鼠有皮", "	xiang4	shu3	you3	pi2",
		"骈肩累足", "	pian2	jian1	lei3	zu2",
		"片鳞只甲", "	pian4	lin2	zhi1	jia3",
		"五行并下", "	wu3	hang2	bing4	xia4",
		"片文只事", "	pian4	wen2	zhi1	shi4",
		"和平共处", "	he2	ping2	gong4	chu3",
		"傻瓜相机", "	sha3	gua1	xiang4	ji1",
		"未艾方兴", "	wei4	ai4	fang1	xing1",
		"夕寐宵兴", "	xi1	mei4	xiao1	xing1",
		"值得称赞", "	zhi2	de	cheng1	zan4",
		"小廉曲谨", "	xiao3	lian2	qu3	jin3",
		"无量寿佛", "	wu2	liang4	shou4	fo2",
		"未了公案", "	wei4	liao3	gong1	an4",
		"孝子顺孙", "	xiao4	zi3	shun4	sun1",
		"孝子贤孙", "	xiao4	zi3	xian2	sun1",
		"橡皮钉子", "	xiang4	pi2	ding4	zi3",
		"能者为师", "	neng2	zhe3	wei2	shi1",
		"邪不干正", "	xie2	bu4	gan1	zheng4",
		"协调发展", "	xie2	tiao2	fa1	zhan3",
		"心瞻魏阙", "	xin1	zhan1	wei4	que4",
		"兴邦立国", "	xing1	bang1	li4	guo2",
		"骈肩累迹", "	pian2	jian1	lei3	ji4",
		"皮相之谈", "	pi2	xiang4	zhi1	tan2",
		"兴词构讼", "	xing1	ci2	gou4	song4",
		"五行生克", "	wu3	hang2	sheng1	ke4",
		"一笑置之", "	yi1	xiao4	zhi4	zhi1",
		"温席扇枕", "	wen1	xi2	shan1	zhen3",
		"偶联反应", "	ou3	lian2	fan3	ying4",
		"停酒止乐", "	ting2	jiu3	zhi3	yue4",
		"停车位置", "	ting2	che1	wei4	zhi",
		"闻风而兴", "	wen2	feng1	er2	xing1",
		"文行出处", "	wen2	xing2	chu1	chu3",
		"贫困潦倒", "	pin2	kun4	liao2	dao3",
		"频率成分", "	pin2	lv4	cheng2	fen4",
		"五行相克", "	wu3	hang2	xiang1	ke4",
		"命名作业", "	ming4	ming2	zuo4	ye4",
		"雾兴云涌", "	wu4	xing1	yun2	yong3",
		"凭几据杖", "	ping2	ji1	ju4	zhang4",
		"味同嚼蜡", "	wei4	tong2	jiao2	la4",
		"恶醉强酒", "	wu4	zui4	qiang3	jiu3",
		"诬良为盗", "	wu1	liang2	wei2	dao4",
		"温枕扇席", "	wen1	zhen3	shan1	xi2",
		"片长薄技", "	pian4	chang2	bo2	ji4",
		"片甲不还", "	pian4	jia3	bu4	huan2",
		"无肠公子", "	wu2	chang2	gong1	zi3",
		"少不更事", "	shao4	bu4	geng1	shi4",
		"取长弃短", "	qu3	chang2	qi4	duan3",
		"扪参历井", "	men2	shen1	li4	jing3",
		"洋底地壳", "	yang2	di3	di4	qiao4",
		"一之为甚", "	yi1	zhi1	wei2	shen4",
		"百喙莫辩", "	bai3	hui4	mo4	bian4",
		"没羞没臊", "	mei2	xiu1	mei2	sao4",
		"分毫之差", "	fen1	hao2	zhi1	cha1",
		"一之谓甚", "	yi1	zhi1	wei4	shen4",
		"提起精神", "	ti2	qi3	jing1	shen",
		"白发红颜", "	bai2	fa4	hong2	yan2",
		"白发苍颜", "	bai2	fa4	cang1	yan2",
		"熟思审处", "	shu2	si1	shen3	chu3",
		"分解代谢", "	fen1	jie3	dai4	xie4",
		"泄露天机", "	xie4	lou4	tian1	ji1",
		"束身自好", "	shu4	shen1	zi4	hao4",
		"八方呼应", "	ba1	fang1	hu1	ying4",
		"束戈卷甲", "	shu4	ge1	juan4	jia3",
		"八方风雨", "	ba1	fang1	feng1	yu3",
		"没有关系", "	mei2	you3	guan1	xi",
		"没有什么", "	mei2	you3	shen2	me",
		"调皮捣蛋", "	tiao2	pi2	dao3	dan4",
		"熬姜呷醋", "	ao2	jiang1	xia1	cu4",
		"作歹为非", "	zuo4	dai3	wei2	fei1",
		"五倍子虫", "	wu3	bei4	zi3	chong2",
		"朝攀暮折", "	zhao1	pan1	mu4	she2",
		"安守本分", "	an1	shou3	ben3	fen4",
		"为时过早", "	wei2	shi2	guo4	zao3",
		"为善最乐", "	wei2	shan4	zui4	le4",
		"朝华夕秀", "	zhao1	hua2	xi1	xiu4",
		"朝欢暮乐", "	zhao1	huan1	mu4	le4",
		"为德不终", "	wei2	de2	bu4	zhong1",
		"为时未晚", "	wei2	shi2	wei4	wan3",
		"等差级数", "	deng3	cha1	ji2	shu4",
		"竹篮打水", "	zhu2	lan2	da2	shui3",
		"枕曲藉糟", "	zhen3	qu1	jie4	zao1",
		"竭尽全力", "	jie2	jin4	quan2	li4",
		"一念之差", "	yi1	nian4	zhi1	cha1",
		"私生子女", "	si1	sheng1	zi3	nu:3",
		"一弹指顷", "	yi1	tan2	zhi3	qing3",
		"朝折暮折", "	zhao1	she2	mu4	she2",
		"一矢中的", "	yi1	shi3	zhong4	di4",
		"没有差别", "	mei2	you3	cha1	bie2",
		"空地导弹", "	kong4	di4	dao3	dan4",
		"中子俘获", "	zhong1	zi3	fu2	huo4",
		"左右为难", "	zuo3	you4	wei2	nan2",
		"积年累月", "	ji1	nian2	lei3	yue4",
		"移山倒海", "	yi2	shan1	dao3	hai3",
		"一年半载", "	yi1	nian2	ban4	zai3",
		"坐不重席", "	zuo4	bu4	chong2	xi2",
		"炸土豆条", "	zha2	tu3	dou4	tiao2",
		"一年到头", "	yi4	nian2	dao4	tou2",
		"书本知识", "	shu1	ben3	zhi1	shi",
		"长目飞耳", "	chang2	mu4	fei1	er3",
		"虱胫虮肝", "	shi1	jing4	ji1	gan1",
		"歪歪倒倒", "	wai1	wai1	dao3	dao3",
		"脱袍退位", "	tuo1	pao2	tui4	wei4",
		"拖麻拽布", "	tuo1	ma2	zhuai4	bu4",
		"魂不守舍", "	hun2	bu4	shou3	she4",
		"长虑却顾", "	chang2	lv4	que4	gu4",
		"总体要求", "	zong3	ti3	yao1	qiu2",
		"屯蹶否塞", "	tun2	jue3	fou3	sai1",
		"疏不间亲", "	shu1	bu4	jian4	qin1",
		"推轮捧毂", "	tui1	lun2	peng3	gu1",
		"长虑后顾", "	chang2	lv4	hou4	gu4",
		"长虑顾后", "	chang2	lv4	gu4	hou4",
		"渣打银行", "	zha1	da3	yin2	hang2",
		"失马塞翁", "	shi1	ma3	sai4	weng1",
		"什围伍攻", "	shi2	wei2	wu3	gong1",
		"兔角龟毛", "	tu	jiao	gui	mao",
		"安时处顺", "	an1	shi2	chu3	shun4",
		"投资银行", "	tou2	zi1	yin2	hang2",
		"淡泊明志", "	dan4	bo2	ming2	zhi4",
		"百载树人", "	bai3	zai3	shu4	ren2",
		"调墨弄笔", "	tiao2	mo4	nong4	bi3",
		"一多对应", "	yi1	duo1	dui4	ying4",
		"树倒根摧", "	shu4	dao3	gen1	cui1",
		"天干地支", "	tian1	gan1	di4	zhi1",
		"百口莫辩", "	bai3	kou3	mo4	bian4",
		"参伍错综", "	cen1	wu3	cuo4	zong1",
		"束缊还妇", "	shu4	yun1	huan2	fu4",
		"浪卡子县", "	lang4	ka3	zi3	xian4",
		"田父献曝", "	tian2	fu3	xian4	pu4",
		"草头天子", "	cao3	tou2	tian1	zi3",
		"浪子回头", "	lang4	zi3	hui2	tou2",
		"梳云掠月", "	shu1	yun2	lue3	yue4",
		"一天到晚", "	yi4	tian1	dao4	wan3",
		"沈鱼落雁", "	chen2	yu2	luo4	yan4",
		"苍颜白发", "	cang1	yan2	bai2	fa4",
		"恬淡无为", "	tian2	dan4	wu2	wei2",
		"百身莫赎", "	bai3	shen1	mo4	shu2",
		"刚正不阿", "	gang1	zheng4	bu4	e1",
		"切向速度", "	qie1	xiang4	su4	du4",
		"腾腾兀兀", "	teng2	teng2	wu1	wu1",
		"白云亲舍", "	bai2	yun2	qin1	she4",
		"排难解纷", "	pai2	nan4	jie3	fen1",
		"炸土豆片", "	zha2	tu3	dou4	pian4",
		"一无所长", "	yi1	wu2	suo3	chang2",
		"鼓鼓囊囊", "	gu3	gu3	nang1	nang1",
		"与世长辞", "	yu3	shi4	chang2	ci2",
		"考试卷子", "	kao3	shi4	juan4	zi",
		"优游不断", "	you1	you2	bu4	duan4",
		"优游岁月", "	you1	you2	sui4	yue4",
		"腹笥便便", "	fu4	si4	pian2	pian2",
		"圣德太子", "	sheng4	de2	tai4	zi3",
		"兴灭继绝", "	xing1	mie4	ji4	jue2",
		"有志之士", "	you3	zhi4	zhi1	shi4",
		"兴旺发达", "	xing1	wang4	fa1	da2",
		"与人为善", "	yu3	ren2	wei2	shan4",
		"原始积累", "	yuan2	shi3	ji1	lei3",
		"老少皆宜", "	lao3	shao4	jie1	yi2",
		"与世无争", "	yu2	shi4	wu2	zheng1",
		"果实累累", "	guo3	shi2	lei3	lei3",
		"自视甚高", "	zi4	shi4	shen4	gao1",
		"与民更始", "	yu3	ren2	geng1	shi3",
		"胆大妄为", "	dan3	da4	wang4	wei2",
		"冤家路狭", "	yuan1	jia	lu4	xia2",
		"不可胜数", "	bu4	ke3	sheng4	shu3",
		"九齿钉耙", "	jiu3	chi3	ding1	pa2",
		"予智予雄", "	yu2	zhi4	yu2	xiong2",
		"有以善处", "	you3	yi3	shan4	chu3",
		"老两口儿", "	lao3	liang3	kou3	r",
		"组成部分", "	zu3	cheng2	bu4	fen",
		"曾母投杼", "	zeng1	mu3	tou2	zhu4",
		"习以为常", "	xi2	yi3	wei2	chang2",
		"置之脑后", "	zhi4	zhi1	nao3	hou4",
		"匀速运动", "	yun2	su4	yun4	dong4",
		"核反应堆", "	he2	fan3	ying4	dui1",
		"月晕而风", "	yue4	yun4	er2	feng1",
		"早占勿药", "	zao3	zhan1	wu4	yao4",
		"网络铁路", "	wang3	luo4	tie3	lu4",
		"干净俐落", "	gan1	jing4	li4	luo4",
		"月夜花朝", "	yue4	ye4	hua1	zhao1",
		"脱骨成佛", "	tuo1	gu3	cheng2	fo2",
		"东倒西歪", "	dong1	dao3	xi1	wai1",
		"干净利落", "	gan1	jing4	li4	luo4",
		"腹笥甚宽", "	fu4	si4	shen4	kuan1",
		"于无声处", "	yu2	wu2	sheng1	chu3",
		"芝麻小事", "	zhi1	ma	xiao3	shi4",
		"褎如充耳", "	you4	ru2	chong1	er3",
		"月夕花朝", "	yue4	xi1	hua1	zhao1",
		"事怕行家", "	shi4	pa4	hang2	jia1",
		"事在人为", "	shi4	zai4	ren2	wei2",
		"有所作为", "	you3	suo3	zuo4	wei2",
		"脊椎动物", "	ji3	zhui1	dong4	wu4",
		"指不胜偻", "	zhi3	bu4	sheng4	lv3",
		"澎湖群岛", "	peng2	hu2	qun2	dao3",
		"子丑寅卯", "	zi3	chou3	yin2	mao3",
		"绝食抗议", "	jue2	shi2	kang4	yi4",
		"溘先朝露", "	ke4	xian1	zhao1	lu4",
		"氢氧离子", "	qing1	yang3	li2	zi3",
		"氢原子核", "	qing1	yuan2	zi3	he2",
		"灭此朝食", "	mie4	ci3	zhao1	shi2",
		"神出鬼没", "	shen2	chu1	gui3	mo4",
		"一技之长", "	yi1	ji4	zhi1	chang2",
		"礼废乐崩", "	li3	fei4	yue4	beng1",
		"氧乙炔焊", "	yang3	yi3	que1	han4",
		"绍兴地区", "	shao4	xing1	di4	qu1",
		"置锥之地", "	zhi4	zhui1	zhi1	di4",
		"漏脯充饥", "	lou4	fu3	chong1	ji1",
		"细嚼慢咽", "	xi4	jiao2	man4	yan4",
		"瞻予马首", "	zhan1	yu2	ma3	shou3",
		"朝歌暮弦", "	zhao1	ge1	mu4	xian2",
		"追趋逐耆", "	zhui1	qu1	zhu2	shi4",
		"洁身自好", "	jie2	shen1	zi4	hao4",
		"朝歌夜弦", "	zhao1	ge1	ye4	xian2",
		"子孙满堂", "	zi3	sun1	man3	tang2",
		"澎湖列岛", "	peng2	hu2	lie4	dao3",
		"知识产业", "	zhi1	shi	chan3	ye4",
		"橡子面儿", "	xiang4	zi	mian4	r",
		"尽人皆知", "	jin4	ren2	jie1	zhi1",
		"花朝月夕", "	hua1	zhao1	yue4	xi1",
		"百废具兴", "	bai3	fei4	ju4	xing1",
		"石头火锅", "	shi2	tou	huo3	guo1",
		"不省人事", "	bu4	xing3	ren2	shi4",
		"乐善好施", "	le4	shan4	hao4	shi1",
		"栉风酾雨", "	zhi4	feng1	shi1	yu3",
		"止戈兴仁", "	zhi3	ge1	xing1	ren2",
		"瞎子摸象", "	xia1	zi3	mo1	xiang4",
		"不为所动", "	bu4	wei2	suo3	dong4",
		"不求甚解", "	bu4	qiu2	shen4	jie3",
		"相体裁衣", "	xiang4	ti3	cai2	yi1",
		"尽收眼底", "	jin4	shou1	yan3	di3",
		"不着边际", "	bu4	zhuo2	bian1	ji4",
		"指山卖磨", "	zhi3	shan1	mai4	mo4",
		"民间故事", "	min2	jian1	gu4	shi",
		"知识结构", "	zhi1	shi	jie2	gou4",
		"直系血亲", "	zhi2	xi4	xue4	qing4",
		"不定冠词", "	bu4	ding4	guan4	ci2",
		"目下十行", "	mu4	xia4	shi2	hang2",
		"指皂为白", "	zhi3	zao4	wei2	bai2",
		"尽欢而散", "	jin4	huan1	er2	san4",
		"黎明时分", "	li2	ming2	shi2	fen4",
		"爱出风头", "	ai4	chu1	feng1	tou",
		"扇枕温席", "	shan1	zhen3	wen1	xi2",
		"欺人太甚", "	qi1	ren2	tai4	shen4",
		"神号鬼哭", "	shen2	hao2	gui3	ku1",
		"玩儿不转", "	wan2	er2	bu4	zhuan4",
		"畏首畏尾", "	wei4	shou3	wei4	wei3",
		"为国为民", "	wei2	guo2	wei2	min2",
		"首要任务", "	shou3	yao4	ren4	wu",
		"为蛇添足", "	wei2	she2	tian1	zu2",
		"饶舌音乐", "	rao2	she2	yin1	yue4",
		"番茄红素", "	fan1	qie2	hong2	su4",
		"为数不少", "	wei2	shu4	bu4	shao3",
		"电动葫芦", "	dian4	dong4	hu2	lu",
		"神至之笔", "	shen2	zhi4	zhi1	bi3",
		"北斗七星", "	bei3	dou3	qi1	xing1",
		"超然独处", "	chao1	ran2	du2	chu3",
		"异曲同工", "	yi4	qu3	tong2	gong1",
		"巢居穴处", "	chao2	ju1	xue2	chu3",
		"畏威怀德", "	wei4	wei1	huai2	de2",
		"化险为夷", "	hua4	xian3	wei2	yi2",
		"权利要求", "	quan2	li4	yao1	qiu2",
		"昼乾夕惕", "	zhou4	qian2	xi1	ti4",
		"违法行为", "	wei2	fa3	xing2	wei2",
		"故地重游", "	gu4	di4	chong2	you2",
		"操作系统", "	cao1	zuo1	xi4	tong3",
		"诗肠鼓吹", "	shi1	cha2	gu3	chui4",
		"电磁干扰", "	dian4	ci2	gan1	rao3",
		"电子器件", "	dian4	zi3	qi4	jian4",
		"威望素著", "	wei1	wang4	su4	zhu4",
		"长揖不拜", "	chang2	yi1	bu4	bai4",
		"光禄大夫", "	guang1	lu4	dai4	fu",
		"鞠躬尽瘁", "	ju1	gong1	jin4	cui4",
		"长驱直入", "	chang2	qu1	zhi2	ru4",
		"文过遂非", "	wen2	guo4	sui2	fei1",
		"男性厌恶", "	nan2	xing4	yan4	wu4",
		"颠三倒四", "	dian1	san1	dao3	si4",
		"深文曲折", "	shen1	wen2	qu3	she2",
		"枉曲直凑", "	wang3	qu3	zhi2	cou4",
		"汇业银行", "	hui4	ye4	yin2	hang2",
		"颠来倒去", "	dian1	lai2	dao3	qu4",
		"放不下心", "	fang4	bu	xia4	xin1",
		"放下包袱", "	fang4	xia	bao1	fu",
		"文房四侯", "	wen2	fang2	si4	hou4",
		"先入为主", "	xian1	ru4	wei2	zhu3",
		"危于累卵", "	wei1	yu2	lei3	luan3",
		"望风披靡", "	wang4	feng1	pi1	mi3",
		"长途奔袭", "	chang2	tu2	ben1	xi2",
		"擢发难数", "	zhuo2	fa4	nan2	shu3",
		"深厉浅揭", "	shen1	li4	qian3	qi4",
		"委委佗佗", "	wei1	wei1	tuo2	tuo2",
		"裙屐少年", "	qun2	ji1	shao4	nian2",
		"旷日累时", "	kuang4	ri4	lei3	shi2",
		"瑟调琴弄", "	se4	tiao2	qin2	nong4",
		"前半晌儿", "	qian2	ban4	shang3	r",
		"久安长治", "	jiu3	an1	chang2	zhi4",
		"尽忠竭力", "	jin4	zhong1	jie2	li4",
		"深谷为陵", "	shen1	gu3	wei2	ling2",
		"朝生暮死", "	zhao1	sheng1	mu4	si3",
		"朝升暮合", "	zhao1	sheng1	mu4	ge3",
		"总会计师", "	zong3	kuai4	ji4	shi1",
		"狼子兽心", "	lang2	zi3	shou4	xin1",
		"款曲周至", "	kuan3	qu3	zhou1	zhi4",
		"杀妻求将", "	sha1	qi1	qiu2	jiang4",
		"曲终人散", "	qu3	zhong1	ren2	san4",
		"朝令暮改", "	zhao1	ling4	mu4	gai3",
		"朝经暮史", "	zhao1	jing1	mu4	shi3",
		"朝生夕死", "	zhao1	sheng1	xi1	si3",
		"朝趁暮食", "	zhao1	chen4	mu4	shi2",
		"施工合同", "	shi1	gong1	he2	tong",
		"太古洋行", "	tai4	gu3	yang2	hang2",
		"似水流年", "	si4	shui3	liu2	nian2",
		"子夏悬鹑", "	zi3	xia4	xuan2	chun2",
		"朝衣东市", "	zhao1	yi1	dong1	shi4",
		"十夫楺椎", "	shi2	fu1	zhi1	zhui1",
		"朝更暮改", "	zhao1	geng4	mu4	gai3",
		"生死未卜", "	sheng1	si3	wei4	bu3",
		"长途直拨", "	chang2	tu2	zhi2	bo1",
		"十夫桡椎", "	shi2	fu1	rao2	zhui1",
		"审己度人", "	shen3	ji3	duo2	ren2",
		"食物中毒", "	shi2	wu4	zhong4	du2",
		"十四行诗", "	shi2	si4	hang2	shi1",
		"收拾残局", "	shou1	shi	can2	ju2",
		"进退中度", "	jin4	tui4	zhong4	du4",
		"善财童子", "	shan4	cai2	tong2	zi3",
		"周郎顾曲", "	zhou1	lang2	gu4	qu3",
		"瑟弄琴调", "	se4	nong4	qin2	tiao2",
		"曲意承迎", "	qu3	yi4	cheng2	ying2",
		"累牍连篇", "	lei3	du2	lian2	pian1",
		"硕望宿德", "	shuo4	wang4	xiu3	de2",
		"金相玉质", "	jin1	xiang4	yu4	zhi4",
		"钻冰取火", "	zuan4	bing1	qu3	huo3",
		"纵曲枉直", "	zong4	qu3	wang3	zhi2",
		"走为上策", "	zou3	wei2	shang4	ce4",
		"孀妻弱子", "	shuang1	qi1	ruo4	zi3",
		"博闻强识", "	bo2	wen2	qiang2	zhi4",
		"风尘仆仆", "	feng1	chen2	pu2	pu2",
		"优哉游哉", "	you1	zai1	you2	zai1",
		"长恶靡悛", "	chang2	e4	mi3	quan1",
		"男孩乐队", "	nan2	hai2	yue4	dui4",
		"不了而了", "	bu4	liao3	er2	liao3",
		"拜人为师", "	bai4	ren2	wei2	shi1",
		"不了不当", "	bu4	liao3	bu4	dang4",
		"变危为安", "	bian4	wei1	wei2	an1",
		"遂心快意", "	sui2	xin1	kuai4	yi4",
		"遂迷忘反", "	sui2	mi2	wang4	fan3",
		"拾级而上", "	she4	ji2	er2	shang4",
		"薄弱环节", "	bo2	ruo4	huan2	jie2",
		"薄命佳人", "	bo2	ming4	jia1	ren2",
		"挑拨离间", "	tiao3	bo1	li2	jian4",
		"泰然处之", "	tai4	ran2	chu3	zhi1",
		"理性认识", "	li3	xing4	ren4	shi",
		"挑拨是非", "	tiao3	bo1	shi4	fei1",
		"屏气敛息", "	bing3	qi4	lian3	xi1",
		"遂非文过", "	sui2	fei1	wen2	guo4",
		"拨乱为治", "	bo1	luan4	wei2	zhi4",
		"肆意横行", "	si4	yi4	heng2	xing2",
		"夙兴昧旦", "	su4	xing1	mei4	dan4",
		"宋词元曲", "	song4	ci2	yuan2	qu3",
		"初露头角", "	chu1	lu4	tou2	jiao3",
		"标记原子", "	biao1	ji4	yuan2	zi3",
		"泰来否往", "	tai4	lai2	pi3	wang3",
		"韬戈卷甲", "	tao1	ge1	juan4	jia3",
		"投传而去", "	tou2	zhuan4	er2	qu4",
		"通同一气", "	tong1	tong2	yi1	yi4",
		"长恶不悛", "	chang2	e4	bu4	quan1",
		"实验研究", "	shi2	yan4	yan2	jiu1",
		"同工异曲", "	tong2	gong1	yi4	qu3",
		"为非作歹", "	wei2	fei1	zuo4	dai3",
		"调朱傅粉", "	tiao2	zhu1	fu4	fen3",
		"力尽神危", "	li4	jin4	shen2	wei1",
		"出没无常", "	chu1	mo4	wu2	chang2",
		"并为一谈", "	bing4	wei2	yi1	tan2",
		"无以为生", "	wu2	yi3	wei2	sheng1",
		"嗒然若丧", "	ta4	ran2	ruo4	sang4",
		"首都领地", "	shou3	du1	ling3	di4",
		"排忧解难", "	pai2	you1	jie3	nan4",
		"隋珠弹雀", "	sui2	zhu1	tan2	que4",
		"别无长物", "	bie2	wu2	chang2	wu4",
		"百废俱兴", "	bai3	fei4	ju4	xing1",
		"别开蹊径", "	bie2	kai1	xi1	jing4",
		"别别扭扭", "	bie4	bie4	niu2	niu",
		"标题音乐", "	biao1	ti2	yin1	yue4",
		"岁序更新", "	sui4	xu4	geng1	xin1",
		"不遑启处", "	bu4	huang2	qi3	chu3",
		"叹观止矣", "	tan4	guan1	zhi3	yi3",
		"男女老少", "	nan2	nv3	lao3	shao4",
		"鞭辟着里", "	bian1	bi4	zhuo2	li3",
		"捏脊治疗", "	nie1	ji3	zhi4	liao2",
		"切磋琢磨", "	qie1	cuo1	zhuo2	mo2",
		"李氏朝鲜", "	li3	shi4	chao2	xian3",
		"本本分分", "	ben3	ben3	fen4	fen1",
		"本相毕露", "	ben3	xiang4	bi4	lu4",
		"碧波荡漾", "	bi4	bo1	dang4	yang4",
		"蔽聪塞明", "	bi4	conɡ1	se4	minɡ2",
		"闭明塞聪", "	bi4	ming2	se4	cong1",
		"四方之志", "	si4	fang1	zhi1	zhi4",
		"北门锁钥", "	bei3	men2	suo3	yue4",
		"欧阳予倩", "	ou1	yang2	yu2	qian4",
		"十行俱下", "	shi2	hang2	ju4	xia4",
		"调丝品竹", "	tiao2	si1	pin3	zhu2",
		"用尽心机", "	yong4	jin4	xin1	ji1",
		"包皮环切", "	bao1	pi2	huan2	qie1",
		"电子工业", "	dian4	zi3	gong1	ye4",
		"蛇蝎为心", "	she2	xie1	wei2	xin1",
		"唯唯否否", "	wei3	wei3	fou3	fou3",
		"兆电子伏", "	zhao4	dian4	zi3	fu2",
		"深恶痛疾", "	shen1	wu4	tong4	ji2",
		"铄古切今", "	shuo4	gu3	qie1	jin1",
		"顺蔓摸瓜", "	shun4	wan4	mo1	gua1",
		"弹剑作歌", "	tan2	jian4	zuo4	ge1",
		"卑辞重币", "	bei1	ci2	zhong4	bi4",
		"暴露文学", "	bao4	lou4	wen2	xue2",
		"唐虞之治", "	tang2	yu2	zhi1	zhi4",
		"才占八斗", "	cai2	zhan1	ba1	dou3",
		"主客颠倒", "	zhu3	ke4	dian1	dao3",
		"助桀为虐", "	zhu4	jie2	wei2	nue4",
		"采购合同", "	cai3	gou4	he2	tong",
		"抱柱之信", "	bao4	zhu4	zhi1	xin4",
		"抱子弄孙", "	bao4	zi3	nong4	sun1",
		"悲悲切切", "	bei1	bei1	qie4	qie1",
		"助桀为暴", "	zhu4	jie2	wei2	bao4",
		"削职为民", "	xue1	zhi2	wei2	min2",
		"北斗之尊", "	bei3	dou3	zhi1	zun1",
		"甚感诧异", "	shen4	gan3	cha4	yi4",
		"前半天儿", "	qian2	ban4	tian1	r",
		"才薄智浅", "	cai1	bo2	zhi4	qian3",
		"不知颠倒", "	bu4	zhi1	dian1	dao3",
		"不着疼热", "	bu4	zhuo2	teng2	re4",
		"削铅笔机", "	xiao1	qian1	bi3	ji1",
		"铸剑为犁", "	zhu4	jian4	wei2	li2",
		"背曲腰躬", "	bei4	qu3	yao1	gong1",
		"捧腹绝倒", "	peng3	fu4	jue2	dao3",
		"丧失殆尽", "	sang4	shi1	dai4	jin4",
		"束缊请火", "	shu4	yun4	qing3	huo3",
		"调词架讼", "	tiao2	ci2	jia4	song4",
		"苍劲有力", "	cang1	jing4	you3	li4",
		"目挑心招", "	mu4	tiao3	xin1	zhao1",
		"拓扑空间", "	tuo4	pu1	kong1	jian1",
		"流行音乐", "	liu2	xing2	yin1	yue4",
		"拐弯抹角", "	guai3	wan1	mo4	jiao3",
		"长舌之妇", "	chang2	she2	zhi1	fu4",
		"找不着北", "	zhao3	bu	zhao2	bei3",
		"惨绿少年", "	can3	lv4	shao4	nian2",
		"长驱直进", "	chang2	qu1	zhi2	jin4",
		"称心快意", "	chen4	xin1	kuai4	yi4",
		"沦没丧亡", "	lun2	mo4	sang4	wang2",
		"材高知深", "	cai2	gao1	zhi4	shen1",
		"长驱深入", "	chang2	qu1	shen1	ru4",
		"抽丝剥茧", "	chou1	si1	bao1	jian3",
		"长此以往", "	chang2	ci3	yi3	wang3",
		"长短不一", "	chang2	duan3	bu4	yi1",
		"长歌当哭", "	chang2	ge1	dang4	ku1",
		"奉为圭臬", "	feng4	wei2	gui1	nie4",
		"牢靠妥当", "	lao2	kao4	tuo3	dang4",
		"晨兴夜寐", "	chen2	xing1	ye4	mei4",
		"矫国更俗", "	jiao3	guo2	geng1	su2",
		"冲冠怒发", "	chong1	guan4	nu4	fa4",
		"重规累矩", "	chong2	gui1	lei4	ju3",
		"吃斋念佛", "	chi1	zhai1	nian4	fo2",
		"霸道横行", "	ba4	dao4	heng2	xing2",
		"疾风劲草", "	ji2	feng1	jing4	cao3",
		"当行出色", "	dang1	hang2	chu1	se4",
		"拜倒辕门", "	bai4	dao3	yuan2	men2",
		"饥冻交切", "	ji1	dong4	jiao1	qie1",
		"白发苍苍", "	bai2	fa4	cang1	cang1",
		"冲冠发怒", "	chong1	guan4	fa1	nu4",
		"槟榔西施", "	bing1	lang	xi1	shi1",
		"威慑力量", "	wei1	she4	li4	liang",
		"威化饼干", "	wei1	hua4	bing3	gan1",
		"白发青衫", "	bai2	fa4	qing1	shan1",
		"机关算尽", "	ji1	guan1	suan4	jin4",
		"白黑颠倒", "	bai2	hei1	dian1	dao3",
		"手不释卷", "	shou3	bu4	shi4	juan4",
		"扬长而去", "	yang2	chang2	er2	qu4",
		"舂容大雅", "	chong1	rong2	da4	ya2",
		"长戟高门", "	chang2	ji3	gao1	men2",
		"长计远虑", "	chang2	ji4	yuan3	lv4",
		"重迹屏气", "	chong2	ji4	bing3	qi4",
		"招人喜欢", "	zhao1	ren2	xi3	huan",
		"屏退左右", "	bing3	tui4	zuo3	you4",
		"活神仙似", "	huo2	shen2	xian1	si4",
		"泰山北斗", "	tai4	shan1	bei3	dou3",
		"薄寒中人", "	bo2	han2	zhong4	ren2",
		"长夜之饮", "	chang2	ye4	zhi1	yin3",
		"长吁短气", "	chang2	xu1	duan3	qi4",
		"不差上下", "	bu4	cha1	shang4	xia4",
		"法国长棍", "	fa3	guo2	chang2	gun4",
		"倡条冶叶", "	chang1	tiao2	ye3	ye4",
		"不相为谋", "	bu4	xiang1	wei2	mou2",
		"夹脚拖鞋", "	jia2	jiao3	tuo1	xie2",
		"深恶痛绝", "	shen1	wu4	tong4	jue2",
		"长斋礼佛", "	chang2	zhai1	li3	fo2",
		"隔行扫描", "	ge2	hang2	sao3	miao2",
		"恶语中伤", "	e4	yu3	zhong4	shang1",
		"收购要约", "	shou1	gou4	yao1	yue1",
		"电磁感应", "	dian4	ci2	gan3	ying4",
		"测量工具", "	ce4	liang2	gong1	ju4",
		"没完没了", "	mei2	wan2	mei2	liao3",
		"派拉蒙影", "	pai4	la1	meng3	ying3",
		"液晶显示", "	ye4	jing1	xian3	shi4",
		"别创一格", "	bie2	chuang4	yi2	ge2",
		"长久之计", "	chang2	jiu3	zhi1	ji4",
		"层台累榭", "	ceng2	tai2	lei3	xie4",
		"表面处理", "	biao3	mian4	chu3	li3",
		"材薄质衰", "	cai2	bo2	zhi4	shuai1",
		"畅所欲为", "	chang4	suo3	yu4	wei2",
		"消息来源", "	xiao1	xi	lai2	yuan2",
		"角巾东路", "	jiao3	jin1	dong1	lu4",
		"海盗行为", "	hai3	dao4	xing2	wei2",
		"矫情干誉", "	jiao3	qing2	gan1	yu4",
		"屏声息气", "	bing3	sheng1	xi1	qi4",
		"趁水和泥", "	chen4	shui3	huo4	ni2",
		"宾主尽欢", "	bin1	zhu3	jin4	huan1",
		"挑灯拨火", "	tiao3	deng1	bo1	huo3",
		"深更半夜", "	shen1	geng1	ban4	ye4",
		"扯篷拉纤", "	che3	peng2	la1	qian4",
		"超今冠古", "	chao1	jin1	guan4	gu3",
		"冰山易倒", "	bing1	shan1	yi4	dao3",
		"胶柱调瑟", "	jiao1	zhu4	tiao2	se4",
		"戳脊梁骨", "	chuo1	ji3	liang	gu3",
		"安老怀少", "	an1	lao3	huai2	shao4",
		"电邮位置", "	dian4	you2	wei4	zhi",
		"百中百发", "	bai3	zhong4	bai3	fa1",
		"词优效应", "	ci2	you1	xiao4	ying4",
		"万古长新", "	wan4	gu3	chang2	xin1",
		"阶级成分", "	jie1	ji2	cheng2	fen4",
		"随机应变", "	sui2	ji1	ying4	bian4",
		"缓发中子", "	huan3	fa1	zhong1	zi3",
		"排起长队", "	pai2	qi3	chang2	dui4",
		"购销合同", "	gou4	xiao1	he2	tong",
		"长眠不起", "	chang2	mian2	bu4	qi3",
		"紧急应变", "	jin3	ji2	ying4	bian4",
		"宽大为怀", "	kuan1	da4	wei2	huai2",
		"好整以暇", "	hao4	zheng3	yi3	xia2",
		"排山倒海", "	pai2	shan1	dao3	hai3",
		"甲壳动物", "	jia3	qiao4	dong4	wu4",
		"积微成著", "	ji1	wei1	cheng2	zhu4",
		"正人君子", "	zheng4	ren2	jun1	zi3",
		"击中要害", "	ji1	zhong4	yao4	hai4",
		"抱关执钥", "	bao4	guan1	zhi2	yue4",
		"聚变反应", "	ju4	bian4	fan3	ying4",
		"调味肉汁", "	tiao2	wei4	rou4	zhi1",
		"价格行情", "	jia4	ge2	hang2	qing2",
		"认知失调", "	ren4	zhi1	shi1	tiao2",
		"亲朋好友", "	qin1	peng2	hao2	you",
		"亲生子女", "	qin1	sheng1	zi3	nu:3",
		"兴高彩烈", "	xing1	gao1	cai3	lie4",
		"有两下子", "	you3	liang3	xia4	zi3",
		"解铃系铃", "	jie3	ling2	ji4	ling2",
		"调嘴学舌", "	tiao2	zui3	xue2	she2",
		"讨价还价", "	tao3	jia4	huan2	jia4",
		"词频效应", "	ci2	pin2	xiao4	ying4",
		"飞灾横祸", "	fei1	zai1	heng4	huo4",
		"国难当头", "	guo2	nan4	dang1	tou2",
		"良家女子", "	liang2	jia1	nu:3	zi3",
		"非意相干", "	fei1	yi4	xiang1	gan1",
		"谁人乐队", "	shei2	ren2	yue4	dui4",
		"草草了事", "	cao3	cao3	liao3	shi4",
		"贡禹弹冠", "	gong4	yu3	tan2	guan1",
		"小缸缸儿", "	xiao3	gang1	gang	r",
		"公子王孙", "	gong1	zi3	wang2	sun1",
		"柔情似水", "	rou2	qing2	si4	shui3",
		"包皮过长", "	bao1	pi2	guo4	chang2",
		"现代音乐", "	xian4	dai4	yin1	yue4",
		"重门击柝", "	chong2	men2	ji1	tuo4",
		"机关用尽", "	ji1	guan1	yong4	jin4",
		"捋臂揎拳", "	luo1	bi4	xuan1	quan2",
		"婚姻调解", "	hun1	yin1	tiao2	jie3",
		"火尽灰冷", "	huo3	jin4	hui1	leng3",
		"百般刁难", "	bai3	ban1	diao1	nan4",
		"百发百中", "	bai3	fa1	bai3	zhong4",
		"成分分析", "	cheng2	fen4	fen1	xi1",
		"百废待兴", "	bai3	fei4	dai4	xing1",
		"沙加缅度", "	sha1	jia1	mian3	duo2",
		"鞭辟向里", "	bian1	bi4	xiang4	li3",
		"成风尽垩", "	cheng2	feng1	jin4	e4",
		"发言中肯", "	fa1	yan2	zhong4	ken3",
		"鞭长不及", "	bian1	chang2	bu4	ji2",
		"变废为宝", "	bian4	fei4	wei2	bao3",
		"北门管钥", "	bei3	men2	guan3	yue4",
		"表里为奸", "	biao3	li3	wei2	jian1",
		"百下百着", "	bai3	xia4	bai3	zhao2",
		"充分发挥", "	chong1	fen4	fa1	hui1",
		"重葩累藻", "	chong2	pa1	lei4	zao3",
		"尽善尽美", "	jin4	shan4	jin4	mei3",
		"霍尔效应", "	huo4	er3	xiao4	ying4",
		"正月初一", "	zheng1	yue4	chu1	yi1",
		"舍车保帅", "	she3	ju1	bao3	shuai4",
		"夹心饼干", "	jia1	xin1	bing3	gan1",
		"赍粮藉寇", "	ji1	liang2	jie4	kou4",
		"俭不中礼", "	jian3	bu4	zhong4	li3",
		"抱蔓摘瓜", "	bao4	wan4	zhai1	gua1",
		"正确处理", "	zheng4	que4	chu3	li3",
		"正负电子", "	zheng4	fu4	dian4	zi3",
		"犯罪行为", "	fan4	zui4	xing2	wei2",
		"武装分子", "	wu3	zhuang1	fen4	zi3",
		"卑宫菲食", "	bei1	gong1	fei3	shi2",
		"贝阙珠宫", "	bei4	que4	zhu1	gong1",
		"见哭兴悲", "	jian4	ku1	xing1	bei1",
		"简能而任", "	jian3	neng2	er2	ren4",
		"歃血为盟", "	sha4	xue4	wei2	meng2",
		"槛花笼鹤", "	jian4	hua1	long2	he4",
		"见义当为", "	jian4	yi4	dang1	wei2",
		"白衣宰相", "	bai2	yi1	zai3	xiang4",
		"横行霸道", "	heng2	xing2	ba4	dao4",
		"乘间伺隙", "	cheng2	jian1	si4	xi4",
		"催化反应", "	cui1	hua4	fan3	ying4",
		"摧刚为柔", "	cui1	gang1	wei2	rou2",
		"亲子鉴定", "	qin1	zi3	jian4	ding4",
		"审时度势", "	shen3	shi2	duo2	shi4",
		"香榭丽舍", "	xiang1	xie4	li4	she4",
		"科教兴国", "	ke1	jiao4	xing1	guo2",
		"毫发不爽", "	hao2	fa4	bu4	shuang3",
		"桁杨刀锯", "	hang2	yang2	dao1	ju4",
		"揣时度力", "	chuai3	shi2	duo2	li4",
		"华夏银行", "	hua2	xia4	yin2	hang2",
		"转悲为喜", "	zhuan3	bei1	wei2	xi3",
		"累加总数", "	lei3	jia1	zong3	shu4",
		"好勇斗狠", "	hao4	yong3	dou4	hen3",
		"鹄面鸠形", "	hu2	mian4	jiu1	xing2",
		"化枭为鸠", "	hua4	xiao1	wei2	jiu1",
		"哗世取宠", "	hua2	shi4	qu3	chong3",
		"红颜薄命", "	hong2	yan2	bo2	ming4",
		"化鸱为凤", "	hua4	chi1	wei2	feng4",
		"孔子学院", "	kong3	zi3	xue2	yuan4",
		"鹄峙鸾停", "	hu2	zhi4	luan2	ting2",
		"审度时势", "	shen3	duo2	shi2	shi4",
		"触类而长", "	chu4	lei4	er2	chang2",
		"鹤短凫长", "	he4	duan3	fu2	chang2",
		"行伍出身", "	hang2	wu3	chu1	shen1",
		"飞来横祸", "	fei1	lai2	heng4	huo4",
		"颠倒是非", "	dian1	dao3	shi4	fei1",
		"颠倒过来", "	dian1	dao3	guo4	lai2",
		"颠倒黑白", "	dian1	dao3	hei1	bai2",
		"风土人情", "	feng1	tu2	ren2	qing2",
		"站不住脚", "	zhan4	bu	zhu4	jiao3",
		"穷于应付", "	qiong2	yu2	ying4	fu4",
		"风雨漂摇", "	feng1	yu3	piao1	yao2",
		"完全懂得", "	wan2	quan2	dong3	de",
		"横行逆施", "	heng2	xing2	ni4	shi1",
		"首都机场", "	shou3	du1	ji1	chang3",
		"骄阳似火", "	jiao1	yang2	si4	huo3",
		"养尊处优", "	yang3	zun1	chu3	you1",
		"棺材瓤子", "	guan1	cai	rang2	zi",
		"空气调节", "	kong1	qi4	tiao2	jie2",
		"横灾飞祸", "	heng4	zai1	fei1	huo4",
		"养虎为患", "	yang3	hu3	wei2	huan4",
		"触物兴怀", "	chu4	wu4	xing1	huai2",
		"首都剧场", "	shou3	du1	ju4	chang3",
		"矮杆品种", "	ai3	gan3	pin3	zhong3",
		"石膏绷带", "	shi2	gao1	beng1	dai4",
		"鹤长凫短", "	he4	chang2	fu2	duan3",
		"横征苛役", "	heng4	zheng1	ke1	yi4",
		"回山倒海", "	hui2	shan1	dao3	hai3",
		"相夫教子", "	xiang4	fu1	jiao4	zi3",
		"相差不多", "	xiang1	cha4	bu	duo1",
		"好生之德", "	hao4	sheng1	zhi1	de2",
		"桴鼓相应", "	fu2	gu3	xiang1	ying4",
		"稀里光当", "	xi1	li	guang1	dang1",
		"黄绵袄子", "	huang2	mian2	ao3	zi3",
		"相机而动", "	xiang4	ji1	er2	dong4",
		"黄冠野服", "	huang2	guan4	ye3	fu2",
		"回天运斗", "	hui2	tian1	yun4	dou3",
		"换斗移星", "	huan4	dou3	yi2	xing1",
		"患难与共", "	huan4	nan4	yu3	gong4",
		"瞬发中子", "	shun4	fa1	zhong1	zi3",
		"还年驻色", "	huan2	nian2	zhu4	se4",
		"还淳返朴", "	huan2	chun2	fan3	pu3",
		"众矢之的", "	zhong4	shi3	zhi1	di4",
		"相机而行", "	xiang4	ji1	er2	xing2",
		"眼泪横流", "	yan3	lei4	heng4	liu2",
		"寓意深长", "	yu4	yi4	shen1	chang2",
		"还淳反素", "	huan2	chun2	fan3	su4",
		"胡行乱为", "	hu2	xing2	luan4	wei2",
		"实际应用", "	shi2	ji4	ying4	yong4",
		"毫不相干", "	hao2	bu4	xiang1	gan1",
		"知之甚微", "	zhi1	zhi1	shen4	wei1",
		"硕果累累", "	shuo4	guo3	lei2	lei2",
		"狐唱枭和", "	hu2	chang4	xiao1	he2",
		"孤身只影", "	gu1	shen1	zhi1	ying3",
		"红绳系足", "	hong2	sheng2	ji4	zu2",
		"红寡妇鸟", "	hong2	gua3	fu	niao3",
		"好为事端", "	hao4	wei2	shi4	duan1",
		"浩气长存", "	hao4	qi4	chang2	cun2",
		"还淳反古", "	huan2	chun2	fan3	gu3",
		"鸿篇巨著", "	hong2	pian1	ju4	zhu4",
		"礼坏乐崩", "	li3	huai4	yue4	beng1",
		"寥寥可数", "	liao2	liao2	ke3	shu3",
		"察察为明", "	cha2	cha2	wei2	ming2",
		"礼崩乐坏", "	li3	beng1	yue4	huai4",
		"礼乐崩坏", "	li3	yue4	beng1	huai4",
		"呼天抢地", "	hu1	tian1	qiang1	di4",
		"秀发垂肩", "	xiu4	fa4	chui2	jian1",
		"频率调制", "	pin2	lu:4	tiao2	zhi4",
		"音乐电视", "	yin1	yue4	dian4	shi4",
		"霍乱杆菌", "	huo4	luan4	gan3	jun1",
		"溢出效应", "	yi4	chu1	xiao4	ying4",
		"春色撩人", "	chun1	se4	liao2	ren2",
		"青藏铁路", "	qing1	zang4	tie3	lu4",
		"气冲牛斗", "	qi4	chong1	niu2	dou3",
		"唇干口燥", "	chun2	gan1	kou3	zao4",
		"恶意中伤", "	e4	yi4	zhong4	shang1",
		"电子邮件", "	dian4	zi3	you2	jian4",
		"满口脏话", "	man3	kou3	zang1	hua4",
		"怒发冲冠", "	nu4	fa4	chong1	guan1",
		"随机效应", "	sui2	ji1	xiao4	ying4",
		"春深似海", "	chun1	shen1	si4	hai3",
		"随行就市", "	sui2	hang2	jiu4	shi4",
		"随风倒柳", "	sui2	feng1	dao3	liu3",
		"当头棒喝", "	dang1	tou2	bang4	he4",
		"水底相机", "	shui3	di3	xiang4	ji1",
		"浑身解数", "	hun2	shen1	xie4	shu4",
		"随风倒舵", "	sui2	feng1	dao3	duo4",
		"难兄难弟", "	nan4	xiong1	nan4	di4",
		"游说团体", "	you2	shui4	tuan2	ti3",
		"没颠没倒", "	mei2	dian1	mei2	dao3",
		"漫漫长夜", "	man4	man4	chang2	ye4",
		"树碑立传", "	shu4	bei1	li4	zhuan4",
		"热岛效应", "	re4	dao3	xiao4	ying4",
		"历尽沧桑", "	li4	jin4	cang1	sang1",
		"寸长尺技", "	cun4	chang2	chi3	ji4",
		"为人师表", "	wei2	ren2	shi1	biao3",
		"青堂瓦舍", "	qing1	tang2	wa3	she4",
		"非分之念", "	fei1	fen4	zhi1	nian4",
		"燕雀处堂", "	yan4	que4	chu3	tang2",
		"啜英咀华", "	chuo4	ying1	ju3	hua2",
		"死海经卷", "	si3	hai3	jing1	juan4",
		"烟熏火燎", "	yan1	xun1	huo3	liao3",
		"民间音乐", "	min2	jian1	yin1	yue4",
		"煎炸食品", "	jian1	zha2	shi2	pin3",
		"非杠杆化", "	fei1	gang4	gan3	hua4",
		"壳牌公司", "	qiao4	pai2	gong1	si1",
		"烈火干柴", "	lie4	huo3	gan1	chai2",
		"炎黄子孙", "	yan2	huang2	zi3	sun1",
		"感性认识", "	gan3	xing4	ren4	shi",
		"较德焯勤", "	jiao4	de2	zhuo1	qin2",
		"鞭长莫及", "	bian1	chang2	mo4	ji2",
		"敢为人先", "	gan3	wei2	ren2	xian1",
		"改善关系", "	gai3	shan4	guan1	xi",
		"骆驼祥子", "	luo4	tuo2	xiang2	zi3",
		"应试教育", "	ying4	shi4	jiao4	yu4",
		"处变不惊", "	chu3	bian4	bu4	jing1",
		"应有尽有", "	ying1	you3	jin4	you3",
		"高丽王朝", "	gao1	li2	wang2	chao2",
		"应用科学", "	ying4	yong4	ke1	xue2",
		"鲜为人知", "	xian3	wei2	ren2	zhi1",
		"除患兴利", "	chu2	huan4	xing1	li4",
		"重足屏息", "	chong2	zu2	bing3	xi1",
		"重振旗鼓", "	chong2	zhen4	qi2	gu3",
		"重兴旗鼓", "	chong2	xing1	qi2	gu3",
		"等差数列", "	deng3	cha1	shu4	lie4",
		"黄毛丫头", "	huang2	mao2	ya1	tou",
		"黑咕隆咚", "	hei1	gu1	long1	dong1",
		"重熙累洽", "	chong2	xi1	lei3	qia4",
		"重足屏气", "	chong2	zu2	bing3	qi4",
		"韩国银行", "	han2	guo2	yin2	hang2",
		"哼哈二将", "	heng1	ha1	er4	jiang4",
		"横科暴敛", "	heng4	ke1	bao4	lian3",
		"骨牌效应", "	gu3	pai2	xiao4	ying4",
		"处高临深", "	chu3	gao1	lin2	shen1",
		"音乐学院", "	yin1	yue4	xue2	yuan4",
		"电子商务", "	dian4	zi3	shang1	wu4",
		"电子文件", "	dian4	zi3	wen2	jian4",
		"毁舟为杕", "	hui3	zhou1	wei2	duo4",
		"电子层数", "	dian4	zi3	ceng2	shu4",
		"悄无声息", "	qiao3	wu2	sheng1	xi1",
		"绞尽脑汁", "	jiao3	jin4	nao3	zhi1",
		"横祸飞灾", "	heng4	huo4	fei1	zai1",
		"家常豆腐", "	jia1	chang2	dou4	fu",
		"河清云庆", "	he2	qing1	yun2	qing4",
		"黑白颠倒", "	hei1	bai2	dian1	dao3",
		"横倒竖歪", "	heng2	dao3	shu4	wai1",
		"吹叶嚼蕊", "	chui1	ye4	jiao2	rui3",
		"措置失当", "	cuo4	zhi4	shi1	dang4",
		"电子网络", "	dian4	zi3	wang3	luo4",
		"电子警察", "	dian4	zi3	jing3	cha2",
		"简单地说", "	jian3	dan1	de	shuo1",
		"政治避难", "	zheng4	zhi4	bi4	nan4",
		"放热反应", "	fang4	re4	fan3	ying4",
		"待时守分", "	dai4	shi2	shou3	fen4",
		"矮子观场", "	ai3	zi3	guan1	chang2",
		"兴师问罪", "	xing1	shi1	wen4	zui4",
		"眼见为实", "	yan3	jian4	wei2	shi2",
		"花不棱登", "	hua1	bu4	leng1	deng1",
		"重蹈覆辙", "	chong2	dao3	fu4	zhe2",
		"强凫变鹤", "	qiang3	fu2	bian4	he4",
		"颠唇簸嘴", "	dian1	chun2	bo4	zui3",
		"竭尽所能", "	jie2	jin4	suo3	neng2",
		"弓折刀尽", "	gong1	zhe2	dao1	jin4",
		"绷扒吊拷", "	beng1	ba1	diao4	kao3",
		"绷爬吊拷", "	beng1	pa2	diao4	kao3",
		"斗筲之材", "	dou3	shao1	zhi1	cai2",
		"翘首以待", "	qiao2	shou2	yi3	dai4",
		"军事力量", "	jun1	shi4	li4	liang",
		"纶巾羽扇", "	guan1	jin1	yu3	shan4",
		"绷巴吊拷", "	beng4	ba1	diao4	kao3",
		"动画片儿", "	dong4	hua4	pian1	er",
		"灯尽油干", "	deng1	jin4	you2	gan4",
		"长治久安", "	chang2	zhi4	jiu3	an1",
		"东横西倒", "	dong1	heng2	xi1	dao3",
		"切中时弊", "	qie4	zhong4	shi2	bi4",
		"颠倒干坤", "	dian1	dao3	gan4	kun1",
		"金山屯区", "	jin1	shan1	zhun1	qu1",
		"方兴未已", "	fang1	xing1	wei4	yi3",
		"得心应手", "	de2	xin1	ying4	shou3",
		"新都桥镇", "	xin1	du1	qiao2	zhen4",
		"倒执手版", "	dao3	zhi2	shou3	ban3",
		"弹尽援绝", "	dan4	jin4	yuan2	jue2",
		"新兴产业", "	xin1	xing1	chan3	ye4",
		"地方风味", "	di4	fang1	feng1	wei4",
		"兴业银行", "	xing1	ye4	yin2	hang2",
		"长度单位", "	chang2	du4	dan1	wei4",
		"量化逻辑", "	liang4	hua4	luo2	ji",
		"量入为出", "	liang4	ru4	wei2	chu1",
		"地狱变相", "	di4	yu4	bian4	xiang4",
		"从长计议", "	cong2	chang2	ji4	yi4",
		"听墙根儿", "	ting1	qiang2	gen1	r",
		"阴错阳差", "	yin1	cuo4	yang2	cha1",
		"丢车保帅", "	diu1	ju1	bao3	shuai4",
		"过从甚密", "	guo4	cong2	shen4	mi4",
		"差强人意", "	cha1	qiang2	ren2	yi4",
		"卖文为生", "	mai4	wen2	wei2	shen1",
		"以慎为键", "	yi3	shen4	wei2	jian4",
		"抢地呼天", "	qiang1	di4	hu1	tian1",
		"一天星斗", "	yi1	tian1	xing1	dou3",
		"血债累累", "	xue4	zhai4	lei3	lei3",
		"单眼相机", "	dan1	yan3	xiang4	ji1",
		"差动齿轮", "	cha1	dong4	chi3	lun2",
		"望而兴叹", "	wang4	er2	xing1	tan4",
		"天王老子", "	tian1	wang2	lao3	zi3",
		"意义深长", "	yi4	yi4	shen1	chang2",
		"伏虎降龙", "	fu2	hu3	xiang2	long2",
		"凫短鹤长", "	fu2	duan3	he4	chang2",
		"佛眼相看", "	fo2	yan3	xiang1	kan4",
		"缝衣工人", "	feng2	yi1	gong1	ren2",
		"强文假醋", "	qiang3	wen2	jia3	cu4",
		"强死赖活", "	qiang3	si3	lai4	huo2",
		"衣绣昼行", "	yi4	xiu4	zhou4	xing2",
		"对薄公堂", "	dui4	bu4	gong1	tang2",
		"游说集团", "	you2	shui4	ji2	tuan2",
		"脱不了身", "	tuo1	bu4	liao3	shen1",
		"血流漂杵", "	xue4	liu2	piao1	chu3",
		"行家里手", "	hang2	jia1	li3	shou3",
		"老少咸宜", "	lao3	shao4	xian2	yi2",
		"干柴烈火", "	gan1	chai2	lie4	huo3",
		"田父之功", "	tian2	fu3	zhi1	gong1",
		"行为准则", "	xing2	wei2	zhun3	ze2",
		"朝思暮想", "	zhao1	si1	mu4	xiang3",
		"朝令夕改", "	zhao1	ling4	xi1	gai3",
		"叱吒风云", "	chi4	zha4	feng1	yun2",
		"重睹天日", "	chong2	du3	tian1	ri4",
		"强聒不舍", "	qiang3	guo1	bu4	she3",
		"旧地重游", "	jiu4	di4	chong2	you2",
		"钉头磷磷", "	ding	tou	lin	lin",
		"佛性禅心", "	fo2	xing4	chan2	xin1",
		"重操旧业", "	chong2	cao1	jiu4	ye4",
		"都铎王朝", "	du1	duo2	wang2	chao2",
		"短见薄识", "	duan3	jian4	bo2	shi2",
		"长途网路", "	chang2	tu2	wang3	lu4",
		"酌情处理", "	zhuo2	qing2	chu3	li3",
		"间接选举", "	jian4	jie1	xuan3	ju3",
		"道尽途穷", "	dao4	jin4	tu2	qiong2",
		"断发文身", "	duan4	fa4	wen2	shen1",
		"弦鸣乐器", "	xian2	ming2	yue4	qi4",
		"数九寒天", "	shu3	jiu3	han2	tian1",
		"柏林围墙", "	bo2	lin2	wei2	qiang2",
		"都中纸贵", "	du1	zhong1	zhi3	gui4",
		"弧长参数", "	hu2	chang2	can1	shu4",
		"重复语境", "	chong2	fu4	yu3	jing4",
		"酩酊大醉", "	ming3	ding3	da4	zui4",
		"倒廪倾囷", "	dao3	lin3	qing1	qun1",
		"弹射座舱", "	tan2	she4	zuo4	cang1",
		"电子产品", "	dian4	zi3	chan3	pin3",
		"重提旧事", "	chong2	ti2	jiu4	shi4",
		"都江堰市", "	du1	jiang1	yan4	shi4",
		"电子文档", "	dian4	zi3	wen2	dang4",
		"重温旧业", "	chong2	wen1	jiu4	ye4",
		"重历旧游", "	chong2	li4	jiu4	you2",
		"重新开机", "	chong2	xin1	kai1	ji1",
		"斗酒百篇", "	dou3	jiu3	bai3	pian1",
		"数典忘祖", "	shu3	dian3	wang4	zu3",
		"长途话费", "	chang2	tu2	hua4	fei4",
		"自力更生", "	zi4	li4	geng1	sheng1",
		"心广体胖", "	xin1	guang3	ti3	pan2",
		"斗折蛇行", "	dou3	zhe2	she2	xing2",
		"心拙口夯", "	xin1	zhuo1	kou3	ben4",
		"更弦易辙", "	geng1	xian2	yi4	zhe2",
		"断线鹞子", "	duan4	xian4	yao4	zi3",
		"数不胜数", "	shu3	bu4	sheng4	shu3",
		"铜管乐器", "	tong2	guan3	yue4	qi4",
		"莘莘学子", "	shen1	shen1	xue2	zi3",
		"雕肝琢膂", "	diao1	gan1	zhuo2	lv3",
		"阴差阳错", "	yin1	cha1	yang2	cuo4",
		"倒街卧巷", "	dao3	jie1	wo4	xiang4",
		"公共积累", "	gong1	gong4	ji1	lei3",
		"钻头卡盘", "	zuan4	tou2	qia3	pan2",
		"盗嫂受金", "	dao4	sao3	shou4	jin1",
		"斗筲之人", "	dou3	shao1	zhi1	ren2",
		"将伯之助", "	qiang1	bo2	zhi1	zhu4",
		"点石为金", "	dian3	shi2	wei2	jin1",
		"钻头夹盘", "	zuan4	tou2	jia2	pan2",
		"铤而走险", "	ting3	er2	zou3	xian3",
		"长夜漫漫", "	chang2	ye4	man4	man4",
		"方兴未艾", "	fang1	xing1	wei4	ai4",
		"刁钻促狭", "	diao1	zuan4	cu4	xia2",
		"刁斗森严", "	diao1	dou3	sen1	yan2",
		"经济困境", "	jing1	ji4	kun4	jing4",
		"鼓乐喧天", "	gu3	yue4	xuan1	tian1",
		"彰善瘅恶", "	zhang1	shan4	dan4	e4",
		"弹指之间", "	tan2	zhi3	zhi1	jian1",
		"鼎鼐调和", "	ding3	nai	tiao2	he2",
		"倒冠落佩", "	dao3	guan1	luo4	pei4",
		"早期效应", "	zao3	qi1	xiao4	ying4",
		"早生贵子", "	zao3	sheng1	gui4	zi3",
		"倒持手板", "	dao3	chi2	shou3	ban3",
		"东亚银行", "	dong1	ya4	yin2	hang2",
		"除旧更新", "	chu2	jiu4	geng1	xin1",
		"鬼魅伎俩", "	gui3	mei4	ji4	liang3",
		"间隔摄影", "	jian4	ge2	she4	ying3",
		"防毒斗篷", "	fang2	du2	dou3	peng2",
		"降龙伏虎", "	xiang2	long2	fu2	hu3",
		"道傍之筑", "	dao4	bang4	zhi1	zhu4",
		"罪行累累", "	zui4	xing2	lei3	lei3",
		"强直自遂", "	qiang2	zhi2	zi4	sui2",
		"强识博闻", "	qiang3	shi2	bo2	wen2",
		"单方恐吓", "	dan1	fang1	kong3	he4",
		"返朴还淳", "	fan3	pu3	huan2	chun2",
		"绕梁三日", "	rao3	liang2	san1	ri4",
		"发人深省", "	fa1	ren2	shen1	xing3",
		"军团杆菌", "	jun1	tuan2	gan3	jun1",
		"一长二短", "	yi1	chang2	er4	duan3",
		"勉强及格", "	mian3	qiang3	ji2	ge2",
		"面南背北", "	mian4	nan2	bei4	bei3",
		"反躬自省", "	fan3	gong1	zi4	xing3",
		"一长一短", "	yi1	chang2	yi1	duan3",
		"豁然开朗", "	huo4	ran2	kai1	lang3",
		"移动平台", "	yi2	dong4	ping2	tai2",
		"一了百当", "	yi1	liao3	bai3	dang4",
		"似笑非笑", "	si4	xiao4	fei1	xiao4",
		"似水年华", "	si4	shui3	nian2	hua2",
		"以攻为守", "	yi3	gong1	wei2	shou3",
		"返朴还真", "	fan3	pu3	huan2	zhen1",
		"搴旗取将", "	qian1	qi2	qu3	jiang4",
		"靡然从风", "	mi3	ran2	cong2	feng1",
		"慢性咽炎", "	man4	xing4	yan1	yan2",
		"可共患难", "	ke3	gong4	huan4	nan4",
		"谦谦君子", "	qian1	qian1	jun1	zi3",
		"朝鲜日报", "	chao2	xian3	ri4	bao4",
		"朝鲜八道", "	chao2	xian3	ba1	dao4",
		"杠杆原理", "	gang4	gan3	yuan2	li3",
		"一哄而上", "	yi4	hong1	er2	shang4",
		"似懂非懂", "	si4	dong3	fei1	dong3",
		"崭露头角", "	zhan3	lu4	tou2	jiao3",
		"薄养厚葬", "	bo2	yang3	hou4	zang4",
		"过敏反应", "	guo4	min3	fan3	ying4",
		"奉为至宝", "	feng4	wei2	zhi4	bao3",
		"有为有守", "	you3	wei2	you3	shou3",
		"反应迟钝", "	fan3	ying4	chi2	dun4",
		"翘居群首", "	qiao2	ju1	qun2	shou3",
		"庚子国变", "	geng1	zi3	guo2	bian4",
		"以守为攻", "	yi3	shou3	wei2	gong1",
		"冠山戴粒", "	guan4	shan1	dai4	li4",
		"专业知识", "	zhuan1	ye4	zhi1	shi",
		"背景音乐", "	bei4	jing3	yin1	yue4",
		"天之骄子", "	tian1	zhi1	jiao1	zi3",
		"见义勇为", "	jian4	yi4	yong3	wei2",
		"年少无知", "	nian2	shao4	wu2	zhi1",
		"费尽周折", "	fei4	jin4	zhou1	zhe2",
		"风流蕴藉", "	feng1	liu2	yun4	jie4",
		"钝学累功", "	dun4	xue2	lei3	gong1",
		"小两口儿", "	xiao3	liang3	kou3	r",
		"猫鼠同处", "	mao1	shu3	tong2	chu3",
		"毛遂堕井", "	mao2	sui2	duo4	jing3",
		"视微知着", "	shi4	wei1	zhi1	zhuo2",
		"锋镝余生", "	feng1	di2	yu2	sheng1",
		"调理阴阳", "	tiao2	li3	yin1	yang2",
		"发怒冲冠", "	fa4	nu4	chong1	guan1",
		"连篇累牍", "	lian2	pian1	lei3	du2",
		"兴隆台区", "	xing1	long2	tai2	qu1",
		"天下为家", "	tian1	xia4	wei2	jia1",
		"一口两匙", "	yi1	kou3	liang3	chi2",
		"泛应曲当", "	fan4	ying1	qu3	dang1",
		"仰屋兴叹", "	yang3	wu1	xing1	tan4",
		"英语教学", "	ying1	yu3	jiao1	xue2",
		"千载一逢", "	qian1	zai3	yi1	feng2",
		"发怒穿冠", "	fa4	nu4	chuan1	guan1",
		"天造草昧", "	tian1	zao4	cao3	mei4",
		"通讯行业", "	tong1	xun4	hang2	ye4",
		"儿女情长", "	er2	nv3	qing2	chang2",
		"单反相机", "	dan1	fan3	xiang4	ji1",
		"转危为安", "	zhuan3	wei1	wei2	an1",
		"儿女成行", "	er2	nv3	cheng2	hang2",
		"任人唯贤", "	ren4	ren2	wei2	xian2",
		"阿党相为", "	e1	dang3	xiang1	wei2",
		"膏唇贩舌", "	gao4	chun2	fan4	she2",
		"眠花藉柳", "	mian2	hua1	jie4	liu3",
		"天差地远", "	tian1	cha1	di4	yuan3",
		"葛莱美奖", "	ge3	lai2	mei3	jiang3",
		"高情逸兴", "	gao1	qing2	yi4	xing1",
		"朝饔夕飧", "	zhao1	yong1	xi1	sun1",
		"鸾孤凤只", "	luan2	gu1	feng4	zhi1",
		"营业时候", "	ying2	ye4	shi2	hou",
		"巧发奇中", "	qiao3	fa1	qi2	zhong4",
		"朋比为奸", "	peng2	bi3	wei2	jian1",
		"朱云折槛", "	zhu1	yun2	she2	jian4",
		"恬不为怪", "	tian2	bu4	wei2	guai4",
		"各有所长", "	ge4	you3	suo3	chang2",
		"缝衣浅带", "	feng2	yi1	qian3	dai4",
		"叹为观止", "	tan4	wei2	guan1	zhi3",
		"鸾停鹄峙", "	luan2	ting2	hu2	zhi4",
		"蝴蝶效应", "	hu2	die2	xiao4	ying4",
		"一朝之患", "	yi1	zhao1	zhi1	huan4",
		"鸾鹄在庭", "	luan2	hu2	zai4	ting2",
		"叶公好龙", "	ye4	gong1	hao4	long2",
		"告老还家", "	gao4	lao3	huan2	jia1",
		"未竟之志", "	wei4	jing4	zhi1	zhi4",
		"风云之志", "	feng1	yun2	zhi1	zhi4",
		"处堂燕雀", "	chu3	tang2	yan4	que4",
		"鸾鹄停峙", "	luan2	hu2	ting2	zhi4",
		"绿林强盗", "	lu4	lin2	qiang2	dao4",
		"朝鲜核谈", "	chao2	xian3	he2	tan2",
		"见微知著", "	jian4	wei1	zhi1	zhu4",
		"剔抽秃揣", "	ti1	chou1	tu1	chuai3",
		"著称于世", "	zhu4	cheng1	yu2	shi4",
		"凤子龙孙", "	feng4	zi3	long2	sun1",
		"陆相沉积", "	lu4	xiang4	chen2	ji1",
		"凤只鸾孤", "	feng4	zhi1	luan2	gu1",
		"乱臣贼子", "	luan4	chen2	zei2	zi3",
		"缟纻之交", "	gao1	zhu4	zhi1	jiao1",
		"剔蝎撩蜂", "	ti1	xie1	liao2	feng1",
		"裸裎袒裼", "	luo3	cheng2	tan3	xi1",
		"翘足引领", "	qiao2	zu2	yin3	ling3",
		"内切球", "	nei4	qie1	qiu2",
		"粘合剂", "	nian2	he2	ji4",
		"血豆腐", "	xie3	dou4	fu3",
		"打擂台", "	da3	lei4	tai2",
		"背带裤", "	bei1	dai4	ku4",
		"增压比", "	zeng1	ya4	bi3",
		"脑门子", "	nao3	men2	zi3",
		"碎块儿", "	sui4	kuai4	r",
		"简帖儿", "	jian3	tie3	r",
		"大兴区", "	da4	xing1	qu1",
		"增压机", "	zeng1	ya4	ji1",
		"那时候", "	na4	shi2	hou",
		"碌曲县", "	lu4	qu3	xian4",
		"都安县", "	du1	an	xian4",
		"剃发令", "	ti4	fa4	ling4",
		"奔头儿", "	ben4	tou	er",
		"打不通", "	da3	bu	tong1",
		"快板儿", "	kuai4	ban3	r",
		"兴安区", "	xing1	an1	qu1",
		"喝倒彩", "	he4	dao4	cai3",
		"碎嘴子", "	sui4	zui3	zi3",
		"这下子", "	zhe4	xia4	zi3",
		"拿不动", "	na2	bu	dong4",
		"亚原子", "	ya4	yuan2	zi3",
		"干旱土", "	gan1	han4	tu3",
		"脑瓢儿", "	nao3	piao2	r",
		"舔屁股", "	tian3	pi4	gu",
		"狗骨头", "	gou3	gu2	tou",
		"打呵欠", "	da3	he1	qian4",
		"压轴子", "	ya1	zhou4	zi3",
		"三拗汤", "	san1	ao4	tang1",
		"脑瓜子", "	nao3	gua1	zi3",
		"趁早儿", "	chen4	zao3	r",
		"遛弯儿", "	liu4	wan1	er2",
		"少不得", "	shao3	bu	de2",
		"划不来", "	hua2	bu4	lai2",
		"西门町", "	xi1	men2	ding1",
		"保不住", "	bao3	bu2	zhu4",
		"增压器", "	zeng1	ya4	qi4",
		"那倒是", "	na4	dao4	shi",
		"脯氨酸", "	fu3	an1	suan1",
		"南边儿", "	nan2	bian	r",
		"近似解", "	jin4	si4	jie3",
		"佛甲草", "	fo2	jia3	cao3",
		"干梅子", "	gan1	mei2	zi",
		"近似值", "	jin4	si4	zhi2",
		"与会国", "	yu4	hui4	guo2",
		"女公子", "	nv3	gong1	zi3",
		"小菜儿", "	xiao3	cai4	r",
		"脖颈儿", "	bo2	geng3	er2",
		"拌和机", "	ban4	huo4	ji1",
		"那曲县", "	na3	qu1	xian4",
		"部分值", "	bu4	fen4	zhi2",
		"架不住", "	jia4	bu2	zhu4",
		"逗闷子", "	dou4	men4	zi3",
		"柞丝绸", "	zuo4	si1	chou2",
		"出主意", "	chu1	zhu3	yi",
		"云头儿", "	yun2	tou	er",
		"喀什市", "	ka1	shi2	shi4",
		"石头记", "	shi2	tou	ji4",
		"都匀市", "	du1	yun2	shi4",
		"了不得", "	liao3	bu4	de2",
		"亚粘土", "	ya4	nian2	tu3",
		"尽可能", "	jin4	ke3	neng2",
		"四公子", "	si4	gong1	zi3",
		"氨哮素", "	an1	xiao4	su4",
		"脏乎乎", "	zang1	hu1	hu1",
		"排子车", "	pai3	zi3	che1",
		"佛出世", "	fo2	chu1	shi4",
		"迫击炮", "	pai3	ji1	pao4",
		"都柏林", "	dou1	bo2	lin2",
		"脚丫子", "	jiao3	ya1	zi3",
		"乌什县", "	wu1	shi2	xian4",
		"知识库", "	zhi1	shi	ku4",
		"大舌头", "	da4	she2	tou",
		"豆腐羹", "	dou4	fu	geng1",
		"乌良哈", "	wu1	liang2	ha3",
		"倒好儿", "	dao3	hao3	er2",
		"鼻咽炎", "	bi2	yan1	yan2",
		"逻辑学", "	luo2	ji	xue2",
		"梭子蟹", "	suo1	zi3	xie4",
		"石榴子", "	shi2	liu	zi3",
		"贾似道", "	jia3	si4	dao4",
		"眼底下", "	yan3	di3	xia",
		"脊髓炎", "	ji3	sui3	yan2",
		"锁子甲", "	suo3	zi3	jia3",
		"避难所", "	bi4	nan4	suo3",
		"都更案", "	du1	geng1	an4",
		"南海子", "	nan2	hai3	zi3",
		"混名儿", "	hun4	ming2	r",
		"刨笔刀", "	bao4	bi3	dao1",
		"吴兴区", "	wu2	xing1	qu1",
		"文曲星", "	wen2	qu3	xing1",
		"佛法僧", "	fo2	fa3	seng1",
		"漂洗机", "	piao3	xi3	ji1",
		"划得来", "	hua2	de	lai2",
		"粘乎乎", "	nian2	hu1	hu1",
		"大轴戏", "	da4	zhou4	xi4",
		"节骨眼", "	jie1	gu3	yan3",
		"弹拨乐", "	tan2	bo1	yue4",
		"随大溜", "	sui2	da4	liu4",
		"套马杆", "	tao4	ma3	gan3",
		"空白符", "	kong4	bai2	fu2",
		"调速器", "	tiao2	su4	qi4",
		"嘴把式", "	zui3	ba3	shi",
		"赔不是", "	pei2	bu2	shi4",
		"螺丝钻", "	luo2	si1	zuan4",
		"二愣子", "	er4	leng4	zi3",
		"电喇叭", "	dian4	la3	ba",
		"走门子", "	zou3	men2	zi3",
		"备不住", "	bei4	bu2	zhu4",
		"笑呵呵", "	xiao4	he1	he1",
		"老莱子", "	lao3	lai2	zi3",
		"塔什干", "	ta3	shi2	gan4",
		"小姑子", "	xiao3	gu1	zi3",
		"走样儿", "	zou3	yang4	r",
		"痱子粉", "	fei4	zi3	fen3",
		"小肚子", "	xiao3	du3	zi",
		"质子数", "	zhi4	zi3	shu4",
		"没空儿", "	mei2	kong4	r",
		"书记处", "	shu1	ji	chu4",
		"书馆儿", "	shu1	guan3	r",
		"乔答摩", "	qiao2	da1	mo2",
		"包园儿", "	bao1	yuan2	r",
		"补给线", "	bu2	ji3	xian4",
		"调色剂", "	tiao2	se4	ji4",
		"摇滚乐", "	yao2	gun3	yue4",
		"童子鸡", "	tong2	zi3	ji1",
		"空心儿", "	kong4	xin1	r",
		"空壳子", "	kong1	ke2	zi3",
		"有益处", "	you3	yi4	chu",
		"配给品", "	pei4	ji3	pin3",
		"歌片儿", "	ge1	pian1	er",
		"有道理", "	you3	dao4	li",
		"做什么", "	zuo4	shi2	mo3",
		"有边儿", "	you3	bian1	r",
		"要样儿", "	yao4	yang4	r",
		"扩散剂", "	kuo4	san3	ji4",
		"调和漆", "	tiao2	he2	qi1",
		"责任人", "	ze2	ren4	ren2",
		"老鸨子", "	lao3	bao3	zi3",
		"北边儿", "	bei3	bian1	r",
		"分子式", "	fen4	zi3	shi4",
		"老大难", "	lao3	da4	nan4",
		"贺子珍", "	he4	zi3	zhen1",
		"套衫儿", "	tao4	shan1	r",
		"落不是", "	luo4	bu2	shi4",
		"挑头儿", "	tiao3	tou2	r",
		"大不了", "	da4	bu4	liao3",
		"倒计时", "	dao3	ji4	shi2",
		"徐熙媛", "	xu2	xi1	yuan2",
		"着劲儿", "	zhuo2	jin4	r",
		"子午莲", "	zi3	wu3	lian2",
		"蛋卷儿", "	dan4	juan3	r",
		"卷发器", "	juan3	fa4	qi4",
		"葵花子", "	kui2	hua1	zi3",
		"猪尾巴", "	zhu1	wei3	ba",
		"波隆那", "	bo1	long1	na4",
		"葛法翁", "	ge3	fa3	weng1",
		"豆角儿", "	dou4	jue2	er2",
		"出漏子", "	chu1	lou4	zi3",
		"踝子骨", "	huai2	zi3	gu3",
		"调压器", "	tiao2	ya1	qi4",
		"葡萄干", "	pu2	tao2	gan1",
		"线坯子", "	xian4	pi1	zi3",
		"出岔子", "	chu1	cha4	zi3",
		"电驴子", "	dian4	lv2	zi3",
		"有会子", "	you3	hui4	zi3",
		"懒骨头", "	lan3	gu3	tou",
		"排叉儿", "	pai2	cha4	er2",
		"作曲者", "	zuo4	qu3	zhe3",
		"一个样", "	yi1	ge	yang4",
		"柞蚕丝", "	zuo4	can2	si1",
		"一刀切", "	yi1	dao1	qie1",
		"让步地", "	rang4	bu4	de",
		"出月子", "	chu1	yue4	zi3",
		"拦不住", "	lan2	bu2	zhu4",
		"毛丫头", "	mao2	ya1	tou",
		"出尖儿", "	chu1	jian1	r",
		"血淋淋", "	xie3	lin2	lin2",
		"曾祖母", "	zeng1	zu3	mu3",
		"高丽纸", "	gao1	li2	zhi3",
		"子系统", "	zi3	xi4	tong3",
		"后边儿", "	hou4	bian	r",
		"王世子", "	wang2	shi4	zi3",
		"曾纪泽", "	zeng1	ji4	ze2",
		"瞎琢磨", "	xia1	zuo2	mo",
		"烘干机", "	hong1	gan1	ji1",
		"蒙古族", "	meng3	gu3	zu2",
		"蒙古语", "	meng3	gu3	yu3",
		"混球儿", "	hun2	qiu2	er2",
		"曾祖父", "	zeng1	zu3	fu4",
		"来得早", "	lai2	de	zao3",
		"谈得来", "	tan2	de	lai2",
		"未处理", "	wei4	chu3	li3",
		"莲都区", "	lian2	du1	qu1",
		"法隆寺", "	fa3	long1	si4",
		"铜离子", "	tong2	li2	zi3",
		"薄荷糖", "	bo4	he	tang2",
		"西洲曲", "	xi1	zhou1	qu3",
		"薄荷醇", "	bo4	he	chun2",
		"铜子儿", "	tong2	zi3	er",
		"西塞山", "	xi1	sai4	shan1",
		"搞不懂", "	gao3	bu	dong3",
		"配给制", "	pei4	ji3	zhi4",
		"外边儿", "	wai4	bian	r",
		"过得去", "	guo4	dei3	qu4",
		"干燥炉", "	gan1	zao4	lu2",
		"无名子", "	wu2	ming2	zi3",
		"斗门区", "	dou3	men2	qu1",
		"傍家儿", "	bang4	jia1	r",
		"出门子", "	chu1	men2	zi3",
		"处理品", "	chu3	li3	pin3",
		"多任务", "	duo1	ren4	wu",
		"会计课", "	kuai4	ji4	ke4",
		"试手儿", "	shi4	shou3	r",
		"托门子", "	tuo1	men2	zi3",
		"武曲星", "	wu3	qu3	xing1",
		"填塞物", "	tian2	se4	wu4",
		"会计科", "	kuai4	ji4	ke1",
		"处女作", "	chu3	nv3	zuo4",
		"处女座", "	chu3	nv3	zuo4",
		"处子秀", "	chu3	zi3	xiu4",
		"瓦楞子", "	wa3	leng2	zi3",
		"红模子", "	hong2	mu2	zi3",
		"腿腕子", "	tui3	wan4	zi3",
		"伪君子", "	wei3	jun1	zi3",
		"堆垛机", "	dui1	duo4	ji1",
		"干燥器", "	gan1	zao4	qi4",
		"多得是", "	duo1	de	shi4",
		"傀儡戏", "	kui3	lei3	xi4",
		"怪物似", "	guai4	wu4	si4",
		"坤角儿", "	kun1	jue2	er2",
		"浪卡子", "	lang4	ka3	zi3",
		"过不下", "	guo4	bu	xia4",
		"恐吓信", "	kong3	he4	xin4",
		"鼻粘膜", "	bi2	nian2	mo2",
		"包干儿", "	bao1	gan1	er2",
		"背不住", "	bei4	bu2	zhu4",
		"遇难者", "	yu4	nan4	zhe3",
		"曲沃县", "	qu3	wo4	xian4",
		"丑婆子", "	chou3	po2	zi3",
		"分子论", "	fen1	zi3	lun4",
		"五斗柜", "	wu3	dou3	gui4",
		"叫哥哥", "	jiao4	ge1	ge",
		"指事字", "	zhi3	shi4	zi4",
		"应答器", "	ying4	da2	qi4",
		"松巴哇", "	song1	ba1	wa1",
		"忍得住", "	ren3	de	zhu4",
		"锄头雨", "	chu2	tou	yu3",
		"捧角儿", "	peng3	jue2	r",
		"练习曲", "	lian4	xi2	qu3",
		"这阵儿", "	zhe4	zhen4	r",
		"这边儿", "	zhe4	bian1	r",
		"脊椎骨", "	ji3	zhui1	gu3",
		"老师傅", "	lao3	shi1	fu1",
		"不到家", "	bu2	dao4	jia1",
		"薄伽丘", "	bo2	jia1	qiu1",
		"弥勒县", "	mi2	le4	xian4",
		"油炸机", "	you2	zha2	ji1",
		"有为法", "	you3	wei2	fa3",
		"窝囊气", "	wo1	nang1	qi4",
		"被誉为", "	bei4	yu4	wei2",
		"袖筒儿", "	xiu4	tong3	r",
		"独不见", "	du2	bu2	jian4",
		"压轴戏", "	ya1	zhou4	xi4",
		"做头发", "	zuo4	tou2	fa4",
		"煤黑子", "	mei2	hei1	zi3",
		"褪套儿", "	tun4	tao4	er2",
		"北碚区", "	bei3	bei4	qu1",
		"栖霞市", "	xi1	xia2	shi4",
		"趵突泉", "	bo1	tu1	quan2",
		"窍门儿", "	qiao4	men2	r",
		"要不是", "	yao4	bu2	shi4",
		"五斗橱", "	wu3	dou3	chu2",
		"八爪鱼", "	ba1	zhua3	yu2",
		"泊头市", "	bo2	tou2	shi4",
		"戳份儿", "	chuo1	fen4	r",
		"弹子锁", "	dan4	zi3	suo3",
		"月头儿", "	yue4	tou	er",
		"孔夫子", "	kong3	fu1	zi3",
		"了不起", "	liao3	bu4	qi3",
		"炮筒子", "	pao4	tong3	zi3",
		"误差值", "	wu4	cha1	zhi2",
		"克耶邦", "	ke4	ye1	bang1",
		"杜松子", "	du4	song1	zi3",
		"君子国", "	jun1	zi3	guo2",
		"药方儿", "	yao4	fang1	r",
		"喜剧片", "	xi3	ju4	pian1",
		"西藏人", "	xi1	zang4	ren2",
		"料头儿", "	liao4	tou2	r",
		"戏馆子", "	xi4	guan3	zi3",
		"脖颈子", "	bo2	geng3	zi",
		"塞尔南", "	sai4	er3	nan2",
		"再处理", "	zai4	chu3	li3",
		"延误费", "	yan2	wu	fei4",
		"曾都区", "	zeng1	du1	qu1",
		"药师佛", "	yao4	shi1	fo2",
		"马钱子", "	ma3	qian2	zi3",
		"补给站", "	bu3	ji3	zhan4",
		"药水儿", "	yao4	shui3	r",
		"看家戏", "	kan1	jia1	xi4",
		"戏园子", "	xi4	yuan2	zi3",
		"与会者", "	yu4	hui4	zhe3",
		"坏包儿", "	huai4	bao1	r",
		"策勒县", "	ce4	le4	xian4",
		"可的松", "	ke3	di4	song1",
		"度假者", "	du4	jia4	zhe3",
		"啃骨头", "	ken3	gu2	tou",
		"度假村", "	du4	jia4	cun1",
		"河曲县", "	he2	qu3	xian4",
		"走形儿", "	zou3	xing2	r",
		"洒狗血", "	sa3	gou3	xie3",
		"皮桶子", "	pi2	tong3	zi3",
		"对不住", "	dui4	bu2	zhu4",
		"注射液", "	zhu4	she4	ye4",
		"薄烤饼", "	bo2	kao3	bing3",
		"目的港", "	mu4	di4	gang3",
		"济南市", "	ji3	nan2	shi4",
		"菜子油", "	cai4	zi3	you2",
		"那么着", "	na4	me	zhao1",
		"原子核", "	yuan2	zi3	he2",
		"饭馆儿", "	fan4	guan3	r",
		"败家子", "	bai4	jia1	zi3",
		"子宫癌", "	zi3	gong1	ai2",
		"反面儿", "	fan3	mian4	r",
		"理发店", "	li3	fa4	dian4",
		"理发厅", "	li3	fa4	ting1",
		"那些个", "	nei4	xie1	ge4",
		"理发院", "	li3	fa4	yuan4",
		"调味剂", "	tiao2	wei4	ji4",
		"韩非子", "	han2	fei1	zi3",
		"理发员", "	li3	fa4	yuan2",
		"不是事", "	bu2	shi4	shi4",
		"体己钱", "	ti1	ji	qian2",
		"狗腿子", "	gou3	tui3	zi3",
		"曲射炮", "	qu3	she4	pao4",
		"热干面", "	re4	gan1	mian4",
		"容不得", "	rong2	bu	de2",
		"欧巴桑", "	ou1	ba	sang1",
		"安公子", "	an1	gong1	zi3",
		"名角儿", "	ming2	jue2	r",
		"薄油层", "	bo2	you2	ceng2",
		"调制波", "	tiao2	zhi4	bo1",
		"分子键", "	fen1	zi3	jian4",
		"没得说", "	mei2	de	shuo1",
		"过家家", "	guo1	jia1	jia1",
		"馊点子", "	sou1	dian3	zi3",
		"活塞杆", "	huo2	sai1	gan3",
		"曲江区", "	qu3	jiang1	qu1",
		"酸处理", "	suan1	chu3	li3",
		"参与者", "	can1	yu4	zhe3",
		"逼供信", "	bi1	gong4	xin4",
		"酸奶子", "	suan1	nai3	zi3",
		"进行曲", "	jin4	xing2	qu3",
		"拐弯儿", "	guai3	wan1	r",
		"犯得着", "	fan4	de	zhao2",
		"目的性", "	mu4	di4	xing4",
		"犟劲儿", "	jiang4	jin4	r",
		"不见得", "	bu2	jian4	de",
		"分子病", "	fen1	zi3	bing4",
		"掷骰子", "	zhi4	tou2	zi3",
		"钻门子", "	zuan4	men2	zi3",
		"娃娃生", "	wa2	wa	sheng1",
		"参与制", "	can1	yu4	zhi4",
		"核子能", "	he2	zi3	neng2",
		"着色剂", "	zhuo2	se4	ji4",
		"避难权", "	bi4	nan4	quan2",
		"除不尽", "	chu2	bu4	jin4",
		"滥套子", "	lan4	tao4	zi3",
		"犯不着", "	fan4	bu4	zhao2",
		"小家子", "	xiao3	jia1	zi3",
		"黑芝麻", "	hei1	zhi1	ma",
		"男子单", "	nan2	zi3	dan1",
		"折跟头", "	zhe1	gen1	tou",
		"不对头", "	bu2	dui4	tou2",
		"上一个", "	shang4	yi1	ge",
		"电子业", "	dian4	zi3	ye4",
		"炸丸子", "	zha2	wan2	zi3",
		"无名帖", "	wu2	ming2	tie3",
		"满剌加", "	man3	la4	jia1",
		"高勾丽", "	gao1	gou1	li2",
		"窃以为", "	qie4	yi3	wei2",
		"不尽根", "	bu4	jin4	gen1",
		"男子汉", "	nan2	zi3	han4",
		"切削力", "	qie1	xue1	li4",
		"会计学", "	kuai4	ji4	xue2",
		"无患子", "	wu2	huan4	zi3",
		"拓跋魏", "	tuo4	ba2	wei4",
		"高句丽", "	gao1	gou1	li2",
		"高分子", "	gao1	fen4	zi3",
		"白干儿", "	bai2	gan1	er2",
		"一次性", "	yi2	ci4	xing4",
		"拖尾巴", "	tuo1	wei3	ba",
		"弓弦儿", "	gong1	xian2	r",
		"不干涉", "	bu4	gan1	she4",
		"预应力", "	yu4	ying4	li4",
		"后发座", "	hou4	fa4	zuo4",
		"白切鸡", "	bai2	qie1	ji1",
		"吴堡县", "	wu2	bu3	xian4",
		"虎爪派", "	hu3	zhua3	pai4",
		"顺嘴儿", "	shun4	zui3	r",
		"开卷机", "	kai1	juan4	ji1",
		"合得着", "	he2	de	zhao2",
		"的士高", "	di2	shi4	gao1",
		"会计室", "	kuai4	ji4	shi4",
		"不失为", "	bu4	shi1	wei2",
		"姜子牙", "	jiang1	zi3	ya2",
		"再发见", "	zai4	fa1	xian4",
		"藏族人", "	zang4	zu2	ren2",
		"子弟兵", "	zi3	di4	bing1",
		"做功夫", "	zuo4	gong1	fu",
		"原子笔", "	yuan2	zi3	bi3",
		"回弹力", "	hui2	tan2	li4",
		"做工夫", "	zuo4	gong1	fu",
		"一溜烟", "	yi1	liu2	yan1",
		"说不出", "	shuo1	bu	chu1",
		"内应力", "	nei4	ying4	li4",
		"不应期", "	bu4	ying4	qi1",
		"曲艺团", "	qu3	yi4	tuan2",
		"散腿裤", "	san3	tui3	ku4",
		"小弟弟", "	xiao3	di4	di",
		"白芝麻", "	bai2	zhi1	ma",
		"这会子", "	zhe4	hui4	zi3",
		"择日子", "	zhai2	ri4	zi",
		"粘度计", "	nian2	du4	ji4",
		"锭子油", "	ding4	zi3	you2",
		"六环路", "	liu4	huan2	lu4",
		"会厌炎", "	hui4	yan4	yan2",
		"子宫壁", "	zi3	gong1	bi4",
		"古惑仔", "	gu3	huo4	zai3",
		"脏兮兮", "	zang1	xi1	xi1",
		"看得过", "	kan4	de	guo4",
		"不在行", "	bu4	zai4	hang2",
		"捣练子", "	dao3	lian4	zi3",
		"接泊车", "	jie1	bo2	che1",
		"知识化", "	zhi1	shi	hua4",
		"尽全力", "	jin4	quan2	li4",
		"说不到", "	shuo1	bu2	dao4",
		"九曲桥", "	jiu3	qu3	qiao2",
		"脊梁骨", "	ji3	liang2	gu3",
		"洛子峰", "	luo4	zi3	feng1",
		"微电子", "	wei1	dian4	zi3",
		"弹劾权", "	tan2	he2	quan2",
		"弹性体", "	tan2	xing4	ti3",
		"前奏曲", "	qian2	zou4	qu3",
		"避风头", "	bi4	feng1	tou",
		"水泡子", "	shui3	pao1	zi",
		"过家伙", "	guo1	jia1	huo",
		"都兰县", "	du1	lan2	xian4",
		"反间计", "	fan3	jian4	ji4",
		"眼不见", "	yan3	bu2	jian4",
		"俱舍宗", "	ju4	she4	zong1",
		"颅测量", "	lu2	ce4	liang2",
		"狗仔式", "	gou3	zai3	shi4",
		"兴凯湖", "	xing1	kai3	hu2",
		"曲别针", "	qu3	bie2	zhen1",
		"风信子", "	feng1	xin4	zi3",
		"擂台赛", "	lei4	tai2	sai4",
		"反知识", "	fan3	zhi1	shi",
		"不对称", "	bu4	dui4	chen4",
		"类似点", "	lei4	si4	dian3",
		"修指甲", "	xiu1	zhi3	jia",
		"择不开", "	zhai2	bu4	kai1",
		"瓜子脸", "	gua1	zi3	lian3",
		"弹跳力", "	tan2	tiao4	li4",
		"怎么着", "	zen3	me	zhao1",
		"丰子恺", "	feng1	zi3	kai3",
		"畜牧场", "	xu4	mu4	chang3",
		"快点儿", "	kuai4	dian3	r",
		"量热器", "	liang2	re4	qi4",
		"反诘问", "	fan3	jie2	wen4",
		"枯萎病", "	ku1	wei3	bing4",
		"激将法", "	ji1	jiang4	fa3",
		"佛香阁", "	fo2	xiang1	ge2",
		"胡涂虫", "	hu2	tu	chong2",
		"旋木雀", "	xuan4	mu4	que4",
		"供佛花", "	gong4	fo2	hua1",
		"金樱子", "	jin1	ying1	zi3",
		"说头儿", "	shuo1	tou	er",
		"甚至于", "	shen4	zhi4	yu2",
		"天老爷", "	tian1	lao3	ye",
		"暗适应", "	an4	shi4	ying4",
		"说什么", "	shuo1	shi2	mo3",
		"佛光寺", "	fo2	guang1	si4",
		"当家子", "	dang1	jia1	zi3",
		"腮帮子", "	sai1	bang1	zi3",
		"颠儿面", "	dian1	r	mian4",
		"海陆空", "	hai3	lu4	kong4",
		"前边儿", "	qian2	bian	r",
		"燕歌行", "	yan1	ge1	xing2",
		"反电子", "	fan3	dian4	zi3",
		"佛手柑", "	fo2	shou3	gan1",
		"说得来", "	shuo1	de	lai2",
		"古典乐", "	gu3	dian3	yue4",
		"花点子", "	hua1	dian3	zi3",
		"辣椒仔", "	la4	jiao1	zai3",
		"寒山子", "	han2	shan1	zi3",
		"狗仔队", "	gou3	zai3	dui4",
		"曲靖市", "	qu3	jing4	shi4",
		"国子监", "	guo2	zi3	jian4",
		"迷惑龙", "	mi2	huo	long2",
		"质子泵", "	zhi4	zi3	beng4",
		"太过分", "	tai4	guo4	fen4",
		"抱佛脚", "	bao4	fo2	jiao3",
		"苦差事", "	ku3	chai1	shi4",
		"不着家", "	bu4	zhao2	jia1",
		"寒暑假", "	han2	shu3	jia4",
		"太子参", "	tai4	zi3	shen1",
		"卿大夫", "	qing1	dai4	fu1",
		"受难日", "	shou4	nan4	ri4",
		"挨时间", "	ai2	shi2	jian1",
		"鼻梁子", "	bi2	liang2	zi3",
		"京油子", "	jing1	you2	zi3",
		"知制诰", "	zhi1	zhi4	gao4",
		"大麦町", "	da4	mai4	ting3",
		"风流子", "	feng1	liu2	zi3",
		"风荷载", "	feng1	he4	zai4",
		"余干县", "	yu2	gan1	xian4",
		"别着急", "	bie2	zhao2	ji2",
		"理发匠", "	li3	fa4	jiang4",
		"兴奋剂", "	xing1	fen4	ji4",
		"切削液", "	qie1	xiao1	ye4",
		"没什么", "	mei2	shen2	me",
		"到了儿", "	dao4	liao3	er",
		"切肉刀", "	qie1	rou4	dao1",
		"抽嘴巴", "	chou1	zui3	ba",
		"亲家母", "	qing4	jia1	mu3",
		"放印子", "	fang4	yin4	zi3",
		"自适应", "	zi4	shi4	ying4",
		"那程子", "	na4	cheng2	zi3",
		"芝麻饼", "	zhi1	ma	bing3",
		"探亲假", "	tan4	qin1	jia4",
		"台面呢", "	tai2	mian4	ni2",
		"连轧机", "	lian2	zha2	ji1",
		"押运员", "	ya1	yun4	yuan2",
		"不值当", "	bu4	zhi2	dang4",
		"费工夫", "	fei4	gong1	fu",
		"兴宾区", "	xing1	bin1	qu1",
		"这么着", "	zhe4	me	zhao1",
		"芫花素", "	yuan2	hua1	su4",
		"踏莎行", "	ta4	suo1	xing2",
		"德兴市", "	de2	xing1	shi4",
		"转矩臂", "	zhuan4	ju3	bi4",
		"转速比", "	zhuan4	su4	bi3",
		"花旗参", "	hua1	qi2	shen1",
		"东阿县", "	dong1	e1	xian4",
		"这些个", "	zhei4	xie1	ge4",
		"玄菟郡", "	xuan2	tu4	jun4",
		"香胰子", "	xiang1	yi2	zi3",
		"香薄荷", "	xiang1	bo4	he",
		"东边儿", "	dong1	bian1	r",
		"兴义市", "	xing1	yi4	shi4",
		"逆反应", "	ni4	fan3	ying4",
		"独生子", "	du2	sheng1	zi3",
		"龈擦音", "	yin2	ca1	yin1",
		"无脊椎", "	wu2	ji3	zhui1",
		"月子病", "	yue4	zi3	bing4",
		"娃娃兵", "	wa2	wa	bing1",
		"抄靶子", "	chao1	ba3	zi3",
		"牛脊肉", "	niu2	ji3	rou4",
		"托勒玫", "	tuo1	le4	mei2",
		"小夜曲", "	xiao3	ye4	qu3",
		"南瓜子", "	nan2	gua1	zi3",
		"子弹带", "	zi3	dan4	dai4",
		"筒子楼", "	tong3	zi3	lou2",
		"小伙儿", "	xiao3	huo3	r",
		"隐君子", "	yin3	jun1	zi3",
		"摸不着", "	mo1	bu4	zhao2",
		"疏勒国", "	shu1	le4	guo2",
		"吧托女", "	ba1	tuo1	nu:3",
		"补给舰", "	bu3	ji3	jian4",
		"起五更", "	qi3	wu3	geng1",
		"阿华田", "	a	hua4	tian2",
		"大堡礁", "	da4	pu4	jiao1",
		"调侃儿", "	tiao2	kan3	er2",
		"洗发水", "	xi3	fa4	shui3",
		"苣荬菜", "	qu3	mai3	cai4",
		"话篓子", "	hua4	lou3	zi3",
		"挨呲儿", "	ai2	ci1	r",
		"新乐府", "	xin1	yue4	fu3",
		"立合同", "	li4	he2	tong",
		"平埔族", "	ping2	pu3	zu2",
		"花骨朵", "	hua1	gu1	duo3",
		"理发馆", "	li3	fa4	guan3",
		"死不了", "	si3	bu4	liao3",
		"木头人", "	mu4	tou	ren2",
		"倒座儿", "	dao3	zuo4	er2",
		"吃得开", "	chi1	de	kai1",
		"草甸子", "	cao3	dian4	zi3",
		"热得快", "	re4	de	kuai4",
		"鹤嘴镐", "	he4	zui3	hao4",
		"阳离子", "	yang2	li2	zi3",
		"不调和", "	bu4	tiao2	he2",
		"不均匀", "	bu4	jun1	yun2",
		"童子痨", "	tong2	zi3	lao2",
		"黄陂区", "	huang2	pi2	qu1",
		"扩散板", "	kuo4	san3	ban3",
		"汉乐府", "	han4	yue4	fu3",
		"吃空额", "	chi1	kong4	e2",
		"不作为", "	bu4	zuo4	wei2",
		"着色力", "	zhuo2	se4	li4",
		"察合台", "	cha2	ge3	tai2",
		"人贩子", "	ren2	fan4	zi3",
		"对对子", "	dui4	dui4	zi3",
		"脊索瘤", "	ji3	suo3	liu2",
		"子模型", "	zi3	mo2	xing2",
		"右边儿", "	you4	bian	r",
		"切割刀", "	qie1	ge1	dao1",
		"掰腕子", "	bai1	wan4	zi3",
		"玩儿坏", "	wan2	r	huai4",
		"尉犁县", "	yu4	li2	xian4",
		"燃灯佛", "	ran2	deng1	fo2",
		"瘾君子", "	yin3	jun1	zi3",
		"认不是", "	ren4	bu2	shi4",
		"牛仔裤", "	niu2	zai3	ku4",
		"坊子区", "	fang1	zi3	qu1",
		"卸载器", "	xie4	zai3	qi4",
		"拇指甲", "	mu3	zhi3	jia",
		"动荷载", "	dong4	he4	zai4",
		"劳什子", "	lao2	shi2	zi3",
		"跑神儿", "	pao3	shen2	r",
		"吃得消", "	chi1	de	xiao1",
		"万户侯", "	wan4	hu4	hou4",
		"电子流", "	dian4	zi3	liu2",
		"万柏林", "	wan4	bo2	lin2",
		"小胡子", "	xiao3	hu2	zi3",
		"超负荷", "	chao1	fu4	he4",
		"小女子", "	xiao3	nv3	zi3",
		"小曲儿", "	xiao3	qu3	er2",
		"坐月子", "	zuo4	yue4	zi3",
		"肋膜炎", "	lei4	mo2	yan2",
		"得样儿", "	de	yang4	er2",
		"洋娃娃", "	yang2	wa2	wa",
		"李隆基", "	li3	long1	ji1",
		"卸担子", "	xie4	dan4	zi",
		"较劲儿", "	jiao4	jin4	r",
		"洋画儿", "	yang2	hua4	r",
		"泪人儿", "	lei4	ren2	er2",
		"莫泊桑", "	mo4	bo2	sang1",
		"小姨子", "	xiao3	yi2	zi3",
		"小苏打", "	xiao3	su1	da2",
		"反弹力", "	fan3	tan2	li4",
		"身板儿", "	shen1	ban3	r",
		"勒索者", "	le4	suo3	zhe3",
		"蹦高儿", "	beng4	gao1	r",
		"复兴区", "	fu4	xing1	qu1",
		"没准儿", "	mei2	zhun3	r",
		"汤婆子", "	tang1	po2	zi3",
		"芝麻包", "	zhi1	ma	bao1",
		"年画儿", "	nian2	hua4	r",
		"坎肩儿", "	kan3	jian1	r",
		"芸苔子", "	yun2	tai2	zi3",
		"花边儿", "	hua1	bian1	r",
		"冷负荷", "	leng3	fu4	he4",
		"德都县", "	de2	du1	xian4",
		"雕刻刀", "	diao1	ke4	dao1",
		"办不到", "	ban4	bu2	dao4",
		"弹花机", "	tan2	hua1	ji1",
		"圆舞曲", "	yuan2	wu3	qu3",
		"大氧吧", "	da4	yang3	ba1",
		"干扰素", "	gan1	rao3	su4",
		"大月氏", "	da4	rou4	zhi1",
		"莱佛士", "	lai2	fo2	shi4",
		"脾切除", "	pi2	qie1	chu2",
		"离子源", "	li2	zi3	yuan2",
		"干涉仪", "	gan1	she4	yi2",
		"离子能", "	li2	zi3	neng2",
		"虎而冠", "	hu3	er2	guan4",
		"土著人", "	tu3	zhu4	ren2",
		"回旋曲", "	hui2	xuan2	qu3",
		"弹射器", "	tan2	she4	qi4",
		"年头儿", "	nian2	tou2	r",
		"茶馆儿", "	cha2	guan3	r",
		"迎头儿", "	ying2	tou2	r",
		"老油子", "	lao3	you2	zi3",
		"小妮子", "	xiao3	ni1	zi3",
		"拗不过", "	niu4	bu4	guo4",
		"烧茄子", "	shao1	qie2	zi",
		"合同法", "	he2	tong	fa3",
		"子午线", "	zi3	wu3	xian4",
		"刮舌子", "	gua1	she2	zi3",
		"热应力", "	re4	ying4	li4",
		"行业语", "	hang2	ye4	yu3",
		"斗地主", "	dou4	di4	zhu3",
		"雪佛兰", "	xue3	fo2	lan2",
		"肉丸子", "	rou4	wan2	zi3",
		"卜算子", "	bu3	suan4	zi3",
		"下边儿", "	xia4	bian	r",
		"雪佛莱", "	xue3	fo2	lai2",
		"牙龈炎", "	ya2	yin2	yan2",
		"牛仔布", "	niu2	zai3	bu4",
		"盐坨子", "	yan2	tuo2	zi3",
		"拉大便", "	la4	da4	bian4",
		"死难者", "	si3	nan4	zhe3",
		"认识论", "	ren4	shi	lun4",
		"挂不住", "	gua4	bu2	zhu4",
		"君子兰", "	jun1	zi3	lan2",
		"史丹佛", "	shi3	dan1	fo2",
		"子公司", "	zi3	gong1	si1",
		"冬瓜子", "	dong1	gua1	zi3",
		"找碴儿", "	zhao3	cha2	r",
		"娃娃脸", "	wa2	wa	lian3",
		"云浮市", "	yun2	fu2	shi4",
		"乳杆菌", "	ru3	gan3	jun1",
		"对工儿", "	dui4	gong1	r",
		"支努干", "	zhi1	nu3	gan1",
		"雅诺什", "	ya3	nuo4	shi2",
		"黏糊糊", "	nian2	hu1	hu1",
		"直发板", "	zhi2	fa4	ban3",
		"动干戈", "	dong4	gan1	ge1",
		"脱不了", "	tuo1	bu4	liao3",
		"打跟头", "	da3	gen1	tou",
		"龈辅音", "	yin2	fu3	yin1",
		"不对劲", "	bu2	dui4	jin4",
		"脱壳机", "	tuo1	qiao4	ji1",
		"玛曲县", "	ma3	qu3	xian4",
		"会计师", "	kuai4	ji4	shi1",
		"不要紧", "	bu2	yao4	jin3",
		"知不道", "	zhi4	bu4	dao4",
		"宿舍楼", "	su4	she4	lou2",
		"齿龈炎", "	chi3	yin2	yan2",
		"狗崽子", "	gou3	zai3	zi3",
		"头脸儿", "	tou2	lian3	r",
		"摆阔气", "	bai3	kuo4	qi",
		"齿龈音", "	chi3	yin2	yin1",
		"阿物儿", "	a1	wu4	r",
		"看热闹", "	kan4	re4	nao",
		"每个人", "	mei3	ge	ren2",
		"任务书", "	ren4	wu	shu1",
		"看不出", "	kan4	bu	chu1",
		"附着物", "	fu4	zhuo2	wu4",
		"真子集", "	zhen1	zi3	ji2",
		"合不着", "	he2	bu4	zhao2",
		"脊柱炎", "	ji3	zhu4	yan2",
		"小摊儿", "	xiao3	tan1	r",
		"拓扑学", "	tuo4	pu1	xue2",
		"狄更斯", "	di2	geng1	si1",
		"假招子", "	jia3	zhao1	zi3",
		"主合同", "	zhu3	he2	tong",
		"电子伏", "	dian4	zi3	fu2",
		"拉个手", "	la1	ge	shou3",
		"调酒器", "	tiao2	jiu3	qi4",
		"麻麻亮", "	ma1	mɑ	liang4",
		"蔡甸区", "	cai4	dian4	qu1",
		"黄埔区", "	huang2	pu3	qu1",
		"汉堡包", "	han4	pu4	bao1",
		"果子酒", "	guo3	zi3	jiu3",
		"革吉县", "	ge2	ji2	xian4",
		"乐都县", "	le4	du1	xian4",
		"测量机", "	ce4	liang2	ji1",
		"靠得住", "	kao4	de	zhu4",
		"咔哒声", "	ka3	da	sheng1",
		"卸肩儿", "	xie4	jian1	r",
		"死胡同", "	si3	hu2	tong4",
		"独山子", "	du2	shan1	zi3",
		"登徒子", "	deng1	tu2	zi3",
		"死劲儿", "	si3	jing4	er",
		"调色板", "	tiao2	se4	ban3",
		"靠不住", "	kao4	bu2	zhu4",
		"小娃娃", "	xiao3	wa2	wa",
		"吃得住", "	chi1	de	zhu4",
		"吃不住", "	chi1	bu2	zhu4",
		"氢离子", "	qing1	li2	zi3",
		"脑萎缩", "	nao3	wei3	suo1",
		"调节器", "	tiao2	jie2	qi4",
		"子囊菌", "	zi3	nang2	jun1",
		"牟平区", "	mu4	ping2	qu1",
		"八斗才", "	ba1	dou3	cai2",
		"马尾松", "	ma3	yi3	song1",
		"鬼故事", "	gui3	gu4	shi",
		"瞧得起", "	qiao2	de	qi3",
		"燕尾蝶", "	yan1	wei3	die2",
		"卷地皮", "	juan4	di4	pi2",
		"面条儿", "	mian4	tiao2	r",
		"电子论", "	dian4	zi3	lun4",
		"差错率", "	cha1	cuo4	lv4",
		"好得多", "	hao3	de	duo1",
		"鸡血石", "	ji1	xie3	shi2",
		"谐振子", "	xie2	zhen4	zi3",
		"印古什", "	yin4	gu3	shi2",
		"瓜子金", "	gua1	zi3	jin1",
		"猜谜儿", "	cai1	mei4	er2",
		"离子键", "	li2	zi3	jian4",
		"猜得透", "	cai1	de	tou4",
		"好得很", "	hao3	de	hen3",
		"粘糊糊", "	nian2	hu1	hu1",
		"电子门", "	dian4	zi3	men2",
		"猜不透", "	cai1	bu	tou4",
		"鲁子敬", "	lu3	zi3	jing4",
		"厦门市", "	xia4	men2	shi4",
		"马尾辫", "	ma3	yi3	bian4",
		"捞什子", "	lao1	shi2	zi",
		"粘合机", "	nian2	he2	ji1",
		"南蛮子", "	nan2	man2	zi3",
		"出乱子", "	chu1	luan4	zi3",
		"不一定", "	bu4	yi2	ding4",
		"司天台", "	si1	tian1	tai1",
		"电子式", "	dian4	zi3	shi4",
		"纪录片", "	ji4	lu4	pian1",
		"喇叭形", "	la3	ba	xing2",
		"处理器", "	chu3	li3	qi4",
		"喉塞音", "	hou2	se4	yin1",
		"安魂曲", "	an1	hun2	qu3",
		"合得来", "	he2	de	lai2",
		"黑糊糊", "	hei1	hu1	hu1",
		"一部分", "	yi1	bu4	fen",
		"乌干达", "	wu1	gan1	da2",
		"乌拉圭", "	wu4	lɑ	gui1",
		"鱼肚白", "	yu2	du3	bai2",
		"暗门子", "	an4	men2	zi3",
		"发小儿", "	fa4	xiao3	r",
		"牙缝儿", "	ya2	feng4	r",
		"润发露", "	run4	fa4	lu4",
		"润发液", "	run4	fa4	ye4",
		"叭啦狗", "	ba1	la1	gou3",
		"鼻咽癌", "	bi2	yan1	ai2",
		"牡丹区", "	mu3	dan	qu1",
		"牡丹卡", "	mu3	dan	ka3",
		"武都市", "	wu3	du1	shi4",
		"阿克苏", "	a	ke4	su1",
		"暗楼子", "	an4	lou2	zi3",
		"阿克拉", "	a	ke4	la1",
		"不值得", "	bu4	zhi2	de",
		"可不是", "	ke3	bu2	shi4",
		"一甲子", "	yi1	jia3	zi3",
		"撒拉铁", "	sa3	la1	tie3",
		"可数集", "	ke3	shu3	ji2",
		"龈腭音", "	yin2	e4	yin1",
		"龈颚音", "	yin2	e4	yin1",
		"魏都区", "	wei4	du1	qu1",
		"折子戏", "	zhe2	zi3	xi4",
		"反粒子", "	fan3	li4	zi3",
		"欧柏林", "	ou1	bo2	lin2",
		"挂钩儿", "	gua4	gou1	r",
		"不由得", "	bu4	you2	de",
		"百子图", "	bai3	zi3	tu2",
		"男子气", "	nan2	zi3	qi4",
		"男孩儿", "	nan2	hai2	r",
		"番禺区", "	pan1	yu2	qu1",
		"氨吖啶", "	an1	a1	ding4",
		"颚龈音", "	e4	yin2	yin1",
		"不舒服", "	bu4	shu1	fu",
		"殷都区", "	yin1	du1	qu1",
		"齐柏林", "	qi2	bo2	lin2",
		"麦盖提", "	mai4	ge3	ti2",
		"丽佳娜", "	li2	jia1	na4",
		"史密斯", "	shi3	mi4	si1",
		"盐都区", "	yan2	du1	qu1",
		"烟头儿", "	yan1	tou2	r",
		"无支祁", "	wu2	zhi1	qi2",
		"鹍鸡曲", "	kun1	ji1	qu3",
		"熟道儿", "	shu2	dao4	r",
		"三部曲", "	san1	bu4	qu3",
		"吉卜赛", "	ji2	bu3	sai4",
		"炸子鸡", "	zha2	zi3	ji1",
		"热处理", "	re4	chu3	li3",
		"撒切尔", "	sa1	qie1	er3",
		"舍利塔", "	she4	li4	ta3",
		"没门儿", "	mei2	men2	r",
		"没劲儿", "	mei2	jin4	r",
		"卢塞恩", "	lu2	sai4	en1",
		"没六儿", "	mei2	liu4	r",
		"和得来", "	he2	de	lai2",
		"笔头儿", "	bi3	tou	er",
		"零杂儿", "	ling2	za2	r",
		"和散那", "	he2	san3	na4",
		"和稀泥", "	huo4	xi1	ni2",
		"白麻子", "	bai2	ma2	zi3",
		"摆设儿", "	bai3	she	r",
		"如来佛", "	ru2	lai2	fo2",
		"一家子", "	yi1	jia1	zi3",
		"没奈何", "	mo4	nai4	he2",
		"自以为", "	zi4	yi3	wei2",
		"一个人", "	yi2	ge	ren2",
		"瘾头儿", "	yin3	tou2	r",
		"阴离子", "	yin1	li2	zi3",
		"涂尔干", "	tu2	er3	gan1",
		"阿堵物", "	e1	du3	wu4",
		"背搭子", "	bei4	da1	zi3",
		"孺子牛", "	ru2	zi3	niu2",
		"杜笃玛", "	du4	du3	ma3",
		"西耶那", "	xi1	ye1	na4",
		"核子力", "	he2	zi3	li4",
		"洗发皂", "	xi3	fa4	zao4",
		"洗发粉", "	xi3	fa4	fen3",
		"诸葛弩", "	zhu1	ge3	nu3",
		"辟支佛", "	pi4	zhi1	fo2",
		"一水儿", "	yi1	shui3	r",
		"切割器", "	qie1	ge1	qi4",
		"下一个", "	xia4	yi1	ge",
		"切割机", "	qie1	ge1	ji1",
		"歌仔戏", "	ge1	zai3	xi4",
		"挨板子", "	ai2	ban3	zi",
		"海蛤蝓", "	hai3	ge2	yu2",
		"卡脖子", "	qia3	bo2	zi",
		"挨边儿", "	ai1	bian1	r",
		"没溜儿", "	mei2	liu4	r",
		"挨头子", "	ai2	tou2	zi",
		"笔杆儿", "	bi3	gan3	er2",
		"阿伊努", "	a	yi1	nu3",
		"杂件儿", "	za2	jian4	r",
		"散座儿", "	san3	zuo4	r",
		"直发器", "	zhi2	fa4	qi4",
		"白班儿", "	bai2	ban1	r",
		"捋胳膊", "	luo1	ge1	bo",
		"波尔干", "	bo1	er3	gan1",
		"一个劲", "	yi2	ge4	jin4",
		"捋虎须", "	luo1	hu3	xu1",
		"印把子", "	yin4	ba4	zi",
		"鼻咽部", "	bi2	yan1	bu4",
		"尽义务", "	jin4	yi4	wu4",
		"子弟书", "	zi3	di4	shu1",
		"铺路石", "	pu1	lu4	shi2",
		"大姨子", "	da4	yi2	zi3",
		"续随子", "	xu4	sui2	zi3",
		"猫眼儿", "	mao1	yan3	r",
		"补给品", "	bu3	ji3	pin3",
		"微粒子", "	wei1	li4	zi3",
		"脱衣服", "	tuo1	yi1	fu",
		"畜牧学", "	xu4	mu4	xue2",
		"臭子儿", "	chou4	zi3	r",
		"果子露", "	guo3	zi3	lu4",
		"果子狸", "	guo3	zi3	li2",
		"果仁儿", "	guo3	ren2	r",
		"副书记", "	fu4	shu1	ji",
		"枕席儿", "	zhen3	xi2	r",
		"虚套子", "	xu1	tao4	zi3",
		"费劲儿", "	fei4	jin4	r",
		// https://github.com/overtrue/pinyin/blob/master/data/words_0#L6544
		"剥皮器", "	bao1	pi2	qi4",
		"柏克郡", "	bo2	ke4	jun4",
		"牙花子", "	ya2	hua1	zi3",
		"使劲儿", "	shi3	jin4	r",
		"脑瓜儿", "	nao3	gua1	r",
		"阿合奇", "	a	he2	qi2",
		"脑脊液", "	nao3	ji3	ye4",
		"来得及", "	lai2	de	ji2",
		"枸杞子", "	gou3	qi3	zi3",
		"来火儿", "	lai2	huo3	r",
		"临月儿", "	lin2	yue4	r",
		"买不起", "	mai3	bu	qi3",
		"费德勒", "	fei4	de2	le4",
		"花都区", "	hua1	du1	qu1",
		"土狗子", "	tu3	gou3	zi3",
		"薄熙来", "	bo2	xi1	lai2",
		"软泥儿", "	ruan3	ni2	r",
		"五倍子", "	wu3	bei4	zi3",
		"记不住", "	ji4	bu	zhu4",
		"西边儿", "	xi1	bian1	r",
		"西门子", "	xi1	men2	zi3",
		"内比都", "	nei4	bi3	du1",
		"触技曲", "	chu4	ji4	qu3",
		"土粉子", "	tu3	fen3	zi3",
		"里边儿", "	li3	bian	r",
		"拓扑图", "	tuo4	pu1	tu2",
		"记号笔", "	ji4	hao	bi3",
		"阿玛尼", "	a	ma3	ni2",
		"脱模剂", "	tuo1	mu2	ji4",
		"脱模器", "	tuo1	mu2	qi4",
		"许廑父", "	xu3	qin2	fu4",
		"脱模机", "	tuo1	mu2	ji1",
		"认人儿", "	ren4	ren2	r",
		"阿瓦提", "	a	wa3	ti2",
		"兔崽子", "	tu4	zai3	zi3",
		"起小兒", "	qi3	xiao3	r",
		"曼德勒", "	man4	de2	le4",
		"费米子", "	fei4	mi3	zi3",
		"蜗杆副", "	wo1	gan3	fu4",
		"缩砂密", "	su4	sha1	mi4",
		"四君子", "	si4	jun1	zi3",
		"抱娃娃", "	bao4	wa2	wa",
		"马勃菌", "	ma3	bo2	jun4",
		"扬子鳄", "	yang2	zi3	e4",
		"熬头儿", "	ao2	tou	er",
		"理发师", "	li3	fa4	shi1",
		"武侯祠", "	wu3	hou4	ci2",
		"不可数", "	bu4	ke3	shu3",
		"器乐曲", "	qi4	yue4	qu3",
		"一揽子", "	yi1	lan3	zi3",
		"马赛曲", "	ma3	sai4	qu3",
		"马约卡", "	ma3	yao1	ka3",
		"马塞卢", "	ma3	sai4	lu2",
		"不含糊", "	bu4	han2	hu",
		"熬不住", "	ao2	bu2	zhu4",
		"取灯儿", "	qu3	deng1	r",
		"拨子弹", "	bo1	zi3	tan2",
		"不安分", "	bu4	an1	fen4",
		"扑脸儿", "	pu1	lian3	r",
		"子母扣", "	zi3	mu3	kou4",
		"半拉子", "	ban4	la3	zi3",
		"破谜儿", "	po4	mei4	er2",
		"浑球儿", "	hun2	qiu2	r",
		"呀诺达", "	ya1	nuo4	da2",
		"呆会儿", "	dai1	hui4	r",
		"字帖儿", "	zi4	tie3	er",
		"剥皮机", "	bao1	pi2	ji1",
		"班辈儿", "	ban1	bei4	r",
		"独院儿", "	du2	yuan4	r",
		"别客气", "	bie2	ke4	qi",
		"暾欲谷", "	tun1	yu4	gu3",
		"血糊糊", "	xie3	hu1	hu1",
		"开普勒", "	kai1	pu3	le4",
		"朴子市", "	po4	zi3	shi4",
		"迦叶佛", "	jia1	ye4	fo2",
		"曲麻莱", "	qu3	ma2	lai2",
		"丝挂子", "	si1	gua4	zi3",
		"阿卡提", "	a	ka3	di1",
		"部落格", "	bu4	luo4	ge2",
		"俄勒冈", "	e	le4	gang1",
		"舍利子", "	she4	li4	zi3",
		"配对儿", "	pei4	dui4	r",
		"都卜勒", "	dou1	bu3	le4",
		"子大夫", "	zi3	dai4	fu1",
		"都伯林", "	du1	bo2	lin2",
		"芋头色", "	yu4	tou	se4",
		"那维克", "	na3	wei2	ke4",
		"芥子气", "	jie4	zi3	qi4",
		"那曲市", "	na4	qu3	shi4",
		"刮胡子", "	gua1	hu2	zi3",
		"泡沫剂", "	pao1	mo4	ji4",
		"毗耶娑", "	pi2	ye1	suo1",
		"不在乎", "	bu4	zai4	hu",
		"余甘子", "	yu2	gan1	zi3",
		"玩儿完", "	wan2	r	wan2",
		"吐谷浑", "	tu3	yu4	hun2",
		"炮儿局", "	pao4	r	ju2",
		"苦活儿", "	ku3	huo2	r",
		"稀释液", "	xi1	shi4	ye4",
		"遗腹子", "	yi2	fu4	zi3",
		"杂牌儿", "	za2	pai2	r",
		"阿斯兰", "	a	si1	lan2",
		"泥娃娃", "	ni2	wa2	wa",
		"阿勒泰", "	a	le4	tai4",
		"哈喇子", "	ha1	la3	zi3",
		"可劲儿", "	ke3	jin4	r",
		"斗趣儿", "	dou4	qu4	r",
		"四部曲", "	si4	bu4	qu3",
		"阿图什", "	a	tu2	shi2",
		"阿赖耶", "	a1	lai4	ye1",
		"扎鲁特", "	za1	lu3	te4",
		"阿奎纳", "	a	kui2	na4",
		"扒头儿", "	ba1	tou	r",
		"刺儿话", "	ci4	r	hua4",
		"拉撒路", "	la1	sa3	lu4",
		"鸭子儿", "	ya1	zi3	er",
		"阿森斯", "	a	sen1	si1",
		"阿森纳", "	a	sen1	na4",
		"阿閦佛", "	a	chu4	fo2",
		"阿贝尔", "	a	bei4	er3",
		"哥德堡", "	ge1	de2	pu4",
		"那话儿", "	na4	hua4	r",
		"合辙儿", "	he2	zhe2	r",
		"打趸儿", "	da3	dun3	r",
		"鸡子儿", "	ji1	zi3	er",
		"阿布贾", "	a	bu4	jia3",
		"阿兰若", "	a1	lan2	re3",
		"钠离子", "	na4	li2	zi3",
		"嘎拉哈", "	ga1	la1	ha4",
		"顾不得", "	gu4	bu	de",
		"呕吐物", "	ou3	tu4	wu4",
		"爱玉子", "	ai4	yu4	zi3",
		"头箍儿", "	tou2	gu1	r",
		"氯离子", "	lv4	li2	zi3",
		"马褡子", "	ma3	da1	zi3",
		"努嘴儿", "	nu3	zui3	r",
		"骨碌碌", "	gu1	lu4	lu4",
		"刺儿李", "	ci4	r	li3",
		"大姑子", "	da4	gu1	zi3",
		"大衣呢", "	da4	yi1	ni2",
		"迂夫子", "	yu1	fu1	zi3",
		"哪一个", "	na3	yi1	ge",
		"一拨儿", "	yi1	bo1	r",
		"哈巴河", "	ha1	ba1	he2",
		"大苏打", "	da4	su1	da2",
		"努劲儿", "	nu3	jin4	r",
		"惹不起", "	re3	bu	qi3",
		"拿得起", "	na2	de	qi3",
		"吉娃娃", "	ji2	wa2	wa",
		"恶名儿", "	e4	ming2	r",
		"古希腊", "	gu3	xi1	la4",
		"马服子", "	ma3	fu2	zi3",
		"撒播机", "	sa3	bo1	ji1",
		"阿阇梨", "	a1	she2	li2",
		"玻色子", "	bo1	se4	zi3",
		"提头儿", "	ti2	tou2	r",
		"拉勾儿", "	la1	gou4	r",
		"菩提子", "	pu2	ti2	zi3",
		"破衣服", "	po4	yi1	fu",
		"书皮儿", "	shu1	pi2	r",
		"鼻洼子", "	bi2	wa1	zi3",
		"地肤子", "	di4	fu1	zi3",
		"土坎儿", "	tu3	kan3	r",
		"离子膜", "	li2	zi3	mo2",
		"德勒兹", "	de2	le4	zi1",
		"提篮儿", "	ti2	lan2	r",
		"负离子", "	fu4	li2	zi3",
		"贝壳儿", "	bei4	ke2	r",
		"热负荷", "	re4	fu4	he4",
		"在那儿", "	zai4	na	r",
		"笆篱子", "	ba1	li2	zi3",
		"锂离子", "	li3	li2	zi3",
		"护发素", "	hu4	fa4	su4",
		"赋格曲", "	fu4	ge2	qu3",
		"土木堡", "	tu3	mu4	pu4",
		"替角儿", "	ti4	jue2	r",
		"替班儿", "	ti4	ban1	r",
		"弥勒佛", "	mi2	le4	fo2",
		"塞席尔", "	se4	xi2	er3",
		"呼啦啦", "	hu1	la1	la1",
		"模糊集", "	mo2	hu	ji2",
		"阿凡达", "	a	fan2	da2",
		"阿阇黎", "	a1	she2	li2",
		"拿撒勒", "	na2	sa3	le4",
		"阿马逊", "	a	ma3	xun4",
		"打屁股", "	da3	pi4	gu",
		"阿维拉", "	a	wei2	la1",
		"搭茬儿", "	da1	cha2	r",
		"拉肚子", "	la1	du3	zi",
		"阿尔泰", "	a	er3	tai4",
		"哥们儿", "	ge1	men	r",
		"撒丫子", "	sa1	ya1	zi3",
		"鱼钩儿", "	yu2	gou1	r",
		"阿瑞斯", "	a	rui4	si1",
		"雅尔塔", "	ya2	er3	ta3",
		"打顿儿", "	da3	dun4	r",
		"阿凡提", "	a	fan2	ti2",
		"凹朴皮", "	ao1	po4	pi2",
		"阿美族", "	a	mei3	zu2",
		"护发乳", "	hu4	fa4	ru3",
		"阿肯色", "	a	ken3	se4",
		"卡哇伊", "	ka3	wa1	yi1",
		"阿盖达", "	a	gai4	da2",
		"闭子集", "	bi4	zi3	ji2",
		"阿初佛", "	a	chu1	fo2",
		"阿依莎", "	a	yi1	sha1",
		"阿伊莎", "	a	yi1	sha1",
		"阿克伦", "	a	ke4	lun2",
		"阿克陶", "	a	ke4	tao2",
		"玩艺儿", "	wan2	yi4	r",
		"瓦勒他", "	wa3	le4	ta1",
		"苦不唧", "	ku3	bu	ji1",
		"兹沃勒", "	zi1	wo4	le4",
		"西子湖", "	xi1	zi3	hu2",
		"一对儿", "	yi1	dui4	r",
		"虚粒子", "	xu1	li4	zi3",
		"媳妇子", "	xi2	fu4	zi3",
		"细伢子", "	xi4	ya2	zi3",
		"薄一波", "	bo2	yi1	bo1",
		"大剌剌", "	da4	la4	la4",
		"子不语", "	zi3	bu4	yu3",
		"几乎不", "	ji1	hu1	bu4",
		"莫伯日", "	mo4	bo2	ri4",
		"洗发露", "	xi3	fa4	lu4",
		"夜盆儿", "	ye4	pen2	r",
		"渔钩儿", "	yu2	gou1	r",
		"一面倒", "	yi1	mian4	dao3",
		"子目录", "	zi3	mu4	lu4",
		"庵摩勒", "	an1	mo2	le4",
		"库尔勒", "	ku4	er3	le4",
		"蜡坨儿", "	la4	tuo2	r",
		"阿法尔", "	a	fa3	er3",
		"栖息地", "	qi1	xi1	di4",
		"竹箍儿", "	zhu2	gu1	r",
		"奥米伽", "	ao4	mi3	ga1",
		"奥塞梯", "	ao4	se4	ti1",
		"歌曲集", "	ge1	qu3	ji2",
		"子午仪", "	zi3	wu3	yi2",
		"借字儿", "	jie4	zi4	r",
		"痰盂儿", "	tan2	yu2	r",
		"法耶德", "	fa3	ye1	de2",
		"河西堡", "	he2	xi1	pu4",
		"孤立子", "	gu1	li4	zi3",
		"被窝儿", "	bei4	wo1	r",
		"阿姆河", "	a	mu3	he2",
		"克耶族", "	ke4	ye1	zu2",
		"克蕾儿", "	ke4	lei3	r",
		"洗发乳", "	xi3	fa4	ru3",
		"洗发剂", "	xi3	fa4	ji4",
		"大肚子", "	da4	du3	zi",
		"子集合", "	zi3	ji2	he2",
		"讨底儿", "	tao3	di3	r",
		"六合区", "	lu4	he2	qu1",
		"卧佛寺", "	wo4	fo2	si4",
		"法勒斯", "	fa3	le4	si1",
		"欧米伽", "	ou1	mi3	ga1",
		"个头儿", "	ge4	tou2	r",
		"帽箍儿", "	mao4	gu1	r",
		"没谱儿", "	mei2	pu3	r",
		"葫芦科", "	hu2	lu	ke1",
		"衣钩儿", "	yi1	gou1	r",
		"子夜歌", "	zi3	ye4	ge1",
		"菟丝子", "	tu4	si1	zi",
		"武把子", "	wu3	ba4	zi",
		"阿爸父", "	a	ba4	fu4",
		"渔歌子", "	yu2	ge1	zi3",
		"五子棋", "	wu3	zi3	qi2",
		"瓦都兹", "	wa3	du1	zi1",
		"不拉几", "	bu4	la1	ji1",
		"柏拉图", "	bo2	la1	tu2",
		"阿巴斯", "	a	ba1	si1",
		"邷么儿", "	wa3	mo2	r",
		"密麻麻", "	mi4	ma1	mɑ",
		"自个儿", "	zi4	ge3	er2",
		"巴勒莫", "	ba1	le4	mo4",
		"奇蹄目", "	ji1	ti2	mu4",
		"纹丝儿", "	wen2	si1	r",
		"窝脖儿", "	wo1	bo2	r",
		"纸马儿", "	zhi3	ma3	r",
		"自各儿", "	zi4	ge3	r",
		"不答理", "	bu4	da1	li3",
		"热剌剌", "	re4	la4	la4",
		"畜牧业", "	xu4	mu4	ye4",
		"娃娃鱼", "	wa2	wa	yu2",
		"咖喱鸡", "	ga1	li2	ji1",
		"塔塔儿", "	ta3	ta3	r",
		"伊妹儿", "	yi1	mei4	r",
		"伍子胥", "	wu3	zi3	xu1",
		"一路哭", "	yi2	lu4	ku1",
		"伺服器", "	si4	fu2	qi4",
		"八哥儿", "	ba1	ge1	r",
		"大气儿", "	da4	qi4	r",
		"格子呢", "	ge2	zi	ni2",
		"柏柏尔", "	bo4	bo4	er3",
		"希腊语", "	xi1	la4	yu3",
		"箍节儿", "	gu1	jie	r",
		"阿拉尔", "	a	la1	er3",
		"乐呵呵", "	le4	he1	he1",
		"阿提拉", "	a	ti2	la1",
		"姑爷爷", "	gu1	ye2	ye",
		"阿拉瓦", "	a	la1	wa3",
		"鼓子词", "	gu3	zi3	ci2",
		"孤哀子", "	gu1	ai1	zi3",
		"尼勒克", "	ni2	le4	ke4",
		"尼泊尔", "	ni2	bo2	er3",
		"屁眼儿", "	pi4	yan3	r",
		"目的地", "	mu4	di4	di4",
		"耶弗他", "	ye1	fu2	ta1",
		"阿拉斯", "	a	la1	si1",
		"希特勒", "	xi1	te4	le4",
		"耶利米", "	ye1	li4	mi3",
		"阿拉摩", "	a	la1	mo2",
		"阿拉伯", "	a	la1	bo2",
		"胡琴儿", "	hu2	qin2	r",
		"一肚子", "	yi1	du3	zi",
		"耳挖子", "	er3	wa1	zi3",
		"老客儿", "	lao3	ke4	r",
		"武都区", "	wu3	du1	qu1",
		"佛骨塔", "	fo2	gu3	ta3",
		"比特币", "	bi3	te4	bi4",
		"阿希姆", "	a	xi1	mu3",
		"布娃娃", "	bu4	wa2	wa",
		"洗发膏", "	xi3	fa4	gao1",
		"载伯德", "	zai3	bo2	de2",
		"贼骨头", "	zei2	gu2	tou",
		"花子儿", "	hua1	zi3	er",
		"伽罗瓦", "	jia1	luo2	wa4",
		"伏都教", "	fu2	du1	jiao4",
		"附着力", "	fu4	zhuo2	li4",
		"节假日", "	jie2	jia4	ri4",
		"经得起", "	jing1	de	qi3",
		"绕弯子", "	rao4	wan1	zi3",
		"夹尾巴", "	jia1	wei3	ba",
		"捋袖子", "	luo1	xiu4	zi",
		"爱好者", "	ai4	hao4	zhe3",
		"夹当儿", "	jia1	dang1	r",
		"孙女儿", "	sun1	nu:3	r",
		"不舍得", "	bu4	she3	de",
		"翟理斯", "	zhai2	li3	si1",
		"哇沙比", "	wa1	sha1	bi3",
		"狐媚子", "	hu2	mei4	zi3",
		"薄荷脑", "	bo4	he	nao3",
		"子细胞", "	zi3	xi4	bao1",
		"哇沙米", "	wa1	sha1	mi3",
		"安南子", "	an1	nan2	zi3",
		"孙媳夫", "	sun1	xi2	fu",
		"宜都市", "	yi2	du1	shi4",
		"安德肋", "	an	de2	lei4",
		"孙武子", "	sun1	wu3	zi3",
		"挎兜儿", "	kua4	dou1	r",
		"催干剂", "	cui1	gan1	ji4",
		"美发师", "	mei3	fa4	shi1",
		"不自禁", "	bu4	zi4	jin1",
		"使君子", "	shi3	jun1	zi3",
		"罗刹女", "	luo2	cha4	nv3",
		"勒索罪", "	le4	suo3	zui4",
		"约维克", "	yao1	wei2	ke4",
		"干扰机", "	gan1	rao3	ji1",
		"人尖儿", "	ren2	jian1	r",
		"红胡子", "	hong2	hu2	zi3",
		"人为土", "	ren2	wei2	tu3",
		"于都县", "	yu2	du1	xian4",
		"干妹子", "	gan4	mei4	zi3",
		"奇函数", "	ji1	han2	shu4",
		"奇偶性", "	ji1	ou3	xing4",
		"昆都仑", "	kun1	du1	lun2",
		"美智子", "	mei3	zhi4	zi3",
		"金龟子", "	jin1	gui1	zi3",
		"夫子庙", "	fu1	zi3	miao4",
		"父子兵", "	fu4	zi3	bing1",
		"左边儿", "	zuo3	bian	r",
		"钓钩儿", "	diao4	gou1	r",
		"罗伯逊", "	luo1	bo2	xun4",
		"罗圈儿", "	luo2	quan1	r",
		"罗夫诺", "	luo1	fu1	nuo4",
		"罗姆酒", "	luo1	mu3	jiu3",
		"片子地", "	pian1	zi	di4",
		"惹乱子", "	re3	luan4	zi3",
		"子母弹", "	zi3	mu3	dan4",
		"咖喱粉", "	ga1	li2	fen3",
		"吹胡子", "	chui1	hu2	zi3",
		"钙离子", "	gai4	li2	zi3",
		"马扎子", "	ma3	zha2	zi3",
		"马尾藻", "	ma3	yi3	zao3",
		"马奶子", "	ma3	nai3	zi3",
		"麻麻黑", "	ma1	mɑ	hei1",
		"处女地", "	chu3	nv3	di4",
		"麻雷子", "	ma2	lei2	zi3",
		"喷嘴儿", "	pen1	zui3	r",
		"码垛机", "	ma3	duo4	ji1",
		"哗啦啦", "	hua1	la1	la1",
		"夹肢窝", "	ga1	zhi1	wo1",
		"嘴巴子", "	zui3	ba	zi",
		"夹塞儿", "	jia1	sai1	r",
		"满负荷", "	man3	fu4	he4",
		"咖喱饭", "	ga1	li2	fan4",
		"路倒儿", "	lu4	dao3	er",
		"惹麻烦", "	re3	ma2	fan",
		"浮头儿", "	fu2	tou	er",
		"惠斯勒", "	hui4	si1	le4",
		"大都市", "	da4	du1	shi4",
		"塞勒姆", "	sai1	le4	mu3",
		"夜宵儿", "	ye4	xiao1	r",
		"耳掴子", "	er3	guo2	zi3",
		"待会儿", "	dai1	hui4	r",
		"多粒子", "	duo1	li4	zi3",
		"买得起", "	mai3	de	qi3",
		"高拨子", "	gao1	bo1	zi3",
		"话把儿", "	hua4	ba4	er",
		"禁得起", "	jin1	de	qi3",
		"拜把子", "	bai4	ba4	zi",
		"柏林寺", "	bo2	lin2	si4",
		"牌子曲", "	pai2	zi	qu3",
		"华达呢", "	hua2	da2	ni2",
		"大部分", "	da4	bu4	fen4",
		"拆烂污", "	ca1	lan4	wu1",
		"回单儿", "	hui2	dan1	r",
		"刘阿斗", "	liu2	a1	dou3",
		"打得好", "	da3	de	hao3",
		"差速器", "	cha1	su4	qi4",
		"大师傅", "	da4	shi1	fu1",
		"金缕曲", "	jin1	lv3	qu3",
		"奇蹄类", "	ji1	ti2	lei4",
		"太仆寺", "	tai4	pu2	si4",
		"富家子", "	fu4	jia1	zi3",
		"金娃娃", "	jin1	wa2	wa",
		"刀把儿", "	dao1	ba4	er",
		"布什尔", "	bu4	shi2	er3",
		"希思罗", "	xi1	si1	luo1",
		"希腊文", "	xi1	la4	wen2",
		"分子力", "	fen4	zi3	li4",
		"打不倒", "	da3	bu4	dao3",
		"打摆子", "	da3	bai3	zi3",
		"大都会", "	da4	du1	hui4",
		"懂门儿", "	dong3	men2	r",
		"紫坪铺", "	zi3	ping2	pu1",
		"拉呱儿", "	la1	gua1	er",
		"佛得角", "	fo2	de2	jiao3",
		"漂浮物", "	piao1	fu2	wu4",
		"音乐剧", "	yin1	yue4	ju4",
		"耶稣教", "	ye1	su1	jiao4",
		"摇篮曲", "	yao2	lan2	qu3",
		"大袋鼠", "	da4	dai4	shu3",
		"打哈欠", "	da3	ha1	qian",
		"耶烈万", "	ye1	lie4	wan4",
		"大家伙", "	da4	jia1	huo",
		"大姐姐", "	da4	jie3	jie",
		"大咧咧", "	da4	lie1	lie1",
		"是不是", "	shi4	bu2	shi4",
		"耶诞节", "	ye1	dan4	jie2",
		"吃得来", "	chi1	de	lai2",
		"佛教徒", "	fo2	jiao4	tu2",
		"佛教语", "	fo2	jiao4	yu3",
		"佛朗哥", "	fo2	lang3	ge1",
		"数一数", "	shu3	yi1	shu4",
		"耳坠子", "	er3	zhui4	zi3",
		"药引子", "	yao4	yin3	zi3",
		"佛朗机", "	fo2	lang3	ji1",
		"老骨头", "	lao3	gu2	tou",
		"老毛子", "	lao3	mao2	zi3",
		"女人家", "	nv3	ren2	jia",
		"老处女", "	lao3	chu3	nv3",
		"吃得下", "	chi1	de	xia4",
		"干燥机", "	gan1	zao4	ji1",
		"老头儿", "	lao3	tou	er",
		"煤烟子", "	mei2	yan1	zi3",
		"箭靶子", "	jian4	ba3	zi3",
		"乐谱架", "	yue4	pu3	jia4",
		"鱼秧子", "	yu2	yang1	zi3",
		"闷头儿", "	men4	tou	er",
		"捎马子", "	shao1	ma3	zi3",
		"保得住", "	bao3	de	zhu4",
		"数不尽", "	shu4	bu	jin4",
		"榛仁儿", "	zhen1	ren2	r",
		"玉米粥", "	yu4	mi3	zhou1",
		"煤砟子", "	mei2	zha3	zi3",
		"房牙子", "	fang2	ya2	zi3",
		"伛偻病", "	yu2	lv3	bing4",
		"干燥剂", "	gan1	zao4	ji4",
		"闷子车", "	men4	zi3	che1",
		"榜葛剌", "	bang3	ge2	la4",
		"好奇心", "	hao4	qi2	xin1",
		"禁不住", "	jin1	bu2	zhu4",
		"乐府诗", "	yue4	fu3	shi1",
		"阿城区", "	a	cheng2	qu1",
		"协奏曲", "	xie2	zou4	qu3",
		"枪把儿", "	qiang1	ba4	r",
		"票友儿", "	piao4	you3	r",
		"尿盆儿", "	niao4	pen2	r",
		"溜边儿", "	liu1	bian1	r",
		"京都府", "	jing1	du1	fu3",
		"呼啦圈", "	hu1	la1	quan1",
		"介子推", "	jie4	zi3	tui1",
		"累加器", "	lei3	jia1	qi4",
		"肖伯纳", "	xiao1	bo2	na4",
		"消食儿", "	xiao1	shi2	r",
		"镚子儿", "	beng4	zi3	er",
		"厚薄规", "	hou4	bo2	gui1",
		"柏青哥", "	bo2	qing1	ge1",
		"四子王", "	si4	zi3	wang2",
		"大轴子", "	da4	zhou4	zi3",
		"背包客", "	bei1	bao1	ke4",
		"背包袱", "	bei1	bao1	fu2",
		"背影儿", "	bei4	ying3	r",
		"接头儿", "	jie1	tou	er",
		"慢累积", "	man4	lei3	ji1",
		"大少爷", "	da4	shao4	ye2",
		"干酪素", "	gan1	lao4	su4",
		"日月晕", "	ri4	yue4	yun4",
		"是非题", "	shi4	fei1	ti2",
		"左撇子", "	zuo3	pie3	zi3",
		"使绊子", "	shi3	ban4	zi3",
		"愣劲儿", "	leng4	jin4	r",
		"世家子", "	shi4	jia1	zi3",
		"什叶派", "	shi2	ye4	pai4",
		"阿鲁巴", "	a	lu3	ba1",
		"乱麻麻", "	luan4	ma1	mɑ",
		"结对子", "	jie2	dui4	zi3",
		"大宛马", "	da4	yuan1	ma3",
		"禁得住", "	jin1	de	zhu4",
		"大包干", "	da4	bao1	gan1",
		"戴假发", "	dai4	jia3	fa4",
		"溜溜儿", "	liu1	liu4	er2",
		"女主角", "	nv3	zhu3	jue2",
		"一般般", "	yi4	ban1	ban1",
		"六君子", "	liu4	jun1	zi3",
		"大单于", "	da4	chan2	yu2",
		"六个月", "	liu4	ge	yue4",
		"洋码子", "	yang2	ma3	zi3",
		"负电子", "	fu4	dian4	zi3",
		"翻篇儿", "	fan1	pian1	r",
		"酒令儿", "	jiu3	ling4	r",
		"柏辽兹", "	bo2	liao2	zi1",
		"胡椒子", "	hu2	jiao1	zi3",
		"负电荷", "	fu4	dian4	he4",
		"担不是", "	dan1	bu2	shi4",
		"派不是", "	pai4	bu2	shi4",
		"酒馆儿", "	jiu3	guan3	r",
		"脊柱裂", "	ji3	zhu4	lie4",
		"释迦佛", "	shi4	jia1	fo2",
		"烟贩子", "	yan1	fan4	zi3",
		"烟斗丝", "	yan1	dou3	si1",
		"后处理", "	hou4	chu3	li3",
		"作曲家", "	zuo4	qu3	jia1",
		"水磨机", "	shui3	mo4	ji1",
		"太子丹", "	tai4	zi3	dan1",
		"佛蒙特", "	fo2	meng2	te4",
		"多目的", "	duo1	mu4	di4",
		"喇叭口", "	la3	ba	kou3",
		"蔡李佛", "	cai4	li3	fo2",
		"碰磁儿", "	peng4	ci2	r",
		"红箍儿", "	hong2	gu1	r",
		"阿斯旺", "	a	si1	wang4",
		"阿尔山", "	a	er3	shan1",
		"阿洛菲", "	a	luo4	fei1",
		"在那里", "	zai4	na4	li",
		"干巴巴", "	gan1	ba1	ba1",
		"阿荣旗", "	a	rong2	qi2",
		"阿曼湾", "	a	man4	wan1",
		"碑座儿", "	bei1	zuo4	r",
		"傻呵呵", "	sha3	he1	he1",
		"晕乎乎", "	yun4	hu1	hu1",
		"阿拉善", "	a	la1	shan4",
		"耶和华", "	ye1	he2	hua2",
		"阿拉丁", "	a	la1	ding1",
		"磨得开", "	mo2	de	kai1",
		"禁不起", "	jin1	bu4	qi3",
		"阿多诺", "	a	duo1	nuo4",
		"福安市", "	fu2	an1	shi4",
		"阿坝县", "	a	ba4	xian4",
		"石鼓区", "	dan4	gu3	qu1",
		"阿瑟县", "	a	se4	xian4",
		"占地儿", "	zhan4	di4	r",
		"看得起", "	kan4	de	qi3",
		"阿里郎", "	a	li3	lang2",
		"加的斯", "	jia1	di4	si1",
		"耳刮子", "	er3	gua1	zi3",
		"阿兰文", "	a	lan2	wen2",
		"羞答答", "	xiu1	da1	da1",
		"染发剂", "	ran3	fa4	ji4",
		"加勒比", "	jia1	le4	bi3",
		"佛舍利", "	fo2	she4	li4",
		"佛兰德", "	fo2	lan2	de2",
		"佛诞日", "	fo2	dan4	ri4",
		"胡燕妮", "	hu2	yan1	ni1",
		"野孩子", "	ye3	hai2	zi3",
		"加劲儿", "	jia1	jin4	r",
		"耶酥会", "	ye1	su1	hui4",
		"铁钩儿", "	tie3	gou1	r",
		"老妈子", "	lao3	ma1	zi3",
		"一竿子", "	yi1	gan1	zi3",
		"耙耳朵", "	pa1	er3	duo",
		"早班儿", "	zao3	ban1	r",
		"旱鸭子", "	han4	ya1	zi3",
		"老伯伯", "	lao3	bo2	bo",
		"老佛爷", "	lao3	fo2	ye2",
		"石磨机", "	shi2	mo4	ji1",
		"耶稣会", "	ye1	su1	hui4",
		"阿卢巴", "	a	lu2	ba1",
		"一刹那", "	yi1	cha4	na4",
		"柳子戏", "	liu3	zi3	xi4",
		"老帽儿", "	lao3	mao4	r",
		"老爷爷", "	lao3	ye2	ye",
		"眵目糊", "	chi1	mu	hu1",
		"阿瑟镇", "	a	se4	zhen4",
		"扣眼儿", "	kou4	yan3	r",
		"处女膜", "	chu3	nv3	mo2",
		"开花儿", "	kai1	hua1	r",
		"五味子", "	wu3	wei4	zi3",
		"杰佛兹", "	jie2	fo2	zi1",
		"做伴儿", "	zuo4	ban4	r",
		"木齿耙", "	mu4	chi3	pa2",
		"车份儿", "	che1	fen4	r",
		"躲不起", "	duo3	bu	qi3",
		"阿皮亚", "	a	pi2	ya4",
		"苏打粉", "	su1	da2	fen3",
		"乌拉草", "	wu4	lɑ	cao3",
		"木子美", "	mu4	zi3	mei3",
		"五斗米", "	wu3	dou3	mi3",
		"笔杆子", "	bi3	gan3	zi",
		"跟屁股", "	gen1	pi4	gu",
		"跑味儿", "	pao3	wei4	r",
		"五大夫", "	wu3	dai4	fu1",
		"傻帽儿", "	sha3	mao4	r",
		"薄荷油", "	bo4	he	you2",
		"赶得及", "	gan3	de	ji2",
		"葛缕子", "	ge3	lu:3	zi",
		"弹力丝", "	tan2	li4	si1",
		"弹力袜", "	tan2	li4	wa4",
		"借单儿", "	jie4	dan1	r",
		"戏报子", "	xi4	bao4	zi3",
		"开都河", "	kai1	du1	he2",
		"第四台", "	di4	si4	tai2",
		"阿苏山", "	a	su1	shan1",
		"亚曼牙", "	ya4	man4	ya2",
		"干儿子", "	gan1	er2	zi",
		"阿莱曼", "	a	lai2	man4",
		"阿育王", "	a1	yu4	wang2",
		"阿罗约", "	a	luo2	yue1",
		"阿的平", "	a1	di4	ping2",
		"色差仪", "	se4	cha1	yi2",
		"石子儿", "	shi2	zi3	er",
		"石河子", "	shi2	he2	zi3",
		"阿坝州", "	a	ba4	zhou1",
		"阿加维", "	a	jia1	wei2",
		"粒子流", "	li4	zi3	liu2",
		"梅西耶", "	mei2	xi1	ye1",
		"一下子", "	yi1	xia4	zi3",
		"六安市", "	lu4	an1	shi4",
		"粒子束", "	li4	zi3	shu4",
		"门坎儿", "	men2	kan3	r",
		"秦都区", "	qin2	du1	qu1",
		"二流子", "	er4	liu2	zi3",
		"鱼丸子", "	yu2	wan2	zi3",
		"阿伯丁", "	a	bo2	ding1",
		"预处理", "	yu4	chu3	li3",
		"窝里反", "	wo1	li	fan3",
		"窝里斗", "	wo1	li	dou4",
		"半分儿", "	ban4	fen1	r",
		"二里头", "	er	li3	tou",
		"针箍儿", "	zhen1	gu1	r",
		"罗锅儿", "	luo2	guo1	r",
		"捆扎机", "	kun3	za1	ji1",
		"抓子儿", "	zhua1	zi3	r",
		"大伯子", "	da4	bai3	zi3",
		"老婆子", "	lao3	po2	zi3",
		"发疟子", "	fa1	yao4	zi3",
		"老夫子", "	lao3	fu1	zi3",
		"度假区", "	du4	jia4	qu1",
		"得尔塔", "	dei3	er3	ta3",
		"卷叶蛾", "	juan4	ye4	e2",
		"单子叶", "	dan1	zi3	ye4",
		"宝葫芦", "	bao3	hu2	lu",
		"宝贝儿", "	bao3	bei4	r",
		"积累率", "	ji1	lei3	lv4",
		"鸡内金", "	ji1	na4	jin1",
		"老爷子", "	lao3	ye2	zi3",
		"磨粉机", "	mo4	fen3	ji1",
		"找刺儿", "	zhao3	ci4	r",
		"对劲儿", "	dui4	jin4	r",
		"对味儿", "	dui4	wei4	r",
		"对得起", "	dui4	de	qi3",
		"对心儿", "	dui4	xin1	r",
		"批处理", "	pi1	chu3	li3",
		"抹得开", "	mo4	de	kai1",
		"娃娃菜", "	wa2	wa	cai4",
		"哈巴狗", "	ha3	ba1	gou3",
		"哥特式", "	ge1	te4	shi4",
		"滴溜儿", "	di1	liu4	er2",
		"尧都区", "	yao2	du1	qu1",
		"活局子", "	huo2	ju2	zi3",
		"地窨子", "	di4	yin4	zi3",
		"多普勒", "	duo1	pu3	le4",
		"夜猫子", "	ye4	mao1	zi3",
		"多佛尔", "	duo1	fo2	er3",
		"墨水儿", "	mo4	shui3	r",
		"独奏曲", "	du2	zou4	qu3",
		"弹涂鱼", "	tan2	tu2	yu2",
		"压不碎", "	ya1	bu	sui4",
		"都御使", "	du1	yu4	shi3",
		"克分子", "	ke4	fen4	zi3",
		"后钩儿", "	hou4	gou1	r",
		"堵塞费", "	du3	se4	fei4",
		"粪箕子", "	fen4	ji1	zi3",
		"培勒兹", "	pei2	le4	zi1",
		"大袋子", "	da4	dai4	zi",
		"大舅子", "	da4	jiu4	zi3",
		"酒嗉子", "	jiu3	su4	zi3",
		"阿衣奴", "	a	yi1	nu3",
		"旧衣服", "	jiu4	yi1	fu",
		"离子束", "	li2	zi3	shu4",
		"离子流", "	li2	zi3	liu2",
		"大文蛤", "	da4	wen2	ge2",
		"在一起", "	zai4	yi4	qi3",
		"类似于", "	lei4	si4	yu2",
		"类似物", "	lei4	si4	wu4",
		"阿萨德", "	a	sa4	de2",
		"闹肚子", "	nao4	du3	zi",
		"以此为", "	yi3	ci3	wei2",
		"一路货", "	yi2	lu4	huo4",
		"打短儿", "	da3	duan3	r",
		"打旋儿", "	da3	xuan2	r",
		"喀喇沁", "	ka1	la1	qin4",
		"打把式", "	da3	ba3	shi",
		"打嘴巴", "	da3	zui3	ba",
		"打不过", "	da3	bu	guo4",
		"折刀儿", "	zhe2	dao1	r",
		"腿肚子", "	tui3	du3	zi",
		"一路人", "	yi2	lu4	ren2",
		"勒维夫", "	le4	wei2	fu",
		"新都区", "	xin1	du1	qu1",
		"一溜儿", "	yi1	liu4	er2",
		"启发式", "	qi3	fa4	shi4",
		"继子女", "	ji4	zi3	nu:3",
		"十八子", "	shi2	ba1	zi3",
		"勒威耶", "	le4	wei1	ye1",
		"任一个", "	ren4	yi1	ge",
		"纹缕儿", "	wen2	lu:3	r",
		"纳匝肋", "	na4	za1	lei4",
		"绝门儿", "	jue2	men2	r",
		"斯坦佛", "	si1	tan3	fo2",
		"斯宾塞", "	si1	bin1	se4",
		"以斯帖", "	yi3	si1	tie3",
		"阿萨姆", "	a	sa4	mu3",
		"啦啦队", "	la1	la1	dui4",
		"托勒密", "	tuo1	le4	mi4",
		"岔曲儿", "	cha4	qu3	er",
		"戳个儿", "	chuo1	ge4	r",
		"南歌子", "	nan2	ge1	zi3",
		"哪门子", "	na3	men2	zi3",
		"拿不住", "	na2	bu2	zhu4",
		"娃娃车", "	wa2	wa	che1",
		"娃娃亲", "	wa2	wa	qin1",
		"哈什蚂", "	ha	shi	ma4",
		"宝坻区", "	bao3	di3	qu1",
		"折过儿", "	zhe1	guo4	r",
		"过去佛", "	guo4	qu4	fo2",
		"目的论", "	mu4	di4	lun4",
		"墨斗鱼", "	mo4	dou3	yu2",
		"敕勒歌", "	chi4	le4	ge1",
		"古乐府", "	gu3	yue4	fu3",
		"奶嘴儿", "	nai3	zui3	r",
		"奴儿干", "	nu2	er2	gan1",
		"门弟子", "	men2	di4	zi3",
		"搁得住", "	ge2	de	zhu4",
		"镁离子", "	mei3	li2	zi3",
		"搁不住", "	ge2	bu2	zhu4",
		"煤核儿", "	mei2	hu2	er2",
		"高压脊", "	gao1	ya1	ji3",
		"压根儿", "	ya4	gen1	er2",
		"骨朵儿", "	gu1	duo3	er",
		"扳本儿", "	ban1	ben3	r",
		"抹不开", "	mo4	bu4	kai1",
		"补给船", "	bu3	ji3	chuan2",
		"尽人事", "	jin4	ren2	shi4",
		"比不上", "	bi3	bu4	shang3",
		"订书钉", "	ding4	shu1	ding1",
		"男傧相", "	nan2	bin1	xiang4",
		"番茄酱", "	fan1	qie2	jiang4",
		"新兴县", "	xin1	xing1	xian4",
		"干燥症", "	gan1	zao4	zheng4",
		"应力场", "	ying4	li4	chang3",
		"长宁区", "	chang2	ning2	qu1",
		"印相纸", "	yin4	xiang4	zhi3",
		"长子县", "	chang2	zi3	xian4",
		"方框图", "	fang1	kuang4	tu2",
		"长寿区", "	chang2	shou4	qu1",
		"长沙市", "	chang2	sha1	shi4",
		"商都县", "	shang1	du1	xian4",
		"传记性", "	zhuan4	ji4	xing4",
		"动画片", "	dong4	hua4	pian1",
		"斜长石", "	xie2	chang2	shi2",
		"长武县", "	chang2	wu3	xian4",
		"感应圈", "	gan3	ying4	quan1",
		"长期性", "	chang2	qi1	xing4",
		"干燥箱", "	gan1	zao4	xiang1",
		"应景诗", "	ying4	jing3	shi1",
		"长沙湾", "	chang2	sha1	wan1",
		"交响曲", "	jiao1	xiang3	qu3",
		"长治市", "	chang2	zhi4	shi4",
		"增温层", "	zeng1	wen1	ceng2",
		"精校本", "	jing1	jiao4	ben3",
		"教学片", "	jiao4	xue2	pian1",
		"亲家公", "	qing4	jia1	gong1",
		"海螵蛸", "	hai3	piao1	xiao1",
		"校正子", "	jiao4	zheng4	zi3",
		"美容觉", "	mei3	rong2	jiao4",
		"首相府", "	shou3	xiang4	fu3",
		"犍为县", "	qian2	wei4	xian4",
		"量角器", "	liang2	jiao3	qi4",
		"翟志刚", "	zhai2	zhi4	gang1",
		"命中率", "	ming4	zhong4	lv4",
		"想倒美", "	xiang3	dao3	mei3",
		"缝衣匠", "	feng2	yi1	jiang4",
		"弄明白", "	nong4	ming2	bai",
		"一场空", "	yi1	chang2	kong1",
		"长方体", "	chang2	fang1	ti3",
		"昌都县", "	chang1	du1	xian4",
		"撞运气", "	zhuang4	yun4	qi",
		"海兴县", "	hai3	xing1	xian4",
		"藏红花", "	zang4	hong2	hua1",
		"请病假", "	qing3	bing4	jia4",
		"钦天监", "	qin1	tian1	jian4",
		"说得上", "	shuo1	de	shang4",
		"弹簧刀", "	tan2	huang2	dao1",
		"瓶塞钻", "	ping2	sai1	zuan4",
		"粘滞性", "	nian2	zhi4	xing4",
		"长洲区", "	chang2	zhou1	qu1",
		"感应电", "	gan3	ying4	dian4",
		"甩脸子", "	shuai3	lian3	zi3",
		"犯得上", "	fan4	dei3	shang4",
		"背饥荒", "	bei1	ji1	huang1",
		"曾金燕", "	zeng1	jin1	yan4",
		"招待会", "	zhao1	dai1	hui4",
		"望都县", "	wang4	du1	xian4",
		"绷弓子", "	beng1	gong1	zi",
		"谁知道", "	shei2	zhi1	dao4",
		"调酒师", "	tiao2	jiu3	shi1",
		"片儿汤", "	pian1	er	tang1",
		"漂白粉", "	piao3	bai2	fen3",
		"猪仔馆", "	zhu1	zai3	guan3",
		"曾孝谷", "	zeng1	xiao4	gu3",
		"指甲剪", "	zhi3	jia	jian3",
		"两着儿", "	liang3	zhao1	r",
		"偏差值", "	pian1	cha1	zhi2",
		"空调器", "	kong1	tiao2	qi4",
		"调药刀", "	tiao2	yao4	dao1",
		"彭丽媛", "	peng2	li4	yuan2",
		"浪荡子", "	lang4	dang4	zi3",
		"两下子", "	liang3	xia4	zi3",
		"曾繁仁", "	zeng1	fan2	ren2",
		"挑衅者", "	tiao3	xin4	zhe3",
		"丰都县", "	feng1	du1	xian4",
		"王尽美", "	wang2	jin4	mei3",
		"空调机", "	kong1	tiao2	ji1",
		"电子战", "	dian4	zi3	zhan4",
		"土党参", "	tu3	dang3	shen1",
		"诸葛亮", "	zhu1	ge3	liang4",
		"宝兴县", "	bao3	xing1	xian4",
		"长清区", "	chang2	qing1	qu1",
		"当世冠", "	dang1	shi4	guan4",
		"长乐宫", "	chang2	le4	gong1",
		"迎新会", "	ying2	xin1	kuai4",
		"流行性", "	liu2	xing2	xing4",
		"银行券", "	yin2	hang2	juan4",
		"不正当", "	bu4	zheng4	dang4",
		"钻牛角", "	zuan4	niu2	jiao3",
		"孪生子", "	luan2	sheng1	zi3",
		"管弦乐", "	guan3	xian2	yue4",
		"角斗场", "	jue2	dou4	chang3",
		"用得上", "	yong4	de	shang4",
		"施甸县", "	shi1	dian4	xian4",
		"外行话", "	wai4	hang2	hua4",
		"陪产假", "	pei2	chan3	jia4",
		"典当业", "	dian3	dang4	ye4",
		"振兴区", "	zhen4	xing1	qu1",
		"孔子庙", "	kong3	zi3	miao4",
		"泼脏水", "	po1	zang1	shui3",
		"谈朋友", "	tan2	peng2	you",
		"弹跳板", "	tan2	tiao4	ban3",
		"调节者", "	tiao2	jie2	zhe3",
		"有年头", "	you3	nian2	tou",
		"电子表", "	dian4	zi3	biao3",
		"壁效应", "	bi4	xiao4	ying4",
		"罗甸县", "	luo2	dian4	xian4",
		"钉书针", "	ding4	shu1	zhen1",
		"冠军赛", "	guan4	jun1	sai4",
		"占星家", "	zhan1	xing1	jia1",
		"相似性", "	xiang1	si4	xing4",
		"光电子", "	guang1	dian4	zi3",
		"对称性", "	dui4	chen4	xing4",
		"瞭望台", "	liao4	wang4	tai2",
		"小脏鬼", "	xiao3	zang1	gui3",
		"曾国荃", "	zeng1	guo2	quan2",
		"对话框", "	dui4	hua4	kuang4",
		"蒙蒙黑", "	meng1	meng1	hei1",
		"占星师", "	zhan1	xing1	shi1",
		"衣冠冢", "	yi4	guan1	zhong3",
		"占星术", "	zhan1	xing1	shu4",
		"哑终端", "	ya1	zhong1	duan1",
		"挑大梁", "	tiao3	da4	liang2",
		"占星学", "	zhan1	xing1	xue2",
		"小便斗", "	xiao3	bian4	dou3",
		"三连冠", "	san1	lian2	guan4",
		"冲击钻", "	chong1	ji1	zuan4",
		"散兵线", "	san3	bing1	xian4",
		"打长工", "	da3	chang2	gong1",
		"三重门", "	san1	chong2	men2",
		"标准差", "	biao1	zhun3	cha1",
		"长须鲸", "	chang2	xu1	jing1",
		"小数点", "	xiao3	shu3	dian3",
		"相位差", "	xiang4	wei4	cha1",
		"挑战者", "	tiao3	zhan4	zhe3",
		"够得上", "	gou4	dei3	shang4",
		"光散射", "	guang1	san3	she4",
		"应战书", "	ying4	zhan4	shu1",
		"扁担星", "	bian3	dan4	xing1",
		"长筒袜", "	chang2	tong3	wa4",
		"交白卷", "	jiao1	bai2	juan4",
		"朝鲜文", "	chao2	xian3	wen2",
		"正电荷", "	zheng4	dian4	he4",
		"见识浅", "	jian4	shi	qian3",
		"冲孔机", "	chong4	kong3	ji1",
		"空调室", "	kong1	tiao2	shi4",
		"原子钟", "	yuan2	zi3	zhong1",
		"空白点", "	kong4	bai2	dian3",
		"碱中毒", "	jian3	zhong4	du2",
		"对称轴", "	dui4	chen4	zhou2",
		"空调车", "	kong1	tiao2	che1",
		"长颈鹿", "	chang2	jing3	lu4",
		"椎间盘", "	zhui1	jian1	pan2",
		"长野县", "	chang2	ye3	xian4",
		"枕头风", "	zhen3	tou	feng1",
		"北朝鲜", "	bei3	chao2	xian3",
		"公仔面", "	gong1	zai3	mian4",
		"弦切角", "	xian2	qie1	jiao3",
		"病假条", "	bing4	jia4	tiao2",
		"张国焘", "	zhang1	guo2	tao1",
		"眼干症", "	yan3	gan1	zheng4",
		"旁切圆", "	pang2	qie1	yuan2",
		"卷层云", "	juan4	ceng2	yun2",
		"金山屯", "	jin1	shan1	zhun1",
		"世界上", "	shi4	jie4	shang",
		"长短句", "	chang2	duan3	ju4",
		"赶得上", "	gan3	dei3	shang4",
		"飞将军", "	fei1	jiang4	jun1",
		"弹簧门", "	tan2	huang2	men2",
		"正安县", "	zheng1	an	xian4",
		"长春子", "	chang2	chun1	zi3",
		"紧绷绷", "	jin3	beng1	beng1",
		"请假条", "	qing3	jia4	tiao2",
		"钻井队", "	zuan4	jing3	dui4",
		"石头城", "	shi2	tou	cheng2",
		"钱串子", "	qian2	chuan4	zi3",
		"唐三藏", "	tang2	san1	zang4",
		"取景框", "	qu3	jing3	kuang4",
		"绍兴市", "	shao4	xing1	shi4",
		"绍兴酒", "	shao4	xing1	jiu3",
		"风切变", "	feng1	qie1	bian4",
		"止疼片", "	zhi3	teng2	pian1",
		"校正器", "	jiao4	zheng4	qi4",
		"结婚证", "	jie1	hun1	zheng4",
		"始兴县", "	shi3	xing1	xian4",
		"应用文", "	ying4	yong4	wen2",
		"弹簧锁", "	tan2	huang2	suo3",
		"爱漂亮", "	ai4	piao4	liang",
		"香泡树", "	xiang1	pao1	shu4",
		"肠杆菌", "	chang2	gan3	jun1",
		"砷中毒", "	shen1	zhong4	du2",
		"敲竹杠", "	qiao1	zhu1	gang4",
		"公切线", "	gong1	qie1	xian4",
		"散兵坑", "	san3	bing1	keng1",
		"碰头会", "	peng4	tou2	kuai4",
		"朝阳门", "	zhao1	yang2	men2",
		"复选框", "	fu4	xuan3	kuang4",
		"南朝鲜", "	nan2	chao2	xian3",
		"中子源", "	zhong1	zi3	yuan2",
		"南北长", "	nan2	bei3	chang2",
		"协调员", "	xie2	tiao2	yuan2",
		"最前面", "	zui4	qian2	mian",
		"中子星", "	zhong1	zi3	xing1",
		"少年犯", "	shao4	nian2	fan4",
		"知更鸟", "	zhi1	geng1	niao3",
		"中毒性", "	zhong4	du2	xing4",
		"膀胱癌", "	pang2	guang1	ai2",
		"短波长", "	duan3	bo1	chang2",
		"汞中毒", "	gong3	zhong4	du2",
		"双子座", "	shuang1	zi3	zuo4",
		"少女峰", "	shao4	nu:3	feng1",
		"强迫性", "	qiang3	po4	xing4",
		"公冶长", "	gong1	ye3	chang2",
		"载畜量", "	zai3	chu4	liang4",
		"中爪哇", "	zhong1	zhao3	wa1",
		"中洋脊", "	zhong1	yang2	ji3",
		"再加上", "	zai4	jia1	shang",
		"拍卖行", "	pai1	mai4	hang2",
		"挑花眼", "	tiao3	hua1	yan3",
		"正规化", "	zheng4	gui1	hua1",
		"吊膀子", "	diao4	bang4	zi",
		"弹钢琴", "	tan2	gang1	qin2",
		"转铃儿", "	zhuan4	ling2	r",
		"转轴儿", "	zhuan4	zhou2	r",
		"运货员", "	yun4	huo4	yuan2",
		"忘不了", "	wang4	bu4	liao3",
		"粮食局", "	liang2	shi	ju2",
		"两三个", "	liang3	san1	ge",
		"还原剂", "	huan2	yuan2	ji4",
		"搬楦头", "	ban1	xuan4	tou",
		"司天监", "	si1	tian1	jian4",
		"两个月", "	liang3	ge	yue4",
		"遇难船", "	yu4	nan4	chuan2",
		"曲松县", "	qu3	song1	xian4",
		"搓麻将", "	cuo1	ma2	jiang4",
		"千佛山", "	qian1	fo2	shan1",
		"曲柄钻", "	qu1	bing3	zuan4",
		"曲水县", "	qu3	shui3	xian4",
		"良家子", "	liang2	jia1	zi3",
		"转腰子", "	zhuan4	yao1	zi",
		"弹棉花", "	tan2	mian2	hua1",
		"还魂纸", "	huan2	hun2	zhi3",
		"跟不上", "	gen1	bu	shang4",
		"微中子", "	wei1	zhong1	zi3",
		"圆石头", "	yuan2	shi2	tou",
		"不着调", "	bu4	zhao2	diao4",
		"复兴党", "	fu4	xing1	dang3",
		"山岗子", "	shan1	gang1	zi3",
		"中郎将", "	zhong1	lang2	jiang4",
		"电子层", "	dian4	zi3	ceng2",
		"整脊学", "	zheng3	ji3	xue2",
		"找不着", "	zhao3	bu	zhao2",
		"冲盹儿", "	chong4	dun3	er",
		"电子管", "	dian4	zi3	guan3",
		"间谍罪", "	jian4	die2	zui4",
		"少女风", "	shao4	nv3	feng1",
		"门框子", "	men2	kuang4	zi",
		"数不上", "	shu3	bu4	shang4",
		"开拓性", "	kai1	tuo4	xing4",
		"撑得住", "	cheng1	de	zhu4",
		"这年头", "	zhe4	nian2	tou",
		"扎囊县", "	za1	nang2	xian4",
		"协调人", "	xie2	tiao2	ren2",
		"卷心菜", "	juan4	xin1	cai4",
		"山桐子", "	shan1	tong2	zi3",
		"协方差", "	xie2	fang1	cha1",
		"银行家", "	yin2	hang2	jia1",
		"调解人", "	tiao2	jie3	ren2",
		"随想曲", "	sui2	xiang3	qu3",
		"粘合胶", "	nian2	he2	jiao1",
		"速调管", "	su4	tiao2	guan3",
		"曲阳县", "	qu3	yang2	xian4",
		"车行道", "	che1	hang2	dao4",
		"天仙子", "	tian1	xian1	zi3",
		"吃枪子", "	chi1	qiang1	zi3",
		"金曲奖", "	jin1	qu3	jiang3",
		"切换到", "	qie1	huan4	dao4",
		"重复节", "	chong2	fu4	jie2",
		"鲁甸县", "	lu3	dian4	xian4",
		"重眼皮", "	chong2	yan3	pi2",
		"可行性", "	ke3	xing2	xing4",
		"鲗鱼涌", "	zei2	yu2	chong1",
		"大黄素", "	dai4	huang2	su4",
		"嚼舌根", "	jiao2	she2	gen1",
		"嚼舌头", "	jiao2	she2	tou",
		"量子化", "	liang4	zi3	hua4",
		"脑栓塞", "	nao3	shuan1	se4",
		"受得了", "	shou4	de	liao3",
		"重头戏", "	chong2	tou2	xi4",
		"长安街", "	chang2	an1	jie1",
		"切削刃", "	qie1	xiao1	ren4",
		"星子县", "	xing1	zi3	xian4",
		"星宿海", "	xing1	xiu4	hai3",
		"量体温", "	liang2	ti3	wen1",
		"切削面", "	qie1	xue1	mian4",
		"龙兴寺", "	long2	xing1	si4",
		"想得开", "	xiang3	de	kai1",
		"想不到", "	xiang3	bu2	dao4",
		"切削角", "	qie1	xue1	jiao3",
		"量子论", "	liang4	zi3	lun4",
		"情急了", "	qing2	ji2	liao3",
		"召陵区", "	shao4	ling2	qu1",
		"切向力", "	qie1	xiang4	li4",
		"更新版", "	geng1	xin1	ban3",
		"分子量", "	fen4	zi3	liang4",
		"粘性土", "	nian2	xing4	tu3",
		"调节板", "	tiao2	jie2	ban3",
		"调节池", "	tiao2	jie2	chi2",
		"娘子军", "	niang2	zi3	jun1",
		"累进税", "	lei3	jin4	shui4",
		"更年期", "	geng1	nian2	qi1",
		"冷脸子", "	leng3	lian3	zi3",
		"转差率", "	zhuan3	cha1	lv4",
		"转字锁", "	zhuan4	zi4	suo3",
		"更新世", "	geng1	xin1	shi4",
		"均匀性", "	jun1	yun2	xing4",
		"南乡子", "	nan2	xiang1	zi3",
		"轻音乐", "	qing1	yin1	yue4",
		"切成丝", "	qie1	cheng2	si1",
		"载客量", "	zai3	ke4	liang4",
		"控制杆", "	kong4	zhi4	gan3",
		"白娘子", "	bai2	niang2	zi3",
		"肋条肉", "	lei4	tiao2	rou4",
		"软龈音", "	ruan3	yin2	yin1",
		"软着陆", "	ruan3	zhuo2	lu4",
		"垣曲县", "	yuan2	qu3	xian4",
		"乾隆帝", "	qian2	long2	di4",
		"利眠宁", "	li4	mian2	ning4",
		"上大夫", "	shang4	dai4	fu1",
		"手指头", "	shou3	zhi2	tou",
		"苯中毒", "	ben3	zhong4	du2",
		"数九天", "	shu3	jiu3	tian1",
		"长舌妇", "	chang2	she2	fu4",
		"出差费", "	chu1	chai1	fei4",
		"音乐院", "	yin1	yue4	yuan4",
		"处分权", "	chu3	fen4	quan2",
		"顶呱呱", "	ding3	gua1	gua1",
		"长乐市", "	chang2	le4	shi4",
		"马生角", "	ma3	sheng1	jue2",
		"斗南镇", "	dou3	nan2	zhen4",
		"应变力", "	ying4	bian4	li4",
		"新干县", "	xin1	gan1	xian4",
		"灵雀寺", "	ling2	qiao3	si4",
		"闪亮儿", "	shan3	liang4	r",
		"抽空机", "	chou1	kong4	ji1",
		"十天干", "	shi2	tian1	gan1",
		"冲劲儿", "	chong4	jin4	er",
		"汇出行", "	hui4	chu1	hang2",
		"成都市", "	cheng2	du1	shi4",
		"长途车", "	chang2	tu2	che1",
		"长葛市", "	chang2	ge3	shi4",
		"北斗镇", "	bei3	dou3	zhen4",
		"成方儿", "	cheng2	fang1	r",
		"北斗星", "	bei3	dou3	xing1",
		"热效应", "	re4	xiao4	ying4",
		"文化圈", "	wen2	hua4	juan4",
		"抽冷子", "	chou1	leng3	zi3",
		"全武行", "	quan2	wu3	hang2",
		"新娘子", "	xin1	niang2	zi3",
		"涂浆台", "	tu2	jiang4	tai2",
		"调味汁", "	tiao2	wei4	zhi1",
		"曾国藩", "	zeng1	guo2	fan1",
		"点电荷", "	dian3	dian4	he4",
		"调味品", "	tiao2	wei4	pin3",
		"有弹性", "	you3	tan2	xing4",
		"电熨斗", "	dian4	yun4	dou3",
		"冰凝器", "	bing1	ning2	qi4",
		"八重奏", "	ba1	chong2	zou4",
		"出风头", "	chu1	feng1	tou",
		"贡嘎县", "	gong4	ga2	xian4",
		"牛仔衫", "	niu2	zai3	shan1",
		"电荷泵", "	dian4	he4	beng4",
		"单房差", "	dan1	fang2	cha1",
		"命名法", "	ming4	ming2	fa3",
		"命名日", "	ming4	ming2	ri4",
		"病秧子", "	bing4	yang1	zi3",
		"免不了", "	mian3	bu4	liao3",
		"呱呱叫", "	gua1	gua1	jiao4",
		"伸舌头", "	shen1	she2	tou",
		"调解书", "	tiao2	jie3	shu1",
		"音乐厅", "	yin1	yue4	ting1",
		"长袍儿", "	chang2	pao2	er",
		"抓功夫", "	zhua1	gong1	fu",
		"应聘者", "	ying4	pin4	zhe3",
		"非对称", "	fei1	dui4	chen4",
		"应名儿", "	ying4	ming2	er2",
		"人参果", "	ren2	shen1	guo3",
		"隆子县", "	long2	zi3	xian4",
		"吹奏乐", "	chui1	zou4	yue4",
		"千佛洞", "	qian1	fo2	dong4",
		"射流泵", "	she4	liu2	beng4",
		"受难者", "	shou4	nan4	zhe3",
		"双子叶", "	shuang1	zi3	ye4",
		"喘不过", "	chuan3	bu	guo4",
		"南长区", "	nan2	chang2	qu1",
		"打孔钻", "	da3	kong3	zuan4",
		"难民营", "	nan4	min2	ying2",
		"难为情", "	nan2	wei2	qing2",
		"扫帚菜", "	sao4	zhou3	cai4",
		"阳电荷", "	yang2	dian4	he4",
		"反应锅", "	fan3	ying4	guo1",
		"阳电子", "	yang2	dian4	zi3",
		"阳曲县", "	yang2	qu3	xian4",
		"随风倒", "	sui2	feng1	dao3",
		"占地方", "	zhan4	di4	fang",
		"塞上曲", "	sai1	shang4	qu3",
		"三勒浆", "	san1	le4	jiang1",
		"博兴县", "	bo2	xing1	xian4",
		"打水漂", "	da3	shui3	piao1",
		"三娘子", "	san1	niang2	zi3",
		"阿莲乡", "	a	lian2	xiang1",
		"雄配子", "	xiong2	pei4	zi3",
		"反斜杠", "	fan3	xie2	gang4",
		"反应式", "	fan3	ying4	shi4",
		"原子能", "	yuan2	zi3	neng2",
		"马槟榔", "	ma3	bing1	lang",
		"十三省", "	shi2	san1	xing3",
		"长恨歌", "	chang2	hen4	ge1",
		"穷骨头", "	qiong2	gu2	tou",
		"表蒙子", "	biao3	meng2	zi3",
		"反间谍", "	fan3	jian4	die2",
		"钱串儿", "	qian2	chuan4	r",
		"受不了", "	shou4	bu4	liao3",
		"铺面房", "	pu1	mian4	fang2",
		"纯音乐", "	chun2	yin1	yue4",
		"磁效应", "	ci2	xiao4	ying4",
		"香子兰", "	xiang1	zi3	lan2",
		"鹿角胶", "	lu4	jiao3	jiao1",
		"反应堆", "	fan3	ying4	dui1",
		"纯阳子", "	chun2	yang2	zi3",
		"生发油", "	sheng1	fa4	you2",
		"操纵杆", "	cao1	zong4	gan3",
		"绿茸茸", "	lv4	rong2	rong2",
		"担担面", "	dan4	dɑn	mian4",
		"曲颈甑", "	qu3	jing3	zeng4",
		"生查子", "	sheng1	zha1	zi3",
		"嘉兴市", "	jia1	xing1	shi4",
		"时间差", "	shi2	jian1	cha1",
		"嘉荫县", "	jia1	yin4	xian4",
		"钻空子", "	zuan1	kong4	zi",
		"长统袜", "	chang2	tong3	wa4",
		"长臂猿", "	chang2	bi4	yuan2",
		"怔神儿", "	zheng1	shen2	r",
		"调整到", "	tiao2	zheng3	dao4",
		"少年宫", "	shao4	nian2	gong1",
		"张僧繇", "	zhang1	seng1	you2",
		"乱哄哄", "	luan4	hong3	hong3",
		"撑得慌", "	cheng1	de	huang1",
		"码长城", "	ma3	chang2	cheng2",
		"检察长", "	jian3	cha2	chang2",
		"间断性", "	jian4	duan4	xing4",
		"轧钢厂", "	zha2	gang1	chang3",
		"半长轴", "	ban4	chang2	zhou2",
		"统称为", "	tong3	cheng1	wei2",
		"出洋相", "	chu1	yang2	xiang4",
		"切成块", "	qie1	cheng2	kuai4",
		"多重性", "	duo1	chong2	xing4",
		"天长市", "	tian1	chang2	shi4",
		"双子宫", "	shuang1	zi3	gong1",
		"脑中风", "	nao3	zhong4	feng1",
		"膀胱炎", "	pang2	guang1	yan2",
		"着重号", "	zhuo2	zhong4	hao4",
		"四重唱", "	si4	chong2	chang4",
		"曾庆红", "	zeng1	qing4	hong2",
		"双折射", "	shuang1	zhe1	she4",
		"蒜茸钳", "	suan4	rong2	qian2",
		"眼镜框", "	yan3	jing4	kuang4",
		"谷梁传", "	gu3	liang2	zhuan4",
		"种植园", "	zhong4	zhi2	yuan2",
		"弹簧钢", "	tan2	huang2	gang1",
		"陈省身", "	chen2	xing3	shen1",
		"供应站", "	gong4	ying1	zhan4",
		"瞭望哨", "	liao4	wang4	shao4",
		"脏躁症", "	zang1	zao4	zheng4",
		"灯笼椒", "	deng1	long	jiao1",
		"供应舰", "	gong1	ying4	jian4",
		"小旋风", "	xiao3	xuan4	feng1",
		"光波长", "	guang1	bo1	chang2",
		"兜率天", "	dou1	shuai4	tian1",
		"光感应", "	guang1	gan3	ying4",
		"兜率宫", "	dou1	shuai4	gong1",
		"强迫症", "	qiang3	po4	zheng4",
		"长相思", "	zhang3	xiang4	si1",
		"旋风装", "	xuan4	feng1	zhuang1",
		"长公主", "	chang2	gong1	zhu3",
		"长兴岛", "	chang2	xing1	dao3",
		"衡量制", "	heng2	liang	zhi4",
		"桑螵蛸", "	sang1	piao1	xiao1",
		"九重霄", "	jiu3	chong2	xiao1",
		"身分证", "	shen1	fen4	zheng4",
		"闪长岩", "	shan3	chang2	yan2",
		"门边框", "	men2	bian1	kuang4",
		"少年行", "	shao4	nian2	xing2",
		"王舍城", "	wang2	she4	cheng2",
		"独唱曲", "	du2	chang4	qu3",
		"谢长廷", "	xie4	chang2	ting2",
		"双曲面", "	shuang1	qu3	mian4",
		"长岛县", "	chang2	dao3	xian4",
		"田长霖", "	tian2	chang2	lin2",
		"弹簧销", "	tan2	huang2	xiao1",
		"长毛绒", "	chang2	mao2	rong2",
		"混水墙", "	hun2	shui3	qiang2",
		"永兴县", "	yong3	xing1	xian4",
		"长命锁", "	chang2	ming4	suo3",
		"长流水", "	chang2	liu2	shui3",
		"龈脓肿", "	yin2	nong2	zhong3",
		"甲壳虫", "	jia3	qiao4	chong2",
		"洪洞县", "	hong2	tong2	xian4",
		"轰隆隆", "	hong1	long1	long2",
		"乾清宫", "	qian2	qing1	gong1",
		"青少年", "	qing1	shao4	nian2",
		"重阳节", "	chong2	yang2	jie2",
		"炸酱面", "	zha2	jiang4	mian4",
		"农场主", "	nong2	chang2	zhu3",
		"青囊经", "	qing1	nang2	jing1",
		"黄萎病", "	huang2	wei3	bing4",
		"光反应", "	guang1	fan3	ying4",
		"广成子", "	guang3	cheng2	zi3",
		"霰弹枪", "	xian4	dan4	qiang1",
		"电转盘", "	dian4	zhuan4	pan2",
		"清算行", "	qing1	suan4	hang2",
		"青藏线", "	qing1	zang4	xian4",
		"长长的", "	chang2	chang2	de",
		"星相学", "	xing1	xiang4	xue2",
		"手相学", "	shou3	xiang4	xue2",
		"兴山县", "	xing1	shan1	xian4",
		"延长县", "	yan2	chang2	xian4",
		"两边倒", "	liang3	bian1	dao3",
		"连接框", "	lian2	jie1	kuang4",
		"相位表", "	xiang4	wei4	biao3",
		"相适应", "	xiang1	shi4	ying4",
		"响应值", "	xiang3	ying4	zhi2",
		"兴隆县", "	xing1	long2	xian4",
		"粮食厅", "	liang2	shi	ting1",
		"相电流", "	xiang4	dian4	liu2",
		"兴城市", "	xing1	cheng2	shi4",
		"兴中会", "	xing1	zhong1	hui4",
		"适应症", "	shi4	ying4	zheng4",
		"鹿角霜", "	lu4	jiao3	shuang1",
		"罗盛教", "	luo2	cheng2	jiao4",
		"侍应生", "	shi4	ying4	sheng1",
		"杓球场", "	shao2	qiu2	chang3",
		"延长线", "	yan2	chang2	xian4",
		"藏经洞", "	zang4	jing1	dong4",
		"重庆市", "	chong2	qing4	shi4",
		"转轮王", "	zhuan4	lun2	wang2",
		"弹簧管", "	tan2	huang2	guan3",
		"薯莨绸", "	shu3	liang2	chou2",
		"星相术", "	xing1	xiang4	shu4",
		"萧万长", "	xiao1	wan4	chang2",
		"星相师", "	xing1	xiang4	shi1",
		"长城卡", "	chang2	cheng2	ka3",
		"应召站", "	ying4	zhao4	zhan4",
		"宽甸县", "	kuan1	dian4	xian4",
		"前首相", "	qian2	shou3	xiang4",
		"相空间", "	xiang4	kong1	jian1",
		"长垣县", "	chang2	yuan2	xian4",
		"范长江", "	fan4	chang2	jiang1",
		"白晃晃", "	bai2	huang4	huang3",
		"工段长", "	gong1	duan4	chang2",
		"公平秤", "	gong1	ping2	cheng4",
		"绷场面", "	beng1	chang3	mian4",
		"娘娘腔", "	niang2	niang	qiang1",
		"重正化", "	chong2	zheng4	hua4",
		"转动轴", "	zhuan4	dong4	zhou2",
		"转动件", "	zhuan4	dong4	jian4",
		"上将军", "	shang4	jiang4	jun1",
		"长宁县", "	chang2	ning2	xian4",
		"正当性", "	zheng4	dang4	xing4",
		"相对象", "	xiang4	dui4	xiang4",
		"旧框框", "	jiu4	kuang4	kuang",
		"金晃晃", "	jin1	huang4	huang3",
		"左丞相", "	zuo3	cheng2	xiang4",
		"照相馆", "	zhao4	xiang4	guan3",
		"正长石", "	zheng4	chang2	shi2",
		"长绒棉", "	chang2	rong2	mian2",
		"长寿面", "	chang2	shou4	mian4",
		"老框框", "	lao3	kuang4	kuang4",
		"上半晌", "	shang4	ban4	shang3",
		"肖像权", "	xiao1	xiang4	quan2",
		"长岭县", "	chang2	ling3	xian4",
		"供应商", "	gong1	ying4	shang1",
		"长角羊", "	chang2	jiao3	yang2",
		"扛长工", "	kang2	chang2	gong1",
		"蒙蒙亮", "	meng2	meng1	liang4",
		"长城牌", "	chang2	cheng2	pai2",
		"长庚星", "	chang2	geng1	xing1",
		"重甸甸", "	zhong4	dian4	dian4",
		"还乡团", "	huan2	xiang1	tuan2",
		"相平面", "	xiang4	ping2	mian4",
		"中奖者", "	zhong4	jiang3	zhe3",
		"油晃晃", "	you2	huang4	huang3",
		"右丞相", "	you4	cheng2	xiang4",
		"长丰县", "	chang2	feng1	xian4",
		"长兴县", "	chang2	xing1	xian4",
		"长方形", "	chang2	fang1	xing2",
		"调整环", "	tiao2	zheng3	huan2",
		"长生果", "	chang2	sheng1	guo3",
		"长滨乡", "	chang2	bin1	xiang1",
		"长治乡", "	chang2	zhi4	xiang1",
		"长汀县", "	chang2	ting1	xian4",
		"长毛象", "	chang2	mao2	xiang4",
		"膀胱镜", "	pang2	guang1	jing4",
		"长颈龙", "	chang2	jing3	long2",
		"长颈瓶", "	chang2	jing3	ping2",
		"长顺县", "	chang2	shun4	xian4",
		"长明灯", "	chang2	ming2	deng1",
		"团团转", "	tuan2	tuan2	zhuan4",
		"厚生相", "	hou4	sheng1	xiang4",
		"工伤假", "	gong1	shang1	jia4",
		"长白镇", "	chang2	bai2	zhen4",
		"弹簧床", "	tan2	huang2	chuang2",
		"长城站", "	chang2	cheng2	zhan4",
		"创伤后", "	chuang1	shang1	hou4",
		"重定向", "	chong2	ding4	xiang4",
		"穷酸相", "	qiong2	suan1	xiang4",
		"长泰县", "	chang2	tai4	xian4",
		"兴冲冲", "	xing1	chong1	chong1",
		"应用层", "	ying4	yong4	ceng2",
		"长治县", "	chang2	zhi4	xian4",
		"长沙县", "	chang2	sha1	xian4",
		"茄萣乡", "	qie2	ding4	xiang1",
		"江城子", "	jiang1	cheng2	zi3",
		"长海县", "	chang2	hai3	xian4",
		"长蛇阵", "	chang2	she2	zhen4",
		"二重唱", "	er4	chong2	chang4",
		"长统靴", "	chang2	tong3	xue1",
		"长筒靴", "	chang2	tong3	xue1",
		"应用性", "	ying4	yong4	xing4",
		"粘着性", "	zhan1	zhuo2	xing4",
		"长春市", "	chang2	chun1	shi4",
		"村上隆", "	cun1	shang4	long1",
		"旋风脚", "	xuan4	feng1	jiao3",
		"檀香扇", "	tan2	xiang1	shan4",
		"交响乐", "	jiao1	xiang3	yue4",
		"长生天", "	chang2	sheng1	tian1",
		"蛮漂亮", "	man2	piao4	liang",
		"中间件", "	zhong1	jian1	jian4",
		"两重天", "	liang3	chong2	tian1",
		"中长跑", "	zhong1	chang2	pao3",
		"花生浆", "	hua1	sheng1	jiang4",
		"双生子", "	shuang1	sheng1	zi3",
		"少壮派", "	shao4	zhuang4	pai4",
		"应声虫", "	ying4	sheng1	chong2",
		"中甸县", "	zhong1	dian4	xian4",
		"敲丧钟", "	qiao1	sang1	zhong1",
		"楞怔怔", "	leng2	zheng4	zheng4",
		"正仓院", "	zheng1	cang1	yuan4",
		"众生相", "	zhong4	sheng1	xiang4",
		"哮喘病", "	xiao4	chuan3	bing4",
		"两重性", "	liang3	chong2	xing4",
		"长生殿", "	chang2	sheng1	dian4",
		"卷轴装", "	juan4	zhou2	zhuang1",
		"元长乡", "	yuan2	chang2	xiang1",
		"川滇藏", "	chuan1	dian1	zang4",
		"川党参", "	chuan1	dang3	shen1",
		"切向量", "	qie1	xiang4	liang4",
		"弓长岭", "	gong1	chang2	ling3",
		"弹簧秤", "	tan2	huang2	cheng4",
		"朝鲜筝", "	chao2	xian3	zheng1",
		"公羊传", "	gong1	yang2	zhuan4",
		"长白县", "	chang2	bai2	xian4",
		"长白山", "	chang2	bai2	shan1",
		"中标者", "	zhong4	biao1	zhe3",
		"香獐子", "	xiang1	zhang1	zi3",
		"二重性", "	er4	chong2	xing4",
		"游说团", "	you2	shui4	tuan2",
		"链反应", "	lian4	fan3	ying4",
		"传记片", "	zhuan4	ji4	pian4",
		"供应者", "	gong1	ying4	zhe3",
		"着陆场", "	zhuo2	lu4	chang3",
		"着眼点", "	zhuo2	yan3	dian3",
		"怪念头", "	guai4	nian4	tou",
		"大城市", "	dai4	cheng2	shi4",
		"性行为", "	xing4	xing2	wei2",
		"黑糁糁", "	hei1	shen1	shen1",
		"辉长岩", "	hui1	chang2	yan2",
		"性偏好", "	xing4	pian1	hao4",
		"性兴奋", "	xing4	xing1	fen4",
		"弹着点", "	dan4	zhuo2	dian3",
		"天台山", "	tian1	tai1	shan1",
		"冷轧钢", "	leng3	zha2	gang1",
		"廊坊市", "	lang2	fang2	shi4",
		"酌处权", "	zhuo2	chu3	quan2",
		"刀削面", "	dao1	xiao1	mian4",
		"李长春", "	li3	chang2	chun1",
		"切平面", "	qie1	ping2	mian4",
		"还原酶", "	huan2	yuan2	mei2",
		"不相称", "	bu4	xiang1	chen4",
		"丹参酮", "	dan1	shen1	tong2",
		"行香子", "	xing2	xiang1	zi3",
		"挑战书", "	tiao3	zhan4	shu1",
		"能量子", "	neng2	liang4	zi3",
		"兴隆台", "	xing1	long2	tai2",
		"转速表", "	zhuan4	su4	biao3",
		"快中子", "	kuai4	zhong1	zi3",
		"适应性", "	shi4	ying4	xing4",
		"致良知", "	zhi4	liang2	zhi1",
		"电子秤", "	dian4	zi3	cheng4",
		"扬子江", "	yang2	zi3	jiang1",
		"同字框", "	tong2	zi4	kuang4",
		"兴国县", "	xing1	guo2	xian4",
		"退行性", "	tui4	xing2	xing4",
		"换档杆", "	huan4	dang4	gan3",
		"分散相", "	fen1	san4	xiang4",
		"毛茸茸", "	mao2	rong2	rong2",
		"换挡杆", "	huan4	dang3	gan3",
		"东兴市", "	dong1	xing1	shi4",
		"东三省", "	dong1	san1	xing3",
		"救难船", "	jiu4	nan4	chuan2",
		"保险杠", "	bao3	xian3	gang4",
		"豆豉酱", "	dou4	chi3	jiang4",
		"灰蒙蒙", "	hui1	meng1	meng2",
		"黄埔港", "	huang2	pu3	gang3",
		"酸中毒", "	suan1	zhong4	du2",
		"进行性", "	jin4	xing2	xing4",
		"兴海县", "	xing1	hai3	xian4",
		"豁免权", "	huo4	mian3	quan2",
		"三重市", "	san1	chong2	shi4",
		"都昌县", "	du1	chang1	xian4",
		"九转丹", "	jiu3	zhuan4	dan1",
		"空白表", "	kong4	bai2	biao3",
		"间歇泉", "	jian4	xie1	quan2",
		"间接税", "	jian4	jie1	shui4",
		"霰粒肿", "	xian4	li4	zhong3",
		"寻甸县", "	xun2	dian4	xian4",
		"戳脊梁", "	chuo1	ji3	liang",
		"洋中脊", "	yang2	zhong1	ji3",
		"有粘性", "	you3	nian2	xing4",
		"开小差", "	kai1	xiao3	chai1",
		"朝鲜人", "	chao2	xian3	ren2",
		"内省性", "	nei4	xing3	xing4",
		"挑逗性", "	tiao3	dou4	xing4",
		"福兴乡", "	fu2	xing1	xiang1",
		"称之为", "	cheng1	zhi1	wei2",
		"照相簿", "	zhao4	xiang4	bu4",
		"白蛇传", "	bai2	she2	zhuan4",
		"咸兴市", "	xian2	xing1	shi4",
		"关卡税", "	guan1	qia3	shui4",
		"弧线长", "	hu2	xian4	chang2",
		"原子量", "	yuan2	zi3	liang4",
		"长蛇座", "	chang2	she2	zuo4",
		"丧葬费", "	sang1	zang4	fei4",
		"乔冠华", "	qiao2	guan1	hua4",
		"子长县", "	zi3	chang2	xian4",
		"量油尺", "	liang2	you2	chi3",
		"称多县", "	chen4	duo1	xian4",
		"见世面", "	xian4	shi4	mian4",
		"三重奏", "	san1	chong2	zou4",
		"转一趟", "	zhuan4	yi1	tang4",
		"线桄子", "	xian4	guang4	zi",
		"转车台", "	zhuan4	che1	tai2",
		"供应品", "	gong1	ying4	pin3",
		"涡阳县", "	guo1	yang2	xian4",
		"供应室", "	gong1	ying4	shi4",
		"拓荒者", "	tuo4	huang1	zhe3",
		"兴奋性", "	xing1	fen4	xing4",
		"缝纫工", "	feng2	ren4	gong1",
		"一年生", "	yi4	nian2	sheng1",
		"自转轴", "	zi4	zhuan4	zhou2",
		"天台宗", "	tian1	tai1	zong1",
		"电子枪", "	dian4	zi3	qiang1",
		"电荷量", "	dian4	he4	liang4",
		"弹性销", "	tan2	xing4	xiao1",
		"铜管乐", "	tong2	guan3	yue4",
		"还原焰", "	huan2	yuan2	yan4",
		"烹调术", "	peng1	tiao2	shu4",
		"切空间", "	qie1	kong1	jian1",
		"凉州曲", "	liang2	zhou1	qu3",
		"三框栏", "	san1	kuang4	lan2",
		"兴仁县", "	xing1	ren2	xian4",
		"相似形", "	xiang1	si4	xing2",
		"扇面琴", "	shan1	mian4	qin2",
		"间谍网", "	jian4	die2	wang3",
		"兴文县", "	xing1	wen2	xian4",
		"扫帚星", "	sao4	zhou3	xing1",
		"命令行", "	ming4	ling4	hang2",
		"摔跟头", "	shuai1	gen1	tou",
		"教书匠", "	jiao1	shu1	jiang4",
		"照相纸", "	zhao4	xiang4	zhi3",
		"长寿菜", "	chang2	shou4	cai4",
		"枞阳县", "	zong1	yang2	xian4",
		"荥经县", "	ying2	jing1	xian4",
		"着火点", "	zhao2	huo3	dian3",
		"幻想曲", "	huan4	xiang3	qu3",
		"曾荫权", "	zeng1	yin4	quan2",
		"强的松", "	qiang2	di2	song1",
		"面包片", "	mian4	bao1	pian1",
		"照相机", "	zhao4	xiang4	ji1",
		"铅中毒", "	qian1	zhong4	du2",
		"中圈套", "	zhong4	quan1	tao4",
		"喜相逢", "	xi3	xiang4	feng2",
		"佛跳墙", "	fo2	tiao4	qiang2",
		"总长度", "	zong3	chang2	du4",
		"黑旋风", "	hei1	xuan4	feng1",
		"纵切面", "	zong4	qie1	mian4",
		"相片儿", "	xiang4	pian1	er",
		"干事长", "	gan4	shi	zhang3",
		"漂白水", "	piao3	bai2	shui3",
		"重婚罪", "	chong2	hun1	zui4",
		"拉长脸", "	la1	chang2	lian3",
		"校书郎", "	jiao4	shu1	lang2",
		"沧浪亭", "	cang1	lang2	ting2",
		"氧效应", "	yang3	xiao4	ying4",
		"冗长度", "	rong3	chang2	du4",
		"三重县", "	san1	chong2	xian4",
		"行情表", "	hang2	qing2	biao3",
		"娘家姓", "	niang2	jia	xing4",
		"沉甸甸", "	chen2	dian4	dian4",
		"中都城", "	zhong1	du1	cheng2",
		"绷子床", "	beng1	zi	chuang2",
		"审判长", "	shen3	pan4	chang2",
		"航行灯", "	hang2	xing2	deng1",
		"狂想曲", "	kuang2	xiang3	qu3",
		"海监船", "	hai3	jian4	chuan2",
		"长镜头", "	chang2	jing4	tou2",
		"生还者", "	sheng1	huan2	zhe3",
		"颈椎病", "	jing3	zhui1	bing4",
		"小公共", "	xiao3	gong1	gong4",
		"清劲风", "	qing1	jing4	feng1",
		"钻井工", "	zuan4	jing3	gong1",
		"黄克强", "	huang2	ke4	jiang4",
		"黄长烨", "	huang2	chang2	ye4",
		"吃空饷", "	chi1	kong4	xiang3",
		"还原糖", "	huan2	yuan2	tang2",
		"照相版", "	zhao4	xiang4	ban3",
		"照相术", "	zhao4	xiang4	shu4",
		"定兴县", "	ding4	xing1	xian4",
		"测量船", "	ce4	liang2	chuan2",
		"灭虫宁", "	mie4	chong2	ning4",
		"车头相", "	che1	tou2	xiang4",
		"金刚钻", "	jin1	gang1	zuan4",
		"兴平市", "	xing1	ping2	shi4",
		"朴正熙", "	piao2	zheng4	xi1",
		"轴对称", "	zhou2	dui4	chen4",
		"相扑手", "	xiang4	pu1	shou3",
		"漂流瓶", "	piao1	liu2	ping2",
		"复兴乡", "	fu4	xing1	xiang1",
		"晕血症", "	yun4	xue4	zheng4",
		"白相人", "	bai2	xiang4	ren2",
		"卷筒纸", "	juan4	tong3	zhi3",
		"假芫茜", "	jia3	yuan2	qian4",
		"万圣节", "	wan4	sheng4	jie1",
		"种植者", "	zhong4	zhi2	zhe3",
		"调味料", "	tiao2	wei4	liao4",
		"排行榜", "	pai2	hang2	bang3",
		"粘土砖", "	nian2	tu3	zhuan1",
		"水浒传", "	shui3	hu3	zhuan4",
		"卷叶虫", "	juan4	ye4	chong2",
		"红娘子", "	hong2	niang2	zi3",
		"轧钢条", "	zha2	gang1	tiao2",
		"弹簧板", "	tan2	huang2	ban3",
		"酆都城", "	feng1	du1	cheng2",
		"兴宁市", "	xing1	ning2	shi4",
		"林甸县", "	lin2	dian4	xian4",
		"电转儿", "	dian4	zhuan4	er2",
		"运动员", "	yun4	dong4	yuan2",
		"拖累症", "	tuo1	lei3	zheng4",
		"将进酒", "	qiang1	jin4	jiu3",
		"创可贴", "	chuang1	ke3	tie1",
		"上齿龈", "	shang4	chi3	yin2",
		"闹哄哄", "	nao4	hong1	hong3",
		"吹管乐", "	chui1	guan3	yue4",
		"走为上", "	zou3	wei2	shang4",
		"溜溜转", "	liu1	liu1	zhuan4",
		"重身子", "	chong2	shen1	zi",
		"超对称", "	chao1	dui4	chen4",
		"子宫腔", "	zi3	gong1	qiang1",
		"未命名", "	wei4	ming4	ming2",
		"重覆性", "	chong2	fu4	xing4",
		"数得上", "	shu3	dei3	shang4",
		"太行山", "	tai4	hang2	shan1",
		"种牛痘", "	zhong4	niu2	dou4",
		"星相图", "	xing1	xiang4	tu2",
		"横切面", "	heng2	qie1	mian4",
		"量尺寸", "	liang2	chi3	cun4",
		"调节税", "	tiao2	jie2	shui4",
		"调停者", "	tiao2	ting2	zhe3",
		"伽南香", "	qie2	nan2	xiang1",
		"相应物", "	xiang1	ying4	wu4",
		"荐头店", "	jian4	tou	dian4",
		"娘子关", "	niang2	zi3	guan1",
		"调节表", "	tiao2	jie2	biao3",
		"切换键", "	qie1	huan4	jian4",
		"小娘子", "	xiao3	niang2	zi3",
		"闹嚷嚷", "	nao4	rang1	rɑng",
		"列女传", "	lie4	nv3	zhuan4",
		"放大率", "	fang4	da4	shuai4",
		"看得中", "	kan4	de	zhong4",
		"打折票", "	da3	she2	piao4",
		"反应力", "	fan3	ying4	li4",
		"剪切力", "	jian3	qie1	li4",
		"工夫茶", "	gong1	fu	cha2",
		"电子云", "	dian4	zi3	yun2",
		"胃粘膜", "	wei4	nian2	mo2",
		"小舅子", "	xiao3	jiu4	zi3",
		"肠阻塞", "	chang2	zu3	se4",
		"过得硬", "	guo4	de	ying4",
		"剪头发", "	jian3	tou2	fa",
		"肋间肌", "	lei4	jian1	ji1",
		"拗口令", "	ao4	kou3	ling4",
		"压倒性", "	ya1	dao3	xing4",
		"脊椎炎", "	ji3	zhui1	yan2",
		"甲壳素", "	jia3	qiao4	su4",
		"眼见得", "	yan3	jian4	de",
		"弹球盘", "	tan2	qiu2	pan2",
		"直贡呢", "	zhi2	gong4	ni2",
		"消闲儿", "	xiao1	xian2	r",
		"耍骨头", "	shua3	gu2	tou",
		"耍笔杆", "	shua3	bi3	gan3",
		"看花眼", "	kan1	hua1	yan3",
		"不要脸", "	bu2	yao4	lian3",
		"车前子", "	che1	qian2	zi3",
		"决明子", "	jue2	ming2	zi3",
		"澎湖岛", "	peng2	hu2	dao3",
		"甩负荷", "	shuai3	fu4	he4",
		"核门槛", "	he2	men2	jian4",
		"畜产品", "	xu4	chan3	pin3",
		"小石子", "	xiao3	shi2	zi3",
		"顺手儿", "	shun4	shou3	r",
		"留成儿", "	liu2	cheng2	r",
		"要不了", "	yao4	bu4	liao3",
		"氧分子", "	yang3	fen1	zi3",
		"掺沙子", "	chan1	sha1	zi",
		"打麻将", "	da3	ma2	jiang4",
		"顶尖儿", "	ding3	jian1	r",
		"佛手瓜", "	fo2	shou3	gua1",
		"乐学者", "	yue4	xue2	zhe3",
		"罗刹国", "	luo2	cha4	guo2",
		"番茄汁", "	fan1	qie2	zhi1",
		"歪点子", "	wai1	dian3	zi3",
		"小叔子", "	xiao3	shu1	zi3",
		"不倒翁", "	bu4	dao3	weng1",
		"更衣室", "	geng1	yi1	shi4",
		"逍遥子", "	xiao1	yao2	zi3",
		"片儿会", "	pian1	er	hui4",
		"大龙湫", "	da4	long2	qiu1",
		"叫化子", "	jiao4	hua1	zi",
		"放得下", "	fang4	de	xia4",
		"捅娄子", "	tong3	lou2	zi3",
		"看门人", "	kan1	men2	ren2",
		"太子港", "	tai4	zi3	gang3",
		"淋溶土", "	lin4	rong2	tu3",
		"轧钢机", "	zha2	gang1	ji1",
		"老爷岭", "	lao3	ye	ling3",
		"箭垛子", "	jian4	duo4	zi",
		"娘儿们", "	niang2	r	men",
		"冷处理", "	leng3	chu3	li3",
		"音乐节", "	yin1	yue4	jie2",
		"打晃儿", "	da3	huang4	er",
		"省劲儿", "	sheng3	jin4	r",
		"高低杠", "	gao1	di1	gang4",
		"大还丹", "	da4	huan2	dan1",
		"副反应", "	fu4	fan3	ying4",
		"音乐会", "	yin1	yue4	hui4",
		"不协调", "	bu4	xie2	tiao2",
		"反应物", "	fan3	ying4	wu4",
		"太子党", "	tai4	zi3	dang3",
		"协调器", "	xie2	tiao2	qi4",
		"吃不了", "	chi1	bu4	liao3",
		"音乐家", "	yin1	yue4	jia1",
		"博白县", "	bo2	bai2	xian4",
		"佛山市", "	fo2	shan1	shi4",
		"树行子", "	shu4	hang4	zi",
		"数得着", "	shu3	de	zhao2",
		"重复法", "	chong2	fu4	fa3",
		"夫妻相", "	fu1	qi1	xiang4",
		"韦应物", "	wei2	ying4	wu4",
		"贼忒忒", "	zei2	tui1	tui1",
		"漂流物", "	piao1	liu2	wu4",
		"半彪子", "	ban4	biao1	zi3",
		"韛拐子", "	bai4	guai3	zi3",
		"处理权", "	chu3	li3	quan2",
		"反应热", "	fan3	ying4	re4",
		"知识界", "	zhi1	shi	jie4",
		"差异性", "	cha1	yi4	xing4",
		"鬼点子", "	gui3	dian3	zi3",
		"短打扮", "	duan3	da3	ban",
		"切削机", "	qie1	xiao1	ji1",
		"重离子", "	zhong4	li2	zi3",
		"军乐队", "	jun1	yue4	dui4",
		"一边倒", "	yi1	bian1	dao3",
		"不划算", "	bu4	hua2	suan4",
		"软耳朵", "	ruan3	er3	duo",
		"惠更斯", "	hui4	geng1	si1",
		"电子琴", "	dian4	zi3	qin2",
		"野颠茄", "	ye3	dian1	qie2",
		"原子价", "	yuan2	zi3	jia4",
		"电子书", "	dian4	zi3	shu1",
		"翻跟头", "	fan1	gen1	tou",
		"翻跟斗", "	fan1	gen1	dou3",
		"刘少奇", "	liu2	shao4	qi2",
		"打工仔", "	da3	gong1	zai3",
		"刘涓子", "	liu2	juan1	zi3",
		"番茄粉", "	fan1	qie2	fen3",
		"重活儿", "	zhong4	huo2	r",
		"反应炉", "	fan3	ying4	lu2",
		"较真儿", "	jiao4	zhen1	r",
		"草垫子", "	cao3	dian4	zi3",
		"音乐学", "	yin1	yue4	xue2",
		"反应器", "	fan3	ying4	qi4",
		"柔佛州", "	rou2	fo2	zhou1",
		"淋球菌", "	lin4	qiu2	jun1",
		"蜚蠊科", "	fei3	lian2	ke1",
		"石头人", "	shi2	tou	ren2",
		"磨工病", "	mo4	gong1	bing4",
		"原子团", "	yuan2	zi3	tuan2",
		"增压泵", "	zeng1	ya4	beng4",
		"朝鲜语", "	chao2	xian3	yu3",
		"均方差", "	jun1	fang1	cha1",
		"变速杆", "	bian4	su4	gan3",
		"差旅费", "	chai1	lv3	fei4",
		"参宿七", "	shen1	xiu4	qi1",
		"漂白液", "	piao3	bai2	ye4",
		"阿房宫", "	e1	pang2	gong1",
		"量子沫", "	liang4	zi3	mo4",
		"翻筋斗", "	fan1	jin1	dou3",
		"小太太", "	xiao3	tai4	tai",
		"子宫内", "	zi3	gong1	nei4",
		"缝纫机", "	feng2	ren4	ji1",
		"伽罗华", "	jia1	luo2	hua4",
		"刽子手", "	gui4	zi3	shou3",
		"露马脚", "	lou4	ma3	jiao3",
		"搬舌头", "	ban1	she2	tou",
		"总书记", "	zong3	shu1	ji",
		"子宫瘤", "	zi3	gong1	liu2",
		"碳原子", "	tan4	yuan2	zi3",
		"露馅儿", "	lou4	xian4	er2",
		"波带片", "	bo1	dai4	pian1",
		"种植业", "	zhong4	zhi2	ye4",
		"行得通", "	xing2	de	tong1",
		"称得起", "	cheng1	de	qi3",
		"鹿谷乡", "	lu4	gu3	xiang1",
		"主属性", "	zhu3	shu3	xing4",
		"莲花落", "	lian2	hua1	lao4",
		"跟得上", "	gen1	de	shang4",
		"曾孙女", "	zeng1	sun1	nv3",
		"蒙代尔", "	meng1	dai4	er3",
		"著作郎", "	zhu4	zuo4	lang2",
		"闹乱子", "	nao4	luan4	zi3",
		"朝歌镇", "	zhao1	ge1	zhen4",
		"氢原子", "	qing1	yuan2	zi3",
		"公共课", "	gong1	gong4	ke4",
		"碰钉子", "	peng4	ding4	zi3",
		"蒙嘉慧", "	meng3	jia1	hui4",
		"竹扫帚", "	zhu2	sao4	zhou",
		"电子眼", "	dian4	zi3	yan3",
		"行列式", "	hang2	lie4	shi4",
		"乐清市", "	yue4	qing1	shi4",
		"尖沙咀", "	jian1	sha1	zui3",
		"一点点", "	yi4	dian3	dian3",
		"炸薯条", "	zha2	shu3	tiao2",
		"枪杆子", "	qiang1	gan3	zi",
		"女舍监", "	nu:3	she4	jian1",
		"朝鲜族", "	chao2	xian3	zu2",
		"炸薯片", "	zha2	shu3	pian4",
		"瞎忙活", "	xia1	mang2	huo",
		"子宫环", "	zi3	gong1	huan2",
		"桌面儿", "	zhuo1	mian4	r",
		"槐荫区", "	huai2	yin4	qu1",
		"小崽子", "	xiao3	zai3	zi3",
		"复兴社", "	fu4	xing1	she4",
		"已更新", "	yi3	geng1	xin1",
		"翘拇指", "	qiao2	mu3	zhi3",
		"看不见", "	kan4	bu2	jian4",
		"调温器", "	tiao2	wen1	qi4",
		"看不懂", "	kan4	bu	dong3",
		"抹灰层", "	mo4	hui1	ceng2",
		"漏斗云", "	lou4	dou3	yun2",
		"疏勒县", "	shu1	le4	xian4",
		"倒霉蛋", "	dao3	mei2	dan4",
		"核反应", "	he2	fan3	ying4",
		"金国汗", "	jin1	guo2	han2",
		"鱼子酱", "	yu2	zi3	jiang4",
		"钟子期", "	zhong1	zi3	qi1",
		"调节阀", "	tiao2	jie2	fa2",
		"室内乐", "	shi4	nei4	yue4",
		"多菲什", "	duo1	fei1	shi2",
		"铺盖卷", "	pu1	gai4	juan3",
		"易卜生", "	yi4	bu3	sheng1",
		"占卜者", "	zhan1	bu3	zhe3",
		"何应钦", "	he2	ying4	qin1",
		"大娘子", "	da4	niang2	zi3",
		"散文家", "	san3	wen2	jia1",
		"升压器", "	sheng1	ya4	qi4",
		"听不到", "	ting1	bu	dao4",
		"真是的", "	zhen1	shi	de",
		"百分号", "	bai3	fen1	hao2",
		"爪哇岛", "	zhao3	wa1	dao3",
		"好家伙", "	hao3	jia1	huo",
		"坏分子", "	huai4	fen4	zi3",
		"粘结剂", "	nian2	jie2	ji4",
		"供给者", "	gong1	ji3	zhe3",
		"鹿角菜", "	lu4	jiao3	cai4",
		"咽峡炎", "	yan1	xia2	yan2",
		"金铃子", "	jin1	ling2	zi3",
		"银行业", "	yin2	hang2	ye4",
		"功夫球", "	gong1	fu	qiu2",
		"受委屈", "	shou4	wei3	qu",
		"不适当", "	bu4	shi4	dang4",
		"银行卡", "	yin2	hang2	ka3",
		"氧乙炔", "	yang3	yi3	que1",
		"汽缸盖", "	qi4	gang1	gai4",
		"着边儿", "	zhao2	bian1	r",
		"一块肉", "	yi2	kuai4	rou4",
		"罄身儿", "	qing4	shen1	r",
		"调音器", "	tiao2	yin1	qi4",
		"供给制", "	gong1	ji3	zhi4",
		"氟中毒", "	fu2	zhong4	du2",
		"摆擂台", "	bai3	lei4	tai2",
		"解调器", "	jie3	tiao2	qi4",
		"淮南子", "	huai2	nan2	zi3",
		"耳光子", "	er3	guang1	zi3",
		"烂舌头", "	lan4	she2	tou",
		"调谐器", "	tiao2	xie2	qi4",
		"猪仔包", "	zhu1	zai3	bao1",
		"笨家伙", "	ben4	jia1	huo",
		"数不着", "	shu3	bu4	zhao2",
		"蒙古人", "	meng3	gu3	ren2",
		"枪杆儿", "	qiang1	gan3	r",
		"尥蹶子", "	liao4	jue2	zi3",
		"善男子", "	shan4	nan2	zi3",
		"什刹海", "	shi2	cha4	hai3",
		"校验器", "	jiao4	yan4	qi4",
		"蚌埠市", "	beng4	bu4	shi4",
		"露一手", "	lou4	yi1	shou3",
		"迎宾曲", "	ying2	bin1	qu3",
		"工尺谱", "	gong1	che3	pu3",
		"阴电子", "	yin1	dian4	zi3",
		"原子束", "	yuan2	zi3	shu4",
		"发现号", "	fa1	xian4	hao2",
		"扎猛子", "	zha1	meng3	zi3",
		"发横财", "	fa1	heng4	cai2",
		"人缘儿", "	ren2	yuan2	er2",
		"原子弹", "	yuan2	zi3	dan4",
		"出疹子", "	chu1	zhen3	zi3",
		"切菜板", "	qie1	cai4	ban3",
		"抗倒伏", "	kang4	dao3	fu2",
		"扎线带", "	za1	xian4	dai4",
		"原子堆", "	yuan2	zi3	dui1",
		"脚腕子", "	jiao3	wan4	zi3",
		"洞子货", "	dong4	zi3	huo4",
		"寻开心", "	xin2	kai1	xin1",
		"旅行家", "	lv3	hang2	jia",
		"感应器", "	gan3	ying4	qi4",
		"采桑子", "	cai3	sang1	zi3",
		"蛋白石", "	dan4	bai2	shi2",
		"间奏曲", "	jian4	zou4	qu3",
		"闵行区", "	min3	hang2	qu1",
		"间隔号", "	jian4	ge2	hao4",
		"兵油子", "	bing1	you2	zi3",
		"和面机", "	huo2	mian4	ji1",
		"亨格洛", "	heng1	ge2	luo4",
		"盘杠子", "	pan2	gang4	zi",
		"梅干菜", "	mei2	gan1	cai4",
		"分子筛", "	fen4	zi3	shai1",
		"女神蛤", "	nu:3	shen2	ge2",
		"两头儿", "	liang3	tou2	r",
		"长距离", "	chang2	ju4	li2",
		"蚰蜒草", "	you2	dan4	cao3",
		"嚼裹儿", "	jiao2	guo3	er2",
		"干着急", "	gan1	zhao2	ji2",
		"集电杆", "	ji2	dian4	gan3",
		"票贩子", "	piao4	fan4	zi3",
		"报纸夹", "	bao4	zhi3	jia2",
		"书卷气", "	shu1	juan4	qi4",
		"咽鼓管", "	yan1	gu3	guan3",
		"粘膜炎", "	nian2	mo2	yan2",
		"伤和气", "	shang1	he2	qi",
		"处理掉", "	chu3	li3	diao4",
		"陈子昂", "	chen2	zi3	ang2",
		"动载荷", "	dong4	zai4	he4",
		"差一点", "	cha4	yi4	dian3",
		"原子时", "	yuan2	zi3	shi2",
		"牛肉干", "	niu2	rou4	gan1",
		"童子军", "	tong2	zi3	jun1",
		"室间隔", "	shi4	jian4	ge2",
		"公因子", "	gong1	yin1	zi3",
		"犬夜叉", "	quan3	ye4	cha4",
		"积累性", "	ji1	lei3	xing4",
		"牡丹亭", "	mu3	dan	ting2",
		"原子论", "	yuan2	zi3	lun4",
		"磁测量", "	ci2	ce4	liang2",
		"先君子", "	xian1	jun1	zi3",
		"人造草", "	ren2	zao4	cao3",
		"面人儿", "	mian4	ren2	er2",
		"镇得住", "	zhen4	de	zhu4",
		"栽跟头", "	zai1	gen1	tou",
		"牡丹坊", "	mu3	dan	fang1",
		"几丁质", "	ji1	ding1	zhi4",
		"切面机", "	qie1	mian4	ji1",
		"不粘锅", "	bu4	nian2	guo1",
		"发型师", "	fa4	xing2	shi1",
		"粘结力", "	nian2	jie2	li4",
		"小器作", "	xiao3	qi4	zuo1",
		"华龙区", "	hua4	long2	qu1",
		"切片机", "	qie1	pian4	ji1",
		"高丽朝", "	gao1	li2	chao2",
		"天可汗", "	tian1	ke4	han2",
		"高丽参", "	gao1	li2	shen1",
		"磨坊主", "	mo4	fang2	zhu3",
		"漂泊者", "	piao1	bo2	zhe3",
		"石榴汁", "	shi2	liu	zhi1",
		"自感应", "	zi4	gan3	ying4",
		"切断机", "	qie1	duan4	ji1",
		"八行书", "	ba1	hang2	shu1",
		"切分音", "	qie1	fen1	yin1",
		"人影儿", "	ren2	ying3	er2",
		"有时候", "	you3	shi2	hou",
		"挑担子", "	tiao1	dan4	zi",
		"旁边儿", "	pang2	bian1	r",
		"翻斗车", "	fan1	dou3	che1",
		"什件儿", "	shi2	jian4	er2",
		"早知道", "	zao3	zhi1	dao",
		"切换阀", "	qie1	huan4	fa2",
		"悲切切", "	bei1	qie4	qie1",
		"架秧子", "	jia4	yang1	zi3",
		"三班倒", "	san1	ban1	dao3",
		"仙方儿", "	xian1	fang1	r",
		"弦乐器", "	xian2	yue4	qi4",
		"绮想曲", "	qi3	xiang3	qu3",
		"济宁市", "	ji3	ning2	shi4",
		"磁感应", "	ci2	gan3	ying4",
		"经不住", "	jing1	bu	zhu4",
		"窝囊废", "	wo1	nang1	fei4",
		"三毛猫", "	san1	mao2	mao1",
		"穿衣服", "	chuan1	yi1	fu",
		"小人儿", "	xiao3	ren2	er",
		"热轧钢", "	re4	zha2	gang1",
		"烘笼儿", "	hong1	long2	r",
		"小妹子", "	xiao3	mei4	zi3",
		"秒差距", "	miao3	cha1	ju4",
		"孢子囊", "	bao1	zi3	nang2",
		"露头角", "	lu4	tou2	jiao3",
		"干燥室", "	gan1	zao4	shi4",
		"杂和面", "	za2	huo	mian4",
		"农家子", "	nong2	jia1	zi3",
		"看家狗", "	kan1	jia1	gou3",
		"傍角儿", "	bang4	jue2	er2",
		"卷铺盖", "	juan3	pu1	gai4",
		"处女航", "	chu3	nv3	hang2",
		"江西腊", "	jiang1	xi1	la4",
		"校对机", "	jiao4	dui4	ji1",
		"干燥窑", "	gan1	zao4	yao2",
		"硬骨头", "	ying4	gu2	tou",
		"皮划艇", "	pi2	hua2	ting3",
		"麻纤维", "	ma1	xian1	wei2",
		"月收入", "	yue4	shou1	ru4",
		"福州市", "	fu2	zhou1	shi4",
		"爪哇国", "	zhao3	wa1	guo2",
		"口角炎", "	kou3	jue2	yan2",
		"手腕子", "	shou3	wan4	zi3",
		"四方台", "	si4	fang1	tai2",
		"应力值", "	ying4	li4	zhi2",
		"福泉市", "	fu2	quan2	shi4",
		"碾磙子", "	nian3	gun3	zi3",
		"瓦岗军", "	wa3	gang1	jun1",
		"不干净", "	bu4	gan1	jing4",
		"福清市", "	fu2	qing1	shi4",
		"找不到", "	zhao3	bu	dao4",
		"感应力", "	gan3	ying4	li4",
		"茄红素", "	qie2	hong2	su4",
		"吃馆子", "	chi1	guan3	zi3",
		"五苓散", "	wu3	ling2	san3",
		"包干制", "	bao1	gan1	zhi4",
		"赤松子", "	chi4	song1	zi3",
		"应景儿", "	ying4	jing3	r",
		"说得着", "	shuo1	de	zhao2",
		"蔡侯纸", "	cai4	hou4	zhi3",
		"管扳子", "	guan3	ban1	zi3",
		"私生子", "	si1	sheng1	zi3",
		"管乐器", "	guan3	yue4	qi4",
		"剪切机", "	jian3	qie1	ji1",
		"宜兴市", "	yi2	xing1	shi4",
		"尉迟恭", "	yu4	chi2	gong1",
		"放包袱", "	fang4	bao1	fu2",
		"有分寸", "	you3	fen1	cun",
		"软骨头", "	ruan3	gu2	tou",
		"敞开儿", "	chang3	kai1	r",
		"好事者", "	hao4	shi4	zhe3",
		"印子钱", "	yin4	zi3	qian2",
		"筋斗云", "	jin1	dou3	yun2",
		"冲压机", "	chong4	ya1	ji1",
		"斗六市", "	dou3	liu4	shi4",
		"漂流木", "	piao1	liu2	mu4",
		"半吊子", "	ban4	diao4	zi3",
		"催眠曲", "	cui1	mian2	qu3",
		"感应炉", "	gan3	ying4	lu2",
		"漂白剂", "	piao3	bai2	ji4",
		"吃干饭", "	chi1	gan1	fan4",
		"打长途", "	da3	chang2	tu2",
		"粘土岩", "	nian2	tu3	yan2",
		"无为县", "	wu2	wei2	xian4",
		"油炸鬼", "	you2	zha2	gui3",
		"妃子笑", "	fei1	zi3	xiao4",
		"牛头刨", "	niu2	tou2	bao4",
		"刹那间", "	cha4	na4	jian1",
		"水处理", "	shui3	chu3	li3",
		"子程序", "	zi3	cheng2	xu4",
		"哀伤地", "	ai1	shang1	de",
		"解痉剂", "	xie4	jing4	ji4",
		"烘干器", "	hong1	gan1	qi4",
		"散文诗", "	san3	wen2	shi1",
		"开拓者", "	kai1	tuo4	zhe3",
		"水磨沟", "	shui3	mo4	gou1",
		"穆棱市", "	mu4	ling2	shi4",
		"扫把星", "	sao4	ba3	xing1",
		"屎壳郎", "	shi3	ke	lang4",
		"戳得住", "	chuo1	de	zhu4",
		"间歇热", "	jian4	xie1	re4",
		"战斗部", "	zhan4	dou3	bu4",
		"刮削器", "	gua1	xiao1	qi4",
		"章子怡", "	zhang1	zi3	yi2",
		"闹别扭", "	nao4	bie4	niu3",
		"看门狗", "	kan1	men2	gou3",
		"干洗店", "	gan1	xi3	dian4",
		"角斗士", "	jue2	dou4	shi4",
		"煤斗车", "	mei2	dou3	che1",
		"子母钟", "	zi3	mu3	zhong1",
		"新兴区", "	xin1	xing1	qu1",
		"奏鸣曲", "	zou4	ming2	qu3",
		"高挑儿", "	gao1	tiao3	er2",
		"福鼎市", "	fu2	ding3	shi4",
		"钢琴曲", "	gang1	qin2	qu3",
		"复兴门", "	fu4	xing1	men2",
		"月氏人", "	yue4	zhi1	ren2",
		"三都县", "	san1	du1	xian4",
		"电子学", "	dian4	zi3	xue2",
		"子宫炎", "	zi3	gong1	yan2",
		"背带裙", "	bei1	dai4	qun2",
		"顾颉刚", "	gu4	xie2	gang1",
		"雪佛龙", "	xue3	fo2	long2",
		"笑脸儿", "	xiao4	lian3	r",
		"舍身崖", "	she4	shen1	ya2",
		"男人家", "	nan2	ren2	jia",
		"宅度假", "	zhai2	du4	jia4",
		"叫花子", "	jiao4	hua1	zi3",
		"倒胃口", "	dao3	wei4	kou3",
		"水饺儿", "	shui3	jiao3	r",
		"数来宝", "	shu3	lai2	bao3",
		"祭司长", "	ji4	si1	chang2",
		"数不清", "	shu3	bu4	qing1",
		"弹射出", "	tan2	she4	chu1",
		"区字框", "	qu1	zi4	kuang4",
		"长鼻目", "	chang2	bi2	mu4",
		"李娃传", "	li3	wa2	zhuan4",
		"所得税", "	suo3	de	shui4",
		"睡午觉", "	shui4	wu3	jiao4",
		"五虎将", "	wu3	hu3	jiang4",
		"看不中", "	kan4	bu	zhong1",
		"贱骨头", "	jian4	gu2	tou",
		"潭子乡", "	tan2	zi3	xiang1",
		"脚趾头", "	jiao3	zhi3	tou",
		"佛坪县", "	fo2	ping2	xian4",
		"考试卷", "	kao3	shi4	juan4",
		"大黄鱼", "	dai4	huang2	yu2",
		"民乐县", "	min2	yue4	xian4",
		"海参崴", "	hai3	shen1	wei1",
		"使兴奋", "	shi3	xing1	fen4",
		"姬松茸", "	ji1	song1	rong2",
		"正角儿", "	zheng4	jue2	er",
		"都察院", "	du1	cha2	yuan4",
		"钻井机", "	zuan4	jing3	ji1",
		"卖关子", "	mai4	guan1	zi3",
		"珲春市", "	hun2	chun1	shi4",
		"低转速", "	di1	zhuan4	su4",
		"槟榔屿", "	bing1	lang2	yu3",
		"柬埔寨", "	jian2	pu3	zhai4",
		"老朋友", "	lao3	peng2	you",
		"柳毅传", "	liu3	yi4	zhuan4",
		"佛冈县", "	fo2	gang1	xian4",
		"贾平凹", "	jia3	ping2	wa1",
		"香附子", "	xiang1	fu4	zi3",
		"脑卒中", "	nao3	cu4	zhong4",
		"果子酱", "	guo3	zi3	jiang4",
		"肺栓塞", "	fei4	shuan1	se4",
		"用不着", "	yong4	bu4	zhao2",
		"脚指甲", "	jiao3	zhi3	jia",
		"当回事", "	dang4	hui2	shi4",
		"用不了", "	yong4	bu4	liao3",
		"小瘪三", "	xiao3	bie1	san1",
		"影片儿", "	ying3	pian1	er",
		"小胡同", "	xiao3	hu2	tong4",
		"脚蹬子", "	jiao3	deng1	zi3",
		"家雀儿", "	jia1	qiao3	er2",
		"应试者", "	ying4	shi4	zhe3",
		"干燥管", "	gan1	zao4	guan3",
		"黑钻石", "	hei1	zuan4	shi2",
		"中微子", "	zhong4	wei1	zi3",
		"套口供", "	tao4	kou3	gong4",
		"亚平宁", "	ya4	ping2	ning4",
		"子洲县", "	zi3	zhou1	xian4",
		"不中意", "	bu4	zhong4	yi4",
		"二重奏", "	er4	chong2	zou4",
		"女傧相", "	nv3	bin1	xiang4",
		"中庶子", "	zhong1	shu4	zi3",
		"著作权", "	zhu4	zuo4	quan2",
		"崆峒区", "	kong1	tong2	qu1",
		"老家伙", "	lao3	jia1	huo",
		"管不着", "	guan3	bu	zhao2",
		"算不了", "	suan4	bu4	liao3",
		"桦甸市", "	hua4	dian4	shi4",
		"照片儿", "	zhao4	pian1	er",
		"硬着陆", "	ying4	zhuo2	lu4",
		"二重根", "	er4	chong2	gen1",
		"兴教寺", "	xing1	jiao4	si4",
		"校准器", "	jiao4	zhun3	qi4",
		"用得着", "	yong4	de	zhao2",
		"澎湖县", "	peng2	hu2	xian4",
		"中乐透", "	zhong4	le4	tou4",
		"行李卷", "	xing2	li3	juan4",
		"标识码", "	biao1	zhi4	ma3",
		"折杨柳", "	she2	yang2	liu3",
		"失身分", "	shi1	shen1	fen4",
		"总供给", "	zong3	gong1	ji3",
		"缝针迹", "	feng2	zhen1	ji4",
		"调频器", "	tiao2	pin2	qi4",
		"舟曲县", "	zhou1	qu3	xian4",
		"缝衣针", "	feng2	yi1	zhen1",
		"缅甸语", "	mian3	dian4	yu3",
		"接插件", "	jie1	cha1	jian4",
		"校准仪", "	jiao4	zhun3	yi2",
		"飞行家", "	fei1	hang2	jia",
		"片儿警", "	pian4	r	jing3",
		"繁峙县", "	fan2	shi4	xian4",
		"分权制", "	fen4	quan2	zhi4",
		"娃娃装", "	wa2	wa	zhuang1",
		"钻孔机", "	zuan4	kong3	ji1",
		"兴庆区", "	xing1	qing4	qu1",
		"标识符", "	biao1	zhi4	fu2",
		"变样儿", "	bian4	yang4	r",
		"缝合线", "	feng2	he2	xian4",
		"老来少", "	lao3	lai2	shao4",
		"兴化市", "	xing1	hua4	shi4",
		"兴和县", "	xing1	he2	xian4",
		"兴安盟", "	xing1	an1	meng2",
		"兴安县", "	xing1	an1	xian4",
		"狮子乡", "	shi1	zi3	xiang1",
		"大藏经", "	da4	zang4	jing1",
		"生闷气", "	sheng1	men1	qi4",
		"资兴市", "	zi1	xing1	shi4",
		"进给量", "	jin4	ji3	liang4",
		"咽喉痛", "	yan1	hou2	tong4",
		"调节剂", "	tiao2	jie2	ji4",
		"甚高频", "	shen4	gao1	pin2",
		"装糊涂", "	zhuang1	hu2	tu",
		"甲壳类", "	jia3	qiao4	lei4",
		"转载机", "	zhuan3	zai3	ji1",
		"柏林墙", "	bo2	lin2	qiang2",
		"听得懂", "	ting1	de	dong3",
		"听不见", "	ting1	bu	jian4",
		"延长器", "	yan2	chang2	qi4",
		"鸭绿江", "	ya1	lu4	jiang1",
		"知识面", "	zhi1	shi	mian4",
		"行为学", "	xing2	wei2	xue2",
		"知识性", "	zhi1	shi	xing4",
		"不相干", "	bu4	xiang1	gan1",
		"指定值", "	zhi3	ding4	zhi2",
		"天晓得", "	tian1	xiao3	de",
		"佳丽酿", "	jia1	li4	niang2",
		"黄葛树", "	huang2	ge3	shu4",
		"绿营兵", "	lu4	ying2	bing1",
		"总干事", "	zong3	gan4	shi",
		"江都市", "	jiang1	du1	shi4",
		"脑梗塞", "	nao3	geng3	se4",
		"伊甸园", "	yi1	dian4	yuan2",
		"沂蒙山", "	yi2	meng3	shan1",
		"宁都县", "	ning2	du1	xian4",
		"乱弹琴", "	luan4	tan2	qin2",
		"兴山区", "	xing1	shan1	qu1",
		"倒春寒", "	dao3	chun1	han2",
		"黏着力", "	nian2	zhuo2	li4",
		"黏着语", "	nian2	zhuo2	yu3",
		"前齿龈", "	qian2	chi3	yin2",
		"沧浪客", "	cang1	lang2	ke4",
		"藏经阁", "	zang4	jing1	ge2",
		"长草区", "	chang2	cao3	qu1",
		"酶反应", "	mei2	fan3	ying4",
		"炸油饼", "	zha2	you2	bing3",
		"相思曲", "	xiang1	si1	qu3",
		"江干区", "	jiang1	gan1	qu1",
		"应变仪", "	ying4	bian4	yi2",
		"洋漂族", "	yang2	piao1	zu2",
		"横筋斗", "	heng2	jin1	dou3",
		"内切圆", "	nei4	qie1	yuan2",
		"小王子", "	xiao3	wang2	zi3",
		"反应池", "	fan3	ying4	chi2",
		"横爬行", "	heng2	pa2	xing2",
		"华罗庚", "	hua4	luo2	geng1",
		"华兴会", "	hua2	xing1	hui4",
		"粘着力", "	zhan1	zhuo2	li4",
		"干鲜果", "	gan1	xian1	guo3",
		"粘胶液", "	nian2	jiao1	ye4",
		"李昌镐", "	li3	chang1	hao4",
		"的确良", "	di2	que4	liang2",
		"皇太子", "	huang2	tai4	zi3",
		"牡丹乡", "	mu3	dan	xiang1",
		"黏涎子", "	nian2	xian2	zi3",
		"四重奏", "	si4	chong2	zou4",
		"冠军杯", "	guan4	jun1	bei1",
		"龙门刨", "	long2	men2	bao4",
		"水仙子", "	shui3	xian1	zi3",
		"晒骆驼", "	shai4	luo4	tuo",
		"都江堰", "	du1	jiang1	yan4",
		"怪叔叔", "	guai4	shu1	shu",
		"说不了", "	shuo1	bu4	liao3",
		"说不着", "	shuo1	bu4	zhao2",
		"相思子", "	xiang1	si1	zi3",
		"曲周县", "	qu3	zhou1	xian4",
		"枪子儿", "	qiang1	zi3	er",
		"量子态", "	liang4	zi3	tai4",
		"乡人子", "	xiang1	ren2	zi3",
		"采血针", "	cai3	xie3	zhen1",
		"当间儿", "	dang1	jian4	er2",
		"逮捕证", "	dai4	bu3	zheng4",
		"量子数", "	liang4	zi3	shu4",
		"都庞岭", "	du1	pang2	ling3",
		"钌铞儿", "	liao4	diao4	er2",
		"测量值", "	ce4	liang2	zhi2",
		"重估后", "	chong2	gu1	hou4",
		"测量学", "	ce4	liang2	xue2",
		"大行星", "	da4	hang2	xing1",
		"重孙子", "	chong2	sun1	zi",
		"重孙女", "	chong2	sun1	nv3",
		"拉家常", "	la2	jia1	chang2",
		"剪应力", "	jian3	ying4	li4",
		"麻将牌", "	ma2	jiang4	pai2",
		"干燥瓶", "	gan1	zao4	ping2",
		"航行图", "	hang2	xing2	tu2",
		"空格键", "	kong4	ge2	jian4",
		"二人转", "	er4	ren2	zhuan4",
		"行家话", "	hang2	jia1	hua4",
		"粘性力", "	nian2	xing4	li4",
		"落埋怨", "	lao4	man2	yuan4",
		"嫡长子", "	di2	zhang3	zi3",
		"色达县", "	shai3	da2	xian4",
		"爪尖儿", "	zhua3	jian1	er",
		"定冠词", "	ding4	guan4	ci2",
		"种植土", "	zhong4	zhi2	tu3",
		"耳咽管", "	er3	yan1	guan3",
		"脊神经", "	ji3	shen2	jing1",
		"降魔杵", "	xiang2	mo2	chu3",
		"童子尿", "	tong2	zi3	niao4",
		"漂流者", "	piao1	liu2	zhe3",
		"干扰源", "	gan1	rao3	yuan2",
		"儿童片", "	er2	tong2	pian1",
		"相国寺", "	xiang4	guo2	si4",
		"烘干窑", "	hong1	gan1	yao2",
		"中子流", "	zhong1	zi3	liu2",
		"烘干室", "	hong1	gan1	shi4",
		"子宫颈", "	zi3	gong1	jing3",
		"给事中", "	ji3	shi4	zhong1",
		"夜行性", "	ye4	xing2	xing4",
		"着陆点", "	zhuo2	lu4	dian3",
		"对称美", "	dui4	chen4	mei3",
		"康有为", "	kang1	you3	wei2",
		"实际上", "	shi2	ji4	shang",
		"李重茂", "	li3	chong2	mao4",
		"反应慢", "	fan3	ying4	man4",
		"李公朴", "	li3	gong1	piao2",
		"行道树", "	hang2	dao4	shu4",
		"中子弹", "	zhong1	zi3	dan4",
		"朴槿惠", "	piao2	jin3	hui4",
		"中子数", "	zhong1	zi3	shu4",
		"泰兴市", "	tai4	xing1	shi4",
		"效应器", "	xiao4	ying4	qi4",
		"小家伙", "	xiao3	jia1	huo",
		"放暑假", "	fang4	shu3	jia4",
		"韩湘子", "	han2	xiang1	zi3",
		"栽种机", "	zai1	zhong4	ji1",
		"什邡市", "	shi2	fang1	shi4",
		"中大夫", "	zhong1	dai4	fu1",
		"脚指头", "	jiao3	zhi3	tou",
		"花朝节", "	hua1	zhao1	jie2",
		"纠结点", "	jiu1	jie1	dian3",
		"校验位", "	jiao4	yan4	wei4",
		"大将军", "	da4	jiang4	jun1",
		"曹不兴", "	cao2	bu4	xing1",
		"插杠子", "	cha1	gang4	zi",
		"光杆儿", "	guang1	gan3	er2",
		"这程子", "	zhe4	cheng2	zi3",
		"京片子", "	jing1	pian1	zi",
		"放寒假", "	fang4	han2	jia4",
		"赵子龙", "	zhao4	zi3	long2",
		"银行学", "	yin2	hang2	xue2",
		"管乐队", "	guan3	yue4	dui4",
		"校勘学", "	jiao4	kan1	xue2",
		"兴宁区", "	xing1	ning2	qu1",
		"东兴区", "	dong1	xing1	qu1",
		"照片子", "	zhao4	pian1	zi",
		"蚌山区", "	beng4	shan1	qu1",
		"指甲刀", "	zhi3	jia	dao1",
		"看守所", "	kan1	shou3	suo3",
		"还魂丹", "	huan2	hun2	dan1",
		"讲义气", "	jiang3	yi4	qi",
		"船夫曲", "	chuan2	fu1	qu3",
		"抗干扰", "	kang4	gan1	rao3",
		"出大差", "	chu1	da4	chai1",
		"串处理", "	chuan4	chu3	li3",
		"姑娘家", "	gu1	niang2	jia1",
		"串门子", "	chuan4	men2	zi3",
		"上钩儿", "	shang4	gou1	r",
		"蒙古国", "	meng3	gu3	guo2",
		"前处理", "	qian2	chu3	li3",
		"薄瑞光", "	bo2	rui4	guang1",
		"张掖市", "	zhang1	ye4	shi4",
		"够得着", "	gou4	de	zhao2",
		"西洋参", "	xi1	yang2	shen1",
		"元好问", "	yuan2	hao4	wen4",
		"少奶奶", "	shao4	nai3	nɑi",
		"应急灯", "	ying4	ji2	deng1",
		"干扰者", "	gan1	rao3	zhe3",
		"燕麦粥", "	yan1	mai4	zhou1",
		"无将牌", "	wu2	jiang4	pai2",
		"被没收", "	bei4	mo4	shou1",
		"钻石婚", "	zuan4	shi2	hun1",
		"系列片", "	xi4	lie4	pian1",
		"九华山", "	jiu3	hua4	shan1",
		"广安门", "	guang3	an1	men2",
		"未见得", "	wei4	jian4	de",
		"文冠果", "	wen2	guan4	guo3",
		"萧子显", "	xiao1	zi3	xian3",
		"原子尘", "	yuan2	zi3	chen2",
		"新都桥", "	xin1	du1	qiao2",
		"电子狗", "	dian4	zi3	gou3",
		"氧原子", "	yang3	yuan2	zi3",
		"爵士乐", "	jue2	shi4	yue4",
		"澄泥砚", "	deng4	ni2	yan4",
		"螺桨毂", "	luo2	jiang3	gu1",
		"回流泵", "	hui2	liu2	beng4",
		"少不了", "	shao4	bu4	liao3",
		"间接费", "	jian4	jie1	fei4",
		"测量器", "	ce4	liang2	qi4",
		"无穷尽", "	wu2	qiong2	jin4",
		"买东西", "	mai3	dong1	xi",
		"军乐团", "	jun1	yue4	tuan2",
		"蟹爪兰", "	xie4	zhua3	lan2",
		"元真子", "	yuan2	zhen1	zi3",
		"广安市", "	guang3	an1	shi4",
		"张柏芝", "	zhang1	bo2	zhi1",
		"多水分", "	duo1	shui3	fen4",
		"子弹箱", "	zi3	dan4	xiang1",
		"浪漫曲", "	lang4	man4	qu3",
		"蒙松雨", "	meng1	song1	yu3",
		"虞应龙", "	yu2	ying4	long2",
		"榴霰弹", "	liu2	xian4	dan4",
		"泌阳县", "	bi4	yang2	xian4",
		"嫌麻烦", "	xian2	ma2	fan",
		"乾安县", "	qian2	an1	xian4",
		"上边儿", "	shang4	bian	r",
		"够不着", "	gou4	bu4	zhao2",
		"子空间", "	zi3	kong1	jian1",
		"五行阵", "	wu3	hang2	zhen4",
		"负效应", "	fu4	xiao4	ying4",
		"转弯子", "	zhuan4	wan1	zi",
		"煎炸油", "	jian1	zha2	you2",
		"调制器", "	tiao2	zhi4	qi4",
		"看上去", "	kan4	shang	qu",
		"鼓囊囊", "	gu3	nang1	nɑng",
		"畹町市", "	wan3	ding1	shi4",
		"兴业县", "	xing1	ye4	xian4",
		"藏青色", "	zang4	qing1	se4",
		"蒙古包", "	meng3	gu3	bao1",
		"虎跑泉", "	hu3	pao2	quan2",
		"女强人", "	nv3	qiang3	ren2",
		"丽水市", "	li2	shui3	shi4",
		"大长今", "	da4	chang2	jin1",
		"摽劲儿", "	biao4	jin4	er",
		"五通神", "	wu3	tong4	shen2",
		"黄药子", "	huang2	yao4	zi3",
		"调皮鬼", "	tiao2	pi2	gui3",
		"短不了", "	duan3	bu4	liao3",
		"灾难片", "	zai1	nan4	pian4",
		"滑行道", "	hua2	hang2	dao4",
		"尹潽善", "	yin3	pu3	shan4",
		"背黑锅", "	bei1	hei1	guo1",
		"供应科", "	gong1	ying4	ke1",
		"变奏曲", "	bian4	zou4	qu3",
		"枕头套", "	zhen3	tou	tao4",
		"蔺相如", "	lin4	xiang4	ru2",
		"羊痒疫", "	yang2	yang3	yi4",
		"美差事", "	mei3	chai1	shi4",
		"孔丛子", "	kong3	cong2	zi3",
		"林家翘", "	lin2	jia1	qiao2",
		"科教片", "	ke1	jiao4	pian1",
		"小插曲", "	xiao3	cha1	qu3",
		"失忆症", "	shi1	yi4	zheng4",
		"血中毒", "	xue4	zhong4	du2",
		"真番郡", "	zhen1	pan1	jun4",
		"好朋友", "	hao3	peng2	you",
		"烫头发", "	tang4	tou2	fa",
		"罗唝曲", "	luo2	gong4	qu3",
		"电子束", "	dian4	zi3	shu4",
		"三只手", "	san1	zhi1	shou3",
		"灾难性", "	zai1	nan4	xing4",
		"载驳船", "	zai3	bo2	chuan2",
		"长安区", "	chang2	an1	qu1",
		"宝生佛", "	bao3	sheng1	fo2",
		"剪切板", "	jian3	qie1	ban3",
		"弦乐队", "	xian2	yue4	dui4",
		"红曲", "	hong2	qu3",
		"半折", "	ban4	she2",
		"仆从", "	pu2	cong2",
		"粘液", "	nian2	ye4",
		"碾子", "	nian3	zi3",
		"应付", "	ying4	fu4",
		"查下", "	cha2	xia4",
		"粗朴", "	cu1	piao2",
		"不省", "	bu4	xing3",
		"悲咽", "	bei1	yan1",
		"答应", "	da1	ying4",
		"灾煞", "	zai1	sha4",
		"伴乐", "	ban4	yue4",
		"令子", "	ling4	zi3",
		"猛子", "	meng3	zi3",
		"粘合", "	nian2	he2",
		"查勤", "	cha2	qin2",
		"粘糊", "	nian2	hu1",
		"粘米", "	nian2	mi3",
		"拗陷", "	ao4	xian4",
		"蒙族", "	meng3	zu2",
		"杆菌", "	gan3	jun1",
		"卜算", "	bu3	suan4",
		"福兴", "	fu2	xing1",
		"空儿", "	kong4	er2",
		"干贝", "	gan1	bei4",
		"咽峡", "	yan1	xia2",
		"罗刹", "	luo2	cha4",
		"难属", "	nan4	shu3",
		"精子", "	jing1	zi3",
		"答讪", "	da1	shan4",
		"别别", "	bie4	bie4",
		"流尽", "	liu2	jin4",
		"绵薄", "	mian2	bo2",
		"糊弄", "	hu4	nong4",
		"罗罗", "	luo1	luo1",
		"原曲", "	yuan2	qu3",
		"案卷", "	an4	juan4",
		"拶指", "	zan3	zhi3",
		"梵刹", "	fan4	cha4",
		"干嚎", "	gan1	hao2",
		"应和", "	ying4	he4",
		"应力", "	ying4	li4",
		"折头", "	zhe2	tou",
		"笔供", "	bi3	gong4",
		"嗔喝", "	chen1	he4",
		"单于", "	chan2	yu2",
		"缜发", "	zhen3	fa4",
		"应得", "	ying1	de",
		"指头", "	zhi3	tou",
		"呼应", "	hu1	ying4",
		"嗜好", "	shi4	hao4",
		"累累", "	lei3	lei3",
		"人为", "	ren2	wei2",
		"懮虑", "	you1	lu:4",
		"咽喉", "	yan1	hou2",
		"排车", "	pai3	che1",
		"梵呗", "	fan4	bai4",
		"比兴", "	bi3	xing1",
		"折煞", "	she2	sha4",
		"网吧", "	wang3	ba1",
		"排难", "	pai2	nan4",
		"拾芥", "	shi2	jie4",
		"蝤蛑", "	you2	mou2",
		"剥脱", "	bao1	tuo1",
		"哽咽", "	geng3	ye4",
		"累进", "	lei3	jin4",
		"指甲", "	zhi3	jia",
		"折耗", "	she2	hao4",
		"绵子", "	mian2	zi3",
		"干菜", "	gan1	cai4",
		"抽咽", "	chou1	ye4",
		"攮子", "	nang3	zi3",
		"宁子", "	ning2	zi3",
		"一通", "	yi1	tong4",
		"拗劲", "	niu4	jin4",
		"抡才", "	lun2	cai2",
		"慰藉", "	wei4	jie4",
		"拖累", "	tuo1	lei3",
		"难友", "	nan4	you3",
		"园子", "	yuan2	zi3",
		"元子", "	yuan2	zi3",
		"一天", "	yi4	tian1",
		"论处", "	lun4	chu3",
		"查察", "	cha2	cha2",
		"鱼漂", "	yu2	piao1",
		"咽炎", "	yan1	yan2",
		"插接", "	cha1	jie1",
		"粘土", "	nian2	tu3",
		"粘度", "	nian2	du4",
		"所为", "	suo3	wei2",
		"嘉荫", "	jia1	yin4",
		"憎恶", "	zeng1	wu4",
		"哪边", "	na3	bian",
		"缝合", "	feng2	he2",
		"有分", "	you3	fen4",
		"折箩", "	zhe1	luo2",
		"神佛", "	shen2	fo2",
		"闭卷", "	bi4	juan4",
		"懂得", "	dong3	de",
		"论著", "	lun4	zhu4",
		"查数", "	cha2	shu4",
		"应急", "	ying4	ji2",
		"干草", "	gan1	cao3",
		"榛子", "	zhen1	zi3",
		"玉琢", "	yu4	zhuo2",
		"磨削", "	mo2	xiao1",
		"查查", "	cha2	cha2",
		"参错", "	cen1	cuo4",
		"策应", "	ce4	ying4",
		"论难", "	lun4	nan4",
		"栽倒", "	zai1	dao3",
		"磨坊", "	mo4	fang2",
		"捻子", "	nian3	zi3",
		"边子", "	bian1	zi3",
		"吴兴", "	wu2	xing1",
		"亹亹", "	wei3	wei3",
		"排叉", "	pai2	cha4",
		"藏历", "	zang4	li4",
		"团子", "	tuan2	zi3",
		"啴啴", "	tan1	tan1",
		"杠夫", "	gang4	fu1",
		"严查", "	yan2	cha2",
		"交恶", "	jiao1	wu4",
		"咽头", "	yan1	tou2",
		"采血", "	cai3	xie3",
		"漏尽", "	lou4	jin4",
		"瀑流", "	bao4	liu2",
		"杠子", "	gang4	zi",
		"篇子", "	pian1	zi3",
		"筛子", "	shai1	zi3",
		"石头", "	shi2	tou",
		"拢子", "	long3	zi3",
		"藏戏", "	zang4	xi4",
		"门斗", "	men2	dou3",
		"石作", "	shi2	zuo1",
		"以还", "	yi3	huan2",
		"藏医", "	zang4	yi1",
		"应物", "	ying4	wu4",
		"拐子", "	guai3	zi3",
		"掺合", "	chan1	he",
		"大卷", "	da4	juan4",
		"嚼子", "	jiao2	zi3",
		"喽喽", "	lou	lou",
		"干旱", "	gan1	han4",
		"半宿", "	ban4	xiu3",
		"臧否", "	zang1	pi3",
		"攒集", "	cuan2	ji2",
		"扳倒", "	ban1	dao3",
		"桑耶", "	sang1	ye1",
		"宝刹", "	bao3	cha4",
		"碇泊", "	ding4	bo2",
		"繁峙", "	fan2	shi4",
		"呵欠", "	he1	qian4",
		"呢绒", "	ni2	rong2",
		"存查", "	cun2	cha2",
		"恶相", "	e4	xiang4",
		"愚氓", "	yu2	meng2",
		"刺参", "	ci4	shen1",
		"干燥", "	gan1	zao4",
		"晕高", "	yun4	gao1",
		"云为", "	yun2	wei2",
		"摧折", "	cui1	she2",
		"已甚", "	yi3	shen4",
		"乐感", "	yue4	gan3",
		"被难", "	bei4	nan4",
		"乐池", "	yue4	chi2",
		"哗然", "	hua2	ran2",
		"京都", "	jing1	du1",
		"碑拓", "	bei1	tuo4",
		"镚子", "	beng4	zi3",
		"应募", "	ying4	mu4",
		"仿似", "	fang3	si4",
		"从子", "	cong2	zi3",
		"端的", "	duan1	di4",
		"龙子", "	long2	zi3",
		"折本", "	she2	ben3",
		"骠骑", "	piao4	qi2",
		"应举", "	ying4	ju3",
		"能子", "	neng2	zi3",
		"缝补", "	feng2	bu3",
		"攒聚", "	cuan2	ju4",
		"硙硙", "	wei4	wei4",
		"遗少", "	yi2	shao4",
		"舍下", "	she4	xia4",
		"才分", "	cai2	fen4",
		"漂儿", "	piao1	er2",
		"刺痒", "	ci4	yang2",
		"绷子", "	beng1	zi3",
		"磅礴", "	pang2	bo2",
		"拌和", "	ban4	huo4",
		"嚼蜡", "	jiao2	la4",
		"拚贴", "	pin1	tie1",
		"闷雷", "	men1	lei2",
		"查报", "	cha2	bao4",
		"拖斗", "	tuo1	dou3",
		"绫子", "	ling2	zi3",
		"扒手", "	pa2	shou3",
		"吸着", "	xi1	zhuo2",
		"有处", "	you3	chu3",
		"噱头", "	xue2	tou",
		"才尽", "	cai2	jin4",
		"难胞", "	nan4	bao1",
		"掺杂", "	chan1	za2",
		"产子", "	chan3	zi3",
		"牛舍", "	niu2	she4",
		"五更", "	wu3	geng1",
		"一着", "	yi1	zhao1",
		"算子", "	suan4	zi3",
		"一觉", "	yi1	jiao4",
		"不调", "	bu4	tiao2",
		"扎囊", "	za1	nang2",
		"桔槔", "	jie2	gao1",
		"干酪", "	gan1	lao4",
		"不甚", "	bu4	shen4",
		"蒙医", "	meng3	yi1",
		"乾安", "	qian2	an1",
		"营子", "	ying2	zi3",
		"干透", "	gan1	tou4",
		"干货", "	gan1	huo4",
		"缨子", "	ying1	zi3",
		"拜倒", "	bai4	dao3",
		"粘聚", "	nian2	ju4",
		"答卷", "	da2	juan4",
		"哪些", "	nei3	xie1",
		"粘膜", "	nian2	mo2",
		"壅塞", "	yong1	se4",
		"筋斗", "	jin1	dou3",
		"郢都", "	ying3	du1",
		"鱼卷", "	yu2	juan4",
		"一了", "	yi1	liao3",
		"梗塞", "	geng3	se4",
		"仔肩", "	zi1	jian1",
		"一卷", "	yi1	juan4",
		"楦子", "	xuan4	zi3",
		"攒盒", "	cuan2	he2",
		"龙脊", "	long2	ji3",
		"灵子", "	ling2	zi3",
		"吓倒", "	xia4	dao3",
		"灶头", "	zao4	tou",
		"干杯", "	gan1	bei1",
		"绝倒", "	jue2	dao3",
		"姘头", "	pin1	tou",
		"粘附", "	nian2	fu4",
		"披卷", "	pi1	juan4",
		"变子", "	bian4	zi3",
		"恫吓", "	dong4	he4",
		"灶火", "	zao4	huo1",
		"碑帖", "	bei1	tie4",
		"手把", "	shou3	ba4",
		"丧服", "	sang1	fu2",
		"管子", "	guan3	zi3",
		"不更", "	bu4	geng1",
		"牤子", "	mang1	zi3",
		"砚台", "	yan4	tai1",
		"缏子", "	bian4	zi3",
		"条几", "	tiao2	ji1",
		"棒喝", "	bang4	he4",
		"秧子", "	yang1	zi3",
		"卷发", "	juan3	fa4",
		"丧仪", "	sang1	yi2",
		"齿数", "	chi3	shu3",
		"干果", "	gan1	guo3",
		"草舍", "	cao3	she4",
		"休假", "	xiu1	jia4",
		"仙子", "	xian1	zi3",
		"干尸", "	gan1	shi1",
		"嗳酸", "	ai3	suan1",
		"纤夫", "	qian4	fu1",
		"难舍", "	nan2	she4",
		"子道", "	zi3	dao4",
		"干爹", "	gan1	die1",
		"矸子", "	gan1	zi3",
		"丹佛", "	dan1	fo2",
		"茶几", "	cha2	ji1",
		"颉利", "	xie2	li4",
		"茬子", "	cha2	zi3",
		"茅厕", "	mao2	si",
		"主仆", "	zhu3	pu2",
		"芍陂", "	que4	pi2",
		"乐谱", "	yue4	pu3",
		"茄子", "	qie2	zi",
		"乐府", "	yue4	fu3",
		"簪子", "	zan1	zi3",
		"倒塌", "	dao3	ta1",
		"芋头", "	yu4	tou",
		"花蛤", "	hua1	ge2",
		"怎得", "	zen3	de",
		"贼子", "	zei2	zi3",
		"心曲", "	xin1	qu3",
		"花都", "	hua1	du1",
		"心子", "	xin1	zi3",
		"倒地", "	dao3	di4",
		"石勒", "	shi2	le4",
		"信子", "	xin4	zi3",
		"芯子", "	xin4	zi3",
		"乐器", "	yue4	qi4",
		"碟子", "	die2	zi3",
		"丸子", "	wan2	zi3",
		"干儿", "	gan1	er2",
		"倒伏", "	dao3	fu2",
		"薄弱", "	bo2	ruo4",
		"着哩", "	zhe	li3",
		"幸得", "	xing4	de",
		"落得", "	luo4	de",
		"茄科", "	qie2	ke1",
		"乙炔", "	yi3	que1",
		"看似", "	kan4	si4",
		"乜嘢", "	nie4	ye3",
		"看押", "	kan1	ya1",
		"看护", "	kan1	hu4",
		"倒戈", "	dao3	ge1",
		"花呢", "	hua1	ni2",
		"荀子", "	xun2	zi3",
		"砟子", "	zha3	zi3",
		"倒序", "	dao3	xu4",
		"渣子", "	zha1	zi3",
		"破处", "	po4	chu3",
		"眸子", "	mou2	zi3",
		"乐曲", "	yue4	qu3",
		"些子", "	xie1	zi3",
		"蟹子", "	xie4	zi3",
		"干涸", "	gan1	he2",
		"干洗", "	gan1	xi3",
		"干枯", "	gan1	ku1",
		"乐律", "	yue4	lv4",
		"仔仔", "	zi3	zai3",
		"来得", "	lai2	de",
		"稚子", "	zhi4	zi3",
		"的确", "	di2	que4",
		"秦都", "	qin2	du1",
		"私处", "	si1	chu3",
		"休得", "	xiu1	de",
		"寓舍", "	yu4	she4",
		"发卡", "	fa4	qia3",
		"落子", "	lao4	zi3",
		"羞恶", "	xiu1	wu4",
		"发帖", "	fa1	tie3",
		"吁求", "	yu4	qiu2",
		"萎靡", "	wei3	mi3",
		"与人", "	yu2	ren2",
		"菲姬", "	fei3	ji1",
		"发难", "	fa1	nan4",
		"白佛", "	bai2	fo2",
		"于思", "	yu2	sai1",
		"落下", "	la4	xia4",
		"白子", "	bai2	zi3",
		"槟子", "	bin1	zi3",
		"乐迷", "	yue4	mi2",
		"尽力", "	jin4	li4",
		"尽意", "	jin4	yi4",
		"倒毙", "	dao3	bi4",
		"磨烦", "	mo4	fan2",
		"的士", "	di2	shi4",
		"白鹄", "	bai2	hu2",
		"范蠡", "	fan4	li3",
		"瞽阇", "	gu3	she2",
		"云子", "	yun2	zi3",
		"杂处", "	za2	chu3",
		"扎紧", "	za1	jin3",
		"苦难", "	ku3	nan4",
		"苦处", "	ku3	chu3",
		"崽子", "	zai3	zi3",
		"载负", "	zai3	fu4",
		"乳晕", "	ru3	yun4",
		"砣子", "	tuo2	zi3",
		"砌末", "	qie4	mo4",
		"花子", "	hua1	zi3",
		"砂子", "	sha1	zi3",
		"白发", "	bai2	fa4",
		"新曲", "	xin1	qu3",
		"草耙", "	cao3	pa2",
		"倒把", "	dao3	ba3",
		"极为", "	ji2	wei2",
		"丫杈", "	ya1	cha4",
		"丫头", "	ya1	tou",
		"萎叶", "	wei3	ye4",
		"熨帖", "	yu4	tie1",
		"与闻", "	yu4	wen2",
		"菹醢", "	zu1	hai3",
		"科斗", "	ke1	dou3",
		"腕子", "	wan4	zi3",
		"雪子", "	xue3	zi3",
		"信佛", "	xin4	fo2",
		"逾分", "	yu2	fen4",
		"许处", "	xu3	chu3",
		"釉子", "	you4	zi3",
		"番禺", "	pan1	yu2",
		"只此", "	zhi1	ci3",
		"桠杈", "	ya1	cha4",
		"疏勒", "	shu1	le4",
		"不菲", "	bu4	fei3",
		"与会", "	yu4	hui4",
		"不要", "	bu2	yao4",
		"余处", "	yu2	chu3",
		"橱子", "	chu2	zi3",
		"楔子", "	xie1	zi3",
		"积累", "	ji1	lei3",
		"果子", "	guo3	zi3",
		"枚卜", "	mei2	bu3",
		"例假", "	li4	jia4",
		"独处", "	du2	chu3",
		"脊背", "	ji3	bei4",
		"脊髓", "	ji3	sui3",
		"压载", "	ya1	zai3",
		"压蔓", "	ya1	wan4",
		"蕃庑", "	fan2	wu2",
		"煞气", "	sha4	qi4",
		"无处", "	wu2	chu3",
		"油子", "	you2	zi3",
		"痱子", "	fei4	zi3",
		"梅子", "	mei2	zi3",
		"瘤子", "	liu2	zi3",
		"瓤儿", "	rang2	r",
		"窥伺", "	kui1	si4",
		"窑子", "	yao2	zi3",
		"枣子", "	zao3	zi3",
		"幽咽", "	you1	ye4",
		"止咳", "	zhi3	ke2",
		"瓜子", "	gua1	zi3",
		"臊子", "	sao4	zi3",
		"舀子", "	yao3	zi3",
		"质的", "	zhi4	di4",
		"征辟", "	zhi3	bi4",
		"不遂", "	bu4	sui2",
		"直得", "	zhi2	de",
		"疟子", "	yao4	zi3",
		"瘸子", "	que2	zi3",
		"瘊子", "	hou2	zi3",
		"癖好", "	pi3	hao4",
		"哲子", "	zhe2	zi3",
		"稻子", "	dao4	zi3",
		"倒爷", "	dao3	ye2",
		"折翼", "	she2	yi4",
		"干衣", "	gan1	yi1",
		"瘫子", "	tan1	zi3",
		"落泊", "	luo4	bo2",
		"蔫儿", "	nian1	r",
		"下得", "	xia4	de",
		"茓子", "	xue2	zi3",
		"腰子", "	yao1	zi3",
		"狍子", "	pao2	zi3",
		"过得", "	guo4	de",
		"荤粥", "	xun1	yu4",
		"武侯", "	wu3	hou4",
		"犹子", "	you2	zi3",
		"支子", "	zhi1	zi3",
		"只字", "	zhi1	zi4",
		"之子", "	zhi1	zi3",
		"葛优", "	ge3	you1",
		"竿子", "	gan1	zi3",
		"脱发", "	tuo1	fa4",
		"牢子", "	lao2	zi3",
		"笆斗", "	ba1	dou3",
		"使得", "	shi3	de",
		"下子", "	xia4	zi3",
		"答白", "	da1	bai2",
		"夏子", "	xia4	zi3",
		"历尽", "	li4	jin4",
		"牙龈", "	ya2	yin2",
		"历数", "	li4	shu3",
		"有得", "	you3	de",
		"由得", "	you2	de",
		"踅子", "	xue2	zi3",
		"不住", "	bu2	zhu4",
		"学佛", "	xue2	fo2",
		"不到", "	bu2	dao4",
		"栀子", "	zhi1	zi3",
		"作曲", "	zuo4	qu3",
		"下都", "	xia4	du1",
		"柏悦", "	bo2	yue4",
		"热帖", "	re4	tie3",
		"押头", "	ya1	tou",
		"死难", "	si3	nan4",
		"脊肋", "	ji3	lei4",
		"脊柱", "	ji3	zhu4",
		"为期", "	wei2	qi1",
		"乌什", "	wu1	shi2",
		"值得", "	zhi2	de",
		"薄厚", "	bo2	hou4",
		"作死", "	zuo1	si3",
		"笔杆", "	bi3	gan3",
		"脊索", "	ji3	suo3",
		"无为", "	wu2	wei2",
		"柏林", "	bo2	lin2",
		"无尽", "	wu2	jin4",
		"芜累", "	wu2	lei3",
		"西乐", "	xi1	yue4",
		"殷都", "	yin1	du1",
		"无干", "	wu2	gan1",
		"侉子", "	kua3	zi3",
		"主薄", "	zhu3	bu4",
		"爆肚", "	bao4	du3",
		"李适", "	li3	kuo4",
		"模板", "	mu2	ban3",
		"抹脸", "	ma1	lian3",
		"粪耙", "	fen4	pa2",
		"子书", "	zi3	shu1",
		"一般", "	yi4	ban1",
		"薄酒", "	bo2	jiu3",
		"胳臂", "	ge1	bei",
		"处罚", "	chu3	fa2",
		"佛门", "	fo2	men2",
		"栽子", "	zai1	zi3",
		"处死", "	chu3	si3",
		"美的", "	mei3	di2",
		"比才", "	bi4	cai2",
		"假日", "	jia4	ri4",
		"佛龛", "	fo2	kan1",
		"一干", "	yi1	gan1",
		"混子", "	hun4	zi3",
		"为伍", "	wei2	wu3",
		"薄海", "	bo2	hai3",
		"饮子", "	yin3	zi3",
		"罗勒", "	luo2	le4",
		"围子", "	wei2	zi3",
		"处于", "	chu3	yu2",
		"耗子", "	hao4	zi3",
		"没药", "	mo4	yao4",
		"泊车", "	bo2	che1",
		"绿林", "	lu4	lin2",
		"没落", "	mo4	luo4",
		"翅子", "	chi4	zi3",
		"处女", "	chu3	nv3",
		"木杆", "	mu4	gan3",
		"浸没", "	jin4	mo4",
		"荫庇", "	yin4	bi4",
		"海子", "	hai3	zi3",
		"栅子", "	zha4	zi3",
		"柞栎", "	zuo4	li4",
		"子惠", "	zi3	hui4",
		"自好", "	zi4	hao4",
		"组分", "	zu3	fen4",
		"什器", "	shi2	qi4",
		"自处", "	zi4	chu3",
		"一舍", "	yi1	she4",
		"问卜", "	wen4	bu3",
		"系留", "	ji4	liu2",
		"滚子", "	gun3	zi3",
		"子月", "	zi3	yue4",
		"假期", "	jia4	qi1",
		"淹没", "	yan1	mo4",
		"毛肚", "	mao2	du3",
		"美发", "	mei3	fa4",
		"佛陀", "	fo2	tuo2",
		"炸鱼", "	zha2	yu2",
		"炸鸡", "	zha2	ji1",
		"人儿", "	ren2	er2",
		"鹞子", "	yao4	zi3",
		"微子", "	wei1	zi3",
		"泊位", "	bo2	wei4",
		"何干", "	he2	gan1",
		"卖解", "	mai4	xie4",
		"约塔", "	yao1	ta3",
		"泡子", "	pao1	zi3",
		"脂麻", "	zhi1	ma",
		"似雪", "	si4	xue3",
		"胞子", "	bao1	zi3",
		"稠糊", "	chou2	hu1",
		"应答", "	ying4	da2",
		"垸子", "	yuan4	zi3",
		"背着", "	bei1	zhe",
		"出倒", "	chu1	dao3",
		"乱子", "	luan4	zi3",
		"偏得", "	pian1	de",
		"一宿", "	yi1	xiu3",
		"应敌", "	ying4	di2",
		"绷瓷", "	beng4	ci2",
		"秦桧", "	qin2	hui4",
		"任人", "	ren4	ren2",
		"干脆", "	gan1	cui4",
		"御苑", "	yu4	yuan4",
		"编曲", "	bian1	qu3",
		"出塞", "	chu1	sai4",
		"偏曲", "	pian1	qu3",
		"干瘪", "	gan1	bie3",
		"处士", "	chu3	shi4",
		"伺候", "	ci4	hou",
		"一带", "	yi2	dai4",
		"毛厕", "	mao2	si",
		"絮叨", "	xu4	dao2",
		"河叉", "	he2	cha4",
		"泡吧", "	pao4	ba1",
		"续假", "	xu4	jia4",
		"假子", "	jia3	zi3",
		"未卜", "	wei4	bu3",
		"苇子", "	wei3	zi3",
		"一化", "	yi1	hua1",
		"蝎子", "	xie1	zi3",
		"佛家", "	fo2	jia1",
		"圩子", "	wei2	zi3",
		"佛学", "	fo2	xue2",
		"沙拉", "	sha1	la4",
		"作揖", "	zuo1	yi1",
		"臆度", "	yi4	duo2",
		"催吐", "	cui1	tu4",
		"藉以", "	jie4	yi3",
		"五斗", "	wu3	dou3",
		"帷子", "	wei2	zi3",
		"子男", "	zi3	nan2",
		"处理", "	chu3	li3",
		"人子", "	ren2	zi3",
		"罹难", "	li2	nan4",
		"一匙", "	yi1	chi2",
		"缉查", "	ji1	cha2",
		"柚木", "	you2	mu4",
		"沤肥", "	ou4	fei2",
		"直发", "	zhi2	fa4",
		"活佛", "	huo2	fo2",
		"梭子", "	suo1	zi3",
		"佛号", "	fo2	hao4",
		"雁子", "	yan4	zi3",
		"子金", "	zi3	jin1",
		"烟子", "	yan1	zi3",
		"檐子", "	yan2	zi3",
		"蚂蚱", "	ma4	zha4",
		"一到", "	yi2	dao4",
		"累计", "	lei3	ji4",
		"活似", "	huo2	si4",
		"兰若", "	lan2	re3",
		"眼子", "	yan3	zi3",
		"尽速", "	jin4	su4",
		"子衿", "	zi3	jin1",
		"肋骨", "	lei4	gu3",
		"一撮", "	yi1	zuo3",
		"佚失", "	yi4	shi1",
		"议处", "	yi4	chu3",
		"文曲", "	wen2	qu3",
		"蜗杆", "	wo1	gan3",
		"介子", "	jie4	zi3",
		"淫靡", "	yin2	mi3",
		"企划", "	qi3	hua2",
		"子侄", "	zi3	zhi2",
		"薄待", "	bo2	dai4",
		"束发", "	shu4	fa4",
		"累积", "	lei3	ji1",
		"俟候", "	si4	hou4",
		"磨盘", "	mo4	pan2",
		"般乐", "	pan2	le4",
		"乐户", "	yue4	hu4",
		"干涩", "	gan1	se4",
		"磨叨", "	mo4	dao1",
		"楼子", "	lou2	zi3",
		"乐舞", "	yue4	wu3",
		"干渴", "	gan1	ke3",
		"乐歌", "	yue4	ge1",
		"华发", "	hua2	fa4",
		"莞尔", "	wan3	er3",
		"祝发", "	zhu4	fa4",
		"舍弟", "	she4	di4",
		"东阿", "	dong1	e1",
		"杯葛", "	bei1	ge3",
		"李悝", "	li3	kui1",
		"旧都", "	jiu4	du1",
		"尽责", "	jin4	ze2",
		"盘曲", "	pan2	qu3",
		"倒替", "	dao3	ti4",
		"磨难", "	mo2	nan4",
		"舍利", "	she4	li4",
		"菌子", "	jun4	zi",
		"磨碎", "	mo4	sui4",
		"活泛", "	huo2	fa2",
		"一撇", "	yi1	pie3",
		"虾子", "	xia1	zi3",
		"子都", "	zi3	dou1",
		"淡泊", "	dan4	bo2",
		"仆人", "	pu2	ren2",
		"蛤蚧", "	ge2	jie4",
		"淡薄", "	dan4	bo2",
		"蛙鞋", "	wa1	xie2",
		"结壳", "	jie1	ke2",
		"结子", "	jie2	zi3",
		"令狐", "	ling2	hu2",
		"木头", "	mu4	tou",
		"查核", "	cha2	he2",
		"蚶子", "	han1	zi3",
		"何处", "	he2	chu3",
		"什叶", "	shi2	ye4",
		"亏得", "	kui1	de",
		"虺蜥", "	hui3	xi1",
		"译著", "	yi4	zhu4",
		"佛书", "	fo2	shu1",
		"查缉", "	cha2	ji1",
		"屋舍", "	wu1	she4",
		"老姥", "	lao3	mu3",
		"染发", "	ran3	fa4",
		"柔佛", "	rou2	fo2",
		"分子", "	fen4	zi3",
		"结发", "	jie2	fa4",
		"子畜", "	zi3	chu4",
		"号子", "	hao4	zi3",
		"以为", "	yi3	wei2",
		"济南", "	ji3	nan2",
		"渡假", "	du4	jia4",
		"毛发", "	mao2	fa4",
		"背逆", "	bei1	ni4",
		"假发", "	jia3	fa4",
		"背负", "	bei1	fu4",
		"毫发", "	hao2	fa4",
		"结巴", "	jie1	ba1",
		"泰勒", "	tai4	le4",
		"背脊", "	bei4	ji3",
		"子口", "	zi3	kou3",
		"闻得", "	wen2	de",
		"澹泊", "	dan4	bo2",
		"结扎", "	jie2	za1",
		"测度", "	ce4	duo2",
		"给事", "	ji3	shi4",
		"纳什", "	na4	shi2",
		"纽子", "	niu3	zi3",
		"绦子", "	tao1	zi3",
		"摇把", "	yao2	ba4",
		"纰缪", "	pi1	miu4",
		"饮马", "	yin4	ma3",
		"兀鹫", "	wu1	jiu4",
		"肉脯", "	rou4	fu3",
		"湮没", "	yan1	mo4",
		"沦没", "	lun2	mo4",
		"稍息", "	shao4	xi1",
		"好高", "	hao4	gao1",
		"没顶", "	mo4	ding3",
		"干挠", "	gan1	nao2",
		"犁靬", "	li2	jian1",
		"缝衣", "	feng2	yi1",
		"封子", "	feng1	zi3",
		"蜂子", "	feng1	zi3",
		"市担", "	shi4	dan4",
		"只眼", "	zhi1	yan3",
		"大兴", "	da4	xing1",
		"分出", "	fen4	chu1",
		"干支", "	gan1	zhi1",
		"干扰", "	gan1	rao3",
		"飞掠", "	fei1	lue3",
		"间隔", "	jian4	ge2",
		"球差", "	qiu2	cha1",
		"吠舍", "	fei4	she4",
		"九难", "	jiu3	nan4",
		"非为", "	fei1	wei2",
		"只在", "	zhi1	zai4",
		"干休", "	gan1	xiu1",
		"帮子", "	bang1	zi3",
		"直指", "	zhi2	zhi3",
		"致知", "	zhi4	zhi1",
		"王子", "	wang2	zi3",
		"阏氏", "	yan1	zhi1",
		"犂靬", "	li2	jian1",
		"班什", "	ban1	shi2",
		"发还", "	fa1	huan2",
		"绢子", "	juan4	zi3",
		"由头", "	you2	tou",
		"新干", "	xin1	gan1",
		"发蒙", "	fa1	meng1",
		"卷叶", "	juan4	ye4",
		"甚于", "	shen4	yu2",
		"枯干", "	ku1	gan1",
		"庚子", "	geng1	zi3",
		"神怡", "	shen1	yi2",
		"发兴", "	fa1	xing1",
		"只道", "	zhi1	dao4",
		"净得", "	jing4	de",
		"至为", "	zhi4	wei2",
		"干涉", "	gan1	she4",
		"究诘", "	jiu1	jie2",
		"分划", "	fen1	hua2",
		"斤斗", "	jin1	dou3",
		"猵狙", "	pian4	ju1",
		"分值", "	fen4	zhi2",
		"猜度", "	cai1	duo2",
		"锋镝", "	feng1	di2",
		"分处", "	fen1	chu3",
		"狗血", "	gou3	xie3",
		"铺首", "	pu1	shou3",
		"弥缝", "	mi2	feng2",
		"甚么", "	shen4	me",
		"弹纠", "	tan2	jiu1",
		"散人", "	san3	ren2",
		"磈磊", "	kui3	lei3",
		"般游", "	pan2	you2",
		"塞外", "	sai4	wai4",
		"形似", "	xing2	si4",
		"檃栝", "	yin3	kuo4",
		"窥度", "	kui1	duo2",
		"定都", "	ding4	du1",
		"弹球", "	tan2	qiu2",
		"档子", "	dang4	zi3",
		"舟曲", "	zhou1	qu3",
		"吊子", "	diao4	zi3",
		"定子", "	ding4	zi3",
		"顶子", "	ding3	zi3",
		"款曲", "	kuan3	qu3",
		"丁子", "	ding1	zi3",
		"锭子", "	ding4	zi3",
		"弹花", "	tan2	hua1",
		"三倒", "	san1	dao3",
		"略为", "	lue4	wei2",
		"坑子", "	keng1	zi3",
		"别扭", "	bie4	niu3",
		"当机", "	dang4	ji1",
		"三舍", "	san1	she4",
		"弹琴", "	tan2	qin2",
		"不兴", "	bu4	xing1",
		"仓卒", "	cang1	cu4",
		"番茄", "	fan1	qie2",
		"兴替", "	xing1	ti4",
		"会稽", "	kuai4	ji1",
		"散话", "	san3	hua4",
		"招子", "	zhao1	zi3",
		"卜占", "	bu3	zhan1",
		"弹斥", "	tan2	chi4",
		"垫子", "	dian4	zi3",
		"坠子", "	zhui4	zi3",
		"弹指", "	tan2	zhi3",
		"罩子", "	zhao4	zi3",
		"白术", "	bai2	zhu2",
		"弹射", "	tan2	she4",
		"斗车", "	dou3	che1",
		"卜宅", "	bu3	zhai2",
		"弹奏", "	tan2	zou4",
		"色子", "	shai3	zi3",
		"折到", "	she2	dao4",
		"斗酒", "	dou3	jiu3",
		"弹回", "	tan2	hui2",
		"折过", "	zhe1	guo4",
		"洞子", "	dong4	zi3",
		"发丧", "	fa1	sang1",
		"申曲", "	shen1	qu3",
		"不当", "	bu4	dang4",
		"断喝", "	duan4	he4",
		"棱子", "	leng2	zi3",
		"劲旅", "	jing4	lv3",
		"倒回", "	dao3	hui2",
		"圆子", "	yuan2	zi3",
		"看家", "	kan1	jia1",
		"镇咳", "	zhen4	ke2",
		"得兼", "	de	jian1",
		"坊子", "	fang1	zi3",
		"眄睨", "	mian4	ni4",
		"得令", "	de	ling4",
		"旋木", "	xuan4	mu4",
		"均匀", "	jun1	yun2",
		"累月", "	lei3	yue4",
		"冷子", "	leng3	zi3",
		"之至", "	zhi1	zhi4",
		"占课", "	zhan1	ke4",
		"得神", "	de	shen2",
		"主角", "	zhu3	jue2",
		"得算", "	de	suan4",
		"擂主", "	lei4	zhu3",
		"链子", "	lian4	zi3",
		"楞子", "	leng2	zi3",
		"必应", "	bi4	ying4",
		"倒败", "	dao3	bai4",
		"燎祭", "	liao4	ji4",
		"铲子", "	chan3	zi3",
		"待查", "	dai4	cha2",
		"脸子", "	lian3	zi3",
		"倒还", "	dao3	hai2",
		"乐坛", "	yue4	tan2",
		"倒好", "	dao3	hao3",
		"当户", "	dang4	hu4",
		"劲拔", "	jing4	ba2",
		"错处", "	cuo4	chu3",
		"瘅疟", "	dan4	nue4",
		"了悟", "	liao3	wu4",
		"则甚", "	ze2	shen4",
		"锁匙", "	suo3	chi2",
		"槵子", "	huan4	zi3",
		"了如", "	liao3	ru2",
		"干哕", "	gan1	yue3",
		"当得", "	dang1	de",
		"锁钥", "	suo3	yue4",
		"四更", "	si4	geng1",
		"待会", "	dai1	hui4",
		"代为", "	dai4	wei2",
		"丹墀", "	dan	chi",
		"单处", "	dan1	chu3",
		"劲敌", "	jing4	di2",
		"恐吓", "	kong3	he4",
		"择席", "	zhai2	xi2",
		"立卷", "	li4	juan4",
		"款子", "	kuan3	zi3",
		"枋子", "	fang1	zi3",
		"卷第", "	juan4	di4",
		"茅舍", "	mao2	she4",
		"几丁", "	ji1	ding1",
		"卷末", "	juan4	mo4",
		"卷次", "	juan4	ci4",
		"肢势", "	zhi1	shi4",
		"甚巨", "	shen4	ju4",
		"杏子", "	xing4	zi3",
		"居丧", "	ju1	sang1",
		"瓦隆", "	wa3	long1",
		"大宛", "	da4	yuan1",
		"茶匙", "	cha2	chi2",
		"方子", "	fang1	zi3",
		"勒庞", "	le4	pang2",
		"智识", "	zhi4	shi2",
		"璧还", "	bi4	huan2",
		"直切", "	zhi2	qie1",
		"几谏", "	ji1	jian4",
		"军乐", "	jun1	yue4",
		"神子", "	shen2	zi3",
		"隽秀", "	jun4	xiu4",
		"留难", "	liu2	nan4",
		"厦门", "	xia4	men2",
		"旋子", "	xuan2	zi3",
		"甚而", "	shen4	er2",
		"刀切", "	dao1	qie1",
		"地壳", "	di4	qiao4",
		"彻查", "	che4	cha2",
		"曾思", "	zeng1	si1",
		"德兴", "	de2	xing1",
		"倒社", "	dao3	she4",
		"乐师", "	yue4	shi1",
		"看头", "	kan4	tou",
		"倒着", "	dao3	zhe",
		"旦角", "	dan4	jue2",
		"眼晕", "	yan3	yun4",
		"挓挲", "	zha1	sha1",
		"勘查", "	kan1	cha2",
		"勒令", "	le4	ling4",
		"的当", "	di2	dang4",
		"眯缝", "	mi1	feng2",
		"勃兴", "	bo2	xing1",
		"轧车", "	zha2	che1",
		"佛灯", "	fo2	deng1",
		"彷似", "	fang3	si4",
		"困处", "	kun4	chu3",
		"铁杆", "	tie3	gan3",
		"甚钜", "	shen4	ju4",
		"翻查", "	fan1	cha2",
		"翻斗", "	fan1	dou3",
		"断发", "	duan4	fa4",
		"锻模", "	duan4	mu2",
		"倒翻", "	dao3	fan1",
		"顺子", "	shun4	zi3",
		"着衣", "	zhuo2	yi1",
		"笋干", "	sun3	gan1",
		"倒霉", "	dao3	mei2",
		"所处", "	suo3	chu3",
		"倒运", "	dao3	yun4",
		"消得", "	xiao1	de",
		"曲松", "	qu3	song1",
		"遭难", "	zao1	nan4",
		"落藉", "	luo4	jie4",
		"落难", "	luo4	nan4",
		"倒班", "	dao3	ban1",
		"曲阳", "	qu3	yang2",
		"落魄", "	luo4	tuo4",
		"著作", "	zhu4	zuo4",
		"阳曲", "	yang2	qu3",
		"说得", "	shuo1	de",
		"着力", "	zhuo2	li4",
		"着地", "	zhao2	di4",
		"刷子", "	shua1	zi3",
		"着墨", "	zhuo2	mo4",
		"那些", "	nei4	xie1",
		"着急", "	zhao2	ji2",
		"本处", "	ben3	chu3",
		"造血", "	zao4	xie3",
		"刨刀", "	bao4	dao1",
		"挼搓", "	ruo2	cuo1",
		"着棋", "	zhuo2	qi2",
		"司钻", "	si1	zuan4",
		"若为", "	ruo4	wei2",
		"曲水", "	qu3	shui3",
		"过过", "	guo4	guo",
		"判处", "	pan4	chu3",
		"松子", "	song1	zi3",
		"宋子", "	song4	zi3",
		"过分", "	guo4	fen4",
		"散碎", "	san3	sui4",
		"素朴", "	su4	piao2",
		"逢俉", "	feng2	wu2",
		"着法", "	zhao1	fa3",
		"倒蛋", "	dao3	dan4",
		"列为", "	lie4	wei2",
		"著书", "	zhu4	shu1",
		"倒卖", "	dao3	mai4",
		"着笔", "	zhuo2	bi3",
		"算得", "	suan4	de",
		"逼供", "	bi1	gong4",
		"着色", "	zhuo2	se4",
		"蒜子", "	suan4	zi3",
		"曲调", "	qu3	diao4",
		"似曾", "	si4	ceng2",
		"死当", "	si3	dang4",
		"遛弯", "	liu4	wan1",
		"苗子", "	miao2	zi3",
		"苦参", "	ku3	shen1",
		"兴复", "	xing1	fu4",
		"煞有", "	sha4	you3",
		"半载", "	ban4	zai3",
		"唼喋", "	sha4	zha2",
		"杏脯", "	xing4	fu3",
		"少艾", "	shao4	ai4",
		"关子", "	guan1	zi3",
		"兴福", "	xing1	fu2",
		"若干", "	ruo4	gan1",
		"倒反", "	dao3	fan3",
		"杀掠", "	sha1	lue3",
		"衫子", "	shan1	zi3",
		"苫布", "	shan4	bu4",
		"兴波", "	xing1	bo1",
		"兴发", "	xing1	fa1",
		"倒休", "	dao3	xiu1",
		"行都", "	xing2	du1",
		"行卜", "	xing2	bu3",
		"芟荑", "	shan1	yi2",
		"芥蓝", "	gai4	lan2",
		"阿城", "	a	cheng2",
		"山曲", "	shan1	qu3",
		"芥兰", "	gai4	lan2",
		"杉篙", "	sha1	gao1",
		"刨齿", "	bao4	chi3",
		"倒茬", "	dao3	cha2",
		"隆子", "	long2	zi3",
		"丝杠", "	si1	gang4",
		"还击", "	huan2	ji1",
		"寺观", "	si4	guan4",
		"四行", "	si4	hang2",
		"还席", "	huan2	xi2",
		"着意", "	zhuo2	yi4",
		"还俗", "	huan2	su2",
		"邀约", "	yao1	yue1",
		"倒台", "	dao3	tai2",
		"散尽", "	san4	jin4",
		"兴革", "	xing1	ge2",
		"迁都", "	qian1	du1",
		"四通", "	si4	tong4",
		"隔行", "	ge2	hang2",
		"博兴", "	bo2	xing1",
		"倒下", "	dao3	xia4",
		"还礼", "	huan2	li3",
		"兴德", "	xing1	de2",
		"著述", "	zhu4	shu4",
		"铺面", "	pu1	mian4",
		"阑干", "	lan2	gan1",
		"倒数", "	dao4	shu3",
		"肆应", "	si4	ying4",
		"曲周", "	qu3	zhou1",
		"外头", "	wai4	tou",
		"划过", "	hua2	guo4",
		"真子", "	zhen1	zi3",
		"振子", "	zhen4	zi3",
		"砧子", "	zhen1	zi3",
		"可曾", "	ke3	zeng1",
		"课卷", "	ke4	juan4",
		"一哄", "	yi2	hong4",
		"横死", "	heng4	si3",
		"罗嗦", "	luo1	suo",
		"塞北", "	sai4	bei3",
		"削皮", "	xiao1	pi2",
		"菸斗", "	yan1	dou3",
		"瘦子", "	shou4	zi3",
		"划痕", "	hua2	hen2",
		"舌头", "	she2	tou",
		"萎缩", "	wei3	suo1",
		"划切", "	hua2	qie4",
		"剿袭", "	chao1	xi2",
		"倒灶", "	dao3	zao4",
		"萎蕤", "	wei3	rui2",
		"晕倒", "	yun1	dao3",
		"晕染", "	yun4	ran3",
		"晕池", "	yun4	chi2",
		"俞穴", "	shu4	xue2",
		"贞子", "	zhen1	zi3",
		"真似", "	zhen1	si4",
		"劈柴", "	pi3	chai2",
		"弹出", "	tan2	chu1",
		"当夜", "	dang4	ye4",
		"当铺", "	dang4	pu4",
		"看门", "	kan1	men2",
		"欺哄", "	qi1	hong3",
		"剀切", "	kai3	qie1",
		"不着", "	bu4	zhao2",
		"建都", "	jian4	du1",
		"多难", "	duo1	nan4",
		"枝杈", "	zhi1	cha4",
		"不见", "	bu2	jian4",
		"都统", "	du1	tong3",
		"附着", "	fu4	zhuo2",
		"疹子", "	zhen3	zi3",
		"斗室", "	dou3	shi4",
		"折实", "	she2	shi2",
		"舍友", "	she4	you3",
		"散诞", "	san3	dan4",
		"占卜", "	zhan1	bu3",
		"折损", "	she2	sun3",
		"瘪三", "	bie1	san1",
		"折折", "	she2	she2",
		"丙子", "	bing3	zi3",
		"靠头", "	kao4	tou",
		"晕血", "	yun4	xue4",
		"晕车", "	yun4	che1",
		"都灵", "	du1	ling2",
		"锄头", "	chu2	tou",
		"劲卒", "	jing4	zu2",
		"笑呀", "	xiao4	ya1",
		"劫难", "	jie2	nan4",
		"倒是", "	dao3	shi4",
		"菌盖", "	jun4	gai4",
		"倒楣", "	dao3	mei2",
		"小曲", "	xiao3	qu3",
		"铺平", "	pu1	ping2",
		"华佗", "	hua4	tuo2",
		"铺垫", "	pu1	dian4",
		"销子", "	xiao1	zi3",
		"时为", "	shi2	wei2",
		"明子", "	ming2	zi3",
		"华为", "	hua2	wei2",
		"华视", "	hua4	shi4",
		"倒槽", "	dao3	cao2",
		"收得", "	shou1	de",
		"华陀", "	hua4	tuo2",
		"钎子", "	qian1	zi3",
		"昏倒", "	hun1	dao3",
		"钉耙", "	ding1	pa2",
		"铺展", "	pu1	zhan3",
		"铺陈", "	pu1	chen2",
		"铺炕", "	pu1	kang4",
		"施为", "	shi1	wei2",
		"萹蓄", "	bian1	xu4",
		"配载", "	pei4	zai3",
		"暑假", "	shu3	jia4",
		"小纪", "	xiao3	ji3",
		"里弄", "	li3	long4",
		"落价", "	lao4	jia4",
		"酸曲", "	suan1	qu3",
		"酷肖", "	ku4	xiao1",
		"刹时", "	cha4	shi2",
		"酬和", "	chou2	he4",
		"暴晒", "	pu4	shai4",
		"落拓", "	luo4	tuo4",
		"配角", "	pei4	jue2",
		"石拓", "	shi2	tuo4",
		"邻舍", "	lin2	she4",
		"朴硝", "	po4	xiao1",
		"晓得", "	xiao3	de",
		"散职", "	san3	zhi2",
		"树杈", "	shu4	cha4",
		"散粉", "	san3	fen3",
		"星子", "	xing1	zi3",
		"莎草", "	suo1	cao3",
		"试帖", "	shi4	tie3",
		"铺衬", "	pu1	chen4",
		"菌伞", "	jun4	san3",
		"倒飞", "	dao3	fei1",
		"曾父", "	zeng1	fu4",
		"懒散", "	lan3	san3",
		"周内", "	zhou1	na4",
		"干咳", "	gan1	hai1",
		"佛堂", "	fo2	tang2",
		"爪机", "	zhua3	ji1",
		"下载", "	xia4	zai3",
		"爪子", "	zhua3	zi3",
		"爪哇", "	zhao3	wa1",
		"佛说", "	fo2	shuo1",
		"尽好", "	jin4	hao3",
		"差迟", "	cha1	chi2",
		"爪儿", "	zhua3	er2",
		"夫差", "	fu1	chai1",
		"少爷", "	shao4	ye2",
		"尽瘁", "	jin4	cui4",
		"烫发", "	tang4	fa4",
		"差错", "	cha1	cuo4",
		"肘子", "	zhou3	zi3",
		"尽美", "	jin4	mei3",
		"父丧", "	fu4	sang1",
		"牟平", "	mu4	ping2",
		"天呀", "	tian1	ya1",
		"天哪", "	tian1	na",
		"天子", "	tian1	zi3",
		"毋宁", "	wu2	ning4",
		"隔扇", "	ge2	shan1",
		"牛只", "	niu2	zhi1",
		"间色", "	jian4	se4",
		"毡子", "	zhan1	zi3",
		"剪发", "	jian3	fa4",
		"供案", "	gong4	an4",
		"尤为", "	you2	wei2",
		"供佛", "	gong4	fo2",
		"好学", "	hao4	xue2",
		"一样", "	yi2	yang4",
		"更移", "	geng1	yi2",
		"高知", "	gao1	zhi4",
		"跟斗", "	gen1	dou3",
		"为主", "	wei2	zhu3",
		"给水", "	ji3	shui3",
		"炸糕", "	zha2	gao1",
		"葛洪", "	ge3	hong2",
		"间杂", "	jian4	za2",
		"炮制", "	pao2	zhi4",
		"屏息", "	bing3	xi1",
		"间日", "	jian4	ri4",
		"炮烙", "	pao2	luo4",
		"灾难", "	zai1	nan4",
		"女红", "	nv3	gong1",
		"湾仔", "	wan1	zai3",
		"济宁", "	ji3	ning2",
		"牛饮", "	niu2	yin4",
		"镯子", "	zhuo2	zi3",
		"哽塞", "	geng3	se4",
		"揭帖", "	jie1	tie3",
		"煞是", "	sha4	shi4",
		"煞白", "	sha4	bai2",
		"朱干", "	zhu1	gan1",
		"死劲", "	si3	jing4",
		"复还", "	fu4	huan2",
		"燕国", "	yan1	guo2",
		"殆尽", "	dai4	jin4",
		"熨斗", "	yun4	dou3",
		"轧空", "	ga2	kong1",
		"差池", "	cha1	chi2",
		"差役", "	chai1	yi4",
		"无间", "	wu2	jian4",
		"差别", "	cha1	bie2",
		"殉难", "	xun4	nan4",
		"照得", "	zhao4	de",
		"诘难", "	jie2	nan2",
		"蠡县", "	li3	xian4",
		"特调", "	te4	tiao2",
		"少府", "	shao4	fu3",
		"家什", "	jia1	shi2",
		"海蜇", "	hai3	zhe2",
		"钻机", "	zuan4	ji1",
		"害臊", "	hai4	sao4",
		"舟子", "	zhou1	zi3",
		"无爪", "	wu2	zhua3",
		"佛手", "	fo2	shou3",
		"燕麦", "	yan1	mai4",
		"不了", "	bu4	liao3",
		"牛仔", "	niu2	zai3",
		"尽然", "	jin4	ran2",
		"牙行", "	ya2	hang2",
		"牙冠", "	ya2	guan4",
		"片子", "	pian1	zi",
		"片儿", "	pian1	er",
		"尽人", "	jin4	ren2",
		"干裂", "	gan1	lie4",
		"轴子", "	zhou2	zi3",
		"差价", "	cha1	jia4",
		"干花", "	gan1	hua1",
		"烟斗", "	yan1	dou3",
		"叫子", "	jiao4	zi3",
		"酵子", "	jiao4	zi3",
		"交子", "	jiao1	zi3",
		"骄子", "	jiao1	zi3",
		"段子", "	duan4	zi3",
		"娇子", "	jiao1	zi3",
		"干犯", "	gan1	fan4",
		"干粪", "	gan1	fen4",
		"无着", "	wu2	zhuo2",
		"干耗", "	gan1	hao4",
		"更易", "	geng1	yi4",
		"澎湖", "	peng2	hu2",
		"浮漂", "	fu2	piao1",
		"打烊", "	da3	yang4",
		"抹角", "	mo4	jiao3",
		"童子", "	tong2	zi3",
		"游散", "	you2	san3",
		"抹面", "	mo4	mian4",
		"竭尽", "	jie2	jin4",
		"二更", "	er4	geng1",
		"端子", "	duan1	zi3",
		"投奔", "	tou2	ben4",
		"脖颈", "	bo2	geng3",
		"空地", "	kong4	di4",
		"打更", "	da3	geng1",
		"隐处", "	yin3	chu3",
		"干馏", "	gan1	liu2",
		"晨曲", "	chen2	qu3",
		"什锦", "	shi2	jin3",
		"篷子", "	peng2	zi3",
		"挑起", "	tiao3	qi3",
		"空子", "	kong4	zi",
		"喝令", "	he4	ling4",
		"栟榈", "	bing1	lv2",
		"结实", "	jie1	shi",
		"配乐", "	pei4	yue4",
		"空隙", "	kong4	xi4",
		"事假", "	shi4	jia4",
		"问倒", "	wen4	dao3",
		"埂子", "	geng3	zi3",
		"打哄", "	da3	hong3",
		"没乱", "	mo4	luan4",
		"没什", "	mei2	shi2",
		"戳子", "	chuo1	zi3",
		"丧礼", "	sang1	li3",
		"义兴", "	yi4	xing1",
		"吁请", "	yu4	qing3",
		"干号", "	gan1	hao2",
		"绿营", "	lu4	ying2",
		"抖搂", "	dou3	lou1",
		"干饭", "	gan1	fan4",
		"缪缪", "	miu4	miu4",
		"挎斗", "	kua4	dou3",
		"兵子", "	bing1	zi3",
		"咧咧", "	lie1	lie1",
		"柄子", "	bing3	zi3",
		"了局", "	liao3	ju2",
		"空余", "	kong4	yu2",
		"啜泣", "	chuo4	qi4",
		"窝囊", "	wo1	nang1",
		"批卷", "	pi1	juan4",
		"剥除", "	bao1	chu2",
		"阴处", "	yin1	chu3",
		"名子", "	ming2	zi3",
		"扯臊", "	che3	sao4",
		"挑拨", "	tiao3	bo1",
		"尿泡", "	sui1	pao4",
		"巡查", "	xun2	cha2",
		"膏油", "	gao4	you2",
		"毒爪", "	du2	zhua3",
		"奔头", "	ben4	tou2",
		"焙干", "	bei4	gan1",
		"干亲", "	gan1	qin1",
		"奇羡", "	ji1	xian4",
		"校核", "	jiao4	he2",
		"干人", "	gan1	ren2",
		"干肉", "	gan1	rou4",
		"刚子", "	gang1	zi3",
		"为难", "	wei2	nan2",
		"皋陶", "	gao1	yao2",
		"奏帖", "	zou4	tie3",
		"奏乐", "	zou4	yue4",
		"为着", "	wei2	zhe",
		"一点", "	yi4	dian3",
		"为止", "	wei2	zhi3",
		"干薪", "	gan1	xin1",
		"母丧", "	mu3	sang1",
		"为人", "	wei2	ren2",
		"屏气", "	bing3	qi4",
		"尿脬", "	sui1	pao1",
		"民乐", "	min2	yue4",
		"糕干", "	gao1	gan1",
		"篙头", "	gao1	tou",
		"喉咽", "	hou2	yan1",
		"大轴", "	da4	zhou4",
		"朝露", "	zhao1	lu4",
		"吵子", "	chao3	zi3",
		"邮折", "	you2	she2",
		"椎骨", "	zhui1	gu3",
		"命薄", "	ming4	bo2",
		"鸣镝", "	ming2	di2",
		"什菜", "	shi2	cai4",
		"绊倒", "	ban4	dao3",
		"大藏", "	da4	zang4",
		"差数", "	cha1	shu4",
		"岗子", "	gang3	zi3",
		"属文", "	zhu3	wen2",
		"猪仔", "	zhu1	zai3",
		"著者", "	zhu4	zhe3",
		"浇薄", "	jiao1	bo2",
		"猪只", "	zhu1	zhi1",
		"告倒", "	gao4	dao3",
		"为时", "	wei2	shi2",
		"缸子", "	gang1	zi3",
		"山脊", "	shan1	ji3",
		"告假", "	gao4	jia4",
		"山子", "	shan1	zi3",
		"奠都", "	dian4	du1",
		"子层", "	zi3	ceng2",
		"宫掖", "	gong1	ye4",
		"倒跌", "	dao3	die1",
		"尽饱", "	jin4	bao3",
		"模样", "	mu2	yang4",
		"了无", "	liao3	wu2",
		"直奔", "	zhi2	ben4",
		"等子", "	deng3	zi3",
		"循分", "	xun2	fen4",
		"盘诘", "	pan2	jie2",
		"盘查", "	pan2	cha2",
		"戥子", "	deng3	zi3",
		"盘倒", "	pan2	dao3",
		"了得", "	liao3	de",
		"镫子", "	deng4	zi3",
		"基甸", "	ji1	dian4",
		"尽头", "	jin4	tou2",
		"累加", "	lei3	jia1",
		"执拗", "	zhi2	niu4",
		"省悟", "	xing3	wu4",
		"的应", "	de	ying4",
		"得用", "	de	yong4",
		"垣曲", "	yuan2	qu3",
		"盼头", "	pan4	tou",
		"的真", "	di2	zhen1",
		"等得", "	deng3	de",
		"累代", "	lei3	dai4",
		"风子", "	feng1	zi3",
		"乐队", "	yue4	dui4",
		"妹妹", "	mei4	mei",
		"行伍", "	hang2	wu3",
		"杭育", "	hang2	yo1",
		"行子", "	hang2	zi3",
		"宁都", "	ning2	du1",
		"子星", "	zi3	xing1",
		"滑倒", "	hua2	dao3",
		"子埝", "	zi3	nian4",
		"国难", "	guo2	nan4",
		"准的", "	zhun3	di4",
		"贵处", "	gui4	chu3",
		"渺子", "	miao3	zi3",
		"佛殿", "	fo2	dian4",
		"归处", "	gui1	chu3",
		"奇零", "	ji1	ling2",
		"子囊", "	zi3	nang2",
		"子陵", "	zi3	ling2",
		"子明", "	zi3	ming2",
		"锅伙", "	guo1	huo",
		"过淋", "	guo4	lin4",
		"姐姐", "	jie3	jie",
		"蜾蠃", "	guo3	luo3",
		"子棉", "	zi3	mian2",
		"打颤", "	da3	zhan4",
		"累时", "	lei3	shi2",
		"得能", "	de	neng2",
		"子弦", "	zi3	xian2",
		"尽皆", "	jin4	jie1",
		"朝暮", "	zhao1	mu4",
		"得亏", "	dei3	kui1",
		"尽数", "	jin4	shu4",
		"尽职", "	jin4	zhi2",
		"尽是", "	jin4	shi4",
		"报载", "	bao4	zai3",
		"唠唠", "	lao4	lao4",
		"得着", "	de	zhao2",
		"落架", "	lao4	jia4",
		"劲急", "	jing4	ji2",
		"甸子", "	dian4	zi3",
		"报帖", "	bao4	tie3",
		"得性", "	de	xing4",
		"锥子", "	zhui1	zi3",
		"得行", "	de	xing2",
		"荡子", "	dang4	zi3",
		"挡子", "	dang3	zi3",
		"倒板", "	dao3	ban3",
		"曾波", "	zeng1	bo1",
		"念佛", "	nian4	fo2",
		"忖度", "	cun3	duo2",
		"当子", "	dang1	zi3",
		"倒错", "	dao3	cuo4",
		"尽致", "	jin4	zhi4",
		"尽言", "	jin4	yan2",
		"得请", "	de	qing3",
		"电发", "	dian4	fa4",
		"乐音", "	yue4	yin1",
		"标的", "	biao1	di4",
		"累世", "	lei3	shi4",
		"得幸", "	de	xing4",
		"了不", "	liao3	bu4",
		"樵子", "	qiao2	zi3",
		"场儿", "	chang3	r",
		"狼子", "	lang2	zi3",
		"琅邪", "	lang2	ya2",
		"后头", "	hou4	tou",
		"尽心", "	jin4	xin1",
		"复兴", "	fu4	xing1",
		"得当", "	de2	dang4",
		"电磨", "	dian4	mo4",
		"后燕", "	hou4	yan1",
		"店子", "	dian4	zi3",
		"癫子", "	dian1	zi3",
		"拉纤", "	la1	qian4",
		"盔头", "	kui1	tou",
		"颠仆", "	dian1	pu2",
		"勒兵", "	le4	bing1",
		"唠扯", "	lao4	che3",
		"骶椎", "	di3	zhui1",
		"混和", "	hun4	huo4",
		"子平", "	zi3	ping2",
		"海难", "	hai3	nan4",
		"泄露", "	xie4	lou4",
		"钻塔", "	zuan4	ta3",
		"黑煞", "	hei1	sha4",
		"子贡", "	zi3	gong4",
		"画帖", "	hua4	tie4",
		"侯家", "	hou4	jia1",
		"泌阳", "	bi4	yang2",
		"侯氏", "	hou4	shi4",
		"互见", "	hu4	xian4",
		"化为", "	hua4	wei2",
		"左肋", "	zuo3	lei4",
		"鹄望", "	hu2	wang4",
		"好施", "	hao4	shi1",
		"油炸", "	you2	zha2",
		"孟子", "	meng4	zi3",
		"孝子", "	xiao4	zi3",
		"孔子", "	kong3	zi3",
		"泊松", "	bo2	song1",
		"洪佛", "	hong2	fo2",
		"红子", "	hong2	zi3",
		"子网", "	zi3	wang3",
		"洗马", "	xian3	ma3",
		"洋脊", "	yang2	ji3",
		"子洲", "	zi3	zhou1",
		"嫌恶", "	xian2	wu4",
		"一定", "	yi2	ding4",
		"宜兴", "	yi2	xing1",
		"子宫", "	zi3	gong1",
		"钻具", "	zuan4	ju4",
		"浪子", "	lang4	zi3",
		"流血", "	liu2	xie3",
		"流干", "	liu2	gan1",
		"没收", "	mo4	shou1",
		"和药", "	huo4	yao4",
		"獾子", "	huan1	zi3",
		"子房", "	zi3	fang2",
		"环子", "	huan2	zi3",
		"沉没", "	chen2	mo4",
		"子丑", "	zi3	chou3",
		"回煞", "	hui2	sha4",
		"子京", "	zi3	jing1",
		"子婴", "	zi3	ying1",
		"子真", "	zi3	zhen1",
		"婚假", "	hun1	jia4",
		"宁可", "	ning4	ke3",
		"一块", "	yi2	kuai4",
		"寒舍", "	han2	she4",
		"沦为", "	lun2	wei2",
		"寒假", "	han2	jia4",
		"回弹", "	hui2	tan2",
		"密缝", "	mi4	feng2",
		"泰斗", "	tai4	dou3",
		"横逆", "	heng4	ni4",
		"子痫", "	zi3	xian2",
		"漏斗", "	lou4	dou3",
		"家舍", "	jia1	she4",
		"椎体", "	zhui1	ti3",
		"少妇", "	shao4	fu4",
		"少女", "	shao4	nv3",
		"家累", "	jia1	lei3",
		"伽蓝", "	qie2	lan2",
		"棘爪", "	ji2	zhua3",
		"气钻", "	qi4	zuan4",
		"沤凼", "	ou4	dang4",
		"狗舍", "	gou3	she4",
		"夹被", "	jia2	bei4",
		"漂砾", "	piao1	li4",
		"好斗", "	hao4	dou4",
		"卓子", "	zhuo2	zi3",
		"一更", "	yi1	geng1",
		"汗国", "	han2	guo2",
		"乖子", "	guai1	zi3",
		"溶没", "	rong2	mo4",
		"子乔", "	zi3	qiao2",
		"子桑", "	zi3	sang1",
		"浅薄", "	qian3	bo2",
		"混蛋", "	hun2	dan4",
		"混球", "	hun2	qiu2",
		"漂移", "	piao1	yi2",
		"乖剌", "	guai1	la4",
		"孱头", "	can4	tou",
		"鼓角", "	gu3	jiao3",
		"子产", "	zi3	chan3",
		"官子", "	guan1	zi3",
		"泥守", "	ni4	shou3",
		"环伺", "	huan2	si4",
		"子精", "	zi3	jing1",
		"泡货", "	pao1	huo4",
		"柞蚕", "	zuo4	can2",
		"泥泞", "	ni2	ning4",
		"潜没", "	qian2	mo4",
		"婊子", "	biao3	zi3",
		"咕隆", "	gu1	long1",
		"漂泊", "	piao1	bo2",
		"漂浮", "	piao1	fu2",
		"漂洗", "	piao3	xi3",
		"给养", "	ji3	yang3",
		"谷坊", "	gu3	fang2",
		"继兴", "	ji4	xing1",
		"固着", "	gu4	zhuo2",
		"自供", "	zi4	gong4",
		"挂斗", "	gua4	dou3",
		"满处", "	man3	chu3",
		"瓜蔓", "	gua1	wan4",
		"怪得", "	guai4	de",
		"倒闭", "	dao3	bi4",
		"逻辑", "	luo2	ji",
		"不对", "	bu2	dui4",
		"差讹", "	cha1	e2",
		"薄雾", "	bo2	wu4",
		"五子", "	wu3	zi3",
		"谱子", "	pu3	zi3",
		"乌拉", "	wu4	lɑ",
		"西曲", "	xi1	qu3",
		"图子", "	tu2	zi3",
		"栖栖", "	xi1	xi1",
		"熬稃", "	ao1	fu1",
		"热呼", "	re4	hu",
		"毂辘", "	gu1	lu4",
		"一起", "	yi4	qi3",
		"跛子", "	bo3	zi3",
		"跂訾", "	qi3	zi3",
		"夫子", "	fu1	zi3",
		"薄利", "	bo2	li4",
		"子堤", "	zi3	di1",
		"姑子", "	gu1	zi3",
		"息子", "	xi1	zi3",
		"系子", "	xi4	zi3",
		"股子", "	gu3	zi3",
		"自个", "	zi4	ge3",
		"一路", "	yi2	lu4",
		"谱曲", "	pu3	qu3",
		"巨擘", "	ju4	bo4",
		"奇偶", "	ji1	ou3",
		"母子", "	mu3	zi3",
		"薄暮", "	bo2	mu4",
		"无似", "	wu2	si4",
		"薄暗", "	bo2	an4",
		"奇技", "	qi2	ji4",
		"苏打", "	su1	da2",
		"贾客", "	gu3	ke4",
		"薄技", "	bo2	ji4",
		"漯河", "	ta4	he2",
		"於菟", "	wu1	tu2",
		"局子", "	ju2	zi3",
		"杌子", "	wu4	zi3",
		"女子", "	nv3	zi3",
		"女仆", "	nv3	pu2",
		"阁子", "	ge2	zi3",
		"葛麻", "	ge3	ma2",
		"屋脊", "	wu1	ji3",
		"屈曲", "	qu1	qu3",
		"奴仆", "	nu2	pu2",
		"兀秃", "	wu1	tu1",
		"激子", "	ji1	zi3",
		"汩没", "	gu3	mo4",
		"骨碌", "	gu1	lu4",
		"细发", "	xi4	fa4",
		"子路", "	zi3	lu4",
		"曲子", "	qu3	zi",
		"厄难", "	e4	nan4",
		"度曲", "	du4	qu3",
		"衣子", "	yi1	zi3",
		"痦子", "	wu4	zi3",
		"子弟", "	zi3	di4",
		"不义", "	bu2	yi4",
		"都司", "	du1	si1",
		"鹤发", "	he4	fa4",
		"西子", "	xi1	zi3",
		"酷似", "	ku4	si4",
		"西打", "	xi1	da2",
		"蛤蛎", "	ge2	li4",
		"寄子", "	ji4	zi3",
		"医卜", "	yi1	bu3",
		"寄与", "	ji4	yu2",
		"卒子", "	zu2	zi3",
		"蛤蜊", "	ge2	li2",
		"淤塞", "	yu1	se4",
		"夜曲", "	ye4	qu3",
		"都督", "	du1	du",
		"都护", "	du1	hu4",
		"独得", "	du2	de",
		"古佛", "	gu3	fo2",
		"桴子", "	fu2	zi3",
		"语塞", "	yu3	se4",
		"武曲", "	wu3	qu3",
		"起子", "	qi3	zi3",
		"语域", "	yu3	yu4",
		"穄子", "	ji4	zi3",
		"鸡子", "	ji1	zi3",
		"虎子", "	hu3	zi3",
		"薄地", "	bo2	di4",
		"子安", "	zi3	an1",
		"子部", "	zi3	bu4",
		"子叶", "	zi3	ye4",
		"机子", "	ji1	zi3",
		"浮子", "	fu2	zi3",
		"附子", "	fu4	zi3",
		"嘎子", "	ga3	zi3",
		"婀娜", "	e1	nuo2",
		"迪吧", "	di2	ba1",
		"曲艺", "	qu3	yi4",
		"畜牧", "	xu4	mu4",
		"袄子", "	ao3	zi3",
		"克勒", "	ke4	le4",
		"套儿", "	tao4	r",
		"喜得", "	xi3	de",
		"子夜", "	zi3	ye4",
		"盖儿", "	gai4	r",
		"佛力", "	fo2	li4",
		"佛理", "	fo2	li3",
		"辈儿", "	bei4	r",
		"子母", "	zi3	mu3",
		"字模", "	zi4	mu2",
		"佛偈", "	fo2	ji4",
		"羁勒", "	ji1	le4",
		"佛骨", "	fo2	gu3",
		"子墨", "	zi3	mo4",
		"佛曲", "	fo2	qu3",
		"子么", "	zi3	mo3",
		"妻子", "	qi1	zi3",
		"差额", "	cha1	e2",
		"屉子", "	ti4	zi3",
		"剃发", "	ti4	fa4",
		"佛土", "	fo2	tu3",
		"於乎", "	wu1	hu1",
		"籍没", "	ji2	mo4",
		"特勒", "	te4	le4",
		"一意", "	yi1	yi4",
		"记得", "	ji4	de",
		"佛历", "	fo2	li4",
		"佛母", "	fo2	mu3",
		"尉犁", "	yu4	li2",
		"撒播", "	sa3	bo1",
		"案子", "	an4	zi3",
		"脉脉", "	mo4	mo4",
		"瓯子", "	ou1	zi3",
		"组曲", "	zu3	qu3",
		"扒鸡", "	pa2	ji1",
		"派司", "	pa1	si1",
		"筢子", "	pa2	zi3",
		"卜卜", "	bu3	bu3",
		"撒督", "	sa3	du1",
		"发屋", "	fa4	wu1",
		"瓦剌", "	wa3	la4",
		"发丝", "	fa4	si1",
		"趵趵", "	bo1	bo1",
		"咖喱", "	ga1	li2",
		"胡佛", "	hu2	fo2",
		"啪啦", "	pa1	la1",
		"昵比", "	ni4	bi4",
		"的子", "	de	zi3",
		"麸子", "	fu1	zi3",
		"牙子", "	ya2	zi3",
		"哇啦", "	wa1	la1",
		"子鸡", "	zi3	ji1",
		"父子", "	fu4	zi3",
		"偶遇", "	ou3	yu4",
		"迤逦", "	yi3	li3",
		"大雅", "	da4	ya2",
		"子期", "	zi3	qi1",
		"狸子", "	li2	zi3",
		"帕子", "	pa4	zi3",
		"末子", "	mo4	zi3",
		"葛摩", "	ge3	mo2",
		"子奇", "	zi3	qi2",
		"大都", "	da4	du1",
		"帝都", "	di4	du1",
		"哥子", "	ge1	zi3",
		"希腊", "	xi1	la4",
		"席勒", "	xi2	le4",
		"带儿", "	dai4	r",
		"无得", "	wu2	de",
		"娃子", "	wa2	zi3",
		"六安", "	lu4	an1",
		"夫夫", "	fu2	fu1",
		"薄荷", "	bo4	he",
		"薄礼", "	bo2	li3",
		"负荷", "	fu4	he4",
		"万俟", "	mo4	qi2",
		"辣子", "	la4	zi3",
		"独子", "	du2	zi3",
		"爷爷", "	ye2	ye",
		"理发", "	li3	fa4",
		"妮子", "	ni1	zi3",
		"佛子", "	fo2	zi3",
		"辟谷", "	bi4	gu3",
		"娃娃", "	wa2	wa",
		"太阿", "	tai4	e1",
		"踏踏", "	ta1	ta4",
		"哈巴", "	ha3	ba1",
		"觑糊", "	qu4	hu",
		"一度", "	yi2	du4",
		"哈呀", "	ha1	ya1",
		"泰阿", "	tai4	e1",
		"迷糊", "	mi2	hu",
		"巨贾", "	ju4	gu3",
		"逆子", "	ni4	zi3",
		"玛曲", "	ma3	qu3",
		"居积", "	ju1	ji1",
		"覆没", "	fu4	mo4",
		"子兮", "	zi3	xi1",
		"沮洳", "	ju4	ru4",
		"子息", "	zi3	xi1",
		"子午", "	zi3	wu3",
		"武都", "	wu3	du1",
		"二曲", "	er4	qu3",
		"法子", "	fa3	zi3",
		"怒发", "	nu4	fa4",
		"要击", "	yao1	ji1",
		"齱齵", "	zou1	yu2",
		"瓦舍", "	wa3	she4",
		"解法", "	xie4	fa3",
		"瓦刀", "	wa4	dao1",
		"崴泥", "	wei1	ni2",
		"龟兹", "	qiu1	ci2",
		"要得", "	yao4	de",
		"麇集", "	qun2	ji2",
		"丽致", "	li2	zhi4",
		"要末", "	yao4	me",
		"鼻咽", "	bi2	yan1",
		"盐都", "	yan2	du1",
		"叱喝", "	chi4	he4",
		"核查", "	he2	cha2",
		"可汗", "	ke4	han2",
		"帵子", "	wan1	zi3",
		"宛似", "	wan3	si4",
		"亲子", "	qin1	zi3",
		"叱呵", "	chi4	he1",
		"觉得", "	jue2	de",
		"角力", "	jue2	li4",
		"吆喝", "	yao1	he",
		"湾泊", "	wan1	bo2",
		"鹄候", "	hu2	hou4",
		"替角", "	ti4	jue2",
		"句读", "	ju4	dou4",
		"掸子", "	dan3	zi3",
		"骨头", "	gu2	tou",
		"凯撒", "	kai3	sa3",
		"投得", "	tou2	de",
		"骰子", "	tou2	zi3",
		"吐泻", "	tu4	xie4",
		"血塞", "	xue4	se4",
		"衣甲", "	yi4	jia3",
		"骨殖", "	gu3	shi",
		"角色", "	jue2	se4",
		"论语", "	lun2	yu3",
		"韦曲", "	wei2	qu3",
		"驮子", "	duo4	zi3",
		"试液", "	shi4	ye4",
		"高丽", "	gao1	li2",
		"摩莎", "	mo2	suo1",
		"要子", "	yao4	zi3",
		"角抵", "	jue2	di3",
		"崴子", "	wei1	zi3",
		"外子", "	wai4	zi3",
		"鲍耶", "	bao4	ye1",
		"阿顺", "	e1	shun4",
		"驳倒", "	bo2	dao3",
		"记为", "	ji4	wei2",
		"可数", "	ke3	shu3",
		"且夫", "	qie3	fu2",
		"可塞", "	ke3	sai4",
		"记载", "	ji4	zai3",
		"鬓发", "	bin4	fa4",
		"合为", "	he2	wei2",
		"脱模", "	tuo1	mu2",
		"月子", "	yue4	zi3",
		"折子", "	zhe2	zi3",
		"诸葛", "	zhu1	ge3",
		"为底", "	wei2	di3",
		"割舍", "	ge1	she4",
		"铁勒", "	tie3	le4",
		"卑鄙", "	bei1	bi3",
		"列子", "	lie4	zi3",
		"阿亨", "	a	heng1",
		"阻难", "	zu3	nan4",
		"半拉", "	ban4	la3",
		"半打", "	ban4	da2",
		"遇难", "	yu4	nan4",
		"阇黎", "	she2	li2",
		"魏都", "	wei4	du1",
		"褶子", "	zhe3	zi3",
		"托子", "	tuo1	zi3",
		"袒裼", "	tan3	xi1",
		"入月", "	ru4	yue4",
		"囤聚", "	tun2	ju4",
		"屯堡", "	tun2	pu4",
		"腿子", "	tui3	zi3",
		"发式", "	fa4	shi4",
		"合著", "	he2	zhu4",
		"发带", "	fa4	dai4",
		"切末", "	qie1	mo4",
		"发菜", "	fa4	cai4",
		"为乐", "	wei2	le4",
		"魔难", "	mo2	nan4",
		"褪去", "	tun4	qu4",
		"为力", "	wei2	li4",
		"一只", "	yi4	zhi1",
		"推磨", "	tui1	mo4",
		"诱掖", "	you4	ye4",
		"袍子", "	pao2	zi3",
		"入肉", "	ru4	rou4",
		"里头", "	li3	tou",
		"认得", "	ren4	de",
		"服事", "	fu2	shi",
		"吐血", "	tu4	xie3",
		"欸乃", "	ai3	nai3",
		"歌子", "	ge1	zi3",
		"子女", "	zi3	nv3",
		"鄙薄", "	bi3	bo2",
		"兀自", "	wu1	zi4",
		"何似", "	he2	si4",
		"那末", "	na4	me",
		"那曲", "	na3	qu1",
		"子细", "	zi3	xi4",
		"蝲蛄", "	la4	gu3",
		"补给", "	bu3	ji3",
		"饵子", "	er3	zi3",
		"歌曲", "	ge1	qu3",
		"里脊", "	li3	ji3",
		"嫡子", "	di2	zi3",
		"喔喔", "	wo1	wo1",
		"苏子", "	su1	zi3",
		"俗子", "	su2	zi3",
		"蔚蔚", "	yu4	yu4",
		"嗉子", "	su4	zi3",
		"垡子", "	fa2	zi3",
		"几米", "	ji1	mi3",
		"几率", "	ji1	lv4",
		"几欲", "	ji1	yu4",
		"那麽", "	na4	me",
		"服服", "	fu2	fu",
		"几案", "	ji1	an4",
		"宜都", "	yi2	du1",
		"虾蟆", "	ha2	ma",
		"咔叽", "	ka3	ji1",
		"不子", "	bu4	zi3",
		"禾子", "	he2	zi3",
		"诃子", "	he1	zi3",
		"刻薄", "	ke4	bo2",
		"泥子", "	ni4	zi3",
		"次子", "	ci4	zi3",
		"粒子", "	li4	zi3",
		"虮子", "	ji3	zi3",
		"朴子", "	po4	zi3",
		"犊子", "	du2	zi3",
		"蟢子", "	xi3	zi3",
		"弟弟", "	di4	di",
		"子目", "	zi3	mu4",
		"都邑", "	du1	yi4",
		"曲奇", "	qu3	qi2",
		"子粒", "	zi3	li4",
		"泥古", "	ni4	gu3",
		"疑似", "	yi2	si4",
		"疙疸", "	ge1	da",
		"訾议", "	zi3	yi4",
		"曲沃", "	qu3	wo4",
		"琴曲", "	qin2	qu3",
		"子羽", "	zi3	yu3",
		"仆役", "	pu2	yi4",
		"子句", "	zi3	ju4",
		"发妻", "	fa4	qi1",
		"坷垃", "	ke1	la1",
		"法曲", "	fa3	qu3",
		"弟子", "	di4	zi3",
		"子集", "	zi3	ji2",
		"欧泊", "	ou1	bo2",
		"发乳", "	fa4	ru3",
		"微曲", "	wei1	qu3",
		"子嗣", "	zi3	si4",
		"古刹", "	gu3	cha4",
		"投子", "	tou2	zi3",
		"只得", "	zhi3	de",
		"蛮子", "	man2	zi3",
		"蚕薄", "	can2	bo2",
		"骨朵", "	gu1	duo3",
		"误差", "	wu4	cha1",
		"诸子", "	zhu1	zi3",
		"驼子", "	tuo2	zi3",
		"撒门", "	sa3	men2",
		"子鱼", "	zi3	yu2",
		"呼啦", "	hu1	la1",
		"孤子", "	gu1	zi3",
		"举子", "	ju3	zi3",
		"几希", "	ji1	xi1",
		"暗堡", "	an4	pu4",
		"婆子", "	po2	zi3",
		"几乎", "	ji1	hu1",
		"窝子", "	wo1	zi3",
		"子婿", "	zi3	xu4",
		"曲率", "	qu3	lv4",
		"子虚", "	zi3	xu1",
		"具足", "	ju4	zu2",
		"曲目", "	qu3	mu4",
		"巨子", "	ju4	zi3",
		"发际", "	fa4	ji4",
		"季子", "	ji4	zi3",
		"瓠子", "	hu4	zi3",
		"坷拉", "	ke1	la1",
		"序曲", "	xu4	qu3",
		"素子", "	su4	zi3",
		"鹄立", "	hu2	li4",
		"都德", "	du1	de2",
		"四子", "	si4	zi3",
		"俗曲", "	su2	qu3",
		"子域", "	zi3	yu4",
		"怒喝", "	nu4	he4",
		"体己", "	ti1	ji",
		"阇梨", "	she2	li2",
		"得色", "	de	se4",
		"鏊子", "	ao4	zi3",
		"斗门", "	dou3	men2",
		"的卢", "	di4	lu2",
		"樀樀", "	di2	di2",
		"日没", "	ri4	mo4",
		"嘀哒", "	di1	da1",
		"乐得", "	le4	de",
		"乐呵", "	le4	he1",
		"目的", "	mu4	di4",
		"模糊", "	mo2	hu",
		"铺路", "	pu1	lu4",
		"模子", "	mu2	zi3",
		"勒子", "	le4	zi3",
		"模具", "	mu2	ju4",
		"模似", "	mo2	si4",
		"复辟", "	fu4	bi4",
		"于都", "	yu2	du1",
		"勒逼", "	le4	bi1",
		"勒抑", "	le4	yi4",
		"得按", "	de	an4",
		"堵塞", "	du3	se4",
		"锯子", "	ju4	zi3",
		"卜辞", "	bu3	ci2",
		"棵子", "	ke1	zi3",
		"须得", "	xu1	de",
		"余裕", "	yu2	yu4",
		"秕子", "	bi3	zi3",
		"秘鲁", "	bi4	lu3",
		"租子", "	zu1	zi3",
		"吗哪", "	ma3	na3",
		"余吾", "	yu2	wu2",
		"故都", "	gu4	du1",
		"伛偻", "	yu3	lv3",
		"稀薄", "	xi1	bo2",
		"没地", "	mo4	di4",
		"阿诺", "	a	nuo4",
		"戊子", "	wu4	zi3",
		"戏子", "	xi4	zi3",
		"戏曲", "	xi4	qu3",
		"没入", "	mo4	ru4",
		"自给", "	zi4	ji3",
		"摊儿", "	tan1	r",
		"圩日", "	xu1	ri4",
		"去得", "	qu4	de",
		"露茜", "	lu4	xi1",
		"撒子", "	sa1	zi3",
		"铺砌", "	pu1	qi4",
		"锞子", "	ke4	zi3",
		"嗳腐", "	ai4	fu3",
		"砝码", "	fa3	ma3",
		"达子", "	da2	zi3",
		"搭子", "	da1	zi3",
		"矮子", "	ai3	zi3",
		"博得", "	bo2	de",
		"卜居", "	bu3	ju1",
		"大佛", "	da4	fo2",
		"南无", "	na1	mo2",
		"答答", "	da1	da1",
		"噶嗒", "	ga2	ta4",
		"舞曲", "	wu3	qu3",
		"阿森", "	a	sen1",
		"破的", "	po4	di4",
		"咋呀", "	za3	ya1",
		"俟机", "	si4	ji1",
		"附和", "	fu4	he4",
		"卜课", "	bu3	ke4",
		"般若", "	bo1	re3",
		"得也", "	de	ye3",
		"杜塞", "	du4	se4",
		"阿伦", "	a	lun2",
		"坨儿", "	tuo2	r",
		"鞑子", "	da2	zi3",
		"阿斗", "	a1	dou3",
		"剂子", "	ji4	zi3",
		"菥蓂", "	xi1	mi4",
		"口哦", "	kou3	o4",
		"钜子", "	ju4	zi3",
		"墨子", "	mo4	zi3",
		"钩儿", "	gou1	r",
		"李子", "	li3	zi3",
		"塞责", "	se4	ze2",
		"锔子", "	ju1	zi3",
		"徒裼", "	tu2	xi1",
		"弥勒", "	mi2	le4",
		"塔扎", "	ta3	za1",
		"坯模", "	pi1	mu2",
		"百色", "	bo2	se4",
		"拉忽", "	la3	hu1",
		"役畜", "	yi4	xu4",
		"剌剌", "	la4	la4",
		"砬子", "	la2	zi3",
		"劲儿", "	jin4	r",
		"铺叙", "	pu1	xu4",
		"铺子", "	pu4	zi3",
		"卜骨", "	bu3	gu3",
		"勒马", "	le4	ma3",
		"科克", "	ke1	ke4",
		"雨子", "	yu3	zi3",
		"得气", "	de	qi4",
		"姓曾", "	xing4	zeng1",
		"阿附", "	e1	fu4",
		"壳儿", "	ke2	r",
		"理儿", "	li3	r",
		"尜儿", "	ga2	r",
		"啊哟", "	a1	yo1",
		"挨饿", "	ai2	e4",
		"皮儿", "	pi2	r",
		"啊呀", "	a1	ya1",
		"阿里", "	a	li3",
		"曾姓", "	zeng1	xing4",
		"肚儿", "	du3	r",
		"杂沓", "	za2	ta4",
		"辱没", "	ru3	mo4",
		"集子", "	ji2	zi3",
		"呕气", "	ou4	qi4",
		"嗣子", "	si4	zi3",
		"曾家", "	zeng1	jia1",
		"嘀嗒", "	di1	da1",
		"呕吐", "	ou3	tu4",
		"嘎啦", "	ga1	la1",
		"呜咽", "	wu1	ye4",
		"子儿", "	zi3	r",
		"嗯啊", "	ng	a1",
		"鹿子", "	lu4	zi3",
		"啊哈", "	a1	ha1",
		"阿耶", "	a1	ye1",
		"吖吖", "	a1	a1",
		"阿苏", "	a	su1",
		"囮子", "	e2	zi3",
		"阿瑟", "	a	se4",
		"阿佤", "	a	wa3",
		"呃呃", "	e	e㐀",
		"巴阿", "	ba1	a",
		"腌臜", "	a1	za1",
		"阿比", "	e1	bi3",
		"抹额", "	mo4	e2",
		"末儿", "	mo4	r",
		"阿的", "	a1	di4",
		"阿巴", "	a	ba1",
		"阿坝", "	a	ba4",
		"阿堵", "	e1	du3",
		"便宜", "	pian2	yi2",
		"阿卡", "	a	ka3",
		"哦呀", "	o4	ya1",
		"阿谀", "	e1	yu2",
		"地儿", "	di4	r",
		"磨子", "	mo4	zi3",
		"碌曲", "	lu4	qu3",
		"离子", "	li2	zi3",
		"哑子", "	ya3	zi3",
		"玉佛", "	yu4	fo2",
		"卧佛", "	wo4	fo2",
		"欲得", "	yu4	de",
		"沵迤", "	mi3	yi3",
		"谜子", "	mi2	zi3",
		"靶子", "	ba3	zi3",
		"喜子", "	xi3	zi3",
		"胆儿", "	dan3	r",
		"腻子", "	ni4	zi3",
		"曲谱", "	qu3	pu3",
		"靡靡", "	mi3	mi3",
		"扶掖", "	fu2	ye4",
		"莫得", "	mo4	de",
		"栖息", "	qi1	xi1",
		"冒顿", "	mo4	du2",
		"靺鞨", "	mo4	he2",
		"把儿", "	ba4	er",
		"预卜", "	yu4	bu3",
		"麻麻", "	ma1	mɑ",
		"革吉", "	ge2	ji2",
		"姁姁", "	xu1	xu1",
		"浴佛", "	yu4	fo2",
		"屈子", "	qu1	zi3",
		"恶煞", "	e4	sha4",
		"孺子", "	ru2	zi3",
		"嗳气", "	ai4	qi4",
		"恶心", "	e3	xin1",
		"恶嗪", "	e3	qin2",
		"瘄子", "	cu4	zi3",
		"粗呢", "	cu1	ni2",
		"撒布", "	sa3	bu4",
		"刺啦", "	ci1	la1",
		"爱子", "	ai4	zi3",
		"入子", "	ru4	zi3",
		"垆坶", "	lu2	mu4",
		"呲牙", "	zi1	ya2",
		"靡丽", "	mi3	li4",
		"词曲", "	ci2	qu3",
		"磨叽", "	mo4	ji",
		"卤子", "	lu3	zi3",
		"乳女", "	ru3	nv3",
		"码子", "	ma3	zi3",
		"麻秸", "	ma2	ji2",
		"玉子", "	yu4	zi3",
		"秃子", "	tu1	zi3",
		"虚子", "	xu1	zi3",
		"扒犁", "	pa2	li",
		"得死", "	de	si3",
		"得理", "	de	li3",
		"不敷", "	bu4	fu1",
		"拘泥", "	ju1	ni4",
		"马勒", "	ma3	le4",
		"马子", "	ma3	zi3",
		"篦子", "	bi4	zi3",
		"马尾", "	ma3	yi3",
		"餔子", "	bu1	zi3",
		"布子", "	bu4	zi3",
		"堡子", "	bu3	zi",
		"补子", "	bu3	zi3",
		"丫子", "	ya1	zi3",
		"哈佛", "	ha1	fo2",
		"米芾", "	mi3	fu2",
		"驹子", "	ju1	zi3",
		"哇哇", "	wa1	wa1",
		"脊骨", "	ji3	gu3",
		"部曲", "	bu4	qu3",
		"哎呀", "	ai1	ya1",
		"箕子", "	ji1	zi3",
		"把子", "	ba4	zi",
		"曲裾", "	qu3	ju1",
		"莫邪", "	mo4	ye2",
		"壳子", "	ke2	zi3",
		"哑哑", "	ya1	ya1",
		"呀呀", "	ya1	ya1",
		"木模", "	mu4	mu2",
		"意得", "	yi4	de",
		"吧嗒", "	ba1	da1",
		"坝子", "	ba4	zi3",
		"吧唧", "	ba1	ji1",
		"一发", "	yi1	fa4",
		"七佛", "	qi1	fo2",
		"耳子", "	er3	zi3",
		"七个", "	qi1	ge",
		"吖嗪", "	a1	qin2",
		"佛寺", "	fo2	si4",
		"一得", "	yi1	de",
		"拨刺", "	bo1	ci1",
		"耙子", "	pa2	zi3",
		"吟哦", "	yin2	e2",
		"磨墨", "	mo2	mo4",
		"魣鱼", "	yu2	yu2",
		"婢子", "	bi4	zi3",
		"哈达", "	ha3	da2",
		"哈迪", "	ha3	di2",
		"拨子", "	bo1	zi3",
		"簸箕", "	bo4	ji",
		"簿子", "	bu4	zi3",
		"牟尼", "	mu4	ni2",
		"披靡", "	pi1	mi3",
		"似核", "	si4	he2",
		"肚子", "	du3	zi",
		"可恶", "	ke3	wu4",
		"移易", "	yi2	yi4",
		"胡子", "	hu2	zi3",
		"仡仡", "	yi4	yi4",
		"给予", "	ji3	yu3",
		"鱼子", "	yu2	zi3",
		"挨打", "	ai2	da3",
		"挨批", "	ai2	pi1",
		"咿呀", "	yi1	ya1",
		"挨挤", "	ai2	ji3",
		"郁塞", "	yu4	se4",
		"丝柏", "	si1	bo2",
		"鱼肚", "	yu2	du3",
		"挨骂", "	ai2	ma4",
		"移译", "	yi2	yi4",
		"糊糊", "	hu1	hu1",
		"发髻", "	fa4	ji4",
		"咖哩", "	ka1	li",
		"哀子", "	ai1	zi3",
		"糢糊", "	mo2	hu",
		"古都", "	gu3	du1",
		"披发", "	pi1	fa4",
		"须发", "	xu1	fa4",
		"曲剧", "	qu3	ju4",
		"播撒", "	bo1	sa3",
		"木子", "	mu4	zi3",
		"抹布", "	ma1	bu4",
		"哥哥", "	ge1	ge",
		"那得", "	na4	de",
		"梨子", "	li2	zi3",
		"衲子", "	na4	zi3",
		"曲辞", "	qu3	ci2",
		"嗳哟", "	ai4	yo1",
		"筏子", "	fa2	zi3",
		"答理", "	da1	li3",
		"策勒", "	ce4	le4",
		"佛语", "	fo2	yu3",
		"脯子", "	pu2	zi3",
		"取得", "	qu3	de",
		"曲度", "	qu3	du4",
		"箅子", "	bi4	zi3",
		"驴子", "	lv2	zi3",
		"不落", "	bu4	la4",
		"翼子", "	yi4	zi3",
		"胰子", "	yi2	zi3",
		"义子", "	yi4	zi3",
		"须子", "	xu1	zi3",
		"吧女", "	ba1	nv3",
		"一个", "	yi2	ge4",
		"乙巳", "	yi3	si4",
		"仆妇", "	pu2	fu4",
		"昳丽", "	yi4	li4",
		"麻力", "	ma2	li",
		"呢子", "	ni2	zi3",
		"伢子", "	ya2	zi3",
		"伯伯", "	bo2	bo",
		"摩撒", "	ma1	sa",
		"伯都", "	bo2	du1",
		"估衣", "	gu4	yi1",
		"摩挲", "	ma1	sa1",
		"吴子", "	wu2	zi3",
		"吽牙", "	ou1	ya2",
		"耶鲁", "	ye1	lu3",
		"仆仆", "	pu2	pu2",
		"合子", "	he2	zi3",
		"泼剌", "	po1	la4",
		"伺服", "	si4	fu2",
		"鹿谷", "	lu4	gu3",
		"鹄的", "	gu3	di4",
		"以撒", "	yi3	sa3",
		"格勒", "	ge2	le4",
		"坯子", "	pi1	zi3",
		"继子", "	ji4	zi3",
		"系泊", "	ji4	bo2",
		"佛祖", "	fo2	zu3",
		"阻塞", "	zu3	se4",
		"闭塞", "	bi4	se4",
		"丽都", "	li4	du1",
		"的卡", "	di2	ka3",
		"礼佛", "	li3	fo2",
		"乐子", "	le4	zi3",
		"得度", "	de	du4",
		"得得", "	de	de",
		"地堡", "	di4	pu4",
		"俚曲", "	li3	qu3",
		"阿丹", "	a	dan1",
		"摸吧", "	mo1	ba1",
		"里子", "	li3	zi3",
		"德都", "	de2	du1",
		"阿来", "	a	lai2",
		"得地", "	de	di4",
		"壶子", "	hu2	zi3",
		"抹子", "	mo3	zi3",
		"棋子", "	qi2	zi3",
		"核子", "	he2	zi3",
		"核儿", "	hu2	er2",
		"呢呢", "	ni2	ni2",
		"貔子", "	pi2	zi3",
		"碧波", "	bi4	bo1",
		"耶稣", "	ye1	su1",
		"野葛", "	ye3	ge3",
		"鞍子", "	an1	zi3",
		"巴子", "	ba1	zi3",
		"安子", "	an1	zi3",
		"弃子", "	qi4	zi3",
		"揦子", "	la2	zi3",
		"衣被", "	yi4	pi1",
		"页子", "	ye4	zi3",
		"耶耶", "	ye1	ye1",
		"也得", "	ye3	de",
		"也似", "	ye3	si4",
		"埯子", "	an3	zi3",
		"耶律", "	ye1	lv4",
		"七子", "	qi1	zi3",
		"掖咕", "	ye1	gu",
		"伽马", "	ga1	ma3",
		"八子", "	ba1	zi3",
		"仆射", "	pu2	ye4",
		"伺机", "	si4	ji1",
		"伺隙", "	si4	xi4",
		"似乎", "	si4	hu1",
		"耶西", "	ye1	xi1",
		"庵子", "	an1	zi3",
		"挨罚", "	ai2	fa2",
		"佛牙", "	fo2	ya2",
		"呵喝", "	he1	he4",
		"一似", "	yi1	si4",
		"呼吁", "	hu1	yu4",
		"佛爷", "	fo2	ye2",
		"味儿", "	wei4	r",
		"呵责", "	he1	ze2",
		"呵护", "	he1	hu4",
		"鮨科", "	qi2	ke1",
		"凫茈", "	fu2	zi3",
		"鸭子", "	ya1	zi3",
		"佛法", "	fo2	fa3",
		"一曲", "	yi1	qu3",
		"佛塔", "	fo2	ta3",
		"呵呵", "	he1	he1",
		"呼喝", "	hu1	he4",
		"婢仆", "	bi4	pu2",
		"耶酥", "	ye1	su1",
		"吐蕃", "	tu3	bo1",
		"吐沫", "	tu4	mo4",
		"吉勒", "	ji2	le4",
		"栖宿", "	qi1	su4",
		"搭拉", "	da1	la",
		"吧吧", "	ba1	ba1",
		"游子", "	you2	zi3",
		"射的", "	she4	di4",
		"琢磨", "	zuo2	mo",
		"打杈", "	da3	cha4",
		"哪吒", "	ne2	zha1",
		"没世", "	mo4	shi4",
		"抹灰", "	mo4	hui1",
		"磨粉", "	mo4	fen3",
		"批假", "	pi1	jia4",
		"难挨", "	nan2	ai2",
		"扳子", "	ban1	zi3",
		"啦呱", "	la1	gua",
		"喀什", "	ka1	shi2",
		"泯没", "	min3	mo4",
		"柰子", "	nai4	zi3",
		"打折", "	da3	she2",
		"喀嚓", "	ka1	cha1",
		"缪斯", "	miu4	si1",
		"菜子", "	cai4	zi3",
		"难弟", "	nan4	di4",
		"哪个", "	nei3	ge4",
		"穇子", "	can3	zi3",
		"拉杆", "	la1	gan3",
		"槽子", "	cao2	zi3",
		"艚子", "	cao2	zi3",
		"押解", "	ya1	jie4",
		"内子", "	nei4	zi3",
		"南子", "	nan2	zi3",
		"咳痰", "	ke2	tan2",
		"拓扑", "	tuo4	pu1",
		"委蛇", "	wei1	yi2",
		"哇靠", "	wa1	kao4",
		"拓拔", "	tuo4	ba2",
		"不究", "	bu4	jiu4",
		"补假", "	bu3	jia4",
		"咱家", "	za2	jia1",
		"潘子", "	pan1	zi3",
		"咳嗽", "	ke2	sou4",
		"剥取", "	bao1	qu3",
		"彩子", "	cai3	zi3",
		"拾级", "	she4	ji2",
		"不价", "	bu4	jie",
		"啪嚓", "	pa1	cha1",
		"怒号", "	nu4	hao2",
		"不倒", "	bu4	dao3",
		"拶子", "	zan3	zi3",
		"牛子", "	niu2	zi3",
		"妞子", "	niu1	zi3",
		"不处", "	bu4	chu3",
		"咯嚓", "	ge1	cha1",
		"拉呱", "	la1	gua1",
		"抿子", "	min3	zi3",
		"拓跋", "	tuo4	ba2",
		"八斗", "	ba1	dou3",
		"绊子", "	ban4	zi3",
		"剥壳", "	bao1	ke2",
		"吧托", "	ba1	tuo1",
		"吞没", "	tun1	mo4",
		"名儿", "	ming2	r",
		"卡壳", "	qia3	ke2",
		"卡具", "	qia3	ju4",
		"熬菜", "	ao1	cai4",
		"凄咽", "	qi1	yan1",
		"吧台", "	ba1	tai2",
		"柈子", "	ban4	zi3",
		"八舍", "	ba1	she4",
		"插曲", "	cha1	qu3",
		"提溜", "	di1	liu1",
		"起解", "	qi3	jie4",
		"吖啶", "	a1	ding4",
		"君子", "	jun1	zi3",
		"推子", "	tui1	zi3",
		"七煞", "	qi1	sha4",
		"炮子", "	pao4	zi3",
		"扫把", "	sao4	ba3",
		"朴刀", "	po1	dao1",
		"半子", "	ban4	zi3",
		"差可", "	cha1	ke3",
		"配曲", "	pei4	qu3",
		"南曲", "	nan2	qu3",
		"男仆", "	nan2	pu2",
		"杈子", "	cha1	zi3",
		"汊子", "	cha4	zi3",
		"拉倒", "	la1	dao3",
		"拂士", "	bi4	shi4",
		"查理", "	cha2	li3",
		"车毂", "	che1	gu1",
		"炮格", "	pao2	ge2",
		"采邑", "	cai4	yi4",
		"酦醅", "	po1	pei1",
		"掖门", "	ye4	men2",
		"百子", "	bai3	zi3",
		"含糊", "	han2	hu",
		"稗子", "	bai4	zi3",
		"败子", "	bai4	zi3",
		"吸尽", "	xi1	jin4",
		"探子", "	tan4	zi3",
		"版子", "	ban3	zi3",
		"吸血", "	xi1	xie3",
		"陂陀", "	po1	tuo2",
		"呢帽", "	ni2	mao4",
		"拖沓", "	tuo1	ta4",
		"披散", "	pi1	san3",
		"干礼", "	gan1	li3",
		"干租", "	gan1	zu1",
		"套子", "	tao4	zi3",
		"昆曲", "	kun1	qu3",
		"岔子", "	cha4	zi3",
		"套曲", "	tao4	qu3",
		"屯子", "	tun2	zi3",
		"秆子", "	gan3	zi3",
		"奥什", "	ao4	shi2",
		"奇数", "	ji1	shu4",
		"赴难", "	fu4	nan4",
		"干子", "	gan4	zi3",
		"差异", "	cha1	yi4",
		"失意", "	shi1	yi4",
		"附载", "	fu4	zai3",
		"附识", "	fu4	zhi4",
		"夹克", "	jia2	ke4",
		"干没", "	gan1	mo4",
		"干碍", "	gan1	ai4",
		"干巴", "	gan1	ba1",
		"巨著", "	ju4	zhu4",
		"杆儿", "	gan3	er2",
		"甘子", "	gan1	zi3",
		"柑子", "	gan1	zi3",
		"干急", "	gan1	ji2",
		"子时", "	zi3	shi2",
		"蒿子", "	hao1	zi3",
		"宿舍", "	su4	she4",
		"宿分", "	su4	fen4",
		"家子", "	jia1	zi3",
		"家姑", "	jia1	gu1",
		"荷载", "	he4	zai3",
		"害得", "	hai4	de",
		"子弹", "	zi3	dan4",
		"和诗", "	he4	shi1",
		"子曰", "	zi3	yue1",
		"干谒", "	gan1	ye4",
		"何为", "	he2	wei2",
		"喝问", "	he4	wen4",
		"子实", "	zi3	shi2",
		"差距", "	cha1	ju4",
		"鸡舍", "	ji1	she4",
		"呱哒", "	gua1	da1",
		"干呕", "	gan1	ou3",
		"干热", "	gan1	re4",
		"杆塔", "	gan3	ta3",
		"赶圩", "	gan3	xu1",
		"干股", "	gan1	gu3",
		"干季", "	gan1	ji4",
		"拗口", "	ao4	kou3",
		"暗查", "	an4	cha2",
		"割切", "	ge1	qie1",
		"夹衣", "	jia2	yi1",
		"给回", "	ji3	hui2",
		"居处", "	ju1	chu3",
		"奶子", "	nai3	zi3",
		"好似", "	hao3	si4",
		"好哇", "	hao3	wa1",
		"尾子", "	wei3	zi3",
		"蛤仔", "	ge2	zai3",
		"络子", "	lao4	zi",
		"圪节", "	ge1	jie1",
		"尧都", "	yao2	du1",
		"哀乐", "	ai1	yue4",
		"拮据", "	jie2	ju1",
		"哀号", "	ai1	hao2",
		"拜佛", "	bai4	fo2",
		"臬兀", "	nie4	wu1",
		"哇噻", "	wa1	sai1",
		"哇塞", "	wa1	sai1",
		"牛肚", "	niu2	du3",
		"不为", "	bu4	wei2",
		"夺得", "	duo2	de",
		"歌呗", "	ge1	bai4",
		"夹袄", "	jia2	ao3",
		"狗子", "	gou3	zi3",
		"呱唧", "	gua1	ji1",
		"属意", "	zhu3	yi4",
		"羔子", "	gao1	zi3",
		"家仆", "	jia1	pu2",
		"购得", "	gou4	de",
		"狗脊", "	gou3	ji3",
		"枸橘", "	gou1	ju2",
		"好色", "	hao4	se4",
		"夹布", "	jia2	bu4",
		"好恶", "	hao4	wu4",
		"贾祸", "	gu3	huo4",
		"篙子", "	gao1	zi3",
		"锢露", "	gu4	lou4",
		"贾人", "	gu3	ren2",
		"鼓乐", "	gu3	yue4",
		"妃子", "	fei1	zi3",
		"呱嗒", "	gua1	da1",
		"沟子", "	gou1	zi3",
		"膏泽", "	gao4	ze2",
		"好客", "	hao4	ke4",
		"好奇", "	hao4	qi2",
		"膏子", "	gao1	zi3",
		"宝子", "	bao3	zi3",
		"挨揍", "	ai2	zou4",
		"黑子", "	hei1	zi3",
		"扎染", "	za1	ran3",
		"打倒", "	da3	dao3",
		"扒糕", "	pa2	gao1",
		"喝彩", "	he4	cai3",
		"喝道", "	he4	dao4",
		"闷气", "	men1	qi4",
		"喝采", "	he4	cai3",
		"宓妃", "	fu2	fei1",
		"扒灰", "	pa2	hui1",
		"扒搂", "	ba1	lou1",
		"才子", "	cai2	zi3",
		"咪唑", "	mi3	zuo4",
		"痴子", "	chi1	zi3",
		"扒窃", "	pa2	qie4",
		"喷薄", "	pen1	bo2",
		"吗啡", "	ma3	fei1",
		"处和", "	chu3	he2",
		"庐舍", "	lu2	she4",
		"路卡", "	lu4	qia3",
		"虏掠", "	lu3	lue3",
		"嘴子", "	zui3	zi3",
		"爱好", "	ai4	hao4",
		"秘钥", "	mi4	yue4",
		"匙子", "	chi2	zi",
		"陆处", "	lu4	chu3",
		"煤核", "	mei2	hu2",
		"得靠", "	de	kao4",
		"微薄", "	wei1	bo2",
		"喜好", "	xi3	hao4",
		"闷热", "	men1	re4",
		"喷子", "	pen1	zi3",
		"媒子", "	mei2	zi3",
		"糜子", "	mei2	zi3",
		"戽斗", "	hu4	dou3",
		"戒子", "	jie4	zi3",
		"懒得", "	lan3	de",
		"所得", "	suo3	de",
		"门把", "	men2	ba4",
		"没得", "	mei2	de",
		"毛呢", "	mao2	ni2",
		"单个", "	dan1	ge",
		"锚泊", "	mao2	bo2",
		"满子", "	man3	zi3",
		"单曲", "	dan1	qu3",
		"嫚骂", "	man4	ma4",
		"毛子", "	mao2	zi3",
		"单薄", "	dan1	bo2",
		"猝倒", "	cu4	dao3",
		"篓子", "	lou3	zi3",
		"力尽", "	li4	jin4",
		"不尽", "	bu4	jin4",
		"制曲", "	zhi4	qu3",
		"空额", "	kong4	e2",
		"不会", "	bu2	hui4",
		"枝子", "	zhi1	zi3",
		"朱子", "	zhu1	zi3",
		"甲子", "	jia3	zi3",
		"不是", "	bu2	shi4",
		"只鸡", "	zhi1	ji1",
		"男子", "	nan2	zi3",
		"款儿", "	kuan3	r",
		"果脯", "	guo3	fu3",
		"幼子", "	you4	zi3",
		"不禁", "	bu4	jin1",
		"倒卧", "	dao3	wo4",
		"优子", "	you1	zi3",
		"留都", "	liu2	du1",
		"只如", "	zhi1	ru2",
		"枯萎", "	ku1	wei3",
		"著录", "	zhu4	lu4",
		"臊气", "	sao4	qi4",
		"卧倒", "	wo4	dao3",
		"自尽", "	zi4	jin4",
		"勒戒", "	le4	jie4",
		"恶少", "	e4	shao4",
		"马仔", "	ma3	zai3",
		"绺子", "	liu3	zi3",
		"溜子", "	liu1	zi3",
		"六子", "	liu4	zi3",
		"情儿", "	qing2	r",
		"漏子", "	lou4	zi3",
		"嗑药", "	ke4	yao4",
		"唠嗑", "	lao4	ke4",
		"哗啦", "	hua1	la1",
		"马扎", "	ma3	zha2",
		"抹澡", "	ma1	zao3",
		"马杆", "	ma3	gan3",
		"蚕子", "	can2	zi3",
		"麻杆", "	ma2	gan3",
		"滀仕", "	xu4	shi4",
		"刺溜", "	ci1	liu1",
		"雏子", "	chu2	zi3",
		"落发", "	luo4	fa4",
		"憨子", "	han1	zi3",
		"掠地", "	lue3	di4",
		"恺撒", "	kai3	sa3",
		"恺弟", "	kai3	ti4",
		"处子", "	chu3	zi3",
		"得对", "	de	dui4",
		"地处", "	di4	chu3",
		"咋舌", "	ze2	she2",
		"恨恶", "	hen4	wu4",
		"贝子", "	bei4	zi3",
		"褙子", "	bei4	zi3",
		"背子", "	bei1	zi",
		"锛子", "	ben1	zi3",
		"北曲", "	bei3	qu3",
		"底处", "	di3	chu3",
		"车仆", "	che1	pu2",
		"喜帖", "	xi3	tie3",
		"大说", "	da4	yue4",
		"答允", "	da1	yun3",
		"呵禁", "	he1	jin4",
		"待得", "	dai4	de",
		"赕佛", "	dan3	fo2",
		"恁么", "	ren4	me",
		"急难", "	ji2	nan4",
		"恰似", "	qia4	si4",
		"蛋子", "	dan4	zi3",
		"刀把", "	dao1	ba4",
		"回鹘", "	hui2	hu2",
		"因子", "	yin1	zi3",
		"到得", "	dao4	de",
		"捏脊", "	nie1	ji3",
		"贝勒", "	bei4	le4",
		"囤积", "	tun2	ji1",
		"喷撒", "	pen1	sa3",
		"挨宰", "	ai2	zai3",
		"和洽", "	he2	qia4",
		"芘芣", "	pi2	fou3",
		"和牌", "	hu2	pai2",
		"咋呼", "	zha1	hu1",
		"挨克", "	ai2	kei1",
		"膍胵", "	pi2	zhi4",
		"瘪子", "	bie3	zi3",
		"别子", "	bie2	zi3",
		"胚子", "	pei1	zi3",
		"挨斗", "	ai2	dou4",
		"咔嚓", "	ka1	cha1",
		"僻处", "	pi4	chu3",
		"呢喃", "	ni2	nan2",
		"鼻血", "	bi2	xie3",
		"呼号", "	hu1	hao2",
		"保子", "	bao3	zi3",
		"挨延", "	ai2	yan2",
		"呵叱", "	he1	chi4",
		"舍得", "	she4	de",
		"呵斥", "	he1	chi4",
		"倒底", "	dao3	di3",
		"回纥", "	hui2	he2",
		"地窨", "	di4	yin4",
		"叨咕", "	dao2	gu",
		"得时", "	de	shi2",
		"肋膜", "	lei4	mo2",
		"勒掯", "	le4	ken4",
		"得使", "	de	shi3",
		"累及", "	lei3	ji2",
		"累次", "	lei3	ci4",
		"勒石", "	le4	shi2",
		"勒派", "	le4	pai4",
		"埋没", "	mai2	mo4",
		"坎子", "	kan3	zi3",
		"檑木", "	lei4	mu4",
		"得来", "	de	lai2",
		"必得", "	bi4	dei3",
		"德干", "	de2	gan1",
		"土著", "	tu3	zhu4",
		"礼乐", "	li3	yue4",
		"倒牙", "	dao3	ya2",
		"在乎", "	zai4	hu",
		"坋粒", "	fen4	li4",
		"礼帖", "	li3	tie3",
		"道子", "	dao4	zi3",
		"肋木", "	lei4	mu4",
		"得这", "	de	zhe4",
		"倒阁", "	dao3	ge2",
		"吓唬", "	xia4	hu",
		"淋滤", "	lin4	lv4",
		"大溜", "	da4	liu4",
		"遛马", "	liu4	ma3",
		"六路", "	liu4	lu4",
		"锉子", "	cuo4	zi3",
		"瘩背", "	da2	bei4",
		"答茬", "	da1	cha2",
		"六个", "	liu4	ge",
		"大落", "	da4	luo1",
		"噶厦", "	ga2	xia4",
		"大哗", "	da4	hua2",
		"得月", "	de	yue4",
		"大尽", "	da4	jin4",
		"檩子", "	lin3	zi3",
		"悉数", "	xi1	shu3",
		"打擂", "	da3	lei4",
		"大斗", "	da4	dou3",
		"矬子", "	cuo2	zi3",
		"国都", "	guo2	du1",
		"得数", "	de	shu4",
		"得位", "	de	wei4",
		"坨子", "	tuo2	zi3",
		"会得", "	hui4	de",
		"子孙", "	zi3	sun1",
		"折辱", "	she2	ru3",
		"叔子", "	shu1	zi3",
		"铁耙", "	tie3	pa2",
		"谩骂", "	man4	ma4",
		"识得", "	shi2	de",
		"馓子", "	san3	zi3",
		"余干", "	yu2	gan1",
		"余切", "	yu2	qie1",
		"饿莩", "	e4	piao3",
		"誉为", "	yu4	wei2",
		"出没", "	chu1	mo4",
		"责难", "	ze2	nan4",
		"贩子", "	fan4	zi3",
		"食肆", "	shi2	si4",
		"类似", "	lei4	si4",
		"击倒", "	ji1	dao3",
		"秋子", "	qiu1	zi3",
		"球子", "	qiu2	zi3",
		"豁达", "	huo4	da2",
		"曲包", "	qu3	bao1",
		"颓靡", "	tui2	mi3",
		"豆皀", "	dou4	bi1",
		"曲池", "	qu3	chi2",
		"谜儿", "	mei4	er2",
		"贴吧", "	tie1	ba1",
		"出落", "	chu1	la4",
		"参与", "	can1	yu4",
		"赤子", "	chi4	zi3",
		"曲牌", "	qu3	pai2",
		"书脊", "	shu1	ji3",
		"走子", "	zou3	zi3",
		"头儿", "	tou	er",
		"颇为", "	po1	wei2",
		"曲式", "	qu3	shi4",
		"担搁", "	dan1	ge",
		"贲临", "	bi4	lin2",
		"担荷", "	dan1	he4",
		"参差", "	cen1	ci1",
		"树子", "	shu4	zi3",
		"擘划", "	bo4	hua4",
		"擘画", "	bo4	hua4",
		"擘开", "	bo4	kai1",
		"屈折", "	qu1	she2",
		"跂坐", "	qi4	zuo4",
		"擦干", "	ca1	gan1",
		"摆子", "	bai3	zi3",
		"鞋子", "	xie2	zi3",
		"曲坛", "	qu3	tan2",
		"貌似", "	mao4	si4",
		"扑倒", "	pu1	dao3",
		"担子", "	dan4	zi",
		"厌恶", "	yan4	wu4",
		"陪都", "	pei2	du1",
		"切腹", "	qie1	fu4",
		"印子", "	yin4	zi3",
		"即为", "	ji2	wei2",
		"踏实", "	ta1	shi",
		"踏查", "	ta4	cha2",
		"厌薄", "	yan4	bo2",
		"踶跂", "	di4	zhi1",
		"群子", "	qun2	zi3",
		"蹦儿", "	beng4	r",
		"若夫", "	ruo4	fu2",
		"切入", "	qie1	ru4",
		"热和", "	re4	huo",
		"摊薄", "	tan1	bo2",
		"轧机", "	zha2	ji1",
		"陶子", "	tao2	zi3",
		"热轧", "	re4	zha2",
		"切割", "	qie1	ge1",
		"露底", "	lou4	di3",
		"切勿", "	qie1	wu4",
		"露富", "	lou4	fu4",
		"划子", "	hua2	zi3",
		"散发", "	san4	fa4",
		"除子", "	chu2	zi3",
		"卡子", "	qia3	zi",
		"踅摸", "	xue2	mo",
		"面儿", "	mian4	r",
		"载入", "	zai3	ru4",
		"载籍", "	zai3	ji2",
		"鸡肋", "	ji1	lei4",
		"散居", "	san3	ju1",
		"隽誉", "	jun4	yu4",
		"载荷", "	zai4	he4",
		"隽语", "	jun4	yu3",
		"儒艮", "	ru2	gen4",
		"近似", "	jin4	si4",
		"雅乐", "	ya3	yue4",
		"雅什", "	ya3	shi2",
		"隐没", "	yin3	mo4",
		"日晕", "	ri4	yun4",
		"切牙", "	qie1	ya2",
		"轗轲", "	kan3	ke3",
		"散曲", "	san3	qu3",
		"辟邪", "	bi4	xie2",
		"贪得", "	tan1	de",
		"乳臭", "	ru3	xiu4",
		"质子", "	zhi4	zi3",
		"头发", "	tou2	fa4",
		"任子", "	ren4	zi3",
		"阿盟", "	a	meng2",
		"划拉", "	hua2	la1",
		"这末", "	zhe4	me",
		"阿明", "	a	ming2",
		"穗子", "	sui4	zi3",
		"这麽", "	zhe4	me",
		"卜问", "	bu3	wen4",
		"卜卦", "	bu3	gua4",
		"阿莲", "	a	lian2",
		"阿胶", "	e1	jiao1",
		"博白", "	bo2	bai2",
		"锁子", "	suo3	zi3",
		"色晕", "	se4	yun4",
		"逮捕", "	dai4	bu3",
		"杉木", "	sha1	mu4",
		"痧子", "	sha1	zi3",
		"三曲", "	san1	qu3",
		"胎发", "	tai1	fa4",
		"斗笠", "	dou3	li4",
		"勾勒", "	gou1	le4",
		"削发", "	xue1	fa4",
		"配子", "	pei4	zi3",
		"散记", "	san3	ji4",
		"索子", "	suo3	zi3",
		"铺排", "	pu1	pai2",
		"包扎", "	bao1	za1",
		"俗乐", "	su2	yue4",
		"违拗", "	wei2	ao4",
		"递解", "	di4	jie4",
		"区处", "	qu1	chu3",
		"数伏", "	shu3	fu2",
		"化子", "	hua1	zi",
		"文蛤", "	wen2	ge2",
		"包袱", "	bao1	fu2",
		"遗著", "	yi2	zhu4",
		"刨子", "	bao4	zi3",
		"三个", "	san1	ge",
		"避难", "	bi4	nan4",
		"门子", "	men2	zi3",
		"斗大", "	dou3	da4",
		"阿扁", "	a	bian3",
		"散体", "	san3	ti3",
		"卜筮", "	bu3	shi4",
		"嗒然", "	ta4	ran2",
		"阘懦", "	ta4	nuo4",
		"卜甲", "	bu3	jia3",
		"他处", "	ta1	chu3",
		"铺摆", "	pu1	bai3",
		"食邑", "	shi2	yi4",
		"卖卜", "	mai4	bu3",
		"日头", "	ri4	tou",
		"那是", "	na4	shi",
		"那知", "	na3	zhi1",
		"旄期", "	mao4	qi1",
		"旅舍", "	lv3	she4",
		"孕吐", "	yun4	tu4",
		"什物", "	shi2	wu4",
		"是得", "	shi4	de",
		"石堤", "	shi2	di1",
		"都匀", "	du1	yun2",
		"识记", "	zhi4	ji4",
		"凿子", "	zao2	zi3",
		"錾子", "	zan4	zi3",
		"都尉", "	du1	wei4",
		"镏子", "	liu4	zi3",
		"都市", "	du1	shi4",
		"铺轨", "	pu1	gui3",
		"铺设", "	pu1	she4",
		"部分", "	bu4	fen4",
		"贴子", "	tie1	zi3",
		"撒施", "	sa3	shi1",
		"撒花", "	sa3	hua1",
		"旄倪", "	mao4	ni2",
		"勒索", "	le4	suo3",
		"配给", "	pei4	ji3",
		"昧没", "	mei4	mo4",
		"石子", "	shi2	zi3",
		"酒吧", "	jiu3	ba1",
		"世子", "	shi4	zi3",
		"释子", "	shi4	zi3",
		"刹那", "	cha4	na4",
		"剥皮", "	bao1	pi2",
		"铺摊", "	pu1	tan",
		"金发", "	jin1	fa4",
		"劈叉", "	pi3	cha4",
		"划破", "	hua2	po4",
		"黍子", "	shu3	zi3",
		"新都", "	xin1	du1",
		"竖子", "	shu4	zi3",
		"晏子", "	yan4	zi3",
		"普查", "	pu3	cha2",
		"晕乎", "	yun1	hu",
		"晕糊", "	yun1	hu",
		"力拓", "	li4	tuo4",
		"哀切", "	ai1	qie1",
		"都兰", "	du1	lan2",
		"铺盖", "	pu1	gai4",
		"肆掠", "	si4	lue3",
		"厚薄", "	hou4	bo2",
		"雹子", "	bao2	zi3",
		"子规", "	zi3	gui1",
		"兜子", "	dou1	zi3",
		"多得", "	duo1	de",
		"都试", "	du1	shi4",
		"铐子", "	kao4	zi3",
		"科处", "	ke1	chu3",
		"压板", "	ya4	ban3",
		"都下", "	du1	xia4",
		"咳血", "	ke2	xue4",
		"压根", "	ya4	gen1",
		"客舍", "	ke4	she4",
		"尻子", "	kao1	zi3",
		"多子", "	duo1	zi3",
		"斗子", "	dou3	zi",
		"篼子", "	dou1	zi3",
		"坷坎", "	ke1	kan3",
		"士子", "	shi4	zi3",
		"克尽", "	ke4	jin4",
		"刻划", "	ke4	hua2",
		"壬子", "	ren2	zi3",
		"痘子", "	dou4	zi3",
		"报子", "	bao4	zi3",
		"拂过", "	bi4	guo4",
		"恶寒", "	wu4	han2",
		"咯血", "	ka3	xie3",
		"国子", "	guo2	zi3",
		"斗渠", "	dou3	qu2",
		"堤围", "	di1	wei2",
		"落儿", "	lao4	er2",
		"得很", "	de	hen3",
		"塌实", "	ta1	shi",
		"塔刹", "	ta3	cha4",
		"来子", "	lai2	zi3",
		"赖子", "	lai4	zi3",
		"老佛", "	lao3	fo2",
		"阿房", "	e1	pang2",
		"都头", "	du1	tou2",
		"多哇", "	duo1	wa1",
		"靠泊", "	kao4	bo2",
		"引得", "	yin3	de",
		"引子", "	yin3	zi3",
		"墩子", "	dun1	zi3",
		"多佛", "	duo1	fo2",
		"看得", "	kan4	de",
		"砘子", "	dun4	zi3",
		"靠得", "	kao4	de",
		"式子", "	shi4	zi3",
		"多咱", "	duo1	za2",
		"诘责", "	jie2	ze2",
		"系带", "	ji4	dai4",
		"老仆", "	lao3	pu2",
		"孽子", "	nie4	zi3",
		"磙子", "	gun3	zi3",
		"极尽", "	ji2	jin4",
		"射干", "	ye4	gan1",
		"急煞", "	ji2	sha4",
		"会子", "	hui4	zi3",
		"毫子", "	hao2	zi3",
		"很子", "	hen3	zi3",
		"子爵", "	zi3	jue2",
		"安分", "	an1	fen4",
		"学摸", "	xue2	mo",
		"桂子", "	gui4	zi3",
		"学子", "	xue2	zi3",
		"子群", "	zi3	qun2",
		"子民", "	zi3	min2",
		"侯波", "	hou4	bo1",
		"厚朴", "	hou4	po4",
		"季肋", "	ji4	lei4",
		"子音", "	zi3	yin1",
		"胡为", "	hu2	wei2",
		"子鼠", "	zi3	shu3",
		"字帖", "	zi4	tie4",
		"辊子", "	gun3	zi3",
		"脊檩", "	ji3	lin3",
		"极处", "	ji2	chu3",
		"浑似", "	hun2	si4",
		"馃子", "	guo3	zi3",
		"哈什", "	ha4	shi2",
		"海曲", "	hai3	qu3",
		"宝坻", "	bao3	di3",
		"扞格", "	han4	ge2",
		"镬子", "	huo4	zi3",
		"耠子", "	huo1	zi3",
		"豁子", "	huo1	zi3",
		"娄子", "	lou2	zi3",
		"好古", "	hao4	gu3",
		"喊呀", "	han3	ya1",
		"贵子", "	gui4	zi3",
		"子代", "	zi3	dai4",
		"威吓", "	wei1	he4",
		"委靡", "	wei3	mi3",
		"对子", "	dui4	zi3",
		"寻的", "	xun2	di4",
		"妗子", "	jin4	zi3",
		"寻死", "	xin2	si3",
		"尉迟", "	yu4	chi2",
		"妹子", "	mei4	zi3",
		"姥爷", "	lao3	ye",
		"莱塞", "	lai2	se4",
		"老区", "	lao3	ou1",
		"体查", "	ti3	cha2",
		"法帖", "	fa3	tie4",
		"庶几", "	shu4	ji1",
		"庶子", "	shu4	zi3",
		"二舍", "	er4	she4",
		"发鬓", "	fa4	bin4",
		"座子", "	zuo4	zi3",
		"几微", "	ji1	wei1",
		"倔巴", "	jue4	ba1",
		"度假", "	du4	jia4",
		"庇荫", "	bi4	yin4",
		"发噱", "	fa1	xue2",
		"几至", "	ji1	zhi4",
		"几近", "	ji1	jin4",
		"发指", "	fa4	zhi3",
		"夥计", "	huo3	ji",
		"蹶子", "	jue2	zi3",
		"九曲", "	jiu3	qu3",
		"分得", "	fen1	de",
		"金铺", "	jin1	pu1",
		"太仆", "	tai4	pu2",
		"佛头", "	fo2	tou2",
		"太子", "	tai4	zi3",
		"橛子", "	jue2	zi3",
		"干吗", "	gan4	ma2",
		"佛心", "	fo2	xin1",
		"大夫", "	dai4	fu1",
		"切尼", "	qie1	ni2",
		"难得", "	nan2	de",
		"散剂", "	san3	ji4",
		"忍得", "	ren3	de",
		"叉子", "	cha1	zi3",
		"读为", "	du2	wei2",
		"安处", "	an1	chu3",
		"幡子", "	fan1	zi3",
		"干邑", "	gan1	yi4",
		"柜柳", "	ju3	liu3",
		"榧子", "	fei3	zi3",
		"菲薄", "	fei3	bo2",
		"凡子", "	fan2	zi3",
		"干与", "	gan1	yu4",
		"舅子", "	jiu4	zi3",
		"干戈", "	gan1	ge1",
		"大为", "	da4	wei2",
		"菲仪", "	fei3	yi2",
		"干系", "	gan1	xi4",
		"飞子", "	fei1	zi3",
		"九子", "	jiu3	zi3",
		"进给", "	jin4	ji3",
		"佛印", "	fo2	yin4",
		"得要", "	de	yao4",
		"弹子", "	dan4	zi3",
		"盔子", "	kui1	zi3",
		"铫子", "	yao2	zi3",
		"弹词", "	tan2	ci2",
		"塞语", "	sai4	yu3",
		"塞音", "	se4	yin1",
		"弹牙", "	tan2	ya2",
		"弯子", "	wan1	zi3",
		"胯子", "	kua4	zi3",
		"墨斗", "	mo4	dou3",
		"弹压", "	tan2	ya1",
		"杰子", "	jie2	zi3",
		"豆秸", "	dou4	ji2",
		"压倒", "	ya1	dao3",
		"弹劾", "	tan2	he2",
		"弹拨", "	tan2	bo1",
		"弹力", "	tan2	li4",
		"影儿", "	ying3	r",
		"癞子", "	lai4	zi3",
		"复查", "	fu4	cha2",
		"低徊", "	di1	hui2",
		"地煞", "	di4	sha4",
		"厨子", "	chu2	zi3",
		"巴斗", "	ba1	dou3",
		"佛事", "	fo2	shi4",
		"纷沓", "	fen1	ta4",
		"佛珠", "	fo2	zhu1",
		"褯子", "	jie4	zi3",
		"节子", "	jie1	zi3",
		"疖子", "	jie1	zi3",
		"芥子", "	jie4	zi3",
		"街子", "	jie1	zi3",
		"佛座", "	fo2	zuo4",
		"幔子", "	man4	zi3",
		"佛人", "	fo2	ren2",
		"佛老", "	fo2	lao3",
		"师傅", "	shi1	fu1",
		"佛界", "	fo2	jie4",
		"帖子", "	tie3	zi3",
		"大只", "	da4	zhi1",
		"大难", "	da4	nan4",
		"禁曲", "	jin4	qu3",
		"布什", "	bu4	shi2",
		"禁子", "	jin4	zi3",
		"天儿", "	tian1	r",
		"佛宝", "	fo2	bao3",
		"佛国", "	fo2	guo2",
		"佛化", "	fo2	hua4",
		"间隙", "	jian4	xi4",
		"圆晕", "	yuan2	yun4",
		"沈思", "	chen2	si1",
		"惩处", "	cheng2	chu3",
		"手缝", "	shou3	feng2",
		"蒙哄", "	meng2	hong3",
		"手卷", "	shou3	juan4",
		"上分", "	shang4	fen4",
		"靓妹", "	liang4	mei4",
		"上切", "	shang4	qie1",
		"升斗", "	sheng1	dou3",
		"门框", "	men2	kuang4",
		"重头", "	chong2	tou2",
		"丧葬", "	sang1	zang4",
		"阮元", "	ruan3	yuan2",
		"应点", "	ying4	dian3",
		"长号", "	chang2	hao4",
		"应酬", "	ying4	chou2",
		"投中", "	tou2	zhong4",
		"长门", "	chang2	men2",
		"音长", "	yin1	chang2",
		"长处", "	chang2	chu4",
		"长眉", "	chang2	mei2",
		"沈朴", "	shen3	piao2",
		"靓仔", "	liang4	zai3",
		"找着", "	zhao3	zhao2",
		"长毛", "	chang2	mao2",
		"阆苑", "	lang4	yuan4",
		"白相", "	bai2	xiang4",
		"重获", "	chong2	huo4",
		"耍横", "	shua3	heng4",
		"重版", "	chong2	ban3",
		"丧棒", "	sang1	bang4",
		"重出", "	chong2	chu1",
		"绕梁", "	rao3	liang2",
		"少康", "	shao4	kang1",
		"穰穰", "	rang3	rang3",
		"闷声", "	men1	sheng1",
		"杓棒", "	shao2	bang4",
		"间苗", "	jian4	miao2",
		"扁舟", "	pian1	zhou1",
		"间断", "	jian4	duan4",
		"少小", "	shao4	xiao3",
		"烧着", "	shao1	zhao2",
		"闲空", "	xian2	kong4",
		"戴上", "	dai4	shang",
		"长排", "	chang2	pai2",
		"扇动", "	shan1	dong4",
		"长牌", "	chang2	pai2",
		"应变", "	ying4	bian4",
		"长舌", "	chang2	she2",
		"吵吵", "	chao1	chao",
		"降妖", "	xiang2	yao1",
		"扮相", "	ban4	xiang4",
		"长醉", "	chang2	zui4",
		"朝朝", "	zhao1	zhao1",
		"雕琢", "	diao1	zhuo2",
		"南长", "	nan2	chang2",
		"双子", "	shuang1	zi3",
		"长随", "	chang2	sui2",
		"长夏", "	chang2	xia4",
		"三率", "	san1	shuai4",
		"长休", "	chang2	xiu1",
		"长头", "	chang2	tou2",
		"三乘", "	san1	sheng4",
		"长心", "	chang2	xin1",
		"长信", "	chang2	xin4",
		"长音", "	chang2	yin1",
		"长吟", "	chang2	yin2",
		"长云", "	chang2	yun2",
		"盛载", "	sheng4	zai3",
		"盛满", "	cheng2	man3",
		"效应", "	xiao4	ying4",
		"长蛇", "	chang2	she2",
		"长直", "	chang2	zhi2",
		"手钻", "	shou3	zuan4",
		"长至", "	chang2	zhi4",
		"摆晃", "	bai3	huang4",
		"应诏", "	ying4	zhao4",
		"重写", "	chong2	xie3",
		"长袍", "	chang2	pao2",
		"长袖", "	chang2	xiu4",
		"舍长", "	she4	chang2",
		"重来", "	chong2	lai2",
		"长靴", "	chang2	xue1",
		"长队", "	chang2	dui4",
		"长逝", "	chang2	shi4",
		"重数", "	chong2	shu4",
		"青藏", "	qing1	zang4",
		"重拍", "	chong2	pai1",
		"深更", "	shen1	geng1",
		"成分", "	cheng2	fen4",
		"长跑", "	chang2	pao3",
		"挑动", "	tiao3	dong4",
		"长谈", "	chang2	tan2",
		"长诗", "	chang2	shi1",
		"长裙", "	chang2	qun2",
		"成为", "	cheng2	wei2",
		"应诊", "	ying4	zhen3",
		"哄骗", "	hong3	pian4",
		"切向", "	qie1	xiang4",
		"电钻", "	dian4	zuan4",
		"调卷", "	diao4	juan4",
		"摒挡", "	bing4	dang4",
		"调调", "	tiao2	diao4",
		"调档", "	tiao2	dang4",
		"挑灯", "	tiao3	deng1",
		"调料", "	tiao2	liao4",
		"调弄", "	tiao2	nong4",
		"调教", "	tiao2	jiao4",
		"调挡", "	tiao2	dang3",
		"刁横", "	diao1	heng4",
		"棚圈", "	peng2	juan4",
		"调情", "	tiao2	qing2",
		"调控", "	tiao2	kong4",
		"喷香", "	pen4	xiang1",
		"挑明", "	tiao3	ming2",
		"援藏", "	yuan2	zang4",
		"卖相", "	mai4	xiang4",
		"转差", "	zhuan3	cha1",
		"转台", "	zhuan4	tai2",
		"换行", "	huan4	hang2",
		"更换", "	geng1	huan4",
		"转位", "	zhuan4	wei4",
		"调准", "	tiao2	zhun3",
		"冰凝", "	bing1	ning2",
		"轮种", "	lun2	zhong4",
		"曾参", "	zeng1	shen1",
		"碘酊", "	dian3	ding3",
		"背筐", "	bei1	kuang1",
		"贫相", "	pin2	xiang4",
		"琅孉", "	lang2	huan1",
		"财相", "	cai2	xiang4",
		"调弦", "	tiao2	xian2",
		"振兴", "	zhen4	xing1",
		"命名", "	ming4	ming2",
		"变更", "	bian4	geng1",
		"兵差", "	bing1	chai1",
		"调笑", "	tiao2	xiao4",
		"调焦", "	tiao2	jiao1",
		"调停", "	tiao2	ting2",
		"典当", "	dian3	dang4",
		"顶杠", "	ding3	gang4",
		"定更", "	ding4	geng1",
		"曾巩", "	zeng1	gong3",
		"挑战", "	tiao3	zhan4",
		"鼎兴", "	ding3	xing1",
		"挑弄", "	tiao3	nong4",
		"并州", "	bing1	zhou1",
		"轮转", "	lun2	zhuan4",
		"插上", "	cha1	shang",
		"拙朴", "	zhuo1	piao2",
		"楞楞", "	leng4	leng4",
		"掉色", "	diao4	shai3",
		"天监", "	tian1	jian4",
		"刨光", "	bao4	guang1",
		"跳行", "	tiao4	hang2",
		"走相", "	zou3	xiang4",
		"赚头", "	zhuan4	tou",
		"账载", "	zhang4	zai3",
		"评卷", "	ping2	juan4",
		"平巷", "	ping2	hang4",
		"分量", "	fen4	liang4",
		"哄劝", "	hong3	quan4",
		"接种", "	jie1	zhong4",
		"白镪", "	bai2	qiang3",
		"坦率", "	tan3	shuai4",
		"更深", "	geng1	shen1",
		"切成", "	qie1	cheng2",
		"挣脱", "	zheng4	tuo1",
		"挣扎", "	zheng1	zha2",
		"切中", "	qie4	zhong4",
		"轩槛", "	xuan1	jian4",
		"百中", "	bai3	zhong4",
		"天应", "	tian1	ying4",
		"分相", "	fen1	xiang4",
		"重奏", "	chong2	zou4",
		"拖长", "	tuo1	chang2",
		"镗孔", "	tang2	kong3",
		"糖色", "	tang2	shai3",
		"蛣蜣", "	jie2	qiang1",
		"转悠", "	zhuan4	you1",
		"转门", "	zhuan4	men2",
		"转游", "	zhuan4	you",
		"更动", "	geng1	dong4",
		"转轮", "	zhuan4	lun2",
		"转载", "	zhuan3	zai3",
		"更名", "	geng1	ming2",
		"招供", "	zhao1	gong4",
		"转文", "	zhuai3	wen2",
		"倒想", "	dao3	xiang3",
		"倒箱", "	dao3	xiang1",
		"揣度", "	chuai3	duo2",
		"转纽", "	zhuan4	niu3",
		"转筋", "	zhuan4	jin1",
		"农行", "	nong2	hang2",
		"败将", "	bai4	jiang4",
		"叨光", "	tao1	guang1",
		"蹭蹬", "	ceng4	deng4",
		"散光", "	san3	guang1",
		"露相", "	lou4	xiang4",
		"点着", "	dian3	zhao2",
		"撩动", "	liao2	dong4",
		"劲风", "	jing4	feng1",
		"啜茗", "	chuo4	ming2",
		"长褂", "	chang2	gua4",
		"旋工", "	xuan4	gong1",
		"飞转", "	fei1	zhuan4",
		"折衷", "	she2	zhong1",
		"哮鸣", "	xiao4	ming2",
		"劲挺", "	jing4	ting3",
		"长干", "	chang2	gan4",
		"史乘", "	shi3	sheng4",
		"春兴", "	chun1	xing1",
		"劲峭", "	jing4	qiao4",
		"撬杠", "	qiao4	gang4",
		"应召", "	ying4	zhao4",
		"长恨", "	chang2	hen4",
		"长尾", "	chang2	wei3",
		"长存", "	chang2	cun2",
		"长多", "	chang2	duo1",
		"懂行", "	dong3	hang2",
		"长叹", "	chang2	tan4",
		"钻井", "	zuan4	jing3",
		"钟乐", "	zhong1	yue4",
		"长跪", "	chang2	gui4",
		"折秤", "	she2	cheng4",
		"长男", "	chang2	nan2",
		"省方", "	xing3	fang1",
		"长街", "	chang2	jie1",
		"长海", "	chang2	hai3",
		"长滨", "	chang2	bin1",
		"单县", "	shan4	xian4",
		"长矛", "	chang2	mao2",
		"应用", "	ying4	yong4",
		"参茸", "	shen1	rong2",
		"长白", "	chang2	bai2",
		"颈椎", "	jing3	zhui1",
		"长岛", "	chang2	dao3",
		"长流", "	chang2	liu2",
		"投降", "	tou2	xiang2",
		"长班", "	chang2	ban1",
		"棽棽", "	chen1	chen1",
		"长林", "	chang2	lin2",
		"应景", "	ying4	jing3",
		"长列", "	chang2	lie4",
		"长烟", "	chang2	yan1",
		"受禅", "	shou4	shan4",
		"生角", "	sheng1	jue2",
		"长假", "	chang2	jia4",
		"风钻", "	feng1	zuan4",
		"长幼", "	chang2	you4",
		"粘着", "	nian2	zhuo2",
		"悍将", "	han4	jiang4",
		"校订", "	jiao4	ding4",
		"缥囊", "	piao3	nang2",
		"纤手", "	qian4	shou3",
		"猜中", "	cai1	zhong4",
		"宽甸", "	kuan1	dian4",
		"率然", "	shuai4	ran2",
		"绗缝", "	hang2	feng2",
		"桁杨", "	hang2	yang2",
		"射中", "	she4	zhong4",
		"校准", "	jiao4	zhun3",
		"奉还", "	feng4	huan2",
		"应典", "	ying4	dian3",
		"粘胶", "	nian2	jiao1",
		"交还", "	jiao1	huan2",
		"应供", "	ying4	gong4",
		"粘粘", "	nian2	nian2",
		"粘稠", "	nian2	chou2",
		"杆秤", "	gan3	cheng4",
		"粘性", "	nian2	xing4",
		"粘缠", "	nian2	chan2",
		"校监", "	xiao4	jian4",
		"差商", "	cha1	shang1",
		"长活", "	chang2	huo2",
		"缝缀", "	feng2	zhui4",
		"长话", "	chang2	hua4",
		"慢长", "	man4	chang2",
		"旋风", "	xuan4	feng1",
		"长久", "	chang2	jiu3",
		"共工", "	gong4	gong1",
		"戎行", "	rong2	hang2",
		"杠杠", "	gang4	gang4",
		"伄儅", "	diao4	dang1",
		"份量", "	fen4	liang",
		"缅甸", "	mian3	dian4",
		"种菜", "	zhong4	cai4",
		"正旦", "	zheng1	dan4",
		"干城", "	gan1	cheng2",
		"率直", "	shuai4	zhi2",
		"网杓", "	wang3	shao2",
		"正切", "	zheng4	qie1",
		"经卷", "	jing1	juan4",
		"栽种", "	zai1	zhong4",
		"甚浓", "	shen4	nong2",
		"正月", "	zheng1	yue4",
		"缥渺", "	piao3	miao3",
		"长杰", "	chang2	jie2",
		"身着", "	shen1	zhuo2",
		"城阙", "	cheng2	que4",
		"量杯", "	liang2	bei1",
		"重迭", "	chong2	die2",
		"骗供", "	pian4	gong4",
		"重蹈", "	chong2	dao3",
		"骄横", "	jiao1	heng4",
		"重制", "	chong2	zhi4",
		"惊醒", "	jing1	xing3",
		"长材", "	chang2	cai2",
		"重返", "	chong2	fan3",
		"薯莨", "	shu3	liang2",
		"长刀", "	chang2	dao1",
		"掸邦", "	shan4	bang1",
		"世相", "	shi4	xiang4",
		"加长", "	jia1	chang2",
		"铺床", "	pu1	chuang2",
		"明了", "	ming2	liao3",
		"攒动", "	cuan2	dong4",
		"撩乱", "	liao2	luan4",
		"馕嗓", "	nang3	sang3",
		"香干", "	xiang1	gan1",
		"加上", "	jia1	shang",
		"馕糠", "	nang3	kang1",
		"重述", "	chong2	shu4",
		"长车", "	chang2	che1",
		"量规", "	liang2	gui1",
		"茸茸", "	rong2	rong2",
		"称手", "	chen4	shou3",
		"尨茸", "	meng2	rong2",
		"趁空", "	chen4	kong4",
		"丧乱", "	sang1	luan4",
		"卷轴", "	juan4	zhou2",
		"称身", "	chen4	shen1",
		"晨兴", "	chen2	xing1",
		"趁兴", "	chen4	xing1",
		"扇风", "	shan1	feng1",
		"称愿", "	chen4	yuan4",
		"重造", "	chong2	zao4",
		"钐镰", "	shan4	lian2",
		"卷宗", "	juan4	zong1",
		"善卷", "	shan4	juan4",
		"盛饭", "	cheng2	fan4",
		"山岗", "	shan1	gang1",
		"重婚", "	chong2	hun1",
		"长石", "	chang2	shi2",
		"单相", "	dan1	xiang4",
		"重开", "	chong2	kai1",
		"清供", "	qing1	gong4",
		"想头", "	xiang3	tou",
		"隆兴", "	long2	xing1",
		"身著", "	shen1	zhuo2",
		"顺应", "	shun4	ying4",
		"脏乱", "	zang1	luan4",
		"晃悠", "	huang4	you1",
		"重温", "	chong2	wen1",
		"嚷嚷", "	rang1	rɑng",
		"划伤", "	hua2	shang1",
		"脏水", "	zang1	shui3",
		"剿说", "	chao1	shuo1",
		"重楼", "	chong2	lou2",
		"重演", "	chong2	yan3",
		"劲吹", "	jing4	chui1",
		"重犯", "	chong2	fan4",
		"应手", "	ying4	shou3",
		"应战", "	ying4	zhan4",
		"长治", "	chang2	zhi4",
		"长沙", "	chang2	sha1",
		"应从", "	ying4	cong2",
		"长俊", "	chang2	jun4",
		"求降", "	qiu2	xiang2",
		"深省", "	shen1	xing3",
		"长泰", "	chang2	tai4",
		"长棍", "	chang2	gun4",
		"重查", "	chong2	cha2",
		"悠长", "	you1	chang2",
		"寸长", "	cun4	chang2",
		"重担", "	zhong4	dan4",
		"龙兴", "	long2	xing1",
		"儱侗", "	long3	tong3",
		"重叠", "	chong2	die2",
		"重瓣", "	chong2	ban4",
		"脏病", "	zang1	bing4",
		"重新", "	chong2	xin1",
		"晕船", "	yun4	chuan2",
		"重文", "	chong2	wen2",
		"邻长", "	lin2	chang2",
		"重插", "	chong2	cha1",
		"长坂", "	chang2	ban3",
		"晕场", "	yun4	chang3",
		"脏脏", "	zang1	zang1",
		"重拾", "	chong2	shi2",
		"重弹", "	chong2	tan2",
		"重孙", "	chong2	sun1",
		"召陵", "	shao4	ling2",
		"长才", "	chang2	cai2",
		"晾干", "	liang4	gan1",
		"重构", "	chong2	gou4",
		"灵应", "	ling2	ying4",
		"漂漂", "	piao1	piao1",
		"影片", "	ying3	pian1",
		"精当", "	jing1	dang4",
		"随兴", "	sui2	xing1",
		"消褪", "	xiao1	tun4",
		"校书", "	jiao4	shu1",
		"卷包", "	juan4	bao1",
		"小舍", "	xiao3	she4",
		"卷丹", "	juan4	dan1",
		"圈肥", "	juan4	fei2",
		"圈舍", "	juan4	she4",
		"划艇", "	hua2	ting3",
		"卷柜", "	juan4	gui4",
		"划算", "	hua2	suan4",
		"倒换", "	dao3	huan4",
		"划拳", "	hua2	quan2",
		"索还", "	suo3	huan2",
		"小侯", "	xiao3	hou4",
		"销号", "	xiao1	hao4",
		"小斗", "	xiao3	dou3",
		"小尽", "	xiao3	jin4",
		"丹参", "	dan1	shen1",
		"奔丧", "	ben1	sang1",
		"曲张", "	qu3	zhang1",
		"两得", "	liang3	de",
		"连杆", "	lian2	gan3",
		"参宿", "	shen1	xiu4",
		"切面", "	qie1	mian4",
		"两都", "	liang3	du1",
		"像似", "	xiang4	si4",
		"卷缩", "	juan4	suo1",
		"台钻", "	tai2	zuan4",
		"卷头", "	juan4	tou2",
		"卷尾", "	juan4	wei3",
		"朘削", "	juan1	xue1",
		"切点", "	qie1	dian3",
		"相如", "	xiang4	ru2",
		"太甚", "	tai4	shen4",
		"颉颃", "	xie2	hang2",
		"降魔", "	xiang2	mo2",
		"切变", "	qie1	bian4",
		"相里", "	xiang4	li3",
		"相和", "	xiang1	he4",
		"相得", "	xiang1	de",
		"倒腾", "	dao3	teng2",
		"切线", "	qie1	xian4",
		"在行", "	zai4	hang2",
		"切痛", "	qie1	tong4",
		"相马", "	xiang4	ma3",
		"执著", "	zhi2	zhuo2",
		"昭著", "	zhao1	zhu4",
		"切片", "	qie1	pian4",
		"原处", "	yuan2	chu3",
		"中得", "	zhong1	de",
		"著实", "	zhuo2	shi2",
		"抢地", "	qiang1	di4",
		"划行", "	hua2	xing2",
		"花朝", "	hua1	zhao1",
		"中意", "	zhong4	yi4",
		"三藏", "	san1	zang4",
		"乾造", "	qian2	zao4",
		"口供", "	kou3	gong4",
		"朝霞", "	zhao1	xia2",
		"划水", "	hua2	shui3",
		"三通", "	san1	tong4",
		"钻杆", "	zuan4	gan3",
		"黄子", "	huang2	zi3",
		"弄口", "	long4	kou3",
		"受难", "	shou4	nan4",
		"中子", "	zhong1	zi3",
		"染坊", "	ran3	fang2",
		"篇什", "	pian1	shi2",
		"原著", "	yuan2	zhu4",
		"子将", "	zi3	jiang1",
		"女将", "	nv3	jiang4",
		"群氓", "	qun2	meng2",
		"周处", "	zhou1	chu3",
		"仔兽", "	zai3	shou4",
		"炔烃", "	que1	ting1",
		"牛鞅", "	niu2	yang4",
		"并处", "	bing4	chu3",
		"评弹", "	ping2	tan2",
		"折干", "	she2	qian2",
		"内省", "	nei4	xing3",
		"确当", "	que4	dang4",
		"朝云", "	zhao1	yun2",
		"折行", "	she2	xing2",
		"牛圈", "	niu2	juan4",
		"属望", "	zhu3	wang4",
		"拧紧", "	ning3	jin3",
		"吹干", "	chui1	gan1",
		"折减", "	she2	jian3",
		"还丹", "	huan2	dan1",
		"三更", "	san1	geng1",
		"折受", "	she2	shou4",
		"子姜", "	zi3	jiang1",
		"哄瞒", "	hong3	man2",
		"妥当", "	tuo3	dang4",
		"受累", "	shou4	lei3",
		"初更", "	chu1	geng1",
		"前头", "	qian2	tou",
		"反间", "	fan3	jian4",
		"肯綮", "	ken3	qing4",
		"公石", "	gong1	dan4",
		"偷空", "	tou1	kong4",
		"冗散", "	rong3	san3",
		"筐子", "	kuang1	zi3",
		"拓宽", "	tuo4	kuan1",
		"款识", "	kuan3	zhi4",
		"拓边", "	tuo4	bian1",
		"外应", "	wai4	ying4",
		"调休", "	tiao2	xiu1",
		"同好", "	tong2	hao4",
		"公假", "	gong1	jia4",
		"调治", "	tiao2	zhi4",
		"充塞", "	chong1	se4",
		"兆头", "	zhao4	tou",
		"为甚", "	wei2	shen4",
		"光子", "	guang1	zi3",
		"出差", "	chu1	chai1",
		"为善", "	wei2	shan4",
		"出丧", "	chu1	sang1",
		"冷轧", "	leng3	zha2",
		"来还", "	lai2	huan2",
		"公斗", "	gong1	dou3",
		"铜臭", "	tong2	xiu4",
		"萎蔫", "	wei3	nian1",
		"开兴", "	kai1	xing1",
		"假条", "	jia4	tiao2",
		"切块", "	qie1	kuai4",
		"乐工", "	yue4	gong1",
		"累年", "	lei3	nian2",
		"偏差", "	pian1	cha1",
		"埋怨", "	man2	yuan4",
		"执着", "	zhi2	zhuo2",
		"切削", "	qie1	xiao1",
		"天阙", "	tian1	que4",
		"添头", "	tian1	tou",
		"公仔", "	gong1	zai3",
		"累卵", "	lei2	luan3",
		"瞎蒙", "	xia1	meng1",
		"为限", "	wei2	xian4",
		"冠军", "	guan4	jun1",
		"王舍", "	wang2	she4",
		"阔少", "	kuo4	shao4",
		"内蒙", "	nei4	meng3",
		"内行", "	nei4	hang2",
		"内哄", "	nei4	hong4",
		"空载", "	kong1	zai3",
		"铁杠", "	tie3	gang4",
		"亭侯", "	ting2	hou4",
		"大王", "	dai4	wang2",
		"型芯", "	xing2	xin4",
		"倒噍", "	dao3	jiao4",
		"倒手", "	dao3	shou3",
		"兴家", "	xing1	jia1",
		"救应", "	jiu4	ying4",
		"供认", "	gong4	ren4",
		"兴运", "	xing1	yun4",
		"便人", "	pian2	ren2",
		"剪切", "	jian3	qie1",
		"兴修", "	xing1	xiu1",
		"率意", "	shuai4	yi4",
		"因应", "	yin1	ying4",
		"剥啄", "	bao1	zhuo2",
		"栓子", "	shuan1	zi3",
		"便难", "	bian4	nan4",
		"前燕", "	qian2	yan1",
		"回佣", "	hui2	yong4",
		"前咽", "	qian2	yan1",
		"兴叹", "	xing1	tan4",
		"税卡", "	shui4	qia3",
		"信差", "	xin4	chai1",
		"削球", "	xiao1	qiu2",
		"卷柏", "	juan4	bai3",
		"倒扁", "	dao3	bian3",
		"为命", "	wei2	ming4",
		"回应", "	hui2	ying4",
		"为名", "	wei2	ming2",
		"课长", "	ke4	chang2",
		"同处", "	tong2	chu3",
		"为患", "	wei2	huan4",
		"为情", "	wei2	qing2",
		"精舍", "	jing1	she4",
		"里长", "	li3	chang2",
		"霰弹", "	xian4	dan4",
		"九钻", "	jiu3	zuan4",
		"说什", "	shuo1	shi2",
		"刨冰", "	bao4	bing1",
		"杏干", "	xing4	gan1",
		"梁子", "	liang2	zi3",
		"兴废", "	xing1	fei4",
		"倒仓", "	dao3	cang1",
		"大将", "	da4	jiang4",
		"刺中", "	ci4	zhong4",
		"行处", "	xing2	chu3",
		"回还", "	hui2	huan2",
		"倒嚼", "	dao3	jiao4",
		"倒弄", "	dao3	nong4",
		"曲种", "	qu3	zhong3",
		"黄柏", "	huang2	bo4",
		"铜钿", "	tong2	tian2",
		"吊杠", "	diao4	gang4",
		"刚劲", "	gang1	jing4",
		"刷卷", "	shua1	juan4",
		"同行", "	tong2	hang2",
		"重围", "	chong2	wei2",
		"摇晃", "	yao2	huang4",
		"重回", "	chong2	hui2",
		"重又", "	chong2	you4",
		"重印", "	chong2	yin4",
		"重修", "	chong2	xiu1",
		"衰萎", "	shuai1	wei3",
		"通红", "	tong4	hong2",
		"太冲", "	tai4	chong4",
		"追还", "	zhui1	huan2",
		"吊卷", "	diao4	juan4",
		"俏销", "	qiao4	xiao1",
		"重九", "	chong2	jiu3",
		"党参", "	dang3	shen1",
		"靓白", "	liang4	bai2",
		"强人", "	qiang3	ren2",
		"性行", "	xing4	xing2",
		"单姓", "	shan4	xing4",
		"当行", "	dang1	hang2",
		"乾龙", "	qian2	long2",
		"膻中", "	dan4	zhong1",
		"盅子", "	zhong1	zi3",
		"中牟", "	zhong1	mu4",
		"浑朴", "	hun2	piao2",
		"皮相", "	pi2	xiang4",
		"画片", "	hua4	pian1",
		"中脊", "	zhong1	ji3",
		"豁朗", "	huo4	lang3",
		"切手", "	qie1	shou3",
		"啁啾", "	zhou1	jiu1",
		"中计", "	zhong4	ji4",
		"儒将", "	ru2	jiang4",
		"划船", "	hua2	chuan2",
		"中举", "	zhong4	ju3",
		"竹行", "	zhu2	hang2",
		"裨将", "	pi2	jiang4",
		"作践", "	zuo2	jian4",
		"惬当", "	qie4	dang4",
		"昏蒙", "	hun1	meng1",
		"划桨", "	hua2	jiang3",
		"台长", "	tai2	chang2",
		"乾明", "	qian2	ming2",
		"拓荒", "	tuo4	huang1",
		"两肋", "	liang3	lei4",
		"还债", "	huan2	zhai4",
		"劈账", "	pi3	zhang4",
		"识相", "	shi2	xiang4",
		"别传", "	bie2	zhuan4",
		"难兄", "	nan4	xiong1",
		"了断", "	liao3	duan4",
		"道长", "	dao4	chang2",
		"削尖", "	xiao1	jian1",
		"男相", "	nan2	xiang4",
		"还手", "	huan2	shou3",
		"占星", "	zhan1	xing1",
		"轰隆", "	hong1	long1",
		"便了", "	bian4	liao3",
		"摔倒", "	shuai1	dao3",
		"听差", "	ting1	chai1",
		"咸兴", "	xian2	xing1",
		"往还", "	wang3	huan2",
		"诸相", "	zhu1	xiang4",
		"诸将", "	zhu1	jiang4",
		"调养", "	tiao2	yang3",
		"凝冰", "	ning2	bing1",
		"彭彭", "	bang1	bang1",
		"彷徉", "	pang2	yang2",
		"调羹", "	tiao2	geng1",
		"运转", "	yun4	zhuan4",
		"吃相", "	chi1	xiang4",
		"强切", "	qiang2	qie1",
		"强留", "	qiang3	liu2",
		"还原", "	huan2	yuan2",
		"曹长", "	cao2	chang2",
		"刨程", "	bao4	cheng2",
		"还清", "	huan2	qing1",
		"钌铞", "	liao4	diao4",
		"还愿", "	huan2	yuan4",
		"掺水", "	chan1	shui3",
		"当票", "	dang4	piao4",
		"当差", "	dang1	chai1",
		"摊场", "	tan1	chang2",
		"内传", "	nei4	zhuan4",
		"强颜", "	qiang3	yan2",
		"黑框", "	hei1	kuang4",
		"浅浅", "	jian1	jian1",
		"乾乾", "	qian2	qian2",
		"连翘", "	lian2	qiao2",
		"列传", "	lie4	zhuan4",
		"乾元", "	qian2	yuan2",
		"酬应", "	chou2	ying4",
		"酩酊", "	ming3	ding3",
		"运将", "	yun4	jiang4",
		"级长", "	ji2	chang2",
		"娘子", "	niang2	zi3",
		"吊斗", "	diao4	dou3",
		"字长", "	zi4	chang2",
		"清隽", "	qing1	jun4",
		"世行", "	shi4	hang2",
		"还家", "	huan2	jia1",
		"受尽", "	shou4	jin4",
		"木强", "	mu4	jiang4",
		"情切", "	qing2	qie1",
		"千载", "	qian1	zai3",
		"能为", "	neng2	wei2",
		"颀长", "	qi2	chang2",
		"清切", "	qing1	qie1",
		"商都", "	shang1	du1",
		"受到", "	shou4	dao4",
		"只缘", "	zhi1	yuan2",
		"轻载", "	qing1	zai3",
		"参校", "	can1	jiao4",
		"激将", "	ji1	jiang4",
		"正脊", "	zheng4	ji3",
		"子城", "	zi3	cheng2",
		"只手", "	zhi1	shou3",
		"黄发", "	huang2	fa4",
		"千石", "	qian1	dan4",
		"曲中", "	qu3	zhong1",
		"商贾", "	shang1	gu3",
		"乾道", "	qian2	dao4",
		"名角", "	ming2	jue2",
		"反省", "	fan3	xing3",
		"参薯", "	shen1	shu3",
		"始兴", "	shi3	xing1",
		"乞降", "	qi3	xiang2",
		"只从", "	zhi1	cong2",
		"值当", "	zhi2	dang4",
		"遒劲", "	qiu2	jing4",
		"唱曲", "	chang4	qu3",
		"曲梁", "	qu3	liang2",
		"指缝", "	zhi3	feng2",
		"内应", "	nei4	ying4",
		"只见", "	zhi1	jian4",
		"名著", "	ming2	zhu4",
		"还珠", "	huan2	zhu1",
		"乾嘉", "	qian2	jia1",
		"唱喏", "	chang4	re3",
		"唱和", "	chang4	he4",
		"名为", "	ming2	wei2",
		"准头", "	zhun3	tou",
		"名帖", "	ming2	tie3",
		"反应", "	fan3	ying4",
		"子长", "	zi3	chang2",
		"钻修", "	zuan4	xiu1",
		"绘卷", "	hui4	juan4",
		"障子", "	zhang4	zi3",
		"入相", "	ru4	xiang4",
		"啜饮", "	chuo4	yin3",
		"软和", "	ruan3	huo",
		"咳呛", "	ke2	qiang4",
		"掌子", "	zhang3	zi3",
		"画供", "	hua4	gong4",
		"礃子", "	zhang3	zi3",
		"哨卡", "	shao4	qia3",
		"獐子", "	zhang1	zi3",
		"作甚", "	zuo4	shen4",
		"作弄", "	zuo1	nong4",
		"和弄", "	huo4	nong4",
		"劈成", "	pi3	cheng2",
		"妄为", "	wang4	wei2",
		"咆哮", "	pao2	xiao4",
		"钻台", "	zuan4	tai2",
		"猪圈", "	zhu1	juan4",
		"系绳", "	ji4	sheng2",
		"钻饰", "	zuan4	shi4",
		"上去", "	shang3	qu4",
		"上个", "	shang4	ge",
		"难侨", "	nan4	qiao2",
		"问卷", "	wen4	juan4",
		"中魔", "	zhong4	mo2",
		"卷帙", "	juan4	zhi4",
		"钻凿", "	zuan4	zao2",
		"钻穴", "	zuan4	xue2",
		"竹杠", "	zhu2	gang4",
		"衷曲", "	zhong1	qu3",
		"杖子", "	zhang4	zi3",
		"卵泡", "	luan3	pao1",
		"俏头", "	qiao4	tou",
		"软肋", "	ruan3	lei4",
		"抨弹", "	peng1	tan2",
		"弱冠", "	ruo4	guan4",
		"火燎", "	huo3	liao3",
		"长机", "	chang2	ji1",
		"切当", "	qie1	dang1",
		"和面", "	huo2	mian4",
		"幛子", "	zhang4	zi3",
		"棚舍", "	peng2	she4",
		"南甸", "	nan2	dian4",
		"叩应", "	kou4	ying4",
		"切用", "	qie1	yong4",
		"中毒", "	zhong4	du2",
		"柞绸", "	zuo4	chou2",
		"嚼用", "	jiao2	yong4",
		"桑葚", "	sang1	shen4",
		"肋条", "	lei4	tiao2",
		"长籼", "	chang2	xian1",
		"少成", "	shao4	cheng2",
		"商参", "	shang1	shen1",
		"种田", "	zhong4	tian2",
		"长顺", "	chang2	shun4",
		"应承", "	ying4	cheng2",
		"长眠", "	chang2	mian2",
		"粘虫", "	nian2	chong2",
		"长短", "	chang2	duan3",
		"长篇", "	chang2	pian1",
		"长线", "	chang2	xian4",
		"少长", "	shao4	zhang3",
		"长兴", "	chang2	xing1",
		"长龙", "	chang2	long2",
		"长虹", "	chang2	hong2",
		"长衫", "	chang2	shan1",
		"长丰", "	chang2	feng1",
		"长远", "	chang2	yuan3",
		"长钉", "	chang2	ding4",
		"粮行", "	liang2	hang2",
		"真相", "	zhen1	xiang4",
		"少相", "	shao4	xiang1",
		"闲晃", "	xian2	huang4",
		"战将", "	zhan4	jiang4",
		"转圈", "	zhuan4	quan1",
		"全长", "	quan2	chang2",
		"转行", "	zhuan3	hang2",
		"调光", "	tiao2	guang1",
		"较长", "	jiao4	chang2",
		"更正", "	geng1	zheng4",
		"轻率", "	qing1	shuai4",
		"纤长", "	xian1	chang2",
		"仙长", "	xian1	chang2",
		"转动", "	zhuan4	dong4",
		"更张", "	geng1	zhang1",
		"重阳", "	chong2	yang2",
		"倘佯", "	chang2	yang2",
		"辗转", "	zhan3	zhuan3",
		"偏将", "	pian1	jiang4",
		"天相", "	tian1	xiang4",
		"更生", "	geng1	sheng1",
		"天将", "	tian1	jiang4",
		"身长", "	shen1	chang2",
		"藏象", "	zang4	xiang4",
		"相间", "	xiang1	jian4",
		"胸椎", "	xiong1	zhui1",
		"真率", "	zhen1	shuai4",
		"散装", "	san3	zhuang1",
		"调整", "	tiao2	zheng3",
		"统率", "	tong3	shuai4",
		"长条", "	chang2	tiao2",
		"经传", "	jing1	zhuan4",
		"长拳", "	chang2	quan2",
		"长荣", "	chang2	rong2",
		"长汀", "	chang2	ting1",
		"终了", "	zhong1	liao3",
		"长清", "	chang2	qing1",
		"长漂", "	chang2	piao1",
		"长片", "	chang2	pian4",
		"勉强", "	mian3	qiang3",
		"长春", "	chang2	chun1",
		"长廊", "	chang2	lang2",
		"伸长", "	shen1	chang2",
		"长凳", "	chang2	deng4",
		"长垣", "	chang2	yuan2",
		"长庚", "	chang2	geng1",
		"长寿", "	chang2	shou4",
		"绷簧", "	beng1	huang2",
		"长宁", "	chang2	ning2",
		"长岭", "	chang2	ling3",
		"长平", "	chang2	ping2",
		"长柄", "	chang2	bing3",
		"长效", "	chang2	xiao4",
		"院长", "	yuan4	chang2",
		"镜框", "	jing4	kuang4",
		"睡相", "	shui4	xiang4",
		"干爽", "	gan1	shuang3",
		"山长", "	shan1	chang2",
		"晒场", "	shai4	chang2",
		"重逢", "	chong2	feng2",
		"亭长", "	ting2	chang2",
		"耕种", "	geng1	zhong4",
		"镇长", "	zhen4	chang2",
		"校场", "	jiao4	chang3",
		"重霄", "	chong2	xiao1",
		"校正", "	jiao4	zheng4",
		"星相", "	xing1	xiang4",
		"量瓶", "	liang2	ping2",
		"量筒", "	liang2	tong3",
		"扬长", "	yang2	chang2",
		"扬场", "	yang2	chang2",
		"量身", "	liang2	shen1",
		"收降", "	shou1	xiang2",
		"手长", "	shou3	chang2",
		"量表", "	liang2	biao3",
		"参商", "	shen1	shang1",
		"王长", "	wang2	chang2",
		"冗长", "	rong3	chang2",
		"长空", "	chang2	kong1",
		"相面", "	xiang4	mian4",
		"受降", "	shou4	xiang2",
		"猛将", "	meng3	jiang4",
		"率先", "	shuai4	xian1",
		"饼铛", "	bing3	cheng1",
		"卿相", "	qing1	xiang4",
		"请降", "	qing3	xiang2",
		"率领", "	shuai4	ling3",
		"率真", "	shuai4	zhen1",
		"正着", "	zheng4	zhao2",
		"边框", "	bian1	kuang4",
		"牵强", "	qian1	qiang3",
		"边长", "	bian1	chang2",
		"芒种", "	mang2	zhong4",
		"色钟", "	shai3	zhong1",
		"说项", "	shui4	xiang4",
		"色盅", "	shai3	zhong1",
		"前传", "	qian2	zhuan4",
		"丑相", "	chou3	xiang4",
		"还乡", "	huan2	xiang1",
		"着凉", "	zhao2	liang2",
		"着慌", "	zhao2	huang1",
		"首相", "	shou3	xiang4",
		"准将", "	zhun3	jiang4",
		"小将", "	xiao3	jiang4",
		"黄漂", "	huang2	piao1",
		"千乘", "	qian1	sheng4",
		"点将", "	dian3	jiang4",
		"纤绳", "	qian4	sheng2",
		"抢风", "	qiang1	feng1",
		"黄兴", "	huang2	xing1",
		"强笑", "	qiang3	xiao4",
		"照相", "	zhao4	xiang4",
		"戗面", "	qiang4	mian4",
		"上供", "	shang4	gong4",
		"响应", "	xiang3	ying4",
		"水相", "	shui3	xiang4",
		"涨红", "	zhang4	hong2",
		"清长", "	qing1	chang2",
		"擅长", "	shan4	chang2",
		"生还", "	sheng1	huan2",
		"挣钱", "	zheng4	qian2",
		"挣命", "	zheng4	ming4",
		"评传", "	ping2	zhuan4",
		"挣断", "	zheng4	duan4",
		"正朔", "	zheng1	shuo4",
		"当成", "	dang4	cheng2",
		"着想", "	zhuo2	xiang3",
		"骁将", "	xiao1	jiang4",
		"公转", "	gong1	zhuan4",
		"通长", "	tong1	chang2",
		"雄劲", "	xiong2	jing4",
		"重样", "	chong2	yang4",
		"兴城", "	xing1	cheng2",
		"创口", "	chuang1	kou3",
		"重映", "	chong2	ying4",
		"供称", "	gong4	cheng1",
		"降龙", "	xiang2	long2",
		"着重", "	zhuo2	zhong4",
		"表率", "	biao3	shuai4",
		"衡量", "	heng2	liang2",
		"凶横", "	xiong1	heng4",
		"行长", "	hang2	zhang3",
		"挑中", "	tiao1	zhong4",
		"行商", "	hang2	shang1",
		"变相", "	bian4	xiang4",
		"元长", "	yuan2	chang2",
		"偿还", "	chang2	huan2",
		"贤相", "	xian2	xiang4",
		"赚哄", "	zhuan4	hong3",
		"贯串", "	guan4	chuan4",
		"诚朴", "	cheng2	piao2",
		"重庆", "	chong2	qing4",
		"重影", "	chong2	ying3",
		"还账", "	huan2	zhang4",
		"晃动", "	huang4	dong4",
		"连长", "	lian2	chang2",
		"选中", "	xuan3	zhong4",
		"刨床", "	bao4	chuang2",
		"兴昌", "	xing1	chang1",
		"箱笼", "	xiang1	long3",
		"率性", "	shuai4	xing4",
		"兴衰", "	xing1	shuai1",
		"悬揣", "	xuan2	chuai3",
		"重洋", "	chong2	yang2",
		"脸相", "	lian3	xiang4",
		"重建", "	chong2	jian4",
		"重现", "	chong2	xian4",
		"膀胱", "	pang2	guang1",
		"晃荡", "	huang4	dang4",
		"重申", "	chong2	shen1",
		"重算", "	chong2	suan4",
		"重编", "	chong2	bian1",
		"重访", "	chong2	fang3",
		"重评", "	chong2	ping2",
		"兴盛", "	xing1	sheng4",
		"重审", "	chong2	shen3",
		"长年", "	chang2	nian2",
		"绵长", "	mian2	chang2",
		"上当", "	shang4	dang4",
		"相中", "	xiang1	zhong4",
		"长成", "	chang2	cheng2",
		"长枪", "	chang2	qiang1",
		"重整", "	chong2	zheng3",
		"将将", "	qiang1	qiang1",
		"穿上", "	chuan1	shang",
		"将相", "	jiang4	xiang4",
		"倡狂", "	chang1	kuang2",
		"着装", "	zhuo2	zhuang1",
		"相长", "	xiang1	chang2",
		"着床", "	zhuo2	chuang2",
		"长相", "	zhang3	xiang4",
		"相率", "	xiang1	shuai4",
		"凶相", "	xiong1	xiang4",
		"窘相", "	jiong3	xiang4",
		"两重", "	liang3	chong2",
		"良将", "	liang2	jiang4",
		"供状", "	gong4	zhuang4",
		"强征", "	qiang3	zheng1",
		"怔忪", "	zheng1	zhong1",
		"怔怔", "	zheng4	zheng4",
		"跄踉", "	qiang4	liang4",
		"长江", "	chang2	jiang1",
		"长生", "	chang2	sheng1",
		"踉蹡", "	liang4	qiang1",
		"重重", "	chong2	chong2",
		"旋床", "	xuan4	chuang2",
		"创面", "	chuang1	mian4",
		"长城", "	chang2	cheng2",
		"创兴", "	chuang4	xing1",
		"生相", "	sheng1	xiang4",
		"亮相", "	liang4	xiang4",
		"框框", "	kuang4	kuang4",
		"铛铛", "	cheng1	cheng1",
		"长帅", "	chang2	shuai4",
		"乡长", "	xiang1	chang2",
		"掌相", "	zhang3	xiang4",
		"钻床", "	zuan4	chuang2",
		"创痛", "	chuang1	tong4",
		"长征", "	chang2	zheng1",
		"更爽", "	geng1	shuang3",
		"称量", "	cheng1	liang2",
		"重光", "	chong2	guang1",
		"重唱", "	chong2	chang4",
		"上相", "	shang4	xiang4",
		"汤汤", "	shang1	shang1",
		"少壮", "	shao4	zhuang4",
		"踉跄", "	liang4	qiang4",
		"征传", "	zheng1	zhuan4",
		"绷床", "	beng1	chuang2",
		"乘胜", "	cheng2	sheng4",
		"将帅", "	jiang4	shuai4",
		"丈量", "	zhang4	liang2",
		"中伤", "	zhong4	shang1",
		"商量", "	shang1	liang2",
		"正传", "	zheng4	zhuan4",
		"上将", "	shang4	jiang4",
		"泷水", "	shuang1	shui3",
		"上声", "	shang3	sheng1",
		"降将", "	xiang2	jiang4",
		"政争", "	zheng4	zheng1",
		"挣揣", "	zheng4	chuai4",
		"场长", "	chang2	zhang3",
		"靓装", "	liang4	zhuang1",
		"闯将", "	chuang3	jiang4",
		"窗框", "	chuang1	kuang4",
		"创伤", "	chuang1	shang1",
		"重创", "	zhong4	chuang1",
		"装相", "	zhuang1	xiang4",
		"冲床", "	chong4	chuang2",
		"双重", "	shuang1	chong2",
		"间壁", "	jian4	bi4",
		"长川", "	chang2	chuan1",
		"专长", "	zhuan1	chang2",
		"镗床", "	tang2	chuang2",
		"中奖", "	zhong4	jiang3",
		"相向", "	xiang1	xiang4",
		"长长", "	chang2	chang2",
		"种粮", "	zhong4	liang2",
		"揣想", "	chuai3	xiang3",
		"相像", "	xiang1	xiang4",
		"中将", "	zhong1	jiang4",
		"丞相", "	cheng2	xiang4",
		"相声", "	xiang4	sheng",
		"相框", "	xiang4	kuang4",
		"黄裳", "	huang2	chang2",
		"中长", "	zhong1	chang2",
		"长虫", "	chang2	chong2",
		"双杠", "	shuang1	gang4",
		"晃晃", "	huang4	huang3",
		"正长", "	zheng4	chang2",
		"长程", "	chang2	cheng2",
		"抢种", "	qiang3	zhong4",
		"中枪", "	zhong4	qiang1",
		"强抢", "	qiang2	qiang3",
		"强将", "	qiang2	jiang4",
		"跄跄", "	qiang4	qiang4",
		"量程", "	liang2	cheng2",
		"兵长", "	bing1	chang2",
		"少将", "	shao4	jiang4",
		"长剑", "	chang2	jian4",
		"间种", "	jian4	zhong4",
		"重茧", "	chong2	jian3",
		"监生", "	jian4	sheng1",
		"重放", "	chong2	fang4",
		"手相", "	shou3	xiang4",
		"健将", "	jian4	jiang4",
		"将校", "	jiang4	xiao4",
		"唱片", "	chang4	pian1",
		"丧荒", "	sang1	huang1",
		"长红", "	chang2	hong2",
		"乘间", "	cheng2	jian4",
		"长工", "	chang2	gong1",
		"长风", "	chang2	feng1",
		"长方", "	chang2	fang1",
		"长调", "	chang2	diao4",
		"厂甸", "	chang3	dian4",
		"商汤", "	shang1	tang1",
		"哮喘", "	xiao4	chuan3",
		"抽中", "	chou1	zhong4",
		"长编", "	chang2	bian1",
		"长康", "	chang2	kang1",
		"重趼", "	chong2	jian3",
		"冲孔", "	chong4	kong3",
		"长勺", "	chang2	shao2",
		"长啸", "	chang2	xiao4",
		"长洲", "	chang2	zhou1",
		"长斋", "	chang2	zhai1",
		"长圆", "	chang2	yuan2",
		"长缨", "	chang2	ying1",
		"工长", "	gong1	chang2",
		"长行", "	chang2	xing2",
		"昌兴", "	chang1	xing1",
		"长性", "	chang2	xing4",
		"长笑", "	chang2	xiao4",
		"小传", "	xiao3	zhuan4",
		"成行", "	cheng2	hang2",
		"长痛", "	chang2	tong4",
		"长亭", "	chang2	ting2",
		"长天", "	chang2	tian1",
		"长松", "	chang2	song1",
		"盟长", "	meng2	chang2",
		"更香", "	geng1	xiang1",
		"丧钟", "	sang1	zhong1",
		"重瞳", "	zhong4	tong2",
		"重山", "	chong2	shan1",
		"将令", "	jiang4	ling4",
		"长身", "	chang2	shen1",
		"长山", "	chang2	shan1",
		"悄声", "	qiao3	sheng1",
		"峥巆", "	zheng1	ying2",
		"彷徨", "	pang2	huang2",
		"点种", "	dian3	zhong4",
		"重圆", "	chong2	yuan2",
		"春种", "	chun1	zhong4",
		"创痕", "	chuang1	hen2",
		"揣情", "	chuai3	qing2",
		"应征", "	ying4	zheng1",
		"杆状", "	gan3	zhuang4",
		"川藏", "	chuan1	zang4",
		"莨绸", "	liang2	chou2",
		"端量", "	duan1	liang2",
		"倒床", "	dao3	chuang2",
		"巷弄", "	xiang4	long4",
		"冯生", "	ping2	sheng1",
		"警长", "	jing3	chang2",
		"疯长", "	feng1	chang2",
		"天长", "	tian1	chang2",
		"怪相", "	guai4	xiang4",
		"了账", "	liao3	zhang4",
		"囊膪", "	nang1	chuai4",
		"囊揣", "	nang1	chuai4",
		"鼎铛", "	ding3	cheng1",
		"空转", "	kong1	zhuan4",
		"光栅", "	guang1	shan1",
		"长陵", "	chang2	ling2",
		"专横", "	zhuan1	heng4",
		"长卷", "	chang2	juan4",
		"长庆", "	chang2	qing4",
		"长桥", "	chang2	qiao2",
		"承应", "	cheng2	ying4",
		"将领", "	jiang4	ling3",
		"将官", "	jiang4	guan1",
		"长鸣", "	chang2	ming2",
		"长命", "	chang2	ming4",
		"商行", "	shang1	hang2",
		"短长", "	duan3	chang2",
		"长青", "	chang2	qing1",
		"黄钻", "	huang2	zuan4",
		"重行", "	chong2	xing2",
		"场院", "	chang2	yuan4",
		"方框", "	fang1	kuang4",
		"帐棚", "	zhang4	peng",
		"连中", "	lian2	zhong4",
		"强横", "	qiang2	heng4",
		"冲调", "	chong1	tiao2",
		"强劲", "	qiang2	jing4",
		"专差", "	zhuan1	chai1",
		"名将", "	ming2	jiang4",
		"饮场", "	yin4	chang3",
		"肇兴", "	zhao4	xing1",
		"矫情", "	jiao2	qing2",
		"供桌", "	gong4	zhuo1",
		"杠荡", "	gang4	dang4",
		"杠铃", "	gang4	ling2",
		"相干", "	xiang1	gan1",
		"瞭望", "	liao4	wang4",
		"枞阳", "	zong1	yang2",
		"干重", "	gan1	zhong4",
		"秤杆", "	cheng4	gan3",
		"疏率", "	shu1	shuai4",
		"相士", "	xiang4	shi4",
		"应选", "	ying4	xuan3",
		"崆峒", "	kong1	tong2",
		"筵上", "	yan2	shang3",
		"将佐", "	jiang4	zuo3",
		"套种", "	tao4	zhong4",
		"当真", "	dang4	zhen1",
		"槟榔", "	bing1	lang2",
		"应援", "	ying4	yuan2",
		"专著", "	zhuan1	zhu4",
		"睡觉", "	shui4	jiao4",
		"相国", "	xiang4	guo2",
		"光晕", "	guang1	yun4",
		"看相", "	kan4	xiang4",
		"直率", "	zhi2	shuai4",
		"拱券", "	gong3	xuan4",
		"长眼", "	chang2	yan3",
		"炸酱", "	zha2	jiang4",
		"扎挣", "	zha2	zheng1",
		"斋供", "	zhai1	gong4",
		"张拓", "	zhang1	tuo4",
		"侧棱", "	zhai1	leng2",
		"睡着", "	shui4	zhao2",
		"看中", "	kan4	zhong4",
		"干娘", "	gan1	niang2",
		"占梦", "	zhan1	meng4",
		"眄眄", "	mian4	mian4",
		"久长", "	jiu3	chang2",
		"相纸", "	xiang4	zhi3",
		"相处", "	xiang1	chu3",
		"乐章", "	yue4	zhang1",
		"少年", "	shao4	nian2",
		"相架", "	xiang4	jia4",
		"瞭哨", "	liao4	shao4",
		"相位", "	xiang4	wei4",
		"奠定", "	dian4	ding4",
		"正处", "	zheng4	chu3",
		"好胜", "	hao4	sheng4",
		"广为", "	guang3	wei2",
		"了了", "	liao3	liao3",
		"乾陵", "	qian2	ling2",
		"称为", "	cheng1	wei2",
		"干姜", "	gan1	jiang1",
		"种花", "	zhong4	hua1",
		"横行", "	heng2	xing2",
		"种树", "	zhong4	shu4",
		"种植", "	zhong4	zhi2",
		"称钱", "	chen4	qian2",
		"椆苕", "	diao4	tiao2",
		"乾隆", "	qian2	long2",
		"症结", "	zheng1	jie2",
		"广乐", "	guang3	yue4",
		"将门", "	jiang4	men2",
		"了当", "	liao3	dang4",
		"屏营", "	bing1	ying2",
		"光杆", "	guang1	gan3",
		"棕绷", "	zong1	beng1",
		"穷尽", "	qiong2	jin4",
		"槟州", "	bing1	zhou1",
		"检校", "	jian3	jiao4",
		"减削", "	jian3	xiao1",
		"穹肋", "	qiong2	lei4",
		"痴长", "	chi1	chang2",
		"岭巆", "	ling3	ying2",
		"将牌", "	jiang4	pai2",
		"校雠", "	jiao4	chou2",
		"交卷", "	jiao1	juan4",
		"校点", "	jiao4	dian3",
		"应身", "	ying4	shen1",
		"扛鼎", "	gang1	ding3",
		"笼罩", "	long3	zhao4",
		"杠房", "	gang4	fang2",
		"交差", "	jiao1	chai1",
		"归降", "	gui1	xiang2",
		"空调", "	kong1	tiao2",
		"挣开", "	zheng4	kai1",
		"笼槛", "	long2	jian4",
		"应天", "	ying4	tian1",
		"简朴", "	jian3	piao2",
		"当天", "	dang4	tian1",
		"笼统", "	long3	tong3",
		"更变", "	geng1	bian4",
		"属相", "	shu3	xiang4",
		"将尉", "	jiang4	wei4",
		"空闲", "	kong4	xian2",
		"乾县", "	qian2	xian4",
		"中暑", "	zhong4	shu3",
		"兴建", "	xing1	jian4",
		"为生", "	wei2	sheng1",
		"晃着", "	huang4	zhe",
		"兴平", "	xing1	ping2",
		"黄晕", "	huang2	yun4",
		"兴山", "	xing1	shan1",
		"兴宁", "	xing1	ning2",
		"封禅", "	feng1	shan4",
		"抓差", "	zhua1	chai1",
		"兴亡", "	xing1	wang2",
		"唪经", "	beng3	jing1",
		"为重", "	wei2	zhong4",
		"照片", "	zhao4	pian1",
		"兴兵", "	xing1	bing1",
		"校样", "	jiao4	yang4",
		"好尚", "	hao4	shang4",
		"考量", "	kao3	liang2",
		"行款", "	hang2	kuan3",
		"老将", "	lao3	jiang4",
		"央行", "	yang1	hang2",
		"种瓜", "	zhong4	gua1",
		"审校", "	shen3	jiao4",
		"种痘", "	zhong4	dou4",
		"烹调", "	peng1	tiao2",
		"佣钱", "	yong4	qian2",
		"行帮", "	hang2	bang1",
		"纯朴", "	chun2	piao2",
		"左传", "	zuo3	zhuan4",
		"工行", "	gong1	hang2",
		"绍兴", "	shao4	xing1",
		"框架", "	kuang4	jia4",
		"滚转", "	gun3	zhuan4",
		"用间", "	yong4	jian4",
		"缴卷", "	jiao3	juan4",
		"工坊", "	gong1	fang2",
		"过长", "	guo4	chang2",
		"应龙", "	ying4	long2",
		"主将", "	zhu3	jiang4",
		"狭长", "	xia2	chang2",
		"伙种", "	huo3	zhong4",
		"三重", "	san1	chong2",
		"大黄", "	dai4	huang2",
		"供应", "	gong1	ying4",
		"供奉", "	gong4	feng4",
		"胶粘", "	jiao1	nian2",
		"金相", "	jin1	xiang4",
		"照应", "	zhao4	ying4",
		"脑涨", "	nao3	zhang4",
		"翘棱", "	qiao2	leng1",
		"翘望", "	qiao2	wang4",
		"中彩", "	zhong4	cai3",
		"远兴", "	yuan3	xing1",
		"社长", "	she4	chang2",
		"少校", "	shao4	xiao4",
		"乐正", "	yue4	zheng4",
		"供款", "	gong4	kuan3",
		"中邪", "	zhong4	xie2",
		"好强", "	hao4	qiang2",
		"供暖", "	gong4	nuan3",
		"中肯", "	zhong4	ken3",
		"云裳", "	yun2	chang2",
		"更行", "	geng1	xing2",
		"碾坊", "	nian3	fang2",
		"横杠", "	heng2	gang4",
		"更定", "	geng1	ding4",
		"干粮", "	gan1	liang2",
		"更更", "	geng1	geng1",
		"见年", "	xian4	nian2",
		"原卷", "	yuan2	juan4",
		"枪杆", "	qiang1	gan3",
		"禅让", "	shan4	rang4",
		"中弹", "	zhong4	dan4",
		"尽忠", "	jin4	zhong1",
		"少间", "	shao3	jian4",
		"家种", "	jia1	zhong4",
		"翘首", "	qiao2	shou3",
		"羊圈", "	yang2	juan4",
		"上头", "	shang4	tou",
		"实相", "	shi2	xiang4",
		"肖邦", "	xiao1	bang1",
		"肖扬", "	xiao1	yang2",
		"爪蟾", "	zhua3	chan2",
		"婵媛", "	chan2	yuan2",
		"种牛", "	zhong4	niu2",
		"洋行", "	yang2	hang2",
		"片名", "	pian1	ming2",
		"差遣", "	chai1	qian3",
		"乐声", "	yue4	sheng1",
		"豁亮", "	huo4	liang4",
		"中舍", "	zhong1	she4",
		"宁愿", "	ning4	yuan4",
		"声乐", "	sheng1	yue4",
		"帑藏", "	tang3	zang4",
		"画框", "	hua4	kuang4",
		"将士", "	jiang4	shi4",
		"矿难", "	kuang4	nan4",
		"越长", "	yue4	chang2",
		"兼差", "	jian1	chai1",
		"诱降", "	you4	xiang2",
		"胸闷", "	xiong1	men1",
		"乾光", "	qian2	guang1",
		"拖拽", "	tuo1	zhuai4",
		"转来", "	zhuan4	lai2",
		"炸两", "	zha2	liang3",
		"左强", "	zuo3	jiang4",
		"航行", "	hang2	xing2",
		"修长", "	xiu1	chang2",
		"垫圈", "	dian4	juan4",
		"嘴长", "	zui3	chang2",
		"炒更", "	chao3	geng1",
		"转为", "	zhuan3	wei2",
		"填空", "	tian2	kong4",
		"宰相", "	zai3	xiang4",
		"兴隆", "	xing1	long2",
		"兴坏", "	xing1	huai4",
		"话长", "	hua4	chang2",
		"详尽", "	xiang2	jin4",
		"便嬛", "	pian2	xuan1",
		"干证", "	gan1	zheng4",
		"萎黄", "	wei3	huang2",
		"浆纸", "	jiang4	zhi3",
		"弹簧", "	tan2	huang2",
		"便便", "	pian2	pian2",
		"兴讼", "	xing1	song4",
		"保长", "	bao3	chang2",
		"兴荣", "	xing1	rong2",
		"便溺", "	bian4	niao4",
		"倥侗", "	kong1	tong2",
		"苍劲", "	cang1	jing4",
		"年少", "	nian2	shao4",
		"月相", "	yue4	xiang4",
		"公差", "	gong1	chai1",
		"兴庆", "	xing1	qing4",
		"九转", "	jiu3	zhuan4",
		"公共", "	gong1	gong4",
		"观塘", "	guan4	tang2",
		"船只", "	chuan2	zhi1",
		"宫观", "	gong1	guan4",
		"都长", "	dou1	chang2",
		"钻钻", "	zuan4	zuan4",
		"东兴", "	dong1	xing1",
		"兴贤", "	xing1	xian2",
		"万乘", "	wan4	sheng4",
		"诈降", "	zha4	xiang2",
		"和熊", "	huo2	xiong2",
		"兴能", "	xing1	neng2",
		"洋壳", "	yang2	qiao4",
		"东渐", "	dong1	jian1",
		"兴邦", "	xing1	bang1",
		"芳甸", "	fang1	dian4",
		"夏种", "	xia4	zhong4",
		"偏长", "	pian1	chang2",
		"中签", "	zhong4	qian1",
		"中甸", "	zhong1	dian4",
		"中标", "	zhong4	biao1",
		"折床", "	she2	chuang2",
		"中风", "	zhong4	feng1",
		"串供", "	chuan4	gong4",
		"相应", "	xiang1	ying4",
		"攘场", "	rang3	chang2",
		"命中", "	ming4	zhong4",
		"相公", "	xiang4	gong1",
		"招降", "	zhao1	xiang2",
		"深长", "	shen1	chang2",
		"遣将", "	qian3	jiang4",
		"戆直", "	zhuang4	zhi2",
		"营长", "	ying2	chang2",
		"幢幡", "	zhuang4	fan1",
		"周正", "	zhou1	zheng1",
		"相角", "	xiang4	jiao3",
		"撞倒", "	zhuang4	dao3",
		"中觉", "	zhong1	jiao4",
		"片长", "	pian4	chang2",
		"中招", "	zhong4	zhao1",
		"中兴", "	zhong1	xing1",
		"涨满", "	zhang4	man3",
		"状子", "	zhuang4	zi3",
		"倒帐", "	dao3	zhang4",
		"松茸", "	song1	rong2",
		"兜率", "	dou1	shuai4",
		"兴行", "	xing1	xing2",
		"会长", "	hui4	chang2",
		"弹唱", "	tan2	chang4",
		"桩子", "	zhuang1	zi3",
		"兴工", "	xing1	gong1",
		"飞将", "	fei1	jiang4",
		"兴县", "	xing1	xian4",
		"中选", "	zhong4	xuan3",
		"垦种", "	ken3	zhong4",
		"试种", "	shi4	zhong4",
		"掂量", "	dian1	liang",
		"周长", "	zhou1	chang2",
		"相片", "	xiang4	pian1",
		"相称", "	xiang1	chen4",
		"劝降", "	quan4	xiang2",
		"瘦长", "	shou4	chang2",
		"长钱", "	chang2	qian2",
		"洋相", "	yang2	xiang4",
		"钻工", "	zuan4	gong1",
		"廊坊", "	lang2	fang2",
		"相貌", "	xiang4	mao4",
		"行间", "	hang2	jian1",
		"卷面", "	juan4	mian4",
		"张角", "	zhang1	jue2",
		"强求", "	qiang3	qiu2",
		"漫长", "	man4	chang2",
		"屯邅", "	zhun1	zhan1",
		"斗转", "	dou3	zhuan3",
		"幸甚", "	xing4	shen4",
		"冲劲", "	chong4	jin4",
		"草率", "	cao3	shuai4",
		"吊丧", "	diao4	sang1",
		"还钱", "	huan2	qian2",
		"行当", "	hang2	dang1",
		"卷帘", "	juan4	lian2",
		"漂零", "	piao1	ling2",
		"削面", "	xiao1	mian4",
		"强嘴", "	jiang4	zui3",
		"行情", "	hang2	qing2",
		"小卷", "	xiao3	juan4",
		"凶煞", "	xiong1	sha4",
		"朝阳", "	zhao1	yang2",
		"还阳", "	huan2	yang2",
		"相切", "	xiang1	qie1",
		"着边", "	zhuo2	bian1",
		"漂荡", "	piao1	dang4",
		"着手", "	zhuo2	shou3",
		"小差", "	xiao3	chai1",
		"倒相", "	dao4	xiang4",
		"定兴", "	ding4	xing1",
		"着忙", "	zhao2	mang2",
		"海相", "	hai3	xiang4",
		"卷首", "	juan4	shou3",
		"定当", "	ding4	dang4",
		"位相", "	wei4	xiang4",
		"蟏蛸", "	xiao1	shao1",
		"外传", "	wai4	zhuan4",
		"乡侯", "	xiang1	hou4",
		"圈养", "	juan4	yang3",
		"张华", "	zhang1	hua4",
		"为政", "	wei2	zheng4",
		"螵蛸", "	piao1	xiao1",
		"康乾", "	kang1	qian2",
		"够戗", "	gou4	qiang4",
		"著称", "	zhu4	cheng1",
		"倒账", "	dao3	zhang4",
		"还童", "	huan2	tong2",
		"官差", "	guan1	chai1",
		"充分", "	chong1	fen4",
		"卷卷", "	juan4	juan4",
		"短供", "	duan3	gong4",
		"蒙山", "	meng3	shan1",
		"钻攻", "	zuan4	gong1",
		"下乘", "	xia4	sheng4",
		"荫凉", "	yin4	liang2",
		"傧相", "	bin1	xiang4",
		"僮族", "	zhuang4	zu2",
		"本相", "	ben3	xiang4",
		"多重", "	duo1	chong2",
		"朝鲜", "	chao2	xian3",
		"兴旺", "	xing1	wang4",
		"蒙茸", "	meng2	rong2",
		"看场", "	kan1	chang3",
		"蜀相", "	shu3	xiang4",
		"荥经", "	ying2	jing1",
		"鲜见", "	xian3	jian4",
		"倥偬", "	kong3	zong3",
		"蒜茸", "	suan4	rong2",
		"盖上", "	gai4	shang",
		"滇藏", "	dian1	zang4",
		"沧浪", "	cang1	lang2",
		"蓬茸", "	peng2	rong2",
		"守更", "	shou3	geng1",
		"浅鲜", "	qian3	xian3",
		"传略", "	zhuan4	lue4",
		"干将", "	gan4	jiang4",
		"延长", "	yan2	chang2",
		"大城", "	dai4	cheng2",
		"倔强", "	jue2	jiang4",
		"漂洋", "	piao1	yang2",
		"沉着", "	chen2	zhuo2",
		"萧乾", "	xiao1	qian2",
		"蚌山", "	beng4	shan1",
		"哗众", "	hua2	zhong4",
		"守丧", "	shou3	sang1",
		"嬛嬛", "	xuan1	xuan1",
		"荐椎", "	jian4	zhui1",
		"淳朴", "	chun2	piao2",
		"永兴", "	yong3	xing1",
		"哄哄", "	hong3	hong3",
		"建行", "	jian4	hang2",
		"哄弄", "	hong3	nong4",
		"弄堂", "	long4	tang2",
		"藏羚", "	zang4	ling2",
		"江干", "	jiang1	gan1",
		"藏青", "	zang4	qing1",
		"传赞", "	zhuan4	zan4",
		"弄脏", "	nong4	zang1",
		"螣蛇", "	teng2	she2",
		"拽文", "	zhuai4	wen2",
		"坤甸", "	kun1	dian4",
		"崩倒", "	beng1	dao3",
		"供词", "	gong4	ci2",
		"飘泊", "	piao1	bo2",
		"朴雅", "	piao2	ya3",
		"散匪", "	san3	fei3",
		"马圈", "	ma3	juan4",
		"口角", "	kou3	jue2",
		"脊椎", "	ji3	zhui1",
		"兴安", "	xing1	an1",
		"书卷", "	shu1	juan4",
		"撩人", "	liao2	ren2",
		"离间", "	li2	jian4",
		"燕赵", "	yan1	zhao4",
		"背榜", "	bei1	bang3",
		"不揣", "	bu4	chuai3",
		"为准", "	wei2	zhun3",
		"更阑", "	geng1	lan2",
		"馕糟", "	nang3	zao1",
		"笼络", "	long3	luo4",
		"案称", "	an4	cheng4",
		"为首", "	wei2	shou3",
		"移行", "	yi2	hang2",
		"兴业", "	xing1	ye4",
		"跂想", "	qi3	xiang3",
		"擂台", "	lei4	tai2",
		"羞臊", "	xiu1	sao4",
		"掖庭", "	ye4	ting2",
		"一刬", "	yi1	chan4",
		"掖垣", "	ye4	yuan2",
		"卵子", "	luan3	zi3",
		"盐分", "	yan2	fen4",
		"修为", "	xiu1	wei2",
		"难弹", "	nan2	tan2",
		"何曾", "	he2	zeng1",
		"风靡", "	feng1	mi3",
		"散架", "	san3	jia4",
		"雀子", "	qiao1	zi3",
		"撩拨", "	liao2	bo1",
		"首都", "	shou3	du1",
		"雅片", "	ya1	pian4",
		"养子", "	yang3	zi3",
		"散文", "	san3	wen2",
		"起更", "	qi3	geng1",
		"推度", "	tui1	duo2",
		"择刺", "	zhai2	ci4",
		"散射", "	san3	she4",
		"感兴", "	gan3	xing1",
		"步长", "	bu4	chang2",
		"危难", "	wei1	nan4",
		"拼攒", "	pin1	cuan2",
		"质朴", "	zhi4	piao2",
		"狼头", "	lang2	tou",
		"风镐", "	feng1	hao4",
		"风斗", "	feng1	dou3",
		"犍为", "	qian2	wei2",
		"武将", "	wu3	jiang4",
		"脱壳", "	tuo1	qiao4",
		"拽步", "	zhuai4	bu4",
		"本色", "	ben3	shai3",
		"牵累", "	qian1	lei3",
		"累坠", "	lei2	zhui4",
		"转距", "	zhuan4	ju4",
		"干甚", "	gan4	shen4",
		"更番", "	geng1	fan1",
		"轧钢", "	zha2	gang1",
		"体长", "	ti3	chang2",
		"粘滑", "	nian2	hua2",
		"残卷", "	can2	juan4",
		"煞神", "	sha4	shen2",
		"粘菌", "	nian2	jun1",
		"撒种", "	sa3	zhong3",
		"丰镐", "	feng1	hao4",
		"返还", "	fan3	huan2",
		"辩难", "	bian4	nan4",
		"比量", "	bi3	liang2",
		"高更", "	gao1	geng1",
		"纳降", "	na4	xiang2",
		"屏除", "	bing3	chu2",
		"高挑", "	gao1	tiao3",
		"梗咽", "	geng3	yan1",
		"屏退", "	bing3	tui4",
		"追查", "	zhui1	cha2",
		"撂倒", "	liao4	dao3",
		"财会", "	cai2	kuai4",
		"高着", "	gao1	zhao1",
		"蒙文", "	meng3	wen2",
		"细长", "	xi4	chang2",
		"退税", "	tui4	shui4",
		"掺假", "	chan1	jia3",
		"退色", "	tui4	shai3",
		"箭杆", "	jian4	gan3",
		"框图", "	kuang4	tu2",
		"框子", "	kuang4	zi",
		"农舍", "	nong2	she4",
		"累赘", "	lei2	zhui4",
		"山查", "	shan1	zha1",
		"散沙", "	san3	sha1",
		"压卷", "	ya1	juan4",
		"更新", "	geng1	xin1",
		"撩惹", "	liao2	re3",
		"背篓", "	bei1	lou3",
		"背包", "	bei1	bao1",
		"背带", "	bei1	dai4",
		"瓤子", "	rang2	zi3",
		"自省", "	zi4	xing3",
		"枝蔓", "	zhi1	wan4",
		"非分", "	fei1	fen4",
		"魏巍", "	wei4	wei1",
		"眼泡", "	yan3	pao1",
		"摒弃", "	bing4	qi4",
		"咽音", "	yan1	yin1",
		"杨子", "	yang2	zi3",
		"悄寂", "	qiao3	ji4",
		"齿龈", "	chi3	yin2",
		"阳子", "	yang2	zi3",
		"乾图", "	qian2	tu2",
		"诮呵", "	qiao4	he1",
		"曲工", "	qu3	gong1",
		"丽水", "	li2	shui3",
		"稽首", "	qi3	shou3",
		"翘曲", "	qiao2	qu1",
		"龈炎", "	yin2	yan2",
		"佛教", "	fo2	jiao4",
		"脾脏", "	pi2	zang1",
		"羊子", "	yang2	zi3",
		"浅子", "	qian3	zi3",
		"撇嘴", "	pie3	zui3",
		"签子", "	qian1	zi3",
		"查探", "	cha2	tan4",
		"发辫", "	fa4	bian4",
		"佛经", "	fo2	jing1",
		"胄子", "	zhou4	zi3",
		"选曲", "	xuan3	qu3",
		"龈音", "	yin2	yin1",
		"来头", "	lai2	tou",
		"发钗", "	fa4	chai1",
		"玄子", "	xuan2	zi3",
		"轩子", "	xuan1	zi3",
		"露背", "	lou4	bei4",
		"背头", "	bei1	tou2",
		"露白", "	lou4	bai2",
		"腰杆", "	yao1	gan3",
		"任丘", "	ren2	qiu1",
		"龟裂", "	jun1	lie4",
		"镟子", "	xuan4	zi3",
		"切分", "	qie1	fen1",
		"推倒", "	tui1	dao3",
		"一朝", "	yi1	zhao1",
		"询查", "	xun2	cha2",
		"作乐", "	zuo4	yue4",
		"显得", "	xian3	de",
		"反诘", "	fan3	jie2",
		"提防", "	di1	fang2",
		"馒头", "	man2	tou",
		"推杆", "	tui1	gan3",
		"严处", "	yan2	chu3",
		"扑棱", "	pu1	leng1",
		"青子", "	qing1	zi3",
		"翻倒", "	fan1	dao3",
		"骑缝", "	qi2	feng2",
		"佝瞀", "	kou4	mao4",
		"禽舍", "	qin2	she4",
		"供给", "	gong1	ji3",
		"脊线", "	ji3	xian4",
		"肉干", "	rou4	gan1",
		"使尽", "	shi3	jin4",
		"探查", "	tan4	cha2",
		"难倒", "	nan2	dao3",
		"脱脱", "	tui4	tui4",
		"切至", "	qie1	zhi4",
		"兴许", "	xing1	xu3",
		"掰扯", "	bai1	che",
		"食菌", "	shi2	jun4",
		"鸡枞", "	ji1	zong1",
		"隐潭", "	yin3	tan2",
		"压轴", "	ya1	zhou4",
		"颤栗", "	zhan4	li4",
		"押当", "	ya1	dang4",
		"栅极", "	shan1	ji2",
		"马蹬", "	ma3	deng4",
		"栅格", "	shan1	ge2",
		"兴义", "	xing1	yi4",
		"翘足", "	qiao2	zu2",
		"伊甸", "	yi1	dian4",
		"翘企", "	qiao2	qi3",
		"摆划", "	bai3	hua2",
		"兴和", "	xing1	he2",
		"古朴", "	gu3	piao2",
		"馆子", "	guan3	zi3",
		"八行", "	ba1	hang2",
		"馏分", "	liu2	fen4",
		"住舍", "	zhu4	she4",
		"散板", "	san3	ban3",
		"扑扇", "	pu1	shan1",
		"作为", "	zuo4	wei2",
		"拥塞", "	yong1	se4",
		"脏话", "	zang1	hua4",
		"差使", "	chai1	shi3",
		"扦子", "	qian1	zi3",
		"校阅", "	jiao4	yue4",
		"审度", "	shen3	duo2",
		"处方", "	chu3	fang1",
		"栓塞", "	shuan1	se4",
		"校勘", "	jiao4	kan1",
		"行号", "	hang2	hao2",
		"孱弱", "	chan2	ruo4",
		"泡桐", "	pao1	tong2",
		"黉舍", "	hong2	she4",
		"宏拓", "	hong2	tuo4",
		"行为", "	xing2	wei2",
		"豪横", "	hao2	heng4",
		"翘材", "	qiao2	cai2",
		"行市", "	hang2	shi4",
		"校舍", "	xiao4	she4",
		"行家", "	hang2	jia1",
		"侯刚", "	hou4	gang1",
		"行话", "	hang2	hua4",
		"行列", "	hang2	lie4",
		"朝珠", "	chao2	zhu1",
		"接应", "	jie1	ying4",
		"血钻", "	xue4	zuan4",
		"号叫", "	hao2	jiao4",
		"老少", "	lao3	shao4",
		"美差", "	mei3	chai1",
		"审查", "	shen3	cha2",
		"混浊", "	hun2	zhuo2",
		"氹仔", "	dang4	zai3",
		"计量", "	ji4	liang2",
		"解调", "	jie3	tiao2",
		"寒颤", "	han2	zhan4",
		"背债", "	bei1	zhai4",
		"巷道", "	hang4	dao4",
		"行道", "	hang2	dao4",
		"行规", "	hang2	gui1",
		"行会", "	hang2	hui4",
		"柴火", "	chai2	huo1",
		"亲家", "	qing4	jia",
		"深知", "	shen1	zhi4",
		"解元", "	jie4	yuan2",
		"编著", "	bian1	zhu4",
		"栟茶", "	bing1	cha2",
		"考卷", "	kao3	juan4",
		"江都", "	jiang1	du1",
		"好还", "	hao3	huan2",
		"缝纫", "	feng2	ren4",
		"宁肯", "	ning4	ken3",
		"挣得", "	zheng4	de2",
		"治丧", "	zhi4	sang1",
		"混熟", "	hun4	shou2",
		"行货", "	hang2	huo4",
		"行头", "	xing2	tou",
		"官倒", "	guan1	dao3",
		"横事", "	heng4	shi4",
		"行辈", "	hang2	bei4",
		"守分", "	shou3	fen4",
		"宅舍", "	zhai2	she4",
		"翘楚", "	qiao2	chu3",
		"哄逗", "	hong3	dou4",
		"罄尽", "	qing4	jin4",
		"稖头", "	bang4	tou",
		"横蛮", "	heng4	man2",
		"炳著", "	bing3	zhu4",
		"混蒙", "	hun4	meng1",
		"混行", "	hun2	xing2",
		"调酒", "	tiao2	jiu3",
		"调适", "	tiao2	shi4",
		"供稿", "	gong4	gao3",
		"摔打", "	shuai1	da2",
		"摒绝", "	bing4	jue2",
		"供果", "	gong4	guo3",
		"潦倒", "	liao2	dao3",
		"翘盼", "	qiao2	pan4",
		"系上", "	ji4	shang",
		"季相", "	ji4	xiang4",
		"绷带", "	beng1	dai4",
		"罗甸", "	luo2	dian4",
		"蛮横", "	man2	heng4",
		"办差", "	ban4	chai1",
		"户长", "	hu4	chang2",
		"沙参", "	sha1	shen1",
		"校对", "	jiao4	dui4",
		"宝钻", "	bao3	zuan4",
		"罐头", "	guan4	tou",
		"波长", "	bo1	chang2",
		"补种", "	bu3	zhong4",
		"泡面", "	pao1	mian4",
		"雹霰", "	bao2	xian4",
		"袅娜", "	niao3	nuo2",
		"扫帚", "	sao4	zhou3",
		"裁缝", "	cai2	feng2",
		"绷紧", "	beng1	jin3",
		"室町", "	shi4	ting3",
		"抱朴", "	bao4	piao2",
		"校验", "	jiao4	yan4",
		"绕腾", "	rao4	teng",
		"泰兴", "	tai4	xing1",
		"审处", "	shen3	chu3",
		"号丧", "	hao2	sang1",
		"差事", "	chai1	shi4",
		"拶刑", "	zan3	xing2",
		"燕京", "	yan1	jing1",
		"蒙难", "	meng2	nan4",
		"煎炸", "	jian1	zha2",
		"转去", "	zhuan4	qu4",
		"干冷", "	gan1	leng3",
		"干连", "	gan1	lian2",
		"跟差", "	gen1	chai1",
		"壳牌", "	qiao4	pai2",
		"较著", "	jiao4	zhu4",
		"转速", "	zhuan4	su4",
		"差派", "	chai1	pai4",
		"转鼓", "	zhuan4	gu3",
		"轘裂", "	huan4	lie4",
		"粗率", "	cu1	shuai4",
		"松散", "	song1	san3",
		"烘干", "	hong1	gan1",
		"香几", "	xiang1	ji1",
		"红晕", "	hong2	yun4",
		"特长", "	te4	chang2",
		"拓展", "	tuo4	zhan3",
		"更代", "	geng1	dai4",
		"更楼", "	geng1	lou2",
		"脏弹", "	zang1	dan4",
		"糨糊", "	jiang4	hu4",
		"载明", "	zai3	ming2",
		"该着", "	gai1	zhao2",
		"更改", "	geng1	gai3",
		"烟卷", "	yan1	juan4",
		"殷红", "	yan1	hong2",
		"桔梗", "	jie2	geng3",
		"干柴", "	gan1	chai2",
		"蔡甸", "	cai4	dian4",
		"脏煤", "	zang1	mei2",
		"更漏", "	geng1	lou4",
		"载湉", "	zai3	tian2",
		"脊梁", "	ji3	liang2",
		"燕山", "	yan1	shan1",
		"粘结", "	nian2	jie2",
		"肮脏", "	ang1	zang1",
		"更为", "	geng4	wei2",
		"拙著", "	zhuo1	zhu4",
		"粘滞", "	nian2	zhi4",
		"归还", "	gui1	huan2",
		"归省", "	gui1	xing3",
		"蔓菁", "	man2	jing1",
		"较为", "	jiao4	wei2",
		"能耐", "	neng2	nai4",
		"转矩", "	zhuan4	ju3",
		"浪头", "	lang4	tou",
		"宿将", "	su4	jiang4",
		"揣摩", "	chuai3	mo2",
		"净尽", "	jing4	jin4",
		"有空", "	you3	kong4",
		"换帖", "	huan4	tie3",
		"好闲", "	hao4	xian2",
		"被卷", "	bei4	juan4",
		"嚎丧", "	hao2	sang1",
		"淋病", "	lin4	bing4",
		"蜕壳", "	tui4	qiao4",
		"蜚蠊", "	fei3	lian2",
		"柴门", "	zhai4	men2",
		"蝃蝥", "	zhuo1	mao2",
		"家当", "	jia1	dang4",
		"海兴", "	hai3	xing1",
		"翻供", "	fan1	gong4",
		"缝制", "	feng2	zhi4",
		"宫阙", "	gong1	que4",
		"海参", "	hai3	shen1",
		"总得", "	zong3	dei3",
		"褪色", "	tui4	shai3",
		"要功", "	yao1	gong1",
		"寒伧", "	han2	chen",
		"揣测", "	chuai3	ce4",
		"争得", "	zheng1	de",
		"转炉", "	zhuan4	lu2",
		"转塔", "	zhuan4	ta3",
		"转子", "	zhuan4	zi3",
		"更迭", "	geng1	die2",
		"更始", "	geng1	shi3",
		"片头", "	pian1	tou2",
		"转椅", "	zhuan4	yi3",
		"转磨", "	zhuan4	mo4",
		"身处", "	shen1	chu3",
		"身分", "	shen1	fen4",
		"糨子", "	jiang4	zi3",
		"缝絍", "	feng2	ren4",
		"部将", "	bu4	jiang4",
		"蕉萃", "	qiao2	cui4",
		"未曾", "	wei4	zeng1",
		"拳头", "	quan2	tou",
		"身为", "	shen1	wei2",
		"煮熟", "	zhu3	shou2",
		"处身", "	chu3	shen1",
		"曾孙", "	zeng1	sun1",
		"有朝", "	you3	zhao1",
		"深信", "	shen1	xin4",
		"肖似", "	xiao4	si4",
		"鸿鹄", "	hong2	hu2",
		"攻难", "	gong1	nan4",
		"视为", "	shi4	wei2",
		"为学", "	wei2	xue2",
		"为是", "	wei2	shi4",
		"公子", "	gong1	zi3",
		"裁切", "	cai2	qie1",
		"裁处", "	cai2	chu3",
		"处处", "	chu3	chu4",
		"公仆", "	gong1	pu2",
		"号啕", "	hao2	tao2",
		"婉娩", "	wan3	wan3",
		"万石", "	wan4	dan4",
		"蝇子", "	ying2	zi3",
		"有为", "	you3	wei2",
		"见得", "	jian4	de",
		"蚌埠", "	beng4	bu4",
		"要求", "	yao1	qiu2",
		"要晕", "	yao1	yun1",
		"要挟", "	yao1	xie2",
		"要好", "	yao1	hao3",
		"要塞", "	yao4	sai4",
		"裁度", "	cai2	duo2",
		"萎谢", "	wei3	xie4",
		"朝雨", "	zhao1	yu3",
		"虾干", "	xia1	gan1",
		"朝歌", "	zhao1	ge1",
		"望都", "	wang4	du1",
		"螺杆", "	luo2	gan3",
		"萎落", "	wei3	luo4",
		"衣着", "	yi1	zhuo2",
		"衣冠", "	yi4	guan1",
		"朝夕", "	zhao1	xi1",
		"行距", "	hang2	ju4",
		"为然", "	wei2	ran2",
		"行语", "	hang2	yu3",
		"行业", "	hang2	ye4",
		"为下", "	wei2	xia4",
		"朝气", "	zhao1	qi4",
		"问难", "	wen4	nan4",
		"为什", "	wei4	shi2",
		"为数", "	wei2	shu4",
		"为头", "	wei2	tou2",
		"唯唯", "	wei3	wei3",
		"崴嵬", "	wei1	wei2",
		"血晕", "	xie3	yun4",
		"元曲", "	yuan2	qu3",
		"为文", "	wei2	wen2",
		"西藏", "	xi1	zang4",
		"僮仆", "	tong2	pu2",
		"蚂螂", "	ma1	lang2",
		"下处", "	xia4	chu3",
		"软呢", "	ruan3	ni2",
		"蔚县", "	yu4	xian4",
		"藤子", "	teng2	zi3",
		"切杆", "	qie1	gan1",
		"轩掖", "	xuan1	ye4",
		"俶傥", "	ti4	tang3",
		"轧辊", "	zha2	gun3",
		"轧制", "	zha2	zhi4",
		"切口", "	qie1	kou3",
		"更衣", "	geng1	yi1",
		"特供", "	te4	gong4",
		"切切", "	qie1	qie1",
		"切刀", "	qie1	dao1",
		"天得", "	tian1	de",
		"蕃茄", "	fan1	qie2",
		"天都", "	tian1	du1",
		"车斗", "	che1	dou3",
		"躯壳", "	qu1	qiao4",
		"躲难", "	duo3	nan4",
		"蹄髈", "	ti2	pang3",
		"蕃衍", "	fan2	yan3",
		"蔚为", "	wei4	wei2",
		"下切", "	xia4	qie1",
		"望子", "	wang4	zi3",
		"为害", "	wei2	hai4",
		"汪子", "	wang1	zi3",
		"萎败", "	wei3	bai4",
		"免得", "	mian3	de",
		"褪下", "	tun4	xia4",
		"俭薄", "	jian3	bo2",
		"萎顿", "	wei3	dun4",
		"尽早", "	jin4	zao3",
		"蝳蝐", "	dai4	mao4",
		"服丧", "	fu2	sang1",
		"嗡子", "	weng1	zi3",
		"叨扰", "	tao1	rao3",
		"着迷", "	zhao2	mi2",
		"藏族", "	zang4	zu2",
		"梃子", "	ting3	zi3",
		"轻薄", "	qing1	bo2",
		"轻子", "	qing1	zi3",
		"更次", "	geng1	ci4",
		"堂子", "	tang2	zi3",
		"唐子", "	tang2	zi3",
		"下头", "	xia4	tou",
		"下帖", "	xia4	tie3",
		"优游", "	you1	you2",
		"角子", "	jiao3	zi3",
		"切碎", "	qie1	sui4",
		"蕴藉", "	yun4	jie4",
		"斗六", "	dou3	liu4",
		"挑拔", "	tiao3	ba2",
		"包干", "	bao1	gan1",
		"神似", "	shen2	si4",
		"舌苔", "	she2	tai1",
		"兴起", "	xing1	qi3",
		"逃难", "	tao2	nan4",
		"曲靖", "	qu3	jing4",
		"木椆", "	mu4	zhou4",
		"腿杆", "	tui3	gan3",
		"敛巴", "	lian3	ba",
		"最为", "	zui4	wei2",
		"认识", "	ren4	shi",
		"会计", "	kuai4	ji4",
		"认为", "	ren4	wei2",
		"伞菌", "	san3	jun4",
		"备查", "	bei4	cha2",
		"处世", "	chu3	shi4",
		"诘问", "	jie2	wen4",
		"月分", "	yue4	fen4",
		"木栅", "	mu4	shan1",
		"村舍", "	cun1	she4",
		"北斗", "	bei3	dou3",
		"傀儡", "	kui3	lei3",
		"舍亲", "	she4	qin1",
		"梢子", "	shao1	zi3",
		"少子", "	shao3	zi3",
		"叨教", "	tao1	jiao4",
		"半分", "	ban4	fen1",
		"午觉", "	wu3	jiao4",
		"开衩", "	kai1	cha4",
		"开杆", "	kai1	gan3",
		"开拓", "	kai1	tuo4",
		"数九", "	shu3	jiu3",
		"舍人", "	she4	ren2",
		"数落", "	shu3	luo4",
		"苦差", "	ku3	chai1",
		"杓子", "	shao2	zi",
		"十干", "	shi2	gan1",
		"斗胆", "	dou3	dan3",
		"倒坍", "	dao3	tan1",
		"汇差", "	hui4	cha1",
		"数出", "	shu3	chu1",
		"北碚", "	bei3	bei4",
		"数数", "	shu3	shu4",
		"甚的", "	shen4	de",
		"处事", "	chu3	shi4",
		"家伙", "	jia1	huo",
		"处置", "	chu3	zhi4",
		"冠以", "	guan4	yi3",
		"筒子", "	tong3	zi3",
		"桶子", "	tong3	zi3",
		"桐子", "	tong2	zi3",
		"铜子", "	tong2	zi3",
		"瞳子", "	tong2	zi3",
		"最差", "	zui4	cha1",
		"冠词", "	guan4	ci2",
		"调皮", "	tiao2	pi2",
		"调理", "	tiao2	li3",
		"做为", "	zuo4	wei2",
		"痛恶", "	tong4	wu4",
		"调拨", "	tiao2	bo1",
		"调戏", "	tiao2	xi4",
		"调和", "	tiao2	he2",
		"透切", "	tou4	qie1",
		"调剂", "	tiao2	ji4",
		"曾都", "	zeng1	du1",
		"图卷", "	tu2	juan4",
		"停泊", "	ting2	bo2",
		"冠子", "	guan4	zi",
		"藏獒", "	zang4	ao2",
		"调色", "	tiao2	se4",
		"调资", "	tiao2	zi1",
		"拓殖", "	tuo4	zhi2",
		"外切", "	wai4	qie1",
		"处在", "	chu3	zai4",
		"月晕", "	yue4	yun4",
		"月氏", "	rou4	zhi1",
		"处暑", "	chu3	shu3",
		"解数", "	xie4	shu4",
		"解廌", "	xie4	zhi4",
		"角斗", "	jue2	dou4",
		"歪货", "	wai3	huo4",
		"处决", "	chu3	jue2",
		"角逐", "	jue2	zhu2",
		"藏独", "	zang4	du2",
		"处治", "	chu3	zhi4",
		"处分", "	chu3	fen4",
		"处男", "	chu3	nan2",
		"五通", "	wu3	tong4",
		"藏语", "	zang4	yu3",
		"铜佛", "	tong2	fo2",
		"铜模", "	tong2	mu2",
		"凳子", "	deng4	zi3",
		"童仆", "	tong2	pu2",
		"调速", "	tiao2	su4",
		"更替", "	geng1	ti4",
		"逃奔", "	tao2	ben4",
		"面糊", "	mian4	hu4",
		"名曲", "	ming2	qu3",
		"搭挡", "	da1	dang4",
		"曲蟮", "	qu3	shan4",
		"挨冻", "	ai2	dong4",
		"搭当", "	da1	dang4",
		"佛性", "	fo2	xing4",
		"架式", "	jia4	shi",
		"供物", "	gong4	wu4",
		"脏字", "	zang1	zi4",
		"揭载", "	jie1	zai3",
		"脏土", "	zang1	tu3",
		"电锯", "	dian4	ju1",
		"曲静", "	qu3	jing4",
		"散列", "	san3	lie4",
		"难处", "	nan2	chu3",
		"卷须", "	juan4	xu1",
		"恰切", "	qia4	qie1",
		"难为", "	nan2	wei2",
		"查看", "	cha2	kan4",
		"考查", "	kao3	cha2",
		"颓萎", "	tui2	wei3",
		"查处", "	cha2	chu3",
		"发卷", "	fa1	juan4",
		"腰折", "	yao1	she2",
		"袷袢", "	qia1	pan4",
		"发小", "	fa4	xiao3",
		"改为", "	gai3	wei2",
		"佛坪", "	fo2	ping2",
		"切开", "	qie1	kai1",
		"佛典", "	fo2	dian3",
		"摇杆", "	yao2	gan3",
		"耍子", "	shua3	zi3",
		"担懮", "	dan1	you1",
		"发型", "	fa4	xing2",
		"掖县", "	ye4	xian4",
		"教子", "	jiao4	zi3",
		"佛山", "	fo2	shan1",
		"耗尽", "	hao4	jin4",
		"也曾", "	ye3	zeng1",
		"发脚", "	fa4	jiao3",
		"切花", "	qie1	hua1",
		"耳片", "	er3	pian1",
		"胶子", "	jiao1	zi3",
		"胡同", "	hu2	tong4",
		"要切", "	yao4	qie1",
		"佛冈", "	fo2	gang1",
		"电荷", "	dian4	he4",
		"难民", "	nan4	min2",
		"暗杠", "	an4	gang4",
		"搜查", "	sou1	cha2",
		"鲁甸", "	lu3	dian4",
		"鬈发", "	quan2	fa4",
		"音乐", "	yin1	yue4",
		"阙下", "	que4	xia4",
		"非难", "	fei1	nan4",
		"鮟鱇", "	an1	kang1",
		"臣子", "	chen2	zi3",
		"攒簇", "	cuan2	cu4",
		"臣仆", "	chen2	pu2",
		"非得", "	fei1	dei3",
		"让子", "	rang4	zi3",
		"临帖", "	lin2	tie4",
		"临难", "	lin2	nan4",
		"圩镇", "	xu1	zhen4",
		"洋落", "	yang2	la4",
		"犬子", "	quan3	zi3",
		"鹿角", "	lu4	jiao3",
		"鹿茸", "	lu4	rong2",
		"职分", "	zhi2	fen4",
		"叶韵", "	xie2	yun4",
		"面的", "	mian4	di2",
		"肖恩", "	xiao1	en1",
		"畜养", "	xu4	yang3",
		"撇号", "	pie3	hao4",
		"颈子", "	jing3	zi3",
		"教课", "	jiao1	ke4",
		"学舍", "	xue2	she4",
		"叶心", "	xie2	xin1",
		"切人", "	qie1	ren2",
		"枸橼", "	ju3	yuan2",
		"高头", "	gao1	tou",
		"却倒", "	que4	dao3",
		"脊令", "	ji2	ling2",
		"乾德", "	qian2	de2",
		"腱子", "	jian4	zi3",
		"仰给", "	yang3	ji3",
		"可调", "	ke3	tiao2",
		"敢为", "	gan3	wei2",
		"脚本", "	jue2	ben3",
		"脏污", "	zang1	wu1",
		"卸载", "	xie4	zai3",
		"电子", "	dian4	zi3",
		"烟杆", "	yan1	gan3",
		"切屑", "	qie1	xie4",
		"露出", "	lou4	chu1",
		"露怯", "	lou4	qie4",
		"叱吒", "	chi4	zha4",
		"畜产", "	xu4	chan3",
		"发廊", "	fa4	lang2",
		"着陆", "	zhuo2	lu4",
		"贡嘎", "	gong4	ga2",
		"切磋", "	qie1	cuo1",
		"瘫倒", "	tan1	dao3",
		"曾祖", "	zeng1	zu3",
		"天姥", "	tian1	mu3",
		"西兴", "	xi1	xing1",
		"调气", "	tiao2	qi4",
		"薄晓", "	bo2	xiao3",
		"曾子", "	zeng1	zi3",
		"薄产", "	bo2	chan3",
		"猫腰", "	mao2	yao1",
		"切糕", "	qie1	gao1",
		"调息", "	tiao2	xi1",
		"苕溪", "	tiao2	xi1",
		"薄田", "	bo2	tian2",
		"丰都", "	feng1	du1",
		"豉油", "	chi3	you2",
		"豆豉", "	dou4	chi3",
		"调序", "	tiao2	xu4",
		"蹊径", "	xi1	jing4",
		"豆佉", "	dou4	qia1",
		"豁然", "	huo4	ran2",
		"澹台", "	tan2	tai2",
		"更夫", "	geng1	fu1",
		"假藉", "	jia3	jie4",
		"曲面", "	qu3	mian4",
		"着魔", "	zhao2	mo2",
		"倒头", "	dao3	tou2",
		"阘茸", "	ta4	rong2",
		"嗒丧", "	ta4	sang4",
		"线子", "	xian4	zi3",
		"蚬子", "	xian3	zi3",
		"馅子", "	xian4	zi3",
		"弦子", "	xian2	zi3",
		"本分", "	ben3	fen4",
		"刊载", "	kan1	zai3",
		"莲都", "	lian2	du1",
		"辗轧", "	zhan3	ya4",
		"蒙覆", "	meng3	fu4",
		"探杆", "	tan4	gan3",
		"辟雍", "	bi4	yong1",
		"仙佛", "	xian1	fo2",
		"切韵", "	qie1	yun4",
		"末了", "	mo4	liao3",
		"莲子", "	lian2	zi3",
		"切除", "	qie1	chu2",
		"更卒", "	geng1	zu2",
		"变得", "	bian4	de",
		"藉口", "	jie4	kou3",
		"原子", "	yuan2	zi3",
		"薄情", "	bo2	qing2",
		"薄命", "	bo2	ming4",
		"分内", "	fen4	nei4",
		"趼子", "	jian3	zi3",
		"更鼓", "	geng1	gu3",
		"调合", "	tiao2	he2",
		"起哄", "	qi3	hong4",
		"薄幸", "	bo2	xing4",
		"调护", "	tiao2	hu4",
		"调级", "	tiao2	ji2",
		"赢得", "	ying2	de",
		"调达", "	tiao2	da2",
		"赚得", "	zuan4	de",
		"质难", "	zhi4	nan4",
		"薄明", "	bo2	ming2",
		"分外", "	fen4	wai4",
		"调幅", "	tiao2	fu2",
		"散漫", "	san3	man4",
		"录供", "	lu4	gong4",
		"点子", "	dian3	zi3",
		"搪塞", "	tang2	se4",
		"胡芫", "	hu2	yuan2",
		"跂望", "	qi4	wang4",
		"分散", "	fen1	san3",
		"藉由", "	jie4	you2",
		"踺子", "	jian4	zi3",
		"藉着", "	jie4	zhe",
		"谢帖", "	xie4	tie3",
		"帖文", "	tie3	wen2",
		"帖学", "	tie4	xue2",
		"藏掖", "	cang2	ye4",
		"曾朴", "	zeng1	pu3",
		"厅子", "	ting1	zi3",
		"听子", "	ting1	zi3",
		"薄酬", "	bo2	chou2",
		"资兴", "	zi1	xing1",
		"跌倒", "	die1	dao3",
		"分叉", "	fen1	cha4",
		"跪倒", "	gui4	dao3",
		"跟头", "	gen1	tou",
		"天雨", "	tian1	yu4",
		"分为", "	fen1	wei2",
		"铣削", "	xi3	xiao1",
		"田子", "	tian2	zi3",
		"佻薄", "	tiao1	bo2",
		"调测", "	tiao2	ce4",
		"更递", "	geng1	di4",
		"冰斗", "	bing1	dou3",
		"攘辟", "	rang3	bi4",
		"供事", "	gong4	shi4",
		"重估", "	chong2	gu1",
		"长股", "	chang2	gu3",
		"春假", "	chun1	jia4",
		"重覆", "	chong2	fu4",
		"重合", "	chong2	he2",
		"重午", "	chong2	wu3",
		"发怔", "	fa1	zheng4",
		"斗方", "	dou3	fang1",
		"斗拱", "	dou3	gong3",
		"长局", "	chang2	ju2",
		"长句", "	chang2	ju4",
		"铅山", "	yan2	shan1",
		"页框", "	ye4	kuang4",
		"释卷", "	shi4	juan4",
		"丑角", "	chou3	jue2",
		"醒豁", "	xing3	huo4",
		"顶杆", "	ding3	gan3",
		"顺差", "	shun4	cha1",
		"重启", "	chong2	qi3",
		"强逼", "	qiang3	bi1",
		"强迫", "	qiang3	po4",
		"登载", "	deng1	zai3",
		"长图", "	chang2	tu2",
		"橙子", "	cheng2	zi3",
		"落枕", "	lao4	zhen3",
		"昌都", "	chang1	du1",
		"靓丽", "	liang4	li4",
		"空缺", "	kong4	que1",
		"长衣", "	chang2	yi1",
		"空难", "	kong1	nan4",
		"打量", "	da3	liang",
		"菌柄", "	jun4	bing3",
		"长吁", "	chang2	xu1",
		"长须", "	chang2	xu1",
		"扣应", "	kou4	ying4",
		"铺张", "	pu1	zhang1",
		"长嘶", "	chang2	si1",
		"得中", "	de2	zhong4",
		"尽兴", "	jin4	xing4",
		"桦甸", "	hua4	dian4",
		"搀和", "	chan1	huo",
		"窨井", "	yin4	jing3",
		"销假", "	xiao1	jia4",
		"铣铁", "	xian3	tie3",
		"银行", "	yin2	hang2",
		"地转", "	di4	zhuan4",
		"华山", "	hua4	shan1",
		"竺乾", "	zhu2	qian2",
		"配称", "	pei4	chen4",
		"潮差", "	chao2	cha1",
		"长理", "	chang2	li3",
		"攀供", "	pan1	gong4",
		"冻干", "	dong4	gan1",
		"掷色", "	zhi4	shai3",
		"拧开", "	ning3	kai1",
		"长路", "	chang2	lu4",
		"长利", "	chang2	li4",
		"长丽", "	chang2	li4",
		"重提", "	chong2	ti2",
		"晕针", "	yun4	zhen1",
		"白卷", "	bai2	juan4",
		"章子", "	zhang1	zi3",
		"重屋", "	chong2	wu1",
		"暖和", "	nuan3	huo",
		"重沓", "	chong2	ta4",
		"应聘", "	ying4	pin4",
		"冲压", "	chong4	ya1",
		"纶巾", "	guan1	jin1",
		"伎俩", "	ji4	liang3",
		"解款", "	jie4	kuan3",
		"估量", "	gu1	liang",
		"失调", "	shi1	tiao2",
		"重子", "	zhong4	zi3",
		"时兴", "	shi2	xing1",
		"酌处", "	zhuo2	chu3",
		"重塑", "	chong2	su4",
		"长戟", "	chang2	ji3",
		"强拉", "	qiang3	la1",
		"强子", "	qiang2	zi3",
		"邓拓", "	deng4	tuo4",
		"长河", "	chang2	he2",
		"落炕", "	lao4	kang4",
		"强似", "	qiang2	si4",
		"酬酢", "	chou2	zuo4",
		"横财", "	heng4	cai2",
		"弹性", "	tan2	xing4",
		"重组", "	chong2	zu3",
		"场圃", "	chang2	pu3",
		"重复", "	chong2	fu4",
		"重荷", "	zhong4	he4",
		"重聚", "	chong2	ju4",
		"菲酌", "	fei3	zhuo2",
		"自传", "	zi4	zhuan4",
		"螲蟷", "	die2	dang1",
		"技俩", "	ji4	liang3",
		"弹跳", "	tan2	tiao4",
		"抄查", "	chao1	cha2",
		"长足", "	chang2	zu2",
		"朝晖", "	zhao1	hui1",
		"胜子", "	sheng4	zi3",
		"甚或", "	shen4	huo4",
		"养分", "	yang3	fen4",
		"王著", "	wang2	zhu4",
		"撩开", "	liao2	kai1",
		"撩逗", "	liao2	dou4",
		"退还", "	tui4	huan2",
		"苍术", "	cang1	zhu2",
		"正子", "	zheng4	zi3",
		"甲壳", "	jia3	qiao4",
		"甚微", "	shen4	wei1",
		"道观", "	dao4	guan4",
		"筠连", "	jun1	lian2",
		"田舍", "	tian2	she4",
		"用处", "	yong4	chu3",
		"用尽", "	yong4	jin4",
		"产假", "	chan3	jia4",
		"产仔", "	chan3	zai3",
		"生发", "	sheng1	fa4",
		"欢势", "	huan1	shi",
		"道行", "	dao4	heng2",
		"道藏", "	dao4	zang4",
		"生子", "	sheng1	zi3",
		"岑参", "	cen2	shen1",
		"正意", "	zheng1	yi4",
		"本行", "	ben3	hang2",
		"着落", "	zhuo2	luo4",
		"择菜", "	zhai2	cai4",
		"颠茄", "	dian1	qie2",
		"放倒", "	fang4	dao3",
		"答腔", "	da1	qiang1",
		"甚且", "	shen4	qie3",
		"着紧", "	zhao2	jin3",
		"风头", "	feng1	tou",
		"查检", "	cha2	jian3",
		"着花", "	zhuo2	hua1",
		"连载", "	lian2	zai3",
		"正安", "	zheng1	an",
		"连累", "	lian2	lei3",
		"查岗", "	cha2	gang3",
		"腔子", "	qiang1	zi3",
		"废卷", "	fei4	juan4",
		"通什", "	tong1	shi2",
		"年假", "	nian2	jia4",
		"着处", "	zhuo2	chu4",
		"饼干", "	bing3	gan1",
		"这些", "	zhei4	xie1",
		"查边", "	cha2	bian1",
		"掺和", "	chan1	huo",
		"甜头", "	tian2	tou",
		"尽情", "	jin4	qing2",
		"量器", "	liang2	qi4",
		"横折", "	heng2	she2",
		"量测", "	liang2	ce4",
		"横暴", "	heng4	bao4",
		"橡子", "	xiang4	zi3",
		"华龙", "	hua4	long2",
		"量度", "	liang2	du4",
		"盛器", "	cheng2	qi4",
		"星斗", "	xing1	dou3",
		"量子", "	liang4	zi3",
		"斗柄", "	dou3	bing3",
		"量计", "	liang2	ji4",
		"皇子", "	huang2	zi3",
		"量具", "	liang2	ju4",
		"重译", "	chong2	yi4",
		"雕刀", "	diao1	dao1",
		"刁斗", "	diao1	dou3",
		"立传", "	li4	zhuan4",
		"横祸", "	heng4	huo4",
		"长驱", "	chang2	qu1",
		"凋萎", "	diao1	wei3",
		"尽性", "	jin4	xing4",
		"尽孝", "	jin4	xiao4",
		"星宿", "	xing1	xiu4",
		"显豁", "	xian3	huo4",
		"着眼", "	zhuo2	yan3",
		"查照", "	cha2	zhao4",
		"风干", "	feng1	gan1",
		"曲江", "	qu3	jiang1",
		"游说", "	you2	shui4",
		"差人", "	chai1	ren2",
		"甚至", "	shen4	zhi4",
		"枪子", "	qiang1	zi3",
		"着然", "	zhuo2	ran2",
		"年载", "	nian2	zai3",
		"甚为", "	shen4	wei2",
		"鞅牛", "	yang3	niu2",
		"显著", "	xian3	zhu4",
		"空白", "	kong4	bai2",
		"落色", "	lao4	shai3",
		"晒干", "	shai4	gan1",
		"横切", "	heng2	qie1",
		"钓杆", "	diao4	gan3",
		"长日", "	chang2	ri4",
		"找头", "	zhao3	tou",
		"易传", "	yi4	zhuan4",
		"电镐", "	dian4	hao4",
		"失着", "	shi1	zhao1",
		"掠阵", "	lue3	zhen4",
		"畹町", "	wan3	ding1",
		"舍监", "	she4	jian1",
		"油坊", "	you2	fang2",
		"舍间", "	she4	jian1",
		"耩子", "	jiang3	zi3",
		"膙子", "	jiang3	zi3",
		"应约", "	ying4	yue1",
		"没空", "	mei2	kong4",
		"应心", "	ying4	xin1",
		"北漂", "	bei3	piao1",
		"甚佳", "	shen4	jia1",
		"应是", "	ying4	shi4",
		"干笑", "	gan1	xiao4",
		"奔命", "	ben4	ming4",
		"应会", "	ying4	hui4",
		"应化", "	ying4	hua4",
		"神乐", "	shen2	yue4",
		"应给", "	ying4	gei3",
		"单杠", "	dan1	gang4",
		"校改", "	jiao4	gai3",
		"脚杆", "	jiao3	gan3",
		"共处", "	gong4	chu3",
		"干等", "	gan1	deng3",
		"丧假", "	sang1	jia4",
		"教给", "	jiao1	gei3",
		"二重", "	er4	chong2",
		"曾加", "	zeng1	jia1",
		"好战", "	hao4	zhan4",
		"再兴", "	zai4	xing1",
		"榠楂", "	ming2	cha2",
		"占卦", "	zhan1	gua4",
		"侧歪", "	zhai1	wai1",
		"斋舍", "	zhai1	she4",
		"卜征", "	bu3	zheng1",
		"曾云", "	zeng1	yun2",
		"三省", "	san1	xing3",
		"桑干", "	sang1	gan1",
		"干俸", "	gan1	feng4",
		"唤头", "	huan4	tou",
		"曾华", "	zeng1	hua2",
		"好氧", "	hao4	yang3",
		"干冰", "	gan1	bing1",
		"乾坤", "	qian2	kun1",
		"黾勉", "	min3	mian3",
		"僧舍", "	seng1	she4",
		"藏民", "	zang4	min2",
		"藏蓝", "	zang4	lan2",
		"家雀", "	jia1	qiao3",
		"诱供", "	you4	gong4",
		"渐染", "	jian1	ran3",
		"喧哗", "	xuan1	hua2",
		"抗折", "	kang4	she2",
		"倾倒", "	qing1	dao3",
		"倾尽", "	qing1	jin4",
		"报应", "	bao4	ying4",
		"捞着", "	lao1	zhao2",
		"僬侥", "	jiao1	yao2",
		"刁难", "	diao1	nan4",
		"调琴", "	tiao2	qin2",
		"文卷", "	wen2	juan4",
		"尾椎", "	wei3	zhui1",
		"为真", "	wei2	zhen1",
		"调处", "	tiao2	chu3",
		"咳喘", "	ke2	chuan3",
		"允当", "	yun3	dang4",
		"外行", "	wai4	hang2",
		"为性", "	wei2	xing4",
		"报丧", "	bao4	sang1",
		"分行", "	fen1	hang2",
		"挑檐", "	tiao3	yan2",
		"躺倒", "	tang3	dao3",
		"切断", "	qie1	duan4",
		"切换", "	qie1	huan4",
		"挑担", "	tiao1	dan4",
		"勘校", "	kan1	jiao4",
		"丧尸", "	sang1	shi1",
		"夺冠", "	duo2	guan4",
		"柬帖", "	jian3	tie3",
		"卓著", "	zhuo2	zhu4",
		"卒中", "	cu4	zhong4",
		"羽裳", "	yu3	chang2",
		"上齐", "	shang4	ji4",
		"了事", "	liao3	shi4",
		"诱哄", "	you4	hong4",
		"了却", "	liao3	que4",
		"了结", "	liao3	jie2",
		"少奶", "	shao4	nai3",
		"分当", "	fen4	dang1",
		"了解", "	liao3	jie3",
		"有甚", "	you3	shen4",
		"稍为", "	shao1	wei2",
		"丧尽", "	sang4	jin4",
		"有间", "	you3	jian4",
		"了然", "	liao3	ran2",
		"塞翁", "	sai4	weng1",
		"精尽", "	jing1	jin4",
		"兴筑", "	xing1	zhu4",
		"传记", "	zhuan4	ji4",
		"干癣", "	gan1	xuan3",
		"干瘦", "	gan1	shou4",
		"失当", "	shi1	dang4",
		"巡更", "	xun2	geng1",
		"介壳", "	jie4	qiao4",
		"校注", "	jiao4	zhu4",
		"甚者", "	shen4	zhe3",
		"动弹", "	dong4	tan",
		"生得", "	sheng1	de",
		"什邡", "	shi2	fang1",
		"神煞", "	shen2	sha4",
		"哗变", "	hua2	bian4",
		"食甚", "	shi2	shen4",
		"六行", "	liu4	hang2",
		"勤朴", "	qin2	piao2",
		"舒卷", "	shu1	juan4",
		"雪糁", "	xue3	shen1",
		"吓声", "	he4	sheng1",
		"天台", "	tian1	tai1",
		"来朝", "	lai2	zhao1",
		"天分", "	tian1	fen4",
		"悬瀑", "	xuan2	bao4",
		"赎当", "	shu2	dang4",
		"供品", "	gong4	pin3",
		"惊倒", "	jing1	dao3",
		"胜似", "	sheng4	si4",
		"今朝", "	jin1	zhao1",
		"数算", "	shu3	suan4",
		"乱弹", "	luan4	tan2",
		"嘉兴", "	jia1	xing1",
		"解送", "	jie4	song4",
		"十行", "	shi2	hang2",
		"劲草", "	jing4	cao3",
		"劲直", "	jing4	zhi2",
		"劲烈", "	jing4	lie4",
		"一唱", "	yi2	chang4",
		"一长", "	yi1	chang2",
		"诗卷", "	shi1	juan4",
		"哗笑", "	hua2	xiao4",
		"匀称", "	yun2	chen4",
		"乘舆", "	sheng4	yu2",
		"人参", "	ren2	shen1",
		"甚是", "	shen4	shi4",
		"娇娜", "	jiao1	nuo2",
		"呛咕", "	qiang1	gu",
		"嚼头", "	jiao2	tou2",
		"浇头", "	jiao1	tou",
		"引吭", "	yin3	hang2",
		"勾当", "	gou4	dang4",
		"解差", "	jie4	chai1",
		"数说", "	shu3	shuo1",
		"圩场", "	xu1	chang2",
		"协调", "	xie2	tiao2",
		"苫盖", "	shan4	gai4",
		"作兴", "	zuo4	xing1",
		"龙湫", "	long2	qiu1",
		"刷白", "	shua4	bai2",
		"漫卷", "	man4	juan4",
		"焦干", "	jiao1	gan1",
		"晕圈", "	yun4	quan1",
		"善处", "	shan4	chu3",
		"佳兴", "	jia1	xing1",
		"干净", "	gan1	jing4",
		"嘉应", "	jia1	ying4",
		"作料", "	zuo2	liao4",
		"监本", "	jian4	ben3",
		"干潮", "	gan1	chao2",
		"干煸", "	gan1	bian1",
		"煞星", "	sha4	xing1",
		"乐段", "	yue4	duan4",
		"丧事", "	sang1	shi4",
		"蒙事", "	meng1	shi4",
		"园舍", "	yuan2	she4",
		"圜丘", "	yuan2	qiu1",
		"好动", "	hao4	dong4",
		"遛鸟", "	liu4	niao3",
		"作坊", "	zuo1	fang",
		"副相", "	fu4	xiang4",
		"佛光", "	fo2	guang1",
		"供职", "	gong4	zhi2",
		"供花", "	gong4	hua1",
		"茎杆", "	jing1	gan3",
		"嚼舌", "	jiao2	she2",
		"是甚", "	shi4	shen4",
		"天干", "	tian1	gan1",
		"佣金", "	yong4	jin1",
		"佛像", "	fo2	xiang4",
		"劲射", "	jing4	she4",
		"嘲哳", "	zhao1	zha1",
		"雁行", "	yan4	hang2",
		"太监", "	tai4	jian4",
		"路长", "	lu4	chang2",
		"龙仔", "	long2	zai3",
		"加冠", "	jia1	guan4",
		"洋镐", "	yang2	hao4",
		"尽让", "	jin4	rang4",
		"收载", "	shou1	zai3",
		"尽欢", "	jin4	huan1",
		"掩卷", "	yan3	juan4",
		"磟碡", "	liu4	zhou2",
		"都昌", "	du1	chang1",
		"诗行", "	shi1	hang2",
		"槛车", "	jian4	che1",
		"斜杠", "	xie2	gang4",
		"倒找", "	dao3	zhao3",
		"斗篷", "	dou3	peng2",
		"长物", "	chang2	wu4",
		"微调", "	wei1	tiao2",
		"长牙", "	chang2	ya2",
		"乐清", "	yue4	qing1",
		"收假", "	shou1	jia4",
		"料斗", "	liao4	dou3",
		"长武", "	chang2	wu3",
		"困觉", "	kun4	jiao4",
		"改行", "	gai3	hang2",
		"楞严", "	leng4	yan2",
		"瞒哄", "	man2	hong3",
		"数清", "	shu3	qing1",
		"称职", "	chen4	zhi2",
		"开钻", "	kai1	zuan4",
		"杠头", "	gang4	tou2",
		"零散", "	ling2	san3",
		"知了", "	zhi1	liao3",
		"扁担", "	bian3	dan4",
		"开卷", "	kai1	juan4",
		"斗筲", "	dou3	shao1",
		"刀削", "	dao1	xiao1",
		"当是", "	dang4	shi4",
		"倒剪", "	dao3	jian3",
		"馆舍", "	guan3	she4",
		"管乐", "	guan3	yue4",
		"水分", "	shui3	fen4",
		"藤蔓", "	teng2	wan4",
		"调价", "	tiao2	jia4",
		"奖掖", "	jiang3	ye4",
		"着火", "	zhao2	huo3",
		"拉长", "	la1	chang2",
		"数点", "	shu3	dian3",
		"瞓觉", "	xun4	jiao4",
		"放假", "	fang4	jia4",
		"教书", "	jiao1	shu1",
		"长袜", "	chang2	wa4",
		"倒卷", "	dao3	juan4",
		"长裤", "	chang2	ku4",
		"长葛", "	chang2	ge3",
		"倒嗓", "	dao3	sang3",
		"兴仁", "	xing1	ren2",
		"倒算", "	dao3	suan4",
		"长笛", "	chang2	di2",
		"长途", "	chang2	tu2",
		"散兵", "	san3	bing1",
		"思量", "	si1	liang",
		"冠带", "	guan4	dai4",
		"省察", "	xing3	cha2",
		"的证", "	di2	zheng4",
		"打场", "	da3	chang2",
		"露苗", "	lou4	miao2",
		"露丑", "	lou4	chou3",
		"相机", "	xiang4	ji1",
		"相扑", "	xiang4	pu1",
		"露面", "	lou4	mian4",
		"车削", "	che1	xiao1",
		"镐京", "	hao4	jing1",
		"露风", "	lou4	feng1",
		"草甸", "	cao3	dian4",
		"露馅", "	lou4	xian4",
		"空暇", "	kong4	xia2",
		"等衰", "	deng3	cui1",
		"搅混", "	jiao3	gun3",
		"撤差", "	che4	chai1",
		"搅和", "	jiao3	huo",
		"相图", "	xiang4	tu2",
		"相册", "	xiang4	ce4",
		"靓女", "	liang4	nv3",
		"澄沙", "	deng4	sha1",
		"露脸", "	lou4	lian3",
		"茸毛", "	rong2	mao2",
		"手弹", "	shou3	tan2",
		"数念", "	shu3	nian4",
		"重播", "	chong2	bo1",
		"散件", "	san3	jian4",
		"乐团", "	yue4	tuan2",
		"蛏子", "	cheng1	zi3",
		"闭上", "	bi4	shang",
		"倒产", "	dao3	chan3",
		"散乱", "	san3	luan4",
		"倒垂", "	dao3	chui2",
		"长发", "	chang2	fa4",
		"倒吊", "	dao3	diao4",
		"钻卡", "	zuan4	qia3",
		"长野", "	chang2	ye3",
		"长达", "	chang2	da2",
		"倒动", "	dao3	dong4",
		"呈子", "	cheng2	zi3",
		"倒风", "	dao3	feng1",
		"蒙牛", "	meng3	niu2",
		"念头", "	nian4	tou",
		"称心", "	chen4	xin1",
		"长乐", "	chang2	le4",
		"支行", "	zhi1	hang2",
		"冠绝", "	guan4	jue2",
		"满拧", "	man3	ning3",
		"相似", "	xiang1	si4",
		"更老", "	geng1	lao3",
		"挑唆", "	tiao3	suo1",
		"未了", "	wei4	liao3",
		"藏人", "	zang4	ren2",
		"挑嘴", "	tiao3	zui3",
		"禀帖", "	bing3	tie3",
		"麻将", "	ma2	jiang4",
		"羹匙", "	geng1	chi2",
		"藏文", "	zang4	wen2",
		"潦草", "	liao2	cao3",
		"黄埔", "	huang2	pu3",
		"查拳", "	zha1	quan2",
		"圣子", "	sheng4	zi3",
		"尿样", "	sui1	yang4",
		"黄陂", "	huang2	po1",
		"澎湃", "	peng2	pai4",
		"溃脓", "	hui4	nong2",
		"庚帖", "	geng1	tie3",
		"请帖", "	qing3	tie3",
		"搂钱", "	lou1	qian2",
		"请假", "	qing3	jia4",
		"调驯", "	tiao2	xun4",
		"议长", "	yi4	chang2",
		"变为", "	bian4	wei2",
		"冰瀑", "	bing1	bao4",
		"调解", "	tiao2	jie3",
		"挑花", "	tiao3	hua1",
		"调音", "	tiao2	yin1",
		"摒除", "	bing4	chu2",
		"调谑", "	tiao2	xue4",
		"边塞", "	bian1	sai4",
		"漫应", "	man4	ying4",
		"调谐", "	tiao2	xie2",
		"调试", "	tiao2	shi4",
		"调训", "	tiao2	xun4",
		"句芒", "	gou1	mang2",
		"豁免", "	huo4	mian3",
		"挑逗", "	tiao3	dou4",
		"齿更", "	chi3	geng1",
		"挑衅", "	tiao3	xin4",
		"漂雷", "	piao1	lei2",
		"漂游", "	piao1	you2",
		"少尉", "	shao4	wei4",
		"够着", "	gou4	zhao2",
		"供饭", "	gong4	fan4",
		"调频", "	tiao2	pin2",
		"炮炼", "	pao2	lian4",
		"工尺", "	gong1	che3",
		"挺杆", "	ting3	gan3",
		"刮削", "	gua1	xiao1",
		"调唆", "	tiao2	suo1",
		"搋子", "	chuai1	zi3",
		"处境", "	chu3	jing4",
		"评为", "	ping2	wei2",
		"龈病", "	yin2	bing4",
		"桄子", "	guang4	zi3",
		"挨整", "	ai2	zheng3",
		"漂白", "	piao3	bai2",
		"调嘴", "	tiao2	zui3",
		"漂流", "	piao1	liu2",
		"固相", "	gu4	xiang4",
		"讨还", "	tao3	huan2",
		"调味", "	tiao2	wei4",
		"调协", "	tiao2	xie2",
		"调匀", "	tiao2	yun2",
		"漂染", "	piao3	ran3",
		"漂摇", "	piao1	yao2",
		"汤匙", "	tang1	chi2",
		"调制", "	tiao2	zhi4",
		"对称", "	dui4	chen4",
		"调侃", "	tiao2	kan3",
		"对应", "	dui4	ying4",
		"缘分", "	yuan2	fen4",
		"记传", "	ji4	zhuan4",
		"调节", "	tiao2	jie2",
		"宝藏", "	bao3	zang4",
		"调摄", "	tiao2	she4",
		"藓苔", "	xian3	tai1",
		"将棋", "	jiang4	qi2",
		"将伯", "	qiang1	bo2",
		"虎将", "	hu3	jiang4",
		"测量", "	ce4	liang2",
		"滚杠", "	gun3	gang4",
		"该应", "	gai1	ying4",
		"臂长", "	bi4	chang2",
		"木框", "	mu4	kuang4",
		"清查", "	qing1	cha2",
		"涡阳", "	guo1	yang2",
		"试卷", "	shi4	juan4",
		"紧绷", "	jin3	beng1",
		"线杆", "	xian4	gan3",
		"宝兴", "	bao3	xing1",
		"访查", "	fang3	cha2",
		"国丧", "	guo2	sang1",
		"过甚", "	guo4	shen4",
		"宝应", "	bao3	ying4",
		"安广", "	an1	guang3",
		"朝来", "	zhao1	lai2",
		"谁知", "	shei2	zhi1",
		"自转", "	zi4	zhuan4",
		"大仓", "	tai4	cang1",
		"兴奋", "	xing1	fen4",
		"情分", "	qing2	fen4",
		"应运", "	ying4	yun4",
		"程子", "	cheng2	zi3",
		"芫花", "	yuan2	hua1",
		"应门", "	ying4	men2",
		"应验", "	ying4	yan4",
		"破相", "	po4	xiang4",
		"杠刀", "	gang4	dao1",
		"应邀", "	ying4	yao1",
		"应诺", "	ying4	nuo4",
		"粉坊", "	fen3	fang2",
		"排行", "	pai2	hang2",
		"等为", "	deng3	wei2",
		"着恼", "	zhuo2	nao3",
		"栏栅", "	lan2	shan1",
		"还魂", "	huan2	hun2",
		"画卷", "	hua4	juan4",
		"弄混", "	nong4	hun2",
		"还贷", "	huan2	dai4",
		"还给", "	huan2	gei3",
		"恶创", "	e4	chuang1",
		"碌碡", "	liu4	zhou",
		"长策", "	chang2	ce4",
		"间歇", "	jian4	xie1",
		"关塞", "	guan1	sai4",
		"关卡", "	guan1	qia3",
		"悄然", "	qiao3	ran2",
		"恰当", "	qia4	dang4",
		"称多", "	chen4	duo1",
		"大率", "	da4	shuai4",
		"兴化", "	xing1	hua4",
		"阅卷", "	yue4	juan4",
		"间谍", "	jian4	die2",
		"杠杆", "	gang4	gan3",
		"应试", "	ying4	shi4",
		"间接", "	jian4	jie1",
		"间或", "	jian4	huo4",
		"间奏", "	jian4	zou4",
		"种地", "	zhong4	di4",
		"碎钻", "	sui4	zuan4",
		"患难", "	huan4	nan4",
		"兴学", "	xing1	xue2",
		"散工", "	san3	gong1",
		"攒眉", "	cuan2	mei2",
		"攒射", "	cuan2	she4",
		"还本", "	huan2	ben3",
		"还书", "	huan2	shu1",
		"敌将", "	di2	jiang4",
		"张掖", "	zhang1	ye4",
		"长歌", "	chang2	ge1",
		"邮差", "	you2	chai1",
		"督率", "	du1	shuai4",
		"长斧", "	chang2	fu3",
		"病假", "	bing4	jia4",
		"病倒", "	bing4	dao3",
		"长法", "	chang2	fa3",
		"敦朴", "	dun1	piao2",
		"折钱", "	she2	qian2",
		"著名", "	zhu4	ming2",
		"折缝", "	zhe2	feng2",
		"弧长", "	hu2	chang2",
		"当月", "	dang4	yue4",
		"长辞", "	chang2	ci2",
		"折腾", "	zhe1	teng2",
		"引着", "	yin3	zhao2",
		"荷重", "	he4	zhong4",
		"弦乐", "	xian2	yue4",
		"当晚", "	dang4	wan3",
		"着实", "	zhuo2	shi2",
		"抬杠", "	tai2	gang4",
		"都城", "	du1	cheng2",
		"长骨", "	chang2	gu3",
		"抹胸", "	mo4	xiong1",
		"留空", "	liu2	kong4",
		"广安", "	guang3	an1",
		"厂子", "	chang3	zi3",
		"当作", "	dang4	zuo4",
		"长波", "	chang2	bo1",
		"还口", "	huan2	kou3",
		"还价", "	huan2	jia4",
		"抽斗", "	chou1	dou3",
		"抽查", "	chou1	cha2",
		"着数", "	zhao1	shu4",
		"频数", "	pin2	shuo4",
		"长鼓", "	chang2	gu3",
		"筊杯", "	jiao3	bei1",
		"脑杓", "	nao3	shao2",
		"款新", "	kuan3	xin1",
		"击中", "	ji1	zhong4",
		"颠倒", "	dian1	dao3",
		"适当", "	shi4	dang4",
		"还嘴", "	huan2	zui3",
		"适应", "	shi4	ying4",
		"当做", "	dang4	zuo4",
		"边卡", "	bian1	qia3",
		"成都", "	cheng2	du1",
		"钦差", "	qin1	chai1",
		"冲模", "	chong4	mu2",
		"榔头", "	lang2	tou",
		"长女", "	chang2	nv3",
		"施甸", "	shi1	dian4",
		"支差", "	zhi1	chai1",
		"霓裳", "	ni2	chang2",
		"钻头", "	zuan4	tou2",
		"茄萣", "	qie2	ding4",
		"录相", "	lu4	xiang4",
		"房舍", "	fang2	she4",
		"间作", "	jian4	zuo4",
		"感应", "	gan3	ying4",
		"省亲", "	xing3	qin1",
		"应接", "	ying4	jie1",
		"只身", "	zhi1	shen1",
		"散见", "	san3	jian4",
		"般桓", "	pan2	huan2",
		"舰只", "	jian4	zhi1",
		"应时", "	ying4	shi2",
		"枕头", "	zhen3	tou",
		"愁煞", "	chou2	sha4",
		"枕藉", "	zhen3	jie4",
		"色相", "	se4	xiang4",
		"省视", "	xing3	shi4",
		"长子", "	zhang3	zi3",
		"兴文", "	xing1	wen2",
		"看守", "	kan1	shou3",
		"钻戒", "	zuan4	jie4",
		"椽子", "	chuan2	zi3",
		"钻石", "	zuan4	shi2",
		"长椅", "	chang2	yi3",
		"空匮", "	kong4	kui4",
		"看管", "	kan1	guan3",
		"长期", "	chang2	qi1",
		"长于", "	chang2	yu2",
		"长揖", "	chang2	yi1",
		"长德", "	chang2	de2",
		"眄睐", "	mian4	lai4",
		"长得", "	zhang3	de",
		"乐经", "	yue4	jing1",
		"支应", "	zhi1	ying4",
		"长度", "	chang2	du4",
		"新款", "	xin1	kuan3",
		"省得", "	sheng3	de",
		"新兴", "	xin1	xing1",
		"长崎", "	chang2	qi2",
		"打中", "	da3	zhong4",
		"长安", "	chang2	an1",
		"色长", "	se4	chang2",
		"长夜", "	chang2	ye4",
		"杯筊", "	bei1	jiao3",
		"吹擂", "	chui1	lei4",
		"应分", "	ying1	fen4",
		"兴办", "	xing1	ban4",
		"应对", "	ying4	dui4",
		"兴头", "	xing4	tou",
		"串子", "	chuan4	zi3",
		"凭藉", "	ping2	jie4",
		"应市", "	ying4	shi4",
		"兴尽", "	xing4	jin4",
		"陡削", "	dou3	xiao1",
		"降服", "	xiang2	fu2",
		"随行", "	sui2	hang2",
		"降伏", "	xiang2	fu2",
		"兴海", "	xing1	hai3",
		"吹弹", "	chui1	tan2",
		"应报", "	ying4	bao4",
		"闲散", "	xian2	san3",
		"雅相", "	ya3	xiang4",
		"碰倒", "	peng4	dao3",
		"兴国", "	xing1	guo2",
		"林甸", "	lin2	dian4",
		"成佛", "	cheng2	fo2",
		"应制", "	ying4	zhi4",
		"松菌", "	song1	jun4",
		"禁受", "	jin1	shou4",
		"禅位", "	shan4	wei4",
		"槐荫", "	huai2	yin4",
		"抽干", "	chou1	gan1",
		"应考", "	ying4	kao3",
		"腰椎", "	yao1	zhui1",
		"散养", "	san3	yang3",
		"兴师", "	xing1	shi1",
		"爱将", "	ai4	jiang4",
		"冲子", "	chong4	zi",
		"锤头", "	chui2	tou",
		"慌得", "	huang1	de",
		"花着", "	hua1	zhao1",
		"榜笞", "	bang4	chi1",
		"福相", "	fu2	xiang4",
		"处斩", "	chu3	zhan3",
		"应卯", "	ying4	mao3",
		"兴宾", "	xing1	bin1",
		"禾场", "	he2	chang2",
		"处刑", "	chu3	xing2",
		"禁用", "	jin1	yong4",
		"阳萎", "	yang2	wei3",
		"糳", "	zuo4",
		"糵", "	nie4",
		"糶", "	tiao4",
		"糹", "	si1",
		"糷", "	lan4",
		"糸", "	mi4",
		"系", "	xi4",
		"糺", "	jiu1",
		"糴", "	di2",
		"紖", "	zhen4",
		"糲", "	li4",
		"糱", "	nie4",
		"糰", "	tuan2",
		"糯", "	nuo4",
		"糮", "	xian4",
		"糭", "	zong4",
		"糬", "	shu",
		"糫", "	huan2",
		"糪", "	bo4",
		"糽", "	zheng3",
		"糩", "	kuai4",
		"糨", "	jiang4",
		"糼", "	gong1",
		"紒", "	ji4",
		"糾", "	jiu1",
		"紋", "	wen2",
		"紕", "	pi1",
		"糦", "	xi1",
		"純", "	chun2",
		"紓", "	shu1",
		"紑", "	fou2",
		"紐", "	niu3",
		"紏", "	tou3",
		"紎", "	zi1",
		"納", "	na4",
		"紌", "	qiu2",
		"紊", "	wen3",
		"糿", "	you4",
		"紉", "	ren4",
		"紈", "	wan2",
		"紇", "	he2",
		"紆", "	yu1",
		"紅", "	hong2",
		"約", "	yue1",
		"紃", "	xun2",
		"紂", "	zhou4",
		"紁", "	cha4",
		"紀", "	ji4",
		"糧", "	liang2",
		"粺", "	bai4",
		"糥", "	nuo4",
		"粿", "	guo3",
		"糉", "	zong4",
		"糈", "	xu3",
		"糇", "	hou2",
		"糆", "	mian4",
		"糅", "	rou2",
		"糄", "	bian3",
		"糃", "	tang2",
		"糂", "	san3",
		"糁", "	san3",
		"糀", "	hua",
		"粴", "	li3",
		"糋", "	jian4",
		"精", "	jing1",
		"粽", "	zong4",
		"粼", "	lin2",
		"粻", "	zhang1",
		"粵", "	yue4",
		"粹", "	cui4",
		"粸", "	qi2",
		"粷", "	ju2",
		"粶", "	lu4",
		"紘", "	hong2",
		"糊", "	hu2",
		"糌", "	zan1",
		"糤", "	san3",
		"糙", "	cao1",
		"糣", "	san3",
		"糢", "	mo2",
		"糡", "	jiang4",
		"糠", "	kang1",
		"糟", "	zao1",
		"糞", "	fen4",
		"糝", "	san3",
		"糜", "	mi2",
		"糛", "	tang2",
		"糚", "	zhuang1",
		"糘", "	jia",
		"糍", "	ci2",
		"糗", "	qiu3",
		"糖", "	tang2",
		"糕", "	gao1",
		"糔", "	xiu3",
		"糓", "	gu3",
		"糒", "	bei4",
		"糑", "	nuo4",
		"糐", "	fu1",
		"糏", "	xie4",
		"糎", "	li2",
		"紗", "	sha1",
		"絶", "	jue2",
		"紙", "	zhi3",
		"絚", "	geng1",
		"絤", "	xian4",
		"絣", "	beng1",
		"絢", "	xuan4",
		"絡", "	luo4",
		"絠", "	gai3",
		"絟", "	quan2",
		"絞", "	jiao3",
		"絝", "	ku4",
		"絜", "	jie2",
		"絛", "	tao1",
		"絙", "	huan2",
		"給", "	gei3",
		"絘", "	ci4",
		"絗", "	hu2",
		"絖", "	kuang4",
		"絕", "	jue2",
		"絔", "	bai3",
		"絓", "	gua4",
		"絒", "	chou2",
		"絑", "	zhu1",
		"結", "	jie2",
		"絏", "	xie4",
		"絥", "	fu2",
		"絧", "	dong4",
		"絍", "	ren4",
		"絴", "	xiang2",
		"絽", "	lv3",
		"粲", "	can4",
		"絼", "	zhen3",
		"絾", "	cheng2",
		"絻", "	mian3",
		"絺", "	chi1",
		"絹", "	juan4",
		"絸", "	jian3",
		"絷", "	zhi2",
		"絵", "	hui4",
		"絳", "	jiang4",
		"絨", "	rong2",
		"絲", "	si1",
		"統", "	tong3",
		"絰", "	die2",
		"絯", "	gai1",
		"絮", "	xu4",
		"絭", "	juan4",
		"絬", "	xie4",
		"絫", "	lei3",
		"絪", "	yin1",
		"絩", "	tiao4",
		"絎", "	hang2",
		"経", "	jing1",
		"級", "	ji2",
		"紦", "	ba",
		"細", "	xi4",
		"累", "	lei4",
		"紮", "	za1",
		"紭", "	hong2",
		"紬", "	chou2",
		"紫", "	zi3",
		"紪", "	ci3",
		"紩", "	zhi4",
		"紨", "	fu1",
		"紧", "	jin3",
		"紥", "	za1",
		"紲", "	xie4",
		"紤", "	jiu3",
		"紣", "	cui4",
		"索", "	suo3",
		"紡", "	fang3",
		"素", "	su4",
		"紟", "	jin1",
		"紞", "	dan3",
		"紝", "	ren4",
		"紜", "	yun2",
		"紛", "	fen1",
		"紱", "	fu2",
		"紳", "	shen1",
		"絋", "	kuang",
		"絀", "	chu4",
		"絊", "	zui4",
		"絉", "	shu4",
		"絈", "	mo4",
		"絇", "	qu2",
		"絆", "	ban4",
		"絅", "	jiong1",
		"組", "	zu3",
		"絃", "	xian2",
		"終", "	zhong1",
		"絁", "	shi1",
		"紿", "	dai4",
		"紴", "	bo1",
		"紾", "	zhen3",
		"紽", "	tuo2",
		"紼", "	fu2",
		"紻", "	yang3",
		"紺", "	gan4",
		"紹", "	shao4",
		"紸", "	zhu4",
		"紷", "	ling2",
		"紶", "	qu1",
		"紵", "	zhu4",
		"粳", "	jing1",
		"篯", "	jian1",
		"粱", "	liang2",
		"簣", "	kui4",
		"簭", "	shi4",
		"簬", "	lu4",
		"簫", "	xiao1",
		"簪", "	zan1",
		"簩", "	lao2",
		"簨", "	sun3",
		"簧", "	huang2",
		"簦", "	deng1",
		"簥", "	jiao1",
		"簤", "	dai4",
		"簢", "	min3",
		"簯", "	qi",
		"簡", "	jian3",
		"簠", "	fu3",
		"簟", "	dian4",
		"簞", "	dan1",
		"簝", "	liao2",
		"簜", "	dang4",
		"簛", "	shai1",
		"簚", "	mi4",
		"簙", "	bo2",
		"簘", "	xiao1",
		"簮", "	zan1",
		"簰", "	pai2",
		"簖", "	duan4",
		"簽", "	qian1",
		"籇", "	hao2",
		"籆", "	yue4",
		"籅", "	yu2",
		"籄", "	kui4",
		"籃", "	lan2",
		"籂", "	shi",
		"籁", "	lai4",
		"籀", "	zhou4",
		"簿", "	bu4",
		"簾", "	lian2",
		"簼", "	long2",
		"簱", "	qi",
		"簻", "	zhua1",
		"簺", "	sai4",
		"簹", "	dang1",
		"簸", "	bo3",
		"簷", "	yan2",
		"簶", "	lu4",
		"簵", "	du4",
		"簴", "	ju4",
		"簳", "	gan3",
		"簲", "	pai2",
		"簗", "	liang",
		"簕", "	le4",
		"籉", "	tai2",
		"篮", "	lan2",
		"篹", "	zhuan4",
		"篸", "	can3",
		"篷", "	peng2",
		"篶", "	yan1",
		"篵", "	cong1",
		"篴", "	di2",
		"篳", "	bi4",
		"篲", "	hui4",
		"篱", "	li2",
		"篰", "	bu4",
		"篭", "	long2",
		"篻", "	piao3",
		"篬", "	qiang1",
		"篫", "	zhu4",
		"篪", "	chi2",
		"篩", "	shai1",
		"篨", "	chu2",
		"篧", "	zhuo2",
		"篦", "	bi4",
		"篤", "	du3",
		"綀", "	shu1",
		"篥", "	li4",
		"篺", "	pi2",
		"篼", "	dou1",
		"簔", "	suo1",
		"簉", "	zao4",
		"簓", "	diao",
		"簒", "	cuan4",
		"簑", "	suo1",
		"簐", "	nian3",
		"簏", "	lu4",
		"簎", "	ce4",
		"簍", "	lou3",
		"簌", "	su4",
		"簋", "	gui3",
		"簊", "	ji1",
		"簈", "	ping2",
		"篽", "	yu4",
		"簇", "	cu4",
		"簆", "	kou4",
		"簅", "	chan3",
		"簄", "	hu4",
		"簃", "	yi2",
		"簂", "	gui4",
		"簁", "	shai1",
		"簀", "	ze2",
		"篿", "	tuan2",
		"篾", "	mie4",
		"籈", "	zhen1",
		"籊", "	ti4",
		"粰", "	fu2",
		"粋", "	cui4",
		"粕", "	po4",
		"粔", "	ju4",
		"粓", "	gan1",
		"粒", "	li4",
		"粑", "	ba1",
		"粐", "	hu",
		"粏", "	tai",
		"粎", "	chi3",
		"粍", "	zhe2",
		"粌", "	yin",
		"粊", "	bi4",
		"粗", "	cu1",
		"粉", "	fen3",
		"粈", "	rou3",
		"粇", "	kang1",
		"粆", "	sha1",
		"粅", "	wu4",
		"粄", "	ban3",
		"粃", "	bi3",
		"粂", "	zhai",
		"粁", "	qian1",
		"粀", "	zhang",
		"粖", "	mo4",
		"粘", "	zhan1",
		"籾", "	ni2",
		"粥", "	zhou1",
		"粯", "	xian4",
		"粮", "	liang2",
		"粭", "	he",
		"粬", "	qu1",
		"粫", "	er2",
		"粪", "	fen4",
		"粩", "	lao",
		"粨", "	bai3",
		"粧", "	zhuang1",
		"粦", "	lin2",
		"粤", "	yue4",
		"粙", "	zhou4",
		"粣", "	ce4",
		"粢", "	zi1",
		"粡", "	tong2",
		"粠", "	hong2",
		"粟", "	su4",
		"粞", "	xi1",
		"粝", "	li4",
		"粜", "	tiao4",
		"粛", "	su4",
		"粚", "	li2",
		"籿", "	cun4",
		"籽", "	zi3",
		"籋", "	nie4",
		"籗", "	zhuo2",
		"籡", "	qie",
		"籠", "	long2",
		"籟", "	lai4",
		"籞", "	yu4",
		"籝", "	ying2",
		"籜", "	tuo4",
		"籛", "	jian3",
		"籚", "	lu2",
		"籙", "	lu4",
		"籘", "	teng2",
		"籖", "	qian",
		"籣", "	lan2",
		"籕", "	zhou4",
		"籔", "	sou3",
		"籓", "	fan1",
		"籒", "	zhou4",
		"籑", "	zhuan4",
		"籐", "	teng2",
		"籏", "	qi",
		"籎", "	yi",
		"籍", "	ji2",
		"籌", "	chou2",
		"籢", "	lian2",
		"籤", "	qian1",
		"籼", "	xian1",
		"籱", "	zhuo2",
		"类", "	lei4",
		"籺", "	he2",
		"籹", "	nv3",
		"籸", "	shen1",
		"籷", "	zhe2",
		"籶", "	shen1",
		"籵", "	fan2",
		"籴", "	di2",
		"米", "	mi3",
		"籲", "	yu4",
		"籰", "	yue4",
		"籥", "	yue4",
		"籯", "	ying2",
		"籮", "	luo2",
		"籭", "	si1",
		"籬", "	li2",
		"籫", "	zuan3",
		"籪", "	duan4",
		"籩", "	bian1",
		"籨", "	lian2",
		"籧", "	qu2",
		"籦", "	zhong1",
		"絿", "	qiu2",
		"缌", "	si1",
		"綁", "	bang3",
		"纒", "	chan2",
		"纜", "	lan3",
		"纛", "	dao4",
		"纚", "	li2",
		"纙", "	luo4",
		"纘", "	zuan3",
		"纗", "	zui1",
		"纖", "	xian1",
		"纕", "	rang3",
		"纔", "	cai2",
		"纓", "	ying1",
		"纑", "	lu2",
		"纞", "	lian4",
		"纐", "	jiao",
		"纏", "	chan2",
		"纎", "	xian1",
		"纍", "	lei2",
		"續", "	xu4",
		"纋", "	you1",
		"纊", "	kuang4",
		"纉", "	zuan3",
		"纈", "	xie2",
		"纇", "	lei4",
		"纝", "	lei2",
		"纟", "	si1",
		"纅", "	yao4",
		"纬", "	wei3",
		"纶", "	lun2",
		"纵", "	zong4",
		"纴", "	ren4",
		"纳", "	na4",
		"纲", "	gang1",
		"纱", "	sha1",
		"纰", "	pi1",
		"纯", "	chun2",
		"纮", "	hong2",
		"纭", "	yun2",
		"纫", "	ren4",
		"纠", "	jiu1",
		"纪", "	ji4",
		"纩", "	kuang4",
		"纨", "	wan2",
		"级", "	ji2",
		"约", "	yue1",
		"纥", "	ge1",
		"纤", "	xian1",
		"纣", "	zhou4",
		"红", "	hong2",
		"纡", "	yu1",
		"纆", "	mo4",
		"纄", "	peng2",
		"纸", "	zhi3",
		"繞", "	rao4",
		"繨", "	da",
		"繧", "	yun",
		"繦", "	qiang3",
		"繥", "	xi1",
		"繤", "	zuan3",
		"繣", "	hua4",
		"繢", "	hui4",
		"繡", "	xiu4",
		"繠", "	rui3",
		"繟", "	chan3",
		"繝", "	jian4",
		"繪", "	hui4",
		"繜", "	zun1",
		"繛", "	chuo4",
		"繚", "	liao2",
		"繙", "	fan1",
		"繘", "	yu4",
		"繗", "	lin2",
		"繖", "	san3",
		"繕", "	shan4",
		"織", "	zhi1",
		"繓", "	zuo3",
		"繩", "	sheng2",
		"繫", "	xi4",
		"纃", "	qi2",
		"繸", "	sui4",
		"纂", "	zuan3",
		"纁", "	xun1",
		"纀", "	pu2",
		"繿", "	lan2",
		"繾", "	qian3",
		"繽", "	bin1",
		"繼", "	ji4",
		"繻", "	xu1",
		"繺", "	shai3",
		"繹", "	yi4",
		"繷", "	nong3",
		"繬", "	se4",
		"繶", "	yi4",
		"繵", "	dan4",
		"繴", "	bi4",
		"繳", "	jiao3",
		"繲", "	xie4",
		"繱", "	cong1",
		"繰", "	zao3",
		"繯", "	huan2",
		"繮", "	jiang1",
		"繭", "	jian3",
		"纷", "	fen1",
		"纹", "	wen2",
		"繑", "	qiao1",
		"绺", "	liu3",
		"缄", "	jian1",
		"缃", "	xiang1",
		"缂", "	ke4",
		"缁", "	zi1",
		"缀", "	zhui4",
		"绿", "	lv4",
		"绾", "	wan3",
		"绽", "	zhan4",
		"综", "	zong1",
		"绻", "	quan3",
		"绹", "	tao2",
		"缆", "	lan3",
		"绸", "	chou2",
		"绷", "	beng3",
		"绶", "	shou4",
		"绵", "	mian2",
		"维", "	wei2",
		"绳", "	sheng2",
		"绲", "	gun3",
		"绱", "	shang4",
		"绰", "	chuo4",
		"绯", "	fei1",
		"缅", "	mian3",
		"缇", "	ti2",
		"续", "	xu4",
		"缕", "	lv3",
		"缞", "	cui1",
		"篢", "	long3",
		"缝", "	feng4",
		"缜", "	zhen3",
		"缛", "	ru4",
		"缚", "	fu4",
		"缙", "	jin4",
		"缘", "	yuan2",
		"缗", "	min2",
		"编", "	bian1",
		"缔", "	di4",
		"缈", "	miao3",
		"缓", "	huan3",
		"缒", "	zhui4",
		"缑", "	gou1",
		"缐", "	xian4",
		"缏", "	bian4",
		"缎", "	duan4",
		"缍", "	duo3",
		"缋", "	hui4",
		"缊", "	yun1",
		"缉", "	ji1",
		"绮", "	qi3",
		"绬", "	ying1",
		"纺", "	fang3",
		"细", "	xi4",
		"绐", "	dai4",
		"经", "	jing1",
		"绎", "	yi4",
		"绍", "	shao4",
		"绌", "	chu4",
		"绋", "	fu2",
		"绊", "	ban4",
		"绉", "	zhou4",
		"终", "	zhong1",
		"织", "	zhi1",
		"绅", "	shen1",
		"绒", "	rong2",
		"组", "	zu3",
		"练", "	lian4",
		"绂", "	fu2",
		"绁", "	xie4",
		"绀", "	gan4",
		"线", "	xian4",
		"纾", "	shu1",
		"纽", "	niu3",
		"纼", "	zhen4",
		"纻", "	zhu4",
		"绑", "	bang3",
		"结", "	jie2",
		"绫", "	ling2",
		"绠", "	geng3",
		"绪", "	xu4",
		"绩", "	ji1",
		"绨", "	ti2",
		"继", "	ji4",
		"绦", "	tao1",
		"绥", "	sui2",
		"绤", "	xi4",
		"绣", "	xiu4",
		"绢", "	juan4",
		"绡", "	xiao1",
		"统", "	tong3",
		"绔", "	ku4",
		"绞", "	jiao3",
		"绝", "	jue2",
		"络", "	luo4",
		"绛", "	jiang4",
		"绚", "	xuan4",
		"给", "	gei3",
		"绘", "	hui4",
		"绗", "	hang2",
		"绖", "	die2",
		"绕", "	rao4",
		"繒", "	zeng1",
		"繐", "	sui4",
		"綂", "	tong3",
		"緂", "	tian2",
		"緌", "	rui2",
		"緋", "	fei1",
		"緊", "	jin3",
		"緉", "	liang3",
		"緈", "	xing4",
		"緇", "	zi1",
		"緆", "	xi1",
		"緅", "	zou1",
		"緄", "	gun3",
		"緃", "	zong1",
		"緁", "	qie4",
		"緎", "	yu4",
		"緀", "	qi1",
		"綿", "	mian2",
		"綾", "	ling2",
		"綽", "	chuo4",
		"綼", "	bi4",
		"綻", "	zhan4",
		"綺", "	qi3",
		"綹", "	liu3",
		"綸", "	lun2",
		"綷", "	cui4",
		"緍", "	min2",
		"総", "	zong3",
		"綵", "	cai3",
		"緜", "	mian2",
		"緦", "	si1",
		"緥", "	bao3",
		"緤", "	xie4",
		"緣", "	yuan2",
		"緢", "	miao2",
		"緡", "	min2",
		"締", "	di4",
		"緟", "	chong2",
		"緞", "	duan4",
		"緝", "	ji1",
		"緛", "	ruan3",
		"緐", "	fan2",
		"線", "	xian4",
		"緙", "	ke4",
		"緘", "	jian1",
		"緗", "	xiang1",
		"緖", "	xu4",
		"緕", "	qi",
		"緔", "	shang4",
		"緓", "	ying1",
		"緒", "	xu4",
		"緑", "	lv4",
		"綶", "	guo3",
		"綴", "	zhui4",
		"編", "	bian1",
		"綎", "	ting1",
		"綘", "	feng2",
		"綗", "	jiong3",
		"綖", "	yan2",
		"綕", "	zhi1",
		"綔", "	hu4",
		"經", "	jing1",
		"綒", "	fu1",
		"綑", "	kun3",
		"綐", "	dui4",
		"綏", "	sui1",
		"綍", "	fu2",
		"続", "	xu",
		"綌", "	xi4",
		"綋", "	hong2",
		"綊", "	xie2",
		"綉", "	tou4",
		"綈", "	ti2",
		"綇", "	xiu3",
		"綆", "	geng3",
		"綅", "	qin1",
		"綄", "	huan2",
		"綃", "	xiao1",
		"継", "	ji4",
		"綛", "	ren",
		"綳", "	beng1",
		"綨", "	qi2",
		"網", "	wang3",
		"綱", "	gang1",
		"綰", "	wan3",
		"綯", "	tao2",
		"綮", "	qi3",
		"維", "	wei2",
		"綬", "	shou4",
		"綫", "	xian4",
		"綪", "	qian4",
		"綩", "	wan3",
		"綧", "	zhun3",
		"綜", "	zong1",
		"綦", "	qi2",
		"綥", "	qi2",
		"綤", "	shao4",
		"綣", "	quan3",
		"綢", "	chou2",
		"綡", "	liang2",
		"綠", "	lv4",
		"綟", "	li4",
		"綞", "	duo3",
		"綝", "	chen1",
		"緧", "	qiu1",
		"緩", "	huan3",
		"繏", "	xuan4",
		"縪", "	bi4",
		"縴", "	qian4",
		"縳", "	juan4",
		"縲", "	lei2",
		"縱", "	zong4",
		"縰", "	xi3",
		"縯", "	yan3",
		"縮", "	suo1",
		"縭", "	li2",
		"縬", "	cu4",
		"縫", "	feng4",
		"縩", "	cai4",
		"縶", "	zhi2",
		"縨", "	huang",
		"縧", "	tao1",
		"縦", "	zong4",
		"縥", "	zhen3",
		"縤", "	su4",
		"縣", "	xian4",
		"縢", "	teng2",
		"縡", "	zai4",
		"縠", "	hu2",
		"縟", "	ru4",
		"縵", "	man4",
		"縷", "	lv3",
		"縝", "	chen1",
		"繄", "	yi1",
		"繎", "	ran2",
		"繍", "	xiu4",
		"繌", "	sha",
		"繋", "	ji4",
		"繊", "	xian",
		"繉", "	hun2",
		"繈", "	qiang3",
		"繇", "	yao2",
		"繆", "	mou2",
		"繅", "	sao1",
		"繃", "	beng3",
		"縸", "	mu4",
		"繂", "	lv4",
		"繁", "	fan2",
		"繀", "	sui4",
		"縿", "	shan1",
		"績", "	ji1",
		"總", "	zong3",
		"縼", "	xuan4",
		"縻", "	mi2",
		"縺", "	lian2",
		"縹", "	piao3",
		"縞", "	gao3",
		"縜", "	yun2",
		"緪", "	geng1",
		"緶", "	bian4",
		"縀", "	xia2",
		"緿", "	dai4",
		"緾", "	chan2",
		"緽", "	cheng1",
		"緼", "	yun4",
		"緻", "	zhi4",
		"緺", "	gua1",
		"緹", "	ti2",
		"緸", "	yin1",
		"緷", "	yun4",
		"緵", "	zong1",
		"縂", "	zong3",
		"練", "	lian4",
		"緳", "	xie2",
		"緲", "	miao3",
		"緱", "	gou1",
		"緰", "	tou2",
		"緯", "	wei3",
		"緮", "	fu4",
		"緭", "	wei4",
		"緬", "	mian3",
		"緫", "	cong1",
		"縁", "	yuan2",
		"縃", "	xu1",
		"縛", "	fu4",
		"縐", "	zhou4",
		"縚", "	tao1",
		"縙", "	rong2",
		"縘", "	xi1",
		"縗", "	cui1",
		"縖", "	xia2",
		"縕", "	yun1",
		"縔", "	shuang3",
		"縓", "	quan2",
		"縒", "	ci1",
		"縑", "	jian1",
		"縏", "	pan2",
		"縄", "	ying",
		"縎", "	gu3",
		"縍", "	bang1",
		"縌", "	ni4",
		"縋", "	zhui4",
		"縊", "	yi4",
		"縉", "	jin4",
		"縈", "	ying2",
		"縇", "	xuan1",
		"縆", "	geng1",
		"縅", "	wei",
		"篣", "	peng2",
		"磅", "	bang4",
		"篡", "	cuan4",
		"禲", "	li4",
		"禼", "	xie4",
		"离", "	li2",
		"禺", "	yu2",
		"禹", "	yu3",
		"禸", "	rou2",
		"禷", "	lei4",
		"禶", "	zan4",
		"禵", "	ti2",
		"禴", "	yue4",
		"禳", "	rang2",
		"禱", "	dao3",
		"禾", "	he2",
		"禰", "	mi2",
		"禯", "	nong2",
		"禮", "	li3",
		"禭", "	sui4",
		"禬", "	gui4",
		"禫", "	dan4",
		"禪", "	chan2",
		"禩", "	si4",
		"禨", "	ji1",
		"禧", "	xi3",
		"禽", "	qin2",
		"禿", "	tu1",
		"禥", "	qi2",
		"秌", "	qiu1",
		"秖", "	zhi1",
		"秕", "	bi3",
		"秔", "	jing1",
		"秓", "	zhi1",
		"秒", "	miao3",
		"科", "	ke1",
		"秐", "	yun2",
		"秏", "	hao4",
		"秎", "	fen4",
		"种", "	zhong3",
		"秋", "	qiu1",
		"秀", "	xiu4",
		"秊", "	nian2",
		"秉", "	bing3",
		"秈", "	xian1",
		"秇", "	yi4",
		"秆", "	gan3",
		"秅", "	cha2",
		"秄", "	zi3",
		"秃", "	tu1",
		"秂", "	ren2",
		"私", "	si1",
		"禦", "	yu4",
		"禤", "	xuan1",
		"秘", "	mi4",
		"祾", "	ling2",
		"禈", "	hui1",
		"禇", "	zhe3",
		"禆", "	bei1",
		"禅", "	chan2",
		"禄", "	lu4",
		"禃", "	zhi2",
		"禂", "	dao3",
		"禁", "	jin4",
		"禀", "	bing3",
		"祿", "	lu4",
		"祽", "	zui4",
		"禊", "	xi4",
		"祼", "	guan4",
		"祻", "	gu4",
		"祺", "	qi2",
		"祹", "	tao2",
		"祸", "	huo4",
		"祷", "	dao3",
		"祶", "	di4",
		"祵", "	kun3",
		"祴", "	gai1",
		"祳", "	shen4",
		"禉", "	you3",
		"禋", "	yin1",
		"禣", "	fu",
		"禘", "	di4",
		"禢", "	ta4",
		"禡", "	ma4",
		"禠", "	si1",
		"禟", "	tang2",
		"禞", "	gao4",
		"禝", "	ji2",
		"禜", "	yong3",
		"禛", "	zhen1",
		"禚", "	zhuo2",
		"禙", "	bei",
		"禗", "	si1",
		"禌", "	zi1",
		"禖", "	mei2",
		"禕", "	yi1",
		"禔", "	zhi1",
		"禓", "	yang2",
		"禒", "	xian3",
		"禑", "	wu2",
		"禐", "	yuan4",
		"福", "	fu2",
		"禎", "	zhen1",
		"禍", "	huo4",
		"秗", "	yu4",
		"秙", "	ku4",
		"祱", "	shui4",
		"稚", "	zhi4",
		"稤", "	lue4",
		"稣", "	su1",
		"稢", "	yu4",
		"稡", "	zui4",
		"稠", "	chou2",
		"稟", "	bing3",
		"稞", "	ke1",
		"稝", "	peng2",
		"稜", "	leng2",
		"稛", "	kun3",
		"稙", "	zhi1",
		"稦", "	yi1",
		"稘", "	ji1",
		"稗", "	bai4",
		"稖", "	bang4",
		"稕", "	zhun4",
		"稔", "	ren3",
		"稓", "	zuo2",
		"稒", "	gu4",
		"稑", "	lu4",
		"稐", "	lun3",
		"稏", "	ya4",
		"稥", "	xiang1",
		"稧", "	xi4",
		"稍", "	shao1",
		"稴", "	xian2",
		"稾", "	gao3",
		"稽", "	ji1",
		"稼", "	jia4",
		"稻", "	dao4",
		"稺", "	zhi4",
		"稹", "	zhen3",
		"稸", "	xu4",
		"稷", "	ji4",
		"稶", "	yu4",
		"稵", "	zi1",
		"稳", "	wen3",
		"稨", "	bian3",
		"稲", "	dao4",
		"稱", "	cheng1",
		"稰", "	xu3",
		"稯", "	zong1",
		"種", "	zhong3",
		"稭", "	jie1",
		"稬", "	nuo4",
		"稫", "	pi4",
		"稪", "	fu2",
		"稩", "	ji4",
		"税", "	shui4",
		"稌", "	tu2",
		"秚", "	ban4",
		"秦", "	qin2",
		"称", "	cheng1",
		"积", "	ji1",
		"秮", "	huo2",
		"秭", "	zi3",
		"秬", "	ju4",
		"秫", "	shu2",
		"秪", "	zhi1",
		"秩", "	zhi4",
		"秨", "	zuo2",
		"秧", "	yang1",
		"秥", "	nian2",
		"秲", "	zhi4",
		"秤", "	cheng4",
		"秣", "	mo4",
		"秢", "	ling2",
		"秡", "	bo2",
		"秠", "	pi1",
		"租", "	zu1",
		"秞", "	you2",
		"秝", "	li4",
		"秜", "	ni2",
		"秛", "	pi1",
		"秱", "	tong2",
		"秳", "	huo2",
		"程", "	cheng2",
		"稀", "	xi1",
		"稊", "	ti2",
		"稉", "	jing1",
		"稈", "	gan3",
		"稇", "	kun3",
		"稆", "	lv3",
		"稅", "	shui4",
		"稄", "	xun4",
		"稃", "	fu1",
		"稂", "	lang2",
		"稁", "	kao3",
		"秿", "	fu4",
		"秴", "	he2",
		"秾", "	nong2",
		"秽", "	hui4",
		"秼", "	zhu1",
		"移", "	yi2",
		"秺", "	du4",
		"秹", "	ren3",
		"秸", "	jie1",
		"秷", "	zhi4",
		"秶", "	zi1",
		"秵", "	yin1",
		"祲", "	jin4",
		"祰", "	gao4",
		"穀", "	gu3",
		"磡", "	kan4",
		"磫", "	zong1",
		"磪", "	cui1",
		"磩", "	qi4",
		"磨", "	mo2",
		"磧", "	qi4",
		"磦", "	biao1",
		"磥", "	lei3",
		"磤", "	yin3",
		"磣", "	chen3",
		"磢", "	chuang3",
		"磠", "	lu3",
		"磭", "	chuo4",
		"磟", "	liu4",
		"磞", "	peng1",
		"磝", "	ao2",
		"磜", "	qi4",
		"磛", "	chan2",
		"磚", "	zhuan1",
		"磙", "	gun3",
		"磘", "	qing4",
		"磗", "	zhuan1",
		"磖", "	la2",
		"磬", "	qing4",
		"磮", "	lun",
		"磔", "	zhe2",
		"磻", "	pan2",
		"礅", "	dun1",
		"礄", "	qiao2",
		"礃", "	zhang3",
		"礂", "	xi",
		"礁", "	jiao1",
		"礀", "	jian",
		"磿", "	li4",
		"磾", "	di1",
		"磽", "	qiao1",
		"磼", "	za2",
		"磺", "	huang2",
		"磯", "	ji1",
		"磹", "	tan2",
		"磸", "	ding4",
		"磷", "	lin2",
		"磶", "	xi4",
		"磵", "	jian4",
		"磴", "	deng4",
		"磳", "	zeng1",
		"磲", "	qu2",
		"磱", "	lao2",
		"磰", "	shan4",
		"磕", "	ke1",
		"磓", "	dui1",
		"礇", "	yu4",
		"碬", "	xia2",
		"碶", "	qi4",
		"碵", "	tian",
		"碴", "	cha2",
		"碳", "	tan4",
		"碲", "	di4",
		"碱", "	jian3",
		"碰", "	peng4",
		"碯", "	nao3",
		"碮", "	ti2",
		"碭", "	dang4",
		"碫", "	duan4",
		"碸", "	feng1",
		"碪", "	zhen1",
		"碩", "	shuo4",
		"碨", "	wei4",
		"碧", "	bi4",
		"碦", "	ke4",
		"碥", "	bian3",
		"碤", "	ying1",
		"碣", "	jie2",
		"碢", "	tuo2",
		"缠", "	chan2",
		"碷", "	dun",
		"碹", "	xuan4",
		"磒", "	yun3",
		"磇", "	pi1",
		"磑", "	wei2",
		"磐", "	pan2",
		"磏", "	lian2",
		"磎", "	xi1",
		"磍", "	xia2",
		"磌", "	tian2",
		"磋", "	cuo1",
		"磊", "	lei3",
		"磉", "	sang3",
		"磈", "	wei3",
		"磆", "	hua2",
		"確", "	que4",
		"磄", "	tang2",
		"磃", "	si1",
		"磂", "	liu2",
		"磁", "	ci2",
		"磀", "	e2",
		"碿", "	su4",
		"碾", "	nian3",
		"碽", "	gong1",
		"碼", "	ma3",
		"碻", "	que4",
		"礆", "	jian3",
		"礈", "	zhui4",
		"祯", "	zhen1",
		"祊", "	beng1",
		"祔", "	fu4",
		"祓", "	fu2",
		"祒", "	tiao2",
		"祑", "	zhi4",
		"祐", "	you4",
		"祏", "	shi2",
		"祎", "	yi1",
		"祍", "	ren4",
		"祌", "	zhong4",
		"祋", "	dui4",
		"祉", "	zhi3",
		"祖", "	zu3",
		"祈", "	qi2",
		"祇", "	qi2",
		"祆", "	xian1",
		"祅", "	yao1",
		"祄", "	xie4",
		"祃", "	ma4",
		"祂", "	ta1",
		"祁", "	qi2",
		"祀", "	si4",
		"礿", "	yue4",
		"祕", "	mi4",
		"祗", "	zhi1",
		"礽", "	reng2",
		"祤", "	yu3",
		"祮", "	gao4",
		"祭", "	ji4",
		"祬", "	zhi1",
		"祫", "	xia2",
		"祪", "	gui3",
		"祩", "	zhu4",
		"票", "	piao4",
		"祧", "	tiao1",
		"祦", "	wu2",
		"祥", "	xiang2",
		"祣", "	lv3",
		"祘", "	suan4",
		"祢", "	mi2",
		"祡", "	chai2",
		"祠", "	ci2",
		"祟", "	sui4",
		"神", "	shen2",
		"祝", "	zhu4",
		"祜", "	hu4",
		"祛", "	qu1",
		"祚", "	zuo4",
		"祙", "	mei4",
		"社", "	she4",
		"礼", "	li3",
		"礉", "	he2",
		"礕", "	pi1",
		"礟", "	pao4",
		"礞", "	meng2",
		"礝", "	ruan3",
		"礜", "	yu4",
		"礛", "	jian1",
		"礚", "	ke1",
		"礙", "	ai4",
		"礘", "	e4",
		"礗", "	pin1",
		"礖", "	yu4",
		"礔", "	pi1",
		"礡", "	bo2",
		"礓", "	jiang1",
		"礒", "	yi3",
		"礑", "	dang4",
		"礐", "	que4",
		"礏", "	ye4",
		"礎", "	chu3",
		"礍", "	ke3",
		"礌", "	lei2",
		"礋", "	ze2",
		"礊", "	ke4",
		"礠", "	ci2",
		"礢", "	yang",
		"礻", "	shi4",
		"礰", "	li4",
		"示", "	shi4",
		"礹", "	yan2",
		"礸", "	zan3",
		"礷", "	lan2",
		"礶", "	guan4",
		"礵", "	shuang1",
		"礴", "	bo2",
		"礳", "	mo4",
		"礲", "	long2",
		"礱", "	long2",
		"礯", "	ying1",
		"礣", "	ma4",
		"礮", "	pao4",
		"礭", "	que4",
		"礬", "	fan2",
		"礫", "	li4",
		"礪", "	li4",
		"礩", "	zhi4",
		"礨", "	lei3",
		"礧", "	lei2",
		"礦", "	kuang4",
		"礥", "	xian2",
		"礤", "	ca3",
		"稿", "	gao3",
		"穁", "	rong2",
		"篠", "	xiao3",
		"筓", "	ji1",
		"筝", "	zheng1",
		"筜", "	dang1",
		"筛", "	shai1",
		"筚", "	bi4",
		"筙", "	lai2",
		"筘", "	kou4",
		"筗", "	zhong4",
		"策", "	ce4",
		"筕", "	hang2",
		"答", "	da2",
		"筒", "	tong3",
		"筟", "	fu1",
		"筑", "	zhu4",
		"筐", "	kuang1",
		"筏", "	fa2",
		"筎", "	ru2",
		"筍", "	sun3",
		"筌", "	quan2",
		"筋", "	jin1",
		"筊", "	xiao2",
		"等", "	deng3",
		"筈", "	kuo4",
		"筞", "	ce4",
		"筠", "	yun2",
		"筆", "	bi3",
		"筭", "	suan4",
		"筷", "	kuai4",
		"筶", "	gao4",
		"筵", "	yan2",
		"筴", "	ce4",
		"筳", "	ting2",
		"筲", "	shao1",
		"筱", "	xiao3",
		"筰", "	zuo2",
		"筯", "	zhu4",
		"筮", "	shi4",
		"筬", "	cheng2",
		"筡", "	tu2",
		"筫", "	zhi4",
		"筪", "	xia2",
		"筩", "	tong2",
		"筨", "	han2",
		"筧", "	jian3",
		"筦", "	guan3",
		"筥", "	ju3",
		"筤", "	lang2",
		"筣", "	li2",
		"筢", "	pa2",
		"筇", "	qiong2",
		"筅", "	xian3",
		"筹", "	chou2",
		"笟", "	gu1",
		"笩", "	pei4",
		"笨", "	ben4",
		"笧", "	ce4",
		"符", "	fu2",
		"笥", "	si4",
		"笤", "	tiao2",
		"笣", "	bao1",
		"笢", "	min3",
		"笡", "	qie4",
		"笠", "	li4",
		"笞", "	chi1",
		"笫", "	zi3",
		"笝", "	na4",
		"笜", "	zhu2",
		"笛", "	di2",
		"笚", "	da1",
		"笙", "	sheng1",
		"笘", "	shan1",
		"笗", "	dong1",
		"笖", "	yi3",
		"笕", "	jian3",
		"笔", "	bi3",
		"笪", "	da2",
		"第", "	di4",
		"筄", "	yao4",
		"笹", "	ti",
		"筃", "	yin1",
		"筂", "	chi2",
		"筁", "	qu1",
		"筀", "	gui4",
		"笿", "	luo4",
		"笾", "	bian1",
		"笽", "	min",
		"笼", "	long2",
		"笻", "	qiong2",
		"笺", "	jian1",
		"笸", "	po3",
		"笭", "	ling2",
		"笷", "	mao3",
		"笶", "	shi3",
		"笵", "	fan4",
		"笴", "	gan3",
		"笳", "	jia1",
		"笲", "	fan2",
		"笱", "	gou3",
		"笰", "	fu2",
		"笯", "	nu2",
		"笮", "	ze2",
		"筸", "	gan1",
		"筺", "	kuang",
		"笒", "	cen2",
		"箻", "	lv4",
		"篅", "	chuan2",
		"範", "	fan4",
		"篃", "	mei4",
		"篂", "	xing1",
		"篁", "	huang2",
		"節", "	jie2",
		"箿", "	ji2",
		"箾", "	shuo4",
		"箽", "	dong3",
		"箼", "	wu1",
		"箺", "	chun1",
		"篇", "	pian1",
		"箹", "	yue1",
		"箸", "	zhu4",
		"箷", "	yi2",
		"箶", "	hu2",
		"箵", "	xing1",
		"箴", "	zhen1",
		"箳", "	ping2",
		"箲", "	xian3",
		"箱", "	xiang1",
		"箰", "	sun3",
		"篆", "	zhuan4",
		"篈", "	feng1",
		"箮", "	xuan1",
		"篕", "	he2",
		"篟", "	qian4",
		"篞", "	nie4",
		"篝", "	gou1",
		"篜", "	zheng1",
		"篛", "	ruo4",
		"篚", "	fei3",
		"篙", "	gao1",
		"篘", "	chou1",
		"篗", "	yue4",
		"篖", "	tang2",
		"篔", "	yun2",
		"築", "	zhu2",
		"篓", "	lou3",
		"篒", "	shi",
		"篑", "	kui4",
		"篐", "	gu",
		"篏", "	qian4",
		"篎", "	miao3",
		"篍", "	qiu1",
		"篌", "	hou2",
		"篋", "	qie4",
		"篊", "	huang2",
		"箯", "	bian1",
		"箭", "	jian4",
		"筻", "	gang4",
		"箇", "	ge4",
		"箑", "	sha4",
		"箐", "	qing4",
		"箏", "	zheng1",
		"箎", "	chi2",
		"箍", "	gu1",
		"箌", "	dao4",
		"箋", "	jian1",
		"箊", "	yu1",
		"箉", "	guai3",
		"箈", "	tai2",
		"箆", "	bi4",
		"箓", "	lu4",
		"箅", "	bi4",
		"箄", "	bi3",
		"箃", "	zou1",
		"箂", "	lai2",
		"箁", "	pou2",
		"简", "	jian3",
		"筿", "	xiao3",
		"签", "	qian1",
		"筽", "	o",
		"筼", "	yun2",
		"箒", "	zhou3",
		"箔", "	bo2",
		"箬", "	ruo4",
		"管", "	guan3",
		"箫", "	xiao1",
		"箪", "	dan1",
		"箩", "	luo2",
		"箨", "	tuo4",
		"箧", "	qie4",
		"箦", "	ze2",
		"箥", "	bo3",
		"箤", "	zu2",
		"箣", "	ce4",
		"箢", "	yuan1",
		"箠", "	chui2",
		"箕", "	ji1",
		"箟", "	jun4",
		"箞", "	qian1",
		"箝", "	qian2",
		"箜", "	kong1",
		"箛", "	gu1",
		"箚", "	zha2",
		"箙", "	fu2",
		"箘", "	jun4",
		"算", "	suan4",
		"箖", "	lin2",
		"笓", "	bi4",
		"笑", "	xiao4",
		"穂", "	sui4",
		"窂", "	lao2",
		"窌", "	jiao4",
		"窋", "	zhu2",
		"窊", "	wa1",
		"窉", "	bing3",
		"窈", "	yao3",
		"窇", "	bao2",
		"窆", "	bian3",
		"窅", "	yao3",
		"窄", "	zhai3",
		"窃", "	qie4",
		"突", "	tu1",
		"窎", "	diao4",
		"窀", "	zhun1",
		"穿", "	chuan1",
		"穾", "	yao4",
		"穽", "	jing3",
		"穼", "	shen1",
		"穻", "	yu1",
		"空", "	kong1",
		"穹", "	qiong2",
		"穸", "	xi1",
		"穷", "	qiong2",
		"窍", "	qiao4",
		"窏", "	wu1",
		"穵", "	wa1",
		"窜", "	cuan4",
		"窦", "	dou4",
		"窥", "	kui1",
		"窤", "	guan1",
		"窣", "	su1",
		"窢", "	xu1",
		"窡", "	zhuo2",
		"窠", "	ke1",
		"窟", "	ku1",
		"窞", "	dan4",
		"窝", "	wo1",
		"窛", "	kou4",
		"窐", "	gui1",
		"窚", "	cheng2",
		"窙", "	xiao1",
		"窘", "	jiong3",
		"窗", "	chuang1",
		"窖", "	jiao4",
		"窕", "	tiao3",
		"窔", "	yao4",
		"窓", "	chuang1",
		"窒", "	zhi4",
		"窑", "	yao2",
		"究", "	jiu1",
		"穴", "	xue2",
		"窨", "	xun1",
		"穎", "	ying3",
		"穘", "	xiao1",
		"穗", "	sui4",
		"穖", "	ji3",
		"穕", "	qie4",
		"穔", "	huang2",
		"穓", "	yi4",
		"穒", "	he4",
		"穑", "	se4",
		"穐", "	qiu1",
		"穏", "	wen3",
		"積", "	ji1",
		"穚", "	jiao1",
		"穌", "	su1",
		"穋", "	lu4",
		"穊", "	ji4",
		"穉", "	zhi4",
		"穈", "	mei2",
		"穇", "	can3",
		"穆", "	mu4",
		"穅", "	kang1",
		"穄", "	ji4",
		"穃", "	rong",
		"穙", "	pu2",
		"穛", "	zhuo1",
		"穳", "	cuan2",
		"穨", "	tui2",
		"穲", "	li2",
		"穱", "	zhuo1",
		"穰", "	rang2",
		"穯", "	se",
		"穮", "	biao1",
		"穭", "	lv3",
		"穬", "	kuang4",
		"穫", "	huo4",
		"穪", "	cheng1",
		"穩", "	wen3",
		"穧", "	ji4",
		"穜", "	zhong3",
		"穦", "	pin1",
		"穥", "	yu4",
		"穤", "	nuo4",
		"穣", "	rang2",
		"穢", "	hui4",
		"穡", "	se4",
		"穠", "	nong2",
		"穟", "	sui4",
		"穞", "	lv3",
		"穝", "	zui",
		"窧", "	zhuo",
		"窩", "	wo1",
		"笐", "	hang2",
		"竫", "	jing4",
		"竵", "	wai1",
		"竴", "	cun1",
		"竳", "	deng1",
		"竲", "	ceng2",
		"竱", "	zhuan3",
		"竰", "	shao2",
		"端", "	duan1",
		"竮", "	ping1",
		"竭", "	jie2",
		"竬", "	qu3",
		"竪", "	shu4",
		"竷", "	kan3",
		"竩", "	yi4",
		"竨", "	diao4",
		"竧", "	jing4",
		"竦", "	song3",
		"童", "	tong2",
		"竤", "	hong2",
		"竣", "	jun4",
		"竢", "	si4",
		"竡", "	bai",
		"章", "	zhang1",
		"競", "	jing4",
		"竸", "	jing4",
		"竞", "	jing4",
		"笅", "	xiao2",
		"笏", "	hu4",
		"笎", "	yuan2",
		"笍", "	zhui4",
		"笌", "	ya2",
		"笋", "	sun3",
		"笊", "	zhao4",
		"笉", "	qin3",
		"笈", "	ji2",
		"笇", "	suan4",
		"笆", "	ba1",
		"笄", "	ji1",
		"竹", "	zhu2",
		"笃", "	du3",
		"笂", "	wan",
		"笁", "	zhu2",
		"笀", "	mang2",
		"竿", "	gan1",
		"竾", "	chi2",
		"竽", "	yu2",
		"竼", "	peng2",
		"竻", "	le4",
		"竺", "	zhu2",
		"竟", "	jing4",
		"竝", "	bing4",
		"窪", "	wa1",
		"窶", "	ju4",
		"竀", "	cheng1",
		"窿", "	long2",
		"窾", "	kuan3",
		"窽", "	kuan",
		"窼", "	zhao1",
		"窻", "	chuang1",
		"窺", "	kui1",
		"窹", "	wu4",
		"窸", "	xi1",
		"窷", "	liao4",
		"窵", "	diao4",
		"竂", "	piao2",
		"窴", "	tian2",
		"窳", "	yu3",
		"窲", "	chao2",
		"窱", "	tiao3",
		"窰", "	yao2",
		"窯", "	yao2",
		"窮", "	qiong2",
		"窭", "	ju4",
		"窬", "	yu2",
		"窫", "	ya4",
		"竁", "	cui4",
		"竃", "	zao4",
		"竜", "	long2",
		"竑", "	hong2",
		"竛", "	ling2",
		"竚", "	zhu4",
		"站", "	zhan4",
		"竘", "	qu3",
		"竗", "	miao4",
		"竖", "	shu4",
		"竕", "	fen",
		"竔", "	sheng",
		"竓", "	hao",
		"竒", "	qi2",
		"竐", "	chu4",
		"竄", "	cuan4",
		"竏", "	qian",
		"竎", "	fu4",
		"竍", "	shi",
		"竌", "	chu4",
		"立", "	li4",
		"竊", "	qie4",
		"竉", "	long3",
		"竈", "	zao4",
		"竇", "	dou4",
		"竆", "	qiong2",
		"竅", "	qiao4",
		"缟", "	gao3",
		"蕚", "	e4",
		"缡", "	li2",
		"荳", "	dou4",
		"荽", "	sui1",
		"荼", "	tu2",
		"荻", "	di2",
		"荺", "	yun3",
		"荹", "	bu4",
		"荸", "	bi2",
		"荷", "	he2",
		"荶", "	yin2",
		"荵", "	ren3",
		"荴", "	fu1",
		"荲", "	li2",
		"荿", "	cheng2",
		"荱", "	wei3",
		"荰", "	du4",
		"药", "	yao4",
		"荮", "	zhou4",
		"荭", "	hong2",
		"荬", "	mai3",
		"荫", "	yin1",
		"荪", "	sun1",
		"荩", "	jin4",
		"荨", "	xun2",
		"荾", "	sui1",
		"莀", "	chen2",
		"荦", "	luo4",
		"莍", "	qiu2",
		"莗", "	che1",
		"莖", "	jing1",
		"莕", "	xing4",
		"莔", "	meng2",
		"莓", "	mei2",
		"莒", "	ju3",
		"莑", "	peng2",
		"莐", "	chen2",
		"莏", "	suo1",
		"莎", "	sha1",
		"莌", "	tuo1",
		"莁", "	wu2",
		"莋", "	zuo2",
		"莊", "	zhuang1",
		"莉", "	li4",
		"莈", "	mo4",
		"莇", "	zhu4",
		"莆", "	pu2",
		"莅", "	li4",
		"莄", "	geng3",
		"莃", "	xi1",
		"莂", "	bie2",
		"荧", "	ying2",
		"荥", "	xing2",
		"莙", "	jun1",
		"茿", "	zhu2",
		"草", "	cao3",
		"荈", "	chuan3",
		"荇", "	xing4",
		"荆", "	jing1",
		"荅", "	da1",
		"荄", "	gai1",
		"荃", "	quan2",
		"荂", "	fu1",
		"荁", "	huan2",
		"荀", "	xun2",
		"茾", "	qian1",
		"荋", "	er2",
		"茽", "	zhong4",
		"茼", "	tong2",
		"茻", "	mang3",
		"茺", "	chong1",
		"茹", "	ru2",
		"茸", "	rong1",
		"茷", "	fa2",
		"茶", "	cha2",
		"茵", "	yin1",
		"茴", "	hui2",
		"荊", "	jing1",
		"荌", "	an4",
		"荤", "	hun1",
		"荙", "	da2",
		"荣", "	rong2",
		"荢", "	yu",
		"荡", "	dang4",
		"荠", "	ji4",
		"荟", "	hui4",
		"荞", "	qiao2",
		"荝", "	ze2",
		"荜", "	bi4",
		"荛", "	rao2",
		"荚", "	jia2",
		"荘", "	zhuang1",
		"荍", "	qiao2",
		"荗", "	shu4",
		"荖", "	lao3",
		"荕", "	jin1",
		"荔", "	li4",
		"荓", "	ping2",
		"荒", "	huang1",
		"荑", "	ti2",
		"荐", "	jian4",
		"荏", "	ren3",
		"荎", "	chi2",
		"莘", "	shen1",
		"莚", "	yan2",
		"茲", "	zi1",
		"菛", "	men2",
		"菥", "	xi1",
		"菤", "	juan3",
		"菣", "	qin4",
		"菢", "	bao4",
		"菡", "	han4",
		"菠", "	bo1",
		"菟", "	tu2",
		"菞", "	li2",
		"菝", "	ba2",
		"菜", "	cai4",
		"菚", "	zhan4",
		"菧", "	di3",
		"菙", "	chui2",
		"菘", "	song1",
		"菗", "	chou2",
		"菖", "	chang1",
		"菕", "	lun2",
		"菔", "	fu2",
		"菓", "	guo3",
		"菒", "	gao3",
		"菑", "	zai1",
		"菐", "	pu2",
		"菦", "	qin2",
		"菨", "	jie1",
		"菎", "	kun1",
		"菵", "	wang3",
		"菿", "	dao4",
		"菾", "	tian2",
		"菽", "	shu1",
		"菼", "	tan3",
		"菻", "	lin3",
		"菺", "	jian1",
		"菹", "	ju1",
		"菸", "	yan1",
		"菷", "	zhou3",
		"菶", "	beng3",
		"菴", "	an1",
		"菩", "	pu2",
		"菳", "	qin2",
		"菲", "	fei1",
		"菱", "	ling2",
		"菰", "	gu1",
		"華", "	hua2",
		"菮", "	geng1",
		"菭", "	tai2",
		"菬", "	qiao2",
		"菫", "	jin3",
		"菪", "	dang4",
		"菏", "	he2",
		"菍", "	nie4",
		"莛", "	ting2",
		"莧", "	xian4",
		"莱", "	lai2",
		"莰", "	kan3",
		"莯", "	mu4",
		"莮", "	nan2",
		"莭", "	jie2",
		"莬", "	wen4",
		"莫", "	mo4",
		"莪", "	e2",
		"莩", "	fu2",
		"莨", "	lang4",
		"莦", "	shao1",
		"莳", "	shi2",
		"莥", "	niu3",
		"莤", "	su4",
		"莣", "	wang2",
		"莢", "	jia2",
		"莡", "	cuo4",
		"莠", "	you3",
		"莟", "	han4",
		"莞", "	guan3",
		"莝", "	cuo4",
		"莜", "	you2",
		"莲", "	lian2",
		"莴", "	wo1",
		"菌", "	jun1",
		"菁", "	jing1",
		"菋", "	wei4",
		"菊", "	ju2",
		"菉", "	lu4",
		"菈", "	la1",
		"菇", "	gu1",
		"菆", "	zou1",
		"菅", "	jian1",
		"菄", "	dong1",
		"菃", "	qu2",
		"菂", "	di4",
		"菀", "	wan3",
		"莵", "	tu",
		"莿", "	ci4",
		"莾", "	mang3",
		"莽", "	mang3",
		"莼", "	chun2",
		"莻", "	gong4",
		"莺", "	ying1",
		"莹", "	ying2",
		"莸", "	you2",
		"获", "	huo4",
		"莶", "	xian1",
		"茳", "	jiang1",
		"茱", "	zhu1",
		"萁", "	qi2",
		"芣", "	fu2",
		"芭", "	ba1",
		"芬", "	fen1",
		"芫", "	yan2",
		"芪", "	qi2",
		"芩", "	qin2",
		"芨", "	ji1",
		"芧", "	xu4",
		"芦", "	lu2",
		"芥", "	jie4",
		"芤", "	kou1",
		"芢", "	ren2",
		"芯", "	xin1",
		"芡", "	qian4",
		"芠", "	wen2",
		"芟", "	shan1",
		"芞", "	qi4",
		"芝", "	zhi1",
		"芜", "	wu2",
		"芛", "	wei3",
		"芚", "	tun2",
		"芙", "	fu2",
		"芘", "	pi2",
		"芮", "	rui4",
		"芰", "	ji4",
		"芖", "	zhi4",
		"芽", "	ya2",
		"苇", "	wei3",
		"苆", "	qie",
		"苅", "	yi4",
		"苄", "	bian4",
		"苃", "	you3",
		"苂", "	yin2",
		"苁", "	cong1",
		"苀", "	hang2",
		"芿", "	reng4",
		"芾", "	fei4",
		"芼", "	mao4",
		"花", "	hua1",
		"芻", "	chu2",
		"芺", "	ao3",
		"芹", "	qin2",
		"芸", "	yun2",
		"芷", "	zhi3",
		"芶", "	gou3",
		"芵", "	jue2",
		"芴", "	wu4",
		"芳", "	fang1",
		"芲", "	hua1",
		"芗", "	xiang1",
		"芕", "	sui1",
		"苉", "	pi3",
		"良", "	liang2",
		"艹", "	cao",
		"艸", "	cao3",
		"艷", "	yan4",
		"艶", "	yan4",
		"艵", "	ping1",
		"艴", "	fu2",
		"艳", "	yan4",
		"色", "	se4",
		"艱", "	jian1",
		"艰", "	jian1",
		"艮", "	gen3",
		"艻", "	le4",
		"艭", "	shuang1",
		"艬", "	chan2",
		"艫", "	lu2",
		"艪", "	lu3",
		"艩", "	qi2",
		"艨", "	meng2",
		"艧", "	huo4",
		"艦", "	jian4",
		"艥", "	ji2",
		"艤", "	yi3",
		"艺", "	yi4",
		"艼", "	ting1",
		"芔", "	hui4",
		"芉", "	gan1",
		"芓", "	zi4",
		"芒", "	mang2",
		"芑", "	qi3",
		"芐", "	hu4",
		"芏", "	du4",
		"芎", "	qiong1",
		"芍", "	shao2",
		"芌", "	yu4",
		"芋", "	yu4",
		"芊", "	qian1",
		"芈", "	mi3",
		"艽", "	jiao1",
		"芇", "	mian2",
		"芆", "	chai1",
		"芅", "	yi4",
		"芄", "	wan2",
		"芃", "	peng2",
		"节", "	jie2",
		"芁", "	jiao1",
		"芀", "	tiao2",
		"艿", "	nai3",
		"艾", "	ai4",
		"苈", "	li4",
		"苊", "	e4",
		"茰", "	yu2",
		"茋", "	di3",
		"茕", "	qiong2",
		"茔", "	ying2",
		"茓", "	xue2",
		"茒", "	yuan2",
		"茑", "	niao3",
		"茐", "	cong",
		"茏", "	long2",
		"茎", "	jing1",
		"茍", "	ji4",
		"茌", "	chi2",
		"茊", "	zi1",
		"茗", "	ming2",
		"茉", "	mo4",
		"茈", "	ci2",
		"茇", "	ba2",
		"茆", "	mao2",
		"茅", "	mao2",
		"茄", "	jia1",
		"范", "	fan4",
		"茂", "	mao4",
		"茁", "	zhuo2",
		"茀", "	fu2",
		"茖", "	ge2",
		"茘", "	li4",
		"苾", "	bi4",
		"茥", "	gui1",
		"茯", "	fu2",
		"茮", "	jiao1",
		"茭", "	jiao1",
		"茬", "	cha2",
		"茫", "	mang2",
		"茪", "	guang1",
		"茩", "	gou4",
		"茨", "	ci2",
		"茧", "	jian3",
		"茦", "	ci4",
		"茤", "	ji4",
		"茙", "	rong2",
		"茣", "	wu2",
		"茢", "	lie4",
		"茡", "	zi4",
		"茠", "	hao1",
		"茟", "	yu4",
		"茞", "	chen2",
		"茝", "	chai3",
		"茜", "	qian4",
		"茛", "	gen4",
		"茚", "	yin4",
		"苿", "	wei4",
		"苽", "	gu1",
		"苋", "	xian4",
		"苗", "	miao2",
		"苡", "	yi3",
		"苠", "	min2",
		"苟", "	gou3",
		"苞", "	bao1",
		"苝", "	bei4",
		"苜", "	mu4",
		"苛", "	ke1",
		"苚", "	yong4",
		"苙", "	li4",
		"苘", "	qing3",
		"苖", "	di2",
		"苣", "	ju4",
		"苕", "	shao2",
		"苔", "	tai2",
		"苓", "	ling2",
		"苒", "	ran3",
		"苑", "	yuan4",
		"苐", "	ti2",
		"苏", "	su1",
		"苎", "	zhu4",
		"苍", "	cang1",
		"苌", "	chang2",
		"苢", "	yi3",
		"苤", "	pie3",
		"苼", "	sheng1",
		"英", "	ying1",
		"苻", "	fu2",
		"苺", "	mei2",
		"苹", "	ping2",
		"苸", "	hu1",
		"苷", "	gan1",
		"苶", "	nie2",
		"苵", "	die2",
		"苴", "	ju1",
		"苳", "	dong1",
		"苲", "	zha3",
		"苰", "	hong2",
		"若", "	ruo4",
		"苯", "	ben3",
		"苮", "	xian1",
		"苭", "	yao3",
		"苬", "	xiu2",
		"苫", "	shan1",
		"苪", "	bing3",
		"苩", "	bo2",
		"苨", "	ni3",
		"苧", "	ning2",
		"苦", "	ku3",
		"萀", "	hu3",
		"萂", "	he2",
		"艢", "	qiang2",
		"蔓", "	man4",
		"蔝", "	mi3",
		"蔜", "	ao2",
		"蔛", "	hu2",
		"蔚", "	wei4",
		"蔙", "	xuan4",
		"蔘", "	shen1",
		"蔗", "	zhe4",
		"蔖", "	cuo2",
		"蔕", "	di4",
		"蔔", "	bo2",
		"蔒", "	xun1",
		"蔟", "	cu4",
		"蔑", "	mie4",
		"蔐", "	di2",
		"蔏", "	shang1",
		"蔎", "	she4",
		"蔍", "	lu4",
		"蔌", "	su4",
		"蔋", "	di2",
		"蔊", "	han3",
		"蔉", "	gun3",
		"蔈", "	biao1",
		"蔞", "	lou2",
		"蔠", "	zhong1",
		"蔆", "	ling2",
		"蔭", "	yin1",
		"蔷", "	qiang2",
		"蔶", "	ze",
		"蔵", "	zang1",
		"蔴", "	ma2",
		"蔳", "	qian4",
		"蔲", "	kou4",
		"蔱", "	sha1",
		"蔰", "	hu4",
		"蔯", "	chen2",
		"蔮", "	guo2",
		"蔬", "	shu1",
		"蔡", "	cai4",
		"蔫", "	nian1",
		"蔪", "	jian4",
		"蔩", "	yin2",
		"蔨", "	juan4",
		"蔧", "	hui4",
		"蔦", "	niao3",
		"蔥", "	cong1",
		"蔤", "	mi4",
		"蔣", "	jiang3",
		"蔢", "	po2",
		"蔇", "	ji4",
		"蔅", "	yan2",
		"蔹", "	lian3",
		"蓟", "	ji4",
		"蓩", "	mao3",
		"蓨", "	tiao2",
		"蓧", "	diao4",
		"蓦", "	mo4",
		"蓥", "	ying2",
		"蓤", "	ling",
		"蓣", "	yu4",
		"蓢", "	lang3",
		"蓡", "	shen1",
		"蓠", "	li2",
		"蓞", "	dan4",
		"蓫", "	chu4",
		"蓝", "	lan2",
		"蓜", "	pei",
		"蓛", "	ce4",
		"蓚", "	tiao2",
		"蓙", "	zuo",
		"蓘", "	gun3",
		"蓗", "	zong3",
		"蓖", "	bi4",
		"蓕", "	gui4",
		"蓔", "	yao3",
		"蓪", "	tong1",
		"蓬", "	peng2",
		"蔄", "	man4",
		"蓹", "	yu4",
		"蔃", "	qiang2",
		"蔂", "	lei2",
		"蔁", "	zhang1",
		"蔀", "	bu4",
		"蓿", "	xu",
		"蓾", "	lu3",
		"蓽", "	bi4",
		"蓼", "	liao3",
		"蓻", "	zi2",
		"蓺", "	yi4",
		"蓸", "	cao2",
		"蓭", "	an1",
		"蓷", "	tui1",
		"蓶", "	wei2",
		"蓵", "	jie2",
		"蓴", "	chun2",
		"蓳", "	jin3",
		"蓲", "	qiu1",
		"蓱", "	ping2",
		"蓰", "	xi3",
		"蓯", "	cong1",
		"蓮", "	lian2",
		"蔸", "	dou1",
		"蔺", "	lin4",
		"蓒", "	xuan1",
		"蕻", "	hong2",
		"薅", "	hao1",
		"薄", "	bao2",
		"薃", "	hao4",
		"薂", "	xi2",
		"薁", "	yu4",
		"薀", "	yun4",
		"蕿", "	xuan1",
		"蕾", "	lei3",
		"蕽", "	nong2",
		"蕼", "	si4",
		"蕺", "	ji2",
		"薇", "	wei1",
		"蕹", "	weng4",
		"蕸", "	xia2",
		"蕷", "	yu4",
		"蕶", "	ling2",
		"蕵", "	sun1",
		"蕴", "	yun4",
		"蕳", "	jian1",
		"蕲", "	qi2",
		"蕱", "	shao",
		"蕰", "	wen1",
		"薆", "	ai4",
		"薈", "	hui4",
		"蕮", "	xi4",
		"薕", "	lian2",
		"薟", "	xian1",
		"薞", "	sun1",
		"薝", "	zhan1",
		"薜", "	bi4",
		"薛", "	xue1",
		"薚", "	tang1",
		"薙", "	ti4",
		"薘", "	da2",
		"薗", "	yuan2",
		"薖", "	ke1",
		"薔", "	qiang2",
		"薉", "	hui4",
		"薓", "	shen1",
		"薒", "	can4",
		"薑", "	jiang1",
		"薐", "	leng2",
		"薏", "	yi4",
		"薎", "	mie4",
		"薍", "	wan4",
		"薌", "	xiang1",
		"薋", "	ci2",
		"薊", "	ji4",
		"蕯", "	long2",
		"蕭", "	xiao1",
		"蔻", "	kou4",
		"蕇", "	dian3",
		"蕑", "	jian1",
		"蕐", "	hua2",
		"蕏", "	chu2",
		"蕎", "	qiao2",
		"蕍", "	yu2",
		"蕌", "	lei3",
		"蕋", "	rui3",
		"蕊", "	rui3",
		"蕉", "	jiao1",
		"蕈", "	xun4",
		"蕆", "	chan3",
		"蕓", "	yun2",
		"蕅", "	ou3",
		"蕄", "	meng2",
		"蕃", "	fan1",
		"蕂", "	sheng4",
		"蕁", "	qian2",
		"蕀", "	ji2",
		"蔿", "	wei3",
		"蔾", "	li2",
		"蔽", "	bi4",
		"蔼", "	ai3",
		"蕒", "	mai3",
		"蕔", "	bao1",
		"蕬", "	si1",
		"蕡", "	fen2",
		"蕫", "	dong3",
		"蕪", "	wu2",
		"蕩", "	dang4",
		"蕨", "	jue2",
		"蕧", "	fu4",
		"蕦", "	xu1",
		"蕥", "	ya3",
		"蕤", "	rui2",
		"蕣", "	shun4",
		"蕢", "	kui4",
		"蕠", "	ru2",
		"蕕", "	you2",
		"蕟", "	fa4",
		"蕞", "	zui4",
		"蕝", "	jue2",
		"蕜", "	fei3",
		"蕛", "	ti2",
		"碠", "	ding4",
		"蕙", "	hui4",
		"蕘", "	rao2",
		"蕗", "	lu4",
		"蕖", "	qu2",
		"蓓", "	bei4",
		"蓑", "	suo1",
		"萃", "	cui4",
		"葃", "	zuo4",
		"葍", "	fu2",
		"葌", "	jian1",
		"葋", "	qu2",
		"葊", "	an1",
		"葉", "	ye4",
		"葈", "	xi3",
		"葇", "	rou2",
		"葆", "	bao3",
		"葅", "	zu1",
		"葄", "	zuo4",
		"葂", "	mian3",
		"葏", "	jing1",
		"葁", "	jiang1",
		"葀", "	kuo4",
		"萿", "	kuo4",
		"萾", "	ying2",
		"落", "	luo4",
		"萼", "	e4",
		"萻", "	an1",
		"萺", "	mao4",
		"萹", "	bian3",
		"萸", "	yu2",
		"葎", "	lv4",
		"葐", "	pen2",
		"萶", "	chun3",
		"葝", "	qing2",
		"葧", "	bo2",
		"葦", "	wei3",
		"葥", "	jian4",
		"葤", "	zhou4",
		"董", "	dong3",
		"葢", "	gai4",
		"葡", "	pu2",
		"葠", "	shen1",
		"葟", "	huang2",
		"葞", "	mi3",
		"葜", "	qia1",
		"葑", "	feng1",
		"葛", "	ge2",
		"葚", "	ren4",
		"葙", "	xiang1",
		"葘", "	zi1",
		"著", "	zhe",
		"葖", "	tu1",
		"葕", "	yan4",
		"葔", "	hou2",
		"葓", "	hong2",
		"葒", "	hong2",
		"萷", "	xiao1",
		"萵", "	wo1",
		"葩", "	pa1",
		"萏", "	dan4",
		"萙", "	zhen",
		"萘", "	nai4",
		"萗", "	ce4",
		"萖", "	wan3",
		"萕", "	qi2",
		"萔", "	tiao2",
		"萓", "	yi2",
		"萒", "	yan3",
		"萑", "	huan2",
		"萐", "	sha4",
		"萎", "	wei1",
		"萛", "	jiu1",
		"萍", "	ping2",
		"萌", "	meng2",
		"萋", "	qi1",
		"萊", "	lai2",
		"萉", "	fei4",
		"萈", "	huan2",
		"萇", "	chang2",
		"萆", "	bi4",
		"萅", "	chun1",
		"萄", "	tao2",
		"萚", "	tuo4",
		"萜", "	tie1",
		"萴", "	ce4",
		"萩", "	qiu1",
		"萳", "	nan3",
		"萲", "	xuan1",
		"萱", "	xuan1",
		"萰", "	lian4",
		"萯", "	fu4",
		"萮", "	yu2",
		"萭", "	yu3",
		"萬", "	wan4",
		"萫", "	xiang4",
		"萪", "	ke1",
		"萨", "	sa4",
		"萝", "	luo2",
		"萧", "	xiao1",
		"萦", "	ying2",
		"营", "	ying2",
		"萤", "	ying2",
		"萣", "	ding4",
		"萢", "	pao",
		"萡", "	bo",
		"萠", "	meng2",
		"萟", "	yi",
		"萞", "	bi",
		"葨", "	wei1",
		"葪", "	ji4",
		"蓐", "	ru4",
		"蒫", "	cuo2",
		"蒵", "	xi2",
		"蒴", "	shuo4",
		"蒳", "	na4",
		"蒲", "	pu2",
		"蒱", "	pu2",
		"蒰", "	pan2",
		"蒯", "	kuai3",
		"蒮", "	yu4",
		"蒭", "	chu2",
		"蒬", "	yuan1",
		"蒪", "	po4",
		"蒷", "	yun2",
		"蒩", "	zu1",
		"蒨", "	qian4",
		"蒧", "	dian3",
		"蒦", "	huo4",
		"蒥", "	liu2",
		"蒤", "	tu2",
		"蒣", "	xu2",
		"蒢", "	chu2",
		"蒡", "	bang4",
		"蒠", "	xi1",
		"蒶", "	fen2",
		"蒸", "	zheng1",
		"蒞", "	li4",
		"蓅", "	liu2",
		"蓏", "	luo3",
		"蓎", "	tang2",
		"蓍", "	shi1",
		"蓌", "	cuo4",
		"蓋", "	gai4",
		"蓊", "	weng3",
		"蓉", "	rong2",
		"蓈", "	lang2",
		"蓇", "	gu3",
		"蓆", "	xi2",
		"蓄", "	xu4",
		"蒹", "	jian1",
		"蓃", "	sou1",
		"蓂", "	ming2",
		"蓁", "	zhen1",
		"蓀", "	sun1",
		"蒿", "	hao1",
		"蒾", "	mi2",
		"蒽", "	en1",
		"蒼", "	cang1",
		"蒻", "	ruo4",
		"蒺", "	ji2",
		"蒟", "	ju3",
		"蒝", "	yuan2",
		"葫", "	hu2",
		"葷", "	hun1",
		"蒁", "	shu4",
		"蒀", "	yun1",
		"葿", "	mei2",
		"葾", "	yuan1",
		"葽", "	yao1",
		"葼", "	zong1",
		"葻", "	lan2",
		"葺", "	qi4",
		"葹", "	shi1",
		"葸", "	xi3",
		"葶", "	ting2",
		"蒃", "	zhuan4",
		"葵", "	kui2",
		"葴", "	zhen1",
		"葳", "	wei1",
		"葲", "	quan2",
		"葱", "	cong1",
		"葰", "	sui1",
		"葯", "	yao4",
		"葮", "	duan4",
		"葭", "	jia1",
		"葬", "	zang4",
		"蒂", "	di4",
		"蒄", "	guan1",
		"蒜", "	suan4",
		"蒑", "	yin4",
		"蒛", "	que1",
		"蒚", "	li4",
		"蒙", "	meng2",
		"蒘", "	ru2",
		"蒗", "	lang4",
		"蒖", "	zhen1",
		"蒕", "	yun1",
		"蒔", "	shi2",
		"蒓", "	chun2",
		"蒒", "	shi1",
		"蒐", "	sou1",
		"蒅", "	ran",
		"蒏", "	you",
		"蒎", "	pai4",
		"蒍", "	wei3",
		"蒌", "	lou2",
		"蒋", "	jiang3",
		"蒊", "	hua1",
		"蒉", "	kui4",
		"蒈", "	kai3",
		"蒇", "	chan3",
		"蒆", "	xue1",
		"艣", "	lu3",
		"艡", "	dang1",
		"缢", "	yi4",
		"耲", "	huai2",
		"耼", "	dan1",
		"耻", "	chi3",
		"耺", "	yun2",
		"耹", "	qin2",
		"耸", "	song3",
		"耷", "	da1",
		"耶", "	ye2",
		"耵", "	ding1",
		"耴", "	yi4",
		"耳", "	er3",
		"耱", "	mo4",
		"耾", "	hong2",
		"耰", "	you1",
		"耯", "	huo4",
		"耮", "	lao4",
		"耭", "	ji1",
		"耬", "	lou2",
		"耫", "	zha2",
		"耪", "	pang3",
		"耩", "	jiang3",
		"耨", "	nou4",
		"耧", "	lou2",
		"耽", "	dan1",
		"耿", "	geng3",
		"耥", "	tang1",
		"职", "	zhi2",
		"聖", "	sheng4",
		"聕", "	hao4",
		"联", "	lian2",
		"聓", "	xu",
		"聒", "	gua1",
		"聑", "	tie1",
		"聐", "	ya4",
		"聏", "	er2",
		"聎", "	tiao1",
		"聍", "	ning2",
		"聋", "	long2",
		"聀", "	zhi2",
		"聊", "	liao2",
		"聉", "	wa4",
		"聈", "	you3",
		"聇", "	zheng1",
		"聆", "	ling2",
		"聅", "	che4",
		"聄", "	zhen3",
		"聃", "	dan1",
		"聂", "	nie4",
		"聁", "	pan4",
		"耦", "	ou3",
		"耤", "	ji2",
		"聘", "	pin4",
		"翾", "	xuan1",
		"耈", "	gou3",
		"耇", "	gou3",
		"耆", "	qi2",
		"者", "	zhe3",
		"耄", "	mao4",
		"考", "	kao3",
		"耂", "	lao3",
		"老", "	lao3",
		"耀", "	yao4",
		"翿", "	dao4",
		"翽", "	hui4",
		"耊", "	die4",
		"翼", "	yi4",
		"翻", "	fan1",
		"翺", "	ao2",
		"翹", "	qiao4",
		"翸", "	pen3",
		"翷", "	lin2",
		"翶", "	ao",
		"翵", "	hou2",
		"翴", "	lian2",
		"翳", "	yi4",
		"耉", "	gou3",
		"耋", "	die2",
		"耣", "	lun3",
		"耘", "	yun2",
		"耢", "	lao4",
		"耡", "	chu2",
		"耠", "	huo1",
		"耟", "	ju4",
		"耞", "	jia1",
		"耝", "	qu4",
		"耜", "	si4",
		"耛", "	yi2",
		"耚", "	pi1",
		"耙", "	ba4",
		"耗", "	hao4",
		"而", "	er2",
		"耖", "	chao4",
		"耕", "	geng1",
		"耔", "	zi3",
		"耓", "	ting1",
		"耒", "	lei3",
		"耑", "	duan1",
		"耐", "	nai4",
		"耏", "	nai4",
		"耎", "	ruan3",
		"耍", "	shua3",
		"聗", "	lie4",
		"聙", "	jing1",
		"翱", "	ao2",
		"肚", "	du4",
		"肤", "	fu1",
		"肣", "	han2",
		"肢", "	zhi1",
		"股", "	gu3",
		"肠", "	chang2",
		"肟", "	wo4",
		"肞", "	cha1",
		"肝", "	gan1",
		"肜", "	rong2",
		"肛", "	gang1",
		"肙", "	yuan4",
		"肦", "	fen2",
		"肘", "	zhou3",
		"肗", "	ru3",
		"肖", "	xiao4",
		"肕", "	ren4",
		"肔", "	yi3",
		"肓", "	huang1",
		"肒", "	huan4",
		"肑", "	bo2",
		"肐", "	ge1",
		"肏", "	cao4",
		"肥", "	fei2",
		"肧", "	pei1",
		"肍", "	qiu2",
		"肴", "	yao2",
		"肾", "	shen4",
		"肽", "	tai4",
		"肼", "	jing3",
		"肻", "	ken3",
		"肺", "	fei4",
		"肹", "	xi1",
		"肸", "	xi1",
		"肷", "	qian3",
		"肶", "	pi2",
		"肵", "	qi2",
		"肳", "	wen3",
		"肨", "	pang4",
		"育", "	yu4",
		"肱", "	gong1",
		"肰", "	ran2",
		"肯", "	ken3",
		"肮", "	ang1",
		"肭", "	na4",
		"肬", "	you2",
		"肫", "	zhun1",
		"肪", "	fang2",
		"肩", "	jian1",
		"肎", "	ken3",
		"肌", "	ji1",
		"聚", "	ju4",
		"聦", "	cong1",
		"聰", "	cong1",
		"聯", "	lian2",
		"聮", "	lian2",
		"聭", "	kui4",
		"聬", "	weng3",
		"聫", "	lian2",
		"聪", "	cong1",
		"聩", "	kui4",
		"聨", "	lian",
		"聧", "	kui1",
		"聥", "	ju3",
		"聲", "	sheng1",
		"聤", "	ting2",
		"聣", "	ni2",
		"聢", "	ding",
		"聡", "	cong1",
		"聠", "	ping1",
		"聟", "	xu4",
		"聞", "	wen2",
		"聝", "	guo2",
		"聜", "	di3",
		"聛", "	bi3",
		"聱", "	ao2",
		"聳", "	song3",
		"肋", "	le1",
		"肀", "	yu4",
		"肊", "	yi4",
		"肉", "	rou4",
		"肈", "	zhao4",
		"肇", "	zhao4",
		"肆", "	si4",
		"肅", "	su4",
		"肄", "	yi4",
		"肃", "	su4",
		"肂", "	si4",
		"肁", "	zhao4",
		"聿", "	yu4",
		"聴", "	ting1",
		"聾", "	long2",
		"聽", "	ting1",
		"聼", "	ting1",
		"聻", "	ni3",
		"聺", "	qie2",
		"聹", "	ning2",
		"聸", "	dan1",
		"職", "	zhi2",
		"聶", "	nie4",
		"聵", "	kui4",
		"翲", "	piao1",
		"翰", "	han4",
		"胀", "	zhang4",
		"罢", "	ba4",
		"罬", "	zhuo2",
		"罫", "	gua4",
		"罪", "	zui4",
		"罩", "	zhao4",
		"罨", "	yan3",
		"罧", "	shen4",
		"罦", "	fu2",
		"罥", "	juan4",
		"罤", "	ti2",
		"罣", "	gua4",
		"罡", "	gang1",
		"置", "	zhi4",
		"罠", "	min2",
		"罟", "	gu3",
		"罞", "	mao2",
		"罝", "	ju1",
		"罜", "	zhu3",
		"罛", "	gu1",
		"罚", "	fa2",
		"罙", "	mi2",
		"罘", "	fu2",
		"罗", "	luo2",
		"罭", "	yu4",
		"罯", "	an3",
		"罕", "	han3",
		"罼", "	bi4",
		"羆", "	pi2",
		"羅", "	luo2",
		"羄", "	zhao4",
		"羃", "	mi4",
		"羂", "	juan4",
		"羁", "	ji1",
		"羀", "	liu3",
		"罿", "	chong1",
		"罾", "	zeng1",
		"罽", "	ji4",
		"罻", "	wei4",
		"罰", "	fa2",
		"罺", "	chao2",
		"罹", "	li2",
		"罸", "	fa2",
		"罷", "	ba4",
		"罶", "	liu3",
		"罵", "	ma4",
		"罴", "	pi2",
		"罳", "	si1",
		"署", "	shu3",
		"罱", "	lan3",
		"罖", "	luo2",
		"罔", "	wang3",
		"羈", "	ji1",
		"缮", "	shan4",
		"缸", "	gang1",
		"缷", "	xie4",
		"缶", "	fou3",
		"缵", "	zuan3",
		"缴", "	jiao3",
		"缳", "	huan2",
		"缲", "	qiao1",
		"缱", "	qian3",
		"缰", "	jiang1",
		"缯", "	zeng1",
		"缭", "	liao2",
		"缺", "	que1",
		"缬", "	xie2",
		"缫", "	sao1",
		"缪", "	mou2",
		"缩", "	suo1",
		"缨", "	ying1",
		"缧", "	lei2",
		"缦", "	man4",
		"缥", "	piao1",
		"缤", "	bin1",
		"缣", "	jian1",
		"缹", "	fou3",
		"缻", "	fou3",
		"罓", "	gang1",
		"罈", "	tan2",
		"罒", "	wang3",
		"网", "	wang3",
		"罐", "	guan4",
		"罏", "	lu2",
		"罎", "	tan2",
		"罍", "	lei2",
		"罌", "	ying1",
		"罋", "	weng4",
		"罊", "	qi4",
		"罉", "	cang",
		"罇", "	zun1",
		"缼", "	qi",
		"罆", "	guan4",
		"罅", "	xia4",
		"罄", "	qing4",
		"罃", "	ying1",
		"罂", "	ying1",
		"罁", "	gang1",
		"罀", "	zhao",
		"缿", "	xiang4",
		"缾", "	ping2",
		"缽", "	bo1",
		"羇", "	ji1",
		"羉", "	luan2",
		"翯", "	he4",
		"翊", "	yi4",
		"翔", "	xiang2",
		"翓", "	xie2",
		"習", "	xi2",
		"翑", "	qu2",
		"翐", "	zhi4",
		"翏", "	liu4",
		"翎", "	ling2",
		"翍", "	pi1",
		"翌", "	yi4",
		"翋", "	la1",
		"翉", "	ben3",
		"翖", "	xi4",
		"翈", "	xia2",
		"翇", "	fu2",
		"翆", "	cui4",
		"翅", "	chi4",
		"翄", "	chi4",
		"翃", "	hong2",
		"翂", "	fen1",
		"翁", "	weng1",
		"翀", "	chong1",
		"羿", "	yi4",
		"翕", "	xi1",
		"翗", "	ke2",
		"羽", "	yu3",
		"翤", "	chi4",
		"翮", "	he2",
		"翭", "	hou2",
		"翬", "	hui1",
		"翫", "	wan2",
		"翪", "	zong1",
		"翩", "	pian1",
		"翨", "	chi4",
		"翧", "	xuan1",
		"翦", "	jian3",
		"翥", "	zhu4",
		"翣", "	sha4",
		"翘", "	qiao4",
		"翢", "	dao4",
		"翡", "	fei3",
		"翠", "	cui4",
		"翟", "	di2",
		"翞", "	jiang1",
		"翝", "	hong2",
		"翜", "	sha4",
		"翛", "	xiao1",
		"翚", "	hui1",
		"翙", "	hui4",
		"羾", "	gong4",
		"羼", "	chan4",
		"羊", "	yang2",
		"羖", "	gu3",
		"羠", "	yi2",
		"羟", "	qiang3",
		"羞", "	xiu1",
		"羝", "	di1",
		"羜", "	zhu4",
		"羛", "	yi4",
		"羚", "	ling2",
		"羙", "	gao1",
		"羘", "	zang1",
		"羗", "	qiang1",
		"羕", "	yang4",
		"羢", "	rong2",
		"羔", "	gao1",
		"羓", "	ba1",
		"羒", "	fen2",
		"羑", "	you3",
		"羐", "	you3",
		"羏", "	yang2",
		"美", "	mei3",
		"羍", "	da2",
		"羌", "	qiang1",
		"羋", "	mi3",
		"羡", "	xian4",
		"羣", "	qun2",
		"羻", "	qiang4",
		"羰", "	tang1",
		"羺", "	nou2",
		"羹", "	geng1",
		"羸", "	lei2",
		"羷", "	lian3",
		"羶", "	shan1",
		"羵", "	fen2",
		"羴", "	shan1",
		"羳", "	fan2",
		"羲", "	xi1",
		"羱", "	yuan2",
		"羯", "	jie2",
		"群", "	qun2",
		"羮", "	geng1",
		"羭", "	yu2",
		"羬", "	qian2",
		"羫", "	qiang1",
		"羪", "	yang",
		"義", "	yi4",
		"羨", "	xian4",
		"羧", "	suo1",
		"羦", "	huan2",
		"羥", "	qiang3",
		"肿", "	zhong3",
		"胁", "	xie2",
		"艠", "	deng",
		"臓", "	zang4",
		"臝", "	luo3",
		"臜", "	za1",
		"臛", "	huo4",
		"臚", "	lu2",
		"臙", "	yan1",
		"臘", "	la4",
		"臗", "	kuan1",
		"臖", "	xing4",
		"臕", "	biao1",
		"臔", "	xian4",
		"臒", "	wo4",
		"臟", "	zang4",
		"臑", "	nao4",
		"臐", "	xun1",
		"臏", "	bin4",
		"臎", "	cui4",
		"臍", "	qi2",
		"臌", "	gu3",
		"臋", "	tun2",
		"臊", "	sao1",
		"臉", "	lian3",
		"臈", "	la4",
		"臞", "	qu2",
		"臠", "	luan2",
		"臆", "	yi4",
		"臭", "	chou4",
		"臷", "	die2",
		"臶", "	jian4",
		"臵", "	ge2",
		"致", "	zhi4",
		"至", "	zhi4",
		"臲", "	nie4",
		"臱", "	mian2",
		"臰", "	chou4",
		"臯", "	gao1",
		"臮", "	ji4",
		"臬", "	nie4",
		"臡", "	ni2",
		"臫", "	jiao3",
		"自", "	zi4",
		"臩", "	guang3",
		"臨", "	lin2",
		"臧", "	zang1",
		"臦", "	guang4",
		"臥", "	wo4",
		"臤", "	qian1",
		"臣", "	chen2",
		"臢", "	za1",
		"臇", "	juan3",
		"臅", "	chu4",
		"臹", "	xiu1",
		"膟", "	lv4",
		"膩", "	ni4",
		"膨", "	peng2",
		"膧", "	tong2",
		"膦", "	lin4",
		"膥", "	chun1",
		"膤", "	xue",
		"膣", "	zhi4",
		"膢", "	lv2",
		"膡", "	ying4",
		"膠", "	jiao1",
		"膞", "	zhuan1",
		"膫", "	liao2",
		"膝", "	xi1",
		"膜", "	mo2",
		"膛", "	tang2",
		"膚", "	fu1",
		"膙", "	jiang3",
		"膘", "	biao1",
		"膗", "	chuai2",
		"膖", "	pang1",
		"膕", "	guo2",
		"膔", "	lu4",
		"膪", "	chuai4",
		"膬", "	cui4",
		"臄", "	jue2",
		"膹", "	fen4",
		"臃", "	yong1",
		"臂", "	bi4",
		"臁", "	lian2",
		"臀", "	tun2",
		"膿", "	nong2",
		"膾", "	kuai4",
		"膽", "	dan3",
		"膼", "	zhua1",
		"膻", "	shan1",
		"膺", "	ying1",
		"膸", "	sui3",
		"膭", "	gui1",
		"膷", "	xiang1",
		"膶", "	run4",
		"膵", "	cui4",
		"膴", "	hu1",
		"膳", "	shan4",
		"膲", "	jiao1",
		"膱", "	zhi2",
		"膰", "	fan2",
		"膯", "	teng1",
		"膮", "	xiao1",
		"臸", "	zhi1",
		"臺", "	tai2",
		"膒", "	ou2",
		"舻", "	lu2",
		"艅", "	yu2",
		"艄", "	shao1",
		"艃", "	li2",
		"艂", "	feng2",
		"艁", "	zao4",
		"艀", "	fu2",
		"舿", "	kua",
		"舾", "	xi1",
		"舽", "	pang2",
		"舼", "	qiong2",
		"舺", "	xia2",
		"艇", "	ting3",
		"船", "	chuan2",
		"舸", "	ge3",
		"舷", "	xian2",
		"舶", "	bo2",
		"舵", "	duo4",
		"舴", "	ze2",
		"舳", "	zhu2",
		"舲", "	ling2",
		"舱", "	cang1",
		"舰", "	jian4",
		"艆", "	lang2",
		"艈", "	yu4",
		"舮", "	lu",
		"艕", "	bang4",
		"艟", "	chong1",
		"艞", "	yao4",
		"艝", "	xue",
		"艜", "	dai4",
		"艛", "	lou2",
		"艚", "	cao2",
		"艙", "	cang1",
		"艘", "	sou1",
		"艗", "	yi4",
		"艖", "	cha1",
		"艔", "	dou",
		"艉", "	wei3",
		"艓", "	die2",
		"艒", "	mu4",
		"艑", "	bian4",
		"艐", "	ke4",
		"艏", "	shou3",
		"艎", "	huang2",
		"艍", "	ju1",
		"艌", "	nian4",
		"艋", "	meng3",
		"艊", "	bo2",
		"舯", "	zhong1",
		"舭", "	bi3",
		"臻", "	zhen1",
		"與", "	yu3",
		"舑", "	tan1",
		"舐", "	shi4",
		"舏", "	jiu3",
		"舎", "	she",
		"舍", "	she3",
		"舌", "	she2",
		"舋", "	xin4",
		"舊", "	jiu4",
		"舉", "	ju3",
		"興", "	xing4",
		"舆", "	yu2",
		"舓", "	shi4",
		"舅", "	jiu4",
		"舄", "	xi4",
		"舃", "	xi4",
		"舂", "	chong1",
		"舁", "	yu2",
		"舀", "	yao3",
		"臿", "	cha1",
		"臾", "	yu2",
		"臽", "	xian4",
		"臼", "	jiu4",
		"舒", "	shu1",
		"舔", "	tian3",
		"般", "	ban1",
		"舡", "	chuan2",
		"舫", "	fang3",
		"航", "	hang2",
		"舩", "	chuan2",
		"舨", "	ban3",
		"舧", "	fan2",
		"舦", "	tai4",
		"舥", "	pa1",
		"舤", "	fan",
		"舣", "	yi3",
		"舢", "	shan1",
		"舠", "	dao1",
		"舕", "	tan4",
		"舟", "	zhou1",
		"舞", "	wu3",
		"舝", "	xia2",
		"舜", "	shun4",
		"舛", "	chuan3",
		"舚", "	tian4",
		"舙", "	hua4",
		"舘", "	guan3",
		"舗", "	pu4",
		"舖", "	pu4",
		"膓", "	chang2",
		"膑", "	bin4",
		"胂", "	shen4",
		"脂", "	zhi1",
		"脌", "	nin",
		"脋", "	xie",
		"脊", "	ji2",
		"脉", "	mai4",
		"脈", "	mai4",
		"脇", "	xie2",
		"脆", "	cui4",
		"脅", "	xie2",
		"脄", "	mei2",
		"脃", "	cui4",
		"脁", "	tiao3",
		"脎", "	sa4",
		"脀", "	cheng2",
		"胿", "	gui1",
		"胾", "	zi4",
		"能", "	neng2",
		"胼", "	pian2",
		"胻", "	heng2",
		"胺", "	an4",
		"胹", "	er2",
		"胸", "	xiong1",
		"胷", "	xiong1",
		"脍", "	kuai4",
		"脏", "	zang4",
		"胵", "	chi1",
		"脜", "	you3",
		"脦", "	de",
		"脥", "	qian3",
		"脤", "	shen4",
		"脣", "	chun2",
		"脢", "	mei2",
		"脡", "	ting3",
		"脠", "	shan1",
		"脟", "	lie4",
		"脞", "	cuo3",
		"脝", "	heng1",
		"脛", "	jing4",
		"脐", "	qi2",
		"脚", "	jiao3",
		"脙", "	xiu1",
		"脘", "	wan3",
		"脗", "	wen3",
		"脖", "	bo2",
		"脕", "	wan4",
		"脔", "	luan2",
		"脓", "	nong2",
		"脒", "	mi3",
		"脑", "	nao3",
		"胶", "	jiao1",
		"胴", "	dong4",
		"脨", "	cu4",
		"胎", "	tai1",
		"胘", "	xian2",
		"胗", "	zhen1",
		"胖", "	pang4",
		"胕", "	fu3",
		"胔", "	zi4",
		"胓", "	ping2",
		"胒", "	ni4",
		"胑", "	zhi1",
		"胐", "	ku1",
		"胏", "	zi3",
		"胍", "	gua1",
		"胚", "	pei1",
		"背", "	bei4",
		"胋", "	tian2",
		"胊", "	qu2",
		"胉", "	bo2",
		"胈", "	ba2",
		"胇", "	fei4",
		"胆", "	dan3",
		"胅", "	die2",
		"胄", "	zhou4",
		"胃", "	wei4",
		"胙", "	zuo4",
		"胛", "	jia3",
		"胳", "	ge1",
		"胨", "	dong4",
		"胲", "	hai3",
		"胱", "	guang1",
		"胰", "	yi2",
		"胯", "	kua4",
		"胮", "	pang1",
		"胭", "	yan1",
		"胬", "	nu3",
		"胫", "	jing4",
		"胪", "	lu2",
		"胩", "	ka3",
		"胧", "	long2",
		"胜", "	sheng4",
		"胦", "	yang1",
		"胥", "	xu1",
		"胤", "	yin4",
		"胣", "	chi3",
		"胢", "	ke1",
		"胡", "	hu2",
		"胠", "	qu1",
		"胟", "	mu3",
		"胞", "	bao1",
		"胝", "	zhi1",
		"脧", "	juan1",
		"脩", "	xiu1",
		"膐", "	lv3",
		"腫", "	zhong3",
		"腵", "	jia1",
		"腴", "	yu2",
		"腳", "	jiao3",
		"腲", "	wei3",
		"腱", "	jian4",
		"腰", "	yao1",
		"腯", "	tu2",
		"腮", "	sai1",
		"腭", "	e4",
		"腬", "	rou4",
		"腪", "	yun4",
		"腷", "	bi4",
		"腩", "	nan3",
		"腨", "	shuan4",
		"腧", "	shu4",
		"腦", "	nao3",
		"腥", "	xing1",
		"腤", "	an1",
		"腣", "	di4",
		"腢", "	ou3",
		"腡", "	luo2",
		"腠", "	cou4",
		"腶", "	duan4",
		"腸", "	chang2",
		"腞", "	zhuan4",
		"膅", "	tang2",
		"膏", "	gao1",
		"膎", "	xie2",
		"膍", "	pi2",
		"膌", "	ji2",
		"膋", "	liao2",
		"膊", "	bo2",
		"膉", "	yi4",
		"膈", "	ge2",
		"膇", "	zhui4",
		"膆", "	su4",
		"膄", "	sou4",
		"腹", "	fu4",
		"膃", "	wa4",
		"膂", "	lv3",
		"膁", "	qian3",
		"膀", "	bang3",
		"腿", "	tui3",
		"腾", "	teng2",
		"腽", "	wa4",
		"腼", "	mian3",
		"腻", "	ni4",
		"腺", "	xian4",
		"腟", "	chi4",
		"腝", "	ni2",
		"脪", "	xin4",
		"脶", "	luo2",
		"腀", "	lun2",
		"脿", "	biao1",
		"脾", "	pi2",
		"脽", "	shui2",
		"脼", "	liang3",
		"脻", "	jie1",
		"脺", "	cui4",
		"脹", "	zhang4",
		"脸", "	lian3",
		"脷", "	li4",
		"脵", "	gu3",
		"腂", "	lei3",
		"脴", "	pi3",
		"脳", "	nao",
		"脲", "	niao4",
		"脱", "	tuo1",
		"脰", "	dou4",
		"脯", "	pu2",
		"脮", "	nei3",
		"脭", "	cheng2",
		"脬", "	pao1",
		"脫", "	tuo1",
		"腁", "	pian2",
		"腃", "	kui4",
		"腜", "	mei3",
		"腑", "	fu3",
		"腛", "	wo4",
		"腚", "	ding4",
		"腙", "	zong1",
		"腘", "	guo2",
		"腗", "	pi2",
		"腖", "	dong4",
		"腕", "	wan4",
		"腔", "	qiang1",
		"腓", "	fei2",
		"腒", "	ju1",
		"腐", "	fu3",
		"腄", "	chui2",
		"腏", "	chuo4",
		"腎", "	shen4",
		"腍", "	ren4",
		"腌", "	yan1",
		"腋", "	ye4",
		"腊", "	la4",
		"腉", "	nai2",
		"腈", "	jing1",
		"腇", "	nei3",
		"腆", "	tian3",
		"腅", "	dan4",
		"碡", "	du2",
		"牟", "	mou2",
		"碟", "	die2",
		"濨", "	ci2",
		"濲", "	gu3",
		"濱", "	bin1",
		"濰", "	wei2",
		"濯", "	zhuo2",
		"濮", "	pu2",
		"濭", "	ai3",
		"濬", "	jun4",
		"濫", "	lan4",
		"濪", "	jing4",
		"濩", "	huo4",
		"濧", "	dui4",
		"濴", "	ying2",
		"濦", "	yin3",
		"濥", "	yin3",
		"濤", "	tao1",
		"濣", "	wo4",
		"濢", "	cui4",
		"濡", "	ru2",
		"濠", "	hao2",
		"濟", "	ji4",
		"濞", "	bi4",
		"濝", "	qi2",
		"濳", "	qian2",
		"濵", "	bin",
		"濛", "	meng2",
		"瀂", "	lu3",
		"瀌", "	biao1",
		"瀋", "	shen3",
		"瀊", "	pan2",
		"瀉", "	xie4",
		"瀈", "	hui1",
		"瀇", "	wang3",
		"瀆", "	du2",
		"瀅", "	ying2",
		"瀄", "	zhi4",
		"瀃", "	si4",
		"瀁", "	yang4",
		"濶", "	kuo4",
		"瀀", "	you1",
		"濿", "	li4",
		"濾", "	lv4",
		"濽", "	zan4",
		"濼", "	luo4",
		"濻", "	wei3",
		"濺", "	jian4",
		"濹", "	me",
		"濸", "	cang",
		"濷", "	fei4",
		"濜", "	jin4",
		"濚", "	ying2",
		"瀎", "	mo4",
		"澴", "	huan2",
		"澾", "	ta4",
		"澽", "	ju4",
		"澼", "	pi4",
		"澻", "	sui4",
		"澺", "	yi4",
		"澹", "	dan4",
		"澸", "	dan3",
		"澷", "	man4",
		"澶", "	chan2",
		"澵", "	zhen1",
		"澳", "	ao4",
		"激", "	ji1",
		"澲", "	ye4",
		"澱", "	dian4",
		"澰", "	lian4",
		"澯", "	can4",
		"澮", "	hui4",
		"澭", "	yong1",
		"澬", "	zi1",
		"澫", "	wan4",
		"澪", "	ling2",
		"澩", "	xue2",
		"澿", "	qin2",
		"濁", "	zhuo2",
		"濙", "	ying2",
		"濎", "	ding3",
		"濘", "	ning4",
		"濗", "	mi4",
		"濖", "	shu4",
		"濕", "	shi1",
		"濔", "	mi3",
		"濓", "	lian2",
		"濒", "	bin1",
		"濑", "	lai4",
		"濐", "	zhu3",
		"濏", "	se4",
		"濍", "	song1",
		"濂", "	lian2",
		"濌", "	ta4",
		"濋", "	chu3",
		"濊", "	hui4",
		"濉", "	sui1",
		"濈", "	ji2",
		"濇", "	se4",
		"濆", "	fen2",
		"濅", "	jin4",
		"濄", "	guo1",
		"濃", "	nong2",
		"瀍", "	chan2",
		"瀏", "	liu2",
		"澧", "	li3",
		"灐", "	ying",
		"灚", "	jiao3",
		"灙", "	dang3",
		"灘", "	tan1",
		"灗", "	shan4",
		"灖", "	mi3",
		"灕", "	li2",
		"灔", "	yan4",
		"灓", "	luan2",
		"灒", "	zan4",
		"灑", "	sa3",
		"灏", "	hao4",
		"灜", "	ying",
		"灎", "	yan4",
		"灍", "	que4",
		"灌", "	guan4",
		"灋", "	fa3",
		"灊", "	qian2",
		"灉", "	yong1",
		"灈", "	qu2",
		"灇", "	cong2",
		"灆", "	lan2",
		"灅", "	lei3",
		"灛", "	chan3",
		"灝", "	hao4",
		"灃", "	feng1",
		"灪", "	yu4",
		"灴", "	hong1",
		"灳", "	hui",
		"灲", "	xiao1",
		"灱", "	xiao1",
		"灰", "	hui1",
		"灯", "	deng1",
		"灮", "	guang1",
		"灭", "	mie4",
		"灬", "	biao1",
		"火", "	huo3",
		"灩", "	yan4",
		"灞", "	ba4",
		"灨", "	gan4",
		"灧", "	yan4",
		"灦", "	xian3",
		"灥", "	xun2",
		"灤", "	luan2",
		"灣", "	wan1",
		"灢", "	nang3",
		"灡", "	lan2",
		"灠", "	lan3",
		"灟", "	zhu2",
		"灄", "	she4",
		"灂", "	zhuo2",
		"瀐", "	jian1",
		"瀜", "	rong2",
		"瀦", "	zhu1",
		"瀥", "	xue4",
		"瀤", "	huai2",
		"瀣", "	xie4",
		"瀢", "	wei3",
		"瀡", "	sui3",
		"瀠", "	ying2",
		"瀟", "	xiao1",
		"瀞", "	jing4",
		"瀝", "	li4",
		"瀛", "	ying2",
		"瀨", "	lai4",
		"瀚", "	han4",
		"瀙", "	qin4",
		"瀘", "	lu2",
		"瀗", "	xian4",
		"瀖", "	huo4",
		"瀕", "	bin1",
		"瀔", "	gu3",
		"瀓", "	cheng2",
		"瀒", "	se4",
		"瀑", "	pu4",
		"瀧", "	long2",
		"瀩", "	dui4",
		"灁", "	yuan1",
		"瀶", "	lin2",
		"灀", "	shuang4",
		"瀿", "	fan2",
		"瀾", "	lan2",
		"瀽", "	jian3",
		"瀼", "	rang2",
		"瀻", "	dai4",
		"瀺", "	chan2",
		"瀹", "	yue4",
		"瀸", "	jian1",
		"瀷", "	yi4",
		"瀵", "	fen4",
		"瀪", "	fan2",
		"瀴", "	ying2",
		"瀳", "	jian4",
		"瀲", "	lian4",
		"瀱", "	ji4",
		"瀰", "	mi2",
		"瀯", "	ying2",
		"瀮", "	ling",
		"瀭", "	shu",
		"瀬", "	lai4",
		"瀫", "	hu2",
		"澨", "	shi4",
		"澦", "	yu4",
		"灶", "	zao4",
		"漘", "	chun2",
		"漢", "	han4",
		"漡", "	shang1",
		"漠", "	mo4",
		"漟", "	tang2",
		"漞", "	mi4",
		"漝", "	xi2",
		"漜", "	ye3",
		"漛", "	teng2",
		"漚", "	ou1",
		"漙", "	tuan2",
		"漗", "	cong1",
		"漤", "	lan3",
		"漖", "	jiao4",
		"漕", "	cao2",
		"演", "	yan3",
		"漓", "	li2",
		"漒", "	qiang2",
		"漑", "	gai4",
		"漐", "	zhi2",
		"漏", "	lou4",
		"漎", "	cong2",
		"漍", "	guo2",
		"漣", "	lian2",
		"漥", "	wa1",
		"漋", "	long2",
		"漲", "	zhang3",
		"漼", "	cui3",
		"漻", "	liao2",
		"漺", "	shuang3",
		"漹", "	yan1",
		"漸", "	jian4",
		"漷", "	huo3",
		"漶", "	huan4",
		"漵", "	xu4",
		"漴", "	zhuang4",
		"漳", "	zhang1",
		"漱", "	shu4",
		"漦", "	chi2",
		"漰", "	peng1",
		"漯", "	luo4",
		"漮", "	kang1",
		"漭", "	mang3",
		"漬", "	zi4",
		"漫", "	man4",
		"漪", "	yi1",
		"漩", "	xuan2",
		"漨", "	feng2",
		"漧", "	gan1",
		"漌", "	jin3",
		"漊", "	lou2",
		"漾", "	yang4",
		"滤", "	lv4",
		"滮", "	biao1",
		"滭", "	bi4",
		"滬", "	hu4",
		"滫", "	xiu3",
		"滪", "	yu4",
		"滩", "	tan1",
		"滨", "	bin1",
		"滧", "	xiao",
		"滦", "	luan2",
		"滥", "	lan4",
		"滣", "	chun2",
		"滰", "	jiang4",
		"滢", "	ying2",
		"满", "	man3",
		"滠", "	she4",
		"滟", "	yan4",
		"滞", "	zhi4",
		"滝", "	long2",
		"滜", "	gao1",
		"滛", "	yin2",
		"滚", "	gun3",
		"滙", "	hui4",
		"滯", "	zhi4",
		"滱", "	kou4",
		"漉", "	lu4",
		"滾", "	gun3",
		"漈", "	ji4",
		"漇", "	xi3",
		"漆", "	qi1",
		"漅", "	chao2",
		"漄", "	ya2",
		"漃", "	ji4",
		"漂", "	piao4",
		"漁", "	yu2",
		"漀", "	qing3",
		"滿", "	man3",
		"滽", "	yong1",
		"滲", "	shen4",
		"滼", "	fan4",
		"滻", "	chan3",
		"滺", "	you1",
		"滹", "	hu1",
		"滸", "	hu3",
		"滷", "	lu3",
		"滶", "	ao2",
		"滵", "	mi4",
		"滴", "	di1",
		"滳", "	shang1",
		"漽", "	ti2",
		"漿", "	jiang1",
		"澥", "	xie4",
		"澀", "	se4",
		"澊", "	cun1",
		"澉", "	gan3",
		"澈", "	che4",
		"澇", "	lao4",
		"澆", "	jiao1",
		"澅", "	hua4",
		"澄", "	cheng2",
		"澃", "	jiong3",
		"澂", "	cheng2",
		"澁", "	se4",
		"潿", "	wei2",
		"澌", "	si1",
		"潾", "	lin2",
		"潽", "	pu1",
		"潼", "	tong2",
		"潻", "	shu3",
		"潺", "	chan2",
		"潹", "	chan2",
		"潸", "	shan1",
		"潷", "	bi4",
		"潶", "	hei1",
		"潵", "	sa3",
		"澋", "	hong4",
		"澍", "	shu4",
		"潳", "	tu2",
		"澚", "	yu",
		"澤", "	ze2",
		"澣", "	huan4",
		"澢", "	dang1",
		"澡", "	zao3",
		"澠", "	mian3",
		"澟", "	lin3",
		"澞", "	yu2",
		"澝", "	ning",
		"澜", "	lan2",
		"澛", "	lu3",
		"澙", "	xi4",
		"澎", "	peng1",
		"澘", "	shan1",
		"澗", "	jian4",
		"澖", "	xian2",
		"澕", "	he2",
		"澔", "	hao4",
		"澓", "	fu2",
		"澒", "	hong4",
		"澑", "	liu4",
		"澐", "	yun2",
		"澏", "	han2",
		"潴", "	zhu1",
		"潲", "	shao4",
		"潀", "	cong2",
		"潌", "	zhi4",
		"潖", "	pa2",
		"潕", "	wu3",
		"潔", "	jie2",
		"潓", "	hui4",
		"潒", "	dang4",
		"潑", "	po1",
		"潐", "	jiao4",
		"潏", "	yu4",
		"潎", "	pi4",
		"潍", "	wei2",
		"潋", "	lian4",
		"潘", "	pan1",
		"潊", "	xu4",
		"潉", "	kun",
		"潈", "	zong",
		"潇", "	xiao1",
		"潆", "	ying2",
		"潅", "	guan4",
		"潄", "	shu4",
		"潃", "	xun2",
		"潂", "	hong2",
		"潁", "	ying3",
		"潗", "	ji2",
		"潙", "	wei2",
		"潱", "	ye1",
		"潦", "	lao3",
		"潰", "	kui4",
		"潯", "	xun2",
		"潮", "	chao2",
		"潭", "	tan2",
		"潬", "	shan4",
		"潫", "	wan1",
		"潪", "	zhe4",
		"潩", "	yi4",
		"潨", "	cong2",
		"潧", "	zhen1",
		"潥", "	su4",
		"潚", "	su4",
		"潤", "	run4",
		"潣", "	min3",
		"潢", "	huang2",
		"潡", "	dun4",
		"潠", "	xun4",
		"潟", "	xi4",
		"潞", "	lu4",
		"潝", "	xi1",
		"潜", "	qian2",
		"潛", "	qian2",
		"灵", "	ling2",
		"灷", "	zhuan4",
		"滗", "	bi4",
		"熊", "	xiong2",
		"熔", "	rong2",
		"熓", "	wu3",
		"熒", "	ying2",
		"熑", "	lian2",
		"熐", "	mi4",
		"熏", "	xun1",
		"熎", "	yao4",
		"熍", "	qiong",
		"熌", "	shan3",
		"熋", "	nai2",
		"熉", "	yun2",
		"熖", "	yan",
		"熈", "	xi1",
		"熇", "	he4",
		"熆", "	he2",
		"熅", "	yun4",
		"熄", "	xi1",
		"熃", "	wu4",
		"熂", "	xi4",
		"熁", "	xie2",
		"熀", "	huang3",
		"煿", "	bo2",
		"熕", "	gong1",
		"熗", "	qiang4",
		"煽", "	shan1",
		"熤", "	yi4",
		"熮", "	liu3",
		"熭", "	wei4",
		"熬", "	ao2",
		"熫", "	zhi4",
		"熪", "	yi2",
		"熩", "	hu4",
		"熨", "	yun4",
		"熧", "	zong1",
		"熦", "	jue2",
		"熥", "	teng1",
		"熣", "	sui1",
		"熘", "	liu1",
		"熢", "	peng2",
		"熡", "	lou2",
		"熠", "	yi4",
		"熟", "	shu2",
		"熞", "	jian1",
		"熝", "	lu4",
		"熜", "	cong1",
		"熛", "	biao1",
		"熚", "	bi4",
		"熙", "	xi1",
		"煾", "	en1",
		"煼", "	chao3",
		"熰", "	ou1",
		"煖", "	nuan3",
		"煠", "	zha2",
		"煟", "	wei4",
		"煞", "	sha1",
		"煝", "	mei4",
		"煜", "	yu4",
		"煛", "	jiong3",
		"煚", "	jiong3",
		"煙", "	yan1",
		"煘", "	chan2",
		"煗", "	nuan3",
		"煕", "	xi1",
		"煢", "	qiong2",
		"煔", "	shan3",
		"煓", "	tuan1",
		"煒", "	wei3",
		"煑", "	zhu3",
		"煐", "	ying1",
		"煏", "	bi4",
		"煎", "	jian1",
		"煍", "	jiao3",
		"煌", "	huang2",
		"煋", "	xing1",
		"煡", "	xin4",
		"煣", "	rou2",
		"煻", "	tang2",
		"煰", "	gao4",
		"煺", "	tui4",
		"煹", "	gou4",
		"煸", "	bian1",
		"煷", "	liang",
		"煶", "	shi",
		"煵", "	xia1",
		"煴", "	yun1",
		"煳", "	hu2",
		"煲", "	bao1",
		"煱", "	gua1",
		"煯", "	jie1",
		"煤", "	mei2",
		"煮", "	zhu3",
		"煭", "	lie4",
		"煬", "	yang2",
		"煫", "	sui4",
		"煪", "	qiu2",
		"煩", "	fan2",
		"煨", "	wei1",
		"照", "	zhao4",
		"煦", "	xu4",
		"煥", "	huan4",
		"熯", "	han4",
		"熱", "	re4",
		"煉", "	lian4",
		"燲", "	xie2",
		"燼", "	jin4",
		"燻", "	xun1",
		"燺", "	kao3",
		"燹", "	xian3",
		"燸", "	ru2",
		"燷", "	lan2",
		"燶", "	nong2",
		"燵", "	da",
		"燴", "	hui4",
		"燳", "	zhao4",
		"燱", "	yi4",
		"燾", "	dao4",
		"燰", "	wei1",
		"燯", "	ling2",
		"燮", "	xie4",
		"燭", "	zhu2",
		"燬", "	hui3",
		"燫", "	lian2",
		"燪", "	cong1",
		"燩", "	que4",
		"燨", "	xi1",
		"燧", "	sui4",
		"燽", "	chou2",
		"燿", "	yao4",
		"燥", "	zao4",
		"爌", "	kuang4",
		"爖", "	long2",
		"爕", "	xie4",
		"爔", "	xi1",
		"爓", "	yan4",
		"爒", "	liao3",
		"爑", "	jue2",
		"爐", "	lu2",
		"爏", "	li4",
		"爎", "	liao",
		"爍", "	shuo4",
		"爋", "	xun4",
		"爀", "	he4",
		"爊", "	ao1",
		"爉", "	la4",
		"爈", "	lv4",
		"爇", "	ruo4",
		"爆", "	bao4",
		"爅", "	mo4",
		"爄", "	li4",
		"爃", "	rong2",
		"爂", "	biao1",
		"爁", "	lan4",
		"燦", "	can4",
		"燤", "	tai4",
		"熲", "	jiong3",
		"熾", "	chi4",
		"燈", "	deng1",
		"燇", "	jun4",
		"燆", "	qiao1",
		"燅", "	xian2",
		"燄", "	yan4",
		"燃", "	ran2",
		"燂", "	tan2",
		"燁", "	ye4",
		"燀", "	chan3",
		"熿", "	huang2",
		"熽", "	xiao4",
		"燊", "	shen1",
		"熼", "	yi4",
		"熻", "	xi1",
		"熺", "	xi1",
		"熹", "	xi1",
		"熸", "	jian1",
		"熷", "	zeng1",
		"熶", "	cuan4",
		"熵", "	shang1",
		"熴", "	kun",
		"熳", "	man4",
		"燉", "	dun4",
		"燋", "	jiao1",
		"燣", "	lan2",
		"燘", "	mei3",
		"燢", "	xue2",
		"燡", "	yi4",
		"燠", "	yu4",
		"營", "	ying2",
		"燞", "	jiao3",
		"燝", "	jing",
		"燜", "	men4",
		"燛", "	jing3",
		"燚", "	yi4",
		"燙", "	tang4",
		"燗", "	lan4",
		"燌", "	fen2",
		"燖", "	xun2",
		"燕", "	yan4",
		"燔", "	fan2",
		"燓", "	fen1",
		"燒", "	shao1",
		"燑", "	tong2",
		"燐", "	lin2",
		"燏", "	yu4",
		"燎", "	liao2",
		"燍", "	si1",
		"煊", "	xuan1",
		"煈", "	feng4",
		"灸", "	jiu3",
		"炸", "	zha4",
		"烂", "	lan4",
		"烁", "	shuo4",
		"烀", "	hu1",
		"炿", "	zhou",
		"炾", "	huang3",
		"炽", "	chi4",
		"炼", "	lian4",
		"炻", "	shi2",
		"為", "	wei4",
		"点", "	dian3",
		"炷", "	zhu4",
		"烄", "	jiao3",
		"炶", "	han1",
		"炵", "	tong1",
		"炴", "	yang3",
		"炳", "	bing3",
		"炲", "	tai2",
		"炱", "	tai2",
		"炰", "	pao2",
		"炯", "	jiong3",
		"炮", "	pao4",
		"炭", "	tan4",
		"烃", "	ting1",
		"烅", "	xu4",
		"炫", "	xuan4",
		"烒", "	shi4",
		"烜", "	xuan3",
		"烛", "	zhu2",
		"烚", "	xia2",
		"烙", "	lao4",
		"烘", "	hong1",
		"烗", "	kai4",
		"烖", "	zai1",
		"烕", "	mie4",
		"烔", "	tong2",
		"烓", "	wei1",
		"烑", "	yao2",
		"烆", "	heng2",
		"烐", "	zhou1",
		"烏", "	wu1",
		"烎", "	yin2",
		"烍", "	xian3",
		"烌", "	xiu1",
		"烋", "	xiu1",
		"烊", "	yang2",
		"烉", "	huan4",
		"烈", "	lie4",
		"烇", "	quan3",
		"炬", "	ju4",
		"炪", "	zhuo1",
		"烞", "	po4",
		"炄", "	niu3",
		"炎", "	yan2",
		"炍", "	pan4",
		"炌", "	kai4",
		"炋", "	pi1",
		"炊", "	chui1",
		"炉", "	lu2",
		"炈", "	yi4",
		"炇", "	po4",
		"炆", "	wen2",
		"炅", "	jiong3",
		"炃", "	fen2",
		"炐", "	pang4",
		"炂", "	zhong1",
		"炁", "	qi4",
		"炀", "	yang2",
		"灿", "	can4",
		"灾", "	zai1",
		"災", "	zai1",
		"灼", "	zhuo2",
		"灻", "	chi4",
		"灺", "	xie4",
		"灹", "	zha4",
		"炏", "	kai4",
		"炑", "	mu4",
		"炩", "	ling4",
		"炞", "	bian",
		"炨", "	duo4",
		"炧", "	xie4",
		"炦", "	ba2",
		"炥", "	fu2",
		"炤", "	zhao4",
		"炣", "	ke3",
		"炢", "	zhu2",
		"炡", "	zheng1",
		"炠", "	xia2",
		"炟", "	da2",
		"炝", "	qiang4",
		"炒", "	chao3",
		"炜", "	wei3",
		"炛", "	guang1",
		"炚", "	guang1",
		"炙", "	zhi4",
		"炘", "	xin1",
		"炗", "	guang1",
		"炖", "	dun4",
		"炕", "	kang4",
		"炔", "	gui4",
		"炓", "	liao4",
		"烝", "	zheng1",
		"烟", "	yan1",
		"煇", "	hui1",
		"焢", "	hong1",
		"焬", "	xi1",
		"焫", "	ruo4",
		"焪", "	qiong2",
		"焩", "	ping2",
		"焨", "	feng4",
		"焧", "	cong1",
		"焦", "	jiao1",
		"焥", "	wo4",
		"焤", "	fu3",
		"焣", "	chao3",
		"無", "	wu2",
		"焮", "	xin4",
		"焠", "	cui4",
		"焟", "	xi1",
		"焞", "	tun1",
		"焝", "	hun4",
		"焜", "	kun1",
		"焛", "	lin4",
		"焚", "	fen2",
		"焙", "	bei4",
		"焘", "	dao4",
		"焗", "	ju2",
		"焭", "	qiong2",
		"焯", "	chao1",
		"焕", "	huan4",
		"焼", "	shao1",
		"煆", "	xia1",
		"煅", "	duan4",
		"煄", "	zhong3",
		"煃", "	kui3",
		"煂", "	he4",
		"煁", "	chen2",
		"煀", "	wei",
		"焿", "	geng1",
		"焾", "	nian3",
		"焽", "	xiong3",
		"焻", "	chang4",
		"焰", "	yan4",
		"焺", "	sheng1",
		"焹", "	wang",
		"焸", "	xiong4",
		"焷", "	pi2",
		"然", "	ran2",
		"焵", "	gang4",
		"焴", "	yu4",
		"焳", "	jue2",
		"焲", "	yi4",
		"焱", "	yan4",
		"焖", "	men4",
		"焔", "	yan4",
		"烠", "	hui2",
		"热", "	re4",
		"烷", "	wan2",
		"烶", "	ting3",
		"烵", "	zhuo2",
		"烴", "	ting1",
		"烳", "	pu3",
		"烲", "	xie4",
		"烱", "	jiong3",
		"烰", "	fu2",
		"烯", "	xi1",
		"烮", "	lie",
		"烬", "	jin4",
		"烹", "	peng1",
		"烫", "	tang4",
		"烩", "	hui4",
		"烨", "	ye4",
		"烧", "	shao1",
		"烦", "	fan2",
		"烥", "	chen",
		"烤", "	kao3",
		"烣", "	hui1",
		"烢", "	che4",
		"烡", "	guang1",
		"烸", "	hai3",
		"烺", "	lang3",
		"焓", "	han2",
		"焈", "	xi1",
		"焒", "	lü",
		"焑", "	yan1",
		"焐", "	wu4",
		"焏", "	ji2",
		"焎", "	xie4",
		"焍", "	di4",
		"焌", "	jun4",
		"焋", "	zhuang4",
		"焊", "	han4",
		"焉", "	yan1",
		"焇", "	xiao1",
		"烻", "	yan4",
		"焆", "	juan1",
		"焅", "	ku4",
		"焄", "	xun1",
		"焃", "	he4",
		"焂", "	shu1",
		"焁", "	xi1",
		"焀", "	hu2",
		"烿", "	rong2",
		"烾", "	chi4",
		"烽", "	feng1",
		"烼", "	xu4",
		"滘", "	jiao4",
		"滖", "	sui1",
		"爘", "	can",
		"沧", "	cang1",
		"沱", "	tuo2",
		"沰", "	tuo1",
		"沯", "	zan3",
		"沮", "	ju3",
		"沭", "	shu4",
		"沬", "	mei4",
		"沫", "	mo4",
		"沪", "	hu4",
		"沩", "	wei2",
		"沨", "	feng1",
		"沦", "	lun2",
		"河", "	he2",
		"沥", "	li4",
		"沤", "	ou1",
		"沣", "	feng1",
		"沢", "	ze2",
		"没", "	mei2",
		"沠", "	liu2",
		"沟", "	gou1",
		"沞", "	za1",
		"沝", "	zhui3",
		"沜", "	pan4",
		"沲", "	tuo2",
		"沴", "	li4",
		"沚", "	zhi3",
		"況", "	kuang4",
		"泋", "	hui4",
		"泊", "	po1",
		"泉", "	quan2",
		"泈", "	zhong1",
		"泇", "	jia1",
		"泆", "	yi4",
		"泅", "	qiu2",
		"泄", "	xie4",
		"泃", "	ju1",
		"泂", "	jiong3",
		"泀", "	si1",
		"沵", "	mi3",
		"沿", "	yan2",
		"沾", "	zhan1",
		"沽", "	gu1",
		"沼", "	zhao3",
		"治", "	zhi4",
		"沺", "	tian2",
		"油", "	you2",
		"沸", "	fei4",
		"沷", "	fa1",
		"沶", "	yi2",
		"沛", "	pei4",
		"沙", "	sha1",
		"泍", "	ben1",
		"汳", "	bian4",
		"汽", "	qi4",
		"汼", "	niu2",
		"汻", "	hu3",
		"決", "	jue2",
		"汹", "	xiong1",
		"汸", "	fang1",
		"汷", "	zhong1",
		"汶", "	wen4",
		"汵", "	gan4",
		"汴", "	bian4",
		"汲", "	ji2",
		"汿", "	xu4",
		"汱", "	quan3",
		"汰", "	tai4",
		"汯", "	hong2",
		"汮", "	jun1",
		"汭", "	rui4",
		"汬", "	jing3",
		"汫", "	jing3",
		"汪", "	wang1",
		"汩", "	gu3",
		"汨", "	mi4",
		"汾", "	fen2",
		"沀", "	xu4",
		"沘", "	bi3",
		"沍", "	hu4",
		"沗", "	pang1",
		"沖", "	chong1",
		"沕", "	mi4",
		"沔", "	mian3",
		"沓", "	da2",
		"沒", "	mei2",
		"沑", "	nv4",
		"沐", "	mu4",
		"沏", "	qi1",
		"沎", "	huo4",
		"沌", "	dun4",
		"沁", "	qin4",
		"沋", "	you2",
		"沊", "	dan4",
		"沉", "	chen2",
		"沈", "	shen3",
		"沇", "	yan3",
		"沆", "	hang4",
		"沅", "	yuan2",
		"沄", "	yun2",
		"沃", "	wo4",
		"沂", "	yi2",
		"泌", "	mi4",
		"泎", "	ze2",
		"汦", "	zhi3",
		"洏", "	er2",
		"洙", "	zhu1",
		"洘", "	kao3",
		"洗", "	xi3",
		"洖", "	wu2",
		"洕", "	yin4",
		"洔", "	zhi3",
		"洓", "	se4",
		"洒", "	sa3",
		"洑", "	fu2",
		"洐", "	xing2",
		"洎", "	ji4",
		"洛", "	luo4",
		"洍", "	si4",
		"洌", "	lie4",
		"洋", "	yang2",
		"洊", "	jian4",
		"洉", "	hou4",
		"洈", "	wei2",
		"洇", "	yin1",
		"洆", "	cheng2",
		"洅", "	zai4",
		"洄", "	hui2",
		"洚", "	jiang4",
		"洜", "	luo4",
		"洂", "	yi4",
		"洩", "	xie4",
		"洳", "	ru4",
		"洲", "	zhou1",
		"洱", "	er3",
		"洰", "	ju4",
		"洯", "	qie4",
		"洮", "	tao2",
		"洭", "	kuang1",
		"洬", "	su4",
		"洫", "	xu4",
		"洪", "	hong2",
		"洨", "	xiao2",
		"洝", "	an4",
		"洧", "	wei3",
		"洦", "	po4",
		"津", "	jin1",
		"洤", "	quan2",
		"洣", "	mi3",
		"洢", "	yi1",
		"洡", "	lei4",
		"洠", "	mou2",
		"洟", "	ti4",
		"洞", "	dong4",
		"洃", "	hui1",
		"洁", "	jie2",
		"泏", "	zhu2",
		"泛", "	fan4",
		"泥", "	ni2",
		"泤", "	si4",
		"泣", "	qi4",
		"波", "	bo1",
		"泡", "	pao4",
		"泠", "	ling2",
		"泟", "	cheng1",
		"泞", "	ning4",
		"泝", "	su4",
		"泜", "	zhi1",
		"泚", "	ci3",
		"泧", "	sa4",
		"泙", "	ping2",
		"泘", "	hu1",
		"泗", "	si4",
		"泖", "	mao3",
		"法", "	fa3",
		"泔", "	gan1",
		"泓", "	hong2",
		"泒", "	gu1",
		"泑", "	you1",
		"泐", "	le4",
		"泦", "	ju2",
		"注", "	zhu4",
		"洀", "	pan2",
		"泵", "	beng4",
		"泿", "	yin2",
		"泾", "	jing1",
		"泽", "	ze2",
		"泼", "	po1",
		"泻", "	xie4",
		"泺", "	luo4",
		"泹", "	dan4",
		"泸", "	lu2",
		"泷", "	long2",
		"泶", "	xue2",
		"泴", "	guan4",
		"泩", "	sheng1",
		"泳", "	yong3",
		"泲", "	ji3",
		"泱", "	yang1",
		"泰", "	tai4",
		"泯", "	min3",
		"泮", "	pan4",
		"泭", "	fu2",
		"泬", "	jue2",
		"泫", "	xuan4",
		"泪", "	lei4",
		"汧", "	qian1",
		"汥", "	zhi1",
		"洵", "	xun2",
		"毗", "	pi2",
		"毡", "	zhan1",
		"毠", "	jia1",
		"毟", "	lie",
		"毞", "	pi2",
		"毝", "	cai3",
		"毜", "	hao2",
		"毛", "	mao2",
		"毚", "	chan2",
		"毙", "	bi4",
		"毘", "	pi2",
		"毖", "	bi4",
		"毣", "	mu4",
		"毕", "	bi4",
		"比", "	bi3",
		"毓", "	yu4",
		"毒", "	du2",
		"毑", "	jie3",
		"毐", "	ai3",
		"每", "	mei3",
		"毎", "	mei3",
		"母", "	mu3",
		"毌", "	guan4",
		"毢", "	sai1",
		"毤", "	tuo4",
		"毊", "	xiao1",
		"毱", "	ju2",
		"毻", "	tuo4",
		"毺", "	yu1",
		"毹", "	shu1",
		"毸", "	sai1",
		"毷", "	mao4",
		"毶", "	san",
		"毵", "	san1",
		"毴", "	bi1",
		"毳", "	cui4",
		"毲", "	duo1",
		"毰", "	pei2",
		"毥", "	xun2",
		"毯", "	tan3",
		"毮", "	sha1",
		"毭", "	dou4",
		"毬", "	qiu2",
		"毫", "	hao2",
		"毪", "	mu2",
		"毩", "	ju2",
		"毨", "	xian3",
		"毧", "	rong2",
		"毦", "	er3",
		"毋", "	wu2",
		"毉", "	yi1",
		"毽", "	jian4",
		"殣", "	jin4",
		"殭", "	jiang1",
		"殬", "	du4",
		"殫", "	dan1",
		"殪", "	yi4",
		"殩", "	cuan4",
		"殨", "	hui4",
		"殧", "	jiu4",
		"殦", "	diao1",
		"殥", "	yin2",
		"殤", "	shang1",
		"殢", "	ti4",
		"殯", "	bin4",
		"殡", "	bin4",
		"殠", "	chou4",
		"殟", "	wen1",
		"殞", "	yun3",
		"殝", "	zhen1",
		"殜", "	die2",
		"殛", "	ji2",
		"殚", "	dan1",
		"殙", "	hun1",
		"殘", "	can2",
		"殮", "	lian4",
		"殰", "	du2",
		"毈", "	duan4",
		"殽", "	xiao2",
		"毇", "	hui3",
		"毆", "	ou1",
		"毅", "	yi4",
		"毄", "	ji1",
		"毃", "	qiao1",
		"毂", "	gu3",
		"毁", "	hui3",
		"毀", "	hui3",
		"殿", "	dian4",
		"殾", "	xun4",
		"殼", "	ke2",
		"殱", "	jian",
		"殻", "	qiao4",
		"殺", "	sha1",
		"殹", "	yi4",
		"殸", "	qing4",
		"殷", "	yin1",
		"殶", "	zhu4",
		"段", "	duan4",
		"殴", "	ou1",
		"殳", "	shu1",
		"殲", "	jian1",
		"毼", "	he2",
		"毾", "	ta4",
		"汤", "	tang1",
		"氿", "	gui3",
		"汉", "	han4",
		"汈", "	diao1",
		"汇", "	hui4",
		"汆", "	cuan1",
		"汅", "	mian3",
		"汄", "	ze4",
		"汃", "	bin1",
		"求", "	qiu2",
		"汁", "	zhi1",
		"汀", "	ting1",
		"氾", "	fan4",
		"汋", "	zhuo2",
		"氽", "	tun3",
		"氼", "	ni4",
		"氻", "	le4",
		"氺", "	shui",
		"氹", "	dang4",
		"永", "	yong3",
		"氷", "	bing1",
		"氶", "	zheng3",
		"氵", "	shui",
		"水", "	shui3",
		"汊", "	cha4",
		"汌", "	chuan4",
		"氲", "	yun1",
		"汙", "	wu1",
		"汣", "	jiu",
		"汢", "	tu",
		"污", "	wu1",
		"池", "	chi2",
		"江", "	jiang1",
		"汞", "	gong3",
		"汝", "	ru3",
		"汜", "	si4",
		"汛", "	xun4",
		"汚", "	wu1",
		"汘", "	qian1",
		"汍", "	wan2",
		"汗", "	han4",
		"汖", "	pin4",
		"汕", "	shan4",
		"汔", "	qi4",
		"汓", "	qiu2",
		"汒", "	mang2",
		"汑", "	tuo1",
		"汐", "	xi1",
		"汏", "	da4",
		"汎", "	fan4",
		"氳", "	yun1",
		"氱", "	yang3",
		"毿", "	san1",
		"氋", "	meng2",
		"氕", "	pie1",
		"气", "	qi4",
		"氓", "	mang2",
		"氒", "	jue2",
		"民", "	min2",
		"氐", "	di1",
		"氏", "	shi4",
		"氎", "	die2",
		"氍", "	qu2",
		"氌", "	lu3",
		"氊", "	zhan1",
		"気", "	qi4",
		"氉", "	sao4",
		"氈", "	zhan1",
		"氇", "	lu",
		"氆", "	pu3",
		"氅", "	chang3",
		"氄", "	rong3",
		"氃", "	tong2",
		"氂", "	mao2",
		"氁", "	mu2",
		"氀", "	lv2",
		"氖", "	nai3",
		"氘", "	dao1",
		"氰", "	qing2",
		"氥", "	xi1",
		"氯", "	lv4",
		"氮", "	dan4",
		"氭", "	dong1",
		"氬", "	ya4",
		"氫", "	qing1",
		"氪", "	ke4",
		"氩", "	ya4",
		"氨", "	an1",
		"氧", "	yang3",
		"氦", "	hai4",
		"氤", "	yin1",
		"氙", "	xian1",
		"氣", "	qi4",
		"氢", "	qing1",
		"氡", "	dong1",
		"氠", "	shen1",
		"氟", "	fu2",
		"氞", "	bin",
		"氝", "	nei4",
		"氜", "	yang2",
		"氛", "	fen1",
		"氚", "	chuan1",
		"洴", "	ping2",
		"洶", "	xiong1",
		"滕", "	teng2",
		"湈", "	mei2",
		"湒", "	ji2",
		"湑", "	xu1",
		"湐", "	mo4",
		"湏", "	hui4",
		"湎", "	mian3",
		"湍", "	tuan1",
		"湌", "	can1",
		"湋", "	wei2",
		"湊", "	cou4",
		"湉", "	tian2",
		"湇", "	qi4",
		"湔", "	jian1",
		"湆", "	qi4",
		"湅", "	lian4",
		"湄", "	mei2",
		"湃", "	pai4",
		"湂", "	e4",
		"湁", "	chi4",
		"湀", "	gui3",
		"渿", "	nai4",
		"渾", "	hun2",
		"渽", "	zai1",
		"湓", "	pen2",
		"湕", "	jian3",
		"渻", "	sheng3",
		"湢", "	bi4",
		"湬", "	jiao3",
		"湫", "	jiao3",
		"湪", "	tuan4",
		"湩", "	dong4",
		"湨", "	ju2",
		"湧", "	yong3",
		"湦", "	sheng1",
		"湥", "	tu1",
		"湤", "	shi1",
		"湣", "	min3",
		"湡", "	yu2",
		"湖", "	hu2",
		"湠", "	tan4",
		"湟", "	huang2",
		"湞", "	cheng1",
		"湝", "	jie1",
		"湜", "	shi2",
		"湛", "	zhan4",
		"湚", "	yin4",
		"湙", "	yi4",
		"湘", "	xiang1",
		"湗", "	feng4",
		"渼", "	mei3",
		"渺", "	miao3",
		"湮", "	yan1",
		"渔", "	yu2",
		"渞", "	qiu2",
		"渝", "	yu2",
		"渜", "	nuan3",
		"減", "	jian3",
		"渚", "	zhu3",
		"渙", "	huan4",
		"渘", "	rou2",
		"渗", "	shen4",
		"渖", "	shen3",
		"渕", "	yuan1",
		"渓", "	xi",
		"渠", "	qu2",
		"渒", "	pi4",
		"渑", "	mian3",
		"渐", "	jian4",
		"渏", "	qi",
		"渎", "	du2",
		"渍", "	zi4",
		"渌", "	lu4",
		"渋", "	se",
		"渊", "	yuan1",
		"渉", "	she4",
		"渟", "	ting2",
		"渡", "	du4",
		"渹", "	hong1",
		"渮", "	he2",
		"游", "	you2",
		"渷", "	yan3",
		"渶", "	ying1",
		"渵", "	mao2",
		"渴", "	ke3",
		"渳", "	mi3",
		"渲", "	xuan4",
		"渱", "	hong2",
		"渰", "	yan3",
		"港", "	gang3",
		"渭", "	wei4",
		"渢", "	fan2",
		"測", "	ce4",
		"渫", "	xie4",
		"渪", "	ru2",
		"温", "	wen1",
		"渨", "	wei1",
		"渧", "	di4",
		"渦", "	wo1",
		"渥", "	wo4",
		"渤", "	bo2",
		"渣", "	zha1",
		"湭", "	qiu2",
		"湯", "	tang1",
		"渇", "	ke3",
		"溰", "	ai2",
		"溺", "	ni4",
		"溹", "	suo4",
		"溸", "	su4",
		"溷", "	hun4",
		"溶", "	rong2",
		"溵", "	yin1",
		"溴", "	xiu4",
		"溳", "	yun2",
		"溲", "	sou1",
		"溱", "	qin2",
		"溯", "	su4",
		"溼", "	shi1",
		"溮", "	shi1",
		"溭", "	ze2",
		"溬", "	qiang1",
		"溫", "	wen1",
		"溪", "	xi1",
		"溩", "	wu4",
		"溨", "	cai2",
		"溧", "	li4",
		"溦", "	wei1",
		"溥", "	pu3",
		"溻", "	ta1",
		"溽", "	ru4",
		"溣", "	lun4",
		"滊", "	xi4",
		"滔", "	tao1",
		"滓", "	zi3",
		"滒", "	ge1",
		"滑", "	hua2",
		"滐", "	jie2",
		"滏", "	fu3",
		"滎", "	xing2",
		"滍", "	zhi4",
		"滌", "	di2",
		"滋", "	zi1",
		"滉", "	huang4",
		"溾", "	ai1",
		"滈", "	hao4",
		"滇", "	dian1",
		"滆", "	ge2",
		"滅", "	mie4",
		"滄", "	cang1",
		"滃", "	weng1",
		"滂", "	pang1",
		"滁", "	chu2",
		"滀", "	chu4",
		"溿", "	pan4",
		"溤", "	ma3",
		"溢", "	yi4",
		"湰", "	long2",
		"湼", "	nie4",
		"溆", "	xu4",
		"溅", "	jian4",
		"溄", "	feng",
		"溃", "	kui4",
		"溂", "	la",
		"溁", "	ying2",
		"満", "	man3",
		"湿", "	shi1",
		"湾", "	wan1",
		"湽", "	zi1",
		"湻", "	chun2",
		"溈", "	wei2",
		"湺", "	yan2",
		"湹", "	chan2",
		"湸", "	liang4",
		"湷", "	zhuang1",
		"湶", "	quan2",
		"湵", "	you3",
		"湴", "	ban4",
		"湳", "	nan3",
		"湲", "	yuan2",
		"湱", "	huo4",
		"溇", "	lou2",
		"溉", "	gai4",
		"溡", "	shi2",
		"準", "	zhun3",
		"溠", "	zha4",
		"溟", "	ming2",
		"溞", "	sao1",
		"溝", "	gou1",
		"溜", "	liu1",
		"溛", "	wa1",
		"溚", "	ta3",
		"溙", "	tai4",
		"溘", "	ke4",
		"溗", "	cheng2",
		"溕", "	meng4",
		"溊", "	xia",
		"溔", "	yao3",
		"溓", "	lian2",
		"溒", "	yuan2",
		"溑", "	suo3",
		"源", "	yuan2",
		"溏", "	tang2",
		"溎", "	yan4",
		"溍", "	jin4",
		"溌", "	po1",
		"溋", "	ying2",
		"済", "	ji4",
		"渆", "	yuan1",
		"洷", "	zhi4",
		"海", "	hai3",
		"涁", "	shen4",
		"涀", "	xian4",
		"浿", "	pei4",
		"浾", "	cheng1",
		"浽", "	sui1",
		"浼", "	mei3",
		"浻", "	jiong3",
		"浺", "	chong1",
		"浹", "	jia1",
		"浸", "	jin4",
		"浶", "	lao2",
		"涃", "	kun4",
		"浵", "	tong2",
		"浴", "	yu4",
		"浳", "	yi4",
		"浲", "	feng2",
		"浱", "	chun2",
		"浰", "	lian4",
		"浯", "	wu2",
		"浮", "	fu2",
		"浭", "	geng1",
		"浬", "	li3",
		"涂", "	tu2",
		"涄", "	ping1",
		"浪", "	lang4",
		"涑", "	su4",
		"涛", "	tao1",
		"涚", "	shui4",
		"涙", "	lei4",
		"涘", "	si4",
		"涗", "	shui4",
		"涖", "	li4",
		"涕", "	ti4",
		"涔", "	cen2",
		"涓", "	juan1",
		"涒", "	tun1",
		"涐", "	e2",
		"涅", "	nie4",
		"涏", "	ting3",
		"涎", "	xian2",
		"涍", "	xiao4",
		"涌", "	yong3",
		"涋", "	tu1",
		"涊", "	nian3",
		"涉", "	she4",
		"消", "	xiao1",
		"涇", "	jing1",
		"涆", "	han4",
		"浫", "	han3",
		"浩", "	hao4",
		"涝", "	lao4",
		"浃", "	jia1",
		"浍", "	hui4",
		"浌", "	fa2",
		"测", "	ce4",
		"浊", "	zhuo2",
		"浉", "	shi1",
		"浈", "	zhen1",
		"浇", "	jiao1",
		"浆", "	jiang1",
		"浅", "	qian3",
		"浄", "	jing4",
		"浂", "	yi4",
		"浏", "	liu2",
		"流", "	liu2",
		"浀", "	qu1",
		"洿", "	wu1",
		"派", "	pai4",
		"洽", "	qia4",
		"洼", "	wa1",
		"活", "	huo2",
		"洺", "	ming2",
		"洹", "	huan2",
		"洸", "	guang1",
		"济", "	ji4",
		"浐", "	chan3",
		"浨", "	lan3",
		"浝", "	mang2",
		"浧", "	ying3",
		"浦", "	pu3",
		"浥", "	yi4",
		"浤", "	hong2",
		"浣", "	huan4",
		"浢", "	dou4",
		"浡", "	bo2",
		"浠", "	xi1",
		"浟", "	you2",
		"浞", "	zhuo2",
		"浜", "	bang1",
		"浑", "	hun2",
		"浛", "	han2",
		"浚", "	jun4",
		"浙", "	zhe4",
		"浘", "	wei3",
		"浗", "	qiu2",
		"浖", "	lie4",
		"浕", "	jin4",
		"浔", "	xun2",
		"浓", "	nong2",
		"浒", "	hu3",
		"涜", "	du2",
		"涞", "	lai2",
		"清", "	qing1",
		"淠", "	pi4",
		"淪", "	lun2",
		"淩", "	ling2",
		"淨", "	jing4",
		"淧", "	mi4",
		"淦", "	gan4",
		"淥", "	lu4",
		"淤", "	yu1",
		"淣", "	ni2",
		"淢", "	yu4",
		"淡", "	dan4",
		"淟", "	tian3",
		"淬", "	cui4",
		"淞", "	song1",
		"淝", "	fei2",
		"淜", "	ping2",
		"淛", "	zhe4",
		"淚", "	lei4",
		"淙", "	cong2",
		"淘", "	tao2",
		"淗", "	ju2",
		"淖", "	nao4",
		"淕", "	lu4",
		"淫", "	yin2",
		"淭", "	qu2",
		"淓", "	fang1",
		"淺", "	qian3",
		"渄", "	fei1",
		"渃", "	ruo4",
		"渂", "	wen4",
		"渁", "	yuan1",
		"渀", "	ben4",
		"淿", "	mi4",
		"淾", "	yin3",
		"淽", "	zhi3",
		"淼", "	miao3",
		"添", "	tian1",
		"淹", "	yan1",
		"淮", "	huai2",
		"淸", "	qing1",
		"混", "	hun4",
		"淶", "	lai2",
		"淵", "	yuan1",
		"淴", "	hu1",
		"淳", "	chun2",
		"淲", "	biao1",
		"深", "	shen1",
		"淰", "	nian3",
		"淯", "	yu4",
		"淔", "	zhi2",
		"淒", "	qi1",
		"涟", "	lian2",
		"涫", "	guan4",
		"涵", "	han2",
		"涴", "	wo4",
		"涳", "	kong1",
		"液", "	ye4",
		"涱", "	zhang4",
		"涰", "	chuo4",
		"涯", "	ya2",
		"涮", "	shuan4",
		"涭", "	shou4",
		"涬", "	xing4",
		"涪", "	fu2",
		"涷", "	dong1",
		"涩", "	se4",
		"涨", "	zhang3",
		"涧", "	jian4",
		"润", "	run4",
		"涥", "	heng",
		"涤", "	di2",
		"涣", "	huan4",
		"涢", "	yun2",
		"涡", "	wo1",
		"涠", "	wei2",
		"涶", "	tuo1",
		"涸", "	he2",
		"淑", "	shu1",
		"淆", "	xiao2",
		"淐", "	chang1",
		"淏", "	hao4",
		"淎", "	peng3",
		"淍", "	zhou1",
		"淌", "	tang3",
		"淋", "	lin2",
		"淊", "	yan1",
		"淉", "	guo3",
		"淈", "	gu3",
		"淇", "	qi2",
		"淅", "	xi1",
		"涹", "	wo1",
		"淄", "	zi1",
		"淃", "	juan4",
		"淂", "	de2",
		"淁", "	qie4",
		"淀", "	dian4",
		"涿", "	zhuo1",
		"涾", "	ta4",
		"涽", "	hun1",
		"涼", "	liang2",
		"涻", "	she4",
		"涺", "	ju1",
		"爗", "	ye4",
		"爙", "	rang3",
		"碞", "	yan2",
		"癰", "	yong1",
		"発", "	fa1",
		"癹", "	ba2",
		"癸", "	gui3",
		"癷", "	bo1",
		"癶", "	bo1",
		"癵", "	luan2",
		"癴", "	luan2",
		"癳", "	luo3",
		"癲", "	dian1",
		"癱", "	tan1",
		"癯", "	qu2",
		"發", "	fa1",
		"癮", "	yin3",
		"癭", "	ying3",
		"癬", "	xuan3",
		"癫", "	dian1",
		"癪", "	ji1",
		"癩", "	lai4",
		"癨", "	huo4",
		"癧", "	li4",
		"癦", "	me",
		"癥", "	zheng1",
		"登", "	deng1",
		"白", "	bai2",
		"癣", "	xuan3",
		"皊", "	ling2",
		"皔", "	han4",
		"皓", "	hao4",
		"皒", "	e2",
		"皑", "	ai2",
		"皐", "	gao1",
		"皏", "	peng3",
		"皎", "	jiao3",
		"皍", "	ji2",
		"皌", "	mo4",
		"皋", "	gao1",
		"皉", "	ci3",
		"百", "	bai3",
		"皈", "	gui1",
		"皇", "	huang2",
		"皆", "	jie1",
		"皅", "	pa1",
		"的", "	de",
		"皃", "	mao4",
		"皂", "	zao4",
		"皁", "	zao4",
		"皀", "	ji2",
		"癿", "	qie2",
		"癤", "	jie1",
		"癢", "	yang3",
		"皖", "	wan3",
		"瘼", "	mo4",
		"癆", "	lao2",
		"癅", "	liu2",
		"癄", "	qiao2",
		"癃", "	long2",
		"療", "	liao2",
		"癁", "	fu2",
		"癀", "	huang2",
		"瘿", "	ying3",
		"瘾", "	yin3",
		"瘽", "	qin2",
		"瘻", "	lou4",
		"癈", "	fei4",
		"瘺", "	lou4",
		"瘹", "	diao4",
		"瘸", "	que2",
		"瘷", "	se4",
		"瘶", "	sou4",
		"瘵", "	zhai4",
		"瘴", "	zhang4",
		"瘳", "	chou1",
		"瘲", "	zong4",
		"瘱", "	yi4",
		"癇", "	xian2",
		"癉", "	dan1",
		"癡", "	chi1",
		"癖", "	pi3",
		"癠", "	ji4",
		"癟", "	bie3",
		"癞", "	lai4",
		"癝", "	lin3",
		"癜", "	dian4",
		"癛", "	lin3",
		"癚", "	dan4",
		"癙", "	shu3",
		"癘", "	li4",
		"癗", "	lei3",
		"癕", "	yong1",
		"癊", "	yin4",
		"癔", "	yi4",
		"癓", "	wei2",
		"癒", "	yu4",
		"癑", "	nong4",
		"癐", "	gui4",
		"癏", "	guan1",
		"癎", "	xian2",
		"癍", "	ban1",
		"癌", "	ai2",
		"癋", "	he4",
		"皕", "	bi4",
		"皗", "	chou2",
		"瘯", "	cu4",
		"盘", "	pan2",
		"盢", "	xu4",
		"盡", "	jin3",
		"盠", "	li2",
		"盟", "	meng2",
		"盞", "	zhan3",
		"盝", "	lu4",
		"盜", "	dao4",
		"盛", "	sheng4",
		"盚", "	qiu2",
		"盙", "	fu3",
		"盗", "	dao4",
		"盤", "	pan2",
		"盖", "	gai4",
		"盕", "	fan4",
		"盔", "	kui1",
		"盓", "	yu1",
		"盒", "	he2",
		"监", "	jian1",
		"盐", "	yan2",
		"盏", "	zhan3",
		"盎", "	ang4",
		"盍", "	he2",
		"監", "	jian1",
		"盥", "	guan4",
		"盋", "	bo1",
		"盲", "	mang2",
		"盼", "	pan4",
		"盻", "	xi4",
		"盺", "	xin1",
		"盹", "	dun3",
		"相", "	xiang1",
		"盷", "	tian2",
		"盶", "	yuan3",
		"盵", "	qi4",
		"直", "	zhi2",
		"盳", "	wang4",
		"盱", "	xu1",
		"盦", "	an1",
		"盰", "	gan4",
		"盯", "	ding1",
		"目", "	mu4",
		"盭", "	li4",
		"盬", "	gu3",
		"盫", "	an1",
		"盪", "	dang4",
		"盩", "	zhou1",
		"盨", "	xu3",
		"盧", "	lu2",
		"盌", "	wan3",
		"益", "	yi4",
		"皘", "	qian4",
		"皤", "	po2",
		"皮", "	pi2",
		"皭", "	jiao4",
		"皬", "	he2",
		"皫", "	piao3",
		"皪", "	li4",
		"皩", "	huang4",
		"皨", "	xing1",
		"皧", "	ai4",
		"皦", "	jiao3",
		"皥", "	hao4",
		"皣", "	ye4",
		"皰", "	pao4",
		"皢", "	xiao3",
		"皡", "	hao4",
		"皠", "	cui3",
		"皟", "	ze2",
		"皞", "	hao4",
		"皝", "	huang4",
		"皜", "	hao4",
		"皛", "	xiao3",
		"䴰", "	shu2",
		"皙", "	xi1",
		"皯", "	gan3",
		"皱", "	zhou4",
		"盉", "	he2",
		"皾", "	du2",
		"盈", "	ying2",
		"盇", "	he2",
		"盆", "	pen2",
		"盅", "	zhong1",
		"盄", "	zhao1",
		"盃", "	bei1",
		"盂", "	yu2",
		"盁", "	ying2",
		"盀", "	qi3",
		"皿", "	min3",
		"皽", "	zhao1",
		"皲", "	jun1",
		"皼", "	gu3",
		"皻", "	zha1",
		"皺", "	zhou4",
		"皹", "	jun1",
		"皸", "	jun1",
		"皷", "	gu3",
		"皶", "	zha1",
		"皵", "	que4",
		"皴", "	cun1",
		"皳", "	qiu2",
		"瘰", "	luo3",
		"瘮", "	shen4",
		"盾", "	dun4",
		"疠", "	li4",
		"疪", "	bi4",
		"疩", "	cui4",
		"疨", "	xia1",
		"疧", "	qi2",
		"疦", "	jue2",
		"疥", "	jie4",
		"疤", "	ba1",
		"疣", "	you2",
		"疢", "	chen4",
		"疡", "	yang2",
		"疟", "	nue4",
		"疬", "	li4",
		"疞", "	xu1",
		"疝", "	shan4",
		"疜", "	xia4",
		"疛", "	zhou3",
		"疚", "	jiu4",
		"疙", "	ge1",
		"疘", "	gang1",
		"疗", "	liao2",
		"疖", "	jie1",
		"疕", "	bi3",
		"疫", "	yi4",
		"疭", "	zong4",
		"疓", "	nai3",
		"疺", "	fa2",
		"痄", "	zha4",
		"痃", "	xuan2",
		"痂", "	jia1",
		"痁", "	shan1",
		"痀", "	ju1",
		"疿", "	fei4",
		"疾", "	ji2",
		"疽", "	ju1",
		"疼", "	teng2",
		"疻", "	zhi3",
		"疹", "	zhen3",
		"疮", "	chuang1",
		"疸", "	dan3",
		"疷", "	zhi1",
		"疶", "	xue1",
		"疵", "	ci1",
		"疴", "	ke1",
		"疳", "	gan1",
		"疲", "	pi2",
		"疱", "	pao4",
		"疰", "	zhu4",
		"疯", "	feng1",
		"疔", "	ding1",
		"疒", "	ne4",
		"痆", "	nie4",
		"畬", "	she1",
		"當", "	dang1",
		"畵", "	hua4",
		"畴", "	chou2",
		"畳", "	die2",
		"畲", "	she1",
		"畱", "	liu2",
		"異", "	yi4",
		"畯", "	jun4",
		"畮", "	mu3",
		"畭", "	yu2",
		"畫", "	hua4",
		"畸", "	ji1",
		"番", "	fan1",
		"畩", "	yi",
		"畨", "	pan1",
		"畧", "	lue4",
		"畦", "	qi2",
		"略", "	lue4",
		"畤", "	zhi4",
		"畣", "	da2",
		"畢", "	bi4",
		"畡", "	gai1",
		"畷", "	zhui4",
		"畹", "	wan3",
		"疑", "	yi2",
		"疆", "	jiang1",
		"疐", "	zhi4",
		"疏", "	shu1",
		"疎", "	shu1",
		"疍", "	dan4",
		"疌", "	jie2",
		"疋", "	pi3",
		"疊", "	die2",
		"疉", "	die2",
		"疈", "	pi4",
		"疇", "	chou2",
		"疅", "	jiang1",
		"畺", "	jiang1",
		"疄", "	lin4",
		"疃", "	tuan3",
		"疂", "	die",
		"疁", "	liu2",
		"疀", "	cha1",
		"畿", "	ji1",
		"畾", "	lei2",
		"畽", "	tun3",
		"畼", "	chang4",
		"畻", "	cheng2",
		"病", "	bing4",
		"症", "	zheng4",
		"瘭", "	biao1",
		"瘈", "	chi4",
		"瘒", "	wen2",
		"瘑", "	guo1",
		"瘐", "	yu3",
		"瘏", "	tu2",
		"瘎", "	chen2",
		"瘍", "	yang2",
		"瘌", "	la4",
		"瘋", "	feng1",
		"瘊", "	hou2",
		"瘉", "	yu4",
		"瘇", "	zhong3",
		"瘔", "	ku4",
		"瘆", "	shen4",
		"瘅", "	dan1",
		"瘄", "	cu4",
		"瘃", "	zhu2",
		"瘂", "	ya3",
		"瘁", "	cui4",
		"瘀", "	yu1",
		"痿", "	wei3",
		"痾", "	e1",
		"痽", "	dui1",
		"瘓", "	huan4",
		"瘕", "	jia3",
		"痻", "	min2",
		"瘢", "	ban1",
		"瘬", "	zhang4",
		"瘫", "	tan1",
		"瘪", "	bie3",
		"瘩", "	da",
		"瘨", "	dian1",
		"瘧", "	nue4",
		"瘦", "	shou4",
		"瘥", "	chai4",
		"瘤", "	liu2",
		"瘣", "	hui4",
		"瘡", "	chuang1",
		"瘖", "	yin1",
		"瘠", "	ji2",
		"瘟", "	wen1",
		"瘞", "	yi4",
		"瘝", "	guan1",
		"瘜", "	xi1",
		"瘛", "	chi4",
		"瘚", "	jue2",
		"瘙", "	sao4",
		"瘘", "	lou4",
		"瘗", "	yi4",
		"痼", "	gu4",
		"痺", "	bi4",
		"痈", "	yong1",
		"痔", "	zhi4",
		"痞", "	pi3",
		"痝", "	mang2",
		"痜", "	tu1",
		"痛", "	tong4",
		"痚", "	xiao1",
		"痙", "	jing4",
		"痘", "	dou4",
		"痗", "	mei4",
		"痖", "	ya3",
		"痕", "	hen2",
		"痓", "	chi4",
		"痠", "	suan1",
		"痒", "	yang3",
		"痑", "	tan1",
		"痐", "	hui2",
		"痏", "	wei3",
		"痎", "	jie1",
		"痍", "	yi2",
		"痌", "	tong1",
		"痋", "	teng2",
		"痊", "	quan2",
		"痉", "	jing4",
		"痟", "	xiao1",
		"痡", "	fu1",
		"痹", "	bi4",
		"痮", "	zhang4",
		"痸", "	chi4",
		"痷", "	an1",
		"痶", "	tian3",
		"痵", "	ji4",
		"痴", "	chi1",
		"痳", "	lin2",
		"痲", "	ma2",
		"痱", "	fei4",
		"痰", "	tan2",
		"痯", "	guan3",
		"痭", "	beng1",
		"痢", "	li4",
		"痬", "	yi4",
		"痫", "	xian2",
		"痪", "	huan4",
		"痩", "	shou4",
		"痨", "	lao2",
		"痧", "	sha1",
		"痦", "	wu4",
		"痥", "	duo2",
		"痤", "	cuo2",
		"痣", "	zhi4",
		"盽", "	feng1",
		"盿", "	min2",
		"畟", "	ce4",
		"砑", "	ya4",
		"砛", "	jin",
		"砚", "	yan4",
		"砙", "	pan1",
		"砘", "	dun4",
		"砗", "	che1",
		"砖", "	zhuan1",
		"砕", "	sui4",
		"研", "	yan2",
		"砓", "	zhe2",
		"砒", "	pi1",
		"砐", "	e4",
		"砝", "	fa2",
		"砏", "	bin1",
		"砎", "	jie4",
		"砍", "	kan3",
		"砌", "	qi4",
		"砋", "	zhi3",
		"砊", "	kang1",
		"砉", "	huo4",
		"砈", "	e3",
		"砇", "	min2",
		"砆", "	fu1",
		"砜", "	feng1",
		"砞", "	mo4",
		"砄", "	jue2",
		"砫", "	zhu4",
		"砵", "	bo1",
		"破", "	po4",
		"砳", "	le4",
		"砲", "	pao4",
		"砱", "	ling2",
		"砰", "	peng1",
		"砯", "	ping1",
		"砮", "	nu3",
		"砭", "	bian1",
		"砬", "	la2",
		"砪", "	mu3",
		"砟", "	zha3",
		"砩", "	fu2",
		"砨", "	e4",
		"砧", "	zhen1",
		"砦", "	zhai4",
		"砥", "	di3",
		"砤", "	tuo2",
		"砣", "	tuo2",
		"砢", "	ke1",
		"砡", "	yu4",
		"砠", "	ju1",
		"砅", "	li4",
		"砃", "	dan1",
		"砷", "	shen1",
		"矝", "	lin2",
		"矧", "	shen3",
		"矦", "	hou2",
		"知", "	zhi1",
		"矤", "	shen3",
		"矣", "	yi3",
		"矢", "	shi3",
		"矡", "	jue2",
		"矠", "	ze2",
		"矟", "	shuo4",
		"矞", "	yu4",
		"矜", "	jin1",
		"矩", "	ju3",
		"矛", "	mao2",
		"矚", "	zhu3",
		"矙", "	kan4",
		"矘", "	tang3",
		"矗", "	chu4",
		"矖", "	xi3",
		"矕", "	man3",
		"矔", "	guan4",
		"矓", "	long2",
		"矒", "	meng2",
		"矨", "	ying3",
		"矪", "	zhou1",
		"砂", "	sha1",
		"矷", "	zi3",
		"码", "	ma3",
		"砀", "	dang4",
		"矿", "	kuang4",
		"矾", "	fan2",
		"矽", "	xi4",
		"矼", "	gang1",
		"矻", "	ku1",
		"矺", "	zhe2",
		"矹", "	wu4",
		"矸", "	gan1",
		"矶", "	ji1",
		"矫", "	jiao3",
		"矵", "	qi4",
		"矴", "	ding4",
		"石", "	shi2",
		"矲", "	ba4",
		"矱", "	yue1",
		"矰", "	zeng1",
		"矯", "	jiao3",
		"矮", "	ai3",
		"短", "	duan3",
		"矬", "	cuo2",
		"砶", "	po4",
		"砸", "	za2",
		"矐", "	huo4",
		"硹", "	song1",
		"碃", "	qing4",
		"碂", "	zong4",
		"碁", "	qi2",
		"碀", "	cheng2",
		"硿", "	kong1",
		"硾", "	zhui4",
		"硽", "	yan1",
		"硼", "	peng2",
		"硻", "	keng1",
		"硺", "	zhuo2",
		"硸", "	nue4",
		"碅", "	jun1",
		"硷", "	jian3",
		"硶", "	chen3",
		"硵", "	lu3",
		"硴", "	hua",
		"硳", "	chi4",
		"硲", "	yu4",
		"硱", "	kun3",
		"硰", "	sha1",
		"硯", "	yan4",
		"确", "	que4",
		"碄", "	lin2",
		"碆", "	bo1",
		"硬", "	ying4",
		"碓", "	dui4",
		"碝", "	ruan3",
		"碜", "	chen3",
		"碛", "	qi4",
		"碚", "	bei4",
		"碙", "	nao2",
		"碘", "	dian3",
		"碗", "	wan3",
		"碖", "	lun3",
		"碕", "	qi2",
		"碔", "	wu3",
		"碒", "	yin2",
		"碇", "	ding4",
		"碑", "	bei1",
		"碐", "	leng2",
		"碏", "	que4",
		"碎", "	sui4",
		"碍", "	ai4",
		"碌", "	lu4",
		"碋", "	he4",
		"碊", "	jian1",
		"碉", "	diao1",
		"碈", "	min2",
		"硭", "	mang2",
		"硫", "	liu2",
		"砹", "	ai4",
		"硅", "	gui1",
		"硏", "	yan2",
		"硎", "	xing2",
		"硍", "	xian4",
		"硌", "	ge4",
		"硋", "	ai4",
		"硊", "	wei3",
		"硉", "	lu4",
		"硈", "	qia4",
		"硇", "	nao2",
		"硆", "	e4",
		"硄", "	kuang1",
		"硑", "	peng1",
		"硃", "	zhu1",
		"硂", "	quan2",
		"硁", "	keng1",
		"础", "	chu3",
		"砿", "	kuang",
		"砾", "	li4",
		"砽", "	yong",
		"砼", "	tong2",
		"砻", "	long2",
		"砺", "	li4",
		"硐", "	dong4",
		"硒", "	xi1",
		"硪", "	wo4",
		"硟", "	chan4",
		"硩", "	che4",
		"硨", "	che1",
		"硧", "	yong3",
		"硦", "	luo4",
		"硥", "	mang3",
		"硤", "	xia2",
		"硣", "	xiao1",
		"硢", "	yu2",
		"硡", "	hong1",
		"硠", "	lang2",
		"硞", "	que4",
		"硓", "	lao",
		"硝", "	xiao1",
		"硜", "	keng1",
		"硛", "	yi4",
		"硚", "	qiao2",
		"硙", "	wei2",
		"硘", "	qing",
		"硗", "	qiao1",
		"硖", "	xia2",
		"硕", "	shuo4",
		"硔", "	hong2",
		"矑", "	lu2",
		"矏", "	mian2",
		"眀", "	ming2",
		"着", "	zhe",
		"睊", "	juan4",
		"睉", "	cuo2",
		"睈", "	cheng3",
		"睇", "	di4",
		"睆", "	huan4",
		"睅", "	han4",
		"睄", "	shao4",
		"睃", "	suo1",
		"睂", "	mei2",
		"睁", "	zheng1",
		"眿", "	mo4",
		"睌", "	man3",
		"眾", "	zhong4",
		"眽", "	mo4",
		"眼", "	yan3",
		"眻", "	yang2",
		"眺", "	tiao4",
		"眹", "	zhen4",
		"眸", "	mou2",
		"眷", "	juan4",
		"眶", "	kuang4",
		"眵", "	chi1",
		"睋", "	e2",
		"睍", "	xian4",
		"眳", "	ming2",
		"睚", "	ya2",
		"睤", "	bi4",
		"督", "	du1",
		"睢", "	sui1",
		"睡", "	shui4",
		"睠", "	juan4",
		"睟", "	sui4",
		"睞", "	lai4",
		"睝", "	li2",
		"睜", "	zheng1",
		"睛", "	jing1",
		"睙", "	lie4",
		"睎", "	xi1",
		"睘", "	qiong2",
		"睗", "	shi4",
		"睖", "	leng4",
		"睕", "	wan3",
		"睔", "	gun4",
		"睓", "	tian3",
		"睒", "	shan3",
		"睑", "	jian3",
		"睐", "	lai4",
		"睏", "	kun4",
		"眴", "	xuan4",
		"眲", "	ne4",
		"睦", "	mu4",
		"県", "	xian4",
		"眖", "	kuang4",
		"眕", "	zhen3",
		"眔", "	da4",
		"眓", "	huo4",
		"眒", "	shen1",
		"眑", "	yao3",
		"眐", "	zheng1",
		"眏", "	yang1",
		"眎", "	shi4",
		"眍", "	kou1",
		"看", "	kan4",
		"眘", "	shen4",
		"眊", "	mao4",
		"眉", "	mei2",
		"眈", "	dan1",
		"眇", "	miao3",
		"眆", "	fang3",
		"眅", "	pan1",
		"眄", "	mian3",
		"眃", "	yun2",
		"眂", "	shi4",
		"省", "	sheng3",
		"眗", "	ju1",
		"眙", "	yi2",
		"眱", "	di4",
		"眦", "	zi4",
		"眰", "	die4",
		"眯", "	mi1",
		"眮", "	tong2",
		"眭", "	sui1",
		"眬", "	long2",
		"眫", "	mi3",
		"眪", "	bing3",
		"眩", "	xuan4",
		"眨", "	zha3",
		"眧", "	chao3",
		"眥", "	zi4",
		"眚", "	sheng3",
		"眤", "	ni4",
		"眣", "	die2",
		"眢", "	yuan1",
		"眡", "	shi4",
		"眠", "	mian2",
		"真", "	zhen1",
		"眞", "	zhen1",
		"眝", "	zhu4",
		"眜", "	mo4",
		"眛", "	mei4",
		"睥", "	pi4",
		"睧", "	hun1",
		"矎", "	xuan1",
		"瞩", "	zhu3",
		"瞳", "	tong2",
		"瞲", "	xu4",
		"瞱", "	ye4",
		"瞰", "	kan4",
		"瞯", "	xian2",
		"瞮", "	che4",
		"瞭", "	liao3",
		"瞬", "	shun4",
		"瞫", "	shen3",
		"瞪", "	deng4",
		"瞨", "	pu2",
		"瞵", "	lin2",
		"瞧", "	qiao2",
		"瞦", "	xi1",
		"瞥", "	pie1",
		"瞤", "	run2",
		"瞣", "	huan",
		"瞢", "	meng2",
		"瞡", "	gui3",
		"瞠", "	cheng1",
		"瞟", "	piao3",
		"瞞", "	man2",
		"瞴", "	mou2",
		"瞶", "	gui4",
		"瞜", "	lou1",
		"矃", "	ning3",
		"矍", "	jue2",
		"矌", "	kuang4",
		"矋", "	li4",
		"矊", "	mian2",
		"矉", "	pin2",
		"矈", "	mian2",
		"矇", "	meng2",
		"矆", "	huo4",
		"矅", "	yao4",
		"矄", "	xun1",
		"矂", "	sao4",
		"瞷", "	jian4",
		"矁", "	chou3",
		"矀", "	mei2",
		"瞿", "	qu2",
		"瞾", "	zhao4",
		"瞽", "	gu3",
		"瞼", "	jian3",
		"瞻", "	zhan1",
		"瞺", "	hui4",
		"瞹", "	ai4",
		"瞸", "	ye4",
		"瞝", "	chi1",
		"瞛", "	cong1",
		"睨", "	ni4",
		"睴", "	gun4",
		"睾", "	gao1",
		"睽", "	kui2",
		"睼", "	tian4",
		"睻", "	xuan1",
		"睺", "	hou2",
		"睹", "	du3",
		"睸", "	mei4",
		"睷", "	jian1",
		"睶", "	chun3",
		"睵", "	zai1",
		"睳", "	hui1",
		"瞀", "	mao4",
		"睲", "	xing3",
		"睱", "	xia4",
		"睰", "	ma4",
		"睯", "	hun1",
		"睮", "	yu2",
		"睭", "	zhou3",
		"睬", "	cai3",
		"睫", "	jie2",
		"睪", "	yi4",
		"睩", "	lu4",
		"睿", "	rui4",
		"瞁", "	xu4",
		"瞚", "	shun4",
		"瞏", "	qiong2",
		"瞙", "	mo4",
		"瞘", "	kou1",
		"瞗", "	diao1",
		"瞖", "	yi4",
		"瞕", "	zhang4",
		"瞔", "	ze2",
		"瞓", "	shui4",
		"瞒", "	man2",
		"瞑", "	ming2",
		"瞐", "	mo4",
		"瞎", "	xia1",
		"瞂", "	fa2",
		"瞍", "	sou3",
		"瞌", "	ke1",
		"瞋", "	chen1",
		"瞊", "	dang4",
		"瞉", "	kou4",
		"瞈", "	weng3",
		"瞇", "	mi1",
		"瞆", "	kui4",
		"瞅", "	chou3",
		"瞄", "	miao2",
		"瞃", "	wo4",
		"畠", "	tian2",
		"畞", "	mu3",
		"爚", "	yue4",
		"猪", "	zhu1",
		"猴", "	hou2",
		"猳", "	jia1",
		"猲", "	xie1",
		"猱", "	nao2",
		"猰", "	ya4",
		"猯", "	tuan1",
		"献", "	xian4",
		"猭", "	chuan1",
		"猬", "	wei4",
		"猫", "	mao1",
		"猩", "	xing1",
		"猶", "	you2",
		"猨", "	yuan2",
		"猧", "	wo1",
		"猦", "	feng1",
		"猥", "	wei3",
		"猤", "	gui4",
		"猣", "	zong1",
		"猢", "	hu2",
		"猡", "	luo2",
		"猠", "	dian3",
		"猟", "	lie",
		"猵", "	bian1",
		"猷", "	you2",
		"猝", "	cu4",
		"獄", "	yu4",
		"獎", "	jiang3",
		"獍", "	jing4",
		"獌", "	man4",
		"獋", "	hao2",
		"獊", "	cang1",
		"獉", "	zhen1",
		"獈", "	yi4",
		"獇", "	qiang",
		"獆", "	hao2",
		"獅", "	shi1",
		"獃", "	dai1",
		"猸", "	mei2",
		"獂", "	yuan2",
		"獁", "	ma4",
		"獀", "	sou1",
		"猿", "	yuan2",
		"猾", "	hua2",
		"猽", "	ming2",
		"猼", "	bo2",
		"猻", "	sun1",
		"猺", "	yao2",
		"猹", "	cha2",
		"猞", "	she1",
		"猜", "	cai1",
		"獐", "	zhang1",
		"狶", "	xi1",
		"猀", "	sha1",
		"狿", "	yan2",
		"狾", "	zhi4",
		"狽", "	bei4",
		"狼", "	lang2",
		"狻", "	suan1",
		"狺", "	yin2",
		"狹", "	xia2",
		"狸", "	li2",
		"狷", "	juan4",
		"狵", "	mang2",
		"猂", "	han4",
		"狴", "	bi4",
		"狳", "	yu2",
		"狲", "	sun1",
		"狱", "	yu4",
		"狰", "	zheng1",
		"狯", "	kuai4",
		"狮", "	shi1",
		"狭", "	xia2",
		"独", "	du2",
		"狫", "	lao3",
		"猁", "	li4",
		"猃", "	xian3",
		"猛", "	meng3",
		"猐", "	qiang1",
		"猚", "	ya2",
		"猙", "	zheng1",
		"猘", "	zhi4",
		"猗", "	yi1",
		"猖", "	chang1",
		"猕", "	mi2",
		"猔", "	zong4",
		"猓", "	guo3",
		"猒", "	yan1",
		"猑", "	kun1",
		"猏", "	jian1",
		"猄", "	jing1",
		"猎", "	lie4",
		"猍", "	lai2",
		"猌", "	yin4",
		"猋", "	biao1",
		"猊", "	ni2",
		"猉", "	qi2",
		"猈", "	bai4",
		"猇", "	xiao1",
		"猆", "	fei1",
		"猅", "	pai2",
		"獏", "	mo4",
		"獑", "	chan2",
		"狩", "	shou4",
		"玒", "	hong2",
		"玜", "	gong1",
		"玛", "	ma3",
		"玚", "	chang4",
		"玙", "	yu2",
		"玘", "	qi3",
		"玗", "	yu2",
		"玖", "	jiu3",
		"玕", "	gan1",
		"玔", "	chuan4",
		"玓", "	di4",
		"玑", "	ji1",
		"玞", "	fu1",
		"玐", "	ba1",
		"玏", "	le4",
		"玎", "	ding1",
		"玍", "	ga3",
		"玌", "	qiu2",
		"王", "	wang2",
		"玊", "	su4",
		"玉", "	yu4",
		"玈", "	lu2",
		"率", "	lv4",
		"玝", "	wu3",
		"玟", "	wen2",
		"玅", "	miao4",
		"玬", "	dan3",
		"玶", "	ping2",
		"玵", "	an2",
		"玴", "	yi4",
		"玳", "	dai4",
		"玲", "	ling2",
		"玱", "	qiang1",
		"现", "	xian4",
		"环", "	huan2",
		"玮", "	wei3",
		"玭", "	pin2",
		"玫", "	mei2",
		"玠", "	jie4",
		"玪", "	jian1",
		"玩", "	wan2",
		"玨", "	jue2",
		"玧", "	men2",
		"玦", "	jue2",
		"玥", "	yue4",
		"玤", "	bang4",
		"玣", "	bian4",
		"玢", "	bin1",
		"玡", "	ya2",
		"玆", "	zi1",
		"玄", "	xuan2",
		"獒", "	ao2",
		"獞", "	tong2",
		"獨", "	du2",
		"獧", "	juan4",
		"獦", "	ge2",
		"獥", "	jiao4",
		"獤", "	dun1",
		"獣", "	shou",
		"獢", "	xiao1",
		"獡", "	shuo4",
		"獠", "	liao2",
		"獟", "	yao4",
		"獝", "	xu4",
		"獪", "	kuai4",
		"獜", "	lin2",
		"獛", "	pu2",
		"獚", "	huang2",
		"獙", "	bi4",
		"獘", "	bi4",
		"獗", "	jue2",
		"獖", "	ben4",
		"獕", "	cui1",
		"獔", "	hao2",
		"獓", "	ao2",
		"獩", "	hui4",
		"獫", "	xian3",
		"玃", "	jue2",
		"獸", "	shou4",
		"玂", "	qi2",
		"玁", "	xian3",
		"玀", "	luo2",
		"獿", "	nao3",
		"獾", "	huan1",
		"獽", "	rang2",
		"獼", "	mi2",
		"獻", "	xian4",
		"獺", "	ta3",
		"獹", "	lu2",
		"獷", "	guang3",
		"獬", "	xie4",
		"獶", "	nao3",
		"獵", "	lie4",
		"獴", "	meng3",
		"獳", "	nou4",
		"獲", "	huo4",
		"獱", "	pin2",
		"獰", "	ning2",
		"獯", "	xun1",
		"獮", "	xian3",
		"獭", "	ta3",
		"狪", "	tong2",
		"狨", "	rong2",
		"玸", "	fu2",
		"牚", "	cheng1",
		"牤", "	mang1",
		"牣", "	ren4",
		"牢", "	lao2",
		"牡", "	mu3",
		"牠", "	ta1",
		"薡", "	ding3",
		"牞", "	jiu1",
		"牝", "	pin4",
		"牜", "	niu",
		"牛", "	niu2",
		"牙", "	ya2",
		"牦", "	mao2",
		"牘", "	du2",
		"牗", "	you",
		"牖", "	you3",
		"牕", "	chuang1",
		"牔", "	bo2",
		"牓", "	bang3",
		"牒", "	die2",
		"牑", "	bian1",
		"牐", "	zha2",
		"牏", "	yu2",
		"牥", "	fang1",
		"牧", "	mu4",
		"牍", "	du2",
		"牴", "	di3",
		"牾", "	wu3",
		"牽", "	qian1",
		"牼", "	keng1",
		"牻", "	mang2",
		"牺", "	xi1",
		"特", "	te4",
		"牸", "	zi4",
		"牷", "	quan2",
		"牶", "	quan4",
		"牵", "	qian1",
		"牳", "	mu3",
		"牨", "	gang1",
		"牲", "	sheng1",
		"牱", "	ge1",
		"牰", "	you4",
		"牯", "	gu3",
		"牮", "	jian4",
		"牭", "	si4",
		"牬", "	bei4",
		"牫", "	ge1",
		"牪", "	yan4",
		"物", "	wu4",
		"牎", "	chuang1",
		"牌", "	pai2",
		"犀", "	xi1",
		"爦", "	lan3",
		"爰", "	yuan2",
		"爯", "	cheng1",
		"爮", "	pao2",
		"爭", "	zheng1",
		"爬", "	pa2",
		"爫", "	zhao",
		"爪", "	zhao3",
		"爩", "	yu4",
		"爨", "	cuan4",
		"爧", "	ling2",
		"爥", "	zhu2",
		"爲", "	wei4",
		"爤", "	lan4",
		"爣", "	tang3",
		"爢", "	mi2",
		"爡", "	che4",
		"爠", "	ju",
		"爟", "	guan4",
		"爞", "	chong2",
		"爝", "	jue2",
		"爜", "	cong2",
		"爛", "	lan4",
		"爱", "	ai4",
		"爳", "	han",
		"牋", "	jian1",
		"牀", "	chuang2",
		"牊", "	chao2",
		"牉", "	pan4",
		"版", "	ban3",
		"片", "	pian4",
		"牆", "	qiang2",
		"牅", "	yong2",
		"牄", "	qiang1",
		"牃", "	die2",
		"牂", "	zang1",
		"牁", "	ke1",
		"爿", "	pan2",
		"爴", "	jue2",
		"爾", "	er3",
		"爽", "	shuang3",
		"爼", "	zu3",
		"爻", "	yao2",
		"爺", "	ye2",
		"爹", "	die1",
		"爸", "	ba4",
		"爷", "	ye2",
		"父", "	fu4",
		"爵", "	jue2",
		"牿", "	gu4",
		"犁", "	li2",
		"狧", "	ta4",
		"狂", "	kuang2",
		"狌", "	sheng1",
		"狋", "	yi2",
		"狊", "	ju2",
		"狉", "	pi1",
		"狈", "	bei4",
		"狇", "	mu4",
		"狆", "	zhong4",
		"狅", "	qing1",
		"狄", "	di2",
		"狃", "	niu3",
		"狁", "	yun3",
		"狎", "	xia2",
		"狀", "	zhuang4",
		"犿", "	huan1",
		"犾", "	yin2",
		"犽", "	ya4",
		"犼", "	hou3",
		"犻", "	bo2",
		"犺", "	kang4",
		"犹", "	you2",
		"犸", "	ma4",
		"犷", "	guang3",
		"狍", "	pao2",
		"狏", "	tuo2",
		"犵", "	ge1",
		"狜", "	ku3",
		"狦", "	shan1",
		"狥", "	xun4",
		"狤", "	ji2",
		"狣", "	zhao4",
		"狢", "	he2",
		"狡", "	jiao3",
		"狠", "	hen3",
		"狟", "	huan2",
		"狞", "	ning2",
		"狝", "	xian3",
		"狛", "	bo2",
		"狐", "	hu2",
		"狚", "	dan4",
		"狙", "	ju1",
		"狘", "	xue4",
		"狗", "	gou3",
		"狖", "	you4",
		"狕", "	yao3",
		"狔", "	ni3",
		"狓", "	pi2",
		"狒", "	fei4",
		"狑", "	ling2",
		"状", "	zhuang4",
		"犴", "	an4",
		"犂", "	li2",
		"犎", "	feng1",
		"犘", "	ma2",
		"犗", "	jie4",
		"犖", "	luo4",
		"犕", "	bei4",
		"犔", "	xi4",
		"犓", "	chu2",
		"犒", "	kao4",
		"犑", "	ju2",
		"犐", "	ke1",
		"犏", "	pian1",
		"犍", "	jian1",
		"犚", "	wei4",
		"犌", "	jia1",
		"犋", "	ju4",
		"犊", "	du2",
		"犉", "	chun2",
		"犈", "	quan2",
		"犇", "	ben1",
		"犆", "	zhi2",
		"犅", "	gang1",
		"犄", "	ji1",
		"犃", "	pou3",
		"犙", "	san1",
		"犛", "	mao2",
		"犳", "	zhuo2",
		"犨", "	chou1",
		"犲", "	cai2",
		"犱", "	ji3",
		"犰", "	qiu2",
		"犯", "	fan4",
		"犮", "	ba2",
		"犭", "	quan3",
		"犬", "	quan3",
		"犫", "	chou1",
		"犪", "	kui2",
		"犩", "	wei2",
		"犧", "	xi1",
		"犜", "	dun1",
		"犦", "	bo2",
		"犥", "	piao1",
		"犤", "	pai2",
		"犣", "	lie4",
		"犢", "	du2",
		"犡", "	li4",
		"犠", "	xi",
		"犟", "	jiang4",
		"犞", "	qiao",
		"犝", "	tong2",
		"玷", "	dian4",
		"玹", "	xuan2",
		"畝", "	mu3",
		"瓋", "	ti4",
		"瓕", "	mi2",
		"瓔", "	ying1",
		"瓓", "	lan4",
		"瓒", "	zan4",
		"瓑", "	li4",
		"瓐", "	lu2",
		"瓏", "	long2",
		"瓎", "	la4",
		"瓍", "	sui2",
		"瓌", "	gui1",
		"瓊", "	qiong2",
		"瓗", "	qiong2",
		"瓉", "	zan4",
		"瓈", "	li2",
		"瓇", "	rou2",
		"瓆", "	zhi4",
		"瓅", "	li4",
		"瓄", "	du2",
		"瓃", "	lei2",
		"瓂", "	gai4",
		"瓁", "	wo4",
		"瓀", "	ruan3",
		"瓖", "	xiang1",
		"瓘", "	guan4",
		"璾", "	zi1",
		"瓥", "	li4",
		"瓲", "	wa",
		"瓯", "	ou1",
		"瓮", "	weng4",
		"瓭", "	dan3",
		"瓬", "	fang3",
		"瓫", "	pen2",
		"瓪", "	ban3",
		"瓩", "	qian1",
		"瓨", "	xiang2",
		"瓦", "	wa3",
		"瓤", "	rang2",
		"瓙", "	dao4",
		"瓣", "	ban4",
		"瓢", "	piao2",
		"瓡", "	zhi2",
		"瓠", "	hu4",
		"瓟", "	bo2",
		"瓞", "	die2",
		"瓝", "	bo2",
		"瓜", "	gua1",
		"瓛", "	huan2",
		"瓚", "	zan4",
		"璿", "	xuan2",
		"璽", "	xi3",
		"瓴", "	ling2",
		"璗", "	dang4",
		"璡", "	jin4",
		"璠", "	fan2",
		"璟", "	jing3",
		"璞", "	pu2",
		"璝", "	gui1",
		"璜", "	huang2",
		"璛", "	su4",
		"璚", "	qiong2",
		"璙", "	liao2",
		"璘", "	lin2",
		"璖", "	qu2",
		"璣", "	ji1",
		"璕", "	xun2",
		"璔", "	zeng1",
		"璓", "	xiu4",
		"璒", "	deng1",
		"璑", "	wu2",
		"璐", "	lu4",
		"璏", "	wei4",
		"璎", "	ying1",
		"璍", "	hua",
		"璌", "	yin2",
		"璢", "	liu2",
		"璤", "	hui",
		"璼", "	lan2",
		"璱", "	se4",
		"璻", "	zui3",
		"璺", "	wen4",
		"璹", "	shu2",
		"璸", "	bin1",
		"璷", "	lu2",
		"璶", "	jin4",
		"璵", "	yu2",
		"璴", "	chu",
		"璳", "	tian2",
		"璲", "	sui4",
		"環", "	huan2",
		"璥", "	jing3",
		"璯", "	hui4",
		"璮", "	tan3",
		"璭", "	gun4",
		"璬", "	jiao3",
		"璫", "	dang1",
		"璪", "	zao3",
		"璩", "	qu2",
		"璨", "	can4",
		"璧", "	bi4",
		"璦", "	ai4",
		"瓳", "	hu2",
		"瓵", "	yi2",
		"璊", "	men2",
		"甸", "	dian1",
		"畂", "	liu4",
		"畁", "	qi2",
		"畀", "	bi4",
		"甿", "	meng2",
		"甾", "	zai1",
		"甽", "	zhen4",
		"甼", "	ting3",
		"画", "	hua4",
		"町", "	ting1",
		"甹", "	ping1",
		"男", "	nan2",
		"畄", "	liu2",
		"甶", "	fu2",
		"电", "	dian4",
		"甴", "	zha2",
		"申", "	shen1",
		"甲", "	jia3",
		"由", "	you2",
		"田", "	tian2",
		"甯", "	ning2",
		"甮", "	feng4",
		"甭", "	beng2",
		"畃", "	xun2",
		"畅", "	chang4",
		"甫", "	fu3",
		"畒", "	mu3",
		"畜", "	chu4",
		"畛", "	zhen3",
		"畚", "	ben3",
		"留", "	liu2",
		"畘", "	nan2",
		"畗", "	da2",
		"畖", "	wa1",
		"畕", "	jiang1",
		"畔", "	pan4",
		"畓", "	duo1",
		"畑", "	tian2",
		"畆", "	mu3",
		"畐", "	fu2",
		"畏", "	wei4",
		"畎", "	quan3",
		"畍", "	jie4",
		"界", "	jie4",
		"畋", "	tian2",
		"畊", "	geng1",
		"畉", "	fu2",
		"畈", "	fan4",
		"畇", "	yun2",
		"甬", "	yong3",
		"甪", "	lu4",
		"瓶", "	ping2",
		"甃", "	zhou4",
		"甎", "	zhuan1",
		"甍", "	meng2",
		"甌", "	ou1",
		"甋", "	di4",
		"甊", "	lou3",
		"甉", "	xian2",
		"甈", "	qi4",
		"甇", "	ying1",
		"甆", "	ci2",
		"甄", "	zhen1",
		"甂", "	bian1",
		"甐", "	lin4",
		"甁", "	ping2",
		"甀", "	zhui4",
		"瓿", "	bu4",
		"瓾", "	meng3",
		"瓽", "	dang4",
		"瓻", "	chi1",
		"瓺", "	chang2",
		"瓹", "	juan1",
		"瓸", "	bai3",
		"瓷", "	ci2",
		"甏", "	beng4",
		"甑", "	zeng4",
		"甩", "	shuai3",
		"甞", "	chang2",
		"用", "	yong4",
		"甧", "	shen1",
		"甦", "	su1",
		"甥", "	sheng1",
		"甤", "	rui2",
		"産", "	chan3",
		"產", "	chan3",
		"甡", "	shen1",
		"甠", "	qing2",
		"生", "	sheng1",
		"甝", "	han2",
		"甒", "	wu3",
		"甜", "	tian2",
		"甛", "	tian2",
		"甚", "	shen2",
		"甙", "	dai4",
		"甘", "	gan1",
		"甗", "	yan3",
		"甖", "	ying1",
		"甕", "	weng4",
		"甔", "	dan1",
		"甓", "	pi4",
		"璋", "	zhang1",
		"璉", "	lian3",
		"玺", "	xi3",
		"珺", "	jun4",
		"琄", "	xuan4",
		"球", "	qiu2",
		"琂", "	yan2",
		"琁", "	xuan2",
		"琀", "	han2",
		"珿", "	chu4",
		"現", "	xian4",
		"珽", "	ting3",
		"珼", "	bei4",
		"珻", "	mei2",
		"珹", "	cheng2",
		"理", "	li3",
		"珸", "	wu2",
		"珷", "	wu3",
		"珶", "	di4",
		"珵", "	cheng2",
		"珴", "	e2",
		"珳", "	wen2",
		"珲", "	hui1",
		"珱", "	ying",
		"珰", "	dang1",
		"珯", "	lao",
		"琅", "	lang2",
		"琇", "	xiu4",
		"班", "	ban1",
		"琔", "	dian4",
		"琞", "	sheng4",
		"琝", "	wen2",
		"琜", "	lai2",
		"琛", "	chen1",
		"琚", "	ju1",
		"琙", "	yu4",
		"琘", "	min2",
		"琗", "	se4",
		"琖", "	zhan3",
		"琕", "	pin2",
		"琓", "	wan2",
		"琈", "	fu2",
		"琒", "	feng",
		"琑", "	suo",
		"琐", "	suo3",
		"琏", "	lian3",
		"琎", "	jin4",
		"琍", "	li2",
		"琌", "	ling2",
		"琋", "	xi1",
		"琊", "	ya2",
		"琉", "	liu2",
		"珮", "	pei4",
		"珬", "	xu4",
		"琠", "	tian3",
		"珆", "	yi2",
		"珐", "	fa4",
		"珏", "	jue2",
		"珎", "	zhen1",
		"珍", "	zhen1",
		"珌", "	bi4",
		"珋", "	liu3",
		"珊", "	shan1",
		"珉", "	min2",
		"珈", "	jia1",
		"珇", "	zu3",
		"珅", "	shen1",
		"珒", "	jin1",
		"珄", "	sheng1",
		"珃", "	ran3",
		"珂", "	ke1",
		"珁", "	ci2",
		"珀", "	po4",
		"玿", "	shao2",
		"玾", "	jia3",
		"玽", "	gou3",
		"玼", "	ci3",
		"玻", "	bo1",
		"珑", "	long2",
		"珓", "	jiao4",
		"珫", "	chong1",
		"珠", "	zhu1",
		"珪", "	gui1",
		"珩", "	hang2",
		"珨", "	xia2",
		"珧", "	yao2",
		"珦", "	xiang4",
		"珥", "	er3",
		"珤", "	bao3",
		"珣", "	xun2",
		"珢", "	yin2",
		"珡", "	qin2",
		"珟", "	su4",
		"珔", "	jian4",
		"珞", "	luo4",
		"珝", "	xu3",
		"珜", "	yang2",
		"珛", "	xiu4",
		"珚", "	yan1",
		"珙", "	gong3",
		"珘", "	zhou1",
		"珗", "	xian1",
		"珖", "	guang4",
		"珕", "	li4",
		"琟", "	wei2",
		"琡", "	chu4",
		"璈", "	ao2",
		"瑣", "	suo3",
		"瑭", "	tang2",
		"瑬", "	liu2",
		"瑫", "	tao1",
		"瑪", "	ma3",
		"瑩", "	ying2",
		"瑨", "	jin4",
		"瑧", "	zhen1",
		"瑦", "	wu3",
		"瑥", "	wen1",
		"瑤", "	yao2",
		"瑢", "	rong2",
		"瑯", "	lang2",
		"瑡", "	shi1",
		"瑠", "	liu2",
		"瑟", "	se4",
		"瑞", "	rui4",
		"瑝", "	huang2",
		"瑜", "	yu2",
		"瑛", "	ying1",
		"瑚", "	hu2",
		"瑙", "	nao3",
		"瑘", "	ya2",
		"瑮", "	li4",
		"瑰", "	gui1",
		"瑖", "	duan4",
		"瑽", "	cong1",
		"璇", "	xuan2",
		"璆", "	qiu2",
		"璅", "	suo3",
		"璄", "	ying3",
		"璃", "	li2",
		"璂", "	qi2",
		"璁", "	cong1",
		"璀", "	cui3",
		"瑿", "	yi1",
		"瑾", "	jin3",
		"瑼", "	zhuan1",
		"瑱", "	zhen4",
		"瑻", "	kun1",
		"瑺", "	chang2",
		"瑹", "	shu1",
		"瑸", "	bin1",
		"瑷", "	ai4",
		"瑶", "	yao2",
		"瑵", "	zhao3",
		"瑴", "	jue2",
		"瑳", "	cuo1",
		"瑲", "	qiang1",
		"瑗", "	yuan4",
		"瑕", "	xia2",
		"琢", "	zuo2",
		"琮", "	cong2",
		"琸", "	zhuo2",
		"琷", "	que4",
		"琶", "	pa2",
		"琵", "	pi2",
		"琴", "	qin2",
		"琳", "	lin2",
		"琲", "	bei4",
		"琱", "	diao1",
		"琰", "	yan3",
		"琯", "	guan3",
		"琭", "	lu4",
		"琺", "	fa4",
		"琬", "	wan3",
		"琫", "	beng3",
		"琪", "	qi2",
		"琩", "	chang1",
		"琨", "	kun1",
		"琧", "	e4",
		"琦", "	qi2",
		"琥", "	hu3",
		"琤", "	cheng1",
		"琣", "	beng3",
		"琹", "	qin2",
		"琻", "	jin",
		"瑔", "	quan2",
		"瑉", "	min2",
		"瑓", "	lian4",
		"瑒", "	chang4",
		"瑑", "	zhuan4",
		"瑐", "	jian3",
		"瑏", "	chuan1",
		"瑎", "	xie2",
		"瑍", "	huan4",
		"瑌", "	ruan3",
		"瑋", "	wei3",
		"瑊", "	jian1",
		"瑈", "	rou2",
		"琼", "	qiong2",
		"瑇", "	dai4",
		"瑆", "	xing1",
		"瑅", "	ti2",
		"瑄", "	xuan1",
		"瑃", "	chun1",
		"瑂", "	mei2",
		"瑁", "	mao4",
		"瑀", "	yu3",
		"琿", "	hun2",
		"琾", "	jie4",
		"琽", "	du3",
		"薠", "	fan2",
		"诛", "	zhu1",
		"薢", "	xie4",
		"雸", "	an2",
		"霂", "	mu4",
		"霁", "	ji4",
		"需", "	xu1",
		"雿", "	diao4",
		"雾", "	wu4",
		"雽", "	hu4",
		"雼", "	dang4",
		"電", "	dian4",
		"雺", "	wu4",
		"雹", "	bao2",
		"雷", "	lei2",
		"霄", "	xiao1",
		"零", "	ling2",
		"雵", "	yang1",
		"雴", "	chi4",
		"雳", "	li4",
		"雲", "	yun2",
		"雱", "	pang1",
		"雰", "	fen1",
		"雯", "	wen2",
		"雮", "	mu4",
		"雭", "	se4",
		"霃", "	chen2",
		"霅", "	zha4",
		"雫", "	na3",
		"霒", "	yin1",
		"霜", "	shuang1",
		"霛", "	ling2",
		"霚", "	wu4",
		"霙", "	ying1",
		"霘", "	dong4",
		"霗", "	ling",
		"霖", "	lin2",
		"霕", "	tun2",
		"霔", "	zhu4",
		"霓", "	ni2",
		"霑", "	zhan1",
		"霆", "	ting2",
		"霐", "	hong2",
		"霏", "	fei1",
		"霎", "	sha4",
		"霍", "	huo4",
		"霌", "	zhou1",
		"霋", "	qi1",
		"霊", "	ling2",
		"霉", "	mei2",
		"霈", "	pei4",
		"震", "	zhen4",
		"雬", "	fou3",
		"雪", "	xue3",
		"霞", "	xia2",
		"雄", "	xiong2",
		"雎", "	ju1",
		"雍", "	yong1",
		"雌", "	ci2",
		"雋", "	juan4",
		"雊", "	gou4",
		"雉", "	zhi4",
		"雈", "	huan2",
		"雇", "	gu4",
		"集", "	ji2",
		"雅", "	ya3",
		"雃", "	qian1",
		"雐", "	hu1",
		"雂", "	qin2",
		"雁", "	yan4",
		"雀", "	que4",
		"隿", "	yi4",
		"难", "	nan2",
		"隽", "	juan4",
		"隼", "	sun3",
		"隻", "	zhi1",
		"隺", "	hu2",
		"隹", "	zhui1",
		"雏", "	chu2",
		"雑", "	za2",
		"雩", "	yu2",
		"雞", "	ji1",
		"雨", "	yu3",
		"雧", "	ji2",
		"雦", "	ji2",
		"雥", "	za2",
		"雤", "	xue2",
		"難", "	nan2",
		"離", "	li2",
		"雡", "	liu4",
		"雠", "	chou2",
		"雟", "	xi1",
		"雝", "	yong1",
		"雒", "	luo4",
		"雜", "	za2",
		"雛", "	chu2",
		"雚", "	guan4",
		"雙", "	shuang1",
		"雘", "	wo4",
		"雗", "	han4",
		"雖", "	sui1",
		"雕", "	diao1",
		"雔", "	chou2",
		"雓", "	yu2",
		"霝", "	ling2",
		"霟", "	hong2",
		"隷", "	li4",
		"靠", "	kao4",
		"靪", "	ding1",
		"革", "	ge2",
		"靨", "	ye4",
		"靧", "	hui4",
		"靦", "	tian3",
		"靥", "	ye4",
		"靤", "	bao4",
		"靣", "	mian4",
		"面", "	mian4",
		"靡", "	mi2",
		"靟", "	fei1",
		"靬", "	qian2",
		"非", "	fei1",
		"靝", "	tian1",
		"靜", "	jing4",
		"靛", "	dian4",
		"靚", "	jing4",
		"静", "	jing4",
		"靘", "	qing4",
		"靗", "	cheng1",
		"靖", "	jing4",
		"靕", "	zhen1",
		"靫", "	cha2",
		"靭", "	ren4",
		"靓", "	jing4",
		"靺", "	mo4",
		"鞄", "	pao2",
		"鞃", "	hong2",
		"鞂", "	jia2",
		"鞁", "	bei4",
		"鞀", "	tao2",
		"靿", "	yao4",
		"靾", "	yi4",
		"靽", "	ban4",
		"靼", "	da2",
		"靻", "	zu3",
		"靹", "	na4",
		"靮", "	di2",
		"靸", "	sa3",
		"靷", "	yin3",
		"靶", "	ba3",
		"靵", "	niu3",
		"靴", "	xue1",
		"靳", "	jin4",
		"靲", "	qin2",
		"靱", "	ren4",
		"靰", "	wu4",
		"靯", "	du4",
		"靔", "	tian1",
		"青", "	qing1",
		"霠", "	yin1",
		"霬", "	yi4",
		"霶", "	pang1",
		"霵", "	ji2",
		"霴", "	dai4",
		"霳", "	long2",
		"露", "	lu4",
		"霱", "	yu4",
		"霰", "	san3",
		"霯", "	teng4",
		"霮", "	dan4",
		"霭", "	ai3",
		"霫", "	xi2",
		"霸", "	ba4",
		"霪", "	yin2",
		"霩", "	kuo4",
		"霨", "	wei4",
		"霧", "	wu4",
		"霦", "	bin1",
		"霥", "	meng4",
		"霤", "	liu4",
		"霣", "	yun3",
		"霢", "	mai4",
		"霡", "	mai4",
		"霷", "	yang2",
		"霹", "	pi1",
		"靑", "	qing1",
		"靆", "	dai4",
		"靐", "	bing4",
		"靏", "	he4",
		"靎", "	he4",
		"靍", "	he",
		"靌", "	bao3",
		"靋", "	li4",
		"靊", "	feng1",
		"靉", "	ai4",
		"靈", "	ling2",
		"靇", "	long2",
		"靅", "	fei4",
		"霺", "	wei2",
		"靄", "	ai3",
		"靃", "	huo4",
		"靂", "	li4",
		"靁", "	lei2",
		"靀", "	meng2",
		"霿", "	meng2",
		"霾", "	mai2",
		"霽", "	ji4",
		"霼", "	xi4",
		"霻", "	feng1",
		"隸", "	li4",
		"隶", "	li4",
		"鞆", "	bing",
		"阨", "	e4",
		"防", "	fang2",
		"阱", "	jing3",
		"阰", "	pi2",
		"阯", "	zhi3",
		"阮", "	ruan3",
		"阭", "	yun3",
		"阬", "	keng1",
		"阫", "	pei2",
		"阪", "	ban3",
		"阩", "	sheng1",
		"阧", "	dou3",
		"阴", "	yin1",
		"阦", "	yang2",
		"阥", "	yin1",
		"阤", "	zhi4",
		"阣", "	gai4",
		"阢", "	wu4",
		"阡", "	qian1",
		"阠", "	xin4",
		"队", "	dui4",
		"阞", "	le4",
		"阝", "	fu4",
		"阳", "	yang2",
		"阵", "	zhen4",
		"阛", "	huan2",
		"陂", "	bei1",
		"陌", "	mo4",
		"陋", "	lou4",
		"陊", "	duo4",
		"陉", "	xing2",
		"陈", "	chen2",
		"陇", "	long3",
		"陆", "	lu4",
		"际", "	ji4",
		"附", "	fu4",
		"陃", "	bing3",
		"陁", "	tuo2",
		"阶", "	jie1",
		"陀", "	tuo2",
		"阿", "	a1",
		"阾", "	ling3",
		"阽", "	dian4",
		"阼", "	zuo4",
		"阻", "	zu3",
		"阺", "	di3",
		"阹", "	qu1",
		"阸", "	e4",
		"阷", "	cheng1",
		"阜", "	fu4",
		"阚", "	han3",
		"陎", "	shu1",
		"间", "	jian1",
		"闾", "	lv2",
		"闽", "	min3",
		"闼", "	ta4",
		"闻", "	wen2",
		"闺", "	gui1",
		"闹", "	nao4",
		"闸", "	zha2",
		"闷", "	men4",
		"闶", "	kang1",
		"闵", "	min3",
		"闳", "	hong2",
		"阀", "	fa2",
		"闲", "	xian2",
		"闱", "	wei2",
		"闰", "	run4",
		"闯", "	chuang3",
		"问", "	wen4",
		"闭", "	bi4",
		"闬", "	han4",
		"闫", "	yan4",
		"闪", "	shan3",
		"闩", "	shuan1",
		"闿", "	kai3",
		"阁", "	ge2",
		"阙", "	que1",
		"阎", "	yan2",
		"阘", "	da2",
		"阗", "	tian2",
		"阖", "	he2",
		"阕", "	que4",
		"阔", "	kuo4",
		"阓", "	hui4",
		"阒", "	qu4",
		"阑", "	lan2",
		"阐", "	chan3",
		"阏", "	e4",
		"阍", "	hun1",
		"阂", "	he2",
		"阌", "	wen2",
		"阋", "	xi4",
		"阊", "	chang1",
		"阉", "	yan1",
		"阈", "	yu4",
		"阇", "	du1",
		"阆", "	lang2",
		"阅", "	yue4",
		"阄", "	jiu1",
		"阃", "	kun3",
		"降", "	jiang4",
		"陏", "	duo4",
		"隵", "	xi1",
		"隐", "	yin3",
		"隚", "	tang2",
		"隙", "	xi4",
		"隘", "	ai4",
		"隗", "	kui2",
		"隖", "	wu4",
		"隕", "	yun3",
		"隔", "	ge2",
		"隓", "	hui1",
		"隒", "	yan3",
		"隑", "	gai4",
		"随", "	sui2",
		"障", "	zhang4",
		"階", "	jie1",
		"隍", "	huang2",
		"隌", "	an3",
		"隋", "	sui2",
		"隊", "	dui4",
		"隉", "	nie4",
		"隈", "	wei1",
		"隇", "	wei1",
		"隆", "	long2",
		"隅", "	yu2",
		"際", "	ji4",
		"隝", "	dao3",
		"隃", "	shu4",
		"險", "	xian3",
		"隴", "	long3",
		"隳", "	hui1",
		"隲", "	e2",
		"隱", "	yin3",
		"隰", "	xi2",
		"隯", "	dao3",
		"隮", "	ji1",
		"隭", "	er2",
		"隬", "	ni3",
		"隫", "	fen2",
		"隩", "	ao4",
		"隞", "	ao2",
		"隨", "	sui2",
		"隧", "	sui4",
		"隦", "	jiao3",
		"隥", "	deng4",
		"隤", "	tui2",
		"隣", "	lin2",
		"隢", "	rao3",
		"隡", "	sa",
		"隠", "	yin3",
		"隟", "	xi4",
		"隄", "	di1",
		"隂", "	yin1",
		"限", "	xian4",
		"陜", "	xia2",
		"陦", "	dao",
		"陥", "	xian4",
		"除", "	chu2",
		"陣", "	zhen4",
		"院", "	yuan4",
		"陡", "	dou3",
		"陠", "	pu1",
		"陟", "	zhi4",
		"陞", "	sheng1",
		"陝", "	shan3",
		"陛", "	bi4",
		"陨", "	yun3",
		"陚", "	fu4",
		"陙", "	chun2",
		"陘", "	xing2",
		"陗", "	qiao4",
		"陖", "	jun4",
		"陕", "	shan3",
		"陔", "	gai1",
		"陓", "	yu1",
		"陒", "	gui3",
		"陑", "	er2",
		"陧", "	nie4",
		"险", "	xian3",
		"隁", "	yan4",
		"陶", "	tao2",
		"隀", "	chong2",
		"陿", "	xia2",
		"陾", "	reng2",
		"陽", "	yang2",
		"陼", "	zhu3",
		"陻", "	yin1",
		"険", "	xian3",
		"陹", "	sheng1",
		"陸", "	lu4",
		"陷", "	xian4",
		"陵", "	ling2",
		"陪", "	pei2",
		"陴", "	pi2",
		"陳", "	chen2",
		"陲", "	chui2",
		"陱", "	ju1",
		"陰", "	yin1",
		"陯", "	lun2",
		"陮", "	dui4",
		"陭", "	yi4",
		"陬", "	zou1",
		"陫", "	fei4",
		"鞅", "	yang1",
		"鞇", "	yin1",
		"闧", "	ta1",
		"题", "	ti2",
		"颢", "	hao4",
		"颡", "	sang3",
		"颠", "	dian1",
		"颟", "	man1",
		"颞", "	nie4",
		"额", "	e2",
		"颜", "	yan2",
		"颛", "	zhuan1",
		"颚", "	e4",
		"颙", "	yong2",
		"颗", "	ke1",
		"颤", "	chan4",
		"颖", "	ying3",
		"颕", "	ying3",
		"颔", "	han4",
		"颓", "	tui2",
		"颒", "	hui4",
		"频", "	pin2",
		"颐", "	yi2",
		"颏", "	ke1",
		"颎", "	jiong3",
		"颍", "	ying3",
		"颣", "	lei4",
		"颥", "	ru2",
		"颋", "	ting3",
		"颲", "	lie4",
		"颼", "	sou1",
		"颻", "	yao2",
		"颺", "	yang2",
		"颹", "	wei3",
		"颸", "	si1",
		"颷", "	biao1",
		"颶", "	ju4",
		"颵", "	shao1",
		"颴", "	xuan4",
		"颳", "	gua1",
		"颱", "	tai2",
		"颦", "	pin2",
		"颰", "	ba2",
		"颯", "	sa4",
		"颮", "	biao1",
		"颭", "	zhan3",
		"颬", "	xia1",
		"颫", "	fu2",
		"颪", "	gua",
		"颩", "	biao1",
		"風", "	feng1",
		"颧", "	quan2",
		"颌", "	he2",
		"颊", "	jia2",
		"颾", "	sou1",
		"顤", "	yao2",
		"顮", "	bin1",
		"顭", "	meng2",
		"顬", "	ru2",
		"顫", "	chan4",
		"顪", "	hui4",
		"顩", "	yan3",
		"顨", "	xun4",
		"顧", "	gu4",
		"顦", "	qiao2",
		"顥", "	hao4",
		"顣", "	cu4",
		"顰", "	pin2",
		"顢", "	man2",
		"顡", "	wai4",
		"顠", "	piao3",
		"顟", "	lao2",
		"類", "	lei4",
		"顝", "	kui1",
		"顜", "	jiang3",
		"顛", "	dian1",
		"顚", "	dian1",
		"顙", "	sang3",
		"顯", "	xian3",
		"顱", "	lu2",
		"颉", "	jie2",
		"顾", "	gu4",
		"颈", "	jing3",
		"颇", "	po1",
		"领", "	ling3",
		"颅", "	lu2",
		"预", "	yu4",
		"颃", "	hang2",
		"颂", "	song4",
		"颁", "	ban1",
		"颀", "	qi2",
		"顿", "	dun4",
		"顽", "	wan2",
		"顲", "	lan3",
		"顼", "	xu1",
		"须", "	xu1",
		"顺", "	shun4",
		"项", "	xiang4",
		"顸", "	han1",
		"顷", "	qing3",
		"顶", "	ding3",
		"页", "	ye4",
		"顴", "	quan2",
		"顳", "	nie4",
		"颽", "	kai3",
		"颿", "	fan1",
		"顗", "	yi3",
		"餀", "	hai4",
		"養", "	yang3",
		"餉", "	xiang3",
		"餈", "	ci2",
		"餇", "	tong2",
		"餆", "	yao2",
		"餅", "	bing3",
		"餄", "	jia2",
		"餃", "	jiao3",
		"餂", "	tian3",
		"餁", "	ren4",
		"飿", "	duo4",
		"餌", "	er3",
		"飾", "	shi4",
		"飽", "	bao3",
		"飼", "	si4",
		"飻", "	tie4",
		"飺", "	ci2",
		"飹", "	liu3",
		"飸", "	tao1",
		"飷", "	jie3",
		"飶", "	bi4",
		"飵", "	zuo4",
		"餋", "	juan4",
		"餍", "	yan4",
		"飳", "	tou3",
		"餚", "	yao2",
		"餤", "	tan2",
		"餣", "	ye4",
		"餢", "	bu4",
		"餡", "	xian4",
		"餠", "	bing3",
		"餟", "	zhui4",
		"餞", "	jian4",
		"餝", "	shi4",
		"餜", "	guo3",
		"餛", "	hun2",
		"餙", "	shi4",
		"餎", "	le",
		"餘", "	yu2",
		"餗", "	su4",
		"餖", "	dou4",
		"餕", "	jun4",
		"餔", "	bu4",
		"餓", "	e4",
		"餒", "	nei3",
		"餑", "	bo1",
		"餐", "	can1",
		"餏", "	xi1",
		"飴", "	yi2",
		"飲", "	yin3",
		"飀", "	liu2",
		"飌", "	feng1",
		"飖", "	yao2",
		"飕", "	sou1",
		"飔", "	si1",
		"飓", "	ju4",
		"飒", "	sa4",
		"飑", "	biao1",
		"飐", "	zhan3",
		"飏", "	yang2",
		"风", "	feng1",
		"飍", "	xiu1",
		"飋", "	se4",
		"飘", "	piao1",
		"飊", "	biao",
		"飉", "	liao2",
		"飈", "	biao1",
		"飇", "	biao1",
		"飆", "	biao1",
		"飅", "	liu2",
		"飄", "	piao1",
		"飃", "	piao1",
		"飂", "	liu4",
		"飁", "	xi2",
		"飗", "	liu2",
		"飙", "	biao1",
		"飱", "	sun1",
		"飦", "	zhan1",
		"飰", "	fan4",
		"飯", "	fan4",
		"飮", "	yin3",
		"飭", "	chi4",
		"飬", "	juan4",
		"飫", "	yu4",
		"飪", "	ren4",
		"飩", "	tun2",
		"飨", "	xiang3",
		"飧", "	sun1",
		"飥", "	tuo1",
		"飚", "	biao1",
		"飤", "	si4",
		"飣", "	ding4",
		"飢", "	ji1",
		"飡", "	can1",
		"飠", "	shi2",
		"食", "	shi2",
		"飞", "	fei1",
		"飝", "	fei1",
		"飜", "	fan1",
		"飛", "	fei1",
		"願", "	yuan4",
		"顖", "	xin4",
		"鞈", "	ge2",
		"韈", "	wa4",
		"韒", "	qiao4",
		"韑", "	wei3",
		"韐", "	ge2",
		"韏", "	quan4",
		"韎", "	mei4",
		"韍", "	fu2",
		"韌", "	ren4",
		"韋", "	wei2",
		"韊", "	lan2",
		"韉", "	jian1",
		"韇", "	du2",
		"韔", "	chang4",
		"韆", "	qian1",
		"韅", "	xian3",
		"韄", "	hu4",
		"韃", "	da2",
		"韂", "	chan4",
		"韁", "	jiang1",
		"韀", "	jian1",
		"鞿", "	ji1",
		"鞾", "	xue1",
		"鞽", "	qiao2",
		"韓", "	han2",
		"韕", "	kuo",
		"鞻", "	lou2",
		"韢", "	sui4",
		"韬", "	tao1",
		"韫", "	yun4",
		"韪", "	wei3",
		"韩", "	han2",
		"韨", "	fu2",
		"韧", "	ren4",
		"韦", "	wei2",
		"韥", "	du2",
		"韤", "	wa4",
		"韣", "	du2",
		"韡", "	wei3",
		"韖", "	rou3",
		"韠", "	bi4",
		"韟", "	gao1",
		"韞", "	yun4",
		"韝", "	gou1",
		"韜", "	tao1",
		"韛", "	bai4",
		"韚", "	ge2",
		"韙", "	wei3",
		"韘", "	she4",
		"韗", "	yun4",
		"鞼", "	gui4",
		"鞺", "	tang1",
		"韮", "	jiu3",
		"鞔", "	man2",
		"鞞", "	bing3",
		"鞝", "	shang4",
		"鞜", "	ta4",
		"鞛", "	beng3",
		"鞚", "	kong4",
		"鞙", "	xuan4",
		"鞘", "	qiao4",
		"鞗", "	tiao2",
		"鞖", "	sui1",
		"鞕", "	ying4",
		"鞓", "	ting1",
		"鞠", "	ju1",
		"鞒", "	qiao2",
		"鞑", "	da2",
		"鞐", "	qia",
		"鞏", "	gong3",
		"鞎", "	hen2",
		"鞍", "	an1",
		"鞌", "	an1",
		"鞋", "	xie2",
		"鞊", "	jie2",
		"鞉", "	tao2",
		"鞟", "	kuo4",
		"鞡", "	la",
		"鞹", "	kuo4",
		"鞮", "	di1",
		"鞸", "	bi4",
		"鞷", "	ge2",
		"鞶", "	pan2",
		"鞵", "	xie2",
		"鞴", "	bei4",
		"鞳", "	ta4",
		"鞲", "	gou1",
		"鞱", "	tao1",
		"鞰", "	wen1",
		"鞯", "	jian1",
		"鞭", "	bian1",
		"鞢", "	xie4",
		"鞬", "	jian1",
		"鞫", "	ju1",
		"鞪", "	mu4",
		"鞩", "	xiao4",
		"鞨", "	he2",
		"鞧", "	qiu1",
		"鞦", "	qiu1",
		"鞥", "	eng1",
		"鞤", "	bang1",
		"鞣", "	rou2",
		"韭", "	jiu3",
		"韯", "	xian1",
		"顕", "	xian3",
		"頰", "	jia2",
		"頺", "	tui2",
		"頹", "	tui2",
		"頸", "	jing3",
		"頷", "	han4",
		"頶", "	hu2",
		"頵", "	yun1",
		"頴", "	ying3",
		"頳", "	cheng1",
		"頲", "	ting3",
		"頱", "	luo1",
		"頯", "	kui2",
		"頼", "	lai4",
		"頮", "	hui4",
		"頭", "	tou2",
		"頬", "	jia2",
		"頫", "	fu3",
		"頪", "	lei4",
		"頩", "	ping1",
		"頨", "	yu3",
		"頧", "	dui3",
		"頦", "	hai2",
		"頥", "	shen3",
		"頻", "	pin2",
		"頽", "	tui2",
		"頣", "	shen3",
		"顊", "	yi2",
		"顔", "	yan2",
		"顓", "	zhuan1",
		"顒", "	yong2",
		"顑", "	kan3",
		"顐", "	wen4",
		"顏", "	yan2",
		"顎", "	e4",
		"額", "	e2",
		"題", "	ti2",
		"顋", "	sai1",
		"顉", "	qin1",
		"頾", "	zi1",
		"顈", "	xuan3",
		"顇", "	cui4",
		"顆", "	ke1",
		"顅", "	qian1",
		"顄", "	han4",
		"顃", "	tan2",
		"顂", "	lai4",
		"顁", "	ding4",
		"顀", "	chui2",
		"頿", "	zi1",
		"頤", "	yi2",
		"頢", "	kuo4",
		"韰", "	xie4",
		"韼", "	peng2",
		"順", "	shun4",
		"項", "	xiang4",
		"頄", "	kui2",
		"頃", "	qing3",
		"頂", "	ding3",
		"頁", "	ye4",
		"頀", "	hu4",
		"響", "	xiang3",
		"韾", "	yin1",
		"韽", "	an1",
		"韻", "	yun4",
		"須", "	xu1",
		"韺", "	ying1",
		"韹", "	huang2",
		"韸", "	peng2",
		"韷", "	le4",
		"韶", "	shao2",
		"韵", "	yun4",
		"韴", "	za2",
		"音", "	yin1",
		"韲", "	ji1",
		"韱", "	xian1",
		"頇", "	han1",
		"頉", "	yi2",
		"頡", "	xie2",
		"頖", "	pan4",
		"頠", "	wei3",
		"頟", "	e2",
		"頞", "	e4",
		"頝", "	qiao1",
		"頜", "	he2",
		"頛", "	lei4",
		"頚", "	jing3",
		"頙", "	che4",
		"領", "	ling3",
		"頗", "	po1",
		"頕", "	dan1",
		"頊", "	xu1",
		"頔", "	di2",
		"頓", "	dun4",
		"頒", "	ban1",
		"頑", "	wan2",
		"預", "	yu4",
		"頏", "	hang2",
		"頎", "	qi2",
		"頍", "	kui3",
		"頌", "	song4",
		"頋", "	e3",
		"门", "	men2",
		"闦", "	wen2",
		"餦", "	zhang1",
		"鎷", "	ma3",
		"鏁", "	suo3",
		"鏀", "	lu3",
		"鎿", "	na2",
		"鎾", "	wen",
		"鎽", "	feng",
		"鎼", "	xia4",
		"鎻", "	suo3",
		"鎺", "	zu",
		"鎹", "	song",
		"鎸", "	juan1",
		"鎶", "	ge1",
		"鏃", "	zu2",
		"鎵", "	jia1",
		"鎴", "	xi2",
		"鎳", "	nie4",
		"鎲", "	tang3",
		"鎱", "	yuan2",
		"鎰", "	yi4",
		"鎯", "	lang2",
		"鎮", "	zhen4",
		"鎭", "	zhen4",
		"鎬", "	hao4",
		"鏂", "	ou1",
		"鏄", "	tuan2",
		"鎪", "	sou1",
		"鏑", "	di2",
		"鏛", "	chang2",
		"鏚", "	qi1",
		"鏙", "	cui1",
		"鏘", "	qiang1",
		"鏗", "	keng1",
		"鏖", "	ao2",
		"鏕", "	lu4",
		"鏔", "	yi2",
		"鏓", "	zong3",
		"鏒", "	san3",
		"鏐", "	liu2",
		"鏅", "	xiu1",
		"鏏", "	wei4",
		"鏎", "	bi4",
		"鏍", "	luo2",
		"鏌", "	mo4",
		"鏋", "	man3",
		"鏊", "	ao4",
		"鏉", "	shou4",
		"鏈", "	lian4",
		"鏇", "	xuan4",
		"鏆", "	guan4",
		"鎫", "	wan4",
		"鎩", "	sha1",
		"鏝", "	man4",
		"鎃", "	pai4",
		"鎍", "	suo3",
		"鎌", "	lian2",
		"鎋", "	xia2",
		"鎊", "	bang4",
		"鎉", "	da2",
		"鎈", "	suo3",
		"鎇", "	mei2",
		"鎆", "	qian",
		"鎅", "	jie4",
		"鎄", "	ai1",
		"鎂", "	mei3",
		"鎏", "	liu2",
		"鎁", "	ye2",
		"鎀", "	xiu1",
		"鍿", "	zi1",
		"鍾", "	zhong1",
		"鍽", "	bian1",
		"鍼", "	zhen1",
		"鍻", "	jie2",
		"鍺", "	duo3",
		"鍹", "	xuan1",
		"鍸", "	hu2",
		"鎎", "	kai4",
		"鎐", "	yao2",
		"鎨", "	sun3",
		"鎝", "	da1",
		"鎧", "	kai3",
		"鎦", "	liu2",
		"鎥", "	tiao2",
		"鎤", "	huang4",
		"鎣", "	ying2",
		"鎢", "	wu1",
		"鎡", "	zi1",
		"鎠", "	gang1",
		"鎟", "	sang3",
		"鎞", "	bi1",
		"鎜", "	pan2",
		"鎑", "	ye4",
		"鎛", "	bo2",
		"鎚", "	chui2",
		"鎙", "	shuo4",
		"鎘", "	li4",
		"鎗", "	qiang1",
		"鎖", "	suo3",
		"鎕", "	tang2",
		"鎔", "	rong2",
		"鎓", "	weng1",
		"鎒", "	nou4",
		"鏜", "	tang1",
		"鏞", "	yong1",
		"鍶", "	song1",
		"鐟", "	zan1",
		"鐩", "	sui4",
		"鐨", "	fei4",
		"鐧", "	jian1",
		"鐦", "	kai1",
		"鐥", "	shan4",
		"鐤", "	ding3",
		"鐣", "	zhang",
		"鐢", "	fan2",
		"鐡", "	tie3",
		"鐠", "	pu3",
		"鐞", "	nou4",
		"鐫", "	juan1",
		"鐝", "	jue2",
		"鐜", "	dui1",
		"鐛", "	ying4",
		"鐚", "	ya1",
		"鐙", "	deng4",
		"鐘", "	zhong1",
		"鐗", "	jian3",
		"鐖", "	ji1",
		"鐕", "	zan1",
		"鐔", "	xin2",
		"鐪", "	lu3",
		"鐬", "	hui4",
		"鐒", "	lao2",
		"鐹", "	guo3",
		"鑃", "	diao4",
		"鑂", "	xun4",
		"鑁", "	zong1",
		"鑀", "	ai4",
		"鐿", "	yi4",
		"鐾", "	bei4",
		"鐽", "	da2",
		"鐼", "	fen2",
		"鐻", "	ju4",
		"鐺", "	dang1",
		"鐸", "	duo2",
		"鐭", "	yu4",
		"鐷", "	ye4",
		"鐶", "	huan2",
		"鐵", "	tie3",
		"鐴", "	bi4",
		"鐳", "	lei2",
		"鐲", "	zhuo2",
		"鐱", "	jian4",
		"鐰", "	qiao1",
		"鐯", "	zhuo2",
		"鐮", "	lian2",
		"鐓", "	dui4",
		"鐑", "	qie4",
		"鏟", "	chan3",
		"鏫", "	li2",
		"鏵", "	hua2",
		"鏴", "	lu4",
		"鏳", "	cheng1",
		"鏲", "	qian",
		"鏱", "	zhang",
		"鏰", "	beng4",
		"鏯", "	shuang",
		"鏮", "	kang1",
		"鏭", "	xi1",
		"鏬", "	xia4",
		"鏪", "	cao2",
		"鏷", "	pu2",
		"鏩", "	jian4",
		"鏨", "	zan4",
		"鏧", "	long2",
		"鏦", "	cong1",
		"鏥", "	xiu4",
		"鏤", "	lou4",
		"鏣", "	shu4",
		"鏢", "	biao1",
		"鏡", "	jing4",
		"鏠", "	feng1",
		"鏶", "	ji2",
		"鏸", "	hui4",
		"鐐", "	liao2",
		"鐅", "	pie3",
		"鐏", "	zun1",
		"鐎", "	jiao1",
		"鐍", "	jue2",
		"鐌", "	xiang4",
		"鐋", "	tang1",
		"鐊", "	yang2",
		"鐉", "	quan1",
		"鐈", "	qiao2",
		"鐇", "	fan2",
		"鐆", "	sui4",
		"鐄", "	huang2",
		"鏹", "	qiang3",
		"鐃", "	nao2",
		"鐂", "	liu4",
		"鐁", "	si1",
		"鐀", "	kui4",
		"鏿", "	cheng1",
		"鏾", "	san3",
		"鏽", "	xiu4",
		"鏼", "	se4",
		"鏻", "	lin2",
		"鏺", "	po1",
		"鍷", "	kui2",
		"鍵", "	jian4",
		"鑅", "	heng2",
		"鋧", "	xian4",
		"鋱", "	te4",
		"鋰", "	li3",
		"鋯", "	gao4",
		"鋮", "	cheng2",
		"鋭", "	rui4",
		"鋬", "	pan4",
		"鋫", "	li2",
		"鋪", "	pu4",
		"鋩", "	mang2",
		"鋨", "	tie3",
		"鋦", "	ju1",
		"鋳", "	zhu4",
		"鋥", "	zeng4",
		"鋤", "	chu2",
		"鋣", "	ye2",
		"鋢", "	lue4",
		"鋡", "	han2",
		"鋠", "	shen4",
		"鋟", "	qin3",
		"鋞", "	xing2",
		"鋝", "	lue4",
		"鋜", "	zhuo2",
		"鋲", "	bing",
		"鋴", "	zhen",
		"鋚", "	tiao2",
		"錁", "	guo3",
		"錋", "	peng2",
		"錊", "	zui4",
		"錉", "	min2",
		"錈", "	juan3",
		"錇", "	pou2",
		"錆", "	qiang1",
		"錅", "	li2",
		"錄", "	lu4",
		"錃", "	bei1",
		"錂", "	ling2",
		"錀", "	lun2",
		"鋵", "	tu1",
		"鋿", "	chang2",
		"鋾", "	tao2",
		"鋽", "	diao4",
		"鋼", "	gang1",
		"鋻", "	jian4",
		"鋺", "	yuan3",
		"鋹", "	chang3",
		"鋸", "	ju4",
		"鋷", "	zui4",
		"鋶", "	liu3",
		"鋛", "	gong3",
		"鋙", "	yu3",
		"錍", "	pi1",
		"銳", "	rui4",
		"銽", "	gua1",
		"銼", "	cuo4",
		"銻", "	ti2",
		"銺", "	zang4",
		"銹", "	xiu4",
		"銸", "	zhe2",
		"銷", "	xiao1",
		"銶", "	qiu2",
		"銵", "	keng1",
		"銴", "	shi4",
		"銲", "	han4",
		"銿", "	zhong1",
		"銱", "	diao4",
		"銰", "	ai1",
		"銯", "	si",
		"銮", "	luan2",
		"銭", "	qian2",
		"銬", "	kao4",
		"銫", "	se4",
		"銪", "	you3",
		"銩", "	diu1",
		"銨", "	an3",
		"銾", "	hong4",
		"鋀", "	tou1",
		"鋘", "	hua2",
		"鋍", "	bo2",
		"鋗", "	xuan1",
		"鋖", "	si1",
		"鋕", "	zhi4",
		"鋔", "	wan3",
		"鋓", "	chan1",
		"鋒", "	feng1",
		"鋑", "	cuan1",
		"鋐", "	hong2",
		"鋏", "	jia2",
		"鋎", "	han4",
		"鋌", "	ding4",
		"鋁", "	lv3",
		"鋋", "	chan2",
		"鋊", "	yu4",
		"鋉", "	su4",
		"鋈", "	wu4",
		"鋇", "	bei4",
		"鋆", "	yun2",
		"鋅", "	xin1",
		"鋄", "	wan3",
		"鋃", "	lang2",
		"鋂", "	mei2",
		"錌", "	an4",
		"錎", "	xian4",
		"鍴", "	duan1",
		"鍏", "	wei2",
		"鍙", "	hu4",
		"鍘", "	zha2",
		"鍗", "	ti2",
		"鍖", "	chen3",
		"鍕", "	jun1",
		"鍔", "	e4",
		"鍓", "	ji2",
		"鍒", "	rou2",
		"鍑", "	fu4",
		"鍐", "	zong1",
		"鍎", "	tu2",
		"鍛", "	duan4",
		"鍍", "	du4",
		"鍌", "	xian3",
		"鍋", "	guo1",
		"鍊", "	lian4",
		"鍉", "	di1",
		"鍈", "	ying1",
		"鍇", "	kai3",
		"鍆", "	men2",
		"鍅", "	fa",
		"鍄", "	liang4",
		"鍚", "	yang2",
		"鍜", "	xia2",
		"鍂", "	pian1",
		"鍩", "	tian3",
		"鍳", "	jian4",
		"鍲", "	min2",
		"鍱", "	ye4",
		"鍰", "	huan2",
		"鍯", "	cong1",
		"鍮", "	tou1",
		"鍭", "	hou2",
		"鍬", "	qiao1",
		"鍫", "	qiao1",
		"鍪", "	mou2",
		"鍨", "	kui2",
		"鍝", "	yu2",
		"鍧", "	hong1",
		"鍦", "	shi1",
		"鍥", "	qie4",
		"鍤", "	cha1",
		"鍣", "	zhao1",
		"鍢", "	fu4",
		"鍡", "	wei3",
		"鍠", "	huang2",
		"鍟", "	xing1",
		"鍞", "	keng1",
		"鍃", "	huo1",
		"鍁", "	xian1",
		"錏", "	ya1",
		"錛", "	ben1",
		"錥", "	yu4",
		"錤", "	ji1",
		"錣", "	zhui4",
		"錢", "	qian2",
		"錡", "	qi2",
		"錠", "	ding4",
		"錟", "	tan2",
		"錞", "	chun2",
		"錝", "	zong4",
		"錜", "	nie4",
		"錚", "	zheng1",
		"錧", "	guan3",
		"錙", "	zi1",
		"錘", "	chui2",
		"錗", "	nei4",
		"錖", "	du2",
		"錕", "	kun1",
		"錔", "	ta4",
		"錓", "	kong1",
		"錒", "	ke1",
		"錑", "	lei4",
		"錐", "	zhui1",
		"錦", "	jin3",
		"錨", "	mao2",
		"鍀", "	de2",
		"錵", "	hua1",
		"錿", "	hu",
		"錾", "	zan4",
		"錽", "	wan4",
		"錼", "	nai4",
		"錻", "	wu",
		"錺", "	fang",
		"錹", "	ken3",
		"錸", "	lai2",
		"錷", "	ga2",
		"錶", "	biao3",
		"錴", "	lu4",
		"錩", "	chang1",
		"錳", "	meng3",
		"録", "	lu4",
		"錱", "	zhen1",
		"錰", "	shu4",
		"錯", "	cuo4",
		"錮", "	gu4",
		"錭", "	tao2",
		"錬", "	lian4",
		"錫", "	xi1",
		"錪", "	tian3",
		"鑄", "	zhu4",
		"鑆", "	zhui4",
		"闥", "	ta4",
		"镘", "	man4",
		"镢", "	jue2",
		"镡", "	chan2",
		"镠", "	liu2",
		"镟", "	xuan4",
		"镞", "	zu2",
		"镝", "	di1",
		"镜", "	jing4",
		"镛", "	yong1",
		"镚", "	beng4",
		"镙", "	luo2",
		"镗", "	tang1",
		"镤", "	pu2",
		"镖", "	biao1",
		"镕", "	rong2",
		"镔", "	bin1",
		"镓", "	jia1",
		"镒", "	yi4",
		"镑", "	bang4",
		"镐", "	gao3",
		"镏", "	liu2",
		"镎", "	na2",
		"镍", "	nie4",
		"镣", "	liao4",
		"镥", "	lu3",
		"镋", "	tang3",
		"镲", "	cha3",
		"镼", "	qu1",
		"镻", "	die2",
		"镺", "	ao3",
		"镹", "	jiu3",
		"镸", "	chang2",
		"長", "	zhang3",
		"镶", "	xiang1",
		"镵", "	chan2",
		"镴", "	la4",
		"镳", "	biao1",
		"镱", "	yi4",
		"镦", "	dui4",
		"镰", "	lian2",
		"镯", "	zhuo2",
		"镮", "	huan2",
		"镭", "	lei2",
		"镬", "	huo4",
		"镫", "	deng4",
		"镪", "	qiang1",
		"镩", "	cuan1",
		"镨", "	pu3",
		"镧", "	lan2",
		"镌", "	juan1",
		"镊", "	nie4",
		"镾", "	mi2",
		"锤", "	chui2",
		"键", "	jian4",
		"锭", "	ding4",
		"锬", "	tan2",
		"锫", "	pei2",
		"锪", "	huo1",
		"锩", "	juan3",
		"锨", "	xian1",
		"锧", "	zhi4",
		"锦", "	jin3",
		"锥", "	zhui1",
		"锣", "	luo2",
		"锰", "	meng3",
		"锢", "	gu4",
		"锡", "	xi1",
		"锠", "	chang1",
		"锟", "	kun1",
		"锞", "	ke4",
		"锝", "	de2",
		"锜", "	qi2",
		"锛", "	ben1",
		"锚", "	mao2",
		"错", "	cuo4",
		"锯", "	ju4",
		"锱", "	zi1",
		"镉", "	ge2",
		"锾", "	huan2",
		"镈", "	bo2",
		"镇", "	zhen4",
		"镆", "	mo4",
		"镅", "	mei2",
		"镄", "	fei4",
		"镃", "	zi1",
		"镂", "	lou4",
		"镁", "	mei3",
		"镀", "	du4",
		"锿", "	ai1",
		"锽", "	huang2",
		"锲", "	qie4",
		"锼", "	sou1",
		"锻", "	duan4",
		"锺", "	zhong1",
		"锹", "	qiao1",
		"锸", "	cha1",
		"锷", "	e4",
		"锶", "	si1",
		"锵", "	qiang1",
		"锴", "	kai3",
		"锳", "	ying1",
		"镽", "	liao3",
		"长", "	zhang3",
		"锗", "	zhe3",
		"闀", "	xiang4",
		"闊", "	kuo4",
		"闉", "	yin1",
		"闈", "	wei2",
		"闇", "	an4",
		"闆", "	ban3",
		"闅", "	wen2",
		"闄", "	yao3",
		"闃", "	qu4",
		"闂", "	hong4",
		"闁", "	bao1",
		"閿", "	wen2",
		"闌", "	lan2",
		"閾", "	yu4",
		"閽", "	hun1",
		"閼", "	e4",
		"閻", "	yan2",
		"閺", "	wen2",
		"閹", "	yan1",
		"閸", "	kun3",
		"閷", "	shai4",
		"閶", "	chang1",
		"閵", "	lin4",
		"闋", "	que4",
		"闍", "	du1",
		"閳", "	chan3",
		"闚", "	kui1",
		"闤", "	huan2",
		"闣", "	dang4",
		"闢", "	pi4",
		"闡", "	chan3",
		"闠", "	hui4",
		"闟", "	xi4",
		"闞", "	kan4",
		"闝", "	piao2",
		"關", "	guan1",
		"闛", "	tang2",
		"闙", "	qi3",
		"闎", "	quan",
		"闘", "	dou4",
		"闗", "	guan1",
		"闖", "	chuang3",
		"闕", "	que4",
		"闔", "	he2",
		"闓", "	kai3",
		"闒", "	ta4",
		"闑", "	nie4",
		"闐", "	tian2",
		"闏", "	feng1",
		"閴", "	qu4",
		"閲", "	yue4",
		"門", "	men2",
		"閌", "	kang4",
		"閖", "	shui",
		"閕", "	xia1",
		"閔", "	min3",
		"間", "	jian1",
		"閒", "	xian2",
		"閑", "	xian2",
		"閐", "	san4",
		"閏", "	run4",
		"閎", "	hong2",
		"閍", "	beng1",
		"開", "	kai1",
		"閘", "	zha2",
		"閊", "	shan",
		"閉", "	bi4",
		"閈", "	han4",
		"閇", "	bi4",
		"閆", "	yan2",
		"閅", "	men2",
		"閄", "	huo4",
		"閃", "	shan3",
		"閂", "	shuan1",
		"閁", "	ma4",
		"閗", "	dou4",
		"閙", "	nao4",
		"閱", "	yue4",
		"閦", "	chu4",
		"閰", "	ju2",
		"閯", "	sha4",
		"閮", "	ting2",
		"閭", "	lv2",
		"閬", "	lang4",
		"閫", "	kun3",
		"閪", "	se1",
		"閩", "	min3",
		"閨", "	gui1",
		"閧", "	hong4",
		"閥", "	fa2",
		"閚", "	zhan1",
		"閤", "	ge2",
		"閣", "	ge2",
		"関", "	guan1",
		"閡", "	ai4",
		"閠", "	run4",
		"閟", "	bi4",
		"閞", "	bian4",
		"閝", "	ling2",
		"閜", "	xia3",
		"閛", "	peng1",
		"锘", "	nuo4",
		"锖", "	qiang1",
		"鑇", "	ji1",
		"钇", "	yi3",
		"钑", "	ji2",
		"钐", "	shan1",
		"钏", "	chuan4",
		"钎", "	qian1",
		"钍", "	tu3",
		"钌", "	liao3",
		"钋", "	po1",
		"钊", "	zhao1",
		"钉", "	ding1",
		"针", "	zhen1",
		"钆", "	ga2",
		"钓", "	diao4",
		"钅", "	jin1",
		"钄", "	lan2",
		"钃", "	shu3",
		"钂", "	tang3",
		"钁", "	jue2",
		"钀", "	nie4",
		"鑿", "	zao2",
		"鑾", "	luan2",
		"鑽", "	zuan1",
		"鑼", "	luo2",
		"钒", "	fan2",
		"钔", "	men2",
		"鑺", "	qu2",
		"钡", "	bei4",
		"钫", "	fang1",
		"钪", "	kang4",
		"钩", "	gou1",
		"钨", "	wu1",
		"钧", "	jun1",
		"钦", "	qin1",
		"钥", "	yao4",
		"钤", "	qian2",
		"钣", "	ban3",
		"钢", "	gang1",
		"钠", "	na4",
		"钕", "	nv3",
		"钟", "	zhong1",
		"钞", "	chao1",
		"钝", "	dun4",
		"钜", "	ju4",
		"钛", "	tai4",
		"钚", "	bu4",
		"钙", "	gai4",
		"钘", "	xing2",
		"钗", "	chai1",
		"钖", "	yang2",
		"鑻", "	pan4",
		"鑹", "	cuan1",
		"钭", "	tou3",
		"鑓", "	qian",
		"鑝", "	peng2",
		"鑜", "	shang3",
		"鑛", "	kuang4",
		"鑚", "	zuan4",
		"鑙", "	ji1",
		"鑘", "	lei2",
		"鑗", "	li2",
		"鑖", "	mie4",
		"鑕", "	zhi4",
		"鑔", "	cha3",
		"鑒", "	jian4",
		"鑟", "	du2",
		"鑑", "	jian4",
		"鑐", "	xu1",
		"鑏", "	ning2",
		"鑎", "	kui4",
		"鑍", "	ying1",
		"鑌", "	bin1",
		"鑋", "	qing1",
		"鑊", "	huo4",
		"鑉", "	he2",
		"鑈", "	nie4",
		"鑞", "	la4",
		"鑠", "	shuo4",
		"鑸", "	lei3",
		"鑭", "	lan4",
		"鑷", "	nie4",
		"鑶", "	cang2",
		"鑵", "	guan4",
		"鑴", "	xi1",
		"鑳", "	jian4",
		"鑲", "	xiang1",
		"鑱", "	chan2",
		"鑰", "	yao4",
		"鑯", "	jian1",
		"鑮", "	bo2",
		"鑬", "	jian4",
		"鑡", "	chuo4",
		"鑫", "	xin1",
		"鑪", "	lu2",
		"鑩", "	e4",
		"鑨", "	long2",
		"鑧", "	kuan",
		"鑦", "	xian",
		"鑥", "	lu3",
		"鑤", "	bao4",
		"鑣", "	biao1",
		"鑢", "	lv4",
		"钬", "	huo3",
		"钮", "	niu3",
		"锕", "	a1",
		"铰", "	jiao3",
		"铺", "	pu4",
		"铹", "	lao2",
		"铸", "	zhu4",
		"铷", "	ru2",
		"银", "	yin2",
		"铵", "	an3",
		"铴", "	tang1",
		"铳", "	chong4",
		"铲", "	chan3",
		"铱", "	yi1",
		"铯", "	se4",
		"铼", "	lai2",
		"铮", "	zheng1",
		"铭", "	ming2",
		"铬", "	ge4",
		"铫", "	diao4",
		"铪", "	ha1",
		"铩", "	sha1",
		"铨", "	quan2",
		"铧", "	hua2",
		"铦", "	xian1",
		"铥", "	diu1",
		"铻", "	wu2",
		"铽", "	te4",
		"铣", "	xi3",
		"锊", "	lue4",
		"锔", "	ju1",
		"锓", "	qin3",
		"锒", "	lang2",
		"锑", "	ti1",
		"锐", "	rui4",
		"锏", "	jian3",
		"锎", "	kai1",
		"锍", "	liu3",
		"锌", "	xin1",
		"锋", "	feng1",
		"锉", "	cuo4",
		"链", "	lian4",
		"锈", "	xiu4",
		"锇", "	e2",
		"锆", "	gao4",
		"锅", "	guo1",
		"锄", "	chu2",
		"锃", "	zeng4",
		"锂", "	li3",
		"锁", "	suo3",
		"销", "	xiao1",
		"铿", "	keng1",
		"铤", "	ding4",
		"铢", "	zhu1",
		"钯", "	ba3",
		"钻", "	zuan1",
		"铅", "	qian1",
		"铄", "	shuo4",
		"铃", "	ling2",
		"铂", "	bo2",
		"铁", "	tie3",
		"铀", "	you2",
		"钿", "	dian4",
		"钾", "	jia3",
		"钽", "	tan3",
		"钼", "	mu4",
		"钺", "	yue4",
		"铇", "	bao4",
		"钹", "	bo2",
		"钸", "	bu4",
		"钷", "	po3",
		"钶", "	e1",
		"钵", "	bo1",
		"钴", "	gu3",
		"钳", "	qian2",
		"钲", "	zheng1",
		"钱", "	qian2",
		"钰", "	yu4",
		"铆", "	mao3",
		"铈", "	shi4",
		"铡", "	zha2",
		"铖", "	cheng2",
		"铠", "	kai3",
		"铟", "	yin1",
		"铞", "	diao4",
		"铝", "	lv3",
		"铜", "	tong2",
		"铛", "	dang1",
		"铚", "	zhi4",
		"铙", "	nao2",
		"铘", "	ye2",
		"铗", "	jia2",
		"铕", "	you3",
		"铉", "	xuan4",
		"铔", "	ya4",
		"铓", "	mang2",
		"铒", "	er3",
		"铑", "	lao3",
		"铐", "	kao4",
		"铏", "	xing2",
		"铎", "	duo2",
		"铍", "	pi1",
		"铌", "	ni2",
		"铋", "	bi4",
		"铊", "	ta1",
		"餥", "	fei1",
		"餧", "	wei4",
		"銦", "	yin1",
		"鵹", "	li2",
		"鶃", "	yi4",
		"鶂", "	yi4",
		"鶁", "	jing1",
		"鶀", "	qi2",
		"鵿", "	sheng1",
		"鵾", "	kun1",
		"鵽", "	duo4",
		"鵼", "	kong1",
		"鵻", "	zhui1",
		"鵺", "	ye4",
		"鵸", "	qi2",
		"鶅", "	zi1",
		"鵷", "	yuan1",
		"鵶", "	ya1",
		"鵵", "	tu4",
		"鵴", "	ju2",
		"鵳", "	jian1",
		"鵲", "	que4",
		"鵱", "	lu4",
		"鵰", "	diao1",
		"鵯", "	bei1",
		"鵮", "	qian1",
		"鶄", "	jing1",
		"鶆", "	lai2",
		"鵬", "	peng2",
		"鶓", "	miao2",
		"鶝", "	fu2",
		"鶜", "	mao2",
		"鶛", "	jie1",
		"鶚", "	e4",
		"鶙", "	ti2",
		"鶘", "	hu2",
		"鶗", "	ti2",
		"鶖", "	qiu1",
		"鶕", "	an1",
		"鶔", "	rou2",
		"鶒", "	chi4",
		"鶇", "	dong1",
		"鶑", "	ying1",
		"鶐", "	shu4",
		"鶏", "	ji1",
		"鶎", "	zun",
		"鶍", "	yi",
		"鶌", "	jue2",
		"鶋", "	ju1",
		"鶊", "	geng1",
		"鶉", "	chun2",
		"鶈", "	qi1",
		"鵭", "	qin2",
		"鵫", "	zhuo2",
		"鶟", "	tu2",
		"鵅", "	luo4",
		"鵏", "	bu3",
		"鵎", "	tuo3",
		"鵍", "	huan1",
		"鵌", "	tu2",
		"鵋", "	ji4",
		"鵊", "	jia2",
		"鵉", "	luan2",
		"鵈", "	e3",
		"鵇", "	nian",
		"鵆", "	heng",
		"鵄", "	zhi1",
		"鵑", "	juan1",
		"鵃", "	zhou1",
		"鵂", "	xiu1",
		"鵁", "	jiao1",
		"鵀", "	ren2",
		"鴿", "	ge1",
		"鴾", "	mou2",
		"鴽", "	ru2",
		"鴼", "	luo4",
		"鴻", "	hong2",
		"鴺", "	ti2",
		"鵐", "	wu2",
		"鵒", "	yu4",
		"鵪", "	an1",
		"鵟", "	kuang2",
		"鵩", "	fu2",
		"鵨", "	shu1",
		"鵧", "	pi2",
		"鵦", "	lu4",
		"鵥", "	pan",
		"鵤", "	jiao",
		"鵣", "	lai4",
		"鵢", "	shen1",
		"鵡", "	wu3",
		"鵠", "	hu2",
		"鵞", "	e2",
		"鵓", "	bo2",
		"鵝", "	e2",
		"鵜", "	ti2",
		"鵛", "	jing1",
		"鵚", "	tu1",
		"鵙", "	ju2",
		"鵘", "	jun4",
		"鵗", "	xi1",
		"鵖", "	bi1",
		"鵕", "	xun4",
		"鵔", "	jun4",
		"鶞", "	chun1",
		"鶠", "	yan3",
		"鴸", "	zhu1",
		"鷡", "	wu2",
		"鷫", "	su4",
		"鷪", "	ying1",
		"鷩", "	bi4",
		"鷨", "	hua2",
		"鷧", "	yi4",
		"鷦", "	jiao1",
		"鷥", "	si1",
		"鷤", "	ti2",
		"鷣", "	yin2",
		"鷢", "	jue2",
		"鷠", "	yu2",
		"鷭", "	fan2",
		"鷟", "	zhuo2",
		"鷞", "	shuang1",
		"鷝", "	bi4",
		"鷜", "	lv2",
		"鷛", "	yong1",
		"鷚", "	liu4",
		"鷙", "	zhi4",
		"鷘", "	chi4",
		"鷗", "	ou1",
		"鷖", "	yi1",
		"鷬", "	huang2",
		"鷮", "	jiao1",
		"鷔", "	ao2",
		"鷻", "	tuan2",
		"鸅", "	ze2",
		"鸄", "	ji1",
		"鸃", "	yi2",
		"鸂", "	xi1",
		"鸁", "	luo2",
		"鸀", "	chu3",
		"鷿", "	pi4",
		"鷾", "	yi4",
		"鷽", "	xue2",
		"鷼", "	xian2",
		"鷺", "	lu4",
		"鷯", "	liao2",
		"鷹", "	ying1",
		"鷸", "	yu4",
		"鷷", "	zun1",
		"鷶", "	mai3",
		"鷵", "	tu2",
		"鷴", "	xian2",
		"鷳", "	xian2",
		"鷲", "	jiu4",
		"鷱", "	gao1",
		"鷰", "	yan4",
		"鷕", "	yao3",
		"鷓", "	zhe4",
		"鶡", "	he2",
		"鶭", "	fang3",
		"鶷", "	xia2",
		"鶶", "	tang2",
		"鶵", "	chu2",
		"鶴", "	he4",
		"鶳", "	shi1",
		"鶲", "	weng1",
		"鶱", "	xian1",
		"鶰", "	yuan2",
		"鶯", "	ying1",
		"鶮", "	he4",
		"鶬", "	cang1",
		"鶹", "	liu2",
		"鶫", "	dong",
		"鶪", "	ju2",
		"鶩", "	wu4",
		"鶨", "	chuan4",
		"鶧", "	ying1",
		"鶦", "	hu2",
		"鶥", "	mei2",
		"鶤", "	kun1",
		"鶣", "	pian1",
		"鶢", "	yuan2",
		"鶸", "	ruo4",
		"鶺", "	ji2",
		"鷒", "	tuan2",
		"鷇", "	kou4",
		"鷑", "	ji2",
		"鷐", "	chen2",
		"鷏", "	tian2",
		"鷎", "	gao1",
		"鷍", "	jiao1",
		"鷌", "	ma3",
		"鷋", "	tu2",
		"鷊", "	yi4",
		"鷉", "	ti1",
		"鷈", "	ti1",
		"鷆", "	tian2",
		"鶻", "	gu2",
		"鷅", "	li4",
		"鷄", "	ji1",
		"鷃", "	yan4",
		"鷂", "	yao4",
		"鷁", "	yi4",
		"鷀", "	ci2",
		"鶿", "	ci2",
		"鶾", "	han4",
		"鶽", "	sun3",
		"鶼", "	jian1",
		"鴹", "	yang2",
		"鴷", "	lie4",
		"鸇", "	zhan1",
		"鲩", "	huan4",
		"鲳", "	chang1",
		"鲲", "	kun1",
		"鲱", "	fei1",
		"鲰", "	zou1",
		"鲯", "	qi2",
		"鲮", "	ling2",
		"鲭", "	qing1",
		"鲬", "	yong3",
		"鲫", "	ji4",
		"鲪", "	jun1",
		"鲨", "	sha1",
		"鲵", "	ni2",
		"鲧", "	gun3",
		"鲦", "	tiao2",
		"鲥", "	shi2",
		"鲤", "	li3",
		"鲣", "	jian1",
		"鲢", "	lian2",
		"鲡", "	li2",
		"鲠", "	geng3",
		"鲟", "	xun2",
		"鲞", "	xiang3",
		"鲴", "	gu4",
		"鲶", "	nian2",
		"鲜", "	xian1",
		"鳃", "	sai1",
		"鳍", "	qi2",
		"鳌", "	ao2",
		"鳋", "	sao1",
		"鳊", "	bian1",
		"鳉", "	jiang1",
		"鳈", "	quan2",
		"鳇", "	huang2",
		"鳆", "	fu4",
		"鳅", "	qiu1",
		"鳄", "	e4",
		"鳂", "	wei1",
		"鲷", "	diao1",
		"鳁", "	wen1",
		"鳀", "	ti2",
		"鲿", "	chang2",
		"鲾", "	bi1",
		"鲽", "	die2",
		"鲼", "	fen4",
		"鲻", "	zi1",
		"鲺", "	shi1",
		"鲹", "	shen1",
		"鲸", "	jing1",
		"鲝", "	zha3",
		"鲛", "	jiao1",
		"鳏", "	guan1",
		"鱵", "	zhen1",
		"鱿", "	you2",
		"鱾", "	ji3",
		"鱽", "	dao1",
		"鱼", "	yu2",
		"鱻", "	xian1",
		"鱺", "	li2",
		"鱹", "	guan4",
		"鱸", "	lu2",
		"鱷", "	e4",
		"鱶", "	xiang3",
		"鱴", "	mie4",
		"鲁", "	lu3",
		"鱳", "	li4",
		"鱲", "	lie4",
		"鱱", "	li4",
		"鱰", "	shu",
		"鱯", "	hu4",
		"鱮", "	xu4",
		"鱭", "	ji4",
		"鱬", "	ru2",
		"鱫", "	ai",
		"鱪", "	shu",
		"鲀", "	tun2",
		"鲂", "	fang2",
		"鲚", "	ji4",
		"鲏", "	pi2",
		"鲙", "	kuai4",
		"鲘", "	hou4",
		"鲗", "	zei2",
		"鲖", "	tong2",
		"鲕", "	er2",
		"鲔", "	wei3",
		"鲓", "	kao3",
		"鲒", "	jie2",
		"鲑", "	gui1",
		"鲐", "	tai2",
		"鲎", "	hou4",
		"鲃", "	ba1",
		"鲍", "	bao4",
		"鲌", "	ba4",
		"鲋", "	fu4",
		"鲊", "	zha3",
		"鲉", "	you2",
		"鲈", "	lu2",
		"鲇", "	nian2",
		"鲆", "	ping2",
		"鲅", "	ba4",
		"鲄", "	he2",
		"鳎", "	ta3",
		"鳐", "	yao2",
		"鴶", "	jia2",
		"鴑", "	ru2",
		"鴛", "	yuan1",
		"鴚", "	ge1",
		"鴙", "	zhi4",
		"鴘", "	bian3",
		"鴗", "	li4",
		"鴖", "	min2",
		"鴕", "	tuo2",
		"鴔", "	fu2",
		"鴓", "	mie4",
		"鴒", "	ling2",
		"鴐", "	ge1",
		"鴝", "	qu2",
		"鴏", "	dai4",
		"鴎", "	ou1",
		"鴍", "	wen2",
		"鴌", "	feng4",
		"鴋", "	fang1",
		"鴊", "	zheng4",
		"鴉", "	ya1",
		"鴈", "	yan4",
		"鴇", "	bao3",
		"鴆", "	zhen4",
		"鴜", "	ci2",
		"鴞", "	xiao1",
		"鴄", "	pi3",
		"鴫", "	tian",
		"鴵", "	xiao1",
		"鴴", "	heng2",
		"鴳", "	yan4",
		"鴲", "	zhi1",
		"鴱", "	ai4",
		"鴰", "	gua1",
		"鴯", "	er2",
		"鴮", "	wu1",
		"鴭", "	dui1",
		"鴬", "	ying1",
		"鴪", "	yu4",
		"鴟", "	chi1",
		"鴩", "	tie3",
		"鴨", "	ya1",
		"鴧", "	rong4",
		"鴦", "	yang1",
		"鴥", "	yu4",
		"鴤", "	dong1",
		"鴣", "	gu1",
		"鴢", "	yao3",
		"鴡", "	ju1",
		"鴠", "	dan4",
		"鴅", "	huan1",
		"鴃", "	jue2",
		"鳑", "	pang2",
		"鳝", "	shan4",
		"鳧", "	fu2",
		"鳦", "	yi3",
		"鳥", "	niao3",
		"鳤", "	guan3",
		"鳣", "	zhan1",
		"鳢", "	li3",
		"鳡", "	gan3",
		"鳠", "	hu4",
		"鳟", "	zun1",
		"鳞", "	lin2",
		"鳜", "	gui4",
		"鳩", "	jiu1",
		"鳛", "	xi2",
		"鳚", "	wei4",
		"鳙", "	yong1",
		"鳘", "	min3",
		"鳗", "	man2",
		"鳖", "	bie1",
		"鳕", "	xue3",
		"鳔", "	biao4",
		"鳓", "	le4",
		"鳒", "	jian1",
		"鳨", "	li4",
		"鳪", "	bu2",
		"鴂", "	jue2",
		"鳷", "	zhi1",
		"鴁", "	yao1",
		"鴀", "	fou3",
		"鳿", "	yu4",
		"鳾", "	shi1",
		"鳽", "	jian1",
		"鳼", "	wen2",
		"鳻", "	ban1",
		"鳺", "	fu1",
		"鳹", "	qin2",
		"鳸", "	hu4",
		"鳶", "	yuan1",
		"鳫", "	yan4",
		"鳵", "	bao3",
		"鳴", "	ming2",
		"鳳", "	feng4",
		"鳲", "	shi1",
		"鳱", "	gan1",
		"鳰", "	ru",
		"鳯", "	feng4",
		"鳮", "	ji1",
		"鳭", "	diao1",
		"鳬", "	fu3",
		"鸆", "	yu2",
		"鸈", "	ye4",
		"鱨", "	chang2",
		"鼚", "	chang1",
		"鼤", "	wen2",
		"鼣", "	fei4",
		"鼢", "	fen2",
		"鼡", "	shu3",
		"鼠", "	shu3",
		"鼟", "	teng1",
		"鼞", "	tang1",
		"鼝", "	yuan1",
		"鼜", "	qi4",
		"鼛", "	gao1",
		"鼙", "	pi2",
		"鼦", "	diao1",
		"鼘", "	yuan1",
		"鼗", "	tao2",
		"鼖", "	fen2",
		"鼕", "	dong1",
		"鼔", "	gu3",
		"鼓", "	gu3",
		"鼒", "	zi1",
		"鼑", "	ding3",
		"鼐", "	nai4",
		"鼏", "	mi4",
		"鼥", "	ba2",
		"鼧", "	tuo2",
		"鼍", "	tuo2",
		"鼴", "	yan3",
		"鼾", "	han1",
		"鼽", "	qiu2",
		"鼼", "	yao3",
		"鼻", "	bi2",
		"鼺", "	lei2",
		"鼹", "	yan3",
		"鼸", "	xian4",
		"鼷", "	xi1",
		"鼶", "	si1",
		"鼵", "	tu1",
		"鼳", "	ju2",
		"鼨", "	zhong1",
		"鼲", "	hun2",
		"鼱", "	jing1",
		"鼰", "	nian4",
		"鼯", "	wu2",
		"鼮", "	ting2",
		"鼭", "	shi2",
		"鼬", "	you4",
		"鼫", "	shi2",
		"鼪", "	sheng1",
		"鼩", "	qu2",
		"鼎", "	ding3",
		"鼌", "	chao2",
		"齀", "	wu4",
		"黦", "	yue4",
		"黰", "	zhen3",
		"黯", "	an4",
		"黮", "	dan3",
		"黭", "	yan3",
		"黬", "	yan2",
		"黫", "	yan1",
		"黪", "	can3",
		"黩", "	du2",
		"黨", "	dang3",
		"黧", "	li2",
		"黥", "	qing2",
		"黲", "	can3",
		"黤", "	yan3",
		"黣", "	mei3",
		"黢", "	qu1",
		"黡", "	yan3",
		"黠", "	xia2",
		"黟", "	yi1",
		"點", "	dian3",
		"黝", "	you3",
		"黜", "	chu4",
		"黛", "	dai4",
		"黱", "	dai4",
		"黳", "	yi1",
		"鼋", "	yuan2",
		"鼀", "	cu4",
		"鼊", "	bi4",
		"鼉", "	tuo2",
		"鼈", "	bie1",
		"鼇", "	ao2",
		"鼆", "	meng2",
		"鼅", "	zhi1",
		"鼄", "	zhu1",
		"鼃", "	wa1",
		"鼂", "	chao2",
		"鼁", "	qu4",
		"黿", "	yuan2",
		"黴", "	mei2",
		"黾", "	mian3",
		"黽", "	mian3",
		"黼", "	fu3",
		"黻", "	fu2",
		"黺", "	fen3",
		"黹", "	zhi3",
		"黸", "	lu2",
		"黷", "	du2",
		"黶", "	yan3",
		"黵", "	zhan3",
		"鼿", "	wu4",
		"齁", "	hou1",
		"黙", "	mo4",
		"龂", "	yin2",
		"龌", "	wo4",
		"龋", "	qu3",
		"龊", "	chuo4",
		"龉", "	yu3",
		"龈", "	ken3",
		"龇", "	zi1",
		"龆", "	tiao2",
		"龅", "	bao1",
		"龄", "	ling2",
		"龃", "	ju3",
		"龁", "	he2",
		"龎", "	pang2",
		"龀", "	chen4",
		"齿", "	chi3",
		"齾", "	ya4",
		"齽", "	jin4",
		"齼", "	chu3",
		"齻", "	dian1",
		"齺", "	zou1",
		"齹", "	ci1",
		"齸", "	yi4",
		"齷", "	wo4",
		"龍", "	long2",
		"龏", "	gong1",
		"齵", "	ou2",
		"龜", "	gui1",
		"鿃", "	shan3",
		"龥", "	yu4",
		"龤", "	xie2",
		"龣", "	jue2",
		"龢", "	he2",
		"龡", "	chui4",
		"龠", "	yue4",
		"龟", "	gui1",
		"龞", "	bie1",
		"龝", "	qiu1",
		"龛", "	kan1",
		"龐", "	pang2",
		"龚", "	gong1",
		"龙", "	long2",
		"龘", "	da2",
		"龗", "	ling2",
		"龖", "	da2",
		"龕", "	kan1",
		"龔", "	gong1",
		"龓", "	long3",
		"龒", "	long2",
		"龑", "	yan3",
		"齶", "	e4",
		"齴", "	yan3",
		"齂", "	xie4",
		"齎", "	ji1",
		"齘", "	xie4",
		"齗", "	yin2",
		"齖", "	ya2",
		"齕", "	he2",
		"齔", "	chen4",
		"齓", "	chen4",
		"齒", "	chi3",
		"齑", "	ji1",
		"齐", "	qi2",
		"齏", "	ji1",
		"齍", "	zi1",
		"齚", "	ze2",
		"齌", "	ji4",
		"齋", "	zhai1",
		"齊", "	qi2",
		"齉", "	nang4",
		"齈", "	nong4",
		"齇", "	zha1",
		"齆", "	weng4",
		"齅", "	xiu4",
		"齄", "	zha1",
		"齃", "	e4",
		"齙", "	bao1",
		"齛", "	xie4",
		"齳", "	yun3",
		"齨", "	jiu4",
		"齲", "	qu3",
		"齱", "	zou1",
		"齰", "	ze2",
		"齯", "	ni2",
		"齮", "	yi3",
		"齭", "	chu3",
		"齬", "	yu3",
		"齫", "	kun3",
		"齪", "	chuo4",
		"齩", "	yao3",
		"齧", "	nie4",
		"齜", "	chai2",
		"齦", "	ken3",
		"齥", "	xie4",
		"齤", "	quan2",
		"齣", "	chu1",
		"齢", "	ling2",
		"齡", "	ling2",
		"齠", "	tiao2",
		"齟", "	ju3",
		"齞", "	yan3",
		"齝", "	chi1",
		"黚", "	qian2",
		"默", "	mo4",
		"鸉", "	yang2",
		"鹉", "	wu3",
		"鹓", "	yuan1",
		"鹒", "	geng1",
		"鹑", "	chun2",
		"鹐", "	qian1",
		"鹏", "	peng2",
		"鹎", "	bei1",
		"鹍", "	kun1",
		"鹌", "	an1",
		"鹋", "	miao2",
		"鹊", "	que4",
		"鹈", "	ti2",
		"鹕", "	hu2",
		"鹇", "	xian2",
		"鹆", "	yu4",
		"鹅", "	e2",
		"鹄", "	gu3",
		"鹃", "	juan1",
		"鹂", "	li2",
		"鹁", "	bo2",
		"鹀", "	wu2",
		"鸿", "	hong2",
		"鸾", "	luan2",
		"鹔", "	su4",
		"鹖", "	he2",
		"鸼", "	zhou1",
		"鹣", "	jian1",
		"鹭", "	lu4",
		"鹬", "	yu4",
		"鹫", "	jiu4",
		"鹪", "	jiao1",
		"鹩", "	liao2",
		"鹨", "	liu4",
		"鹧", "	zhe4",
		"鹦", "	ying1",
		"鹥", "	yi1",
		"鹤", "	he4",
		"鹢", "	yi4",
		"鹗", "	e4",
		"鹡", "	ji2",
		"鹠", "	liu2",
		"鹟", "	weng1",
		"鹞", "	yao4",
		"鹝", "	yi4",
		"鹜", "	wu4",
		"鹛", "	mei2",
		"鹚", "	ci2",
		"鹙", "	qiu1",
		"鹘", "	gu3",
		"鸽", "	ge1",
		"鸻", "	heng2",
		"鹯", "	zhan1",
		"鸕", "	lu2",
		"鸟", "	niao3",
		"鸞", "	luan2",
		"鸝", "	li2",
		"鸜", "	qu2",
		"鸛", "	guan4",
		"鸚", "	ying1",
		"鸙", "	yue4",
		"鸘", "	shuang1",
		"鸗", "	long2",
		"鸖", "	he4",
		"鸔", "	bao4",
		"鸡", "	ji1",
		"鸓", "	lei3",
		"鸒", "	yu4",
		"鸑", "	yue4",
		"鸐", "	di2",
		"鸏", "	meng2",
		"鸎", "	ying1",
		"鸍", "	mi2",
		"鸌", "	hu4",
		"鸋", "	ning2",
		"鸊", "	pi4",
		"鸠", "	jiu1",
		"鸢", "	yuan1",
		"鸺", "	xiu1",
		"鸯", "	yang1",
		"鸹", "	gua1",
		"鸸", "	er2",
		"鸷", "	zhi4",
		"鸶", "	si1",
		"鸵", "	tuo2",
		"鸴", "	xue2",
		"鸳", "	yuan1",
		"鸲", "	qu2",
		"鸱", "	chi1",
		"鸰", "	ling2",
		"鸮", "	xiao1",
		"鸣", "	ming2",
		"鸭", "	ya1",
		"鸬", "	lu2",
		"鸫", "	dong1",
		"鸪", "	gu1",
		"鸩", "	zhen4",
		"鸨", "	bao3",
		"鸧", "	cang1",
		"鸦", "	ya1",
		"鸥", "	ou1",
		"鸤", "	shi1",
		"鹮", "	huan2",
		"鹰", "	ying1",
		"黗", "	tun1",
		"麲", "	xian4",
		"麼", "	me",
		"麻", "	ma2",
		"麺", "	mian4",
		"麹", "	qu1",
		"麸", "	fu1",
		"麷", "	feng1",
		"麶", "	chi",
		"麵", "	mian4",
		"麴", "	qu1",
		"麳", "	lai2",
		"麱", "	fu1",
		"麾", "	hui1",
		"麰", "	mou2",
		"麯", "	qu1",
		"麮", "	qu4",
		"麭", "	pao4",
		"麬", "	fu1",
		"麫", "	mian3",
		"麪", "	mian4",
		"麩", "	fu1",
		"麨", "	chao3",
		"麧", "	he2",
		"麽", "	mo2",
		"麿", "	mo",
		"麥", "	mai4",
		"黌", "	hong2",
		"黖", "	xi4",
		"黕", "	dan3",
		"黔", "	qian2",
		"黓", "	yi4",
		"黒", "	hei1",
		"黑", "	hei1",
		"黐", "	chi1",
		"黏", "	nian2",
		"黎", "	li2",
		"黍", "	shu3",
		"黋", "	kuang4",
		"黀", "	zou1",
		"黊", "	hua4",
		"黉", "	hong2",
		"黈", "	tou3",
		"黇", "	tian1",
		"黆", "	guang1",
		"黅", "	jin1",
		"黄", "	huang2",
		"黃", "	huang2",
		"黂", "	fen2",
		"黁", "	nun2",
		"麦", "	mai4",
		"麤", "	cu1",
		"鹱", "	hu4",
		"鹽", "	yan2",
		"麇", "	jun1",
		"麆", "	zhu4",
		"麅", "	pao2",
		"麄", "	cu1",
		"麃", "	pao2",
		"麂", "	ji3",
		"麁", "	cu1",
		"麀", "	you1",
		"鹿", "	lu4",
		"鹾", "	cuo2",
		"鹼", "	jian3",
		"麉", "	jian1",
		"鹻", "	jian3",
		"鹺", "	cuo2",
		"鹹", "	xian2",
		"鹸", "	jian3",
		"鹷", "	ling2",
		"鹶", "	jin1",
		"鹵", "	lu3",
		"鹴", "	shuang1",
		"鹳", "	guan4",
		"鹲", "	meng2",
		"麈", "	zhu3",
		"麊", "	mi2",
		"麣", "	yan2",
		"麘", "	xiang1",
		"麢", "	ling2",
		"麡", "	qi2",
		"麠", "	jing1",
		"麟", "	lin2",
		"麞", "	zhang1",
		"麝", "	she4",
		"麜", "	li4",
		"麛", "	mi2",
		"麚", "	jia1",
		"麙", "	xian2",
		"麗", "	li4",
		"麋", "	mi2",
		"麖", "	jing1",
		"麕", "	jun1",
		"麔", "	jiu4",
		"麓", "	lu4",
		"麒", "	qi2",
		"麑", "	ni2",
		"麐", "	lin2",
		"麏", "	jun1",
		"麎", "	chen2",
		"麍", "	liu2",
		"麌", "	yu3",
		"鱩", "	lei",
		"鱧", "	li3",
		"館", "	guan3",
		"騸", "	shan4",
		"驂", "	can1",
		"驁", "	ao4",
		"驀", "	mo4",
		"騿", "	zhang1",
		"騾", "	luo2",
		"騽", "	xi2",
		"騼", "	lu4",
		"騻", "	shuang1",
		"騺", "	zhi4",
		"騹", "	li2",
		"騷", "	sao1",
		"驄", "	cong1",
		"騶", "	zou1",
		"騵", "	yuan2",
		"騴", "	yan4",
		"騳", "	du2",
		"騲", "	cao3",
		"騱", "	xi2",
		"騰", "	teng2",
		"騯", "	peng2",
		"騮", "	liu2",
		"騭", "	zhi4",
		"驃", "	biao1",
		"驅", "	qu1",
		"騫", "	qian1",
		"驒", "	tuo2",
		"驜", "	ye4",
		"驛", "	yi4",
		"驚", "	jing1",
		"驙", "	zhan1",
		"驘", "	luo2",
		"驗", "	yan4",
		"驖", "	tie3",
		"驕", "	jiao1",
		"驔", "	dian4",
		"驓", "	ceng2",
		"驑", "	liu2",
		"驆", "	bi4",
		"驐", "	dun1",
		"驏", "	zhan4",
		"驎", "	lin2",
		"驍", "	xiao1",
		"驌", "	su4",
		"驋", "	bo1",
		"驊", "	hua2",
		"驉", "	xu1",
		"驈", "	yu4",
		"驇", "	zhi4",
		"騬", "	cheng2",
		"騪", "	sou1",
		"驞", "	pin1",
		"騄", "	lu4",
		"騎", "	qi2",
		"騍", "	ke4",
		"騌", "	zong1",
		"騋", "	lai2",
		"騊", "	tao2",
		"騉", "	kun1",
		"騈", "	pian2",
		"騇", "	she4",
		"騆", "	zhou1",
		"騅", "	zhui1",
		"騃", "	ai2",
		"騐", "	yan4",
		"騂", "	xing1",
		"騁", "	cheng3",
		"騀", "	e3",
		"駿", "	jun4",
		"駾", "	tui4",
		"駽", "	xuan1",
		"駼", "	tu2",
		"駻", "	han4",
		"駺", "	lang2",
		"駹", "	mang2",
		"騏", "	qi2",
		"騑", "	fei1",
		"騩", "	gui1",
		"騞", "	huo1",
		"騨", "	tuo2",
		"騧", "	gua1",
		"騦", "	si1",
		"騥", "	rou2",
		"騤", "	kui2",
		"騣", "	zong1",
		"騢", "	xia2",
		"騡", "	quan2",
		"騠", "	ti2",
		"騟", "	yu2",
		"騝", "	qian2",
		"騒", "	sao1",
		"騜", "	huang2",
		"騛", "	fei1",
		"騚", "	qian2",
		"騙", "	pian4",
		"騘", "	cong1",
		"騗", "	pian4",
		"騖", "	wu4",
		"騕", "	yao3",
		"騔", "	ge2",
		"験", "	yan3",
		"驝", "	tuo1",
		"驟", "	zhou4",
		"駷", "	song3",
		"骠", "	biao1",
		"骪", "	wei3",
		"骩", "	wei3",
		"骨", "	gu3",
		"骧", "	xiang1",
		"骦", "	shuang1",
		"骥", "	ji4",
		"骤", "	zhou4",
		"骣", "	chan3",
		"骢", "	cong1",
		"骡", "	luo2",
		"骟", "	shan4",
		"骬", "	yu2",
		"骞", "	qian1",
		"骝", "	liu2",
		"骜", "	ao4",
		"骛", "	wu4",
		"骚", "	sao1",
		"骙", "	kui2",
		"骘", "	zhi4",
		"骗", "	pian4",
		"骖", "	can1",
		"骕", "	su4",
		"骫", "	wei3",
		"骭", "	gan4",
		"骓", "	zhui1",
		"骺", "	hou2",
		"髄", "	sui3",
		"髃", "	yu2",
		"髂", "	qia4",
		"髁", "	ke1",
		"髀", "	bi4",
		"骿", "	pian2",
		"骾", "	geng3",
		"骽", "	tui3",
		"骼", "	ge2",
		"骻", "	kua4",
		"骹", "	qiao1",
		"骮", "	yi4",
		"骸", "	hai2",
		"骷", "	ku1",
		"骶", "	di3",
		"骵", "	ti3",
		"骴", "	ci1",
		"骳", "	bei4",
		"骲", "	bao4",
		"骱", "	jie4",
		"骰", "	tou2",
		"骯", "	ang1",
		"骔", "	zong1",
		"骒", "	ke4",
		"驠", "	yan4",
		"马", "	ma3",
		"驶", "	shi3",
		"驵", "	zang3",
		"驴", "	lv2",
		"驳", "	bo2",
		"驲", "	ri4",
		"驱", "	qu1",
		"驰", "	chi2",
		"驯", "	xun2",
		"驮", "	tuo2",
		"驭", "	yu4",
		"驫", "	biao1",
		"驸", "	fu4",
		"驪", "	li2",
		"驩", "	huan1",
		"驨", "	xi2",
		"驧", "	ju2",
		"驦", "	shuang1",
		"驥", "	ji4",
		"驤", "	xiang1",
		"驣", "	teng2",
		"驢", "	lv2",
		"驡", "	long2",
		"驷", "	si4",
		"驹", "	ju1",
		"骑", "	qi2",
		"骆", "	luo4",
		"骐", "	qi2",
		"骏", "	jun4",
		"骎", "	qin1",
		"骍", "	xing1",
		"验", "	yan4",
		"骋", "	cheng3",
		"骊", "	li2",
		"骉", "	biao1",
		"骈", "	pian2",
		"骇", "	hai4",
		"骅", "	hua2",
		"驺", "	zou1",
		"骄", "	jiao1",
		"骃", "	yin1",
		"骂", "	ma4",
		"骁", "	xiao1",
		"骀", "	dai4",
		"驿", "	yi4",
		"驾", "	jia4",
		"驽", "	nu2",
		"驼", "	tuo2",
		"驻", "	zhu4",
		"駸", "	qin1",
		"駶", "	ju2",
		"髆", "	bo2",
		"饨", "	tun2",
		"饲", "	si4",
		"饱", "	bao3",
		"饰", "	shi4",
		"饯", "	jian4",
		"饮", "	yin3",
		"饭", "	fan4",
		"饬", "	chi4",
		"饫", "	yu4",
		"饪", "	ren4",
		"饩", "	xi4",
		"饧", "	tang2",
		"饴", "	yi2",
		"饦", "	tuo1",
		"饥", "	ji1",
		"饤", "	ding4",
		"饣", "	shi2",
		"饢", "	nang2",
		"饡", "	zan4",
		"饠", "	luo2",
		"饟", "	xiang3",
		"饞", "	chan2",
		"饝", "	mo2",
		"饳", "	duo4",
		"饵", "	er3",
		"饛", "	meng2",
		"馂", "	jun4",
		"馌", "	ye4",
		"馋", "	chan2",
		"馊", "	sou1",
		"馉", "	gu3",
		"馈", "	kui4",
		"馇", "	cha1",
		"馆", "	guan3",
		"馅", "	xian4",
		"馄", "	hun2",
		"馃", "	guo3",
		"馁", "	nei3",
		"饶", "	rao2",
		"馀", "	yu2",
		"饿", "	e4",
		"饾", "	dou4",
		"饽", "	bo1",
		"饼", "	bing3",
		"饻", "	xi1",
		"饺", "	jiao3",
		"饹", "	le",
		"饸", "	he2",
		"饷", "	xiang3",
		"饜", "	yan4",
		"饚", "	hai4",
		"馎", "	bo2",
		"餴", "	fen1",
		"餾", "	liu4",
		"餽", "	kui4",
		"餼", "	xi4",
		"餻", "	gao1",
		"餺", "	bo2",
		"餹", "	tang2",
		"餸", "	song4",
		"餷", "	cha1",
		"餶", "	gu3",
		"餵", "	wei4",
		"餳", "	tang2",
		"饀", "	tao2",
		"餲", "	ai4",
		"餱", "	hou2",
		"餰", "	jian1",
		"餯", "	hui4",
		"餮", "	tie4",
		"餭", "	huang2",
		"餬", "	hu2",
		"餫", "	yun4",
		"餪", "	nuan3",
		"餩", "	e4",
		"餿", "	sou1",
		"饁", "	ye4",
		"饙", "	fen1",
		"饎", "	chi4",
		"饘", "	zhan1",
		"饗", "	xiang3",
		"饖", "	wei4",
		"饕", "	tao1",
		"饔", "	yong1",
		"饓", "	cheng1",
		"饒", "	rao2",
		"饑", "	ji1",
		"饐", "	yi4",
		"饏", "	dan4",
		"饍", "	shan4",
		"饂", "	yun2",
		"饌", "	zhuan4",
		"饋", "	kui4",
		"饊", "	san3",
		"饉", "	jin3",
		"饈", "	xiu1",
		"饇", "	yu4",
		"饆", "	bi4",
		"饅", "	man2",
		"饄", "	tang2",
		"饃", "	mo2",
		"馍", "	mo2",
		"馏", "	liu2",
		"駵", "	liu2",
		"駐", "	zhu4",
		"駚", "	yang3",
		"駙", "	fu4",
		"駘", "	tai2",
		"駗", "	zhen3",
		"駖", "	ling2",
		"駕", "	jia4",
		"駔", "	zang3",
		"駓", "	pi1",
		"駒", "	ju1",
		"駑", "	nu2",
		"駏", "	ju4",
		"駜", "	bi4",
		"駎", "	zhou4",
		"駍", "	pei2",
		"駌", "	yuan1",
		"駋", "	zhao1",
		"駊", "	po3",
		"駉", "	jiong1",
		"駈", "	qu1",
		"駇", "	wen2",
		"駆", "	qu1",
		"駅", "	yi4",
		"駛", "	shi3",
		"駝", "	tuo2",
		"駃", "	jue2",
		"駪", "	shen1",
		"駴", "	xie4",
		"駳", "	dan4",
		"駲", "	zhou",
		"駱", "	luo4",
		"駰", "	yin1",
		"駯", "	zhu1",
		"駮", "	bo2",
		"駭", "	hai4",
		"駬", "	er3",
		"駫", "	jiong1",
		"駩", "	quan1",
		"駞", "	tuo2",
		"駨", "	xun1",
		"駧", "	dong4",
		"駦", "	teng2",
		"駥", "	rong2",
		"駤", "	zhi4",
		"駣", "	tao2",
		"駢", "	pian2",
		"駡", "	ma4",
		"駠", "	liu2",
		"駟", "	si4",
		"駄", "	tuo2",
		"駂", "	bao3",
		"馐", "	xiu1",
		"馜", "	ni3",
		"馦", "	xian1",
		"馥", "	fu4",
		"馤", "	ai4",
		"馣", "	an1",
		"馢", "	jian1",
		"馡", "	fei1",
		"馠", "	han1",
		"馟", "	tu2",
		"馞", "	bo2",
		"馝", "	bi4",
		"馛", "	bo2",
		"馨", "	xin1",
		"馚", "	fen2",
		"香", "	xiang1",
		"馘", "	guo2",
		"馗", "	kui2",
		"首", "	shou3",
		"馕", "	nang2",
		"馔", "	zhuan4",
		"馓", "	san3",
		"馒", "	man2",
		"馑", "	jin3",
		"馧", "	yun1",
		"馩", "	fen2",
		"駁", "	bo2",
		"馶", "	zhi1",
		"駀", "	you2",
		"馿", "	lv2",
		"馾", "	dan4",
		"馽", "	zhi2",
		"馼", "	wen2",
		"馻", "	yun3",
		"馺", "	sa4",
		"馹", "	ri4",
		"馸", "	xin4",
		"馷", "	pei4",
		"馵", "	zhu4",
		"馪", "	pin1",
		"馴", "	xun2",
		"馳", "	chi2",
		"馲", "	zhe2",
		"馱", "	tuo2",
		"馰", "	di2",
		"馯", "	han4",
		"馮", "	feng2",
		"馭", "	yu4",
		"馬", "	ma3",
		"馫", "	xin1",
		"髅", "	lou2",
		"髇", "	xiao1",
		"鱦", "	ying4",
		"鯙", "	chun2",
		"鯣", "	yi4",
		"鯢", "	ni2",
		"鯡", "	fei4",
		"鯠", "	lai2",
		"鯟", "	dong1",
		"鯞", "	zhou3",
		"鯝", "	gu4",
		"鯜", "	qie4",
		"鯛", "	diao1",
		"鯚", "	ji4",
		"鯘", "	nei3",
		"鯥", "	lu4",
		"鯗", "	xiang3",
		"鯖", "	zheng1",
		"鯕", "	qi2",
		"鯔", "	zi1",
		"鯓", "	ni2",
		"鯒", "	yong3",
		"鯑", "	xi",
		"鯐", "	zou",
		"鯏", "	li",
		"鯎", "	cheng",
		"鯤", "	kun1",
		"鯦", "	jiu4",
		"鯌", "	kao4",
		"鯳", "	di",
		"鯽", "	zei2",
		"鯼", "	zong1",
		"鯻", "	la4",
		"鯺", "	zhu1",
		"鯹", "	xing1",
		"鯸", "	hou2",
		"鯷", "	ti2",
		"鯶", "	hun3",
		"鯵", "	shen1",
		"鯴", "	shi1",
		"鯲", "	yu",
		"鯧", "	chang1",
		"鯱", "	hu",
		"鯰", "	nian2",
		"鯯", "	zhi4",
		"鯮", "	zong1",
		"鯭", "	meng3",
		"鯬", "	li2",
		"鯫", "	zou1",
		"鯪", "	ling2",
		"鯩", "	lun2",
		"鯨", "	jing1",
		"鯍", "	meng2",
		"鯋", "	sha1",
		"鯿", "	bian1",
		"鮥", "	luo4",
		"鮯", "	ge2",
		"鮮", "	xian1",
		"鮭", "	gui1",
		"鮬", "	ku1",
		"鮫", "	jiao1",
		"鮪", "	wei3",
		"鮩", "	bing4",
		"鮨", "	yi4",
		"鮧", "	ti3",
		"鮦", "	tong2",
		"鮤", "	lie4",
		"鮱", "	lao",
		"鮣", "	yin4",
		"鮢", "	zhu1",
		"鮡", "	zhao4",
		"鮠", "	wei2",
		"鮟", "	an4",
		"鮞", "	er2",
		"鮝", "	xiang3",
		"鮜", "	hou4",
		"鮛", "	shu1",
		"鮚", "	jie2",
		"鮰", "	hui2",
		"鮲", "	fu",
		"鯊", "	sha1",
		"鮿", "	zhe2",
		"鯉", "	li3",
		"鯈", "	tiao2",
		"鯇", "	huan4",
		"鯆", "	pu1",
		"鯅", "	shan1",
		"鯄", "	qiu2",
		"鯃", "	wu2",
		"鯂", "	su",
		"鯁", "	geng3",
		"鯀", "	gun3",
		"鮾", "	nei3",
		"鮳", "	kao4",
		"鮽", "	yu2",
		"鮼", "	qin1",
		"鮻", "	suo1",
		"鮺", "	zha3",
		"鮹", "	shao1",
		"鮸", "	mian3",
		"鮷", "	ti2",
		"鮶", "	jun1",
		"鮵", "	duo2",
		"鮴", "	xiu",
		"鯾", "	bian1",
		"鰀", "	huan4",
		"鮘", "	dai",
		"鱁", "	zhu2",
		"鱋", "	qu1",
		"鱊", "	yu4",
		"鱉", "	bie1",
		"鱈", "	xue3",
		"鱇", "	kang1",
		"鱆", "	zhang1",
		"鱅", "	yong1",
		"鱄", "	zhuan1",
		"鱃", "	xiu1",
		"鱂", "	jiang1",
		"鱀", "	ji4",
		"鱍", "	bo1",
		"鰿", "	ji4",
		"鰾", "	biao4",
		"鰽", "	qiu2",
		"鰼", "	xi2",
		"鰻", "	man2",
		"鰺", "	shen1",
		"鰹", "	jian1",
		"鰸", "	qu1",
		"鰷", "	tiao2",
		"鰶", "	ji4",
		"鱌", "	xiang4",
		"鱎", "	jiao3",
		"鰴", "	hui1",
		"鱛", "	zeng",
		"鱥", "	gui4",
		"鱤", "	gan3",
		"鱣", "	zhan1",
		"鱢", "	sao1",
		"鱡", "	zei2",
		"鱠", "	kuai4",
		"鱟", "	hou4",
		"鱞", "	guan1",
		"鱝", "	fen4",
		"鱜", "	xiang",
		"鱚", "	xi3",
		"鱏", "	xun2",
		"鱙", "	miao2",
		"鱘", "	xun2",
		"鱗", "	lin2",
		"鱖", "	gui4",
		"鱕", "	fan1",
		"鱔", "	shan4",
		"鱓", "	shan4",
		"鱒", "	zun1",
		"鱑", "	huang2",
		"鱐", "	su4",
		"鰵", "	min3",
		"鰳", "	le4",
		"鰁", "	quan2",
		"鰍", "	qiu1",
		"鰗", "	hu2",
		"鰖", "	tuo3",
		"鰕", "	xia1",
		"鰔", "	gan3",
		"鰓", "	sai1",
		"鰒", "	fu4",
		"鰑", "	yang2",
		"鰐", "	e4",
		"鰏", "	bi1",
		"鰎", "	jian3",
		"鰌", "	qiu1",
		"鰙", "	ruo4",
		"鰋", "	yan3",
		"鰊", "	lian4",
		"鰉", "	huang2",
		"鰈", "	die2",
		"鰇", "	rou2",
		"鰆", "	chun1",
		"鰅", "	yu2",
		"鰄", "	wei1",
		"鰃", "	wei1",
		"鰂", "	zei2",
		"鰘", "	shi",
		"鰚", "	xuan",
		"鰲", "	ao2",
		"鰧", "	teng2",
		"鰱", "	lian2",
		"鰰", "	shen",
		"鰯", "	ruo4",
		"鰮", "	wen1",
		"鰭", "	qi2",
		"鰬", "	qian2",
		"鰫", "	yong2",
		"鰪", "	e2",
		"鰩", "	yao2",
		"鰨", "	ta3",
		"鰦", "	zi1",
		"鰛", "	wen1",
		"鰥", "	guan1",
		"鰤", "	shi1",
		"鰣", "	shi2",
		"鰢", "	ma3",
		"鰡", "	liu2",
		"鰠", "	sao1",
		"鰟", "	fang2",
		"鰞", "	wu1",
		"鰝", "	hao4",
		"鰜", "	qian4",
		"鮙", "	ta4",
		"鮗", "	dong",
		"髈", "	bang3",
		"鬈", "	quan2",
		"鬒", "	zhen3",
		"鬑", "	lian2",
		"鬐", "	qi2",
		"鬏", "	jiu1",
		"鬎", "	la4",
		"鬍", "	hu2",
		"鬌", "	tuo3",
		"鬋", "	jian3",
		"鬊", "	shun4",
		"鬉", "	zong1",
		"鬇", "	zheng1",
		"鬔", "	peng2",
		"鬆", "	song1",
		"鬅", "	peng2",
		"鬄", "	di2",
		"鬃", "	zong1",
		"鬂", "	bin4",
		"鬁", "	li4",
		"鬀", "	ti4",
		"髿", "	suo1",
		"髾", "	shao1",
		"髽", "	zhua1",
		"鬓", "	bin4",
		"鬕", "	ma4",
		"髻", "	ji4",
		"鬢", "	bin4",
		"鬬", "	dou4",
		"鬫", "	han3",
		"鬪", "	dou4",
		"鬩", "	xi4",
		"鬨", "	hong4",
		"鬧", "	nao4",
		"鬦", "	dou4",
		"鬥", "	dou4",
		"鬤", "	rang2",
		"鬣", "	lie4",
		"鬡", "	ning2",
		"鬖", "	san1",
		"鬠", "	kuo4",
		"鬟", "	huan2",
		"鬞", "	nang2",
		"鬝", "	qian1",
		"鬜", "	qian1",
		"鬛", "	lie4",
		"鬚", "	xu1",
		"鬙", "	seng1",
		"鬘", "	man2",
		"鬗", "	man2",
		"髼", "	peng2",
		"髺", "	kuo4",
		"鬮", "	jiu1",
		"體", "	ti3",
		"髞", "	sao4",
		"髝", "	lao2",
		"髜", "	qiao3",
		"髛", "	kao1",
		"髚", "	qiao4",
		"髙", "	gao1",
		"高", "	gao1",
		"髗", "	lu2",
		"髖", "	kuan1",
		"髕", "	bin4",
		"髓", "	sui3",
		"髠", "	kun1",
		"髒", "	zang1",
		"髑", "	du2",
		"髐", "	xiao1",
		"髏", "	lou2",
		"髎", "	liao2",
		"髍", "	mo2",
		"髌", "	bin4",
		"髋", "	kuan1",
		"髊", "	ci1",
		"髉", "	bo2",
		"髟", "	biao1",
		"髡", "	kun1",
		"髹", "	xiu1",
		"髮", "	fa4",
		"髸", "	gong1",
		"髷", "	qu1",
		"髶", "	rong2",
		"髵", "	er2",
		"髴", "	fu2",
		"髳", "	mao2",
		"髲", "	bi4",
		"髱", "	bao4",
		"髰", "	ti4",
		"髯", "	ran2",
		"髭", "	zi1",
		"髢", "	di2",
		"髬", "	pi1",
		"髫", "	tiao2",
		"髪", "	fa4",
		"髩", "	bin4",
		"髨", "	kun1",
		"髧", "	dan4",
		"髦", "	mao2",
		"髥", "	ran2",
		"髤", "	xiu1",
		"髣", "	fang3",
		"鬭", "	dou4",
		"鬯", "	chang4",
		"鮖", "	shi",
		"魱", "	hu2",
		"魻", "	xia2",
		"魺", "	he2",
		"魹", "	mo",
		"魸", "	pian",
		"魷", "	you2",
		"魶", "	na4",
		"魵", "	fen2",
		"魴", "	fang2",
		"魳", "	za1",
		"魲", "	lu2",
		"魰", "	wen2",
		"魽", "	han2",
		"魯", "	lu3",
		"魮", "	pi2",
		"魭", "	yuan2",
		"魬", "	ban3",
		"魫", "	shen3",
		"魪", "	jie4",
		"魩", "	mo4",
		"魨", "	tun2",
		"魧", "	hang2",
		"魦", "	sha1",
		"魼", "	qu1",
		"魾", "	pi1",
		"魤", "	e2",
		"鮋", "	you2",
		"鮕", "	gu1",
		"鮔", "	ju4",
		"鮓", "	zha3",
		"鮒", "	fu4",
		"鮑", "	bao4",
		"鮐", "	tai2",
		"鮏", "	xing1",
		"鮎", "	nian2",
		"鮍", "	pi1",
		"鮌", "	gun3",
		"鮊", "	ba4",
		"魿", "	ling2",
		"鮉", "	diao1",
		"鮈", "	ju1",
		"鮇", "	wei4",
		"鮆", "	ci3",
		"鮅", "	bi4",
		"鮄", "	fu2",
		"鮃", "	ping2",
		"鮂", "	qiu2",
		"鮁", "	bo1",
		"鮀", "	tuo2",
		"魥", "	e4",
		"魣", "	xu4",
		"鬰", "	yu4",
		"鬼", "	gui3",
		"魆", "	xu1",
		"魅", "	mei4",
		"魄", "	po4",
		"魃", "	ba2",
		"魂", "	hun2",
		"魁", "	kui2",
		"魀", "	ga4",
		"鬿", "	qi2",
		"鬾", "	ji4",
		"鬽", "	mei4",
		"鬻", "	yu4",
		"魈", "	xiao1",
		"鬺", "	shang1",
		"鬹", "	gui1",
		"鬸", "	liu4",
		"鬷", "	zong1",
		"鬶", "	gui1",
		"鬵", "	qin2",
		"鬴", "	fu3",
		"鬳", "	yan4",
		"鬲", "	ge2",
		"鬱", "	yu4",
		"魇", "	yan3",
		"魉", "	liang3",
		"魢", "	ji3",
		"魗", "	chou3",
		"魡", "	diao4",
		"魠", "	tuo1",
		"魟", "	hong2",
		"魞", "	ba",
		"魝", "	jie2",
		"魜", "	ren2",
		"魛", "	dao1",
		"魚", "	yu2",
		"魙", "	zhan1",
		"魘", "	yan3",
		"魖", "	xu1",
		"魊", "	yu4",
		"魕", "	ji3",
		"魔", "	mo2",
		"魓", "	bi4",
		"魒", "	piao1",
		"魑", "	chi1",
		"魐", "	gan1",
		"魏", "	wei4",
		"魎", "	liang3",
		"魍", "	wang3",
		"魌", "	qi1",
		"魋", "	tui2",
		"銧", "	guang1",
		"銥", "	yi1",
		"薣", "	gu3",
		"觴", "	shang1",
		"觾", "	yan4",
		"觽", "	xi1",
		"觼", "	jue2",
		"觻", "	li4",
		"觺", "	yi2",
		"觹", "	xi1",
		"觸", "	chu4",
		"觷", "	xue2",
		"觶", "	zhi4",
		"觵", "	gong1",
		"觳", "	hu2",
		"言", "	yan2",
		"觲", "	xing1",
		"觱", "	bi4",
		"觰", "	zha1",
		"觯", "	zhi4",
		"觮", "	lu4",
		"觭", "	ji1",
		"觬", "	ni2",
		"觫", "	su4",
		"觪", "	xing1",
		"觩", "	qiu2",
		"觿", "	xi1",
		"訁", "	yan2",
		"觧", "	jie3",
		"討", "	tao3",
		"記", "	ji4",
		"託", "	tuo1",
		"訖", "	qi4",
		"訕", "	shan4",
		"訔", "	yin2",
		"訓", "	xun4",
		"訒", "	ren4",
		"訑", "	yi2",
		"訐", "	jie2",
		"訏", "	xu1",
		"訍", "	chai4",
		"訂", "	ding4",
		"訌", "	hong4",
		"訋", "	diao4",
		"訊", "	xun4",
		"訉", "	fan1",
		"計", "	ji4",
		"訇", "	hong1",
		"訆", "	jiao4",
		"訅", "	qiu2",
		"訄", "	qiu2",
		"訃", "	fu4",
		"觨", "	hun4",
		"触", "	chu4",
		"訚", "	yin2",
		"觀", "	guan1",
		"觊", "	ji4",
		"觉", "	jue2",
		"览", "	lan3",
		"觇", "	chan1",
		"视", "	shi4",
		"觅", "	mi4",
		"规", "	gui1",
		"觃", "	yan4",
		"观", "	guan1",
		"见", "	jian4",
		"覿", "	di2",
		"觌", "	di2",
		"覾", "	shen3",
		"覽", "	lan3",
		"覼", "	luo2",
		"覻", "	qu1",
		"覺", "	jue2",
		"覹", "	wei2",
		"覸", "	jian1",
		"覷", "	qu4",
		"覶", "	luo2",
		"覵", "	jian4",
		"觋", "	xi2",
		"觍", "	tian3",
		"觥", "	gong1",
		"觚", "	gu1",
		"觤", "	gui3",
		"解", "	jie3",
		"觢", "	shi4",
		"觡", "	ge2",
		"觠", "	quan2",
		"觟", "	hua4",
		"觞", "	shang1",
		"觝", "	di3",
		"觜", "	zi1",
		"觛", "	dan4",
		"觙", "	ji2",
		"觎", "	yu2",
		"觘", "	chao4",
		"觗", "	zhi4",
		"觖", "	jue2",
		"觕", "	cu1",
		"觔", "	jin1",
		"觓", "	qiu2",
		"角", "	jiao3",
		"觑", "	qu4",
		"觐", "	jin4",
		"觏", "	gou4",
		"訙", "	xun4",
		"訛", "	e2",
		"観", "	guan1",
		"詜", "	tao1",
		"試", "	shi4",
		"詥", "	he2",
		"詤", "	huang3",
		"詣", "	yi4",
		"詢", "	xun2",
		"詡", "	xu3",
		"詠", "	yong3",
		"詟", "	zhe2",
		"詞", "	ci2",
		"詝", "	zhu3",
		"詛", "	zu3",
		"詨", "	xiao4",
		"詚", "	da2",
		"詙", "	ba2",
		"詘", "	qu1",
		"詗", "	xiong4",
		"詖", "	bi4",
		"評", "	ping2",
		"詔", "	zhao4",
		"詓", "	qu3",
		"詒", "	yi2",
		"詑", "	yi2",
		"詧", "	cha2",
		"詩", "	shi1",
		"詏", "	yao4",
		"詶", "	zhou4",
		"誀", "	er4",
		"詿", "	gua4",
		"詾", "	xiong1",
		"詽", "	yan2",
		"詼", "	hui1",
		"詻", "	e4",
		"詺", "	ming4",
		"詹", "	zhan1",
		"詸", "	mi2",
		"詷", "	tong2",
		"詵", "	shen1",
		"詪", "	hen3",
		"詴", "	wei1",
		"詳", "	xiang2",
		"該", "	gai1",
		"話", "	hua4",
		"詰", "	jie2",
		"詯", "	hui4",
		"詮", "	quan2",
		"詭", "	gui3",
		"詬", "	gou4",
		"詫", "	cha4",
		"詐", "	zha4",
		"詎", "	ju4",
		"訜", "	fen1",
		"訨", "	zhi3",
		"訲", "	yi4",
		"許", "	xu3",
		"訰", "	zhun4",
		"訯", "	sa3",
		"訮", "	xian1",
		"設", "	she4",
		"訬", "	chao1",
		"訫", "	xin4",
		"訪", "	fang3",
		"訩", "	xiong1",
		"訧", "	you2",
		"訴", "	su4",
		"訦", "	chen2",
		"訥", "	ne4",
		"訤", "	xiao2",
		"訣", "	jue2",
		"訢", "	xin1",
		"訡", "	yin2",
		"訠", "	shen3",
		"訟", "	song4",
		"訞", "	yao1",
		"訝", "	ya4",
		"訳", "	yi4",
		"訵", "	chi1",
		"詍", "	yi4",
		"詂", "	fu4",
		"詌", "	gan4",
		"詋", "	zhou4",
		"詊", "	pan4",
		"詉", "	nao2",
		"詈", "	li4",
		"詇", "	yang4",
		"詆", "	di3",
		"詅", "	ling2",
		"詄", "	die2",
		"詃", "	jian3",
		"詁", "	gu3",
		"訶", "	he1",
		"詀", "	zhan1",
		"訿", "	zi3",
		"訾", "	zi1",
		"訽", "	gou4",
		"証", "	zheng4",
		"註", "	zhu4",
		"診", "	zhen3",
		"訹", "	xu4",
		"訸", "	he2",
		"訷", "	shen1",
		"覴", "	deng1",
		"覲", "	jin4",
		"誂", "	tiao3",
		"褤", "	yuan4",
		"褮", "	ying1",
		"褭", "	niao3",
		"褬", "	sang3",
		"褫", "	chi3",
		"褪", "	tui4",
		"褩", "	ban1",
		"褨", "	suo3",
		"褧", "	jiong3",
		"褦", "	nai4",
		"褥", "	ru4",
		"褣", "	rong2",
		"褰", "	qian1",
		"褢", "	huai2",
		"褡", "	da1",
		"褠", "	gou1",
		"褟", "	ta1",
		"褞", "	yun3",
		"褝", "	dan1",
		"褜", "	pao",
		"褛", "	lv3",
		"褚", "	chu3",
		"褙", "	bei4",
		"褯", "	jie4",
		"褱", "	huai2",
		"褗", "	yan3",
		"褾", "	biao3",
		"襈", "	zhuan4",
		"襇", "	jian3",
		"襆", "	fu2",
		"襅", "	bi",
		"襄", "	xiang1",
		"襃", "	bao1",
		"襂", "	sen1",
		"襁", "	qiang3",
		"襀", "	ji1",
		"褿", "	cao2",
		"褽", "	wei4",
		"褲", "	ku4",
		"褼", "	xian1",
		"褻", "	xie4",
		"褺", "	die1",
		"褹", "	yi4",
		"褸", "	lv3",
		"褷", "	shi1",
		"褶", "	zhe3",
		"褵", "	li2",
		"褴", "	lan2",
		"褳", "	lian2",
		"褘", "	hui1",
		"褖", "	tuan4",
		"襊", "	cui4",
		"裰", "	duo1",
		"裺", "	yan3",
		"裹", "	guo3",
		"裸", "	luo3",
		"裷", "	yuan1",
		"裶", "	fei1",
		"裵", "	pei2",
		"裴", "	pei2",
		"裳", "	shang",
		"裲", "	liang3",
		"裱", "	biao3",
		"裯", "	chou2",
		"裼", "	ti4",
		"裮", "	chang1",
		"裭", "	chi3",
		"裬", "	ling2",
		"裫", "	yuan4",
		"裪", "	tao2",
		"裩", "	kun1",
		"裨", "	bi4",
		"裧", "	chan1",
		"裦", "	fou2",
		"裥", "	jian3",
		"裻", "	du2",
		"製", "	zhi4",
		"褕", "	yu2",
		"褊", "	bian3",
		"褔", "	fu4",
		"褓", "	bao3",
		"褒", "	bao1",
		"褑", "	yuan4",
		"褐", "	he4",
		"褏", "	xiu4",
		"褎", "	xiu4",
		"褍", "	duan1",
		"褌", "	kun1",
		"褋", "	die2",
		"褉", "	xie4",
		"裾", "	ju1",
		"褈", "	chong2",
		"複", "	fu4",
		"褆", "	ti2",
		"褅", "	ti4",
		"褄", "	qi",
		"褃", "	ken4",
		"褂", "	gua4",
		"褁", "	zhi2",
		"褀", "	ji4",
		"裿", "	yi3",
		"襉", "	jian3",
		"襋", "	ji2",
		"覱", "	zhan4",
		"覌", "	guan1",
		"視", "	shi4",
		"覕", "	mie4",
		"覔", "	mi4",
		"覓", "	mi4",
		"覒", "	mao4",
		"覑", "	pian3",
		"覐", "	jue2",
		"規", "	gui1",
		"覎", "	yan4",
		"覍", "	bian4",
		"見", "	jian4",
		"覘", "	chan1",
		"覊", "	ji1",
		"覉", "	ji1",
		"覈", "	he2",
		"覇", "	ba4",
		"覆", "	fu4",
		"覅", "	fiao4",
		"覄", "	fu",
		"覃", "	tan2",
		"覂", "	feng3",
		"要", "	yao4",
		"覗", "	si4",
		"覙", "	luo2",
		"西", "	xi1",
		"覦", "	yu2",
		"覰", "	qu1",
		"覯", "	gou4",
		"覮", "	ying2",
		"覭", "	ming2",
		"覬", "	ji4",
		"覫", "	pang3",
		"親", "	qin1",
		"覩", "	du3",
		"覨", "	e4",
		"覧", "	lan3",
		"覥", "	tian3",
		"覚", "	jue2",
		"覤", "	xi4",
		"覣", "	wei1",
		"覢", "	shan3",
		"覡", "	xi2",
		"覠", "	jun1",
		"覟", "	zhi4",
		"覞", "	yao4",
		"覝", "	lian2",
		"覜", "	tiao4",
		"覛", "	mi4",
		"覀", "	xi1",
		"襾", "	ya4",
		"襌", "	dan1",
		"襘", "	gui4",
		"襢", "	tan3",
		"襡", "	shu3",
		"襠", "	dang1",
		"襟", "	jin1",
		"襞", "	bi4",
		"襝", "	lian3",
		"襜", "	chan1",
		"襛", "	nong2",
		"襚", "	sui4",
		"襙", "	cao4",
		"襗", "	ze2",
		"襤", "	lan2",
		"襖", "	ao3",
		"襕", "	lan2",
		"襔", "	man3",
		"襓", "	rao2",
		"襒", "	bie2",
		"襑", "	xin2",
		"襐", "	xiang4",
		"襏", "	bo2",
		"襎", "	fan2",
		"襍", "	za2",
		"襣", "	bi4",
		"襥", "	pu2",
		"襽", "	lan",
		"襲", "	xi2",
		"襼", "	yi4",
		"襻", "	pan4",
		"襺", "	jian3",
		"襹", "	shi1",
		"襸", "	zan4",
		"襷", "	ju",
		"襶", "	dai4",
		"襵", "	zhe3",
		"襴", "	lan2",
		"襳", "	xian1",
		"襱", "	long2",
		"襦", "	ru2",
		"襰", "	lai4",
		"襯", "	chen4",
		"襮", "	bo2",
		"襭", "	xie2",
		"襬", "	bai3",
		"襫", "	shi4",
		"襪", "	wa4",
		"襩", "	shu3",
		"襨", "	dui4",
		"襧", "	zhi3",
		"誁", "	bing4",
		"誃", "	yi2",
		"裣", "	lian3",
		"讕", "	lan2",
		"讟", "	du2",
		"讞", "	yan4",
		"讝", "	zhan2",
		"讜", "	dang3",
		"讛", "	yi4",
		"讚", "	zan4",
		"讙", "	huan1",
		"讘", "	nie4",
		"讗", "	xie2",
		"讖", "	chen4",
		"讔", "	yin3",
		"计", "	ji4",
		"讓", "	rang4",
		"讒", "	chan2",
		"讑", "	yao4",
		"讐", "	chou2",
		"讏", "	wei4",
		"讎", "	chou2",
		"讍", "	e4",
		"讌", "	yan4",
		"讋", "	zhe2",
		"變", "	bian4",
		"讠", "	yan2",
		"订", "	ding4",
		"讈", "	li4",
		"讯", "	xun4",
		"讹", "	e2",
		"许", "	xu3",
		"讷", "	ne4",
		"讶", "	ya4",
		"讵", "	ju4",
		"讴", "	ou1",
		"讳", "	hui4",
		"讲", "	jiang3",
		"讱", "	ren4",
		"记", "	ji4",
		"议", "	yi4",
		"讣", "	fu4",
		"训", "	xun4",
		"讬", "	tuo1",
		"讫", "	qi4",
		"讪", "	shan4",
		"让", "	rang4",
		"讨", "	tao3",
		"讧", "	hong4",
		"讦", "	jie2",
		"讥", "	ji1",
		"认", "	ren4",
		"讉", "	yi2",
		"讇", "	chan3",
		"讻", "	xiong1",
		"譡", "	dang3",
		"譫", "	zhan1",
		"譪", "	ai4",
		"譩", "	yi1",
		"譨", "	nang2",
		"譧", "	zhan4",
		"警", "	jing3",
		"譥", "	jiao4",
		"譤", "	ji1",
		"譣", "	xian3",
		"譢", "	sui4",
		"譠", "	tan2",
		"譭", "	hui3",
		"譟", "	zao4",
		"譞", "	xuan1",
		"譝", "	sheng2",
		"譜", "	pu3",
		"譛", "	zen4",
		"譚", "	tan2",
		"譙", "	qiao4",
		"識", "	shi2",
		"譗", "	zha2",
		"譖", "	zen4",
		"譬", "	pi4",
		"譮", "	hua4",
		"讆", "	wei4",
		"譻", "	ying1",
		"讅", "	shen3",
		"讄", "	lei3",
		"讃", "	zan4",
		"讂", "	xuan4",
		"讁", "	zhe2",
		"讀", "	du2",
		"譿", "	hui4",
		"譾", "	jian3",
		"譽", "	yu4",
		"譼", "	jian4",
		"譺", "	ai4",
		"譯", "	yi4",
		"譹", "	hao2",
		"譸", "	zhou1",
		"護", "	hu4",
		"譶", "	ta4",
		"譵", "	zhui4",
		"譴", "	qian3",
		"譳", "	nou4",
		"譲", "	rang4",
		"譱", "	shan4",
		"議", "	yi4",
		"论", "	lun4",
		"讼", "	song4",
		"譔", "	zhuan4",
		"诽", "	fei3",
		"谇", "	sui4",
		"谆", "	zhun1",
		"谅", "	liang4",
		"谄", "	chan3",
		"调", "	diao4",
		"谂", "	shen3",
		"谁", "	shui2",
		"谀", "	yu2",
		"诿", "	wei3",
		"课", "	ke4",
		"诼", "	zhuo2",
		"谉", "	shen3",
		"读", "	du2",
		"诺", "	nuo4",
		"诹", "	zou1",
		"诸", "	zhu1",
		"请", "	qing3",
		"诶", "	ei2",
		"诵", "	song4",
		"说", "	shuo1",
		"诳", "	kuang2",
		"诲", "	hui4",
		"谈", "	tan2",
		"谊", "	yi4",
		"诰", "	gao4",
		"谗", "	chan2",
		"谡", "	su4",
		"谠", "	dang3",
		"谟", "	mo2",
		"谞", "	xu1",
		"谝", "	pian3",
		"谜", "	mi2",
		"谛", "	di4",
		"谚", "	yan4",
		"谙", "	an1",
		"谘", "	zi1",
		"谖", "	xuan1",
		"谋", "	mou2",
		"谕", "	yu4",
		"谔", "	e4",
		"谓", "	wei4",
		"谒", "	ye4",
		"谑", "	xue4",
		"谐", "	xie2",
		"谏", "	jian4",
		"谎", "	huang3",
		"谍", "	die2",
		"谌", "	chen2",
		"诱", "	you4",
		"误", "	wu4",
		"讽", "	feng3",
		"诉", "	su4",
		"诓", "	kuang1",
		"诒", "	yi2",
		"译", "	yi4",
		"诐", "	bi4",
		"诏", "	zhao4",
		"诎", "	qu1",
		"词", "	ci2",
		"诌", "	zhou1",
		"诋", "	di3",
		"诊", "	zhen3",
		"诈", "	zha4",
		"试", "	shi4",
		"诇", "	xiong4",
		"识", "	shi2",
		"诅", "	zu3",
		"评", "	ping2",
		"诃", "	he1",
		"诂", "	gu3",
		"证", "	zheng4",
		"诀", "	jue2",
		"访", "	fang3",
		"设", "	she4",
		"诔", "	lei3",
		"诖", "	gua4",
		"诮", "	qiao4",
		"诣", "	yi4",
		"语", "	yu3",
		"诬", "	wu1",
		"诫", "	jie4",
		"诪", "	zhou1",
		"诩", "	xu3",
		"诨", "	hun4",
		"诧", "	cha4",
		"详", "	xiang2",
		"该", "	gai1",
		"诤", "	zheng1",
		"询", "	xun2",
		"诗", "	shi1",
		"诡", "	gui3",
		"诠", "	quan2",
		"诟", "	gou4",
		"诞", "	dan4",
		"话", "	hua4",
		"诜", "	shen1",
		"殖", "	zhi2",
		"诚", "	cheng2",
		"诙", "	hui1",
		"诘", "	ji2",
		"譕", "	wu2",
		"譓", "	hui4",
		"誄", "	lei3",
		"諄", "	zhun1",
		"諎", "	ze2",
		"諍", "	zheng4",
		"諌", "	dong3",
		"請", "	qing3",
		"諊", "	ju2",
		"諉", "	wei3",
		"諈", "	zhui4",
		"談", "	tan2",
		"諆", "	qi1",
		"諅", "	ji4",
		"諃", "	chen1",
		"諐", "	qian1",
		"諂", "	chan3",
		"諁", "	zhuo2",
		"諀", "	pi3",
		"調", "	diao4",
		"誾", "	yin2",
		"誽", "	ni4",
		"誼", "	yi4",
		"誻", "	ta4",
		"誺", "	chi1",
		"誹", "	fei3",
		"諏", "	zou1",
		"諑", "	zhuo2",
		"誷", "	wang3",
		"諞", "	pian3",
		"諨", "	fu2",
		"諧", "	xie2",
		"諦", "	di4",
		"諥", "	zhong4",
		"諤", "	e4",
		"諣", "	hua4",
		"諢", "	hun4",
		"諡", "	shi4",
		"諠", "	xuan1",
		"諟", "	shi4",
		"諝", "	xu1",
		"諒", "	liang4",
		"諜", "	die2",
		"諛", "	yu2",
		"諚", "	pian2",
		"諙", "	huai4",
		"諘", "	biao3",
		"諗", "	shen3",
		"論", "	lun4",
		"諕", "	hao2",
		"諔", "	chu4",
		"諓", "	jian4",
		"誸", "	xian2",
		"誶", "	sui4",
		"諪", "	ting2",
		"誐", "	e2",
		"誚", "	qiao4",
		"誙", "	keng1",
		"誘", "	you4",
		"誗", "	chan2",
		"誖", "	bei4",
		"誕", "	dan4",
		"誔", "	ting3",
		"誓", "	shi4",
		"誒", "	ei2",
		"誑", "	kuang2",
		"誏", "	lang3",
		"誜", "	shua4",
		"誎", "	cu4",
		"認", "	ren4",
		"誌", "	zhi4",
		"誋", "	ji4",
		"誊", "	teng2",
		"誉", "	yu4",
		"誈", "	wu2",
		"誇", "	kua1",
		"誆", "	kuang1",
		"誅", "	zhu1",
		"誛", "	qin1",
		"誝", "	an1",
		"誵", "	xiao2",
		"說", "	shuo1",
		"誴", "	cong2",
		"誳", "	qu1",
		"課", "	ke4",
		"誱", "	jie2",
		"誰", "	shui2",
		"誯", "	chang4",
		"誮", "	hua",
		"読", "	du2",
		"説", "	shuo1",
		"誫", "	zhen4",
		"誩", "	jing4",
		"語", "	yu3",
		"誨", "	hui4",
		"誧", "	bu1",
		"誦", "	song4",
		"誥", "	gao4",
		"誤", "	wu4",
		"誣", "	wu1",
		"誢", "	xian4",
		"誡", "	jie4",
		"誠", "	cheng2",
		"誟", "	xiao4",
		"諩", "	pu3",
		"諫", "	jian4",
		"譒", "	bo4",
		"謭", "	jian3",
		"謷", "	ao2",
		"謶", "	zhuo2",
		"謵", "	xi2",
		"謴", "	gun4",
		"謳", "	ou1",
		"謲", "	can4",
		"謱", "	lou2",
		"謰", "	lian2",
		"謯", "	jie1",
		"謮", "	ze2",
		"謬", "	miu4",
		"謹", "	jin3",
		"謫", "	zhe2",
		"謪", "	shang1",
		"謩", "	mo4",
		"謨", "	mo2",
		"謧", "	li2",
		"謦", "	qing4",
		"謥", "	cong4",
		"謤", "	biao1",
		"謣", "	yu2",
		"謢", "	zhi",
		"謸", "	ao2",
		"謺", "	zhe2",
		"謠", "	yao2",
		"譇", "	zha1",
		"譑", "	jiao3",
		"譐", "	zun3",
		"譏", "	ji1",
		"譎", "	jue2",
		"譍", "	ying1",
		"譌", "	e2",
		"譋", "	lan2",
		"譊", "	nao2",
		"證", "	zheng4",
		"譈", "	dui4",
		"譆", "	xi1",
		"謻", "	yi2",
		"譅", "	se4",
		"譄", "	zeng1",
		"譃", "	xu1",
		"譂", "	chan3",
		"譁", "	hua2",
		"譀", "	han4",
		"謿", "	chao2",
		"謾", "	man2",
		"謽", "	jiang4",
		"謼", "	hu1",
		"謡", "	yao2",
		"謟", "	tao1",
		"諬", "	qi3",
		"諸", "	zhu1",
		"謂", "	wei4",
		"謁", "	ye4",
		"謀", "	mou2",
		"諿", "	qi1",
		"諾", "	nuo4",
		"諽", "	ge2",
		"諼", "	xuan1",
		"諻", "	huang2",
		"諺", "	yan4",
		"諹", "	yang2",
		"諷", "	feng3",
		"謄", "	teng2",
		"諶", "	chen2",
		"諵", "	nan2",
		"諴", "	xian2",
		"諳", "	an1",
		"諲", "	yin1",
		"諱", "	hui4",
		"諰", "	xi3",
		"諯", "	zhuan1",
		"諮", "	zi1",
		"諭", "	yu4",
		"謃", "	xing",
		"謅", "	zhou1",
		"謞", "	he4",
		"謓", "	chen1",
		"謝", "	xie4",
		"謜", "	yuan2",
		"講", "	jiang3",
		"謚", "	shi4",
		"謙", "	qian1",
		"謘", "	chi2",
		"謗", "	bang4",
		"謖", "	su4",
		"謕", "	ti2",
		"謔", "	xue4",
		"謒", "	qiang1",
		"謆", "	shan4",
		"謑", "	xi3",
		"謐", "	mi4",
		"謏", "	xiao3",
		"謎", "	mi2",
		"謍", "	ying2",
		"謌", "	ge1",
		"謋", "	huo4",
		"謊", "	huang3",
		"謉", "	kui4",
		"謈", "	po2",
		"謇", "	jian3",
		"裤", "	ku4",
		"裢", "	lian2",
		"谣", "	yao2",
		"蚳", "	chi2",
		"蚽", "	pi2",
		"蚼", "	gou3",
		"蚻", "	zha2",
		"蚺", "	ran2",
		"蚹", "	fu4",
		"蚸", "	li4",
		"蚷", "	ju4",
		"蚶", "	han1",
		"蚵", "	he2",
		"蚴", "	you4",
		"蚲", "	ping2",
		"蚿", "	xian2",
		"蚱", "	zha4",
		"蚰", "	you2",
		"蚯", "	qiu1",
		"蚮", "	te4",
		"蚭", "	ni2",
		"蚬", "	xian3",
		"蚫", "	bao4",
		"蚪", "	dou3",
		"蚩", "	chi1",
		"蚨", "	fu2",
		"蚾", "	pi2",
		"蛀", "	zhu4",
		"蚦", "	ran2",
		"蛍", "	ying2",
		"蛗", "	fu4",
		"蛖", "	mang2",
		"蛕", "	hui2",
		"蛔", "	hui2",
		"蛓", "	ci4",
		"蛒", "	ge2",
		"蛑", "	mou2",
		"蛐", "	qu1",
		"蛏", "	cheng1",
		"蛎", "	li4",
		"蛌", "	gu3",
		"蛁", "	diao1",
		"蛋", "	dan4",
		"蛊", "	gu3",
		"蛉", "	ling2",
		"蛈", "	tie3",
		"蛇", "	she2",
		"蛆", "	qu1",
		"蛅", "	zhan1",
		"蛄", "	gu1",
		"蛃", "	bing3",
		"蛂", "	bie2",
		"蚧", "	jie4",
		"蚥", "	fu4",
		"蛙", "	wa1",
		"虿", "	chai4",
		"蚉", "	wen2",
		"蚈", "	qian1",
		"蚇", "	chi3",
		"蚆", "	ba1",
		"蚅", "	e4",
		"蚄", "	fang1",
		"蚃", "	xiang4",
		"蚂", "	ma3",
		"蚁", "	yi3",
		"蚀", "	shi2",
		"虾", "	xia1",
		"蚋", "	rui4",
		"虽", "	sui1",
		"虼", "	ge4",
		"虻", "	meng2",
		"虺", "	hui1",
		"虹", "	hong2",
		"虸", "	zi3",
		"虷", "	han2",
		"虶", "	yu1",
		"虵", "	she2",
		"虴", "	zhe2",
		"蚊", "	wen2",
		"蚌", "	bang4",
		"蚤", "	zao3",
		"蚙", "	qin2",
		"蚣", "	gong1",
		"蚢", "	hang2",
		"蚡", "	fen2",
		"蚠", "	fen2",
		"蚟", "	wang2",
		"蚞", "	mu4",
		"蚝", "	hao2",
		"蚜", "	ya2",
		"蚛", "	zhong4",
		"蚚", "	qi2",
		"蚘", "	hui2",
		"蚍", "	pi2",
		"蚗", "	jue2",
		"蚖", "	yuan2",
		"蚕", "	can2",
		"蚔", "	qi2",
		"蚓", "	yin3",
		"蚒", "	tong2",
		"蚑", "	qi2",
		"蚐", "	jun1",
		"蚏", "	yue4",
		"蚎", "	yue4",
		"蛘", "	yang2",
		"蛚", "	lie4",
		"虲", "	xia1",
		"蜛", "	ju1",
		"蜥", "	xi1",
		"蜤", "	si1",
		"蜣", "	qiang1",
		"蜢", "	meng3",
		"蜡", "	la4",
		"蜠", "	jun4",
		"蜟", "	yu4",
		"蜞", "	qi2",
		"蜝", "	qi2",
		"蜜", "	mi4",
		"蜚", "	fei1",
		"蜧", "	li4",
		"蜙", "	song1",
		"蜘", "	zhi1",
		"蜗", "	wo1",
		"蜖", "	hui2",
		"蜕", "	tui4",
		"蜔", "	dian4",
		"蜓", "	ting2",
		"蜒", "	yan2",
		"蜑", "	dan4",
		"蜐", "	jie2",
		"蜦", "	lun2",
		"蜨", "	die2",
		"蜎", "	yuan1",
		"蜵", "	yuan1",
		"蜿", "	wan1",
		"蜾", "	guo3",
		"蜽", "	liang3",
		"蜼", "	wei4",
		"蜻", "	qing1",
		"蜺", "	ni2",
		"蜹", "	rui4",
		"蜸", "	qian3",
		"蜷", "	quan2",
		"蜶", "	suo4",
		"蜴", "	yi4",
		"蜩", "	tiao2",
		"蜳", "	dun1",
		"蜲", "	wei1",
		"蜱", "	pi2",
		"蜰", "	fei2",
		"蜯", "	bang4",
		"蜮", "	yu4",
		"蜭", "	han4",
		"蜬", "	han2",
		"蜫", "	kun1",
		"蜪", "	tao2",
		"蜏", "	you3",
		"蜍", "	chu2",
		"蛛", "	zhu1",
		"蛧", "	wang3",
		"蛱", "	jia2",
		"蛰", "	zhe2",
		"蛯", "	lao",
		"蛮", "	man2",
		"蛭", "	zhi4",
		"蛬", "	qiong2",
		"蛫", "	gui3",
		"蛪", "	qie4",
		"蛩", "	qiong2",
		"蛨", "	mo4",
		"蛦", "	yi2",
		"蛳", "	si1",
		"蛥", "	she2",
		"蛤", "	ha2",
		"蛣", "	qi1",
		"蛢", "	ping2",
		"蛡", "	yi4",
		"蛠", "	li4",
		"蛟", "	jiao1",
		"蛞", "	kuo4",
		"蛝", "	xian2",
		"蛜", "	yi1",
		"蛲", "	nao2",
		"蛴", "	qi2",
		"蜌", "	bi4",
		"蜁", "	xuan2",
		"蜋", "	lang2",
		"蜊", "	li2",
		"蜉", "	fu2",
		"蜈", "	wu2",
		"蜇", "	zhe1",
		"蜆", "	xian4",
		"蜅", "	fu3",
		"蜄", "	shen4",
		"蜃", "	shen4",
		"蜂", "	feng1",
		"蜀", "	shu3",
		"蛵", "	xing1",
		"蛿", "	han4",
		"蛾", "	e2",
		"蛽", "	bai4",
		"蛼", "	che1",
		"蛻", "	tui4",
		"蛺", "	jia2",
		"蛹", "	yong3",
		"蛸", "	shao1",
		"蛷", "	qiu2",
		"蛶", "	jie4",
		"虳", "	jue2",
		"虱", "	shi1",
		"蝁", "	e4",
		"藣", "	bei1",
		"藭", "	qiong2",
		"藬", "	tui1",
		"藫", "	tan2",
		"藪", "	sou3",
		"藩", "	fan1",
		"藨", "	biao1",
		"藧", "	huan4",
		"藦", "	mo4",
		"藥", "	yao4",
		"藤", "	teng2",
		"藢", "	zhi3",
		"藯", "	wei4",
		"藡", "	di2",
		"藠", "	jiao4",
		"藟", "	lei3",
		"藞", "	la3",
		"藝", "	yi4",
		"藜", "	li2",
		"藛", "	xie3",
		"藚", "	xu4",
		"藙", "	yi4",
		"藘", "	lv2",
		"藮", "	qiao2",
		"藰", "	liu2",
		"藖", "	xian2",
		"藽", "	qin4",
		"蘇", "	su1",
		"蘆", "	lu2",
		"蘅", "	heng2",
		"蘄", "	qi2",
		"蘃", "	rui3",
		"蘂", "	rui3",
		"蘁", "	wu4",
		"蘀", "	tuo4",
		"藿", "	huo4",
		"藾", "	lai4",
		"藼", "	xuan1",
		"藱", "	hui4",
		"藻", "	zao3",
		"藺", "	lin4",
		"藹", "	ai3",
		"藸", "	chu2",
		"藷", "	shu3",
		"藶", "	li4",
		"藵", "	bao",
		"藴", "	yun4",
		"藳", "	gao3",
		"藲", "	ou",
		"藗", "	su4",
		"藕", "	ou3",
		"蘉", "	meng2",
		"薯", "	shu3",
		"薹", "	tai2",
		"薸", "	piao2",
		"薷", "	ru2",
		"薶", "	mai2",
		"薵", "	chou2",
		"薴", "	ning2",
		"薳", "	wei3",
		"薲", "	pin2",
		"薱", "	dui4",
		"薰", "	xun1",
		"薮", "	sou3",
		"薻", "	zao3",
		"薭", "	bai",
		"薬", "	yao4",
		"薫", "	xun1",
		"薪", "	xin1",
		"薩", "	sa4",
		"薨", "	hong1",
		"薧", "	hao1",
		"薦", "	jian4",
		"薥", "	shu3",
		"薤", "	xie4",
		"薺", "	ji4",
		"薼", "	chen2",
		"藔", "	liao2",
		"藉", "	ji2",
		"藓", "	xian3",
		"藒", "	qie4",
		"藑", "	qiong2",
		"藐", "	miao3",
		"藏", "	cang2",
		"藎", "	jin4",
		"藍", "	lan2",
		"藌", "	mi4",
		"藋", "	diao4",
		"藊", "	bian3",
		"藈", "	kui2",
		"薽", "	zhen1",
		"藇", "	xu4",
		"藆", "	jian3",
		"藅", "	fa2",
		"藄", "	qi2",
		"藃", "	xiao1",
		"藂", "	cong2",
		"藁", "	gao3",
		"藀", "	ying2",
		"薿", "	ni3",
		"薾", "	er3",
		"蘈", "	tui2",
		"蘊", "	yun4",
		"虰", "	ding1",
		"虋", "	men2",
		"處", "	chu4",
		"虔", "	qian2",
		"虓", "	xiao1",
		"虒", "	si1",
		"虑", "	lv4",
		"虐", "	nue4",
		"虏", "	lu3",
		"虎", "	hu3",
		"虍", "	hu1",
		"虌", "	bie1",
		"虊", "	luan2",
		"虗", "	xu1",
		"虉", "	yi4",
		"虈", "	xiao1",
		"虇", "	quan3",
		"虆", "	lei2",
		"虅", "	teng",
		"虄", "	sa4",
		"虃", "	jian1",
		"虂", "	lu4",
		"虁", "	kui2",
		"虀", "	ji1",
		"虖", "	hu1",
		"虘", "	cuo2",
		"蘾", "	huai4",
		"虥", "	zhan4",
		"虯", "	qiu2",
		"虮", "	ji3",
		"虭", "	diao1",
		"虬", "	qiu2",
		"虫", "	chong2",
		"虪", "	shu4",
		"虩", "	xi4",
		"虨", "	bin1",
		"虧", "	kui1",
		"虦", "	zhan4",
		"虤", "	yan2",
		"虙", "	fu2",
		"虣", "	bao4",
		"虢", "	guo2",
		"虡", "	ju4",
		"虠", "	jiao1",
		"號", "	hao4",
		"虞", "	yu2",
		"虝", "	hu3",
		"虜", "	lu3",
		"虛", "	xu1",
		"虚", "	xu1",
		"蘿", "	luo2",
		"蘽", "	lei3",
		"蘋", "	ping2",
		"蘗", "	bo4",
		"蘡", "	ying1",
		"蘠", "	qiang2",
		"蘟", "	yin3",
		"蘞", "	lian3",
		"蘝", "	lian4",
		"蘜", "	ju2",
		"蘛", "	yu2",
		"蘚", "	xian3",
		"蘙", "	yi4",
		"蘘", "	rang2",
		"蘖", "	nie4",
		"蘣", "	tou3",
		"蘕", "	feng",
		"蘔", "	jiong1",
		"蘓", "	su1",
		"蘒", "	qiu",
		"蘑", "	mo2",
		"蘐", "	xuan1",
		"蘏", "	jiong1",
		"蘎", "	ji4",
		"蘍", "	xun1",
		"蘌", "	yu3",
		"蘢", "	long2",
		"蘤", "	wei3",
		"蘼", "	mi2",
		"蘱", "	lei4",
		"蘻", "	ji4",
		"蘺", "	li2",
		"蘹", "	huai2",
		"蘸", "	zhan4",
		"蘷", "	kui2",
		"蘶", "	wei4",
		"蘵", "	zhi1",
		"蘴", "	feng1",
		"蘳", "	hui1",
		"蘲", "	lei2",
		"蘰", "	man",
		"蘥", "	yue4",
		"蘯", "	dang4",
		"蘮", "	ji4",
		"蘭", "	lan2",
		"蘬", "	kui1",
		"蘫", "	han4",
		"蘪", "	mei2",
		"蘩", "	fan2",
		"蘨", "	yao2",
		"蘧", "	qu2",
		"蘦", "	ling2",
		"蝀", "	dong1",
		"蝂", "	ban3",
		"裡", "	li3",
		"衔", "	xian2",
		"衞", "	wei4",
		"衝", "	chong1",
		"衜", "	dao4",
		"衛", "	wei4",
		"衚", "	hu2",
		"衙", "	ya2",
		"衘", "	xian2",
		"街", "	jie1",
		"衖", "	xiang4",
		"衕", "	tong4",
		"術", "	shu4",
		"衠", "	zhun1",
		"衒", "	xuan4",
		"衑", "	ling2",
		"衐", "	qu",
		"衏", "	yuan4",
		"衎", "	kan4",
		"衍", "	yan3",
		"行", "	xing2",
		"衋", "	xi4",
		"衊", "	mie4",
		"衉", "	ka1",
		"衟", "	dao4",
		"衡", "	heng2",
		"衇", "	mai4",
		"衮", "	gun3",
		"衸", "	jie4",
		"衷", "	zhong1",
		"衶", "	zhong4",
		"衵", "	yi4",
		"衴", "	dan3",
		"衳", "	zhong1",
		"衲", "	na4",
		"衱", "	jie2",
		"衰", "	shuai1",
		"衯", "	fen1",
		"衭", "	fu1",
		"衢", "	qu2",
		"衬", "	chen4",
		"衫", "	shan1",
		"衪", "	yi2",
		"衩", "	cha3",
		"表", "	biao3",
		"衧", "	yu2",
		"衦", "	gan3",
		"补", "	bu3",
		"衤", "	yi1",
		"衣", "	yi1",
		"衈", "	er4",
		"衆", "	zhong4",
		"衺", "	xie2",
		"蠠", "	min3",
		"蠪", "	long2",
		"蠩", "	zhu1",
		"蠨", "	xiao1",
		"蠧", "	du4",
		"蠦", "	lu2",
		"蠥", "	nie4",
		"蠤", "	qiu1",
		"蠣", "	li4",
		"蠢", "	chun3",
		"蠡", "	li2",
		"蠟", "	la4",
		"蠬", "	long2",
		"蠞", "	jie2",
		"蠝", "	lei2",
		"蠜", "	fan2",
		"蠛", "	mie4",
		"蠚", "	he1",
		"蠙", "	pin2",
		"蠘", "	jie2",
		"蠗", "	zhuo2",
		"蠖", "	huo4",
		"蠕", "	ru2",
		"蠫", "	li4",
		"蠭", "	feng1",
		"衅", "	xin4",
		"蠺", "	can2",
		"衄", "	nv4",
		"衃", "	pei1",
		"衂", "	niu4",
		"衁", "	huang1",
		"血", "	xue4",
		"蠿", "	zhuo1",
		"蠾", "	zhu2",
		"蠽", "	jie2",
		"蠼", "	qu2",
		"蠻", "	man2",
		"蠹", "	du4",
		"蠮", "	ye1",
		"蠸", "	quan2",
		"蠷", "	qu2",
		"蠶", "	can2",
		"蠵", "	xi1",
		"蠴", "	shu",
		"蠳", "	ying1",
		"蠲", "	juan1",
		"蠱", "	gu3",
		"蠰", "	nang2",
		"蠯", "	beng4",
		"衹", "	zhi3",
		"衻", "	ran2",
		"蠓", "	meng3",
		"袼", "	ge1",
		"裆", "	dang1",
		"装", "	zhuang1",
		"裄", "	xing",
		"裃", "	ka",
		"裂", "	lie4",
		"裁", "	cai2",
		"裀", "	yin1",
		"袿", "	gui1",
		"袾", "	zhu1",
		"袽", "	ru2",
		"袻", "	er2",
		"裈", "	kun1",
		"袺", "	jie2",
		"袹", "	bo2",
		"袸", "	jian4",
		"袷", "	jia2",
		"袶", "	jiang4",
		"袵", "	ren4",
		"袴", "	ku4",
		"袳", "	chi3",
		"袲", "	chi3",
		"袱", "	fu2",
		"裇", "	xu1",
		"裉", "	ken4",
		"袯", "	bo2",
		"裖", "	zhen3",
		"裠", "	qun2",
		"裟", "	sha1",
		"裞", "	shui4",
		"裝", "	zhuang1",
		"補", "	bu3",
		"裛", "	yi4",
		"裚", "	ji4",
		"裙", "	qun2",
		"裘", "	qiu2",
		"裗", "	liu2",
		"裕", "	yu4",
		"裊", "	niao3",
		"裔", "	yi4",
		"裓", "	ge2",
		"裒", "	pou2",
		"裑", "	shen1",
		"裐", "	juan1",
		"裏", "	li3",
		"裎", "	cheng2",
		"裍", "	kun3",
		"裌", "	jia2",
		"裋", "	shu4",
		"袰", "	bo1",
		"袮", "	ni",
		"衼", "	zhi1",
		"袈", "	jia1",
		"袒", "	tan3",
		"袑", "	shao4",
		"袐", "	bi4",
		"袏", "	zuo4",
		"袎", "	yao4",
		"袍", "	pao2",
		"袌", "	bao4",
		"袋", "	dai4",
		"袊", "	ling3",
		"袉", "	tuo2",
		"袇", "	ran2",
		"袔", "	he4",
		"袆", "	hui1",
		"袅", "	niao3",
		"袄", "	ao3",
		"袃", "	chai4",
		"袂", "	mei4",
		"袁", "	yuan2",
		"袀", "	jun1",
		"衿", "	jin1",
		"衾", "	qin1",
		"衽", "	ren4",
		"袓", "	ju4",
		"袕", "	xue2",
		"袭", "	xi2",
		"袢", "	pan4",
		"袬", "	gun3",
		"被", "	bei4",
		"袪", "	qu1",
		"袩", "	zhe2",
		"袨", "	xuan4",
		"袧", "	gou1",
		"袦", "	na4",
		"袥", "	tuo1",
		"袤", "	mao4",
		"袣", "	yi4",
		"袡", "	ran2",
		"袖", "	xiu4",
		"袠", "	zhi4",
		"袟", "	zhi4",
		"袞", "	gun3",
		"袝", "	fu4",
		"袜", "	wa4",
		"袛", "	di1",
		"袚", "	bo1",
		"袙", "	pa4",
		"袘", "	yi2",
		"袗", "	zhen3",
		"蠔", "	hao2",
		"蠒", "	jian3",
		"蝃", "	di4",
		"螃", "	pang2",
		"融", "	rong2",
		"螌", "	ban1",
		"螋", "	sou1",
		"螊", "	lian2",
		"螉", "	weng1",
		"螈", "	yuan2",
		"螇", "	xi1",
		"螆", "	ci4",
		"螅", "	xi1",
		"螄", "	si1",
		"螂", "	lang2",
		"螏", "	ji2",
		"螁", "	ban",
		"螀", "	jiang1",
		"蝿", "	ying2",
		"蝾", "	rong2",
		"蝽", "	chun1",
		"蝼", "	lou2",
		"蝻", "	nan3",
		"蝺", "	qu3",
		"蝹", "	yun1",
		"蝸", "	wo1",
		"螎", "	rong2",
		"螐", "	wu1",
		"蝶", "	die2",
		"螝", "	gui1",
		"螧", "	qi",
		"螦", "	sao",
		"螥", "	cang1",
		"螤", "	zhong1",
		"螣", "	te4",
		"螢", "	ying2",
		"螡", "	wen2",
		"螠", "	yi4",
		"螟", "	ming2",
		"螞", "	ma3",
		"螜", "	hu2",
		"螑", "	xiu4",
		"螛", "	he2",
		"螚", "	nai4",
		"螙", "	du4",
		"螘", "	yi3",
		"螗", "	tang2",
		"螖", "	hua2",
		"螕", "	bi1",
		"螔", "	yi2",
		"螓", "	qin2",
		"螒", "	han4",
		"蝷", "	li4",
		"蝵", "	qiu1",
		"螩", "	tiao",
		"蝏", "	ting2",
		"蝙", "	bian1",
		"蝘", "	yan3",
		"蝗", "	huang2",
		"蝖", "	xuan1",
		"蝕", "	shi2",
		"蝔", "	jie1",
		"蝓", "	yu2",
		"蝒", "	mian2",
		"蝑", "	xu1",
		"蝐", "	mao4",
		"蝎", "	xie1",
		"蝛", "	wei1",
		"蝍", "	jie2",
		"蝌", "	ke1",
		"蝋", "	la4",
		"蝊", "	ding4",
		"蝉", "	chan2",
		"蝈", "	guo1",
		"蝇", "	ying2",
		"蝆", "	yang3",
		"蝅", "	can2",
		"蝄", "	wang3",
		"蝚", "	rou2",
		"蝜", "	fu4",
		"蝴", "	hu2",
		"蝩", "	chong2",
		"蝳", "	du2",
		"蝲", "	la4",
		"蝱", "	meng2",
		"蝰", "	kui2",
		"蝯", "	yuan2",
		"蝮", "	fu4",
		"蝭", "	ti2",
		"蝬", "	zong1",
		"蝫", "	zhu1",
		"蝪", "	tang1",
		"蝨", "	shi1",
		"蝝", "	yuan2",
		"蝧", "	ying1",
		"蝦", "	xia1",
		"蝥", "	mao2",
		"蝤", "	qiu2",
		"蝣", "	you2",
		"蝢", "	xie2",
		"蝡", "	ru2",
		"蝠", "	fu2",
		"蝟", "	wei4",
		"蝞", "	mei4",
		"螨", "	man3",
		"螪", "	shang1",
		"蠑", "	rong2",
		"蟬", "	chan2",
		"蟶", "	cheng1",
		"蟵", "	chu",
		"蟴", "	si1",
		"蟳", "	xun2",
		"蟲", "	chong2",
		"蟱", "	wu2",
		"蟰", "	xiao1",
		"蟯", "	nao2",
		"蟮", "	shan4",
		"蟭", "	jiao1",
		"蟫", "	yin2",
		"蟸", "	li3",
		"蟪", "	hui4",
		"蟩", "	jue2",
		"蟨", "	jue2",
		"蟧", "	lao2",
		"蟦", "	fei2",
		"蟥", "	huang2",
		"蟤", "	zhuan1",
		"蟣", "	ji3",
		"蟢", "	xi3",
		"蟡", "	gui3",
		"蟷", "	dang1",
		"蟹", "	xie4",
		"蟟", "	liao2",
		"蠆", "	chai4",
		"蠐", "	qi2",
		"蠏", "	xie4",
		"蠎", "	mang3",
		"蠍", "	xie1",
		"蠌", "	ze2",
		"蠋", "	zhu2",
		"蠊", "	lian2",
		"蠉", "	xuan1",
		"蠈", "	zei2",
		"蠇", "	li4",
		"蠅", "	ying2",
		"蟺", "	shan4",
		"蠄", "	qin2",
		"蠃", "	luo3",
		"蠂", "	she4",
		"蠁", "	xiang3",
		"蠀", "	ci1",
		"蟿", "	qi4",
		"蟾", "	chan2",
		"蟽", "	da2",
		"蟼", "	jing3",
		"蟻", "	yi3",
		"蟠", "	pan2",
		"蟞", "	bie1",
		"螫", "	shi4",
		"螷", "	pi2",
		"蟁", "	wen2",
		"蟀", "	shuai4",
		"螿", "	jiang1",
		"螾", "	yin3",
		"螽", "	zhong1",
		"螼", "	qin3",
		"螻", "	lou2",
		"螺", "	luo2",
		"螹", "	jian4",
		"螸", "	yu2",
		"螶", "	qu2",
		"蟃", "	wan4",
		"螵", "	piao1",
		"螴", "	chen2",
		"螳", "	tang2",
		"螲", "	zhi4",
		"螱", "	wei4",
		"螰", "	lu4",
		"螯", "	ao2",
		"螮", "	di4",
		"螭", "	chi1",
		"螬", "	cao2",
		"蟂", "	xiao1",
		"蟄", "	zhe2",
		"蟝", "	qu2",
		"蟒", "	mang3",
		"蟜", "	jiao3",
		"蟛", "	peng2",
		"蟚", "	peng2",
		"蟙", "	zhi2",
		"蟘", "	te4",
		"蟗", "	qiu1",
		"蟖", "	si1",
		"蟕", "	zui1",
		"蟔", "	mo4",
		"蟓", "	xiang4",
		"蟑", "	zhang1",
		"蟅", "	zhe4",
		"蟐", "	chang",
		"蟏", "	xiao1",
		"蟎", "	man3",
		"蟍", "	li2",
		"蟌", "	cong1",
		"蟋", "	xi1",
		"蟊", "	mao2",
		"蟉", "	liu2",
		"蟈", "	guo1",
		"蟇", "	ma2",
		"蟆", "	ma2",
		"谢", "	xie4",
		"谤", "	bang4",
		"銤", "	mi3",
		"遶", "	rao4",
		"邀", "	yao1",
		"避", "	bi4",
		"遾", "	shi4",
		"遽", "	ju4",
		"遼", "	liao2",
		"遻", "	wu4",
		"遺", "	yi2",
		"遹", "	yu4",
		"選", "	xuan3",
		"遷", "	qian1",
		"遵", "	zun1",
		"邂", "	xie4",
		"遴", "	lin2",
		"遳", "	cuo1",
		"遲", "	chi2",
		"遱", "	lou2",
		"遰", "	di4",
		"遯", "	dun4",
		"遮", "	zhe1",
		"遭", "	zao1",
		"遬", "	su4",
		"遫", "	chi4",
		"邁", "	mai4",
		"邃", "	sui4",
		"適", "	shi4",
		"邐", "	li3",
		"邚", "	ru2",
		"邙", "	mang2",
		"邘", "	yu2",
		"邗", "	han2",
		"邖", "	shan1",
		"邕", "	yong1",
		"邔", "	qi3",
		"邓", "	deng4",
		"邒", "	ting2",
		"邑", "	yi4",
		"邏", "	luo2",
		"還", "	hai2",
		"邎", "	yao2",
		"邍", "	yuan2",
		"邌", "	li2",
		"邋", "	la1",
		"邊", "	bian1",
		"邉", "	bian1",
		"邈", "	miao3",
		"邇", "	er3",
		"邆", "	teng2",
		"邅", "	zhan1",
		"遪", "	ca4",
		"遨", "	ao2",
		"邜", "	wan",
		"遂", "	sui4",
		"遌", "	e4",
		"運", "	yun4",
		"遊", "	you2",
		"遉", "	zhen1",
		"遈", "	shi2",
		"遇", "	yu4",
		"遆", "	ti2",
		"遅", "	chi2",
		"遄", "	chuan2",
		"遃", "	yan3",
		"遁", "	dun4",
		"過", "	guo4",
		"遀", "	sui2",
		"逿", "	dang4",
		"逾", "	yu2",
		"逽", "	nuo4",
		"逼", "	bi1",
		"逻", "	luo2",
		"逺", "	yuan3",
		"逹", "	da2",
		"逸", "	yi4",
		"逷", "	ti4",
		"遍", "	bian4",
		"遏", "	e4",
		"遧", "	zhang1",
		"遜", "	xun4",
		"遦", "	guan4",
		"遥", "	yao2",
		"遤", "	ma",
		"遣", "	qian3",
		"遢", "	ta4",
		"遡", "	su4",
		"遠", "	yuan3",
		"遟", "	chi2",
		"遞", "	di4",
		"遝", "	ta4",
		"遛", "	liu2",
		"遐", "	xia2",
		"遚", "	chou4",
		"遙", "	yao2",
		"遘", "	gou4",
		"遗", "	yi2",
		"遖", "	nan",
		"違", "	wei2",
		"達", "	da2",
		"道", "	dao4",
		"遒", "	qiu2",
		"遑", "	huang2",
		"邛", "	qiong2",
		"邝", "	kuang4",
		"逵", "	kui2",
		"郞", "	lang2",
		"部", "	bu4",
		"郧", "	yun2",
		"郦", "	li4",
		"郥", "	bei4",
		"郤", "	xi4",
		"郣", "	bo2",
		"郢", "	ying3",
		"郡", "	jun4",
		"郠", "	geng3",
		"郟", "	jia2",
		"郝", "	hao3",
		"郪", "	qi1",
		"郜", "	gao4",
		"郛", "	fu2",
		"郚", "	wu2",
		"郙", "	fu3",
		"郘", "	lv2",
		"郗", "	xi1",
		"郖", "	dou4",
		"郕", "	cheng2",
		"郔", "	yan2",
		"郓", "	yun4",
		"郩", "	xiao2",
		"郫", "	pi2",
		"郑", "	zheng4",
		"郸", "	dan1",
		"鄂", "	e4",
		"鄁", "	bei4",
		"鄀", "	ruo4",
		"郿", "	mei2",
		"郾", "	yan3",
		"都", "	dou1",
		"郼", "	yi1",
		"郻", "	qiao1",
		"郺", "	yong1",
		"郹", "	ju2",
		"郷", "	xiang1",
		"郬", "	qing1",
		"郶", "	bu4",
		"郵", "	you2",
		"郴", "	chen1",
		"郳", "	ni2",
		"郲", "	lai2",
		"郱", "	ping2",
		"郰", "	zou1",
		"郯", "	tan2",
		"郮", "	zhou1",
		"郭", "	guo1",
		"郒", "	lang",
		"郐", "	kuai4",
		"邞", "	fu1",
		"邪", "	xie2",
		"邴", "	bing3",
		"邳", "	pi1",
		"邲", "	bi4",
		"邱", "	qiu1",
		"邰", "	tai2",
		"邯", "	han2",
		"邮", "	you2",
		"邭", "	ju4",
		"邬", "	wu1",
		"邫", "	bang1",
		"邩", "	huo3",
		"邶", "	bei4",
		"邨", "	cun1",
		"邧", "	yuan2",
		"邦", "	bang1",
		"邥", "	shen3",
		"邤", "	xin1",
		"那", "	na4",
		"邢", "	xing2",
		"邡", "	fang1",
		"邠", "	bin1",
		"邟", "	kang4",
		"邵", "	shao4",
		"邷", "	wa3",
		"郏", "	jia2",
		"郄", "	qie4",
		"郎", "	lang2",
		"郍", "	nuo2",
		"郌", "	gui1",
		"郋", "	xi2",
		"郊", "	jiao1",
		"郉", "	xing2",
		"郈", "	hou4",
		"郇", "	huan2",
		"郆", "	ji2",
		"郅", "	zhi4",
		"郃", "	he2",
		"邸", "	di3",
		"郂", "	gai1",
		"郁", "	yu4",
		"郀", "	ku1",
		"邿", "	shi1",
		"邾", "	zhu1",
		"邽", "	gui1",
		"邼", "	kuang1",
		"邻", "	lin2",
		"邺", "	ye4",
		"邹", "	zou1",
		"逶", "	wei1",
		"逴", "	chuo1",
		"鄄", "	juan4",
		"辦", "	ban4",
		"辰", "	chen2",
		"辯", "	bian4",
		"辮", "	bian4",
		"辭", "	ci2",
		"辬", "	ban1",
		"辫", "	bian4",
		"辪", "	xue1",
		"辩", "	bian4",
		"辨", "	bian4",
		"辧", "	bian4",
		"辥", "	xue1",
		"農", "	nong2",
		"辤", "	ci2",
		"辣", "	la4",
		"辢", "	la4",
		"辡", "	bian4",
		"辠", "	zui4",
		"辟", "	pi4",
		"辞", "	ci2",
		"辝", "	ci2",
		"辜", "	gu1",
		"辛", "	xin1",
		"辱", "	ru3",
		"辳", "	nong2",
		"辙", "	zhe2",
		"迀", "	gan1",
		"迊", "	za1",
		"迉", "	qi1",
		"迈", "	mai4",
		"过", "	guo4",
		"迆", "	yi2",
		"迅", "	xun4",
		"迄", "	qi4",
		"迃", "	yu1",
		"迂", "	yu1",
		"迁", "	qian1",
		"辿", "	chan1",
		"辴", "	chan3",
		"达", "	da2",
		"辽", "	liao2",
		"込", "	ru",
		"辻", "	shi2",
		"辺", "	bian1",
		"边", "	bian1",
		"辸", "	reng2",
		"辷", "	yi",
		"辶", "	chuo4",
		"辵", "	chuo4",
		"辚", "	lin2",
		"辘", "	lu4",
		"迌", "	tu4",
		"轲", "	ke1",
		"轼", "	shi4",
		"轻", "	qing1",
		"轺", "	yao2",
		"轹", "	li4",
		"轸", "	zhen3",
		"轷", "	hu1",
		"轶", "	yi4",
		"轵", "	zhi3",
		"轴", "	zhou2",
		"轳", "	lu2",
		"轱", "	gu1",
		"轾", "	zhi4",
		"轰", "	hong1",
		"软", "	ruan3",
		"轮", "	lun2",
		"轭", "	e4",
		"转", "	zhuan3",
		"轫", "	ren4",
		"轪", "	dai4",
		"轩", "	xuan1",
		"轨", "	gui3",
		"轧", "	ya4",
		"载", "	zai4",
		"轿", "	jiao4",
		"辗", "	nian3",
		"辌", "	liang2",
		"辖", "	xia2",
		"辕", "	yuan2",
		"辔", "	pei4",
		"输", "	shu1",
		"辒", "	wen1",
		"辑", "	ji2",
		"辐", "	fu2",
		"辏", "	cou4",
		"辎", "	zi1",
		"辍", "	chuo4",
		"辋", "	wang3",
		"辀", "	zhou1",
		"辊", "	gun3",
		"辉", "	hui1",
		"辈", "	bei4",
		"辇", "	nian3",
		"辆", "	liang4",
		"辅", "	fu3",
		"辄", "	zhe2",
		"较", "	jiao4",
		"辂", "	lu4",
		"辁", "	quan2",
		"迋", "	wang4",
		"迍", "	zhun1",
		"逳", "	yu4",
		"逎", "	qiu2",
		"逘", "	yi3",
		"逗", "	dou4",
		"逖", "	ti4",
		"逕", "	jing4",
		"途", "	tu2",
		"逓", "	di4",
		"递", "	di4",
		"逑", "	qiu2",
		"逐", "	zhu2",
		"透", "	tou4",
		"逍", "	xiao1",
		"通", "	tong1",
		"逌", "	you1",
		"逋", "	bu1",
		"逊", "	xun4",
		"选", "	xuan3",
		"逈", "	jiong3",
		"逇", "	dun4",
		"逆", "	ni4",
		"逅", "	hou4",
		"逄", "	pang2",
		"逃", "	tao2",
		"這", "	zhe4",
		"逛", "	guang4",
		"送", "	song4",
		"逨", "	lai2",
		"進", "	jin4",
		"週", "	zhou1",
		"逰", "	you2",
		"逯", "	lu4",
		"逮", "	dai3",
		"逭", "	huan4",
		"逬", "	beng4",
		"逫", "	jue2",
		"逪", "	cuo4",
		"逩", "	ben4",
		"逧", "	gu",
		"逜", "	wu4",
		"逦", "	li3",
		"逥", "	hui2",
		"逤", "	suo4",
		"連", "	lian2",
		"逢", "	feng2",
		"逡", "	qun1",
		"造", "	zao4",
		"速", "	su4",
		"逞", "	cheng3",
		"逝", "	shi4",
		"适", "	shi4",
		"退", "	tui4",
		"迎", "	ying2",
		"迚", "	zhong",
		"迤", "	yi2",
		"迣", "	zhi4",
		"迢", "	tiao2",
		"迡", "	ni4",
		"迠", "	che4",
		"迟", "	chi2",
		"连", "	lian2",
		"违", "	wei2",
		"远", "	yuan3",
		"进", "	jin4",
		"这", "	zhe4",
		"迦", "	jia1",
		"还", "	hai2",
		"迗", "	e2",
		"迖", "	da2",
		"迕", "	wu4",
		"返", "	fan3",
		"迓", "	ya4",
		"迒", "	hang2",
		"近", "	jin4",
		"运", "	yun4",
		"迏", "	ti4",
		"迥", "	jiong3",
		"迧", "	chen2",
		"迿", "	xun4",
		"迴", "	hui2",
		"迾", "	lie4",
		"追", "	zhui1",
		"迼", "	jie2",
		"迻", "	yi2",
		"迺", "	nai3",
		"迹", "	ji1",
		"迸", "	beng4",
		"迷", "	mi2",
		"迶", "	you4",
		"迵", "	dong4",
		"迳", "	jing4",
		"迨", "	dai4",
		"迲", "	qu",
		"迱", "	tuo2",
		"述", "	shu4",
		"迯", "	tao2",
		"迮", "	ze2",
		"迭", "	die2",
		"迬", "	zhu4",
		"迫", "	po4",
		"迪", "	di2",
		"迩", "	er3",
		"鄃", "	shu1",
		"鄅", "	yu3",
		"轥", "	lin4",
		"鈗", "	yun3",
		"鈡", "	zhong1",
		"鈠", "	yi4",
		"鈟", "	shi1",
		"鈞", "	jun1",
		"鈝", "	yin2",
		"鈜", "	hong2",
		"鈛", "	guo1",
		"鈚", "	pi1",
		"鈙", "	qin2",
		"鈘", "	ji3",
		"鈖", "	fen1",
		"鈣", "	gai4",
		"鈕", "	niu3",
		"鈔", "	chao1",
		"鈓", "	ren2",
		"鈒", "	sa4",
		"鈑", "	ban3",
		"鈐", "	qian2",
		"鈏", "	yin3",
		"鈎", "	gou1",
		"鈍", "	dun4",
		"鈌", "	jue2",
		"鈢", "	xi3",
		"鈤", "	ri4",
		"鈊", "	xin1",
		"鈱", "	min2",
		"鈻", "	si4",
		"鈺", "	yu4",
		"鈹", "	pi1",
		"鈸", "	bo2",
		"鈷", "	gu3",
		"鈶", "	si4",
		"鈵", "	bing3",
		"鈴", "	ling2",
		"鈳", "	ke1",
		"鈲", "	gu1",
		"鈰", "	shi4",
		"鈥", "	huo3",
		"鈯", "	tu2",
		"鈮", "	ni3",
		"鈭", "	zi1",
		"鈬", "	duo2",
		"鈫", "	wen",
		"鈪", "	e4",
		"鈩", "	lu",
		"鈨", "	yuan",
		"鈧", "	kang4",
		"鈦", "	tai4",
		"鈋", "	e2",
		"鈉", "	na4",
		"鈽", "	bu1",
		"釣", "	diao4",
		"釭", "	gang1",
		"釬", "	han4",
		"釫", "	hua2",
		"釪", "	hua2",
		"釩", "	fan3",
		"釨", "	zi3",
		"釧", "	chuan4",
		"釦", "	kou4",
		"釥", "	qiao3",
		"釤", "	shan4",
		"釢", "	nai3",
		"釯", "	mang2",
		"釡", "	fu3",
		"釠", "	luan4",
		"釟", "	ba1",
		"釞", "	zhi2",
		"針", "	zhen1",
		"釜", "	fu3",
		"釛", "	ba1",
		"釚", "	qiu2",
		"釙", "	po4",
		"釘", "	ding1",
		"釮", "	qi2",
		"釰", "	ri4",
		"鈈", "	pi1",
		"釽", "	pi4",
		"鈇", "	fu1",
		"鈆", "	qian1",
		"鈅", "	yue4",
		"鈄", "	dou3",
		"鈃", "	xing2",
		"鈂", "	chen2",
		"鈁", "	fang1",
		"鈀", "	ba3",
		"釿", "	jin1",
		"釾", "	ye2",
		"釼", "	jian4",
		"釱", "	di4",
		"釻", "	qiu",
		"釺", "	qian1",
		"釹", "	nv3",
		"釸", "	xi1",
		"釷", "	tu3",
		"釶", "	shi1",
		"釵", "	chai1",
		"釴", "	yi4",
		"釳", "	xi4",
		"釲", "	si4",
		"鈼", "	zuo2",
		"鈾", "	you2",
		"釖", "	dao1",
		"鉿", "	jia1",
		"銉", "	yu4",
		"銈", "	ji1",
		"銇", "	lei4",
		"銆", "	mo4",
		"銅", "	tong2",
		"銄", "	xiang3",
		"銃", "	chong4",
		"銂", "	zhou1",
		"銁", "	jun1",
		"銀", "	yin2",
		"鉾", "	mou2",
		"銋", "	ren2",
		"鉽", "	shi4",
		"鉼", "	bing3",
		"鉻", "	luo4",
		"鉺", "	er4",
		"鉹", "	chi3",
		"鉸", "	jiao3",
		"鉷", "	hong2",
		"鉶", "	xing2",
		"鉵", "	tong2",
		"鉴", "	jian4",
		"銊", "	xu4",
		"銌", "	zun4",
		"鉲", "	ka3",
		"銙", "	kua3",
		"銣", "	ru2",
		"銢", "	pi3",
		"銡", "	ji2",
		"銠", "	lao3",
		"銟", "	cha1",
		"銞", "	jun1",
		"銝", "	xiu1",
		"銜", "	xian2",
		"銛", "	xian1",
		"銚", "	yao2",
		"銘", "	ming2",
		"銍", "	zhi4",
		"銗", "	xiang4",
		"銖", "	zhu1",
		"銕", "	tie3",
		"銔", "	pi1",
		"銓", "	quan2",
		"銒", "	xing2",
		"銑", "	xian3",
		"銐", "	chi4",
		"銏", "	shan4",
		"銎", "	qiong2",
		"鉳", "	bei3",
		"鉱", "	kuang4",
		"鈿", "	tian2",
		"鉋", "	bao4",
		"鉕", "	po1",
		"鉔", "	za1",
		"鉓", "	chi4",
		"鉒", "	zhu4",
		"鉑", "	bo2",
		"鉐", "	shi2",
		"鉏", "	chu2",
		"鉎", "	sheng1",
		"鉍", "	bi4",
		"鉌", "	he2",
		"鉊", "	zhao1",
		"鉗", "	qian2",
		"鉉", "	xuan4",
		"鉈", "	shi1",
		"鉇", "	shi1",
		"鉆", "	chan1",
		"鉅", "	ju4",
		"鉄", "	zhi2",
		"鉃", "	shi4",
		"鉂", "	shi3",
		"鉁", "	zhen1",
		"鉀", "	jia3",
		"鉖", "	tong2",
		"鉘", "	fu2",
		"鉰", "	si1",
		"鉥", "	shu4",
		"鉯", "	yi3",
		"鉮", "	huan2",
		"鉭", "	tan3",
		"鉬", "	mu4",
		"鉫", "	jia1",
		"鉪", "	di4",
		"鉩", "	xi3",
		"鉨", "	xi3",
		"鉧", "	mu3",
		"鉦", "	zheng1",
		"鉤", "	gou1",
		"鉙", "	zhai3",
		"鉣", "	jie2",
		"鉢", "	bo1",
		"鉡", "	ban4",
		"鉠", "	yang1",
		"鉟", "	pi1",
		"鉞", "	yue4",
		"鉝", "	li4",
		"鉜", "	fu2",
		"鉛", "	qian1",
		"鉚", "	liu3",
		"釗", "	zhao1",
		"釕", "	liao3",
		"鄆", "	yun4",
		"酆", "	feng1",
		"酐", "	gan1",
		"酏", "	yi3",
		"酎", "	zhou4",
		"配", "	pei4",
		"酌", "	zhuo2",
		"酋", "	qiu2",
		"酊", "	ding1",
		"酉", "	you3",
		"酈", "	li4",
		"酇", "	zan4",
		"酅", "	xi1",
		"酒", "	jiu3",
		"酄", "	huan1",
		"酃", "	ling2",
		"酂", "	cuo2",
		"酁", "	chan2",
		"酀", "	yan4",
		"鄿", "	ji1",
		"鄾", "	you1",
		"鄽", "	chan2",
		"鄼", "	zan4",
		"鄻", "	lian3",
		"酑", "	yu2",
		"酓", "	yan3",
		"鄹", "	zou1",
		"酠", "	qia3",
		"酪", "	lao4",
		"酩", "	ming3",
		"酨", "	zai4",
		"酧", "	chou2",
		"酦", "	fa1",
		"酥", "	su1",
		"酤", "	gu1",
		"酣", "	han1",
		"酢", "	cu4",
		"酡", "	tuo2",
		"酟", "	tian1",
		"酔", "	zui4",
		"酞", "	tai4",
		"酝", "	yun4",
		"酜", "	fu",
		"酛", "	yuan",
		"酚", "	fen1",
		"酙", "	zhen1",
		"酘", "	dou4",
		"酗", "	xu4",
		"酖", "	zhen4",
		"酕", "	mao2",
		"鄺", "	kuang4",
		"鄸", "	meng2",
		"酬", "	chou2",
		"鄒", "	zou1",
		"鄜", "	fu1",
		"鄛", "	chao2",
		"鄚", "	mao4",
		"鄙", "	bi3",
		"鄘", "	yong1",
		"鄗", "	hao4",
		"鄖", "	yun2",
		"鄕", "	xiang1",
		"鄔", "	wu1",
		"鄓", "	ye4",
		"鄑", "	zi1",
		"鄞", "	yin2",
		"鄐", "	chu4",
		"鄏", "	ru3",
		"鄎", "	xi1",
		"鄍", "	ming2",
		"鄌", "	tang2",
		"鄋", "	sou1",
		"鄊", "	xiang1",
		"鄉", "	xiang1",
		"鄈", "	kui2",
		"鄇", "	hou2",
		"鄝", "	liao3",
		"鄟", "	zhuan1",
		"鄷", "	feng1",
		"鄬", "	wei2",
		"鄶", "	kuai4",
		"鄵", "	cao4",
		"鄴", "	ye4",
		"鄳", "	meng2",
		"鄲", "	dan1",
		"鄱", "	po2",
		"鄰", "	lin2",
		"鄯", "	shan4",
		"鄮", "	mao4",
		"鄭", "	zheng4",
		"鄫", "	zeng1",
		"鄠", "	hu4",
		"鄪", "	bi4",
		"鄩", "	xun2",
		"鄨", "	bi4",
		"鄧", "	deng4",
		"鄦", "	xu3",
		"鄥", "	qiao1",
		"鄤", "	man4",
		"鄣", "	zhang1",
		"鄢", "	yan1",
		"鄡", "	qiao1",
		"酫", "	chuo4",
		"酭", "	you4",
		"釔", "	yi3",
		"醯", "	xi1",
		"醹", "	ru2",
		"醸", "	niang4",
		"醷", "	yi4",
		"醶", "	yan4",
		"醵", "	ju4",
		"醴", "	li3",
		"醳", "	yi4",
		"醲", "	nong2",
		"醱", "	fa1",
		"醰", "	tan2",
		"醮", "	jiao4",
		"醻", "	chou2",
		"醭", "	bu2",
		"醬", "	jiang4",
		"醫", "	yi1",
		"醪", "	lao2",
		"醩", "	zao1",
		"醨", "	li2",
		"醧", "	yu4",
		"醦", "	chen3",
		"醥", "	piao3",
		"醤", "	jiang4",
		"醺", "	xun1",
		"醼", "	yan4",
		"醢", "	hai3",
		"釉", "	you4",
		"釓", "	qiu2",
		"釒", "	jin1",
		"金", "	jin1",
		"釐", "	li2",
		"量", "	liang4",
		"野", "	ye3",
		"重", "	zhong4",
		"里", "	li3",
		"釋", "	shi4",
		"释", "	shi4",
		"釈", "	shi4",
		"醽", "	ling2",
		"采", "	cai3",
		"釆", "	bian4",
		"釅", "	yan4",
		"釄", "	mi2",
		"釃", "	shai1",
		"釂", "	jiao4",
		"釁", "	xin4",
		"釀", "	niang4",
		"醿", "	mi2",
		"醾", "	mi2",
		"醣", "	tang2",
		"醡", "	zha4",
		"酮", "	tong2",
		"酺", "	pu2",
		"醄", "	tao2",
		"醃", "	yan1",
		"醂", "	lan3",
		"醁", "	lu4",
		"醀", "	wei2",
		"酿", "	niang4",
		"酾", "	shai1",
		"酽", "	yan4",
		"酼", "	hai3",
		"酻", "	zui4",
		"酹", "	lei4",
		"醆", "	zhan3",
		"酸", "	suan1",
		"酷", "	ku4",
		"酶", "	mei2",
		"酵", "	jiao4",
		"酴", "	tu2",
		"酳", "	yin4",
		"酲", "	cheng2",
		"酱", "	jiang4",
		"酰", "	xian1",
		"酯", "	zhi3",
		"醅", "	pei1",
		"醇", "	chun2",
		"醠", "	ang4",
		"醕", "	chun2",
		"醟", "	yong4",
		"醞", "	yun4",
		"醝", "	cuo1",
		"醜", "	chou3",
		"醛", "	quan2",
		"醚", "	mi2",
		"醙", "	sou1",
		"醘", "	ke1",
		"醗", "	po4",
		"醖", "	yun4",
		"醔", "	qiu2",
		"醈", "	tan2",
		"醓", "	tan3",
		"醒", "	xing3",
		"醑", "	xu3",
		"醐", "	hu2",
		"醏", "	du1",
		"醎", "	xian2",
		"醍", "	ti2",
		"醌", "	kun1",
		"醋", "	cu4",
		"醊", "	zhui4",
		"醉", "	zui4",
		"车", "	che1",
		"轤", "	lu2",
		"谥", "	shi4",
		"贵", "	gui4",
		"贿", "	hui4",
		"贾", "	jia3",
		"贽", "	zhi4",
		"贼", "	zei2",
		"贻", "	yi2",
		"贺", "	he4",
		"费", "	fei4",
		"贸", "	mao4",
		"贷", "	dai4",
		"贶", "	kuang4",
		"贴", "	tie1",
		"赁", "	lin4",
		"贳", "	shi4",
		"贲", "	ben1",
		"贱", "	jian4",
		"贰", "	er4",
		"贯", "	guan4",
		"贮", "	zhu4",
		"购", "	gou4",
		"贬", "	bian3",
		"贫", "	pin2",
		"贪", "	tan1",
		"赀", "	zi1",
		"赂", "	lu4",
		"质", "	zhi4",
		"赏", "	shang3",
		"赙", "	fu4",
		"赘", "	zhui4",
		"赗", "	feng4",
		"赖", "	lai4",
		"赕", "	dan3",
		"赔", "	pei2",
		"赓", "	geng1",
		"赒", "	zhou1",
		"赑", "	bi4",
		"赐", "	ci4",
		"赎", "	shu2",
		"赃", "	zang1",
		"赍", "	ji1",
		"赌", "	du3",
		"赋", "	fu4",
		"赊", "	she1",
		"赉", "	lai4",
		"赈", "	zhen4",
		"赇", "	qiu2",
		"赆", "	jin4",
		"赅", "	gai1",
		"资", "	zi1",
		"贩", "	fan4",
		"货", "	huo4",
		"赛", "	sai4",
		"贁", "	bai4",
		"贋", "	yan4",
		"贊", "	zan4",
		"贉", "	dan4",
		"贈", "	zeng4",
		"贇", "	yun1",
		"贆", "	biao1",
		"贅", "	zhui4",
		"贄", "	zhi4",
		"贃", "	wan4",
		"贂", "	chen3",
		"贀", "	yi4",
		"贍", "	shan4",
		"賿", "	liao2",
		"賾", "	ze2",
		"賽", "	sai4",
		"購", "	gou4",
		"賻", "	fu4",
		"賺", "	zhuan4",
		"賹", "	yi4",
		"賸", "	sheng4",
		"賷", "	ji1",
		"賶", "	cang4",
		"贌", "	pu",
		"贎", "	wan4",
		"账", "	zhang4",
		"贛", "	gan4",
		"败", "	bai4",
		"贤", "	xian2",
		"责", "	ze2",
		"财", "	cai2",
		"贡", "	gong4",
		"贠", "	yuan2",
		"负", "	fu4",
		"贞", "	zhen1",
		"贝", "	bei4",
		"贜", "	zang1",
		"贚", "	long4",
		"贏", "	ying2",
		"贙", "	xuan4",
		"贘", "	shang3",
		"贗", "	yan4",
		"贖", "	shu2",
		"贕", "	du2",
		"贔", "	bi4",
		"贓", "	zang1",
		"贒", "	xian2",
		"贑", "	gan4",
		"贐", "	jin4",
		"赚", "	zhuan4",
		"赜", "	ze2",
		"賴", "	lai4",
		"趝", "	jian4",
		"趧", "	ti2",
		"趦", "	zi1",
		"趥", "	qiu1",
		"趤", "	dang4",
		"趣", "	qu4",
		"趢", "	lu4",
		"趡", "	cui3",
		"趠", "	chuo4",
		"趟", "	tang4",
		"趞", "	que4",
		"趜", "	ju2",
		"趩", "	chi4",
		"趛", "	yin3",
		"趚", "	su4",
		"趙", "	zhao4",
		"趘", "	xi2",
		"趗", "	cu4",
		"趖", "	suo1",
		"趕", "	gan3",
		"趔", "	lie4",
		"趓", "	duo3",
		"趒", "	tiao2",
		"趨", "	qu1",
		"趪", "	huang2",
		"趐", "	xue4",
		"趷", "	ke1",
		"跁", "	ba4",
		"跀", "	yue4",
		"趿", "	ta1",
		"趾", "	zhi3",
		"趽", "	fang4",
		"趼", "	jian3",
		"趻", "	chen3",
		"趺", "	fu1",
		"趹", "	jue2",
		"趸", "	dun3",
		"趶", "	ku4",
		"趫", "	qiao2",
		"趵", "	bao4",
		"趴", "	pa1",
		"足", "	zu2",
		"趲", "	zan3",
		"趱", "	zan3",
		"趰", "	er3",
		"趯", "	ti4",
		"趮", "	zao4",
		"趭", "	jiao4",
		"趬", "	qiao1",
		"趑", "	zi1",
		"趏", "	gua1",
		"赝", "	yan4",
		"赩", "	xi4",
		"赳", "	jiu1",
		"赲", "	li4",
		"赱", "	zou3",
		"走", "	zou3",
		"赯", "	tang2",
		"赮", "	xia2",
		"赭", "	zhe3",
		"赬", "	cheng1",
		"赫", "	he4",
		"赪", "	cheng1",
		"赨", "	tong2",
		"赵", "	zhao4",
		"赧", "	nan3",
		"赦", "	she4",
		"赥", "	xi1",
		"赤", "	chi4",
		"赣", "	gan4",
		"赢", "	ying2",
		"赡", "	shan4",
		"赠", "	zeng4",
		"赟", "	yun1",
		"赞", "	zan4",
		"赴", "	fu4",
		"赶", "	gan3",
		"趎", "	chu2",
		"趃", "	die2",
		"趍", "	chi2",
		"趌", "	ji2",
		"趋", "	qu1",
		"越", "	yue4",
		"趉", "	jue2",
		"趈", "	zhan1",
		"趇", "	xi4",
		"趆", "	di1",
		"超", "	chao1",
		"趄", "	ju1",
		"趂", "	chen4",
		"起", "	qi3",
		"趁", "	chen4",
		"趀", "	ci1",
		"赿", "	chi2",
		"赾", "	qin3",
		"赽", "	jue2",
		"赼", "	ci1",
		"赻", "	xian3",
		"赺", "	yin3",
		"赹", "	qiong2",
		"赸", "	shan4",
		"賵", "	feng4",
		"賳", "	zai1",
		"跃", "	yue4",
		"豥", "	gai1",
		"豯", "	xi1",
		"豮", "	fen2",
		"豭", "	jia1",
		"豬", "	zhu1",
		"豫", "	yu4",
		"豪", "	hao2",
		"豩", "	bin1",
		"豨", "	xi1",
		"豧", "	fu1",
		"豦", "	ju4",
		"豤", "	ken3",
		"豱", "	wen1",
		"豣", "	jian1",
		"豢", "	huan4",
		"象", "	xiang4",
		"豠", "	chu2",
		"豟", "	e4",
		"豞", "	hou4",
		"豝", "	ba1",
		"豜", "	jian1",
		"豛", "	yi4",
		"豚", "	tun2",
		"豰", "	bo2",
		"豲", "	huan2",
		"豘", "	tun2",
		"豿", "	gou3",
		"貉", "	hao2",
		"貈", "	he2",
		"貇", "	kun1",
		"貆", "	huan2",
		"貅", "	xiu1",
		"貄", "	si4",
		"貃", "	mo4",
		"貂", "	diao1",
		"貁", "	you4",
		"貀", "	na4",
		"豾", "	pi1",
		"豳", "	bin1",
		"豽", "	na4",
		"豼", "	pi2",
		"豻", "	an4",
		"豺", "	chai2",
		"豹", "	bao4",
		"豸", "	zhi4",
		"豷", "	yi4",
		"豶", "	fen2",
		"豵", "	zong1",
		"豴", "	di2",
		"豙", "	yi4",
		"豗", "	hui1",
		"貋", "	han4",
		"谱", "	pu3",
		"谻", "	ji2",
		"谺", "	xia1",
		"谹", "	hong2",
		"谸", "	qian1",
		"谷", "	gu3",
		"谶", "	chen4",
		"谵", "	zhan1",
		"谴", "	qian3",
		"谳", "	yan4",
		"谲", "	jue2",
		"谰", "	lan2",
		"谽", "	han1",
		"谯", "	qiao2",
		"谮", "	zen4",
		"谭", "	tan2",
		"谬", "	miu4",
		"谫", "	jian3",
		"谪", "	zhe2",
		"谩", "	man2",
		"谨", "	jin3",
		"谧", "	mi4",
		"谦", "	qian1",
		"谼", "	hong2",
		"谾", "	hong1",
		"豖", "	chu4",
		"豋", "	deng1",
		"豕", "	shi3",
		"豔", "	yan4",
		"豓", "	yan4",
		"豒", "	zhi4",
		"豑", "	zhi4",
		"豐", "	feng1",
		"豏", "	xian4",
		"豎", "	shu4",
		"豍", "	bi1",
		"豌", "	wan1",
		"豊", "	li3",
		"谿", "	xi1",
		"豉", "	shi4",
		"豈", "	qi3",
		"豇", "	jiang1",
		"豆", "	dou4",
		"豅", "	long2",
		"豄", "	du2",
		"豃", "	han3",
		"豂", "	liao2",
		"豁", "	huo1",
		"豀", "	xi1",
		"貊", "	mo4",
		"貌", "	mao4",
		"賲", "	bao3",
		"賍", "	zang1",
		"賗", "	chuan4",
		"賖", "	she1",
		"賕", "	qiu2",
		"賔", "	bin1",
		"賓", "	bin1",
		"賒", "	she1",
		"賑", "	zhen4",
		"賐", "	xun4",
		"賏", "	ying1",
		"賎", "	jian4",
		"賌", "	gai4",
		"賙", "	zhou1",
		"賋", "	jiao3",
		"賊", "	zei2",
		"賉", "	xu4",
		"賈", "	jia3",
		"資", "	zi1",
		"賆", "	pian2",
		"賅", "	gai1",
		"賄", "	hui4",
		"賃", "	lin4",
		"賂", "	lu4",
		"賘", "	zang1",
		"賚", "	lai4",
		"賀", "	he4",
		"賧", "	tan4",
		"賱", "	yun3",
		"賰", "	chun3",
		"賯", "	xiong1",
		"賮", "	jin4",
		"賭", "	du3",
		"賬", "	zhang4",
		"賫", "	ji1",
		"質", "	zhi4",
		"賩", "	cong2",
		"賨", "	cong2",
		"賦", "	fu4",
		"賛", "	zan4",
		"賥", "	sui4",
		"賤", "	jian4",
		"賣", "	mai4",
		"賢", "	xian2",
		"賡", "	geng1",
		"賠", "	pei2",
		"賟", "	tian3",
		"賞", "	shang3",
		"賝", "	chen1",
		"賜", "	ci4",
		"賁", "	bi4",
		"貿", "	mao4",
		"貍", "	li2",
		"貙", "	chu1",
		"貣", "	te4",
		"貢", "	gong4",
		"財", "	cai2",
		"負", "	fu4",
		"貟", "	yuan2",
		"貞", "	zhen1",
		"貝", "	bei4",
		"貜", "	jue2",
		"貛", "	huan1",
		"貚", "	tan2",
		"貘", "	mo4",
		"貥", "	hang2",
		"貗", "	ju4",
		"貖", "	e4",
		"貕", "	xi1",
		"貔", "	pi2",
		"貓", "	mao1",
		"貒", "	tuan1",
		"貑", "	jia1",
		"貐", "	yu3",
		"貏", "	bi3",
		"貎", "	ni2",
		"貤", "	yi2",
		"貦", "	wan4",
		"貾", "	chi2",
		"貳", "	er4",
		"貽", "	yi2",
		"貼", "	tie1",
		"費", "	fei4",
		"貺", "	kuang4",
		"貹", "	sheng4",
		"貸", "	dai4",
		"買", "	mai3",
		"貶", "	bian3",
		"貵", "	pian3",
		"貴", "	gui4",
		"貲", "	zi1",
		"貧", "	pin2",
		"貱", "	bi4",
		"貰", "	shi4",
		"貯", "	zhu4",
		"貮", "	er4",
		"貭", "	zhi2",
		"責", "	ze2",
		"貫", "	guan4",
		"貪", "	tan1",
		"販", "	fan4",
		"貨", "	huo4",
		"跂", "	qi2",
		"跄", "	qiang1",
		"轣", "	li4",
		"軖", "	kuang2",
		"軠", "	ren4",
		"軟", "	ruan3",
		"軞", "	mao2",
		"軝", "	qi2",
		"軜", "	na4",
		"軛", "	e4",
		"軚", "	dai4",
		"軙", "	chen2",
		"軘", "	tun2",
		"軗", "	shu1",
		"軕", "	shan1",
		"転", "	zhuan3",
		"軔", "	ren4",
		"軓", "	fan4",
		"軒", "	xuan1",
		"軑", "	dai4",
		"軐", "	xin4",
		"軏", "	yue4",
		"軎", "	wei4",
		"軍", "	jun1",
		"軌", "	gui3",
		"軋", "	ya4",
		"軡", "	qian2",
		"軣", "	hong1",
		"軉", "	yu4",
		"軰", "	bei4",
		"軺", "	yao2",
		"軹", "	zhi3",
		"軸", "	zhou2",
		"軷", "	ba2",
		"軶", "	e4",
		"軵", "	rong3",
		"軴", "	zhu4",
		"軳", "	pao2",
		"軲", "	gu1",
		"軱", "	gu1",
		"軯", "	peng1",
		"軤", "	hu1",
		"軮", "	yang3",
		"軭", "	kuang1",
		"軬", "	fan4",
		"軫", "	zhen3",
		"軪", "	ao1",
		"軩", "	dai4",
		"軨", "	ling2",
		"軧", "	di3",
		"軦", "	kuang4",
		"軥", "	qu2",
		"車", "	che1",
		"軈", "	ying",
		"軼", "	yi4",
		"躢", "	ta4",
		"躬", "	gong1",
		"身", "	shen1",
		"躪", "	lin4",
		"躩", "	jue2",
		"躨", "	kui2",
		"躧", "	xi3",
		"躦", "	cuo2",
		"躥", "	cuan1",
		"躤", "	jie4",
		"躣", "	qu2",
		"躡", "	nie4",
		"躮", "	fen",
		"躠", "	sa3",
		"躟", "	rang2",
		"躞", "	xie4",
		"躝", "	lan2",
		"躜", "	zuan1",
		"躛", "	wei4",
		"躚", "	xian1",
		"躙", "	lin4",
		"躘", "	long2",
		"躗", "	wei4",
		"躭", "	dan1",
		"躯", "	qu1",
		"軇", "	dao4",
		"躼", "	lao4",
		"軆", "	ti3",
		"軅", "	yan",
		"軄", "	zhi2",
		"軃", "	duo3",
		"軂", "	lao4",
		"軁", "	lou2",
		"軀", "	qu1",
		"躿", "	kang1",
		"躾", "	mei",
		"躽", "	yan3",
		"躻", "	kong",
		"躰", "	ti3",
		"躺", "	tang3",
		"躹", "	ju2",
		"躸", "	ji1",
		"躷", "	ai3",
		"躶", "	luo3",
		"躵", "	ren",
		"躴", "	lang2",
		"躳", "	gong1",
		"躲", "	duo3",
		"躱", "	duo3",
		"軻", "	ke1",
		"軽", "	zhi4",
		"躕", "	chu2",
		"輾", "	zhan3",
		"轈", "	chao2",
		"轇", "	jiao1",
		"轆", "	lu4",
		"轅", "	yuan2",
		"轄", "	xia2",
		"轃", "	zhen1",
		"轂", "	gu3",
		"轁", "	tao1",
		"轀", "	wen1",
		"輿", "	yu2",
		"輽", "	ben4",
		"轊", "	wei4",
		"輼", "	wen1",
		"輻", "	fu2",
		"輺", "	zi1",
		"輹", "	fu4",
		"輸", "	shu1",
		"輷", "	hong1",
		"輶", "	you2",
		"輵", "	ge2",
		"輴", "	chun1",
		"輳", "	cou4",
		"轉", "	zhuan3",
		"轋", "	hun2",
		"輱", "	xian2",
		"轘", "	huan2",
		"轢", "	li4",
		"轡", "	pei4",
		"轠", "	lei2",
		"轟", "	hong1",
		"轞", "	jian4",
		"轝", "	yu4",
		"轜", "	er2",
		"轛", "	zhui4",
		"轚", "	ji2",
		"轙", "	yi3",
		"轗", "	kan3",
		"轌", "	xue",
		"轖", "	se4",
		"轕", "	ge2",
		"轔", "	lin2",
		"轓", "	fan1",
		"轒", "	fen2",
		"轑", "	lao3",
		"轐", "	bu2",
		"轏", "	zhan4",
		"轎", "	jiao4",
		"轍", "	zhe2",
		"輲", "	chuan2",
		"輰", "	yang2",
		"軾", "	shi4",
		"輊", "	zhi4",
		"輔", "	fu3",
		"輓", "	wan3",
		"輒", "	zhe2",
		"輑", "	yin3",
		"輐", "	wan4",
		"輏", "	you2",
		"輎", "	shao1",
		"輍", "	yu4",
		"輌", "	liang4",
		"輋", "	she1",
		"載", "	zai4",
		"輖", "	zhou1",
		"輈", "	zhou1",
		"輇", "	quan2",
		"輆", "	kai3",
		"輅", "	he2",
		"輄", "	guang1",
		"較", "	jiao4",
		"輂", "	ju2",
		"輁", "	gong3",
		"輀", "	er2",
		"軿", "	ping2",
		"輕", "	qing1",
		"輗", "	ni2",
		"輯", "	ji2",
		"輤", "	qian4",
		"輮", "	rou2",
		"輭", "	ruan3",
		"輬", "	liang2",
		"輫", "	pai2",
		"輪", "	lun2",
		"輩", "	bei4",
		"輨", "	guan3",
		"輧", "	ping2",
		"輦", "	nian3",
		"輥", "	gun3",
		"輣", "	peng2",
		"輘", "	leng2",
		"輢", "	yi3",
		"輡", "	kan3",
		"輠", "	guo3",
		"輟", "	chuo4",
		"輞", "	wang3",
		"輝", "	hui1",
		"輜", "	zi1",
		"輛", "	liang4",
		"輚", "	zhan4",
		"輙", "	zhe2",
		"躖", "	duan4",
		"躔", "	chan2",
		"跅", "	tuo4",
		"踅", "	xue2",
		"踏", "	ta4",
		"踎", "	mou2",
		"踍", "	qiao1",
		"踌", "	chou2",
		"踋", "	jiao3",
		"踊", "	yong3",
		"踉", "	liang2",
		"踈", "	shu1",
		"踇", "	mu3",
		"踆", "	cun1",
		"踄", "	bu4",
		"踑", "	qi2",
		"踃", "	xiao1",
		"踂", "	nie4",
		"踁", "	jing4",
		"踀", "	chu4",
		"跿", "	tu2",
		"跾", "	shu1",
		"跽", "	ji4",
		"跼", "	ju2",
		"跻", "	ji1",
		"跺", "	duo4",
		"踐", "	jian4",
		"踒", "	wo1",
		"跸", "	bi4",
		"踟", "	chi2",
		"踩", "	cai3",
		"踨", "	zong1",
		"踧", "	cu4",
		"踦", "	yi3",
		"踥", "	qie4",
		"踤", "	zu2",
		"踣", "	bo2",
		"踢", "	ti1",
		"踡", "	quan2",
		"踠", "	wan3",
		"踞", "	ju4",
		"踓", "	wei3",
		"踝", "	huai2",
		"踜", "	leng4",
		"踛", "	lu4",
		"踚", "	lun2",
		"踙", "	ju1",
		"踘", "	ju1",
		"踗", "	nie4",
		"踖", "	ji2",
		"踕", "	jie2",
		"踔", "	chuo1",
		"跹", "	xian1",
		"跷", "	qiao1",
		"踫", "	peng4",
		"跑", "	pao3",
		"跛", "	bo3",
		"跚", "	shan1",
		"跙", "	ju4",
		"跘", "	pan2",
		"跗", "	fu1",
		"跖", "	zhi2",
		"跕", "	dian3",
		"跔", "	ju1",
		"跓", "	zhu4",
		"跒", "	qia3",
		"跐", "	ci1",
		"距", "	ju4",
		"跏", "	jia1",
		"跎", "	tuo2",
		"跍", "	ku1",
		"跌", "	die1",
		"跋", "	ba2",
		"跊", "	mei4",
		"跉", "	ling2",
		"跈", "	nian3",
		"跇", "	yi4",
		"跆", "	tai2",
		"跜", "	ni2",
		"跞", "	li4",
		"跶", "	ta4",
		"跫", "	qiong2",
		"践", "	jian4",
		"跴", "	cai3",
		"跳", "	tiao4",
		"跲", "	jia2",
		"跱", "	zhi4",
		"跰", "	pian2",
		"路", "	lu4",
		"跮", "	chi4",
		"跭", "	xiang2",
		"跬", "	kui3",
		"跪", "	gui4",
		"跟", "	gen1",
		"跩", "	zhuai3",
		"跨", "	kua4",
		"跧", "	quan2",
		"跦", "	zhu1",
		"跥", "	duo4",
		"跤", "	jiao1",
		"跣", "	xian3",
		"跢", "	duo4",
		"跡", "	ji1",
		"跠", "	yi2",
		"踪", "	zong1",
		"踬", "	zhi4",
		"躓", "	zhi4",
		"蹮", "	xian1",
		"蹸", "	lin4",
		"蹷", "	jue2",
		"蹶", "	jue2",
		"蹵", "	cu4",
		"蹴", "	cu4",
		"蹳", "	bo1",
		"蹲", "	dun1",
		"蹱", "	zhong1",
		"蹰", "	chu2",
		"蹯", "	fan2",
		"蹭", "	ceng4",
		"蹺", "	qiao1",
		"蹬", "	deng1",
		"蹫", "	ju2",
		"蹪", "	tui2",
		"蹩", "	bie2",
		"蹨", "	nian3",
		"蹧", "	zao1",
		"蹦", "	beng4",
		"蹥", "	lian2",
		"蹤", "	zong1",
		"蹣", "	pan2",
		"蹹", "	ta2",
		"蹻", "	jue1",
		"蹡", "	qiang1",
		"躈", "	qiao4",
		"躒", "	li4",
		"躑", "	zhi2",
		"躐", "	lie4",
		"躏", "	lin4",
		"躎", "	nian3",
		"躍", "	yue4",
		"躌", "	wu3",
		"躋", "	ji1",
		"躊", "	chou2",
		"躉", "	dun3",
		"躇", "	chu2",
		"蹼", "	pu3",
		"躆", "	ju4",
		"躅", "	zhu2",
		"躄", "	bi4",
		"躃", "	bi4",
		"躂", "	da2",
		"躁", "	zao4",
		"躀", "	kuang4",
		"蹿", "	cuan1",
		"蹾", "	dun1",
		"蹽", "	liao1",
		"蹢", "	di2",
		"蹠", "	zhi2",
		"踭", "	zheng1",
		"踹", "	chuai4",
		"蹃", "	nuo4",
		"蹂", "	rou2",
		"蹁", "	pian2",
		"蹀", "	die2",
		"踿", "	zu2",
		"踾", "	fu2",
		"踽", "	ju3",
		"踼", "	tang2",
		"踻", "	gua1",
		"踺", "	jian4",
		"踸", "	chen3",
		"蹅", "	cha3",
		"踷", "	zha3",
		"踶", "	di4",
		"踵", "	zhong3",
		"踴", "	yong3",
		"踳", "	chuan3",
		"踲", "	dun4",
		"踱", "	duo2",
		"踰", "	yu2",
		"踯", "	zhi2",
		"踮", "	dian3",
		"蹄", "	ti2",
		"蹆", "	tui3",
		"蹟", "	ji1",
		"蹔", "	zan4",
		"蹞", "	kui3",
		"蹝", "	xi3",
		"蹜", "	su4",
		"蹛", "	dai4",
		"蹚", "	tang1",
		"蹙", "	cu4",
		"蹘", "	liao2",
		"蹗", "	lu4",
		"蹖", "	chong1",
		"蹕", "	bi4",
		"蹓", "	liu1",
		"蹇", "	jian3",
		"蹒", "	pan2",
		"蹑", "	nie4",
		"蹐", "	ji2",
		"蹏", "	ti2",
		"蹎", "	dian1",
		"蹍", "	nian3",
		"蹌", "	qiang1",
		"蹋", "	ta4",
		"蹊", "	qi1",
		"蹉", "	cuo1",
		"蹈", "	dao3",
		"殗", "	ye4",
		"敛", "	lian3",
		"殕", "	fou3",
		"䠒", "	hu2",
		"䠝", "	xun1",
		"䠜", "	rong2",
		"䠛", "	yao2",
		"䠚", "	wa4",
		"䠙", "	pang2",
		"䠘", "	pi4",
		"䠗", "	qiu4",
		"䠕", "	cai1",
		"䠔", "	sui4",
		"䠓", "	qiu1",
		"䠑", "	kui3",
		"䠟", "	die2",
		"䠐", "	qu4",
		"䠏", "	ji4",
		"䠎", "	wo4",
		"䠍", "	xia1",
		"䠋", "	bi4",
		"䠊", "	fei4",
		"䠉", "	huan4",
		"䠈", "	tu2",
		"䠇", "	jue2",
		"䠆", "	chang2",
		"䠞", "	cu4",
		"䠠", "	chi4",
		"䠄", "	tian3",
		"䠭", "	lai2",
		"䠷", "	tiao3",
		"䠶", "	she4",
		"䠵", "	fu4",
		"䠴", "	zhen3",
		"䠳", "	chen1",
		"䠲", "	ling2",
		"䠱", "	zhu2",
		"䠰", "	quan2",
		"䠯", "	yue4",
		"䠮", "	teng2",
		"䠬", "	deng4",
		"䠡", "	cuo2",
		"䠫", "	zou4",
		"䠪", "	duan4",
		"䠩", "	gui4",
		"䠨", "	chan4",
		"䠧", "	chu2",
		"䠦", "	zhe4",
		"䠥", "	bie2",
		"䠤", "	duo3",
		"䠣", "	xuan3",
		"䠢", "	meng4",
		"䠅", "	kun3",
		"䠃", "	liang3",
		"䠹", "	ai2",
		"䟘", "	hang4",
		"䟢", "	chen2",
		"䟡", "	zhi1",
		"䟠", "	yue4",
		"䟟", "	cu4",
		"䟞", "	chu2",
		"䟝", "	tou4",
		"䟜", "	na4",
		"䟛", "	bo2",
		"䟚", "	qi2",
		"䟙", "	qie4",
		"䟗", "	shi4",
		"䟤", "	bi4",
		"䟖", "	tang4",
		"䟕", "	cha4",
		"䟔", "	fu4",
		"䟓", "	cheng1",
		"䟒", "	quan2",
		"䟑", "	yue4",
		"䟐", "	li4",
		"䟏", "	li4",
		"䟍", "	bian1",
		"䟌", "	ji2",
		"䟣", "	chu4",
		"䟥", "	meng2",
		"䠂", "	chu2",
		"䟵", "	qiu2",
		"䠀", "	tang1",
		"䟿", "	lu4",
		"䟾", "	zhuo2",
		"䟼", "	wu3",
		"䟻", "	du4",
		"䟺", "	bei4",
		"䟹", "	lie4",
		"䟸", "	kui2",
		"䟷", "	chi4",
		"䟶", "	zuo4",
		"䟴", "	zhen4",
		"䟦", "	ba2",
		"䟰", "	jian3",
		"䟯", "	kuo4",
		"䟮", "	fu2",
		"䟭", "	tiao2",
		"䟬", "	qiu4",
		"䟫", "	cheng1",
		"䟪", "	feng3",
		"䟩", "	lie3",
		"䟨", "	min2",
		"䟧", "	tian2",
		"䠸", "	kua1",
		"䠻", "	qiong2",
		"䟊", "	qu2",
		"䢀", "	qi4",
		"䢌", "	bo2",
		"䢋", "	ji4",
		"䢊", "	you2",
		"䢉", "	nong2",
		"䢈", "	chen2",
		"䢇", "	rong3",
		"䢅", "	chen2",
		"䢄", "	xi3",
		"䢃", "	yi4",
		"䢁", "	yue4",
		"䡿", "	ling2",
		"䢐", "	cu2",
		"䡾", "	nie4",
		"䡽", "	zuan1",
		"䡼", "	ling2",
		"䡻", "	min2",
		"䡺", "	wei4",
		"䡹", "	zhi4",
		"䡷", "	kai4",
		"䡶", "	bei4",
		"䡵", "	sui4",
		"䡴", "	chong1",
		"䢍", "	fang3",
		"䢑", "	di3",
		"䡲", "	chan2",
		"䢠", "	song4",
		"䢪", "	bo2",
		"䢩", "	yu4",
		"䢨", "	cong1",
		"䢧", "	liao4",
		"䢦", "	shuai4",
		"䢥", "	yan2",
		"䢤", "	shu4",
		"䢣", "	yao2",
		"䢢", "	cang4",
		"䢡", "	ye4",
		"䢟", "	you2",
		"䢒", "	jiao1",
		"䢞", "	shu4",
		"䢝", "	ya4",
		"䢛", "	jiong3",
		"䢚", "	geng1",
		"䢙", "	bai4",
		"䢗", "	qu1",
		"䢖", "	yu4",
		"䢕", "	xu4",
		"䢔", "	he2",
		"䢓", "	yu2",
		"䡳", "	si1",
		"䡱", "	zhuan3",
		"䠼", "	shu4",
		"䡉", "	kang3",
		"䡓", "	juan4",
		"䡒", "	tian2",
		"䡑", "	min2",
		"䡐", "	tuo2",
		"䡏", "	hong2",
		"䡎", "	lu2",
		"䡍", "	fu2",
		"䡌", "	hong2",
		"䡋", "	qi2",
		"䡊", "	fan3",
		"䡈", "	jue2",
		"䡕", "	zheng3",
		"䡇", "	yue4",
		"䡆", "	rong2",
		"䡅", "	chun1",
		"䡃", "	li4",
		"䡂", "	jiu1",
		"䡁", "	long3",
		"䡀", "	zhan3",
		"䠿", "	wai4",
		"䠾", "	shan3",
		"䠽", "	hai2",
		"䡔", "	qi3",
		"䡖", "	qing4",
		"䡰", "	keng1",
		"䡤", "	zhu1",
		"䡯", "	cong1",
		"䡭", "	xiu1",
		"䡬", "	man4",
		"䡫", "	peng2",
		"䡪", "	shan4",
		"䡩", "	keng1",
		"䡨", "	cha4",
		"䡧", "	wu1",
		"䡦", "	sang3",
		"䡥", "	rong2",
		"䡣", "	hun1",
		"䡗", "	gong3",
		"䡢", "	bian4",
		"䡡", "	xie2",
		"䡟", "	pi4",
		"䡞", "	ju2",
		"䡝", "	yuan1",
		"䡜", "	lu4",
		"䡛", "	yin4",
		"䡚", "	mao4",
		"䡙", "	lang2",
		"䡘", "	tian2",
		"䟋", "	zhan3",
		"䟉", "	zhu2",
		"䢭", "	yan4",
		"䜯", "	ju2",
		"䜻", "	chi3",
		"䜺", "	chai3",
		"䜹", "	shu4",
		"䜸", "	mei3",
		"䜷", "	qin1",
		"䜶", "	xiang2",
		"䜵", "	chi3",
		"䜴", "	chu4",
		"䜲", "	lie4",
		"䜱", "	man3",
		"䜮", "	liao2",
		"䜽", "	yu2",
		"䜭", "	jun4",
		"䜬", "	song3",
		"䜫", "	jiang1",
		"䜪", "	qiu2",
		"䜩", "	yan4",
		"䜧", "	nao3",
		"䜣", "	xin1",
		"䜢", "	xian3",
		"䜡", "	yu4",
		"䜠", "	che4",
		"䜼", "	gu2",
		"䜾", "	yin1",
		"䜞", "	ji4",
		"䝏", "	lou2",
		"䝛", "	bo1",
		"䝚", "	ni2",
		"䝙", "	chu1",
		"䝘", "	yi4",
		"䝖", "	zhao3",
		"䝕", "	zhe2",
		"䝓", "	lie4",
		"䝒", "	zhu4",
		"䝑", "	chong1",
		"䝐", "	wei2",
		"䝎", "	tuan1",
		"䝀", "	liu2",
		"䝍", "	jun4",
		"䝌", "	jue2",
		"䝋", "	zong4",
		"䝊", "	sha4",
		"䝈", "	e4",
		"䝅", "	hui1",
		"䝄", "	shuang1",
		"䝃", "	zhe2",
		"䝂", "	shu4",
		"䝁", "	lao2",
		"䜟", "	chen2",
		"䜝", "	tuan3",
		"䝝", "	yi3",
		"䛶", "	lei3",
		"䜀", "	nao3",
		"䛿", "	ge2",
		"䛾", "	su4",
		"䛽", "	zha3",
		"䛼", "	hui3",
		"䛻", "	you4",
		"䛺", "	jie4",
		"䛹", "	can4",
		"䛸", "	che4",
		"䛷", "	wan3",
		"䛵", "	shou4",
		"䜃", "	dui1",
		"䛴", "	ji1",
		"䛳", "	yan4",
		"䛲", "	man2",
		"䛱", "	ti2",
		"䛰", "	hun4",
		"䛯", "	ju4",
		"䛮", "	jiu4",
		"䛭", "	xing4",
		"䛬", "	tao2",
		"䛫", "	zhang1",
		"䜁", "	xi4",
		"䜄", "	chi2",
		"䜜", "	wei4",
		"䜑", "	wu4",
		"䜛", "	chan2",
		"䜚", "	ta4",
		"䜙", "	an2",
		"䜘", "	jing3",
		"䜗", "	xin4",
		"䜖", "	tan4",
		"䜕", "	mai4",
		"䜔", "	sui2",
		"䜓", "	she4",
		"䜒", "	ao4",
		"䜐", "	hui1",
		"䜅", "	wei2",
		"䜏", "	tuo1",
		"䜎", "	lao2",
		"䜍", "	liao2",
		"䜌", "	luan2",
		"䜋", "	hui4",
		"䜊", "	zao1",
		"䜉", "	chi1",
		"䜈", "	chao1",
		"䜇", "	gun3",
		"䜆", "	zhe2",
		"䝜", "	suan1",
		"䝞", "	hao4",
		"䟈", "	zhi2",
		"䞢", "	zuo2",
		"䞬", "	tou4",
		"䞫", "	yun3",
		"䞪", "	jiang4",
		"䞩", "	e4",
		"䞨", "	gui3",
		"䞧", "	hou4",
		"䞦", "	he2",
		"䞥", "	you4",
		"䞤", "	qu2",
		"䞣", "	che3",
		"䞡", "	tan3",
		"䞮", "	tu1",
		"䞠", "	zhi1",
		"䞟", "	po4",
		"䞞", "	fu2",
		"䞝", "	yu4",
		"䞜", "	fu4",
		"䞛", "	yan1",
		"䞚", "	qi2",
		"䞙", "	za2",
		"䞘", "	ji2",
		"䞗", "	cai1",
		"䞭", "	cun1",
		"䞯", "	fu4",
		"䞕", "	ru2",
		"䞽", "	suo3",
		"䟇", "	ji1",
		"䟆", "	bi4",
		"䟅", "	jian4",
		"䟄", "	qi4",
		"䟃", "	can1",
		"䟂", "	man2",
		"䟁", "	xiao2",
		"䟀", "	cai1",
		"䞿", "	qian1",
		"䞾", "	chi2",
		"䞼", "	chui3",
		"䞰", "	zuo2",
		"䞻", "	yong3",
		"䞺", "	chun1",
		"䞹", "	huang2",
		"䞸", "	fu4",
		"䞷", "	jue2",
		"䞶", "	tang1",
		"䞵", "	jue3",
		"䞴", "	zhao1",
		"䞳", "	bo2",
		"䞱", "	hu2",
		"䞖", "	shu3",
		"䞔", "	wei3",
		"䝟", "	ya4",
		"䝫", "	zuo2",
		"䝶", "	liang2",
		"䝵", "	bu4",
		"䝳", "	can2",
		"䝲", "	jin4",
		"䝱", "	xie2",
		"䝰", "	zhi4",
		"䝯", "	yi4",
		"䝮", "	xuan4",
		"䝭", "	gou4",
		"䝬", "	zhu4",
		"䝪", "	shu3",
		"䝸", "	ji4",
		"䝩", "	zhen4",
		"䝨", "	xian2",
		"䝧", "	min2",
		"䝦", "	zhong1",
		"䝥", "	hao2",
		"䝤", "	lao3",
		"䝣", "	qu2",
		"䝢", "	man4",
		"䝡", "	man4",
		"䝠", "	huan2",
		"䝷", "	zhi1",
		"䝹", "	wan3",
		"䞓", "	cheng1",
		"䞆", "	suo3",
		"䞒", "	dong4",
		"䞑", "	hong2",
		"䞐", "	chun3",
		"䞍", "	qing2",
		"䞌", "	she2",
		"䞋", "	chen4",
		"䞊", "	xun4",
		"䞉", "	sheng4",
		"䞈", "	gui4",
		"䞇", "	die2",
		"䞅", "	yi2",
		"䝺", "	guan4",
		"䞄", "	biao4",
		"䞃", "	zhi4",
		"䞂", "	ruan3",
		"䞁", "	yan4",
		"䞀", "	hou4",
		"䝿", "	gui4",
		"䝾", "	fu4",
		"䝽", "	ai4",
		"䝼", "	jing4",
		"䝻", "	ju1",
		"䢫", "	sui2",
		"䢮", "	lei4",
		"䛩", "	wu4",
		"䧢", "	qu1",
		"䧯", "	chan2",
		"䧮", "	xian4",
		"䧬", "	bin1",
		"䧫", "	hao2",
		"䧪", "	che4",
		"䧨", "	ye4",
		"䧧", "	yi3",
		"䧦", "	wei2",
		"䧥", "	hui4",
		"䧤", "	pu2",
		"䧡", "	yong1",
		"䧲", "	han4",
		"䧠", "	shuan4",
		"䧟", "	xian4",
		"䧞", "	ma4",
		"䧝", "	chi1",
		"䧜", "	tang2",
		"䧛", "	bang4",
		"䧚", "	hao4",
		"䧙", "	ling2",
		"䧘", "	zhuan4",
		"䧗", "	bi4",
		"䧰", "	hun4",
		"䧳", "	ci2",
		"䧕", "	cheng2",
		"䨄", "	yan4",
		"䨐", "	qia4",
		"䨏", "	ci2",
		"䨎", "	hong2",
		"䨍", "	ying3",
		"䨌", "	bao2",
		"䨋", "	nue4",
		"䨊", "	yuan1",
		"䨈", "	bin1",
		"䨆", "	bi2",
		"䨅", "	liao2",
		"䨂", "	qiu1",
		"䧴", "	zhi1",
		"䨁", "	wu4",
		"䨀", "	di2",
		"䧿", "	que4",
		"䧽", "	cui3",
		"䧼", "	hu2",
		"䧺", "	xiong2",
		"䧹", "	ying1",
		"䧷", "	rou2",
		"䧶", "	kui2",
		"䧵", "	qi2",
		"䧖", "	jian4",
		"䧔", "	nian4",
		"䨒", "	yu4",
		"䦦", "	qin2",
		"䦲", "	yan2",
		"䦱", "	wei3",
		"䦯", "	zhi4",
		"䦮", "	chun3",
		"䦭", "	hang1",
		"䦬", "	que4",
		"䦫", "	ying1",
		"䦪", "	ya4",
		"䦨", "	lan2",
		"䦧", "	qie2",
		"䦥", "	xian2",
		"䦴", "	yi4",
		"䦤", "	chuai4",
		"䦣", "	fu4",
		"䦢", "	kuo4",
		"䦡", "	huan2",
		"䦠", "	du1",
		"䦟", "	wen3",
		"䦞", "	run4",
		"䦝", "	huo1",
		"䦜", "	wu2",
		"䦛", "	zheng4",
		"䦳", "	xiang4",
		"䦵", "	ni3",
		"䧓", "	zhou1",
		"䧅", "	yi2",
		"䧒", "	lai2",
		"䧑", "	di1",
		"䧎", "	xuan4",
		"䧍", "	xi4",
		"䧌", "	sui1",
		"䧋", "	xian3",
		"䧊", "	ku1",
		"䧉", "	li3",
		"䧇", "	yi1",
		"䧆", "	hong2",
		"䧄", "	ge4",
		"䦶", "	zheng4",
		"䧃", "	tian2",
		"䧂", "	dao4",
		"䧁", "	xu3",
		"䦾", "	yuan2",
		"䦽", "	xu4",
		"䦼", "	jue2",
		"䦻", "	zi3",
		"䦺", "	ding1",
		"䦹", "	shi2",
		"䦷", "	chuai4",
		"䨑", "	ti2",
		"䨓", "	lei2",
		"䦙", "	si4",
		"䩘", "	di4",
		"䩣", "	tu2",
		"䩢", "	zhi4",
		"䩡", "	jia2",
		"䩟", "	yi2",
		"䩞", "	tie2",
		"䩝", "	pao2",
		"䩜", "	zhou4",
		"䩛", "	bi4",
		"䩚", "	di4",
		"䩙", "	xuan4",
		"䩗", "	ba4",
		"䩥", "	dan4",
		"䩕", "	ang2",
		"䩔", "	duo4",
		"䩓", "	qi2",
		"䩒", "	yu2",
		"䩑", "	hong2",
		"䩐", "	hu1",
		"䩏", "	mie4",
		"䩍", "	liao3",
		"䩌", "	qiao2",
		"䩋", "	mo3",
		"䩤", "	xie2",
		"䩦", "	tiao2",
		"䩉", "	fu3",
		"䩴", "	hu2",
		"䩾", "	zhe4",
		"䩽", "	yu1",
		"䩼", "	feng2",
		"䩻", "	ba4",
		"䩺", "	weng1",
		"䩹", "	e2",
		"䩸", "	rong2",
		"䩷", "	bang1",
		"䩶", "	chan3",
		"䩵", "	yun4",
		"䩳", "	sou1",
		"䩧", "	xie4",
		"䩲", "	du1",
		"䩱", "	shu4",
		"䩰", "	xuan4",
		"䩯", "	ji2",
		"䩮", "	lu4",
		"䩬", "	beng3",
		"䩫", "	liang3",
		"䩪", "	guan3",
		"䩩", "	yuan3",
		"䩨", "	chang4",
		"䩊", "	wan3",
		"䩈", "	hui4",
		"䨔", "	bao2",
		"䨡", "	han2",
		"䨬", "	lian2",
		"䨫", "	mai4",
		"䨪", "	mai2",
		"䨩", "	ling2",
		"䨨", "	zhui1",
		"䨦", "	pang1",
		"䨥", "	huo4",
		"䨤", "	di2",
		"䨣", "	ge2",
		"䨢", "	dan4",
		"䨠", "	ai3",
		"䨮", "	xue3",
		"䨟", "	wa1",
		"䨞", "	yu3",
		"䨝", "	qing1",
		"䨜", "	beng1",
		"䨛", "	se4",
		"䨚", "	hu1",
		"䨙", "	cen2",
		"䨘", "	xian4",
		"䨗", "	fu2",
		"䨖", "	ji4",
		"䨭", "	xiao1",
		"䨯", "	zhen4",
		"䩇", "	zhan1",
		"䨼", "	hu4",
		"䩆", "	zhan3",
		"䩅", "	zhan3",
		"䩄", "	mian3",
		"䩃", "	shi4",
		"䩂", "	xian1",
		"䩁", "	fei1",
		"䩀", "	bei4",
		"䨿", "	za2",
		"䨾", "	fei4",
		"䨽", "	fei3",
		"䨻", "	beng4",
		"䨰", "	po4",
		"䨺", "	dui4",
		"䨹", "	shu1",
		"䨸", "	yin3",
		"䨷", "	xian4",
		"䨶", "	yun3",
		"䨵", "	dan4",
		"䨴", "	dui4",
		"䨳", "	xi4",
		"䨲", "	nou2",
		"䨱", "	fu4",
		"䦚", "	kua4",
		"䦘", "	xian4",
		"䢯", "	lin2",
		"䣸", "	ran3",
		"䤃", "	yin1",
		"䤂", "	mei2",
		"䤁", "	cen2",
		"䣿", "	yu1",
		"䣾", "	mi4",
		"䣽", "	zhi1",
		"䣼", "	liang2",
		"䣻", "	han1",
		"䣺", "	juan1",
		"䣹", "	fa2",
		"䣷", "	zhu1",
		"䤅", "	tu2",
		"䣶", "	huo2",
		"䣵", "	er4",
		"䣴", "	xu4",
		"䣲", "	fan4",
		"䣱", "	xu4",
		"䣰", "	ju4",
		"䣯", "	cu2",
		"䣮", "	po4",
		"䣭", "	tai4",
		"䣬", "	zai3",
		"䤄", "	mian3",
		"䤆", "	kui2",
		"䣪", "	po4",
		"䤕", "	xue4",
		"䤟", "	chen2",
		"䤞", "	yun3",
		"䤝", "	ying4",
		"䤜", "	dun4",
		"䤛", "	qiu2",
		"䤚", "	li3",
		"䤙", "	li4",
		"䤘", "	chan3",
		"䤗", "	gan3",
		"䤖", "	bao4",
		"䤔", "	jian4",
		"䤉", "	mi4",
		"䤓", "	meng2",
		"䤒", "	ji4",
		"䤑", "	wang4",
		"䤐", "	jin3",
		"䤏", "	pi3",
		"䤎", "	ju2",
		"䤍", "	mi2",
		"䤌", "	qiang1",
		"䤋", "	yu4",
		"䤊", "	rong2",
		"䣫", "	li2",
		"䣩", "	chun2",
		"䤡", "	ran3",
		"䢾", "	xian3",
		"䣊", "	dang3",
		"䣈", "	hang4",
		"䣇", "	qiu2",
		"䣆", "	xing2",
		"䣅", "	chen2",
		"䣄", "	tu2",
		"䣂", "	lei3",
		"䣁", "	yu3",
		"䣀", "	gui3",
		"䢿", "	an1",
		"䢽", "	xiang4",
		"䣌", "	di3",
		"䢼", "	gong1",
		"䢻", "	chen2",
		"䢺", "	chu1",
		"䢹", "	ju3",
		"䢸", "	ju1",
		"䢵", "	yun2",
		"䢳", "	ji3",
		"䢲", "	yue4",
		"䢱", "	du2",
		"䢰", "	ti1",
		"䣋", "	cai3",
		"䣍", "	yan3",
		"䣨", "	chun2",
		"䣝", "	tu2",
		"䣧", "	yi4",
		"䣦", "	lei4",
		"䣥", "	bi3",
		"䣤", "	jue2",
		"䣣", "	dang3",
		"䣢", "	ji2",
		"䣡", "	yi2",
		"䣠", "	jie2",
		"䣟", "	can2",
		"䣞", "	e4",
		"䣜", "	cuo2",
		"䣎", "	zi1",
		"䣛", "	qi1",
		"䣚", "	lou2",
		"䣙", "	pei2",
		"䣘", "	tang2",
		"䣖", "	ma3",
		"䣕", "	ma3",
		"䣔", "	suo3",
		"䣓", "	li2",
		"䣑", "	chan2",
		"䣐", "	ying1",
		"䤠", "	zhi3",
		"䤣", "	lue4",
		"䦗", "	xu4",
		"䥩", "	wei2",
		"䥳", "	you1",
		"䥲", "	ou1",
		"䥱", "	xie3",
		"䥰", "	meng2",
		"䥯", "	bei1",
		"䥮", "	zhu2",
		"䥭", "	zheng4",
		"䥬", "	bo2",
		"䥫", "	tie3",
		"䥪", "	xian3",
		"䥨", "	lv4",
		"䥶", "	li4",
		"䥧", "	huan2",
		"䥥", "	lian2",
		"䥤", "	bao2",
		"䥣", "	zao2",
		"䥢", "	long2",
		"䥡", "	ye4",
		"䥟", "	ye4",
		"䥞", "	jiao3",
		"䥝", "	ao2",
		"䥜", "	jian4",
		"䥵", "	xiao3",
		"䥷", "	zha2",
		"䥙", "	sui4",
		"䦌", "	chu4",
		"䦖", "	xie2",
		"䦕", "	peng1",
		"䦔", "	tan3",
		"䦓", "	zhan1",
		"䦒", "	dang4",
		"䦑", "	xue4",
		"䦐", "	ting3",
		"䦏", "	xie4",
		"䦎", "	guan3",
		"䦍", "	wu4",
		"䦋", "	ao2",
		"䥸", "	mi2",
		"䦊", "	niao3",
		"䦈", "	jie1",
		"䦇", "	ji4",
		"䦆", "	jue2",
		"䦅", "	shan4",
		"䦃", "	zhuo1",
		"䦂", "	shan4",
		"䥾", "	xie3",
		"䥽", "	po1",
		"䥺", "	ye2",
		"䥛", "	jie1",
		"䥘", "	cu4",
		"䤤", "	kai1",
		"䤰", "	ying2",
		"䤺", "	jin1",
		"䤹", "	sou1",
		"䤸", "	zuan4",
		"䤷", "	yan3",
		"䤶", "	ye4",
		"䤵", "	fei4",
		"䤴", "	han2",
		"䤳", "	ye4",
		"䤲", "	chi4",
		"䤱", "	shi4",
		"䤯", "	xing2",
		"䤼", "	xian4",
		"䤮", "	she4",
		"䤭", "	shi4",
		"䤬", "	sha1",
		"䤫", "	chan2",
		"䤪", "	duo3",
		"䤩", "	cha2",
		"䤨", "	pi4",
		"䤧", "	hui4",
		"䤦", "	yue4",
		"䤥", "	gui3",
		"䤻", "	duo4",
		"䤽", "	guan1",
		"䥗", "	kuan3",
		"䥌", "	zheng4",
		"䥖", "	tian2",
		"䥕", "	pie3",
		"䥔", "	su4",
		"䥓", "	qi1",
		"䥒", "	jiang4",
		"䥑", "	wan4",
		"䥐", "	mou2",
		"䥏", "	yu3",
		"䥎", "	chun2",
		"䥍", "	zhi4",
		"䥋", "	peng1",
		"䤾", "	tao1",
		"䥉", "	yuan1",
		"䥈", "	mu3",
		"䥇", "	shan4",
		"䥆", "	jin3",
		"䥅", "	qian4",
		"䥄", "	cu4",
		"䥃", "	yue4",
		"䥂", "	meng4",
		"䥁", "	han2",
		"䥀", "	chan3",
		"䤿", "	qie4",
		"䛪", "	qiong2",
		"䛨", "	xin4",
		"䪀", "	guan3",
		"䑸", "	zong1",
		"䒄", "	fu4",
		"䒃", "	cao4",
		"䒂", "	jiang3",
		"䒁", "	xi2",
		"䒀", "	bu4",
		"䑿", "	su4",
		"䑽", "	ta4",
		"䑼", "	zhou1",
		"䑻", "	you2",
		"䑹", "	sou1",
		"䑶", "	qian4",
		"䒆", "	che4",
		"䑵", "	mu4",
		"䑴", "	qi2",
		"䑳", "	lun2",
		"䑲", "	zhao4",
		"䑱", "	wan3",
		"䑰", "	bu4",
		"䑯", "	di4",
		"䑭", "	di4",
		"䑬", "	tao1",
		"䑫", "	beng1",
		"䒅", "	teng2",
		"䒇", "	fu4",
		"䑨", "	duo4",
		"䒔", "	bai4",
		"䒠", "	feng1",
		"䒟", "	dan1",
		"䒞", "	chen2",
		"䒝", "	xiao2",
		"䒜", "	niu2",
		"䒛", "	huan4",
		"䒚", "	shao3",
		"䒗", "	qi4",
		"䒖", "	xin4",
		"䒕", "	xiao3",
		"䒓", "	kai3",
		"䒈", "	fei4",
		"䒒", "	tiao2",
		"䒑", "	cao3",
		"䒐", "	meng2",
		"䒏", "	seng1",
		"䒎", "	mang3",
		"䒍", "	pang3",
		"䒌", "	ming4",
		"䒋", "	yang3",
		"䒊", "	xi1",
		"䒉", "	wu3",
		"䑪", "	e4",
		"䑧", "	fu2",
		"䒢", "	ang2",
		"䐽", "	man2",
		"䑇", "	zhi4",
		"䑆", "	yang3",
		"䑅", "	meng2",
		"䑄", "	pi4",
		"䑃", "	meng2",
		"䑂", "	ai3",
		"䑁", "	wu4",
		"䑀", "	pi4",
		"䐿", "	ao4",
		"䐾", "	duo2",
		"䐼", "	xi4",
		"䑉", "	ying2",
		"䐻", "	gu1",
		"䐺", "	tan4",
		"䐹", "	sou1",
		"䐸", "	huo4",
		"䐷", "	dan1",
		"䐶", "	zan1",
		"䐵", "	gong1",
		"䐴", "	gui4",
		"䐳", "	yu2",
		"䐲", "	zhe2",
		"䑈", "	bo2",
		"䑊", "	wei2",
		"䑦", "	gou1",
		"䑙", "	tan1",
		"䑥", "	e4",
		"䑤", "	jin4",
		"䑣", "	chen1",
		"䑠", "	liao3",
		"䑟", "	huang2",
		"䑞", "	shun4",
		"䑝", "	jia3",
		"䑜", "	ta4",
		"䑛", "	chi3",
		"䑚", "	tian2",
		"䑘", "	cuo2",
		"䑋", "	rang3",
		"䑗", "	dang4",
		"䑕", "	shu3",
		"䑔", "	fei4",
		"䑓", "	tai2",
		"䑑", "	pu2",
		"䑐", "	zhen3",
		"䑏", "	quan2",
		"䑎", "	chan3",
		"䑍", "	yan1",
		"䑌", "	lan2",
		"䒡", "	yin3",
		"䒣", "	ran3",
		"䐰", "	xiu1",
		"䓮", "	mao4",
		"䓸", "	jian1",
		"䓷", "	xing4",
		"䓶", "	lai4",
		"䓵", "	fu1",
		"䓴", "	ruan3",
		"䓳", "	hen3",
		"䓲", "	rui4",
		"䓱", "	chai2",
		"䓰", "	yin1",
		"䓯", "	du2",
		"䓭", "	cha4",
		"䓺", "	mei3",
		"䓫", "	qi2",
		"䓨", "	ying1",
		"䓧", "	ci4",
		"䓦", "	dian3",
		"䓥", "	la4",
		"䓤", "	hu1",
		"䓣", "	liang3",
		"䓢", "	gu4",
		"䓡", "	zhi1",
		"䓠", "	ta4",
		"䓹", "	yi4",
		"䓼", "	mang2",
		"䓞", "	li4",
		"䔊", "	bing1",
		"䔖", "	ling2",
		"䔕", "	pu2",
		"䔔", "	jing4",
		"䔓", "	xu3",
		"䔒", "	bei4",
		"䔑", "	xie2",
		"䔐", "	jian1",
		"䔏", "	chou4",
		"䔎", "	su4",
		"䔋", "	suo1",
		"䔉", "	li4",
		"䓽", "	ji4",
		"䔈", "	gong4",
		"䔇", "	qi3",
		"䔆", "	li2",
		"䔅", "	ge1",
		"䔄", "	yao2",
		"䔃", "	zu3",
		"䔂", "	zi3",
		"䔁", "	li4",
		"䓿", "	han4",
		"䓾", "	suo1",
		"䓟", "	zhou1",
		"䓝", "	meng4",
		"䒤", "	ri4",
		"䒳", "	duo3",
		"䒾", "	yi1",
		"䒽", "	wang3",
		"䒼", "	qu1",
		"䒻", "	qi3",
		"䒺", "	jin3",
		"䒹", "	lei4",
		"䒸", "	xue4",
		"䒷", "	gua1",
		"䒵", "	hao4",
		"䒴", "	you3",
		"䒲", "	cha4",
		"䓂", "	yan2",
		"䒰", "	kuang1",
		"䒭", "	deng3",
		"䒬", "	mo4",
		"䒫", "	dai4",
		"䒪", "	bian4",
		"䒩", "	he2",
		"䒨", "	shi3",
		"䒧", "	qu1",
		"䒦", "	fan4",
		"䒥", "	man2",
		"䒿", "	liao2",
		"䓃", "	yi4",
		"䓜", "	zhi1",
		"䓐", "	chun2",
		"䓛", "	qu1",
		"䓚", "	qu1",
		"䓙", "	kua1",
		"䓘", "	gao1",
		"䓗", "	cong1",
		"䓖", "	qiong2",
		"䓕", "	tuo3",
		"䓓", "	chou2",
		"䓒", "	kuai3",
		"䓑", "	ping2",
		"䓏", "	fu1",
		"䓄", "	yin2",
		"䓎", "	chuo4",
		"䓍", "	han3",
		"䓌", "	zhi4",
		"䓋", "	zhi1",
		"䓊", "	wu2",
		"䓉", "	ye2",
		"䓈", "	yi4",
		"䓇", "	xi4",
		"䓆", "	zhe2",
		"䓅", "	qi2",
		"䐱", "	zhai4",
		"䐯", "	lei2",
		"䔘", "	zuo4",
		"䎜", "	hun1",
		"䎨", "	ye4",
		"䎧", "	bang4",
		"䎦", "	yan3",
		"䎤", "	ju2",
		"䎣", "	si4",
		"䎢", "	qi3",
		"䎡", "	ruan3",
		"䎠", "	er2",
		"䎟", "	er2",
		"䎝", "	chu2",
		"䎚", "	guan4",
		"䎪", "	ne4",
		"䎙", "	pin1",
		"䎘", "	su4",
		"䎗", "	qiao2",
		"䎖", "	zeng1",
		"䎕", "	hong1",
		"䎔", "	fu1",
		"䎓", "	ta4",
		"䎒", "	zhan3",
		"䎑", "	lu4",
		"䎐", "	chao3",
		"䎩", "	zi1",
		"䎫", "	chuang4",
		"䎎", "	na4",
		"䎸", "	wu4",
		"䏂", "	sou3",
		"䏁", "	zai3",
		"䏀", "	la4",
		"䎿", "	qiu2",
		"䎾", "	gun3",
		"䎽", "	wen2",
		"䎼", "	lu4",
		"䎻", "	zhou4",
		"䎺", "	zhi4",
		"䎹", "	wen2",
		"䎷", "	zhu4",
		"䎬", "	ba4",
		"䎶", "	er4",
		"䎵", "	bi4",
		"䎴", "	geng1",
		"䎳", "	wa4",
		"䎲", "	zhe2",
		"䎱", "	ba4",
		"䎰", "	zuo2",
		"䎯", "	han4",
		"䎮", "	ti4",
		"䎭", "	cao1",
		"䎏", "	han2",
		"䎌", "	chu4",
		"䏄", "	di3",
		"䍢", "	wu2",
		"䍮", "	zhao4",
		"䍬", "	peng1",
		"䍫", "	tuo2",
		"䍪", "	wa4",
		"䍩", "	yang3",
		"䍨", "	po1",
		"䍦", "	li2",
		"䍥", "	li4",
		"䍤", "	ji3",
		"䍣", "	lei2",
		"䍡", "	lu4",
		"䍱", "	xu2",
		"䍠", "	li2",
		"䍟", "	zong4",
		"䍞", "	yu4",
		"䍝", "	ta4",
		"䍜", "	zhao4",
		"䍛", "	gu4",
		"䍚", "	lang4",
		"䍙", "	mei2",
		"䍘", "	mi2",
		"䍗", "	xuan4",
		"䍯", "	gui3",
		"䍲", "	nai2",
		"䎋", "	kao4",
		"䎀", "	xue4",
		"䎊", "	luo4",
		"䎉", "	xu4",
		"䎈", "	yi4",
		"䎇", "	zhou1",
		"䎆", "	liao4",
		"䎅", "	po4",
		"䎄", "	xiao1",
		"䎃", "	ran3",
		"䎂", "	bao3",
		"䎁", "	hu2",
		"䍿", "	huang2",
		"䍳", "	que4",
		"䍾", "	yan3",
		"䍽", "	li4",
		"䍼", "	zan1",
		"䍻", "	xuan4",
		"䍺", "	huan4",
		"䍸", "	bo2",
		"䍷", "	wei3",
		"䍶", "	dong1",
		"䍵", "	zheng1",
		"䍴", "	wei3",
		"䏃", "	mian2",
		"䏅", "	qi4",
		"䐮", "	chan3",
		"䐉", "	zi4",
		"䐓", "	rou2",
		"䐒", "	zha1",
		"䐑", "	zhe2",
		"䐐", "	qiu1",
		"䐏", "	chun3",
		"䐎", "	di1",
		"䐍", "	chu4",
		"䐌", "	tian3",
		"䐋", "	cong1",
		"䐊", "	kun1",
		"䐈", "	zhi2",
		"䐕", "	ji2",
		"䐇", "	wen3",
		"䐆", "	cai3",
		"䐅", "	xi1",
		"䐄", "	xian4",
		"䐃", "	jun4",
		"䐂", "	lu4",
		"䐁", "	zhuo2",
		"䐀", "	ji4",
		"䏿", "	qi3",
		"䏽", "	bu4",
		"䐔", "	bin3",
		"䐖", "	xi1",
		"䏻", "	neng2",
		"䐣", "	sun3",
		"䐭", "	zhi4",
		"䐬", "	cao2",
		"䐫", "	cong1",
		"䐪", "	fan4",
		"䐩", "	gai1",
		"䐨", "	gu3",
		"䐧", "	kao4",
		"䐦", "	ke1",
		"䐥", "	weng3",
		"䐤", "	chai1",
		"䐢", "	zhu4",
		"䐗", "	zhu1",
		"䐡", "	qi2",
		"䐠", "	huang3",
		"䐟", "	xiang3",
		"䐞", "	ruo4",
		"䐝", "	suo4",
		"䐜", "	chen1",
		"䐛", "	da1",
		"䐚", "	ji1",
		"䐙", "	ge2",
		"䐘", "	jue2",
		"䏼", "	can2",
		"䏺", "	pang1",
		"䏆", "	cao2",
		"䏒", "	pian4",
		"䏜", "	he1",
		"䏛", "	chun3",
		"䏚", "	chao3",
		"䏙", "	tan3",
		"䏘", "	pi4",
		"䏗", "	gai4",
		"䏖", "	zhen4",
		"䏕", "	ren4",
		"䏔", "	niu3",
		"䏓", "	guan3",
		"䏑", "	di4",
		"䏞", "	mo4",
		"䏐", "	jue2",
		"䏏", "	xu1",
		"䏎", "	feng2",
		"䏍", "	yuan4",
		"䏌", "	qi4",
		"䏋", "	su4",
		"䏊", "	long2",
		"䏉", "	shi1",
		"䏈", "	lian2",
		"䏇", "	piao4",
		"䏝", "	zhuan1",
		"䏟", "	bie2",
		"䏹", "	xian4",
		"䏮", "	xi2",
		"䏸", "	yu2",
		"䏷", "	han4",
		"䏶", "	bi4",
		"䏵", "	meng3",
		"䏴", "	shao4",
		"䏳", "	zhe4",
		"䏲", "	die2",
		"䏱", "	ju2",
		"䏰", "	run4",
		"䏯", "	zhi4",
		"䏬", "	mou2",
		"䏠", "	qi4",
		"䏫", "	xiu1",
		"䏪", "	er4",
		"䏩", "	xi1",
		"䏨", "	hui3",
		"䏧", "	na4",
		"䏦", "	gua1",
		"䏤", "	si4",
		"䏣", "	jue2",
		"䏢", "	bi3",
		"䏡", "	shi4",
		"䔗", "	xiang2",
		"䔙", "	diao4",
		"䛧", "	mi2",
		"䙊", "	xie4",
		"䙗", "	ti4",
		"䙕", "	zong3",
		"䙔", "	ou1",
		"䙓", "	bai3",
		"䙒", "	xu4",
		"䙑", "	cui1",
		"䙐", "	ke4",
		"䙏", "	bo2",
		"䙎", "	xie2",
		"䙌", "	kui4",
		"䙉", "	xun2",
		"䙙", "	chi2",
		"䙈", "	hou2",
		"䙇", "	ruan2",
		"䙆", "	kui4",
		"䙅", "	yao1",
		"䙄", "	qi4",
		"䙃", "	duo4",
		"䙁", "	can2",
		"䙀", "	beng3",
		"䘿", "	jue2",
		"䘾", "	guan3",
		"䙘", "	chu3",
		"䙚", "	niao3",
		"䘼", "	wan3",
		"䙨", "	guo3",
		"䙷", "	de2",
		"䙵", "	xi1",
		"䙳", "	biao1",
		"䙱", "	du2",
		"䙰", "	li2",
		"䙯", "	cu4",
		"䙮", "	guan4",
		"䙬", "	ying4",
		"䙪", "	long2",
		"䙩", "	meng2",
		"䙦", "	meng2",
		"䙛", "	guan4",
		"䙥", "	ling2",
		"䙤", "	duo3",
		"䙣", "	sa4",
		"䙢", "	zeng4",
		"䙡", "	kui4",
		"䙠", "	jue2",
		"䙟", "	wei2",
		"䙞", "	deng1",
		"䙝", "	xie4",
		"䙜", "	feng2",
		"䘽", "	ni2",
		"䘻", "	yu4",
		"䙹", "	xian4",
		"䘌", "	ni4",
		"䘘", "	yu4",
		"䘕", "	hang2",
		"䘔", "	ka1",
		"䘓", "	kan4",
		"䘒", "	zui1",
		"䘑", "	mai4",
		"䘐", "	nv4",
		"䘏", "	xu4",
		"䘎", "	wan1",
		"䘍", "	chai4",
		"䘋", "	jian1",
		"䘚", "	zhu2",
		"䘊", "	mie4",
		"䘉", "	can2",
		"䘈", "	li4",
		"䘇", "	wen2",
		"䘆", "	xian3",
		"䘅", "	nai2",
		"䘄", "	zhu4",
		"䘃", "	mo4",
		"䘁", "	ge2",
		"䘀", "	fu4",
		"䘙", "	wei4",
		"䘝", "	yi4",
		"䘺", "	zhan4",
		"䘬", "	rong2",
		"䘹", "	zui4",
		"䘸", "	yi4",
		"䘷", "	bie1",
		"䘶", "	han1",
		"䘵", "	lu4",
		"䘳", "	jin1",
		"䘱", "	yu4",
		"䘰", "	shan1",
		"䘮", "	sang1",
		"䘭", "	zhi4",
		"䘫", "	nou4",
		"䘟", "	diao1",
		"䘪", "	chong1",
		"䘩", "	xun2",
		"䘨", "	jiao3",
		"䘦", "	ni2",
		"䘥", "	xia2",
		"䘤", "	shu4",
		"䘣", "	zi3",
		"䘢", "	zhu3",
		"䘡", "	bi3",
		"䘠", "	fu2",
		"䙸", "	de2",
		"䙺", "	lian2",
		"䗾", "	xian3",
		"䛁", "	nan2",
		"䛋", "	ji4",
		"䛊", "	xi1",
		"䛉", "	mian4",
		"䛈", "	shi4",
		"䛇", "	yuan3",
		"䛆", "	zhou4",
		"䛅", "	xia2",
		"䛄", "	yuan3",
		"䛃", "	wan4",
		"䛂", "	yao1",
		"䛀", "	fan3",
		"䛍", "	fei4",
		"䚿", "	yin4",
		"䚾", "	nin2",
		"䚽", "	hao4",
		"䚼", "	nv4",
		"䚻", "	yao2",
		"䚺", "	yao2",
		"䚹", "	pi3",
		"䚸", "	xie4",
		"䚷", "	yi1",
		"䚶", "	tian1",
		"䛌", "	tao2",
		"䛎", "	xue4",
		"䚴", "	wa4",
		"䛜", "	xun4",
		"䛦", "	song4",
		"䛥", "	xi1",
		"䛤", "	cu4",
		"䛣", "	ping1",
		"䛢", "	tu1",
		"䛡", "	hua4",
		"䛠", "	dou4",
		"䛟", "	jia2",
		"䛞", "	han4",
		"䛝", "	nao2",
		"䛛", "	hui4",
		"䛏", "	ni2",
		"䛚", "	lue4",
		"䛙", "	xu4",
		"䛘", "	ren2",
		"䛗", "	zhi3",
		"䛖", "	e4",
		"䛕", "	yu4",
		"䛔", "	na2",
		"䛒", "	bian4",
		"䛑", "	mi4",
		"䛐", "	ci2",
		"䚵", "	tou3",
		"䚳", "	zhi4",
		"䙼", "	shao4",
		"䚊", "	jian3",
		"䚖", "	ling2",
		"䚕", "	li4",
		"䚔", "	bin1",
		"䚓", "	nian3",
		"䚒", "	chuang2",
		"䚑", "	mai2",
		"䚐", "	ji2",
		"䚏", "	lin4",
		"䚍", "	qi4",
		"䚋", "	yun4",
		"䚉", "	qi4",
		"䚘", "	cheng2",
		"䚈", "	juan4",
		"䚇", "	sheng3",
		"䚆", "	ying3",
		"䚅", "	lai4",
		"䚄", "	lu4",
		"䚃", "	you2",
		"䚂", "	he4",
		"䙿", "	wei4",
		"䙾", "	shi1",
		"䙽", "	xie2",
		"䚗", "	gang1",
		"䚙", "	xuan1",
		"䚲", "	shan4",
		"䚧", "	liu2",
		"䚱", "	xin4",
		"䚰", "	pi3",
		"䚯", "	tao3",
		"䚮", "	reng2",
		"䚭", "	xuan1",
		"䚬", "	lin2",
		"䚫", "	xi2",
		"䚪", "	guan1",
		"䚩", "	jiao3",
		"䚨", "	fei4",
		"䚦", "	zhi4",
		"䚚", "	xian3",
		"䚥", "	nuo4",
		"䚣", "	ti2",
		"䚢", "	che4",
		"䚡", "	sai1",
		"䚠", "	hun4",
		"䚟", "	dai3",
		"䚞", "	dai3",
		"䚝", "	zu2",
		"䚜", "	bi1",
		"䚛", "	hu2",
		"䗿", "	ning2",
		"䗽", "	wei4",
		"䔚", "	chun2",
		"䕥", "	ni3",
		"䕰", "	fan2",
		"䕯", "	piao2",
		"䕮", "	ju2",
		"䕭", "	qian2",
		"䕫", "	kui2",
		"䕪", "	ze2",
		"䕩", "	lao3",
		"䕨", "	teng2",
		"䕧", "	xiao4",
		"䕦", "	ying2",
		"䕤", "	ji1",
		"䕲", "	lin3",
		"䕣", "	he2",
		"䕢", "	zha3",
		"䕡", "	lv2",
		"䕠", "	fei4",
		"䕟", "	xing1",
		"䕞", "	lang4",
		"䕝", "	cheng1",
		"䕛", "	jia2",
		"䕚", "	kui4",
		"䕙", "	jie2",
		"䕱", "	tou2",
		"䕳", "	mi2",
		"䕗", "	bi4",
		"䖁", "	yi4",
		"䖌", "	yi4",
		"䖋", "	nue4",
		"䖊", "	yi4",
		"䖈", "	nue4",
		"䖇", "	yu4",
		"䖆", "	niang4",
		"䖅", "	ling2",
		"䖄", "	ran2",
		"䖃", "	yue4",
		"䖂", "	luan2",
		"䕿", "	han4",
		"䕴", "	zhuo2",
		"䕾", "	yin2",
		"䕽", "	zhu2",
		"䕼", "	ran2",
		"䕻", "	li4",
		"䕺", "	cong2",
		"䕹", "	za2",
		"䕸", "	jie1",
		"䕷", "	mi2",
		"䕶", "	hu4",
		"䕵", "	xie2",
		"䕘", "	ling2",
		"䕕", "	man4",
		"䖎", "	xia2",
		"䔪", "	shuang3",
		"䔶", "	ti2",
		"䔴", "	ce4",
		"䔳", "	ran2",
		"䔲", "	deng1",
		"䔱", "	yi1",
		"䔰", "	fu4",
		"䔯", "	ku4",
		"䔮", "	si1",
		"䔭", "	ning4",
		"䔬", "	yi4",
		"䔧", "	li2",
		"䔸", "	biao3",
		"䔤", "	pa1",
		"䔣", "	li2",
		"䔢", "	hua2",
		"䔡", "	yu2",
		"䔠", "	shao3",
		"䔟", "	yi2",
		"䔞", "	lv4",
		"䔝", "	zhai1",
		"䔜", "	nan2",
		"䔛", "	qing3",
		"䔷", "	qin2",
		"䔹", "	sui4",
		"䕔", "	xian2",
		"䕈", "	xie4",
		"䕓", "	cha2",
		"䕒", "	jia1",
		"䕑", "	jun4",
		"䕏", "	e2",
		"䕎", "	fu2",
		"䕍", "	yi4",
		"䕌", "	zhi4",
		"䕋", "	tang2",
		"䕊", "	tan2",
		"䕉", "	ze2",
		"䕇", "	hui4",
		"䔺", "	wei2",
		"䕆", "	dou4",
		"䕅", "	sao3",
		"䕃", "	yin4",
		"䕁", "	fei3",
		"䕀", "	kuan3",
		"䔿", "	zun3",
		"䔾", "	qi4",
		"䔽", "	ai4",
		"䔼", "	se4",
		"䔻", "	dun1",
		"䖍", "	qian2",
		"䖏", "	chu3",
		"䗼", "	xun1",
		"䗓", "	cong1",
		"䗝", "	can2",
		"䗜", "	liu2",
		"䗛", "	xiu1",
		"䗚", "	bo2",
		"䗙", "	han2",
		"䗘", "	ge2",
		"䗗", "	ji1",
		"䗖", "	di4",
		"䗕", "	wan3",
		"䗔", "	hou2",
		"䗒", "	bing4",
		"䗟", "	yi4",
		"䗑", "	yi4",
		"䗐", "	shi1",
		"䗏", "	sou1",
		"䗎", "	yan1",
		"䗍", "	li3",
		"䗌", "	xing1",
		"䗋", "	mou2",
		"䗊", "	tan4",
		"䗉", "	chang1",
		"䗈", "	meng2",
		"䗞", "	can2",
		"䗠", "	xuan2",
		"䗆", "	guan3",
		"䗰", "	guan4",
		"䗻", "	jie2",
		"䗺", "	yan3",
		"䗹", "	ci4",
		"䗸", "	yong1",
		"䗷", "	yi4",
		"䗶", "	la4",
		"䗵", "	jiang1",
		"䗴", "	ting2",
		"䗲", "	lin4",
		"䗱", "	pu2",
		"䗯", "	jin4",
		"䗡", "	yan2",
		"䗮", "	shuang3",
		"䗫", "	ma2",
		"䗪", "	zhe4",
		"䗩", "	qi1",
		"䗨", "	yu2",
		"䗧", "	kang1",
		"䗥", "	zong1",
		"䗤", "	yong2",
		"䗣", "	han4",
		"䗢", "	zao3",
		"䗇", "	ju2",
		"䗅", "	chang2",
		"䖐", "	yin2",
		"䖜", "	yin2",
		"䖦", "	qu1",
		"䖥", "	li2",
		"䖤", "	wan3",
		"䖣", "	zao3",
		"䖢", "	miao2",
		"䖡", "	nv4",
		"䖠", "	yuan2",
		"䖟", "	mang3",
		"䖞", "	zhou3",
		"䖝", "	chong2",
		"䖛", "	suo3",
		"䖨", "	shi2",
		"䖚", "	wu1",
		"䖙", "	ti1",
		"䖘", "	tu2",
		"䖗", "	yan2",
		"䖖", "	xia2",
		"䖕", "	zu3",
		"䖔", "	kan3",
		"䖓", "	na4",
		"䖒", "	xi1",
		"䖑", "	mi4",
		"䖧", "	na4",
		"䖩", "	bi4",
		"䗄", "	fu3",
		"䖸", "	e2",
		"䗃", "	zhan4",
		"䗂", "	hu3",
		"䗁", "	ji4",
		"䗀", "	cheng1",
		"䖿", "	li2",
		"䖽", "	li2",
		"䖼", "	jue2",
		"䖻", "	you2",
		"䖺", "	tiao2",
		"䖹", "	yang2",
		"䖷", "	xi1",
		"䖪", "	zi1",
		"䖶", "	hui1",
		"䖵", "	kun1",
		"䖴", "	yao2",
		"䖳", "	zha4",
		"䖲", "	xun2",
		"䖱", "	kuang1",
		"䖰", "	pai4",
		"䖯", "	kui2",
		"䖮", "	xiang3",
		"䖭", "	juan4",
		"䖫", "	bang4",
		"䩿", "	fen2",
		"䪁", "	bu3",
		"䍕", "	di1",
		"佘", "	she2",
		"佢", "	qu2",
		"佡", "	xian1",
		"你", "	ni3",
		"佟", "	tong2",
		"佞", "	ning4",
		"佝", "	gou1",
		"作", "	zuo4",
		"佛", "	fu2",
		"佚", "	yi4",
		"余", "	yu2",
		"佗", "	tuo2",
		"佤", "	wa3",
		"佖", "	bi4",
		"何", "	he2",
		"佔", "	zhan4",
		"体", "	ti3",
		"佒", "	yang3",
		"佑", "	you4",
		"佐", "	zuo3",
		"住", "	zhu4",
		"低", "	di1",
		"位", "	wei4",
		"佣", "	yong1",
		"佥", "	qian1",
		"佋", "	zhao1",
		"佲", "	ming3",
		"佼", "	jiao3",
		"佻", "	tiao1",
		"佺", "	quan2",
		"佹", "	gui3",
		"佸", "	huo2",
		"佷", "	hen3",
		"佶", "	ji2",
		"併", "	bing4",
		"佴", "	er4",
		"佳", "	jia1",
		"佱", "	fa3",
		"佦", "	shi",
		"佰", "	bai3",
		"佯", "	yang2",
		"佮", "	ge2",
		"佭", "	xiang2",
		"佬", "	lao3",
		"佫", "	he4",
		"佪", "	hui2",
		"佩", "	pei4",
		"佨", "	bao",
		"佧", "	ka3",
		"佌", "	ci3",
		"佊", "	bi3",
		"佾", "	yi4",
		"伤", "	shang1",
		"伮", "	nu3",
		"伭", "	xian2",
		"伬", "	ze",
		"伫", "	zhu4",
		"伪", "	wei3",
		"伩", "	xin4",
		"伨", "	xun4",
		"伧", "	cang1",
		"伦", "	lun2",
		"伥", "	chang1",
		"伣", "	xian4",
		"估", "	gu1",
		"伢", "	ya2",
		"伡", "	che1",
		"传", "	chuan2",
		"伟", "	wei3",
		"伞", "	san3",
		"伝", "	chuan2",
		"伜", "	cui4",
		"伛", "	yu3",
		"会", "	hui4",
		"伙", "	huo3",
		"伯", "	bo2",
		"伱", "	ni3",
		"佉", "	qu1",
		"伾", "	pi1",
		"佈", "	bu4",
		"佇", "	zhu4",
		"但", "	dan4",
		"佅", "	mai4",
		"佄", "	han1",
		"佃", "	dian4",
		"佂", "	zheng1",
		"佁", "	yi3",
		"佀", "	si4",
		"伿", "	yi4",
		"伽", "	jia1",
		"伲", "	ni4",
		"似", "	shi4",
		"伻", "	beng1",
		"伺", "	ci4",
		"伹", "	qu1",
		"伸", "	shen1",
		"伷", "	zhou4",
		"伶", "	ling2",
		"伵", "	xu4",
		"伴", "	ban4",
		"伳", "	xie4",
		"佽", "	ci4",
		"使", "	shi3",
		"众", "	zhong4",
		"俀", "	tui3",
		"俊", "	jun4",
		"俉", "	wu3",
		"俈", "	ku4",
		"俇", "	guang4",
		"俆", "	xu2",
		"俅", "	qiu2",
		"俄", "	e2",
		"促", "	cu4",
		"係", "	xi4",
		"俁", "	yu3",
		"便", "	bian4",
		"俌", "	fu3",
		"侾", "	xiao1",
		"侽", "	nan2",
		"侼", "	bo2",
		"侻", "	tui4",
		"侺", "	shen4",
		"侹", "	ting3",
		"侸", "	shu4",
		"侷", "	ju2",
		"侶", "	lv3",
		"侵", "	qin1",
		"俋", "	yi4",
		"俍", "	liang2",
		"侳", "	zuo4",
		"俚", "	li3",
		"俤", "	di4",
		"俣", "	yu3",
		"俢", "	xiu1",
		"信", "	xin4",
		"俠", "	xia2",
		"俟", "	qi2",
		"俞", "	yu2",
		"保", "	bao3",
		"俜", "	ping1",
		"俛", "	fu3",
		"俙", "	xi1",
		"俎", "	zu3",
		"俘", "	fu2",
		"俗", "	su2",
		"俖", "	pei3",
		"俕", "	san4",
		"俔", "	qian4",
		"俓", "	jing4",
		"俒", "	hun4",
		"俑", "	yong3",
		"俐", "	li4",
		"俏", "	qiao4",
		"侴", "	chou3",
		"侲", "	zhen4",
		"侀", "	xing2",
		"侌", "	yin1",
		"侖", "	lun2",
		"侕", "	er2",
		"侔", "	mou2",
		"侓", "	lu4",
		"侒", "	an1",
		"侑", "	you4",
		"侐", "	xu4",
		"侏", "	zhu1",
		"侎", "	mi3",
		"侍", "	shi4",
		"例", "	li4",
		"侘", "	cha4",
		"侊", "	guang1",
		"侉", "	kua3",
		"侈", "	chi3",
		"侇", "	yi2",
		"來", "	lai2",
		"侅", "	gai1",
		"侄", "	zhi2",
		"侃", "	kan3",
		"侂", "	tuo1",
		"侁", "	shen1",
		"侗", "	dong4",
		"侙", "	chi1",
		"侱", "	cheng3",
		"侦", "	zhen1",
		"侰", "	jiong3",
		"侯", "	hou2",
		"侮", "	wu3",
		"侭", "	jin3",
		"侬", "	nong2",
		"侫", "	ning4",
		"侪", "	chai2",
		"侩", "	kuai4",
		"侨", "	qiao2",
		"侧", "	ce4",
		"侥", "	jiao3",
		"侚", "	xun4",
		"侤", "	ta",
		"侣", "	lv3",
		"侢", "	zai4",
		"価", "	si4",
		"侠", "	xia2",
		"侟", "	cun2",
		"侞", "	ru2",
		"依", "	yi1",
		"侜", "	zhou1",
		"供", "	gong1",
		"优", "	you1",
		"伖", "	tang3",
		"俦", "	chou2",
		"予", "	yu3",
		"互", "	hu4",
		"云", "	yun2",
		"亐", "	yu2",
		"亏", "	kui1",
		"于", "	yu2",
		"亍", "	chu4",
		"二", "	er4",
		"事", "	shi4",
		"亊", "	shi4",
		"争", "	zheng1",
		"亇", "	ma",
		"五", "	wu3",
		"了", "	le",
		"亅", "	jue2",
		"亄", "	yi4",
		"亃", "	lin3",
		"亂", "	luan4",
		"亁", "	gan1",
		"亀", "	gui1",
		"乿", "	zhi4",
		"乾", "	gan1",
		"乽", "	zhe3",
		"亓", "	qi2",
		"井", "	jing3",
		"乻", "	yu2",
		"亢", "	kang4",
		"京", "	jing1",
		"享", "	xiang3",
		"亪", "	ye",
		"亩", "	mu3",
		"亨", "	heng1",
		"产", "	chan3",
		"亦", "	yi4",
		"亥", "	hai4",
		"交", "	jiao1",
		"亣", "	ta4",
		"亡", "	wang2",
		"亖", "	si4",
		"亠", "	tou2",
		"亟", "	ji2",
		"亞", "	ya4",
		"亝", "	qi2",
		"亜", "	ya4",
		"些", "	xie1",
		"亚", "	ya4",
		"亙", "	gen4",
		"亘", "	gen4",
		"亗", "	sui4",
		"乼", "	cui",
		"乺", "	suo3",
		"亮", "	liang4",
		"乔", "	qiao2",
		"乞", "	qi3",
		"九", "	jiu3",
		"乜", "	mie1",
		"乛", "	ya",
		"乚", "	yin3",
		"乙", "	yi3",
		"乘", "	cheng2",
		"乗", "	cheng2",
		"乖", "	guai1",
		"乕", "	hu3",
		"乓", "	pang1",
		"习", "	xi2",
		"乒", "	ping1",
		"乑", "	yin2",
		"乐", "	le4",
		"乏", "	fa2",
		"乎", "	hu1",
		"乍", "	zha4",
		"乌", "	wu1",
		"之", "	zhi1",
		"乊", "	yi1",
		"义", "	yi4",
		"也", "	ye3",
		"乡", "	xiang1",
		"乹", "	gan1",
		"乮", "	mao3",
		"乸", "	na3",
		"乷", "	sha1",
		"乶", "	fu3",
		"乵", "	yan3",
		"乴", "	xue2",
		"乳", "	ru3",
		"乲", "	zi1",
		"乱", "	luan4",
		"买", "	mai3",
		"乯", "	hu1",
		"乭", "	shi2",
		"乢", "	gai4",
		"乬", "	ju4",
		"乫", "	jia1",
		"乪", "	nang2",
		"乩", "	ji1",
		"乨", "	shi3",
		"乧", "	dou",
		"书", "	shu1",
		"乥", "	hu4",
		"乤", "	xia4",
		"乣", "	jiu3",
		"亭", "	ting2",
		"亯", "	xiang3",
		"伕", "	fu1",
		"仰", "	yang3",
		"仺", "	cang1",
		"仹", "	feng1",
		"仸", "	yao3",
		"价", "	jia4",
		"件", "	jian4",
		"仵", "	wu3",
		"仴", "	wo4",
		"仳", "	pi3",
		"仲", "	zhong4",
		"仱", "	qian2",
		"仯", "	chao4",
		"仼", "	wang2",
		"仮", "	jia3",
		"仭", "	ren4",
		"们", "	men",
		"仫", "	mu4",
		"仪", "	yi2",
		"仩", "	shang",
		"仨", "	sa1",
		"仧", "	chang2",
		"仦", "	chao4",
		"以", "	yi3",
		"任", "	ren4",
		"份", "	fen4",
		"代", "	dai4",
		"伊", "	yi1",
		"伔", "	dan3",
		"伓", "	pi1",
		"伒", "	jin4",
		"休", "	xiu1",
		"伐", "	fa2",
		"伏", "	fu2",
		"伎", "	ji4",
		"伍", "	wu3",
		"伌", "	ai4",
		"伋", "	ji2",
		"伉", "	kang4",
		"仾", "	di1",
		"伈", "	xin3",
		"伇", "	yi4",
		"伆", "	wu4",
		"伅", "	dun4",
		"伄", "	diao4",
		"伃", "	yu2",
		"伂", "	pei4",
		"企", "	qi3",
		"伀", "	zhong1",
		"仿", "	fang3",
		"令", "	ling4",
		"仢", "	bo2",
		"亰", "	jing1",
		"亼", "	ji2",
		"仆", "	pu1",
		"仅", "	jin3",
		"仄", "	ze4",
		"仃", "	ding1",
		"仂", "	le4",
		"仁", "	ren2",
		"什", "	shen2",
		"亿", "	yi4",
		"亾", "	wang2",
		"亽", "	ji",
		"亻", "	ren2",
		"仈", "	ba1",
		"人", "	ren2",
		"亹", "	men2",
		"亸", "	duo3",
		"亷", "	lian2",
		"亶", "	dan3",
		"亵", "	xie4",
		"亴", "	you4",
		"亳", "	bo2",
		"亲", "	qin1",
		"亱", "	ye4",
		"仇", "	chou2",
		"仉", "	zhang3",
		"仡", "	ge1",
		"他", "	ta1",
		"仠", "	gan3",
		"仟", "	qian1",
		"仞", "	ren4",
		"仝", "	tong2",
		"仜", "	hong2",
		"仛", "	tuo1",
		"仚", "	xian1",
		"仙", "	xian1",
		"付", "	fu4",
		"仗", "	zhang4",
		"仕", "	shi4",
		"今", "	jin1",
		"仔", "	zi3",
		"仓", "	cang1",
		"仒", "	bing1",
		"仑", "	lun2",
		"仐", "	san3",
		"仏", "	fo2",
		"从", "	cong2",
		"仍", "	reng2",
		"仌", "	bing1",
		"介", "	jie4",
		"俥", "	che1",
		"俧", "	zhi",
		"乇", "	tuo1",
		"價", "	jia4",
		"儃", "	chan2",
		"儂", "	nong2",
		"儁", "	jun4",
		"儀", "	yi2",
		"僿", "	sai4",
		"僾", "	ai4",
		"僽", "	zhou4",
		"僼", "	feng1",
		"僻", "	pi4",
		"僺", "	qiao4",
		"僸", "	jin4",
		"儅", "	dang4",
		"僷", "	ye4",
		"僶", "	min3",
		"僵", "	jiang1",
		"僴", "	xian4",
		"僳", "	su4",
		"僲", "	xian",
		"僱", "	gu4",
		"僰", "	bo2",
		"僯", "	lin4",
		"僮", "	tong2",
		"億", "	yi4",
		"儆", "	jing3",
		"僬", "	jiao1",
		"儓", "	tai2",
		"儝", "	qiong2",
		"儜", "	ning2",
		"儛", "	wu3",
		"儚", "	meng2",
		"儙", "	qian4",
		"儘", "	jin3",
		"儗", "	ni3",
		"儖", "	lan2",
		"儕", "	chai2",
		"儔", "	chou2",
		"儒", "	ru2",
		"儇", "	xuan1",
		"儑", "	an2",
		"儐", "	bin1",
		"儏", "	can",
		"儎", "	zai4",
		"儍", "	sha3",
		"儌", "	jiao3",
		"儋", "	dan1",
		"儊", "	chu4",
		"儉", "	jian3",
		"儈", "	kuai4",
		"僭", "	jian4",
		"僫", "	e4",
		"償", "	chang2",
		"僅", "	jin3",
		"像", "	xiang4",
		"僎", "	zhuan4",
		"働", "	dong4",
		"僌", "	ying2",
		"僋", "	tan4",
		"僊", "	xian1",
		"僉", "	qian1",
		"僈", "	man2",
		"僇", "	lu4",
		"僆", "	lian4",
		"僄", "	piao4",
		"僑", "	qiao2",
		"僃", "	bei4",
		"僂", "	lou2",
		"僁", "	xie4",
		"僀", "	di4",
		"傿", "	yan4",
		"傾", "	qing1",
		"傽", "	zhang1",
		"傼", "	han4",
		"傻", "	sha3",
		"傺", "	chi4",
		"僐", "	shan4",
		"僒", "	jiong3",
		"僪", "	ju2",
		"僟", "	ji1",
		"僩", "	xian4",
		"僨", "	fen4",
		"僧", "	seng1",
		"僦", "	jiu4",
		"僥", "	jiao3",
		"僤", "	dan4",
		"僣", "	tie3",
		"僢", "	chuan3",
		"僡", "	hui4",
		"僠", "	bo1",
		"僞", "	wei3",
		"僓", "	tui3",
		"僝", "	chan2",
		"僜", "	cheng1",
		"僛", "	qi1",
		"僚", "	liao2",
		"僙", "	guang1",
		"僘", "	chang3",
		"僗", "	lao2",
		"僖", "	xi1",
		"僕", "	pu2",
		"僔", "	zun3",
		"儞", "	ni3",
		"儠", "	lie4",
		"傸", "	chuang3",
		"兣", "	li3",
		"六", "	liu4",
		"公", "	gong1",
		"八", "	ba1",
		"兪", "	yu2",
		"兩", "	liang3",
		"全", "	quan2",
		"內", "	nei4",
		"兦", "	wang2",
		"入", "	ru4",
		"兤", "	huang2",
		"兢", "	jing1",
		"兯", "	han",
		"兠", "	dou1",
		"兟", "	shen1",
		"兞", "	mao2",
		"兝", "	fen1",
		"兜", "	dou1",
		"兛", "	qian1",
		"党", "	dang3",
		"兘", "	shi3",
		"兗", "	yan3",
		"兖", "	yan3",
		"兮", "	xi1",
		"兰", "	lan2",
		"兔", "	tu4",
		"兽", "	shou4",
		"冇", "	mao3",
		"円", "	yuan2",
		"内", "	nei4",
		"冄", "	ran3",
		"冃", "	mao4",
		"冂", "	jiong1",
		"冁", "	chan3",
		"冀", "	ji4",
		"兿", "	yi4",
		"兾", "	ji4",
		"兼", "	jian1",
		"共", "	gong4",
		"养", "	yang3",
		"兺", "	fen1",
		"兹", "	zi1",
		"典", "	dian3",
		"具", "	ju4",
		"其", "	qi2",
		"兵", "	bing1",
		"兴", "	xing4",
		"关", "	guan1",
		"兲", "	tian1",
		"兕", "	si4",
		"兓", "	jin1",
		"儡", "	lei3",
		"儭", "	chen4",
		"儷", "	li4",
		"儶", "	hui4",
		"儵", "	shu1",
		"儴", "	rang2",
		"儳", "	chan2",
		"儲", "	chu3",
		"儱", "	long3",
		"儰", "	wei3",
		"儯", "	teng2",
		"儮", "	li4",
		"儬", "	chen4",
		"儹", "	zan3",
		"儫", "	hao2",
		"優", "	you1",
		"儩", "	si4",
		"儨", "	zhi2",
		"儧", "	zan3",
		"儦", "	biao1",
		"儥", "	yu4",
		"儤", "	bao4",
		"儣", "	kuang3",
		"儢", "	lv3",
		"儸", "	luo2",
		"儺", "	nuo2",
		"兒", "	er2",
		"兇", "	xiong1",
		"兑", "	dui4",
		"児", "	er2",
		"兏", "	chang2",
		"兎", "	tu4",
		"免", "	mian3",
		"兌", "	dui4",
		"克", "	ke4",
		"兊", "	dui4",
		"光", "	guang1",
		"先", "	xian1",
		"兆", "	zhao4",
		"儻", "	tang3",
		"充", "	chong1",
		"兄", "	xiong1",
		"元", "	yuan2",
		"兂", "	zan1",
		"允", "	yun3",
		"兀", "	wu4",
		"儿", "	er2",
		"儾", "	nang4",
		"儽", "	lei2",
		"儼", "	yan3",
		"傹", "	jing4",
		"傷", "	shang1",
		"俨", "	yan3",
		"倨", "	ju4",
		"倲", "	dong1",
		"倱", "	hun4",
		"倰", "	leng4",
		"倯", "	song1",
		"倮", "	luo3",
		"倭", "	wo1",
		"倬", "	zhuo1",
		"倫", "	lun2",
		"倪", "	ni2",
		"倩", "	qian4",
		"倧", "	zong1",
		"倴", "	ben4",
		"倦", "	juan4",
		"倥", "	kong1",
		"値", "	zhi2",
		"倣", "	fang3",
		"倢", "	jie2",
		"倡", "	chang4",
		"倠", "	sui1",
		"借", "	jie4",
		"倞", "	jing4",
		"倝", "	gan4",
		"倳", "	zi4",
		"倵", "	wu3",
		"倛", "	qi1",
		"偂", "	jian1",
		"偌", "	ruo4",
		"偋", "	bing4",
		"偊", "	yu3",
		"偉", "	wei3",
		"偈", "	ji4",
		"假", "	jia3",
		"偆", "	chun3",
		"偅", "	zhong4",
		"偄", "	ruan3",
		"偃", "	yan3",
		"偁", "	cheng1",
		"倶", "	ju4",
		"偀", "	ying1",
		"倿", "	qie",
		"倾", "	qing1",
		"倽", "	sha4",
		"值", "	zhi2",
		"倻", "	ye1",
		"债", "	zhai4",
		"倹", "	jian3",
		"倸", "	cai3",
		"倷", "	nai3",
		"倜", "	ti4",
		"倚", "	yi3",
		"偎", "	wei1",
		"俴", "	jian4",
		"俾", "	bi3",
		"俽", "	xin1",
		"俼", "	yu4",
		"俻", "	bei4",
		"俺", "	an3",
		"俹", "	ya4",
		"俸", "	feng4",
		"俷", "	fei4",
		"俶", "	chu4",
		"俵", "	biao4",
		"俳", "	pai2",
		"倀", "	chang1",
		"俲", "	xiao4",
		"俱", "	ju4",
		"俰", "	huo4",
		"俯", "	fu3",
		"修", "	xiu1",
		"俭", "	jian3",
		"俬", "	si1",
		"俫", "	lai2",
		"俪", "	li4",
		"俩", "	lia3",
		"俿", "	hu3",
		"倁", "	zhi1",
		"候", "	hou4",
		"倎", "	tian3",
		"倘", "	tang3",
		"倗", "	peng2",
		"倖", "	xing4",
		"倕", "	chui2",
		"倔", "	jue2",
		"倓", "	tan2",
		"倒", "	dao4",
		"們", "	men",
		"倐", "	shu1",
		"倏", "	shu1",
		"倍", "	bei4",
		"倂", "	bing4",
		"倌", "	guan1",
		"個", "	ge4",
		"倊", "	zong4",
		"倉", "	cang1",
		"倈", "	lai2",
		"倇", "	wan3",
		"倆", "	lia3",
		"倅", "	cui4",
		"倄", "	yao2",
		"倃", "	jiu4",
		"偍", "	ti2",
		"偏", "	pian1",
		"傶", "	zu2",
		"傑", "	jie2",
		"傛", "	yong3",
		"傚", "	xiao4",
		"備", "	bei4",
		"傘", "	san3",
		"傗", "	chu4",
		"傖", "	cang1",
		"傕", "	jue2",
		"傔", "	qian4",
		"傓", "	shan4",
		"傒", "	xi1",
		"傐", "	hao4",
		"傝", "	tan4",
		"傏", "	tang2",
		"傎", "	dian1",
		"傍", "	bang4",
		"傌", "	ma4",
		"傋", "	jiang3",
		"傊", "	yun4",
		"傉", "	nu4",
		"傈", "	li4",
		"傇", "	rong3",
		"傆", "	yuan4",
		"傜", "	yao2",
		"傞", "	suo1",
		"傄", "	xia1",
		"傫", "	lei3",
		"債", "	zhai4",
		"傴", "	yu3",
		"傳", "	chuan2",
		"傲", "	ao4",
		"傱", "	song3",
		"傰", "	beng1",
		"傯", "	zong3",
		"傮", "	zao1",
		"傭", "	yong1",
		"催", "	cui1",
		"傪", "	can1",
		"傟", "	yang3",
		"傩", "	nuo2",
		"储", "	chu3",
		"傧", "	bin1",
		"傦", "	gu",
		"傥", "	tang3",
		"傤", "	zai4",
		"傣", "	dai3",
		"傢", "	jia1",
		"傡", "	bing4",
		"傠", "	fa1",
		"傅", "	fu4",
		"傃", "	su4",
		"偐", "	yan4",
		"停", "	ting2",
		"偦", "	xu3",
		"健", "	jian4",
		"偤", "	you2",
		"偣", "	yan1",
		"偢", "	chou3",
		"偡", "	zhan4",
		"偠", "	yao3",
		"偟", "	huang2",
		"偞", "	xie4",
		"偝", "	bei4",
		"偛", "	cha1",
		"偨", "	ci1",
		"做", "	zuo4",
		"偙", "	di4",
		"偘", "	kan3",
		"偗", "	sheng3",
		"偖", "	che3",
		"偕", "	xie2",
		"偔", "	e4",
		"偓", "	wo4",
		"偒", "	tang3",
		"偑", "	feng1",
		"偧", "	zha1",
		"偩", "	fu4",
		"傂", "	zhi4",
		"偷", "	tou1",
		"傁", "	sou3",
		"傀", "	gui1",
		"偿", "	chang2",
		"偾", "	fen4",
		"偽", "	wei3",
		"偼", "	jie2",
		"偻", "	lou2",
		"偺", "	za2",
		"偹", "	bei4",
		"偸", "	tou1",
		"偶", "	ou3",
		"偪", "	bi1",
		"偵", "	zhen1",
		"側", "	ce4",
		"偳", "	duan1",
		"偲", "	cai1",
		"偱", "	xun2",
		"偰", "	xie4",
		"偯", "	yi3",
		"偮", "	ji2",
		"偭", "	mian3",
		"偬", "	zong3",
		"偫", "	zhi4",
		"么", "	me",
		"乆", "	jiu3",
		"䪂", "	ge2",
		"䮪", "	cheng2",
		"䮴", "	deng4",
		"䮳", "	fan2",
		"䮲", "	huang2",
		"䮱", "	zhu2",
		"䮰", "	zhe2",
		"䮯", "	ao4",
		"䮮", "	mai4",
		"䮭", "	mi4",
		"䮬", "	mo4",
		"䮫", "	lou2",
		"䮩", "	gu2",
		"䮷", "	du2",
		"䮨", "	zai3",
		"䮧", "	han4",
		"䮥", "	li4",
		"䮤", "	he2",
		"䮢", "	zha2",
		"䮡", "	bi4",
		"䮠", "	bi1",
		"䮟", "	sou1",
		"䮞", "	chun3",
		"䮝", "	hun2",
		"䮵", "	tong2",
		"䮸", "	wo4",
		"䮛", "	fu4",
		"䯆", "	yi4",
		"䯐", "	hai2",
		"䯏", "	gua1",
		"䯎", "	gan4",
		"䯍", "	ling2",
		"䯌", "	kao1",
		"䯋", "	bo2",
		"䯊", "	qia4",
		"䯉", "	wa1",
		"䯈", "	wan2",
		"䯇", "	ku1",
		"䯅", "	nie4",
		"䮹", "	wei4",
		"䯄", "	gua1",
		"䯂", "	shen1",
		"䯁", "	luo2",
		"䯀", "	nie4",
		"䮿", "	jian3",
		"䮾", "	long2",
		"䮽", "	biao1",
		"䮼", "	lin2",
		"䮻", "	chi4",
		"䮺", "	ji4",
		"䮜", "	zha2",
		"䮚", "	leng4",
		"䯒", "	heng2",
		"䭯", "	bo2",
		"䭹", "	ang2",
		"䭸", "	bao3",
		"䭷", "	mao2",
		"䭶", "	qi2",
		"䭵", "	fan2",
		"䭴", "	huan2",
		"䭳", "	wei4",
		"䭲", "	yi3",
		"䭱", "	bie2",
		"䭰", "	beng4",
		"䭮", "	fu2",
		"䭻", "	fu4",
		"䭭", "	shou3",
		"䭬", "	qi3",
		"䭫", "	qi3",
		"䭪", "	liang2",
		"䭩", "	mo2",
		"䭨", "	shui4",
		"䭧", "	mi3",
		"䭦", "	bo1",
		"䭥", "	xue4",
		"䭤", "	qian3",
		"䭺", "	ang3",
		"䭼", "	qi2",
		"䮙", "	yu4",
		"䮍", "	niao3",
		"䮘", "	er2",
		"䮗", "	an4",
		"䮖", "	chang1",
		"䮕", "	zhuo2",
		"䮔", "	zui1",
		"䮓", "	zhuo1",
		"䮒", "	pu1",
		"䮑", "	lei4",
		"䮏", "	wu2",
		"䮎", "	xi4",
		"䮋", "	li4",
		"䭽", "	qun2",
		"䮊", "	yi2",
		"䮉", "	lu2",
		"䮈", "	chi2",
		"䮇", "	yu4",
		"䮄", "	xuan2",
		"䮂", "	ba2",
		"䮁", "	pian2",
		"䮀", "	bo2",
		"䭿", "	yi4",
		"䭾", "	tuo2",
		"䯑", "	kuang1",
		"䯓", "	kui1",
		"䭢", "	ning2",
		"䰙", "	yi3",
		"䰣", "	wang3",
		"䰢", "	xing4",
		"䰡", "	chi4",
		"䰠", "	shen2",
		"䰟", "	hun2",
		"䰞", "	zhu3",
		"䰝", "	zeng4",
		"䰜", "	li4",
		"䰛", "	li4",
		"䰚", "	wen2",
		"䰘", "	liu2",
		"䰥", "	huo4",
		"䰖", "	zuan3",
		"䰕", "	lu2",
		"䰔", "	pan2",
		"䰓", "	mian2",
		"䰒", "	meng2",
		"䰐", "	lan2",
		"䰏", "	ji4",
		"䰎", "	kui4",
		"䰍", "	ci4",
		"䰌", "	zong3",
		"䰤", "	dong1",
		"䰦", "	pi3",
		"䰊", "	bo2",
		"䰵", "	zi1",
		"䱀", "	yang1",
		"䰿", "	tuo2",
		"䰾", "	ba1",
		"䰽", "	bei4",
		"䰼", "	qin2",
		"䰻", "	yu2",
		"䰺", "	jie4",
		"䰹", "	ze2",
		"䰸", "	gong1",
		"䰷", "	bang4",
		"䰴", "	qi4",
		"䰧", "	hu1",
		"䰲", "	ya4",
		"䰱", "	ling2",
		"䰰", "	ru2",
		"䰯", "	yi4",
		"䰭", "	nou4",
		"䰬", "	ju2",
		"䰫", "	chao1",
		"䰪", "	mei4",
		"䰩", "	che3",
		"䰨", "	mei4",
		"䰋", "	man2",
		"䰉", "	pan2",
		"䯔", "	ze2",
		"䯠", "	ao3",
		"䯫", "	hao4",
		"䯪", "	kao3",
		"䯨", "	qiao1",
		"䯧", "	qing3",
		"䯦", "	ma4",
		"䯥", "	an4",
		"䯤", "	kuai4",
		"䯣", "	kui4",
		"䯢", "	mo2",
		"䯡", "	jian4",
		"䯟", "	dui4",
		"䯭", "	xian1",
		"䯞", "	kua1",
		"䯝", "	sui3",
		"䯜", "	ti4",
		"䯛", "	wan4",
		"䯚", "	yao3",
		"䯙", "	po4",
		"䯘", "	huan4",
		"䯗", "	bi4",
		"䯖", "	lang2",
		"䯕", "	ting1",
		"䯬", "	duo3",
		"䯮", "	nai2",
		"䰈", "	cuo2",
		"䯼", "	di2",
		"䰇", "	qi2",
		"䰆", "	rou2",
		"䰄", "	sai1",
		"䰃", "	peng2",
		"䰂", "	cai4",
		"䰁", "	fei4",
		"䰀", "	wo3",
		"䯿", "	zu2",
		"䯾", "	tiao2",
		"䯽", "	pou2",
		"䯺", "	kuo4",
		"䯯", "	suo1",
		"䯹", "	xian1",
		"䯸", "	ci4",
		"䯷", "	song1",
		"䯶", "	man2",
		"䯵", "	nie4",
		"䯴", "	chang2",
		"䯳", "	song1",
		"䯲", "	pa1",
		"䯱", "	pi1",
		"䯰", "	jie4",
		"䭣", "	ci2",
		"䭡", "	en4",
		"䱂", "	you3",
		"䫈", "	chen3",
		"䫒", "	men2",
		"䫑", "	yi1",
		"䫐", "	lin2",
		"䫏", "	qi1",
		"䫎", "	zhuo1",
		"䫍", "	fu3",
		"䫌", "	pi3",
		"䫋", "	wei1",
		"䫊", "	pei2",
		"䫉", "	mao4",
		"䫇", "	ran2",
		"䫔", "	qi4",
		"䫆", "	cheng2",
		"䫅", "	san4",
		"䫄", "	chua4",
		"䫃", "	chun2",
		"䫂", "	duo3",
		"䫁", "	bi4",
		"䫀", "	gen3",
		"䪿", "	sheng3",
		"䪾", "	zhen3",
		"䪽", "	hao4",
		"䫓", "	wu2",
		"䫕", "	die2",
		"䪻", "	bian4",
		"䫢", "	si1",
		"䫭", "	hui4",
		"䫬", "	zhen3",
		"䫫", "	lou2",
		"䫪", "	shuang3",
		"䫩", "	san3",
		"䫨", "	ao4",
		"䫦", "	ge2",
		"䫥", "	kui3",
		"䫤", "	ming2",
		"䫣", "	xi2",
		"䫡", "	yan2",
		"䫖", "	chen3",
		"䫠", "	pi1",
		"䫟", "	hun4",
		"䫞", "	qiao1",
		"䫝", "	fu3",
		"䫜", "	ao1",
		"䫛", "	hou2",
		"䫚", "	gua1",
		"䫙", "	sang3",
		"䫘", "	he2",
		"䫗", "	xia2",
		"䪼", "	zhuo1",
		"䪺", "	ge2",
		"䫰", "	lin4",
		"䪎", "	sui1",
		"䪘", "	wei3",
		"䪗", "	xia2",
		"䪖", "	po4",
		"䪕", "	ju2",
		"䪔", "	bu3",
		"䪓", "	die1",
		"䪒", "	zhu4",
		"䪑", "	tuo2",
		"䪐", "	bi4",
		"䪏", "	na4",
		"䪍", "	lan2",
		"䪚", "	da1",
		"䪌", "	zhan4",
		"䪋", "	wei4",
		"䪊", "	long2",
		"䪉", "	lie4",
		"䪈", "	qian4",
		"䪇", "	bo2",
		"䪆", "	ti3",
		"䪅", "	du2",
		"䪄", "	huang2",
		"䪃", "	dun1",
		"䪙", "	po4",
		"䪛", "	fan1",
		"䪹", "	bai1",
		"䪮", "	chou3",
		"䪸", "	min2",
		"䪷", "	hou4",
		"䪶", "	ju1",
		"䪵", "	ya3",
		"䪴", "	zhen3",
		"䪳", "	yun3",
		"䪲", "	kun1",
		"䪱", "	gai3",
		"䪰", "	yi1",
		"䪯", "	ying1",
		"䪭", "	ruan3",
		"䪜", "	chan1",
		"䪬", "	bo2",
		"䪫", "	jing1",
		"䪩", "	yin2",
		"䪨", "	bao2",
		"䪧", "	chi2",
		"䪦", "	hong2",
		"䪥", "	xie4",
		"䪤", "	fan2",
		"䪞", "	za2",
		"䪝", "	hu4",
		"䫮", "	chan2",
		"䫱", "	na2",
		"䭠", "	jian3",
		"䬹", "	zhi4",
		"䭃", "	ren3",
		"䭂", "	yi4",
		"䭁", "	zhi4",
		"䭀", "	xun4",
		"䬿", "	wei3",
		"䬾", "	ti2",
		"䬽", "	shui4",
		"䬼", "	yuan4",
		"䬻", "	jian4",
		"䬺", "	yang4",
		"䬷", "	she3",
		"䭅", "	hu2",
		"䬶", "	en4",
		"䬵", "	gai1",
		"䬴", "	mo4",
		"䬳", "	ban3",
		"䬲", "	gou1",
		"䬱", "	ben4",
		"䬰", "	shao4",
		"䬯", "	nian2",
		"䬮", "	yi2",
		"䬬", "	ying3",
		"䭄", "	shi4",
		"䭆", "	ne4",
		"䬪", "	bo2",
		"䭔", "	dui1",
		"䭟", "	ye4",
		"䭞", "	yi4",
		"䭝", "	kuai4",
		"䭛", "	dan4",
		"䭚", "	chuang2",
		"䭙", "	jin3",
		"䭘", "	ying3",
		"䭗", "	ying3",
		"䭖", "	zhu4",
		"䭕", "	zan3",
		"䭓", "	en4",
		"䭇", "	ye1",
		"䭒", "	xi1",
		"䭑", "	lian2",
		"䭐", "	yang4",
		"䭎", "	ye4",
		"䭍", "	hu2",
		"䭌", "	hu2",
		"䭋", "	bao3",
		"䭊", "	ying3",
		"䭉", "	sui3",
		"䭈", "	jian4",
		"䬫", "	ti2",
		"䬨", "	jiu4",
		"䫲", "	han4",
		"䫾", "	bi1",
		"䬈", "	dui4",
		"䬇", "	yuan4",
		"䬆", "	li4",
		"䬅", "	li4",
		"䬄", "	xu4",
		"䬃", "	sa4",
		"䬂", "	xue4",
		"䬁", "	yi2",
		"䬀", "	you3",
		"䫿", "	chao1",
		"䫽", "	pao1",
		"䬊", "	sha4",
		"䫼", "	xue4",
		"䫻", "	yu4",
		"䫺", "	hong2",
		"䫹", "	hong2",
		"䫸", "	chao1",
		"䫷", "	e4",
		"䫶", "	fan2",
		"䫵", "	mian2",
		"䫴", "	jin4",
		"䫳", "	du2",
		"䬉", "	huo4",
		"䬋", "	leng2",
		"䬧", "	yuan2",
		"䬘", "	xiao1",
		"䬦", "	dou4",
		"䬥", "	yi4",
		"䬤", "	zan4",
		"䬣", "	xi4",
		"䬡", "	zhu4",
		"䬟", "	liu2",
		"䬞", "	tao2",
		"䬝", "	heng2",
		"䬛", "	bi4",
		"䬙", "	yao2",
		"䬗", "	yang2",
		"䬌", "	pou1",
		"䬖", "	heng2",
		"䬕", "	xiang1",
		"䬔", "	yu2",
		"䬓", "	an4",
		"䬒", "	sou1",
		"䬑", "	wei4",
		"䬐", "	rui2",
		"䬏", "	bu4",
		"䬎", "	guo2",
		"䬍", "	hu1",
		"䱁", "	qiao2",
		"䱃", "	zhi4",
		"久", "	jiu3",
		"䵪", "	gun4",
		"䵴", "	ying4",
		"䵳", "	wei4",
		"䵲", "	qiao1",
		"䵱", "	xi4",
		"䵰", "	shang1",
		"䵯", "	tuan3",
		"䵮", "	yang4",
		"䵭", "	zhe4",
		"䵬", "	ta4",
		"䵫", "	xun1",
		"䵩", "	li2",
		"䵶", "	qu2",
		"䵨", "	mang2",
		"䵧", "	zai4",
		"䵦", "	xie4",
		"䵥", "	yu4",
		"䵤", "	jian3",
		"䵣", "	da2",
		"䵢", "	mei4",
		"䵡", "	jian3",
		"䵠", "	di2",
		"䵟", "	gan3",
		"䵵", "	chua1",
		"䵷", "	wa1",
		"䵝", "	yi4",
		"䶅", "	he2",
		"䶏", "	ti4",
		"䶎", "	he1",
		"䶍", "	di4",
		"䶌", "	pao4",
		"䶋", "	xi1",
		"䶊", "	nv4",
		"䶉", "	liu2",
		"䶈", "	bo2",
		"䶇", "	zhou4",
		"䶆", "	zhui1",
		"䶄", "	ping2",
		"䵹", "	zhi1",
		"䶃", "	han2",
		"䶂", "	zhuo2",
		"䶁", "	ta4",
		"䶀", "	ta4",
		"䵿", "	tie4",
		"䵾", "	fu2",
		"䵽", "	ca4",
		"䵼", "	shang1",
		"䵻", "	gu3",
		"䵺", "	ting3",
		"䵞", "	jing4",
		"䵜", "	nong3",
		"䶑", "	ti4",
		"䴵", "	bing3",
		"䴿", "	meng2",
		"䴾", "	cuo2",
		"䴽", "	pi2",
		"䴼", "	chan4",
		"䴻", "	li2",
		"䴺", "	bu4",
		"䴹", "	guo3",
		"䴸", "	fu1",
		"䴷", "	hun2",
		"䴶", "	peng2",
		"䴴", "	tie4",
		"䵁", "	qiang4",
		"䴳", "	hua2",
		"䴲", "	mo4",
		"䴱", "	tuo1",
		"䴯", "	hu1",
		"䴮", "	shan4",
		"䴭", "	cai2",
		"䴬", "	yi4",
		"䴫", "	ling2",
		"䴪", "	lu4",
		"䴩", "	piao2",
		"䵀", "	suo3",
		"䵂", "	zhi2",
		"䵛", "	qian4",
		"䵐", "	chan3",
		"䵚", "	tao3",
		"䵙", "	zha1",
		"䵘", "	shai4",
		"䵗", "	bo2",
		"䵖", "	qian4",
		"䵕", "	ju4",
		"䵔", "	dong3",
		"䵓", "	li2",
		"䵒", "	ni4",
		"䵑", "	ni4",
		"䵏", "	lao3",
		"䵃", "	kuang4",
		"䵎", "	tuan1",
		"䵌", "	xian1",
		"䵋", "	wei3",
		"䵊", "	tuan1",
		"䵉", "	tou2",
		"䵈", "	ku4",
		"䵇", "	xian4",
		"䵆", "	meng2",
		"䵅", "	ao2",
		"䵄", "	bi2",
		"䶐", "	wai4",
		"䶒", "	qi2",
		"䴦", "	yin2",
		"丠", "	qiu1",
		"个", "	ge4",
		"丩", "	jiu1",
		"丨", "	gun3",
		"丧", "	sang4",
		"並", "	bing4",
		"严", "	yan2",
		"两", "	liang3",
		"丣", "	you3",
		"丢", "	diu1",
		"両", "	liang3",
		"丟", "	diu1",
		"丬", "	qiang2",
		"丞", "	cheng2",
		"丝", "	si1",
		"东", "	dong1",
		"丛", "	cong2",
		"业", "	ye4",
		"丙", "	bing3",
		"丘", "	qiu1",
		"丗", "	shi4",
		"世", "	shi4",
		"丕", "	pi1",
		"丫", "	ya1",
		"中", "	zhong1",
		"专", "	zhuan1",
		"为", "	wei4",
		"乄", "	wu",
		"乃", "	nai3",
		"乂", "	yi4",
		"乁", "	yi2",
		"乀", "	fu2",
		"丿", "	pie3",
		"举", "	ju3",
		"丽", "	li4",
		"丼", "	jing3",
		"主", "	zhu3",
		"丹", "	dan1",
		"丮", "	ji3",
		"丸", "	wan2",
		"丷", "	ha",
		"丶", "	zhu3",
		"丵", "	zhuo2",
		"临", "	lin2",
		"丳", "	chan3",
		"串", "	chuan4",
		"丱", "	guan4",
		"丰", "	feng1",
		"丯", "	jie4",
		"且", "	qie3",
		"丒", "	chou3",
		"䶓", "	ji4",
		"䶟", "	xian4",
		"䶩", "	ji4",
		"䶨", "	zhan1",
		"䶧", "	yao3",
		"䶦", "	ze2",
		"䶥", "	zha1",
		"䶤", "	hua2",
		"䶣", "	ai2",
		"䶢", "	jian1",
		"䶡", "	shi2",
		"䶠", "	jian3",
		"䶞", "	qi2",
		"䶫", "	yan4",
		"䶝", "	qia4",
		"䶜", "	gu3",
		"䶛", "	la4",
		"䶚", "	qu3",
		"䶙", "	ju4",
		"䶘", "	li4",
		"䶗", "	ke4",
		"䶖", "	jin4",
		"䶕", "	ba4",
		"䶔", "	chi2",
		"䶪", "	cha4",
		"䶬", "	jian1",
		"丑", "	chou3",
		"丆", "	han3",
		"丐", "	gai4",
		"丏", "	mian3",
		"与", "	yu3",
		"不", "	bu4",
		"丌", "	ji1",
		"下", "	xia4",
		"上", "	shang4",
		"三", "	san1",
		"丈", "	zhang4",
		"万", "	wan4",
		"丅", "	xia4",
		"䶮", "	yan3",
		"丄", "	shang4",
		"七", "	qi1",
		"丂", "	kao3",
		"丁", "	ding1",
		"一", "	yi1",
		"䶵", "	chi2",
		"䶳", "	yue4",
		"䶲", "	nan2",
		"䶱", "	tong2",
		"䶰", "	jiao1",
		"䴧", "	wei1",
		"䴥", "	jia1",
		"䱄", "	jie4",
		"䲋", "	cen2",
		"䲕", "	pu1",
		"䲔", "	qing2",
		"䲓", "	yan3",
		"䲒", "	xie4",
		"䲑", "	yi2",
		"䲐", "	lu3",
		"䲏", "	lao2",
		"䲎", "	nei3",
		"䲍", "	teng2",
		"䲌", "	kuan3",
		"䲊", "	duo4",
		"䲗", "	xian2",
		"䲉", "	si1",
		"䲆", "	su1",
		"䲅", "	gui1",
		"䲄", "	min2",
		"䲃", "	zao3",
		"䲂", "	xuan2",
		"䲁", "	wei4",
		"䲀", "	zhi4",
		"䱿", "	chan4",
		"䱾", "	lou2",
		"䲖", "	chou2",
		"䲘", "	guan3",
		"䱻", "	hua2",
		"䲨", "	hong2",
		"䲵", "	que4",
		"䲴", "	zhen4",
		"䲳", "	hang2",
		"䲲", "	gong1",
		"䲱", "	fang3",
		"䲰", "	yun4",
		"䲯", "	ji2",
		"䲮", "	yuan2",
		"䲬", "	qi2",
		"䲪", "	xi4",
		"䲧", "	du4",
		"䲙", "	jie2",
		"䲦", "	dai4",
		"䲣", "	yu2",
		"䲢", "	teng2",
		"䲡", "	qiu1",
		"䲠", "	chun1",
		"䲟", "	yin4",
		"䲞", "	li4",
		"䲜", "	ye4",
		"䲛", "	meng2",
		"䲚", "	lai4",
		"䱼", "	zhan3",
		"䱺", "	hai2",
		"䲹", "	pi2",
		"䱐", "	fu1",
		"䱚", "	lu4",
		"䱙", "	shu1",
		"䱘", "	li2",
		"䱗", "	can1",
		"䱖", "	liu2",
		"䱕", "	mou2",
		"䱔", "	tiao2",
		"䱓", "	ting2",
		"䱒", "	ye4",
		"䱑", "	xue2",
		"䱏", "	tou3",
		"䱜", "	cuo4",
		"䱎", "	geng4",
		"䱍", "	geng4",
		"䱌", "	yi2",
		"䱋", "	gong3",
		"䱊", "	mi3",
		"䱉", "	shan4",
		"䱈", "	qi2",
		"䱇", "	shan4",
		"䱆", "	sheng2",
		"䱅", "	mo4",
		"䱛", "	huo4",
		"䱝", "	pai2",
		"䱹", "	zha3",
		"䱮", "	e2",
		"䱸", "	sou1",
		"䱷", "	yu2",
		"䱶", "	lang2",
		"䱵", "	weng1",
		"䱴", "	geng4",
		"䱳", "	zhan1",
		"䱲", "	yuan2",
		"䱱", "	ti2",
		"䱰", "	zhong4",
		"䱯", "	mu2",
		"䱭", "	geng4",
		"䱞", "	liu2",
		"䱬", "	xu1",
		"䱫", "	la4",
		"䱨", "	la4",
		"䱥", "	zhi4",
		"䱤", "	xian4",
		"䱣", "	zu2",
		"䱢", "	zheng1",
		"䱡", "	ju2",
		"䱠", "	zhan4",
		"䱟", "	ju4",
		"䲸", "	jie4",
		"䲺", "	gan4",
		"䴤", "	sheng1",
		"䳿", "	ran2",
		"䴉", "	huan2",
		"䴈", "	ao3",
		"䴇", "	ling2",
		"䴆", "	pu2",
		"䴅", "	fen2",
		"䴄", "	shun4",
		"䴃", "	nao2",
		"䴂", "	xiang4",
		"䴁", "	yu4",
		"䴀", "	tong2",
		"䳾", "	deng1",
		"䴋", "	huan2",
		"䳽", "	he4",
		"䳻", "	can2",
		"䳺", "	yan4",
		"䳹", "	kou4",
		"䳸", "	ma2",
		"䳷", "	cong2",
		"䳶", "	xi1",
		"䳵", "	chi4",
		"䳴", "	ta4",
		"䳳", "	xu4",
		"䴊", "	yi2",
		"䴌", "	meng2",
		"䳱", "	wu4",
		"䴙", "	pi4",
		"䴣", "	hu1",
		"䴢", "	mi2",
		"䴡", "	li4",
		"䴠", "	yao3",
		"䴟", "	huan2",
		"䴞", "	di2",
		"䴝", "	chuai4",
		"䴜", "	wai1",
		"䴛", "	xiao1",
		"䴚", "	gang3",
		"䴘", "	ti1",
		"䴍", "	ying1",
		"䴗", "	ju2",
		"䴖", "	jing1",
		"䴕", "	lie4",
		"䴔", "	jiao1",
		"䴓", "	shi1",
		"䴒", "	ling2",
		"䴑", "	die2",
		"䴐", "	bao3",
		"䴏", "	yan4",
		"䴎", "	lei3",
		"䳲", "	zhen4",
		"䳰", "	bao3",
		"䲻", "	xuan2",
		"䳇", "	wu3",
		"䳒", "	yuan2",
		"䳑", "	you3",
		"䳐", "	ci4",
		"䳏", "	gui4",
		"䳎", "	jiu4",
		"䳍", "	gong1",
		"䳋", "	tong2",
		"䳊", "	ba2",
		"䳉", "	dan4",
		"䳈", "	bao3",
		"䳆", "	bai2",
		"䳔", "	ju2",
		"䳅", "	zhi3",
		"䳄", "	ci2",
		"䳃", "	wan3",
		"䳂", "	diao1",
		"䳁", "	bo2",
		"䳀", "	die2",
		"䲿", "	ci2",
		"䲾", "	qiao3",
		"䲽", "	shi2",
		"䲼", "	sheng1",
		"䳓", "	lao3",
		"䳕", "	fu2",
		"䳯", "	chong2",
		"䳣", "	yuan2",
		"䳮", "	mo4",
		"䳭", "	ji2",
		"䳬", "	e4",
		"䳫", "	kui2",
		"䳪", "	juan4",
		"䳩", "	yao1",
		"䳨", "	huang2",
		"䳧", "	hou2",
		"䳦", "	xuan1",
		"䳤", "	bie1",
		"䳢", "	qi2",
		"䳖", "	nie4",
		"䳡", "	yan4",
		"䳠", "	shui4",
		"䳟", "	ming2",
		"䳞", "	beng3",
		"䳝", "	pou3",
		"䳜", "	tu2",
		"䳛", "	yan4",
		"䳚", "	kan4",
		"䳙", "	xing3",
		"䳘", "	e2",
		"䳗", "	e2",
		"䍖", "	fu2",
		"䍔", "	gong1",
		"冉", "	ran3",
		"㥍", "	ji4",
		"㥛", "	ji2",
		"㥚", "	yu2",
		"㥖", "	cong1",
		"㥕", "	lian2",
		"㥔", "	yu4",
		"㥓", "	qi1",
		"㥒", "	cai3",
		"㥐", "	yuan4",
		"㥏", "	tian3",
		"㥎", "	lai2",
		"㥌", "	ju2",
		"㥝", "	mi3",
		"㥋", "	yi1",
		"㥊", "	peng2",
		"㥉", "	che4",
		"㥈", "	die2",
		"㥇", "	can2",
		"㥆", "	tui4",
		"㥅", "	shou4",
		"㥄", "	ling2",
		"㥃", "	men4",
		"㥂", "	te4",
		"㥜", "	wei4",
		"㥞", "	sui4",
		"㥀", "	zhi2",
		"㥭", "	tai4",
		"㥷", "	ye4",
		"㥶", "	se4",
		"㥵", "	hun4",
		"㥴", "	yi2",
		"㥳", "	yuan2",
		"㥲", "	chen1",
		"㥱", "	fei3",
		"㥰", "	sao1",
		"㥯", "	yin3",
		"㥮", "	zhou4",
		"㥬", "	pang2",
		"㥟", "	xie2",
		"㥪", "	lou2",
		"㥩", "	duo3",
		"㥨", "	shui4",
		"㥧", "	shun4",
		"㥦", "	qie4",
		"㥥", "	yu2",
		"㥣", "	hui4",
		"㥢", "	qiu2",
		"㥡", "	chi4",
		"㥠", "	xu1",
		"㥁", "	de2",
		"㤿", "	yan1",
		"㥹", "	fen3",
		"㤓", "	ben4",
		"㤟", "	kong3",
		"㤞", "	cha4",
		"㤝", "	chong1",
		"㤜", "	jue2",
		"㤛", "	nin2",
		"㤚", "	hang2",
		"㤘", "	zhou4",
		"㤖", "	zhu4",
		"㤕", "	chu4",
		"㤔", "	fu4",
		"㤒", "	gao1",
		"㤡", "	li4",
		"㤑", "	you4",
		"㤐", "	chan1",
		"㤏", "	tong2",
		"㤎", "	ge1",
		"㤍", "	qiao1",
		"㤌", "	gan1",
		"㤋", "	fen1",
		"㤊", "	xiao4",
		"㤉", "	qia1",
		"㤈", "	qin4",
		"㤠", "	lie4",
		"㤢", "	yu4",
		"㤾", "	san4",
		"㤱", "	fu4",
		"㤽", "	chou2",
		"㤺", "	huang3",
		"㤹", "	qiu2",
		"㤸", "	xi4",
		"㤷", "	han1",
		"㤶", "	mang2",
		"㤵", "	ci2",
		"㤴", "	che4",
		"㤳", "	bei3",
		"㤲", "	qie4",
		"㤰", "	zuo4",
		"㤤", "	yu2",
		"㤯", "	jiong3",
		"㤮", "	guang4",
		"㤬", "	hui4",
		"㤫", "	de2",
		"㤪", "	yuan4",
		"㤩", "	ke4",
		"㤨", "	gong3",
		"㤧", "	hou2",
		"㤦", "	li4",
		"㤥", "	hai4",
		"㥸", "	min3",
		"㥺", "	he2",
		"㤆", "	fan4",
		"㧁", "	qu4",
		"㧋", "	xuan3",
		"㧊", "	po1",
		"㧉", "	gai4",
		"㧈", "	yin3",
		"㧇", "	mao3",
		"㧆", "	jin1",
		"㧅", "	mu4",
		"㧄", "	qian3",
		"㧃", "	shou1",
		"㧂", "	tian2",
		"㧀", "	ji2",
		"㧍", "	fang3",
		"㦿", "	qian3",
		"㦾", "	yi2",
		"㦽", "	yu4",
		"㦼", "	shuang4",
		"㦻", "	xi2",
		"㦺", "	ru4",
		"㦹", "	yang2",
		"㦸", "	ji3",
		"㦷", "	yong3",
		"㦶", "	die2",
		"㧌", "	mao4",
		"㧎", "	ya2",
		"㦴", "	ge2",
		"㧜", "	lie4",
		"㧪", "	gui3",
		"㧩", "	pei4",
		"㧨", "	qiu2",
		"㧦", "	xuan4",
		"㧥", "	xian3",
		"㧤", "	chong4",
		"㧣", "	zhu1",
		"㧢", "	yin1",
		"㧡", "	hai4",
		"㧟", "	kuai3",
		"㧚", "	wa3",
		"㧏", "	gang1",
		"㧙", "	bi4",
		"㧘", "	zi4",
		"㧗", "	zi3",
		"㧖", "	e4",
		"㧕", "	liu3",
		"㧔", "	guai4",
		"㧓", "	gua1",
		"㧒", "	yu4",
		"㧑", "	hui1",
		"㧐", "	song3",
		"㦵", "	zhu1",
		"㦱", "	wo3",
		"㥼", "	yin4",
		"㦉", "	yi4",
		"㦓", "	xian4",
		"㦒", "	li2",
		"㦑", "	xian4",
		"㦐", "	ni4",
		"㦏", "	sun3",
		"㦎", "	huo4",
		"㦍", "	e4",
		"㦌", "	hu1",
		"㦋", "	zha1",
		"㦊", "	hua2",
		"㦇", "	lu4",
		"㦕", "	long2",
		"㦆", "	hu1",
		"㦅", "	die1",
		"㦄", "	ma2",
		"㦃", "	chan3",
		"㦂", "	chang2",
		"㦁", "	lian2",
		"㦀", "	feng2",
		"㥿", "	ao4",
		"㥾", "	ni4",
		"㥽", "	ce4",
		"㦔", "	yan4",
		"㦖", "	men4",
		"㦰", "	jian1",
		"㦥", "	xuan1",
		"㦯", "	huo4",
		"㦮", "	qian2",
		"㦭", "	ling2",
		"㦬", "	luo3",
		"㦫", "	za1",
		"㦪", "	xie4",
		"㦩", "	yin3",
		"㦨", "	lan2",
		"㦧", "	can3",
		"㦦", "	xi4",
		"㦤", "	yi4",
		"㦗", "	jin1",
		"㦣", "	wei4",
		"㦢", "	jie2",
		"㦡", "	le4",
		"㦟", "	mai2",
		"㦞", "	chou2",
		"㦝", "	miao3",
		"㦜", "	huo4",
		"㦛", "	yu3",
		"㦚", "	bian3",
		"㦘", "	ji1",
		"㤇", "	ao3",
		"㤅", "	ai4",
		"㧬", "	gong3",
		"㡕", "	ying1",
		"㡟", "	zao1",
		"㡞", "	lou2",
		"㡝", "	feng4",
		"㡜", "	xie4",
		"㡛", "	mang2",
		"㡚", "	gou1",
		"㡙", "	bi1",
		"㡘", "	lian2",
		"㡗", "	ti2",
		"㡖", "	chuang2",
		"㡔", "	wu4",
		"㡡", "	chu2",
		"㡓", "	kun1",
		"㡒", "	zhun1",
		"㡑", "	qiao1",
		"㡏", "	shu4",
		"㡌", "	mao4",
		"㡋", "	ye2",
		"㡊", "	qia4",
		"㡉", "	xian2",
		"㡈", "	wen4",
		"㡇", "	zhe2",
		"㡠", "	zheng4",
		"㡢", "	man4",
		"㡄", "	xun2",
		"㡱", "	jiu3",
		"㡻", "	liao4",
		"㡺", "	dan4",
		"㡹", "	ju1",
		"㡸", "	zha4",
		"㡷", "	ben3",
		"㡶", "	zhi3",
		"㡵", "	ling2",
		"㡴", "	la1",
		"㡳", "	zhi3",
		"㡲", "	huan2",
		"㡰", "	yu3",
		"㡣", "	long2",
		"㡯", "	zhai2",
		"㡮", "	ji2",
		"㡭", "	ji4",
		"㡫", "	yi4",
		"㡪", "	nie2",
		"㡩", "	luan2",
		"㡨", "	jian1",
		"㡧", "	zheng4",
		"㡦", "	pin1",
		"㡥", "	yin4",
		"㡅", "	nuo3",
		"㡃", "	huang1",
		"㡽", "	zhao4",
		"㠕", "	wei3",
		"㠠", "	lu2",
		"㠟", "	li2",
		"㠝", "	cuan2",
		"㠜", "	ni4",
		"㠛", "	wo4",
		"㠚", "	dui4",
		"㠙", "	hao2",
		"㠘", "	yu3",
		"㠗", "	ao4",
		"㠖", "	yi3",
		"㠔", "	bai4",
		"㠢", "	huai2",
		"㠓", "	meng2",
		"㠒", "	biao3",
		"㠑", "	zui4",
		"㠐", "	jiao4",
		"㠏", "	hua2",
		"㠎", "	ji2",
		"㠍", "	ji2",
		"㠌", "	qi1",
		"㠋", "	e4",
		"㠊", "	qu1",
		"㠡", "	niao3",
		"㠣", "	li4",
		"㡂", "	li4",
		"㠶", "	fan2",
		"㡁", "	kua3",
		"㡀", "	bi4",
		"㠿", "	zi1",
		"㠾", "	yuan1",
		"㠽", "	tong2",
		"㠼", "	si1",
		"㠺", "	sha1",
		"㠹", "	jie4",
		"㠸", "	ku4",
		"㠷", "	ge2",
		"㠵", "	huang1",
		"㠥", "	lv4",
		"㠴", "	ren4",
		"㠲", "	bi3",
		"㠱", "	ji4",
		"㠯", "	yi3",
		"㠮", "	peng1",
		"㠭", "	zhan3",
		"㠪", "	ju4",
		"㠨", "	yu4",
		"㠧", "	mi3",
		"㠦", "	feng1",
		"㡼", "	yi4",
		"㡾", "	xian4",
		"㤄", "	pei4",
		"㣑", "	rong2",
		"㣟", "	xi4",
		"㣞", "	duo2",
		"㣝", "	song1",
		"㣜", "	xing2",
		"㣛", "	ta4",
		"㣚", "	tong3",
		"㣙", "	di2",
		"㣔", "	ding1",
		"㣓", "	can4",
		"㣒", "	ceng4",
		"㣐", "	bian4",
		"㣢", "	ti2",
		"㣏", "	jing4",
		"㣎", "	mu4",
		"㣍", "	tai2",
		"㣌", "	shan4",
		"㣈", "	si4",
		"㣇", "	yi4",
		"㣆", "	mi2",
		"㣅", "	zan4",
		"㣄", "	qu2",
		"㣃", "	yu3",
		"㣠", "	tao1",
		"㣣", "	shan4",
		"㣁", "	bei4",
		"㣵", "	ta4",
		"㤃", "	fang2",
		"㤂", "	ji2",
		"㤁", "	mian3",
		"㣿", "	zhuo2",
		"㣾", "	cha4",
		"㣽", "	shu4",
		"㣼", "	ren3",
		"㣻", "	yi4",
		"㣷", "	ning4",
		"㣶", "	zhan1",
		"㣲", "	wei2",
		"㣤", "	jian4",
		"㣱", "	ze2",
		"㣰", "	xie4",
		"㣯", "	xie4",
		"㣭", "	zong1",
		"㣬", "	qi4",
		"㣫", "	zhong3",
		"㣪", "	huan3",
		"㣧", "	yin4",
		"㣦", "	wei1",
		"㣥", "	zhi4",
		"㣂", "	e4",
		"㣀", "	zhen4",
		"㡿", "	chi4",
		"㢍", "	ying3",
		"㢙", "	qin2",
		"㢘", "	lian2",
		"㢗", "	qiao4",
		"㢖", "	pan1",
		"㢔", "	zong3",
		"㢓", "	yao3",
		"㢒", "	cha2",
		"㢑", "	tui2",
		"㢏", "	tou2",
		"㢎", "	zhe2",
		"㢋", "	chi3",
		"㢛", "	yan4",
		"㢊", "	ai3",
		"㢉", "	cha2",
		"㢈", "	tui2",
		"㢆", "	chan2",
		"㢅", "	long4",
		"㢄", "	dou4",
		"㢃", "	lang2",
		"㢂", "	yan3",
		"㢁", "	chi3",
		"㢀", "	ci4",
		"㢚", "	lu3",
		"㢜", "	kang4",
		"㢾", "	juan4",
		"㢯", "	diao1",
		"㢽", "	er3",
		"㢼", "	bie4",
		"㢻", "	rui4",
		"㢺", "	xian2",
		"㢸", "	bi4",
		"㢶", "	bi4",
		"㢵", "	xie2",
		"㢳", "	lu2",
		"㢲", "	xun4",
		"㢰", "	bi4",
		"㢮", "	chi2",
		"㢝", "	su1",
		"㢬", "	hong2",
		"㢩", "	di4",
		"㢨", "	han4",
		"㢧", "	juan4",
		"㢥", "	dong4",
		"㢣", "	jing4",
		"㢡", "	jiang3",
		"㢠", "	jiong3",
		"㢟", "	chan1",
		"㢞", "	yi4",
		"㧫", "	er2",
		"㧭", "	qiong2",
		"㠈", "	run4",
		"㬭", "	jiao4",
		"㬸", "	tiao1",
		"㬶", "	hao4",
		"㬵", "	xiao2",
		"㬴", "	hong3",
		"㬳", "	wu3",
		"㬲", "	tian1",
		"㬱", "	ti4",
		"㬰", "	yu2",
		"㬯", "	lie4",
		"㬮", "	nan4",
		"㬬", "	ju4",
		"㬻", "	huang1",
		"㬫", "	yan4",
		"㬪", "	die2",
		"㬩", "	hui4",
		"㬧", "	bo2",
		"㬦", "	yue4",
		"㬥", "	pu4",
		"㬤", "	qi1",
		"㬣", "	dui4",
		"㬡", "	ling2",
		"㬠", "	shai4",
		"㬹", "	zheng1",
		"㬼", "	fu4",
		"㬞", "	he4",
		"㭒", "	si4",
		"㭞", "	lie4",
		"㭝", "	qiu2",
		"㭜", "	rong2",
		"㭛", "	pai4",
		"㭚", "	lv3",
		"㭙", "	zhe2",
		"㭘", "	ge2",
		"㭕", "	qu1",
		"㭔", "	lu2",
		"㭓", "	bian4",
		"㭑", "	mei4",
		"㬿", "	tun1",
		"㭏", "	wei3",
		"㭎", "	gang1",
		"㭌", "	mou2",
		"㭋", "	bang4",
		"㭉", "	hua2",
		"㭈", "	jue2",
		"㭇", "	yuan4",
		"㭄", "	xin4",
		"㭂", "	jiao3",
		"㭁", "	reng2",
		"㬟", "	fen1",
		"㬝", "	ceng2",
		"㭠", "	xian3",
		"㫯", "	mao4",
		"㫻", "	kun4",
		"㫹", "	shu4",
		"㫸", "	jie1",
		"㫷", "	ji1",
		"㫶", "	zhou3",
		"㫵", "	fei1",
		"㫳", "	chen2",
		"㫲", "	bei4",
		"㫱", "	nan3",
		"㫰", "	lang4",
		"㫫", "	xian3",
		"㫽", "	lu4",
		"㫨", "	an1",
		"㫧", "	bao4",
		"㫦", "	tao1",
		"㫥", "	ming3",
		"㫤", "	chang3",
		"㫢", "	qu4",
		"㫟", "	yan2",
		"㫝", "	di1",
		"㫜", "	tan3",
		"㫛", "	guang4",
		"㫼", "	die2",
		"㬂", "	yu2",
		"㬜", "	jin4",
		"㬏", "	li4",
		"㬛", "	xi1",
		"㬚", "	che4",
		"㬙", "	wei3",
		"㬘", "	su4",
		"㬗", "	xian4",
		"㬕", "	yang2",
		"㬔", "	hao2",
		"㬓", "	piao4",
		"㬒", "	mang3",
		"㬐", "	jin4",
		"㬎", "	xian3",
		"㬃", "	tai2",
		"㬍", "	bo2",
		"㬌", "	jing4",
		"㬋", "	hou2",
		"㬊", "	huan4",
		"㬉", "	nuan3",
		"㬈", "	wen1",
		"㬇", "	huan4",
		"㬆", "	min3",
		"㬅", "	man4",
		"㬄", "	chan4",
		"㭟", "	gong3",
		"㭡", "	xi4",
		"㫙", "	fu2",
		"㮰", "	pi2",
		"㮾", "	lang3",
		"㮺", "	ben3",
		"㮹", "	zhi3",
		"㮸", "	song4",
		"㮷", "	ji1",
		"㮶", "	shuo4",
		"㮵", "	zhan1",
		"㮳", "	zhen4",
		"㮲", "	chou1",
		"㮱", "	shen1",
		"㮯", "	hun2",
		"㯀", "	xuan4",
		"㮮", "	jie2",
		"㮭", "	xian2",
		"㮬", "	weng1",
		"㮫", "	he2",
		"㮪", "	qiong2",
		"㮩", "	xi1",
		"㮨", "	ji4",
		"㮧", "	wu1",
		"㮦", "	suo3",
		"㮥", "	ben4",
		"㮿", "	bi4",
		"㯁", "	pei2",
		"㮢", "	hou2",
		"㯏", "	gu3",
		"㯛", "	hu2",
		"㯚", "	ta1",
		"㯙", "	zhe2",
		"㯘", "	kuan3",
		"㯗", "	xian2",
		"㯖", "	de2",
		"㯕", "	xi1",
		"㯔", "	cui4",
		"㯓", "	ta4",
		"㯐", "	fang3",
		"㯎", "	nen4",
		"㯂", "	dai4",
		"㯍", "	jiang3",
		"㯌", "	chuan2",
		"㯋", "	jiong3",
		"㯊", "	hen2",
		"㯉", "	huo4",
		"㯈", "	su4",
		"㯇", "	bi4",
		"㯆", "	chan3",
		"㯅", "	pi2",
		"㯄", "	zhi1",
		"㮣", "	gai4",
		"㮡", "	guan4",
		"㭢", "	xin1",
		"㭲", "	ji2",
		"㮀", "	han2",
		"㭿", "	ang2",
		"㭾", "	jue2",
		"㭽", "	di3",
		"㭼", "	ta4",
		"㭻", "	tang2",
		"㭺", "	yan3",
		"㭹", "	xian2",
		"㭸", "	tu2",
		"㭴", "	jian1",
		"㭱", "	he2",
		"㮂", "	ju2",
		"㭰", "	zui1",
		"㭯", "	zhe2",
		"㭮", "	zuo4",
		"㭭", "	ba1",
		"㭬", "	zhuo2",
		"㭫", "	cuo2",
		"㭪", "	fu1",
		"㭩", "	lie4",
		"㭨", "	xie2",
		"㭤", "	niao3",
		"㮁", "	xiao2",
		"㮃", "	wei1",
		"㮟", "	nian3",
		"㮔", "	chong4",
		"㮞", "	jie2",
		"㮝", "	he2",
		"㮜", "	zang1",
		"㮛", "	chi2",
		"㮚", "	li4",
		"㮙", "	e4",
		"㮘", "	mao2",
		"㮗", "	qin2",
		"㮖", "	jia2",
		"㮕", "	ruan3",
		"㮓", "	gen4",
		"㮄", "	bang3",
		"㮒", "	yan1",
		"㮑", "	cha1",
		"㮐", "	sheng3",
		"㮏", "	nai4",
		"㮌", "	mian2",
		"㮋", "	you3",
		"㮈", "	nai4",
		"㮇", "	tian4",
		"㮆", "	nie4",
		"㮅", "	zhui1",
		"㫚", "	hu1",
		"㫘", "	mi4",
		"㧮", "	hu1",
		"㨱", "	yao2",
		"㨻", "	can2",
		"㨺", "	mian3",
		"㨹", "	hui4",
		"㨸", "	ma4",
		"㨷", "	jin4",
		"㨶", "	dao3",
		"㨵", "	jian3",
		"㨴", "	jian4",
		"㨳", "	gui3",
		"㨲", "	ce4",
		"㨰", "	gun3",
		"㨽", "	pi4",
		"㨯", "	huo4",
		"㨮", "	dou1",
		"㨭", "	hu4",
		"㨫", "	lan3",
		"㨪", "	huang4",
		"㨩", "	jie2",
		"㨨", "	chou1",
		"㨧", "	ben4",
		"㨦", "	song3",
		"㨥", "	na4",
		"㨼", "	lue4",
		"㨾", "	yang4",
		"㨢", "	pi1",
		"㩍", "	ce4",
		"㩚", "	meng2",
		"㩙", "	sai1",
		"㩘", "	ni3",
		"㩗", "	xi2",
		"㩖", "	qiang2",
		"㩔", "	tun2",
		"㩓", "	hui3",
		"㩒", "	qin2",
		"㩐", "	den4",
		"㩎", "	ye4",
		"㩌", "	fei4",
		"㨿", "	ju4",
		"㩋", "	xiao1",
		"㩊", "	xuan1",
		"㩉", "	da2",
		"㩈", "	yun3",
		"㩇", "	huo4",
		"㩆", "	jiu4",
		"㩄", "	shai1",
		"㩃", "	qian1",
		"㩁", "	que4",
		"㩀", "	ju4",
		"㨤", "	hui4",
		"㨡", "	hun2",
		"㩜", "	lan3",
		"㧺", "	ta4",
		"㨅", "	nei4",
		"㨄", "	zhou1",
		"㨃", "	dui3",
		"㨂", "	dong3",
		"㨁", "	zhi4",
		"㨀", "	bing3",
		"㧾", "	hu1",
		"㧽", "	gu4",
		"㧼", "	biao4",
		"㧻", "	zhuo2",
		"㧹", "	te4",
		"㨇", "	po2",
		"㧸", "	peng1",
		"㧷", "	tun4",
		"㧶", "	keng1",
		"㧵", "	pou2",
		"㧴", "	wo3",
		"㧳", "	zhuo4",
		"㧲", "	san3",
		"㧱", "	chen4",
		"㧰", "	li4",
		"㧯", "	lao3",
		"㨆", "	lin3",
		"㨈", "	ji3",
		"㨠", "	mi4",
		"㨕", "	ying2",
		"㨟", "	hai1",
		"㨞", "	su4",
		"㨝", "	xie1",
		"㨜", "	qian2",
		"㨛", "	shan3",
		"㨚", "	xun2",
		"㨙", "	xie2",
		"㨘", "	xing3",
		"㨗", "	jie2",
		"㨖", "	zhi4",
		"㨔", "	han4",
		"㨉", "	min2",
		"㨓", "	lao2",
		"㨒", "	kui1",
		"㨑", "	zong1",
		"㨐", "	bu3",
		"㨏", "	tan1",
		"㨎", "	ru2",
		"㨍", "	bang1",
		"㨌", "	gou4",
		"㨋", "	che3",
		"㨊", "	wei3",
		"㩛", "	tuan2",
		"㩝", "	hao2",
		"㫗", "	hou4",
		"㪦", "	yin4",
		"㪱", "	huan4",
		"㪯", "	cha2",
		"㪮", "	ling2",
		"㪭", "	lu2",
		"㪬", "	chuo1",
		"㪫", "	rui4",
		"㪪", "	sa4",
		"㪩", "	su4",
		"㪨", "	shan4",
		"㪧", "	xi1",
		"㪥", "	zha1",
		"㪵", "	ban4",
		"㪤", "	bi4",
		"㪣", "	xiao1",
		"㪢", "	shao3",
		"㪡", "	kai4",
		"㪠", "	qian1",
		"㪞", "	mao4",
		"㪝", "	lian4",
		"㪜", "	chuai3",
		"㪛", "	zhen3",
		"㪚", "	san4",
		"㪴", "	jia2",
		"㪶", "	hu2",
		"㪘", "	lian3",
		"㫄", "	pang2",
		"㫔", "	gen4",
		"㫓", "	qi3",
		"㫒", "	gong3",
		"㫑", "	zhi3",
		"㫐", "	yao3",
		"㫏", "	yao3",
		"㫎", "	hui1",
		"㫍", "	you2",
		"㫊", "	yi3",
		"㫅", "	cha2",
		"㫃", "	yan3",
		"㪷", "	dou3",
		"㫂", "	zhu4",
		"㫁", "	duan4",
		"㫀", "	ding3",
		"㪿", "	zhe2",
		"㪾", "	luo4",
		"㪽", "	suo3",
		"㪼", "	ke3",
		"㪻", "	juan4",
		"㪺", "	ju1",
		"㪹", "	lou3",
		"㪙", "	ke3",
		"㪗", "	tou3",
		"㩞", "	ci4",
		"㩮", "	qian2",
		"㩸", "	die2",
		"㩷", "	qian1",
		"㩶", "	nie4",
		"㩵", "	e4",
		"㩴", "	ju2",
		"㩳", "	song3",
		"㩲", "	kun3",
		"㩱", "	jue2",
		"㩰", "	jiao3",
		"㩯", "	po2",
		"㩭", "	bo2",
		"㩻", "	qi1",
		"㩪", "	xie2",
		"㩩", "	qing3",
		"㩨", "	hui4",
		"㩧", "	bo2",
		"㩦", "	xie2",
		"㩤", "	fu1",
		"㩢", "	mie4",
		"㩡", "	luo3",
		"㩠", "	ao1",
		"㩟", "	zhai4",
		"㩹", "	die2",
		"㩼", "	zhi1",
		"㪖", "	lu4",
		"㪋", "	han4",
		"㪕", "	diao4",
		"㪔", "	san4",
		"㪓", "	chuai2",
		"㪒", "	ni2",
		"㪑", "	ye4",
		"㪐", "	lu4",
		"㪏", "	bi3",
		"㪎", "	shan3",
		"㪍", "	bo2",
		"㪌", "	tong3",
		"㪊", "	qun2",
		"㩽", "	qi2",
		"㪉", "	he2",
		"㪈", "	gui4",
		"㪇", "	xian4",
		"㪆", "	di3",
		"㪄", "	fu2",
		"㪃", "	he2",
		"㪂", "	ku1",
		"㪁", "	qin2",
		"㪀", "	yu2",
		"㩿", "	ku1",
		"㩾", "	zhui4",
		"㠉", "	tong2",
		"㠇", "	jiu4",
		"㯝", "	lu4",
		"㕯", "	ne4",
		"㕺", "	xiao1",
		"㕹", "	fa2",
		"㕸", "	li4",
		"㕷", "	hua4",
		"㕶", "	en3",
		"㕵", "	guo2",
		"㕴", "	chen2",
		"㕲", "	hua2",
		"㕱", "	you2",
		"㕰", "	xue4",
		"㕮", "	fu3",
		"㕽", "	si4",
		"㕭", "	ao1",
		"㕬", "	gong1",
		"㕫", "	fang3",
		"㕪", "	dan3",
		"㕩", "	pang4",
		"㕨", "	fan4",
		"㕧", "	xi1",
		"㕦", "	hua4",
		"㕥", "	shen1",
		"㕤", "	qiu2",
		"㕻", "	pou3",
		"㖀", "	le4",
		"㕢", "	gai4",
		"㖔", "	tun3",
		"㖣", "	tou4",
		"㖢", "	qi2",
		"㖡", "	ye4",
		"㖠", "	nuo4",
		"㖟", "	shou4",
		"㖞", "	wai1",
		"㖘", "	zhen1",
		"㖗", "	yin2",
		"㖖", "	nie4",
		"㖕", "	nie4",
		"㖓", "	hong2",
		"㖁", "	lin4",
		"㖒", "	ti2",
		"㖑", "	xie4",
		"㖐", "	wei3",
		"㖏", "	nie4",
		"㖊", "	xun2",
		"㖇", "	er2",
		"㖆", "	qu2",
		"㖅", "	xu4",
		"㖃", "	hou3",
		"㖂", "	yi4",
		"㕣", "	yan3",
		"㕡", "	he2",
		"㖥", "	jun4",
		"㔴", "	yi4",
		"㔿", "	zou4",
		"㔾", "	xian1",
		"㔽", "	yao4",
		"㔼", "	sun3",
		"㔺", "	shi4",
		"㔹", "	le4",
		"㔸", "	ti1",
		"㔷", "	lou4",
		"㔶", "	gong4",
		"㔵", "	xuan3",
		"㔳", "	gui3",
		"㕂", "	yin2",
		"㔱", "	yu3",
		"㔰", "	heng2",
		"㔯", "	xuan2",
		"㔮", "	nuo2",
		"㔭", "	che4",
		"㔪", "	lu3",
		"㔩", "	e4",
		"㔨", "	bei4",
		"㔧", "	lv4",
		"㔦", "	yang3",
		"㕁", "	que4",
		"㕃", "	xi1",
		"㕠", "	shuang1",
		"㕑", "	chu2",
		"㕟", "	kui4",
		"㕞", "	shua1",
		"㕜", "	shi3",
		"㕛", "	xu4",
		"㕚", "	zhao3",
		"㕙", "	jun4",
		"㕗", "	you4",
		"㕖", "	su4",
		"㕕", "	huan4",
		"㕒", "	wei1",
		"㕐", "	xie3",
		"㕄", "	zhi3",
		"㕏", "	chu2",
		"㕎", "	ke4",
		"㕌", "	ai4",
		"㕋", "	qin2",
		"㕊", "	fu1",
		"㕉", "	ke4",
		"㕈", "	yi3",
		"㕇", "	la1",
		"㕆", "	hu4",
		"㕅", "	jia2",
		"㖤", "	han2",
		"㖦", "	dong3",
		"㔤", "	xin4",
		"㗼", "	ye4",
		"㘇", "	rong2",
		"㘆", "	tai3",
		"㘅", "	xian2",
		"㘄", "	leng1",
		"㘂", "	ci2",
		"㘁", "	yi4",
		"㘀", "	zuo4",
		"㗿", "	he2",
		"㗾", "	xue1",
		"㗽", "	xiang3",
		"㗻", "	guo1",
		"㘉", "	zhi4",
		"㗷", "	sai3",
		"㗶", "	po1",
		"㗵", "	xu4",
		"㗴", "	yan2",
		"㗳", "	ta3",
		"㗲", "	huo4",
		"㗱", "	ji2",
		"㗰", "	cong2",
		"㗭", "	xi1",
		"㗬", "	zha1",
		"㘈", "	yi4",
		"㘊", "	xi1",
		"㗩", "	xi1",
		"㘚", "	han3",
		"㘥", "	you2",
		"㘤", "	wan1",
		"㘣", "	xuan2",
		"㘢", "	weng3",
		"㘡", "	xia2",
		"㘠", "	bi4",
		"㘞", "	huo4",
		"㘝", "	nie4",
		"㘜", "	chi3",
		"㘛", "	kan1",
		"㘙", "	yan2",
		"㘋", "	xian2",
		"㘗", "	qu1",
		"㘖", "	yan2",
		"㘕", "	han3",
		"㘔", "	sai3",
		"㘓", "	lan2",
		"㘑", "	li4",
		"㘐", "	pao4",
		"㘎", "	han3",
		"㘍", "	ji2",
		"㘌", "	ju4",
		"㗫", "	qie4",
		"㗨", "	xie1",
		"㖧", "	hun1",
		"㖺", "	chun3",
		"㗄", "	ku1",
		"㗃", "	wen3",
		"㗂", "	sheng3",
		"㗁", "	e4",
		"㗀", "	you1",
		"㖿", "	xie2",
		"㖾", "	e4",
		"㖽", "	ze2",
		"㖼", "	duo3",
		"㖻", "	niu2",
		"㖹", "	pen1",
		"㗆", "	ge2",
		"㖸", "	xue2",
		"㖷", "	shi2",
		"㖶", "	yan1",
		"㖵", "	ge2",
		"㖮", "	lun2",
		"㖭", "	tian3",
		"㖫", "	ling2",
		"㖪", "	huo4",
		"㖩", "	ju1",
		"㖨", "	lu4",
		"㗅", "	hu2",
		"㗇", "	xia2",
		"㗧", "	zhi4",
		"㗗", "	bei1",
		"㗦", "	lao2",
		"㗥", "	kuo4",
		"㗤", "	cu4",
		"㗣", "	ti4",
		"㗢", "	hong2",
		"㗜", "	xiu4",
		"㗛", "	xiao4",
		"㗚", "	li4",
		"㗙", "	chu1",
		"㗘", "	bo2",
		"㗖", "	dan4",
		"㗈", "	man4",
		"㗕", "	gou4",
		"㗔", "	qian1",
		"㗓", "	zhui1",
		"㗒", "	ai4",
		"㗑", "	bai",
		"㗏", "	wai1",
		"㗌", "	zhi4",
		"㗋", "	hou2",
		"㗊", "	ji2",
		"㗉", "	lue4",
		"㔥", "	bai4",
		"㔣", "	lei2",
		"㘧", "	xu4",
		"㑯", "	xu3",
		"㑻", "	ma4",
		"㑺", "	jun4",
		"㑹", "	hui4",
		"㑸", "	yao2",
		"㑷", "	tai4",
		"㑶", "	xi4",
		"㑵", "	han4",
		"㑳", "	zhou4",
		"㑱", "	rao3",
		"㑰", "	hui4",
		"㑮", "	hun2",
		"㑽", "	tang2",
		"㑪", "	chai2",
		"㑩", "	luo2",
		"㑨", "	yu3",
		"㑧", "	ji4",
		"㑦", "	li4",
		"㑥", "	yi4",
		"㑤", "	miao2",
		"㑣", "	lan2",
		"㑟", "	beng3",
		"㑞", "	ying4",
		"㑼", "	lue4",
		"㑾", "	yao2",
		"㑜", "	yi4",
		"㒌", "	qiong2",
		"㒙", "	mian2",
		"㒗", "	tai2",
		"㒖", "	ou3",
		"㒕", "	yang1",
		"㒔", "	shu2",
		"㒓", "	ta4",
		"㒒", "	pu2",
		"㒑", "	kui3",
		"㒎", "	sa4",
		"㒍", "	lei2",
		"㒊", "	se4",
		"㑿", "	zhao4",
		"㒉", "	tang3",
		"㒈", "	han4",
		"㒇", "	wu3",
		"㒆", "	chi4",
		"㒅", "	qi3",
		"㒄", "	ran3",
		"㒃", "	er4",
		"㒂", "	zhuo2",
		"㒁", "	yu3",
		"㒀", "	zhai1",
		"㑝", "	long4",
		"㑛", "	su4",
		"㒛", "	diao4",
		"㐫", "	xiong1",
		"㐵", "	ru2",
		"㐴", "	pan1",
		"㐳", "	wu4",
		"㐲", "	dai4",
		"㐱", "	zhen3",
		"㐰", "	xin4",
		"㐯", "	yong1",
		"㐮", "	xiang1",
		"㐭", "	lin3",
		"㐬", "	liu2",
		"㐩", "	xing2",
		"㐸", "	qian4",
		"㐨", "	xu4",
		"㐤", "	dan1",
		"㐡", "	nuo4",
		"㐜", "	chou2",
		"㐖", "	xie2",
		"㐌", "	yi2",
		"㐆", "	yin3",
		"㐅", "	wu3",
		"㐄", "	kua4",
		"㐁", "	tian4",
		"㐷", "	ma3",
		"㐹", "	yi4",
		"㑚", "	nuo2",
		"㑊", "	yi4",
		"㑙", "	die2",
		"㑘", "	jie4",
		"㑗", "	shen1",
		"㑔", "	xu3",
		"㑐", "	shu1",
		"㑏", "	zhu4",
		"㑎", "	nao3",
		"㑍", "	lei4",
		"㑌", "	kuang1",
		"㑋", "	qiong2",
		"㑉", "	su4",
		"㐺", "	yin2",
		"㑈", "	dong4",
		"㑇", "	zhou4",
		"㑅", "	zuo4",
		"㑄", "	wu3",
		"㑃", "	ao3",
		"㑂", "	fang3",
		"㑁", "	zhuo1",
		"㐽", "	feng1",
		"㐼", "	cheng4",
		"㐻", "	nei4",
		"㒚", "	yin4",
		"㒜", "	yu3",
		"㔢", "	jue2",
		"㓴", "	ruan3",
		"㔀", "	lue4",
		"㓾", "	xi1",
		"㓽", "	chong2",
		"㓼", "	chi4",
		"㓺", "	jian1",
		"㓹", "	rui4",
		"㓸", "	zhuo1",
		"㓷", "	yi4",
		"㓶", "	qie4",
		"㓵", "	e4",
		"㓳", "	di1",
		"㔂", "	lin2",
		"㓲", "	pian1",
		"㓱", "	tou2",
		"㓰", "	hua4",
		"㓯", "	li2",
		"㓭", "	she2",
		"㓪", "	lang3",
		"㓩", "	xuan1",
		"㓨", "	ci2",
		"㓧", "	gan1",
		"㓦", "	bai1",
		"㔁", "	deng1",
		"㔃", "	jue2",
		"㓤", "	qia4",
		"㔓", "	jian3",
		"㔡", "	bie1",
		"㔠", "	xia1",
		"㔞", "	kuai4",
		"㔝", "	liang3",
		"㔜", "	ba2",
		"㔚", "	jie2",
		"㔙", "	beng1",
		"㔘", "	chu4",
		"㔗", "	fei4",
		"㔕", "	ji2",
		"㔒", "	xi2",
		"㔄", "	su4",
		"㔑", "	chi4",
		"㔏", "	li4",
		"㔎", "	xie4",
		"㔍", "	chua1",
		"㔌", "	zou4",
		"㔋", "	jian1",
		"㔊", "	zhan3",
		"㔉", "	zhu3",
		"㔆", "	zan4",
		"㔅", "	xiao4",
		"㓥", "	tang1",
		"㓣", "	qia4",
		"㒝", "	mie4",
		"㒲", "	cai2",
		"㒿", "	li2",
		"㒾", "	shi4",
		"㒽", "	quan1",
		"㒼", "	man2",
		"㒻", "	mao4",
		"㒸", "	sui4",
		"㒷", "	gua3",
		"㒵", "	mao4",
		"㒴", "	gu3",
		"㒳", "	liang3",
		"㒰", "	quan2",
		"㓂", "	kou4",
		"㒫", "	ji4",
		"㒩", "	luo3",
		"㒧", "	li4",
		"㒦", "	lei3",
		"㒥", "	feng1",
		"㒤", "	che4",
		"㒡", "	you2",
		"㒠", "	xie4",
		"㒟", "	niao3",
		"㒞", "	jun4",
		"㓁", "	wang3",
		"㓃", "	du4",
		"㓢", "	luo4",
		"㓔", "	xie4",
		"㓡", "	fu3",
		"㓠", "	dian4",
		"㓟", "	pi2",
		"㓞", "	qia4",
		"㓝", "	xing2",
		"㓜", "	you4",
		"㓚", "	gong1",
		"㓘", "	su4",
		"㓗", "	jie2",
		"㓖", "	bi4",
		"㓓", "	nan2",
		"㓄", "	zhen4",
		"㓑", "	xing4",
		"㓐", "	lu4",
		"㓏", "	jiong3",
		"㓎", "	qin1",
		"㓌", "	cheng1",
		"㓋", "	gong4",
		"㓊", "	dong4",
		"㓉", "	huo4",
		"㓈", "	bing4",
		"㓅", "	ting1",
		"㘦", "	qin2",
		"㘨", "	nie4",
		"㠆", "	dan1",
		"㝦", "	jun4",
		"㝲", "	qin3",
		"㝱", "	meng4",
		"㝰", "	mian2",
		"㝯", "	qiao2",
		"㝮", "	cui4",
		"㝭", "	xing3",
		"㝫", "	long2",
		"㝪", "	dian4",
		"㝩", "	kang1",
		"㝧", "	wen3",
		"㝥", "	mi3",
		"㝵", "	de2",
		"㝤", "	gou4",
		"㝣", "	yi4",
		"㝢", "	yu3",
		"㝡", "	zui4",
		"㝠", "	ming2",
		"㝟", "	mao2",
		"㝞", "	ya1",
		"㝝", "	lin2",
		"㝛", "	su4",
		"㝚", "	yan2",
		"㝴", "	wan2",
		"㝶", "	ai4",
		"㝘", "	yong2",
		"㞄", "	an1",
		"㞏", "	zhe2",
		"㞎", "	ba3",
		"㞌", "	yun4",
		"㞋", "	nian3",
		"㞊", "	xu4",
		"㞉", "	za1",
		"㞈", "	bo1",
		"㞇", "	wei3",
		"㞆", "	ji3",
		"㞅", "	luo4",
		"㞃", "	ji4",
		"㝸", "	bian4",
		"㞂", "	tui3",
		"㞁", "	yao4",
		"㞀", "	hui1",
		"㝿", "	bo3",
		"㝾", "	zuo3",
		"㝽", "	chui2",
		"㝼", "	yu1",
		"㝻", "	jin3",
		"㝺", "	lian2",
		"㝹", "	nou2",
		"㝙", "	yin2",
		"㝗", "	lang2",
		"㞑", "	wei3",
		"㜯", "	xi1",
		"㜹", "	qu2",
		"㜸", "	nie4",
		"㜷", "	mi2",
		"㜶", "	wan3",
		"㜵", "	niao3",
		"㜴", "	meng4",
		"㜳", "	huai2",
		"㜲", "	weng3",
		"㜱", "	zhi4",
		"㜰", "	yue4",
		"㜮", "	lan4",
		"㜻", "	lian4",
		"㜫", "	ma4",
		"㜪", "	shen1",
		"㜩", "	ao4",
		"㜨", "	nai2",
		"㜧", "	yue4",
		"㜦", "	xin2",
		"㜥", "	mai2",
		"㜤", "	nian3",
		"㜣", "	ran2",
		"㜡", "	cong1",
		"㜺", "	zan4",
		"㜼", "	zhi2",
		"㝖", "	yi2",
		"㝊", "	shou3",
		"㝕", "	ning2",
		"㝔", "	yao3",
		"㝓", "	ke4",
		"㝑", "	mang2",
		"㝐", "	rong2",
		"㝏", "	jie4",
		"㝎", "	ding4",
		"㝍", "	xie3",
		"㝌", "	jiu4",
		"㝋", "	liao3",
		"㝉", "	zhu4",
		"㜽", "	zi3",
		"㝈", "	luan2",
		"㝇", "	chun2",
		"㝅", "	gou4",
		"㝄", "	chun2",
		"㝃", "	mian3",
		"㝂", "	zhi4",
		"㝁", "	xuan1",
		"㝀", "	hao4",
		"㜿", "	xu4",
		"㜾", "	hai2",
		"㞐", "	ju1",
		"㞒", "	xie4",
		"㜞", "	qian4",
		"㟚", "	qi2",
		"㟧", "	e4",
		"㟦", "	yun4",
		"㟤", "	lu4",
		"㟢", "	qi2",
		"㟠", "	gang3",
		"㟟", "	xiang4",
		"㟞", "	zhan4",
		"㟝", "	pei2",
		"㟜", "	mi2",
		"㟛", "	zan4",
		"㟙", "	ze2",
		"㟩", "	min2",
		"㟘", "	tiao2",
		"㟖", "	long4",
		"㟔", "	han2",
		"㟓", "	qi2",
		"㟒", "	qun1",
		"㟑", "	bo2",
		"㟐", "	mang3",
		"㟏", "	han2",
		"㟎", "	tuo3",
		"㟍", "	lang2",
		"㟨", "	duan1",
		"㟪", "	wei1",
		"㟋", "	dui4",
		"㟹", "	lao2",
		"㠅", "	fu2",
		"㠄", "	xi2",
		"㠂", "	ao2",
		"㠀", "	dao3",
		"㟿", "	mang3",
		"㟾", "	yong1",
		"㟽", "	biao3",
		"㟼", "	ao2",
		"㟻", "	qian4",
		"㟺", "	lou2",
		"㟷", "	da",
		"㟫", "	quan2",
		"㟶", "	yuan2",
		"㟵", "	gang3",
		"㟴", "	kuai4",
		"㟳", "	li4",
		"㟲", "	jue2",
		"㟱", "	yao3",
		"㟰", "	ming3",
		"㟮", "	tu1",
		"㟭", "	min2",
		"㟬", "	sou3",
		"㟌", "	mang2",
		"㟊", "	fu2",
		"㞓", "	qi4",
		"㞠", "	lao2",
		"㞬", "	qin4",
		"㞫", "	ju4",
		"㞪", "	nao2",
		"㞩", "	lan2",
		"㞨", "	zi3",
		"㞧", "	hui4",
		"㞦", "	ji3",
		"㞥", "	cen2",
		"㞤", "	yin2",
		"㞡", "	zhan3",
		"㞟", "	dian4",
		"㞯", "	jie2",
		"㞞", "	song2",
		"㞜", "	tui1",
		"㞛", "	ji3",
		"㞚", "	qi4",
		"㞙", "	niao4",
		"㞘", "	du1",
		"㞗", "	qiu2",
		"㞖", "	ci2",
		"㞕", "	xie4",
		"㞔", "	yi2",
		"㞭", "	dai4",
		"㞰", "	xu3",
		"㟉", "	lao2",
		"㞾", "	ni2",
		"㟈", "	qiu2",
		"㟇", "	cuo4",
		"㟆", "	hua2",
		"㟅", "	yang2",
		"㟄", "	xiang2",
		"㟃", "	si1",
		"㟂", "	mu3",
		"㟁", "	an4",
		"㟀", "	lian2",
		"㞿", "	chi4",
		"㞽", "	xue4",
		"㞱", "	cong1",
		"㞼", "	cheng2",
		"㞻", "	hao4",
		"㞺", "	zu2",
		"㞹", "	ke3",
		"㞸", "	sui4",
		"㞷", "	huang2",
		"㞶", "	min3",
		"㞴", "	chi2",
		"㞳", "	dou3",
		"㞲", "	yong4",
		"㜠", "	cui1",
		"㜝", "	an3",
		"㘩", "	bi4",
		"㙶", "	tang2",
		"㚂", "	nang4",
		"㚁", "	qiao4",
		"㚀", "	xi1",
		"㙾", "	xi4",
		"㙼", "	lei3",
		"㙻", "	chan2",
		"㙺", "	kui2",
		"㙹", "	meng2",
		"㙸", "	bao4",
		"㙷", "	zhi2",
		"㙵", "	tai2",
		"㚅", "	long2",
		"㙴", "	chan4",
		"㙳", "	kan3",
		"㙲", "	yong3",
		"㙱", "	hao4",
		"㙰", "	xie4",
		"㙯", "	yi4",
		"㙮", "	da1",
		"㙬", "	yin2",
		"㙫", "	ji2",
		"㙪", "	yi4",
		"㚃", "	yun1",
		"㚆", "	fu4",
		"㙨", "	ji4",
		"㚖", "	gao3",
		"㚠", "	xiao1",
		"㚟", "	chuo4",
		"㚞", "	shen3",
		"㚝", "	zhui1",
		"㚜", "	yu4",
		"㚛", "	xi4",
		"㚚", "	kong1",
		"㚙", "	jia1",
		"㚘", "	ban4",
		"㚗", "	qie2",
		"㚕", "	fu2",
		"㚇", "	zong1",
		"㚔", "	nie4",
		"㚓", "	lai3",
		"㚒", "	shan3",
		"㚐", "	tao4",
		"㚏", "	gao3",
		"㚍", "	kui3",
		"㚌", "	hua4",
		"㚋", "	diao1",
		"㚊", "	kai1",
		"㚉", "	gu3",
		"㙩", "	liao2",
		"㙦", "	xie2",
		"㚢", "	nu2",
		"㘸", "	zang4",
		"㙇", "	chu4",
		"㙅", "	bao3",
		"㙄", "	bi4",
		"㙃", "	bang1",
		"㙂", "	dui4",
		"㙁", "	mei2",
		"㙀", "	liu4",
		"㘿", "	nie4",
		"㘺", "	fa2",
		"㘹", "	ci2",
		"㘷", "	ai4",
		"㙉", "	tian3",
		"㘶", "	jie2",
		"㘵", "	bu4",
		"㘴", "	zuo4",
		"㘲", "	ju2",
		"㘱", "	tan1",
		"㘰", "	zhen1",
		"㘭", "	ao4",
		"㘬", "	ao4",
		"㘫", "	jing3",
		"㘪", "	hao4",
		"㙈", "	xia4",
		"㙊", "	chang2",
		"㙥", "	gun4",
		"㙚", "	xing1",
		"㙤", "	xia4",
		"㙣", "	zhang4",
		"㙢", "	man2",
		"㙡", "	zong1",
		"㙠", "	yi1",
		"㙟", "	lang3",
		"㙞", "	nie4",
		"㙝", "	xie2",
		"㙜", "	chi2",
		"㙛", "	bu3",
		"㙙", "	long3",
		"㙍", "	duo1",
		"㙘", "	yao1",
		"㙗", "	wei1",
		"㙕", "	kuai4",
		"㙔", "	wei3",
		"㙓", "	kui2",
		"㙒", "	ye3",
		"㙑", "	yu3",
		"㙐", "	duo3",
		"㙏", "	fu4",
		"㙎", "	wei1",
		"㚡", "	ji3",
		"㚣", "	xiao2",
		"㜜", "	ao4",
		"㛳", "	yi4",
		"㛾", "	xian2",
		"㛼", "	cha1",
		"㛻", "	kua1",
		"㛺", "	an1",
		"㛹", "	pian2",
		"㛸", "	shu4",
		"㛷", "	ji1",
		"㛶", "	tan4",
		"㛵", "	cheng1",
		"㛴", "	nao3",
		"㛲", "	fa4",
		"㜂", "	feng1",
		"㛱", "	wei3",
		"㛯", "	fan4",
		"㛮", "	sao3",
		"㛭", "	xi1",
		"㛬", "	lu4",
		"㛫", "	xi1",
		"㛪", "	yan4",
		"㛩", "	zhou2",
		"㛨", "	qiang3",
		"㛧", "	man3",
		"㛿", "	zhi4",
		"㜃", "	lian4",
		"㛥", "	ta4",
		"㜐", "	shu4",
		"㜛", "	nen4",
		"㜚", "	su4",
		"㜙", "	lu4",
		"㜘", "	ju4",
		"㜗", "	can1",
		"㜖", "	cao2",
		"㜕", "	lian2",
		"㜓", "	da2",
		"㜒", "	yi4",
		"㜑", "	fu2",
		"㜏", "	yun2",
		"㜄", "	xun2",
		"㜎", "	xi1",
		"㜍", "	tang2",
		"㜌", "	nou3",
		"㜋", "	yi4",
		"㜊", "	zhan3",
		"㜉", "	yong1",
		"㜈", "	mu4",
		"㜇", "	hui4",
		"㜆", "	mi4",
		"㜅", "	xu4",
		"㛦", "	lan3",
		"㛤", "	li2",
		"㚤", "	yi4",
		"㚱", "	qiu1",
		"㚾", "	xiong1",
		"㚽", "	qiao3",
		"㚻", "	ji1",
		"㚺", "	yun4",
		"㚹", "	mao3",
		"㚷", "	er3",
		"㚶", "	si4",
		"㚵", "	dong1",
		"㚴", "	bu4",
		"㚲", "	chan1",
		"㚰", "	pei1",
		"㛀", "	chu2",
		"㚯", "	xin2",
		"㚭", "	you2",
		"㚬", "	jun1",
		"㚫", "	sa4",
		"㚪", "	hao4",
		"㚩", "	ran3",
		"㚨", "	shen3",
		"㚧", "	yan3",
		"㚦", "	yi2",
		"㚥", "	yu2",
		"㚿", "	pao2",
		"㛁", "	peng1",
		"㛣", "	yun2",
		"㛔", "	feng1",
		"㛞", "	long4",
		"㛝", "	bei4",
		"㛜", "	you2",
		"㛛", "	xin4",
		"㛚", "	tong3",
		"㛙", "	xin1",
		"㛘", "	po4",
		"㛗", "	qie1",
		"㛖", "	suo1",
		"㛕", "	yi4",
		"㛓", "	xi1",
		"㛂", "	nuo3",
		"㛒", "	dou4",
		"㛑", "	can4",
		"㛐", "	sou3",
		"㛏", "	qiu2",
		"㛎", "	lv3",
		"㛍", "	qie4",
		"㛊", "	duo3",
		"㛆", "	duo4",
		"㛅", "	er4",
		"㛄", "	yi1",
		"㛃", "	jie2",
		"㯜", "	cui4",
		"㯞", "	juan4",
		"䍓", "	hu4",
		"䃫", "	dan3",
		"䃵", "	niao3",
		"䃴", "	zhu1",
		"䃳", "	la4",
		"䃲", "	pan2",
		"䃱", "	xian4",
		"䃰", "	ca1",
		"䃯", "	li4",
		"䃮", "	da2",
		"䃭", "	gan3",
		"䃬", "	wei3",
		"䃪", "	tan2",
		"䃷", "	ying2",
		"䃩", "	nao2",
		"䃧", "	long2",
		"䃦", "	dun1",
		"䃥", "	chuang2",
		"䃤", "	su4",
		"䃣", "	hui3",
		"䃢", "	qin1",
		"䃡", "	jin1",
		"䃠", "	xuan4",
		"䃞", "	shu2",
		"䃶", "	huai2",
		"䃸", "	xian4",
		"䃜", "	yi1",
		"䄇", "	cheng2",
		"䄒", "	nie4",
		"䄑", "	huo2",
		"䄐", "	quan4",
		"䄏", "	yu2",
		"䄎", "	qi3",
		"䄍", "	zha4",
		"䄌", "	zhui4",
		"䄋", "	yan3",
		"䄉", "	e2",
		"䄈", "	dou4",
		"䄆", "	huo2",
		"䃹", "	lan4",
		"䄅", "	juan4",
		"䄄", "	yin1",
		"䄂", "	liu4",
		"䄁", "	yi4",
		"䄀", "	huo4",
		"䃿", "	fu1",
		"䃾", "	bi3",
		"䃽", "	gui3",
		"䃻", "	ba4",
		"䃺", "	mo2",
		"䃝", "	qiao4",
		"䃛", "	lian2",
		"䄔", "	ju3",
		"䂱", "	rui4",
		"䂻", "	zheng4",
		"䂺", "	wo3",
		"䂹", "	suo3",
		"䂸", "	guo2",
		"䂷", "	guai1",
		"䂶", "	jie2",
		"䂵", "	gong1",
		"䂴", "	yan2",
		"䂳", "	cuo3",
		"䂲", "	fa3",
		"䂰", "	la4",
		"䂽", "	diao4",
		"䂯", "	guai4",
		"䂮", "	lue4",
		"䂭", "	qiao1",
		"䂬", "	gong3",
		"䂫", "	hang1",
		"䂪", "	qiao3",
		"䂩", "	yan4",
		"䂧", "	zhen3",
		"䂦", "	zhen1",
		"䂥", "	min2",
		"䂼", "	nie4",
		"䂾", "	lai3",
		"䃚", "	cu4",
		"䃎", "	zha4",
		"䃙", "	lu4",
		"䃘", "	keng1",
		"䃗", "	bo1",
		"䃖", "	wu4",
		"䃕", "	lao2",
		"䃔", "	hong2",
		"䃓", "	gou4",
		"䃒", "	he2",
		"䃑", "	ban1",
		"䃏", "	xing1",
		"䃍", "	zhao4",
		"䂿", "	ta4",
		"䃌", "	zhen1",
		"䃋", "	yu2",
		"䃊", "	ju3",
		"䃉", "	min2",
		"䃈", "	jie1",
		"䃇", "	mian2",
		"䃅", "	di1",
		"䃂", "	gun3",
		"䃁", "	ya1",
		"䃀", "	cui4",
		"䄓", "	huang2",
		"䄕", "	she4",
		"䂣", "	ci2",
		"䅜", "	duo4",
		"䅦", "	mao2",
		"䅥", "	jie2",
		"䅤", "	qi4",
		"䅣", "	huang2",
		"䅢", "	jiu4",
		"䅡", "	xu3",
		"䅠", "	ti2",
		"䅟", "	can3",
		"䅞", "	ne4",
		"䅝", "	kong1",
		"䅛", "	chang1",
		"䅩", "	zhi3",
		"䅚", "	quan3",
		"䅙", "	hun4",
		"䅘", "	lai2",
		"䅗", "	sui4",
		"䅖", "	an1",
		"䅕", "	ju1",
		"䅔", "	zi1",
		"䅓", "	ju3",
		"䅒", "	mang2",
		"䅑", "	rui2",
		"䅧", "	yan1",
		"䅪", "	tui2",
		"䅏", "	hui4",
		"䅸", "	shen1",
		"䆂", "	lian2",
		"䆁", "	gao1",
		"䆀", "	mei3",
		"䅿", "	huang2",
		"䅾", "	cen2",
		"䅽", "	xin1",
		"䅼", "	man2",
		"䅻", "	li2",
		"䅺", "	biao1",
		"䅹", "	lou3",
		"䅷", "	tu2",
		"䅬", "	ai4",
		"䅶", "	nou4",
		"䅵", "	zhuo2",
		"䅴", "	suo3",
		"䅳", "	chu2",
		"䅲", "	qi2",
		"䅱", "	hun4",
		"䅰", "	en3",
		"䅯", "	tang2",
		"䅮", "	cang4",
		"䅭", "	pang2",
		"䅐", "	jian3",
		"䅎", "	you3",
		"䄘", "	peng2",
		"䄦", "	liao3",
		"䄰", "	ya2",
		"䄯", "	jian3",
		"䄮", "	fu1",
		"䄭", "	nian2",
		"䄬", "	yi2",
		"䄫", "	qi3",
		"䄪", "	diao3",
		"䄩", "	yi4",
		"䄨", "	yu2",
		"䄧", "	reng2",
		"䄥", "	ling2",
		"䄲", "	rui4",
		"䄤", "	lai4",
		"䄢", "	qi2",
		"䄡", "	dan1",
		"䄠", "	shan4",
		"䄟", "	cui1",
		"䄝", "	chuang1",
		"䄜", "	li2",
		"䄛", "	lou2",
		"䄚", "	cao2",
		"䄙", "	ming2",
		"䄱", "	fang1",
		"䄳", "	xian1",
		"䅍", "	ting3",
		"䅂", "	he2",
		"䅌", "	juan1",
		"䅋", "	wan3",
		"䅊", "	cha2",
		"䅉", "	ya4",
		"䅈", "	yuan4",
		"䅇", "	su4",
		"䅆", "	zi4",
		"䅅", "	gui1",
		"䅄", "	li4",
		"䅃", "	qiong2",
		"䅁", "	an4",
		"䄶", "	bi4",
		"䅀", "	lie4",
		"䄿", "	yi4",
		"䄾", "	ru4",
		"䄽", "	tian3",
		"䄼", "	tian3",
		"䄻", "	tao2",
		"䄺", "	zhi4",
		"䄹", "	nian2",
		"䄸", "	po4",
		"䄷", "	shi2",
		"䂤", "	fu4",
		"䂢", "	dong3",
		"䆄", "	zhan3",
		"䀎", "	mian3",
		"䀘", "	xie2",
		"䀗", "	jue2",
		"䀖", "	tian1",
		"䀕", "	zhen4",
		"䀔", "	ren4",
		"䀓", "	huan4",
		"䀒", "	qian1",
		"䀑", "	wo4",
		"䀐", "	shan1",
		"䀏", "	xuan4",
		"䀍", "	kan4",
		"䀚", "	ang2",
		"䀌", "	xi4",
		"䀋", "	yan2",
		"䀊", "	jiao3",
		"䀉", "	qiao2",
		"䀈", "	ji4",
		"䀇", "	gu3",
		"䀆", "	jin4",
		"䀅", "	she4",
		"䀄", "	meng2",
		"䀃", "	tui2",
		"䀙", "	qi4",
		"䀛", "	mei4",
		"䀁", "	you4",
		"䀩", "	luo4",
		"䀳", "	ai4",
		"䀲", "	mu4",
		"䀱", "	feng1",
		"䀰", "	gu3",
		"䀯", "	bu3",
		"䀮", "	huang1",
		"䀭", "	gai1",
		"䀬", "	quan2",
		"䀫", "	jia2",
		"䀪", "	hang2",
		"䀨", "	hua4",
		"䀜", "	gu3",
		"䀧", "	hong3",
		"䀦", "	gu3",
		"䀥", "	shuo4",
		"䀤", "	mao4",
		"䀣", "	bi4",
		"䀢", "	shun4",
		"䀡", "	chan4",
		"䀠", "	ju4",
		"䀟", "	fan2",
		"䀞", "	tao1",
		"䀂", "	an1",
		"䀀", "	fan4",
		"䀵", "	shun4",
		"㿗", "	tui2",
		"㿣", "	he1",
		"㿢", "	yao4",
		"㿠", "	huang4",
		"㿟", "	bai2",
		"㿞", "	mao4",
		"㿜", "	bie3",
		"㿛", "	li4",
		"㿚", "	luo4",
		"㿙", "	pi4",
		"㿘", "	ying2",
		"㿖", "	lu2",
		"㿥", "	he2",
		"㿕", "	yan2",
		"㿔", "	lei3",
		"㿓", "	jia2",
		"㿒", "	dao3",
		"㿑", "	yao4",
		"㿏", "	qun2",
		"㿎", "	fen4",
		"㿍", "	jie4",
		"㿌", "	xian1",
		"㿋", "	sao4",
		"㿤", "	chun3",
		"㿦", "	ning4",
		"㿿", "	ya3",
		"㿴", "	da1",
		"㿾", "	zhu4",
		"㿽", "	xi1",
		"㿼", "	yan2",
		"㿻", "	gan1",
		"㿺", "	bao2",
		"㿹", "	ta4",
		"㿸", "	wan3",
		"㿷", "	cuo2",
		"㿶", "	bang1",
		"㿵", "	ran3",
		"㿳", "	zi1",
		"㿧", "	chou2",
		"㿱", "	xue2",
		"㿰", "	ao2",
		"㿯", "	da2",
		"㿮", "	yang4",
		"㿭", "	che4",
		"㿬", "	ba1",
		"㿫", "	bi4",
		"㿪", "	huan2",
		"㿩", "	tang3",
		"㿨", "	li4",
		"䀴", "	ying3",
		"䀶", "	liang4",
		"䂡", "	di3",
		"䁹", "	bi4",
		"䂃", "	jiao4",
		"䂂", "	qu2",
		"䂁", "	chan2",
		"䂀", "	xi1",
		"䁿", "	mo4",
		"䁾", "	mie4",
		"䁽", "	lie4",
		"䁼", "	mo4",
		"䁻", "	shuo4",
		"䁺", "	shi4",
		"䁸", "	nang2",
		"䂅", "	xian1",
		"䁷", "	jue2",
		"䁶", "	ji1",
		"䁵", "	bian3",
		"䁴", "	zhan3",
		"䁳", "	mang3",
		"䁲", "	mai2",
		"䁱", "	kou1",
		"䁰", "	jiang3",
		"䁯", "	xi1",
		"䁮", "	qian2",
		"䂄", "	huo4",
		"䂆", "	xu4",
		"䁬", "	ceng2",
		"䂕", "	hui4",
		"䂠", "	shi3",
		"䂟", "	jia1",
		"䂞", "	zhe4",
		"䂝", "	jie2",
		"䂜", "	bang4",
		"䂛", "	yu2",
		"䂚", "	yao2",
		"䂙", "	dui1",
		"䂗", "	ku1",
		"䂖", "	shi2",
		"䂔", "	xing4",
		"䂇", "	niu3",
		"䂒", "	qia4",
		"䂑", "	ji1",
		"䂐", "	zhuo1",
		"䂏", "	diao1",
		"䂎", "	zuan3",
		"䂍", "	bo2",
		"䂌", "	chong1",
		"䂊", "	yu4",
		"䂉", "	hou2",
		"䂈", "	tong2",
		"䁭", "	biao1",
		"䁫", "	hu2",
		"䀷", "	jie2",
		"䁄", "	xing4",
		"䁎", "	cheng2",
		"䁍", "	qia4",
		"䁌", "	yu4",
		"䁋", "	xie4",
		"䁊", "	wo4",
		"䁉", "	qi4",
		"䁈", "	qi4",
		"䁇", "	mi4",
		"䁆", "	ye4",
		"䁅", "	meng3",
		"䁃", "	biao1",
		"䁐", "	ying1",
		"䁂", "	xian4",
		"䁁", "	liang4",
		"䀿", "	di4",
		"䀾", "	du3",
		"䀽", "	yan2",
		"䀼", "	chen1",
		"䀻", "	ping4",
		"䀺", "	chou1",
		"䀹", "	jie2",
		"䀸", "	chi4",
		"䁏", "	yao3",
		"䁑", "	yang2",
		"䁪", "	zhan3",
		"䁞", "	sheng3",
		"䁩", "	yu2",
		"䁨", "	huo4",
		"䁧", "	miao2",
		"䁦", "	qu4",
		"䁥", "	ni4",
		"䁤", "	che4",
		"䁣", "	chuan2",
		"䁢", "	xuan2",
		"䁠", "	lian2",
		"䁟", "	cha2",
		"䁝", "	ying2",
		"䁒", "	ji2",
		"䁜", "	huang4",
		"䁛", "	gui4",
		"䁚", "	sun3",
		"䁙", "	yan3",
		"䁘", "	yao3",
		"䁗", "	kai3",
		"䁖", "	lou1",
		"䁕", "	min2",
		"䁔", "	xuan1",
		"䁓", "	zong1",
		"䆃", "	dao4",
		"䆅", "	zi1",
		"㿉", "	tui3",
		"䊶", "	zhen4",
		"䋃", "	mao4",
		"䋂", "	yao2",
		"䋁", "	geng3",
		"䋀", "	hua4",
		"䊿", "	bo2",
		"䊾", "	mu4",
		"䊽", "	guai4",
		"䊼", "	chi3",
		"䊻", "	gan1",
		"䊺", "	hu4",
		"䊵", "	qiu2",
		"䋈", "	ru2",
		"䊴", "	qian4",
		"䊳", "	mi2",
		"䊲", "	chan4",
		"䊱", "	xian1",
		"䊰", "	chu2",
		"䊯", "	kuang4",
		"䊮", "	di2",
		"䊭", "	dao4",
		"䊬", "	chua1",
		"䊫", "	cui3",
		"䋄", "	wang3",
		"䋉", "	xue2",
		"䊩", "	fan2",
		"䋙", "	er3",
		"䋥", "	li2",
		"䋤", "	yue4",
		"䋣", "	fan2",
		"䋢", "	bie1",
		"䋠", "	bu3",
		"䋟", "	ji4",
		"䋞", "	wang3",
		"䋜", "	qing4",
		"䋛", "	mi3",
		"䋚", "	yi4",
		"䋘", "	chuo4",
		"䋊", "	zheng1",
		"䋖", "	yu4",
		"䋕", "	ren4",
		"䋔", "	bi4",
		"䋓", "	zhou4",
		"䋑", "	lie4",
		"䋐", "	yue4",
		"䋏", "	zuo2",
		"䋎", "	zhan4",
		"䋌", "	jiang3",
		"䋋", "	min2",
		"䊪", "	li4",
		"䊨", "	luo2",
		"䋧", "	qu2",
		"䉺", "	hong2",
		"䊅", "	ming2",
		"䊄", "	qiong2",
		"䊃", "	pei4",
		"䊂", "	ce4",
		"䊀", "	hu2",
		"䉿", "	hu2",
		"䉾", "	bi4",
		"䉽", "	ban3",
		"䉼", "	liao4",
		"䉻", "	qi2",
		"䉹", "	ling2",
		"䊇", "	bu4",
		"䉸", "	bian4",
		"䉷", "	yan2",
		"䉶", "	shuang1",
		"䉵", "	zhuan4",
		"䉴", "	rang2",
		"䉳", "	xian1",
		"䉲", "	mi2",
		"䉱", "	ou1",
		"䉰", "	xiao4",
		"䉯", "	xian4",
		"䊆", "	jiu4",
		"䊈", "	mei2",
		"䊧", "	bi4",
		"䊛", "	sa4",
		"䊦", "	ye4",
		"䊥", "	xiao4",
		"䊤", "	tan2",
		"䊣", "	huang2",
		"䊡", "	man2",
		"䊠", "	xi4",
		"䊟", "	men2",
		"䊞", "	zhe2",
		"䊝", "	xie4",
		"䊜", "	tuan2",
		"䊙", "	yan1",
		"䊉", "	san3",
		"䊘", "	jiu4",
		"䊗", "	huang2",
		"䊖", "	nan3",
		"䊔", "	ying2",
		"䊓", "	shi4",
		"䊑", "	xiang3",
		"䊐", "	hun2",
		"䊎", "	quan3",
		"䊍", "	li2",
		"䊊", "	wei4",
		"䋦", "	fan2",
		"䋨", "	fu3",
		"䉭", "	lie4",
		"䌫", "	lan3",
		"䌷", "	chou1",
		"䌵", "	zhu2",
		"䌴", "	luo4",
		"䌳", "	shi1",
		"䌱", "	luo4",
		"䌰", "	nie4",
		"䌯", "	quan1",
		"䌮", "	shuang1",
		"䌭", "	jiao1",
		"䌬", "	chong2",
		"䌪", "	yan3",
		"䌹", "	jiong3",
		"䌩", "	mie4",
		"䌨", "	ca1",
		"䌧", "	chou2",
		"䌦", "	dao4",
		"䌥", "	yin3",
		"䌤", "	shi1",
		"䌣", "	zuan3",
		"䌢", "	ling2",
		"䌡", "	ti3",
		"䌠", "	jian1",
		"䌸", "	juan4",
		"䌺", "	er3",
		"䌞", "	lian3",
		"䍇", "	ta4",
		"䍒", "	mou3",
		"䍑", "	han3",
		"䍐", "	han3",
		"䍎", "	cun4",
		"䍍", "	kou4",
		"䍌", "	bu4",
		"䍋", "	chui2",
		"䍊", "	jiao1",
		"䍉", "	zhai3",
		"䍈", "	ping2",
		"䍆", "	zhu4",
		"䌻", "	yi4",
		"䍅", "	ling2",
		"䍄", "	dian3",
		"䍃", "	you2",
		"䍂", "	yu2",
		"䍁", "	sui4",
		"䍀", "	lan2",
		"䌿", "	fu2",
		"䌾", "	ren2",
		"䌽", "	cai3",
		"䌼", "	rui4",
		"䌟", "	bo2",
		"䌝", "	jin1",
		"䋩", "	er2",
		"䋵", "	yi4",
		"䌀", "	ke1",
		"䋿", "	wei1",
		"䋾", "	zha3",
		"䋽", "	beng3",
		"䋼", "	ting1",
		"䋻", "	nin2",
		"䋹", "	fu2",
		"䋸", "	xun2",
		"䋷", "	mou2",
		"䋶", "	xu3",
		"䋴", "	niu4",
		"䌂", "	ou4",
		"䋳", "	bei3",
		"䋲", "	che3",
		"䋱", "	lai2",
		"䋰", "	ju2",
		"䋯", "	qi3",
		"䋮", "	jin4",
		"䋭", "	yu4",
		"䋬", "	tian1",
		"䋫", "	zheng1",
		"䋪", "	e1",
		"䌁", "	yao1",
		"䌃", "	xiao1",
		"䌜", "	nie4",
		"䌑", "	jian1",
		"䌛", "	yao2",
		"䌚", "	su1",
		"䌙", "	huang4",
		"䌘", "	bie4",
		"䌗", "	fu3",
		"䌖", "	jie2",
		"䌕", "	mi2",
		"䌔", "	ou1",
		"䌓", "	fan2",
		"䌒", "	lu4",
		"䌐", "	mi4",
		"䌄", "	geng3",
		"䌏", "	mi4",
		"䌎", "	lue4",
		"䌍", "	jin3",
		"䌌", "	qi4",
		"䌋", "	da1",
		"䌊", "	yao2",
		"䌈", "	ta1",
		"䌇", "	hui4",
		"䌆", "	gui4",
		"䌅", "	tang2",
		"䉮", "	lin4",
		"䉬", "	fei4",
		"䆈", "	zhi4",
		"䇒", "	jie4",
		"䇟", "	jian4",
		"䇞", "	gan1",
		"䇜", "	qian3",
		"䇛", "	zhi3",
		"䇙", "	yin3",
		"䇘", "	hu4",
		"䇗", "	zhong1",
		"䇖", "	yun3",
		"䇔", "	luo4",
		"䇓", "	xu1",
		"䇑", "	ba4",
		"䇡", "	zhu4",
		"䇐", "	li4",
		"䇏", "	dui4",
		"䇎", "	que4",
		"䇍", "	chu4",
		"䇌", "	qiao4",
		"䇋", "	hai4",
		"䇈", "	hua4",
		"䇇", "	meng2",
		"䇅", "	fa2",
		"䇃", "	si4",
		"䇠", "	zhu4",
		"䇢", "	ku3",
		"䇁", "	si1",
		"䇯", "	rong2",
		"䇻", "	wei3",
		"䇺", "	dou4",
		"䇹", "	jun4",
		"䇸", "	cheng2",
		"䇷", "	bie2",
		"䇶", "	jue2",
		"䇵", "	yi2",
		"䇲", "	ce4",
		"䇱", "	na4",
		"䇰", "	zheng1",
		"䇮", "	ren4",
		"䇣", "	nie4",
		"䇭", "	lao3",
		"䇬", "	zhu1",
		"䇫", "	ji1",
		"䇪", "	chi1",
		"䇩", "	yi4",
		"䇨", "	gong4",
		"䇧", "	zhi4",
		"䇦", "	ang3",
		"䇥", "	ze2",
		"䇤", "	rui4",
		"䇂", "	qian1",
		"䇀", "	rong2",
		"䇽", "	zhe2",
		"䆕", "	yue4",
		"䆟", "	ke4",
		"䆞", "	yao3",
		"䆝", "	xue4",
		"䆜", "	you4",
		"䆛", "	zha4",
		"䆚", "	tong2",
		"䆙", "	yao2",
		"䆘", "	ya1",
		"䆗", "	yao3",
		"䆖", "	hong2",
		"䆔", "	chong1",
		"䆡", "	lang2",
		"䆓", "	e4",
		"䆒", "	jiu4",
		"䆑", "	cheng2",
		"䆐", "	guo2",
		"䆏", "	fei4",
		"䆎", "	xian1",
		"䆍", "	long2",
		"䆋", "	qiu1",
		"䆊", "	cui4",
		"䆉", "	ba4",
		"䆠", "	huan4",
		"䆢", "	yue4",
		"䆿", "	yi4",
		"䆲", "	kang1",
		"䆾", "	lan2",
		"䆽", "	qu2",
		"䆻", "	qiao4",
		"䆺", "	pan1",
		"䆹", "	chong1",
		"䆸", "	zheng1",
		"䆷", "	xue4",
		"䆶", "	jiu1",
		"䆵", "	cheng2",
		"䆳", "	qiong2",
		"䆱", "	tan1",
		"䆣", "	chen2",
		"䆰", "	yu1",
		"䆯", "	zhuo2",
		"䆮", "	jin4",
		"䆭", "	xuan1",
		"䆬", "	yun3",
		"䆫", "	chuang1",
		"䆪", "	hong1",
		"䆩", "	ming2",
		"䆨", "	ning2",
		"䆦", "	shen4",
		"䇼", "	yi4",
		"䇾", "	yan2",
		"䉫", "	li2",
		"䉄", "	leng2",
		"䉏", "	xie4",
		"䉎", "	tang2",
		"䉍", "	jian3",
		"䉌", "	sui4",
		"䉋", "	mei4",
		"䉊", "	fan4",
		"䉉", "	gu1",
		"䉈", "	san3",
		"䉆", "	diao3",
		"䉅", "	zhi4",
		"䉃", "	jiang3",
		"䉑", "	wu2",
		"䉂", "	lei3",
		"䉁", "	ling2",
		"䉀", "	shu4",
		"䈿", "	mi4",
		"䈾", "	shao1",
		"䈽", "	jin1",
		"䈼", "	mie4",
		"䈻", "	pu2",
		"䈺", "	zhong1",
		"䈹", "	sou3",
		"䉐", "	ku1",
		"䉒", "	fan2",
		"䈷", "	luo4",
		"䉟", "	huo4",
		"䉪", "	lei4",
		"䉨", "	yi4",
		"䉧", "	liu2",
		"䉦", "	qian1",
		"䉥", "	song3",
		"䉤", "	sou3",
		"䉣", "	xie4",
		"䉢", "	se4",
		"䉡", "	tan2",
		"䉠", "	wei2",
		"䉞", "	dan3",
		"䉓", "	luo4",
		"䉝", "	yi3",
		"䉜", "	zhi4",
		"䉛", "	yu4",
		"䉚", "	meng2",
		"䉙", "	yun2",
		"䉘", "	cong2",
		"䉗", "	yi1",
		"䉖", "	ling2",
		"䉕", "	ceng2",
		"䉔", "	can1",
		"䈸", "	hu2",
		"䈶", "	rong2",
		"䈀", "	san1",
		"䈌", "	qu1",
		"䈗", "	suo3",
		"䈖", "	ke1",
		"䈕", "	shi2",
		"䈓", "	ge2",
		"䈒", "	nan3",
		"䈑", "	gua3",
		"䈐", "	gui4",
		"䈏", "	bao2",
		"䈎", "	ye4",
		"䈍", "	mang2",
		"䈋", "	ta4",
		"䈙", "	zhou4",
		"䈊", "	ling2",
		"䈉", "	sha4",
		"䈈", "	fei2",
		"䈇", "	zhao4",
		"䈆", "	dai4",
		"䈅", "	yu4",
		"䈄", "	han2",
		"䈃", "	zhao3",
		"䈂", "	ping2",
		"䈁", "	lun2",
		"䈘", "	ci2",
		"䈚", "	tai2",
		"䈵", "	weng1",
		"䈪", "	xi4",
		"䈴", "	qian4",
		"䈳", "	ta4",
		"䈲", "	ban1",
		"䈱", "	tao1",
		"䈰", "	shao1",
		"䈯", "	zhen1",
		"䈮", "	ju4",
		"䈭", "	sou1",
		"䈬", "	pu2",
		"䈫", "	na4",
		"䈧", "	wei3",
		"䈛", "	kuai4",
		"䈦", "	zong1",
		"䈥", "	jin1",
		"䈤", "	qian2",
		"䈣", "	zheng4",
		"䈢", "	sai3",
		"䈡", "	cong1",
		"䈠", "	huan3",
		"䈟", "	ce4",
		"䈞", "	du3",
		"䈝", "	xu1",
		"䈜", "	qin4",
		"㿊", "	can3",
		"㿇", "	xi2",
		"㯟", "	lu4",
		"㴥", "	qiao4",
		"㴯", "	zhi1",
		"㴮", "	xie4",
		"㴭", "	yao3",
		"㴬", "	xie4",
		"㴫", "	jun4",
		"㴪", "	nie4",
		"㴩", "	yong1",
		"㴨", "	zhen4",
		"㴧", "	xi1",
		"㴦", "	guan4",
		"㴝", "	li2",
		"㴲", "	si1",
		"㴜", "	bian4",
		"㴛", "	zhi4",
		"㴚", "	sui4",
		"㴙", "	zha3",
		"㴘", "	mao4",
		"㴗", "	you1",
		"㴖", "	luo4",
		"㴕", "	ji2",
		"㴔", "	xi1",
		"㴓", "	shai1",
		"㴰", "	neng2",
		"㴳", "	long3",
		"㴑", "	su4",
		"㵄", "	han4",
		"㵑", "	he4",
		"㵐", "	jue2",
		"㵏", "	cui3",
		"㵎", "	jian4",
		"㵍", "	men4",
		"㵌", "	xun2",
		"㵋", "	mi4",
		"㵊", "	na4",
		"㵆", "	gao3",
		"㵅", "	tan1",
		"㵃", "	she2",
		"㴴", "	chen2",
		"㵂", "	shu4",
		"㵀", "	zu2",
		"㴿", "	ding3",
		"㴾", "	bo2",
		"㴽", "	xie4",
		"㴼", "	su4",
		"㴸", "	shan3",
		"㴷", "	dan1",
		"㴶", "	que4",
		"㴵", "	mi4",
		"㴒", "	yi4",
		"㴐", "	mian4",
		"㵓", "	shi2",
		"㳚", "	xu4",
		"㳪", "	pi4",
		"㳩", "	tan1",
		"㳨", "	jian3",
		"㳧", "	che4",
		"㳦", "	xie4",
		"㳥", "	long4",
		"㳡", "	guo1",
		"㳠", "	ta4",
		"㳜", "	xiu1",
		"㳛", "	yu2",
		"㳙", "	xuan4",
		"㳬", "	xuan2",
		"㳘", "	chong1",
		"㳗", "	chai4",
		"㳖", "	yi1",
		"㳕", "	lan2",
		"㳔", "	dui4",
		"㳒", "	bian4",
		"㳑", "	yi4",
		"㳐", "	zha2",
		"㳏", "	shi4",
		"㳎", "	bian4",
		"㳫", "	zan3",
		"㳭", "	xian2",
		"㴏", "	wang3",
		"㳿", "	xie4",
		"㴋", "	su4",
		"㴉", "	ji3",
		"㴈", "	yin4",
		"㴇", "	she4",
		"㴆", "	jin4",
		"㴄", "	yong3",
		"㴃", "	lei4",
		"㴂", "	tan1",
		"㴁", "	yi4",
		"㴀", "	fan4",
		"㳾", "	qiang1",
		"㳮", "	niao4",
		"㳽", "	mi3",
		"㳼", "	bi4",
		"㳻", "	ze2",
		"㳺", "	you2",
		"㳹", "	wang3",
		"㳸", "	hua1",
		"㳷", "	hu1",
		"㳶", "	nou3",
		"㳵", "	ji4",
		"㳴", "	mi4",
		"㵒", "	fei4",
		"㵔", "	che3",
		"㳌", "	ya1",
		"㶤", "	chao3",
		"㶳", "	jin4",
		"㶲", "	yong4",
		"㶰", "	han2",
		"㶯", "	liu4",
		"㶭", "	you3",
		"㶬", "	mo4",
		"㶫", "	liao3",
		"㶧", "	nen4",
		"㶦", "	jin4",
		"㶥", "	gan1",
		"㶣", "	chan2",
		"㶵", "	ren4",
		"㶡", "	dai4",
		"㶠", "	yi4",
		"㶟", "	lei3",
		"㶞", "	nang3",
		"㶛", "	yu2",
		"㶚", "	ba4",
		"㶘", "	dian4",
		"㶗", "	fan4",
		"㶖", "	shu4",
		"㶕", "	jian3",
		"㶴", "	chi3",
		"㶶", "	nong2",
		"㶓", "	cang2",
		"㷇", "	hui1",
		"㷓", "	zong3",
		"㷒", "	yu2",
		"㷐", "	hui3",
		"㷏", "	yong3",
		"㷎", "	he4",
		"㷍", "	lun2",
		"㷋", "	tan2",
		"㷊", "	fen2",
		"㷉", "	wei4",
		"㷈", "	e4",
		"㷆", "	fu4",
		"㶹", "	hong4",
		"㷅", "	chao3",
		"㷄", "	hui3",
		"㷃", "	chui3",
		"㷂", "	shu4",
		"㷀", "	qiong2",
		"㶿", "	bo2",
		"㶾", "	biao1",
		"㶽", "	gua1",
		"㶼", "	ai1",
		"㶺", "	tian4",
		"㶔", "	bei4",
		"㶒", "	shan3",
		"㵕", "	shen4",
		"㵦", "	sui2",
		"㵰", "	xu4",
		"㵯", "	feng2",
		"㵮", "	chun2",
		"㵭", "	zhu3",
		"㵬", "	ying2",
		"㵫", "	ni4",
		"㵪", "	xian2",
		"㵩", "	yi4",
		"㵨", "	pi4",
		"㵧", "	ge2",
		"㵥", "	bi4",
		"㵲", "	wu3",
		"㵤", "	sha4",
		"㵣", "	ke3",
		"㵢", "	lei2",
		"㵡", "	bao2",
		"㵠", "	ku1",
		"㵞", "	chou2",
		"㵝", "	yi4",
		"㵘", "	man4",
		"㵗", "	ping2",
		"㵖", "	nv4",
		"㵱", "	piao3",
		"㵳", "	liao2",
		"㶑", "	lian4",
		"㶁", "	guo2",
		"㶏", "	yin1",
		"㶎", "	huan2",
		"㶍", "	xian3",
		"㶌", "	lian2",
		"㶉", "	xi1",
		"㶈", "	ying2",
		"㶇", "	heng2",
		"㶆", "	zhu1",
		"㶅", "	xue2",
		"㶄", "	yan2",
		"㶀", "	jiao1",
		"㵴", "	cang2",
		"㵿", "	xiao4",
		"㵾", "	qing4",
		"㵽", "	lei3",
		"㵻", "	xiu1",
		"㵺", "	pai4",
		"㵹", "	huan2",
		"㵸", "	yao4",
		"㵷", "	bian4",
		"㵶", "	zuo1",
		"㵵", "	zou4",
		"㳍", "	bu4",
		"㳋", "	qiu1",
		"㷕", "	qiu2",
		"㰬", "	xun2",
		"㰶", "	you3",
		"㰵", "	zu2",
		"㰴", "	pou3",
		"㰳", "	ya4",
		"㰲", "	yu1",
		"㰱", "	sha4",
		"㰰", "	xia1",
		"㰯", "	kou4",
		"㰮", "	shen4",
		"㰭", "	xu1",
		"㰫", "	chan1",
		"㰸", "	lian3",
		"㰪", "	gui1",
		"㰩", "	hai1",
		"㰨", "	xia1",
		"㰧", "	hai1",
		"㰦", "	qu4",
		"㰥", "	xi4",
		"㰤", "	he1",
		"㰣", "	zi1",
		"㰢", "	keng1",
		"㰡", "	xie4",
		"㰷", "	zi4",
		"㰹", "	xian1",
		"㰟", "	ji4",
		"㱆", "	xi1",
		"㱔", "	xie1",
		"㱏", "	zheng4",
		"㱎", "	kun1",
		"㱍", "	luan2",
		"㱌", "	ye2",
		"㱋", "	que4",
		"㱊", "	you1",
		"㱉", "	ye4",
		"㱈", "	jin4",
		"㱇", "	se4",
		"㱅", "	yi4",
		"㰺", "	xia4",
		"㱄", "	hei1",
		"㱃", "	yin3",
		"㱂", "	kang1",
		"㱁", "	shi4",
		"㱀", "	chi3",
		"㰿", "	xi1",
		"㰾", "	jiao4",
		"㰽", "	yan4",
		"㰼", "	sha4",
		"㰻", "	yi3",
		"㰠", "	hang1",
		"㰞", "	chi1",
		"㱗", "	xiu1",
		"㯮", "	shu2",
		"㯺", "	jian4",
		"㯹", "	biao3",
		"㯸", "	jin3",
		"㯷", "	pu2",
		"㯶", "	zong1",
		"㯳", "	qing2",
		"㯲", "	jin4",
		"㯱", "	pao1",
		"㯰", "	zhe2",
		"㯯", "	gong4",
		"㯭", "	lu3",
		"㯾", "	zao1",
		"㯬", "	lian3",
		"㯫", "	qu2",
		"㯪", "	ling2",
		"㯩", "	ti4",
		"㯦", "	qi2",
		"㯥", "	cao2",
		"㯤", "	li4",
		"㯢", "	zhen4",
		"㯡", "	pao4",
		"㯠", "	qian4",
		"㯻", "	gun3",
		"㯿", "	lie4",
		"㰝", "	yi3",
		"㰎", "	zui4",
		"㰛", "	yue4",
		"㰚", "	li2",
		"㰙", "	nuo2",
		"㰘", "	yi2",
		"㰗", "	qi2",
		"㰖", "	lan3",
		"㰔", "	xie4",
		"㰒", "	xue2",
		"㰑", "	shan1",
		"㰐", "	jue2",
		"㰍", "	long2",
		"㰀", "	li2",
		"㰌", "	que4",
		"㰋", "	pin2",
		"㰊", "	xian2",
		"㰈", "	lian3",
		"㰆", "	bei4",
		"㰅", "	di2",
		"㰄", "	jian4",
		"㰃", "	mian2",
		"㰂", "	shen3",
		"㰁", "	luo3",
		"㱖", "	cui4",
		"㱘", "	an4",
		"㳊", "	you1",
		"㲠", "	mao2",
		"㲬", "	jiao1",
		"㲫", "	pu2",
		"㲪", "	deng1",
		"㲨", "	rong2",
		"㲧", "	sao4",
		"㲦", "	han4",
		"㲥", "	tang2",
		"㲤", "	shuai1",
		"㲢", "	bian4",
		"㲡", "	nai4",
		"㲟", "	ying3",
		"㲯", "	ran2",
		"㲞", "	su1",
		"㲝", "	rong3",
		"㲜", "	tan2",
		"㲛", "	zhi3",
		"㲚", "	sha1",
		"㲘", "	qu2",
		"㲗", "	fu1",
		"㲖", "	xiao1",
		"㲕", "	lei4",
		"㲔", "	xian1",
		"㲭", "	tan3",
		"㲰", "	ning2",
		"㲒", "	bao4",
		"㲾", "	yu3",
		"㳈", "	pei4",
		"㳇", "	fu4",
		"㳆", "	tou3",
		"㳅", "	jiao3",
		"㳄", "	xian2",
		"㳃", "	cui4",
		"㳂", "	yan2",
		"㳁", "	ze4",
		"㳀", "	guo4",
		"㲿", "	wang3",
		"㲽", "	nian4",
		"㲱", "	lie4",
		"㲼", "	yi4",
		"㲻", "	ni4",
		"㲺", "	ji2",
		"㲹", "	gui3",
		"㲸", "	xi1",
		"㲷", "	dan4",
		"㲶", "	lv4",
		"㲴", "	zhong4",
		"㲳", "	die2",
		"㲲", "	die2",
		"㲓", "	rong2",
		"㲏", "	pao1",
		"㱙", "	xiu3",
		"㱦", "	qi1",
		"㱰", "	zai3",
		"㱯", "	ai2",
		"㱮", "	kuai4",
		"㱭", "	duan4",
		"㱬", "	wei3",
		"㱫", "	lan4",
		"㱪", "	men4",
		"㱩", "	du2",
		"㱨", "	lian4",
		"㱧", "	wo4",
		"㱥", "	ling2",
		"㱲", "	yi4",
		"㱤", "	xi1",
		"㱣", "	tui3",
		"㱢", "	lang2",
		"㱡", "	sheng1",
		"㱠", "	ku1",
		"㱟", "	pi1",
		"㱞", "	yi4",
		"㱜", "	zha2",
		"㱛", "	chuan3",
		"㱚", "	can2",
		"㱱", "	hui4",
		"㱳", "	mo4",
		"㲎", "	lou2",
		"㲂", "	cheng2",
		"㲍", "	zhi1",
		"㲌", "	neng4",
		"㲋", "	chuo4",
		"㲊", "	rui4",
		"㲉", "	que4",
		"㲈", "	shao2",
		"㲆", "	ling2",
		"㲅", "	ji4",
		"㲄", "	jue2",
		"㲃", "	jiu4",
		"㲁", "	kong1",
		"㱴", "	zi4",
		"㲀", "	zhen1",
		"㱿", "	que4",
		"㱾", "	gai1",
		"㱽", "	zhen3",
		"㱼", "	hai1",
		"㱻", "	luo4",
		"㱺", "	lu2",
		"㱹", "	li4",
		"㱸", "	bi4",
		"㱶", "	peng2",
		"㱵", "	fen4",
		"㷔", "	yan4",
		"㷖", "	zhao4",
		"㿆", "	guo1",
		"㼧", "	tong2",
		"㼱", "	ruan3",
		"㼰", "	pi2",
		"㼯", "	dong4",
		"㼮", "	chai1",
		"㼭", "	dian4",
		"㼬", "	xing4",
		"㼫", "	huan4",
		"㼪", "	jie2",
		"㼩", "	cheng2",
		"㼨", "	han2",
		"㼦", "	gong3",
		"㼳", "	sheng3",
		"㼥", "	tou3",
		"㼤", "	qie4",
		"㼣", "	bo2",
		"㼢", "	yi2",
		"㼡", "	shu1",
		"㼠", "	tuo2",
		"㼟", "	bo2",
		"㼞", "	peng4",
		"㼝", "	fan4",
		"㼜", "	ang4",
		"㼲", "	lie4",
		"㼴", "	ou3",
		"㼚", "	gang1",
		"㽁", "	li4",
		"㽌", "	liu4",
		"㽋", "	luo2",
		"㽊", "	xie4",
		"㽉", "	xian4",
		"㽈", "	yi4",
		"㽇", "	hu2",
		"㽆", "	dang1",
		"㽄", "	si1",
		"㽃", "	pan1",
		"㽂", "	sa4",
		"㽀", "	zheng4",
		"㼵", "	di4",
		"㼿", "	tong2",
		"㼾", "	lu4",
		"㼽", "	chuang3",
		"㼼", "	piao2",
		"㼻", "	cong2",
		"㼺", "	tang2",
		"㼹", "	kang1",
		"㼸", "	rong2",
		"㼷", "	chuan2",
		"㼶", "	yu2",
		"㼛", "	xing2",
		"㼙", "	zhou4",
		"㽏", "	gan4",
		"㻧", "	duo4",
		"㻵", "	zhan4",
		"㻲", "	lv3",
		"㻱", "	jin1",
		"㻰", "	mian3",
		"㻯", "	tu2",
		"㻮", "	can4",
		"㻭", "	se4",
		"㻬", "	tu1",
		"㻫", "	bi4",
		"㻪", "	sui4",
		"㻡", "	xue1",
		"㻷", "	ji2",
		"㻠", "	tu2",
		"㻟", "	sui2",
		"㻞", "	bin1",
		"㻝", "	la4",
		"㻗", "	bei4",
		"㻖", "	dai4",
		"㻕", "	jue2",
		"㻔", "	duo3",
		"㻓", "	zou1",
		"㻒", "	jun4",
		"㻶", "	bi3",
		"㻸", "	zen1",
		"㼘", "	wa3",
		"㼍", "	lei3",
		"㼗", "	ting2",
		"㼖", "	li4",
		"㼕", "	dang1",
		"㼔", "	wen1",
		"㼓", "	lian2",
		"㼒", "	tang3",
		"㼑", "	lian4",
		"㼐", "	pian2",
		"㼏", "	nei3",
		"㼎", "	bo2",
		"㼌", "	yu3",
		"㻹", "	xuan1",
		"㼋", "	gu1",
		"㼊", "	tun2",
		"㼉", "	zhen4",
		"㼈", "	luo2",
		"㼇", "	qiong2",
		"㼂", "	e2",
		"㻿", "	shu3",
		"㻾", "	yong1",
		"㻽", "	sui4",
		"㻺", "	li4",
		"㽎", "	tan2",
		"㽑", "	tan2",
		"㻏", "	ling2",
		"㾛", "	qin3",
		"㾥", "	chu4",
		"㾤", "	qiang1",
		"㾣", "	qin1",
		"㾢", "	ai4",
		"㾡", "	que4",
		"㾠", "	kuang2",
		"㾟", "	bu4",
		"㾞", "	you2",
		"㾝", "	che4",
		"㾜", "	qie4",
		"㾚", "	xie1",
		"㾧", "	kuo4",
		"㾙", "	xin4",
		"㾘", "	geng3",
		"㾗", "	liang4",
		"㾖", "	li3",
		"㾕", "	shen3",
		"㾔", "	lv3",
		"㾓", "	yuan1",
		"㾒", "	ru2",
		"㾑", "	da2",
		"㾐", "	li4",
		"㾦", "	pei4",
		"㾨", "	yi1",
		"㾎", "	ya1",
		"㾸", "	gao3",
		"㿅", "	xian3",
		"㿄", "	ai4",
		"㿃", "	zhi4",
		"㾿", "	lang2",
		"㾾", "	xian1",
		"㾽", "	zhui4",
		"㾼", "	tui3",
		"㾻", "	zhu4",
		"㾺", "	ma4",
		"㾹", "	chai2",
		"㾷", "	xi1",
		"㾩", "	guai1",
		"㾶", "	gu3",
		"㾵", "	ji4",
		"㾴", "	zha1",
		"㾱", "	bei4",
		"㾰", "	hu2",
		"㾯", "	hui1",
		"㾮", "	huang2",
		"㾭", "	zhou4",
		"㾫", "	pian1",
		"㾪", "	sheng3",
		"㾏", "	jie4",
		"㾍", "	nai2",
		"㽕", "	you2",
		"㽢", "	an3",
		"㽬", "	fu4",
		"㽫", "	yong1",
		"㽪", "	zeng3",
		"㽩", "	can4",
		"㽨", "	cuo2",
		"㽧", "	zi1",
		"㽦", "	xun2",
		"㽥", "	rou2",
		"㽤", "	ju2",
		"㽣", "	yu4",
		"㽡", "	bei1",
		"㽯", "	xi2",
		"㽠", "	xia2",
		"㽟", "	lie4",
		"㽞", "	liu2",
		"㽝", "	li4",
		"㽜", "	wan3",
		"㽛", "	gou1",
		"㽚", "	chi4",
		"㽙", "	jun4",
		"㽘", "	gang3",
		"㽖", "	nan2",
		"㽭", "	ruan3",
		"㽰", "	shu4",
		"㾌", "	xuan3",
		"㾁", "	shu4",
		"㾋", "	xiu1",
		"㾊", "	ji2",
		"㾉", "	ling2",
		"㾈", "	fu4",
		"㾇", "	mu4",
		"㾆", "	ran2",
		"㾅", "	zi3",
		"㾄", "	du2",
		"㾃", "	tuo2",
		"㾂", "	hai1",
		"㾀", "	qie4",
		"㽱", "	jiao3",
		"㽾", "	wu4",
		"㽽", "	gu4",
		"㽻", "	zhi1",
		"㽺", "	ji2",
		"㽹", "	fan3",
		"㽸", "	chen2",
		"㽷", "	shui4",
		"㽴", "	zhang4",
		"㽳", "	xu1",
		"㽲", "	jiao3",
		"㻑", "	ji4",
		"㻎", "	li4",
		"㷗", "	jiong3",
		"㸪", "	chun2",
		"㸵", "	gui3",
		"㸳", "	ling2",
		"㸲", "	zuo2",
		"㸱", "	tuo2",
		"㸰", "	tuo2",
		"㸯", "	ke1",
		"㸮", "	fen2",
		"㸭", "	ba1",
		"㸬", "	bei4",
		"㸫", "	qian2",
		"㸩", "	an1",
		"㸷", "	shi4",
		"㸨", "	jiu1",
		"㸧", "	ken4",
		"㸦", "	hu4",
		"㸥", "	chan4",
		"㸤", "	pian4",
		"㸣", "	ye4",
		"㸢", "	bei4",
		"㸡", "	shu1",
		"㸠", "	tiao3",
		"㸟", "	zhi1",
		"㸶", "	yan1",
		"㸸", "	hou3",
		"㸝", "	xian1",
		"㹆", "	hui1",
		"㹐", "	chong2",
		"㹏", "	jin3",
		"㹎", "	lei2",
		"㹍", "	di2",
		"㹌", "	chan3",
		"㹋", "	xiu1",
		"㹊", "	yue4",
		"㹉", "	yuan2",
		"㹈", "	li2",
		"㹇", "	he2",
		"㹅", "	zong3",
		"㸹", "	lie4",
		"㹄", "	ji4",
		"㹃", "	fei4",
		"㹂", "	qian3",
		"㹁", "	liang2",
		"㹀", "	bo2",
		"㸿", "	du2",
		"㸾", "	ren4",
		"㸽", "	bei4",
		"㸻", "	si4",
		"㸺", "	sha1",
		"㸞", "	zhe2",
		"㸜", "	kong4",
		"㹒", "	pu3",
		"㷮", "	zao1",
		"㷻", "	wu2",
		"㷹", "	zhao4",
		"㷸", "	die2",
		"㷷", "	juan3",
		"㷶", "	bei4",
		"㷵", "	mo4",
		"㷴", "	ge2",
		"㷳", "	yan4",
		"㷰", "	chi1",
		"㷯", "	beng4",
		"㷬", "	mo4",
		"㷾", "	jue2",
		"㷫", "	qing3",
		"㷪", "	cui4",
		"㷦", "	xu4",
		"㷤", "	hu4",
		"㷣", "	xing1",
		"㷢", "	zha3",
		"㷡", "	jiong3",
		"㷠", "	lin2",
		"㷟", "	tui4",
		"㷘", "	tai2",
		"㷼", "	yan4",
		"㷿", "	xian1",
		"㸛", "	shao2",
		"㸏", "	mi2",
		"㸚", "	li3",
		"㸙", "	zhe1",
		"㸘", "	wan4",
		"㸗", "	tong2",
		"㸖", "	qu1",
		"㸕", "	jue2",
		"㸓", "	mi4",
		"㸒", "	yin2",
		"㸑", "	cuan4",
		"㸐", "	ran2",
		"㸎", "	nie4",
		"㸀", "	tai2",
		"㸍", "	xi4",
		"㸌", "	huo4",
		"㸋", "	fan2",
		"㸊", "	lai4",
		"㸉", "	xie4",
		"㸇", "	zuan3",
		"㸅", "	jie2",
		"㸄", "	ji4",
		"㸃", "	dian3",
		"㸁", "	han3",
		"㹑", "	si4",
		"㹓", "	yao3",
		"㻍", "	wu2",
		"㺜", "	nong2",
		"㺦", "	lian2",
		"㺥", "	chan2",
		"㺤", "	xian1",
		"㺣", "	xi1",
		"㺢", "	huo4",
		"㺡", "	li4",
		"㺠", "	you4",
		"㺟", "	zhuo2",
		"㺞", "	yu2",
		"㺝", "	han4",
		"㺛", "	zhu4",
		"㺩", "	jiu4",
		"㺚", "	ta3",
		"㺘", "	zhan4",
		"㺗", "	chan1",
		"㺖", "	han3",
		"㺕", "	fan2",
		"㺔", "	hai4",
		"㺓", "	ze2",
		"㺒", "	xiao1",
		"㺑", "	shan1",
		"㺐", "	lao3",
		"㺨", "	si1",
		"㺪", "	pu2",
		"㺎", "	rong2",
		"㺺", "	mao4",
		"㻌", "	tu2",
		"㻋", "	la4",
		"㻊", "	mang2",
		"㻉", "	bu4",
		"㻅", "	hui4",
		"㻄", "	bao3",
		"㻃", "	qu1",
		"㻂", "	ping2",
		"㻀", "	yu2",
		"㺿", "	yi2",
		"㺹", "	bian4",
		"㺫", "	qiu2",
		"㺸", "	ping2",
		"㺷", "	xu4",
		"㺵", "	jiu2",
		"㺴", "	ba1",
		"㺳", "	mei2",
		"㺲", "	niu3",
		"㺱", "	reng2",
		"㺮", "	yu2",
		"㺭", "	zi3",
		"㺬", "	gong3",
		"㺏", "	lou2",
		"㺍", "	pin2",
		"㹔", "	jiang1",
		"㹠", "	tun2",
		"㹭", "	yi4",
		"㹬", "	shi3",
		"㹫", "	yi2",
		"㹨", "	you4",
		"㹦", "	diao1",
		"㹥", "	zhu4",
		"㹤", "	qie4",
		"㹣", "	zhong1",
		"㹢", "	jia1",
		"㹡", "	xuan2",
		"㹟", "	jue2",
		"㹱", "	que4",
		"㹞", "	yin2",
		"㹝", "	shi4",
		"㹜", "	yin2",
		"㹛", "	rao2",
		"㹚", "	ying2",
		"㹙", "	weng3",
		"㹘", "	ru4",
		"㹗", "	tao1",
		"㹖", "	huan4",
		"㹕", "	huan1",
		"㹮", "	mo4",
		"㹲", "	xiao1",
		"㺌", "	xian4",
		"㺀", "	hu1",
		"㺋", "	weng1",
		"㺊", "	yang4",
		"㺉", "	hu4",
		"㺈", "	chi1",
		"㺇", "	si1",
		"㺅", "	hou2",
		"㺄", "	yu3",
		"㺃", "	gou3",
		"㺂", "	yan2",
		"㺁", "	nao3",
		"㹿", "	zhuo2",
		"㹳", "	wu2",
		"㹾", "	piao3",
		"㹽", "	chan3",
		"㹼", "	ju2",
		"㹻", "	wo1",
		"㹺", "	ta4",
		"㹹", "	geng1",
		"㹸", "	ni2",
		"㹷", "	shi3",
		"㹶", "	ting2",
		"㹵", "	ying3",
		"㹴", "	geng1",
		"冈", "	gang1",
		"冊", "	ce4",
		"殔", "	yi4",
		"拢", "	long3",
		"括", "	kuo4",
		"拫", "	hen2",
		"拪", "	qian1",
		"择", "	ze2",
		"拨", "	bo1",
		"拧", "	ning2",
		"拦", "	lan2",
		"拥", "	yong1",
		"拤", "	qia2",
		"拣", "	jian3",
		"拡", "	kuo4",
		"拮", "	jie2",
		"拠", "	ju4",
		"拟", "	ni3",
		"拞", "	di3",
		"拝", "	bai4",
		"拜", "	bai4",
		"招", "	zhao1",
		"拚", "	pan4",
		"拙", "	zhuo1",
		"拘", "	ju1",
		"拗", "	ao3",
		"拭", "	shi4",
		"拯", "	zheng3",
		"拕", "	tuo1",
		"拼", "	pin1",
		"挆", "	duo3",
		"挅", "	duo3",
		"挄", "	kuo4",
		"挃", "	zhi4",
		"挂", "	gua4",
		"持", "	chi2",
		"挀", "	bai1",
		"拿", "	na2",
		"拾", "	shi2",
		"拽", "	zhuai1",
		"拻", "	hui1",
		"拰", "	nin3",
		"拺", "	ce4",
		"拹", "	xie2",
		"拸", "	yi2",
		"拷", "	kao3",
		"拶", "	za1",
		"拵", "	cun2",
		"拴", "	shuan1",
		"拳", "	quan2",
		"拲", "	gong3",
		"拱", "	gong3",
		"拖", "	tuo1",
		"拔", "	ba2",
		"挈", "	qie4",
		"抮", "	zhen3",
		"抸", "	jia1",
		"抷", "	pi1",
		"抶", "	chi4",
		"抵", "	di3",
		"抴", "	ye4",
		"抳", "	ni3",
		"抲", "	he1",
		"抱", "	bao4",
		"抰", "	yang1",
		"抯", "	zha1",
		"抭", "	yao3",
		"抺", "	mei4",
		"抬", "	tai2",
		"披", "	pi1",
		"抪", "	bu4",
		"抩", "	tan1",
		"抨", "	peng1",
		"抧", "	zhi3",
		"抦", "	bing3",
		"报", "	bao4",
		"护", "	hu4",
		"抣", "	yun",
		"抹", "	mo3",
		"抻", "	chen1",
		"拓", "	ta4",
		"拈", "	nian1",
		"拒", "	ju4",
		"拑", "	qian2",
		"拐", "	guai3",
		"拏", "	na2",
		"拎", "	lin1",
		"拍", "	pai1",
		"拌", "	ban4",
		"拋", "	pao1",
		"拊", "	fu3",
		"拉", "	la1",
		"拇", "	mu3",
		"押", "	ya1",
		"拆", "	chai1",
		"担", "	dan1",
		"拄", "	zhu3",
		"拃", "	zha3",
		"拂", "	fu2",
		"拁", "	jia1",
		"拀", "	chu4",
		"抿", "	min3",
		"抾", "	qu1",
		"抽", "	chou1",
		"指", "	zhi3",
		"按", "	an4",
		"抡", "	lun1",
		"捊", "	pou2",
		"捔", "	jue2",
		"捓", "	ye2",
		"捒", "	shu4",
		"捑", "	ze4",
		"捐", "	juan1",
		"捏", "	nie1",
		"捎", "	shao1",
		"捍", "	han4",
		"捌", "	ba1",
		"捋", "	lv3",
		"捉", "	zhuo1",
		"捖", "	wan2",
		"捈", "	tu2",
		"捇", "	huo4",
		"捆", "	kun3",
		"捅", "	tong3",
		"捄", "	jiu4",
		"捃", "	jun4",
		"捂", "	wu3",
		"捁", "	jiao3",
		"捀", "	feng2",
		"挿", "	cha1",
		"捕", "	bu3",
		"捗", "	bu4",
		"挽", "	wan3",
		"捤", "	wei",
		"据", "	ju4",
		"捭", "	bai3",
		"捬", "	fu3",
		"捫", "	men2",
		"捪", "	min2",
		"捩", "	lie4",
		"捨", "	she3",
		"捧", "	peng3",
		"捦", "	qin2",
		"捥", "	wan4",
		"捣", "	dao3",
		"捘", "	zun4",
		"换", "	huan4",
		"捡", "	jian3",
		"捠", "	bang1",
		"损", "	sun3",
		"捞", "	lao1",
		"捝", "	tuo1",
		"捜", "	sou1",
		"捛", "	lv3",
		"捚", "	zhai1",
		"捙", "	yi4",
		"挾", "	xie2",
		"挼", "	rua2",
		"挊", "	nong4",
		"挖", "	wa1",
		"挠", "	nao2",
		"挟", "	xie2",
		"挞", "	ta4",
		"挝", "	wo1",
		"挜", "	ya4",
		"挛", "	luan2",
		"挚", "	zhi4",
		"挙", "	ju3",
		"挘", "	lie",
		"挗", "	jue2",
		"挕", "	die2",
		"挢", "	jiao3",
		"挔", "	lv3",
		"挓", "	zha1",
		"挒", "	lie4",
		"挑", "	tiao1",
		"挐", "	na2",
		"挏", "	dong4",
		"挎", "	kua4",
		"挍", "	jiao4",
		"挌", "	ge2",
		"挋", "	zhen4",
		"挡", "	dang3",
		"挣", "	zheng1",
		"挻", "	shan1",
		"挰", "	cheng2",
		"挺", "	ting3",
		"挹", "	yi4",
		"挸", "	jian3",
		"挷", "	peng2",
		"挶", "	ju1",
		"挵", "	long4",
		"挴", "	mei3",
		"挳", "	keng1",
		"挲", "	sa1",
		"挱", "	sa1",
		"振", "	zhen4",
		"挤", "	ji3",
		"挮", "	ti3",
		"挭", "	geng3",
		"挬", "	bo2",
		"挫", "	cuo4",
		"挪", "	nuo2",
		"挩", "	tuo1",
		"挨", "	ai1",
		"挧", "	yu",
		"挦", "	xian2",
		"挥", "	hui1",
		"抢", "	qiang3",
		"抠", "	kou1",
		"捰", "	wo3",
		"戒", "	jie4",
		"戜", "	die2",
		"戛", "	jia2",
		"戚", "	qi1",
		"戙", "	dong4",
		"战", "	zhan4",
		"戗", "	qiang1",
		"或", "	huo4",
		"戕", "	qiang1",
		"戔", "	jian1",
		"戓", "	ge1",
		"我", "	wo3",
		"戞", "	jia2",
		"成", "	cheng2",
		"戏", "	xi4",
		"戎", "	rong2",
		"戍", "	shu4",
		"戌", "	xu1",
		"戋", "	jian1",
		"戊", "	wu4",
		"戉", "	yue4",
		"戈", "	ge1",
		"戇", "	zhuang4",
		"戝", "	zei2",
		"戟", "	ji3",
		"戅", "	gang4",
		"戬", "	jian3",
		"戶", "	hu4",
		"戵", "	qu2",
		"戴", "	dai4",
		"戳", "	chuo1",
		"戲", "	xi4",
		"戱", "	xi4",
		"戰", "	zhan4",
		"戯", "	hu1",
		"戮", "	lu4",
		"戭", "	yan3",
		"戫", "	yu4",
		"戠", "	zhi1",
		"截", "	jie2",
		"戩", "	jian3",
		"戨", "	ge1",
		"戧", "	qiang1",
		"戦", "	zhan4",
		"戥", "	deng3",
		"戤", "	gai4",
		"戣", "	kui2",
		"戢", "	ji2",
		"戡", "	kan1",
		"戆", "	gang4",
		"戄", "	jue2",
		"戸", "	hu4",
		"懞", "	meng2",
		"懨", "	yan1",
		"懧", "	nuo4",
		"懦", "	nuo4",
		"懥", "	zhi4",
		"懤", "	chou2",
		"懣", "	men4",
		"懢", "	lan2",
		"懡", "	mo3",
		"懠", "	qi2",
		"懟", "	dui4",
		"懝", "	ai4",
		"懪", "	bo2",
		"懜", "	meng3",
		"懛", "	dai1",
		"懚", "	yin4",
		"懙", "	yu3",
		"懘", "	chi4",
		"懗", "	xia4",
		"懖", "	kuo4",
		"懕", "	yan1",
		"懔", "	lin3",
		"懓", "	ai4",
		"懩", "	yang3",
		"懫", "	zhi4",
		"戃", "	tang3",
		"懸", "	xuan2",
		"戂", "	mi2",
		"戁", "	nan3",
		"戀", "	lian4",
		"懿", "	yi4",
		"懾", "	she4",
		"懽", "	huan1",
		"懼", "	ju4",
		"懻", "	ji4",
		"懺", "	chan4",
		"懹", "	rang4",
		"懷", "	huai2",
		"懬", "	kuang4",
		"懶", "	lan3",
		"懵", "	meng3",
		"懴", "	chan4",
		"懳", "	hui",
		"懲", "	cheng2",
		"懱", "	mie4",
		"懰", "	liu2",
		"懯", "	fu1",
		"懮", "	you3",
		"懭", "	kuang3",
		"户", "	hu4",
		"戹", "	e4",
		"抟", "	tuan2",
		"扺", "	zhi3",
		"抄", "	chao1",
		"抃", "	bian4",
		"抂", "	kuang2",
		"抁", "	yan3",
		"技", "	ji4",
		"承", "	cheng2",
		"找", "	zhao3",
		"扽", "	den4",
		"扼", "	e4",
		"扻", "	zhi4",
		"批", "	pi1",
		"抆", "	wen3",
		"扸", "	xi1",
		"扷", "	ao4",
		"扶", "	fu2",
		"扵", "	yu2",
		"扴", "	jia2",
		"扳", "	ban1",
		"扲", "	qian2",
		"扱", "	xi1",
		"扰", "	rao3",
		"扯", "	che3",
		"抅", "	ju1",
		"抇", "	hu2",
		"扭", "	niu3",
		"抔", "	pou2",
		"択", "	ze2",
		"抝", "	ao3",
		"抜", "	ba2",
		"抛", "	pao1",
		"抚", "	fu3",
		"抙", "	pou2",
		"折", "	zhe2",
		"抗", "	kang4",
		"抖", "	dou3",
		"投", "	tou2",
		"抓", "	zhua1",
		"抈", "	yue4",
		"抒", "	shu1",
		"抑", "	yi4",
		"抐", "	ne4",
		"抏", "	wan2",
		"抎", "	yun3",
		"抍", "	zheng3",
		"抌", "	dan3",
		"抋", "	qin4",
		"把", "	ba3",
		"抉", "	jue2",
		"扮", "	ban4",
		"扬", "	yang2",
		"戺", "	shi4",
		"扆", "	yi3",
		"扐", "	le4",
		"扏", "	qiu2",
		"扎", "	zha1",
		"才", "	cai2",
		"扌", "	shou",
		"手", "	shou3",
		"扊", "	yan3",
		"扉", "	fei1",
		"扈", "	hu4",
		"扇", "	shan4",
		"扅", "	yi2",
		"扒", "	ba1",
		"扄", "	shang3",
		"扃", "	jiong1",
		"扂", "	dian4",
		"扁", "	bian3",
		"所", "	suo3",
		"房", "	fang2",
		"戾", "	li4",
		"戽", "	hu4",
		"戼", "	mao3",
		"戻", "	ti4",
		"扑", "	pu1",
		"打", "	da3",
		"扫", "	sao3",
		"扠", "	cha1",
		"扪", "	men2",
		"扩", "	kuo4",
		"扨", "	ren4",
		"执", "	zhi2",
		"扦", "	qian1",
		"扥", "	den4",
		"扤", "	wu4",
		"扣", "	kou4",
		"扢", "	gu3",
		"扡", "	tuo1",
		"扟", "	shen1",
		"扔", "	reng1",
		"扞", "	gan3",
		"扝", "	ku1",
		"扜", "	yu1",
		"扛", "	kang2",
		"扚", "	diao3",
		"扙", "	zhang4",
		"托", "	tuo1",
		"扗", "	zai4",
		"扖", "	ru",
		"払", "	fan3",
		"捯", "	dao2",
		"捱", "	ai2",
		"懑", "	men4",
		"撃", "	ji2",
		"撍", "	zan3",
		"撌", "	gui4",
		"撋", "	ruan2",
		"撊", "	xian4",
		"撉", "	dun1",
		"撈", "	lao1",
		"撇", "	pie1",
		"撆", "	pie1",
		"撅", "	jue1",
		"撄", "	ying1",
		"撂", "	liao4",
		"撏", "	xian2",
		"撁", "	qian1",
		"撀", "	gou4",
		"摿", "	yin1",
		"摾", "	jiang4",
		"摽", "	biao1",
		"摼", "	keng1",
		"摻", "	can4",
		"摺", "	zhe2",
		"摹", "	mo2",
		"摸", "	mo1",
		"撎", "	yi4",
		"撐", "	cheng1",
		"摶", "	tuan2",
		"撝", "	hui1",
		"撧", "	jue1",
		"撦", "	che3",
		"撥", "	bo1",
		"撤", "	che4",
		"撣", "	dan3",
		"撢", "	dan3",
		"撡", "	cao1",
		"撠", "	ji3",
		"撟", "	jiao3",
		"撞", "	zhuang4",
		"撜", "	zheng3",
		"撑", "	cheng1",
		"撛", "	lin3",
		"撚", "	nian3",
		"撙", "	zun3",
		"撘", "	da1",
		"撗", "	guang4",
		"撖", "	han4",
		"撕", "	si1",
		"撔", "	hong4",
		"撓", "	nao2",
		"撒", "	sa1",
		"摷", "	jiao3",
		"摵", "	she4",
		"撩", "	liao1",
		"摏", "	chong1",
		"摙", "	lian3",
		"摘", "	zhai1",
		"摗", "	sou1",
		"摖", "	qi4",
		"摕", "	di4",
		"摔", "	shuai1",
		"摓", "	feng2",
		"摒", "	bing3",
		"摑", "	guai1",
		"摐", "	chuang1",
		"摎", "	jiu1",
		"摛", "	chi1",
		"摍", "	suo1",
		"摌", "	chan3",
		"摋", "	sa4",
		"摊", "	tan1",
		"摉", "	sou1",
		"摈", "	bin4",
		"摇", "	yao2",
		"摆", "	bai3",
		"摅", "	shu1",
		"摄", "	she4",
		"摚", "	cheng1",
		"摜", "	guan4",
		"摴", "	chu1",
		"摩", "	mo2",
		"摳", "	kou1",
		"摲", "	chan4",
		"摱", "	man4",
		"摰", "	nie4",
		"摯", "	zhi4",
		"摮", "	ao2",
		"摭", "	zhi2",
		"摬", "	ying3",
		"摫", "	gui1",
		"摪", "	jiang1",
		"摨", "	nai2",
		"摝", "	lu4",
		"摧", "	cui1",
		"摦", "	hua4",
		"摥", "	tang4",
		"摤", "	chuang3",
		"摣", "	zha1",
		"摢", "	hu4",
		"摡", "	gai4",
		"摠", "	zong3",
		"摟", "	lou3",
		"摞", "	luo4",
		"撨", "	fu3",
		"撪", "	ben4",
		"摂", "	she4",
		"擫", "	ye4",
		"擵", "	mo2",
		"擴", "	kuo4",
		"擳", "	zhi4",
		"擲", "	zhi4",
		"擱", "	ge1",
		"擰", "	ning2",
		"擯", "	bin4",
		"擮", "	ji2",
		"擭", "	wo4",
		"擬", "	ni3",
		"擪", "	ye4",
		"擷", "	xie2",
		"擩", "	ru3",
		"擨", "	ye2",
		"擧", "	ju3",
		"擦", "	ca1",
		"擥", "	lan3",
		"擤", "	xing3",
		"擣", "	dao3",
		"擢", "	zhuo2",
		"擡", "	tai2",
		"擠", "	ji3",
		"擶", "	jian4",
		"擸", "	lie4",
		"擞", "	sou3",
		"攅", "	zan3",
		"攏", "	long3",
		"攎", "	lu2",
		"攍", "	ying2",
		"攌", "	huan3",
		"攋", "	la4",
		"攊", "	li4",
		"攉", "	huo1",
		"攈", "	jun4",
		"攇", "	xian3",
		"攆", "	nian3",
		"攄", "	shu1",
		"擹", "	tan1",
		"攃", "	ca1",
		"攂", "	lei4",
		"攁", "	yang3",
		"攀", "	pan1",
		"擿", "	ti1",
		"擾", "	rao3",
		"擽", "	lue4",
		"擼", "	lu3",
		"擻", "	sou3",
		"擺", "	bai3",
		"擟", "	mi2",
		"擝", "	meng",
		"撫", "	fu3",
		"撷", "	xie2",
		"擁", "	yong1",
		"擀", "	gan3",
		"撿", "	jian3",
		"撾", "	wo1",
		"撽", "	qiao4",
		"撼", "	han4",
		"撻", "	ta4",
		"撺", "	cuan1",
		"撹", "	jiao3",
		"撸", "	lu1",
		"撶", "	hua2",
		"擃", "	nang3",
		"撵", "	nian3",
		"撴", "	dun1",
		"撳", "	qin4",
		"撲", "	pu1",
		"撱", "	wei3",
		"撰", "	zhuan4",
		"撯", "	zhuo2",
		"撮", "	cuo1",
		"播", "	bo1",
		"撬", "	qiao4",
		"擂", "	lei2",
		"擄", "	lu3",
		"擜", "	e4",
		"擑", "	jie1",
		"擛", "	ye4",
		"據", "	ju4",
		"擙", "	ao4",
		"擘", "	bai1",
		"擗", "	pi3",
		"擖", "	ka1",
		"擕", "	xie2",
		"擔", "	dan1",
		"擓", "	kuai3",
		"擒", "	qin2",
		"擐", "	huan4",
		"擅", "	shan4",
		"擏", "	qing2",
		"擎", "	qing2",
		"操", "	cao1",
		"擌", "	se4",
		"擋", "	dang3",
		"擊", "	ji1",
		"擉", "	chuo4",
		"擈", "	pu1",
		"擇", "	ze2",
		"擆", "	zhuo2",
		"摃", "	kang2",
		"摁", "	en4",
		"捲", "	juan3",
		"掲", "	jie1",
		"掼", "	guan4",
		"掻", "	sao1",
		"掺", "	can4",
		"掹", "	meng",
		"掸", "	dan3",
		"掷", "	zhi4",
		"掶", "	geng",
		"掵", "	ming",
		"掴", "	guai1",
		"掳", "	lu3",
		"掱", "	pa2",
		"掾", "	yuan4",
		"掰", "	bai1",
		"掯", "	ken4",
		"掮", "	qian2",
		"掭", "	tian4",
		"掬", "	ju1",
		"掫", "	zhou1",
		"措", "	cuo4",
		"掩", "	yan3",
		"推", "	tui1",
		"控", "	kong4",
		"掽", "	peng4",
		"掿", "	nuo4",
		"接", "	jie1",
		"揌", "	sai1",
		"揖", "	yi1",
		"揕", "	zhen4",
		"揔", "	zong3",
		"揓", "	shi4",
		"插", "	cha1",
		"揑", "	nie1",
		"提", "	ti2",
		"描", "	miao2",
		"揎", "	xuan1",
		"揍", "	zou4",
		"揋", "	wei1",
		"揀", "	jian3",
		"揊", "	pi4",
		"揉", "	rou2",
		"揈", "	hong1",
		"揇", "	nan3",
		"揆", "	kui2",
		"揅", "	yan2",
		"揄", "	yu2",
		"揃", "	jian3",
		"揂", "	jiu1",
		"揁", "	zheng1",
		"掦", "	ti4",
		"掤", "	bing1",
		"揘", "	yong2",
		"捾", "	wo4",
		"授", "	shou4",
		"掇", "	duo1",
		"掆", "	gang1",
		"掅", "	qing4",
		"掄", "	lun1",
		"掃", "	sao3",
		"掂", "	dian1",
		"掁", "	cheng2",
		"掀", "	xian1",
		"捿", "	xi1",
		"捽", "	zuo2",
		"掊", "	pou2",
		"捼", "	ruo2",
		"捻", "	nian3",
		"捺", "	na4",
		"捹", "	ben4",
		"捸", "	tu1",
		"捷", "	jie2",
		"捶", "	chui2",
		"捵", "	chen1",
		"捴", "	zong3",
		"捳", "	yue4",
		"掉", "	diao4",
		"掋", "	di3",
		"掣", "	che4",
		"掘", "	jue2",
		"探", "	tan4",
		"採", "	cai3",
		"掠", "	lue4",
		"掟", "	zheng3",
		"掞", "	shan4",
		"掝", "	huo4",
		"掜", "	yi4",
		"掛", "	gua4",
		"掚", "	liang3",
		"掙", "	zheng1",
		"掗", "	ya4",
		"掌", "	zhang3",
		"掖", "	ye1",
		"掕", "	ling2",
		"掔", "	qian1",
		"掓", "	shu1",
		"排", "	pai2",
		"掑", "	qi2",
		"掐", "	qia1",
		"掏", "	tao1",
		"掎", "	ji3",
		"掍", "	hun4",
		"揗", "	xun2",
		"揙", "	bian1",
		"摀", "	wu3",
		"搛", "	jian1",
		"搥", "	chui2",
		"搤", "	e4",
		"搣", "	mie4",
		"搢", "	jin4",
		"搡", "	sang3",
		"搠", "	shuo4",
		"搟", "	xian3",
		"搞", "	gao3",
		"搝", "	qiu3",
		"搜", "	sou1",
		"搚", "	la1",
		"搧", "	shan1",
		"搙", "	nu4",
		"搘", "	zhi1",
		"搗", "	dao3",
		"搖", "	yao2",
		"搕", "	ke1",
		"搔", "	sao1",
		"搓", "	cuo1",
		"搒", "	bang4",
		"搑", "	rong2",
		"搐", "	chu4",
		"搦", "	nuo4",
		"搨", "	ta4",
		"搎", "	sun1",
		"搵", "	wen4",
		"搿", "	ge2",
		"搾", "	zha4",
		"搽", "	cha2",
		"搼", "	quan2",
		"搻", "	nuo4",
		"携", "	xie2",
		"搹", "	e4",
		"搸", "	zhen1",
		"搷", "	tian2",
		"搶", "	qiang3",
		"搴", "	qian1",
		"搩", "	zha3",
		"搳", "	hua2",
		"搲", "	wa1",
		"搱", "	zhi4",
		"搰", "	hu2",
		"搯", "	tao1",
		"搮", "	li4",
		"搭", "	da1",
		"搬", "	ban1",
		"搫", "	pan2",
		"搪", "	tang2",
		"搏", "	bo2",
		"損", "	sun3",
		"揚", "	yang2",
		"揦", "	la2",
		"揰", "	chong4",
		"揯", "	gen4",
		"揮", "	hui1",
		"揭", "	jie1",
		"揬", "	tu2",
		"揫", "	jiu1",
		"揪", "	jiu1",
		"揩", "	kai1",
		"揨", "	chen2",
		"揧", "	la4",
		"揥", "	ti4",
		"揲", "	die2",
		"揤", "	ji2",
		"揣", "	chuai1",
		"揢", "	ke2",
		"握", "	wo4",
		"揠", "	ya4",
		"揟", "	xu1",
		"揞", "	an3",
		"揝", "	zan3",
		"揜", "	yan3",
		"換", "	huan4",
		"揱", "	xiao1",
		"揳", "	xie1",
		"搌", "	zhan3",
		"搁", "	ge1",
		"搋", "	chuai1",
		"搊", "	chou1",
		"搉", "	que4",
		"搈", "	rong2",
		"搇", "	qin4",
		"搆", "	gou4",
		"搅", "	jiao3",
		"搄", "	geng1",
		"搃", "	zong3",
		"搂", "	lou3",
		"搀", "	chan1",
		"援", "	yuan2",
		"揿", "	qin4",
		"揾", "	wen4",
		"揽", "	lan3",
		"揼", "	beng",
		"揻", "	wei1",
		"揺", "	yao2",
		"揹", "	bei1",
		"揸", "	zha1",
		"揷", "	cha1",
		"揶", "	ye2",
		"揵", "	qian2",
		"懒", "	lan3",
		"懐", "	huai2",
		"攑", "	qian1",
		"御", "	yu4",
		"徫", "	wei3",
		"循", "	xun2",
		"復", "	fu4",
		"徨", "	huang2",
		"徧", "	bian4",
		"徦", "	jia3",
		"徥", "	shi4",
		"徤", "	jian4",
		"徣", "	jie4",
		"徢", "	xie4",
		"徠", "	lai2",
		"徭", "	yao2",
		"徟", "	zhou1",
		"從", "	cong2",
		"徝", "	zhi4",
		"徜", "	chang2",
		"徛", "	ji4",
		"徚", "	dong1",
		"徙", "	xi3",
		"徘", "	pai2",
		"得", "	de2",
		"徖", "	cong2",
		"徬", "	pang2",
		"微", "	wei1",
		"徔", "	zhi",
		"徻", "	hui4",
		"必", "	bi4",
		"忄", "	xin",
		"心", "	xin1",
		"忂", "	qu2",
		"忁", "	bao4",
		"忀", "	xiang1",
		"徿", "	long4",
		"徾", "	mei2",
		"徽", "	hui1",
		"徼", "	jiao3",
		"徺", "	jiao3",
		"徯", "	xi1",
		"徹", "	che4",
		"徸", "	chong1",
		"德", "	de2",
		"徶", "	bie2",
		"徵", "	zheng1",
		"徴", "	zheng1",
		"徳", "	de2",
		"徲", "	ti2",
		"徱", "	piao4",
		"徰", "	zheng1",
		"徕", "	lai2",
		"従", "	cong2",
		"忇", "	le4",
		"彭", "	peng2",
		"彷", "	fang3",
		"彶", "	ji2",
		"彵", "	tuo3",
		"彴", "	zhuo2",
		"彳", "	chi4",
		"彲", "	chi1",
		"影", "	ying3",
		"彰", "	zhang1",
		"彯", "	piao3",
		"彮", "	yong3",
		"彬", "	bin1",
		"役", "	yi4",
		"彫", "	diao1",
		"彪", "	biao1",
		"彩", "	cai3",
		"彨", "	chi1",
		"彧", "	yu4",
		"彦", "	yan4",
		"彥", "	yan4",
		"彤", "	tong2",
		"彣", "	wen2",
		"形", "	xing2",
		"彸", "	zhong1",
		"彺", "	wang2",
		"徒", "	tu2",
		"徇", "	xun4",
		"徑", "	jing4",
		"徐", "	xu2",
		"徏", "	zhi4",
		"徎", "	cheng3",
		"徍", "	wang3",
		"後", "	hou4",
		"律", "	lv4",
		"徊", "	huai2",
		"徉", "	yang2",
		"很", "	hen3",
		"徆", "	xi1",
		"彻", "	che4",
		"待", "	dai4",
		"径", "	jing4",
		"徃", "	wang3",
		"徂", "	cu2",
		"征", "	zheng1",
		"往", "	wang3",
		"彿", "	fu2",
		"彾", "	ling2",
		"彽", "	di1",
		"彼", "	bi3",
		"忆", "	yi4",
		"忈", "	ren2",
		"彠", "	yue1",
		"怉", "	bao3",
		"怓", "	nao2",
		"怒", "	nu4",
		"怑", "	ban4",
		"怐", "	ju4",
		"怏", "	yang4",
		"怎", "	zen3",
		"怍", "	zuo4",
		"怌", "	pei1",
		"怋", "	min2",
		"怊", "	chao1",
		"怈", "	yi4",
		"怕", "	pa4",
		"怇", "	ju4",
		"怆", "	chuang4",
		"怅", "	chang4",
		"怄", "	ou4",
		"怃", "	wu3",
		"怂", "	song3",
		"态", "	tai4",
		"怀", "	huai2",
		"忿", "	fen4",
		"忾", "	kai4",
		"怔", "	zheng1",
		"怖", "	bu4",
		"忼", "	kang1",
		"怣", "	you2",
		"怭", "	bi4",
		"怬", "	xi4",
		"怫", "	fu2",
		"怪", "	guai4",
		"怩", "	ni2",
		"怨", "	yuan4",
		"性", "	xing4",
		"怦", "	peng1",
		"急", "	ji2",
		"怤", "	fu1",
		"怢", "	tu1",
		"怗", "	tie1",
		"怡", "	yi2",
		"怠", "	dai4",
		"怟", "	di4",
		"怞", "	chou2",
		"思", "	si1",
		"怜", "	lian2",
		"怛", "	da2",
		"怚", "	ju4",
		"怙", "	hu4",
		"怘", "	hu4",
		"忽", "	hu1",
		"忻", "	xin1",
		"忉", "	dao1",
		"忕", "	shi4",
		"忟", "	wen3",
		"忞", "	min2",
		"忝", "	tian3",
		"応", "	ying1",
		"忛", "	fan2",
		"忚", "	xi1",
		"忙", "	mang2",
		"忘", "	wang4",
		"志", "	zhi4",
		"忖", "	cun3",
		"忔", "	qi4",
		"忡", "	chong1",
		"忓", "	gan1",
		"忒", "	te4",
		"忑", "	te4",
		"忐", "	tan3",
		"忏", "	chan4",
		"忎", "	ren2",
		"忍", "	ren3",
		"忌", "	ji4",
		"忋", "	gai3",
		"忊", "	ding4",
		"忠", "	zhong1",
		"忢", "	wu4",
		"忺", "	xian1",
		"忯", "	qi2",
		"忹", "	kuang2",
		"忸", "	niu3",
		"忷", "	xiong1",
		"忶", "	hun2",
		"念", "	nian4",
		"忴", "	qian2",
		"忳", "	tun2",
		"忲", "	tai4",
		"忱", "	chen2",
		"忰", "	cui4",
		"忮", "	zhi4",
		"忣", "	ji2",
		"忭", "	bian4",
		"忬", "	yu4",
		"快", "	kuai4",
		"忪", "	song1",
		"忩", "	cong1",
		"忨", "	wan4",
		"忧", "	you1",
		"忦", "	jia2",
		"忥", "	xi4",
		"忤", "	wu3",
		"彡", "	shan1",
		"彟", "	yue1",
		"怯", "	qie4",
		"廑", "	jin3",
		"廛", "	chan2",
		"廚", "	chu2",
		"廙", "	yi4",
		"廘", "	lu4",
		"廗", "	dai4",
		"廖", "	liao4",
		"廕", "	yin4",
		"廔", "	lou2",
		"廓", "	kuo4",
		"廒", "	ao2",
		"廐", "	jiu4",
		"廝", "	si1",
		"廏", "	jiu4",
		"廎", "	qing3",
		"廍", "	pou3",
		"廌", "	zhi4",
		"廋", "	sou1",
		"廊", "	lang2",
		"廉", "	lian2",
		"廈", "	sha4",
		"廇", "	liu4",
		"廆", "	gui1",
		"廜", "	tu2",
		"廞", "	xin1",
		"廄", "	jiu4",
		"廫", "	liao2",
		"廵", "	xun2",
		"廴", "	yin3",
		"廳", "	ting1",
		"廲", "	li2",
		"廱", "	yong1",
		"廰", "	ting1",
		"廯", "	xian1",
		"廮", "	ying3",
		"廭", "	ji",
		"廬", "	lu2",
		"廪", "	lin3",
		"廟", "	miao4",
		"廩", "	lin3",
		"廨", "	xie4",
		"廧", "	qiang2",
		"廦", "	bi4",
		"廥", "	kuai4",
		"廤", "	ku4",
		"廣", "	guang3",
		"廢", "	fei4",
		"廡", "	wu3",
		"廠", "	chang3",
		"廅", "	e4",
		"廃", "	fei4",
		"廷", "	ting2",
		"庝", "	tong2",
		"座", "	zuo4",
		"度", "	du4",
		"庥", "	xiu1",
		"庤", "	zhi4",
		"庣", "	tiao1",
		"庢", "	zhi4",
		"庡", "	yi3",
		"庠", "	xiang2",
		"废", "	fei4",
		"庞", "	pang2",
		"府", "	fu3",
		"庩", "	tu2",
		"庛", "	ci4",
		"庚", "	geng1",
		"庙", "	miao4",
		"庘", "	ya1",
		"店", "	dian4",
		"庖", "	pao2",
		"底", "	di3",
		"应", "	ying1",
		"库", "	ku4",
		"庒", "	zhuang",
		"庨", "	xiao1",
		"庪", "	gui3",
		"廂", "	xiang1",
		"康", "	kang1",
		"廁", "	ce4",
		"廀", "	sou1",
		"庿", "	miao4",
		"庾", "	yu3",
		"庽", "	yu4",
		"庼", "	qing3",
		"庻", "	shu4",
		"庺", "	song1",
		"庹", "	tuo3",
		"庸", "	yong1",
		"庶", "	shu4",
		"庫", "	ku4",
		"庵", "	an1",
		"庴", "	ji2",
		"庳", "	bi4",
		"庲", "	lai2",
		"庱", "	cheng3",
		"庰", "	bing4",
		"庯", "	bu1",
		"庮", "	you3",
		"庭", "	ting2",
		"庬", "	mang2",
		"延", "	yan2",
		"廸", "	di2",
		"彞", "	yi2",
		"弹", "	dan4",
		"彃", "	bi4",
		"彂", "	fa1",
		"彁", "	ge",
		"彀", "	gou4",
		"弿", "	jian3",
		"弾", "	dan4",
		"弽", "	she4",
		"弼", "	bi4",
		"弻", "	bi4",
		"强", "	qiang2",
		"弸", "	peng2",
		"彅", "	jian",
		"強", "	qiang2",
		"弶", "	jiang4",
		"張", "	zhang1",
		"弴", "	diao1",
		"弳", "	jing4",
		"弲", "	xuan1",
		"弱", "	ruo4",
		"弰", "	shao1",
		"弯", "	wan1",
		"弮", "	quan1",
		"彄", "	kou1",
		"彆", "	bie4",
		"弬", "	yi2",
		"当", "	dang1",
		"彝", "	yi2",
		"彜", "	yi2",
		"彛", "	yi2",
		"彚", "	hui4",
		"彙", "	hui4",
		"彘", "	zhi4",
		"彗", "	hui4",
		"彖", "	tuan4",
		"录", "	lu4",
		"彔", "	lu4",
		"归", "	gui1",
		"彇", "	xiao1",
		"彑", "	ji4",
		"彐", "	ji4",
		"彏", "	jue2",
		"彎", "	wan1",
		"彍", "	guo1",
		"彌", "	mi2",
		"彋", "	hong2",
		"彊", "	jiang4",
		"彉", "	guo1",
		"彈", "	dan4",
		"弭", "	mi3",
		"弫", "	zhen3",
		"廹", "	pai3",
		"弅", "	fen4",
		"式", "	shi4",
		"弎", "	san1",
		"弍", "	er4",
		"弌", "	yi1",
		"弋", "	yi4",
		"弊", "	bi4",
		"弉", "	zang4",
		"弈", "	yi4",
		"弇", "	yan3",
		"弆", "	ju3",
		"弄", "	nong4",
		"弑", "	shi4",
		"弃", "	qi4",
		"异", "	yi4",
		"弁", "	bian4",
		"开", "	kai1",
		"廿", "	nian4",
		"廾", "	gong3",
		"廽", "	hui2",
		"廼", "	nai3",
		"廻", "	hui2",
		"建", "	jian4",
		"弐", "	er4",
		"弒", "	shi4",
		"弪", "	jing4",
		"弟", "	di4",
		"弩", "	nu3",
		"弨", "	chao1",
		"弧", "	hu2",
		"弦", "	xian2",
		"弥", "	mi2",
		"弤", "	di3",
		"弣", "	fu3",
		"弢", "	tao1",
		"弡", "	jue2",
		"张", "	zhang1",
		"弞", "	shen3",
		"弓", "	gong1",
		"弝", "	ba4",
		"弜", "	jiang4",
		"弛", "	chi2",
		"弚", "	tui2",
		"弙", "	wu1",
		"弘", "	hong2",
		"弗", "	fu2",
		"弖", "	hu4",
		"引", "	yin3",
		"弔", "	diao4",
		"怮", "	you1",
		"怰", "	xuan4",
		"懏", "	jun4",
		"慂", "	yong3",
		"慌", "	huang1",
		"態", "	tai4",
		"慊", "	qian4",
		"慉", "	xu4",
		"慈", "	ci2",
		"慇", "	yin1",
		"慆", "	tao1",
		"慅", "	sao1",
		"慄", "	li4",
		"慃", "	yang3",
		"慁", "	hun4",
		"慎", "	shen4",
		"慀", "	xi4",
		"愿", "	yuan4",
		"愾", "	kai4",
		"愽", "	bo2",
		"愼", "	shen4",
		"愻", "	xun4",
		"愺", "	cao3",
		"愹", "	yong3",
		"愸", "	zheng3",
		"愷", "	kai3",
		"慍", "	yun4",
		"慏", "	ming3",
		"愵", "	ni4",
		"慜", "	min3",
		"慦", "	jiu4",
		"慥", "	zao4",
		"慤", "	que4",
		"慣", "	guan4",
		"慢", "	man4",
		"慡", "	shuang3",
		"慠", "	ao4",
		"慟", "	tong4",
		"慞", "	zhang1",
		"慝", "	te4",
		"慛", "	cui1",
		"慐", "	gong",
		"慚", "	can2",
		"慙", "	can2",
		"慘", "	can3",
		"慗", "	chi4",
		"慖", "	guo2",
		"慕", "	mu4",
		"慔", "	mu4",
		"慓", "	piao1",
		"慒", "	cong2",
		"慑", "	she4",
		"愶", "	xie2",
		"愴", "	chuang4",
		"慨", "	kai3",
		"愎", "	bi4",
		"愘", "	qia4",
		"愗", "	mao4",
		"愖", "	chen2",
		"愕", "	e4",
		"愔", "	yin1",
		"愓", "	dang4",
		"愒", "	kai4",
		"愑", "	yong3",
		"愐", "	mian3",
		"意", "	yi4",
		"愍", "	min3",
		"愚", "	yu2",
		"愌", "	huan4",
		"愋", "	xuan1",
		"愊", "	bi4",
		"愉", "	yu2",
		"愈", "	yu4",
		"愇", "	wei3",
		"愆", "	qian1",
		"愅", "	ge2",
		"愄", "	wei1",
		"愃", "	xuan1",
		"愙", "	ke4",
		"愛", "	ai4",
		"愳", "	ju4",
		"愨", "	que4",
		"愲", "	gu3",
		"愱", "	ji2",
		"愰", "	huang4",
		"愯", "	song3",
		"愮", "	yao2",
		"愭", "	qi2",
		"愬", "	su4",
		"愫", "	su4",
		"愪", "	yun2",
		"愩", "	gong1",
		"愧", "	kui4",
		"愜", "	qie4",
		"愦", "	kui4",
		"愥", "	ying",
		"愤", "	fen4",
		"愣", "	leng4",
		"愢", "	sai1",
		"愡", "	zong3",
		"愠", "	yun4",
		"感", "	gan3",
		"愞", "	nuo4",
		"愝", "	yan3",
		"慧", "	hui4",
		"慩", "	lian2",
		"愁", "	chou2",
		"憪", "	xian2",
		"憴", "	sheng2",
		"憳", "	tan3",
		"憲", "	xian4",
		"憱", "	cu4",
		"憰", "	jue2",
		"憯", "	can3",
		"憮", "	wu3",
		"憭", "	liao3",
		"憬", "	jing3",
		"憫", "	min3",
		"憩", "	qi4",
		"憶", "	yi4",
		"憨", "	han1",
		"憧", "	chong1",
		"憦", "	lao4",
		"憥", "	lao2",
		"憤", "	fen4",
		"憣", "	fan1",
		"憢", "	xiao1",
		"憡", "	ce4",
		"憠", "	jue2",
		"憟", "	su4",
		"憵", "	pi1",
		"憷", "	chu4",
		"憝", "	dui4",
		"懄", "	qin2",
		"懎", "	se4",
		"懍", "	lin3",
		"懌", "	yi4",
		"懋", "	mao4",
		"懊", "	ao4",
		"應", "	ying1",
		"懈", "	xie4",
		"懇", "	ken3",
		"懆", "	cao3",
		"懅", "	ju4",
		"懃", "	qin2",
		"憸", "	xian1",
		"懂", "	dong3",
		"懁", "	xuan1",
		"懀", "	wei4",
		"憿", "	jiao3",
		"憾", "	han4",
		"憽", "	song1",
		"憼", "	jing3",
		"憻", "	tan3",
		"憺", "	dan4",
		"憹", "	nao2",
		"憞", "	dui4",
		"憜", "	duo3",
		"慪", "	ou4",
		"慶", "	qing4",
		"憀", "	liao2",
		"慿", "	ping2",
		"慾", "	yu4",
		"慽", "	qi1",
		"慼", "	qi1",
		"慻", "	juan4",
		"慺", "	lou2",
		"慹", "	zhi2",
		"慸", "	di4",
		"慷", "	kang1",
		"慵", "	yong1",
		"憂", "	you1",
		"慴", "	she4",
		"慳", "	qian1",
		"慲", "	man2",
		"慱", "	tuan2",
		"慰", "	wei4",
		"慯", "	shang1",
		"慮", "	lv4",
		"慭", "	yin4",
		"慬", "	qin2",
		"慫", "	song3",
		"憁", "	cong4",
		"憃", "	chong1",
		"憛", "	tan2",
		"憐", "	lian2",
		"憚", "	dan4",
		"憙", "	xi1",
		"憘", "	xi3",
		"憗", "	yin4",
		"憖", "	yin4",
		"憕", "	cheng2",
		"憔", "	qiao2",
		"憓", "	hui4",
		"憒", "	kui4",
		"憑", "	ping2",
		"憏", "	chi4",
		"憄", "	zhi4",
		"憎", "	zeng1",
		"憍", "	jiao1",
		"憌", "	qiong2",
		"憋", "	bie1",
		"憊", "	bei4",
		"憉", "	peng2",
		"憈", "	qu1",
		"憇", "	qi4",
		"憆", "	cheng1",
		"憅", "	tong4",
		"愂", "	bei4",
		"愀", "	qiao3",
		"怱", "	cong1",
		"恱", "	yue4",
		"恻", "	ce4",
		"恺", "	kai3",
		"恹", "	yan1",
		"恸", "	tong4",
		"恷", "	xiao",
		"恶", "	e4",
		"恵", "	hui4",
		"恴", "	de2",
		"恳", "	ken3",
		"恲", "	peng1",
		"恰", "	qia4",
		"恽", "	yun4",
		"息", "	xi1",
		"恮", "	quan1",
		"恭", "	gong1",
		"恬", "	tian2",
		"恫", "	dong4",
		"恪", "	ke4",
		"恩", "	en1",
		"恨", "	hen4",
		"恧", "	nv4",
		"恦", "	shang4",
		"恼", "	nao3",
		"恾", "	mang2",
		"恤", "	xu4",
		"悋", "	lin4",
		"悕", "	xi1",
		"悔", "	hui3",
		"悓", "	qian4",
		"悒", "	yi4",
		"悑", "	bu4",
		"悐", "	ti4",
		"悏", "	qie4",
		"悎", "	hao4",
		"悍", "	han4",
		"悌", "	ti4",
		"悊", "	zhe2",
		"恿", "	yong3",
		"悉", "	xi1",
		"悈", "	jie4",
		"悇", "	tu2",
		"悆", "	yu4",
		"悅", "	yue4",
		"悄", "	qiao1",
		"悃", "	kun3",
		"悂", "	pi1",
		"悁", "	yuan1",
		"悀", "	yong3",
		"恥", "	chi3",
		"恣", "	zi4",
		"悗", "	man2",
		"怽", "	mo",
		"恇", "	kuang1",
		"恆", "	heng2",
		"恅", "	lao3",
		"恄", "	xi4",
		"恃", "	shi4",
		"恂", "	xun2",
		"恁", "	nen4",
		"恀", "	shi4",
		"怿", "	yi4",
		"怾", "	zhi3",
		"怼", "	dui4",
		"恉", "	zhi3",
		"总", "	zong3",
		"怺", "	yong",
		"怹", "	tan1",
		"怸", "	xi1",
		"怷", "	shu4",
		"怶", "	bi4",
		"怵", "	chu4",
		"怴", "	xu4",
		"怳", "	huang3",
		"怲", "	bing3",
		"恈", "	mou2",
		"恊", "	xie2",
		"恢", "	hui1",
		"恗", "	hu1",
		"恡", "	lin4",
		"恠", "	guai4",
		"恟", "	xiong1",
		"恞", "	yi2",
		"恝", "	jia2",
		"恜", "	chi4",
		"恛", "	hui2",
		"恚", "	hui4",
		"恙", "	yang4",
		"恘", "	qiu1",
		"恖", "	si",
		"恋", "	lian4",
		"恕", "	shu4",
		"恔", "	jiao3",
		"恓", "	xi1",
		"恒", "	heng2",
		"恑", "	gui3",
		"恐", "	kong3",
		"恏", "	hao4",
		"恎", "	die2",
		"恍", "	huang3",
		"恌", "	tiao1",
		"悖", "	bei4",
		"悘", "	yi1",
		"惿", "	ti2",
		"惚", "	hu1",
		"惤", "	jian1",
		"惣", "	zong3",
		"惢", "	suo3",
		"惡", "	e4",
		"惠", "	hui4",
		"惟", "	wei2",
		"惞", "	xin1",
		"惝", "	chang3",
		"惜", "	xi1",
		"惛", "	hun1",
		"惙", "	chuo4",
		"惦", "	dian4",
		"惘", "	wang3",
		"惗", "	nie4",
		"惖", "	ti4",
		"惕", "	ti4",
		"惔", "	tan2",
		"惓", "	quan2",
		"惒", "	he2",
		"惑", "	huo4",
		"惐", "	yu4",
		"惏", "	lan2",
		"惥", "	yong3",
		"惧", "	ju4",
		"惍", "	jin1",
		"惴", "	zhui4",
		"惾", "	zong1",
		"惽", "	min3",
		"惼", "	bian3",
		"惻", "	ce4",
		"惺", "	xing1",
		"惹", "	re3",
		"惸", "	qiong2",
		"惷", "	chun3",
		"惶", "	huang2",
		"惵", "	die2",
		"想", "	xiang3",
		"惨", "	can3",
		"惲", "	yun4",
		"惱", "	nao3",
		"惰", "	duo4",
		"惯", "	guan4",
		"惮", "	dan4",
		"惭", "	can2",
		"惬", "	qie4",
		"惫", "	bei4",
		"惪", "	de2",
		"惩", "	cheng2",
		"惎", "	ji4",
		"惌", "	yuan1",
		"悙", "	heng1",
		"悥", "	yi4",
		"悯", "	min3",
		"悮", "	wu4",
		"悭", "	qian1",
		"悬", "	xuan2",
		"悫", "	que4",
		"悪", "	e4",
		"悩", "	nao3",
		"您", "	nin2",
		"悧", "	li4",
		"悦", "	yue4",
		"悤", "	cong1",
		"悱", "	fei3",
		"患", "	huan4",
		"悢", "	liang4",
		"悡", "	li2",
		"悠", "	you1",
		"悟", "	wu4",
		"悞", "	wu4",
		"悝", "	kui1",
		"悜", "	cheng3",
		"悛", "	quan1",
		"悚", "	song3",
		"悰", "	cong2",
		"悲", "	bei1",
		"惋", "	wan3",
		"惀", "	lun2",
		"惊", "	jing1",
		"惉", "	zhan1",
		"惈", "	guo3",
		"惇", "	dun1",
		"惆", "	chou2",
		"情", "	qing2",
		"惄", "	ni4",
		"惃", "	gun3",
		"惂", "	kan3",
		"惁", "	xi1",
		"悿", "	tian3",
		"悳", "	duo2",
		"悾", "	kong1",
		"悽", "	qi1",
		"悼", "	dao4",
		"悻", "	xing4",
		"悺", "	guan4",
		"悹", "	guan4",
		"悸", "	ji4",
		"悷", "	san4",
		"悶", "	men4",
		"悵", "	chang4",
		"悴", "	cui4",
		"攐", "	qian1",
		"攒", "	zan3",
		"庐", "	lu2",
		"楦", "	xuan4",
		"楰", "	yu2",
		"楯", "	dun4",
		"楮", "	chu3",
		"業", "	ye4",
		"楬", "	jie2",
		"楫", "	ji2",
		"楪", "	ye4",
		"楩", "	pian2",
		"楨", "	zhen1",
		"楧", "	yang3",
		"楥", "	xuan4",
		"楲", "	wei1",
		"楤", "	song3",
		"楣", "	mei2",
		"楢", "	you2",
		"楡", "	yu2",
		"楠", "	nan2",
		"楟", "	ting2",
		"楞", "	leng2",
		"楝", "	lian4",
		"楜", "	hu2",
		"楛", "	hu4",
		"楱", "	zou4",
		"楳", "	mei2",
		"楙", "	mao4",
		"榀", "	pin3",
		"榊", "	shen",
		"榉", "	ju3",
		"榈", "	lv2",
		"榇", "	chen4",
		"榆", "	yu2",
		"榅", "	wen1",
		"榄", "	lan3",
		"榃", "	tan2",
		"概", "	gai4",
		"榁", "	shi",
		"楿", "	xiang",
		"楴", "	ti4",
		"楾", "	quan",
		"楽", "	le4",
		"楼", "	lou2",
		"楻", "	huang2",
		"楺", "	rou3",
		"楹", "	ying2",
		"楸", "	qiu1",
		"楷", "	kai3",
		"楶", "	jie2",
		"極", "	ji2",
		"楚", "	chu3",
		"楘", "	mu4",
		"榌", "	pi",
		"椲", "	wei3",
		"椼", "	yan3",
		"椻", "	yan4",
		"椺", "	xi2",
		"椹", "	shen4",
		"椸", "	yi2",
		"椷", "	jian1",
		"椶", "	zong1",
		"椵", "	jia3",
		"椴", "	duan4",
		"椳", "	wei1",
		"椱", "	fu4",
		"椾", "	jian1",
		"椰", "	ye1",
		"椯", "	duo3",
		"椮", "	sen1",
		"椭", "	tuo3",
		"椬", "	yi",
		"椫", "	zhan3",
		"椪", "	peng4",
		"椩", "	geng",
		"椨", "	fu",
		"椧", "	ming4",
		"椽", "	chuan2",
		"椿", "	chun1",
		"楗", "	jian4",
		"楌", "	yan2",
		"楖", "	zhi4",
		"楕", "	tuo3",
		"楔", "	xie1",
		"楓", "	feng1",
		"楒", "	si1",
		"楑", "	kui2",
		"楐", "	jie4",
		"楏", "	kui2",
		"楎", "	hui1",
		"楍", "	ben3",
		"楋", "	la4",
		"楀", "	yu3",
		"楊", "	yang2",
		"楉", "	ruo4",
		"楈", "	xu1",
		"楇", "	huo4",
		"楆", "	yao1",
		"楅", "	bi1",
		"楄", "	pian2",
		"楃", "	wo4",
		"楂", "	zha1",
		"楁", "	he2",
		"榋", "	chu",
		"榍", "	xie4",
		"椥", "	zhi1",
		"槎", "	cha2",
		"様", "	yang4",
		"槗", "	qiao",
		"槖", "	tuo2",
		"槕", "	zhuo2",
		"槔", "	gao1",
		"槓", "	gang4",
		"槒", "	xu4",
		"槑", "	mei2",
		"槐", "	huai2",
		"槏", "	qian3",
		"槍", "	qiang1",
		"槚", "	jia3",
		"槌", "	chui2",
		"構", "	gou4",
		"槊", "	shuo4",
		"槉", "	ji2",
		"槈", "	nou4",
		"槇", "	dian1",
		"槆", "	xun2",
		"槅", "	ge2",
		"槄", "	tao1",
		"槃", "	pan2",
		"槙", "	dian1",
		"槛", "	kan3",
		"槁", "	gao3",
		"槨", "	guo3",
		"槲", "	hu2",
		"槱", "	you3",
		"槰", "	peng2",
		"槯", "	cui1",
		"槮", "	sen1",
		"槭", "	qi1",
		"槬", "	hua4",
		"槫", "	tuan2",
		"槪", "	gai4",
		"槩", "	gai4",
		"槧", "	qian4",
		"槜", "	zui4",
		"槦", "	yong1",
		"槥", "	hui4",
		"槤", "	lian2",
		"槣", "	ji1",
		"槢", "	xi2",
		"槡", "	sang",
		"槠", "	zhu1",
		"槟", "	bin1",
		"槞", "	long",
		"槝", "	dao",
		"槂", "	sun1",
		"槀", "	gao3",
		"榎", "	jia3",
		"榚", "	yao3",
		"榤", "	jie2",
		"榣", "	yao2",
		"榢", "	jia4",
		"榡", "	su4",
		"榠", "	ming2",
		"榟", "	zi3",
		"榞", "	yuan2",
		"榝", "	sha1",
		"榜", "	bang3",
		"榛", "	zhen1",
		"榙", "	ta1",
		"榦", "	gan4",
		"榘", "	ju3",
		"榗", "	jian4",
		"榖", "	gu3",
		"榕", "	rong2",
		"榔", "	lang2",
		"榓", "	mi4",
		"榒", "	nuo4",
		"榑", "	fu2",
		"榐", "	zhan3",
		"榏", "	yi4",
		"榥", "	huang4",
		"榧", "	fei3",
		"榿", "	qi1",
		"榴", "	liu2",
		"榾", "	gu3",
		"榽", "	xi1",
		"榼", "	ke1",
		"榻", "	ta4",
		"榺", "	sheng4",
		"榹", "	si1",
		"榸", "	zhai1",
		"榷", "	que4",
		"榶", "	tang2",
		"榵", "	rong2",
		"榳", "	ting2",
		"榨", "	zha4",
		"榲", "	yun2",
		"榱", "	cui1",
		"榰", "	zhi1",
		"榯", "	shi2",
		"榮", "	rong2",
		"榭", "	xie4",
		"榬", "	yuan2",
		"榫", "	sun3",
		"榪", "	ma4",
		"榩", "	qian2",
		"椦", "	quan",
		"椤", "	luo2",
		"槴", "	hu4",
		"梖", "	bei4",
		"梠", "	lv3",
		"梟", "	xiao1",
		"梞", "	ji4",
		"條", "	tiao2",
		"梜", "	jia1",
		"梛", "	nuo2",
		"梚", "	wan3",
		"梙", "	huan4",
		"梘", "	jian3",
		"梗", "	geng3",
		"梕", "	ren4",
		"梢", "	shao1",
		"梔", "	zhi1",
		"梓", "	zi3",
		"梒", "	han2",
		"梑", "	di2",
		"梐", "	bi4",
		"梏", "	gu4",
		"梎", "	ao1",
		"梍", "	zao4",
		"梌", "	tu2",
		"梋", "	xuan1",
		"梡", "	hun2",
		"梣", "	cen2",
		"梉", "	zhuang1",
		"械", "	xie4",
		"梺", "	xia",
		"梹", "	bin1",
		"梸", "	li2",
		"梷", "	jing4",
		"梶", "	wei3",
		"梵", "	fan4",
		"梴", "	chan1",
		"梳", "	shu1",
		"梲", "	zhuo2",
		"梱", "	kun3",
		"梯", "	ti1",
		"梤", "	fen2",
		"梮", "	ju1",
		"梭", "	suo1",
		"梬", "	ying3",
		"梫", "	qin3",
		"梪", "	dou4",
		"梩", "	li2",
		"梨", "	li2",
		"梧", "	wu2",
		"梦", "	meng4",
		"梥", "	song1",
		"梊", "	di4",
		"梈", "	peng1",
		"梼", "	tao2",
		"桢", "	zhen1",
		"桬", "	sha1",
		"桫", "	suo1",
		"桪", "	xun2",
		"桩", "	zhuang1",
		"桨", "	jiang3",
		"桧", "	gui4",
		"桦", "	hua4",
		"桥", "	qiao2",
		"桤", "	qi1",
		"档", "	dang4",
		"桡", "	rao2",
		"桮", "	bei1",
		"桠", "	ya1",
		"桟", "	zhan4",
		"桞", "	liu",
		"桝", "	jie",
		"桜", "	ying1",
		"桚", "	zan3",
		"桙", "	yu2",
		"桘", "	zhui4",
		"桗", "	duo4",
		"桖", "	xue4",
		"桭", "	zhen1",
		"桯", "	ting1",
		"梇", "	long4",
		"桼", "	qi1",
		"梆", "	bang1",
		"梅", "	mei2",
		"梄", "	you3",
		"梃", "	ting3",
		"梂", "	qiu2",
		"梁", "	liang2",
		"梀", "	su4",
		"桿", "	gan3",
		"桾", "	jun1",
		"桽", "	wen3",
		"桻", "	feng1",
		"桰", "	kuo4",
		"桺", "	liu3",
		"桹", "	lang2",
		"桸", "	xi1",
		"桷", "	jue2",
		"桶", "	tong3",
		"桵", "	rui2",
		"桴", "	fu2",
		"桳", "	ben4",
		"桲", "	po",
		"桱", "	jing4",
		"梻", "	fo",
		"梽", "	zhi4",
		"椣", "	dian",
		"棾", "	qing2",
		"椈", "	ju2",
		"椇", "	ju3",
		"椆", "	chou2",
		"椅", "	yi3",
		"椄", "	jie1",
		"椃", "	hao2",
		"椂", "	lu4",
		"椁", "	guo3",
		"椀", "	wan3",
		"棿", "	ni2",
		"棽", "	shen1",
		"椊", "	zuo2",
		"棼", "	fen2",
		"棻", "	fen1",
		"棺", "	guan1",
		"棹", "	zhao4",
		"棸", "	zou1",
		"棷", "	zou1",
		"棶", "	lai2",
		"棵", "	ke1",
		"棴", "	fu2",
		"棳", "	zhuo1",
		"椉", "	cheng2",
		"椋", "	liang2",
		"棱", "	leng2",
		"椘", "	chu3",
		"椢", "	gui4",
		"椡", "	dao",
		"椠", "	qian4",
		"椟", "	du2",
		"椞", "	xi4",
		"椝", "	gui1",
		"検", "	jian3",
		"椛", "	hua",
		"椚", "	men",
		"椙", "	chang",
		"椗", "	ding4",
		"椌", "	qiang1",
		"椖", "	peng2",
		"椕", "	bin1",
		"椔", "	zi1",
		"椓", "	zhuo2",
		"椒", "	jiao1",
		"椑", "	bei1",
		"椐", "	ju1",
		"椏", "	ya1",
		"椎", "	chui2",
		"植", "	zhi2",
		"棲", "	qi1",
		"棰", "	chui2",
		"梾", "	lai2",
		"棊", "	qi2",
		"棔", "	hun1",
		"棓", "	bang4",
		"棒", "	bang4",
		"棑", "	pai2",
		"棐", "	fei3",
		"棏", "	de2",
		"棎", "	chan2",
		"棍", "	gun4",
		"棌", "	cai4",
		"棋", "	qi2",
		"棉", "	mian2",
		"棖", "	cheng2",
		"棈", "	qian4",
		"棇", "	cong1",
		"棆", "	lun2",
		"棅", "	bing4",
		"棄", "	qi4",
		"棃", "	li2",
		"棂", "	ling2",
		"棁", "	zhuo1",
		"检", "	jian3",
		"梿", "	lian2",
		"棕", "	zong1",
		"棗", "	zao3",
		"棯", "	ren3",
		"棤", "	cuo4",
		"森", "	sen1",
		"棭", "	yi4",
		"棬", "	quan1",
		"棫", "	yu4",
		"棪", "	yan3",
		"棩", "	yuan1",
		"棨", "	qi3",
		"棧", "	zhan4",
		"棦", "	cheng1",
		"棥", "	fan2",
		"棣", "	di4",
		"棘", "	ji2",
		"棢", "	wang3",
		"棡", "	gang1",
		"棠", "	tang2",
		"棟", "	dong4",
		"棞", "	jun4",
		"棝", "	gu4",
		"棜", "	yu4",
		"棛", "	yu4",
		"棚", "	peng2",
		"棙", "	li4",
		"槳", "	jiang3",
		"槵", "	huan4",
		"桔", "	ju2",
		"欇", "	she4",
		"欑", "	cuan2",
		"欐", "	li4",
		"欏", "	luo2",
		"欎", "	yu4",
		"欍", "	jiu",
		"欌", "	cang",
		"欋", "	qu2",
		"權", "	quan2",
		"欉", "	cong2",
		"欈", "	wei2",
		"欆", "	shuang1",
		"欓", "	dang3",
		"欅", "	ju3",
		"欄", "	lan2",
		"欃", "	chan2",
		"欂", "	bo2",
		"欁", "	nong2",
		"欀", "	xiang1",
		"櫿", "	ying2",
		"櫾", "	you2",
		"櫽", "	yin3",
		"櫼", "	jian1",
		"欒", "	luan2",
		"欔", "	jue2",
		"櫺", "	ling2",
		"次", "	ci4",
		"欫", "	qi4",
		"欪", "	chu4",
		"欩", "	chao1",
		"欨", "	xu1",
		"欧", "	ou1",
		"欦", "	qian1",
		"欥", "	yi4",
		"欤", "	yu2",
		"欣", "	xin1",
		"欢", "	huan1",
		"欠", "	qian4",
		"欕", "	yan",
		"欟", "	guang",
		"欞", "	ling2",
		"欝", "	yu4",
		"欜", "	nang2",
		"欛", "	ba4",
		"欚", "	li3",
		"欙", "	lei2",
		"欘", "	zhu2",
		"欗", "	lan2",
		"欖", "	lan3",
		"櫻", "	ying1",
		"櫹", "	xiao1",
		"欭", "	yi4",
		"櫓", "	lu3",
		"櫝", "	du2",
		"櫜", "	gao1",
		"櫛", "	zhi4",
		"櫚", "	lu2",
		"櫙", "	ou1",
		"櫘", "	hui4",
		"櫗", "	mie4",
		"櫖", "	lv4",
		"櫕", "	cuan2",
		"櫔", "	li4",
		"櫒", "	sa4",
		"櫟", "	li4",
		"櫑", "	lei2",
		"櫐", "	lei3",
		"櫏", "	qian1",
		"櫎", "	huang3",
		"櫍", "	zhi4",
		"櫌", "	you1",
		"櫋", "	mian2",
		"櫊", "	ge",
		"櫉", "	chu2",
		"櫈", "	deng4",
		"櫞", "	yuan2",
		"櫠", "	fei4",
		"櫸", "	ju3",
		"櫭", "	jie2",
		"櫷", "	gui1",
		"櫶", "	xian3",
		"櫵", "	jiao",
		"櫴", "	lai4",
		"櫳", "	long2",
		"櫲", "	yu4",
		"櫱", "	nie4",
		"櫰", "	huai2",
		"櫯", "	su1",
		"櫮", "	e4",
		"櫬", "	chen4",
		"櫡", "	zhuo2",
		"櫫", "	zhu1",
		"櫪", "	li4",
		"櫩", "	yan2",
		"櫨", "	lu2",
		"櫧", "	zhu1",
		"櫦", "	qing",
		"櫥", "	chu2",
		"櫤", "	jiang",
		"櫣", "	lian2",
		"櫢", "	sou3",
		"欬", "	kai4",
		"欮", "	jue2",
		"櫆", "	kui2",
		"歯", "	chi3",
		"歹", "	dai3",
		"歸", "	gui1",
		"歷", "	li4",
		"歶", "	yu2",
		"歵", "	cuo4",
		"歴", "	li4",
		"歳", "	sui4",
		"歲", "	sui4",
		"歱", "	zhong3",
		"歰", "	se4",
		"歮", "	se4",
		"死", "	si3",
		"歭", "	chi2",
		"歬", "	qian2",
		"歫", "	ju4",
		"歪", "	wai1",
		"歩", "	bu4",
		"歨", "	bu4",
		"歧", "	qi2",
		"武", "	wu3",
		"步", "	bu4",
		"此", "	ci3",
		"歺", "	e4",
		"歼", "	jian1",
		"止", "	zhi3",
		"殉", "	xun4",
		"殓", "	lian4",
		"殒", "	yun3",
		"殑", "	qing2",
		"殐", "	su4",
		"殏", "	qiu2",
		"殎", "	qia4",
		"殍", "	piao3",
		"殌", "	jue2",
		"残", "	can2",
		"殊", "	shu1",
		"殈", "	xu4",
		"歽", "	zhe2",
		"殇", "	shang1",
		"殆", "	dai4",
		"殅", "	sheng1",
		"殄", "	tian3",
		"殃", "	yang1",
		"殂", "	cu2",
		"殁", "	mo4",
		"殀", "	yao1",
		"歿", "	mo4",
		"歾", "	mo4",
		"正", "	zheng4",
		"歡", "	huan1",
		"欯", "	xi4",
		"欻", "	chua1",
		"歅", "	yin1",
		"歄", "	gua1",
		"歃", "	sha4",
		"歂", "	chuan3",
		"歁", "	kan3",
		"歀", "	kuan3",
		"欿", "	kan3",
		"款", "	kuan3",
		"欽", "	qin1",
		"欼", "	chi3",
		"欺", "	qi1",
		"歇", "	xie1",
		"欹", "	yi1",
		"欸", "	ai1",
		"欷", "	xi1",
		"欶", "	shuo4",
		"欵", "	kuan3",
		"欴", "	lang2",
		"欳", "	kui4",
		"欲", "	yu4",
		"欱", "	he1",
		"欰", "	xu4",
		"歆", "	xin1",
		"歈", "	yu2",
		"歠", "	chuo4",
		"歕", "	pen1",
		"歟", "	yu2",
		"歞", "	e4",
		"歝", "	yi4",
		"歜", "	chu4",
		"歛", "	han1",
		"歚", "	shan4",
		"歙", "	she4",
		"歘", "	chua1",
		"歗", "	xiao4",
		"歖", "	xi3",
		"歔", "	xu1",
		"歉", "	qian4",
		"歓", "	huan1",
		"歒", "	ti4",
		"歑", "	hu1",
		"歐", "	ou1",
		"歏", "	jin4",
		"歎", "	tan4",
		"歍", "	wu1",
		"歌", "	ge1",
		"歋", "	ye4",
		"歊", "	xiao1",
		"櫇", "	po2",
		"櫅", "	ji1",
		"槶", "	gui4",
		"樶", "	zui1",
		"橀", "	xi1",
		"樿", "	shan4",
		"樾", "	yue4",
		"樽", "	zun1",
		"樼", "	zhen1",
		"樻", "	kui4",
		"樺", "	hua4",
		"樹", "	shu4",
		"樸", "	pu3",
		"樷", "	cong2",
		"樵", "	qiao2",
		"橂", "	dian4",
		"樴", "	zhi2",
		"樳", "	xun2",
		"樲", "	er4",
		"樱", "	ying1",
		"樰", "	xue",
		"樯", "	qiang2",
		"樮", "	yan",
		"樭", "	ji",
		"樬", "	cong1",
		"樫", "	jian1",
		"橁", "	chun1",
		"橃", "	fa2",
		"権", "	quan2",
		"橐", "	tuo2",
		"橚", "	su4",
		"橙", "	cheng2",
		"橘", "	ju2",
		"橗", "	meng2",
		"橖", "	tang2",
		"橕", "	cheng1",
		"橔", "	dun1",
		"橓", "	shun4",
		"橒", "	yun2",
		"橑", "	lao3",
		"橏", "	zhan3",
		"橄", "	gan3",
		"橎", "	fan2",
		"橍", "	run4",
		"橌", "	xian4",
		"橋", "	qiao2",
		"橊", "	liu2",
		"橉", "	lin4",
		"橈", "	rao2",
		"橇", "	qiao1",
		"橆", "	wu3",
		"橅", "	mo2",
		"横", "	heng2",
		"樨", "	xi1",
		"橜", "	jue2",
		"樂", "	le4",
		"樌", "	guan4",
		"樋", "	tong3",
		"樊", "	fan2",
		"樉", "	shuang3",
		"樈", "	qing2",
		"樇", "	xiu1",
		"樆", "	li2",
		"樅", "	cong1",
		"樄", "	chen2",
		"樃", "	lang3",
		"樁", "	zhuang1",
		"樎", "	su4",
		"樀", "	di1",
		"槿", "	jin3",
		"槾", "	man4",
		"槽", "	cao2",
		"槼", "	gui1",
		"槻", "	gui1",
		"槺", "	kang1",
		"槹", "	gao1",
		"槸", "	yi4",
		"槷", "	nie4",
		"樍", "	ze2",
		"樏", "	lei3",
		"樧", "	sha1",
		"樜", "	zhe4",
		"樦", "	zhu4",
		"樥", "	peng2",
		"樤", "	tiao2",
		"樣", "	yang4",
		"樢", "	niao3",
		"模", "	mo2",
		"樠", "	man2",
		"樟", "	zhang1",
		"樞", "	shu1",
		"樝", "	zha1",
		"樛", "	jiu1",
		"樐", "	lu3",
		"樚", "	lu4",
		"標", "	biao1",
		"樘", "	tang2",
		"樗", "	chu1",
		"樖", "	ke1",
		"樕", "	su4",
		"樔", "	chao2",
		"樓", "	lou2",
		"樒", "	mi4",
		"樑", "	liang2",
		"橛", "	jue2",
		"橝", "	dian4",
		"櫄", "	chun1",
		"檟", "	jia3",
		"檩", "	lin3",
		"檨", "	she1",
		"檧", "	song1",
		"檦", "	biao3",
		"檥", "	yi3",
		"檤", "	dao4",
		"檣", "	qiang2",
		"檢", "	jian3",
		"檡", "	zhai2",
		"檠", "	qing2",
		"檞", "	jie3",
		"檫", "	cha2",
		"檝", "	ji2",
		"檜", "	gui4",
		"檛", "	zhua1",
		"檚", "	chu3",
		"檙", "	cheng2",
		"檘", "	ping2",
		"檗", "	bo4",
		"檖", "	sui4",
		"檕", "	ji4",
		"檔", "	dang4",
		"檪", "	li",
		"檬", "	meng2",
		"檒", "	feng1",
		"檹", "	yi1",
		"櫃", "	gui4",
		"櫂", "	zhao4",
		"櫁", "	mi4",
		"櫀", "	qi2",
		"檿", "	yan3",
		"檾", "	qing3",
		"檽", "	nou4",
		"檼", "	yin4",
		"檻", "	kan3",
		"檺", "	gao3",
		"檸", "	ning2",
		"檭", "	yin2",
		"檷", "	ni3",
		"檶", "	qian1",
		"檵", "	ji4",
		"檴", "	huo4",
		"檳", "	bin1",
		"檲", "	tuan2",
		"檱", "	qi2",
		"檰", "	mian2",
		"檯", "	tai2",
		"檮", "	tao2",
		"檓", "	hui3",
		"檑", "	lei2",
		"橞", "	hui4",
		"橪", "	ran3",
		"橴", "	zi",
		"橳", "	sheng",
		"橲", "	xi",
		"橱", "	chu2",
		"橰", "	gao1",
		"橯", "	lao4",
		"橮", "	liu3",
		"橭", "	gu1",
		"橬", "	qian2",
		"橫", "	heng2",
		"橩", "	qiong2",
		"橶", "	ji2",
		"橨", "	fen2",
		"橧", "	zeng1",
		"橦", "	tong2",
		"橥", "	zhu1",
		"橤", "	rui3",
		"橣", "	ning3",
		"橢", "	tuo3",
		"橡", "	xiang4",
		"橠", "	nuo3",
		"機", "	ji1",
		"橵", "	san",
		"橷", "	dou1",
		"檐", "	yan2",
		"檅", "	sui4",
		"檏", "	pu3",
		"檎", "	qin2",
		"檍", "	yi4",
		"檌", "	zui4",
		"檋", "	ju2",
		"檊", "	gan4",
		"檉", "	cheng1",
		"檈", "	xuan2",
		"檇", "	zui4",
		"檆", "	shan1",
		"檄", "	xi2",
		"橸", "	jing",
		"檃", "	yin3",
		"檂", "	nong2",
		"檁", "	lin3",
		"檀", "	tan2",
		"橿", "	jiang1",
		"橾", "	shu1",
		"橽", "	ta4",
		"橼", "	yuan2",
		"橻", "	chu",
		"橺", "	jian",
		"橹", "	lu3",
		"桕", "	jiu4",
		"桓", "	huan2",
		"攓", "	qian1",
		"昤", "	ling2",
		"昮", "	zong4",
		"昭", "	zhao1",
		"昬", "	hun1",
		"昫", "	xu4",
		"昪", "	bian4",
		"昩", "	mo4",
		"昨", "	zuo2",
		"昧", "	mei4",
		"昦", "	hao4",
		"春", "	chun1",
		"昣", "	zhen3",
		"昰", "	shi4",
		"昢", "	po4",
		"昡", "	xuan4",
		"映", "	ying4",
		"星", "	xing1",
		"昞", "	bing3",
		"昝", "	zan3",
		"昜", "	yang2",
		"昛", "	ju4",
		"昚", "	shen4",
		"昙", "	tan2",
		"是", "	shi4",
		"昱", "	yu4",
		"昗", "	ze4",
		"显", "	xian3",
		"晈", "	jiao3",
		"晇", "	xu1",
		"晆", "	kui2",
		"晅", "	xuan3",
		"晄", "	huang3",
		"晃", "	huang3",
		"時", "	shi2",
		"晁", "	chao2",
		"晀", "	tiao3",
		"昿", "	kuang4",
		"昽", "	long2",
		"昲", "	fei4",
		"昼", "	zhou4",
		"昻", "	ang2",
		"昺", "	bing3",
		"昹", "	ai3",
		"昸", "	dong1",
		"昷", "	wen1",
		"昶", "	chang3",
		"昵", "	ni4",
		"昴", "	mao3",
		"昳", "	die2",
		"昘", "	fang3",
		"昖", "	yan2",
		"晊", "	zhi4",
		"旰", "	gan4",
		"旺", "	wang4",
		"旹", "	shi2",
		"旸", "	yang2",
		"旷", "	kuang4",
		"时", "	shi2",
		"旵", "	chan3",
		"旴", "	xu1",
		"旳", "	di4",
		"旲", "	tai2",
		"旱", "	han4",
		"旯", "	la2",
		"旼", "	min2",
		"旮", "	ga1",
		"旭", "	xu4",
		"旬", "	xun2",
		"旫", "	tiao1",
		"旪", "	xie2",
		"早", "	zao3",
		"旨", "	zhi3",
		"旧", "	jiu4",
		"旦", "	dan4",
		"日", "	ri4",
		"旻", "	min2",
		"旽", "	tun4",
		"昕", "	xin1",
		"昊", "	hao4",
		"昔", "	xi1",
		"易", "	yi4",
		"昒", "	hu1",
		"昑", "	qin3",
		"昐", "	fen1",
		"昏", "	hun1",
		"明", "	ming2",
		"昍", "	xuan1",
		"昌", "	chang1",
		"昋", "	gui4",
		"昉", "	fang3",
		"旾", "	chun1",
		"昈", "	hu4",
		"昇", "	sheng1",
		"昆", "	kun1",
		"昅", "	jie2",
		"昄", "	ban3",
		"昃", "	ze4",
		"昂", "	ang2",
		"昁", "	bei4",
		"昀", "	yun2",
		"旿", "	wu3",
		"晉", "	jin4",
		"晋", "	jin4",
		"旣", "	ji4",
		"暌", "	kui2",
		"暖", "	nuan3",
		"暕", "	jian3",
		"暔", "	nan2",
		"暓", "	mao4",
		"暒", "	qing2",
		"暑", "	shu3",
		"暐", "	wei3",
		"暏", "	shu3",
		"暎", "	ying4",
		"暍", "	ye1",
		"暋", "	min3",
		"暘", "	yang2",
		"暊", "	xu3",
		"暉", "	hui1",
		"暈", "	yun1",
		"暇", "	xia2",
		"暆", "	yi2",
		"暅", "	geng4",
		"暄", "	xuan1",
		"暃", "	fei",
		"暂", "	zan4",
		"暁", "	xiao3",
		"暗", "	an4",
		"暙", "	chun1",
		"晿", "	chang1",
		"暦", "	li4",
		"暰", "	cong1",
		"暯", "	mo4",
		"暮", "	mu4",
		"暭", "	hao4",
		"暬", "	xie4",
		"暫", "	zan4",
		"暪", "	men4",
		"暩", "	ji4",
		"暨", "	ji4",
		"暧", "	ai4",
		"暥", "	yan4",
		"暚", "	yao2",
		"暤", "	hao4",
		"暣", "	qi4",
		"暢", "	chang4",
		"暡", "	weng3",
		"暠", "	gao3",
		"暟", "	kai3",
		"暞", "	jiao3",
		"暝", "	ming2",
		"暜", "	jin4",
		"暛", "	suo3",
		"暀", "	wang3",
		"晾", "	liang4",
		"晌", "	shang3",
		"晘", "	han4",
		"晢", "	zhe2",
		"晡", "	bu1",
		"晠", "	sheng4",
		"晟", "	cheng2",
		"晞", "	xi1",
		"晝", "	zhou4",
		"晜", "	kun1",
		"晛", "	xian4",
		"晚", "	wan3",
		"晙", "	jun4",
		"晗", "	han2",
		"晤", "	wu4",
		"晖", "	hui1",
		"晕", "	yun1",
		"晔", "	ye4",
		"晓", "	xiao3",
		"晒", "	shai4",
		"晑", "	xiang3",
		"晐", "	gai1",
		"晏", "	yan4",
		"晎", "	hong3",
		"晍", "	tong2",
		"晣", "	zhe2",
		"晥", "	han4",
		"晽", "	lin2",
		"晲", "	ni3",
		"晼", "	wan3",
		"晻", "	an4",
		"智", "	zhi4",
		"晹", "	yi4",
		"晸", "	zheng3",
		"晷", "	gui3",
		"晶", "	jing1",
		"晵", "	qi3",
		"晴", "	qing2",
		"晳", "	xi1",
		"晱", "	shan3",
		"晦", "	hui4",
		"晰", "	xi1",
		"景", "	jing3",
		"普", "	pu3",
		"晭", "	zhou3",
		"晬", "	zui4",
		"晫", "	zhuo2",
		"晪", "	tian3",
		"晩", "	wan3",
		"晨", "	chen2",
		"晧", "	hao4",
		"旤", "	huo4",
		"既", "	ji4",
		"暲", "	zhang1",
		"敓", "	duo2",
		"敞", "	chang3",
		"敝", "	bi4",
		"敜", "	nie4",
		"敚", "	duo2",
		"教", "	jiao4",
		"敘", "	xu4",
		"敗", "	bai4",
		"敖", "	ao2",
		"敕", "	chi4",
		"敔", "	yu3",
		"敒", "	shen1",
		"敠", "	duo1",
		"救", "	jiu4",
		"敐", "	chen2",
		"敏", "	min3",
		"敎", "	jiao4",
		"敍", "	xu4",
		"敌", "	di2",
		"敋", "	ge2",
		"敊", "	chu4",
		"敉", "	mi3",
		"效", "	xiao4",
		"敟", "	dian3",
		"敡", "	yi4",
		"敆", "	he2",
		"敮", "	xia2",
		"數", "	shu4",
		"敷", "	fu1",
		"敶", "	zhen4",
		"敵", "	di2",
		"整", "	zheng3",
		"敳", "	ai2",
		"敲", "	qiao1",
		"敱", "	ai2",
		"数", "	shu4",
		"敯", "	min2",
		"敭", "	yang2",
		"敢", "	gan3",
		"敬", "	jing4",
		"敫", "	jiao3",
		"敪", "	duo2",
		"敩", "	xiao4",
		"敨", "	tou3",
		"敧", "	ji1",
		"敦", "	dun1",
		"敥", "	yan4",
		"敤", "	ke3",
		"散", "	san4",
		"敇", "	ce4",
		"故", "	gu4",
		"敺", "	qu1",
		"攟", "	jun4",
		"攩", "	dang3",
		"攨", "	wa1",
		"攧", "	dian1",
		"攦", "	li4",
		"攥", "	zuan4",
		"攤", "	tan1",
		"攣", "	luan2",
		"攢", "	zan3",
		"攡", "	li2",
		"攠", "	mi2",
		"攞", "	luo2",
		"攫", "	jue2",
		"攝", "	she4",
		"攜", "	xie2",
		"攛", "	cuan1",
		"攚", "	ying",
		"攙", "	chan1",
		"攘", "	rang3",
		"攗", "	mei2",
		"攖", "	ying1",
		"攕", "	xian1",
		"攔", "	lan2",
		"攪", "	jiao3",
		"攬", "	lan3",
		"敄", "	wu4",
		"改", "	gai3",
		"敃", "	min3",
		"敂", "	kou4",
		"敁", "	dian1",
		"敀", "	po4",
		"政", "	zheng4",
		"放", "	fang4",
		"攽", "	ban1",
		"攼", "	gan1",
		"攻", "	gong1",
		"攺", "	yi3",
		"攸", "	you1",
		"攭", "	li4",
		"攷", "	kao3",
		"收", "	shou1",
		"攵", "	pu1",
		"攴", "	pu1",
		"攳", "	xun2",
		"攲", "	qi1",
		"攱", "	gui3",
		"攰", "	gui4",
		"支", "	zhi1",
		"攮", "	nang3",
		"敹", "	liao2",
		"敻", "	xiong4",
		"旡", "	ji4",
		"於", "	yu2",
		"旆", "	pei4",
		"旅", "	lv3",
		"旄", "	mao2",
		"旃", "	zhan1",
		"旂", "	qi2",
		"旁", "	pang2",
		"旀", "	mei4",
		"斿", "	you2",
		"斾", "	pei4",
		"施", "	shi1",
		"斻", "	hang2",
		"旈", "	liu2",
		"斺", "	chan3",
		"方", "	fang1",
		"斸", "	zhu3",
		"斷", "	duan4",
		"斶", "	chu4",
		"斵", "	zhuo2",
		"斴", "	lin2",
		"斳", "	qin2",
		"斲", "	zhuo2",
		"斱", "	zhuo2",
		"旇", "	pi1",
		"旉", "	fu1",
		"斯", "	si1",
		"旖", "	yi3",
		"无", "	wu2",
		"旟", "	yu2",
		"旞", "	sui4",
		"旝", "	kuai4",
		"旜", "	zhan1",
		"旛", "	fan1",
		"旚", "	piao1",
		"旙", "	fan1",
		"旘", "	zhi4",
		"旗", "	qi2",
		"旕", "	yu2",
		"旊", "	fang3",
		"旔", "	jian4",
		"旓", "	shao1",
		"旒", "	liu2",
		"旑", "	yi3",
		"旐", "	zhao4",
		"族", "	zu2",
		"旎", "	ni3",
		"旍", "	jing1",
		"旌", "	jing1",
		"旋", "	xuan2",
		"新", "	xin1",
		"斮", "	cuo4",
		"敼", "	yi3",
		"斈", "	xue2",
		"斒", "	ban1",
		"斑", "	ban1",
		"斐", "	fei3",
		"斏", "	lang2",
		"斎", "	zhai1",
		"斍", "	jue2",
		"斌", "	bin1",
		"斋", "	zhai1",
		"斊", "	qi2",
		"斉", "	qi2",
		"文", "	wen2",
		"斔", "	yu3",
		"斆", "	xiao4",
		"斅", "	xiao4",
		"斄", "	li2",
		"斃", "	bi4",
		"斂", "	lian3",
		"斁", "	yi4",
		"斀", "	zhuo2",
		"敿", "	jiao3",
		"敾", "	shan",
		"敽", "	jiao3",
		"斓", "	lan2",
		"斕", "	lan2",
		"断", "	duan4",
		"斢", "	tiao3",
		"斬", "	zhan3",
		"斫", "	zhuo2",
		"斪", "	qu2",
		"斩", "	zhan3",
		"斨", "	qiang1",
		"斧", "	fu3",
		"斦", "	yin2",
		"斥", "	chi4",
		"斤", "	jin1",
		"斣", "	dou4",
		"斡", "	wo4",
		"斖", "	wei3",
		"斠", "	jiao4",
		"斟", "	zhen1",
		"斞", "	yu3",
		"斝", "	jia3",
		"斜", "	xie2",
		"斛", "	hu2",
		"斚", "	jia3",
		"料", "	liao4",
		"斘", "	sheng1",
		"斗", "	dou4",
		"暱", "	ni4",
		"暳", "	hui4",
		"桒", "	sang1",
		"柅", "	ni3",
		"柏", "	bai3",
		"柎", "	fu1",
		"柍", "	yang3",
		"柌", "	ci2",
		"柋", "	dai4",
		"柊", "	zhong1",
		"柉", "	fan2",
		"柈", "	ban4",
		"柇", "	he2",
		"柆", "	la1",
		"柄", "	bing3",
		"柑", "	gan1",
		"柃", "	ling2",
		"柂", "	yi2",
		"柁", "	duo4",
		"柀", "	bi3",
		"枿", "	nie4",
		"枾", "	shi4",
		"枽", "	ye4",
		"枼", "	ye4",
		"枻", "	yi4",
		"枺", "	mo4",
		"某", "	mou3",
		"柒", "	qi1",
		"枸", "	gou3",
		"柟", "	nan2",
		"柩", "	jiu4",
		"柨", "	bu4",
		"柧", "	gu1",
		"柦", "	dan4",
		"查", "	cha2",
		"柤", "	zha1",
		"柣", "	zhi4",
		"柢", "	di3",
		"柡", "	yong3",
		"柠", "	ning2",
		"柞", "	zha4",
		"染", "	ran3",
		"柝", "	tuo4",
		"柜", "	gui4",
		"柛", "	shen1",
		"柚", "	you4",
		"柙", "	xia2",
		"柘", "	zhe4",
		"柗", "	song1",
		"柖", "	shao2",
		"柕", "	mao4",
		"柔", "	rou2",
		"枹", "	bao1",
		"枷", "	jia1",
		"柫", "	fu2",
		"枑", "	hu4",
		"枛", "	zhao4",
		"枚", "	mei2",
		"枙", "	e3",
		"枘", "	rui4",
		"林", "	lin2",
		"枖", "	yao1",
		"枕", "	zhen3",
		"枔", "	xin2",
		"枓", "	dou3",
		"枒", "	ya1",
		"析", "	xi1",
		"枝", "	zhi1",
		"枏", "	nan2",
		"枎", "	fu2",
		"枍", "	yi4",
		"枌", "	fen2",
		"枋", "	fang1",
		"枊", "	ang4",
		"枉", "	wang3",
		"枈", "	bi4",
		"枇", "	pi2",
		"枆", "	mao2",
		"果", "	guo3",
		"枞", "	cong1",
		"架", "	jia4",
		"枫", "	feng1",
		"枵", "	xiao1",
		"枴", "	guai3",
		"枳", "	zhi3",
		"枲", "	xi3",
		"枱", "	tai2",
		"枰", "	ping2",
		"枯", "	ku1",
		"枮", "	xian1",
		"枭", "	xiao1",
		"枬", "	nan2",
		"枪", "	qiang1",
		"枟", "	yun4",
		"枩", "	song",
		"枨", "	cheng2",
		"枧", "	jian3",
		"枦", "	lu",
		"枥", "	li4",
		"枤", "	duo",
		"枣", "	zao3",
		"枢", "	shu1",
		"枡", "	dou3",
		"枠", "	zui",
		"柪", "	ao1",
		"柬", "	jian3",
		"构", "	gou4",
		"栭", "	er2",
		"样", "	yang4",
		"栶", "	yin1",
		"栵", "	lie4",
		"栴", "	zhan1",
		"栳", "	lao3",
		"栲", "	kao3",
		"栱", "	gong3",
		"栰", "	fa2",
		"栯", "	you3",
		"栮", "	er3",
		"栬", "	zui4",
		"根", "	gen1",
		"栫", "	jian4",
		"株", "	zhu1",
		"栩", "	xu3",
		"栨", "	ci4",
		"栧", "	yi4",
		"栦", "	chou2",
		"栥", "	zi1",
		"栤", "	bing4",
		"栣", "	ren3",
		"栢", "	bai3",
		"核", "	he2",
		"栺", "	yi4",
		"栠", "	ren3",
		"桇", "	ru2",
		"桑", "	sang1",
		"桐", "	tong2",
		"桏", "	qiong2",
		"桎", "	zhi4",
		"桍", "	ku1",
		"桌", "	zhuo1",
		"桋", "	yi2",
		"桊", "	juan4",
		"桉", "	an1",
		"案", "	an4",
		"框", "	kuang1",
		"栻", "	shi4",
		"桅", "	wei2",
		"桄", "	guang1",
		"桃", "	tao2",
		"桂", "	gui4",
		"桁", "	heng2",
		"桀", "	jie2",
		"栿", "	fu2",
		"栾", "	luan2",
		"栽", "	zai1",
		"格", "	ge2",
		"校", "	xiao4",
		"栟", "	ben1",
		"柭", "	ba1",
		"柹", "	shi4",
		"栃", "	li",
		"栂", "	mei2",
		"栁", "	liu3",
		"栀", "	zhi1",
		"柿", "	shi4",
		"柾", "	jiu4",
		"柽", "	cheng1",
		"柼", "	yao3",
		"査", "	zha1",
		"柺", "	guai3",
		"柸", "	pei1",
		"栅", "	zha4",
		"柷", "	chu4",
		"柶", "	si4",
		"柵", "	shan1",
		"柴", "	chai2",
		"柳", "	liu3",
		"柲", "	bi4",
		"柱", "	zhu4",
		"柰", "	nai4",
		"柯", "	ke1",
		"柮", "	duo4",
		"栄", "	rong2",
		"栆", "	zao",
		"栞", "	kan1",
		"栓", "	shuan1",
		"栝", "	gua1",
		"栜", "	se4",
		"栛", "	li4",
		"栚", "	zhen4",
		"栙", "	xiang2",
		"栘", "	yi2",
		"栗", "	li4",
		"栖", "	qi1",
		"栕", "	zhen1",
		"栔", "	qi4",
		"栒", "	xun2",
		"标", "	biao1",
		"树", "	shu4",
		"栐", "	yong3",
		"栏", "	lan2",
		"栎", "	li4",
		"栍", "	sheng1",
		"栌", "	lu2",
		"栋", "	dong4",
		"栊", "	long2",
		"栉", "	zhi4",
		"栈", "	zhan4",
		"枅", "	ji1",
		"枃", "	jin4",
		"暴", "	bao4",
		"更", "	geng4",
		"曾", "	ceng2",
		"曽", "	ceng1",
		"曼", "	man4",
		"曻", "	sheng",
		"曺", "	cao2",
		"曹", "	cao2",
		"書", "	shu1",
		"曷", "	he2",
		"曶", "	hu1",
		"曵", "	ye4",
		"曳", "	ye4",
		"最", "	zui4",
		"曲", "	qu1",
		"曱", "	yue1",
		"曰", "	yue1",
		"曯", "	zhu2",
		"曮", "	yan3",
		"曭", "	tang3",
		"曬", "	shai4",
		"曫", "	luan2",
		"曪", "	luo3",
		"曩", "	nang3",
		"替", "	ti4",
		"朁", "	can3",
		"曧", "	rong2",
		"朎", "	ling2",
		"朘", "	zui1",
		"朗", "	lang3",
		"朖", "	lang3",
		"朕", "	zhen4",
		"朔", "	shuo4",
		"朓", "	tiao3",
		"朒", "	nv4",
		"朑", "	ti4",
		"朐", "	qu2",
		"朏", "	fei3",
		"服", "	fu2",
		"朂", "	xu4",
		"朌", "	fen2",
		"朋", "	peng2",
		"朊", "	ruan3",
		"有", "	you3",
		"月", "	yue4",
		"朇", "	pi2",
		"朆", "	fen1",
		"朅", "	qie4",
		"朄", "	yin3",
		"會", "	hui4",
		"曨", "	long2",
		"曦", "	xi1",
		"朚", "	huang1",
		"曀", "	yi4",
		"曊", "	fei4",
		"曉", "	xiao3",
		"曈", "	tong2",
		"曇", "	tan2",
		"曆", "	li4",
		"曅", "	ye4",
		"曄", "	ye4",
		"曃", "	dai4",
		"曂", "	huang4",
		"曁", "	ji4",
		"暿", "	xi3",
		"曌", "	zhao4",
		"暾", "	tun1",
		"暽", "	lin2",
		"暼", "	pie1",
		"暻", "	jing3",
		"暺", "	dan4",
		"暹", "	xian1",
		"暸", "	liao2",
		"暷", "	chuan2",
		"暶", "	xuan2",
		"暵", "	han4",
		"曋", "	shen3",
		"曍", "	hao4",
		"曥", "	lu2",
		"曚", "	meng2",
		"曤", "	huo4",
		"曣", "	yan4",
		"曢", "	liao3",
		"曡", "	die2",
		"曠", "	kuang4",
		"曟", "	chen2",
		"曞", "	li4",
		"曝", "	pu4",
		"曜", "	yao4",
		"曛", "	xun1",
		"曙", "	shu3",
		"曎", "	yi4",
		"曘", "	ru2",
		"曗", "	ye4",
		"曖", "	ai4",
		"曕", "	yan4",
		"曔", "	jing4",
		"曓", "	bao4",
		"曒", "	jiao3",
		"曑", "	shen1",
		"曐", "	xing1",
		"曏", "	xiang3",
		"朙", "	ming2",
		"望", "	wang4",
		"枂", "	wo4",
		"杝", "	li2",
		"杧", "	mang2",
		"杦", "	jiu",
		"来", "	lai2",
		"杤", "	wan",
		"杣", "	shan",
		"杢", "	jiang",
		"条", "	tiao2",
		"杠", "	gang1",
		"束", "	shu4",
		"杞", "	qi3",
		"杜", "	du4",
		"杩", "	ma4",
		"杛", "	gong1",
		"杚", "	gai4",
		"杙", "	yi4",
		"杘", "	chi4",
		"杗", "	mang2",
		"杖", "	zhang4",
		"杕", "	di4",
		"杔", "	tuo1",
		"杓", "	biao1",
		"杒", "	ren4",
		"杨", "	yang2",
		"杪", "	miao3",
		"材", "	cai2",
		"杷", "	pa2",
		"极", "	ji2",
		"枀", "	song1",
		"板", "	ban3",
		"松", "	song1",
		"杽", "	chou3",
		"杼", "	zhu4",
		"杻", "	chou3",
		"杺", "	xin1",
		"杹", "	hua4",
		"杸", "	shu1",
		"杶", "	chun1",
		"杫", "	si4",
		"杵", "	chu3",
		"杴", "	xian1",
		"杳", "	yao3",
		"杲", "	gao3",
		"東", "	dong1",
		"杰", "	jie2",
		"杯", "	bei1",
		"杮", "	fei4",
		"杭", "	hang2",
		"杬", "	yuan2",
		"村", "	cun1",
		"杏", "	xing4",
		"朜", "	tun1",
		"木", "	mu4",
		"朲", "	ren2",
		"朱", "	zhu1",
		"朰", "	mu4",
		"术", "	shu4",
		"朮", "	shu4",
		"札", "	zha2",
		"本", "	ben3",
		"末", "	mo4",
		"未", "	wei4",
		"朩", "	deng3",
		"朧", "	long2",
		"朴", "	pu3",
		"朦", "	meng2",
		"朥", "	lao",
		"朤", "	lang3",
		"朣", "	tong2",
		"朢", "	wang4",
		"朡", "	zong1",
		"朠", "	ying1",
		"期", "	qi1",
		"朞", "	ji1",
		"朝", "	chao2",
		"朳", "	ba1",
		"朵", "	duo3",
		"李", "	li3",
		"权", "	quan2",
		"杍", "	zi3",
		"杌", "	wu4",
		"杋", "	fan2",
		"杊", "	xun2",
		"杉", "	shan1",
		"杈", "	cha1",
		"杇", "	wu1",
		"杆", "	gan1",
		"杅", "	yu2",
		"杄", "	qian1",
		"杂", "	za2",
		"朶", "	duo3",
		"杁", "	ru",
		"杀", "	sha1",
		"朿", "	ci4",
		"朾", "	cheng2",
		"朽", "	xiu3",
		"朼", "	bi3",
		"朻", "	jiu1",
		"机", "	ji1",
		"朹", "	gui3",
		"朸", "	li4",
		"朷", "	dao1",
		"庑", "	wu3",
		"序", "	xu4",
		"冋", "	jiong1",
		"嗜", "	shi4",
		"嗦", "	suo",
		"嗥", "	hao2",
		"嗤", "	chi1",
		"嗣", "	si4",
		"嗢", "	wa4",
		"嗡", "	weng1",
		"嗠", "	luo4",
		"嗟", "	jie1",
		"嗞", "	zi1",
		"嗝", "	ge2",
		"嗛", "	qian3",
		"嗩", "	suo3",
		"嗚", "	wu1",
		"嗙", "	pang3",
		"嗘", "	ji1",
		"嗗", "	wa1",
		"嗖", "	sou1",
		"嗕", "	ru4",
		"嗔", "	chen1",
		"嗓", "	sang3",
		"嗒", "	da1",
		"嗑", "	ke1",
		"嗨", "	hai1",
		"嗪", "	qin2",
		"嗏", "	cha1",
		"嗷", "	ao2",
		"嘁", "	qi1",
		"嘀", "	di2",
		"嗿", "	tan3",
		"嗾", "	sou3",
		"嗽", "	sou4",
		"嗼", "	mo4",
		"嗻", "	zhe1",
		"嗺", "	zui1",
		"嗹", "	lian2",
		"嗸", "	ao2",
		"嗶", "	bi4",
		"嗫", "	nie4",
		"嗵", "	tong1",
		"嗴", "	qiang",
		"嗳", "	ai1",
		"嗲", "	dia3",
		"嗱", "	na2",
		"嗰", "	ge4",
		"嗯", "	en4",
		"嗮", "	sai4",
		"嗭", "	zhi2",
		"嗬", "	he1",
		"嗐", "	hai4",
		"嗎", "	ma",
		"嘃", "	chong1",
		"喨", "	liang4",
		"喲", "	yo1",
		"喱", "	li2",
		"喰", "	can1",
		"喯", "	pen4",
		"單", "	dan1",
		"喭", "	yan4",
		"喬", "	qiao2",
		"喫", "	chi1",
		"喪", "	sang4",
		"喩", "	yu4",
		"喧", "	xuan1",
		"喴", "	wei1",
		"喦", "	nie4",
		"喥", "	duo2",
		"喤", "	huang2",
		"喣", "	xu4",
		"喢", "	sha4",
		"喡", "	wei2",
		"喠", "	zhong3",
		"喟", "	kui4",
		"喞", "	ji1",
		"喝", "	he1",
		"喳", "	zha1",
		"喵", "	miao1",
		"嗍", "	suo1",
		"嗂", "	yao2",
		"嗌", "	ai4",
		"嗋", "	xie2",
		"嗊", "	hong3",
		"嗉", "	su4",
		"嗈", "	yong1",
		"嗇", "	se4",
		"嗆", "	qiang1",
		"嗅", "	xiu4",
		"嗄", "	a2",
		"嗃", "	he4",
		"嗁", "	ti2",
		"営", "	ying2",
		"嗀", "	hu4",
		"喿", "	zao4",
		"喾", "	ku4",
		"喽", "	lou2",
		"喼", "	jie2",
		"喻", "	yu4",
		"喺", "	xi4",
		"喹", "	kui2",
		"喸", "	bu3",
		"喷", "	pen1",
		"嘂", "	jiao4",
		"嘄", "	jiao1",
		"喛", "	huan4",
		"噅", "	hui1",
		"噏", "	xi1",
		"噎", "	ye1",
		"噍", "	jiao4",
		"噌", "	ceng1",
		"噋", "	tun1",
		"噊", "	yu4",
		"噉", "	dan4",
		"噈", "	cu4",
		"噇", "	chuang2",
		"噆", "	zan3",
		"噄", "	chi1",
		"噑", "	hao2",
		"噃", "	fan1",
		"噂", "	zun3",
		"噁", "	e3",
		"噀", "	xun4",
		"嘿", "	hei1",
		"嘾", "	dan4",
		"嘽", "	chan3",
		"嘼", "	chu4",
		"嘻", "	xi1",
		"嘺", "	qiao2",
		"噐", "	qi4",
		"噒", "	lian2",
		"嘸", "	fu3",
		"噟", "	ying4",
		"噩", "	e4",
		"器", "	qi4",
		"噧", "	xie4",
		"噦", "	hui4",
		"噥", "	nong2",
		"噤", "	jin4",
		"噣", "	zhou4",
		"噢", "	o1",
		"噡", "	zhan1",
		"噠", "	da1",
		"噞", "	yan3",
		"噓", "	xu1",
		"噝", "	si1",
		"噜", "	lu1",
		"噛", "	nie4",
		"噚", "	xun2",
		"噙", "	qin2",
		"噘", "	jue1",
		"噗", "	pu1",
		"噖", "	yin2",
		"噕", "	hui1",
		"噔", "	deng1",
		"嘹", "	liao2",
		"嘷", "	hao2",
		"嘅", "	kai3",
		"嘑", "	hu1",
		"嘛", "	ma",
		"嘚", "	de1",
		"嘙", "	po2",
		"嘘", "	xu1",
		"嘗", "	chang2",
		"嘖", "	ze2",
		"嘕", "	xian1",
		"嘔", "	ou3",
		"嘓", "	guo1",
		"嘒", "	hui4",
		"嘐", "	xiao1",
		"嘝", "	hu2",
		"嘏", "	gu3",
		"嘎", "	ga1",
		"嘍", "	lou2",
		"嘌", "	piao4",
		"嘋", "	xiao1",
		"嘊", "	ai2",
		"嘉", "	jia1",
		"嘈", "	cao2",
		"嘇", "	shan1",
		"嘆", "	tan4",
		"嘜", "	ma4",
		"嘞", "	lei",
		"嘶", "	si1",
		"嘫", "	ran2",
		"嘵", "	xiao1",
		"嘴", "	zui3",
		"嘳", "	kui4",
		"嘲", "	chao2",
		"嘱", "	zhu3",
		"嘰", "	ji1",
		"嘯", "	xiao4",
		"嘮", "	lao2",
		"嘭", "	peng1",
		"嘬", "	chuai4",
		"嘪", "	mai3",
		"嘟", "	du1",
		"嘩", "	hua1",
		"嘨", "	xiao4",
		"嘧", "	mi4",
		"嘦", "	jiao4",
		"嘥", "	sai",
		"嘤", "	ying1",
		"嘣", "	beng1",
		"嘢", "	ye3",
		"嘡", "	tang1",
		"嘠", "	ga1",
		"喜", "	xi3",
		"喚", "	huan4",
		"噫", "	yi1",
		"唌", "	xian2",
		"唖", "	ya3",
		"唕", "	zao4",
		"唔", "	wu2",
		"唓", "	che1",
		"唒", "	qiu2",
		"唑", "	zuo4",
		"唐", "	tang2",
		"唏", "	xi1",
		"唎", "	li4",
		"唍", "	wan3",
		"唋", "	tu1",
		"唘", "	qi3",
		"唊", "	jia2",
		"唉", "	ai1",
		"唈", "	yi4",
		"唇", "	chun2",
		"唆", "	suo1",
		"唅", "	han2",
		"唄", "	bei",
		"唃", "	gu3",
		"唂", "	gu1",
		"唁", "	yan4",
		"唗", "	dou1",
		"唙", "	di2",
		"哿", "	ge3",
		"唦", "	sha1",
		"唰", "	shua1",
		"唯", "	wei2",
		"售", "	shou4",
		"唭", "	qi4",
		"唬", "	hu3",
		"唫", "	jin4",
		"唪", "	feng3",
		"唩", "	wo1",
		"唨", "	zuo3",
		"唧", "	ji1",
		"唥", "	lang",
		"唚", "	qin4",
		"唤", "	huan4",
		"唣", "	zao4",
		"唢", "	suo3",
		"唡", "	liang3",
		"唠", "	lao2",
		"唟", "	qu4",
		"唞", "	dou3",
		"唝", "	gong4",
		"唜", "	mo4",
		"唛", "	ma4",
		"唀", "	you4",
		"哾", "	shuo1",
		"唲", "	er2",
		"哘", "	xing",
		"哢", "	long4",
		"員", "	yuan2",
		"哠", "	hao4",
		"哟", "	yo1",
		"哞", "	mou1",
		"哝", "	nong2",
		"哜", "	ji4",
		"哛", "	fen1",
		"哚", "	duo3",
		"哙", "	kuai4",
		"哗", "	hua1",
		"哤", "	mang2",
		"哖", "	nian2",
		"哕", "	hui4",
		"哔", "	bi4",
		"哓", "	xiao1",
		"哒", "	da1",
		"哑", "	ya3",
		"哐", "	kuang1",
		"哏", "	gen2",
		"哎", "	ai1",
		"响", "	xiang3",
		"哣", "	pou3",
		"哥", "	ge1",
		"哽", "	geng3",
		"哲", "	zhe2",
		"哼", "	heng1",
		"哻", "	han4",
		"哺", "	bu3",
		"哹", "	fu2",
		"哸", "	sui1",
		"哷", "	lie4",
		"哶", "	mie1",
		"哵", "	ba1",
		"哴", "	liang4",
		"哳", "	zha1",
		"哱", "	bo1",
		"哦", "	o2",
		"哰", "	lao2",
		"哯", "	xian4",
		"哮", "	xiao1",
		"哭", "	ku1",
		"哬", "	he2",
		"哫", "	zu2",
		"哪", "	na3",
		"哩", "	li1",
		"哨", "	shao4",
		"哧", "	chi1",
		"唱", "	chang4",
		"唳", "	li4",
		"喙", "	hui4",
		"啴", "	chan3",
		"啾", "	jiu1",
		"啽", "	an2",
		"啼", "	ti2",
		"啻", "	chi4",
		"啺", "	tang2",
		"啹", "	ju2",
		"啸", "	xiao4",
		"啷", "	lang1",
		"啶", "	ding4",
		"啵", "	bo",
		"啳", "	quan2",
		"喀", "	ka1",
		"啲", "	di4",
		"啱", "	yan1",
		"啰", "	luo1",
		"啯", "	guo1",
		"啮", "	nie4",
		"啭", "	zhuan4",
		"啬", "	se4",
		"啫", "	zhe3",
		"啪", "	pa1",
		"啩", "	gua4",
		"啿", "	dan4",
		"喁", "	yong2",
		"啧", "	ze2",
		"喎", "	wai1",
		"喘", "	chuan3",
		"喗", "	yun3",
		"喖", "	hu2",
		"喕", "	mian3",
		"喔", "	o1",
		"喓", "	yao1",
		"喒", "	za2",
		"喑", "	yin1",
		"喐", "	yu4",
		"喏", "	nuo4",
		"喍", "	chai2",
		"喂", "	wei4",
		"喌", "	zhou1",
		"喋", "	die2",
		"喊", "	han3",
		"喉", "	hou2",
		"喈", "	jie1",
		"喇", "	la3",
		"喆", "	zhe2",
		"喅", "	yu4",
		"善", "	shan4",
		"喃", "	nan2",
		"啨", "	ying1",
		"啦", "	la",
		"唴", "	qiang4",
		"啀", "	ai2",
		"啊", "	a",
		"啉", "	lin2",
		"啈", "	heng1",
		"啇", "	di4",
		"商", "	shang1",
		"啅", "	zhuo2",
		"啄", "	zhuo2",
		"啃", "	ken3",
		"啂", "	nou3",
		"啁", "	zhao1",
		"唿", "	hu1",
		"啌", "	xiang1",
		"唾", "	tuo4",
		"唽", "	xi1",
		"唼", "	sha4",
		"唻", "	lai4",
		"唺", "	tian3",
		"唹", "	yu1",
		"唸", "	nian4",
		"唷", "	yo1",
		"唶", "	ze2",
		"唵", "	an3",
		"啋", "	cai3",
		"啍", "	tun1",
		"啥", "	sha4",
		"啚", "	bi3",
		"啤", "	pi2",
		"啣", "	xian2",
		"啢", "	liang3",
		"啡", "	fei1",
		"啠", "	zhe2",
		"啟", "	qi3",
		"啞", "	ya3",
		"啝", "	he2",
		"啜", "	chuai4",
		"啛", "	cui4",
		"啙", "	zi3",
		"啎", "	wu3",
		"啘", "	ye4",
		"啗", "	dan4",
		"啖", "	dan4",
		"啕", "	tao2",
		"啔", "	qi3",
		"啓", "	qi3",
		"啒", "	gu3",
		"啑", "	sha4",
		"啐", "	cui4",
		"問", "	wen4",
		"噪", "	zao4",
		"噬", "	shi4",
		"哋", "	die4",
		"坾", "	zhu4",
		"垈", "	dai4",
		"垇", "	ao4",
		"垆", "	lu2",
		"垅", "	long3",
		"垄", "	long3",
		"垃", "	la1",
		"垂", "	chui2",
		"垁", "	zhi4",
		"垀", "	hu1",
		"坿", "	fu4",
		"坽", "	ling2",
		"垊", "	min",
		"坼", "	che4",
		"坻", "	chi2",
		"坺", "	ba2",
		"坹", "	xue4",
		"坸", "	gou4",
		"坷", "	ke3",
		"坶", "	mu3",
		"坵", "	qiu1",
		"坴", "	lu4",
		"坳", "	ao4",
		"垉", "	pao2",
		"型", "	xing2",
		"坱", "	yang3",
		"垘", "	fu2",
		"垢", "	gou4",
		"垡", "	fa2",
		"垠", "	yin2",
		"垟", "	yang2",
		"垞", "	cha2",
		"垝", "	gui3",
		"垜", "	duo3",
		"垛", "	duo3",
		"垚", "	yao2",
		"垙", "	guang1",
		"垗", "	zhao4",
		"垌", "	dong4",
		"垖", "	dui1",
		"垕", "	hou4",
		"垔", "	yin1",
		"垓", "	gai1",
		"垒", "	lei3",
		"垑", "	chi3",
		"垐", "	ci2",
		"垏", "	lv4",
		"垎", "	he4",
		"垍", "	ji4",
		"坲", "	fo2",
		"坰", "	jiong1",
		"垤", "	die2",
		"坊", "	fang1",
		"坔", "	di4",
		"坓", "	jing3",
		"坒", "	bi4",
		"坑", "	keng1",
		"坐", "	zuo4",
		"坏", "	huai4",
		"坎", "	kan3",
		"坍", "	tan1",
		"坌", "	ben4",
		"坋", "	ben4",
		"坉", "	tun2",
		"坖", "	ji4",
		"坈", "	rong3",
		"均", "	jun1",
		"坆", "	mei2",
		"坅", "	qin3",
		"坄", "	yi4",
		"坃", "	xun1",
		"坂", "	ban3",
		"坁", "	zhi3",
		"址", "	zhi3",
		"圿", "	jia2",
		"坕", "	jing1",
		"块", "	kuai4",
		"坯", "	pi1",
		"坤", "	kun1",
		"坮", "	tai2",
		"坭", "	ni2",
		"坬", "	gua4",
		"坫", "	dian4",
		"坪", "	ping2",
		"坩", "	gan1",
		"坨", "	tuo2",
		"坧", "	zhi1",
		"坦", "	tan3",
		"坥", "	qu1",
		"坣", "	tang1",
		"坘", "	di3",
		"坢", "	ban4",
		"坡", "	po1",
		"坠", "	zhui4",
		"坟", "	fen2",
		"坞", "	wu4",
		"坝", "	ba4",
		"坜", "	li4",
		"坛", "	tan2",
		"坚", "	jian1",
		"坙", "	jing1",
		"垣", "	yuan2",
		"垥", "	xie2",
		"圽", "	mo4",
		"埦", "	wan3",
		"埰", "	cai4",
		"埯", "	an3",
		"埮", "	tan4",
		"埭", "	dai4",
		"埬", "	dong1",
		"埫", "	chong3",
		"埪", "	kong1",
		"埩", "	zheng1",
		"埨", "	lun3",
		"埧", "	ju4",
		"埥", "	qing1",
		"埲", "	beng3",
		"埤", "	pi2",
		"埣", "	sui4",
		"埢", "	quan2",
		"埡", "	ya1",
		"埠", "	bu4",
		"域", "	yu4",
		"埞", "	di3",
		"埝", "	nian4",
		"埜", "	ye3",
		"埛", "	jiong1",
		"埱", "	chu4",
		"埳", "	kan3",
		"埙", "	xun1",
		"堀", "	ku1",
		"堊", "	e4",
		"堉", "	yu4",
		"堈", "	gang1",
		"堇", "	jin3",
		"堆", "	dui1",
		"堅", "	jian1",
		"堄", "	ni4",
		"堃", "	kun1",
		"堂", "	tang2",
		"堁", "	ke4",
		"埿", "	ni2",
		"埴", "	zhi2",
		"埾", "	ju4",
		"埽", "	sao4",
		"埼", "	qi2",
		"埻", "	zhun3",
		"基", "	ji1",
		"培", "	pei2",
		"埸", "	yi4",
		"執", "	zhi2",
		"埶", "	yi4",
		"埵", "	duo3",
		"埚", "	guo1",
		"埘", "	shi2",
		"垦", "	ken3",
		"垲", "	kai3",
		"垼", "	yi4",
		"垻", "	ba4",
		"垺", "	fu1",
		"垹", "	bang1",
		"垸", "	yuan4",
		"垷", "	xian4",
		"垶", "	xing1",
		"垵", "	an3",
		"垴", "	nao3",
		"垳", "	hang",
		"垱", "	dang4",
		"垾", "	han4",
		"垰", "	ka",
		"垯", "	da",
		"垮", "	kua3",
		"垭", "	ya1",
		"垬", "	hong2",
		"垫", "	dian4",
		"垪", "	bing",
		"垩", "	e4",
		"垨", "	shou3",
		"垧", "	shang3",
		"垽", "	yin4",
		"垿", "	xu4",
		"埗", "	bu4",
		"埌", "	lang4",
		"埖", "	hua",
		"埕", "	cheng2",
		"埔", "	bu4",
		"埓", "	lie4",
		"埒", "	lie4",
		"埑", "	zhe2",
		"埐", "	jin1",
		"埏", "	shan1",
		"城", "	cheng2",
		"埍", "	juan3",
		"埋", "	mai2",
		"埀", "	chui2",
		"埊", "	di4",
		"埉", "	jia1",
		"埈", "	jun4",
		"埇", "	yong3",
		"埆", "	que4",
		"埅", "	fang2",
		"埄", "	beng3",
		"埃", "	ai1",
		"埂", "	geng3",
		"埁", "	qin2",
		"圾", "	ji1",
		"圼", "	nie4",
		"噭", "	jiao4",
		"嚭", "	pi3",
		"嚷", "	rang3",
		"嚶", "	ying1",
		"嚵", "	chan2",
		"嚴", "	yan2",
		"嚳", "	ku4",
		"嚲", "	duo3",
		"嚱", "	xi4",
		"嚰", "	mo2",
		"嚯", "	huo4",
		"嚮", "	xiang4",
		"嚬", "	pin2",
		"嚹", "	la2",
		"嚫", "	chen4",
		"嚪", "	dan4",
		"嚩", "	mo2",
		"嚨", "	long2",
		"嚧", "	lu2",
		"嚦", "	li4",
		"嚥", "	yan4",
		"嚤", "	mo2",
		"嚣", "	xiao1",
		"嚢", "	nang2",
		"嚸", "	dian3",
		"嚺", "	ta4",
		"嚠", "	liu2",
		"囇", "	li4",
		"囑", "	zhu3",
		"囐", "	za2",
		"囏", "	jian1",
		"囎", "	zen",
		"囍", "	xi3",
		"囌", "	su1",
		"囋", "	za2",
		"囊", "	nang2",
		"囉", "	luo1",
		"囈", "	yi4",
		"囆", "	chai4",
		"嚻", "	xiao1",
		"囅", "	chan3",
		"囄", "	li2",
		"囃", "	ca4",
		"囂", "	xiao1",
		"囁", "	nie4",
		"囀", "	zhuan4",
		"嚿", "	huo4",
		"嚾", "	huan1",
		"嚽", "	chuo4",
		"嚼", "	jue2",
		"嚡", "	hai",
		"嚟", "	li2",
		"囓", "	nie4",
		"噹", "	dang1",
		"嚃", "	ta1",
		"嚂", "	lan4",
		"嚁", "	di2",
		"嚀", "	ning2",
		"噿", "	zui3",
		"噾", "	yin1",
		"噽", "	pi3",
		"噼", "	pi1",
		"噻", "	sai1",
		"噺", "	xin",
		"噸", "	dun1",
		"嚅", "	ru2",
		"噷", "	hm",
		"噶", "	ga2",
		"噵", "	dao4",
		"噴", "	pen1",
		"噳", "	yu3",
		"噲", "	kuai4",
		"噱", "	jue2",
		"噰", "	yong1",
		"噯", "	ai1",
		"噮", "	yuan4",
		"嚄", "	huo1",
		"嚆", "	hao1",
		"嚞", "	zhe2",
		"嚓", "	ca1",
		"嚝", "	hong1",
		"嚜", "	me",
		"嚛", "	hu4",
		"嚚", "	yin2",
		"嚙", "	nie4",
		"嚘", "	you1",
		"嚗", "	bo2",
		"嚖", "	hui4",
		"嚕", "	lu3",
		"嚔", "	ti4",
		"嚒", "	me",
		"嚇", "	xia4",
		"嚑", "	xun",
		"嚐", "	chang2",
		"嚏", "	ti4",
		"嚎", "	hao2",
		"嚍", "	jin4",
		"嚌", "	ji4",
		"嚋", "	chou2",
		"嚊", "	pi4",
		"嚉", "	duo1",
		"嚈", "	ye4",
		"囒", "	lan2",
		"囔", "	nang1",
		"圻", "	qi2",
		"圖", "	tu2",
		"圠", "	ya4",
		"土", "	tu3",
		"圞", "	luan2",
		"圝", "	luan2",
		"圜", "	huan2",
		"圛", "	yi4",
		"圚", "	hui4",
		"圙", "	lue4",
		"團", "	tuan2",
		"圗", "	tu2",
		"圕", "	tu2",
		"圢", "	ting3",
		"圔", "	ya4",
		"圓", "	yuan2",
		"園", "	yuan2",
		"圑", "	fu4",
		"圐", "	ku1",
		"圏", "	quan1",
		"圎", "	yuan2",
		"圍", "	wei2",
		"圌", "	chuan2",
		"國", "	guo2",
		"圡", "	tu3",
		"圣", "	sheng4",
		"圉", "	yu3",
		"地", "	di4",
		"场", "	chang3",
		"圹", "	kuang4",
		"圸", "	shan",
		"圷", "	xia",
		"圶", "	qia4",
		"圵", "	dang4",
		"圴", "	zhuo2",
		"圳", "	zhen4",
		"圲", "	qian1",
		"圱", "	qian1",
		"圯", "	yi2",
		"圤", "	pu3",
		"圮", "	pi3",
		"圭", "	gui1",
		"圬", "	wu1",
		"圫", "	yu4",
		"圪", "	ge1",
		"圩", "	wei2",
		"在", "	zai4",
		"圧", "	ya1",
		"圦", "	kuai",
		"圥", "	lu4",
		"圊", "	qing1",
		"圈", "	quan1",
		"囕", "	lan3",
		"囡", "	nan1",
		"囫", "	hu2",
		"囪", "	cong1",
		"囩", "	yun2",
		"囨", "	pian1",
		"囧", "	jiong3",
		"囦", "	yuan1",
		"囥", "	kang4",
		"囤", "	dun4",
		"団", "	tuan2",
		"团", "	tuan2",
		"因", "	yin1",
		"园", "	yuan2",
		"囟", "	xin4",
		"回", "	hui2",
		"囝", "	jian3",
		"囜", "	nin2",
		"四", "	si4",
		"囚", "	qiu2",
		"囙", "	yin1",
		"囘", "	hui2",
		"囗", "	wei2",
		"囖", "	lo",
		"囬", "	hui2",
		"囮", "	e2",
		"圇", "	lun2",
		"囼", "	tai1",
		"圆", "	yuan2",
		"圅", "	han2",
		"圄", "	yu3",
		"圃", "	pu3",
		"圂", "	hun4",
		"圁", "	yin2",
		"圀", "	guo2",
		"囿", "	you4",
		"图", "	tu2",
		"国", "	guo2",
		"囻", "	guo2",
		"囯", "	guo2",
		"固", "	gu4",
		"囹", "	ling2",
		"囸", "	ri4",
		"囷", "	qun1",
		"囶", "	guo2",
		"囵", "	lun2",
		"围", "	wei2",
		"図", "	tu2",
		"囲", "	tong1",
		"囱", "	cong1",
		"困", "	kun4",
		"哌", "	pai4",
		"哊", "	you4",
		"堌", "	gu4",
		"力", "	li4",
		"劥", "	keng1",
		"劤", "	jin4",
		"劣", "	lie4",
		"劢", "	mai4",
		"务", "	wu4",
		"加", "	jia1",
		"功", "	gong1",
		"办", "	ban4",
		"劝", "	quan4",
		"劜", "	ya4",
		"劚", "	zhu3",
		"劧", "	zhi3",
		"劙", "	li2",
		"劘", "	mo2",
		"劗", "	jian3",
		"劖", "	chan2",
		"劕", "	zhi4",
		"劔", "	jian4",
		"劓", "	yi4",
		"劒", "	jian4",
		"劑", "	ji4",
		"劐", "	huo1",
		"劦", "	xie2",
		"动", "	dong4",
		"劎", "	jian4",
		"劵", "	juan4",
		"势", "	shi4",
		"劾", "	he2",
		"劽", "	lie4",
		"劼", "	jie2",
		"劻", "	kuang1",
		"劺", "	mou2",
		"効", "	xiao4",
		"劸", "	wa1",
		"劷", "	yang2",
		"劶", "	kou3",
		"労", "	lao2",
		"助", "	zhu4",
		"劳", "	lao2",
		"劲", "	jin4",
		"励", "	li4",
		"劰", "	mo4",
		"劯", "	zhu1",
		"劮", "	yi4",
		"劭", "	shao4",
		"劬", "	qu2",
		"劫", "	jie2",
		"努", "	nu3",
		"劏", "	tang1",
		"劍", "	jian4",
		"勁", "	jin4",
		"剧", "	ju4",
		"剱", "	jian4",
		"剰", "	sheng4",
		"副", "	fu4",
		"剮", "	gua3",
		"剭", "	wu1",
		"剬", "	duan1",
		"剫", "	duo2",
		"剪", "	jian3",
		"剩", "	sheng4",
		"剨", "	huo1",
		"剦", "	yan1",
		"剳", "	da2",
		"剥", "	bo1",
		"剤", "	ji4",
		"剣", "	jian4",
		"剢", "	du1",
		"剡", "	shan4",
		"剠", "	qing2",
		"剟", "	duo1",
		"剞", "	ji1",
		"剝", "	bo1",
		"剜", "	wan1",
		"割", "	ge1",
		"剴", "	kai3",
		"劌", "	gui4",
		"劁", "	qiao1",
		"劋", "	jiao3",
		"劊", "	gui4",
		"劉", "	liu2",
		"劈", "	pi1",
		"劇", "	ju4",
		"劆", "	lian2",
		"劅", "	zhuo4",
		"劄", "	zha1",
		"劃", "	hua4",
		"劂", "	jue2",
		"劀", "	gua1",
		"創", "	chuang4",
		"剿", "	jiao3",
		"剾", "	kou1",
		"剽", "	piao1",
		"剼", "	shan1",
		"剻", "	peng3",
		"剺", "	li2",
		"剹", "	lu4",
		"剸", "	tuan2",
		"剷", "	chan3",
		"剶", "	chuan1",
		"勀", "	ke4",
		"勂", "	gao4",
		"剚", "	zi4",
		"匃", "	gai4",
		"匍", "	pu2",
		"匌", "	ge2",
		"匋", "	tao2",
		"匊", "	ju1",
		"匉", "	peng1",
		"匈", "	xiong1",
		"匇", "	yi",
		"匆", "	cong1",
		"包", "	bao1",
		"匄", "	gai4",
		"匂", "	bi",
		"匏", "	pao2",
		"匁", "	wen2",
		"匀", "	yun2",
		"勿", "	wu4",
		"勾", "	gou1",
		"勽", "	bao4",
		"勼", "	jiu1",
		"勻", "	yun2",
		"勺", "	shao2",
		"勹", "	bao1",
		"勸", "	quan4",
		"匎", "	e4",
		"匐", "	fu2",
		"勶", "	che4",
		"匝", "	za1",
		"匧", "	qie4",
		"匦", "	gui3",
		"匥", "	bian4",
		"匤", "	qu1",
		"匣", "	xia2",
		"匢", "	hu1",
		"匡", "	kuang1",
		"匠", "	jiang4",
		"匟", "	kang4",
		"匞", "	jiang4",
		"匜", "	yi2",
		"匑", "	gong1",
		"匛", "	jiu4",
		"匚", "	fang1",
		"匙", "	shi",
		"匘", "	nao3",
		"北", "	bei3",
		"化", "	hua4",
		"匕", "	bi3",
		"匔", "	qiong1",
		"匓", "	jiu4",
		"匒", "	da2",
		"勷", "	rang2",
		"勵", "	li4",
		"勃", "	bo2",
		"勏", "	bu4",
		"務", "	wu4",
		"勘", "	kan1",
		"勗", "	xu4",
		"勖", "	xu4",
		"動", "	dong4",
		"勔", "	mian3",
		"勓", "	kai4",
		"勒", "	lei1",
		"勑", "	chi4",
		"勐", "	meng3",
		"勎", "	lu4",
		"勛", "	xun1",
		"勍", "	qing2",
		"勌", "	juan4",
		"勋", "	xun1",
		"勊", "	ke4",
		"勉", "	mian3",
		"勈", "	yong3",
		"勇", "	yong3",
		"勆", "	lang2",
		"勅", "	chi4",
		"勄", "	min3",
		"勚", "	yi4",
		"勜", "	weng3",
		"勴", "	lv4",
		"勩", "	yi4",
		"勳", "	xun1",
		"勲", "	xun1",
		"勱", "	mai4",
		"勰", "	xie2",
		"勯", "	dan1",
		"勮", "	ju4",
		"勭", "	tong2",
		"勬", "	juan1",
		"勫", "	fan1",
		"勪", "	jue2",
		"勨", "	xiang4",
		"勝", "	sheng4",
		"勧", "	quan4",
		"勦", "	chao1",
		"勥", "	jiang4",
		"勤", "	qin2",
		"勣", "	ji1",
		"勢", "	shi4",
		"勡", "	piao4",
		"勠", "	lu4",
		"募", "	mu4",
		"勞", "	lao2",
		"剛", "	gang1",
		"剙", "	chuang4",
		"匩", "	kuang1",
		"凋", "	diao1",
		"凕", "	ming3",
		"凔", "	chuang4",
		"凓", "	li4",
		"凒", "	yi2",
		"凑", "	cou4",
		"凐", "	yin1",
		"减", "	jian3",
		"凎", "	gan4",
		"凍", "	dong4",
		"凌", "	ling2",
		"凊", "	qing4",
		"凗", "	cui1",
		"凉", "	liang2",
		"凈", "	jing4",
		"凇", "	song1",
		"准", "	zhun3",
		"凅", "	gu4",
		"凄", "	qi1",
		"凃", "	tu2",
		"凂", "	mei3",
		"凁", "	shu4",
		"净", "	jing4",
		"凖", "	zhun",
		"凘", "	si1",
		"冾", "	qia4",
		"凥", "	ju1",
		"凯", "	kai3",
		"凮", "	feng1",
		"凭", "	ping2",
		"凬", "	feng1",
		"凫", "	fu2",
		"凪", "	zhi",
		"凩", "	mu",
		"凨", "	feng1",
		"凧", "	zheng",
		"処", "	chu3",
		"凤", "	feng4",
		"凙", "	duo2",
		"凣", "	fan2",
		"凢", "	fan2",
		"凡", "	fan2",
		"几", "	ji3",
		"凟", "	du2",
		"凞", "	xi1",
		"凝", "	ning2",
		"凜", "	lin3",
		"凛", "	lin3",
		"凚", "	jin4",
		"冿", "	jian1",
		"冽", "	lie4",
		"凱", "	kai3",
		"冗", "	rong3",
		"冡", "	meng2",
		"冠", "	guan1",
		"冟", "	shi4",
		"冞", "	mi2",
		"冝", "	yi2",
		"农", "	nong2",
		"军", "	jun1",
		"冚", "	kan3",
		"写", "	xie3",
		"冘", "	yin2",
		"冖", "	mi4",
		"冣", "	ju4",
		"冕", "	mian3",
		"冔", "	xu3",
		"冓", "	gou4",
		"冒", "	mao4",
		"冑", "	zhou4",
		"冐", "	mao4",
		"冏", "	jiong3",
		"冎", "	gua3",
		"再", "	zai4",
		"册", "	ce4",
		"冢", "	zhong3",
		"冤", "	yuan1",
		"冼", "	xian3",
		"冱", "	hu4",
		"冻", "	dong4",
		"冺", "	min3",
		"冹", "	fu2",
		"冸", "	pan4",
		"冷", "	leng3",
		"冶", "	ye3",
		"况", "	kuang4",
		"冴", "	hu4",
		"决", "	jue2",
		"冲", "	chong1",
		"冰", "	bing1",
		"冥", "	ming2",
		"冯", "	feng2",
		"冮", "	gang1",
		"冭", "	tai2",
		"冬", "	dong1",
		"冫", "	bing1",
		"冪", "	mi4",
		"冩", "	xie3",
		"冨", "	fu4",
		"冧", "	lin2",
		"冦", "	kou4",
		"凰", "	huang2",
		"凲", "	gan1",
		"剘", "	qi2",
		"刳", "	ku1",
		"刽", "	gui4",
		"刼", "	jie2",
		"刻", "	ke4",
		"刺", "	ci4",
		"刹", "	sha1",
		"券", "	quan4",
		"刷", "	shua1",
		"制", "	zhi4",
		"刵", "	er4",
		"刴", "	duo4",
		"刲", "	kui1",
		"刿", "	gui4",
		"刱", "	chuang4",
		"到", "	dao4",
		"刯", "	geng1",
		"刮", "	gua1",
		"刭", "	jing3",
		"刬", "	chan3",
		"别", "	bie2",
		"刪", "	shan1",
		"利", "	li4",
		"刨", "	pao2",
		"刾", "	ci4",
		"剀", "	kai3",
		"刦", "	jie2",
		"前", "	qian2",
		"剗", "	chan3",
		"剖", "	pou1",
		"剕", "	fei4",
		"剔", "	ti1",
		"剓", "	li2",
		"剒", "	cuo4",
		"剑", "	jian4",
		"剐", "	gua3",
		"剏", "	chuang4",
		"剎", "	sha1",
		"剌", "	la2",
		"剁", "	duo4",
		"剋", "	ke4",
		"削", "	xue1",
		"剉", "	cuo4",
		"剈", "	yuan1",
		"則", "	ze2",
		"剆", "	luo3",
		"剅", "	lou2",
		"剄", "	jing3",
		"剃", "	ti4",
		"剂", "	ji4",
		"刧", "	jie2",
		"別", "	bie2",
		"凳", "	deng4",
		"凿", "	zao2",
		"刉", "	ji1",
		"刈", "	yi4",
		"切", "	qie4",
		"分", "	fen1",
		"刅", "	chuang1",
		"刄", "	ren4",
		"刃", "	ren4",
		"刂", "	dao1",
		"刁", "	diao1",
		"刀", "	dao1",
		"凾", "	han2",
		"刋", "	qian4",
		"函", "	han2",
		"凼", "	dang4",
		"击", "	ji1",
		"出", "	chu1",
		"凹", "	ao1",
		"凸", "	tu1",
		"凷", "	kuai4",
		"凶", "	xiong1",
		"凵", "	qian3",
		"凴", "	ping2",
		"刊", "	kan1",
		"刌", "	cun3",
		"判", "	pan4",
		"则", "	ze2",
		"刣", "	zhong1",
		"刢", "	ling2",
		"刡", "	min3",
		"删", "	shan1",
		"刟", "	ju1",
		"刞", "	qu4",
		"初", "	chu1",
		"刜", "	fu2",
		"创", "	chuang4",
		"刚", "	gang1",
		"刘", "	liu2",
		"刍", "	chu2",
		"列", "	lie4",
		"刖", "	yue4",
		"刕", "	li2",
		"刔", "	jue2",
		"刓", "	wan2",
		"划", "	hua4",
		"刑", "	xing2",
		"刐", "	dan3",
		"刏", "	ji1",
		"刎", "	wen3",
		"匨", "	zang1",
		"匪", "	fei3",
		"哉", "	zai1",
		"吼", "	hou3",
		"呆", "	dai1",
		"呅", "	mei2",
		"呄", "	ge2",
		"呃", "	e4",
		"呂", "	lv3",
		"呁", "	jun4",
		"呀", "	ya",
		"吿", "	gao4",
		"吾", "	wu2",
		"吽", "	hong1",
		"吻", "	wen3",
		"呈", "	cheng2",
		"吺", "	dou1",
		"吹", "	chui1",
		"吸", "	xi1",
		"吷", "	xue4",
		"吶", "	na4",
		"吵", "	chao3",
		"吴", "	wu2",
		"吳", "	wu2",
		"吲", "	yin3",
		"吱", "	zhi1",
		"呇", "	qi3",
		"呉", "	wu2",
		"启", "	qi3",
		"呖", "	li4",
		"呠", "	pen3",
		"呟", "	juan3",
		"呞", "	shi1",
		"呝", "	e4",
		"呜", "	wu1",
		"呛", "	qiang1",
		"呚", "	wen",
		"呙", "	guo1",
		"员", "	yuan2",
		"呗", "	bei",
		"呕", "	ou3",
		"告", "	gao4",
		"呔", "	dai1",
		"呓", "	yi4",
		"呒", "	fu3",
		"呑", "	tun1",
		"呐", "	na4",
		"呏", "	sheng1",
		"呎", "	chi3",
		"呍", "	hong1",
		"呌", "	jiao4",
		"呋", "	fu1",
		"吰", "	hong2",
		"吮", "	shun3",
		"呢", "	ne",
		"合", "	he2",
		"吒", "	zha1",
		"向", "	xiang4",
		"吐", "	tu3",
		"吏", "	li4",
		"后", "	hou4",
		"名", "	ming2",
		"同", "	tong2",
		"吋", "	cun4",
		"吊", "	diao4",
		"吉", "	ji2",
		"吇", "	zi3",
		"吔", "	ye3",
		"吆", "	yao1",
		"吅", "	xuan1",
		"各", "	ge4",
		"吃", "	chi1",
		"吂", "	mang2",
		"吁", "	xu1",
		"吀", "	mie1",
		"叿", "	hong1",
		"叾", "	liao3",
		"叽", "	ji1",
		"吓", "	xia4",
		"吕", "	lv3",
		"吭", "	keng1",
		"吢", "	qin4",
		"听", "	ting1",
		"含", "	han2",
		"吪", "	e2",
		"吩", "	fen1",
		"吨", "	dun1",
		"吧", "	ba",
		"否", "	fou3",
		"吥", "	bu4",
		"吤", "	jie4",
		"吣", "	qin4",
		"吡", "	bi3",
		"吖", "	ya1",
		"吠", "	fei4",
		"吟", "	yin2",
		"吞", "	tun1",
		"吝", "	lin4",
		"吜", "	chou3",
		"君", "	jun1",
		"吚", "	yi1",
		"吙", "	huo1",
		"吘", "	ou3",
		"吗", "	ma",
		"呡", "	wen3",
		"呣", "	m2",
		"叻", "	le4",
		"咤", "	zha4",
		"咮", "	zhou4",
		"咭", "	ji1",
		"咬", "	yao3",
		"咫", "	zhi3",
		"咪", "	mi1",
		"咩", "	mie1",
		"咨", "	zi1",
		"咧", "	lie3",
		"咦", "	yi2",
		"咥", "	xi4",
		"咣", "	guang1",
		"咰", "	shu4",
		"咢", "	e4",
		"咡", "	er4",
		"咠", "	qi4",
		"咟", "	huo4",
		"咞", "	xian4",
		"咝", "	si1",
		"咜", "	ta",
		"咛", "	ning2",
		"咚", "	dong1",
		"咙", "	long2",
		"咯", "	ge1",
		"咱", "	zan2",
		"咗", "	zuo",
		"咾", "	lao3",
		"哈", "	ha1",
		"哇", "	wa",
		"哆", "	duo1",
		"哅", "	xiong1",
		"哄", "	hong1",
		"哃", "	tong2",
		"哂", "	shen3",
		"品", "	pin3",
		"哀", "	ai1",
		"咿", "	yi1",
		"咽", "	yan4",
		"咲", "	xiao4",
		"咼", "	guo1",
		"咻", "	xiu1",
		"咺", "	xuan3",
		"咹", "	e4",
		"咸", "	xian2",
		"咷", "	tao2",
		"咶", "	huai4",
		"咵", "	kua3",
		"咴", "	hui1",
		"咳", "	hai1",
		"咘", "	bu4",
		"咖", "	ka1",
		"呤", "	ling4",
		"呰", "	zi3",
		"呺", "	xiao1",
		"呹", "	yi4",
		"呸", "	pei1",
		"呷", "	ga1",
		"呶", "	nao2",
		"呵", "	a1",
		"呴", "	xu3",
		"味", "	wei4",
		"呲", "	ci1",
		"呱", "	gu1",
		"呯", "	ping2",
		"呼", "	hu1",
		"呮", "	qi4",
		"呭", "	yi4",
		"呬", "	xi4",
		"呫", "	tie4",
		"呪", "	zhou4",
		"呩", "	shi4",
		"周", "	zhou1",
		"呧", "	di3",
		"呦", "	you1",
		"呥", "	ran2",
		"呻", "	shen1",
		"命", "	ming4",
		"咕", "	gu1",
		"咊", "	he2",
		"咔", "	ka1",
		"咓", "	wa3",
		"咒", "	zhou4",
		"咑", "	da1",
		"咐", "	fu4",
		"咏", "	yong3",
		"咎", "	jiu4",
		"咍", "	hai1",
		"和", "	he2",
		"咋", "	za3",
		"咉", "	yang1",
		"呾", "	da2",
		"咈", "	fu2",
		"咇", "	bie2",
		"咆", "	pao2",
		"咅", "	pou3",
		"咄", "	duo1",
		"咃", "	tuo1",
		"咂", "	za1",
		"咁", "	han2",
		"咀", "	ju3",
		"呿", "	qu4",
		"叼", "	diao1",
		"叺", "	chi3",
		"匫", "	hu1",
		"卫", "	wei4",
		"卵", "	luan3",
		"却", "	que4",
		"即", "	ji2",
		"卲", "	shao4",
		"危", "	wei1",
		"印", "	yin4",
		"卯", "	mao3",
		"卮", "	zhi1",
		"卭", "	qiong2",
		"卬", "	ang2",
		"卪", "	jie2",
		"卷", "	juan3",
		"卩", "	jie2",
		"卨", "	xie4",
		"卧", "	wo4",
		"卦", "	gua4",
		"卥", "	xi1",
		"卤", "	lu3",
		"卣", "	you3",
		"卢", "	lu2",
		"卡", "	ka3",
		"占", "	zhan4",
		"卶", "	chi3",
		"卸", "	xie4",
		"卞", "	bian4",
		"厅", "	ting1",
		"厏", "	zha3",
		"厎", "	di3",
		"厍", "	she4",
		"厌", "	yan4",
		"压", "	ya1",
		"厊", "	ya3",
		"厉", "	li4",
		"厈", "	han3",
		"厇", "	zhe2",
		"历", "	li4",
		"厄", "	e4",
		"卹", "	xu4",
		"厃", "	wei3",
		"厂", "	chang3",
		"厁", "	san",
		"厀", "	xi1",
		"卿", "	qing1",
		"卾", "	e4",
		"卽", "	ji2",
		"卼", "	wu4",
		"卻", "	que4",
		"卺", "	jin3",
		"卟", "	bu3",
		"卝", "	kuang4",
		"厑", "	ya2",
		"匷", "	jue2",
		"十", "	shi2",
		"區", "	qu1",
		"匿", "	ni4",
		"匾", "	bian3",
		"匽", "	yan3",
		"匼", "	ke1",
		"医", "	yi1",
		"区", "	qu1",
		"匹", "	pi3",
		"匸", "	xi4",
		"匶", "	jiu4",
		"千", "	qian1",
		"匵", "	du2",
		"匴", "	suan3",
		"匳", "	lian2",
		"匲", "	lian2",
		"匱", "	gui4",
		"匰", "	dan1",
		"匯", "	hui4",
		"匮", "	kui4",
		"匭", "	gui3",
		"匬", "	yu3",
		"卂", "	xun4",
		"卄", "	nian4",
		"卜", "	bo",
		"卑", "	bei1",
		"卛", "	shuai4",
		"博", "	bo2",
		"卙", "	ji2",
		"単", "	dan1",
		"南", "	nan2",
		"卖", "	mai4",
		"单", "	dan1",
		"協", "	xie2",
		"卓", "	zhuo1",
		"卒", "	zu2",
		"卐", "	wan4",
		"卅", "	sa4",
		"协", "	xie2",
		"华", "	hua2",
		"卍", "	wan4",
		"卌", "	xi4",
		"卋", "	shi4",
		"半", "	ban4",
		"卉", "	hui4",
		"午", "	wu3",
		"升", "	sheng1",
		"卆", "	zu2",
		"厐", "	pang2",
		"厒", "	he2",
		"叹", "	tan4",
		"叔", "	shu1",
		"叞", "	wei4",
		"叝", "	gao4",
		"叜", "	sou3",
		"叛", "	pan4",
		"叚", "	jia3",
		"叙", "	xu4",
		"变", "	bian4",
		"受", "	shou4",
		"取", "	qu3",
		"叕", "	zhuo2",
		"叓", "	shi4",
		"叠", "	die2",
		"叒", "	ruo4",
		"发", "	fa1",
		"叐", "	ba2",
		"叏", "	guai4",
		"収", "	shou1",
		"反", "	fan3",
		"双", "	shuang1",
		"友", "	you3",
		"及", "	ji2",
		"叉", "	cha1",
		"叟", "	sou3",
		"叡", "	rui4",
		"叇", "	dai4",
		"叮", "	ding1",
		"司", "	si1",
		"号", "	hao4",
		"叶", "	ye4",
		"叵", "	po3",
		"叴", "	qiu2",
		"右", "	you4",
		"史", "	shi3",
		"叱", "	chi4",
		"台", "	tai2",
		"可", "	ke3",
		"叭", "	ba1",
		"叢", "	cong2",
		"召", "	zhao4",
		"叫", "	jiao4",
		"只", "	zhi3",
		"叩", "	kou4",
		"叨", "	dao1",
		"叧", "	gua3",
		"另", "	ling4",
		"句", "	ju4",
		"古", "	gu3",
		"口", "	kou3",
		"又", "	you4",
		"叆", "	ai4",
		"厓", "	ya2",
		"原", "	yuan2",
		"厩", "	jiu4",
		"厨", "	chu2",
		"厧", "	dian1",
		"厦", "	sha4",
		"厥", "	jue2",
		"厤", "	li4",
		"厣", "	yan3",
		"厢", "	xiang1",
		"厡", "	yuan2",
		"厠", "	ce4",
		"厞", "	fei4",
		"厫", "	ao2",
		"厝", "	cuo4",
		"厜", "	zui1",
		"厛", "	ting1",
		"厚", "	hou4",
		"厙", "	she4",
		"厘", "	li2",
		"厗", "	ti2",
		"厖", "	pang2",
		"厕", "	ce4",
		"厔", "	zhi4",
		"厪", "	jin3",
		"厬", "	gui3",
		"叅", "	can1",
		"厺", "	qu4",
		"叄", "	can1",
		"參", "	can1",
		"参", "	can1",
		"叁", "	san1",
		"叀", "	zhuan1",
		"县", "	xian4",
		"厾", "	du1",
		"厽", "	lei3",
		"厼", "	er3",
		"去", "	qu4",
		"厹", "	rou2",
		"厭", "	yan4",
		"厸", "	lin2",
		"厷", "	gong1",
		"厶", "	si1",
		"厵", "	yuan2",
		"厴", "	yan3",
		"厳", "	yan2",
		"厲", "	li4",
		"厱", "	lan2",
		"厰", "	chang3",
		"厯", "	li4",
		"厮", "	si1",
		"堋", "	peng2",
		"堍", "	tu4",
		"庎", "	jie4",
		"屠", "	tu2",
		"屪", "	liao2",
		"屩", "	jue1",
		"屨", "	ju4",
		"屧", "	xie4",
		"屦", "	ju4",
		"履", "	lv3",
		"層", "	ceng2",
		"屣", "	xi3",
		"屢", "	lv3",
		"屡", "	lv3",
		"屟", "	xie4",
		"屬", "	shu3",
		"属", "	shu3",
		"屝", "	fei4",
		"屜", "	ti4",
		"屛", "	ping2",
		"屚", "	lou4",
		"屙", "	e1",
		"屘", "	man3",
		"屗", "	wei3",
		"屖", "	xi1",
		"展", "	zhan3",
		"屫", "	jue2",
		"屭", "	xi4",
		"屓", "	xie4",
		"屺", "	qi3",
		"岄", "	yue4",
		"岃", "	ren4",
		"岂", "	qi3",
		"岁", "	sui4",
		"岀", "	chu1",
		"屿", "	yu3",
		"屾", "	shen1",
		"屽", "	han4",
		"屼", "	wu4",
		"屻", "	ren4",
		"屹", "	yi4",
		"屮", "	che4",
		"屸", "	long2",
		"屷", "	hui",
		"屶", "	dao",
		"屵", "	e4",
		"屴", "	li4",
		"屳", "	xian1",
		"屲", "	wa",
		"山", "	shan1",
		"屰", "	ni4",
		"屯", "	tun2",
		"屔", "	ni2",
		"屒", "	zhen3",
		"岆", "	yao3",
		"尬", "	ga4",
		"尶", "	gan1",
		"尵", "	tui2",
		"尴", "	gan1",
		"尳", "	gu3",
		"尲", "	gan1",
		"就", "	jiu4",
		"尰", "	zhong3",
		"尯", "	kui4",
		"尮", "	duo4",
		"尭", "	yao2",
		"尫", "	wang1",
		"尸", "	shi1",
		"尪", "	wang1",
		"尩", "	wang1",
		"尨", "	mang2",
		"尧", "	yao2",
		"尦", "	liao4",
		"尥", "	liao4",
		"尤", "	you2",
		"尣", "	wang1",
		"尢", "	you2",
		"尡", "	kun",
		"尷", "	gan1",
		"尹", "	yin3",
		"屑", "	xie4",
		"屆", "	jie4",
		"屐", "	ji1",
		"屏", "	ping2",
		"屎", "	shi3",
		"屍", "	shi1",
		"屌", "	diao3",
		"屋", "	wu1",
		"届", "	jie4",
		"屉", "	ti4",
		"屈", "	qu1",
		"屇", "	tian2",
		"居", "	ju1",
		"尺", "	chi3",
		"屄", "	bi1",
		"屃", "	xi4",
		"层", "	ceng2",
		"屁", "	pi4",
		"局", "	ju2",
		"尿", "	niao4",
		"尾", "	wei3",
		"尽", "	jin3",
		"尼", "	ni2",
		"尻", "	kao1",
		"岅", "	ban3",
		"岇", "	ang2",
		"尟", "	xian3",
		"峈", "	luo4",
		"峒", "	dong4",
		"峑", "	quan1",
		"峐", "	gai1",
		"峏", "	er2",
		"峎", "	en3",
		"峍", "	lu4",
		"峌", "	die2",
		"峋", "	xun2",
		"峊", "	fu4",
		"峉", "	e4",
		"峇", "	ba1",
		"峔", "	mu3",
		"峆", "	he2",
		"峅", "	bian",
		"峄", "	yi4",
		"峃", "	xue2",
		"峂", "	tong2",
		"峁", "	mao3",
		"峀", "	xiu4",
		"岿", "	kui1",
		"岾", "	han4",
		"岽", "	dong1",
		"峓", "	yi2",
		"峕", "	shi2",
		"岻", "	chi2",
		"峢", "	li3",
		"峬", "	bu1",
		"峫", "	xie2",
		"峪", "	yu4",
		"峩", "	e2",
		"峨", "	e2",
		"峧", "	jiao1",
		"峦", "	luan2",
		"峥", "	zheng1",
		"峤", "	jiao4",
		"峣", "	yao2",
		"峡", "	xia2",
		"峖", "	an1",
		"峠", "	gu",
		"峟", "	you4",
		"峞", "	wei2",
		"峝", "	tong2",
		"峜", "	ji4",
		"峛", "	li3",
		"峚", "	mi4",
		"峙", "	zhi4",
		"峘", "	huan2",
		"峗", "	wei2",
		"岼", "	ping",
		"岺", "	ling2",
		"岈", "	ya2",
		"岔", "	cha4",
		"岞", "	zuo4",
		"岝", "	zuo4",
		"岜", "	ba1",
		"岛", "	dao3",
		"岚", "	lan2",
		"岙", "	ao4",
		"岘", "	xian4",
		"岗", "	gang3",
		"岖", "	qu1",
		"岕", "	jie4",
		"岓", "	qi2",
		"岠", "	ju4",
		"岒", "	qian2",
		"岑", "	cen2",
		"岐", "	qi2",
		"岏", "	wan2",
		"岎", "	fen2",
		"岍", "	qian1",
		"岌", "	ji2",
		"岋", "	e4",
		"岊", "	jie2",
		"岉", "	wu4",
		"岟", "	yang3",
		"岡", "	gang1",
		"岹", "	tiao2",
		"岮", "	tuo2",
		"岸", "	an4",
		"岷", "	min2",
		"岶", "	po4",
		"岵", "	hu4",
		"岴", "	qu1",
		"岳", "	yue4",
		"岲", "	kuang4",
		"岱", "	dai4",
		"岰", "	ao4",
		"岯", "	pi2",
		"岭", "	ling3",
		"岢", "	ke3",
		"岬", "	jia3",
		"岫", "	xiu4",
		"岪", "	fu2",
		"岩", "	yan2",
		"岨", "	qu1",
		"岧", "	tiao2",
		"岦", "	li4",
		"岥", "	po1",
		"岤", "	xue2",
		"岣", "	gou3",
		"尠", "	xian3",
		"尞", "	liao4",
		"峮", "	qun1",
		"宐", "	yi2",
		"定", "	ding4",
		"宙", "	zhou4",
		"官", "	guan1",
		"宗", "	zong1",
		"宖", "	hong2",
		"宕", "	dang4",
		"宔", "	zhu3",
		"宓", "	mi4",
		"宒", "	zhun1",
		"宑", "	jing3",
		"宏", "	hong2",
		"宜", "	yi2",
		"宎", "	yao3",
		"宍", "	rou4",
		"完", "	wan2",
		"宋", "	song4",
		"宊", "	tu1",
		"安", "	an1",
		"守", "	shou3",
		"宇", "	yu3",
		"宆", "	qiong2",
		"宅", "	zhai2",
		"宛", "	wan3",
		"宝", "	bao3",
		"它", "	ta1",
		"宪", "	xian4",
		"宴", "	yan4",
		"害", "	hai4",
		"宲", "	bao3",
		"宱", "	zha4",
		"宰", "	zai3",
		"宯", "	xiao1",
		"宮", "	gong1",
		"宭", "	qun2",
		"宬", "	cheng2",
		"宫", "	gong1",
		"宩", "	shi3",
		"实", "	shi2",
		"宨", "	tiao3",
		"宧", "	yi2",
		"宦", "	huan4",
		"宥", "	you4",
		"室", "	shi4",
		"宣", "	xuan1",
		"客", "	ke4",
		"审", "	shen3",
		"宠", "	chong3",
		"実", "	shi2",
		"宄", "	gui3",
		"宂", "	rong3",
		"家", "	jia1",
		"孜", "	zi1",
		"学", "	xue2",
		"孥", "	nu2",
		"孤", "	gu1",
		"季", "	ji4",
		"孢", "	bao1",
		"孡", "	tai1",
		"孠", "	si4",
		"孟", "	meng4",
		"孞", "	xin4",
		"孝", "	xiao4",
		"孛", "	bei4",
		"孨", "	zhuan3",
		"孚", "	fu2",
		"孙", "	sun1",
		"存", "	cun2",
		"字", "	zi4",
		"孖", "	ma1",
		"孕", "	yun4",
		"孔", "	kong3",
		"孓", "	jue2",
		"孒", "	jue2",
		"孑", "	jie2",
		"孧", "	you",
		"孩", "	hai2",
		"宁", "	ning2",
		"孶", "	zi1",
		"宀", "	mian2",
		"孿", "	luan2",
		"孾", "	ying1",
		"孽", "	nie4",
		"孼", "	nie4",
		"孻", "	nai2",
		"孺", "	ru2",
		"孹", "	bo4",
		"學", "	xue2",
		"孷", "	li2",
		"孵", "	fu1",
		"孪", "	luan2",
		"孴", "	ni3",
		"孳", "	zi1",
		"孲", "	ya1",
		"孱", "	can4",
		"孰", "	shu2",
		"孯", "	qian1",
		"孮", "	cong2",
		"孭", "	mie1",
		"孬", "	nao1",
		"孫", "	sun1",
		"宵", "	xiao1",
		"宷", "	shen3",
		"尝", "	chang2",
		"寸", "	cun4",
		"専", "	zhuan1",
		"封", "	feng1",
		"尀", "	po3",
		"寿", "	shou4",
		"対", "	dui4",
		"寽", "	lv4",
		"导", "	dao3",
		"寻", "	xun2",
		"寺", "	si4",
		"对", "	dui4",
		"寷", "	feng1",
		"射", "	she4",
		"寶", "	bao3",
		"寵", "	chong3",
		"寴", "	qin1",
		"寳", "	bao3",
		"寲", "	yi2",
		"寱", "	yi4",
		"寰", "	huan2",
		"寯", "	jun4",
		"寮", "	liao2",
		"寭", "	hui4",
		"尃", "	fu1",
		"尅", "	ke4",
		"寫", "	xie3",
		"尒", "	er3",
		"尜", "	ga2",
		"尛", "	mo",
		"尚", "	shang4",
		"尙", "	shang4",
		"尘", "	chen2",
		"尗", "	shu1",
		"尖", "	jian1",
		"尕", "	ga3",
		"尔", "	er3",
		"尓", "	er3",
		"少", "	shao3",
		"将", "	jiang1",
		"尐", "	jie2",
		"小", "	xiao3",
		"導", "	dao3",
		"對", "	dui4",
		"尌", "	shu4",
		"尋", "	xun2",
		"尊", "	zun1",
		"尉", "	wei4",
		"專", "	zhuan1",
		"將", "	jiang1",
		"寬", "	kuan1",
		"寪", "	wei3",
		"宸", "	chen2",
		"寄", "	ji4",
		"寎", "	bing4",
		"寍", "	ning2",
		"富", "	fu4",
		"寋", "	jian4",
		"寊", "	zhen1",
		"寉", "	que4",
		"寈", "	qing1",
		"寇", "	kou4",
		"密", "	mi4",
		"寅", "	yin2",
		"寃", "	yuan1",
		"寐", "	mei4",
		"寂", "	ji4",
		"寁", "	zan3",
		"寀", "	cai3",
		"宿", "	su4",
		"宾", "	bin1",
		"宽", "	kuan1",
		"宼", "	kou4",
		"宻", "	mi4",
		"宺", "	huang3",
		"容", "	rong2",
		"寏", "	huan2",
		"寑", "	qin3",
		"審", "	shen3",
		"寞", "	mo4",
		"寨", "	zhai4",
		"寧", "	ning2",
		"實", "	shi2",
		"寥", "	liao2",
		"寤", "	wu4",
		"寣", "	hu1",
		"寢", "	qin3",
		"寡", "	gua3",
		"寠", "	ju4",
		"察", "	cha2",
		"寝", "	qin3",
		"寒", "	han2",
		"寜", "	ning2",
		"寛", "	kuan1",
		"寚", "	bao3",
		"寙", "	yu3",
		"寘", "	zhi4",
		"寗", "	ning2",
		"寖", "	jin4",
		"寕", "	ning2",
		"寔", "	shi2",
		"寓", "	yu4",
		"峭", "	qiao4",
		"峯", "	feng1",
		"孏", "	lan3",
		"币", "	bi4",
		"帋", "	zhi3",
		"帊", "	pa4",
		"帉", "	fen1",
		"师", "	shi1",
		"帇", "	nie4",
		"帆", "	fan1",
		"帅", "	shuai4",
		"帄", "	ding1",
		"布", "	bu4",
		"市", "	shi4",
		"帀", "	za1",
		"帍", "	hu4",
		"巿", "	fu2",
		"巾", "	jin1",
		"巽", "	xun4",
		"巼", "	ba1",
		"巻", "	juan4",
		"巺", "	xun4",
		"巹", "	jin3",
		"巸", "	yi2",
		"巷", "	xiang4",
		"巶", "	zhao1",
		"希", "	xi1",
		"帎", "	dan4",
		"巴", "	ba1",
		"帛", "	bo2",
		"帥", "	shuai4",
		"帤", "	ru2",
		"帣", "	juan3",
		"帢", "	qia4",
		"帡", "	ping2",
		"帠", "	yi4",
		"帟", "	yi4",
		"帞", "	mo4",
		"帝", "	di4",
		"帜", "	zhi4",
		"帚", "	zhou3",
		"帏", "	wei2",
		"帙", "	zhi4",
		"帘", "	lian2",
		"帗", "	bo1",
		"帖", "	tie1",
		"帕", "	pa4",
		"帔", "	pei4",
		"帓", "	mo4",
		"帒", "	dai4",
		"帑", "	tang3",
		"帐", "	zhang4",
		"巵", "	zhi1",
		"巳", "	si4",
		"帧", "	zheng4",
		"巍", "	wei1",
		"巗", "	yan2",
		"巖", "	yan2",
		"巕", "	nie",
		"巔", "	dian1",
		"巓", "	dian1",
		"巒", "	luan2",
		"巑", "	cuan2",
		"巐", "	chao3",
		"巏", "	quan2",
		"巎", "	nao2",
		"巌", "	yan2",
		"巙", "	kui2",
		"巋", "	kui1",
		"巊", "	ying3",
		"巉", "	chan2",
		"巈", "	ju2",
		"巇", "	xi1",
		"巆", "	rong2",
		"巅", "	dian1",
		"巄", "	long2",
		"巃", "	long2",
		"巂", "	gui1",
		"巘", "	yan3",
		"巚", "	yan3",
		"已", "	yi3",
		"巧", "	qiao3",
		"己", "	ji3",
		"巰", "	qiu2",
		"巯", "	qiu2",
		"差", "	cha4",
		"巭", "	pu",
		"巬", "	pu",
		"巫", "	wu1",
		"巪", "	ju4",
		"巩", "	gong3",
		"巨", "	ju4",
		"左", "	zuo3",
		"巛", "	chuan1",
		"工", "	gong1",
		"巤", "	lie4",
		"巣", "	chao2",
		"巢", "	chao2",
		"巡", "	xun2",
		"巠", "	jing1",
		"巟", "	huang1",
		"州", "	zhou1",
		"川", "	chuan1",
		"巜", "	kuai4",
		"带", "	dai4",
		"帨", "	shui4",
		"巀", "	jie2",
		"幩", "	fen2",
		"平", "	ping2",
		"干", "	gan4",
		"幱", "	lan2",
		"幰", "	xian3",
		"幯", "	jie2",
		"幮", "	chu2",
		"幭", "	mie4",
		"幬", "	chou2",
		"幫", "	bang1",
		"幪", "	meng2",
		"幨", "	chan1",
		"幵", "	jian1",
		"幧", "	qiao1",
		"幦", "	mi4",
		"幥", "	zhang",
		"幤", "	bi",
		"幣", "	bi4",
		"幢", "	chuang2",
		"幡", "	fan1",
		"幠", "	hu1",
		"幟", "	zhi4",
		"幞", "	fu2",
		"年", "	nian2",
		"并", "	bing4",
		"幜", "	jing3",
		"広", "	guang3",
		"庍", "	bai4",
		"庌", "	ya3",
		"庋", "	gui3",
		"床", "	chuang2",
		"庉", "	dun4",
		"庈", "	qin2",
		"庇", "	bi4",
		"庆", "	qing4",
		"庅", "	mo2",
		"庄", "	zhuang1",
		"庂", "	ze4",
		"幷", "	bing4",
		"庁", "	ting1",
		"庀", "	pi3",
		"广", "	guang3",
		"幾", "	ji3",
		"幽", "	you1",
		"幼", "	you4",
		"幻", "	huan4",
		"幺", "	yao1",
		"幹", "	gan4",
		"幸", "	xing4",
		"幝", "	chan3",
		"幛", "	zhang4",
		"帩", "	qiao4",
		"帵", "	wan1",
		"帿", "	hou2",
		"帾", "	du3",
		"帽", "	mao4",
		"帼", "	guo2",
		"帻", "	ze2",
		"帺", "	qi2",
		"帹", "	sha4",
		"常", "	chang2",
		"帷", "	wei2",
		"帶", "	dai4",
		"帴", "	san4",
		"幁", "	xu1",
		"帳", "	zhang4",
		"帲", "	ping2",
		"帱", "	chou2",
		"帰", "	gui1",
		"帯", "	dai4",
		"帮", "	bang1",
		"席", "	xi2",
		"帬", "	qun2",
		"師", "	shi1",
		"帪", "	zhen1",
		"幀", "	zheng4",
		"幂", "	mi4",
		"幚", "	bang1",
		"幏", "	jia4",
		"幙", "	mu4",
		"幘", "	ze2",
		"幗", "	guo2",
		"幖", "	biao1",
		"幕", "	mu4",
		"幔", "	man4",
		"幓", "	shan1",
		"幒", "	zhong1",
		"幑", "	hui1",
		"幐", "	teng2",
		"幎", "	mi4",
		"幃", "	wei2",
		"幍", "	tao1",
		"幌", "	huang3",
		"幋", "	pan2",
		"幊", "	gong1",
		"幉", "	die",
		"幈", "	ping2",
		"幇", "	bang1",
		"幆", "	yi4",
		"幅", "	fu2",
		"幄", "	wo4",
		"巁", "	li4",
		"嶿", "	ru",
		"峰", "	feng1",
		"崰", "	zi",
		"崺", "	yi3",
		"崹", "	ti2",
		"崸", "	yang2",
		"崷", "	qiu2",
		"崶", "	feng1",
		"崵", "	yang2",
		"崴", "	wai3",
		"崳", "	yu2",
		"崲", "	huang2",
		"崱", "	ze4",
		"崯", "	yin2",
		"崼", "	shi4",
		"崮", "	gu4",
		"崭", "	zhan3",
		"崬", "	dong1",
		"崫", "	ku1",
		"崪", "	zu2",
		"崩", "	beng1",
		"崨", "	jie2",
		"崧", "	song1",
		"崦", "	yan1",
		"崥", "	pi2",
		"崻", "	zhi4",
		"崽", "	zai3",
		"崣", "	wei3",
		"嵊", "	sheng4",
		"嵔", "	wei3",
		"嵓", "	yan2",
		"嵒", "	yan2",
		"嵑", "	ke3",
		"嵐", "	lan2",
		"嵏", "	zong1",
		"嵎", "	yu2",
		"嵍", "	wu4",
		"嵌", "	qian4",
		"嵋", "	mei2",
		"嵉", "	ting2",
		"崾", "	yao3",
		"嵈", "	huan4",
		"嵇", "	ji1",
		"嵆", "	ji1",
		"嵅", "	han2",
		"嵄", "	mei3",
		"嵃", "	yan3",
		"嵂", "	lv4",
		"嵁", "	kan1",
		"嵀", "	zhu4",
		"崿", "	e4",
		"崤", "	xiao2",
		"崢", "	zheng1",
		"嵖", "	cha2",
		"峼", "	hao4",
		"崆", "	kong1",
		"崅", "	que4",
		"崄", "	xian3",
		"崃", "	lai2",
		"崂", "	lao2",
		"崁", "	kan4",
		"崀", "	lang4",
		"峿", "	yu3",
		"峾", "	yin2",
		"峽", "	xia2",
		"峻", "	jun4",
		"崈", "	chong2",
		"峺", "	geng3",
		"峹", "	tu2",
		"峸", "	cheng2",
		"峷", "	shen1",
		"島", "	dao3",
		"峵", "	hong2",
		"峴", "	xian4",
		"峳", "	you2",
		"峲", "	li3",
		"峱", "	nao2",
		"崇", "	chong2",
		"崉", "	ta4",
		"崡", "	han2",
		"崖", "	ya2",
		"崠", "	dong1",
		"崟", "	yin2",
		"崞", "	guo1",
		"崝", "	zheng1",
		"崜", "	duo1",
		"崛", "	jue2",
		"崚", "	leng2",
		"崙", "	lun2",
		"崘", "	lun2",
		"崗", "	gang3",
		"崕", "	ya2",
		"崊", "	lin2",
		"崔", "	cui1",
		"崓", "	gu4",
		"崒", "	zu2",
		"崑", "	kun1",
		"崐", "	kun1",
		"崏", "	min2",
		"崎", "	qi2",
		"崍", "	lai2",
		"崌", "	ju1",
		"崋", "	hua4",
		"嵕", "	zong1",
		"嵗", "	sui4",
		"嶾", "	yin3",
		"嶙", "	lin2",
		"嶣", "	jiao1",
		"嶢", "	yao2",
		"嶡", "	gui4",
		"嶠", "	jiao4",
		"嶟", "	zun1",
		"嶞", "	duo4",
		"嶝", "	deng4",
		"嶜", "	jin1",
		"嶛", "	liao2",
		"嶚", "	liao2",
		"嶘", "	zhan4",
		"嶥", "	jue2",
		"嶗", "	lao2",
		"嶖", "	yan3",
		"嶕", "	jiao1",
		"嶔", "	qin1",
		"嶓", "	bo1",
		"嶒", "	ceng2",
		"嶑", "	xiang4",
		"嶐", "	long2",
		"嶏", "	pei4",
		"嶎", "	yu4",
		"嶤", "	yao2",
		"嶦", "	zhan1",
		"嶌", "	dao3",
		"嶳", "	di4",
		"嶽", "	yue4",
		"嶼", "	yu3",
		"嶻", "	za2",
		"嶺", "	ling3",
		"嶹", "	dao3",
		"嶸", "	rong2",
		"嶷", "	yi2",
		"嶶", "	wei",
		"嶵", "	zui3",
		"嶴", "	ao4",
		"嶲", "	xi1",
		"嶧", "	yi4",
		"嶱", "	ke3",
		"嶰", "	xie4",
		"嶯", "	ji2",
		"嶮", "	xian3",
		"嶭", "	nie4",
		"嶬", "	yi2",
		"嶫", "	ye4",
		"嶪", "	ye4",
		"嶩", "	nao2",
		"嶨", "	xue2",
		"嶍", "	xi2",
		"嶋", "	dao3",
		"嵘", "	rong2",
		"嵤", "	rong2",
		"嵮", "	dian1",
		"嵭", "	beng1",
		"嵬", "	wei2",
		"嵫", "	zi1",
		"嵪", "	qiao1",
		"嵩", "	song1",
		"嵨", "	wu4",
		"嵧", "	liu2",
		"嵦", "	kai3",
		"嵥", "	jie2",
		"嵣", "	dang4",
		"嵰", "	qian3",
		"嵢", "	cang1",
		"嵡", "	weng3",
		"嵠", "	xi1",
		"嵟", "	dui1",
		"嵞", "	tu2",
		"嵝", "	lou3",
		"嵜", "	ti",
		"嵛", "	yu2",
		"嵚", "	qin1",
		"嵙", "	ke",
		"嵯", "	cuo2",
		"嵱", "	yong3",
		"嶊", "	zui3",
		"嵿", "	ding3",
		"嶉", "	cui1",
		"嶈", "	qiang1",
		"嶇", "	qu1",
		"嶆", "	cao2",
		"嶅", "	ao2",
		"嶄", "	zhan3",
		"嶃", "	zhan3",
		"嶂", "	zhang4",
		"嶁", "	lou3",
		"嶀", "	tu1",
		"嵾", "	cen1",
		"嵲", "	nie4",
		"嵽", "	die2",
		"嵼", "	chan3",
		"嵻", "	kang1",
		"嵺", "	liao2",
		"嵹", "	jiang4",
		"嵸", "	zong1",
		"嵷", "	song3",
		"嵶", "	ruo",
		"嵵", "	shi",
		"嵴", "	ji3",
		"嵳", "	cuo2",
		"子", "	zi",
		"孎", "	zhu2",
		"堎", "	leng4",
		"够", "	gou4",
		"天", "	tian1",
		"夨", "	ze4",
		"大", "	da4",
		"夦", "	chen3",
		"夥", "	huo3",
		"夤", "	yin2",
		"夣", "	meng4",
		"夢", "	meng4",
		"夡", "	qi4",
		"夠", "	gou4",
		"夞", "	wai4",
		"夫", "	fu1",
		"夝", "	qing2",
		"夜", "	ye4",
		"夛", "	duo1",
		"多", "	duo1",
		"夙", "	su4",
		"夘", "	mao3",
		"夗", "	yuan4",
		"外", "	wai4",
		"夕", "	xi1",
		"夔", "	kui2",
		"太", "	tai4",
		"夬", "	guai4",
		"夒", "	nao2",
		"夹", "	jia1",
		"奃", "	di1",
		"奂", "	huan4",
		"奁", "	lian2",
		"奀", "	en1",
		"夿", "	ba1",
		"夾", "	jia1",
		"夽", "	yun3",
		"夼", "	kuang3",
		"夻", "	hua4",
		"夺", "	duo2",
		"夸", "	kua1",
		"夭", "	yao1",
		"夷", "	yi2",
		"夶", "	bi3",
		"夵", "	yan3",
		"头", "	tou2",
		"夳", "	tai4",
		"夲", "	tao1",
		"失", "	shi1",
		"夰", "	gao3",
		"夯", "	hang1",
		"央", "	yang1",
		"夓", "	xia4",
		"夑", "	xie",
		"奅", "	pao4",
		"士", "	shi4",
		"壵", "	zhuang4",
		"壴", "	zhu4",
		"壳", "	ke2",
		"売", "	mai4",
		"壱", "	yi1",
		"声", "	sheng1",
		"壯", "	zhuang4",
		"壮", "	zhuang4",
		"壭", "	san",
		"壬", "	ren2",
		"壪", "	wan1",
		"壷", "	hu2",
		"壩", "	ba4",
		"壨", "	lei2",
		"壧", "	yan2",
		"壦", "	xun1",
		"壥", "	chan",
		"壤", "	rang3",
		"壣", "	lin2",
		"壢", "	li4",
		"壡", "	rui4",
		"壠", "	long3",
		"壶", "	hu2",
		"壸", "	kun3",
		"夐", "	xiong4",
		"夅", "	jiang4",
		"夏", "	xia4",
		"夎", "	cuo4",
		"复", "	fu4",
		"夌", "	ling2",
		"夋", "	qun1",
		"夊", "	sui1",
		"変", "	bian4",
		"夈", "	zhai",
		"备", "	bei4",
		"夆", "	feng2",
		"处", "	chu4",
		"壹", "	yi1",
		"夃", "	gu3",
		"夂", "	zhi3",
		"夁", "	yi1",
		"夀", "	shou4",
		"壿", "	zun1",
		"壾", "	mang3",
		"壽", "	shou4",
		"壼", "	kun3",
		"壻", "	xu4",
		"壺", "	hu2",
		"奄", "	yan3",
		"奆", "	juan4",
		"壞", "	huai4",
		"妇", "	fu4",
		"妑", "	pa1",
		"妐", "	zhong1",
		"妏", "	wen4",
		"妎", "	hai4",
		"妍", "	yan2",
		"妌", "	jing4",
		"妋", "	fu1",
		"妊", "	ren4",
		"妉", "	dan1",
		"妈", "	ma1",
		"妆", "	zhuang1",
		"妓", "	ji4",
		"妅", "	hong2",
		"妄", "	wang4",
		"妃", "	fei1",
		"如", "	ru2",
		"妁", "	shuo4",
		"妀", "	ji3",
		"奿", "	fan4",
		"奾", "	xian1",
		"好", "	hao3",
		"奼", "	cha4",
		"妒", "	du4",
		"妔", "	keng1",
		"奺", "	jiu3",
		"妡", "	xin1",
		"妫", "	gui1",
		"妪", "	yu4",
		"妩", "	wu3",
		"妨", "	fang2",
		"妧", "	wan4",
		"妦", "	feng1",
		"妥", "	tuo3",
		"妤", "	yu2",
		"妣", "	bi3",
		"妢", "	fen2",
		"妠", "	na4",
		"妕", "	zhong4",
		"妟", "	yan4",
		"妞", "	niu1",
		"妝", "	zhuang1",
		"妜", "	yue4",
		"妛", "	chi",
		"妚", "	fou3",
		"妙", "	miao4",
		"妘", "	yun2",
		"妗", "	jin4",
		"妖", "	yao1",
		"奻", "	nuan2",
		"她", "	ta1",
		"奇", "	qi2",
		"奓", "	zha1",
		"奝", "	diao1",
		"奜", "	fei3",
		"奛", "	huang3",
		"奚", "	xi1",
		"奙", "	ben3",
		"奘", "	zang4",
		"套", "	tao4",
		"奖", "	jiang3",
		"奕", "	yi4",
		"奔", "	ben1",
		"奒", "	kai1",
		"奟", "	beng1",
		"契", "	qi4",
		"奐", "	huan4",
		"奏", "	zou4",
		"奎", "	kui2",
		"奍", "	yang",
		"奌", "	dian3",
		"奋", "	fen4",
		"奊", "	xie2",
		"奉", "	feng4",
		"奈", "	nai4",
		"奞", "	xun4",
		"奠", "	dian4",
		"奸", "	jian1",
		"奭", "	shi4",
		"奷", "	qian1",
		"奶", "	nai3",
		"奵", "	ding3",
		"奴", "	nu2",
		"女", "	nv3",
		"奲", "	duo3",
		"奱", "	luan2",
		"奰", "	bi4",
		"奯", "	huo4",
		"奮", "	fen4",
		"奬", "	jiang3",
		"奡", "	ao4",
		"奫", "	yun1",
		"奪", "	duo2",
		"奩", "	lian2",
		"奨", "	jiang3",
		"奧", "	ao4",
		"奦", "	wu4",
		"奥", "	ao4",
		"奤", "	ha3",
		"奣", "	weng3",
		"奢", "	she1",
		"壟", "	long3",
		"壝", "	wei3",
		"妭", "	ba2",
		"塎", "	yong3",
		"塘", "	tang2",
		"塗", "	tu2",
		"塖", "	cheng2",
		"塕", "	weng3",
		"塔", "	ta3",
		"塓", "	mi4",
		"塒", "	shi2",
		"塑", "	su4",
		"塐", "	su4",
		"塏", "	kai3",
		"塍", "	cheng2",
		"塚", "	zhong3",
		"塌", "	ta1",
		"塋", "	ying2",
		"塊", "	kuai4",
		"塉", "	ji2",
		"塈", "	ji4",
		"塇", "	xuan1",
		"塆", "	wan1",
		"塅", "	duan4",
		"塄", "	leng2",
		"塃", "	huang1",
		"塙", "	que4",
		"塛", "	li4",
		"塁", "	lei",
		"塨", "	gong1",
		"塲", "	chang2",
		"塱", "	lang3",
		"塰", "	hai",
		"塯", "	liu4",
		"塮", "	xie4",
		"塭", "	wen1",
		"塬", "	yuan2",
		"填", "	tian2",
		"塪", "	kan3",
		"塩", "	yan2",
		"塧", "	ai4",
		"塜", "	zhong3",
		"塦", "	zhen4",
		"塥", "	ge2",
		"塤", "	xun1",
		"塣", "	zheng4",
		"塢", "	wu4",
		"塡", "	tian2",
		"塠", "	dui1",
		"塟", "	zang4",
		"塞", "	sai1",
		"塝", "	bang4",
		"塂", "	xiang4",
		"塀", "	ping",
		"塴", "	beng4",
		"堚", "	hun2",
		"堤", "	di1",
		"堣", "	yu2",
		"堢", "	bao3",
		"堡", "	bao3",
		"堠", "	hou4",
		"堟", "	zhuan4",
		"堞", "	die2",
		"堝", "	guo1",
		"堜", "	lian4",
		"堛", "	bi4",
		"堙", "	yin1",
		"堦", "	jie1",
		"堘", "	cheng2",
		"堗", "	tu1",
		"堖", "	nao3",
		"堕", "	duo4",
		"堔", "	shen",
		"堓", "	an4",
		"堒", "	kun",
		"堑", "	qian4",
		"堐", "	ya2",
		"堏", "	fang",
		"堥", "	mao2",
		"堧", "	ruan2",
		"堿", "	jian3",
		"場", "	chang3",
		"堾", "	chun1",
		"堽", "	gang1",
		"堼", "	heng4",
		"堻", "	jin1",
		"堺", "	jie4",
		"堹", "	zhong4",
		"堸", "	feng2",
		"堷", "	yin4",
		"堶", "	tuo2",
		"堵", "	du3",
		"堳", "	mei2",
		"堨", "	ye4",
		"堲", "	ci2",
		"報", "	bao4",
		"堰", "	yan4",
		"堯", "	yao2",
		"堮", "	e4",
		"堭", "	huang2",
		"堬", "	yu2",
		"堫", "	zong1",
		"堪", "	kan1",
		"堩", "	geng4",
		"塳", "	peng2",
		"塵", "	chen2",
		"壜", "	tan2",
		"墷", "	ye4",
		"壁", "	bi4",
		"壀", "	pi2",
		"墿", "	yi4",
		"墾", "	ken3",
		"墽", "	qiao1",
		"墼", "	ji1",
		"墻", "	qiang2",
		"墺", "	ao4",
		"墹", "	jian",
		"墸", "	zhu",
		"墶", "	da",
		"壃", "	jiang1",
		"墵", "	tan2",
		"墴", "	huang2",
		"墳", "	fen2",
		"墲", "	mu2",
		"墱", "	deng4",
		"墰", "	tan2",
		"墯", "	duo4",
		"墮", "	duo4",
		"墭", "	sheng4",
		"墬", "	di4",
		"壂", "	dian4",
		"壄", "	ye3",
		"墪", "	dun1",
		"壑", "	he4",
		"壛", "	yan2",
		"壚", "	lu2",
		"壙", "	kuang4",
		"壘", "	lei3",
		"壗", "	jin",
		"壖", "	ruan2",
		"壕", "	hao2",
		"壔", "	dao3",
		"壓", "	ya1",
		"壒", "	ai4",
		"壐", "	xi3",
		"壅", "	yong1",
		"壏", "	xian4",
		"壎", "	xun1",
		"壍", "	qian4",
		"壌", "	rang3",
		"壋", "	dang4",
		"壊", "	huai4",
		"壉", "	ju4",
		"壈", "	lan3",
		"壇", "	tan2",
		"壆", "	xue2",
		"墫", "	zun1",
		"墩", "	dun1",
		"塶", "	lu4",
		"墂", "	biao1",
		"墌", "	zhi2",
		"墋", "	chen3",
		"墊", "	dian4",
		"墉", "	yong1",
		"墈", "	kan4",
		"墇", "	zhang1",
		"墆", "	zhi4",
		"墅", "	shu4",
		"墄", "	ce4",
		"境", "	jing4",
		"墁", "	man4",
		"墎", "	guo1",
		"墀", "	chi2",
		"塿", "	lou3",
		"塾", "	shu2",
		"塽", "	shuang3",
		"塼", "	zhuan1",
		"塻", "	mo4",
		"塺", "	mei2",
		"塹", "	qian4",
		"塸", "	ou1",
		"塷", "	lu3",
		"墍", "	xi4",
		"墏", "	qiang3",
		"墨", "	mo4",
		"墝", "	qiao1",
		"墧", "	que4",
		"墦", "	fan2",
		"墥", "	dong3",
		"墤", "	kuai4",
		"墣", "	pu2",
		"墢", "	ba2",
		"墡", "	shan4",
		"墠", "	shan4",
		"墟", "	xu1",
		"增", "	zeng1",
		"墜", "	zhui4",
		"墐", "	jin4",
		"墛", "	wei",
		"墚", "	liang2",
		"墙", "	qiang2",
		"墘", "	qian2",
		"増", "	zeng1",
		"墖", "	ta3",
		"墕", "	yan4",
		"墔", "	cui1",
		"墓", "	mu4",
		"墒", "	shang1",
		"墑", "	di4",
		"妬", "	du4",
		"妮", "	ni1",
		"孍", "	yan2",
		"嫀", "	qin2",
		"嫊", "	su4",
		"嫉", "	ji2",
		"嫈", "	ying1",
		"嫇", "	ming2",
		"嫆", "	rong2",
		"嫅", "	jie1",
		"嫄", "	yuan2",
		"嫃", "	zhen1",
		"嫂", "	sao3",
		"嫁", "	jia4",
		"媿", "	kui4",
		"嫌", "	xian2",
		"媾", "	gou4",
		"媽", "	ma1",
		"媼", "	ao3",
		"媻", "	pan2",
		"媺", "	mei3",
		"媹", "	liu2",
		"媸", "	chi1",
		"媷", "	ru4",
		"媶", "	rong2",
		"媵", "	ying4",
		"嫋", "	niao3",
		"嫍", "	tao1",
		"媳", "	xi2",
		"嫚", "	man1",
		"嫤", "	jin3",
		"嫣", "	yan1",
		"嫢", "	gui1",
		"嫡", "	di2",
		"嫠", "	li2",
		"嫟", "	ni4",
		"嫞", "	yong1",
		"嫝", "	kang1",
		"嫜", "	zhang1",
		"嫛", "	yi1",
		"嫙", "	xuan2",
		"嫎", "	pang2",
		"嫘", "	lei2",
		"嫗", "	yu4",
		"嫖", "	piao2",
		"嫕", "	yi4",
		"嫔", "	pin2",
		"嫓", "	pi4",
		"嫒", "	ai4",
		"嫑", "	bao2",
		"嫐", "	nao3",
		"嫏", "	lang2",
		"媴", "	yuan2",
		"媲", "	pi4",
		"嫦", "	chang2",
		"媌", "	miao2",
		"媖", "	ying1",
		"媕", "	an1",
		"媔", "	mian2",
		"媓", "	huang2",
		"媒", "	mei2",
		"媑", "	zhong4",
		"媐", "	yi2",
		"媏", "	duan1",
		"媎", "	jie3",
		"媍", "	fu4",
		"媋", "	chun1",
		"媘", "	jie1",
		"媊", "	qian2",
		"媉", "	wo4",
		"媈", "	hui1",
		"媇", "	qin1",
		"媆", "	ruan3",
		"媅", "	dan1",
		"媄", "	mei3",
		"媃", "	rou2",
		"媂", "	di4",
		"媁", "	wei2",
		"媗", "	xuan1",
		"媙", "	wei1",
		"媱", "	yao2",
		"媦", "	wei4",
		"媰", "	chu2",
		"媯", "	gui1",
		"媮", "	tou1",
		"媭", "	xu1",
		"媬", "	bao3",
		"媫", "	qie",
		"媪", "	ao3",
		"媩", "	hu2",
		"媨", "	jiu4",
		"媧", "	wa1",
		"媥", "	pian1",
		"媚", "	mei4",
		"媤", "	si1",
		"媣", "	ran3",
		"媢", "	mao4",
		"媡", "	lian4",
		"媠", "	tuo3",
		"媟", "	xie4",
		"媞", "	shi4",
		"媝", "	qiu1",
		"媜", "	zheng1",
		"媛", "	yuan4",
		"嫥", "	zhuan1",
		"嫧", "	ze2",
		"婿", "	xu4",
		"嬨", "	ci2",
		"嬲", "	niao3",
		"嬱", "	can2",
		"嬰", "	ying1",
		"嬯", "	tai2",
		"嬮", "	yan1",
		"嬭", "	nai3",
		"嬬", "	ru2",
		"嬫", "	rong2",
		"嬪", "	pin2",
		"嬩", "	yu2",
		"嬧", "	jin4",
		"嬴", "	ying2",
		"嬦", "	chou2",
		"嬥", "	tiao3",
		"嬤", "	ma1",
		"嬣", "	ning2",
		"嬢", "	niang2",
		"嬡", "	ai4",
		"嬠", "	can1",
		"嬟", "	yi4",
		"嬞", "	dong3",
		"嬝", "	niao3",
		"嬳", "	yue4",
		"嬵", "	mian2",
		"嬛", "	huan2",
		"孂", "	jiao3",
		"孌", "	luan2",
		"孋", "	li2",
		"孊", "	mi3",
		"孉", "	quan2",
		"孈", "	hui4",
		"孇", "	shuang1",
		"孆", "	ying1",
		"孅", "	qian1",
		"孄", "	lan3",
		"孃", "	niang2",
		"孁", "	ling2",
		"嬶", "	bi",
		"孀", "	shuang1",
		"嬿", "	yan4",
		"嬾", "	lan3",
		"嬽", "	yuan1",
		"嬼", "	liu3",
		"嬻", "	du2",
		"嬺", "	ni4",
		"嬹", "	xing4",
		"嬸", "	shen3",
		"嬷", "	ma1",
		"嬜", "	xin1",
		"嬚", "	lian3",
		"嫨", "	han1",
		"嫴", "	gu1",
		"嫾", "	lian2",
		"嫽", "	liao2",
		"嫼", "	mo4",
		"嫻", "	xian2",
		"嫺", "	xian2",
		"嫹", "	mao2",
		"嫸", "	zhan3",
		"嫷", "	tuo3",
		"嫶", "	qiao2",
		"嫵", "	wu3",
		"嫳", "	pie4",
		"嬀", "	gui1",
		"嫲", "	ma",
		"嫱", "	qiang2",
		"嫰", "	nen4",
		"嫯", "	ao4",
		"嫮", "	hu4",
		"嫭", "	hu4",
		"嫬", "	zhe1",
		"嫫", "	mo2",
		"嫪", "	lao4",
		"嫩", "	nen4",
		"嫿", "	hua4",
		"嬁", "	deng1",
		"嬙", "	qiang2",
		"嬎", "	fan4",
		"嬘", "	sui4",
		"嬗", "	shan4",
		"嬖", "	bi4",
		"嬕", "	shi4",
		"嬔", "	fu4",
		"嬓", "	jiao4",
		"嬒", "	hui4",
		"嬑", "	yi4",
		"嬐", "	xian1",
		"嬏", "	fan1",
		"嬍", "	mei3",
		"嬂", "	zhi2",
		"嬌", "	jiao1",
		"嬋", "	chan2",
		"嬊", "	yan4",
		"嬉", "	xi1",
		"嬈", "	rao2",
		"嬇", "	kui4",
		"嬆", "	xi1",
		"嬅", "	hua4",
		"嬄", "	yi1",
		"嬃", "	xu1",
		"媀", "	yu4",
		"婾", "	tou1",
		"妯", "	zhou2",
		"姯", "	guang1",
		"姹", "	cha4",
		"姸", "	yan2",
		"姷", "	you4",
		"姶", "	e4",
		"姵", "	pei4",
		"姴", "	lie4",
		"姳", "	ming3",
		"姲", "	yan4",
		"姱", "	kua1",
		"姰", "	jun1",
		"姮", "	heng2",
		"姻", "	yin1",
		"姭", "	xian4",
		"姬", "	ji1",
		"姫", "	ji1",
		"姪", "	zhi2",
		"姩", "	nian4",
		"姨", "	yi2",
		"姧", "	jian1",
		"姦", "	jian1",
		"姥", "	lao3",
		"姤", "	gou4",
		"姺", "	shen1",
		"姼", "	shi2",
		"姢", "	juan1",
		"娉", "	ping1",
		"娓", "	wei3",
		"娒", "	mei2",
		"娑", "	suo1",
		"娐", "	fu1",
		"娏", "	mang2",
		"娎", "	xie4",
		"娍", "	cheng2",
		"娌", "	li3",
		"娋", "	shao4",
		"娊", "	xian4",
		"娈", "	luan2",
		"姽", "	gui3",
		"娇", "	jiao1",
		"娆", "	rao2",
		"娅", "	ya4",
		"娄", "	lou2",
		"娃", "	wa2",
		"娂", "	hong2",
		"威", "	wei1",
		"娀", "	song1",
		"姿", "	zi1",
		"姾", "	quan2",
		"姣", "	jiao1",
		"姡", "	hua2",
		"娕", "	chuo4",
		"妻", "	qi1",
		"姅", "	ban4",
		"姄", "	min2",
		"姃", "	zheng1",
		"姂", "	fa2",
		"姁", "	xu3",
		"姀", "	he2",
		"妿", "	e1",
		"妾", "	qie4",
		"妽", "	shen1",
		"妼", "	bi4",
		"妺", "	mo4",
		"姇", "	fu1",
		"妹", "	mei4",
		"妸", "	e1",
		"妷", "	zhi2",
		"妶", "	xian2",
		"妵", "	tou3",
		"妴", "	yuan4",
		"妳", "	nai3",
		"妲", "	da2",
		"妱", "	zhao1",
		"妰", "	zhuo2",
		"姆", "	mu3",
		"姈", "	ling2",
		"姠", "	xiang4",
		"姕", "	zi1",
		"姟", "	gai1",
		"姞", "	ji2",
		"姝", "	shu1",
		"姜", "	jiang1",
		"姛", "	dong4",
		"姚", "	yao2",
		"姙", "	ren4",
		"姘", "	pin1",
		"姗", "	shan1",
		"姖", "	ju4",
		"委", "	wei3",
		"姉", "	zi3",
		"姓", "	xing4",
		"姒", "	si4",
		"姑", "	gu1",
		"姐", "	jie3",
		"姏", "	man2",
		"姎", "	yang1",
		"姍", "	shan1",
		"姌", "	ran3",
		"始", "	shi3",
		"姊", "	zi3",
		"娔", "	ke4",
		"娖", "	chuo4",
		"婽", "	jia3",
		"婘", "	quan2",
		"婢", "	bi4",
		"婡", "	lai2",
		"婠", "	wan1",
		"婟", "	hu4",
		"婞", "	xing4",
		"婝", "	dian4",
		"婜", "	qian1",
		"婛", "	jing1",
		"婚", "	hun1",
		"婙", "	jing4",
		"婗", "	ni2",
		"婤", "	chou1",
		"婖", "	tian1",
		"婕", "	jie2",
		"婔", "	fei",
		"婓", "	fei1",
		"婒", "	tan2",
		"婑", "	rui2",
		"婐", "	wo3",
		"婏", "	fan4",
		"婎", "	hui1",
		"婍", "	qi3",
		"婣", "	yin1",
		"婥", "	nao4",
		"婋", "	xiao1",
		"婲", "	hua",
		"婼", "	chuo4",
		"婻", "	nan4",
		"婺", "	wu4",
		"婹", "	yao3",
		"婸", "	dang4",
		"婷", "	ting2",
		"婶", "	shen3",
		"婵", "	chan2",
		"婴", "	ying1",
		"婳", "	hua4",
		"婱", "	xian2",
		"婦", "	fu4",
		"婰", "	dian3",
		"婯", "	li4",
		"婮", "	ju1",
		"婭", "	ya4",
		"婬", "	yin2",
		"婫", "	kun1",
		"婪", "	lan2",
		"婩", "	an4",
		"婨", "	lun2",
		"婧", "	jing4",
		"婌", "	shu2",
		"婊", "	biao3",
		"娗", "	ting3",
		"娣", "	di4",
		"娭", "	ai1",
		"娬", "	wu3",
		"娫", "	yan2",
		"娪", "	wu2",
		"娩", "	mian3",
		"娨", "	xian4",
		"娧", "	tui4",
		"娦", "	pin2",
		"娥", "	e2",
		"娤", "	zhuang1",
		"娢", "	han2",
		"娯", "	yu2",
		"娡", "	zhi4",
		"娠", "	shen1",
		"娟", "	juan1",
		"娞", "	nei3",
		"娝", "	pou1",
		"娜", "	na4",
		"娛", "	yu2",
		"娚", "	nan2",
		"娙", "	xing2",
		"娘", "	niang2",
		"娮", "	yan2",
		"娰", "	si4",
		"婉", "	wan3",
		"娾", "	ai3",
		"婈", "	ling2",
		"婇", "	cai1",
		"婆", "	po2",
		"婅", "	ju2",
		"婄", "	pou3",
		"婃", "	cong2",
		"婂", "	mian2",
		"婁", "	lou2",
		"婀", "	e1",
		"娿", "	e1",
		"娽", "	lu4",
		"娱", "	yu2",
		"娼", "	chang1",
		"娻", "	dong1",
		"娺", "	zhuo2",
		"娹", "	xian2",
		"娸", "	qi1",
		"娷", "	zhui4",
		"娶", "	qu3",
		"娵", "	ju1",
		"娴", "	xian2",
		"娳", "	li4",
		"娲", "	wa1",
		"皚", "	ai2",
	}

	// surnames 姓氏
	surnames = []string{
		"万俟", "	mo4	qi2",
		"尉迟", "	yu4	chi2",
		"单于", "	chan2	yu2",
		"不", "	fou3",
		"沈", "	shen3",
		"称", "	cheng1",
		"车", "	che1",
		"万", "	wan4",
		"汤", "	tang1",
		"阿", "	a1",
		"丁", "	ding1",
		"强", "	qiang2",
		"仇", "	qiu2",
		"叶", "	ye4",
		"阚", "	kan4",
		"乐", "	yue4",
		"乜", "	nie4",
		"陆", "	lu4",
		"殷", "	yin1",
		"牟", "	mou2",
		"区", "	ou1",
		"宿", "	su4",
		"俞", "	yu2",
		"余", "	yu2",
		"齐", "	qi2",
		"许", "	xu3",
		"信", "	xin4",
		"无", "	wu2",
		"浣", "	wan3",
		"艾", "	ai4",
		"浅", "	qian3",
		"烟", "	yan1",
		"蓝", "	lan2",
		"於", "	yu2",
		"寻", "	xun2",
		"殳", "	shu1",
		"思", "	si1",
		"鸟", "	niao3",
		"卜", "	bu3",
		"单", "	shan4",
		"南", "	nan2",
		"柏", "	bai3",
		"朴", "	piao2",
		"繁", "	po2",
		"曾", "	zeng1",
		"瞿", "	qu2",
		"缪", "	miao4",
		"石", "	shi2",
		"冯", "	feng2",
		"覃", "	qin2",
		"幺", "	yao1",
		"种", "	chong2",
		"折", "	she4",
		"燕", "	yan1",
		"纪", "	ji3",
		"过", "	guo1",
		"华", "	hua4",
		"冼", "	xian3",
		"秘", "	bi4",
		"重", "	chong2",
		"解", "	xie4",
		"那", "	na1",
		"和", "	he2",
		"贾", "	jia3",
		"塔", "	ta3",
		"盛", "	sheng4",
		"查", "	zha1",
		"盖", "	ge3",
		"居", "	ju1",
		"哈", "	ha3",
		"的", "	de1",
		"薄", "	bo2",
		"佴", "	nai4",
		"六", "	lu4",
		"都", "	du1",
		"翟", "	zhai2",
		"扎", "	za1",
		"藏", "	zang4",
		"粘", "	nian4",
		"难", "	nan4",
		"若", "	ruo4",
	}
)