// SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#ifndef OVEMBPROXY_H
#define OVEMBPROXY_H

#include "embeddingproxy.h"

#include <openvino/openvino.hpp>

GLOBAL_BEGIN_NAMESPACE

class OVEmbProxy : public EmbeddingProxy
{
public:
    explicit OVEmbProxy(const std::string &name, ov::Core *core);
    ~OVEmbProxy();
    std::string name() const override;
    std::list<std::vector<int32_t>> tokenize(const std::list<std::string> &prompt, const std::map<std::string, std::string> &params = {}) override;
    std::list<std::vector<float>> embedding(const std::list<std::vector<int32_t>> &tokens, const std::map<std::string, std::string> &params = {}) override;
    bool initialize(const QString &model, const QString &tokenizer, const QVariantHash &params);
protected:
    std::string modelName;
    ov::Core *ovCore = nullptr;
    ov::CompiledModel embModel;
    ov::CompiledModel tokenizerModel;

};

GLOBAL_END_NAMESPACE

#endif // OVEMBPROXY_H
