/*
 * Decompiled with CFR 0.152.
 */
package spec.jbb;

import java.math.BigDecimal;
import java.util.Date;
import spec.jbb.Company;
import spec.jbb.Item;
import spec.jbb.JBButil;
import spec.jbb.Stock;
import spec.jbb.Warehouse;

public class Orderline {
    static final String COPYRIGHT = "SPECjbb2005,Copyright (c) 2005 Standard Performance Evaluation Corporation (SPEC),All rights reserved,(C) Copyright IBM Corp., 1996 - 2005All rights reserved,Licensed Materials - Property of SPEC";
    private Date deliveryDateTime;
    private String districtInfo;
    private BigDecimal amount;
    private int orderId;
    private int itemId;
    private short orderLineNumber;
    private short quantity;
    private byte districtId;
    private short warehouseId;
    private short supplyWarehouseId;
    private Company company;
    private Warehouse warehousePtr;
    private Stock stockPtr;
    private String itemName;
    private BigDecimal itemPrice;
    private int stockQuantity;
    private char BrandGeneric;

    public Orderline(Company company, int n, byte by, short s, short s2, short s3, boolean bl) {
        this.company = company;
        this.orderId = n;
        this.districtId = by;
        this.warehouseId = s;
        this.orderLineNumber = s2;
        this.itemId = JBButil.create_random_item_id(this.company.getMaxItems(), this.warehouseId);
        if (s2 == s3 && bl) {
            this.itemId = 0;
        }
        this.deliveryDateTime = null;
        this.quantity = (short)5;
        this.amount = BigDecimal.valueOf(0L, 2);
        this.districtInfo = null;
    }

    public synchronized boolean validateAndProcess(Warehouse warehouse) {
        boolean bl;
        Item item = null;
        Stock stock = null;
        if (warehouse != null) {
            item = warehouse.retrieveItem(this.itemId);
            stock = warehouse.retrieveStock(this.itemId);
        }
        if (warehouse != null && item != null && stock != null) {
            this.stockPtr = stock;
            this.process(item, stock);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void process(Item item, Stock stock) {
        this.itemName = item.getName();
        this.itemPrice = item.getPrice();
        String string = item.getBrandInfo();
        this.stockQuantity = stock.getQuantity();
        String string2 = stock.getDistrictInfo(this.districtId);
        String string3 = stock.getData();
        if (this.stockQuantity >= this.quantity + 10) {
            stock.changeQuantity(-this.quantity);
        } else {
            stock.changeQuantity(91 - this.quantity);
        }
        stock.incrementYTD(this.quantity);
        stock.incrementOrderCount();
        if (this.warehouseId == this.supplyWarehouseId) {
            stock.incrementRemoteCount();
        }
        this.amount = BigDecimal.valueOf(this.quantity).multiply(this.itemPrice).setScale(2, 4);
        this.BrandGeneric = string.indexOf("ORIGINAL") > 0 && string3.indexOf("ORIGINAL") > 0 ? (char)66 : (char)71;
        this.districtInfo = new String(string2);
    }

    public Stock getStockPtr() {
        return this.stockPtr;
    }

    public synchronized BigDecimal getAmount() {
        BigDecimal bigDecimal = this.amount;
        return bigDecimal;
    }

    public synchronized char getBrandGeneric() {
        char c = this.BrandGeneric;
        return c;
    }

    public synchronized int getItemId() {
        int n = this.itemId;
        return n;
    }

    public synchronized String getItemName() {
        String string = this.itemName;
        return string;
    }

    public synchronized BigDecimal getItemPrice() {
        BigDecimal bigDecimal = this.itemPrice;
        return bigDecimal;
    }

    public synchronized short getSupplyWarehouse() {
        short s = this.supplyWarehouseId;
        return s;
    }

    public synchronized int getStockQuantity() {
        int n = this.stockQuantity;
        return n;
    }

    public synchronized void setSupplyWarehouse(short s) {
        this.supplyWarehouseId = s;
    }

    public synchronized Date getDeliveryDateTime() {
        Date date = this.deliveryDateTime;
        return date;
    }

    public synchronized void setDeliveryTime(Date date) {
        this.deliveryDateTime = date;
    }

    public synchronized short getQuantity() {
        short s = this.quantity;
        return s;
    }

    public synchronized void setQuantity(short s) {
        this.quantity = s;
    }

    public synchronized void setAmount(BigDecimal bigDecimal) {
        this.amount = bigDecimal;
    }

    public synchronized void setDistrictInfo(String string) {
        this.districtInfo = string;
    }
}

