% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.utils.R
\name{xTAx}
\alias{xTAx}
\alias{xAxT}
\alias{xTAx_solve}
\alias{xTAx_qrsolve}
\alias{sandwich_solve}
\alias{xTAx_eigen}
\title{Common quadratic forms}
\usage{
xTAx(x, A)

xAxT(x, A)

xTAx_solve(x, A, ...)

xTAx_qrsolve(x, A, tol = 1e-07, ...)

sandwich_solve(A, B, ...)

xTAx_eigen(x, A, tol = sqrt(.Machine$double.eps), ...)
}
\arguments{
\item{x}{a vector}

\item{A}{a square matrix}

\item{...}{additional arguments to subroutines}

\item{tol}{tolerance argument passed to the relevant subroutine}

\item{B}{a square matrix}
}
\description{
Common quadratic forms
}
\details{
These are somewhat inspired by emulator::quad.form.inv()
and others.
}
\section{Functions}{
\itemize{
\item \code{xTAx()}: Evaluate \eqn{x'Ax} for vector \eqn{x} and square
matrix \eqn{A}.

\item \code{xAxT()}: Evaluate \eqn{xAx'} for vector \eqn{x} and square
matrix \eqn{A}.

\item \code{xTAx_solve()}: Evaluate \eqn{x'A^{-1}x} for vector \eqn{x} and
invertible matrix \eqn{A} using \code{\link[=solve]{solve()}}.

\item \code{xTAx_qrsolve()}: Evaluate \eqn{x'A^{-1}x} for vector \eqn{x} and
matrix \eqn{A} using QR decomposition and confirming that \eqn{x}
is in the span of \eqn{A} if \eqn{A} is singular; returns \code{rank}
and \code{nullity} as attributes just in case subsequent calculations
(e.g., hypothesis test degrees of freedom) are affected.

\item \code{sandwich_solve()}: Evaluate \eqn{A^{-1}B(A')^{-1}} for \eqn{B} a
square matrix and \eqn{A} invertible.

\item \code{xTAx_eigen()}: Evaluate \eqn{x' A^{-1} x} for vector \eqn{x} and
matrix \eqn{A} (symmetric, nonnegative-definite) via
eigendecomposition; returns \code{rank} and \code{nullity} as attributes
just in case subsequent calculations (e.g., hypothesis test
degrees of freedom) are affected.

Decompose \eqn{A = P L P'} for \eqn{L} diagonal matrix of
eigenvalues and \eqn{P} orthogonal. Then \eqn{A^{-1} = P L^{-1}
  P'}.

Substituting, \deqn{x' A^{-1} x = x' P L^{-1} P' x
  = h' L^{-1} h} for \eqn{h = P' x}.

}}
