% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_pubmed_xml.r
\name{parse_pubmed_xml}
\alias{parse_pubmed_xml}
\title{Summarize an XML record from pubmed.}
\usage{
parse_pubmed_xml(record)
}
\arguments{
\item{record}{Either and XMLInternalDocument or character the record to be
parsed ( expected to come from \code{\link{entrez_fetch}})}
}
\value{
Either a single pubmed_record object, or a list of several
}
\description{
Note: this function assumes all records are of the type "PubmedArticle"
and will return an empty record for any other type (including books).
}
\examples{
\donttest{
hox_paper <- entrez_search(db="pubmed", term="10.1038/nature08789[doi]")
hox_rel <- entrez_link(db="pubmed", dbfrom="pubmed", id=hox_paper$ids)
recs <- entrez_fetch(db="pubmed", 
                       id=hox_rel$links$pubmed_pubmed[1:3], 
                       rettype="xml")
parse_pubmed_xml(recs)
}
}
