% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_pareto.R
\name{dist_pareto}
\alias{dist_pareto}
\title{The Pareto distribution}
\usage{
dist_pareto(shape, scale)
}
\arguments{
\item{shape, scale}{parameters. Must be strictly positive.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{
dist <- dist_pareto(shape = c(10, 3, 2, 1), scale = rep(1, 4))
dist

\dontshow{if (requireNamespace("actuar", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
mean(dist)
variance(dist)
support(dist)
generate(dist, 10)

density(dist, 2)
density(dist, 2, log = TRUE)

cdf(dist, 4)

quantile(dist, 0.7)
\dontshow{\}) # examplesIf}
}
\seealso{
\link[actuar:Pareto]{actuar::Pareto}
}
