### 0.8.0 {small}`14th March, 2022`

```{rubric} IO Specification
```

```{warning}
The on disk format of AnnData objects has been updated with this release.
Previous releases of `anndata` will not be able to read all files written by this version.

For discussion of possible future solutions to this issue, see {issue}`698`
```

Internal handling of IO has been overhauled.
This should make it much easier to support new datatypes, use partial access, and use `AnnData` internally in other formats.

- Each element should be tagged with an `encoding_type` and `encoding_version`. See updated docs on the {doc}`file format </fileformat-prose>`
- Support for nullable integer and boolean data arrays. More data types to come!
- Experimental support for low level access to the IO API via {func}`~anndata.experimental.read_elem` and {func}`~anndata.experimental.write_elem`

```{rubric} Features
```

- Added PyTorch dataloader {class}`~anndata.experimental.AnnLoader` and lazy concatenation object {class}`~anndata.experimental.AnnCollection`. See the [tutorials] {pr}`416` {smaller}`S Rybakov`
- Compatibility with `h5ad` files written from Julia {pr}`569` {smaller}`I Kats`
- Many logging messages that should have been warnings are now warnings {pr}`650` {smaller}`I Virshup`
- Significantly more efficient {func}`anndata.read_umi_tools` {pr}`661` {smaller}`I Virshup`
- Fixed deepcopy of a copy of a view retaining sparse matrix view mixin type {pr}`670` {smaller}`M Klein`
- In many cases {attr}`~anndata.AnnData.X` can now be `None` {pr}`463` {smaller}`R Cannoodt` {pr}`677` {smaller}`I Virshup`. Remaining work is documented in {issue}`467`.
- Removed hard `xlrd` dependency {smaller}`I Virshup`
- `obs` and `var` dataframes are no longer copied by default on `AnnData` instantiation {issue}`371` {smaller}`I Virshup`

```{rubric} Bug fixes
```

- Fixed issue where `.copy` was creating sparse matrices views when copying {pr}`670` {smaller}`michalk8`
- Fixed issue where `.X` matrix read in from `zarr` would always have `float32` values {pr}`701` {smaller}`I Virshup`
- `` Raw.to_adata` `` now includes `obsp` in the output {pr}`404` {smaller}`G Eraslan`

```{rubric} Dependencies
```

- `xlrd` dropped as a hard dependency
- Now requires `h5py` `v3.0.0` or newer

[tutorials]: https://anndata-tutorials.readthedocs.io/en/latest/index.html
