/*
Copyright (C) by Dmitry E. Oboukhov 2006, 2007

  This package is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This package is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this package; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
*/
#ifndef __UNIT__H__
#define __UNIT__H__

// структура, описывающая скорострел
typedef struct
{
  int id;             // идентификатор против кого (в info) скорострел
  int rf;             // игровое значение скорострела
  double chance;      // вычисленный шанс на сл. выстрел
} rapidfire;

// массив структур информации о юнитах
// (читается из конфиг-файла)
// id - в остальных структурах - индекс в этом массиве
typedef struct
{
  char name[64];
  int shield, structure, attack, capacity;
  int metal, crystal, deut;   // стоимость юнита

  struct
  {
    unsigned int ground:1;            // 1 = наземное сооружение
    unsigned int large_chargo:1;      // 1 = большой транспорт
    unsigned int small_chargo:1;      // 1 = малый транспорт
    unsigned int recycler:1;          // 1 = переработчик
  } flags;
  int rapid;
} unit_info;


// структура, описывающая юнит
typedef struct
{
  int id;                       // юнита в таблице units
  int attack, shield, armory;   // параметры юнита
  struct
  {
    int shield, armory;
  } max;
} unit;

// производит симуляцию одного юнита (против одного юнита)
// возвращает истину если можно еще раз атаковать (скорострел)
int attack_unit(const unit * attacker, unit * defender);

// создает юнит скорректированный под параметры игрока
unit create_unit(int id, int gattack, int gshield, int garmory);
#endif
