package CParse::Pointer;

use 5.6.0;
use strict;
use warnings;

use CType::Pointer;

sub new
  {
    my $this = shift;
    my $class = ref($this) || $this;
    my $qualifiers = shift;
    my $pointer = shift;
    my $self = {qualifiers => $qualifiers,
                pointer => $pointer,
               };
    bless $self, $class;
    return $self;
  }

sub dump_c
  {
    my $self = shift;

    my $str;

    if (scalar @{$self->{qualifiers}})
      {
        my $qualifiers = join(' ', map {$_->dump_c} @{$self->{qualifiers}});
        $str = "* $qualifiers";
      }
    else
      {
        $str = "*";
      }

    if (defined $self->{pointer})
      {
        $str .= " " . $self->{pointer}->dump_c;
      }

    return $str;
  }

sub get_type
  {
    my $self = shift;

    my $pointer_to_type = shift;

    my @attributes;
    my @qualifiers;

    foreach my $specifier (@{$self->{qualifiers}})
      {
        if ($specifier->isa('CParse::AttributeList'))
          {
            push @attributes, $specifier->attributes;
          }
        else
          {
            push @qualifiers, $specifier;
          }
      }

    my $type = new CType::Pointer $pointer_to_type, \@qualifiers, \@attributes;
    if ($self->{pointer})
      {
        $type = $self->{pointer}->get_type($type);
      }

    return $type;
  }

1;
