"""
ISO639-2 standart: the module only contains the dictionary ISO639_2
which maps a language code in three letters (eg. "fre") to a language
name in english (eg. "French").
"""

# ISO-639, the list comes from:
# http://www.loc.gov/standards/iso639-2/php/English_list.php
_ISO639 = (
    ("Abkhazian", "abk", "ab"),
    ("Achinese", "ace", None),
    ("Acoli", "ach", None),
    ("Adangme", "ada", None),
    ("Adygei", "ady", None),
    ("Adyghe", "ady", None),
    ("Afar", "aar", "aa"),
    ("Afrihili", "afh", None),
    ("Afrikaans", "afr", "af"),
    ("Afro-Asiatic (Other)", "afa", None),
    ("Ainu", "ain", None),
    ("Akan", "aka", "ak"),
    ("Akkadian", "akk", None),
    ("Albanian", "alb/sqi", "sq"),
    ("Alemani", "gsw", None),
    ("Aleut", "ale", None),
    ("Algonquian languages", "alg", None),
    ("Altaic (Other)", "tut", None),
    ("Amharic", "amh", "am"),
    ("Angika", "anp", None),
    ("Apache languages", "apa", None),
    ("Arabic", "ara", "ar"),
    ("Aragonese", "arg", "an"),
    ("Aramaic", "arc", None),
    ("Arapaho", "arp", None),
    ("Araucanian", "arn", None),
    ("Arawak", "arw", None),
    ("Armenian", "arm/hye", "hy"),
    ("Aromanian", "rup", None),
    ("Artificial (Other)", "art", None),
    ("Arumanian", "rup", None),
    ("Assamese", "asm", "as"),
    ("Asturian", "ast", None),
    ("Athapascan languages", "ath", None),
    ("Australian languages", "aus", None),
    ("Austronesian (Other)", "map", None),
    ("Avaric", "ava", "av"),
    ("Avestan", "ave", "ae"),
    ("Awadhi", "awa", None),
    ("Aymara", "aym", "ay"),
    ("Azerbaijani", "aze", "az"),
    ("Bable", "ast", None),
    ("Balinese", "ban", None),
    ("Baltic (Other)", "bat", None),
    ("Baluchi", "bal", None),
    ("Bambara", "bam", "bm"),
    ("Bamileke languages", "bai", None),
    ("Banda", "bad", None),
    ("Bantu (Other)", "bnt", None),
    ("Basa", "bas", None),
    ("Bashkir", "bak", "ba"),
    ("Basque", "baq/eus", "eu"),
    ("Batak (Indonesia)", "btk", None),
    ("Beja", "bej", None),
    ("Belarusian", "bel", "be"),
    ("Bemba", "bem", None),
    ("Bengali", "ben", "bn"),
    ("Berber (Other)", "ber", None),
    ("Bhojpuri", "bho", None),
    ("Bihari", "bih", "bh"),
    ("Bikol", "bik", None),
    ("Bilin", "byn", None),
    ("Bini", "bin", None),
    ("Bislama", "bis", "bi"),
    ("Blin", "byn", None),
    ("Bokmål, Norwegian", "nob", "nb"),
    ("Bosnian", "bos", "bs"),
    ("Braj", "bra", None),
    ("Breton", "bre", "br"),
    ("Buginese", "bug", None),
    ("Bulgarian", "bul", "bg"),
    ("Buriat", "bua", None),
    ("Burmese", "bur/mya", "my"),
    ("Caddo", "cad", None),
    ("Carib", "car", None),
    ("Castilian", "spa", "es"),
    ("Catalan", "cat", "ca"),
    ("Caucasian (Other)", "cau", None),
    ("Cebuano", "ceb", None),
    ("Celtic (Other)", "cel", None),
    ("Central American Indian (Other)", "cai", None),
    ("Chagatai", "chg", None),
    ("Chamic languages", "cmc", None),
    ("Chamorro", "cha", "ch"),
    ("Chechen", "che", "ce"),
    ("Cherokee", "chr", None),
    ("Chewa", "nya", "ny"),
    ("Cheyenne", "chy", None),
    ("Chibcha", "chb", None),
    ("Chichewa", "nya", "ny"),
    ("Chinese", "chi/zho", "zh"),
    ("Chinook jargon", "chn", None),
    ("Chipewyan", "chp", None),
    ("Choctaw", "cho", None),
    ("Chuang", "zha", "za"),
    ("Church Slavic", "chu", "cu"),
    ("Church Slavonic", "chu", "cu"),
    ("Chuukese", "chk", None),
    ("Chuvash", "chv", "cv"),
    ("Classical Nepal Bhasa", "nwc", None),
    ("Classical Newari", "nwc", None),
    ("Coptic", "cop", None),
    ("Cornish", "cor", "kw"),
    ("Corsican", "cos", "co"),
    ("Cree", "cre", "cr"),
    ("Creek", "mus", None),
    ("Creoles and pidgins (Other)", "crp", None),
    ("Creoles and pidgins, English based (Other)", "cpe", None),
    ("Creoles and pidgins, French-based (Other)", "cpf", None),
    ("Creoles and pidgins, Portuguese-based (Other)", "cpp", None),
    ("Crimean Tatar", "crh", None),
    ("Crimean Turkish", "crh", None),
    ("Croatian", "scr/hrv", "hr"),
    ("Cushitic (Other)", "cus", None),
    ("Czech", "cze/ces", "cs"),
    ("Dakota", "dak", None),
    ("Danish", "dan", "da"),
    ("Dargwa", "dar", None),
    ("Dayak", "day", None),
    ("Delaware", "del", None),
    ("Dhivehi", "div", "dv"),
    ("Dimili", "zza", None),
    ("Dimli", "zza", None),
    ("Dinka", "din", None),
    ("Divehi", "div", "dv"),
    ("Dogri", "doi", None),
    ("Dogrib", "dgr", None),
    ("Dravidian (Other)", "dra", None),
    ("Duala", "dua", None),
    ("Dutch", "dut/nld", "nl"),
    ("Dutch, Middle (ca.1050-1350)", "dum", None),
    ("Dyula", "dyu", None),
    ("Dzongkha", "dzo", "dz"),
    ("Eastern Frisian", "frs", None),
    ("Efik", "efi", None),
    ("Egyptian (Ancient)", "egy", None),
    ("Ekajuk", "eka", None),
    ("Elamite", "elx", None),
    ("English", "eng", "en"),
    ("English, Middle (1100-1500)", "enm", None),
    ("English, Old (ca.450-1100)", "ang", None),
    ("Erzya", "myv", None),
    ("Esperanto", "epo", "eo"),
    ("Estonian", "est", "et"),
    ("Ewe", "ewe", "ee"),
    ("Ewondo", "ewo", None),
    ("Fang", "fan", None),
    ("Fanti", "fat", None),
    ("Faroese", "fao", "fo"),
    ("Fijian", "fij", "fj"),
    ("Filipino", "fil", None),
    ("Finnish", "fin", "fi"),
    ("Finno-Ugrian (Other)", "fiu", None),
    ("Flemish", "dut/nld", "nl"),
    ("Fon", "fon", None),
    ("French", "fre/fra", "fr"),
    ("French, Middle (ca.1400-1600)", "frm", None),
    ("French, Old (842-ca.1400)", "fro", None),
    ("Friulian", "fur", None),
    ("Fulah", "ful", "ff"),
    ("Ga", "gaa", None),
    ("Gaelic", "gla", "gd"),
    ("Galician", "glg", "gl"),
    ("Ganda", "lug", "lg"),
    ("Gayo", "gay", None),
    ("Gbaya", "gba", None),
    ("Geez", "gez", None),
    ("Georgian", "geo/kat", "ka"),
    ("German", "ger/deu", "de"),
    ("German, Low", "nds", None),
    ("German, Middle High (ca.1050-1500)", "gmh", None),
    ("German, Old High (ca.750-1050)", "goh", None),
    ("Germanic (Other)", "gem", None),
    ("Gikuyu", "kik", "ki"),
    ("Gilbertese", "gil", None),
    ("Gondi", "gon", None),
    ("Gorontalo", "gor", None),
    ("Gothic", "got", None),
    ("Grebo", "grb", None),
    ("Greek, Ancient (to 1453)", "grc", None),
    ("Greek, Modern (1453-)", "gre/ell", "el"),
    ("Greenlandic", "kal", "kl"),
    ("Guarani", "grn", "gn"),
    ("Gujarati", "guj", "gu"),
    ("Gwich´in", "gwi", None),
    ("Haida", "hai", None),
    ("Haitian", "hat", "ht"),
    ("Haitian Creole", "hat", "ht"),
    ("Hausa", "hau", "ha"),
    ("Hawaiian", "haw", None),
    ("Hebrew", "heb", "he"),
    ("Herero", "her", "hz"),
    ("Hiligaynon", "hil", None),
    ("Himachali", "him", None),
    ("Hindi", "hin", "hi"),
    ("Hiri Motu", "hmo", "ho"),
    ("Hittite", "hit", None),
    ("Hmong", "hmn", None),
    ("Hungarian", "hun", "hu"),
    ("Hupa", "hup", None),
    ("Iban", "iba", None),
    ("Icelandic", "ice/isl", "is"),
    ("Ido", "ido", "io"),
    ("Igbo", "ibo", "ig"),
    ("Ijo", "ijo", None),
    ("Iloko", "ilo", None),
    ("Inari Sami", "smn", None),
    ("Indic (Other)", "inc", None),
    ("Indo-European (Other)", "ine", None),
    ("Indonesian", "ind", "id"),
    ("Ingush", "inh", None),
    ("Interlingua", "ina", "ia"),
    ("Interlingue", "ile", "ie"),
    ("Inuktitut", "iku", "iu"),
    ("Inupiaq", "ipk", "ik"),
    ("Iranian (Other)", "ira", None),
    ("Irish", "gle", "ga"),
    ("Irish, Middle (900-1200)", "mga", None),
    ("Irish, Old (to 900)", "sga", None),
    ("Iroquoian languages", "iro", None),
    ("Italian", "ita", "it"),
    ("Japanese", "jpn", "ja"),
    ("Javanese", "jav", "jv"),
    ("Judeo-Arabic", "jrb", None),
    ("Judeo-Persian", "jpr", None),
    ("Kabardian", "kbd", None),
    ("Kabyle", "kab", None),
    ("Kachin", "kac", None),
    ("Kalaallisut", "kal", "kl"),
    ("Kalmyk", "xal", None),
    ("Kamba", "kam", None),
    ("Kannada", "kan", "kn"),
    ("Kanuri", "kau", "kr"),
    ("Kara-Kalpak", "kaa", None),
    ("Karachay-Balkar", "krc", None),
    ("Karelian", "krl", None),
    ("Karen", "kar", None),
    ("Kashmiri", "kas", "ks"),
    ("Kashubian", "csb", None),
    ("Kawi", "kaw", None),
    ("Kazakh", "kaz", "kk"),
    ("Khasi", "kha", None),
    ("Khmer", "khm", "km"),
    ("Khoisan (Other)", "khi", None),
    ("Khotanese", "kho", None),
    ("Kikuyu", "kik", "ki"),
    ("Kimbundu", "kmb", None),
    ("Kinyarwanda", "kin", "rw"),
    ("Kirdki", "zza", None),
    ("Kirghiz", "kir", "ky"),
    ("Kirmanjki", "zza", None),
    ("Klingon", "tlh", None),
    ("Komi", "kom", "kv"),
    ("Kongo", "kon", "kg"),
    ("Konkani", "kok", None),
    ("Korean", "kor", "ko"),
    ("Kosraean", "kos", None),
    ("Kpelle", "kpe", None),
    ("Kru", "kro", None),
    ("Kuanyama", "kua", "kj"),
    ("Kumyk", "kum", None),
    ("Kurdish", "kur", "ku"),
    ("Kurukh", "kru", None),
    ("Kutenai", "kut", None),
    ("Kwanyama", "kua", "kj"),
    ("Ladino", "lad", None),
    ("Lahnda", "lah", None),
    ("Lamba", "lam", None),
    ("Lao", "lao", "lo"),
    ("Latin", "lat", "la"),
    ("Latvian", "lav", "lv"),
    ("Letzeburgesch", "ltz", "lb"),
    ("Lezghian", "lez", None),
    ("Limburgan", "lim", "li"),
    ("Limburger", "lim", "li"),
    ("Limburgish", "lim", "li"),
    ("Lingala", "lin", "ln"),
    ("Lithuanian", "lit", "lt"),
    ("Lojban", "jbo", None),
    ("Low German", "nds", None),
    ("Low Saxon", "nds", None),
    ("Lower Sorbian", "dsb", None),
    ("Lozi", "loz", None),
    ("Luba-Katanga", "lub", "lu"),
    ("Luba-Lulua", "lua", None),
    ("Luiseno", "lui", None),
    ("Lule Sami", "smj", None),
    ("Lunda", "lun", None),
    ("Luo (Kenya and Tanzania)", "luo", None),
    ("Lushai", "lus", None),
    ("Luxembourgish", "ltz", "lb"),
    ("Macedo-Romanian", "rup", None),
    ("Macedonian", "mac/mkd", "mk"),
    ("Madurese", "mad", None),
    ("Magahi", "mag", None),
    ("Maithili", "mai", None),
    ("Makasar", "mak", None),
    ("Malagasy", "mlg", "mg"),
    ("Malay", "may/msa", "ms"),
    ("Malayalam", "mal", "ml"),
    ("Maldivian", "div", "dv"),
    ("Maltese", "mlt", "mt"),
    ("Manchu", "mnc", None),
    ("Mandar", "mdr", None),
    ("Mandingo", "man", None),
    ("Manipuri", "mni", None),
    ("Manobo languages", "mno", None),
    ("Manx", "glv", "gv"),
    ("Maori", "mao/mri", "mi"),
    ("Marathi", "mar", "mr"),
    ("Mari", "chm", None),
    ("Marshallese", "mah", "mh"),
    ("Marwari", "mwr", None),
    ("Masai", "mas", None),
    ("Mayan languages", "myn", None),
    ("Mende", "men", None),
    ("Mi'kmaq", "mic", None),
    ("Micmac", "mic", None),
    ("Minangkabau", "min", None),
    ("Mirandese", "mwl", None),
    ("Mohawk", "moh", None),
    ("Moksha", "mdf", None),
    ("Moldavian", "mol", "mo"),
    ("Mon-Khmer (Other)", "mkh", None),
    ("Mongo", "lol", None),
    ("Mongolian", "mon", "mn"),
    ("Mossi", "mos", None),
    ("Multiple languages", "mul", None),
    ("Munda languages", "mun", None),
    ("N'Ko", "nqo", None),
    ("Nahuatl", "nah", None),
    ("Nauru", "nau", "na"),
    ("Navaho", "nav", "nv"),
    ("Navajo", "nav", "nv"),
    ("Ndebele, North", "nde", "nd"),
    ("Ndebele, South", "nbl", "nr"),
    ("Ndonga", "ndo", "ng"),
    ("Neapolitan", "nap", None),
    ("Nepal Bhasa", "new", None),
    ("Nepali", "nep", "ne"),
    ("Newari", "new", None),
    ("Nias", "nia", None),
    ("Niger-Kordofanian (Other)", "nic", None),
    ("Nilo-Saharan (Other)", "ssa", None),
    ("Niuean", "niu", None),
    ("No linguistic content", "zxx", None),
    ("Nogai", "nog", None),
    ("Norse, Old", "non", None),
    ("North American Indian", "nai", None),
    ("North Ndebele", "nde", "nd"),
    ("Northern Frisian", "frr", None),
    ("Northern Sami", "sme", "se"),
    ("Northern Sotho", "nso", None),
    ("Norwegian", "nor", "no"),
    ("Norwegian Bokmål", "nob", "nb"),
    ("Norwegian Nynorsk", "nno", "nn"),
    ("Nubian languages", "nub", None),
    ("Nyamwezi", "nym", None),
    ("Nyanja", "nya", "ny"),
    ("Nyankole", "nyn", None),
    ("Nynorsk, Norwegian", "nno", "nn"),
    ("Nyoro", "nyo", None),
    ("Nzima", "nzi", None),
    ("Occitan (post 1500)", "oci", "oc"),
    ("Oirat", "xal", None),
    ("Ojibwa", "oji", "oj"),
    ("Old Bulgarian", "chu", "cu"),
    ("Old Church Slavonic", "chu", "cu"),
    ("Old Newari", "nwc", None),
    ("Old Slavonic", "chu", "cu"),
    ("Oriya", "ori", "or"),
    ("Oromo", "orm", "om"),
    ("Osage", "osa", None),
    ("Ossetian", "oss", "os"),
    ("Ossetic", "oss", "os"),
    ("Otomian languages", "oto", None),
    ("Pahlavi", "pal", None),
    ("Palauan", "pau", None),
    ("Pali", "pli", "pi"),
    ("Pampanga", "pam", None),
    ("Pangasinan", "pag", None),
    ("Panjabi", "pan", "pa"),
    ("Papiamento", "pap", None),
    ("Papuan (Other)", "paa", None),
    ("Pedi", "nso", None),
    ("Persian", "per/fas", "fa"),
    ("Persian, Old (ca.600-400 B.C.)", "peo", None),
    ("Philippine (Other)", "phi", None),
    ("Phoenician", "phn", None),
    ("Pilipino", "fil", None),
    ("Pohnpeian", "pon", None),
    ("Polish", "pol", "pl"),
    ("Portuguese", "por", "pt"),
    ("Prakrit languages", "pra", None),
    ("Provençal", "oci", "oc"),
    ("Provençal, Old (to 1500)", "pro", None),
    ("Punjabi", "pan", "pa"),
    ("Pushto", "pus", "ps"),
    ("Quechua", "que", "qu"),
    ("Raeto-Romance", "roh", "rm"),
    ("Rajasthani", "raj", None),
    ("Rapanui", "rap", None),
    ("Rarotongan", "rar", None),
    ("Reserved for local use", "qaa/qtz", None),
    ("Romance (Other)", "roa", None),
    ("Romanian", "rum/ron", "ro"),
    ("Romany", "rom", None),
    ("Rundi", "run", "rn"),
    ("Russian", "rus", "ru"),
    ("Salishan languages", "sal", None),
    ("Samaritan Aramaic", "sam", None),
    ("Sami languages (Other)", "smi", None),
    ("Samoan", "smo", "sm"),
    ("Sandawe", "sad", None),
    ("Sango", "sag", "sg"),
    ("Sanskrit", "san", "sa"),
    ("Santali", "sat", None),
    ("Sardinian", "srd", "sc"),
    ("Sasak", "sas", None),
    ("Saxon, Low", "nds", None),
    ("Scots", "sco", None),
    ("Scottish Gaelic", "gla", "gd"),
    ("Selkup", "sel", None),
    ("Semitic (Other)", "sem", None),
    ("Sepedi", "nso", None),
    ("Serbian", "scc/srp", "sr"),
    ("Serer", "srr", None),
    ("Shan", "shn", None),
    ("Shona", "sna", "sn"),
    ("Sichuan Yi", "iii", "ii"),
    ("Sicilian", "scn", None),
    ("Sidamo", "sid", None),
    ("Sign Languages", "sgn", None),
    ("Siksika", "bla", None),
    ("Sindhi", "snd", "sd"),
    ("Sinhala", "sin", "si"),
    ("Sinhalese", "sin", "si"),
    ("Sino-Tibetan (Other)", "sit", None),
    ("Siouan languages", "sio", None),
    ("Skolt Sami", "sms", None),
    ("Slave (Athapascan)", "den", None),
    ("Slavic (Other)", "sla", None),
    ("Slovak", "slo/slk", "sk"),
    ("Slovenian", "slv", "sl"),
    ("Sogdian", "sog", None),
    ("Somali", "som", "so"),
    ("Songhai", "son", None),
    ("Soninke", "snk", None),
    ("Sorbian languages", "wen", None),
    ("Sotho, Northern", "nso", None),
    ("Sotho, Southern", "sot", "st"),
    ("South American Indian (Other)", "sai", None),
    ("South Ndebele", "nbl", "nr"),
    ("Southern Altai", "alt", None),
    ("Southern Sami", "sma", None),
    ("Spanish", "spa", "es"),
    ("Sranan Togo", "srn", None),
    ("Sukuma", "suk", None),
    ("Sumerian", "sux", None),
    ("Sundanese", "sun", "su"),
    ("Susu", "sus", None),
    ("Swahili", "swa", "sw"),
    ("Swati", "ssw", "ss"),
    ("Swedish", "swe", "sv"),
    ("Swiss German", "gsw", None),
    ("Syriac", "syr", None),
    ("Tagalog", "tgl", "tl"),
    ("Tahitian", "tah", "ty"),
    ("Tai (Other)", "tai", None),
    ("Tajik", "tgk", "tg"),
    ("Tamashek", "tmh", None),
    ("Tamil", "tam", "ta"),
    ("Tatar", "tat", "tt"),
    ("Telugu", "tel", "te"),
    ("Tereno", "ter", None),
    ("Tetum", "tet", None),
    ("Thai", "tha", "th"),
    ("Tibetan", "tib/bod", "bo"),
    ("Tigre", "tig", None),
    ("Tigrinya", "tir", "ti"),
    ("Timne", "tem", None),
    ("Tiv", "tiv", None),
    ("tlhIngan-Hol", "tlh", None),
    ("Tlingit", "tli", None),
    ("Tok Pisin", "tpi", None),
    ("Tokelau", "tkl", None),
    ("Tonga (Nyasa)", "tog", None),
    ("Tonga (Tonga Islands)", "ton", "to"),
    ("Tsimshian", "tsi", None),
    ("Tsonga", "tso", "ts"),
    ("Tswana", "tsn", "tn"),
    ("Tumbuka", "tum", None),
    ("Tupi languages", "tup", None),
    ("Turkish", "tur", "tr"),
    ("Turkish, Ottoman (1500-1928)", "ota", None),
    ("Turkmen", "tuk", "tk"),
    ("Tuvalu", "tvl", None),
    ("Tuvinian", "tyv", None),
    ("Twi", "twi", "tw"),
    ("Udmurt", "udm", None),
    ("Ugaritic", "uga", None),
    ("Uighur", "uig", "ug"),
    ("Ukrainian", "ukr", "uk"),
    ("Umbundu", "umb", None),
    ("Uncoded languages", "mis", None),
    ("Undetermined", "und", None),
    ("Upper Sorbian", "hsb", None),
    ("Urdu", "urd", "ur"),
    ("Uyghur", "uig", "ug"),
    ("Uzbek", "uzb", "uz"),
    ("Vai", "vai", None),
    ("Valencian", "cat", "ca"),
    ("Venda", "ven", "ve"),
    ("Vietnamese", "vie", "vi"),
    ("Volapük", "vol", "vo"),
    ("Votic", "vot", None),
    ("Wakashan languages", "wak", None),
    ("Walamo", "wal", None),
    ("Walloon", "wln", "wa"),
    ("Waray", "war", None),
    ("Washo", "was", None),
    ("Welsh", "wel/cym", "cy"),
    ("Western Frisian", "fry", "fy"),
    ("Wolof", "wol", "wo"),
    ("Xhosa", "xho", "xh"),
    ("Yakut", "sah", None),
    ("Yao", "yao", None),
    ("Yapese", "yap", None),
    ("Yiddish", "yid", "yi"),
    ("Yoruba", "yor", "yo"),
    ("Yupik languages", "ypk", None),
    ("Zande", "znd", None),
    ("Zapotec", "zap", None),
    ("Zaza", "zza", None),
    ("Zazaki", "zza", None),
    ("Zenaga", "zen", None),
    ("Zhuang", "zha", "za"),
    ("Zulu", "zul", "zu"),
    ("Zuni", "zun", None),
)

# Bibliographic ISO-639-2 form (eg. "fre" => "French")
ISO639_2 = {}
for line in _ISO639:
    for key in line[1].split("/"):
        ISO639_2[key] = line[0]
del _ISO639
