# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create a load balancer.

    :example: Create a basic load balancer.
        az network lb create -g MyResourceGroup -n MyLb --sku Basic

    :example: Create a basic load balancer on a specific virtual network and subnet If a virtual network with the same name is found in the same resource group, the load balancer will utilize this virtual network.  If one is not found a new one will be created.
        az network lb create -g MyResourceGroup -n MyLb --sku Basic --vnet-name MyVnet --subnet MySubnet

    :example: Create a basic load balancer on a subnet of a pre-existing virtual network. The subnet can be in arbitary resource group or subscription by providing the ID of the subnet.
        az network lb create -g MyResourceGroup -n MyLb --sku Basic --subnet {subnetID}

    :example: Create a basic zone flavored internal load balancer, through provisioning a zonal public ip.
        az network lb create -g MyResourceGroup -n MyLb --sku Basic --public-ip-zone 2

    :example: Create a standard zone flavored public-facing load balancer, through provisioning a zonal frontend ip configuration and Vnet.
        az etwork lb create -g MyResourceGroup -n MyLb --sku Standard --frontend-ip-zone 1 --vnet-name MyVnet --subnet MySubnet
    """

    _aaz_info = {
        "version": "2018-11-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.network/loadbalancers/{}", "2018-11-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["-n", "--name"],
            help="The load balancer name.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "Parameters"

        _args_schema = cls._args_schema
        _args_schema.location = AAZResourceLocationArg(
            arg_group="Parameters",
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.sku = AAZObjectArg(
            options=["--sku"],
            arg_group="Parameters",
            help="The load balancer SKU.",
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="Parameters",
            help="Resource tags.",
        )

        sku = cls._args_schema.sku
        sku.name = AAZStrArg(
            options=["name"],
            help="Name of a load balancer SKU.",
            enum={"Basic": "Basic", "Standard": "Standard"},
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.backend_address_pools = AAZListArg(
            options=["--backend-address-pools"],
            arg_group="Properties",
            help="Collection of backend address pools used by a load balancer.",
        )
        _args_schema.inbound_nat_pools = AAZListArg(
            options=["--inbound-nat-pools"],
            arg_group="Properties",
            help="Defines an external port range for inbound NAT to a single backend port on NICs associated with a load balancer. Inbound NAT rules are created automatically for each NIC associated with the Load Balancer using an external port from this range. Defining an Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound NAT rules. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an inbound NAT pool. They have to reference individual inbound NAT rules.",
        )
        _args_schema.inbound_nat_rules = AAZListArg(
            options=["--inbound-nat-rules"],
            arg_group="Properties",
            help="Collection of inbound NAT Rules used by a load balancer. Defining inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with individual virtual machines cannot reference an Inbound NAT pool. They have to reference individual inbound NAT rules.",
        )
        _args_schema.load_balancing_rules = AAZListArg(
            options=["--load-balancing-rules"],
            arg_group="Properties",
            help="Object collection representing the load balancing rules Gets the provisioning.",
        )
        _args_schema.outbound_rules = AAZListArg(
            options=["--outbound-rules"],
            arg_group="Properties",
            help="The outbound rules.",
        )
        _args_schema.probes = AAZListArg(
            options=["--probes"],
            arg_group="Properties",
            help="Collection of probe objects used in the load balancer.",
        )

        backend_address_pools = cls._args_schema.backend_address_pools
        backend_address_pools.Element = AAZObjectArg()

        _element = cls._args_schema.backend_address_pools.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of backend address pools used by the load balancer. This name can be used to access the resource.",
        )

        inbound_nat_pools = cls._args_schema.inbound_nat_pools
        inbound_nat_pools.Element = AAZObjectArg()

        _element = cls._args_schema.inbound_nat_pools.Element
        _element.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.",
        )
        _element.backend_port = AAZIntArg(
            options=["backend-port"],
            help="The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.",
        )
        _element.enable_floating_ip = AAZBoolArg(
            options=["enable-floating-ip"],
            help="Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.",
        )
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="A reference to frontend IP addresses.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port_range_end = AAZIntArg(
            options=["frontend-port-range-end"],
            help="The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.",
        )
        _element.frontend_port_range_start = AAZIntArg(
            options=["frontend-port-range-start"],
            help="The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The reference to the transport protocol used by the inbound NAT pool.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )

        inbound_nat_rules = cls._args_schema.inbound_nat_rules
        inbound_nat_rules.Element = AAZObjectArg()

        _element = cls._args_schema.inbound_nat_rules.Element
        _element.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/loadBalancers/{}/inboundNatRules/{}",
            ),
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of inbound NAT rules used by the load balancer. This name can be used to access the resource.",
        )
        _element.backend_port = AAZIntArg(
            options=["backend-port"],
            help="The port used for the internal endpoint. Acceptable values range from 1 to 65535.",
        )
        _element.enable_floating_ip = AAZBoolArg(
            options=["enable-floating-ip"],
            help="Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.",
        )
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="A reference to frontend IP addresses.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port = AAZIntArg(
            options=["frontend-port"],
            help="The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values range from 1 to 65534.",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The reference to the transport protocol used by the load balancing rule.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )

        load_balancing_rules = cls._args_schema.load_balancing_rules
        load_balancing_rules.Element = AAZObjectArg()

        _element = cls._args_schema.load_balancing_rules.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.",
        )
        _element.backend_address_pool = AAZObjectArg(
            options=["backend-address-pool"],
            help="A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.",
        )
        cls._build_args_sub_resource_create(_element.backend_address_pool)
        _element.backend_port = AAZIntArg(
            options=["backend-port"],
            help="The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables \"Any Port\".",
        )
        _element.disable_outbound_snat = AAZBoolArg(
            options=["disable-outbound-snat"],
            help="Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.",
        )
        _element.enable_floating_ip = AAZBoolArg(
            options=["floating-ip", "enable-floating-ip"],
            help="Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.",
        )
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configuration = AAZObjectArg(
            options=["frontend-ip-configuration"],
            help="A reference to frontend IP addresses.",
        )
        cls._build_args_sub_resource_create(_element.frontend_ip_configuration)
        _element.frontend_port = AAZIntArg(
            options=["frontend-port"],
            help="The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables \"Any Port\".",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout", "idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.",
        )
        _element.load_distribution = AAZStrArg(
            options=["load-distribution"],
            help="The load distribution policy for this rule.",
            enum={"Default": "Default", "SourceIP": "SourceIP", "SourceIPProtocol": "SourceIPProtocol"},
        )
        _element.probe = AAZObjectArg(
            options=["probe"],
            help="The reference to the load balancer probe used by the load balancing rule.",
        )
        cls._build_args_sub_resource_create(_element.probe)
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The reference to the transport protocol used by the load balancing rule.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )

        outbound_rules = cls._args_schema.outbound_rules
        outbound_rules.Element = AAZObjectArg()

        _element = cls._args_schema.outbound_rules.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of outbound rules used by the load balancer. This name can be used to access the resource.",
        )
        _element.allocated_outbound_ports = AAZIntArg(
            options=["outbound-ports", "allocated-outbound-ports"],
            help="The number of outbound ports to be used for NAT.",
        )
        _element.backend_address_pool = AAZObjectArg(
            options=["backend-address-pool"],
            help="A reference to a pool of DIPs. Outbound traffic is randomly load balanced across IPs in the backend IPs.",
        )
        cls._build_args_sub_resource_create(_element.backend_address_pool)
        _element.enable_tcp_reset = AAZBoolArg(
            options=["enable-tcp-reset"],
            help="Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.",
        )
        _element.frontend_ip_configurations = AAZListArg(
            options=["frontend-ip-configurations"],
            help="The Frontend IP addresses of the load balancer.",
        )
        _element.idle_timeout_in_minutes = AAZIntArg(
            options=["idle-timeout", "idle-timeout-in-minutes"],
            help="The timeout for the TCP idle connection.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help="The protocol for the outbound rule in load balancer.",
            enum={"All": "All", "Tcp": "Tcp", "Udp": "Udp"},
        )

        frontend_ip_configurations = cls._args_schema.outbound_rules.Element.frontend_ip_configurations
        frontend_ip_configurations.Element = AAZObjectArg()
        cls._build_args_sub_resource_create(frontend_ip_configurations.Element)

        probes = cls._args_schema.probes
        probes.Element = AAZObjectArg()

        _element = cls._args_schema.probes.Element
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within the set of probes used by the load balancer. This name can be used to access the resource.",
        )
        _element.interval_in_seconds = AAZIntArg(
            options=["interval", "interval-in-seconds"],
            help={"short-summary": "The interval, in seconds, for how frequently to probe the endpoint for health status.", "long-summary": "Typically, the interval is slightly less than half the allocated timeout period (in seconds) which allows two full probes before taking the instance out of rotation. The default value is 15, the minimum value is 5."},
        )
        _element.number_of_probes = AAZIntArg(
            options=["threshold", "number-of-probes"],
            help={"short-summary": "The number of consecutive probe failures before an instance is deemed unhealthy.", "long-summary": "This values allows endpoints to be taken out of rotation faster or slower than the typical times used in Azure."},
        )
        _element.port = AAZIntArg(
            options=["port"],
            help="The port for communicating the probe. Possible values range from 1 to 65535, inclusive.",
        )
        _element.protocol = AAZStrArg(
            options=["protocol"],
            help={"short-summary": "The protocol of the end point.", "long-summary": "If 'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' or 'Https' is specified, a 200 OK response from the specifies URI is required for the probe to be successful."},
            enum={"Http": "Http", "Https": "Https", "Tcp": "Tcp"},
        )
        _element.request_path = AAZStrArg(
            options=["path", "request-path"],
            help="The URI used for requesting health status from the VM. Path is required if a protocol is set to http. Otherwise, it is not allowed.",
        )
        return cls._args_schema

    _args_application_security_group_create = None

    @classmethod
    def _build_args_application_security_group_create(cls, _schema):
        if cls._args_application_security_group_create is not None:
            _schema.id = cls._args_application_security_group_create.id
            _schema.location = cls._args_application_security_group_create.location
            _schema.tags = cls._args_application_security_group_create.tags
            return

        cls._args_application_security_group_create = AAZObjectArg()

        application_security_group_create = cls._args_application_security_group_create
        application_security_group_create.id = AAZResourceIdArg(
            options=["id"],
            help="Resource ID.",
            fmt=AAZResourceIdArgFormat(
                template="/subscriptions/{}/resourceGroups/{}/providers/Microsoft.Network/applicationSecurityGroups/{}",
            ),
        )
        application_security_group_create.location = AAZResourceLocationArg(
            options=["l", "location"],
            help="Resource location.",
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        application_security_group_create.tags = AAZDictArg(
            options=["tags"],
            help="Resource tags.",
        )

        tags = cls._args_application_security_group_create.tags
        tags.Element = AAZStrArg()

        _schema.id = cls._args_application_security_group_create.id
        _schema.location = cls._args_application_security_group_create.location
        _schema.tags = cls._args_application_security_group_create.tags

    _args_security_rule_create = None

    @classmethod
    def _build_args_security_rule_create(cls, _schema):
        if cls._args_security_rule_create is not None:
            _schema.access = cls._args_security_rule_create.access
            _schema.description = cls._args_security_rule_create.description
            _schema.destination_address_prefix = cls._args_security_rule_create.destination_address_prefix
            _schema.destination_address_prefixes = cls._args_security_rule_create.destination_address_prefixes
            _schema.destination_application_security_groups = cls._args_security_rule_create.destination_application_security_groups
            _schema.destination_port_range = cls._args_security_rule_create.destination_port_range
            _schema.destination_port_ranges = cls._args_security_rule_create.destination_port_ranges
            _schema.direction = cls._args_security_rule_create.direction
            _schema.etag = cls._args_security_rule_create.etag
            _schema.name = cls._args_security_rule_create.name
            _schema.priority = cls._args_security_rule_create.priority
            _schema.protocol = cls._args_security_rule_create.protocol
            _schema.provisioning_state = cls._args_security_rule_create.provisioning_state
            _schema.source_address_prefix = cls._args_security_rule_create.source_address_prefix
            _schema.source_address_prefixes = cls._args_security_rule_create.source_address_prefixes
            _schema.source_application_security_groups = cls._args_security_rule_create.source_application_security_groups
            _schema.source_port_range = cls._args_security_rule_create.source_port_range
            _schema.source_port_ranges = cls._args_security_rule_create.source_port_ranges
            return

        cls._args_security_rule_create = AAZObjectArg()

        security_rule_create = cls._args_security_rule_create
        security_rule_create.etag = AAZStrArg(
            options=["etag"],
            help="A unique read-only string that changes whenever the resource is updated.",
        )
        security_rule_create.name = AAZStrArg(
            options=["name"],
            help="The name of the resource that is unique within a resource group. This name can be used to access the resource.",
        )
        security_rule_create.access = AAZStrArg(
            options=["access"],
            help="The network traffic is allowed or denied. Possible values are: 'Allow' and 'Deny'.",
            enum={"Allow": "Allow", "Deny": "Deny"},
        )
        security_rule_create.description = AAZStrArg(
            options=["description"],
            help="A description for this rule. Restricted to 140 chars.",
        )
        security_rule_create.destination_address_prefix = AAZStrArg(
            options=["destination-address-prefix"],
            help="The destination address prefix. CIDR or destination IP range. Asterisks '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used.",
        )
        security_rule_create.destination_address_prefixes = AAZListArg(
            options=["destination-address-prefixes"],
            help="The destination address prefixes. CIDR or destination IP ranges.",
        )
        security_rule_create.destination_application_security_groups = AAZListArg(
            options=["destination-application-security-groups"],
            help="The application security group specified as destination.",
        )
        security_rule_create.destination_port_range = AAZStrArg(
            options=["destination-port-range"],
            help="The destination port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.",
        )
        security_rule_create.destination_port_ranges = AAZListArg(
            options=["destination-port-ranges"],
            help="The destination port ranges.",
        )
        security_rule_create.direction = AAZStrArg(
            options=["direction"],
            help="The direction of the rule. The direction specifies if rule will be evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'.",
            enum={"Inbound": "Inbound", "Outbound": "Outbound"},
        )
        security_rule_create.priority = AAZIntArg(
            options=["priority"],
            help="The priority of the rule. The value can be between 100 and 4096. The priority number must be unique for each rule in the collection. The lower the priority number, the higher the priority of the rule.",
        )
        security_rule_create.protocol = AAZStrArg(
            options=["protocol"],
            help="Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and '*'.",
            enum={"*": "*", "Tcp": "Tcp", "Udp": "Udp"},
        )
        security_rule_create.provisioning_state = AAZStrArg(
            options=["provisioning-state"],
            help="The provisioning state of the public IP resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.",
        )
        security_rule_create.source_address_prefix = AAZStrArg(
            options=["source-address-prefix"],
            help="The CIDR or source IP range. Asterisks '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this is an ingress rule, specifies where network traffic originates from. ",
        )
        security_rule_create.source_address_prefixes = AAZListArg(
            options=["source-address-prefixes"],
            help="The CIDR or source IP ranges.",
        )
        security_rule_create.source_application_security_groups = AAZListArg(
            options=["source-application-security-groups"],
            help="The application security group specified as source.",
        )
        security_rule_create.source_port_range = AAZStrArg(
            options=["source-port-range"],
            help="The source port or range. Integer or range between 0 and 65535. Asterisks '*' can also be used to match all ports.",
        )
        security_rule_create.source_port_ranges = AAZListArg(
            options=["source-port-ranges"],
            help="The source port ranges.",
        )

        destination_address_prefixes = cls._args_security_rule_create.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrArg()

        destination_application_security_groups = cls._args_security_rule_create.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(destination_application_security_groups.Element)

        destination_port_ranges = cls._args_security_rule_create.destination_port_ranges
        destination_port_ranges.Element = AAZStrArg()

        source_address_prefixes = cls._args_security_rule_create.source_address_prefixes
        source_address_prefixes.Element = AAZStrArg()

        source_application_security_groups = cls._args_security_rule_create.source_application_security_groups
        source_application_security_groups.Element = AAZObjectArg()
        cls._build_args_application_security_group_create(source_application_security_groups.Element)

        source_port_ranges = cls._args_security_rule_create.source_port_ranges
        source_port_ranges.Element = AAZStrArg()

        _schema.access = cls._args_security_rule_create.access
        _schema.description = cls._args_security_rule_create.description
        _schema.destination_address_prefix = cls._args_security_rule_create.destination_address_prefix
        _schema.destination_address_prefixes = cls._args_security_rule_create.destination_address_prefixes
        _schema.destination_application_security_groups = cls._args_security_rule_create.destination_application_security_groups
        _schema.destination_port_range = cls._args_security_rule_create.destination_port_range
        _schema.destination_port_ranges = cls._args_security_rule_create.destination_port_ranges
        _schema.direction = cls._args_security_rule_create.direction
        _schema.etag = cls._args_security_rule_create.etag
        _schema.name = cls._args_security_rule_create.name
        _schema.priority = cls._args_security_rule_create.priority
        _schema.protocol = cls._args_security_rule_create.protocol
        _schema.provisioning_state = cls._args_security_rule_create.provisioning_state
        _schema.source_address_prefix = cls._args_security_rule_create.source_address_prefix
        _schema.source_address_prefixes = cls._args_security_rule_create.source_address_prefixes
        _schema.source_application_security_groups = cls._args_security_rule_create.source_application_security_groups
        _schema.source_port_range = cls._args_security_rule_create.source_port_range
        _schema.source_port_ranges = cls._args_security_rule_create.source_port_ranges

    _args_sub_resource_create = None

    @classmethod
    def _build_args_sub_resource_create(cls, _schema):
        if cls._args_sub_resource_create is not None:
            _schema.id = cls._args_sub_resource_create.id
            return

        cls._args_sub_resource_create = AAZObjectArg()

        sub_resource_create = cls._args_sub_resource_create
        sub_resource_create.id = AAZStrArg(
            options=["id"],
            help="Resource ID.",
        )

        _schema.id = cls._args_sub_resource_create.id

    def _execute_operations(self):
        self.pre_operations()
        yield self.LoadBalancersCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class LoadBalancersCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "loadBalancerName", self.ctx.args.name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2018-11-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location")
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("sku", AAZObjectType, ".sku")
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("backendAddressPools", AAZListType, ".backend_address_pools")
                properties.set_prop("inboundNatPools", AAZListType, ".inbound_nat_pools")
                properties.set_prop("inboundNatRules", AAZListType, ".inbound_nat_rules")
                properties.set_prop("loadBalancingRules", AAZListType, ".load_balancing_rules")
                properties.set_prop("outboundRules", AAZListType, ".outbound_rules")
                properties.set_prop("probes", AAZListType, ".probes")

            backend_address_pools = _builder.get(".properties.backendAddressPools")
            if backend_address_pools is not None:
                backend_address_pools.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.backendAddressPools[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            inbound_nat_pools = _builder.get(".properties.inboundNatPools")
            if inbound_nat_pools is not None:
                inbound_nat_pools.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.inboundNatPools[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.inboundNatPools[].properties")
            if properties is not None:
                properties.set_prop("backendPort", AAZIntType, ".backend_port", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("enableFloatingIP", AAZBoolType, ".enable_floating_ip")
                properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
                properties.set_prop("frontendPortRangeEnd", AAZIntType, ".frontend_port_range_end", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("frontendPortRangeStart", AAZIntType, ".frontend_port_range_start", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})

            inbound_nat_rules = _builder.get(".properties.inboundNatRules")
            if inbound_nat_rules is not None:
                inbound_nat_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.inboundNatRules[]")
            if _elements is not None:
                _elements.set_prop("id", AAZStrType, ".id")
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.inboundNatRules[].properties")
            if properties is not None:
                properties.set_prop("backendPort", AAZIntType, ".backend_port")
                properties.set_prop("enableFloatingIP", AAZBoolType, ".enable_floating_ip")
                properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
                properties.set_prop("frontendPort", AAZIntType, ".frontend_port")
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("protocol", AAZStrType, ".protocol")

            load_balancing_rules = _builder.get(".properties.loadBalancingRules")
            if load_balancing_rules is not None:
                load_balancing_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.loadBalancingRules[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.loadBalancingRules[].properties")
            if properties is not None:
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("backendAddressPool", AAZObjectType, ".backend_address_pool"))
                properties.set_prop("backendPort", AAZIntType, ".backend_port")
                properties.set_prop("disableOutboundSnat", AAZBoolType, ".disable_outbound_snat")
                properties.set_prop("enableFloatingIP", AAZBoolType, ".enable_floating_ip")
                properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("frontendIPConfiguration", AAZObjectType, ".frontend_ip_configuration"))
                properties.set_prop("frontendPort", AAZIntType, ".frontend_port", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("loadDistribution", AAZStrType, ".load_distribution")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("probe", AAZObjectType, ".probe"))
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})

            outbound_rules = _builder.get(".properties.outboundRules")
            if outbound_rules is not None:
                outbound_rules.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.outboundRules[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.outboundRules[].properties")
            if properties is not None:
                properties.set_prop("allocatedOutboundPorts", AAZIntType, ".allocated_outbound_ports")
                _CreateHelper._build_schema_sub_resource_create(properties.set_prop("backendAddressPool", AAZObjectType, ".backend_address_pool", typ_kwargs={"flags": {"required": True}}))
                properties.set_prop("enableTcpReset", AAZBoolType, ".enable_tcp_reset")
                properties.set_prop("frontendIPConfigurations", AAZListType, ".frontend_ip_configurations", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("idleTimeoutInMinutes", AAZIntType, ".idle_timeout_in_minutes")
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})

            frontend_ip_configurations = _builder.get(".properties.outboundRules[].properties.frontendIPConfigurations")
            if frontend_ip_configurations is not None:
                _CreateHelper._build_schema_sub_resource_create(frontend_ip_configurations.set_elements(AAZObjectType, "."))

            probes = _builder.get(".properties.probes")
            if probes is not None:
                probes.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.probes[]")
            if _elements is not None:
                _elements.set_prop("name", AAZStrType, ".name")
                _elements.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

            properties = _builder.get(".properties.probes[].properties")
            if properties is not None:
                properties.set_prop("intervalInSeconds", AAZIntType, ".interval_in_seconds")
                properties.set_prop("numberOfProbes", AAZIntType, ".number_of_probes")
                properties.set_prop("port", AAZIntType, ".port", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
                properties.set_prop("requestPath", AAZStrType, ".request_path")

            sku = _builder.get(".sku")
            if sku is not None:
                sku.set_prop("name", AAZStrType, ".name")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()

            _schema_on_200_201 = cls._schema_on_200_201
            _schema_on_200_201.etag = AAZStrType()
            _schema_on_200_201.id = AAZStrType()
            _schema_on_200_201.location = AAZStrType()
            _schema_on_200_201.name = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200_201.properties = AAZObjectType(
                flags={"client_flatten": True},
            )
            _schema_on_200_201.sku = AAZObjectType()
            _schema_on_200_201.tags = AAZDictType()
            _schema_on_200_201.type = AAZStrType(
                flags={"read_only": True},
            )

            properties = cls._schema_on_200_201.properties
            properties.backend_address_pools = AAZListType(
                serialized_name="backendAddressPools",
            )
            properties.frontend_ip_configurations = AAZListType(
                serialized_name="frontendIPConfigurations",
            )
            properties.inbound_nat_pools = AAZListType(
                serialized_name="inboundNatPools",
            )
            properties.inbound_nat_rules = AAZListType(
                serialized_name="inboundNatRules",
            )
            properties.load_balancing_rules = AAZListType(
                serialized_name="loadBalancingRules",
            )
            properties.outbound_rules = AAZListType(
                serialized_name="outboundRules",
            )
            properties.probes = AAZListType()
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.resource_guid = AAZStrType(
                serialized_name="resourceGuid",
            )

            backend_address_pools = cls._schema_on_200_201.properties.backend_address_pools
            backend_address_pools.Element = AAZObjectType()
            _CreateHelper._build_schema_backend_address_pool_read(backend_address_pools.Element)

            frontend_ip_configurations = cls._schema_on_200_201.properties.frontend_ip_configurations
            frontend_ip_configurations.Element = AAZObjectType()
            _CreateHelper._build_schema_frontend_ip_configuration_read(frontend_ip_configurations.Element)

            inbound_nat_pools = cls._schema_on_200_201.properties.inbound_nat_pools
            inbound_nat_pools.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.inbound_nat_pools.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200_201.properties.inbound_nat_pools.Element.properties
            properties.backend_port = AAZIntType(
                serialized_name="backendPort",
                flags={"required": True},
            )
            properties.enable_floating_ip = AAZBoolType(
                serialized_name="enableFloatingIP",
            )
            properties.enable_tcp_reset = AAZBoolType(
                serialized_name="enableTcpReset",
            )
            properties.frontend_ip_configuration = AAZObjectType(
                serialized_name="frontendIPConfiguration",
            )
            _CreateHelper._build_schema_sub_resource_read(properties.frontend_ip_configuration)
            properties.frontend_port_range_end = AAZIntType(
                serialized_name="frontendPortRangeEnd",
                flags={"required": True},
            )
            properties.frontend_port_range_start = AAZIntType(
                serialized_name="frontendPortRangeStart",
                flags={"required": True},
            )
            properties.idle_timeout_in_minutes = AAZIntType(
                serialized_name="idleTimeoutInMinutes",
            )
            properties.protocol = AAZStrType(
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )

            inbound_nat_rules = cls._schema_on_200_201.properties.inbound_nat_rules
            inbound_nat_rules.Element = AAZObjectType()
            _CreateHelper._build_schema_inbound_nat_rule_read(inbound_nat_rules.Element)

            load_balancing_rules = cls._schema_on_200_201.properties.load_balancing_rules
            load_balancing_rules.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.load_balancing_rules.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200_201.properties.load_balancing_rules.Element.properties
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
            )
            _CreateHelper._build_schema_sub_resource_read(properties.backend_address_pool)
            properties.backend_port = AAZIntType(
                serialized_name="backendPort",
            )
            properties.disable_outbound_snat = AAZBoolType(
                serialized_name="disableOutboundSnat",
            )
            properties.enable_floating_ip = AAZBoolType(
                serialized_name="enableFloatingIP",
            )
            properties.enable_tcp_reset = AAZBoolType(
                serialized_name="enableTcpReset",
            )
            properties.frontend_ip_configuration = AAZObjectType(
                serialized_name="frontendIPConfiguration",
            )
            _CreateHelper._build_schema_sub_resource_read(properties.frontend_ip_configuration)
            properties.frontend_port = AAZIntType(
                serialized_name="frontendPort",
                flags={"required": True},
            )
            properties.idle_timeout_in_minutes = AAZIntType(
                serialized_name="idleTimeoutInMinutes",
            )
            properties.load_distribution = AAZStrType(
                serialized_name="loadDistribution",
            )
            properties.probe = AAZObjectType()
            _CreateHelper._build_schema_sub_resource_read(properties.probe)
            properties.protocol = AAZStrType(
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )

            outbound_rules = cls._schema_on_200_201.properties.outbound_rules
            outbound_rules.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.outbound_rules.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200_201.properties.outbound_rules.Element.properties
            properties.allocated_outbound_ports = AAZIntType(
                serialized_name="allocatedOutboundPorts",
            )
            properties.backend_address_pool = AAZObjectType(
                serialized_name="backendAddressPool",
                flags={"required": True},
            )
            _CreateHelper._build_schema_sub_resource_read(properties.backend_address_pool)
            properties.enable_tcp_reset = AAZBoolType(
                serialized_name="enableTcpReset",
            )
            properties.frontend_ip_configurations = AAZListType(
                serialized_name="frontendIPConfigurations",
                flags={"required": True},
            )
            properties.idle_timeout_in_minutes = AAZIntType(
                serialized_name="idleTimeoutInMinutes",
            )
            properties.protocol = AAZStrType(
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )

            frontend_ip_configurations = cls._schema_on_200_201.properties.outbound_rules.Element.properties.frontend_ip_configurations
            frontend_ip_configurations.Element = AAZObjectType()
            _CreateHelper._build_schema_sub_resource_read(frontend_ip_configurations.Element)

            probes = cls._schema_on_200_201.properties.probes
            probes.Element = AAZObjectType()

            _element = cls._schema_on_200_201.properties.probes.Element
            _element.etag = AAZStrType()
            _element.id = AAZStrType()
            _element.name = AAZStrType()
            _element.properties = AAZObjectType(
                flags={"client_flatten": True},
            )

            properties = cls._schema_on_200_201.properties.probes.Element.properties
            properties.interval_in_seconds = AAZIntType(
                serialized_name="intervalInSeconds",
            )
            properties.load_balancing_rules = AAZListType(
                serialized_name="loadBalancingRules",
                flags={"read_only": True},
            )
            properties.number_of_probes = AAZIntType(
                serialized_name="numberOfProbes",
            )
            properties.port = AAZIntType(
                flags={"required": True},
            )
            properties.protocol = AAZStrType(
                flags={"required": True},
            )
            properties.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
            )
            properties.request_path = AAZStrType(
                serialized_name="requestPath",
            )

            load_balancing_rules = cls._schema_on_200_201.properties.probes.Element.properties.load_balancing_rules
            load_balancing_rules.Element = AAZObjectType()
            _CreateHelper._build_schema_sub_resource_read(load_balancing_rules.Element)

            sku = cls._schema_on_200_201.sku
            sku.name = AAZStrType()

            tags = cls._schema_on_200_201.tags
            tags.Element = AAZStrType()

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_application_security_group_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")
        _builder.set_prop("location", AAZStrType, ".location")
        _builder.set_prop("tags", AAZDictType, ".tags")

        tags = _builder.get(".tags")
        if tags is not None:
            tags.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_security_rule_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("etag", AAZStrType, ".etag")
        _builder.set_prop("name", AAZStrType, ".name")
        _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})

        properties = _builder.get(".properties")
        if properties is not None:
            properties.set_prop("access", AAZStrType, ".access", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("description", AAZStrType, ".description")
            properties.set_prop("destinationAddressPrefix", AAZStrType, ".destination_address_prefix")
            properties.set_prop("destinationAddressPrefixes", AAZListType, ".destination_address_prefixes")
            properties.set_prop("destinationApplicationSecurityGroups", AAZListType, ".destination_application_security_groups")
            properties.set_prop("destinationPortRange", AAZStrType, ".destination_port_range")
            properties.set_prop("destinationPortRanges", AAZListType, ".destination_port_ranges")
            properties.set_prop("direction", AAZStrType, ".direction", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("priority", AAZIntType, ".priority")
            properties.set_prop("protocol", AAZStrType, ".protocol", typ_kwargs={"flags": {"required": True}})
            properties.set_prop("provisioningState", AAZStrType, ".provisioning_state")
            properties.set_prop("sourceAddressPrefix", AAZStrType, ".source_address_prefix")
            properties.set_prop("sourceAddressPrefixes", AAZListType, ".source_address_prefixes")
            properties.set_prop("sourceApplicationSecurityGroups", AAZListType, ".source_application_security_groups")
            properties.set_prop("sourcePortRange", AAZStrType, ".source_port_range")
            properties.set_prop("sourcePortRanges", AAZListType, ".source_port_ranges")

        destination_address_prefixes = _builder.get(".properties.destinationAddressPrefixes")
        if destination_address_prefixes is not None:
            destination_address_prefixes.set_elements(AAZStrType, ".")

        destination_application_security_groups = _builder.get(".properties.destinationApplicationSecurityGroups")
        if destination_application_security_groups is not None:
            cls._build_schema_application_security_group_create(destination_application_security_groups.set_elements(AAZObjectType, "."))

        destination_port_ranges = _builder.get(".properties.destinationPortRanges")
        if destination_port_ranges is not None:
            destination_port_ranges.set_elements(AAZStrType, ".")

        source_address_prefixes = _builder.get(".properties.sourceAddressPrefixes")
        if source_address_prefixes is not None:
            source_address_prefixes.set_elements(AAZStrType, ".")

        source_application_security_groups = _builder.get(".properties.sourceApplicationSecurityGroups")
        if source_application_security_groups is not None:
            cls._build_schema_application_security_group_create(source_application_security_groups.set_elements(AAZObjectType, "."))

        source_port_ranges = _builder.get(".properties.sourcePortRanges")
        if source_port_ranges is not None:
            source_port_ranges.set_elements(AAZStrType, ".")

    @classmethod
    def _build_schema_sub_resource_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    _schema_application_security_group_read = None

    @classmethod
    def _build_schema_application_security_group_read(cls, _schema):
        if cls._schema_application_security_group_read is not None:
            _schema.etag = cls._schema_application_security_group_read.etag
            _schema.id = cls._schema_application_security_group_read.id
            _schema.location = cls._schema_application_security_group_read.location
            _schema.name = cls._schema_application_security_group_read.name
            _schema.properties = cls._schema_application_security_group_read.properties
            _schema.tags = cls._schema_application_security_group_read.tags
            _schema.type = cls._schema_application_security_group_read.type
            return

        cls._schema_application_security_group_read = _schema_application_security_group_read = AAZObjectType()

        application_security_group_read = _schema_application_security_group_read
        application_security_group_read.etag = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.id = AAZStrType()
        application_security_group_read.location = AAZStrType()
        application_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        application_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        application_security_group_read.tags = AAZDictType()
        application_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_application_security_group_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        tags = _schema_application_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_application_security_group_read.etag
        _schema.id = cls._schema_application_security_group_read.id
        _schema.location = cls._schema_application_security_group_read.location
        _schema.name = cls._schema_application_security_group_read.name
        _schema.properties = cls._schema_application_security_group_read.properties
        _schema.tags = cls._schema_application_security_group_read.tags
        _schema.type = cls._schema_application_security_group_read.type

    _schema_backend_address_pool_read = None

    @classmethod
    def _build_schema_backend_address_pool_read(cls, _schema):
        if cls._schema_backend_address_pool_read is not None:
            _schema.etag = cls._schema_backend_address_pool_read.etag
            _schema.id = cls._schema_backend_address_pool_read.id
            _schema.name = cls._schema_backend_address_pool_read.name
            _schema.properties = cls._schema_backend_address_pool_read.properties
            return

        cls._schema_backend_address_pool_read = _schema_backend_address_pool_read = AAZObjectType()

        backend_address_pool_read = _schema_backend_address_pool_read
        backend_address_pool_read.etag = AAZStrType()
        backend_address_pool_read.id = AAZStrType()
        backend_address_pool_read.name = AAZStrType()
        backend_address_pool_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_backend_address_pool_read.properties
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
            flags={"read_only": True},
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.outbound_rule = AAZObjectType(
            serialized_name="outboundRule",
        )
        cls._build_schema_sub_resource_read(properties.outbound_rule)
        properties.outbound_rules = AAZListType(
            serialized_name="outboundRules",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        backend_ip_configurations = _schema_backend_address_pool_read.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        load_balancing_rules = _schema_backend_address_pool_read.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        outbound_rules = _schema_backend_address_pool_read.properties.outbound_rules
        outbound_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(outbound_rules.Element)

        _schema.etag = cls._schema_backend_address_pool_read.etag
        _schema.id = cls._schema_backend_address_pool_read.id
        _schema.name = cls._schema_backend_address_pool_read.name
        _schema.properties = cls._schema_backend_address_pool_read.properties

    _schema_frontend_ip_configuration_read = None

    @classmethod
    def _build_schema_frontend_ip_configuration_read(cls, _schema):
        if cls._schema_frontend_ip_configuration_read is not None:
            _schema.etag = cls._schema_frontend_ip_configuration_read.etag
            _schema.id = cls._schema_frontend_ip_configuration_read.id
            _schema.name = cls._schema_frontend_ip_configuration_read.name
            _schema.properties = cls._schema_frontend_ip_configuration_read.properties
            _schema.zones = cls._schema_frontend_ip_configuration_read.zones
            return

        cls._schema_frontend_ip_configuration_read = _schema_frontend_ip_configuration_read = AAZObjectType()

        frontend_ip_configuration_read = _schema_frontend_ip_configuration_read
        frontend_ip_configuration_read.etag = AAZStrType()
        frontend_ip_configuration_read.id = AAZStrType()
        frontend_ip_configuration_read.name = AAZStrType()
        frontend_ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        frontend_ip_configuration_read.zones = AAZListType()

        properties = _schema_frontend_ip_configuration_read.properties
        properties.inbound_nat_pools = AAZListType(
            serialized_name="inboundNatPools",
            flags={"read_only": True},
        )
        properties.inbound_nat_rules = AAZListType(
            serialized_name="inboundNatRules",
            flags={"read_only": True},
        )
        properties.load_balancing_rules = AAZListType(
            serialized_name="loadBalancingRules",
            flags={"read_only": True},
        )
        properties.outbound_rules = AAZListType(
            serialized_name="outboundRules",
            flags={"read_only": True},
        )
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        inbound_nat_pools = _schema_frontend_ip_configuration_read.properties.inbound_nat_pools
        inbound_nat_pools.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(inbound_nat_pools.Element)

        inbound_nat_rules = _schema_frontend_ip_configuration_read.properties.inbound_nat_rules
        inbound_nat_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(inbound_nat_rules.Element)

        load_balancing_rules = _schema_frontend_ip_configuration_read.properties.load_balancing_rules
        load_balancing_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(load_balancing_rules.Element)

        outbound_rules = _schema_frontend_ip_configuration_read.properties.outbound_rules
        outbound_rules.Element = AAZObjectType()
        cls._build_schema_sub_resource_read(outbound_rules.Element)

        zones = _schema_frontend_ip_configuration_read.zones
        zones.Element = AAZStrType()

        _schema.etag = cls._schema_frontend_ip_configuration_read.etag
        _schema.id = cls._schema_frontend_ip_configuration_read.id
        _schema.name = cls._schema_frontend_ip_configuration_read.name
        _schema.properties = cls._schema_frontend_ip_configuration_read.properties
        _schema.zones = cls._schema_frontend_ip_configuration_read.zones

    _schema_ip_configuration_read = None

    @classmethod
    def _build_schema_ip_configuration_read(cls, _schema):
        if cls._schema_ip_configuration_read is not None:
            _schema.etag = cls._schema_ip_configuration_read.etag
            _schema.id = cls._schema_ip_configuration_read.id
            _schema.name = cls._schema_ip_configuration_read.name
            _schema.properties = cls._schema_ip_configuration_read.properties
            return

        cls._schema_ip_configuration_read = _schema_ip_configuration_read = AAZObjectType()

        ip_configuration_read = _schema_ip_configuration_read
        ip_configuration_read.etag = AAZStrType()
        ip_configuration_read.id = AAZStrType()
        ip_configuration_read.name = AAZStrType()
        ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_ip_configuration_read.properties
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        _schema.etag = cls._schema_ip_configuration_read.etag
        _schema.id = cls._schema_ip_configuration_read.id
        _schema.name = cls._schema_ip_configuration_read.name
        _schema.properties = cls._schema_ip_configuration_read.properties

    _schema_inbound_nat_rule_read = None

    @classmethod
    def _build_schema_inbound_nat_rule_read(cls, _schema):
        if cls._schema_inbound_nat_rule_read is not None:
            _schema.etag = cls._schema_inbound_nat_rule_read.etag
            _schema.id = cls._schema_inbound_nat_rule_read.id
            _schema.name = cls._schema_inbound_nat_rule_read.name
            _schema.properties = cls._schema_inbound_nat_rule_read.properties
            return

        cls._schema_inbound_nat_rule_read = _schema_inbound_nat_rule_read = AAZObjectType()

        inbound_nat_rule_read = _schema_inbound_nat_rule_read
        inbound_nat_rule_read.etag = AAZStrType()
        inbound_nat_rule_read.id = AAZStrType()
        inbound_nat_rule_read.name = AAZStrType()
        inbound_nat_rule_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_inbound_nat_rule_read.properties
        properties.backend_ip_configuration = AAZObjectType(
            serialized_name="backendIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.backend_ip_configuration)
        properties.backend_port = AAZIntType(
            serialized_name="backendPort",
        )
        properties.enable_floating_ip = AAZBoolType(
            serialized_name="enableFloatingIP",
        )
        properties.enable_tcp_reset = AAZBoolType(
            serialized_name="enableTcpReset",
        )
        properties.frontend_ip_configuration = AAZObjectType(
            serialized_name="frontendIPConfiguration",
        )
        cls._build_schema_sub_resource_read(properties.frontend_ip_configuration)
        properties.frontend_port = AAZIntType(
            serialized_name="frontendPort",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.protocol = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        _schema.etag = cls._schema_inbound_nat_rule_read.etag
        _schema.id = cls._schema_inbound_nat_rule_read.id
        _schema.name = cls._schema_inbound_nat_rule_read.name
        _schema.properties = cls._schema_inbound_nat_rule_read.properties

    _schema_interface_endpoint_read = None

    @classmethod
    def _build_schema_interface_endpoint_read(cls, _schema):
        if cls._schema_interface_endpoint_read is not None:
            _schema.etag = cls._schema_interface_endpoint_read.etag
            _schema.id = cls._schema_interface_endpoint_read.id
            _schema.location = cls._schema_interface_endpoint_read.location
            _schema.name = cls._schema_interface_endpoint_read.name
            _schema.properties = cls._schema_interface_endpoint_read.properties
            _schema.tags = cls._schema_interface_endpoint_read.tags
            _schema.type = cls._schema_interface_endpoint_read.type
            return

        cls._schema_interface_endpoint_read = _schema_interface_endpoint_read = AAZObjectType()

        interface_endpoint_read = _schema_interface_endpoint_read
        interface_endpoint_read.etag = AAZStrType()
        interface_endpoint_read.id = AAZStrType()
        interface_endpoint_read.location = AAZStrType()
        interface_endpoint_read.name = AAZStrType(
            flags={"read_only": True},
        )
        interface_endpoint_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        interface_endpoint_read.tags = AAZDictType()
        interface_endpoint_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_interface_endpoint_read.properties
        properties.endpoint_service = AAZObjectType(
            serialized_name="endpointService",
        )
        properties.fqdn = AAZStrType()
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.owner = AAZStrType(
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        endpoint_service = _schema_interface_endpoint_read.properties.endpoint_service
        endpoint_service.id = AAZStrType()

        network_interfaces = _schema_interface_endpoint_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()
        cls._build_schema_network_interface_read(network_interfaces.Element)

        tags = _schema_interface_endpoint_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_interface_endpoint_read.etag
        _schema.id = cls._schema_interface_endpoint_read.id
        _schema.location = cls._schema_interface_endpoint_read.location
        _schema.name = cls._schema_interface_endpoint_read.name
        _schema.properties = cls._schema_interface_endpoint_read.properties
        _schema.tags = cls._schema_interface_endpoint_read.tags
        _schema.type = cls._schema_interface_endpoint_read.type

    _schema_network_interface_ip_configuration_read = None

    @classmethod
    def _build_schema_network_interface_ip_configuration_read(cls, _schema):
        if cls._schema_network_interface_ip_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
            _schema.id = cls._schema_network_interface_ip_configuration_read.id
            _schema.name = cls._schema_network_interface_ip_configuration_read.name
            _schema.properties = cls._schema_network_interface_ip_configuration_read.properties
            return

        cls._schema_network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read = AAZObjectType()

        network_interface_ip_configuration_read = _schema_network_interface_ip_configuration_read
        network_interface_ip_configuration_read.etag = AAZStrType()
        network_interface_ip_configuration_read.id = AAZStrType()
        network_interface_ip_configuration_read.name = AAZStrType()
        network_interface_ip_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_network_interface_ip_configuration_read.properties
        properties.application_gateway_backend_address_pools = AAZListType(
            serialized_name="applicationGatewayBackendAddressPools",
        )
        properties.application_security_groups = AAZListType(
            serialized_name="applicationSecurityGroups",
        )
        properties.load_balancer_backend_address_pools = AAZListType(
            serialized_name="loadBalancerBackendAddressPools",
        )
        properties.load_balancer_inbound_nat_rules = AAZListType(
            serialized_name="loadBalancerInboundNatRules",
        )
        properties.primary = AAZBoolType()
        properties.private_ip_address = AAZStrType(
            serialized_name="privateIPAddress",
        )
        properties.private_ip_address_version = AAZStrType(
            serialized_name="privateIPAddressVersion",
        )
        properties.private_ip_allocation_method = AAZStrType(
            serialized_name="privateIPAllocationMethod",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address = AAZObjectType(
            serialized_name="publicIPAddress",
        )
        cls._build_schema_public_ip_address_read(properties.public_ip_address)
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)
        properties.virtual_network_taps = AAZListType(
            serialized_name="virtualNetworkTaps",
        )

        application_gateway_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools
        application_gateway_backend_address_pools.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType()

        properties = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties
        properties.backend_addresses = AAZListType(
            serialized_name="backendAddresses",
        )
        properties.backend_ip_configurations = AAZListType(
            serialized_name="backendIPConfigurations",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        backend_addresses = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses
        backend_addresses.Element = AAZObjectType()

        _element = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_addresses.Element
        _element.fqdn = AAZStrType()
        _element.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )

        backend_ip_configurations = _schema_network_interface_ip_configuration_read.properties.application_gateway_backend_address_pools.Element.properties.backend_ip_configurations
        backend_ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(backend_ip_configurations.Element)

        application_security_groups = _schema_network_interface_ip_configuration_read.properties.application_security_groups
        application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(application_security_groups.Element)

        load_balancer_backend_address_pools = _schema_network_interface_ip_configuration_read.properties.load_balancer_backend_address_pools
        load_balancer_backend_address_pools.Element = AAZObjectType()
        cls._build_schema_backend_address_pool_read(load_balancer_backend_address_pools.Element)

        load_balancer_inbound_nat_rules = _schema_network_interface_ip_configuration_read.properties.load_balancer_inbound_nat_rules
        load_balancer_inbound_nat_rules.Element = AAZObjectType()
        cls._build_schema_inbound_nat_rule_read(load_balancer_inbound_nat_rules.Element)

        virtual_network_taps = _schema_network_interface_ip_configuration_read.properties.virtual_network_taps
        virtual_network_taps.Element = AAZObjectType()
        cls._build_schema_virtual_network_tap_read(virtual_network_taps.Element)

        _schema.etag = cls._schema_network_interface_ip_configuration_read.etag
        _schema.id = cls._schema_network_interface_ip_configuration_read.id
        _schema.name = cls._schema_network_interface_ip_configuration_read.name
        _schema.properties = cls._schema_network_interface_ip_configuration_read.properties

    _schema_network_interface_tap_configuration_read = None

    @classmethod
    def _build_schema_network_interface_tap_configuration_read(cls, _schema):
        if cls._schema_network_interface_tap_configuration_read is not None:
            _schema.etag = cls._schema_network_interface_tap_configuration_read.etag
            _schema.id = cls._schema_network_interface_tap_configuration_read.id
            _schema.name = cls._schema_network_interface_tap_configuration_read.name
            _schema.properties = cls._schema_network_interface_tap_configuration_read.properties
            _schema.type = cls._schema_network_interface_tap_configuration_read.type
            return

        cls._schema_network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read = AAZObjectType()

        network_interface_tap_configuration_read = _schema_network_interface_tap_configuration_read
        network_interface_tap_configuration_read.etag = AAZStrType()
        network_interface_tap_configuration_read.id = AAZStrType()
        network_interface_tap_configuration_read.name = AAZStrType()
        network_interface_tap_configuration_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_interface_tap_configuration_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_tap_configuration_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.virtual_network_tap = AAZObjectType(
            serialized_name="virtualNetworkTap",
        )
        cls._build_schema_virtual_network_tap_read(properties.virtual_network_tap)

        _schema.etag = cls._schema_network_interface_tap_configuration_read.etag
        _schema.id = cls._schema_network_interface_tap_configuration_read.id
        _schema.name = cls._schema_network_interface_tap_configuration_read.name
        _schema.properties = cls._schema_network_interface_tap_configuration_read.properties
        _schema.type = cls._schema_network_interface_tap_configuration_read.type

    _schema_network_interface_read = None

    @classmethod
    def _build_schema_network_interface_read(cls, _schema):
        if cls._schema_network_interface_read is not None:
            _schema.etag = cls._schema_network_interface_read.etag
            _schema.id = cls._schema_network_interface_read.id
            _schema.location = cls._schema_network_interface_read.location
            _schema.name = cls._schema_network_interface_read.name
            _schema.properties = cls._schema_network_interface_read.properties
            _schema.tags = cls._schema_network_interface_read.tags
            _schema.type = cls._schema_network_interface_read.type
            return

        cls._schema_network_interface_read = _schema_network_interface_read = AAZObjectType()

        network_interface_read = _schema_network_interface_read
        network_interface_read.etag = AAZStrType()
        network_interface_read.id = AAZStrType()
        network_interface_read.location = AAZStrType()
        network_interface_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_interface_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_interface_read.tags = AAZDictType()
        network_interface_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_interface_read.properties
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.enable_accelerated_networking = AAZBoolType(
            serialized_name="enableAcceleratedNetworking",
        )
        properties.enable_ip_forwarding = AAZBoolType(
            serialized_name="enableIPForwarding",
        )
        properties.hosted_workloads = AAZListType(
            serialized_name="hostedWorkloads",
            flags={"read_only": True},
        )
        properties.interface_endpoint = AAZObjectType(
            serialized_name="interfaceEndpoint",
        )
        cls._build_schema_interface_endpoint_read(properties.interface_endpoint)
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
        )
        properties.mac_address = AAZStrType(
            serialized_name="macAddress",
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.primary = AAZBoolType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.tap_configurations = AAZListType(
            serialized_name="tapConfigurations",
        )
        properties.virtual_machine = AAZObjectType(
            serialized_name="virtualMachine",
        )
        cls._build_schema_sub_resource_read(properties.virtual_machine)

        dns_settings = _schema_network_interface_read.properties.dns_settings
        dns_settings.applied_dns_servers = AAZListType(
            serialized_name="appliedDnsServers",
        )
        dns_settings.dns_servers = AAZListType(
            serialized_name="dnsServers",
        )
        dns_settings.internal_dns_name_label = AAZStrType(
            serialized_name="internalDnsNameLabel",
        )
        dns_settings.internal_domain_name_suffix = AAZStrType(
            serialized_name="internalDomainNameSuffix",
        )
        dns_settings.internal_fqdn = AAZStrType(
            serialized_name="internalFqdn",
        )

        applied_dns_servers = _schema_network_interface_read.properties.dns_settings.applied_dns_servers
        applied_dns_servers.Element = AAZStrType()

        dns_servers = _schema_network_interface_read.properties.dns_settings.dns_servers
        dns_servers.Element = AAZStrType()

        hosted_workloads = _schema_network_interface_read.properties.hosted_workloads
        hosted_workloads.Element = AAZStrType()

        ip_configurations = _schema_network_interface_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_ip_configuration_read(ip_configurations.Element)

        tap_configurations = _schema_network_interface_read.properties.tap_configurations
        tap_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_tap_configuration_read(tap_configurations.Element)

        tags = _schema_network_interface_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_interface_read.etag
        _schema.id = cls._schema_network_interface_read.id
        _schema.location = cls._schema_network_interface_read.location
        _schema.name = cls._schema_network_interface_read.name
        _schema.properties = cls._schema_network_interface_read.properties
        _schema.tags = cls._schema_network_interface_read.tags
        _schema.type = cls._schema_network_interface_read.type

    _schema_network_security_group_read = None

    @classmethod
    def _build_schema_network_security_group_read(cls, _schema):
        if cls._schema_network_security_group_read is not None:
            _schema.etag = cls._schema_network_security_group_read.etag
            _schema.id = cls._schema_network_security_group_read.id
            _schema.location = cls._schema_network_security_group_read.location
            _schema.name = cls._schema_network_security_group_read.name
            _schema.properties = cls._schema_network_security_group_read.properties
            _schema.tags = cls._schema_network_security_group_read.tags
            _schema.type = cls._schema_network_security_group_read.type
            return

        cls._schema_network_security_group_read = _schema_network_security_group_read = AAZObjectType()

        network_security_group_read = _schema_network_security_group_read
        network_security_group_read.etag = AAZStrType()
        network_security_group_read.id = AAZStrType()
        network_security_group_read.location = AAZStrType()
        network_security_group_read.name = AAZStrType(
            flags={"read_only": True},
        )
        network_security_group_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        network_security_group_read.tags = AAZDictType()
        network_security_group_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_network_security_group_read.properties
        properties.default_security_rules = AAZListType(
            serialized_name="defaultSecurityRules",
        )
        properties.network_interfaces = AAZListType(
            serialized_name="networkInterfaces",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )
        properties.security_rules = AAZListType(
            serialized_name="securityRules",
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        default_security_rules = _schema_network_security_group_read.properties.default_security_rules
        default_security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(default_security_rules.Element)

        network_interfaces = _schema_network_security_group_read.properties.network_interfaces
        network_interfaces.Element = AAZObjectType()
        cls._build_schema_network_interface_read(network_interfaces.Element)

        security_rules = _schema_network_security_group_read.properties.security_rules
        security_rules.Element = AAZObjectType()
        cls._build_schema_security_rule_read(security_rules.Element)

        subnets = _schema_network_security_group_read.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_network_security_group_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_network_security_group_read.etag
        _schema.id = cls._schema_network_security_group_read.id
        _schema.location = cls._schema_network_security_group_read.location
        _schema.name = cls._schema_network_security_group_read.name
        _schema.properties = cls._schema_network_security_group_read.properties
        _schema.tags = cls._schema_network_security_group_read.tags
        _schema.type = cls._schema_network_security_group_read.type

    _schema_public_ip_address_read = None

    @classmethod
    def _build_schema_public_ip_address_read(cls, _schema):
        if cls._schema_public_ip_address_read is not None:
            _schema.etag = cls._schema_public_ip_address_read.etag
            _schema.id = cls._schema_public_ip_address_read.id
            _schema.location = cls._schema_public_ip_address_read.location
            _schema.name = cls._schema_public_ip_address_read.name
            _schema.properties = cls._schema_public_ip_address_read.properties
            _schema.sku = cls._schema_public_ip_address_read.sku
            _schema.tags = cls._schema_public_ip_address_read.tags
            _schema.type = cls._schema_public_ip_address_read.type
            _schema.zones = cls._schema_public_ip_address_read.zones
            return

        cls._schema_public_ip_address_read = _schema_public_ip_address_read = AAZObjectType()

        public_ip_address_read = _schema_public_ip_address_read
        public_ip_address_read.etag = AAZStrType()
        public_ip_address_read.id = AAZStrType()
        public_ip_address_read.location = AAZStrType()
        public_ip_address_read.name = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        public_ip_address_read.sku = AAZObjectType()
        public_ip_address_read.tags = AAZDictType()
        public_ip_address_read.type = AAZStrType(
            flags={"read_only": True},
        )
        public_ip_address_read.zones = AAZListType()

        properties = _schema_public_ip_address_read.properties
        properties.ddos_settings = AAZObjectType(
            serialized_name="ddosSettings",
        )
        properties.dns_settings = AAZObjectType(
            serialized_name="dnsSettings",
        )
        properties.idle_timeout_in_minutes = AAZIntType(
            serialized_name="idleTimeoutInMinutes",
        )
        properties.ip_address = AAZStrType(
            serialized_name="ipAddress",
        )
        properties.ip_configuration = AAZObjectType(
            serialized_name="ipConfiguration",
        )
        cls._build_schema_ip_configuration_read(properties.ip_configuration)
        properties.ip_tags = AAZListType(
            serialized_name="ipTags",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.public_ip_address_version = AAZStrType(
            serialized_name="publicIPAddressVersion",
        )
        properties.public_ip_allocation_method = AAZStrType(
            serialized_name="publicIPAllocationMethod",
        )
        properties.public_ip_prefix = AAZObjectType(
            serialized_name="publicIPPrefix",
        )
        cls._build_schema_sub_resource_read(properties.public_ip_prefix)
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
        )

        ddos_settings = _schema_public_ip_address_read.properties.ddos_settings
        ddos_settings.ddos_custom_policy = AAZObjectType(
            serialized_name="ddosCustomPolicy",
        )
        cls._build_schema_sub_resource_read(ddos_settings.ddos_custom_policy)
        ddos_settings.protection_coverage = AAZStrType(
            serialized_name="protectionCoverage",
        )

        dns_settings = _schema_public_ip_address_read.properties.dns_settings
        dns_settings.domain_name_label = AAZStrType(
            serialized_name="domainNameLabel",
        )
        dns_settings.fqdn = AAZStrType()
        dns_settings.reverse_fqdn = AAZStrType(
            serialized_name="reverseFqdn",
        )

        ip_tags = _schema_public_ip_address_read.properties.ip_tags
        ip_tags.Element = AAZObjectType()

        _element = _schema_public_ip_address_read.properties.ip_tags.Element
        _element.ip_tag_type = AAZStrType(
            serialized_name="ipTagType",
        )
        _element.tag = AAZStrType()

        sku = _schema_public_ip_address_read.sku
        sku.name = AAZStrType()

        tags = _schema_public_ip_address_read.tags
        tags.Element = AAZStrType()

        zones = _schema_public_ip_address_read.zones
        zones.Element = AAZStrType()

        _schema.etag = cls._schema_public_ip_address_read.etag
        _schema.id = cls._schema_public_ip_address_read.id
        _schema.location = cls._schema_public_ip_address_read.location
        _schema.name = cls._schema_public_ip_address_read.name
        _schema.properties = cls._schema_public_ip_address_read.properties
        _schema.sku = cls._schema_public_ip_address_read.sku
        _schema.tags = cls._schema_public_ip_address_read.tags
        _schema.type = cls._schema_public_ip_address_read.type
        _schema.zones = cls._schema_public_ip_address_read.zones

    _schema_security_rule_read = None

    @classmethod
    def _build_schema_security_rule_read(cls, _schema):
        if cls._schema_security_rule_read is not None:
            _schema.etag = cls._schema_security_rule_read.etag
            _schema.id = cls._schema_security_rule_read.id
            _schema.name = cls._schema_security_rule_read.name
            _schema.properties = cls._schema_security_rule_read.properties
            return

        cls._schema_security_rule_read = _schema_security_rule_read = AAZObjectType()

        security_rule_read = _schema_security_rule_read
        security_rule_read.etag = AAZStrType()
        security_rule_read.id = AAZStrType()
        security_rule_read.name = AAZStrType()
        security_rule_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_security_rule_read.properties
        properties.access = AAZStrType(
            flags={"required": True},
        )
        properties.description = AAZStrType()
        properties.destination_address_prefix = AAZStrType(
            serialized_name="destinationAddressPrefix",
        )
        properties.destination_address_prefixes = AAZListType(
            serialized_name="destinationAddressPrefixes",
        )
        properties.destination_application_security_groups = AAZListType(
            serialized_name="destinationApplicationSecurityGroups",
        )
        properties.destination_port_range = AAZStrType(
            serialized_name="destinationPortRange",
        )
        properties.destination_port_ranges = AAZListType(
            serialized_name="destinationPortRanges",
        )
        properties.direction = AAZStrType(
            flags={"required": True},
        )
        properties.priority = AAZIntType()
        properties.protocol = AAZStrType(
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.source_address_prefix = AAZStrType(
            serialized_name="sourceAddressPrefix",
        )
        properties.source_address_prefixes = AAZListType(
            serialized_name="sourceAddressPrefixes",
        )
        properties.source_application_security_groups = AAZListType(
            serialized_name="sourceApplicationSecurityGroups",
        )
        properties.source_port_range = AAZStrType(
            serialized_name="sourcePortRange",
        )
        properties.source_port_ranges = AAZListType(
            serialized_name="sourcePortRanges",
        )

        destination_address_prefixes = _schema_security_rule_read.properties.destination_address_prefixes
        destination_address_prefixes.Element = AAZStrType()

        destination_application_security_groups = _schema_security_rule_read.properties.destination_application_security_groups
        destination_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(destination_application_security_groups.Element)

        destination_port_ranges = _schema_security_rule_read.properties.destination_port_ranges
        destination_port_ranges.Element = AAZStrType()

        source_address_prefixes = _schema_security_rule_read.properties.source_address_prefixes
        source_address_prefixes.Element = AAZStrType()

        source_application_security_groups = _schema_security_rule_read.properties.source_application_security_groups
        source_application_security_groups.Element = AAZObjectType()
        cls._build_schema_application_security_group_read(source_application_security_groups.Element)

        source_port_ranges = _schema_security_rule_read.properties.source_port_ranges
        source_port_ranges.Element = AAZStrType()

        _schema.etag = cls._schema_security_rule_read.etag
        _schema.id = cls._schema_security_rule_read.id
        _schema.name = cls._schema_security_rule_read.name
        _schema.properties = cls._schema_security_rule_read.properties

    _schema_sub_resource_read = None

    @classmethod
    def _build_schema_sub_resource_read(cls, _schema):
        if cls._schema_sub_resource_read is not None:
            _schema.id = cls._schema_sub_resource_read.id
            return

        cls._schema_sub_resource_read = _schema_sub_resource_read = AAZObjectType()

        sub_resource_read = _schema_sub_resource_read
        sub_resource_read.id = AAZStrType()

        _schema.id = cls._schema_sub_resource_read.id

    _schema_subnet_read = None

    @classmethod
    def _build_schema_subnet_read(cls, _schema):
        if cls._schema_subnet_read is not None:
            _schema.etag = cls._schema_subnet_read.etag
            _schema.id = cls._schema_subnet_read.id
            _schema.name = cls._schema_subnet_read.name
            _schema.properties = cls._schema_subnet_read.properties
            return

        cls._schema_subnet_read = _schema_subnet_read = AAZObjectType()

        subnet_read = _schema_subnet_read
        subnet_read.etag = AAZStrType()
        subnet_read.id = AAZStrType()
        subnet_read.name = AAZStrType()
        subnet_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.address_prefixes = AAZListType(
            serialized_name="addressPrefixes",
        )
        properties.delegations = AAZListType()
        properties.interface_endpoints = AAZListType(
            serialized_name="interfaceEndpoints",
            flags={"read_only": True},
        )
        properties.ip_configuration_profiles = AAZListType(
            serialized_name="ipConfigurationProfiles",
            flags={"read_only": True},
        )
        properties.ip_configurations = AAZListType(
            serialized_name="ipConfigurations",
            flags={"read_only": True},
        )
        properties.network_security_group = AAZObjectType(
            serialized_name="networkSecurityGroup",
        )
        cls._build_schema_network_security_group_read(properties.network_security_group)
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.purpose = AAZStrType(
            flags={"read_only": True},
        )
        properties.resource_navigation_links = AAZListType(
            serialized_name="resourceNavigationLinks",
        )
        properties.route_table = AAZObjectType(
            serialized_name="routeTable",
        )
        properties.service_association_links = AAZListType(
            serialized_name="serviceAssociationLinks",
        )
        properties.service_endpoint_policies = AAZListType(
            serialized_name="serviceEndpointPolicies",
        )
        properties.service_endpoints = AAZListType(
            serialized_name="serviceEndpoints",
        )

        address_prefixes = _schema_subnet_read.properties.address_prefixes
        address_prefixes.Element = AAZStrType()

        delegations = _schema_subnet_read.properties.delegations
        delegations.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.delegations.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.delegations.Element.properties
        properties.actions = AAZListType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.service_name = AAZStrType(
            serialized_name="serviceName",
        )

        actions = _schema_subnet_read.properties.delegations.Element.properties.actions
        actions.Element = AAZStrType()

        interface_endpoints = _schema_subnet_read.properties.interface_endpoints
        interface_endpoints.Element = AAZObjectType()
        cls._build_schema_interface_endpoint_read(interface_endpoints.Element)

        ip_configuration_profiles = _schema_subnet_read.properties.ip_configuration_profiles
        ip_configuration_profiles.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.ip_configuration_profiles.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.ip_configuration_profiles.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.subnet = AAZObjectType()
        cls._build_schema_subnet_read(properties.subnet)

        ip_configurations = _schema_subnet_read.properties.ip_configurations
        ip_configurations.Element = AAZObjectType()
        cls._build_schema_ip_configuration_read(ip_configurations.Element)

        resource_navigation_links = _schema_subnet_read.properties.resource_navigation_links
        resource_navigation_links.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.resource_navigation_links.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.resource_navigation_links.Element.properties
        properties.link = AAZStrType()
        properties.linked_resource_type = AAZStrType(
            serialized_name="linkedResourceType",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        route_table = _schema_subnet_read.properties.route_table
        route_table.etag = AAZStrType()
        route_table.id = AAZStrType()
        route_table.location = AAZStrType()
        route_table.name = AAZStrType(
            flags={"read_only": True},
        )
        route_table.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        route_table.tags = AAZDictType()
        route_table.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties
        properties.disable_bgp_route_propagation = AAZBoolType(
            serialized_name="disableBgpRoutePropagation",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        properties.routes = AAZListType()
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        routes = _schema_subnet_read.properties.route_table.properties.routes
        routes.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.route_table.properties.routes.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.route_table.properties.routes.Element.properties
        properties.address_prefix = AAZStrType(
            serialized_name="addressPrefix",
        )
        properties.next_hop_ip_address = AAZStrType(
            serialized_name="nextHopIpAddress",
        )
        properties.next_hop_type = AAZStrType(
            serialized_name="nextHopType",
            flags={"required": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )

        subnets = _schema_subnet_read.properties.route_table.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.route_table.tags
        tags.Element = AAZStrType()

        service_association_links = _schema_subnet_read.properties.service_association_links
        service_association_links.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_association_links.Element
        _element.etag = AAZStrType(
            flags={"read_only": True},
        )
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.service_association_links.Element.properties
        properties.link = AAZStrType()
        properties.linked_resource_type = AAZStrType(
            serialized_name="linkedResourceType",
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )

        service_endpoint_policies = _schema_subnet_read.properties.service_endpoint_policies
        service_endpoint_policies.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoint_policies.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.location = AAZStrType()
        _element.name = AAZStrType(
            flags={"read_only": True},
        )
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        _element.tags = AAZDictType()
        _element.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )
        properties.service_endpoint_policy_definitions = AAZListType(
            serialized_name="serviceEndpointPolicyDefinitions",
        )
        properties.subnets = AAZListType(
            flags={"read_only": True},
        )

        service_endpoint_policy_definitions = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions
        service_endpoint_policy_definitions.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element
        _element.etag = AAZStrType()
        _element.id = AAZStrType()
        _element.name = AAZStrType()
        _element.properties = AAZObjectType(
            flags={"client_flatten": True},
        )

        properties = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties
        properties.description = AAZStrType()
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.service = AAZStrType()
        properties.service_resources = AAZListType(
            serialized_name="serviceResources",
        )

        service_resources = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.service_endpoint_policy_definitions.Element.properties.service_resources
        service_resources.Element = AAZStrType()

        subnets = _schema_subnet_read.properties.service_endpoint_policies.Element.properties.subnets
        subnets.Element = AAZObjectType()
        cls._build_schema_subnet_read(subnets.Element)

        tags = _schema_subnet_read.properties.service_endpoint_policies.Element.tags
        tags.Element = AAZStrType()

        service_endpoints = _schema_subnet_read.properties.service_endpoints
        service_endpoints.Element = AAZObjectType()

        _element = _schema_subnet_read.properties.service_endpoints.Element
        _element.locations = AAZListType()
        _element.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
        )
        _element.service = AAZStrType()

        locations = _schema_subnet_read.properties.service_endpoints.Element.locations
        locations.Element = AAZStrType()

        _schema.etag = cls._schema_subnet_read.etag
        _schema.id = cls._schema_subnet_read.id
        _schema.name = cls._schema_subnet_read.name
        _schema.properties = cls._schema_subnet_read.properties

    _schema_virtual_network_tap_read = None

    @classmethod
    def _build_schema_virtual_network_tap_read(cls, _schema):
        if cls._schema_virtual_network_tap_read is not None:
            _schema.etag = cls._schema_virtual_network_tap_read.etag
            _schema.id = cls._schema_virtual_network_tap_read.id
            _schema.location = cls._schema_virtual_network_tap_read.location
            _schema.name = cls._schema_virtual_network_tap_read.name
            _schema.properties = cls._schema_virtual_network_tap_read.properties
            _schema.tags = cls._schema_virtual_network_tap_read.tags
            _schema.type = cls._schema_virtual_network_tap_read.type
            return

        cls._schema_virtual_network_tap_read = _schema_virtual_network_tap_read = AAZObjectType()

        virtual_network_tap_read = _schema_virtual_network_tap_read
        virtual_network_tap_read.etag = AAZStrType()
        virtual_network_tap_read.id = AAZStrType()
        virtual_network_tap_read.location = AAZStrType()
        virtual_network_tap_read.name = AAZStrType(
            flags={"read_only": True},
        )
        virtual_network_tap_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        virtual_network_tap_read.tags = AAZDictType()
        virtual_network_tap_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_virtual_network_tap_read.properties
        properties.destination_load_balancer_front_end_ip_configuration = AAZObjectType(
            serialized_name="destinationLoadBalancerFrontEndIPConfiguration",
        )
        cls._build_schema_frontend_ip_configuration_read(properties.destination_load_balancer_front_end_ip_configuration)
        properties.destination_network_interface_ip_configuration = AAZObjectType(
            serialized_name="destinationNetworkInterfaceIPConfiguration",
        )
        cls._build_schema_network_interface_ip_configuration_read(properties.destination_network_interface_ip_configuration)
        properties.destination_port = AAZIntType(
            serialized_name="destinationPort",
        )
        properties.network_interface_tap_configurations = AAZListType(
            serialized_name="networkInterfaceTapConfigurations",
            flags={"read_only": True},
        )
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.resource_guid = AAZStrType(
            serialized_name="resourceGuid",
            flags={"read_only": True},
        )

        network_interface_tap_configurations = _schema_virtual_network_tap_read.properties.network_interface_tap_configurations
        network_interface_tap_configurations.Element = AAZObjectType()
        cls._build_schema_network_interface_tap_configuration_read(network_interface_tap_configurations.Element)

        tags = _schema_virtual_network_tap_read.tags
        tags.Element = AAZStrType()

        _schema.etag = cls._schema_virtual_network_tap_read.etag
        _schema.id = cls._schema_virtual_network_tap_read.id
        _schema.location = cls._schema_virtual_network_tap_read.location
        _schema.name = cls._schema_virtual_network_tap_read.name
        _schema.properties = cls._schema_virtual_network_tap_read.properties
        _schema.tags = cls._schema_virtual_network_tap_read.tags
        _schema.type = cls._schema_virtual_network_tap_read.type


__all__ = ["Create"]
