/*
 * Decompiled with CFR 0.152.
 */
package cz.startnet.utils.pgdiff.parsers;

import cz.startnet.utils.pgdiff.parsers.Parser;
import cz.startnet.utils.pgdiff.parsers.ParserUtils;
import cz.startnet.utils.pgdiff.schema.PgDatabase;
import cz.startnet.utils.pgdiff.schema.PgSchema;
import cz.startnet.utils.pgdiff.schema.PgTrigger;

public class CreateTriggerParser {
    public static void parse(PgDatabase pgDatabase, String string, boolean bl) {
        boolean bl2;
        Parser parser = new Parser(string);
        parser.expect("CREATE", "TRIGGER");
        String string2 = parser.parseIdentifier();
        String string3 = ParserUtils.getObjectName(string2);
        PgTrigger pgTrigger = new PgTrigger();
        pgTrigger.setName(string3);
        if (parser.expectOptional("BEFORE")) {
            pgTrigger.setEventTimeQualification(PgTrigger.EventTimeQualification.before);
        } else if (parser.expectOptional("AFTER")) {
            pgTrigger.setEventTimeQualification(PgTrigger.EventTimeQualification.after);
        } else if (parser.expectOptional("INSTEAD OF")) {
            pgTrigger.setEventTimeQualification(PgTrigger.EventTimeQualification.instead_of);
        }
        boolean bl3 = true;
        while (bl3 || parser.expectOptional("OR")) {
            if (parser.expectOptional("INSERT")) {
                pgTrigger.setOnInsert(true);
            } else if (parser.expectOptional("UPDATE")) {
                pgTrigger.setOnUpdate(true);
                if (parser.expectOptional("OF")) {
                    do {
                        pgTrigger.addUpdateColumn(parser.parseIdentifier());
                    } while (parser.expectOptional(","));
                }
            } else if (parser.expectOptional("DELETE")) {
                pgTrigger.setOnDelete(true);
            } else if (parser.expectOptional("TRUNCATE")) {
                pgTrigger.setOnTruncate(true);
            } else {
                if (bl3) break;
                parser.throwUnsupportedCommand();
            }
            bl3 = false;
        }
        parser.expect("ON");
        String string4 = parser.parseIdentifier();
        pgTrigger.setRelationName(ParserUtils.getObjectName(string4));
        String string5 = "REFERENCING";
        if (parser.expectOptional(string5)) {
            String string6;
            pgTrigger.setReferencing("\t" + string5);
            while ((string6 = parser.getSubString(parser.getPosition(), parser.getPosition() + 3)).equals("OLD") || string6.equals("NEW")) {
                CreateTriggerParser.parseReferencing(parser, pgTrigger);
            }
        }
        if (parser.expectOptional("FOR")) {
            parser.expectOptional("EACH");
            if (parser.expectOptional("ROW")) {
                pgTrigger.setForEachRow(true);
            } else if (parser.expectOptional("STATEMENT")) {
                pgTrigger.setForEachRow(false);
            } else {
                parser.throwUnsupportedCommand();
            }
        }
        if (parser.expectOptional("WHEN")) {
            parser.expect("(");
            pgTrigger.setWhen(parser.getExpression());
            parser.expect(")");
        }
        parser.expect("EXECUTE");
        if (!parser.expectOptional("PROCEDURE") && !parser.expectOptional("FUNCTION")) {
            parser.throwUnsupportedCommand();
        }
        pgTrigger.setFunction(parser.getRest());
        boolean bl4 = bl2 = bl && ("_slony_logtrigger".equals(pgTrigger.getName()) || "_slony_denyaccess".equals(pgTrigger.getName()));
        if (!bl2) {
            PgSchema pgSchema = pgDatabase.getSchema(ParserUtils.getSchemaName(string4, pgDatabase));
            pgSchema.getRelation(pgTrigger.getRelationName()).addTrigger(pgTrigger);
        }
    }

    private CreateTriggerParser() {
    }

    private static void parseReferencing(Parser parser, PgTrigger pgTrigger) {
        if (parser.expectOptional("NEW")) {
            pgTrigger.setReferencing(pgTrigger.getReferencing() + " NEW ");
        }
        if (parser.expectOptional("OLD")) {
            pgTrigger.setReferencing(pgTrigger.getReferencing() + " OLD ");
        }
        parser.expect("TABLE");
        parser.expect("AS");
        pgTrigger.setReferencing(pgTrigger.getReferencing() + "TABLE AS " + parser.parseString());
    }

    public static void parseDisable(PgDatabase pgDatabase, String string) {
        Parser parser = new Parser(string);
        parser.expect("ALTER", "TABLE");
        String string2 = parser.parseIdentifier();
        parser.expect("DISABLE", "TRIGGER");
        String string3 = parser.parseIdentifier();
        PgTrigger pgTrigger = new PgTrigger();
        pgTrigger.setName(string3);
        pgTrigger.setRelationName(ParserUtils.getObjectName(string2));
        PgSchema pgSchema = pgDatabase.getSchema(ParserUtils.getSchemaName(string2, pgDatabase));
        pgSchema.getRelation(pgTrigger.getRelationName()).getTrigger(string3).setDisable(true);
    }
}

