/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 *
 */
package org.apache.directory.api.dsmlv2;

/**
 * This Class contains DMSL literals
 *
 * @author <a href="mailto:dev@directory.apache.org">Apache Directory Project</a>
 */
public final class DsmlLiterals
{
    /** Some literal */
    public static final String ABANDON_ID = "abandonID";
    public static final String ABANDON_REQUEST = "abandonRequest";
    public static final String ADD = "add";
    public static final String ADD_REQUEST = "addRequest";
    public static final String ADD_RESPONSE = "addResponse";
    public static final String AND = "and";
    public static final String ANY = "any";
    public static final String APPROX_MATCH = "approxMatch";
    public static final String ASSERTION = "assertion";
    public static final String ATTR = "attr";
    public static final String ATTRIBUTE = "attribute";
    public static final String ATTRIBUTES = "attributes";
    public static final String AUTH_REQUEST = "authRequest";
    public static final String AUTH_RESPONSE = "authResponse";
    public static final String BASE_OBJECT = "baseObject";
    public static final String BATCH_REQUEST = "batchRequest";
    public static final String BATCH_RESPONSE = "batchResponse";
    public static final String BODY = "body";
    public static final String CODE = "code";
    public static final String COMPARE_REQUEST = "compareRequest";
    public static final String COMPARE_RESPONSE = "compareResponse";
    public static final String CONTROL = "control";
    public static final String CONTROL_VALUE = "controlValue";
    public static final String CRITICALITY = "criticality";
    public static final String DEL_REQUEST = "delRequest";
    public static final String DEL_RESPONSE = "delResponse";
    public static final String DELETE = "delete";
    public static final String DELETE_OLD_RDN = "deleteoldrdn";
    public static final String DEREF_ALIASES = "derefAliases";
    public static final String DEREF_ALWAYS = "derefAlways";
    public static final String DEREF_FINDING_BASE_OBJ = "derefFindingBaseObj";
    public static final String DEREF_IN_SEARCHING = "derefInSearching";
    public static final String DESCR = "descr";
    public static final String DETAIL = "detail";
    public static final String DN = "dn";
    public static final String DN_ATTRIBUTES = "dnAttributes";
    public static final String ENVELOPE = "envelope";
    public static final String EQUALITY_MATCH = "equalityMatch";
    public static final String ERROR = "error";
    public static final String ERROR_MESSAGE = "errorMessage";
    public static final String ERROR_RESPONSE = "errorResponse";
    public static final String EXIT = "exit";
    public static final String EXTENDED_REQUEST = "extendedRequest";
    public static final String EXTENDED_RESPONSE = "extendedResponse";
    public static final String EXTENSIBLE_MATCH = "extensibleMatch";
    public static final String FALSE = "false";
    public static final String FILTER = "filter";
    public static final String FINAL = "final";
    public static final String GREATER_OR_EQUAL = "greaterOrEqual";
    public static final String HEADER = "header";
    public static final String INCREMENT = "increment";
    public static final String INITIAL = "initial";
    public static final String LESS_OR_EQUAL = "lessOrEqual";
    public static final String MATCHED_DN = "matchedDN";
    public static final String MATCHING_RULE = "matchingRule";
    public static final String MESSAGE = "message";
    public static final String MOD_DN_REQUEST = "modDNRequest";
    public static final String MOD_DN_RESPONSE = "modDNResponse";
    public static final String MODIFICATION = "modification";
    public static final String MODIFY_REQUEST = "modifyRequest";
    public static final String MODIFY_RESPONSE = "modifyResponse";
    public static final String NAME = "name";
    public static final String NEVER_DEREF_ALIASES = "neverDerefAliases";
    public static final String NEW_RDN = "newrdn";
    public static final String NEW_SUPERIOR = "newSuperior";
    public static final String NOT = "not";
    public static final String ON_ERROR = "onError";
    public static final String OPERATION = "operation";
    public static final String OR = "or";
    public static final String PARALLEL = "parallel";
    public static final String PRESENT = "present";
    public static final String PRINCIPAL = "principal";
    public static final String PROCESSING = "processing";
    public static final String REF = "ref";
    public static final String REFERRAL = "referral";
    public static final String REPLACE = "replace";
    public static final String REQUEST_ID = "requestID";
    public static final String REQUEST_NAME = "requestName";
    public static final String REQUEST_VALUE = "requestValue";
    public static final String RESPONSE = "response";
    public static final String RESPONSE_NAME = "responseName";
    public static final String RESPONSE_ORDER = "responseOrder";
    public static final String RESULT_CODE = "resultCode";
    public static final String RESUME = "resume";
    public static final String SCOPE = "scope";
    public static final String SEARCH_REQUEST = "searchRequest";
    public static final String SEARCH_RESPONSE = "searchResponse";
    public static final String SEARCH_RESULT_DONE = "searchResultDone";
    public static final String SEARCH_RESULT_ENTRY = "searchResultEntry";
    public static final String SEARCH_RESULT_REFERENCE = "searchResultReference";
    public static final String SEQUENTIAL = "sequential";
    public static final String SINGLE_LEVEL = "singleLevel";
    public static final String SIZE_LIMIT = "sizeLimit";
    public static final String SUBSTRINGS = "substrings";
    public static final String TIME_LIMIT = "timeLimit";
    public static final String TRUE = "true";
    public static final String TYPE = "type";
    public static final String TYPES_ONLY = "typesOnly";
    public static final String UNORDERED = "unordered";
    public static final String VALUE = "value";
    public static final String WHOLE_SUBTREE = "wholeSubtree";
    
    private DsmlLiterals()
    {
        // Nothing to do
    }
}
