package ONVIF::PTZ::Types::ObjectId;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'http://www.onvif.org/ver10/schema' };

our $XML_ATTRIBUTE_CLASS = 'ONVIF::PTZ::Types::ObjectId::_ObjectId::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}



# There's no variety - empty complexType
use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

__PACKAGE__->_factory();


package ONVIF::PTZ::Types::ObjectId::_ObjectId::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %ObjectId_of :ATTR(:get<ObjectId>);

__PACKAGE__->_factory(
    [ qw(
        ObjectId
    ) ],
    {

        ObjectId => \%ObjectId_of,
    },
    {
        ObjectId => 'SOAP::WSDL::XSD::Typelib::Builtin::integer',
    }
);

} # end BLOCK




1;


=pod

=head1 NAME

ONVIF::PTZ::Types::ObjectId

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
ObjectId from the namespace http://www.onvif.org/ver10/schema.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

,



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ONVIF::PTZ::Types::ObjectId::_ObjectId::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * ObjectId



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::integer|SOAP::WSDL::XSD::Typelib::Builtin::integer>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

