/*
 * @(#)Pyraminx2dP.h
 *
 * Copyright 2023 - 2024  David A. Bagley, bagleyd AT verizon.net
 *
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the author not be
 * used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.
 *
 * This program is distributed in the hope that it will be "useful",
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */

/* Private header file for Pyraminx2d */

#ifndef _Pyraminx2dP_h
#define _Pyraminx2dP_h

#include "Pyraminx2d.h"

#ifndef WINVER
/* This gets around C's inability to do inheritance */
typedef struct _Pyraminx2DClassPart {
	int ignore;
} Pyraminx2DClassPart;

typedef struct _Pyraminx2DClassRec {
	CoreClassPart coreClass;
	PyraminxClassPart pyraminxClass;
	Pyraminx2DClassPart pyraminx2dClass;
} Pyraminx2DClassRec;

extern Pyraminx2DClassRec pyraminx2dClassRec;
#endif

typedef struct _Pyraminx2DPart {
	Position    faceLength;
	Position    viewLength;
} Pyraminx2DPart;

typedef struct _Pyraminx2DRec {
	CorePart    core;
	PyraminxPart    pyraminx;
	Pyraminx2DPart  pyraminx2d;
} Pyraminx2DRec;

extern Boolean selectPieces2D(Pyraminx2DWidget w, int positionX, int positionY,
	int *face, int *position);
extern void narrowSelection2D(Pyraminx2DWidget w, int style,
	int *face, int *position, int *direction);
extern void eraseFrame2D(const Pyraminx2DWidget w);
extern void drawFrame2D(Pyraminx2DWidget w, Boolean focus);
extern void drawTriangle2D(Pyraminx2DWidget w, int face, int position, int offset);
#ifdef WINVER
extern void initializePuzzle2D(Pyraminx2DWidget w);
extern void resizePuzzle2D(Pyraminx2DWidget w);
extern void exposePuzzle2D(Pyraminx2DWidget w);
#endif

#endif /* _Pyraminx2dP_h */
