# How to contribute?

## Development Guidelines

Please read [development guidelines](https://github.com/manrajgrover/py-log-symbols/blob/master/DEVELOPMENT.md) in order to setup development environment and run tests.

## Steps to contribute

* Look for a issue or open a new one in [project issues](https://github.com/manrajgrover/py-log-symbols/issues)
* Fork the project
* Clone to your machine based on your forked project
* Create a new branch with an intuitive name. Take a look in concept of [feature branch](https://martinfowler.com/bliki/FeatureBranch.html)
* Code your change / fix / new feature
* Run tests
* When the tests pass you are free to commit and push
* Open a Pull Request with a description and the issue reference

## Best Practices

Let's try to keep the code as simple and clean as we can. Some good pratices to follow during the contributing process:

- **Respect the PEP8**: don't forget to check the [PEP8](https://www.python.org/dev/peps/pep-0008/) complains;
- **Write Tests**: **always** write tests for your code
- **Keep the Cordiality**: be polite and kind; words like please and thank you are welcome :)
