# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class KubernetesClusterProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'api_subnet_allow_list': 'list[str]',

        'available_upgrade_versions': 'list[str]',

        'k8s_version': 'str',

        'location': 'str',

        'maintenance_window': 'KubernetesMaintenanceWindow',

        'name': 'str',

        'nat_gateway_ip': 'str',

        'node_subnet': 'str',

        'public': 'bool',

        's3_buckets': 'list[S3Bucket]',

        'viable_node_pool_versions': 'list[str]',
    }

    attribute_map = {

        'api_subnet_allow_list': 'apiSubnetAllowList',

        'available_upgrade_versions': 'availableUpgradeVersions',

        'k8s_version': 'k8sVersion',

        'location': 'location',

        'maintenance_window': 'maintenanceWindow',

        'name': 'name',

        'nat_gateway_ip': 'natGatewayIp',

        'node_subnet': 'nodeSubnet',

        'public': 'public',

        's3_buckets': 's3Buckets',

        'viable_node_pool_versions': 'viableNodePoolVersions',
    }

    def __init__(self, api_subnet_allow_list=None, available_upgrade_versions=None, k8s_version=None, location=None, maintenance_window=None, name=None, nat_gateway_ip=None, node_subnet=None, public=True, s3_buckets=None, viable_node_pool_versions=None, local_vars_configuration=None):  # noqa: E501
        """KubernetesClusterProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._api_subnet_allow_list = None
        self._available_upgrade_versions = None
        self._k8s_version = None
        self._location = None
        self._maintenance_window = None
        self._name = None
        self._nat_gateway_ip = None
        self._node_subnet = None
        self._public = None
        self._s3_buckets = None
        self._viable_node_pool_versions = None
        self.discriminator = None

        if api_subnet_allow_list is not None:
            self.api_subnet_allow_list = api_subnet_allow_list
        if available_upgrade_versions is not None:
            self.available_upgrade_versions = available_upgrade_versions
        if k8s_version is not None:
            self.k8s_version = k8s_version
        if location is not None:
            self.location = location
        if maintenance_window is not None:
            self.maintenance_window = maintenance_window
        self.name = name
        if nat_gateway_ip is not None:
            self.nat_gateway_ip = nat_gateway_ip
        if node_subnet is not None:
            self.node_subnet = node_subnet
        if public is not None:
            self.public = public
        if s3_buckets is not None:
            self.s3_buckets = s3_buckets
        if viable_node_pool_versions is not None:
            self.viable_node_pool_versions = viable_node_pool_versions


    @property
    def api_subnet_allow_list(self):
        """Gets the api_subnet_allow_list of this KubernetesClusterProperties.  # noqa: E501

        Access to the K8s API server is restricted to these CIDRs. Traffic, internal to the cluster, is not affected by this restriction. If no allowlist is specified, access is not restricted. If an IP without subnet mask is provided, the default value is used: 32 for IPv4 and 128 for IPv6.  # noqa: E501

        :return: The api_subnet_allow_list of this KubernetesClusterProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._api_subnet_allow_list

    @api_subnet_allow_list.setter
    def api_subnet_allow_list(self, api_subnet_allow_list):
        """Sets the api_subnet_allow_list of this KubernetesClusterProperties.

        Access to the K8s API server is restricted to these CIDRs. Traffic, internal to the cluster, is not affected by this restriction. If no allowlist is specified, access is not restricted. If an IP without subnet mask is provided, the default value is used: 32 for IPv4 and 128 for IPv6.  # noqa: E501

        :param api_subnet_allow_list: The api_subnet_allow_list of this KubernetesClusterProperties.  # noqa: E501
        :type api_subnet_allow_list: list[str]
        """

        self._api_subnet_allow_list = api_subnet_allow_list

    @property
    def available_upgrade_versions(self):
        """Gets the available_upgrade_versions of this KubernetesClusterProperties.  # noqa: E501

        List of available versions for upgrading the cluster  # noqa: E501

        :return: The available_upgrade_versions of this KubernetesClusterProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._available_upgrade_versions

    @available_upgrade_versions.setter
    def available_upgrade_versions(self, available_upgrade_versions):
        """Sets the available_upgrade_versions of this KubernetesClusterProperties.

        List of available versions for upgrading the cluster  # noqa: E501

        :param available_upgrade_versions: The available_upgrade_versions of this KubernetesClusterProperties.  # noqa: E501
        :type available_upgrade_versions: list[str]
        """

        self._available_upgrade_versions = available_upgrade_versions

    @property
    def k8s_version(self):
        """Gets the k8s_version of this KubernetesClusterProperties.  # noqa: E501

        The Kubernetes version the cluster is running. This imposes restrictions on what Kubernetes versions can be run in a cluster's nodepools. Additionally, not all Kubernetes versions are viable upgrade targets for all prior versions.  # noqa: E501

        :return: The k8s_version of this KubernetesClusterProperties.  # noqa: E501
        :rtype: str
        """
        return self._k8s_version

    @k8s_version.setter
    def k8s_version(self, k8s_version):
        """Sets the k8s_version of this KubernetesClusterProperties.

        The Kubernetes version the cluster is running. This imposes restrictions on what Kubernetes versions can be run in a cluster's nodepools. Additionally, not all Kubernetes versions are viable upgrade targets for all prior versions.  # noqa: E501

        :param k8s_version: The k8s_version of this KubernetesClusterProperties.  # noqa: E501
        :type k8s_version: str
        """

        self._k8s_version = k8s_version

    @property
    def location(self):
        """Gets the location of this KubernetesClusterProperties.  # noqa: E501

        The location of the cluster if the cluster is private. This property is immutable. The location must be enabled for your contract or you must have a Datacenter within that location. This attribute is mandatory if the cluster is private.  # noqa: E501

        :return: The location of this KubernetesClusterProperties.  # noqa: E501
        :rtype: str
        """
        return self._location

    @location.setter
    def location(self, location):
        """Sets the location of this KubernetesClusterProperties.

        The location of the cluster if the cluster is private. This property is immutable. The location must be enabled for your contract or you must have a Datacenter within that location. This attribute is mandatory if the cluster is private.  # noqa: E501

        :param location: The location of this KubernetesClusterProperties.  # noqa: E501
        :type location: str
        """

        self._location = location

    @property
    def maintenance_window(self):
        """Gets the maintenance_window of this KubernetesClusterProperties.  # noqa: E501


        :return: The maintenance_window of this KubernetesClusterProperties.  # noqa: E501
        :rtype: KubernetesMaintenanceWindow
        """
        return self._maintenance_window

    @maintenance_window.setter
    def maintenance_window(self, maintenance_window):
        """Sets the maintenance_window of this KubernetesClusterProperties.


        :param maintenance_window: The maintenance_window of this KubernetesClusterProperties.  # noqa: E501
        :type maintenance_window: KubernetesMaintenanceWindow
        """

        self._maintenance_window = maintenance_window

    @property
    def name(self):
        """Gets the name of this KubernetesClusterProperties.  # noqa: E501

        A Kubernetes cluster name. Valid Kubernetes cluster name must be 63 characters or less and must be empty or begin and end with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.  # noqa: E501

        :return: The name of this KubernetesClusterProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this KubernetesClusterProperties.

        A Kubernetes cluster name. Valid Kubernetes cluster name must be 63 characters or less and must be empty or begin and end with an alphanumeric character ([a-z0-9A-Z]) with dashes (-), underscores (_), dots (.), and alphanumerics between.  # noqa: E501

        :param name: The name of this KubernetesClusterProperties.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def nat_gateway_ip(self):
        """Gets the nat_gateway_ip of this KubernetesClusterProperties.  # noqa: E501

        The nat gateway IP of the cluster if the cluster is private. This property is immutable. Must be a reserved IP in the same location as the cluster's location. This attribute is mandatory if the cluster is private.  # noqa: E501

        :return: The nat_gateway_ip of this KubernetesClusterProperties.  # noqa: E501
        :rtype: str
        """
        return self._nat_gateway_ip

    @nat_gateway_ip.setter
    def nat_gateway_ip(self, nat_gateway_ip):
        """Sets the nat_gateway_ip of this KubernetesClusterProperties.

        The nat gateway IP of the cluster if the cluster is private. This property is immutable. Must be a reserved IP in the same location as the cluster's location. This attribute is mandatory if the cluster is private.  # noqa: E501

        :param nat_gateway_ip: The nat_gateway_ip of this KubernetesClusterProperties.  # noqa: E501
        :type nat_gateway_ip: str
        """

        self._nat_gateway_ip = nat_gateway_ip

    @property
    def node_subnet(self):
        """Gets the node_subnet of this KubernetesClusterProperties.  # noqa: E501

        The node subnet of the cluster, if the cluster is private. This property is optional and immutable. Must be a valid CIDR notation for an IPv4 network prefix of 16 bits length.  # noqa: E501

        :return: The node_subnet of this KubernetesClusterProperties.  # noqa: E501
        :rtype: str
        """
        return self._node_subnet

    @node_subnet.setter
    def node_subnet(self, node_subnet):
        """Sets the node_subnet of this KubernetesClusterProperties.

        The node subnet of the cluster, if the cluster is private. This property is optional and immutable. Must be a valid CIDR notation for an IPv4 network prefix of 16 bits length.  # noqa: E501

        :param node_subnet: The node_subnet of this KubernetesClusterProperties.  # noqa: E501
        :type node_subnet: str
        """

        self._node_subnet = node_subnet

    @property
    def public(self):
        """Gets the public of this KubernetesClusterProperties.  # noqa: E501

        The indicator if the cluster is public or private. Be aware that setting it to false is currently in beta phase.  # noqa: E501

        :return: The public of this KubernetesClusterProperties.  # noqa: E501
        :rtype: bool
        """
        return self._public

    @public.setter
    def public(self, public):
        """Sets the public of this KubernetesClusterProperties.

        The indicator if the cluster is public or private. Be aware that setting it to false is currently in beta phase.  # noqa: E501

        :param public: The public of this KubernetesClusterProperties.  # noqa: E501
        :type public: bool
        """

        self._public = public

    @property
    def s3_buckets(self):
        """Gets the s3_buckets of this KubernetesClusterProperties.  # noqa: E501

        List of S3 bucket configured for K8s usage. For now it contains only an S3 bucket used to store K8s API audit logs  # noqa: E501

        :return: The s3_buckets of this KubernetesClusterProperties.  # noqa: E501
        :rtype: list[S3Bucket]
        """
        return self._s3_buckets

    @s3_buckets.setter
    def s3_buckets(self, s3_buckets):
        """Sets the s3_buckets of this KubernetesClusterProperties.

        List of S3 bucket configured for K8s usage. For now it contains only an S3 bucket used to store K8s API audit logs  # noqa: E501

        :param s3_buckets: The s3_buckets of this KubernetesClusterProperties.  # noqa: E501
        :type s3_buckets: list[S3Bucket]
        """

        self._s3_buckets = s3_buckets

    @property
    def viable_node_pool_versions(self):
        """Gets the viable_node_pool_versions of this KubernetesClusterProperties.  # noqa: E501

        List of versions that may be used for node pools under this cluster  # noqa: E501

        :return: The viable_node_pool_versions of this KubernetesClusterProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._viable_node_pool_versions

    @viable_node_pool_versions.setter
    def viable_node_pool_versions(self, viable_node_pool_versions):
        """Sets the viable_node_pool_versions of this KubernetesClusterProperties.

        List of versions that may be used for node pools under this cluster  # noqa: E501

        :param viable_node_pool_versions: The viable_node_pool_versions of this KubernetesClusterProperties.  # noqa: E501
        :type viable_node_pool_versions: list[str]
        """

        self._viable_node_pool_versions = viable_node_pool_versions
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, KubernetesClusterProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, KubernetesClusterProperties):
            return True

        return self.to_dict() != other.to_dict()
