# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.security import SecurityCenter

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-security
# USAGE
    python create_or_update_information_protection_policy_example.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = SecurityCenter(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.information_protection_policies.create_or_update(
        scope="providers/Microsoft.Management/managementGroups/148059f7-faf3-49a6-ba35-85122112291e",
        information_protection_policy_name="custom",
        information_protection_policy={
            "properties": {
                "informationTypes": {
                    "3bf35491-99b8-41f2-86d5-c1200a7df658": {
                        "custom": True,
                        "displayName": "Custom",
                        "enabled": True,
                        "keywords": [{"canBeNumeric": True, "custom": True, "pattern": "%custom%"}],
                        "order": 1400,
                        "recommendedLabelId": "7aa516c7-5a53-4857-bc6e-6808c6acd542",
                    },
                    "7fb9419d-2473-4ad8-8e11-b25cc8cf6a07": {
                        "custom": False,
                        "displayName": "Networking",
                        "enabled": True,
                        "keywords": [{"canBeNumeric": False, "custom": True, "pattern": "%networking%"}],
                        "order": 100,
                        "recommendedLabelId": "575739d2-3d53-4df0-9042-4c7772d5c7b1",
                    },
                },
                "labels": {
                    "1345da73-bc5a-4a8f-b7dd-3820eb713da8": {"displayName": "Public", "enabled": True, "order": 100},
                    "575739d2-3d53-4df0-9042-4c7772d5c7b1": {
                        "displayName": "Confidential",
                        "enabled": True,
                        "order": 300,
                    },
                    "7aa516c7-5a53-4857-bc6e-6808c6acd542": {"displayName": "General", "enabled": True, "order": 200},
                },
            }
        },
    )
    print(response)


# x-ms-original-file: specification/security/resource-manager/Microsoft.Security/preview/2017-08-01-preview/examples/InformationProtectionPolicies/CreateOrUpdateInformationProtectionPolicy_example.json
if __name__ == "__main__":
    main()
