# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from azure.ai.projects import AIProjectClient
from devtools_testutils import AzureRecordedTestCase, PowerShellPreparer
import functools


class AIProjectClientTestBase(AzureRecordedTestCase):

    def create_client(self, endpoint):
        credential = self.get_credential(AIProjectClient)
        return self.create_client_from_credential(
            AIProjectClient,
            credential=credential,
            endpoint=endpoint,
        )


AIProjectPreparer = functools.partial(
    PowerShellPreparer, "aiproject", aiproject_endpoint="https://fake_aiproject_endpoint.com"
)
