# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .. import models as _models
from .._utils.serialization import Deserializer, Serializer
from ._configuration import ContainerServiceClientConfiguration
from .operations import (
    AgentPoolsOperations,
    ContainerServiceOperations,
    LoadBalancersOperations,
    MachinesOperations,
    MaintenanceConfigurationsOperations,
    ManagedClusterSnapshotsOperations,
    ManagedClustersOperations,
    NamespacesOperations,
    OperationStatusResultOperations,
    Operations,
    PrivateEndpointConnectionsOperations,
    PrivateLinkResourcesOperations,
    ResolvePrivateLinkServiceIdOperations,
    SnapshotsOperations,
    TrustedAccessRoleBindingsOperations,
    TrustedAccessRolesOperations,
)

if TYPE_CHECKING:
    from azure.core.credentials_async import AsyncTokenCredential


class ContainerServiceClient:  # pylint: disable=too-many-instance-attributes
    """The Container Service Client.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.Operations
    :ivar managed_clusters: ManagedClustersOperations operations
    :vartype managed_clusters:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.ManagedClustersOperations
    :ivar container_service: ContainerServiceOperations operations
    :vartype container_service:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.ContainerServiceOperations
    :ivar maintenance_configurations: MaintenanceConfigurationsOperations operations
    :vartype maintenance_configurations:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.MaintenanceConfigurationsOperations
    :ivar namespaces: NamespacesOperations operations
    :vartype namespaces:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.NamespacesOperations
    :ivar agent_pools: AgentPoolsOperations operations
    :vartype agent_pools:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.AgentPoolsOperations
    :ivar machines: MachinesOperations operations
    :vartype machines:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.MachinesOperations
    :ivar private_endpoint_connections: PrivateEndpointConnectionsOperations operations
    :vartype private_endpoint_connections:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.PrivateEndpointConnectionsOperations
    :ivar private_link_resources: PrivateLinkResourcesOperations operations
    :vartype private_link_resources:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.PrivateLinkResourcesOperations
    :ivar resolve_private_link_service_id: ResolvePrivateLinkServiceIdOperations operations
    :vartype resolve_private_link_service_id:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.ResolvePrivateLinkServiceIdOperations
    :ivar operation_status_result: OperationStatusResultOperations operations
    :vartype operation_status_result:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.OperationStatusResultOperations
    :ivar snapshots: SnapshotsOperations operations
    :vartype snapshots:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.SnapshotsOperations
    :ivar managed_cluster_snapshots: ManagedClusterSnapshotsOperations operations
    :vartype managed_cluster_snapshots:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.ManagedClusterSnapshotsOperations
    :ivar trusted_access_roles: TrustedAccessRolesOperations operations
    :vartype trusted_access_roles:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.TrustedAccessRolesOperations
    :ivar trusted_access_role_bindings: TrustedAccessRoleBindingsOperations operations
    :vartype trusted_access_role_bindings:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.TrustedAccessRoleBindingsOperations
    :ivar load_balancers: LoadBalancersOperations operations
    :vartype load_balancers:
     azure.mgmt.containerservice.v2025_02_02_preview.aio.operations.LoadBalancersOperations
    :param credential: Credential needed for the client to connect to Azure. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service URL. Default value is None.
    :type base_url: str
    :keyword api_version: Api Version. Default value is "2025-02-02-preview". Note that overriding
     this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self, credential: "AsyncTokenCredential", subscription_id: str, base_url: Optional[str] = None, **kwargs: Any
    ) -> None:
        _cloud = kwargs.pop("cloud_setting", None) or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = ContainerServiceClientConfiguration(
            credential=credential, subscription_id=subscription_id, credential_scopes=credential_scopes, **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, base_url), policies=_policies, **kwargs
        )

        client_models = {k: v for k, v in _models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.managed_clusters = ManagedClustersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.container_service = ContainerServiceOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.maintenance_configurations = MaintenanceConfigurationsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.namespaces = NamespacesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.agent_pools = AgentPoolsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.machines = MachinesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.private_endpoint_connections = PrivateEndpointConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.private_link_resources = PrivateLinkResourcesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.resolve_private_link_service_id = ResolvePrivateLinkServiceIdOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.operation_status_result = OperationStatusResultOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.snapshots = SnapshotsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.managed_cluster_snapshots = ManagedClusterSnapshotsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.trusted_access_roles = TrustedAccessRolesOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.trusted_access_role_bindings = TrustedAccessRoleBindingsOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )
        self.load_balancers = LoadBalancersOperations(
            self._client, self._config, self._serialize, self._deserialize, "2025-02-02-preview"
        )

    def _send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client._send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
