<?php

namespace AsyncAws\Core\Sts\ValueObject;

/**
 * The Amazon Resource Name (ARN) and the assumed role ID, which are identifiers that you can use to refer to the
 * resulting temporary security credentials. For example, you can reference these credentials as a principal in a
 * resource-based policy by using the ARN or assumed role ID. The ARN and ID include the `RoleSessionName` that you
 * specified when you called `AssumeRole`.
 */
final class AssumedRoleUser
{
    /**
     * A unique identifier that contains the role ID and the role session name of the role that is being assumed. The role
     * ID is generated by Amazon Web Services when the role is created.
     */
    private $assumedRoleId;

    /**
     * The ARN of the temporary security credentials that are returned from the AssumeRole action. For more information
     * about ARNs and how to use them in policies, see IAM Identifiers in the *IAM User Guide*.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html
     */
    private $arn;

    /**
     * @param array{
     *   AssumedRoleId: string,
     *   Arn: string,
     * } $input
     */
    public function __construct(array $input)
    {
        $this->assumedRoleId = $input['AssumedRoleId'] ?? null;
        $this->arn = $input['Arn'] ?? null;
    }

    public static function create($input): self
    {
        return $input instanceof self ? $input : new self($input);
    }

    public function getArn(): string
    {
        return $this->arn;
    }

    public function getAssumedRoleId(): string
    {
        return $this->assumedRoleId;
    }
}
