/* For information on usage and redistribution, and for a DISCLAIMER OF ALL
* WARRANTIES, see the file, "LICENSE.txt," in this distribution.

iem_roomsim written by Thomas Musil (c) IEM KUG Graz Austria 2002 - 2018 */

#include "m_pd.h"
#include "iemlib.h"

static t_class *iem_roomsim_class;

static void *iem_roomsim_new(void)
{
  t_object *x = (t_object *)pd_new(iem_roomsim_class);
  
  return (x);
}

void early_reflections_3d_setup(void);
void early_reflections_2d_setup(void);
void cart2del_damp_2d_setup(void);
void cart2del_damp_3d_setup(void);
//void xy_2_del_damp_phi_setup(void);
//void xyz_3_del_damp_theta_phi_setup(void);

void n_delay1p_line_tilde_setup(void);
void n_delay2p_line_tilde_setup(void);
void nz_tilde_setup(void);
void block_delay_tilde_setup(void);
void block_lp1_tilde_setup(void);
void block_peak_env_tilde_setup(void);

/* ------------------------ setup routine ------------------------- */

void iem_roomsim_setup(void)
{
  early_reflections_3d_setup();
  early_reflections_2d_setup();
  cart2del_damp_2d_setup();
  cart2del_damp_3d_setup();
//  xy_2_del_damp_phi_setup();
//  xyz_3_del_damp_theta_phi_setup();

  n_delay1p_line_tilde_setup();
	n_delay2p_line_tilde_setup();
	nz_tilde_setup();
	block_delay_tilde_setup();
	block_lp1_tilde_setup();
	block_peak_env_tilde_setup();
  
  post("iem_roomsim (1.21) library loaded!   (c) Thomas Musil "BUILD_DATE);
  post("   musil%ciem.at iem KUG Graz Austria", '@');
}
