# Coming into this file, the make variable CURRENT should have been defined.

# On VMS we frequently need to be able to switch between VMS and UNIX
# syntax so we will be doing stuff like the following quite a bit:

TOP_V=$(SUBST ..,-,$(TOP))
TOP_V=$(SUBST /,.,$(TOP_V))
TOP_V=[$(SUBST .-,-,$(TOP_V))]

MK_V=$(SUBST ..,-,$(TOP)/mk)
MK_V=$(SUBST /,.,$(MK_V))
MK_V=[$(SUBST .-,-,$(MK_V))]

# Either uncomment out one of the platform lines below or use the autoconfig
# mechanism by uncommenting out this line

autoconfig=1

#platform=OpenVMS_Alpha_6_2	# OpenVMS Alpha 6.2 DEC/Compaq/HP C++ 6.x
#platform=OpenVMS_Alpha_7_1	# OpenVMS Alpha 7.1 DEC/Compaq/HP C++ 6.x
#platform=OpenVMS_Alpha_7_2	# OpenVMS Alpha 7.2 DEC/Compaq/HP C++ 6.x
#platform=OpenVMS_Alpha_7_3	# OpenVMS Alpha 7.2 DEC/Compaq/HP C++ 6.x

# Also enable the following (if autoconfig is not used):
# CXX6=1	# Compaq C++ 6.x compiler (Alpha only)

# Enable one of the following for the release version of the libraries.  (Note
# that /Debug=all may seem odd for release builds, but could be useful for
# running PCA or analyzing crash dumps).

# RELEASE_DEBUG=/NoDebug
# RELEASE_DEBUG=/Debug=all
RELEASE_DEBUG=/Debug=trace

# enable this to link against shareable images
USE_SHAREABLE_IMAGES=1

# Set the verification level of compilations here.  I.e., if you want only brief
# messages ("Compiling foo.cc...") set this to 0 or comment it out.
# COMPILE_VERIFY=1
.if $(COMPILE_VERIFY) .eq 1
.else
VERBOSITY=@
.endif

# If you want to exclude BOA support in the COS library, uncomment the
# following:
# COS_NO_BOA=1

EXPORT_TREE =  $(TOP)

IMPORT_TREES = $(TOP)

# Macro to indicate whether the current directory has been initialized.
dir_initialized="$(wildcard dependencies.d)" .ne ""

.ifdef VERBOSITY
premakeverbosity=,VERBOSITY="$(VERBOSITY)"
.endif

.ifdef COMPILE_VERIFY
premakecompileverify=,COMPILE_VERIFY="$(COMPILE_VERIFY)"
.endif

.ifdef autoconfig
.include $(TOP)/mk/platform.mms
.endif

.include $(TOP)/mk/beforedir.mms
premakemacroqual=/macro=(dir.mms,MK_V="$(MK_V)"\
$(premakeverbosity)$(premakecompileverify),CONFIG_DIR="$(CONFIG_DIR)")
PREMAKE=$(VERBOSITY) mms /extended$(premakemacroqual)/descr=$(MK_V)premake.mms

# If the directory has been initialized then go ahead and build
.if $(dir_initialized)

.include dir.mms
.if "$(wildcard $(CONFIG_DIR_V)dependencies.d)" .ne ""
.include $(CONFIG_DIR_V)dependencies.d
.endif

premake ::
	$(PREMAKE)

# otherwise initialize the directory, create a dependencies.d file
# then recurse.

.else

premake ::
	$(PREMAKE)
	$(DIR_PREMAKE)

all ::
	$(PREMAKE)
	$(DIR_PREMAKE)
	$(VERBOSITY) $(mms) $(mmsqualifiers) $(mmstargets)

export ::
	$(PREMAKE)
	$(DIR_PREMAKE)
	$(VERBOSITY) $(mms) $(mmsqualifiers) $(mmstargets)

.endif

.include $(top)/mk/afterdir.mms
