/*
 * Decompiled with CFR 0.152.
 */
package org.h2.value;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import org.h2.engine.Mode;
import org.h2.message.DbException;
import org.h2.util.StringUtils;
import org.h2.value.CompareMode;
import org.h2.value.Value;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.locationtech.jts.io.WKTReader;
import org.locationtech.jts.io.WKTWriter;

public class ValueGeometry
extends Value {
    private final byte[] bytes;
    private final int hashCode;
    private Geometry geometry;

    private ValueGeometry(byte[] byArray, Geometry geometry) {
        this.bytes = byArray;
        this.geometry = geometry;
        this.hashCode = Arrays.hashCode(byArray);
    }

    public static ValueGeometry getFromGeometry(Object object) {
        return ValueGeometry.get((Geometry)object);
    }

    private static ValueGeometry get(Geometry geometry) {
        byte[] byArray = ValueGeometry.convertToWKB(geometry);
        return (ValueGeometry)Value.cache(new ValueGeometry(byArray, geometry));
    }

    private static byte[] convertToWKB(Geometry geometry) {
        boolean bl = geometry.getSRID() != 0;
        int n = ValueGeometry.getDimensionCount(geometry);
        WKBWriter wKBWriter = new WKBWriter(n, bl);
        return wKBWriter.write(geometry);
    }

    private static int getDimensionCount(Geometry geometry) {
        ZVisitor zVisitor = new ZVisitor();
        geometry.apply((CoordinateSequenceFilter)zVisitor);
        return zVisitor.isFoundZ() ? 3 : 2;
    }

    public static ValueGeometry get(String string) {
        try {
            Geometry geometry = new WKTReader().read(string);
            return ValueGeometry.get(geometry);
        }
        catch (ParseException parseException) {
            throw DbException.convert(parseException);
        }
    }

    public static ValueGeometry get(String string, int n) {
        try {
            GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), n);
            Geometry geometry = new WKTReader(geometryFactory).read(string);
            return ValueGeometry.get(geometry);
        }
        catch (ParseException parseException) {
            throw DbException.convert(parseException);
        }
    }

    public static ValueGeometry get(byte[] byArray) {
        return (ValueGeometry)Value.cache(new ValueGeometry(byArray, null));
    }

    public Geometry getGeometry() {
        return this.getGeometryNoCopy().copy();
    }

    public Geometry getGeometryNoCopy() {
        if (this.geometry == null) {
            try {
                this.geometry = new WKBReader().read(this.bytes);
            }
            catch (ParseException parseException) {
                throw DbException.convert(parseException);
            }
        }
        return this.geometry;
    }

    public boolean intersectsBoundingBox(ValueGeometry valueGeometry) {
        return this.getGeometryNoCopy().getEnvelopeInternal().intersects(valueGeometry.getGeometryNoCopy().getEnvelopeInternal());
    }

    public Value getEnvelopeUnion(ValueGeometry valueGeometry) {
        GeometryFactory geometryFactory = new GeometryFactory();
        Envelope envelope = new Envelope(this.getGeometryNoCopy().getEnvelopeInternal());
        envelope.expandToInclude(valueGeometry.getGeometryNoCopy().getEnvelopeInternal());
        return ValueGeometry.get(geometryFactory.toGeometry(envelope));
    }

    @Override
    public int getType() {
        return 22;
    }

    @Override
    public String getSQL() {
        return "X'" + StringUtils.convertBytesToHex(this.getBytesNoCopy()) + "'::Geometry";
    }

    @Override
    protected int compareSecure(Value value, CompareMode compareMode) {
        Geometry geometry = ((ValueGeometry)value).getGeometryNoCopy();
        return this.getGeometryNoCopy().compareTo((Object)geometry);
    }

    @Override
    public String getString() {
        return this.getWKT();
    }

    @Override
    public long getPrecision() {
        return 0L;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Object getObject() {
        return this.getGeometry();
    }

    @Override
    public byte[] getBytes() {
        return this.getWKB();
    }

    @Override
    public byte[] getBytesNoCopy() {
        return this.getWKB();
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setObject(n, this.getGeometryNoCopy());
    }

    @Override
    public int getDisplaySize() {
        return this.getWKT().length();
    }

    @Override
    public int getMemory() {
        return this.getWKB().length * 20 + 24;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ValueGeometry && Arrays.equals(this.getWKB(), ((ValueGeometry)object).getWKB());
    }

    public String getWKT() {
        return new WKTWriter(3).write(this.getGeometryNoCopy());
    }

    public byte[] getWKB() {
        return this.bytes;
    }

    @Override
    public Value convertTo(int n, int n2, Mode mode, Object object, String[] stringArray) {
        if (n == 19) {
            return this;
        }
        return super.convertTo(n, n2, mode, object, null);
    }

    static class ZVisitor
    implements CoordinateSequenceFilter {
        private boolean foundZ;

        ZVisitor() {
        }

        public boolean isFoundZ() {
            return this.foundZ;
        }

        public void filter(CoordinateSequence coordinateSequence, int n) {
            if (!Double.isNaN(coordinateSequence.getOrdinate(n, 2))) {
                this.foundZ = true;
            }
        }

        public boolean isDone() {
            return this.foundZ;
        }

        public boolean isGeometryChanged() {
            return false;
        }
    }
}

