/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*
 * ImmutableVariablesCustomizer.java
 *
 * Created on 12.10.2011, 16:36:35
 */
package org.netbeans.modules.php.editor.verification;

import java.util.prefs.Preferences;

/**
 *
 * @author Ondrej Brejla <obrejla@netbeans.org>
 */
public class ImmutableVariablesCustomizer extends javax.swing.JPanel {
    private final ImmutableVariablesHint immutableVariablesHint;
    private final Preferences preferences;

    public ImmutableVariablesCustomizer(Preferences preferences, ImmutableVariablesHint immutableVariablesHint) {
        this.preferences = preferences;
        this.immutableVariablesHint = immutableVariablesHint;
        initComponents();
        numberOfAllowedAssignmentsSpinner.getModel().setValue(immutableVariablesHint.getNumberOfAllowedAssignments(preferences));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        numberOfAllowedAssignmentsSpinner = new javax.swing.JSpinner();

        jLabel1.setText(org.openide.util.NbBundle.getMessage(ImmutableVariablesCustomizer.class, "ImmutableVariablesCustomizer.jLabel1.text")); // NOI18N

        numberOfAllowedAssignmentsSpinner.setModel(new javax.swing.SpinnerNumberModel(1, 1, 20, 1));
        numberOfAllowedAssignmentsSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                numberOfAllowedAssignmentsSpinnerStateChanged(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(numberOfAllowedAssignmentsSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, 52, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(numberOfAllowedAssignmentsSpinner, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(260, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void numberOfAllowedAssignmentsSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_numberOfAllowedAssignmentsSpinnerStateChanged
        immutableVariablesHint.setNumberOfAllowedAssignments(preferences, (Integer) numberOfAllowedAssignmentsSpinner.getValue());
    }//GEN-LAST:event_numberOfAllowedAssignmentsSpinnerStateChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JSpinner numberOfAllowedAssignmentsSpinner;
    // End of variables declaration//GEN-END:variables
}
