/*
 * Copyright 2023 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 */
#ifndef _gc_12_0_0_OFFSET_HEADER
#define _gc_12_0_0_OFFSET_HEADER



// addressBlock: gc_gfx_cpwd_sdma0_sdmadec
// base address: 0x4980
#define regSDMA0_DEC_START                                                                              0x0000
#define regSDMA0_DEC_START_BASE_IDX                                                                     0
#define regSDMA0_MCU_MISC_CNTL                                                                          0x0001
#define regSDMA0_MCU_MISC_CNTL_BASE_IDX                                                                 0
#define regSDMA0_UCODE_REV                                                                              0x0003
#define regSDMA0_UCODE_REV_BASE_IDX                                                                     0
#define regSDMA0_GLOBAL_TIMESTAMP_LO                                                                    0x0005
#define regSDMA0_GLOBAL_TIMESTAMP_LO_BASE_IDX                                                           0
#define regSDMA0_GLOBAL_TIMESTAMP_HI                                                                    0x0006
#define regSDMA0_GLOBAL_TIMESTAMP_HI_BASE_IDX                                                           0
#define regSDMA0_POWER_CNTL                                                                             0x000c
#define regSDMA0_POWER_CNTL_BASE_IDX                                                                    0
#define regSDMA0_CNTL                                                                                   0x000d
#define regSDMA0_CNTL_BASE_IDX                                                                          0
#define regSDMA0_CHICKEN_BITS                                                                           0x000e
#define regSDMA0_CHICKEN_BITS_BASE_IDX                                                                  0
#define regSDMA0_CACHE_CNTL                                                                             0x000f
#define regSDMA0_CACHE_CNTL_BASE_IDX                                                                    0
#define regSDMA0_RB_RPTR_FETCH                                                                          0x0020
#define regSDMA0_RB_RPTR_FETCH_BASE_IDX                                                                 0
#define regSDMA0_RB_RPTR_FETCH_HI                                                                       0x0021
#define regSDMA0_RB_RPTR_FETCH_HI_BASE_IDX                                                              0
#define regSDMA0_IB_OFFSET_FETCH                                                                        0x0022
#define regSDMA0_IB_OFFSET_FETCH_BASE_IDX                                                               0
#define regSDMA0_PROGRAM                                                                                0x0023
#define regSDMA0_PROGRAM_BASE_IDX                                                                       0
#define regSDMA0_STATUS_REG                                                                             0x0024
#define regSDMA0_STATUS_REG_BASE_IDX                                                                    0
#define regSDMA0_STATUS1_REG                                                                            0x0025
#define regSDMA0_STATUS1_REG_BASE_IDX                                                                   0
#define regSDMA0_CNTL1                                                                                  0x0026
#define regSDMA0_CNTL1_BASE_IDX                                                                         0
#define regSDMA0_HBM_PAGE_CONFIG                                                                        0x0027
#define regSDMA0_HBM_PAGE_CONFIG_BASE_IDX                                                               0
#define regSDMA0_FREEZE                                                                                 0x0028
#define regSDMA0_FREEZE_BASE_IDX                                                                        0
#define regSDMA0_PROCESS_QUANTUM0                                                                       0x0029
#define regSDMA0_PROCESS_QUANTUM0_BASE_IDX                                                              0
#define regSDMA0_PROCESS_QUANTUM1                                                                       0x002a
#define regSDMA0_PROCESS_QUANTUM1_BASE_IDX                                                              0
#define regSDMA0_WATCHDOG_CNTL                                                                          0x002b
#define regSDMA0_WATCHDOG_CNTL_BASE_IDX                                                                 0
#define regSDMA0_QUEUE_STATUS0                                                                          0x002c
#define regSDMA0_QUEUE_STATUS0_BASE_IDX                                                                 0
#define regSDMA0_EDC_CONFIG                                                                             0x002d
#define regSDMA0_EDC_CONFIG_BASE_IDX                                                                    0
#define regSDMA0_ID                                                                                     0x002e
#define regSDMA0_ID_BASE_IDX                                                                            0
#define regSDMA0_VERSION                                                                                0x002f
#define regSDMA0_VERSION_BASE_IDX                                                                       0
#define regSDMA0_STATUS2_REG                                                                            0x0030
#define regSDMA0_STATUS2_REG_BASE_IDX                                                                   0
#define regSDMA0_ATOMIC_CNTL                                                                            0x0031
#define regSDMA0_ATOMIC_CNTL_BASE_IDX                                                                   0
#define regSDMA0_ATOMIC_PREOP_LO                                                                        0x0032
#define regSDMA0_ATOMIC_PREOP_LO_BASE_IDX                                                               0
#define regSDMA0_ATOMIC_PREOP_HI                                                                        0x0033
#define regSDMA0_ATOMIC_PREOP_HI_BASE_IDX                                                               0
#define regSDMA0_DCC_CNTL                                                                               0x0034
#define regSDMA0_DCC_CNTL_BASE_IDX                                                                      0
#define regSDMA0_UTCL1_CNTL                                                                             0x0035
#define regSDMA0_UTCL1_CNTL_BASE_IDX                                                                    0
#define regSDMA0_UTCL1_WATERMK                                                                          0x0036
#define regSDMA0_UTCL1_WATERMK_BASE_IDX                                                                 0
#define regSDMA0_UTCL1_TIMEOUT                                                                          0x0037
#define regSDMA0_UTCL1_TIMEOUT_BASE_IDX                                                                 0
#define regSDMA0_UTCL1_PAGE                                                                             0x0038
#define regSDMA0_UTCL1_PAGE_BASE_IDX                                                                    0
#define regSDMA0_EXTERNAL_FROZEN                                                                        0x0039
#define regSDMA0_EXTERNAL_FROZEN_BASE_IDX                                                               0
#define regSDMA0_UTCL1_RD_STATUS                                                                        0x0041
#define regSDMA0_UTCL1_RD_STATUS_BASE_IDX                                                               0
#define regSDMA0_UTCL1_WR_STATUS                                                                        0x0042
#define regSDMA0_UTCL1_WR_STATUS_BASE_IDX                                                               0
#define regSDMA0_UTCL1_INV0                                                                             0x0043
#define regSDMA0_UTCL1_INV0_BASE_IDX                                                                    0
#define regSDMA0_UTCL1_INV1                                                                             0x0044
#define regSDMA0_UTCL1_INV1_BASE_IDX                                                                    0
#define regSDMA0_UTCL1_INV2                                                                             0x0045
#define regSDMA0_UTCL1_INV2_BASE_IDX                                                                    0
#define regSDMA0_UTCL1_RD_XNACK0                                                                        0x0046
#define regSDMA0_UTCL1_RD_XNACK0_BASE_IDX                                                               0
#define regSDMA0_UTCL1_RD_XNACK1                                                                        0x0047
#define regSDMA0_UTCL1_RD_XNACK1_BASE_IDX                                                               0
#define regSDMA0_UTCL1_WR_XNACK0                                                                        0x0048
#define regSDMA0_UTCL1_WR_XNACK0_BASE_IDX                                                               0
#define regSDMA0_UTCL1_WR_XNACK1                                                                        0x0049
#define regSDMA0_UTCL1_WR_XNACK1_BASE_IDX                                                               0
#define regSDMA0_RELAX_ORDERING_LUT                                                                     0x004a
#define regSDMA0_RELAX_ORDERING_LUT_BASE_IDX                                                            0
#define regSDMA0_CHICKEN_BITS_2                                                                         0x004b
#define regSDMA0_CHICKEN_BITS_2_BASE_IDX                                                                0
#define regSDMA0_STATUS3_REG                                                                            0x004c
#define regSDMA0_STATUS3_REG_BASE_IDX                                                                   0
#define regSDMA0_GLOBAL_QUANTUM                                                                         0x004d
#define regSDMA0_GLOBAL_QUANTUM_BASE_IDX                                                                0
#define regSDMA0_ERROR_LOG                                                                              0x004e
#define regSDMA0_ERROR_LOG_BASE_IDX                                                                     0
#define regSDMA0_PUB_DUMMY_REG0                                                                         0x004f
#define regSDMA0_PUB_DUMMY_REG0_BASE_IDX                                                                0
#define regSDMA0_PUB_DUMMY_REG1                                                                         0x0050
#define regSDMA0_PUB_DUMMY_REG1_BASE_IDX                                                                0
#define regSDMA0_PUB_DUMMY_REG2                                                                         0x0051
#define regSDMA0_PUB_DUMMY_REG2_BASE_IDX                                                                0
#define regSDMA0_PUB_DUMMY_REG3                                                                         0x0052
#define regSDMA0_PUB_DUMMY_REG3_BASE_IDX                                                                0
#define regSDMA0_MCU_COUNTER                                                                            0x0053
#define regSDMA0_MCU_COUNTER_BASE_IDX                                                                   0
#define regSDMA0_CRD_CNTL                                                                               0x0054
#define regSDMA0_CRD_CNTL_BASE_IDX                                                                      0
#define regSDMA0_RLC_CGCG_CTRL                                                                          0x0055
#define regSDMA0_RLC_CGCG_CTRL_BASE_IDX                                                                 0
#define regSDMA0_GPU_IOV_VIOLATION_LOG                                                                  0x0056
#define regSDMA0_GPU_IOV_VIOLATION_LOG_BASE_IDX                                                         0
#define regSDMA0_AQL_STATUS                                                                             0x0058
#define regSDMA0_AQL_STATUS_BASE_IDX                                                                    0
#define regSDMA0_TLBI_GCR_CNTL                                                                          0x0060
#define regSDMA0_TLBI_GCR_CNTL_BASE_IDX                                                                 0
#define regSDMA0_INT_STATUS                                                                             0x0061
#define regSDMA0_INT_STATUS_BASE_IDX                                                                    0
#define regSDMA0_GPU_IOV_VIOLATION_LOG2                                                                 0x0062
#define regSDMA0_GPU_IOV_VIOLATION_LOG2_BASE_IDX                                                        0
#define regSDMA0_INVALID_ADDR_LO                                                                        0x0063
#define regSDMA0_INVALID_ADDR_LO_BASE_IDX                                                               0
#define regSDMA0_INVALID_ADDR_HI                                                                        0x0064
#define regSDMA0_INVALID_ADDR_HI_BASE_IDX                                                               0
#define regSDMA0_INVALID_ADDR_SRC                                                                       0x0065
#define regSDMA0_INVALID_ADDR_SRC_BASE_IDX                                                              0
#define regSDMA0_CLOCK_GATING_STATUS                                                                    0x0066
#define regSDMA0_CLOCK_GATING_STATUS_BASE_IDX                                                           0
#define regSDMA0_STATUS4_REG                                                                            0x0067
#define regSDMA0_STATUS4_REG_BASE_IDX                                                                   0
#define regSDMA0_SCRATCH_RAM_DATA                                                                       0x0068
#define regSDMA0_SCRATCH_RAM_DATA_BASE_IDX                                                              0
#define regSDMA0_SCRATCH_RAM_ADDR                                                                       0x0069
#define regSDMA0_SCRATCH_RAM_ADDR_BASE_IDX                                                              0
#define regSDMA0_TIMESTAMP_CNTL                                                                         0x006a
#define regSDMA0_TIMESTAMP_CNTL_BASE_IDX                                                                0
#define regSDMA0_STATUS5_REG                                                                            0x006b
#define regSDMA0_STATUS5_REG_BASE_IDX                                                                   0
#define regSDMA0_QUEUE_RESET_REQ                                                                        0x006c
#define regSDMA0_QUEUE_RESET_REQ_BASE_IDX                                                               0
#define regSDMA0_STATUS6_REG                                                                            0x006d
#define regSDMA0_STATUS6_REG_BASE_IDX                                                                   0
#define regSDMA0_STATUS7_REG                                                                            0x006e
#define regSDMA0_STATUS7_REG_BASE_IDX                                                                   0
#define regSDMA0_STATUS8_REG                                                                            0x006f
#define regSDMA0_STATUS8_REG_BASE_IDX                                                                   0
#define regSDMA0_CE_CTRL                                                                                0x0070
#define regSDMA0_CE_CTRL_BASE_IDX                                                                       0
#define regSDMA0_FED_STATUS                                                                             0x0071
#define regSDMA0_FED_STATUS_BASE_IDX                                                                    0
#define regSDMA0_QUEUE0_RB_CNTL                                                                         0x0080
#define regSDMA0_QUEUE0_RB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE0_RB_BASE                                                                         0x0081
#define regSDMA0_QUEUE0_RB_BASE_BASE_IDX                                                                0
#define regSDMA0_QUEUE0_RB_BASE_HI                                                                      0x0082
#define regSDMA0_QUEUE0_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE0_RB_RPTR                                                                         0x0083
#define regSDMA0_QUEUE0_RB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE0_RB_RPTR_HI                                                                      0x0084
#define regSDMA0_QUEUE0_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE0_RB_WPTR                                                                         0x0085
#define regSDMA0_QUEUE0_RB_WPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE0_RB_WPTR_HI                                                                      0x0086
#define regSDMA0_QUEUE0_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE0_RB_RPTR_ADDR_LO                                                                 0x0087
#define regSDMA0_QUEUE0_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA0_QUEUE0_RB_RPTR_ADDR_HI                                                                 0x0088
#define regSDMA0_QUEUE0_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA0_QUEUE0_IB_CNTL                                                                         0x0089
#define regSDMA0_QUEUE0_IB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE0_IB_RPTR                                                                         0x008a
#define regSDMA0_QUEUE0_IB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE0_IB_OFFSET                                                                       0x008b
#define regSDMA0_QUEUE0_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA0_QUEUE0_IB_BASE_LO                                                                      0x008c
#define regSDMA0_QUEUE0_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA0_QUEUE0_IB_BASE_HI                                                                      0x008d
#define regSDMA0_QUEUE0_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE0_IB_SIZE                                                                         0x008e
#define regSDMA0_QUEUE0_IB_SIZE_BASE_IDX                                                                0
#define regSDMA0_QUEUE0_DOORBELL                                                                        0x008f
#define regSDMA0_QUEUE0_DOORBELL_BASE_IDX                                                               0
#define regSDMA0_QUEUE0_DOORBELL_LOG                                                                    0x0090
#define regSDMA0_QUEUE0_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_DOORBELL_OFFSET                                                                 0x0091
#define regSDMA0_QUEUE0_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA0_QUEUE0_CSA_ADDR_LO                                                                     0x0092
#define regSDMA0_QUEUE0_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA0_QUEUE0_CSA_ADDR_HI                                                                     0x0093
#define regSDMA0_QUEUE0_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA0_QUEUE0_SCHEDULE_CNTL                                                                   0x0094
#define regSDMA0_QUEUE0_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA0_QUEUE0_IB_SUB_REMAIN                                                                   0x0095
#define regSDMA0_QUEUE0_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA0_QUEUE0_PREEMPT                                                                         0x0096
#define regSDMA0_QUEUE0_PREEMPT_BASE_IDX                                                                0
#define regSDMA0_QUEUE0_DUMMY_REG                                                                       0x0097
#define regSDMA0_QUEUE0_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA0_QUEUE0_RB_WPTR_POLL_ADDR_LO                                                            0x0098
#define regSDMA0_QUEUE0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA0_QUEUE0_RB_WPTR_POLL_ADDR_HI                                                            0x0099
#define regSDMA0_QUEUE0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA0_QUEUE0_RB_AQL_CNTL                                                                     0x009a
#define regSDMA0_QUEUE0_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE0_MINOR_PTR_UPDATE                                                                0x009b
#define regSDMA0_QUEUE0_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA0_QUEUE0_CONTEXT_SWITCH_STATUS                                                           0x009e
#define regSDMA0_QUEUE0_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA0_QUEUE0_MIDCMD_CNTL                                                                     0x009f
#define regSDMA0_QUEUE0_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE0_MIDCMD_DATA0                                                                    0x00a0
#define regSDMA0_QUEUE0_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA1                                                                    0x00a1
#define regSDMA0_QUEUE0_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA2                                                                    0x00a2
#define regSDMA0_QUEUE0_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA3                                                                    0x00a3
#define regSDMA0_QUEUE0_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA4                                                                    0x00a4
#define regSDMA0_QUEUE0_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA5                                                                    0x00a5
#define regSDMA0_QUEUE0_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA6                                                                    0x00a6
#define regSDMA0_QUEUE0_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA7                                                                    0x00a7
#define regSDMA0_QUEUE0_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA8                                                                    0x00a8
#define regSDMA0_QUEUE0_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA9                                                                    0x00a9
#define regSDMA0_QUEUE0_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA0_QUEUE0_MIDCMD_DATA10                                                                   0x00aa
#define regSDMA0_QUEUE0_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA0_QUEUE0_WAIT_UNSATISFIED_THD                                                            0x00ab
#define regSDMA0_QUEUE0_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA0_QUEUE0_MQD_BASE_ADDR_LO                                                                0x00ac
#define regSDMA0_QUEUE0_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA0_QUEUE0_MQD_BASE_ADDR_HI                                                                0x00ad
#define regSDMA0_QUEUE0_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA0_QUEUE0_MQD_CONTROL                                                                     0x00ae
#define regSDMA0_QUEUE0_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA0_QUEUE0_DEQUEUE_REQUEST                                                                 0x00af
#define regSDMA0_QUEUE0_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA0_QUEUE0_CONTEXT_STATUS                                                                  0x00b0
#define regSDMA0_QUEUE0_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA0_QUEUE1_RB_CNTL                                                                         0x00d8
#define regSDMA0_QUEUE1_RB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE1_RB_BASE                                                                         0x00d9
#define regSDMA0_QUEUE1_RB_BASE_BASE_IDX                                                                0
#define regSDMA0_QUEUE1_RB_BASE_HI                                                                      0x00da
#define regSDMA0_QUEUE1_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE1_RB_RPTR                                                                         0x00db
#define regSDMA0_QUEUE1_RB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE1_RB_RPTR_HI                                                                      0x00dc
#define regSDMA0_QUEUE1_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE1_RB_WPTR                                                                         0x00dd
#define regSDMA0_QUEUE1_RB_WPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE1_RB_WPTR_HI                                                                      0x00de
#define regSDMA0_QUEUE1_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE1_RB_RPTR_ADDR_LO                                                                 0x00df
#define regSDMA0_QUEUE1_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA0_QUEUE1_RB_RPTR_ADDR_HI                                                                 0x00e0
#define regSDMA0_QUEUE1_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA0_QUEUE1_IB_CNTL                                                                         0x00e1
#define regSDMA0_QUEUE1_IB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE1_IB_RPTR                                                                         0x00e2
#define regSDMA0_QUEUE1_IB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE1_IB_OFFSET                                                                       0x00e3
#define regSDMA0_QUEUE1_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA0_QUEUE1_IB_BASE_LO                                                                      0x00e4
#define regSDMA0_QUEUE1_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA0_QUEUE1_IB_BASE_HI                                                                      0x00e5
#define regSDMA0_QUEUE1_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE1_IB_SIZE                                                                         0x00e6
#define regSDMA0_QUEUE1_IB_SIZE_BASE_IDX                                                                0
#define regSDMA0_QUEUE1_DOORBELL                                                                        0x00e7
#define regSDMA0_QUEUE1_DOORBELL_BASE_IDX                                                               0
#define regSDMA0_QUEUE1_DOORBELL_LOG                                                                    0x00e8
#define regSDMA0_QUEUE1_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_DOORBELL_OFFSET                                                                 0x00e9
#define regSDMA0_QUEUE1_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA0_QUEUE1_CSA_ADDR_LO                                                                     0x00ea
#define regSDMA0_QUEUE1_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA0_QUEUE1_CSA_ADDR_HI                                                                     0x00eb
#define regSDMA0_QUEUE1_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA0_QUEUE1_SCHEDULE_CNTL                                                                   0x00ec
#define regSDMA0_QUEUE1_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA0_QUEUE1_IB_SUB_REMAIN                                                                   0x00ed
#define regSDMA0_QUEUE1_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA0_QUEUE1_PREEMPT                                                                         0x00ee
#define regSDMA0_QUEUE1_PREEMPT_BASE_IDX                                                                0
#define regSDMA0_QUEUE1_DUMMY_REG                                                                       0x00ef
#define regSDMA0_QUEUE1_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA0_QUEUE1_RB_WPTR_POLL_ADDR_LO                                                            0x00f0
#define regSDMA0_QUEUE1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA0_QUEUE1_RB_WPTR_POLL_ADDR_HI                                                            0x00f1
#define regSDMA0_QUEUE1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA0_QUEUE1_RB_AQL_CNTL                                                                     0x00f2
#define regSDMA0_QUEUE1_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE1_MINOR_PTR_UPDATE                                                                0x00f3
#define regSDMA0_QUEUE1_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA0_QUEUE1_CONTEXT_SWITCH_STATUS                                                           0x00f6
#define regSDMA0_QUEUE1_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA0_QUEUE1_MIDCMD_CNTL                                                                     0x00f7
#define regSDMA0_QUEUE1_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE1_MIDCMD_DATA0                                                                    0x00f8
#define regSDMA0_QUEUE1_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA1                                                                    0x00f9
#define regSDMA0_QUEUE1_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA2                                                                    0x00fa
#define regSDMA0_QUEUE1_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA3                                                                    0x00fb
#define regSDMA0_QUEUE1_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA4                                                                    0x00fc
#define regSDMA0_QUEUE1_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA5                                                                    0x00fd
#define regSDMA0_QUEUE1_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA6                                                                    0x00fe
#define regSDMA0_QUEUE1_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA7                                                                    0x00ff
#define regSDMA0_QUEUE1_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA8                                                                    0x0100
#define regSDMA0_QUEUE1_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA9                                                                    0x0101
#define regSDMA0_QUEUE1_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA0_QUEUE1_MIDCMD_DATA10                                                                   0x0102
#define regSDMA0_QUEUE1_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA0_QUEUE1_WAIT_UNSATISFIED_THD                                                            0x0103
#define regSDMA0_QUEUE1_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA0_QUEUE1_MQD_BASE_ADDR_LO                                                                0x0104
#define regSDMA0_QUEUE1_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA0_QUEUE1_MQD_BASE_ADDR_HI                                                                0x0105
#define regSDMA0_QUEUE1_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA0_QUEUE1_MQD_CONTROL                                                                     0x0106
#define regSDMA0_QUEUE1_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA0_QUEUE1_DEQUEUE_REQUEST                                                                 0x0107
#define regSDMA0_QUEUE1_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA0_QUEUE1_CONTEXT_STATUS                                                                  0x0108
#define regSDMA0_QUEUE1_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA0_QUEUE2_RB_CNTL                                                                         0x0130
#define regSDMA0_QUEUE2_RB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE2_RB_BASE                                                                         0x0131
#define regSDMA0_QUEUE2_RB_BASE_BASE_IDX                                                                0
#define regSDMA0_QUEUE2_RB_BASE_HI                                                                      0x0132
#define regSDMA0_QUEUE2_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE2_RB_RPTR                                                                         0x0133
#define regSDMA0_QUEUE2_RB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE2_RB_RPTR_HI                                                                      0x0134
#define regSDMA0_QUEUE2_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE2_RB_WPTR                                                                         0x0135
#define regSDMA0_QUEUE2_RB_WPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE2_RB_WPTR_HI                                                                      0x0136
#define regSDMA0_QUEUE2_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE2_RB_RPTR_ADDR_LO                                                                 0x0137
#define regSDMA0_QUEUE2_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA0_QUEUE2_RB_RPTR_ADDR_HI                                                                 0x0138
#define regSDMA0_QUEUE2_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA0_QUEUE2_IB_CNTL                                                                         0x0139
#define regSDMA0_QUEUE2_IB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE2_IB_RPTR                                                                         0x013a
#define regSDMA0_QUEUE2_IB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE2_IB_OFFSET                                                                       0x013b
#define regSDMA0_QUEUE2_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA0_QUEUE2_IB_BASE_LO                                                                      0x013c
#define regSDMA0_QUEUE2_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA0_QUEUE2_IB_BASE_HI                                                                      0x013d
#define regSDMA0_QUEUE2_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE2_IB_SIZE                                                                         0x013e
#define regSDMA0_QUEUE2_IB_SIZE_BASE_IDX                                                                0
#define regSDMA0_QUEUE2_DOORBELL                                                                        0x013f
#define regSDMA0_QUEUE2_DOORBELL_BASE_IDX                                                               0
#define regSDMA0_QUEUE2_DOORBELL_LOG                                                                    0x0140
#define regSDMA0_QUEUE2_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_DOORBELL_OFFSET                                                                 0x0141
#define regSDMA0_QUEUE2_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA0_QUEUE2_CSA_ADDR_LO                                                                     0x0142
#define regSDMA0_QUEUE2_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA0_QUEUE2_CSA_ADDR_HI                                                                     0x0143
#define regSDMA0_QUEUE2_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA0_QUEUE2_SCHEDULE_CNTL                                                                   0x0144
#define regSDMA0_QUEUE2_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA0_QUEUE2_IB_SUB_REMAIN                                                                   0x0145
#define regSDMA0_QUEUE2_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA0_QUEUE2_PREEMPT                                                                         0x0146
#define regSDMA0_QUEUE2_PREEMPT_BASE_IDX                                                                0
#define regSDMA0_QUEUE2_DUMMY_REG                                                                       0x0147
#define regSDMA0_QUEUE2_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA0_QUEUE2_RB_WPTR_POLL_ADDR_LO                                                            0x0148
#define regSDMA0_QUEUE2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA0_QUEUE2_RB_WPTR_POLL_ADDR_HI                                                            0x0149
#define regSDMA0_QUEUE2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA0_QUEUE2_RB_AQL_CNTL                                                                     0x014a
#define regSDMA0_QUEUE2_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE2_MINOR_PTR_UPDATE                                                                0x014b
#define regSDMA0_QUEUE2_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA0_QUEUE2_CONTEXT_SWITCH_STATUS                                                           0x014e
#define regSDMA0_QUEUE2_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA0_QUEUE2_MIDCMD_CNTL                                                                     0x014f
#define regSDMA0_QUEUE2_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE2_MIDCMD_DATA0                                                                    0x0150
#define regSDMA0_QUEUE2_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA1                                                                    0x0151
#define regSDMA0_QUEUE2_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA2                                                                    0x0152
#define regSDMA0_QUEUE2_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA3                                                                    0x0153
#define regSDMA0_QUEUE2_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA4                                                                    0x0154
#define regSDMA0_QUEUE2_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA5                                                                    0x0155
#define regSDMA0_QUEUE2_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA6                                                                    0x0156
#define regSDMA0_QUEUE2_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA7                                                                    0x0157
#define regSDMA0_QUEUE2_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA8                                                                    0x0158
#define regSDMA0_QUEUE2_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA9                                                                    0x0159
#define regSDMA0_QUEUE2_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA0_QUEUE2_MIDCMD_DATA10                                                                   0x015a
#define regSDMA0_QUEUE2_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA0_QUEUE2_WAIT_UNSATISFIED_THD                                                            0x015b
#define regSDMA0_QUEUE2_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA0_QUEUE2_MQD_BASE_ADDR_LO                                                                0x015c
#define regSDMA0_QUEUE2_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA0_QUEUE2_MQD_BASE_ADDR_HI                                                                0x015d
#define regSDMA0_QUEUE2_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA0_QUEUE2_MQD_CONTROL                                                                     0x015e
#define regSDMA0_QUEUE2_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA0_QUEUE2_DEQUEUE_REQUEST                                                                 0x015f
#define regSDMA0_QUEUE2_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA0_QUEUE2_CONTEXT_STATUS                                                                  0x0160
#define regSDMA0_QUEUE2_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA0_QUEUE3_RB_CNTL                                                                         0x0188
#define regSDMA0_QUEUE3_RB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE3_RB_BASE                                                                         0x0189
#define regSDMA0_QUEUE3_RB_BASE_BASE_IDX                                                                0
#define regSDMA0_QUEUE3_RB_BASE_HI                                                                      0x018a
#define regSDMA0_QUEUE3_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE3_RB_RPTR                                                                         0x018b
#define regSDMA0_QUEUE3_RB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE3_RB_RPTR_HI                                                                      0x018c
#define regSDMA0_QUEUE3_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE3_RB_WPTR                                                                         0x018d
#define regSDMA0_QUEUE3_RB_WPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE3_RB_WPTR_HI                                                                      0x018e
#define regSDMA0_QUEUE3_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE3_RB_RPTR_ADDR_LO                                                                 0x018f
#define regSDMA0_QUEUE3_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA0_QUEUE3_RB_RPTR_ADDR_HI                                                                 0x0190
#define regSDMA0_QUEUE3_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA0_QUEUE3_IB_CNTL                                                                         0x0191
#define regSDMA0_QUEUE3_IB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE3_IB_RPTR                                                                         0x0192
#define regSDMA0_QUEUE3_IB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE3_IB_OFFSET                                                                       0x0193
#define regSDMA0_QUEUE3_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA0_QUEUE3_IB_BASE_LO                                                                      0x0194
#define regSDMA0_QUEUE3_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA0_QUEUE3_IB_BASE_HI                                                                      0x0195
#define regSDMA0_QUEUE3_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE3_IB_SIZE                                                                         0x0196
#define regSDMA0_QUEUE3_IB_SIZE_BASE_IDX                                                                0
#define regSDMA0_QUEUE3_DOORBELL                                                                        0x0197
#define regSDMA0_QUEUE3_DOORBELL_BASE_IDX                                                               0
#define regSDMA0_QUEUE3_DOORBELL_LOG                                                                    0x0198
#define regSDMA0_QUEUE3_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_DOORBELL_OFFSET                                                                 0x0199
#define regSDMA0_QUEUE3_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA0_QUEUE3_CSA_ADDR_LO                                                                     0x019a
#define regSDMA0_QUEUE3_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA0_QUEUE3_CSA_ADDR_HI                                                                     0x019b
#define regSDMA0_QUEUE3_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA0_QUEUE3_SCHEDULE_CNTL                                                                   0x019c
#define regSDMA0_QUEUE3_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA0_QUEUE3_IB_SUB_REMAIN                                                                   0x019d
#define regSDMA0_QUEUE3_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA0_QUEUE3_PREEMPT                                                                         0x019e
#define regSDMA0_QUEUE3_PREEMPT_BASE_IDX                                                                0
#define regSDMA0_QUEUE3_DUMMY_REG                                                                       0x019f
#define regSDMA0_QUEUE3_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA0_QUEUE3_RB_WPTR_POLL_ADDR_LO                                                            0x01a0
#define regSDMA0_QUEUE3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA0_QUEUE3_RB_WPTR_POLL_ADDR_HI                                                            0x01a1
#define regSDMA0_QUEUE3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA0_QUEUE3_RB_AQL_CNTL                                                                     0x01a2
#define regSDMA0_QUEUE3_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE3_MINOR_PTR_UPDATE                                                                0x01a3
#define regSDMA0_QUEUE3_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA0_QUEUE3_CONTEXT_SWITCH_STATUS                                                           0x01a6
#define regSDMA0_QUEUE3_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA0_QUEUE3_MIDCMD_CNTL                                                                     0x01a7
#define regSDMA0_QUEUE3_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE3_MIDCMD_DATA0                                                                    0x01a8
#define regSDMA0_QUEUE3_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA1                                                                    0x01a9
#define regSDMA0_QUEUE3_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA2                                                                    0x01aa
#define regSDMA0_QUEUE3_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA3                                                                    0x01ab
#define regSDMA0_QUEUE3_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA4                                                                    0x01ac
#define regSDMA0_QUEUE3_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA5                                                                    0x01ad
#define regSDMA0_QUEUE3_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA6                                                                    0x01ae
#define regSDMA0_QUEUE3_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA7                                                                    0x01af
#define regSDMA0_QUEUE3_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA8                                                                    0x01b0
#define regSDMA0_QUEUE3_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA9                                                                    0x01b1
#define regSDMA0_QUEUE3_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA0_QUEUE3_MIDCMD_DATA10                                                                   0x01b2
#define regSDMA0_QUEUE3_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA0_QUEUE3_WAIT_UNSATISFIED_THD                                                            0x01b3
#define regSDMA0_QUEUE3_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA0_QUEUE3_MQD_BASE_ADDR_LO                                                                0x01b4
#define regSDMA0_QUEUE3_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA0_QUEUE3_MQD_BASE_ADDR_HI                                                                0x01b5
#define regSDMA0_QUEUE3_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA0_QUEUE3_MQD_CONTROL                                                                     0x01b6
#define regSDMA0_QUEUE3_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA0_QUEUE3_DEQUEUE_REQUEST                                                                 0x01b7
#define regSDMA0_QUEUE3_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA0_QUEUE3_CONTEXT_STATUS                                                                  0x01b8
#define regSDMA0_QUEUE3_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA0_QUEUE4_RB_CNTL                                                                         0x01e0
#define regSDMA0_QUEUE4_RB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE4_RB_BASE                                                                         0x01e1
#define regSDMA0_QUEUE4_RB_BASE_BASE_IDX                                                                0
#define regSDMA0_QUEUE4_RB_BASE_HI                                                                      0x01e2
#define regSDMA0_QUEUE4_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE4_RB_RPTR                                                                         0x01e3
#define regSDMA0_QUEUE4_RB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE4_RB_RPTR_HI                                                                      0x01e4
#define regSDMA0_QUEUE4_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE4_RB_WPTR                                                                         0x01e5
#define regSDMA0_QUEUE4_RB_WPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE4_RB_WPTR_HI                                                                      0x01e6
#define regSDMA0_QUEUE4_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE4_RB_RPTR_ADDR_LO                                                                 0x01e7
#define regSDMA0_QUEUE4_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA0_QUEUE4_RB_RPTR_ADDR_HI                                                                 0x01e8
#define regSDMA0_QUEUE4_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA0_QUEUE4_IB_CNTL                                                                         0x01e9
#define regSDMA0_QUEUE4_IB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE4_IB_RPTR                                                                         0x01ea
#define regSDMA0_QUEUE4_IB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE4_IB_OFFSET                                                                       0x01eb
#define regSDMA0_QUEUE4_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA0_QUEUE4_IB_BASE_LO                                                                      0x01ec
#define regSDMA0_QUEUE4_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA0_QUEUE4_IB_BASE_HI                                                                      0x01ed
#define regSDMA0_QUEUE4_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE4_IB_SIZE                                                                         0x01ee
#define regSDMA0_QUEUE4_IB_SIZE_BASE_IDX                                                                0
#define regSDMA0_QUEUE4_DOORBELL                                                                        0x01ef
#define regSDMA0_QUEUE4_DOORBELL_BASE_IDX                                                               0
#define regSDMA0_QUEUE4_DOORBELL_LOG                                                                    0x01f0
#define regSDMA0_QUEUE4_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_DOORBELL_OFFSET                                                                 0x01f1
#define regSDMA0_QUEUE4_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA0_QUEUE4_CSA_ADDR_LO                                                                     0x01f2
#define regSDMA0_QUEUE4_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA0_QUEUE4_CSA_ADDR_HI                                                                     0x01f3
#define regSDMA0_QUEUE4_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA0_QUEUE4_SCHEDULE_CNTL                                                                   0x01f4
#define regSDMA0_QUEUE4_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA0_QUEUE4_IB_SUB_REMAIN                                                                   0x01f5
#define regSDMA0_QUEUE4_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA0_QUEUE4_PREEMPT                                                                         0x01f6
#define regSDMA0_QUEUE4_PREEMPT_BASE_IDX                                                                0
#define regSDMA0_QUEUE4_DUMMY_REG                                                                       0x01f7
#define regSDMA0_QUEUE4_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA0_QUEUE4_RB_WPTR_POLL_ADDR_LO                                                            0x01f8
#define regSDMA0_QUEUE4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA0_QUEUE4_RB_WPTR_POLL_ADDR_HI                                                            0x01f9
#define regSDMA0_QUEUE4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA0_QUEUE4_RB_AQL_CNTL                                                                     0x01fa
#define regSDMA0_QUEUE4_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE4_MINOR_PTR_UPDATE                                                                0x01fb
#define regSDMA0_QUEUE4_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA0_QUEUE4_CONTEXT_SWITCH_STATUS                                                           0x01fe
#define regSDMA0_QUEUE4_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA0_QUEUE4_MIDCMD_CNTL                                                                     0x01ff
#define regSDMA0_QUEUE4_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE4_MIDCMD_DATA0                                                                    0x0200
#define regSDMA0_QUEUE4_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA1                                                                    0x0201
#define regSDMA0_QUEUE4_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA2                                                                    0x0202
#define regSDMA0_QUEUE4_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA3                                                                    0x0203
#define regSDMA0_QUEUE4_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA4                                                                    0x0204
#define regSDMA0_QUEUE4_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA5                                                                    0x0205
#define regSDMA0_QUEUE4_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA6                                                                    0x0206
#define regSDMA0_QUEUE4_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA7                                                                    0x0207
#define regSDMA0_QUEUE4_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA8                                                                    0x0208
#define regSDMA0_QUEUE4_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA9                                                                    0x0209
#define regSDMA0_QUEUE4_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA0_QUEUE4_MIDCMD_DATA10                                                                   0x020a
#define regSDMA0_QUEUE4_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA0_QUEUE4_WAIT_UNSATISFIED_THD                                                            0x020b
#define regSDMA0_QUEUE4_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA0_QUEUE4_MQD_BASE_ADDR_LO                                                                0x020c
#define regSDMA0_QUEUE4_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA0_QUEUE4_MQD_BASE_ADDR_HI                                                                0x020d
#define regSDMA0_QUEUE4_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA0_QUEUE4_MQD_CONTROL                                                                     0x020e
#define regSDMA0_QUEUE4_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA0_QUEUE4_DEQUEUE_REQUEST                                                                 0x020f
#define regSDMA0_QUEUE4_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA0_QUEUE4_CONTEXT_STATUS                                                                  0x0210
#define regSDMA0_QUEUE4_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA0_QUEUE5_RB_CNTL                                                                         0x0238
#define regSDMA0_QUEUE5_RB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE5_RB_BASE                                                                         0x0239
#define regSDMA0_QUEUE5_RB_BASE_BASE_IDX                                                                0
#define regSDMA0_QUEUE5_RB_BASE_HI                                                                      0x023a
#define regSDMA0_QUEUE5_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE5_RB_RPTR                                                                         0x023b
#define regSDMA0_QUEUE5_RB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE5_RB_RPTR_HI                                                                      0x023c
#define regSDMA0_QUEUE5_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE5_RB_WPTR                                                                         0x023d
#define regSDMA0_QUEUE5_RB_WPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE5_RB_WPTR_HI                                                                      0x023e
#define regSDMA0_QUEUE5_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE5_RB_RPTR_ADDR_LO                                                                 0x023f
#define regSDMA0_QUEUE5_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA0_QUEUE5_RB_RPTR_ADDR_HI                                                                 0x0240
#define regSDMA0_QUEUE5_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA0_QUEUE5_IB_CNTL                                                                         0x0241
#define regSDMA0_QUEUE5_IB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE5_IB_RPTR                                                                         0x0242
#define regSDMA0_QUEUE5_IB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE5_IB_OFFSET                                                                       0x0243
#define regSDMA0_QUEUE5_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA0_QUEUE5_IB_BASE_LO                                                                      0x0244
#define regSDMA0_QUEUE5_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA0_QUEUE5_IB_BASE_HI                                                                      0x0245
#define regSDMA0_QUEUE5_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE5_IB_SIZE                                                                         0x0246
#define regSDMA0_QUEUE5_IB_SIZE_BASE_IDX                                                                0
#define regSDMA0_QUEUE5_DOORBELL                                                                        0x0247
#define regSDMA0_QUEUE5_DOORBELL_BASE_IDX                                                               0
#define regSDMA0_QUEUE5_DOORBELL_LOG                                                                    0x0248
#define regSDMA0_QUEUE5_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_DOORBELL_OFFSET                                                                 0x0249
#define regSDMA0_QUEUE5_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA0_QUEUE5_CSA_ADDR_LO                                                                     0x024a
#define regSDMA0_QUEUE5_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA0_QUEUE5_CSA_ADDR_HI                                                                     0x024b
#define regSDMA0_QUEUE5_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA0_QUEUE5_SCHEDULE_CNTL                                                                   0x024c
#define regSDMA0_QUEUE5_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA0_QUEUE5_IB_SUB_REMAIN                                                                   0x024d
#define regSDMA0_QUEUE5_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA0_QUEUE5_PREEMPT                                                                         0x024e
#define regSDMA0_QUEUE5_PREEMPT_BASE_IDX                                                                0
#define regSDMA0_QUEUE5_DUMMY_REG                                                                       0x024f
#define regSDMA0_QUEUE5_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA0_QUEUE5_RB_WPTR_POLL_ADDR_LO                                                            0x0250
#define regSDMA0_QUEUE5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA0_QUEUE5_RB_WPTR_POLL_ADDR_HI                                                            0x0251
#define regSDMA0_QUEUE5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA0_QUEUE5_RB_AQL_CNTL                                                                     0x0252
#define regSDMA0_QUEUE5_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE5_MINOR_PTR_UPDATE                                                                0x0253
#define regSDMA0_QUEUE5_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA0_QUEUE5_CONTEXT_SWITCH_STATUS                                                           0x0256
#define regSDMA0_QUEUE5_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA0_QUEUE5_MIDCMD_CNTL                                                                     0x0257
#define regSDMA0_QUEUE5_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE5_MIDCMD_DATA0                                                                    0x0258
#define regSDMA0_QUEUE5_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA1                                                                    0x0259
#define regSDMA0_QUEUE5_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA2                                                                    0x025a
#define regSDMA0_QUEUE5_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA3                                                                    0x025b
#define regSDMA0_QUEUE5_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA4                                                                    0x025c
#define regSDMA0_QUEUE5_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA5                                                                    0x025d
#define regSDMA0_QUEUE5_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA6                                                                    0x025e
#define regSDMA0_QUEUE5_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA7                                                                    0x025f
#define regSDMA0_QUEUE5_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA8                                                                    0x0260
#define regSDMA0_QUEUE5_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA9                                                                    0x0261
#define regSDMA0_QUEUE5_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA0_QUEUE5_MIDCMD_DATA10                                                                   0x0262
#define regSDMA0_QUEUE5_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA0_QUEUE5_WAIT_UNSATISFIED_THD                                                            0x0263
#define regSDMA0_QUEUE5_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA0_QUEUE5_MQD_BASE_ADDR_LO                                                                0x0264
#define regSDMA0_QUEUE5_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA0_QUEUE5_MQD_BASE_ADDR_HI                                                                0x0265
#define regSDMA0_QUEUE5_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA0_QUEUE5_MQD_CONTROL                                                                     0x0266
#define regSDMA0_QUEUE5_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA0_QUEUE5_DEQUEUE_REQUEST                                                                 0x0267
#define regSDMA0_QUEUE5_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA0_QUEUE5_CONTEXT_STATUS                                                                  0x0268
#define regSDMA0_QUEUE5_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA0_QUEUE6_RB_CNTL                                                                         0x0290
#define regSDMA0_QUEUE6_RB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE6_RB_BASE                                                                         0x0291
#define regSDMA0_QUEUE6_RB_BASE_BASE_IDX                                                                0
#define regSDMA0_QUEUE6_RB_BASE_HI                                                                      0x0292
#define regSDMA0_QUEUE6_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE6_RB_RPTR                                                                         0x0293
#define regSDMA0_QUEUE6_RB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE6_RB_RPTR_HI                                                                      0x0294
#define regSDMA0_QUEUE6_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE6_RB_WPTR                                                                         0x0295
#define regSDMA0_QUEUE6_RB_WPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE6_RB_WPTR_HI                                                                      0x0296
#define regSDMA0_QUEUE6_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE6_RB_RPTR_ADDR_LO                                                                 0x0297
#define regSDMA0_QUEUE6_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA0_QUEUE6_RB_RPTR_ADDR_HI                                                                 0x0298
#define regSDMA0_QUEUE6_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA0_QUEUE6_IB_CNTL                                                                         0x0299
#define regSDMA0_QUEUE6_IB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE6_IB_RPTR                                                                         0x029a
#define regSDMA0_QUEUE6_IB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE6_IB_OFFSET                                                                       0x029b
#define regSDMA0_QUEUE6_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA0_QUEUE6_IB_BASE_LO                                                                      0x029c
#define regSDMA0_QUEUE6_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA0_QUEUE6_IB_BASE_HI                                                                      0x029d
#define regSDMA0_QUEUE6_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE6_IB_SIZE                                                                         0x029e
#define regSDMA0_QUEUE6_IB_SIZE_BASE_IDX                                                                0
#define regSDMA0_QUEUE6_DOORBELL                                                                        0x029f
#define regSDMA0_QUEUE6_DOORBELL_BASE_IDX                                                               0
#define regSDMA0_QUEUE6_DOORBELL_LOG                                                                    0x02a0
#define regSDMA0_QUEUE6_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_DOORBELL_OFFSET                                                                 0x02a1
#define regSDMA0_QUEUE6_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA0_QUEUE6_CSA_ADDR_LO                                                                     0x02a2
#define regSDMA0_QUEUE6_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA0_QUEUE6_CSA_ADDR_HI                                                                     0x02a3
#define regSDMA0_QUEUE6_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA0_QUEUE6_SCHEDULE_CNTL                                                                   0x02a4
#define regSDMA0_QUEUE6_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA0_QUEUE6_IB_SUB_REMAIN                                                                   0x02a5
#define regSDMA0_QUEUE6_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA0_QUEUE6_PREEMPT                                                                         0x02a6
#define regSDMA0_QUEUE6_PREEMPT_BASE_IDX                                                                0
#define regSDMA0_QUEUE6_DUMMY_REG                                                                       0x02a7
#define regSDMA0_QUEUE6_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA0_QUEUE6_RB_WPTR_POLL_ADDR_LO                                                            0x02a8
#define regSDMA0_QUEUE6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA0_QUEUE6_RB_WPTR_POLL_ADDR_HI                                                            0x02a9
#define regSDMA0_QUEUE6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA0_QUEUE6_RB_AQL_CNTL                                                                     0x02aa
#define regSDMA0_QUEUE6_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE6_MINOR_PTR_UPDATE                                                                0x02ab
#define regSDMA0_QUEUE6_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA0_QUEUE6_CONTEXT_SWITCH_STATUS                                                           0x02ae
#define regSDMA0_QUEUE6_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA0_QUEUE6_MIDCMD_CNTL                                                                     0x02af
#define regSDMA0_QUEUE6_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE6_MIDCMD_DATA0                                                                    0x02b0
#define regSDMA0_QUEUE6_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA1                                                                    0x02b1
#define regSDMA0_QUEUE6_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA2                                                                    0x02b2
#define regSDMA0_QUEUE6_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA3                                                                    0x02b3
#define regSDMA0_QUEUE6_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA4                                                                    0x02b4
#define regSDMA0_QUEUE6_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA5                                                                    0x02b5
#define regSDMA0_QUEUE6_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA6                                                                    0x02b6
#define regSDMA0_QUEUE6_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA7                                                                    0x02b7
#define regSDMA0_QUEUE6_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA8                                                                    0x02b8
#define regSDMA0_QUEUE6_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA9                                                                    0x02b9
#define regSDMA0_QUEUE6_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA0_QUEUE6_MIDCMD_DATA10                                                                   0x02ba
#define regSDMA0_QUEUE6_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA0_QUEUE6_WAIT_UNSATISFIED_THD                                                            0x02bb
#define regSDMA0_QUEUE6_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA0_QUEUE6_MQD_BASE_ADDR_LO                                                                0x02bc
#define regSDMA0_QUEUE6_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA0_QUEUE6_MQD_BASE_ADDR_HI                                                                0x02bd
#define regSDMA0_QUEUE6_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA0_QUEUE6_MQD_CONTROL                                                                     0x02be
#define regSDMA0_QUEUE6_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA0_QUEUE6_DEQUEUE_REQUEST                                                                 0x02bf
#define regSDMA0_QUEUE6_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA0_QUEUE6_CONTEXT_STATUS                                                                  0x02c0
#define regSDMA0_QUEUE6_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA0_QUEUE7_RB_CNTL                                                                         0x02e8
#define regSDMA0_QUEUE7_RB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE7_RB_BASE                                                                         0x02e9
#define regSDMA0_QUEUE7_RB_BASE_BASE_IDX                                                                0
#define regSDMA0_QUEUE7_RB_BASE_HI                                                                      0x02ea
#define regSDMA0_QUEUE7_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE7_RB_RPTR                                                                         0x02eb
#define regSDMA0_QUEUE7_RB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE7_RB_RPTR_HI                                                                      0x02ec
#define regSDMA0_QUEUE7_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE7_RB_WPTR                                                                         0x02ed
#define regSDMA0_QUEUE7_RB_WPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE7_RB_WPTR_HI                                                                      0x02ee
#define regSDMA0_QUEUE7_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE7_RB_RPTR_ADDR_LO                                                                 0x02ef
#define regSDMA0_QUEUE7_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA0_QUEUE7_RB_RPTR_ADDR_HI                                                                 0x02f0
#define regSDMA0_QUEUE7_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA0_QUEUE7_IB_CNTL                                                                         0x02f1
#define regSDMA0_QUEUE7_IB_CNTL_BASE_IDX                                                                0
#define regSDMA0_QUEUE7_IB_RPTR                                                                         0x02f2
#define regSDMA0_QUEUE7_IB_RPTR_BASE_IDX                                                                0
#define regSDMA0_QUEUE7_IB_OFFSET                                                                       0x02f3
#define regSDMA0_QUEUE7_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA0_QUEUE7_IB_BASE_LO                                                                      0x02f4
#define regSDMA0_QUEUE7_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA0_QUEUE7_IB_BASE_HI                                                                      0x02f5
#define regSDMA0_QUEUE7_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA0_QUEUE7_IB_SIZE                                                                         0x02f6
#define regSDMA0_QUEUE7_IB_SIZE_BASE_IDX                                                                0
#define regSDMA0_QUEUE7_DOORBELL                                                                        0x02f7
#define regSDMA0_QUEUE7_DOORBELL_BASE_IDX                                                               0
#define regSDMA0_QUEUE7_DOORBELL_LOG                                                                    0x02f8
#define regSDMA0_QUEUE7_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_DOORBELL_OFFSET                                                                 0x02f9
#define regSDMA0_QUEUE7_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA0_QUEUE7_CSA_ADDR_LO                                                                     0x02fa
#define regSDMA0_QUEUE7_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA0_QUEUE7_CSA_ADDR_HI                                                                     0x02fb
#define regSDMA0_QUEUE7_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA0_QUEUE7_SCHEDULE_CNTL                                                                   0x02fc
#define regSDMA0_QUEUE7_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA0_QUEUE7_IB_SUB_REMAIN                                                                   0x02fd
#define regSDMA0_QUEUE7_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA0_QUEUE7_PREEMPT                                                                         0x02fe
#define regSDMA0_QUEUE7_PREEMPT_BASE_IDX                                                                0
#define regSDMA0_QUEUE7_DUMMY_REG                                                                       0x02ff
#define regSDMA0_QUEUE7_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA0_QUEUE7_RB_WPTR_POLL_ADDR_LO                                                            0x0300
#define regSDMA0_QUEUE7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA0_QUEUE7_RB_WPTR_POLL_ADDR_HI                                                            0x0301
#define regSDMA0_QUEUE7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA0_QUEUE7_RB_AQL_CNTL                                                                     0x0302
#define regSDMA0_QUEUE7_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE7_MINOR_PTR_UPDATE                                                                0x0303
#define regSDMA0_QUEUE7_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA0_QUEUE7_CONTEXT_SWITCH_STATUS                                                           0x0306
#define regSDMA0_QUEUE7_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA0_QUEUE7_MIDCMD_CNTL                                                                     0x0307
#define regSDMA0_QUEUE7_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA0_QUEUE7_MIDCMD_DATA0                                                                    0x0308
#define regSDMA0_QUEUE7_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA1                                                                    0x0309
#define regSDMA0_QUEUE7_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA2                                                                    0x030a
#define regSDMA0_QUEUE7_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA3                                                                    0x030b
#define regSDMA0_QUEUE7_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA4                                                                    0x030c
#define regSDMA0_QUEUE7_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA5                                                                    0x030d
#define regSDMA0_QUEUE7_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA6                                                                    0x030e
#define regSDMA0_QUEUE7_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA7                                                                    0x030f
#define regSDMA0_QUEUE7_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA8                                                                    0x0310
#define regSDMA0_QUEUE7_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA9                                                                    0x0311
#define regSDMA0_QUEUE7_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA0_QUEUE7_MIDCMD_DATA10                                                                   0x0312
#define regSDMA0_QUEUE7_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA0_QUEUE7_WAIT_UNSATISFIED_THD                                                            0x0313
#define regSDMA0_QUEUE7_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA0_QUEUE7_MQD_BASE_ADDR_LO                                                                0x0314
#define regSDMA0_QUEUE7_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA0_QUEUE7_MQD_BASE_ADDR_HI                                                                0x0315
#define regSDMA0_QUEUE7_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA0_QUEUE7_MQD_CONTROL                                                                     0x0316
#define regSDMA0_QUEUE7_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA0_QUEUE7_DEQUEUE_REQUEST                                                                 0x0317
#define regSDMA0_QUEUE7_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA0_QUEUE7_CONTEXT_STATUS                                                                  0x0318
#define regSDMA0_QUEUE7_CONTEXT_STATUS_BASE_IDX                                                         0


// addressBlock: gc_gfx_cpwd_sdma0_sdmahypdec
// base address: 0x3e200
#define regSDMA0_VM_CTX_LO                                                                              0x5880
#define regSDMA0_VM_CTX_LO_BASE_IDX                                                                     1
#define regSDMA0_VM_CTX_HI                                                                              0x5881
#define regSDMA0_VM_CTX_HI_BASE_IDX                                                                     1
#define regSDMA0_ACTIVE_FCN_ID                                                                          0x5882
#define regSDMA0_ACTIVE_FCN_ID_BASE_IDX                                                                 1
#define regSDMA0_VIRT_RESET_REQ                                                                         0x5884
#define regSDMA0_VIRT_RESET_REQ_BASE_IDX                                                                1
#define regSDMA0_VM_CNTL                                                                                0x588d
#define regSDMA0_VM_CNTL_BASE_IDX                                                                       1
#define regSDMA0_MCU_CNTL                                                                               0x588e
#define regSDMA0_MCU_CNTL_BASE_IDX                                                                      1
#define regSDMA0_IC_BASE_LO                                                                             0x588f
#define regSDMA0_IC_BASE_LO_BASE_IDX                                                                    1
#define regSDMA0_IC_BASE_HI                                                                             0x5890
#define regSDMA0_IC_BASE_HI_BASE_IDX                                                                    1
#define regSDMA0_IC_BASE_CNTL                                                                           0x5891
#define regSDMA0_IC_BASE_CNTL_BASE_IDX                                                                  1
#define regSDMA0_IC_OP_CNTL                                                                             0x5892
#define regSDMA0_IC_OP_CNTL_BASE_IDX                                                                    1
#define regSDMA0_IC_CNTL                                                                                0x5894
#define regSDMA0_IC_CNTL_BASE_IDX                                                                       1


// addressBlock: gc_gfx_cpwd_sdma0_sdmapspdec
// base address: 0x3f200
#define regSDMA0_MCU_DM_FROM_RST_ADDR_OFFSET                                                            0x5cbf
#define regSDMA0_MCU_DM_FROM_RST_ADDR_OFFSET_BASE_IDX                                                   1


// addressBlock: gc_gfx_cpwd_sdma0_sdmaperfsdec
// base address: 0x37880
#define regSDMA0_PERFCNT_PERFCOUNTER0_CFG                                                               0x3e20
#define regSDMA0_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      1
#define regSDMA0_PERFCNT_PERFCOUNTER1_CFG                                                               0x3e21
#define regSDMA0_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      1
#define regSDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x3e22
#define regSDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 1
#define regSDMA0_PERFCNT_MISC_CNTL                                                                      0x3e23
#define regSDMA0_PERFCNT_MISC_CNTL_BASE_IDX                                                             1
#define regSDMA0_PERFCOUNTER0_SELECT                                                                    0x3e24
#define regSDMA0_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define regSDMA0_PERFCOUNTER0_SELECT1                                                                   0x3e25
#define regSDMA0_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define regSDMA0_PERFCOUNTER1_SELECT                                                                    0x3e26
#define regSDMA0_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define regSDMA0_PERFCOUNTER1_SELECT1                                                                   0x3e27
#define regSDMA0_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1


// addressBlock: gc_gfx_cpwd_sdma0_sdmaperfddec
// base address: 0x35980
#define regSDMA0_PERFCNT_PERFCOUNTER_LO                                                                 0x3660
#define regSDMA0_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        1
#define regSDMA0_PERFCNT_PERFCOUNTER_HI                                                                 0x3661
#define regSDMA0_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        1
#define regSDMA0_PERFCOUNTER0_LO                                                                        0x3662
#define regSDMA0_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define regSDMA0_PERFCOUNTER0_HI                                                                        0x3663
#define regSDMA0_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define regSDMA0_PERFCOUNTER1_LO                                                                        0x3664
#define regSDMA0_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define regSDMA0_PERFCOUNTER1_HI                                                                        0x3665
#define regSDMA0_PERFCOUNTER1_HI_BASE_IDX                                                               1


// addressBlock: gc_gfx_cpwd_sdma0_sdmapwrdec
// base address: 0x3c430
#define regGFX_ICG_SDMA0_CTRL                                                                           0x510c
#define regGFX_ICG_SDMA0_CTRL_BASE_IDX                                                                  1


// addressBlock: gc_gfx_cpwd_sdma0_sdmadec:1
// base address: 0x6180
#define regSDMA1_DEC_START                                                                              0x0600
#define regSDMA1_DEC_START_BASE_IDX                                                                     0
#define regSDMA1_MCU_MISC_CNTL                                                                          0x0601
#define regSDMA1_MCU_MISC_CNTL_BASE_IDX                                                                 0
#define regSDMA1_UCODE_REV                                                                              0x0603
#define regSDMA1_UCODE_REV_BASE_IDX                                                                     0
#define regSDMA1_GLOBAL_TIMESTAMP_LO                                                                    0x0605
#define regSDMA1_GLOBAL_TIMESTAMP_LO_BASE_IDX                                                           0
#define regSDMA1_GLOBAL_TIMESTAMP_HI                                                                    0x0606
#define regSDMA1_GLOBAL_TIMESTAMP_HI_BASE_IDX                                                           0
#define regSDMA1_POWER_CNTL                                                                             0x060c
#define regSDMA1_POWER_CNTL_BASE_IDX                                                                    0
#define regSDMA1_CNTL                                                                                   0x060d
#define regSDMA1_CNTL_BASE_IDX                                                                          0
#define regSDMA1_CHICKEN_BITS                                                                           0x060e
#define regSDMA1_CHICKEN_BITS_BASE_IDX                                                                  0
#define regSDMA1_CACHE_CNTL                                                                             0x060f
#define regSDMA1_CACHE_CNTL_BASE_IDX                                                                    0
#define regSDMA1_RB_RPTR_FETCH                                                                          0x0620
#define regSDMA1_RB_RPTR_FETCH_BASE_IDX                                                                 0
#define regSDMA1_RB_RPTR_FETCH_HI                                                                       0x0621
#define regSDMA1_RB_RPTR_FETCH_HI_BASE_IDX                                                              0
#define regSDMA1_IB_OFFSET_FETCH                                                                        0x0622
#define regSDMA1_IB_OFFSET_FETCH_BASE_IDX                                                               0
#define regSDMA1_PROGRAM                                                                                0x0623
#define regSDMA1_PROGRAM_BASE_IDX                                                                       0
#define regSDMA1_STATUS_REG                                                                             0x0624
#define regSDMA1_STATUS_REG_BASE_IDX                                                                    0
#define regSDMA1_STATUS1_REG                                                                            0x0625
#define regSDMA1_STATUS1_REG_BASE_IDX                                                                   0
#define regSDMA1_CNTL1                                                                                  0x0626
#define regSDMA1_CNTL1_BASE_IDX                                                                         0
#define regSDMA1_HBM_PAGE_CONFIG                                                                        0x0627
#define regSDMA1_HBM_PAGE_CONFIG_BASE_IDX                                                               0
#define regSDMA1_FREEZE                                                                                 0x0628
#define regSDMA1_FREEZE_BASE_IDX                                                                        0
#define regSDMA1_PROCESS_QUANTUM0                                                                       0x0629
#define regSDMA1_PROCESS_QUANTUM0_BASE_IDX                                                              0
#define regSDMA1_PROCESS_QUANTUM1                                                                       0x062a
#define regSDMA1_PROCESS_QUANTUM1_BASE_IDX                                                              0
#define regSDMA1_WATCHDOG_CNTL                                                                          0x062b
#define regSDMA1_WATCHDOG_CNTL_BASE_IDX                                                                 0
#define regSDMA1_QUEUE_STATUS0                                                                          0x062c
#define regSDMA1_QUEUE_STATUS0_BASE_IDX                                                                 0
#define regSDMA1_EDC_CONFIG                                                                             0x062d
#define regSDMA1_EDC_CONFIG_BASE_IDX                                                                    0
#define regSDMA1_ID                                                                                     0x062e
#define regSDMA1_ID_BASE_IDX                                                                            0
#define regSDMA1_VERSION                                                                                0x062f
#define regSDMA1_VERSION_BASE_IDX                                                                       0
#define regSDMA1_STATUS2_REG                                                                            0x0630
#define regSDMA1_STATUS2_REG_BASE_IDX                                                                   0
#define regSDMA1_ATOMIC_CNTL                                                                            0x0631
#define regSDMA1_ATOMIC_CNTL_BASE_IDX                                                                   0
#define regSDMA1_ATOMIC_PREOP_LO                                                                        0x0632
#define regSDMA1_ATOMIC_PREOP_LO_BASE_IDX                                                               0
#define regSDMA1_ATOMIC_PREOP_HI                                                                        0x0633
#define regSDMA1_ATOMIC_PREOP_HI_BASE_IDX                                                               0
#define regSDMA1_DCC_CNTL                                                                               0x0634
#define regSDMA1_DCC_CNTL_BASE_IDX                                                                      0
#define regSDMA1_UTCL1_CNTL                                                                             0x0635
#define regSDMA1_UTCL1_CNTL_BASE_IDX                                                                    0
#define regSDMA1_UTCL1_WATERMK                                                                          0x0636
#define regSDMA1_UTCL1_WATERMK_BASE_IDX                                                                 0
#define regSDMA1_UTCL1_TIMEOUT                                                                          0x0637
#define regSDMA1_UTCL1_TIMEOUT_BASE_IDX                                                                 0
#define regSDMA1_UTCL1_PAGE                                                                             0x0638
#define regSDMA1_UTCL1_PAGE_BASE_IDX                                                                    0
#define regSDMA1_EXTERNAL_FROZEN                                                                        0x0639
#define regSDMA1_EXTERNAL_FROZEN_BASE_IDX                                                               0
#define regSDMA1_UTCL1_RD_STATUS                                                                        0x0641
#define regSDMA1_UTCL1_RD_STATUS_BASE_IDX                                                               0
#define regSDMA1_UTCL1_WR_STATUS                                                                        0x0642
#define regSDMA1_UTCL1_WR_STATUS_BASE_IDX                                                               0
#define regSDMA1_UTCL1_INV0                                                                             0x0643
#define regSDMA1_UTCL1_INV0_BASE_IDX                                                                    0
#define regSDMA1_UTCL1_INV1                                                                             0x0644
#define regSDMA1_UTCL1_INV1_BASE_IDX                                                                    0
#define regSDMA1_UTCL1_INV2                                                                             0x0645
#define regSDMA1_UTCL1_INV2_BASE_IDX                                                                    0
#define regSDMA1_UTCL1_RD_XNACK0                                                                        0x0646
#define regSDMA1_UTCL1_RD_XNACK0_BASE_IDX                                                               0
#define regSDMA1_UTCL1_RD_XNACK1                                                                        0x0647
#define regSDMA1_UTCL1_RD_XNACK1_BASE_IDX                                                               0
#define regSDMA1_UTCL1_WR_XNACK0                                                                        0x0648
#define regSDMA1_UTCL1_WR_XNACK0_BASE_IDX                                                               0
#define regSDMA1_UTCL1_WR_XNACK1                                                                        0x0649
#define regSDMA1_UTCL1_WR_XNACK1_BASE_IDX                                                               0
#define regSDMA1_RELAX_ORDERING_LUT                                                                     0x064a
#define regSDMA1_RELAX_ORDERING_LUT_BASE_IDX                                                            0
#define regSDMA1_CHICKEN_BITS_2                                                                         0x064b
#define regSDMA1_CHICKEN_BITS_2_BASE_IDX                                                                0
#define regSDMA1_STATUS3_REG                                                                            0x064c
#define regSDMA1_STATUS3_REG_BASE_IDX                                                                   0
#define regSDMA1_GLOBAL_QUANTUM                                                                         0x064d
#define regSDMA1_GLOBAL_QUANTUM_BASE_IDX                                                                0
#define regSDMA1_ERROR_LOG                                                                              0x064e
#define regSDMA1_ERROR_LOG_BASE_IDX                                                                     0
#define regSDMA1_PUB_DUMMY_REG0                                                                         0x064f
#define regSDMA1_PUB_DUMMY_REG0_BASE_IDX                                                                0
#define regSDMA1_PUB_DUMMY_REG1                                                                         0x0650
#define regSDMA1_PUB_DUMMY_REG1_BASE_IDX                                                                0
#define regSDMA1_PUB_DUMMY_REG2                                                                         0x0651
#define regSDMA1_PUB_DUMMY_REG2_BASE_IDX                                                                0
#define regSDMA1_PUB_DUMMY_REG3                                                                         0x0652
#define regSDMA1_PUB_DUMMY_REG3_BASE_IDX                                                                0
#define regSDMA1_MCU_COUNTER                                                                            0x0653
#define regSDMA1_MCU_COUNTER_BASE_IDX                                                                   0
#define regSDMA1_CRD_CNTL                                                                               0x0654
#define regSDMA1_CRD_CNTL_BASE_IDX                                                                      0
#define regSDMA1_RLC_CGCG_CTRL                                                                          0x0655
#define regSDMA1_RLC_CGCG_CTRL_BASE_IDX                                                                 0
#define regSDMA1_GPU_IOV_VIOLATION_LOG                                                                  0x0656
#define regSDMA1_GPU_IOV_VIOLATION_LOG_BASE_IDX                                                         0
#define regSDMA1_AQL_STATUS                                                                             0x0658
#define regSDMA1_AQL_STATUS_BASE_IDX                                                                    0
#define regSDMA1_TLBI_GCR_CNTL                                                                          0x0660
#define regSDMA1_TLBI_GCR_CNTL_BASE_IDX                                                                 0
#define regSDMA1_INT_STATUS                                                                             0x0661
#define regSDMA1_INT_STATUS_BASE_IDX                                                                    0
#define regSDMA1_GPU_IOV_VIOLATION_LOG2                                                                 0x0662
#define regSDMA1_GPU_IOV_VIOLATION_LOG2_BASE_IDX                                                        0
#define regSDMA1_INVALID_ADDR_LO                                                                        0x0663
#define regSDMA1_INVALID_ADDR_LO_BASE_IDX                                                               0
#define regSDMA1_INVALID_ADDR_HI                                                                        0x0664
#define regSDMA1_INVALID_ADDR_HI_BASE_IDX                                                               0
#define regSDMA1_INVALID_ADDR_SRC                                                                       0x0665
#define regSDMA1_INVALID_ADDR_SRC_BASE_IDX                                                              0
#define regSDMA1_CLOCK_GATING_STATUS                                                                    0x0666
#define regSDMA1_CLOCK_GATING_STATUS_BASE_IDX                                                           0
#define regSDMA1_STATUS4_REG                                                                            0x0667
#define regSDMA1_STATUS4_REG_BASE_IDX                                                                   0
#define regSDMA1_SCRATCH_RAM_DATA                                                                       0x0668
#define regSDMA1_SCRATCH_RAM_DATA_BASE_IDX                                                              0
#define regSDMA1_SCRATCH_RAM_ADDR                                                                       0x0669
#define regSDMA1_SCRATCH_RAM_ADDR_BASE_IDX                                                              0
#define regSDMA1_TIMESTAMP_CNTL                                                                         0x066a
#define regSDMA1_TIMESTAMP_CNTL_BASE_IDX                                                                0
#define regSDMA1_STATUS5_REG                                                                            0x066b
#define regSDMA1_STATUS5_REG_BASE_IDX                                                                   0
#define regSDMA1_QUEUE_RESET_REQ                                                                        0x066c
#define regSDMA1_QUEUE_RESET_REQ_BASE_IDX                                                               0
#define regSDMA1_STATUS6_REG                                                                            0x066d
#define regSDMA1_STATUS6_REG_BASE_IDX                                                                   0
#define regSDMA1_STATUS7_REG                                                                            0x066e
#define regSDMA1_STATUS7_REG_BASE_IDX                                                                   0
#define regSDMA1_STATUS8_REG                                                                            0x066f
#define regSDMA1_STATUS8_REG_BASE_IDX                                                                   0
#define regSDMA1_CE_CTRL                                                                                0x0670
#define regSDMA1_CE_CTRL_BASE_IDX                                                                       0
#define regSDMA1_FED_STATUS                                                                             0x0671
#define regSDMA1_FED_STATUS_BASE_IDX                                                                    0
#define regSDMA1_QUEUE0_RB_CNTL                                                                         0x0680
#define regSDMA1_QUEUE0_RB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE0_RB_BASE                                                                         0x0681
#define regSDMA1_QUEUE0_RB_BASE_BASE_IDX                                                                0
#define regSDMA1_QUEUE0_RB_BASE_HI                                                                      0x0682
#define regSDMA1_QUEUE0_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE0_RB_RPTR                                                                         0x0683
#define regSDMA1_QUEUE0_RB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE0_RB_RPTR_HI                                                                      0x0684
#define regSDMA1_QUEUE0_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE0_RB_WPTR                                                                         0x0685
#define regSDMA1_QUEUE0_RB_WPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE0_RB_WPTR_HI                                                                      0x0686
#define regSDMA1_QUEUE0_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE0_RB_RPTR_ADDR_LO                                                                 0x0687
#define regSDMA1_QUEUE0_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA1_QUEUE0_RB_RPTR_ADDR_HI                                                                 0x0688
#define regSDMA1_QUEUE0_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA1_QUEUE0_IB_CNTL                                                                         0x0689
#define regSDMA1_QUEUE0_IB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE0_IB_RPTR                                                                         0x068a
#define regSDMA1_QUEUE0_IB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE0_IB_OFFSET                                                                       0x068b
#define regSDMA1_QUEUE0_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA1_QUEUE0_IB_BASE_LO                                                                      0x068c
#define regSDMA1_QUEUE0_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA1_QUEUE0_IB_BASE_HI                                                                      0x068d
#define regSDMA1_QUEUE0_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE0_IB_SIZE                                                                         0x068e
#define regSDMA1_QUEUE0_IB_SIZE_BASE_IDX                                                                0
#define regSDMA1_QUEUE0_DOORBELL                                                                        0x068f
#define regSDMA1_QUEUE0_DOORBELL_BASE_IDX                                                               0
#define regSDMA1_QUEUE0_DOORBELL_LOG                                                                    0x0690
#define regSDMA1_QUEUE0_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_DOORBELL_OFFSET                                                                 0x0691
#define regSDMA1_QUEUE0_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA1_QUEUE0_CSA_ADDR_LO                                                                     0x0692
#define regSDMA1_QUEUE0_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA1_QUEUE0_CSA_ADDR_HI                                                                     0x0693
#define regSDMA1_QUEUE0_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA1_QUEUE0_SCHEDULE_CNTL                                                                   0x0694
#define regSDMA1_QUEUE0_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA1_QUEUE0_IB_SUB_REMAIN                                                                   0x0695
#define regSDMA1_QUEUE0_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA1_QUEUE0_PREEMPT                                                                         0x0696
#define regSDMA1_QUEUE0_PREEMPT_BASE_IDX                                                                0
#define regSDMA1_QUEUE0_DUMMY_REG                                                                       0x0697
#define regSDMA1_QUEUE0_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA1_QUEUE0_RB_WPTR_POLL_ADDR_LO                                                            0x0698
#define regSDMA1_QUEUE0_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA1_QUEUE0_RB_WPTR_POLL_ADDR_HI                                                            0x0699
#define regSDMA1_QUEUE0_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA1_QUEUE0_RB_AQL_CNTL                                                                     0x069a
#define regSDMA1_QUEUE0_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE0_MINOR_PTR_UPDATE                                                                0x069b
#define regSDMA1_QUEUE0_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA1_QUEUE0_CONTEXT_SWITCH_STATUS                                                           0x069e
#define regSDMA1_QUEUE0_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA1_QUEUE0_MIDCMD_CNTL                                                                     0x069f
#define regSDMA1_QUEUE0_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE0_MIDCMD_DATA0                                                                    0x06a0
#define regSDMA1_QUEUE0_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA1                                                                    0x06a1
#define regSDMA1_QUEUE0_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA2                                                                    0x06a2
#define regSDMA1_QUEUE0_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA3                                                                    0x06a3
#define regSDMA1_QUEUE0_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA4                                                                    0x06a4
#define regSDMA1_QUEUE0_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA5                                                                    0x06a5
#define regSDMA1_QUEUE0_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA6                                                                    0x06a6
#define regSDMA1_QUEUE0_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA7                                                                    0x06a7
#define regSDMA1_QUEUE0_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA8                                                                    0x06a8
#define regSDMA1_QUEUE0_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA9                                                                    0x06a9
#define regSDMA1_QUEUE0_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA1_QUEUE0_MIDCMD_DATA10                                                                   0x06aa
#define regSDMA1_QUEUE0_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA1_QUEUE0_WAIT_UNSATISFIED_THD                                                            0x06ab
#define regSDMA1_QUEUE0_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA1_QUEUE0_MQD_BASE_ADDR_LO                                                                0x06ac
#define regSDMA1_QUEUE0_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA1_QUEUE0_MQD_BASE_ADDR_HI                                                                0x06ad
#define regSDMA1_QUEUE0_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA1_QUEUE0_MQD_CONTROL                                                                     0x06ae
#define regSDMA1_QUEUE0_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA1_QUEUE0_DEQUEUE_REQUEST                                                                 0x06af
#define regSDMA1_QUEUE0_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA1_QUEUE0_CONTEXT_STATUS                                                                  0x06b0
#define regSDMA1_QUEUE0_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA1_QUEUE1_RB_CNTL                                                                         0x06d8
#define regSDMA1_QUEUE1_RB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE1_RB_BASE                                                                         0x06d9
#define regSDMA1_QUEUE1_RB_BASE_BASE_IDX                                                                0
#define regSDMA1_QUEUE1_RB_BASE_HI                                                                      0x06da
#define regSDMA1_QUEUE1_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE1_RB_RPTR                                                                         0x06db
#define regSDMA1_QUEUE1_RB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE1_RB_RPTR_HI                                                                      0x06dc
#define regSDMA1_QUEUE1_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE1_RB_WPTR                                                                         0x06dd
#define regSDMA1_QUEUE1_RB_WPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE1_RB_WPTR_HI                                                                      0x06de
#define regSDMA1_QUEUE1_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE1_RB_RPTR_ADDR_LO                                                                 0x06df
#define regSDMA1_QUEUE1_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA1_QUEUE1_RB_RPTR_ADDR_HI                                                                 0x06e0
#define regSDMA1_QUEUE1_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA1_QUEUE1_IB_CNTL                                                                         0x06e1
#define regSDMA1_QUEUE1_IB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE1_IB_RPTR                                                                         0x06e2
#define regSDMA1_QUEUE1_IB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE1_IB_OFFSET                                                                       0x06e3
#define regSDMA1_QUEUE1_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA1_QUEUE1_IB_BASE_LO                                                                      0x06e4
#define regSDMA1_QUEUE1_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA1_QUEUE1_IB_BASE_HI                                                                      0x06e5
#define regSDMA1_QUEUE1_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE1_IB_SIZE                                                                         0x06e6
#define regSDMA1_QUEUE1_IB_SIZE_BASE_IDX                                                                0
#define regSDMA1_QUEUE1_DOORBELL                                                                        0x06e7
#define regSDMA1_QUEUE1_DOORBELL_BASE_IDX                                                               0
#define regSDMA1_QUEUE1_DOORBELL_LOG                                                                    0x06e8
#define regSDMA1_QUEUE1_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_DOORBELL_OFFSET                                                                 0x06e9
#define regSDMA1_QUEUE1_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA1_QUEUE1_CSA_ADDR_LO                                                                     0x06ea
#define regSDMA1_QUEUE1_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA1_QUEUE1_CSA_ADDR_HI                                                                     0x06eb
#define regSDMA1_QUEUE1_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA1_QUEUE1_SCHEDULE_CNTL                                                                   0x06ec
#define regSDMA1_QUEUE1_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA1_QUEUE1_IB_SUB_REMAIN                                                                   0x06ed
#define regSDMA1_QUEUE1_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA1_QUEUE1_PREEMPT                                                                         0x06ee
#define regSDMA1_QUEUE1_PREEMPT_BASE_IDX                                                                0
#define regSDMA1_QUEUE1_DUMMY_REG                                                                       0x06ef
#define regSDMA1_QUEUE1_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA1_QUEUE1_RB_WPTR_POLL_ADDR_LO                                                            0x06f0
#define regSDMA1_QUEUE1_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA1_QUEUE1_RB_WPTR_POLL_ADDR_HI                                                            0x06f1
#define regSDMA1_QUEUE1_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA1_QUEUE1_RB_AQL_CNTL                                                                     0x06f2
#define regSDMA1_QUEUE1_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE1_MINOR_PTR_UPDATE                                                                0x06f3
#define regSDMA1_QUEUE1_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA1_QUEUE1_CONTEXT_SWITCH_STATUS                                                           0x06f6
#define regSDMA1_QUEUE1_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA1_QUEUE1_MIDCMD_CNTL                                                                     0x06f7
#define regSDMA1_QUEUE1_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE1_MIDCMD_DATA0                                                                    0x06f8
#define regSDMA1_QUEUE1_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA1                                                                    0x06f9
#define regSDMA1_QUEUE1_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA2                                                                    0x06fa
#define regSDMA1_QUEUE1_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA3                                                                    0x06fb
#define regSDMA1_QUEUE1_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA4                                                                    0x06fc
#define regSDMA1_QUEUE1_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA5                                                                    0x06fd
#define regSDMA1_QUEUE1_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA6                                                                    0x06fe
#define regSDMA1_QUEUE1_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA7                                                                    0x06ff
#define regSDMA1_QUEUE1_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA8                                                                    0x0700
#define regSDMA1_QUEUE1_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA9                                                                    0x0701
#define regSDMA1_QUEUE1_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA1_QUEUE1_MIDCMD_DATA10                                                                   0x0702
#define regSDMA1_QUEUE1_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA1_QUEUE1_WAIT_UNSATISFIED_THD                                                            0x0703
#define regSDMA1_QUEUE1_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA1_QUEUE1_MQD_BASE_ADDR_LO                                                                0x0704
#define regSDMA1_QUEUE1_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA1_QUEUE1_MQD_BASE_ADDR_HI                                                                0x0705
#define regSDMA1_QUEUE1_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA1_QUEUE1_MQD_CONTROL                                                                     0x0706
#define regSDMA1_QUEUE1_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA1_QUEUE1_DEQUEUE_REQUEST                                                                 0x0707
#define regSDMA1_QUEUE1_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA1_QUEUE1_CONTEXT_STATUS                                                                  0x0708
#define regSDMA1_QUEUE1_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA1_QUEUE2_RB_CNTL                                                                         0x0730
#define regSDMA1_QUEUE2_RB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE2_RB_BASE                                                                         0x0731
#define regSDMA1_QUEUE2_RB_BASE_BASE_IDX                                                                0
#define regSDMA1_QUEUE2_RB_BASE_HI                                                                      0x0732
#define regSDMA1_QUEUE2_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE2_RB_RPTR                                                                         0x0733
#define regSDMA1_QUEUE2_RB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE2_RB_RPTR_HI                                                                      0x0734
#define regSDMA1_QUEUE2_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE2_RB_WPTR                                                                         0x0735
#define regSDMA1_QUEUE2_RB_WPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE2_RB_WPTR_HI                                                                      0x0736
#define regSDMA1_QUEUE2_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE2_RB_RPTR_ADDR_LO                                                                 0x0737
#define regSDMA1_QUEUE2_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA1_QUEUE2_RB_RPTR_ADDR_HI                                                                 0x0738
#define regSDMA1_QUEUE2_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA1_QUEUE2_IB_CNTL                                                                         0x0739
#define regSDMA1_QUEUE2_IB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE2_IB_RPTR                                                                         0x073a
#define regSDMA1_QUEUE2_IB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE2_IB_OFFSET                                                                       0x073b
#define regSDMA1_QUEUE2_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA1_QUEUE2_IB_BASE_LO                                                                      0x073c
#define regSDMA1_QUEUE2_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA1_QUEUE2_IB_BASE_HI                                                                      0x073d
#define regSDMA1_QUEUE2_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE2_IB_SIZE                                                                         0x073e
#define regSDMA1_QUEUE2_IB_SIZE_BASE_IDX                                                                0
#define regSDMA1_QUEUE2_DOORBELL                                                                        0x073f
#define regSDMA1_QUEUE2_DOORBELL_BASE_IDX                                                               0
#define regSDMA1_QUEUE2_DOORBELL_LOG                                                                    0x0740
#define regSDMA1_QUEUE2_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_DOORBELL_OFFSET                                                                 0x0741
#define regSDMA1_QUEUE2_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA1_QUEUE2_CSA_ADDR_LO                                                                     0x0742
#define regSDMA1_QUEUE2_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA1_QUEUE2_CSA_ADDR_HI                                                                     0x0743
#define regSDMA1_QUEUE2_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA1_QUEUE2_SCHEDULE_CNTL                                                                   0x0744
#define regSDMA1_QUEUE2_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA1_QUEUE2_IB_SUB_REMAIN                                                                   0x0745
#define regSDMA1_QUEUE2_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA1_QUEUE2_PREEMPT                                                                         0x0746
#define regSDMA1_QUEUE2_PREEMPT_BASE_IDX                                                                0
#define regSDMA1_QUEUE2_DUMMY_REG                                                                       0x0747
#define regSDMA1_QUEUE2_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA1_QUEUE2_RB_WPTR_POLL_ADDR_LO                                                            0x0748
#define regSDMA1_QUEUE2_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA1_QUEUE2_RB_WPTR_POLL_ADDR_HI                                                            0x0749
#define regSDMA1_QUEUE2_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA1_QUEUE2_RB_AQL_CNTL                                                                     0x074a
#define regSDMA1_QUEUE2_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE2_MINOR_PTR_UPDATE                                                                0x074b
#define regSDMA1_QUEUE2_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA1_QUEUE2_CONTEXT_SWITCH_STATUS                                                           0x074e
#define regSDMA1_QUEUE2_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA1_QUEUE2_MIDCMD_CNTL                                                                     0x074f
#define regSDMA1_QUEUE2_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE2_MIDCMD_DATA0                                                                    0x0750
#define regSDMA1_QUEUE2_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA1                                                                    0x0751
#define regSDMA1_QUEUE2_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA2                                                                    0x0752
#define regSDMA1_QUEUE2_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA3                                                                    0x0753
#define regSDMA1_QUEUE2_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA4                                                                    0x0754
#define regSDMA1_QUEUE2_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA5                                                                    0x0755
#define regSDMA1_QUEUE2_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA6                                                                    0x0756
#define regSDMA1_QUEUE2_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA7                                                                    0x0757
#define regSDMA1_QUEUE2_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA8                                                                    0x0758
#define regSDMA1_QUEUE2_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA9                                                                    0x0759
#define regSDMA1_QUEUE2_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA1_QUEUE2_MIDCMD_DATA10                                                                   0x075a
#define regSDMA1_QUEUE2_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA1_QUEUE2_WAIT_UNSATISFIED_THD                                                            0x075b
#define regSDMA1_QUEUE2_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA1_QUEUE2_MQD_BASE_ADDR_LO                                                                0x075c
#define regSDMA1_QUEUE2_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA1_QUEUE2_MQD_BASE_ADDR_HI                                                                0x075d
#define regSDMA1_QUEUE2_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA1_QUEUE2_MQD_CONTROL                                                                     0x075e
#define regSDMA1_QUEUE2_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA1_QUEUE2_DEQUEUE_REQUEST                                                                 0x075f
#define regSDMA1_QUEUE2_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA1_QUEUE2_CONTEXT_STATUS                                                                  0x0760
#define regSDMA1_QUEUE2_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA1_QUEUE3_RB_CNTL                                                                         0x0788
#define regSDMA1_QUEUE3_RB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE3_RB_BASE                                                                         0x0789
#define regSDMA1_QUEUE3_RB_BASE_BASE_IDX                                                                0
#define regSDMA1_QUEUE3_RB_BASE_HI                                                                      0x078a
#define regSDMA1_QUEUE3_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE3_RB_RPTR                                                                         0x078b
#define regSDMA1_QUEUE3_RB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE3_RB_RPTR_HI                                                                      0x078c
#define regSDMA1_QUEUE3_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE3_RB_WPTR                                                                         0x078d
#define regSDMA1_QUEUE3_RB_WPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE3_RB_WPTR_HI                                                                      0x078e
#define regSDMA1_QUEUE3_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE3_RB_RPTR_ADDR_LO                                                                 0x078f
#define regSDMA1_QUEUE3_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA1_QUEUE3_RB_RPTR_ADDR_HI                                                                 0x0790
#define regSDMA1_QUEUE3_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA1_QUEUE3_IB_CNTL                                                                         0x0791
#define regSDMA1_QUEUE3_IB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE3_IB_RPTR                                                                         0x0792
#define regSDMA1_QUEUE3_IB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE3_IB_OFFSET                                                                       0x0793
#define regSDMA1_QUEUE3_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA1_QUEUE3_IB_BASE_LO                                                                      0x0794
#define regSDMA1_QUEUE3_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA1_QUEUE3_IB_BASE_HI                                                                      0x0795
#define regSDMA1_QUEUE3_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE3_IB_SIZE                                                                         0x0796
#define regSDMA1_QUEUE3_IB_SIZE_BASE_IDX                                                                0
#define regSDMA1_QUEUE3_DOORBELL                                                                        0x0797
#define regSDMA1_QUEUE3_DOORBELL_BASE_IDX                                                               0
#define regSDMA1_QUEUE3_DOORBELL_LOG                                                                    0x0798
#define regSDMA1_QUEUE3_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_DOORBELL_OFFSET                                                                 0x0799
#define regSDMA1_QUEUE3_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA1_QUEUE3_CSA_ADDR_LO                                                                     0x079a
#define regSDMA1_QUEUE3_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA1_QUEUE3_CSA_ADDR_HI                                                                     0x079b
#define regSDMA1_QUEUE3_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA1_QUEUE3_SCHEDULE_CNTL                                                                   0x079c
#define regSDMA1_QUEUE3_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA1_QUEUE3_IB_SUB_REMAIN                                                                   0x079d
#define regSDMA1_QUEUE3_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA1_QUEUE3_PREEMPT                                                                         0x079e
#define regSDMA1_QUEUE3_PREEMPT_BASE_IDX                                                                0
#define regSDMA1_QUEUE3_DUMMY_REG                                                                       0x079f
#define regSDMA1_QUEUE3_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA1_QUEUE3_RB_WPTR_POLL_ADDR_LO                                                            0x07a0
#define regSDMA1_QUEUE3_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA1_QUEUE3_RB_WPTR_POLL_ADDR_HI                                                            0x07a1
#define regSDMA1_QUEUE3_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA1_QUEUE3_RB_AQL_CNTL                                                                     0x07a2
#define regSDMA1_QUEUE3_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE3_MINOR_PTR_UPDATE                                                                0x07a3
#define regSDMA1_QUEUE3_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA1_QUEUE3_CONTEXT_SWITCH_STATUS                                                           0x07a6
#define regSDMA1_QUEUE3_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA1_QUEUE3_MIDCMD_CNTL                                                                     0x07a7
#define regSDMA1_QUEUE3_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE3_MIDCMD_DATA0                                                                    0x07a8
#define regSDMA1_QUEUE3_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA1                                                                    0x07a9
#define regSDMA1_QUEUE3_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA2                                                                    0x07aa
#define regSDMA1_QUEUE3_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA3                                                                    0x07ab
#define regSDMA1_QUEUE3_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA4                                                                    0x07ac
#define regSDMA1_QUEUE3_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA5                                                                    0x07ad
#define regSDMA1_QUEUE3_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA6                                                                    0x07ae
#define regSDMA1_QUEUE3_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA7                                                                    0x07af
#define regSDMA1_QUEUE3_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA8                                                                    0x07b0
#define regSDMA1_QUEUE3_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA9                                                                    0x07b1
#define regSDMA1_QUEUE3_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA1_QUEUE3_MIDCMD_DATA10                                                                   0x07b2
#define regSDMA1_QUEUE3_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA1_QUEUE3_WAIT_UNSATISFIED_THD                                                            0x07b3
#define regSDMA1_QUEUE3_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA1_QUEUE3_MQD_BASE_ADDR_LO                                                                0x07b4
#define regSDMA1_QUEUE3_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA1_QUEUE3_MQD_BASE_ADDR_HI                                                                0x07b5
#define regSDMA1_QUEUE3_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA1_QUEUE3_MQD_CONTROL                                                                     0x07b6
#define regSDMA1_QUEUE3_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA1_QUEUE3_DEQUEUE_REQUEST                                                                 0x07b7
#define regSDMA1_QUEUE3_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA1_QUEUE3_CONTEXT_STATUS                                                                  0x07b8
#define regSDMA1_QUEUE3_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA1_QUEUE4_RB_CNTL                                                                         0x07e0
#define regSDMA1_QUEUE4_RB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE4_RB_BASE                                                                         0x07e1
#define regSDMA1_QUEUE4_RB_BASE_BASE_IDX                                                                0
#define regSDMA1_QUEUE4_RB_BASE_HI                                                                      0x07e2
#define regSDMA1_QUEUE4_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE4_RB_RPTR                                                                         0x07e3
#define regSDMA1_QUEUE4_RB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE4_RB_RPTR_HI                                                                      0x07e4
#define regSDMA1_QUEUE4_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE4_RB_WPTR                                                                         0x07e5
#define regSDMA1_QUEUE4_RB_WPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE4_RB_WPTR_HI                                                                      0x07e6
#define regSDMA1_QUEUE4_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE4_RB_RPTR_ADDR_LO                                                                 0x07e7
#define regSDMA1_QUEUE4_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA1_QUEUE4_RB_RPTR_ADDR_HI                                                                 0x07e8
#define regSDMA1_QUEUE4_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA1_QUEUE4_IB_CNTL                                                                         0x07e9
#define regSDMA1_QUEUE4_IB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE4_IB_RPTR                                                                         0x07ea
#define regSDMA1_QUEUE4_IB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE4_IB_OFFSET                                                                       0x07eb
#define regSDMA1_QUEUE4_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA1_QUEUE4_IB_BASE_LO                                                                      0x07ec
#define regSDMA1_QUEUE4_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA1_QUEUE4_IB_BASE_HI                                                                      0x07ed
#define regSDMA1_QUEUE4_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE4_IB_SIZE                                                                         0x07ee
#define regSDMA1_QUEUE4_IB_SIZE_BASE_IDX                                                                0
#define regSDMA1_QUEUE4_DOORBELL                                                                        0x07ef
#define regSDMA1_QUEUE4_DOORBELL_BASE_IDX                                                               0
#define regSDMA1_QUEUE4_DOORBELL_LOG                                                                    0x07f0
#define regSDMA1_QUEUE4_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_DOORBELL_OFFSET                                                                 0x07f1
#define regSDMA1_QUEUE4_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA1_QUEUE4_CSA_ADDR_LO                                                                     0x07f2
#define regSDMA1_QUEUE4_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA1_QUEUE4_CSA_ADDR_HI                                                                     0x07f3
#define regSDMA1_QUEUE4_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA1_QUEUE4_SCHEDULE_CNTL                                                                   0x07f4
#define regSDMA1_QUEUE4_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA1_QUEUE4_IB_SUB_REMAIN                                                                   0x07f5
#define regSDMA1_QUEUE4_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA1_QUEUE4_PREEMPT                                                                         0x07f6
#define regSDMA1_QUEUE4_PREEMPT_BASE_IDX                                                                0
#define regSDMA1_QUEUE4_DUMMY_REG                                                                       0x07f7
#define regSDMA1_QUEUE4_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA1_QUEUE4_RB_WPTR_POLL_ADDR_LO                                                            0x07f8
#define regSDMA1_QUEUE4_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA1_QUEUE4_RB_WPTR_POLL_ADDR_HI                                                            0x07f9
#define regSDMA1_QUEUE4_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA1_QUEUE4_RB_AQL_CNTL                                                                     0x07fa
#define regSDMA1_QUEUE4_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE4_MINOR_PTR_UPDATE                                                                0x07fb
#define regSDMA1_QUEUE4_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA1_QUEUE4_CONTEXT_SWITCH_STATUS                                                           0x07fe
#define regSDMA1_QUEUE4_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA1_QUEUE4_MIDCMD_CNTL                                                                     0x07ff
#define regSDMA1_QUEUE4_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE4_MIDCMD_DATA0                                                                    0x0800
#define regSDMA1_QUEUE4_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA1                                                                    0x0801
#define regSDMA1_QUEUE4_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA2                                                                    0x0802
#define regSDMA1_QUEUE4_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA3                                                                    0x0803
#define regSDMA1_QUEUE4_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA4                                                                    0x0804
#define regSDMA1_QUEUE4_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA5                                                                    0x0805
#define regSDMA1_QUEUE4_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA6                                                                    0x0806
#define regSDMA1_QUEUE4_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA7                                                                    0x0807
#define regSDMA1_QUEUE4_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA8                                                                    0x0808
#define regSDMA1_QUEUE4_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA9                                                                    0x0809
#define regSDMA1_QUEUE4_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA1_QUEUE4_MIDCMD_DATA10                                                                   0x080a
#define regSDMA1_QUEUE4_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA1_QUEUE4_WAIT_UNSATISFIED_THD                                                            0x080b
#define regSDMA1_QUEUE4_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA1_QUEUE4_MQD_BASE_ADDR_LO                                                                0x080c
#define regSDMA1_QUEUE4_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA1_QUEUE4_MQD_BASE_ADDR_HI                                                                0x080d
#define regSDMA1_QUEUE4_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA1_QUEUE4_MQD_CONTROL                                                                     0x080e
#define regSDMA1_QUEUE4_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA1_QUEUE4_DEQUEUE_REQUEST                                                                 0x080f
#define regSDMA1_QUEUE4_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA1_QUEUE4_CONTEXT_STATUS                                                                  0x0810
#define regSDMA1_QUEUE4_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA1_QUEUE5_RB_CNTL                                                                         0x0838
#define regSDMA1_QUEUE5_RB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE5_RB_BASE                                                                         0x0839
#define regSDMA1_QUEUE5_RB_BASE_BASE_IDX                                                                0
#define regSDMA1_QUEUE5_RB_BASE_HI                                                                      0x083a
#define regSDMA1_QUEUE5_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE5_RB_RPTR                                                                         0x083b
#define regSDMA1_QUEUE5_RB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE5_RB_RPTR_HI                                                                      0x083c
#define regSDMA1_QUEUE5_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE5_RB_WPTR                                                                         0x083d
#define regSDMA1_QUEUE5_RB_WPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE5_RB_WPTR_HI                                                                      0x083e
#define regSDMA1_QUEUE5_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE5_RB_RPTR_ADDR_LO                                                                 0x083f
#define regSDMA1_QUEUE5_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA1_QUEUE5_RB_RPTR_ADDR_HI                                                                 0x0840
#define regSDMA1_QUEUE5_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA1_QUEUE5_IB_CNTL                                                                         0x0841
#define regSDMA1_QUEUE5_IB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE5_IB_RPTR                                                                         0x0842
#define regSDMA1_QUEUE5_IB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE5_IB_OFFSET                                                                       0x0843
#define regSDMA1_QUEUE5_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA1_QUEUE5_IB_BASE_LO                                                                      0x0844
#define regSDMA1_QUEUE5_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA1_QUEUE5_IB_BASE_HI                                                                      0x0845
#define regSDMA1_QUEUE5_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE5_IB_SIZE                                                                         0x0846
#define regSDMA1_QUEUE5_IB_SIZE_BASE_IDX                                                                0
#define regSDMA1_QUEUE5_DOORBELL                                                                        0x0847
#define regSDMA1_QUEUE5_DOORBELL_BASE_IDX                                                               0
#define regSDMA1_QUEUE5_DOORBELL_LOG                                                                    0x0848
#define regSDMA1_QUEUE5_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_DOORBELL_OFFSET                                                                 0x0849
#define regSDMA1_QUEUE5_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA1_QUEUE5_CSA_ADDR_LO                                                                     0x084a
#define regSDMA1_QUEUE5_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA1_QUEUE5_CSA_ADDR_HI                                                                     0x084b
#define regSDMA1_QUEUE5_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA1_QUEUE5_SCHEDULE_CNTL                                                                   0x084c
#define regSDMA1_QUEUE5_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA1_QUEUE5_IB_SUB_REMAIN                                                                   0x084d
#define regSDMA1_QUEUE5_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA1_QUEUE5_PREEMPT                                                                         0x084e
#define regSDMA1_QUEUE5_PREEMPT_BASE_IDX                                                                0
#define regSDMA1_QUEUE5_DUMMY_REG                                                                       0x084f
#define regSDMA1_QUEUE5_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA1_QUEUE5_RB_WPTR_POLL_ADDR_LO                                                            0x0850
#define regSDMA1_QUEUE5_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA1_QUEUE5_RB_WPTR_POLL_ADDR_HI                                                            0x0851
#define regSDMA1_QUEUE5_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA1_QUEUE5_RB_AQL_CNTL                                                                     0x0852
#define regSDMA1_QUEUE5_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE5_MINOR_PTR_UPDATE                                                                0x0853
#define regSDMA1_QUEUE5_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA1_QUEUE5_CONTEXT_SWITCH_STATUS                                                           0x0856
#define regSDMA1_QUEUE5_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA1_QUEUE5_MIDCMD_CNTL                                                                     0x0857
#define regSDMA1_QUEUE5_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE5_MIDCMD_DATA0                                                                    0x0858
#define regSDMA1_QUEUE5_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA1                                                                    0x0859
#define regSDMA1_QUEUE5_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA2                                                                    0x085a
#define regSDMA1_QUEUE5_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA3                                                                    0x085b
#define regSDMA1_QUEUE5_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA4                                                                    0x085c
#define regSDMA1_QUEUE5_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA5                                                                    0x085d
#define regSDMA1_QUEUE5_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA6                                                                    0x085e
#define regSDMA1_QUEUE5_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA7                                                                    0x085f
#define regSDMA1_QUEUE5_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA8                                                                    0x0860
#define regSDMA1_QUEUE5_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA9                                                                    0x0861
#define regSDMA1_QUEUE5_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA1_QUEUE5_MIDCMD_DATA10                                                                   0x0862
#define regSDMA1_QUEUE5_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA1_QUEUE5_WAIT_UNSATISFIED_THD                                                            0x0863
#define regSDMA1_QUEUE5_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA1_QUEUE5_MQD_BASE_ADDR_LO                                                                0x0864
#define regSDMA1_QUEUE5_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA1_QUEUE5_MQD_BASE_ADDR_HI                                                                0x0865
#define regSDMA1_QUEUE5_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA1_QUEUE5_MQD_CONTROL                                                                     0x0866
#define regSDMA1_QUEUE5_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA1_QUEUE5_DEQUEUE_REQUEST                                                                 0x0867
#define regSDMA1_QUEUE5_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA1_QUEUE5_CONTEXT_STATUS                                                                  0x0868
#define regSDMA1_QUEUE5_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA1_QUEUE6_RB_CNTL                                                                         0x0890
#define regSDMA1_QUEUE6_RB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE6_RB_BASE                                                                         0x0891
#define regSDMA1_QUEUE6_RB_BASE_BASE_IDX                                                                0
#define regSDMA1_QUEUE6_RB_BASE_HI                                                                      0x0892
#define regSDMA1_QUEUE6_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE6_RB_RPTR                                                                         0x0893
#define regSDMA1_QUEUE6_RB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE6_RB_RPTR_HI                                                                      0x0894
#define regSDMA1_QUEUE6_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE6_RB_WPTR                                                                         0x0895
#define regSDMA1_QUEUE6_RB_WPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE6_RB_WPTR_HI                                                                      0x0896
#define regSDMA1_QUEUE6_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE6_RB_RPTR_ADDR_LO                                                                 0x0897
#define regSDMA1_QUEUE6_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA1_QUEUE6_RB_RPTR_ADDR_HI                                                                 0x0898
#define regSDMA1_QUEUE6_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA1_QUEUE6_IB_CNTL                                                                         0x0899
#define regSDMA1_QUEUE6_IB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE6_IB_RPTR                                                                         0x089a
#define regSDMA1_QUEUE6_IB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE6_IB_OFFSET                                                                       0x089b
#define regSDMA1_QUEUE6_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA1_QUEUE6_IB_BASE_LO                                                                      0x089c
#define regSDMA1_QUEUE6_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA1_QUEUE6_IB_BASE_HI                                                                      0x089d
#define regSDMA1_QUEUE6_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE6_IB_SIZE                                                                         0x089e
#define regSDMA1_QUEUE6_IB_SIZE_BASE_IDX                                                                0
#define regSDMA1_QUEUE6_DOORBELL                                                                        0x089f
#define regSDMA1_QUEUE6_DOORBELL_BASE_IDX                                                               0
#define regSDMA1_QUEUE6_DOORBELL_LOG                                                                    0x08a0
#define regSDMA1_QUEUE6_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_DOORBELL_OFFSET                                                                 0x08a1
#define regSDMA1_QUEUE6_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA1_QUEUE6_CSA_ADDR_LO                                                                     0x08a2
#define regSDMA1_QUEUE6_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA1_QUEUE6_CSA_ADDR_HI                                                                     0x08a3
#define regSDMA1_QUEUE6_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA1_QUEUE6_SCHEDULE_CNTL                                                                   0x08a4
#define regSDMA1_QUEUE6_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA1_QUEUE6_IB_SUB_REMAIN                                                                   0x08a5
#define regSDMA1_QUEUE6_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA1_QUEUE6_PREEMPT                                                                         0x08a6
#define regSDMA1_QUEUE6_PREEMPT_BASE_IDX                                                                0
#define regSDMA1_QUEUE6_DUMMY_REG                                                                       0x08a7
#define regSDMA1_QUEUE6_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA1_QUEUE6_RB_WPTR_POLL_ADDR_LO                                                            0x08a8
#define regSDMA1_QUEUE6_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA1_QUEUE6_RB_WPTR_POLL_ADDR_HI                                                            0x08a9
#define regSDMA1_QUEUE6_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA1_QUEUE6_RB_AQL_CNTL                                                                     0x08aa
#define regSDMA1_QUEUE6_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE6_MINOR_PTR_UPDATE                                                                0x08ab
#define regSDMA1_QUEUE6_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA1_QUEUE6_CONTEXT_SWITCH_STATUS                                                           0x08ae
#define regSDMA1_QUEUE6_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA1_QUEUE6_MIDCMD_CNTL                                                                     0x08af
#define regSDMA1_QUEUE6_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE6_MIDCMD_DATA0                                                                    0x08b0
#define regSDMA1_QUEUE6_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA1                                                                    0x08b1
#define regSDMA1_QUEUE6_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA2                                                                    0x08b2
#define regSDMA1_QUEUE6_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA3                                                                    0x08b3
#define regSDMA1_QUEUE6_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA4                                                                    0x08b4
#define regSDMA1_QUEUE6_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA5                                                                    0x08b5
#define regSDMA1_QUEUE6_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA6                                                                    0x08b6
#define regSDMA1_QUEUE6_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA7                                                                    0x08b7
#define regSDMA1_QUEUE6_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA8                                                                    0x08b8
#define regSDMA1_QUEUE6_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA9                                                                    0x08b9
#define regSDMA1_QUEUE6_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA1_QUEUE6_MIDCMD_DATA10                                                                   0x08ba
#define regSDMA1_QUEUE6_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA1_QUEUE6_WAIT_UNSATISFIED_THD                                                            0x08bb
#define regSDMA1_QUEUE6_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA1_QUEUE6_MQD_BASE_ADDR_LO                                                                0x08bc
#define regSDMA1_QUEUE6_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA1_QUEUE6_MQD_BASE_ADDR_HI                                                                0x08bd
#define regSDMA1_QUEUE6_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA1_QUEUE6_MQD_CONTROL                                                                     0x08be
#define regSDMA1_QUEUE6_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA1_QUEUE6_DEQUEUE_REQUEST                                                                 0x08bf
#define regSDMA1_QUEUE6_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA1_QUEUE6_CONTEXT_STATUS                                                                  0x08c0
#define regSDMA1_QUEUE6_CONTEXT_STATUS_BASE_IDX                                                         0
#define regSDMA1_QUEUE7_RB_CNTL                                                                         0x08e8
#define regSDMA1_QUEUE7_RB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE7_RB_BASE                                                                         0x08e9
#define regSDMA1_QUEUE7_RB_BASE_BASE_IDX                                                                0
#define regSDMA1_QUEUE7_RB_BASE_HI                                                                      0x08ea
#define regSDMA1_QUEUE7_RB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE7_RB_RPTR                                                                         0x08eb
#define regSDMA1_QUEUE7_RB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE7_RB_RPTR_HI                                                                      0x08ec
#define regSDMA1_QUEUE7_RB_RPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE7_RB_WPTR                                                                         0x08ed
#define regSDMA1_QUEUE7_RB_WPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE7_RB_WPTR_HI                                                                      0x08ee
#define regSDMA1_QUEUE7_RB_WPTR_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE7_RB_RPTR_ADDR_LO                                                                 0x08ef
#define regSDMA1_QUEUE7_RB_RPTR_ADDR_LO_BASE_IDX                                                        0
#define regSDMA1_QUEUE7_RB_RPTR_ADDR_HI                                                                 0x08f0
#define regSDMA1_QUEUE7_RB_RPTR_ADDR_HI_BASE_IDX                                                        0
#define regSDMA1_QUEUE7_IB_CNTL                                                                         0x08f1
#define regSDMA1_QUEUE7_IB_CNTL_BASE_IDX                                                                0
#define regSDMA1_QUEUE7_IB_RPTR                                                                         0x08f2
#define regSDMA1_QUEUE7_IB_RPTR_BASE_IDX                                                                0
#define regSDMA1_QUEUE7_IB_OFFSET                                                                       0x08f3
#define regSDMA1_QUEUE7_IB_OFFSET_BASE_IDX                                                              0
#define regSDMA1_QUEUE7_IB_BASE_LO                                                                      0x08f4
#define regSDMA1_QUEUE7_IB_BASE_LO_BASE_IDX                                                             0
#define regSDMA1_QUEUE7_IB_BASE_HI                                                                      0x08f5
#define regSDMA1_QUEUE7_IB_BASE_HI_BASE_IDX                                                             0
#define regSDMA1_QUEUE7_IB_SIZE                                                                         0x08f6
#define regSDMA1_QUEUE7_IB_SIZE_BASE_IDX                                                                0
#define regSDMA1_QUEUE7_DOORBELL                                                                        0x08f7
#define regSDMA1_QUEUE7_DOORBELL_BASE_IDX                                                               0
#define regSDMA1_QUEUE7_DOORBELL_LOG                                                                    0x08f8
#define regSDMA1_QUEUE7_DOORBELL_LOG_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_DOORBELL_OFFSET                                                                 0x08f9
#define regSDMA1_QUEUE7_DOORBELL_OFFSET_BASE_IDX                                                        0
#define regSDMA1_QUEUE7_CSA_ADDR_LO                                                                     0x08fa
#define regSDMA1_QUEUE7_CSA_ADDR_LO_BASE_IDX                                                            0
#define regSDMA1_QUEUE7_CSA_ADDR_HI                                                                     0x08fb
#define regSDMA1_QUEUE7_CSA_ADDR_HI_BASE_IDX                                                            0
#define regSDMA1_QUEUE7_SCHEDULE_CNTL                                                                   0x08fc
#define regSDMA1_QUEUE7_SCHEDULE_CNTL_BASE_IDX                                                          0
#define regSDMA1_QUEUE7_IB_SUB_REMAIN                                                                   0x08fd
#define regSDMA1_QUEUE7_IB_SUB_REMAIN_BASE_IDX                                                          0
#define regSDMA1_QUEUE7_PREEMPT                                                                         0x08fe
#define regSDMA1_QUEUE7_PREEMPT_BASE_IDX                                                                0
#define regSDMA1_QUEUE7_DUMMY_REG                                                                       0x08ff
#define regSDMA1_QUEUE7_DUMMY_REG_BASE_IDX                                                              0
#define regSDMA1_QUEUE7_RB_WPTR_POLL_ADDR_LO                                                            0x0900
#define regSDMA1_QUEUE7_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                   0
#define regSDMA1_QUEUE7_RB_WPTR_POLL_ADDR_HI                                                            0x0901
#define regSDMA1_QUEUE7_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                   0
#define regSDMA1_QUEUE7_RB_AQL_CNTL                                                                     0x0902
#define regSDMA1_QUEUE7_RB_AQL_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE7_MINOR_PTR_UPDATE                                                                0x0903
#define regSDMA1_QUEUE7_MINOR_PTR_UPDATE_BASE_IDX                                                       0
#define regSDMA1_QUEUE7_CONTEXT_SWITCH_STATUS                                                           0x0906
#define regSDMA1_QUEUE7_CONTEXT_SWITCH_STATUS_BASE_IDX                                                  0
#define regSDMA1_QUEUE7_MIDCMD_CNTL                                                                     0x0907
#define regSDMA1_QUEUE7_MIDCMD_CNTL_BASE_IDX                                                            0
#define regSDMA1_QUEUE7_MIDCMD_DATA0                                                                    0x0908
#define regSDMA1_QUEUE7_MIDCMD_DATA0_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA1                                                                    0x0909
#define regSDMA1_QUEUE7_MIDCMD_DATA1_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA2                                                                    0x090a
#define regSDMA1_QUEUE7_MIDCMD_DATA2_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA3                                                                    0x090b
#define regSDMA1_QUEUE7_MIDCMD_DATA3_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA4                                                                    0x090c
#define regSDMA1_QUEUE7_MIDCMD_DATA4_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA5                                                                    0x090d
#define regSDMA1_QUEUE7_MIDCMD_DATA5_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA6                                                                    0x090e
#define regSDMA1_QUEUE7_MIDCMD_DATA6_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA7                                                                    0x090f
#define regSDMA1_QUEUE7_MIDCMD_DATA7_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA8                                                                    0x0910
#define regSDMA1_QUEUE7_MIDCMD_DATA8_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA9                                                                    0x0911
#define regSDMA1_QUEUE7_MIDCMD_DATA9_BASE_IDX                                                           0
#define regSDMA1_QUEUE7_MIDCMD_DATA10                                                                   0x0912
#define regSDMA1_QUEUE7_MIDCMD_DATA10_BASE_IDX                                                          0
#define regSDMA1_QUEUE7_WAIT_UNSATISFIED_THD                                                            0x0913
#define regSDMA1_QUEUE7_WAIT_UNSATISFIED_THD_BASE_IDX                                                   0
#define regSDMA1_QUEUE7_MQD_BASE_ADDR_LO                                                                0x0914
#define regSDMA1_QUEUE7_MQD_BASE_ADDR_LO_BASE_IDX                                                       0
#define regSDMA1_QUEUE7_MQD_BASE_ADDR_HI                                                                0x0915
#define regSDMA1_QUEUE7_MQD_BASE_ADDR_HI_BASE_IDX                                                       0
#define regSDMA1_QUEUE7_MQD_CONTROL                                                                     0x0916
#define regSDMA1_QUEUE7_MQD_CONTROL_BASE_IDX                                                            0
#define regSDMA1_QUEUE7_DEQUEUE_REQUEST                                                                 0x0917
#define regSDMA1_QUEUE7_DEQUEUE_REQUEST_BASE_IDX                                                        0
#define regSDMA1_QUEUE7_CONTEXT_STATUS                                                                  0x0918
#define regSDMA1_QUEUE7_CONTEXT_STATUS_BASE_IDX                                                         0


// addressBlock: gc_gfx_cpwd_sdma0_sdmahypdec:1
// base address: 0x3e280
#define regSDMA1_VM_CTX_LO                                                                              0x58a0
#define regSDMA1_VM_CTX_LO_BASE_IDX                                                                     1
#define regSDMA1_VM_CTX_HI                                                                              0x58a1
#define regSDMA1_VM_CTX_HI_BASE_IDX                                                                     1
#define regSDMA1_ACTIVE_FCN_ID                                                                          0x58a2
#define regSDMA1_ACTIVE_FCN_ID_BASE_IDX                                                                 1
#define regSDMA1_VIRT_RESET_REQ                                                                         0x58a4
#define regSDMA1_VIRT_RESET_REQ_BASE_IDX                                                                1
#define regSDMA1_VM_CNTL                                                                                0x58ad
#define regSDMA1_VM_CNTL_BASE_IDX                                                                       1
#define regSDMA1_MCU_CNTL                                                                               0x58ae
#define regSDMA1_MCU_CNTL_BASE_IDX                                                                      1
#define regSDMA1_IC_BASE_LO                                                                             0x58af
#define regSDMA1_IC_BASE_LO_BASE_IDX                                                                    1
#define regSDMA1_IC_BASE_HI                                                                             0x58b0
#define regSDMA1_IC_BASE_HI_BASE_IDX                                                                    1
#define regSDMA1_IC_BASE_CNTL                                                                           0x58b1
#define regSDMA1_IC_BASE_CNTL_BASE_IDX                                                                  1
#define regSDMA1_IC_OP_CNTL                                                                             0x58b2
#define regSDMA1_IC_OP_CNTL_BASE_IDX                                                                    1
#define regSDMA1_IC_CNTL                                                                                0x58b4
#define regSDMA1_IC_CNTL_BASE_IDX                                                                       1


// addressBlock: gc_gfx_cpwd_sdma0_sdmapspdec:1
// base address: 0x3f340
#define regSDMA1_MCU_DM_FROM_RST_ADDR_OFFSET                                                            0x5d0f
#define regSDMA1_MCU_DM_FROM_RST_ADDR_OFFSET_BASE_IDX                                                   1


// addressBlock: gc_gfx_cpwd_sdma0_sdmaperfsdec:1
// base address: 0x378b0
#define regSDMA1_PERFCNT_PERFCOUNTER0_CFG                                                               0x3e2c
#define regSDMA1_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                      1
#define regSDMA1_PERFCNT_PERFCOUNTER1_CFG                                                               0x3e2d
#define regSDMA1_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                      1
#define regSDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                          0x3e2e
#define regSDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                 1
#define regSDMA1_PERFCNT_MISC_CNTL                                                                      0x3e2f
#define regSDMA1_PERFCNT_MISC_CNTL_BASE_IDX                                                             1
#define regSDMA1_PERFCOUNTER0_SELECT                                                                    0x3e30
#define regSDMA1_PERFCOUNTER0_SELECT_BASE_IDX                                                           1
#define regSDMA1_PERFCOUNTER0_SELECT1                                                                   0x3e31
#define regSDMA1_PERFCOUNTER0_SELECT1_BASE_IDX                                                          1
#define regSDMA1_PERFCOUNTER1_SELECT                                                                    0x3e32
#define regSDMA1_PERFCOUNTER1_SELECT_BASE_IDX                                                           1
#define regSDMA1_PERFCOUNTER1_SELECT1                                                                   0x3e33
#define regSDMA1_PERFCOUNTER1_SELECT1_BASE_IDX                                                          1


// addressBlock: gc_gfx_cpwd_sdma0_sdmaperfddec:1
// base address: 0x359b0
#define regSDMA1_PERFCNT_PERFCOUNTER_LO                                                                 0x366c
#define regSDMA1_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                        1
#define regSDMA1_PERFCNT_PERFCOUNTER_HI                                                                 0x366d
#define regSDMA1_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                        1
#define regSDMA1_PERFCOUNTER0_LO                                                                        0x366e
#define regSDMA1_PERFCOUNTER0_LO_BASE_IDX                                                               1
#define regSDMA1_PERFCOUNTER0_HI                                                                        0x366f
#define regSDMA1_PERFCOUNTER0_HI_BASE_IDX                                                               1
#define regSDMA1_PERFCOUNTER1_LO                                                                        0x3670
#define regSDMA1_PERFCOUNTER1_LO_BASE_IDX                                                               1
#define regSDMA1_PERFCOUNTER1_HI                                                                        0x3671
#define regSDMA1_PERFCOUNTER1_HI_BASE_IDX                                                               1


// addressBlock: gc_gfx_cpwd_sdma0_sdmapwrdec:1
// base address: 0x3c434
#define regGFX_ICG_SDMA1_CTRL                                                                           0x510d
#define regGFX_ICG_SDMA1_CTRL_BASE_IDX                                                                  1


// addressBlock: gc_gfx_cpwd_cpwd_grbmdec
// base address: 0x8000
#define regGRBM_CNTL                                                                                    0x0da0
#define regGRBM_CNTL_BASE_IDX                                                                           0
#define regGRBM_SKEW_CNTL                                                                               0x0da1
#define regGRBM_SKEW_CNTL_BASE_IDX                                                                      0
#define regGRBM_STATUS2                                                                                 0x0da2
#define regGRBM_STATUS2_BASE_IDX                                                                        0
#define regGRBM_PWR_CNTL                                                                                0x0da3
#define regGRBM_PWR_CNTL_BASE_IDX                                                                       0
#define regGRBM_STATUS                                                                                  0x0da4
#define regGRBM_STATUS_BASE_IDX                                                                         0
#define regGRBM_STATUS_SE0                                                                              0x0da5
#define regGRBM_STATUS_SE0_BASE_IDX                                                                     0
#define regGRBM_STATUS_SE1                                                                              0x0da6
#define regGRBM_STATUS_SE1_BASE_IDX                                                                     0
#define regGRBM_STATUS3                                                                                 0x0da7
#define regGRBM_STATUS3_BASE_IDX                                                                        0
#define regGRBM_SOFT_RESET                                                                              0x0da8
#define regGRBM_SOFT_RESET_BASE_IDX                                                                     0
#define regGRBM_GFX_CLKEN_CNTL                                                                          0x0dac
#define regGRBM_GFX_CLKEN_CNTL_BASE_IDX                                                                 0
#define regGRBM_WAIT_IDLE_CLOCKS                                                                        0x0dad
#define regGRBM_WAIT_IDLE_CLOCKS_BASE_IDX                                                               0
#define regGRBM_STATUS_SE2                                                                              0x0dae
#define regGRBM_STATUS_SE2_BASE_IDX                                                                     0
#define regGRBM_STATUS_SE3                                                                              0x0daf
#define regGRBM_STATUS_SE3_BASE_IDX                                                                     0
#define regGRBM_READ_ERROR                                                                              0x0db6
#define regGRBM_READ_ERROR_BASE_IDX                                                                     0
#define regGRBM_READ_ERROR2                                                                             0x0db7
#define regGRBM_READ_ERROR2_BASE_IDX                                                                    0
#define regGRBM_INT_CNTL                                                                                0x0db8
#define regGRBM_INT_CNTL_BASE_IDX                                                                       0
#define regGRBM_TRAP_OP                                                                                 0x0db9
#define regGRBM_TRAP_OP_BASE_IDX                                                                        0
#define regGRBM_TRAP_ADDR                                                                               0x0dba
#define regGRBM_TRAP_ADDR_BASE_IDX                                                                      0
#define regGRBM_TRAP_ADDR_MSK                                                                           0x0dbb
#define regGRBM_TRAP_ADDR_MSK_BASE_IDX                                                                  0
#define regGRBM_TRAP_WD                                                                                 0x0dbc
#define regGRBM_TRAP_WD_BASE_IDX                                                                        0
#define regGRBM_TRAP_WD_MSK                                                                             0x0dbd
#define regGRBM_TRAP_WD_MSK_BASE_IDX                                                                    0
#define regGRBM_DSM_BYPASS                                                                              0x0dbe
#define regGRBM_DSM_BYPASS_BASE_IDX                                                                     0
#define regGRBM_WRITE_ERROR                                                                             0x0dbf
#define regGRBM_WRITE_ERROR_BASE_IDX                                                                    0
#define regGRBM_CHIP_REVISION                                                                           0x0dc1
#define regGRBM_CHIP_REVISION_BASE_IDX                                                                  0
#define regGRBM_IH_CREDIT                                                                               0x0dc4
#define regGRBM_IH_CREDIT_BASE_IDX                                                                      0
#define regGRBM_PWR_CNTL2                                                                               0x0dc5
#define regGRBM_PWR_CNTL2_BASE_IDX                                                                      0
#define regGRBM_UTCL2_INVAL_RANGE_START                                                                 0x0dc6
#define regGRBM_UTCL2_INVAL_RANGE_START_BASE_IDX                                                        0
#define regGRBM_UTCL2_INVAL_RANGE_END                                                                   0x0dc7
#define regGRBM_UTCL2_INVAL_RANGE_END_BASE_IDX                                                          0
#define regGRBM_INVALID_PIPE                                                                            0x0dc9
#define regGRBM_INVALID_PIPE_BASE_IDX                                                                   0
#define regGRBM_FENCE_RANGE0                                                                            0x0dca
#define regGRBM_FENCE_RANGE0_BASE_IDX                                                                   0
#define regGRBM_FENCE_RANGE1                                                                            0x0dcb
#define regGRBM_FENCE_RANGE1_BASE_IDX                                                                   0
#define regGRBM_CHICKEN_BITS0                                                                           0x0dcc
#define regGRBM_CHICKEN_BITS0_BASE_IDX                                                                  0
#define regGRBM_CHICKEN_BITS1                                                                           0x0dcd
#define regGRBM_CHICKEN_BITS1_BASE_IDX                                                                  0
#define regCC_GC_FULL_SA_UNIT_DISABLE                                                                   0x0dd9
#define regCC_GC_FULL_SA_UNIT_DISABLE_BASE_IDX                                                          0
#define regGRBM_SCRATCH_REG0                                                                            0x0de0
#define regGRBM_SCRATCH_REG0_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG1                                                                            0x0de1
#define regGRBM_SCRATCH_REG1_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG2                                                                            0x0de2
#define regGRBM_SCRATCH_REG2_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG3                                                                            0x0de3
#define regGRBM_SCRATCH_REG3_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG4                                                                            0x0de4
#define regGRBM_SCRATCH_REG4_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG5                                                                            0x0de5
#define regGRBM_SCRATCH_REG5_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG6                                                                            0x0de6
#define regGRBM_SCRATCH_REG6_BASE_IDX                                                                   0
#define regGRBM_SCRATCH_REG7                                                                            0x0de7
#define regGRBM_SCRATCH_REG7_BASE_IDX                                                                   0
#define regGRBM_INTF_CNTL                                                                               0x0df6
#define regGRBM_INTF_CNTL_BASE_IDX                                                                      0


// addressBlock: gc_gfx_cpwd_cpwd_cpdec
// base address: 0x8200
#define regCP_CPC_DEBUG_CNTL                                                                            0x0e20
#define regCP_CPC_DEBUG_CNTL_BASE_IDX                                                                   0
#define regCP_CPC_DEBUG_DATA                                                                            0x0e21
#define regCP_CPC_DEBUG_DATA_BASE_IDX                                                                   0
#define regCP_CPF_DEBUG_CNTL                                                                            0x0e22
#define regCP_CPF_DEBUG_CNTL_BASE_IDX                                                                   0
#define regCP_CPC_STATUS                                                                                0x0e24
#define regCP_CPC_STATUS_BASE_IDX                                                                       0
#define regCP_CPC_BUSY_STAT                                                                             0x0e25
#define regCP_CPC_BUSY_STAT_BASE_IDX                                                                    0
#define regCP_CPC_STALLED_STAT1                                                                         0x0e26
#define regCP_CPC_STALLED_STAT1_BASE_IDX                                                                0
#define regCP_CPF_STATUS                                                                                0x0e27
#define regCP_CPF_STATUS_BASE_IDX                                                                       0
#define regCP_CPF_BUSY_STAT                                                                             0x0e28
#define regCP_CPF_BUSY_STAT_BASE_IDX                                                                    0
#define regCP_CPF_STALLED_STAT1                                                                         0x0e29
#define regCP_CPF_STALLED_STAT1_BASE_IDX                                                                0
#define regCP_CPC_BUSY_STAT2                                                                            0x0e2a
#define regCP_CPC_BUSY_STAT2_BASE_IDX                                                                   0
#define regCP_CPC_GRBM_FREE_COUNT                                                                       0x0e2b
#define regCP_CPC_GRBM_FREE_COUNT_BASE_IDX                                                              0
#define regCP_CPC_PRIV_VIOLATION_ADDR                                                                   0x0e2c
#define regCP_CPC_PRIV_VIOLATION_ADDR_BASE_IDX                                                          0
#define regCP_CPC_PRIV_VIOLATION_ADDR_HI                                                                0x0e2d
#define regCP_CPC_PRIV_VIOLATION_ADDR_HI_BASE_IDX                                                       0
#define regCP_MEC_ME1_HEADER_DUMP                                                                       0x0e2e
#define regCP_MEC_ME1_HEADER_DUMP_BASE_IDX                                                              0
#define regCP_CPC_SCRATCH_INDEX                                                                         0x0e30
#define regCP_CPC_SCRATCH_INDEX_BASE_IDX                                                                0
#define regCP_CPC_SCRATCH_DATA                                                                          0x0e31
#define regCP_CPC_SCRATCH_DATA_BASE_IDX                                                                 0
#define regCP_CPF_GRBM_FREE_COUNT                                                                       0x0e32
#define regCP_CPF_GRBM_FREE_COUNT_BASE_IDX                                                              0
#define regCP_CPF_BUSY_STAT2                                                                            0x0e33
#define regCP_CPF_BUSY_STAT2_BASE_IDX                                                                   0
#define regCP_CPC_HALT_HYST_COUNT                                                                       0x0e47
#define regCP_CPC_HALT_HYST_COUNT_BASE_IDX                                                              0
#define regCP_STALLED_STAT3                                                                             0x0f3c
#define regCP_STALLED_STAT3_BASE_IDX                                                                    0
#define regCP_STALLED_STAT1                                                                             0x0f3d
#define regCP_STALLED_STAT1_BASE_IDX                                                                    0
#define regCP_STALLED_STAT2                                                                             0x0f3e
#define regCP_STALLED_STAT2_BASE_IDX                                                                    0
#define regCP_BUSY_STAT                                                                                 0x0f3f
#define regCP_BUSY_STAT_BASE_IDX                                                                        0
#define regCP_STAT                                                                                      0x0f40
#define regCP_STAT_BASE_IDX                                                                             0
#define regCP_ME_HEADER_DUMP                                                                            0x0f41
#define regCP_ME_HEADER_DUMP_BASE_IDX                                                                   0
#define regCP_PFP_HEADER_DUMP                                                                           0x0f42
#define regCP_PFP_HEADER_DUMP_BASE_IDX                                                                  0
#define regCP_GRBM_FREE_COUNT                                                                           0x0f43
#define regCP_GRBM_FREE_COUNT_BASE_IDX                                                                  0
#define regCP_PFP_INSTR_PNTR                                                                            0x0f45
#define regCP_PFP_INSTR_PNTR_BASE_IDX                                                                   0
#define regCP_ME_INSTR_PNTR                                                                             0x0f46
#define regCP_ME_INSTR_PNTR_BASE_IDX                                                                    0
#define regCP_CSF_STAT                                                                                  0x0f54
#define regCP_CSF_STAT_BASE_IDX                                                                         0
#define regCP_CNTX_STAT                                                                                 0x0f58
#define regCP_CNTX_STAT_BASE_IDX                                                                        0
#define regCP_ME_PREEMPTION                                                                             0x0f59
#define regCP_ME_PREEMPTION_BASE_IDX                                                                    0
#define regCP_RB0_RPTR                                                                                  0x0f60
#define regCP_RB0_RPTR_BASE_IDX                                                                         0
#define regCP_RB_RPTR                                                                                   0x0f60
#define regCP_RB_RPTR_BASE_IDX                                                                          0
#define regCP_RB_WPTR_DELAY                                                                             0x0f61
#define regCP_RB_WPTR_DELAY_BASE_IDX                                                                    0
#define regCP_RB_WPTR_POLL_CNTL                                                                         0x0f62
#define regCP_RB_WPTR_POLL_CNTL_BASE_IDX                                                                0
#define regCP_ROQ1_THRESHOLDS                                                                           0x0f75
#define regCP_ROQ1_THRESHOLDS_BASE_IDX                                                                  0
#define regCP_ROQ2_THRESHOLDS                                                                           0x0f76
#define regCP_ROQ2_THRESHOLDS_BASE_IDX                                                                  0
#define regCP_STQ_THRESHOLDS                                                                            0x0f77
#define regCP_STQ_THRESHOLDS_BASE_IDX                                                                   0
#define regCP_MEQ_THRESHOLDS                                                                            0x0f79
#define regCP_MEQ_THRESHOLDS_BASE_IDX                                                                   0
#define regCP_ROQ_AVAIL                                                                                 0x0f7a
#define regCP_ROQ_AVAIL_BASE_IDX                                                                        0
#define regCP_STQ_AVAIL                                                                                 0x0f7b
#define regCP_STQ_AVAIL_BASE_IDX                                                                        0
#define regCP_ROQ2_AVAIL                                                                                0x0f7c
#define regCP_ROQ2_AVAIL_BASE_IDX                                                                       0
#define regCP_MEQ_AVAIL                                                                                 0x0f7d
#define regCP_MEQ_AVAIL_BASE_IDX                                                                        0
#define regCP_CMD_INDEX                                                                                 0x0f7e
#define regCP_CMD_INDEX_BASE_IDX                                                                        0
#define regCP_CMD_DATA                                                                                  0x0f7f
#define regCP_CMD_DATA_BASE_IDX                                                                         0
#define regCP_ROQ_RB_STAT                                                                               0x0f80
#define regCP_ROQ_RB_STAT_BASE_IDX                                                                      0
#define regCP_ROQ_IB1_STAT                                                                              0x0f81
#define regCP_ROQ_IB1_STAT_BASE_IDX                                                                     0
#define regCP_ROQ_IB2_STAT                                                                              0x0f82
#define regCP_ROQ_IB2_STAT_BASE_IDX                                                                     0
#define regCP_STQ_STAT                                                                                  0x0f83
#define regCP_STQ_STAT_BASE_IDX                                                                         0
#define regCP_STQ_WR_STAT                                                                               0x0f84
#define regCP_STQ_WR_STAT_BASE_IDX                                                                      0
#define regCP_MEQ_STAT                                                                                  0x0f85
#define regCP_MEQ_STAT_BASE_IDX                                                                         0
#define regCP_ROQ3_THRESHOLDS                                                                           0x0f8c
#define regCP_ROQ3_THRESHOLDS_BASE_IDX                                                                  0
#define regCP_ROQ_DB_STAT                                                                               0x0f8d
#define regCP_ROQ_DB_STAT_BASE_IDX                                                                      0
#define regCP_INT_STAT_DEBUG                                                                            0x0f97
#define regCP_INT_STAT_DEBUG_BASE_IDX                                                                   0
#define regCP_DEBUG_CNTL                                                                                0x0f98
#define regCP_DEBUG_CNTL_BASE_IDX                                                                       0
#define regCP_DEBUG_DATA                                                                                0x0f99
#define regCP_DEBUG_DATA_BASE_IDX                                                                       0
#define regCP_PRIV_VIOLATION_ADDR                                                                       0x0f9a
#define regCP_PRIV_VIOLATION_ADDR_BASE_IDX                                                              0
#define regCP_PRIV_VIOLATION_ADDR_HI                                                                    0x0f9b
#define regCP_PRIV_VIOLATION_ADDR_HI_BASE_IDX                                                           0


// addressBlock: gc_gfx_cpwd_cpwd_padec
// base address: 0x8800
#define regVGT_DMA_DATA_FIFO_DEPTH                                                                      0x0fcd
#define regVGT_DMA_DATA_FIFO_DEPTH_BASE_IDX                                                             0
#define regVGT_DMA_REQ_FIFO_DEPTH                                                                       0x0fce
#define regVGT_DMA_REQ_FIFO_DEPTH_BASE_IDX                                                              0
#define regVGT_DRAW_INIT_FIFO_DEPTH                                                                     0x0fcf
#define regVGT_DRAW_INIT_FIFO_DEPTH_BASE_IDX                                                            0
#define regVGT_MC_LAT_CNTL                                                                              0x0fd6
#define regVGT_MC_LAT_CNTL_BASE_IDX                                                                     0
#define regIA_UTCL1_STATUS_2                                                                            0x0fd7
#define regIA_UTCL1_STATUS_2_BASE_IDX                                                                   0
#define regGE_WD_CNTL_STATUS                                                                            0x0fdf
#define regGE_WD_CNTL_STATUS_BASE_IDX                                                                   0
#define regWD_UTCL1_CNTL                                                                                0x0fe3
#define regWD_UTCL1_CNTL_BASE_IDX                                                                       0
#define regWD_UTCL1_STATUS                                                                              0x0fe4
#define regWD_UTCL1_STATUS_BASE_IDX                                                                     0
#define regIA_UTCL1_CNTL                                                                                0x0fe6
#define regIA_UTCL1_CNTL_BASE_IDX                                                                       0
#define regIA_UTCL1_STATUS                                                                              0x0fe7
#define regIA_UTCL1_STATUS_BASE_IDX                                                                     0
#define regGRBM_CC_GC_SA_UNIT_DISABLE                                                                   0x0fe9
#define regGRBM_CC_GC_SA_UNIT_DISABLE_BASE_IDX                                                          0
#define regGE_PRIV_CONTROL                                                                              0x1004
#define regGE_PRIV_CONTROL_BASE_IDX                                                                     0
#define regGE_STATUS                                                                                    0x1005
#define regGE_STATUS_BASE_IDX                                                                           0
#define regVGT_GS_MAX_WAVE_ID                                                                           0x1009
#define regVGT_GS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define regGFX_PIPE_CONTROL                                                                             0x100d
#define regGFX_PIPE_CONTROL_BASE_IDX                                                                    0
#define regVGT_RESET_DEBUG                                                                              0x1014
#define regVGT_RESET_DEBUG_BASE_IDX                                                                     0


// addressBlock: gc_gfx_cpwd_cpwd_shdec
// base address: 0xb000
#define regCOMPUTE_DISPATCH_INITIATOR                                                                   0x1ba0
#define regCOMPUTE_DISPATCH_INITIATOR_BASE_IDX                                                          0
#define regCOMPUTE_DIM_X                                                                                0x1ba1
#define regCOMPUTE_DIM_X_BASE_IDX                                                                       0
#define regCOMPUTE_DIM_Y                                                                                0x1ba2
#define regCOMPUTE_DIM_Y_BASE_IDX                                                                       0
#define regCOMPUTE_DIM_Z                                                                                0x1ba3
#define regCOMPUTE_DIM_Z_BASE_IDX                                                                       0
#define regCOMPUTE_START_X                                                                              0x1ba4
#define regCOMPUTE_START_X_BASE_IDX                                                                     0
#define regCOMPUTE_START_Y                                                                              0x1ba5
#define regCOMPUTE_START_Y_BASE_IDX                                                                     0
#define regCOMPUTE_START_Z                                                                              0x1ba6
#define regCOMPUTE_START_Z_BASE_IDX                                                                     0
#define regCOMPUTE_NUM_THREAD_X                                                                         0x1ba7
#define regCOMPUTE_NUM_THREAD_X_BASE_IDX                                                                0
#define regCOMPUTE_NUM_THREAD_Y                                                                         0x1ba8
#define regCOMPUTE_NUM_THREAD_Y_BASE_IDX                                                                0
#define regCOMPUTE_NUM_THREAD_Z                                                                         0x1ba9
#define regCOMPUTE_NUM_THREAD_Z_BASE_IDX                                                                0
#define regCOMPUTE_PIPELINESTAT_ENABLE                                                                  0x1baa
#define regCOMPUTE_PIPELINESTAT_ENABLE_BASE_IDX                                                         0
#define regCOMPUTE_PERFCOUNT_ENABLE                                                                     0x1bab
#define regCOMPUTE_PERFCOUNT_ENABLE_BASE_IDX                                                            0
#define regCOMPUTE_PGM_LO                                                                               0x1bac
#define regCOMPUTE_PGM_LO_BASE_IDX                                                                      0
#define regCOMPUTE_PGM_HI                                                                               0x1bad
#define regCOMPUTE_PGM_HI_BASE_IDX                                                                      0
#define regCOMPUTE_DISPATCH_PKT_ADDR_LO                                                                 0x1bae
#define regCOMPUTE_DISPATCH_PKT_ADDR_LO_BASE_IDX                                                        0
#define regCOMPUTE_DISPATCH_PKT_ADDR_HI                                                                 0x1baf
#define regCOMPUTE_DISPATCH_PKT_ADDR_HI_BASE_IDX                                                        0
#define regCOMPUTE_DISPATCH_SCRATCH_BASE_LO                                                             0x1bb0
#define regCOMPUTE_DISPATCH_SCRATCH_BASE_LO_BASE_IDX                                                    0
#define regCOMPUTE_DISPATCH_SCRATCH_BASE_HI                                                             0x1bb1
#define regCOMPUTE_DISPATCH_SCRATCH_BASE_HI_BASE_IDX                                                    0
#define regCOMPUTE_PGM_RSRC1                                                                            0x1bb2
#define regCOMPUTE_PGM_RSRC1_BASE_IDX                                                                   0
#define regCOMPUTE_PGM_RSRC2                                                                            0x1bb3
#define regCOMPUTE_PGM_RSRC2_BASE_IDX                                                                   0
#define regCOMPUTE_VMID                                                                                 0x1bb4
#define regCOMPUTE_VMID_BASE_IDX                                                                        0
#define regCOMPUTE_RESOURCE_LIMITS                                                                      0x1bb5
#define regCOMPUTE_RESOURCE_LIMITS_BASE_IDX                                                             0
#define regCOMPUTE_DESTINATION_EN_SE0                                                                   0x1bb6
#define regCOMPUTE_DESTINATION_EN_SE0_BASE_IDX                                                          0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE0                                                               0x1bb6
#define regCOMPUTE_STATIC_THREAD_MGMT_SE0_BASE_IDX                                                      0
#define regCOMPUTE_DESTINATION_EN_SE1                                                                   0x1bb7
#define regCOMPUTE_DESTINATION_EN_SE1_BASE_IDX                                                          0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE1                                                               0x1bb7
#define regCOMPUTE_STATIC_THREAD_MGMT_SE1_BASE_IDX                                                      0
#define regCOMPUTE_TMPRING_SIZE                                                                         0x1bb8
#define regCOMPUTE_TMPRING_SIZE_BASE_IDX                                                                0
#define regCOMPUTE_DESTINATION_EN_SE2                                                                   0x1bb9
#define regCOMPUTE_DESTINATION_EN_SE2_BASE_IDX                                                          0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE2                                                               0x1bb9
#define regCOMPUTE_STATIC_THREAD_MGMT_SE2_BASE_IDX                                                      0
#define regCOMPUTE_DESTINATION_EN_SE3                                                                   0x1bba
#define regCOMPUTE_DESTINATION_EN_SE3_BASE_IDX                                                          0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE3                                                               0x1bba
#define regCOMPUTE_STATIC_THREAD_MGMT_SE3_BASE_IDX                                                      0
#define regCOMPUTE_RESTART_X                                                                            0x1bbb
#define regCOMPUTE_RESTART_X_BASE_IDX                                                                   0
#define regCOMPUTE_RESTART_Y                                                                            0x1bbc
#define regCOMPUTE_RESTART_Y_BASE_IDX                                                                   0
#define regCOMPUTE_RESTART_Z                                                                            0x1bbd
#define regCOMPUTE_RESTART_Z_BASE_IDX                                                                   0
#define regCOMPUTE_THREAD_TRACE_ENABLE                                                                  0x1bbe
#define regCOMPUTE_THREAD_TRACE_ENABLE_BASE_IDX                                                         0
#define regCOMPUTE_MISC_RESERVED                                                                        0x1bbf
#define regCOMPUTE_MISC_RESERVED_BASE_IDX                                                               0
#define regCOMPUTE_DISPATCH_ID                                                                          0x1bc0
#define regCOMPUTE_DISPATCH_ID_BASE_IDX                                                                 0
#define regCOMPUTE_THREADGROUP_ID                                                                       0x1bc1
#define regCOMPUTE_THREADGROUP_ID_BASE_IDX                                                              0
#define regCOMPUTE_REQ_CTRL                                                                             0x1bc2
#define regCOMPUTE_REQ_CTRL_BASE_IDX                                                                    0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE8                                                               0x1bc3
#define regCOMPUTE_STATIC_THREAD_MGMT_SE8_BASE_IDX                                                      0
#define regCOMPUTE_USER_ACCUM_0                                                                         0x1bc4
#define regCOMPUTE_USER_ACCUM_0_BASE_IDX                                                                0
#define regCOMPUTE_USER_ACCUM_1                                                                         0x1bc5
#define regCOMPUTE_USER_ACCUM_1_BASE_IDX                                                                0
#define regCOMPUTE_USER_ACCUM_2                                                                         0x1bc6
#define regCOMPUTE_USER_ACCUM_2_BASE_IDX                                                                0
#define regCOMPUTE_USER_ACCUM_3                                                                         0x1bc7
#define regCOMPUTE_USER_ACCUM_3_BASE_IDX                                                                0
#define regCOMPUTE_PGM_RSRC3                                                                            0x1bc8
#define regCOMPUTE_PGM_RSRC3_BASE_IDX                                                                   0
#define regCOMPUTE_DDID_INDEX                                                                           0x1bc9
#define regCOMPUTE_DDID_INDEX_BASE_IDX                                                                  0
#define regCOMPUTE_SHADER_CHKSUM                                                                        0x1bca
#define regCOMPUTE_SHADER_CHKSUM_BASE_IDX                                                               0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE4                                                               0x1bcb
#define regCOMPUTE_STATIC_THREAD_MGMT_SE4_BASE_IDX                                                      0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE5                                                               0x1bcc
#define regCOMPUTE_STATIC_THREAD_MGMT_SE5_BASE_IDX                                                      0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE6                                                               0x1bcd
#define regCOMPUTE_STATIC_THREAD_MGMT_SE6_BASE_IDX                                                      0
#define regCOMPUTE_STATIC_THREAD_MGMT_SE7                                                               0x1bce
#define regCOMPUTE_STATIC_THREAD_MGMT_SE7_BASE_IDX                                                      0
#define regCOMPUTE_DISPATCH_INTERLEAVE                                                                  0x1bcf
#define regCOMPUTE_DISPATCH_INTERLEAVE_BASE_IDX                                                         0
#define regCOMPUTE_RELAUNCH                                                                             0x1bd0
#define regCOMPUTE_RELAUNCH_BASE_IDX                                                                    0
#define regCOMPUTE_WAVE_RESTORE_ADDR_LO                                                                 0x1bd1
#define regCOMPUTE_WAVE_RESTORE_ADDR_LO_BASE_IDX                                                        0
#define regCOMPUTE_WAVE_RESTORE_ADDR_HI                                                                 0x1bd2
#define regCOMPUTE_WAVE_RESTORE_ADDR_HI_BASE_IDX                                                        0
#define regCOMPUTE_RELAUNCH2                                                                            0x1bd3
#define regCOMPUTE_RELAUNCH2_BASE_IDX                                                                   0
#define regCOMPUTE_PRESCALED_DIM_X                                                                      0x1bd5
#define regCOMPUTE_PRESCALED_DIM_X_BASE_IDX                                                             0
#define regCOMPUTE_PRESCALED_DIM_Y                                                                      0x1bd6
#define regCOMPUTE_PRESCALED_DIM_Y_BASE_IDX                                                             0
#define regCOMPUTE_PRESCALED_DIM_Z                                                                      0x1bd7
#define regCOMPUTE_PRESCALED_DIM_Z_BASE_IDX                                                             0
#define regCOMPUTE_USER_DATA_0                                                                          0x1be0
#define regCOMPUTE_USER_DATA_0_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_1                                                                          0x1be1
#define regCOMPUTE_USER_DATA_1_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_2                                                                          0x1be2
#define regCOMPUTE_USER_DATA_2_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_3                                                                          0x1be3
#define regCOMPUTE_USER_DATA_3_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_4                                                                          0x1be4
#define regCOMPUTE_USER_DATA_4_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_5                                                                          0x1be5
#define regCOMPUTE_USER_DATA_5_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_6                                                                          0x1be6
#define regCOMPUTE_USER_DATA_6_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_7                                                                          0x1be7
#define regCOMPUTE_USER_DATA_7_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_8                                                                          0x1be8
#define regCOMPUTE_USER_DATA_8_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_9                                                                          0x1be9
#define regCOMPUTE_USER_DATA_9_BASE_IDX                                                                 0
#define regCOMPUTE_USER_DATA_10                                                                         0x1bea
#define regCOMPUTE_USER_DATA_10_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_11                                                                         0x1beb
#define regCOMPUTE_USER_DATA_11_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_12                                                                         0x1bec
#define regCOMPUTE_USER_DATA_12_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_13                                                                         0x1bed
#define regCOMPUTE_USER_DATA_13_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_14                                                                         0x1bee
#define regCOMPUTE_USER_DATA_14_BASE_IDX                                                                0
#define regCOMPUTE_USER_DATA_15                                                                         0x1bef
#define regCOMPUTE_USER_DATA_15_BASE_IDX                                                                0
#define regCOMPUTE_DISPATCH_TUNNEL                                                                      0x1c1d
#define regCOMPUTE_DISPATCH_TUNNEL_BASE_IDX                                                             0
#define regCOMPUTE_DISPATCH_END                                                                         0x1c1e
#define regCOMPUTE_DISPATCH_END_BASE_IDX                                                                0
#define regCOMPUTE_NOWHERE                                                                              0x1c1f
#define regCOMPUTE_NOWHERE_BASE_IDX                                                                     0
#define regSH_RESERVED_REG0                                                                             0x1c20
#define regSH_RESERVED_REG0_BASE_IDX                                                                    0
#define regSH_RESERVED_REG1                                                                             0x1c21
#define regSH_RESERVED_REG1_BASE_IDX                                                                    0


// addressBlock: gc_gfx_cpwd_cpwd_rasdec
// base address: 0xce00
#define regRAS_GE_SIGNATURE0                                                                            0x214c
#define regRAS_GE_SIGNATURE0_BASE_IDX                                                                   0


// addressBlock: gc_gfx_cpwd_cpwd_pfonly_gccacdec
// base address: 0x2eb40
#define regGC_CAC_CTRL_1                                                                                0x1ad0
#define regGC_CAC_CTRL_1_BASE_IDX                                                                       1
#define regGC_CAC_CTRL_2                                                                                0x1ad1
#define regGC_CAC_CTRL_2_BASE_IDX                                                                       1
#define regGC_CAC_AGGR_LOWER                                                                            0x1ad2
#define regGC_CAC_AGGR_LOWER_BASE_IDX                                                                   1
#define regGC_CAC_AGGR_UPPER                                                                            0x1ad3
#define regGC_CAC_AGGR_UPPER_BASE_IDX                                                                   1
#define regSE0_CAC_AGGR_LOWER                                                                           0x1ad4
#define regSE0_CAC_AGGR_LOWER_BASE_IDX                                                                  1
#define regSE0_CAC_AGGR_UPPER                                                                           0x1ad5
#define regSE0_CAC_AGGR_UPPER_BASE_IDX                                                                  1
#define regSE1_CAC_AGGR_LOWER                                                                           0x1ad6
#define regSE1_CAC_AGGR_LOWER_BASE_IDX                                                                  1
#define regSE1_CAC_AGGR_UPPER                                                                           0x1ad7
#define regSE1_CAC_AGGR_UPPER_BASE_IDX                                                                  1
#define regSE2_CAC_AGGR_LOWER                                                                           0x1ad8
#define regSE2_CAC_AGGR_LOWER_BASE_IDX                                                                  1
#define regSE2_CAC_AGGR_UPPER                                                                           0x1ad9
#define regSE2_CAC_AGGR_UPPER_BASE_IDX                                                                  1
#define regSE3_CAC_AGGR_LOWER                                                                           0x1ada
#define regSE3_CAC_AGGR_LOWER_BASE_IDX                                                                  1
#define regSE3_CAC_AGGR_UPPER                                                                           0x1adb
#define regSE3_CAC_AGGR_UPPER_BASE_IDX                                                                  1
#define regGC_CAC_AGGR_GFXCLK_CYCLE                                                                     0x1ae6
#define regGC_CAC_AGGR_GFXCLK_CYCLE_BASE_IDX                                                            1
#define regSE0_CAC_AGGR_GFXCLK_CYCLE                                                                    0x1ae7
#define regSE0_CAC_AGGR_GFXCLK_CYCLE_BASE_IDX                                                           1
#define regSE1_CAC_AGGR_GFXCLK_CYCLE                                                                    0x1ae8
#define regSE1_CAC_AGGR_GFXCLK_CYCLE_BASE_IDX                                                           1
#define regSE2_CAC_AGGR_GFXCLK_CYCLE                                                                    0x1ae9
#define regSE2_CAC_AGGR_GFXCLK_CYCLE_BASE_IDX                                                           1
#define regSE3_CAC_AGGR_GFXCLK_CYCLE                                                                    0x1aea
#define regSE3_CAC_AGGR_GFXCLK_CYCLE_BASE_IDX                                                           1
#define regGC_EDC_CTRL                                                                                  0x1af4
#define regGC_EDC_CTRL_BASE_IDX                                                                         1
#define regGC_EDC_STRETCH_CTRL                                                                          0x1af5
#define regGC_EDC_STRETCH_CTRL_BASE_IDX                                                                 1
#define regGC_EDC_THRESHOLD_LO                                                                          0x1af6
#define regGC_EDC_THRESHOLD_LO_BASE_IDX                                                                 1
#define regGC_EDC_THRESHOLD_HI                                                                          0x1af7
#define regGC_EDC_THRESHOLD_HI_BASE_IDX                                                                 1
#define regGC_EDC_STRETCH_THRESHOLD_LO                                                                  0x1af8
#define regGC_EDC_STRETCH_THRESHOLD_LO_BASE_IDX                                                         1
#define regGC_EDC_STRETCH_THRESHOLD_HI                                                                  0x1af9
#define regGC_EDC_STRETCH_THRESHOLD_HI_BASE_IDX                                                         1
#define regEDC_HYSTERESIS_CNTL                                                                          0x1afa
#define regEDC_HYSTERESIS_CNTL_BASE_IDX                                                                 1
#define regGC_THROTTLE_CTRL                                                                             0x1afb
#define regGC_THROTTLE_CTRL_BASE_IDX                                                                    1
#define regGC_THROTTLE_CTRL1                                                                            0x1afc
#define regGC_THROTTLE_CTRL1_BASE_IDX                                                                   1
#define regGC_THROTTLE_CTRL2                                                                            0x1afd
#define regGC_THROTTLE_CTRL2_BASE_IDX                                                                   1
#define regEDC_STALL_PATTERN_CTRL                                                                       0x1afe
#define regEDC_STALL_PATTERN_CTRL_BASE_IDX                                                              1
#define regPCC_STALL_PATTERN_CTRL                                                                       0x1aff
#define regPCC_STALL_PATTERN_CTRL_BASE_IDX                                                              1
#define regPWRBRK_STALL_PATTERN_CTRL                                                                    0x1b00
#define regPWRBRK_STALL_PATTERN_CTRL_BASE_IDX                                                           1
#define regEDC_STALL_PATTERN_1_2                                                                        0x1b01
#define regEDC_STALL_PATTERN_1_2_BASE_IDX                                                               1
#define regEDC_STALL_PATTERN_3_4                                                                        0x1b02
#define regEDC_STALL_PATTERN_3_4_BASE_IDX                                                               1
#define regEDC_STALL_PATTERN_5_6                                                                        0x1b03
#define regEDC_STALL_PATTERN_5_6_BASE_IDX                                                               1
#define regEDC_STALL_PATTERN_7                                                                          0x1b04
#define regEDC_STALL_PATTERN_7_BASE_IDX                                                                 1
#define regPCC_STALL_PATTERN_1_2                                                                        0x1b05
#define regPCC_STALL_PATTERN_1_2_BASE_IDX                                                               1
#define regPCC_STALL_PATTERN_3_4                                                                        0x1b06
#define regPCC_STALL_PATTERN_3_4_BASE_IDX                                                               1
#define regPCC_STALL_PATTERN_5_6                                                                        0x1b07
#define regPCC_STALL_PATTERN_5_6_BASE_IDX                                                               1
#define regPCC_STALL_PATTERN_7                                                                          0x1b08
#define regPCC_STALL_PATTERN_7_BASE_IDX                                                                 1
#define regPWRBRK_STALL_PATTERN_1_2                                                                     0x1b09
#define regPWRBRK_STALL_PATTERN_1_2_BASE_IDX                                                            1
#define regPWRBRK_STALL_PATTERN_3_4                                                                     0x1b0a
#define regPWRBRK_STALL_PATTERN_3_4_BASE_IDX                                                            1
#define regPWRBRK_STALL_PATTERN_5_6                                                                     0x1b0b
#define regPWRBRK_STALL_PATTERN_5_6_BASE_IDX                                                            1
#define regPWRBRK_STALL_PATTERN_7                                                                       0x1b0c
#define regPWRBRK_STALL_PATTERN_7_BASE_IDX                                                              1
#define regDIDT_STALL_PATTERN_CTRL                                                                      0x1b0d
#define regDIDT_STALL_PATTERN_CTRL_BASE_IDX                                                             1
#define regDIDT_STALL_PATTERN_1_2                                                                       0x1b0e
#define regDIDT_STALL_PATTERN_1_2_BASE_IDX                                                              1
#define regDIDT_STALL_PATTERN_3_4                                                                       0x1b0f
#define regDIDT_STALL_PATTERN_3_4_BASE_IDX                                                              1
#define regDIDT_STALL_PATTERN_5_6                                                                       0x1b10
#define regDIDT_STALL_PATTERN_5_6_BASE_IDX                                                              1
#define regDIDT_STALL_PATTERN_7                                                                         0x1b11
#define regDIDT_STALL_PATTERN_7_BASE_IDX                                                                1
#define regPCC_PWRBRK_HYSTERESIS_CTRL                                                                   0x1b12
#define regPCC_PWRBRK_HYSTERESIS_CTRL_BASE_IDX                                                          1
#define regEDC_STRETCH_PERF_COUNTER                                                                     0x1b13
#define regEDC_STRETCH_PERF_COUNTER_BASE_IDX                                                            1
#define regEDC_UNSTRETCH_PERF_COUNTER                                                                   0x1b14
#define regEDC_UNSTRETCH_PERF_COUNTER_BASE_IDX                                                          1
#define regEDC_STRETCH_NUM_PERF_COUNTER                                                                 0x1b15
#define regEDC_STRETCH_NUM_PERF_COUNTER_BASE_IDX                                                        1
#define regGC_EDC_STATUS                                                                                0x1b16
#define regGC_EDC_STATUS_BASE_IDX                                                                       1
#define regGC_EDC_OVERFLOW                                                                              0x1b17
#define regGC_EDC_OVERFLOW_BASE_IDX                                                                     1
#define regGC_EDC_ROLLING_POWER_DELTA_LO                                                                0x1b18
#define regGC_EDC_ROLLING_POWER_DELTA_LO_BASE_IDX                                                       1
#define regGC_EDC_ROLLING_POWER_DELTA_HI                                                                0x1b19
#define regGC_EDC_ROLLING_POWER_DELTA_HI_BASE_IDX                                                       1
#define regGC_THROTTLE_STATUS                                                                           0x1b1c
#define regGC_THROTTLE_STATUS_BASE_IDX                                                                  1
#define regEDC_PERF_COUNTER                                                                             0x1b1d
#define regEDC_PERF_COUNTER_BASE_IDX                                                                    1
#define regPCC_PERF_COUNTER                                                                             0x1b1e
#define regPCC_PERF_COUNTER_BASE_IDX                                                                    1
#define regPWRBRK_PERF_COUNTER                                                                          0x1b1f
#define regPWRBRK_PERF_COUNTER_BASE_IDX                                                                 1
#define regEDC_HYSTERESIS_STAT                                                                          0x1b20
#define regEDC_HYSTERESIS_STAT_BASE_IDX                                                                 1
#define regDIDT_HYSTERESIS_STAT                                                                         0x1b21
#define regDIDT_HYSTERESIS_STAT_BASE_IDX                                                                1
#define regDIDT_PERF_COUNTER                                                                            0x1b22
#define regDIDT_PERF_COUNTER_BASE_IDX                                                                   1
#define regGC_EDC_CLK_MONITOR_CTRL                                                                      0x1b23
#define regGC_EDC_CLK_MONITOR_CTRL_BASE_IDX                                                             1
#define regGC_CAC_SOFT_CTRL                                                                             0x1b24
#define regGC_CAC_SOFT_CTRL_BASE_IDX                                                                    1
#define regGC_CAC_WEIGHT_CP_0                                                                           0x1b30
#define regGC_CAC_WEIGHT_CP_0_BASE_IDX                                                                  1
#define regGC_CAC_WEIGHT_CP_1                                                                           0x1b31
#define regGC_CAC_WEIGHT_CP_1_BASE_IDX                                                                  1
#define regGC_CAC_WEIGHT_EA_0                                                                           0x1b32
#define regGC_CAC_WEIGHT_EA_0_BASE_IDX                                                                  1
#define regGC_CAC_WEIGHT_EA_1                                                                           0x1b33
#define regGC_CAC_WEIGHT_EA_1_BASE_IDX                                                                  1
#define regGC_CAC_WEIGHT_EA_2                                                                           0x1b34
#define regGC_CAC_WEIGHT_EA_2_BASE_IDX                                                                  1
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_0                                                                 0x1b35
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_0_BASE_IDX                                                        1
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_1                                                                 0x1b36
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_1_BASE_IDX                                                        1
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_2                                                                 0x1b37
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_2_BASE_IDX                                                        1
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_3                                                                 0x1b38
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_3_BASE_IDX                                                        1
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_4                                                                 0x1b39
#define regGC_CAC_WEIGHT_UTCL2_ROUTER_4_BASE_IDX                                                        1
#define regGC_CAC_WEIGHT_UTCL2_VML2_0                                                                   0x1b3a
#define regGC_CAC_WEIGHT_UTCL2_VML2_0_BASE_IDX                                                          1
#define regGC_CAC_WEIGHT_UTCL2_VML2_1                                                                   0x1b3b
#define regGC_CAC_WEIGHT_UTCL2_VML2_1_BASE_IDX                                                          1
#define regGC_CAC_WEIGHT_UTCL2_VML2_2                                                                   0x1b3c
#define regGC_CAC_WEIGHT_UTCL2_VML2_2_BASE_IDX                                                          1
#define regGC_CAC_WEIGHT_UTCL2_WALKER_0                                                                 0x1b3d
#define regGC_CAC_WEIGHT_UTCL2_WALKER_0_BASE_IDX                                                        1
#define regGC_CAC_WEIGHT_UTCL2_WALKER_1                                                                 0x1b3e
#define regGC_CAC_WEIGHT_UTCL2_WALKER_1_BASE_IDX                                                        1
#define regGC_CAC_WEIGHT_UTCL2_WALKER_2                                                                 0x1b3f
#define regGC_CAC_WEIGHT_UTCL2_WALKER_2_BASE_IDX                                                        1
#define regGC_CAC_WEIGHT_GE_0                                                                           0x1b40
#define regGC_CAC_WEIGHT_GE_0_BASE_IDX                                                                  1
#define regGC_CAC_WEIGHT_GE_1                                                                           0x1b41
#define regGC_CAC_WEIGHT_GE_1_BASE_IDX                                                                  1
#define regGC_CAC_WEIGHT_PMM_0                                                                          0x1b4b
#define regGC_CAC_WEIGHT_PMM_0_BASE_IDX                                                                 1
#define regGC_CAC_WEIGHT_SDMA_0                                                                         0x1b50
#define regGC_CAC_WEIGHT_SDMA_0_BASE_IDX                                                                1
#define regGC_CAC_WEIGHT_SDMA_1                                                                         0x1b51
#define regGC_CAC_WEIGHT_SDMA_1_BASE_IDX                                                                1
#define regGC_CAC_WEIGHT_SDMA_2                                                                         0x1b52
#define regGC_CAC_WEIGHT_SDMA_2_BASE_IDX                                                                1
#define regGC_CAC_WEIGHT_SDMA_3                                                                         0x1b53
#define regGC_CAC_WEIGHT_SDMA_3_BASE_IDX                                                                1
#define regGC_CAC_WEIGHT_SDMA_4                                                                         0x1b54
#define regGC_CAC_WEIGHT_SDMA_4_BASE_IDX                                                                1
#define regGC_CAC_WEIGHT_SDMA_5                                                                         0x1b55
#define regGC_CAC_WEIGHT_SDMA_5_BASE_IDX                                                                1
#define regGC_CAC_WEIGHT_CHC_0                                                                          0x1b56
#define regGC_CAC_WEIGHT_CHC_0_BASE_IDX                                                                 1
#define regGC_CAC_WEIGHT_CHC_1                                                                          0x1b57
#define regGC_CAC_WEIGHT_CHC_1_BASE_IDX                                                                 1
#define regGC_CAC_WEIGHT_RLC_0                                                                          0x1b5a
#define regGC_CAC_WEIGHT_RLC_0_BASE_IDX                                                                 1
#define regGC_CAC_WEIGHT_GRBM_0                                                                         0x1b5e
#define regGC_CAC_WEIGHT_GRBM_0_BASE_IDX                                                                1
#define regGC_CAC_WEIGHT_GL2C_0                                                                         0x1b70
#define regGC_CAC_WEIGHT_GL2C_0_BASE_IDX                                                                1
#define regGC_CAC_WEIGHT_GL2C_1                                                                         0x1b71
#define regGC_CAC_WEIGHT_GL2C_1_BASE_IDX                                                                1
#define regGC_CAC_WEIGHT_GL2C_2                                                                         0x1b72
#define regGC_CAC_WEIGHT_GL2C_2_BASE_IDX                                                                1
#define regGC_CAC_IND_INDEX                                                                             0x1bce
#define regGC_CAC_IND_INDEX_BASE_IDX                                                                    1
#define regGC_CAC_IND_DATA                                                                              0x1bcf
#define regGC_CAC_IND_DATA_BASE_IDX                                                                     1


// addressBlock: gc_gfx_cpwd_gc_ea_cpwd_gceadec
// base address: 0xa800
#define regGC_EA_CPWD_VC_MAP                                                                            0x17a0
#define regGC_EA_CPWD_VC_MAP_BASE_IDX                                                                   0
#define regGC_EA_CPWD_SDP_ARB_FINAL                                                                     0x17a1
#define regGC_EA_CPWD_SDP_ARB_FINAL_BASE_IDX                                                            0
#define regGC_EA_CPWD_SDP_PRIORITY                                                                      0x17a2
#define regGC_EA_CPWD_SDP_PRIORITY_BASE_IDX                                                             0
#define regGC_EA_CPWD_SDP_CREDITS                                                                       0x17a3
#define regGC_EA_CPWD_SDP_CREDITS_BASE_IDX                                                              0
#define regGC_EA_CPWD_SDP_TAG_RESERVE0                                                                  0x17a4
#define regGC_EA_CPWD_SDP_TAG_RESERVE0_BASE_IDX                                                         0
#define regGC_EA_CPWD_SDP_TAG_RESERVE1                                                                  0x17a5
#define regGC_EA_CPWD_SDP_TAG_RESERVE1_BASE_IDX                                                         0
#define regGC_EA_CPWD_SDP_TAG_RESERVE2                                                                  0x17a6
#define regGC_EA_CPWD_SDP_TAG_RESERVE2_BASE_IDX                                                         0
#define regGC_EA_CPWD_SDP_VCC_RESERVE0                                                                  0x17a7
#define regGC_EA_CPWD_SDP_VCC_RESERVE0_BASE_IDX                                                         0
#define regGC_EA_CPWD_SDP_VCC_RESERVE1                                                                  0x17a8
#define regGC_EA_CPWD_SDP_VCC_RESERVE1_BASE_IDX                                                         0
#define regGC_EA_CPWD_SDP_VCD_RESERVE0                                                                  0x17a9
#define regGC_EA_CPWD_SDP_VCD_RESERVE0_BASE_IDX                                                         0
#define regGC_EA_CPWD_SDP_VCD_RESERVE1                                                                  0x17aa
#define regGC_EA_CPWD_SDP_VCD_RESERVE1_BASE_IDX                                                         0
#define regGC_EA_CPWD_SDP_REQ_CNTL                                                                      0x17ab
#define regGC_EA_CPWD_SDP_REQ_CNTL_BASE_IDX                                                             0
#define regGC_EA_CPWD_MISC                                                                              0x17ac
#define regGC_EA_CPWD_MISC_BASE_IDX                                                                     0
#define regGC_EA_CPWD_ERR_STATUS                                                                        0x17ad
#define regGC_EA_CPWD_ERR_STATUS_BASE_IDX                                                               0
#define regGC_EA_CPWD_MISC2                                                                             0x17ae
#define regGC_EA_CPWD_MISC2_BASE_IDX                                                                    0
#define regGC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0                                                          0x17af
#define regGC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_BASE_IDX                                                 0
#define regGC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE                                                    0x17b0
#define regGC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS0_WRITE_BASE_IDX                                           0
#define regGC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1                                                          0x17b1
#define regGC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_BASE_IDX                                                 0
#define regGC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE                                                    0x17b2
#define regGC_EA_CPWD_SDP_BACKDOOR_CMDCREDITS1_WRITE_BASE_IDX                                           0
#define regGC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0                                                         0x17b3
#define regGC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_BASE_IDX                                                0
#define regGC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE                                                   0x17b4
#define regGC_EA_CPWD_SDP_BACKDOOR_DATACREDITS0_WRITE_BASE_IDX                                          0
#define regGC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1                                                         0x17b5
#define regGC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_BASE_IDX                                                0
#define regGC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE                                                   0x17b6
#define regGC_EA_CPWD_SDP_BACKDOOR_DATACREDITS1_WRITE_BASE_IDX                                          0
#define regGC_EA_CPWD_SDP_BACKDOOR_MISCCTL                                                              0x17b7
#define regGC_EA_CPWD_SDP_BACKDOOR_MISCCTL_BASE_IDX                                                     0
#define regGC_EA_CPWD_SDP_BACKDOOR_MISCCTL_WRITE                                                        0x17b8
#define regGC_EA_CPWD_SDP_BACKDOOR_MISCCTL_WRITE_BASE_IDX                                               0
#define regGC_EA_CPWD_SDP_ENABLE                                                                        0x181f
#define regGC_EA_CPWD_SDP_ENABLE_BASE_IDX                                                               0


// addressBlock: gc_gfx_cpwd_gc_ea_se_gceadec
// base address: 0xaa00
#define regGC_EA_SE_SDP_ARB_FINAL                                                                       0x1821
#define regGC_EA_SE_SDP_ARB_FINAL_BASE_IDX                                                              0
#define regGC_EA_SE_SDP_PRIORITY                                                                        0x1822
#define regGC_EA_SE_SDP_PRIORITY_BASE_IDX                                                               0
#define regGC_EA_SE_SDP_CREDITS                                                                         0x1823
#define regGC_EA_SE_SDP_CREDITS_BASE_IDX                                                                0
#define regGC_EA_SE_SDP_TAG_RESERVE0                                                                    0x1824
#define regGC_EA_SE_SDP_TAG_RESERVE0_BASE_IDX                                                           0
#define regGC_EA_SE_SDP_TAG_RESERVE1                                                                    0x1825
#define regGC_EA_SE_SDP_TAG_RESERVE1_BASE_IDX                                                           0
#define regGC_EA_SE_SDP_TAG_RESERVE2                                                                    0x1826
#define regGC_EA_SE_SDP_TAG_RESERVE2_BASE_IDX                                                           0
#define regGC_EA_SE_SDP_VCC_RESERVE0                                                                    0x1827
#define regGC_EA_SE_SDP_VCC_RESERVE0_BASE_IDX                                                           0
#define regGC_EA_SE_SDP_VCC_RESERVE1                                                                    0x1828
#define regGC_EA_SE_SDP_VCC_RESERVE1_BASE_IDX                                                           0
#define regGC_EA_SE_SDP_VCD_RESERVE0                                                                    0x1829
#define regGC_EA_SE_SDP_VCD_RESERVE0_BASE_IDX                                                           0
#define regGC_EA_SE_SDP_VCD_RESERVE1                                                                    0x182a
#define regGC_EA_SE_SDP_VCD_RESERVE1_BASE_IDX                                                           0
#define regGC_EA_SE_SDP_REQ_CNTL                                                                        0x182b
#define regGC_EA_SE_SDP_REQ_CNTL_BASE_IDX                                                               0
#define regGC_EA_SE_MISC                                                                                0x182c
#define regGC_EA_SE_MISC_BASE_IDX                                                                       0
#define regGC_EA_SE_MISC2                                                                               0x182e
#define regGC_EA_SE_MISC2_BASE_IDX                                                                      0
#define regGC_EA_SE_SDP_ENABLE                                                                          0x189f
#define regGC_EA_SE_SDP_ENABLE_BASE_IDX                                                                 0


// addressBlock: gc_gfx_cpwd_cpwd_gcrdec
// base address: 0x9f80
#define regGCR_PIO_CNTL                                                                                 0x1580
#define regGCR_PIO_CNTL_BASE_IDX                                                                        0
#define regGCR_PIO_DATA                                                                                 0x1581
#define regGCR_PIO_DATA_BASE_IDX                                                                        0
#define regPMM_CNTL                                                                                     0x1582
#define regPMM_CNTL_BASE_IDX                                                                            0
#define regPMM_STATUS                                                                                   0x1583
#define regPMM_STATUS_BASE_IDX                                                                          0


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvmsharedpfdec
// base address: 0xa000
#define regGCMC_VM_NB_MMIOBASE                                                                          0x15a0
#define regGCMC_VM_NB_MMIOBASE_BASE_IDX                                                                 0
#define regGCMC_VM_NB_MMIOLIMIT                                                                         0x15a1
#define regGCMC_VM_NB_MMIOLIMIT_BASE_IDX                                                                0
#define regGCMC_VM_NB_PCI_CTRL                                                                          0x15a2
#define regGCMC_VM_NB_PCI_CTRL_BASE_IDX                                                                 0
#define regGCMC_VM_NB_PCI_ARB                                                                           0x15a3
#define regGCMC_VM_NB_PCI_ARB_BASE_IDX                                                                  0
#define regGCMC_VM_NB_TOP_OF_DRAM_SLOT1                                                                 0x15a4
#define regGCMC_VM_NB_TOP_OF_DRAM_SLOT1_BASE_IDX                                                        0
#define regGCMC_VM_NB_LOWER_TOP_OF_DRAM2                                                                0x15a5
#define regGCMC_VM_NB_LOWER_TOP_OF_DRAM2_BASE_IDX                                                       0
#define regGCMC_VM_NB_UPPER_TOP_OF_DRAM2                                                                0x15a6
#define regGCMC_VM_NB_UPPER_TOP_OF_DRAM2_BASE_IDX                                                       0
#define regGCMC_VM_FB_OFFSET                                                                            0x15a7
#define regGCMC_VM_FB_OFFSET_BASE_IDX                                                                   0
#define regGCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB                                                     0x15a8
#define regGCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_LSB_BASE_IDX                                            0
#define regGCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB                                                     0x15a9
#define regGCMC_VM_SYSTEM_APERTURE_DEFAULT_ADDR_MSB_BASE_IDX                                            0
#define regGCMC_VM_STEERING                                                                             0x15aa
#define regGCMC_VM_STEERING_BASE_IDX                                                                    0
#define regGCMC_SHARED_VIRT_RESET_REQ                                                                   0x15ab
#define regGCMC_SHARED_VIRT_RESET_REQ_BASE_IDX                                                          0
#define regGCMC_VM_CACHEABLE_DRAM_ADDRESS_START                                                         0x15ac
#define regGCMC_VM_CACHEABLE_DRAM_ADDRESS_START_BASE_IDX                                                0
#define regGCMC_VM_CACHEABLE_DRAM_ADDRESS_END                                                           0x15ad
#define regGCMC_VM_CACHEABLE_DRAM_ADDRESS_END_BASE_IDX                                                  0
#define regGCMC_VM_LOCAL_SYSMEM_ADDRESS_START                                                           0x15ae
#define regGCMC_VM_LOCAL_SYSMEM_ADDRESS_START_BASE_IDX                                                  0
#define regGCMC_VM_LOCAL_SYSMEM_ADDRESS_END                                                             0x15af
#define regGCMC_VM_LOCAL_SYSMEM_ADDRESS_END_BASE_IDX                                                    0
#define regGCMC_VM_APT_CNTL                                                                             0x15b0
#define regGCMC_VM_APT_CNTL_BASE_IDX                                                                    0
#define regGCMC_VM_LOCAL_FB_ADDRESS_START                                                               0x15b1
#define regGCMC_VM_LOCAL_FB_ADDRESS_START_BASE_IDX                                                      0
#define regGCMC_VM_LOCAL_FB_ADDRESS_END                                                                 0x15b2
#define regGCMC_VM_LOCAL_FB_ADDRESS_END_BASE_IDX                                                        0
#define regGCMC_VM_LOCAL_FB_ADDRESS_LOCK_CNTL                                                           0x15b3
#define regGCMC_VM_LOCAL_FB_ADDRESS_LOCK_CNTL_BASE_IDX                                                  0
#define regGCUTCL2_ICG_CTRL                                                                             0x15b4
#define regGCUTCL2_ICG_CTRL_BASE_IDX                                                                    0
#define regGCMC_SHARED_ACTIVE_FCN_ID                                                                    0x15b5
#define regGCMC_SHARED_ACTIVE_FCN_ID_BASE_IDX                                                           0
#define regGCUTCL2_CGTT_BUSY_CTRL                                                                       0x15b6
#define regGCUTCL2_CGTT_BUSY_CTRL_BASE_IDX                                                              0
#define regGCUTCL2_HARVEST_BYPASS_GROUPS                                                                0x15b7
#define regGCUTCL2_HARVEST_BYPASS_GROUPS_BASE_IDX                                                       0
#define regGCUTCL2_GROUP_RET_FAULT_STATUS                                                               0x15b9
#define regGCUTCL2_GROUP_RET_FAULT_STATUS_BASE_IDX                                                      0


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvml2pfdec
// base address: 0xa090
#define regGCVM_L2_CNTL                                                                                 0x15c4
#define regGCVM_L2_CNTL_BASE_IDX                                                                        0
#define regGCVM_L2_CNTL2                                                                                0x15c5
#define regGCVM_L2_CNTL2_BASE_IDX                                                                       0
#define regGCVM_L2_CNTL3                                                                                0x15c6
#define regGCVM_L2_CNTL3_BASE_IDX                                                                       0
#define regGCVM_L2_STATUS                                                                               0x15c7
#define regGCVM_L2_STATUS_BASE_IDX                                                                      0
#define regGCVM_DUMMY_PAGE_FAULT_CNTL                                                                   0x15c8
#define regGCVM_DUMMY_PAGE_FAULT_CNTL_BASE_IDX                                                          0
#define regGCVM_DUMMY_PAGE_FAULT_ADDR_LO32                                                              0x15c9
#define regGCVM_DUMMY_PAGE_FAULT_ADDR_LO32_BASE_IDX                                                     0
#define regGCVM_DUMMY_PAGE_FAULT_ADDR_HI32                                                              0x15ca
#define regGCVM_DUMMY_PAGE_FAULT_ADDR_HI32_BASE_IDX                                                     0
#define regGCVM_INVALIDATE_CNTL                                                                         0x15cb
#define regGCVM_INVALIDATE_CNTL_BASE_IDX                                                                0
#define regGCVM_L2_PROTECTION_FAULT_CNTL                                                                0x15cc
#define regGCVM_L2_PROTECTION_FAULT_CNTL_BASE_IDX                                                       0
#define regGCVM_L2_PROTECTION_FAULT_CNTL2                                                               0x15cd
#define regGCVM_L2_PROTECTION_FAULT_CNTL2_BASE_IDX                                                      0
#define regGCVM_L2_PROTECTION_FAULT_MM_CNTL3                                                            0x15ce
#define regGCVM_L2_PROTECTION_FAULT_MM_CNTL3_BASE_IDX                                                   0
#define regGCVM_L2_PROTECTION_FAULT_MM_CNTL4                                                            0x15cf
#define regGCVM_L2_PROTECTION_FAULT_MM_CNTL4_BASE_IDX                                                   0
#define regGCVM_L2_PROTECTION_FAULT_STATUS_LO32                                                         0x15d0
#define regGCVM_L2_PROTECTION_FAULT_STATUS_LO32_BASE_IDX                                                0
#define regGCVM_L2_PROTECTION_FAULT_STATUS_HI32                                                         0x15d1
#define regGCVM_L2_PROTECTION_FAULT_STATUS_HI32_BASE_IDX                                                0
#define regGCVM_L2_PROTECTION_FAULT_ADDR_LO32                                                           0x15d2
#define regGCVM_L2_PROTECTION_FAULT_ADDR_LO32_BASE_IDX                                                  0
#define regGCVM_L2_PROTECTION_FAULT_ADDR_HI32                                                           0x15d3
#define regGCVM_L2_PROTECTION_FAULT_ADDR_HI32_BASE_IDX                                                  0
#define regGCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32                                                   0x15d4
#define regGCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_LO32_BASE_IDX                                          0
#define regGCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32                                                   0x15d5
#define regGCVM_L2_PROTECTION_FAULT_DEFAULT_ADDR_HI32_BASE_IDX                                          0
#define regGCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32                                             0x15d7
#define regGCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_LO32_BASE_IDX                                    0
#define regGCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32                                             0x15d8
#define regGCVM_L2_CONTEXT1_IDENTITY_APERTURE_LOW_ADDR_HI32_BASE_IDX                                    0
#define regGCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32                                            0x15d9
#define regGCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_LO32_BASE_IDX                                   0
#define regGCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32                                            0x15da
#define regGCVM_L2_CONTEXT1_IDENTITY_APERTURE_HIGH_ADDR_HI32_BASE_IDX                                   0
#define regGCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32                                                0x15db
#define regGCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_LO32_BASE_IDX                                       0
#define regGCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32                                                0x15dc
#define regGCVM_L2_CONTEXT_IDENTITY_PHYSICAL_OFFSET_HI32_BASE_IDX                                       0
#define regGCVM_L2_CNTL4                                                                                0x15dd
#define regGCVM_L2_CNTL4_BASE_IDX                                                                       0
#define regGCVM_L2_MM_GROUP_RT_CLASSES                                                                  0x15de
#define regGCVM_L2_MM_GROUP_RT_CLASSES_BASE_IDX                                                         0
#define regGCVM_L2_BANK_SELECT_RESERVED_CID                                                             0x15df
#define regGCVM_L2_BANK_SELECT_RESERVED_CID_BASE_IDX                                                    0
#define regGCVM_L2_BANK_SELECT_RESERVED_CID2                                                            0x15e0
#define regGCVM_L2_BANK_SELECT_RESERVED_CID2_BASE_IDX                                                   0
#define regGCVM_L2_CACHE_PARITY_CNTL                                                                    0x15e1
#define regGCVM_L2_CACHE_PARITY_CNTL_BASE_IDX                                                           0
#define regGCVM_L2_ICG_CTRL                                                                             0x15e2
#define regGCVM_L2_ICG_CTRL_BASE_IDX                                                                    0
#define regGCVM_L2_CNTL5                                                                                0x15e3
#define regGCVM_L2_CNTL5_BASE_IDX                                                                       0
#define regGCVM_L2_GCR_CNTL                                                                             0x15e4
#define regGCVM_L2_GCR_CNTL_BASE_IDX                                                                    0
#define regGCVML2_WALKER_MACRO_THROTTLE_TIME                                                            0x15e5
#define regGCVML2_WALKER_MACRO_THROTTLE_TIME_BASE_IDX                                                   0
#define regGCVML2_WALKER_MACRO_THROTTLE_FETCH_LIMIT                                                     0x15e6
#define regGCVML2_WALKER_MACRO_THROTTLE_FETCH_LIMIT_BASE_IDX                                            0
#define regGCVML2_WALKER_MICRO_THROTTLE_TIME                                                            0x15e7
#define regGCVML2_WALKER_MICRO_THROTTLE_TIME_BASE_IDX                                                   0
#define regGCVML2_WALKER_MICRO_THROTTLE_FETCH_LIMIT                                                     0x15e8
#define regGCVML2_WALKER_MICRO_THROTTLE_FETCH_LIMIT_BASE_IDX                                            0
#define regGCVM_L2_CGTT_BUSY_CTRL                                                                       0x15e9
#define regGCVM_L2_CGTT_BUSY_CTRL_BASE_IDX                                                              0
#define regGCVM_L2_PTE_CACHE_DUMP_CNTL                                                                  0x15ea
#define regGCVM_L2_PTE_CACHE_DUMP_CNTL_BASE_IDX                                                         0
#define regGCVM_L2_PTE_CACHE_DUMP_READ                                                                  0x15eb
#define regGCVM_L2_PTE_CACHE_DUMP_READ_BASE_IDX                                                         0
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_LO32                                        0x15ee
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_LO32_BASE_IDX                               0
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_HI32                                        0x15ef
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ADDR_HI32_BASE_IDX                               0
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR                                             0x15f0
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_REQUEST_ATTR_BASE_IDX                                    0
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_LO32                                       0x15f1
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_LO32_BASE_IDX                              0
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_HI32                                       0x15f2
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ADDR_HI32_BASE_IDX                              0
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR                                            0x15f3
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_RESPONSE_ATTR_BASE_IDX                                   0
#define regGCVM_L2_BANK_SELECT_MASKS                                                                    0x15f4
#define regGCVM_L2_BANK_SELECT_MASKS_BASE_IDX                                                           0
#define regGCUTCL2_CREDIT_SAFETY_GROUP_RET_CDC                                                          0x15f5
#define regGCUTCL2_CREDIT_SAFETY_GROUP_RET_CDC_BASE_IDX                                                 0
#define regGCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_CDC                                               0x15f6
#define regGCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_CDC_BASE_IDX                                      0
#define regGCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_NOCDC                                             0x15f7
#define regGCUTCL2_CREDIT_SAFETY_GROUP_CLIENTS_INVREQ_NOCDC_BASE_IDX                                    0
#define regGCVML2_CREDIT_SAFETY_IH_FAULT_INTERRUPT                                                      0x15f8
#define regGCVML2_CREDIT_SAFETY_IH_FAULT_INTERRUPT_BASE_IDX                                             0
#define regGCVML2_WALKER_CREDIT_SAFETY_FETCH_RDREQ                                                      0x15f9
#define regGCVML2_WALKER_CREDIT_SAFETY_FETCH_RDREQ_BASE_IDX                                             0


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvmsharedvcdec
// base address: 0xa1d0
#define regGCMC_VM_FB_LOCATION_BASE                                                                     0x1614
#define regGCMC_VM_FB_LOCATION_BASE_BASE_IDX                                                            0
#define regGCMC_VM_FB_LOCATION_TOP                                                                      0x1615
#define regGCMC_VM_FB_LOCATION_TOP_BASE_IDX                                                             0
#define regGCMC_VM_AGP_TOP                                                                              0x1616
#define regGCMC_VM_AGP_TOP_BASE_IDX                                                                     0
#define regGCMC_VM_AGP_BOT                                                                              0x1617
#define regGCMC_VM_AGP_BOT_BASE_IDX                                                                     0
#define regGCMC_VM_AGP_BASE                                                                             0x1618
#define regGCMC_VM_AGP_BASE_BASE_IDX                                                                    0
#define regGCMC_VM_SYSTEM_APERTURE_LOW_ADDR                                                             0x1619
#define regGCMC_VM_SYSTEM_APERTURE_LOW_ADDR_BASE_IDX                                                    0
#define regGCMC_VM_SYSTEM_APERTURE_HIGH_ADDR                                                            0x161a
#define regGCMC_VM_SYSTEM_APERTURE_HIGH_ADDR_BASE_IDX                                                   0
#define regGCMC_VM_MX_L1_TLB_CNTL                                                                       0x161b
#define regGCMC_VM_MX_L1_TLB_CNTL_BASE_IDX                                                              0


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvml2vcdec
// base address: 0xa210
#define regGCVM_CONTEXT0_CNTL                                                                           0x1624
#define regGCVM_CONTEXT0_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT1_CNTL                                                                           0x1625
#define regGCVM_CONTEXT1_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT2_CNTL                                                                           0x1626
#define regGCVM_CONTEXT2_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT3_CNTL                                                                           0x1627
#define regGCVM_CONTEXT3_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT4_CNTL                                                                           0x1628
#define regGCVM_CONTEXT4_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT5_CNTL                                                                           0x1629
#define regGCVM_CONTEXT5_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT6_CNTL                                                                           0x162a
#define regGCVM_CONTEXT6_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT7_CNTL                                                                           0x162b
#define regGCVM_CONTEXT7_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT8_CNTL                                                                           0x162c
#define regGCVM_CONTEXT8_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT9_CNTL                                                                           0x162d
#define regGCVM_CONTEXT9_CNTL_BASE_IDX                                                                  0
#define regGCVM_CONTEXT10_CNTL                                                                          0x162e
#define regGCVM_CONTEXT10_CNTL_BASE_IDX                                                                 0
#define regGCVM_CONTEXT11_CNTL                                                                          0x162f
#define regGCVM_CONTEXT11_CNTL_BASE_IDX                                                                 0
#define regGCVM_CONTEXT12_CNTL                                                                          0x1630
#define regGCVM_CONTEXT12_CNTL_BASE_IDX                                                                 0
#define regGCVM_CONTEXT13_CNTL                                                                          0x1631
#define regGCVM_CONTEXT13_CNTL_BASE_IDX                                                                 0
#define regGCVM_CONTEXT14_CNTL                                                                          0x1632
#define regGCVM_CONTEXT14_CNTL_BASE_IDX                                                                 0
#define regGCVM_CONTEXT15_CNTL                                                                          0x1633
#define regGCVM_CONTEXT15_CNTL_BASE_IDX                                                                 0
#define regGCVM_CONTEXTS_DISABLE                                                                        0x1634
#define regGCVM_CONTEXTS_DISABLE_BASE_IDX                                                               0
#define regGCVM_INVALIDATE_ENG0_SEM                                                                     0x1635
#define regGCVM_INVALIDATE_ENG0_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG1_SEM                                                                     0x1636
#define regGCVM_INVALIDATE_ENG1_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG2_SEM                                                                     0x1637
#define regGCVM_INVALIDATE_ENG2_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG3_SEM                                                                     0x1638
#define regGCVM_INVALIDATE_ENG3_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG4_SEM                                                                     0x1639
#define regGCVM_INVALIDATE_ENG4_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG5_SEM                                                                     0x163a
#define regGCVM_INVALIDATE_ENG5_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG6_SEM                                                                     0x163b
#define regGCVM_INVALIDATE_ENG6_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG7_SEM                                                                     0x163c
#define regGCVM_INVALIDATE_ENG7_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG8_SEM                                                                     0x163d
#define regGCVM_INVALIDATE_ENG8_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG9_SEM                                                                     0x163e
#define regGCVM_INVALIDATE_ENG9_SEM_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG10_SEM                                                                    0x163f
#define regGCVM_INVALIDATE_ENG10_SEM_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG11_SEM                                                                    0x1640
#define regGCVM_INVALIDATE_ENG11_SEM_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG12_SEM                                                                    0x1641
#define regGCVM_INVALIDATE_ENG12_SEM_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG13_SEM                                                                    0x1642
#define regGCVM_INVALIDATE_ENG13_SEM_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG14_SEM                                                                    0x1643
#define regGCVM_INVALIDATE_ENG14_SEM_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG15_SEM                                                                    0x1644
#define regGCVM_INVALIDATE_ENG15_SEM_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG16_SEM                                                                    0x1645
#define regGCVM_INVALIDATE_ENG16_SEM_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG17_SEM                                                                    0x1646
#define regGCVM_INVALIDATE_ENG17_SEM_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG0_REQ                                                                     0x1647
#define regGCVM_INVALIDATE_ENG0_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG1_REQ                                                                     0x1648
#define regGCVM_INVALIDATE_ENG1_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG2_REQ                                                                     0x1649
#define regGCVM_INVALIDATE_ENG2_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG3_REQ                                                                     0x164a
#define regGCVM_INVALIDATE_ENG3_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG4_REQ                                                                     0x164b
#define regGCVM_INVALIDATE_ENG4_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG5_REQ                                                                     0x164c
#define regGCVM_INVALIDATE_ENG5_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG6_REQ                                                                     0x164d
#define regGCVM_INVALIDATE_ENG6_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG7_REQ                                                                     0x164e
#define regGCVM_INVALIDATE_ENG7_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG8_REQ                                                                     0x164f
#define regGCVM_INVALIDATE_ENG8_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG9_REQ                                                                     0x1650
#define regGCVM_INVALIDATE_ENG9_REQ_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG10_REQ                                                                    0x1651
#define regGCVM_INVALIDATE_ENG10_REQ_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG11_REQ                                                                    0x1652
#define regGCVM_INVALIDATE_ENG11_REQ_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG12_REQ                                                                    0x1653
#define regGCVM_INVALIDATE_ENG12_REQ_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG13_REQ                                                                    0x1654
#define regGCVM_INVALIDATE_ENG13_REQ_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG14_REQ                                                                    0x1655
#define regGCVM_INVALIDATE_ENG14_REQ_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG15_REQ                                                                    0x1656
#define regGCVM_INVALIDATE_ENG15_REQ_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG16_REQ                                                                    0x1657
#define regGCVM_INVALIDATE_ENG16_REQ_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG17_REQ                                                                    0x1658
#define regGCVM_INVALIDATE_ENG17_REQ_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG0_ACK                                                                     0x1659
#define regGCVM_INVALIDATE_ENG0_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG1_ACK                                                                     0x165a
#define regGCVM_INVALIDATE_ENG1_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG2_ACK                                                                     0x165b
#define regGCVM_INVALIDATE_ENG2_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG3_ACK                                                                     0x165c
#define regGCVM_INVALIDATE_ENG3_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG4_ACK                                                                     0x165d
#define regGCVM_INVALIDATE_ENG4_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG5_ACK                                                                     0x165e
#define regGCVM_INVALIDATE_ENG5_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG6_ACK                                                                     0x165f
#define regGCVM_INVALIDATE_ENG6_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG7_ACK                                                                     0x1660
#define regGCVM_INVALIDATE_ENG7_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG8_ACK                                                                     0x1661
#define regGCVM_INVALIDATE_ENG8_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG9_ACK                                                                     0x1662
#define regGCVM_INVALIDATE_ENG9_ACK_BASE_IDX                                                            0
#define regGCVM_INVALIDATE_ENG10_ACK                                                                    0x1663
#define regGCVM_INVALIDATE_ENG10_ACK_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG11_ACK                                                                    0x1664
#define regGCVM_INVALIDATE_ENG11_ACK_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG12_ACK                                                                    0x1665
#define regGCVM_INVALIDATE_ENG12_ACK_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG13_ACK                                                                    0x1666
#define regGCVM_INVALIDATE_ENG13_ACK_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG14_ACK                                                                    0x1667
#define regGCVM_INVALIDATE_ENG14_ACK_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG15_ACK                                                                    0x1668
#define regGCVM_INVALIDATE_ENG15_ACK_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG16_ACK                                                                    0x1669
#define regGCVM_INVALIDATE_ENG16_ACK_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG17_ACK                                                                    0x166a
#define regGCVM_INVALIDATE_ENG17_ACK_BASE_IDX                                                           0
#define regGCVM_INVALIDATE_ENG0_ADDR_RANGE_LO32                                                         0x166b
#define regGCVM_INVALIDATE_ENG0_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG0_ADDR_RANGE_HI32                                                         0x166c
#define regGCVM_INVALIDATE_ENG0_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG1_ADDR_RANGE_LO32                                                         0x166d
#define regGCVM_INVALIDATE_ENG1_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG1_ADDR_RANGE_HI32                                                         0x166e
#define regGCVM_INVALIDATE_ENG1_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG2_ADDR_RANGE_LO32                                                         0x166f
#define regGCVM_INVALIDATE_ENG2_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG2_ADDR_RANGE_HI32                                                         0x1670
#define regGCVM_INVALIDATE_ENG2_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG3_ADDR_RANGE_LO32                                                         0x1671
#define regGCVM_INVALIDATE_ENG3_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG3_ADDR_RANGE_HI32                                                         0x1672
#define regGCVM_INVALIDATE_ENG3_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG4_ADDR_RANGE_LO32                                                         0x1673
#define regGCVM_INVALIDATE_ENG4_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG4_ADDR_RANGE_HI32                                                         0x1674
#define regGCVM_INVALIDATE_ENG4_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG5_ADDR_RANGE_LO32                                                         0x1675
#define regGCVM_INVALIDATE_ENG5_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG5_ADDR_RANGE_HI32                                                         0x1676
#define regGCVM_INVALIDATE_ENG5_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG6_ADDR_RANGE_LO32                                                         0x1677
#define regGCVM_INVALIDATE_ENG6_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG6_ADDR_RANGE_HI32                                                         0x1678
#define regGCVM_INVALIDATE_ENG6_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG7_ADDR_RANGE_LO32                                                         0x1679
#define regGCVM_INVALIDATE_ENG7_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG7_ADDR_RANGE_HI32                                                         0x167a
#define regGCVM_INVALIDATE_ENG7_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG8_ADDR_RANGE_LO32                                                         0x167b
#define regGCVM_INVALIDATE_ENG8_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG8_ADDR_RANGE_HI32                                                         0x167c
#define regGCVM_INVALIDATE_ENG8_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG9_ADDR_RANGE_LO32                                                         0x167d
#define regGCVM_INVALIDATE_ENG9_ADDR_RANGE_LO32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG9_ADDR_RANGE_HI32                                                         0x167e
#define regGCVM_INVALIDATE_ENG9_ADDR_RANGE_HI32_BASE_IDX                                                0
#define regGCVM_INVALIDATE_ENG10_ADDR_RANGE_LO32                                                        0x167f
#define regGCVM_INVALIDATE_ENG10_ADDR_RANGE_LO32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG10_ADDR_RANGE_HI32                                                        0x1680
#define regGCVM_INVALIDATE_ENG10_ADDR_RANGE_HI32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG11_ADDR_RANGE_LO32                                                        0x1681
#define regGCVM_INVALIDATE_ENG11_ADDR_RANGE_LO32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG11_ADDR_RANGE_HI32                                                        0x1682
#define regGCVM_INVALIDATE_ENG11_ADDR_RANGE_HI32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG12_ADDR_RANGE_LO32                                                        0x1683
#define regGCVM_INVALIDATE_ENG12_ADDR_RANGE_LO32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG12_ADDR_RANGE_HI32                                                        0x1684
#define regGCVM_INVALIDATE_ENG12_ADDR_RANGE_HI32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG13_ADDR_RANGE_LO32                                                        0x1685
#define regGCVM_INVALIDATE_ENG13_ADDR_RANGE_LO32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG13_ADDR_RANGE_HI32                                                        0x1686
#define regGCVM_INVALIDATE_ENG13_ADDR_RANGE_HI32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG14_ADDR_RANGE_LO32                                                        0x1687
#define regGCVM_INVALIDATE_ENG14_ADDR_RANGE_LO32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG14_ADDR_RANGE_HI32                                                        0x1688
#define regGCVM_INVALIDATE_ENG14_ADDR_RANGE_HI32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG15_ADDR_RANGE_LO32                                                        0x1689
#define regGCVM_INVALIDATE_ENG15_ADDR_RANGE_LO32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG15_ADDR_RANGE_HI32                                                        0x168a
#define regGCVM_INVALIDATE_ENG15_ADDR_RANGE_HI32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG16_ADDR_RANGE_LO32                                                        0x168b
#define regGCVM_INVALIDATE_ENG16_ADDR_RANGE_LO32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG16_ADDR_RANGE_HI32                                                        0x168c
#define regGCVM_INVALIDATE_ENG16_ADDR_RANGE_HI32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG17_ADDR_RANGE_LO32                                                        0x168d
#define regGCVM_INVALIDATE_ENG17_ADDR_RANGE_LO32_BASE_IDX                                               0
#define regGCVM_INVALIDATE_ENG17_ADDR_RANGE_HI32                                                        0x168e
#define regGCVM_INVALIDATE_ENG17_ADDR_RANGE_HI32_BASE_IDX                                               0
#define regGCVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32                                                      0x168f
#define regGCVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1690
#define regGCVM_CONTEXT0_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1691
#define regGCVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1692
#define regGCVM_CONTEXT1_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1693
#define regGCVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1694
#define regGCVM_CONTEXT2_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1695
#define regGCVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1696
#define regGCVM_CONTEXT3_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1697
#define regGCVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32                                                      0x1698
#define regGCVM_CONTEXT4_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32                                                      0x1699
#define regGCVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32                                                      0x169a
#define regGCVM_CONTEXT5_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32                                                      0x169b
#define regGCVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32                                                      0x169c
#define regGCVM_CONTEXT6_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32                                                      0x169d
#define regGCVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32                                                      0x169e
#define regGCVM_CONTEXT7_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32                                                      0x169f
#define regGCVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32                                                      0x16a0
#define regGCVM_CONTEXT8_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32                                                      0x16a1
#define regGCVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32                                                      0x16a2
#define regGCVM_CONTEXT9_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32                                                     0x16a3
#define regGCVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32                                                     0x16a4
#define regGCVM_CONTEXT10_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32                                                     0x16a5
#define regGCVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32                                                     0x16a6
#define regGCVM_CONTEXT11_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32                                                     0x16a7
#define regGCVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32                                                     0x16a8
#define regGCVM_CONTEXT12_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32                                                     0x16a9
#define regGCVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32                                                     0x16aa
#define regGCVM_CONTEXT13_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32                                                     0x16ab
#define regGCVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32                                                     0x16ac
#define regGCVM_CONTEXT14_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32                                                     0x16ad
#define regGCVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32                                                     0x16ae
#define regGCVM_CONTEXT15_PAGE_TABLE_BASE_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32                                                     0x16af
#define regGCVM_CONTEXT0_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32                                                     0x16b0
#define regGCVM_CONTEXT0_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32                                                     0x16b1
#define regGCVM_CONTEXT1_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32                                                     0x16b2
#define regGCVM_CONTEXT1_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32                                                     0x16b3
#define regGCVM_CONTEXT2_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32                                                     0x16b4
#define regGCVM_CONTEXT2_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32                                                     0x16b5
#define regGCVM_CONTEXT3_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32                                                     0x16b6
#define regGCVM_CONTEXT3_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32                                                     0x16b7
#define regGCVM_CONTEXT4_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32                                                     0x16b8
#define regGCVM_CONTEXT4_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32                                                     0x16b9
#define regGCVM_CONTEXT5_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32                                                     0x16ba
#define regGCVM_CONTEXT5_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32                                                     0x16bb
#define regGCVM_CONTEXT6_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32                                                     0x16bc
#define regGCVM_CONTEXT6_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32                                                     0x16bd
#define regGCVM_CONTEXT7_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32                                                     0x16be
#define regGCVM_CONTEXT7_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32                                                     0x16bf
#define regGCVM_CONTEXT8_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32                                                     0x16c0
#define regGCVM_CONTEXT8_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32                                                     0x16c1
#define regGCVM_CONTEXT9_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                            0
#define regGCVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32                                                     0x16c2
#define regGCVM_CONTEXT9_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                            0
#define regGCVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32                                                    0x16c3
#define regGCVM_CONTEXT10_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define regGCVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32                                                    0x16c4
#define regGCVM_CONTEXT10_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define regGCVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32                                                    0x16c5
#define regGCVM_CONTEXT11_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define regGCVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32                                                    0x16c6
#define regGCVM_CONTEXT11_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define regGCVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32                                                    0x16c7
#define regGCVM_CONTEXT12_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define regGCVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32                                                    0x16c8
#define regGCVM_CONTEXT12_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define regGCVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32                                                    0x16c9
#define regGCVM_CONTEXT13_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define regGCVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32                                                    0x16ca
#define regGCVM_CONTEXT13_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define regGCVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32                                                    0x16cb
#define regGCVM_CONTEXT14_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define regGCVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32                                                    0x16cc
#define regGCVM_CONTEXT14_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define regGCVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32                                                    0x16cd
#define regGCVM_CONTEXT15_PAGE_TABLE_START_ADDR_LO32_BASE_IDX                                           0
#define regGCVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32                                                    0x16ce
#define regGCVM_CONTEXT15_PAGE_TABLE_START_ADDR_HI32_BASE_IDX                                           0
#define regGCVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32                                                       0x16cf
#define regGCVM_CONTEXT0_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32                                                       0x16d0
#define regGCVM_CONTEXT0_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32                                                       0x16d1
#define regGCVM_CONTEXT1_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32                                                       0x16d2
#define regGCVM_CONTEXT1_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32                                                       0x16d3
#define regGCVM_CONTEXT2_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32                                                       0x16d4
#define regGCVM_CONTEXT2_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32                                                       0x16d5
#define regGCVM_CONTEXT3_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32                                                       0x16d6
#define regGCVM_CONTEXT3_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32                                                       0x16d7
#define regGCVM_CONTEXT4_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32                                                       0x16d8
#define regGCVM_CONTEXT4_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32                                                       0x16d9
#define regGCVM_CONTEXT5_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32                                                       0x16da
#define regGCVM_CONTEXT5_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32                                                       0x16db
#define regGCVM_CONTEXT6_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32                                                       0x16dc
#define regGCVM_CONTEXT6_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32                                                       0x16dd
#define regGCVM_CONTEXT7_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32                                                       0x16de
#define regGCVM_CONTEXT7_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32                                                       0x16df
#define regGCVM_CONTEXT8_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32                                                       0x16e0
#define regGCVM_CONTEXT8_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32                                                       0x16e1
#define regGCVM_CONTEXT9_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                              0
#define regGCVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32                                                       0x16e2
#define regGCVM_CONTEXT9_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                              0
#define regGCVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32                                                      0x16e3
#define regGCVM_CONTEXT10_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32                                                      0x16e4
#define regGCVM_CONTEXT10_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32                                                      0x16e5
#define regGCVM_CONTEXT11_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32                                                      0x16e6
#define regGCVM_CONTEXT11_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32                                                      0x16e7
#define regGCVM_CONTEXT12_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32                                                      0x16e8
#define regGCVM_CONTEXT12_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32                                                      0x16e9
#define regGCVM_CONTEXT13_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32                                                      0x16ea
#define regGCVM_CONTEXT13_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32                                                      0x16eb
#define regGCVM_CONTEXT14_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32                                                      0x16ec
#define regGCVM_CONTEXT14_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32                                                      0x16ed
#define regGCVM_CONTEXT15_PAGE_TABLE_END_ADDR_LO32_BASE_IDX                                             0
#define regGCVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32                                                      0x16ee
#define regGCVM_CONTEXT15_PAGE_TABLE_END_ADDR_HI32_BASE_IDX                                             0
#define regGCVM_L2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                                    0x16ef
#define regGCVM_L2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                           0
#define regGCVM_L2_CONTEXT0_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f0
#define regGCVM_L2_CONTEXT0_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT1_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f1
#define regGCVM_L2_CONTEXT1_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f2
#define regGCVM_L2_CONTEXT2_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT3_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f3
#define regGCVM_L2_CONTEXT3_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT4_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f4
#define regGCVM_L2_CONTEXT4_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT5_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f5
#define regGCVM_L2_CONTEXT5_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT6_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f6
#define regGCVM_L2_CONTEXT6_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT7_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f7
#define regGCVM_L2_CONTEXT7_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT8_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f8
#define regGCVM_L2_CONTEXT8_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT9_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                           0x16f9
#define regGCVM_L2_CONTEXT9_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                  0
#define regGCVM_L2_CONTEXT10_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16fa
#define regGCVM_L2_CONTEXT10_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define regGCVM_L2_CONTEXT11_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16fb
#define regGCVM_L2_CONTEXT11_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define regGCVM_L2_CONTEXT12_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16fc
#define regGCVM_L2_CONTEXT12_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define regGCVM_L2_CONTEXT13_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16fd
#define regGCVM_L2_CONTEXT13_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define regGCVM_L2_CONTEXT14_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16fe
#define regGCVM_L2_CONTEXT14_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0
#define regGCVM_L2_CONTEXT15_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES                                          0x16ff
#define regGCVM_L2_CONTEXT15_PER_PFVF_PTE_CACHE_FRAGMENT_SIZES_BASE_IDX                                 0


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvml2perfddec
// base address: 0x35380
#define regGCVML2_PERFCOUNTER2_0_LO                                                                     0x34e0
#define regGCVML2_PERFCOUNTER2_0_LO_BASE_IDX                                                            1
#define regGCVML2_PERFCOUNTER2_1_LO                                                                     0x34e1
#define regGCVML2_PERFCOUNTER2_1_LO_BASE_IDX                                                            1
#define regGCVML2_PERFCOUNTER2_0_HI                                                                     0x34e2
#define regGCVML2_PERFCOUNTER2_0_HI_BASE_IDX                                                            1
#define regGCVML2_PERFCOUNTER2_1_HI                                                                     0x34e3
#define regGCVML2_PERFCOUNTER2_1_HI_BASE_IDX                                                            1


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvml2prdec
// base address: 0x35390
#define regGCMC_VM_L2_PERFCOUNTER_LO                                                                    0x34e4
#define regGCMC_VM_L2_PERFCOUNTER_LO_BASE_IDX                                                           1
#define regGCMC_VM_L2_PERFCOUNTER_HI                                                                    0x34e5
#define regGCMC_VM_L2_PERFCOUNTER_HI_BASE_IDX                                                           1
#define regGCUTCL2_PERFCOUNTER_LO                                                                       0x34e6
#define regGCUTCL2_PERFCOUNTER_LO_BASE_IDX                                                              1
#define regGCUTCL2_PERFCOUNTER_HI                                                                       0x34e7
#define regGCUTCL2_PERFCOUNTER_HI_BASE_IDX                                                              1


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvml2perfsdec
// base address: 0x37480
#define regGCVML2_PERFCOUNTER2_0_SELECT                                                                 0x3d20
#define regGCVML2_PERFCOUNTER2_0_SELECT_BASE_IDX                                                        1
#define regGCVML2_PERFCOUNTER2_1_SELECT                                                                 0x3d21
#define regGCVML2_PERFCOUNTER2_1_SELECT_BASE_IDX                                                        1
#define regGCVML2_PERFCOUNTER2_0_SELECT1                                                                0x3d22
#define regGCVML2_PERFCOUNTER2_0_SELECT1_BASE_IDX                                                       1
#define regGCVML2_PERFCOUNTER2_1_SELECT1                                                                0x3d23
#define regGCVML2_PERFCOUNTER2_1_SELECT1_BASE_IDX                                                       1
#define regGCVML2_PERFCOUNTER2_0_MODE                                                                   0x3d24
#define regGCVML2_PERFCOUNTER2_0_MODE_BASE_IDX                                                          1
#define regGCVML2_PERFCOUNTER2_1_MODE                                                                   0x3d25
#define regGCVML2_PERFCOUNTER2_1_MODE_BASE_IDX                                                          1


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvml2pldec
// base address: 0x374c0
#define regGCMC_VM_L2_PERFCOUNTER0_CFG                                                                  0x3d30
#define regGCMC_VM_L2_PERFCOUNTER0_CFG_BASE_IDX                                                         1
#define regGCMC_VM_L2_PERFCOUNTER1_CFG                                                                  0x3d31
#define regGCMC_VM_L2_PERFCOUNTER1_CFG_BASE_IDX                                                         1
#define regGCMC_VM_L2_PERFCOUNTER2_CFG                                                                  0x3d32
#define regGCMC_VM_L2_PERFCOUNTER2_CFG_BASE_IDX                                                         1
#define regGCMC_VM_L2_PERFCOUNTER3_CFG                                                                  0x3d33
#define regGCMC_VM_L2_PERFCOUNTER3_CFG_BASE_IDX                                                         1
#define regGCMC_VM_L2_PERFCOUNTER4_CFG                                                                  0x3d34
#define regGCMC_VM_L2_PERFCOUNTER4_CFG_BASE_IDX                                                         1
#define regGCMC_VM_L2_PERFCOUNTER5_CFG                                                                  0x3d35
#define regGCMC_VM_L2_PERFCOUNTER5_CFG_BASE_IDX                                                         1
#define regGCMC_VM_L2_PERFCOUNTER6_CFG                                                                  0x3d36
#define regGCMC_VM_L2_PERFCOUNTER6_CFG_BASE_IDX                                                         1
#define regGCMC_VM_L2_PERFCOUNTER7_CFG                                                                  0x3d37
#define regGCMC_VM_L2_PERFCOUNTER7_CFG_BASE_IDX                                                         1
#define regGCMC_VM_L2_PERFCOUNTER_RSLT_CNTL                                                             0x3d38
#define regGCMC_VM_L2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                    1
#define regGCUTCL2_PERFCOUNTER0_CFG                                                                     0x3d39
#define regGCUTCL2_PERFCOUNTER0_CFG_BASE_IDX                                                            1
#define regGCUTCL2_PERFCOUNTER1_CFG                                                                     0x3d3a
#define regGCUTCL2_PERFCOUNTER1_CFG_BASE_IDX                                                            1
#define regGCUTCL2_PERFCOUNTER2_CFG                                                                     0x3d3b
#define regGCUTCL2_PERFCOUNTER2_CFG_BASE_IDX                                                            1
#define regGCUTCL2_PERFCOUNTER3_CFG                                                                     0x3d3c
#define regGCUTCL2_PERFCOUNTER3_CFG_BASE_IDX                                                            1
#define regGCUTCL2_PERFCOUNTER_RSLT_CNTL                                                                0x3d3d
#define regGCUTCL2_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                       1


// addressBlock: gc_gfx_cpwd_gcutcl2_gcvml2pspdec
// base address: 0x3f900
#define regGCUTCL2_TRANSLATION_BYPASS_BY_VMID                                                           0x5e41
#define regGCUTCL2_TRANSLATION_BYPASS_BY_VMID_BASE_IDX                                                  1
#define regGCVM_IOMMU_GPU_HOST_TRANSLATION_ENABLE                                                       0x5e43
#define regGCVM_IOMMU_GPU_HOST_TRANSLATION_ENABLE_BASE_IDX                                              1
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_CNTL                                                     0x5e44
#define regGCUTC_GPUVA_VMID_TRANSLATION_ASSIST_CNTL_BASE_IDX                                            1
#define regGCVM_IOMMU_CONTROL_REGISTER                                                                  0x5e45
#define regGCVM_IOMMU_CONTROL_REGISTER_BASE_IDX                                                         1
#define regGCVM_IOMMU_PERFORMANCE_OPTIMIZATION_CONTROL_REGISTER                                         0x5e46
#define regGCVM_IOMMU_PERFORMANCE_OPTIMIZATION_CONTROL_REGISTER_BASE_IDX                                1
#define regGCUTC_TRANSLATION_FAULT_CNTL0                                                                0x5e47
#define regGCUTC_TRANSLATION_FAULT_CNTL0_BASE_IDX                                                       1
#define regGCUTC_TRANSLATION_FAULT_CNTL1                                                                0x5e48
#define regGCUTC_TRANSLATION_FAULT_CNTL1_BASE_IDX                                                       1
#define regGCUTCL2_COMP_EN_OVERRIDES                                                                    0x5e49
#define regGCUTCL2_COMP_EN_OVERRIDES_BASE_IDX                                                           1


// addressBlock: gc_gfx_cpwd_cpwd_cppdec
// base address: 0xc080
#define regCP_CU_MASK_ADDR_LO                                                                           0x1dd2
#define regCP_CU_MASK_ADDR_LO_BASE_IDX                                                                  0
#define regCP_CU_MASK_ADDR_HI                                                                           0x1dd3
#define regCP_CU_MASK_ADDR_HI_BASE_IDX                                                                  0
#define regCP_CU_MASK_CNTL                                                                              0x1dd4
#define regCP_CU_MASK_CNTL_BASE_IDX                                                                     0
#define regCP_EOPQ_WAIT_TIME                                                                            0x1dd5
#define regCP_EOPQ_WAIT_TIME_BASE_IDX                                                                   0
#define regCP_CPC_MGCG_SYNC_CNTL                                                                        0x1dd6
#define regCP_CPC_MGCG_SYNC_CNTL_BASE_IDX                                                               0
#define regCPC_INT_INFO                                                                                 0x1dd7
#define regCPC_INT_INFO_BASE_IDX                                                                        0
#define regCP_VIRT_STATUS                                                                               0x1dd8
#define regCP_VIRT_STATUS_BASE_IDX                                                                      0
#define regCPC_INT_ADDR                                                                                 0x1dd9
#define regCPC_INT_ADDR_BASE_IDX                                                                        0
#define regCPC_INT_PASID                                                                                0x1dda
#define regCPC_INT_PASID_BASE_IDX                                                                       0
#define regCP_GFX_ERROR                                                                                 0x1ddb
#define regCP_GFX_ERROR_BASE_IDX                                                                        0
#define regCPG_UTCL1_CNTL                                                                               0x1ddc
#define regCPG_UTCL1_CNTL_BASE_IDX                                                                      0
#define regCPC_UTCL1_CNTL                                                                               0x1ddd
#define regCPC_UTCL1_CNTL_BASE_IDX                                                                      0
#define regCPF_UTCL1_CNTL                                                                               0x1dde
#define regCPF_UTCL1_CNTL_BASE_IDX                                                                      0
#define regCP_AQL_SMM_STATUS                                                                            0x1ddf
#define regCP_AQL_SMM_STATUS_BASE_IDX                                                                   0
#define regCP_RB0_BASE                                                                                  0x1de0
#define regCP_RB0_BASE_BASE_IDX                                                                         0
#define regCP_RB_BASE                                                                                   0x1de0
#define regCP_RB_BASE_BASE_IDX                                                                          0
#define regCP_RB0_CNTL                                                                                  0x1de1
#define regCP_RB0_CNTL_BASE_IDX                                                                         0
#define regCP_RB_CNTL                                                                                   0x1de1
#define regCP_RB_CNTL_BASE_IDX                                                                          0
#define regCP_RB_RPTR_WR                                                                                0x1de2
#define regCP_RB_RPTR_WR_BASE_IDX                                                                       0
#define regCP_RB0_RPTR_ADDR                                                                             0x1de3
#define regCP_RB0_RPTR_ADDR_BASE_IDX                                                                    0
#define regCP_RB_RPTR_ADDR                                                                              0x1de3
#define regCP_RB_RPTR_ADDR_BASE_IDX                                                                     0
#define regCP_RB0_RPTR_ADDR_HI                                                                          0x1de4
#define regCP_RB0_RPTR_ADDR_HI_BASE_IDX                                                                 0
#define regCP_RB_RPTR_ADDR_HI                                                                           0x1de4
#define regCP_RB_RPTR_ADDR_HI_BASE_IDX                                                                  0
#define regCP_RB0_BUFSZ_MASK                                                                            0x1de5
#define regCP_RB0_BUFSZ_MASK_BASE_IDX                                                                   0
#define regCP_RB_BUFSZ_MASK                                                                             0x1de5
#define regCP_RB_BUFSZ_MASK_BASE_IDX                                                                    0
#define regCP_ME3_INT_STAT_DEBUG                                                                        0x1de6
#define regCP_ME3_INT_STAT_DEBUG_BASE_IDX                                                               0
#define regGC_PRIV_MODE                                                                                 0x1de8
#define regGC_PRIV_MODE_BASE_IDX                                                                        0
#define regCP_INT_CNTL                                                                                  0x1de9
#define regCP_INT_CNTL_BASE_IDX                                                                         0
#define regCP_INT_STATUS                                                                                0x1dea
#define regCP_INT_STATUS_BASE_IDX                                                                       0
#define regCP_DEVICE_ID                                                                                 0x1deb
#define regCP_DEVICE_ID_BASE_IDX                                                                        0
#define regCP_ME0_PIPE_PRIORITY_CNTS                                                                    0x1dec
#define regCP_ME0_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define regCP_RING_PRIORITY_CNTS                                                                        0x1dec
#define regCP_RING_PRIORITY_CNTS_BASE_IDX                                                               0
#define regCP_ME0_PIPE0_PRIORITY                                                                        0x1ded
#define regCP_ME0_PIPE0_PRIORITY_BASE_IDX                                                               0
#define regCP_RING0_PRIORITY                                                                            0x1ded
#define regCP_RING0_PRIORITY_BASE_IDX                                                                   0
#define regCP_FATAL_ERROR                                                                               0x1df0
#define regCP_FATAL_ERROR_BASE_IDX                                                                      0
#define regCP_RB_VMID                                                                                   0x1df1
#define regCP_RB_VMID_BASE_IDX                                                                          0
#define regCP_ME0_PIPE0_VMID                                                                            0x1df2
#define regCP_ME0_PIPE0_VMID_BASE_IDX                                                                   0
#define regCP_RB0_WPTR                                                                                  0x1df4
#define regCP_RB0_WPTR_BASE_IDX                                                                         0
#define regCP_RB_WPTR                                                                                   0x1df4
#define regCP_RB_WPTR_BASE_IDX                                                                          0
#define regCP_RB0_WPTR_HI                                                                               0x1df5
#define regCP_RB0_WPTR_HI_BASE_IDX                                                                      0
#define regCP_RB_WPTR_HI                                                                                0x1df5
#define regCP_RB_WPTR_HI_BASE_IDX                                                                       0
#define regCP_PROCESS_QUANTUM                                                                           0x1df9
#define regCP_PROCESS_QUANTUM_BASE_IDX                                                                  0
#define regCP_RB_DOORBELL_RANGE_LOWER                                                                   0x1dfa
#define regCP_RB_DOORBELL_RANGE_LOWER_BASE_IDX                                                          0
#define regCP_RB_DOORBELL_RANGE_UPPER                                                                   0x1dfb
#define regCP_RB_DOORBELL_RANGE_UPPER_BASE_IDX                                                          0
#define regCP_MEC_DOORBELL_RANGE_LOWER                                                                  0x1dfc
#define regCP_MEC_DOORBELL_RANGE_LOWER_BASE_IDX                                                         0
#define regCP_MEC_DOORBELL_RANGE_UPPER                                                                  0x1dfd
#define regCP_MEC_DOORBELL_RANGE_UPPER_BASE_IDX                                                         0
#define regCPG_UTCL1_ERROR                                                                              0x1dfe
#define regCPG_UTCL1_ERROR_BASE_IDX                                                                     0
#define regCPC_UTCL1_ERROR                                                                              0x1dff
#define regCPC_UTCL1_ERROR_BASE_IDX                                                                     0
#define regCP_IB1_BUFFER_COUNT                                                                          0x1e08
#define regCP_IB1_BUFFER_COUNT_BASE_IDX                                                                 0
#define regCP_IB2_BUFFER_COUNT                                                                          0x1e09
#define regCP_IB2_BUFFER_COUNT_BASE_IDX                                                                 0
#define regCP_INT_CNTL_RING0                                                                            0x1e0a
#define regCP_INT_CNTL_RING0_BASE_IDX                                                                   0
#define regCP_DEBUG_2                                                                                   0x1e0c
#define regCP_DEBUG_2_BASE_IDX                                                                          0
#define regCP_INT_STATUS_RING0                                                                          0x1e0d
#define regCP_INT_STATUS_RING0_BASE_IDX                                                                 0
#define regCP_ME_F32_INTERRUPT                                                                          0x1e13
#define regCP_ME_F32_INTERRUPT_BASE_IDX                                                                 0
#define regCP_PFP_F32_INTERRUPT                                                                         0x1e14
#define regCP_PFP_F32_INTERRUPT_BASE_IDX                                                                0
#define regCP_MEC1_F32_INTERRUPT                                                                        0x1e16
#define regCP_MEC1_F32_INTERRUPT_BASE_IDX                                                               0
#define regCP_PWR_CNTL                                                                                  0x1e18
#define regCP_PWR_CNTL_BASE_IDX                                                                         0
#define regCP_ECC_FIRSTOCCURRENCE                                                                       0x1e1a
#define regCP_ECC_FIRSTOCCURRENCE_BASE_IDX                                                              0
#define regCP_ECC_FIRSTOCCURRENCE_RING0                                                                 0x1e1b
#define regCP_ECC_FIRSTOCCURRENCE_RING0_BASE_IDX                                                        0
#define regGB_EDC_MODE                                                                                  0x1e1e
#define regGB_EDC_MODE_BASE_IDX                                                                         0
#define regCP_DEBUG                                                                                     0x1e1f
#define regCP_DEBUG_BASE_IDX                                                                            0
#define regCP_CPF_DEBUG                                                                                 0x1e20
#define regCP_CPF_DEBUG_BASE_IDX                                                                        0
#define regCP_CPC_DEBUG                                                                                 0x1e21
#define regCP_CPC_DEBUG_BASE_IDX                                                                        0
#define regCP_PQ_WPTR_POLL_CNTL                                                                         0x1e23
#define regCP_PQ_WPTR_POLL_CNTL_BASE_IDX                                                                0
#define regCP_PQ_WPTR_POLL_CNTL1                                                                        0x1e24
#define regCP_PQ_WPTR_POLL_CNTL1_BASE_IDX                                                               0
#define regCP_ME1_PIPE0_INT_CNTL                                                                        0x1e25
#define regCP_ME1_PIPE0_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME1_PIPE1_INT_CNTL                                                                        0x1e26
#define regCP_ME1_PIPE1_INT_CNTL_BASE_IDX                                                               0
#define regCP_ME1_PIPE0_INT_STATUS                                                                      0x1e2d
#define regCP_ME1_PIPE0_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME1_PIPE1_INT_STATUS                                                                      0x1e2e
#define regCP_ME1_PIPE1_INT_STATUS_BASE_IDX                                                             0
#define regCP_ME1_INT_STAT_DEBUG                                                                        0x1e35
#define regCP_ME1_INT_STAT_DEBUG_BASE_IDX                                                               0
#define regCP_GFX_QUEUE_INDEX                                                                           0x1e37
#define regCP_GFX_QUEUE_INDEX_BASE_IDX                                                                  0
#define regCC_GC_EDC_CONFIG                                                                             0x1e38
#define regCC_GC_EDC_CONFIG_BASE_IDX                                                                    0
#define regCP_ME1_PIPE_PRIORITY_CNTS                                                                    0x1e39
#define regCP_ME1_PIPE_PRIORITY_CNTS_BASE_IDX                                                           0
#define regCP_ME1_PIPE0_PRIORITY                                                                        0x1e3a
#define regCP_ME1_PIPE0_PRIORITY_BASE_IDX                                                               0
#define regCP_ME1_PIPE1_PRIORITY                                                                        0x1e3b
#define regCP_ME1_PIPE1_PRIORITY_BASE_IDX                                                               0
#define regCP_PFP_PRGRM_CNTR_START                                                                      0x1e44
#define regCP_PFP_PRGRM_CNTR_START_BASE_IDX                                                             0
#define regCP_ME_PRGRM_CNTR_START                                                                       0x1e45
#define regCP_ME_PRGRM_CNTR_START_BASE_IDX                                                              0
#define regCP_MEC1_PRGRM_CNTR_START                                                                     0x1e46
#define regCP_MEC1_PRGRM_CNTR_START_BASE_IDX                                                            0
#define regCP_PFP_INTR_ROUTINE_START                                                                    0x1e49
#define regCP_PFP_INTR_ROUTINE_START_BASE_IDX                                                           0
#define regCP_ME_INTR_ROUTINE_START                                                                     0x1e4a
#define regCP_ME_INTR_ROUTINE_START_BASE_IDX                                                            0
#define regCP_MEC1_INTR_ROUTINE_START                                                                   0x1e4b
#define regCP_MEC1_INTR_ROUTINE_START_BASE_IDX                                                          0
#define regCP_CONTEXT_CNTL                                                                              0x1e4d
#define regCP_CONTEXT_CNTL_BASE_IDX                                                                     0
#define regCP_MAX_CONTEXT                                                                               0x1e4e
#define regCP_MAX_CONTEXT_BASE_IDX                                                                      0
#define regCP_IQ_WAIT_TIME1                                                                             0x1e4f
#define regCP_IQ_WAIT_TIME1_BASE_IDX                                                                    0
#define regCP_IQ_WAIT_TIME2                                                                             0x1e50
#define regCP_IQ_WAIT_TIME2_BASE_IDX                                                                    0
#define regCP_RB0_BASE_HI                                                                               0x1e51
#define regCP_RB0_BASE_HI_BASE_IDX                                                                      0
#define regCP_VMID_RESET                                                                                0x1e53
#define regCP_VMID_RESET_BASE_IDX                                                                       0
#define regCPC_INT_CNTL                                                                                 0x1e54
#define regCPC_INT_CNTL_BASE_IDX                                                                        0
#define regCPC_INT_STATUS                                                                               0x1e55
#define regCPC_INT_STATUS_BASE_IDX                                                                      0
#define regCP_VMID_PREEMPT                                                                              0x1e56
#define regCP_VMID_PREEMPT_BASE_IDX                                                                     0
#define regCPC_INT_CNTX_ID                                                                              0x1e57
#define regCPC_INT_CNTX_ID_BASE_IDX                                                                     0
#define regCP_PQ_STATUS                                                                                 0x1e58
#define regCP_PQ_STATUS_BASE_IDX                                                                        0
#define regCP_PFP_PRGRM_CNTR_START_HI                                                                   0x1e59
#define regCP_PFP_PRGRM_CNTR_START_HI_BASE_IDX                                                          0
#define regCP_MAX_DRAW_COUNT                                                                            0x1e5c
#define regCP_MAX_DRAW_COUNT_BASE_IDX                                                                   0
#define regCP_VMID_STATUS                                                                               0x1e5f
#define regCP_VMID_STATUS_BASE_IDX                                                                      0
#define regCPC_SUSPEND_CTX_SAVE_BASE_ADDR_LO                                                            0x1e60
#define regCPC_SUSPEND_CTX_SAVE_BASE_ADDR_LO_BASE_IDX                                                   0
#define regCPC_SUSPEND_CTX_SAVE_BASE_ADDR_HI                                                            0x1e61
#define regCPC_SUSPEND_CTX_SAVE_BASE_ADDR_HI_BASE_IDX                                                   0
#define regCPC_SUSPEND_CTX_SAVE_CONTROL                                                                 0x1e62
#define regCPC_SUSPEND_CTX_SAVE_CONTROL_BASE_IDX                                                        0
#define regCPC_SUSPEND_CNTL_STACK_OFFSET                                                                0x1e63
#define regCPC_SUSPEND_CNTL_STACK_OFFSET_BASE_IDX                                                       0
#define regCPC_SUSPEND_CNTL_STACK_SIZE                                                                  0x1e64
#define regCPC_SUSPEND_CNTL_STACK_SIZE_BASE_IDX                                                         0
#define regCPC_SUSPEND_WG_STATE_OFFSET                                                                  0x1e65
#define regCPC_SUSPEND_WG_STATE_OFFSET_BASE_IDX                                                         0
#define regCPC_SUSPEND_CTX_SAVE_SIZE                                                                    0x1e66
#define regCPC_SUSPEND_CTX_SAVE_SIZE_BASE_IDX                                                           0
#define regCPC_OS_PIPES                                                                                 0x1e67
#define regCPC_OS_PIPES_BASE_IDX                                                                        0
#define regCP_SUSPEND_RESUME_REQ                                                                        0x1e68
#define regCP_SUSPEND_RESUME_REQ_BASE_IDX                                                               0
#define regCP_SUSPEND_CNTL                                                                              0x1e69
#define regCP_SUSPEND_CNTL_BASE_IDX                                                                     0
#define regCP_IQ_WAIT_TIME3                                                                             0x1e6a
#define regCP_IQ_WAIT_TIME3_BASE_IDX                                                                    0
#define regCPC_DDID_BASE_ADDR_LO                                                                        0x1e6b
#define regCPC_DDID_BASE_ADDR_LO_BASE_IDX                                                               0
#define regCP_DDID_BASE_ADDR_LO                                                                         0x1e6b
#define regCP_DDID_BASE_ADDR_LO_BASE_IDX                                                                0
#define regCPC_DDID_BASE_ADDR_HI                                                                        0x1e6c
#define regCPC_DDID_BASE_ADDR_HI_BASE_IDX                                                               0
#define regCP_DDID_BASE_ADDR_HI                                                                         0x1e6c
#define regCP_DDID_BASE_ADDR_HI_BASE_IDX                                                                0
#define regCPC_DDID_CNTL                                                                                0x1e6d
#define regCPC_DDID_CNTL_BASE_IDX                                                                       0
#define regCP_DDID_CNTL                                                                                 0x1e6d
#define regCP_DDID_CNTL_BASE_IDX                                                                        0
#define regCP_GFX_DDID_INFLIGHT_COUNT                                                                   0x1e6e
#define regCP_GFX_DDID_INFLIGHT_COUNT_BASE_IDX                                                          0
#define regCP_GFX_DDID_WPTR                                                                             0x1e6f
#define regCP_GFX_DDID_WPTR_BASE_IDX                                                                    0
#define regCP_GFX_DDID_RPTR                                                                             0x1e70
#define regCP_GFX_DDID_RPTR_BASE_IDX                                                                    0
#define regCP_GFX_DDID_DELTA_RPT_COUNT                                                                  0x1e71
#define regCP_GFX_DDID_DELTA_RPT_COUNT_BASE_IDX                                                         0
#define regCP_GFX_HPD_STATUS0                                                                           0x1e72
#define regCP_GFX_HPD_STATUS0_BASE_IDX                                                                  0
#define regCP_GFX_HPD_CONTROL0                                                                          0x1e73
#define regCP_GFX_HPD_CONTROL0_BASE_IDX                                                                 0
#define regCP_GFX_HPD_OSPRE_FENCE_ADDR_LO                                                               0x1e74
#define regCP_GFX_HPD_OSPRE_FENCE_ADDR_LO_BASE_IDX                                                      0
#define regCP_GFX_HPD_OSPRE_FENCE_ADDR_HI                                                               0x1e75
#define regCP_GFX_HPD_OSPRE_FENCE_ADDR_HI_BASE_IDX                                                      0
#define regCP_GFX_HPD_OSPRE_FENCE_DATA_LO                                                               0x1e76
#define regCP_GFX_HPD_OSPRE_FENCE_DATA_LO_BASE_IDX                                                      0
#define regCP_GFX_HPD_OSPRE_FENCE_DATA_HI                                                               0x1e77
#define regCP_GFX_HPD_OSPRE_FENCE_DATA_HI_BASE_IDX                                                      0
#define regCP_GFX_INDEX_MUTEX                                                                           0x1e78
#define regCP_GFX_INDEX_MUTEX_BASE_IDX                                                                  0
#define regCP_ME_PRGRM_CNTR_START_HI                                                                    0x1e79
#define regCP_ME_PRGRM_CNTR_START_HI_BASE_IDX                                                           0
#define regCP_PFP_INTR_ROUTINE_START_HI                                                                 0x1e7a
#define regCP_PFP_INTR_ROUTINE_START_HI_BASE_IDX                                                        0
#define regCP_ME_INTR_ROUTINE_START_HI                                                                  0x1e7b
#define regCP_ME_INTR_ROUTINE_START_HI_BASE_IDX                                                         0
#define regCP_GFX_MQD_BASE_ADDR                                                                         0x1e7e
#define regCP_GFX_MQD_BASE_ADDR_BASE_IDX                                                                0
#define regCP_GFX_MQD_BASE_ADDR_HI                                                                      0x1e7f
#define regCP_GFX_MQD_BASE_ADDR_HI_BASE_IDX                                                             0
#define regCP_GFX_HQD_ACTIVE                                                                            0x1e80
#define regCP_GFX_HQD_ACTIVE_BASE_IDX                                                                   0
#define regCP_GFX_HQD_VMID                                                                              0x1e81
#define regCP_GFX_HQD_VMID_BASE_IDX                                                                     0
#define regCP_GFX_HQD_QUEUE_PRIORITY                                                                    0x1e84
#define regCP_GFX_HQD_QUEUE_PRIORITY_BASE_IDX                                                           0
#define regCP_GFX_HQD_QUANTUM                                                                           0x1e85
#define regCP_GFX_HQD_QUANTUM_BASE_IDX                                                                  0
#define regCP_GFX_HQD_BASE                                                                              0x1e86
#define regCP_GFX_HQD_BASE_BASE_IDX                                                                     0
#define regCP_GFX_HQD_BASE_HI                                                                           0x1e87
#define regCP_GFX_HQD_BASE_HI_BASE_IDX                                                                  0
#define regCP_GFX_HQD_RPTR                                                                              0x1e88
#define regCP_GFX_HQD_RPTR_BASE_IDX                                                                     0
#define regCP_GFX_HQD_RPTR_ADDR                                                                         0x1e89
#define regCP_GFX_HQD_RPTR_ADDR_BASE_IDX                                                                0
#define regCP_GFX_HQD_RPTR_ADDR_HI                                                                      0x1e8a
#define regCP_GFX_HQD_RPTR_ADDR_HI_BASE_IDX                                                             0
#define regCP_RB_WPTR_POLL_ADDR_LO                                                                      0x1e8b
#define regCP_RB_WPTR_POLL_ADDR_LO_BASE_IDX                                                             0
#define regCP_RB_WPTR_POLL_ADDR_HI                                                                      0x1e8c
#define regCP_RB_WPTR_POLL_ADDR_HI_BASE_IDX                                                             0
#define regCP_RB_DOORBELL_CONTROL                                                                       0x1e8d
#define regCP_RB_DOORBELL_CONTROL_BASE_IDX                                                              0
#define regCP_GFX_HQD_OFFSET                                                                            0x1e8e
#define regCP_GFX_HQD_OFFSET_BASE_IDX                                                                   0
#define regCP_GFX_HQD_CNTL                                                                              0x1e8f
#define regCP_GFX_HQD_CNTL_BASE_IDX                                                                     0
#define regCP_GFX_HQD_CSMD_RPTR                                                                         0x1e90
#define regCP_GFX_HQD_CSMD_RPTR_BASE_IDX                                                                0
#define regCP_GFX_HQD_WPTR                                                                              0x1e91
#define regCP_GFX_HQD_WPTR_BASE_IDX                                                                     0
#define regCP_GFX_HQD_WPTR_HI                                                                           0x1e92
#define regCP_GFX_HQD_WPTR_HI_BASE_IDX                                                                  0
#define regCP_GFX_HQD_DEQUEUE_REQUEST                                                                   0x1e93
#define regCP_GFX_HQD_DEQUEUE_REQUEST_BASE_IDX                                                          0
#define regCP_GFX_HQD_MAPPED                                                                            0x1e94
#define regCP_GFX_HQD_MAPPED_BASE_IDX                                                                   0
#define regCP_GFX_HQD_QUE_MGR_CONTROL                                                                   0x1e95
#define regCP_GFX_HQD_QUE_MGR_CONTROL_BASE_IDX                                                          0
#define regCP_GFX_HQD_IQ_TIMER                                                                          0x1e96
#define regCP_GFX_HQD_IQ_TIMER_BASE_IDX                                                                 0
#define regCP_GFX_HQD_HQ_STATUS0                                                                        0x1e98
#define regCP_GFX_HQD_HQ_STATUS0_BASE_IDX                                                               0
#define regCP_GFX_HQD_HQ_CONTROL0                                                                       0x1e99
#define regCP_GFX_HQD_HQ_CONTROL0_BASE_IDX                                                              0
#define regCP_GFX_MQD_CONTROL                                                                           0x1e9a
#define regCP_GFX_MQD_CONTROL_BASE_IDX                                                                  0
#define regCP_HQD_GFX_CONTROL                                                                           0x1e9f
#define regCP_HQD_GFX_CONTROL_BASE_IDX                                                                  0
#define regCP_HQD_GFX_STATUS                                                                            0x1ea0
#define regCP_HQD_GFX_STATUS_BASE_IDX                                                                   0
#define regCP_DMA_WATCH0_ADDR_LO                                                                        0x1ec0
#define regCP_DMA_WATCH0_ADDR_LO_BASE_IDX                                                               0
#define regCP_DMA_WATCH0_ADDR_HI                                                                        0x1ec1
#define regCP_DMA_WATCH0_ADDR_HI_BASE_IDX                                                               0
#define regCP_DMA_WATCH0_MASK                                                                           0x1ec2
#define regCP_DMA_WATCH0_MASK_BASE_IDX                                                                  0
#define regCP_DMA_WATCH0_CNTL                                                                           0x1ec3
#define regCP_DMA_WATCH0_CNTL_BASE_IDX                                                                  0
#define regCP_DMA_WATCH1_ADDR_LO                                                                        0x1ec4
#define regCP_DMA_WATCH1_ADDR_LO_BASE_IDX                                                               0
#define regCP_DMA_WATCH1_ADDR_HI                                                                        0x1ec5
#define regCP_DMA_WATCH1_ADDR_HI_BASE_IDX                                                               0
#define regCP_DMA_WATCH1_MASK                                                                           0x1ec6
#define regCP_DMA_WATCH1_MASK_BASE_IDX                                                                  0
#define regCP_DMA_WATCH1_CNTL                                                                           0x1ec7
#define regCP_DMA_WATCH1_CNTL_BASE_IDX                                                                  0
#define regCP_DMA_WATCH2_ADDR_LO                                                                        0x1ec8
#define regCP_DMA_WATCH2_ADDR_LO_BASE_IDX                                                               0
#define regCP_DMA_WATCH2_ADDR_HI                                                                        0x1ec9
#define regCP_DMA_WATCH2_ADDR_HI_BASE_IDX                                                               0
#define regCP_DMA_WATCH2_MASK                                                                           0x1eca
#define regCP_DMA_WATCH2_MASK_BASE_IDX                                                                  0
#define regCP_DMA_WATCH2_CNTL                                                                           0x1ecb
#define regCP_DMA_WATCH2_CNTL_BASE_IDX                                                                  0
#define regCP_DMA_WATCH3_ADDR_LO                                                                        0x1ecc
#define regCP_DMA_WATCH3_ADDR_LO_BASE_IDX                                                               0
#define regCP_DMA_WATCH3_ADDR_HI                                                                        0x1ecd
#define regCP_DMA_WATCH3_ADDR_HI_BASE_IDX                                                               0
#define regCP_DMA_WATCH3_MASK                                                                           0x1ece
#define regCP_DMA_WATCH3_MASK_BASE_IDX                                                                  0
#define regCP_DMA_WATCH3_CNTL                                                                           0x1ecf
#define regCP_DMA_WATCH3_CNTL_BASE_IDX                                                                  0
#define regCP_DMA_WATCH_STAT_ADDR_LO                                                                    0x1ed0
#define regCP_DMA_WATCH_STAT_ADDR_LO_BASE_IDX                                                           0
#define regCP_DMA_WATCH_STAT_ADDR_HI                                                                    0x1ed1
#define regCP_DMA_WATCH_STAT_ADDR_HI_BASE_IDX                                                           0
#define regCP_DMA_WATCH_STAT                                                                            0x1ed2
#define regCP_DMA_WATCH_STAT_BASE_IDX                                                                   0
#define regCP_PFP_JT_STAT                                                                               0x1ed3
#define regCP_PFP_JT_STAT_BASE_IDX                                                                      0
#define regCP_MEC_JT_STAT                                                                               0x1ed5
#define regCP_MEC_JT_STAT_BASE_IDX                                                                      0
#define regCP_CPC_BUSY_HYSTERESIS                                                                       0x1edb
#define regCP_CPC_BUSY_HYSTERESIS_BASE_IDX                                                              0
#define regCP_CPF_BUSY_HYSTERESIS1                                                                      0x1edc
#define regCP_CPF_BUSY_HYSTERESIS1_BASE_IDX                                                             0
#define regCP_CPF_BUSY_HYSTERESIS2                                                                      0x1edd
#define regCP_CPF_BUSY_HYSTERESIS2_BASE_IDX                                                             0
#define regCP_CPG_BUSY_HYSTERESIS1                                                                      0x1ede
#define regCP_CPG_BUSY_HYSTERESIS1_BASE_IDX                                                             0
#define regCP_CPG_BUSY_HYSTERESIS2                                                                      0x1edf
#define regCP_CPG_BUSY_HYSTERESIS2_BASE_IDX                                                             0
#define regCP_RB_DOORBELL_CLEAR                                                                         0x1f28
#define regCP_RB_DOORBELL_CLEAR_BASE_IDX                                                                0
#define regCP_RB0_ACTIVE                                                                                0x1f40
#define regCP_RB0_ACTIVE_BASE_IDX                                                                       0
#define regCP_RB_ACTIVE                                                                                 0x1f40
#define regCP_RB_ACTIVE_BASE_IDX                                                                        0
#define regCP_RB_STATUS                                                                                 0x1f43
#define regCP_RB_STATUS_BASE_IDX                                                                        0
#define regCPG_RCIU_CAM_INDEX                                                                           0x1f44
#define regCPG_RCIU_CAM_INDEX_BASE_IDX                                                                  0
#define regCPG_RCIU_CAM_DATA                                                                            0x1f45
#define regCPG_RCIU_CAM_DATA_BASE_IDX                                                                   0
#define regCPG_RCIU_CAM_DATA_PHASE0                                                                     0x1f45
#define regCPG_RCIU_CAM_DATA_PHASE0_BASE_IDX                                                            0
#define regCPG_RCIU_CAM_DATA_PHASE1                                                                     0x1f45
#define regCPG_RCIU_CAM_DATA_PHASE1_BASE_IDX                                                            0
#define regCPG_RCIU_CAM_DATA_PHASE2                                                                     0x1f45
#define regCPG_RCIU_CAM_DATA_PHASE2_BASE_IDX                                                            0
#define regCPG_RCIU_CAM_DATA_PHASE3                                                                     0x1f45
#define regCPG_RCIU_CAM_DATA_PHASE3_BASE_IDX                                                            0
#define regCP_GPU_TIMESTAMP_OFFSET_LO                                                                   0x1f4c
#define regCP_GPU_TIMESTAMP_OFFSET_LO_BASE_IDX                                                          0
#define regCP_GPU_TIMESTAMP_OFFSET_HI                                                                   0x1f4d
#define regCP_GPU_TIMESTAMP_OFFSET_HI_BASE_IDX                                                          0
#define regCP_SDMA_DMA_DONE                                                                             0x1f4e
#define regCP_SDMA_DMA_DONE_BASE_IDX                                                                    0
#define regCP_PFP_SDMA_CS                                                                               0x1f4f
#define regCP_PFP_SDMA_CS_BASE_IDX                                                                      0
#define regCP_ME_SDMA_CS                                                                                0x1f50
#define regCP_ME_SDMA_CS_BASE_IDX                                                                       0
#define regCPF_GCR_CNTL                                                                                 0x1f53
#define regCPF_GCR_CNTL_BASE_IDX                                                                        0
#define regCPG_UTCL1_STATUS                                                                             0x1f54
#define regCPG_UTCL1_STATUS_BASE_IDX                                                                    0
#define regCPC_UTCL1_STATUS                                                                             0x1f55
#define regCPC_UTCL1_STATUS_BASE_IDX                                                                    0
#define regCPF_UTCL1_STATUS                                                                             0x1f56
#define regCPF_UTCL1_STATUS_BASE_IDX                                                                    0
#define regCP_SD_CNTL                                                                                   0x1f57
#define regCP_SD_CNTL_BASE_IDX                                                                          0
#define regCP_SOFT_RESET_CNTL                                                                           0x1f59
#define regCP_SOFT_RESET_CNTL_BASE_IDX                                                                  0
#define regCP_CPC_GFX_CNTL                                                                              0x1f5a
#define regCP_CPC_GFX_CNTL_BASE_IDX                                                                     0


// addressBlock: gc_gfx_cpwd_cpwd_cpphqddec
// base address: 0xc800
#define regCP_HPD_UTCL1_CNTL                                                                            0x1fa3
#define regCP_HPD_UTCL1_CNTL_BASE_IDX                                                                   0
#define regCP_HPD_UTCL1_ERROR                                                                           0x1fa7
#define regCP_HPD_UTCL1_ERROR_BASE_IDX                                                                  0
#define regCP_HPD_UTCL1_ERROR_ADDR                                                                      0x1fa8
#define regCP_HPD_UTCL1_ERROR_ADDR_BASE_IDX                                                             0
#define regCP_MQD_BASE_ADDR                                                                             0x1fa9
#define regCP_MQD_BASE_ADDR_BASE_IDX                                                                    0
#define regCP_MQD_BASE_ADDR_HI                                                                          0x1faa
#define regCP_MQD_BASE_ADDR_HI_BASE_IDX                                                                 0
#define regCP_HQD_ACTIVE                                                                                0x1fab
#define regCP_HQD_ACTIVE_BASE_IDX                                                                       0
#define regCP_HQD_VMID                                                                                  0x1fac
#define regCP_HQD_VMID_BASE_IDX                                                                         0
#define regCP_HQD_PERSISTENT_STATE                                                                      0x1fad
#define regCP_HQD_PERSISTENT_STATE_BASE_IDX                                                             0
#define regCP_HQD_PIPE_PRIORITY                                                                         0x1fae
#define regCP_HQD_PIPE_PRIORITY_BASE_IDX                                                                0
#define regCP_HQD_QUEUE_PRIORITY                                                                        0x1faf
#define regCP_HQD_QUEUE_PRIORITY_BASE_IDX                                                               0
#define regCP_HQD_QUANTUM                                                                               0x1fb0
#define regCP_HQD_QUANTUM_BASE_IDX                                                                      0
#define regCP_HQD_PQ_BASE                                                                               0x1fb1
#define regCP_HQD_PQ_BASE_BASE_IDX                                                                      0
#define regCP_HQD_PQ_BASE_HI                                                                            0x1fb2
#define regCP_HQD_PQ_BASE_HI_BASE_IDX                                                                   0
#define regCP_HQD_PQ_RPTR                                                                               0x1fb3
#define regCP_HQD_PQ_RPTR_BASE_IDX                                                                      0
#define regCP_HQD_PQ_RPTR_REPORT_ADDR                                                                   0x1fb4
#define regCP_HQD_PQ_RPTR_REPORT_ADDR_BASE_IDX                                                          0
#define regCP_HQD_PQ_RPTR_REPORT_ADDR_HI                                                                0x1fb5
#define regCP_HQD_PQ_RPTR_REPORT_ADDR_HI_BASE_IDX                                                       0
#define regCP_HQD_PQ_WPTR_POLL_ADDR                                                                     0x1fb6
#define regCP_HQD_PQ_WPTR_POLL_ADDR_BASE_IDX                                                            0
#define regCP_HQD_PQ_WPTR_POLL_ADDR_HI                                                                  0x1fb7
#define regCP_HQD_PQ_WPTR_POLL_ADDR_HI_BASE_IDX                                                         0
#define regCP_HQD_PQ_DOORBELL_CONTROL                                                                   0x1fb8
#define regCP_HQD_PQ_DOORBELL_CONTROL_BASE_IDX                                                          0
#define regCP_HQD_PQ_CONTROL                                                                            0x1fba
#define regCP_HQD_PQ_CONTROL_BASE_IDX                                                                   0
#define regCP_HQD_IB_BASE_ADDR                                                                          0x1fbb
#define regCP_HQD_IB_BASE_ADDR_BASE_IDX                                                                 0
#define regCP_HQD_IB_BASE_ADDR_HI                                                                       0x1fbc
#define regCP_HQD_IB_BASE_ADDR_HI_BASE_IDX                                                              0
#define regCP_HQD_IB_RPTR                                                                               0x1fbd
#define regCP_HQD_IB_RPTR_BASE_IDX                                                                      0
#define regCP_HQD_IB_CONTROL                                                                            0x1fbe
#define regCP_HQD_IB_CONTROL_BASE_IDX                                                                   0
#define regCP_HQD_IQ_TIMER                                                                              0x1fbf
#define regCP_HQD_IQ_TIMER_BASE_IDX                                                                     0
#define regCP_HQD_IQ_RPTR                                                                               0x1fc0
#define regCP_HQD_IQ_RPTR_BASE_IDX                                                                      0
#define regCP_HQD_DEQUEUE_REQUEST                                                                       0x1fc1
#define regCP_HQD_DEQUEUE_REQUEST_BASE_IDX                                                              0
#define regCP_HQD_DMA_OFFLOAD                                                                           0x1fc2
#define regCP_HQD_DMA_OFFLOAD_BASE_IDX                                                                  0
#define regCP_HQD_OFFLOAD                                                                               0x1fc2
#define regCP_HQD_OFFLOAD_BASE_IDX                                                                      0
#define regCP_HQD_MSG_TYPE                                                                              0x1fc4
#define regCP_HQD_MSG_TYPE_BASE_IDX                                                                     0
#define regCP_HQD_ATOMIC0_PREOP_LO                                                                      0x1fc5
#define regCP_HQD_ATOMIC0_PREOP_LO_BASE_IDX                                                             0
#define regCP_HQD_ATOMIC0_PREOP_HI                                                                      0x1fc6
#define regCP_HQD_ATOMIC0_PREOP_HI_BASE_IDX                                                             0
#define regCP_HQD_ATOMIC1_PREOP_LO                                                                      0x1fc7
#define regCP_HQD_ATOMIC1_PREOP_LO_BASE_IDX                                                             0
#define regCP_HQD_ATOMIC1_PREOP_HI                                                                      0x1fc8
#define regCP_HQD_ATOMIC1_PREOP_HI_BASE_IDX                                                             0
#define regCP_HQD_HQ_SCHEDULER0                                                                         0x1fc9
#define regCP_HQD_HQ_SCHEDULER0_BASE_IDX                                                                0
#define regCP_HQD_HQ_STATUS0                                                                            0x1fc9
#define regCP_HQD_HQ_STATUS0_BASE_IDX                                                                   0
#define regCP_HQD_HQ_CONTROL0                                                                           0x1fca
#define regCP_HQD_HQ_CONTROL0_BASE_IDX                                                                  0
#define regCP_HQD_HQ_SCHEDULER1                                                                         0x1fca
#define regCP_HQD_HQ_SCHEDULER1_BASE_IDX                                                                0
#define regCP_MQD_CONTROL                                                                               0x1fcb
#define regCP_MQD_CONTROL_BASE_IDX                                                                      0
#define regCP_HQD_HQ_STATUS1                                                                            0x1fcc
#define regCP_HQD_HQ_STATUS1_BASE_IDX                                                                   0
#define regCP_HQD_HQ_CONTROL1                                                                           0x1fcd
#define regCP_HQD_HQ_CONTROL1_BASE_IDX                                                                  0
#define regCP_HQD_EOP_BASE_ADDR                                                                         0x1fce
#define regCP_HQD_EOP_BASE_ADDR_BASE_IDX                                                                0
#define regCP_HQD_EOP_BASE_ADDR_HI                                                                      0x1fcf
#define regCP_HQD_EOP_BASE_ADDR_HI_BASE_IDX                                                             0
#define regCP_HQD_EOP_CONTROL                                                                           0x1fd0
#define regCP_HQD_EOP_CONTROL_BASE_IDX                                                                  0
#define regCP_HQD_EOP_RPTR                                                                              0x1fd1
#define regCP_HQD_EOP_RPTR_BASE_IDX                                                                     0
#define regCP_HQD_EOP_WPTR                                                                              0x1fd2
#define regCP_HQD_EOP_WPTR_BASE_IDX                                                                     0
#define regCP_HQD_EOP_EVENTS                                                                            0x1fd3
#define regCP_HQD_EOP_EVENTS_BASE_IDX                                                                   0
#define regCP_HQD_CTX_SAVE_BASE_ADDR_LO                                                                 0x1fd4
#define regCP_HQD_CTX_SAVE_BASE_ADDR_LO_BASE_IDX                                                        0
#define regCP_HQD_CTX_SAVE_BASE_ADDR_HI                                                                 0x1fd5
#define regCP_HQD_CTX_SAVE_BASE_ADDR_HI_BASE_IDX                                                        0
#define regCP_HQD_CTX_SAVE_CONTROL                                                                      0x1fd6
#define regCP_HQD_CTX_SAVE_CONTROL_BASE_IDX                                                             0
#define regCP_HQD_CNTL_STACK_OFFSET                                                                     0x1fd7
#define regCP_HQD_CNTL_STACK_OFFSET_BASE_IDX                                                            0
#define regCP_HQD_CNTL_STACK_SIZE                                                                       0x1fd8
#define regCP_HQD_CNTL_STACK_SIZE_BASE_IDX                                                              0
#define regCP_HQD_WG_STATE_OFFSET                                                                       0x1fd9
#define regCP_HQD_WG_STATE_OFFSET_BASE_IDX                                                              0
#define regCP_HQD_CTX_SAVE_SIZE                                                                         0x1fda
#define regCP_HQD_CTX_SAVE_SIZE_BASE_IDX                                                                0
#define regCP_HQD_GDS_RESOURCE_STATE                                                                    0x1fdb
#define regCP_HQD_GDS_RESOURCE_STATE_BASE_IDX                                                           0
#define regCP_HQD_ERROR                                                                                 0x1fdc
#define regCP_HQD_ERROR_BASE_IDX                                                                        0
#define regCP_HQD_EOP_WPTR_MEM                                                                          0x1fdd
#define regCP_HQD_EOP_WPTR_MEM_BASE_IDX                                                                 0
#define regCP_HQD_AQL_CONTROL                                                                           0x1fde
#define regCP_HQD_AQL_CONTROL_BASE_IDX                                                                  0
#define regCP_HQD_PQ_WPTR_LO                                                                            0x1fdf
#define regCP_HQD_PQ_WPTR_LO_BASE_IDX                                                                   0
#define regCP_HQD_PQ_WPTR_HI                                                                            0x1fe0
#define regCP_HQD_PQ_WPTR_HI_BASE_IDX                                                                   0
#define regCP_HQD_SUSPEND_CNTL_STACK_OFFSET                                                             0x1fe1
#define regCP_HQD_SUSPEND_CNTL_STACK_OFFSET_BASE_IDX                                                    0
#define regCP_HQD_SUSPEND_CNTL_STACK_DW_CNT                                                             0x1fe2
#define regCP_HQD_SUSPEND_CNTL_STACK_DW_CNT_BASE_IDX                                                    0
#define regCP_HQD_SUSPEND_WG_STATE_OFFSET                                                               0x1fe3
#define regCP_HQD_SUSPEND_WG_STATE_OFFSET_BASE_IDX                                                      0
#define regCP_HQD_DDID_RPTR                                                                             0x1fe4
#define regCP_HQD_DDID_RPTR_BASE_IDX                                                                    0
#define regCP_HQD_DDID_WPTR                                                                             0x1fe5
#define regCP_HQD_DDID_WPTR_BASE_IDX                                                                    0
#define regCP_HQD_DDID_INFLIGHT_COUNT                                                                   0x1fe6
#define regCP_HQD_DDID_INFLIGHT_COUNT_BASE_IDX                                                          0
#define regCP_HQD_DDID_DELTA_RPT_COUNT                                                                  0x1fe7
#define regCP_HQD_DDID_DELTA_RPT_COUNT_BASE_IDX                                                         0
#define regCP_HQD_DEQUEUE_STATUS                                                                        0x1fe8
#define regCP_HQD_DEQUEUE_STATUS_BASE_IDX                                                               0


// addressBlock: gc_gfx_cpwd_cpwd_gfxdec0
// base address: 0x28000
#define regCOHER_DEST_BASE_HI_0                                                                         0x007a
#define regCOHER_DEST_BASE_HI_0_BASE_IDX                                                                1
#define regCOHER_DEST_BASE_HI_1                                                                         0x007b
#define regCOHER_DEST_BASE_HI_1_BASE_IDX                                                                1
#define regCOHER_DEST_BASE_HI_2                                                                         0x007c
#define regCOHER_DEST_BASE_HI_2_BASE_IDX                                                                1
#define regCOHER_DEST_BASE_HI_3                                                                         0x007d
#define regCOHER_DEST_BASE_HI_3_BASE_IDX                                                                1
#define regCOHER_DEST_BASE_2                                                                            0x007e
#define regCOHER_DEST_BASE_2_BASE_IDX                                                                   1
#define regCOHER_DEST_BASE_3                                                                            0x007f
#define regCOHER_DEST_BASE_3_BASE_IDX                                                                   1
#define regCOHER_DEST_BASE_0                                                                            0x0092
#define regCOHER_DEST_BASE_0_BASE_IDX                                                                   1
#define regCOHER_DEST_BASE_1                                                                            0x0093
#define regCOHER_DEST_BASE_1_BASE_IDX                                                                   1
#define regCP_PERFMON_CNTX_CNTL                                                                         0x00d8
#define regCP_PERFMON_CNTX_CNTL_BASE_IDX                                                                1
#define regCP_CP_PIPEID                                                                                 0x00d9
#define regCP_CP_PIPEID_BASE_IDX                                                                        1
#define regCP_RINGID                                                                                    0x00d9
#define regCP_RINGID_BASE_IDX                                                                           1
#define regCP_CP_VMID                                                                                   0x00da
#define regCP_CP_VMID_BASE_IDX                                                                          1
#define regCONTEXT_RESERVED_REG0                                                                        0x00db
#define regCONTEXT_RESERVED_REG0_BASE_IDX                                                               1
#define regCONTEXT_RESERVED_REG1                                                                        0x00dc
#define regCONTEXT_RESERVED_REG1_BASE_IDX                                                               1
#define regVGT_MULTI_PRIM_IB_RESET_INDX                                                                 0x0103
#define regVGT_MULTI_PRIM_IB_RESET_INDX_BASE_IDX                                                        1
#define regGFX_COPY_STATE                                                                               0x01f4
#define regGFX_COPY_STATE_BASE_IDX                                                                      1
#define regVGT_DMA_BASE_HI                                                                              0x01f9
#define regVGT_DMA_BASE_HI_BASE_IDX                                                                     1
#define regVGT_DMA_BASE                                                                                 0x01fa
#define regVGT_DMA_BASE_BASE_IDX                                                                        1
#define regVGT_DRAW_INITIATOR                                                                           0x01fc
#define regVGT_DRAW_INITIATOR_BASE_IDX                                                                  1
#define regVGT_EVENT_ADDRESS_REG                                                                        0x01fe
#define regVGT_EVENT_ADDRESS_REG_BASE_IDX                                                               1
#define regVGT_HOS_MAX_TESS_LEVEL                                                                       0x0286
#define regVGT_HOS_MAX_TESS_LEVEL_BASE_IDX                                                              1
#define regVGT_HOS_MIN_TESS_LEVEL                                                                       0x0287
#define regVGT_HOS_MIN_TESS_LEVEL_BASE_IDX                                                              1
#define regGE_IA_ENHANCE                                                                                0x029c
#define regGE_IA_ENHANCE_BASE_IDX                                                                       1
#define regVGT_DMA_SIZE                                                                                 0x029d
#define regVGT_DMA_SIZE_BASE_IDX                                                                        1
#define regVGT_DMA_MAX_SIZE                                                                             0x029e
#define regVGT_DMA_MAX_SIZE_BASE_IDX                                                                    1
#define regVGT_DMA_INDEX_TYPE                                                                           0x029f
#define regVGT_DMA_INDEX_TYPE_BASE_IDX                                                                  1
#define regGE_WD_ENHANCE                                                                                0x02a0
#define regGE_WD_ENHANCE_BASE_IDX                                                                       1
#define regVGT_DMA_NUM_INSTANCES                                                                        0x02a2
#define regVGT_DMA_NUM_INSTANCES_BASE_IDX                                                               1
#define regVGT_EVENT_INITIATOR                                                                          0x02a4
#define regVGT_EVENT_INITIATOR_BASE_IDX                                                                 1
#define regVGT_SHADER_STAGES_EN                                                                         0x02a6
#define regVGT_SHADER_STAGES_EN_BASE_IDX                                                                1
#define regVGT_TF_PARAM                                                                                 0x02a9
#define regVGT_TF_PARAM_BASE_IDX                                                                        1
#define regVGT_STRMOUT_DRAW_OPAQUE_OFFSET                                                               0x02ca
#define regVGT_STRMOUT_DRAW_OPAQUE_OFFSET_BASE_IDX                                                      1
#define regVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE                                                   0x02cb
#define regVGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE_BASE_IDX                                          1
#define regVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE                                                        0x02cc
#define regVGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE_BASE_IDX                                               1
#define regVGT_TESS_DISTRIBUTION                                                                        0x02d4
#define regVGT_TESS_DISTRIBUTION_BASE_IDX                                                               1
#define regVGT_LS_HS_CONFIG                                                                             0x02d6
#define regVGT_LS_HS_CONFIG_BASE_IDX                                                                    1


// addressBlock: gc_gfx_cpwd_cpwd_pfvf_cpdec
// base address: 0x2a000
#define regCONFIG_RESERVED_REG0                                                                         0x0800
#define regCONFIG_RESERVED_REG0_BASE_IDX                                                                1
#define regCONFIG_RESERVED_REG1                                                                         0x0801
#define regCONFIG_RESERVED_REG1_BASE_IDX                                                                1
#define regCP_MEC_CNTL                                                                                  0x0802
#define regCP_MEC_CNTL_BASE_IDX                                                                         1
#define regCP_ME_CNTL                                                                                   0x0803
#define regCP_ME_CNTL_BASE_IDX                                                                          1
#define regCP_UNMAPPED_QUEUE0                                                                           0x0840
#define regCP_UNMAPPED_QUEUE0_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE1                                                                           0x0841
#define regCP_UNMAPPED_QUEUE1_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE2                                                                           0x0842
#define regCP_UNMAPPED_QUEUE2_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE3                                                                           0x0843
#define regCP_UNMAPPED_QUEUE3_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE4                                                                           0x0844
#define regCP_UNMAPPED_QUEUE4_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE5                                                                           0x0845
#define regCP_UNMAPPED_QUEUE5_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE6                                                                           0x0846
#define regCP_UNMAPPED_QUEUE6_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE7                                                                           0x0847
#define regCP_UNMAPPED_QUEUE7_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE8                                                                           0x0848
#define regCP_UNMAPPED_QUEUE8_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE9                                                                           0x0849
#define regCP_UNMAPPED_QUEUE9_BASE_IDX                                                                  1
#define regCP_UNMAPPED_QUEUE10                                                                          0x084a
#define regCP_UNMAPPED_QUEUE10_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE11                                                                          0x084b
#define regCP_UNMAPPED_QUEUE11_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE12                                                                          0x084c
#define regCP_UNMAPPED_QUEUE12_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE13                                                                          0x084d
#define regCP_UNMAPPED_QUEUE13_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE14                                                                          0x084e
#define regCP_UNMAPPED_QUEUE14_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE15                                                                          0x084f
#define regCP_UNMAPPED_QUEUE15_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE16                                                                          0x0850
#define regCP_UNMAPPED_QUEUE16_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE17                                                                          0x0851
#define regCP_UNMAPPED_QUEUE17_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE18                                                                          0x0852
#define regCP_UNMAPPED_QUEUE18_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE19                                                                          0x0853
#define regCP_UNMAPPED_QUEUE19_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE20                                                                          0x0854
#define regCP_UNMAPPED_QUEUE20_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE21                                                                          0x0855
#define regCP_UNMAPPED_QUEUE21_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE22                                                                          0x0856
#define regCP_UNMAPPED_QUEUE22_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE23                                                                          0x0857
#define regCP_UNMAPPED_QUEUE23_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE24                                                                          0x0858
#define regCP_UNMAPPED_QUEUE24_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE25                                                                          0x0859
#define regCP_UNMAPPED_QUEUE25_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE26                                                                          0x085a
#define regCP_UNMAPPED_QUEUE26_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE27                                                                          0x085b
#define regCP_UNMAPPED_QUEUE27_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE28                                                                          0x085c
#define regCP_UNMAPPED_QUEUE28_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE29                                                                          0x085d
#define regCP_UNMAPPED_QUEUE29_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE30                                                                          0x085e
#define regCP_UNMAPPED_QUEUE30_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE31                                                                          0x085f
#define regCP_UNMAPPED_QUEUE31_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE32                                                                          0x0860
#define regCP_UNMAPPED_QUEUE32_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE33                                                                          0x0861
#define regCP_UNMAPPED_QUEUE33_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE34                                                                          0x0862
#define regCP_UNMAPPED_QUEUE34_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE35                                                                          0x0863
#define regCP_UNMAPPED_QUEUE35_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE36                                                                          0x0864
#define regCP_UNMAPPED_QUEUE36_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE37                                                                          0x0865
#define regCP_UNMAPPED_QUEUE37_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE38                                                                          0x0866
#define regCP_UNMAPPED_QUEUE38_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE39                                                                          0x0867
#define regCP_UNMAPPED_QUEUE39_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE40                                                                          0x0868
#define regCP_UNMAPPED_QUEUE40_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE41                                                                          0x0869
#define regCP_UNMAPPED_QUEUE41_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE42                                                                          0x086a
#define regCP_UNMAPPED_QUEUE42_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE43                                                                          0x086b
#define regCP_UNMAPPED_QUEUE43_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE44                                                                          0x086c
#define regCP_UNMAPPED_QUEUE44_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE45                                                                          0x086d
#define regCP_UNMAPPED_QUEUE45_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE46                                                                          0x086e
#define regCP_UNMAPPED_QUEUE46_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE47                                                                          0x086f
#define regCP_UNMAPPED_QUEUE47_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE48                                                                          0x0870
#define regCP_UNMAPPED_QUEUE48_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE49                                                                          0x0871
#define regCP_UNMAPPED_QUEUE49_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE50                                                                          0x0872
#define regCP_UNMAPPED_QUEUE50_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE51                                                                          0x0873
#define regCP_UNMAPPED_QUEUE51_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE52                                                                          0x0874
#define regCP_UNMAPPED_QUEUE52_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE53                                                                          0x0875
#define regCP_UNMAPPED_QUEUE53_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE54                                                                          0x0876
#define regCP_UNMAPPED_QUEUE54_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE55                                                                          0x0877
#define regCP_UNMAPPED_QUEUE55_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE56                                                                          0x0878
#define regCP_UNMAPPED_QUEUE56_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE57                                                                          0x0879
#define regCP_UNMAPPED_QUEUE57_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE58                                                                          0x087a
#define regCP_UNMAPPED_QUEUE58_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE59                                                                          0x087b
#define regCP_UNMAPPED_QUEUE59_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE60                                                                          0x087c
#define regCP_UNMAPPED_QUEUE60_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE61                                                                          0x087d
#define regCP_UNMAPPED_QUEUE61_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE62                                                                          0x087e
#define regCP_UNMAPPED_QUEUE62_BASE_IDX                                                                 1
#define regCP_UNMAPPED_QUEUE63                                                                          0x087f
#define regCP_UNMAPPED_QUEUE63_BASE_IDX                                                                 1
#define regCP_UNMAPPED_DOORBELL                                                                         0x0880
#define regCP_UNMAPPED_DOORBELL_BASE_IDX                                                                1
#define regCP_UNMAPPED_QUEUE_BANK0                                                                      0x0881
#define regCP_UNMAPPED_QUEUE_BANK0_BASE_IDX                                                             1
#define regCP_UNMAPPED_QUEUE_BANK1                                                                      0x0882
#define regCP_UNMAPPED_QUEUE_BANK1_BASE_IDX                                                             1


// addressBlock: gc_gfx_cpwd_cpwd_pfvf_grbmdec
// base address: 0x2a400
#define regGRBM_GFX_CNTL                                                                                0x0900
#define regGRBM_GFX_CNTL_BASE_IDX                                                                       1
#define regGRBM_NOWHERE                                                                                 0x0901
#define regGRBM_NOWHERE_BASE_IDX                                                                        1


// addressBlock: gc_gfx_cpwd_cpwd_pfonly_cpdec
// base address: 0x2e000
#define regCP_FETCHER_SOURCE                                                                            0x1801
#define regCP_FETCHER_SOURCE_BASE_IDX                                                                   1
#define regCP_DFY_CNTL                                                                                  0x1804
#define regCP_DFY_CNTL_BASE_IDX                                                                         1
#define regCP_DFY_STAT                                                                                  0x1805
#define regCP_DFY_STAT_BASE_IDX                                                                         1
#define regCP_DFY_ADDR_HI                                                                               0x1806
#define regCP_DFY_ADDR_HI_BASE_IDX                                                                      1
#define regCP_DFY_ADDR_LO                                                                               0x1807
#define regCP_DFY_ADDR_LO_BASE_IDX                                                                      1
#define regCP_DFY_DATA_0                                                                                0x1808
#define regCP_DFY_DATA_0_BASE_IDX                                                                       1
#define regCP_DFY_DATA_1                                                                                0x1809
#define regCP_DFY_DATA_1_BASE_IDX                                                                       1
#define regCP_DFY_DATA_2                                                                                0x180a
#define regCP_DFY_DATA_2_BASE_IDX                                                                       1
#define regCP_DFY_DATA_3                                                                                0x180b
#define regCP_DFY_DATA_3_BASE_IDX                                                                       1
#define regCP_DFY_DATA_4                                                                                0x180c
#define regCP_DFY_DATA_4_BASE_IDX                                                                       1
#define regCP_DFY_DATA_5                                                                                0x180d
#define regCP_DFY_DATA_5_BASE_IDX                                                                       1
#define regCP_DFY_DATA_6                                                                                0x180e
#define regCP_DFY_DATA_6_BASE_IDX                                                                       1
#define regCP_DFY_DATA_7                                                                                0x180f
#define regCP_DFY_DATA_7_BASE_IDX                                                                       1
#define regCP_DFY_DATA_8                                                                                0x1810
#define regCP_DFY_DATA_8_BASE_IDX                                                                       1
#define regCP_DFY_DATA_9                                                                                0x1811
#define regCP_DFY_DATA_9_BASE_IDX                                                                       1
#define regCP_DFY_DATA_10                                                                               0x1812
#define regCP_DFY_DATA_10_BASE_IDX                                                                      1
#define regCP_DFY_DATA_11                                                                               0x1813
#define regCP_DFY_DATA_11_BASE_IDX                                                                      1
#define regCP_DFY_DATA_12                                                                               0x1814
#define regCP_DFY_DATA_12_BASE_IDX                                                                      1
#define regCP_DFY_DATA_13                                                                               0x1815
#define regCP_DFY_DATA_13_BASE_IDX                                                                      1
#define regCP_DFY_DATA_14                                                                               0x1816
#define regCP_DFY_DATA_14_BASE_IDX                                                                      1
#define regCP_DFY_DATA_15                                                                               0x1817
#define regCP_DFY_DATA_15_BASE_IDX                                                                      1
#define regCP_DFY_CMD                                                                                   0x1818
#define regCP_DFY_CMD_BASE_IDX                                                                          1


// addressBlock: gc_gfx_cpwd_cpwd_pfonly_cpphqddec
// base address: 0x2e080
#define regCP_HPD_MES_ROQ_OFFSETS                                                                       0x1821
#define regCP_HPD_MES_ROQ_OFFSETS_BASE_IDX                                                              1
#define regCP_HPD_ROQ_OFFSETS                                                                           0x1821
#define regCP_HPD_ROQ_OFFSETS_BASE_IDX                                                                  1
#define regCP_HPD_STATUS0                                                                               0x1822
#define regCP_HPD_STATUS0_BASE_IDX                                                                      1


// addressBlock: gc_gfx_cpwd_cpwd_pfonly_gcrdec
// base address: 0x2e640
#define regGCR_GENERAL_CNTL                                                                             0x1990
#define regGCR_GENERAL_CNTL_BASE_IDX                                                                    1
#define regGCR_TARGET_DISABLE                                                                           0x1991
#define regGCR_TARGET_DISABLE_BASE_IDX                                                                  1
#define regGCR_CMD_STATUS                                                                               0x1992
#define regGCR_CMD_STATUS_BASE_IDX                                                                      1
#define regGCR_SPARE                                                                                    0x1993
#define regGCR_SPARE_BASE_IDX                                                                           1
#define regPMM_CNTL2                                                                                    0x1999
#define regPMM_CNTL2_BASE_IDX                                                                           1


// addressBlock: gc_gfx_cpwd_cpwd_gfxudec
// base address: 0x30000
#define regCP_EOP_DONE_ADDR_LO                                                                          0x2000
#define regCP_EOP_DONE_ADDR_LO_BASE_IDX                                                                 1
#define regCP_EOP_DONE_ADDR_HI                                                                          0x2001
#define regCP_EOP_DONE_ADDR_HI_BASE_IDX                                                                 1
#define regCP_EOP_DONE_DATA_LO                                                                          0x2002
#define regCP_EOP_DONE_DATA_LO_BASE_IDX                                                                 1
#define regCP_EOP_DONE_DATA_HI                                                                          0x2003
#define regCP_EOP_DONE_DATA_HI_BASE_IDX                                                                 1
#define regCP_EOP_LAST_FENCE_LO                                                                         0x2004
#define regCP_EOP_LAST_FENCE_LO_BASE_IDX                                                                1
#define regCP_EOP_LAST_FENCE_HI                                                                         0x2005
#define regCP_EOP_LAST_FENCE_HI_BASE_IDX                                                                1
#define regCP_PIPE_STATS_ADDR_LO                                                                        0x2018
#define regCP_PIPE_STATS_ADDR_LO_BASE_IDX                                                               1
#define regCP_PIPE_STATS_ADDR_HI                                                                        0x2019
#define regCP_PIPE_STATS_ADDR_HI_BASE_IDX                                                               1
#define regCP_VGT_IAVERT_COUNT_LO                                                                       0x201a
#define regCP_VGT_IAVERT_COUNT_LO_BASE_IDX                                                              1
#define regCP_VGT_IAVERT_COUNT_HI                                                                       0x201b
#define regCP_VGT_IAVERT_COUNT_HI_BASE_IDX                                                              1
#define regCP_VGT_IAPRIM_COUNT_LO                                                                       0x201c
#define regCP_VGT_IAPRIM_COUNT_LO_BASE_IDX                                                              1
#define regCP_VGT_IAPRIM_COUNT_HI                                                                       0x201d
#define regCP_VGT_IAPRIM_COUNT_HI_BASE_IDX                                                              1
#define regCP_VGT_GSPRIM_COUNT_LO                                                                       0x201e
#define regCP_VGT_GSPRIM_COUNT_LO_BASE_IDX                                                              1
#define regCP_VGT_GSPRIM_COUNT_HI                                                                       0x201f
#define regCP_VGT_GSPRIM_COUNT_HI_BASE_IDX                                                              1
#define regCP_VGT_VSINVOC_COUNT_LO                                                                      0x2020
#define regCP_VGT_VSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_VSINVOC_COUNT_HI                                                                      0x2021
#define regCP_VGT_VSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_VGT_GSINVOC_COUNT_LO                                                                      0x2022
#define regCP_VGT_GSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_GSINVOC_COUNT_HI                                                                      0x2023
#define regCP_VGT_GSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_VGT_HSINVOC_COUNT_LO                                                                      0x2024
#define regCP_VGT_HSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_HSINVOC_COUNT_HI                                                                      0x2025
#define regCP_VGT_HSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_VGT_DSINVOC_COUNT_LO                                                                      0x2026
#define regCP_VGT_DSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_DSINVOC_COUNT_HI                                                                      0x2027
#define regCP_VGT_DSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_PA_CINVOC_COUNT_LO                                                                        0x2028
#define regCP_PA_CINVOC_COUNT_LO_BASE_IDX                                                               1
#define regCP_PA_CINVOC_COUNT_HI                                                                        0x2029
#define regCP_PA_CINVOC_COUNT_HI_BASE_IDX                                                               1
#define regCP_PA_CPRIM_COUNT_LO                                                                         0x202a
#define regCP_PA_CPRIM_COUNT_LO_BASE_IDX                                                                1
#define regCP_PA_CPRIM_COUNT_HI                                                                         0x202b
#define regCP_PA_CPRIM_COUNT_HI_BASE_IDX                                                                1
#define regCP_SC_PSINVOC_COUNT0_LO                                                                      0x202c
#define regCP_SC_PSINVOC_COUNT0_LO_BASE_IDX                                                             1
#define regCP_SC_PSINVOC_COUNT0_HI                                                                      0x202d
#define regCP_SC_PSINVOC_COUNT0_HI_BASE_IDX                                                             1
#define regCP_SC_PSINVOC_COUNT1_LO                                                                      0x202e
#define regCP_SC_PSINVOC_COUNT1_LO_BASE_IDX                                                             1
#define regCP_SC_PSINVOC_COUNT1_HI                                                                      0x202f
#define regCP_SC_PSINVOC_COUNT1_HI_BASE_IDX                                                             1
#define regCP_VGT_CSINVOC_COUNT_LO                                                                      0x2030
#define regCP_VGT_CSINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_CSINVOC_COUNT_HI                                                                      0x2031
#define regCP_VGT_CSINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_VGT_ASINVOC_COUNT_LO                                                                      0x2032
#define regCP_VGT_ASINVOC_COUNT_LO_BASE_IDX                                                             1
#define regCP_VGT_ASINVOC_COUNT_HI                                                                      0x2033
#define regCP_VGT_ASINVOC_COUNT_HI_BASE_IDX                                                             1
#define regCP_PIPE_STATS_CONTROL                                                                        0x203d
#define regCP_PIPE_STATS_CONTROL_BASE_IDX                                                               1
#define regSCRATCH_REG0                                                                                 0x2040
#define regSCRATCH_REG0_BASE_IDX                                                                        1
#define regSCRATCH_REG1                                                                                 0x2041
#define regSCRATCH_REG1_BASE_IDX                                                                        1
#define regSCRATCH_REG2                                                                                 0x2042
#define regSCRATCH_REG2_BASE_IDX                                                                        1
#define regSCRATCH_REG3                                                                                 0x2043
#define regSCRATCH_REG3_BASE_IDX                                                                        1
#define regSCRATCH_REG4                                                                                 0x2044
#define regSCRATCH_REG4_BASE_IDX                                                                        1
#define regSCRATCH_REG5                                                                                 0x2045
#define regSCRATCH_REG5_BASE_IDX                                                                        1
#define regSCRATCH_REG6                                                                                 0x2046
#define regSCRATCH_REG6_BASE_IDX                                                                        1
#define regSCRATCH_REG7                                                                                 0x2047
#define regSCRATCH_REG7_BASE_IDX                                                                        1
#define regSCRATCH_REG_ATOMIC                                                                           0x2048
#define regSCRATCH_REG_ATOMIC_BASE_IDX                                                                  1
#define regSCRATCH_REG_CMPSWAP_ATOMIC                                                                   0x2048
#define regSCRATCH_REG_CMPSWAP_ATOMIC_BASE_IDX                                                          1
#define regCP_APPEND_DDID_CNT                                                                           0x204b
#define regCP_APPEND_DDID_CNT_BASE_IDX                                                                  1
#define regCP_APPEND_DATA_HI                                                                            0x204c
#define regCP_APPEND_DATA_HI_BASE_IDX                                                                   1
#define regCP_APPEND_LAST_CS_FENCE_HI                                                                   0x204d
#define regCP_APPEND_LAST_CS_FENCE_HI_BASE_IDX                                                          1
#define regCP_APPEND_LAST_PS_FENCE_HI                                                                   0x204e
#define regCP_APPEND_LAST_PS_FENCE_HI_BASE_IDX                                                          1
#define regCP_PFP_ATOMIC_PREOP_LO                                                                       0x2052
#define regCP_PFP_ATOMIC_PREOP_LO_BASE_IDX                                                              1
#define regCP_PFP_ATOMIC_PREOP_HI                                                                       0x2053
#define regCP_PFP_ATOMIC_PREOP_HI_BASE_IDX                                                              1
#define regCP_APPEND_ADDR_LO                                                                            0x2058
#define regCP_APPEND_ADDR_LO_BASE_IDX                                                                   1
#define regCP_APPEND_ADDR_HI                                                                            0x2059
#define regCP_APPEND_ADDR_HI_BASE_IDX                                                                   1
#define regCP_APPEND_DATA                                                                               0x205a
#define regCP_APPEND_DATA_BASE_IDX                                                                      1
#define regCP_APPEND_DATA_LO                                                                            0x205a
#define regCP_APPEND_DATA_LO_BASE_IDX                                                                   1
#define regCP_APPEND_LAST_CS_FENCE                                                                      0x205b
#define regCP_APPEND_LAST_CS_FENCE_BASE_IDX                                                             1
#define regCP_APPEND_LAST_CS_FENCE_LO                                                                   0x205b
#define regCP_APPEND_LAST_CS_FENCE_LO_BASE_IDX                                                          1
#define regCP_APPEND_LAST_PS_FENCE                                                                      0x205c
#define regCP_APPEND_LAST_PS_FENCE_BASE_IDX                                                             1
#define regCP_APPEND_LAST_PS_FENCE_LO                                                                   0x205c
#define regCP_APPEND_LAST_PS_FENCE_LO_BASE_IDX                                                          1
#define regCP_ATOMIC_PREOP_LO                                                                           0x205d
#define regCP_ATOMIC_PREOP_LO_BASE_IDX                                                                  1
#define regCP_ME_ATOMIC_PREOP_LO                                                                        0x205d
#define regCP_ME_ATOMIC_PREOP_LO_BASE_IDX                                                               1
#define regCP_ATOMIC_PREOP_HI                                                                           0x205e
#define regCP_ATOMIC_PREOP_HI_BASE_IDX                                                                  1
#define regCP_ME_ATOMIC_PREOP_HI                                                                        0x205e
#define regCP_ME_ATOMIC_PREOP_HI_BASE_IDX                                                               1
#define regCP_ME_MC_WADDR_LO                                                                            0x2069
#define regCP_ME_MC_WADDR_LO_BASE_IDX                                                                   1
#define regCP_ME_MC_WADDR_HI                                                                            0x206a
#define regCP_ME_MC_WADDR_HI_BASE_IDX                                                                   1
#define regCP_ME_MC_WDATA_LO                                                                            0x206b
#define regCP_ME_MC_WDATA_LO_BASE_IDX                                                                   1
#define regCP_ME_MC_WDATA_HI                                                                            0x206c
#define regCP_ME_MC_WDATA_HI_BASE_IDX                                                                   1
#define regCP_ME_MC_RADDR_LO                                                                            0x206d
#define regCP_ME_MC_RADDR_LO_BASE_IDX                                                                   1
#define regCP_ME_MC_RADDR_HI                                                                            0x206e
#define regCP_ME_MC_RADDR_HI_BASE_IDX                                                                   1
#define regCP_WAIT_REG_MEM_TIMEOUT                                                                      0x2074
#define regCP_WAIT_REG_MEM_TIMEOUT_BASE_IDX                                                             1
#define regCP_DMA_PFP_CONTROL                                                                           0x2077
#define regCP_DMA_PFP_CONTROL_BASE_IDX                                                                  1
#define regCP_DMA_ME_CONTROL                                                                            0x2078
#define regCP_DMA_ME_CONTROL_BASE_IDX                                                                   1
#define regCP_DMA_ME_SRC_ADDR                                                                           0x2080
#define regCP_DMA_ME_SRC_ADDR_BASE_IDX                                                                  1
#define regCP_DMA_ME_SRC_ADDR_HI                                                                        0x2081
#define regCP_DMA_ME_SRC_ADDR_HI_BASE_IDX                                                               1
#define regCP_DMA_ME_DST_ADDR                                                                           0x2082
#define regCP_DMA_ME_DST_ADDR_BASE_IDX                                                                  1
#define regCP_DMA_ME_DST_ADDR_HI                                                                        0x2083
#define regCP_DMA_ME_DST_ADDR_HI_BASE_IDX                                                               1
#define regCP_DMA_ME_COMMAND                                                                            0x2084
#define regCP_DMA_ME_COMMAND_BASE_IDX                                                                   1
#define regCP_DMA_PFP_SRC_ADDR                                                                          0x2085
#define regCP_DMA_PFP_SRC_ADDR_BASE_IDX                                                                 1
#define regCP_DMA_PFP_SRC_ADDR_HI                                                                       0x2086
#define regCP_DMA_PFP_SRC_ADDR_HI_BASE_IDX                                                              1
#define regCP_DMA_PFP_DST_ADDR                                                                          0x2087
#define regCP_DMA_PFP_DST_ADDR_BASE_IDX                                                                 1
#define regCP_DMA_PFP_DST_ADDR_HI                                                                       0x2088
#define regCP_DMA_PFP_DST_ADDR_HI_BASE_IDX                                                              1
#define regCP_DMA_PFP_COMMAND                                                                           0x2089
#define regCP_DMA_PFP_COMMAND_BASE_IDX                                                                  1
#define regCP_DMA_CNTL                                                                                  0x208a
#define regCP_DMA_CNTL_BASE_IDX                                                                         1
#define regCP_DMA_READ_TAGS                                                                             0x208b
#define regCP_DMA_READ_TAGS_BASE_IDX                                                                    1
#define regCP_PFP_IB_CONTROL                                                                            0x208d
#define regCP_PFP_IB_CONTROL_BASE_IDX                                                                   1
#define regCP_PFP_LOAD_CONTROL                                                                          0x208e
#define regCP_PFP_LOAD_CONTROL_BASE_IDX                                                                 1
#define regCP_SCRATCH_INDEX                                                                             0x208f
#define regCP_SCRATCH_INDEX_BASE_IDX                                                                    1
#define regCP_SCRATCH_DATA                                                                              0x2090
#define regCP_SCRATCH_DATA_BASE_IDX                                                                     1
#define regCP_RB_OFFSET                                                                                 0x2091
#define regCP_RB_OFFSET_BASE_IDX                                                                        1
#define regCP_IB1_OFFSET                                                                                0x2092
#define regCP_IB1_OFFSET_BASE_IDX                                                                       1
#define regCP_IB2_OFFSET                                                                                0x2093
#define regCP_IB2_OFFSET_BASE_IDX                                                                       1
#define regCP_IB1_PREAMBLE_BEGIN                                                                        0x2094
#define regCP_IB1_PREAMBLE_BEGIN_BASE_IDX                                                               1
#define regCP_IB1_PREAMBLE_END                                                                          0x2095
#define regCP_IB1_PREAMBLE_END_BASE_IDX                                                                 1
#define regCP_IB2_PREAMBLE_BEGIN                                                                        0x2096
#define regCP_IB2_PREAMBLE_BEGIN_BASE_IDX                                                               1
#define regCP_IB2_PREAMBLE_END                                                                          0x2097
#define regCP_IB2_PREAMBLE_END_BASE_IDX                                                                 1
#define regCP_DMA_ME_CMD_ADDR_LO                                                                        0x209c
#define regCP_DMA_ME_CMD_ADDR_LO_BASE_IDX                                                               1
#define regCP_DMA_ME_CMD_ADDR_HI                                                                        0x209d
#define regCP_DMA_ME_CMD_ADDR_HI_BASE_IDX                                                               1
#define regCP_DMA_PFP_CMD_ADDR_LO                                                                       0x209e
#define regCP_DMA_PFP_CMD_ADDR_LO_BASE_IDX                                                              1
#define regCP_DMA_PFP_CMD_ADDR_HI                                                                       0x209f
#define regCP_DMA_PFP_CMD_ADDR_HI_BASE_IDX                                                              1
#define regUCONFIG_RESERVED_REG0                                                                        0x20a2
#define regUCONFIG_RESERVED_REG0_BASE_IDX                                                               1
#define regUCONFIG_RESERVED_REG1                                                                        0x20a3
#define regUCONFIG_RESERVED_REG1_BASE_IDX                                                               1
#define regCP_PA_MSPRIM_COUNT_LO                                                                        0x20a4
#define regCP_PA_MSPRIM_COUNT_LO_BASE_IDX                                                               1
#define regCP_PA_MSPRIM_COUNT_HI                                                                        0x20a5
#define regCP_PA_MSPRIM_COUNT_HI_BASE_IDX                                                               1
#define regCP_GE_MSINVOC_COUNT_LO                                                                       0x20a6
#define regCP_GE_MSINVOC_COUNT_LO_BASE_IDX                                                              1
#define regCP_GE_MSINVOC_COUNT_HI                                                                       0x20a7
#define regCP_GE_MSINVOC_COUNT_HI_BASE_IDX                                                              1
#define regCP_IB1_CMD_BUFSZ                                                                             0x20c0
#define regCP_IB1_CMD_BUFSZ_BASE_IDX                                                                    1
#define regCP_IB2_CMD_BUFSZ                                                                             0x20c1
#define regCP_IB2_CMD_BUFSZ_BASE_IDX                                                                    1
#define regCP_ST_CMD_BUFSZ                                                                              0x20c2
#define regCP_ST_CMD_BUFSZ_BASE_IDX                                                                     1
#define regCP_IB1_BASE_LO                                                                               0x20cc
#define regCP_IB1_BASE_LO_BASE_IDX                                                                      1
#define regCP_IB1_BASE_HI                                                                               0x20cd
#define regCP_IB1_BASE_HI_BASE_IDX                                                                      1
#define regCP_IB1_BUFSZ                                                                                 0x20ce
#define regCP_IB1_BUFSZ_BASE_IDX                                                                        1
#define regCP_IB2_BASE_LO                                                                               0x20cf
#define regCP_IB2_BASE_LO_BASE_IDX                                                                      1
#define regCP_IB2_BASE_HI                                                                               0x20d0
#define regCP_IB2_BASE_HI_BASE_IDX                                                                      1
#define regCP_IB2_BUFSZ                                                                                 0x20d1
#define regCP_IB2_BUFSZ_BASE_IDX                                                                        1
#define regCP_ST_BASE_LO                                                                                0x20d2
#define regCP_ST_BASE_LO_BASE_IDX                                                                       1
#define regCP_ST_BASE_HI                                                                                0x20d3
#define regCP_ST_BASE_HI_BASE_IDX                                                                       1
#define regCP_ST_BUFSZ                                                                                  0x20d4
#define regCP_ST_BUFSZ_BASE_IDX                                                                         1
#define regCP_EOP_DONE_EVENT_CNTL                                                                       0x20d5
#define regCP_EOP_DONE_EVENT_CNTL_BASE_IDX                                                              1
#define regCP_EOP_DONE_DATA_CNTL                                                                        0x20d6
#define regCP_EOP_DONE_DATA_CNTL_BASE_IDX                                                               1
#define regCP_EOP_DONE_CNTX_ID                                                                          0x20d7
#define regCP_EOP_DONE_CNTX_ID_BASE_IDX                                                                 1
#define regCP_DB_BASE_LO                                                                                0x20d8
#define regCP_DB_BASE_LO_BASE_IDX                                                                       1
#define regCP_DB_BASE_HI                                                                                0x20d9
#define regCP_DB_BASE_HI_BASE_IDX                                                                       1
#define regCP_DB_BUFSZ                                                                                  0x20da
#define regCP_DB_BUFSZ_BASE_IDX                                                                         1
#define regCP_DB_CMD_BUFSZ                                                                              0x20db
#define regCP_DB_CMD_BUFSZ_BASE_IDX                                                                     1
#define regCP_PFP_COMPLETION_STATUS                                                                     0x20ec
#define regCP_PFP_COMPLETION_STATUS_BASE_IDX                                                            1
#define regCP_PRED_NOT_VISIBLE                                                                          0x20ee
#define regCP_PRED_NOT_VISIBLE_BASE_IDX                                                                 1
#define regCP_PFP_METADATA_BASE_ADDR                                                                    0x20f0
#define regCP_PFP_METADATA_BASE_ADDR_BASE_IDX                                                           1
#define regCP_PFP_METADATA_BASE_ADDR_HI                                                                 0x20f1
#define regCP_PFP_METADATA_BASE_ADDR_HI_BASE_IDX                                                        1
#define regCP_DRAW_INDX_INDR_ADDR                                                                       0x20f4
#define regCP_DRAW_INDX_INDR_ADDR_BASE_IDX                                                              1
#define regCP_DRAW_INDX_INDR_ADDR_HI                                                                    0x20f5
#define regCP_DRAW_INDX_INDR_ADDR_HI_BASE_IDX                                                           1
#define regCP_DISPATCH_INDR_ADDR                                                                        0x20f6
#define regCP_DISPATCH_INDR_ADDR_BASE_IDX                                                               1
#define regCP_DISPATCH_INDR_ADDR_HI                                                                     0x20f7
#define regCP_DISPATCH_INDR_ADDR_HI_BASE_IDX                                                            1
#define regCP_INDEX_BASE_ADDR                                                                           0x20f8
#define regCP_INDEX_BASE_ADDR_BASE_IDX                                                                  1
#define regCP_INDEX_BASE_ADDR_HI                                                                        0x20f9
#define regCP_INDEX_BASE_ADDR_HI_BASE_IDX                                                               1
#define regCP_INDEX_TYPE                                                                                0x20fa
#define regCP_INDEX_TYPE_BASE_IDX                                                                       1
#define regCP_SAMPLE_STATUS                                                                             0x20fd
#define regCP_SAMPLE_STATUS_BASE_IDX                                                                    1
#define regCP_ME_COHER_CNTL                                                                             0x20fe
#define regCP_ME_COHER_CNTL_BASE_IDX                                                                    1
#define regCP_ME_COHER_SIZE                                                                             0x20ff
#define regCP_ME_COHER_SIZE_BASE_IDX                                                                    1
#define regCP_ME_COHER_SIZE_HI                                                                          0x2100
#define regCP_ME_COHER_SIZE_HI_BASE_IDX                                                                 1
#define regCP_ME_COHER_BASE                                                                             0x2101
#define regCP_ME_COHER_BASE_BASE_IDX                                                                    1
#define regCP_ME_COHER_BASE_HI                                                                          0x2102
#define regCP_ME_COHER_BASE_HI_BASE_IDX                                                                 1
#define regCP_ME_COHER_STATUS                                                                           0x2103
#define regCP_ME_COHER_STATUS_BASE_IDX                                                                  1
#define regRLC_GPM_PERF_COUNT_0                                                                         0x2140
#define regRLC_GPM_PERF_COUNT_0_BASE_IDX                                                                1
#define regRLC_GPM_PERF_COUNT_1                                                                         0x2141
#define regRLC_GPM_PERF_COUNT_1_BASE_IDX                                                                1
#define regGRBM_GFX_INDEX                                                                               0x2200
#define regGRBM_GFX_INDEX_BASE_IDX                                                                      1
#define regGRBM_NOWHERE_2                                                                               0x2201
#define regGRBM_NOWHERE_2_BASE_IDX                                                                      1
#define regVGT_PRIMITIVE_TYPE                                                                           0x2242
#define regVGT_PRIMITIVE_TYPE_BASE_IDX                                                                  1
#define regVGT_INDEX_TYPE                                                                               0x2243
#define regVGT_INDEX_TYPE_BASE_IDX                                                                      1
#define regGE_MIN_VTX_INDX                                                                              0x2249
#define regGE_MIN_VTX_INDX_BASE_IDX                                                                     1
#define regGE_INDX_OFFSET                                                                               0x224a
#define regGE_INDX_OFFSET_BASE_IDX                                                                      1
#define regGE_MULTI_PRIM_IB_RESET_EN                                                                    0x224b
#define regGE_MULTI_PRIM_IB_RESET_EN_BASE_IDX                                                           1
#define regVGT_NUM_INDICES                                                                              0x224c
#define regVGT_NUM_INDICES_BASE_IDX                                                                     1
#define regVGT_NUM_INSTANCES                                                                            0x224d
#define regVGT_NUM_INSTANCES_BASE_IDX                                                                   1
#define regVGT_TF_MEMORY_BASE                                                                           0x2250
#define regVGT_TF_MEMORY_BASE_BASE_IDX                                                                  1
#define regGE_GS_THROTTLE                                                                               0x2254
#define regGE_GS_THROTTLE_BASE_IDX                                                                      1
#define regGE_MAX_VTX_INDX                                                                              0x2259
#define regGE_MAX_VTX_INDX_BASE_IDX                                                                     1
#define regVGT_INSTANCE_BASE_ID                                                                         0x225a
#define regVGT_INSTANCE_BASE_ID_BASE_IDX                                                                1
#define regGE_CNTL                                                                                      0x225b
#define regGE_CNTL_BASE_IDX                                                                             1
#define regGE_USER_VGPR1                                                                                0x225c
#define regGE_USER_VGPR1_BASE_IDX                                                                       1
#define regGE_USER_VGPR2                                                                                0x225d
#define regGE_USER_VGPR2_BASE_IDX                                                                       1
#define regGE_USER_VGPR3                                                                                0x225e
#define regGE_USER_VGPR3_BASE_IDX                                                                       1
#define regGE_STEREO_CNTL                                                                               0x225f
#define regGE_STEREO_CNTL_BASE_IDX                                                                      1
#define regGE_USER_VGPR_EN                                                                              0x2260
#define regGE_USER_VGPR_EN_BASE_IDX                                                                     1
#define regVGT_PRIMITIVEID_EN                                                                           0x2262
#define regVGT_PRIMITIVEID_EN_BASE_IDX                                                                  1
#define regGE_VRS_RATE                                                                                  0x2263
#define regGE_VRS_RATE_BASE_IDX                                                                         1
#define regGE_GS_FAST_LAUNCH_WG_DIM                                                                     0x2264
#define regGE_GS_FAST_LAUNCH_WG_DIM_BASE_IDX                                                            1
#define regGE_GS_FAST_LAUNCH_WG_DIM_1                                                                   0x2265
#define regGE_GS_FAST_LAUNCH_WG_DIM_1_BASE_IDX                                                          1
#define regVGT_GS_OUT_PRIM_TYPE                                                                         0x2266
#define regVGT_GS_OUT_PRIM_TYPE_BASE_IDX                                                                1
#define regVGT_TF_MEMORY_BASE_HI                                                                        0x2267
#define regVGT_TF_MEMORY_BASE_HI_BASE_IDX                                                               1
#define regGE_GS_ORDERED_ID_BASE                                                                        0x226c
#define regGE_GS_ORDERED_ID_BASE_BASE_IDX                                                               1
#define regVGT_PRIMITIVEID_RESET                                                                        0x226d
#define regVGT_PRIMITIVEID_RESET_BASE_IDX                                                               1


// addressBlock: gc_gfx_cpwd_cpwd_cprs64dec
// base address: 0x32000
#define regCP_MES_PRGRM_CNTR_START                                                                      0x2800
#define regCP_MES_PRGRM_CNTR_START_BASE_IDX                                                             1
#define regCP_MES_INTR_ROUTINE_START                                                                    0x2801
#define regCP_MES_INTR_ROUTINE_START_BASE_IDX                                                           1
#define regCP_MES_MTVEC_LO                                                                              0x2801
#define regCP_MES_MTVEC_LO_BASE_IDX                                                                     1
#define regCP_MES_INTR_ROUTINE_START_HI                                                                 0x2802
#define regCP_MES_INTR_ROUTINE_START_HI_BASE_IDX                                                        1
#define regCP_MES_MTVEC_HI                                                                              0x2802
#define regCP_MES_MTVEC_HI_BASE_IDX                                                                     1
#define regCP_MES_CNTL                                                                                  0x2807
#define regCP_MES_CNTL_BASE_IDX                                                                         1
#define regCP_MES_PIPE_PRIORITY_CNTS                                                                    0x2808
#define regCP_MES_PIPE_PRIORITY_CNTS_BASE_IDX                                                           1
#define regCP_MES_PIPE0_PRIORITY                                                                        0x2809
#define regCP_MES_PIPE0_PRIORITY_BASE_IDX                                                               1
#define regCP_MES_PIPE1_PRIORITY                                                                        0x280a
#define regCP_MES_PIPE1_PRIORITY_BASE_IDX                                                               1
#define regCP_MES_PIPE2_PRIORITY                                                                        0x280b
#define regCP_MES_PIPE2_PRIORITY_BASE_IDX                                                               1
#define regCP_MES_PIPE3_PRIORITY                                                                        0x280c
#define regCP_MES_PIPE3_PRIORITY_BASE_IDX                                                               1
#define regCP_MES_HEADER_DUMP                                                                           0x280d
#define regCP_MES_HEADER_DUMP_BASE_IDX                                                                  1
#define regCP_MES_MIE_LO                                                                                0x280e
#define regCP_MES_MIE_LO_BASE_IDX                                                                       1
#define regCP_MES_MIE_HI                                                                                0x280f
#define regCP_MES_MIE_HI_BASE_IDX                                                                       1
#define regCP_MES_INTERRUPT                                                                             0x2810
#define regCP_MES_INTERRUPT_BASE_IDX                                                                    1
#define regCP_MES_SCRATCH_INDEX                                                                         0x2811
#define regCP_MES_SCRATCH_INDEX_BASE_IDX                                                                1
#define regCP_MES_SCRATCH_DATA                                                                          0x2812
#define regCP_MES_SCRATCH_DATA_BASE_IDX                                                                 1
#define regCP_MES_INSTR_PNTR                                                                            0x2813
#define regCP_MES_INSTR_PNTR_BASE_IDX                                                                   1
#define regCP_MES_MSCRATCH_HI                                                                           0x2814
#define regCP_MES_MSCRATCH_HI_BASE_IDX                                                                  1
#define regCP_MES_MSCRATCH_LO                                                                           0x2815
#define regCP_MES_MSCRATCH_LO_BASE_IDX                                                                  1
#define regCP_MES_MSTATUS_LO                                                                            0x2816
#define regCP_MES_MSTATUS_LO_BASE_IDX                                                                   1
#define regCP_MES_MSTATUS_HI                                                                            0x2817
#define regCP_MES_MSTATUS_HI_BASE_IDX                                                                   1
#define regCP_MES_MEPC_LO                                                                               0x2818
#define regCP_MES_MEPC_LO_BASE_IDX                                                                      1
#define regCP_MES_MEPC_HI                                                                               0x2819
#define regCP_MES_MEPC_HI_BASE_IDX                                                                      1
#define regCP_MES_MCAUSE_LO                                                                             0x281a
#define regCP_MES_MCAUSE_LO_BASE_IDX                                                                    1
#define regCP_MES_MCAUSE_HI                                                                             0x281b
#define regCP_MES_MCAUSE_HI_BASE_IDX                                                                    1
#define regCP_MES_MBADADDR_LO                                                                           0x281c
#define regCP_MES_MBADADDR_LO_BASE_IDX                                                                  1
#define regCP_MES_MBADADDR_HI                                                                           0x281d
#define regCP_MES_MBADADDR_HI_BASE_IDX                                                                  1
#define regCP_MES_MIP_LO                                                                                0x281e
#define regCP_MES_MIP_LO_BASE_IDX                                                                       1
#define regCP_MES_MIP_HI                                                                                0x281f
#define regCP_MES_MIP_HI_BASE_IDX                                                                       1
#define regCP_MES_IC_OP_CNTL                                                                            0x2820
#define regCP_MES_IC_OP_CNTL_BASE_IDX                                                                   1
#define regCP_MES_MCYCLE_LO                                                                             0x2826
#define regCP_MES_MCYCLE_LO_BASE_IDX                                                                    1
#define regCP_MES_MCYCLE_HI                                                                             0x2827
#define regCP_MES_MCYCLE_HI_BASE_IDX                                                                    1
#define regCP_MES_MTIME_LO                                                                              0x2828
#define regCP_MES_MTIME_LO_BASE_IDX                                                                     1
#define regCP_MES_MTIME_HI                                                                              0x2829
#define regCP_MES_MTIME_HI_BASE_IDX                                                                     1
#define regCP_MES_MINSTRET_LO                                                                           0x282a
#define regCP_MES_MINSTRET_LO_BASE_IDX                                                                  1
#define regCP_MES_MINSTRET_HI                                                                           0x282b
#define regCP_MES_MINSTRET_HI_BASE_IDX                                                                  1
#define regCP_MES_MISA_LO                                                                               0x282c
#define regCP_MES_MISA_LO_BASE_IDX                                                                      1
#define regCP_MES_MISA_HI                                                                               0x282d
#define regCP_MES_MISA_HI_BASE_IDX                                                                      1
#define regCP_MES_MVENDORID_LO                                                                          0x282e
#define regCP_MES_MVENDORID_LO_BASE_IDX                                                                 1
#define regCP_MES_MVENDORID_HI                                                                          0x282f
#define regCP_MES_MVENDORID_HI_BASE_IDX                                                                 1
#define regCP_MES_MARCHID_LO                                                                            0x2830
#define regCP_MES_MARCHID_LO_BASE_IDX                                                                   1
#define regCP_MES_MARCHID_HI                                                                            0x2831
#define regCP_MES_MARCHID_HI_BASE_IDX                                                                   1
#define regCP_MES_MIMPID_LO                                                                             0x2832
#define regCP_MES_MIMPID_LO_BASE_IDX                                                                    1
#define regCP_MES_MIMPID_HI                                                                             0x2833
#define regCP_MES_MIMPID_HI_BASE_IDX                                                                    1
#define regCP_MES_MHARTID_LO                                                                            0x2834
#define regCP_MES_MHARTID_LO_BASE_IDX                                                                   1
#define regCP_MES_MHARTID_HI                                                                            0x2835
#define regCP_MES_MHARTID_HI_BASE_IDX                                                                   1
#define regCP_MES_DC_BASE_CNTL                                                                          0x2836
#define regCP_MES_DC_BASE_CNTL_BASE_IDX                                                                 1
#define regCP_MES_DC_OP_CNTL                                                                            0x2837
#define regCP_MES_DC_OP_CNTL_BASE_IDX                                                                   1
#define regCP_MES_MTIMECMP_LO                                                                           0x2838
#define regCP_MES_MTIMECMP_LO_BASE_IDX                                                                  1
#define regCP_MES_MTIMECMP_HI                                                                           0x2839
#define regCP_MES_MTIMECMP_HI_BASE_IDX                                                                  1
#define regCP_MES_PROCESS_QUANTUM_PIPE0                                                                 0x283a
#define regCP_MES_PROCESS_QUANTUM_PIPE0_BASE_IDX                                                        1
#define regCP_MES_PROCESS_QUANTUM_PIPE1                                                                 0x283b
#define regCP_MES_PROCESS_QUANTUM_PIPE1_BASE_IDX                                                        1
#define regCP_MES_DOORBELL_CONTROL1                                                                     0x283c
#define regCP_MES_DOORBELL_CONTROL1_BASE_IDX                                                            1
#define regCP_MES_DOORBELL_CONTROL2                                                                     0x283d
#define regCP_MES_DOORBELL_CONTROL2_BASE_IDX                                                            1
#define regCP_MES_DOORBELL_CONTROL3                                                                     0x283e
#define regCP_MES_DOORBELL_CONTROL3_BASE_IDX                                                            1
#define regCP_MES_DOORBELL_CONTROL4                                                                     0x283f
#define regCP_MES_DOORBELL_CONTROL4_BASE_IDX                                                            1
#define regCP_MES_DOORBELL_CONTROL5                                                                     0x2840
#define regCP_MES_DOORBELL_CONTROL5_BASE_IDX                                                            1
#define regCP_MES_DOORBELL_CONTROL6                                                                     0x2841
#define regCP_MES_DOORBELL_CONTROL6_BASE_IDX                                                            1
#define regCP_MES_GP0_LO                                                                                0x2843
#define regCP_MES_GP0_LO_BASE_IDX                                                                       1
#define regCP_MES_GP0_HI                                                                                0x2844
#define regCP_MES_GP0_HI_BASE_IDX                                                                       1
#define regCP_MES_GP1_LO                                                                                0x2845
#define regCP_MES_GP1_LO_BASE_IDX                                                                       1
#define regCP_MES_GP1_HI                                                                                0x2846
#define regCP_MES_GP1_HI_BASE_IDX                                                                       1
#define regCP_MES_GP2_LO                                                                                0x2847
#define regCP_MES_GP2_LO_BASE_IDX                                                                       1
#define regCP_MES_GP2_HI                                                                                0x2848
#define regCP_MES_GP2_HI_BASE_IDX                                                                       1
#define regCP_MES_GP3_LO                                                                                0x2849
#define regCP_MES_GP3_LO_BASE_IDX                                                                       1
#define regCP_MES_GP3_HI                                                                                0x284a
#define regCP_MES_GP3_HI_BASE_IDX                                                                       1
#define regCP_MES_GP4_LO                                                                                0x284b
#define regCP_MES_GP4_LO_BASE_IDX                                                                       1
#define regCP_MES_GP4_HI                                                                                0x284c
#define regCP_MES_GP4_HI_BASE_IDX                                                                       1
#define regCP_MES_GP5_LO                                                                                0x284d
#define regCP_MES_GP5_LO_BASE_IDX                                                                       1
#define regCP_MES_GP5_HI                                                                                0x284e
#define regCP_MES_GP5_HI_BASE_IDX                                                                       1
#define regCP_MES_GP6_LO                                                                                0x284f
#define regCP_MES_GP6_LO_BASE_IDX                                                                       1
#define regCP_MES_GP6_HI                                                                                0x2850
#define regCP_MES_GP6_HI_BASE_IDX                                                                       1
#define regCP_MES_GP7_LO                                                                                0x2851
#define regCP_MES_GP7_LO_BASE_IDX                                                                       1
#define regCP_MES_GP7_HI                                                                                0x2852
#define regCP_MES_GP7_HI_BASE_IDX                                                                       1
#define regCP_MES_GP8_LO                                                                                0x2853
#define regCP_MES_GP8_LO_BASE_IDX                                                                       1
#define regCP_MES_GP8_HI                                                                                0x2854
#define regCP_MES_GP8_HI_BASE_IDX                                                                       1
#define regCP_MES_GP9_LO                                                                                0x2855
#define regCP_MES_GP9_LO_BASE_IDX                                                                       1
#define regCP_MES_GP9_HI                                                                                0x2856
#define regCP_MES_GP9_HI_BASE_IDX                                                                       1
#define regCP_MES_LOCAL_BASE0_LO                                                                        0x2883
#define regCP_MES_LOCAL_BASE0_LO_BASE_IDX                                                               1
#define regCP_MES_LOCAL_BASE0_HI                                                                        0x2884
#define regCP_MES_LOCAL_BASE0_HI_BASE_IDX                                                               1
#define regCP_MES_LOCAL_MASK0_LO                                                                        0x2885
#define regCP_MES_LOCAL_MASK0_LO_BASE_IDX                                                               1
#define regCP_MES_LOCAL_MASK0_HI                                                                        0x2886
#define regCP_MES_LOCAL_MASK0_HI_BASE_IDX                                                               1
#define regCP_MES_LOCAL_APERTURE                                                                        0x2887
#define regCP_MES_LOCAL_APERTURE_BASE_IDX                                                               1
#define regCP_MES_LOCAL_INSTR_BASE_LO                                                                   0x2888
#define regCP_MES_LOCAL_INSTR_BASE_LO_BASE_IDX                                                          1
#define regCP_MES_LOCAL_INSTR_BASE_HI                                                                   0x2889
#define regCP_MES_LOCAL_INSTR_BASE_HI_BASE_IDX                                                          1
#define regCP_MES_LOCAL_INSTR_MASK_LO                                                                   0x288a
#define regCP_MES_LOCAL_INSTR_MASK_LO_BASE_IDX                                                          1
#define regCP_MES_LOCAL_INSTR_MASK_HI                                                                   0x288b
#define regCP_MES_LOCAL_INSTR_MASK_HI_BASE_IDX                                                          1
#define regCP_MES_LOCAL_INSTR_APERTURE                                                                  0x288c
#define regCP_MES_LOCAL_INSTR_APERTURE_BASE_IDX                                                         1
#define regCP_MES_LOCAL_SCRATCH_APERTURE                                                                0x288d
#define regCP_MES_LOCAL_SCRATCH_APERTURE_BASE_IDX                                                       1
#define regCP_MES_LOCAL_SCRATCH_BASE_LO                                                                 0x288e
#define regCP_MES_LOCAL_SCRATCH_BASE_LO_BASE_IDX                                                        1
#define regCP_MES_LOCAL_SCRATCH_BASE_HI                                                                 0x288f
#define regCP_MES_LOCAL_SCRATCH_BASE_HI_BASE_IDX                                                        1
#define regCP_MES_PERFCOUNT_CNTL                                                                        0x2899
#define regCP_MES_PERFCOUNT_CNTL_BASE_IDX                                                               1
#define regCP_MES_PENDING_INTERRUPT                                                                     0x289a
#define regCP_MES_PENDING_INTERRUPT_BASE_IDX                                                            1
#define regCP_MES_RS64_EXCEPTION_STATUS                                                                 0x289c
#define regCP_MES_RS64_EXCEPTION_STATUS_BASE_IDX                                                        1
#define regCP_MES_PRGRM_CNTR_START_HI                                                                   0x289d
#define regCP_MES_PRGRM_CNTR_START_HI_BASE_IDX                                                          1
#define regCP_MES_INTERRUPT_DATA_16                                                                     0x289f
#define regCP_MES_INTERRUPT_DATA_16_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_17                                                                     0x28a0
#define regCP_MES_INTERRUPT_DATA_17_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_18                                                                     0x28a1
#define regCP_MES_INTERRUPT_DATA_18_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_19                                                                     0x28a2
#define regCP_MES_INTERRUPT_DATA_19_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_20                                                                     0x28a3
#define regCP_MES_INTERRUPT_DATA_20_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_21                                                                     0x28a4
#define regCP_MES_INTERRUPT_DATA_21_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_22                                                                     0x28a5
#define regCP_MES_INTERRUPT_DATA_22_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_23                                                                     0x28a6
#define regCP_MES_INTERRUPT_DATA_23_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_24                                                                     0x28a7
#define regCP_MES_INTERRUPT_DATA_24_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_25                                                                     0x28a8
#define regCP_MES_INTERRUPT_DATA_25_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_26                                                                     0x28a9
#define regCP_MES_INTERRUPT_DATA_26_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_27                                                                     0x28aa
#define regCP_MES_INTERRUPT_DATA_27_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_28                                                                     0x28ab
#define regCP_MES_INTERRUPT_DATA_28_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_29                                                                     0x28ac
#define regCP_MES_INTERRUPT_DATA_29_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_30                                                                     0x28ad
#define regCP_MES_INTERRUPT_DATA_30_BASE_IDX                                                            1
#define regCP_MES_INTERRUPT_DATA_31                                                                     0x28ae
#define regCP_MES_INTERRUPT_DATA_31_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE0_BASE                                                                     0x28af
#define regCP_MES_DC_APERTURE0_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE0_MASK                                                                     0x28b0
#define regCP_MES_DC_APERTURE0_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE0_CNTL                                                                     0x28b1
#define regCP_MES_DC_APERTURE0_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE1_BASE                                                                     0x28b2
#define regCP_MES_DC_APERTURE1_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE1_MASK                                                                     0x28b3
#define regCP_MES_DC_APERTURE1_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE1_CNTL                                                                     0x28b4
#define regCP_MES_DC_APERTURE1_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE2_BASE                                                                     0x28b5
#define regCP_MES_DC_APERTURE2_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE2_MASK                                                                     0x28b6
#define regCP_MES_DC_APERTURE2_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE2_CNTL                                                                     0x28b7
#define regCP_MES_DC_APERTURE2_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE3_BASE                                                                     0x28b8
#define regCP_MES_DC_APERTURE3_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE3_MASK                                                                     0x28b9
#define regCP_MES_DC_APERTURE3_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE3_CNTL                                                                     0x28ba
#define regCP_MES_DC_APERTURE3_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE4_BASE                                                                     0x28bb
#define regCP_MES_DC_APERTURE4_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE4_MASK                                                                     0x28bc
#define regCP_MES_DC_APERTURE4_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE4_CNTL                                                                     0x28bd
#define regCP_MES_DC_APERTURE4_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE5_BASE                                                                     0x28be
#define regCP_MES_DC_APERTURE5_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE5_MASK                                                                     0x28bf
#define regCP_MES_DC_APERTURE5_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE5_CNTL                                                                     0x28c0
#define regCP_MES_DC_APERTURE5_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE6_BASE                                                                     0x28c1
#define regCP_MES_DC_APERTURE6_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE6_MASK                                                                     0x28c2
#define regCP_MES_DC_APERTURE6_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE6_CNTL                                                                     0x28c3
#define regCP_MES_DC_APERTURE6_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE7_BASE                                                                     0x28c4
#define regCP_MES_DC_APERTURE7_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE7_MASK                                                                     0x28c5
#define regCP_MES_DC_APERTURE7_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE7_CNTL                                                                     0x28c6
#define regCP_MES_DC_APERTURE7_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE8_BASE                                                                     0x28c7
#define regCP_MES_DC_APERTURE8_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE8_MASK                                                                     0x28c8
#define regCP_MES_DC_APERTURE8_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE8_CNTL                                                                     0x28c9
#define regCP_MES_DC_APERTURE8_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE9_BASE                                                                     0x28ca
#define regCP_MES_DC_APERTURE9_BASE_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE9_MASK                                                                     0x28cb
#define regCP_MES_DC_APERTURE9_MASK_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE9_CNTL                                                                     0x28cc
#define regCP_MES_DC_APERTURE9_CNTL_BASE_IDX                                                            1
#define regCP_MES_DC_APERTURE10_BASE                                                                    0x28cd
#define regCP_MES_DC_APERTURE10_BASE_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE10_MASK                                                                    0x28ce
#define regCP_MES_DC_APERTURE10_MASK_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE10_CNTL                                                                    0x28cf
#define regCP_MES_DC_APERTURE10_CNTL_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE11_BASE                                                                    0x28d0
#define regCP_MES_DC_APERTURE11_BASE_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE11_MASK                                                                    0x28d1
#define regCP_MES_DC_APERTURE11_MASK_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE11_CNTL                                                                    0x28d2
#define regCP_MES_DC_APERTURE11_CNTL_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE12_BASE                                                                    0x28d3
#define regCP_MES_DC_APERTURE12_BASE_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE12_MASK                                                                    0x28d4
#define regCP_MES_DC_APERTURE12_MASK_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE12_CNTL                                                                    0x28d5
#define regCP_MES_DC_APERTURE12_CNTL_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE13_BASE                                                                    0x28d6
#define regCP_MES_DC_APERTURE13_BASE_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE13_MASK                                                                    0x28d7
#define regCP_MES_DC_APERTURE13_MASK_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE13_CNTL                                                                    0x28d8
#define regCP_MES_DC_APERTURE13_CNTL_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE14_BASE                                                                    0x28d9
#define regCP_MES_DC_APERTURE14_BASE_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE14_MASK                                                                    0x28da
#define regCP_MES_DC_APERTURE14_MASK_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE14_CNTL                                                                    0x28db
#define regCP_MES_DC_APERTURE14_CNTL_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE15_BASE                                                                    0x28dc
#define regCP_MES_DC_APERTURE15_BASE_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE15_MASK                                                                    0x28dd
#define regCP_MES_DC_APERTURE15_MASK_BASE_IDX                                                           1
#define regCP_MES_DC_APERTURE15_CNTL                                                                    0x28de
#define regCP_MES_DC_APERTURE15_CNTL_BASE_IDX                                                           1
#define regCP_MES_METADATA_CNTL                                                                         0x28df
#define regCP_MES_METADATA_CNTL_BASE_IDX                                                                1
#define regCP_MEC_RS64_PRGRM_CNTR_START                                                                 0x2900
#define regCP_MEC_RS64_PRGRM_CNTR_START_BASE_IDX                                                        1
#define regCP_MEC_MTVEC_LO                                                                              0x2901
#define regCP_MEC_MTVEC_LO_BASE_IDX                                                                     1
#define regCP_MEC_MTVEC_HI                                                                              0x2902
#define regCP_MEC_MTVEC_HI_BASE_IDX                                                                     1
#define regCP_MEC_RS64_CNTL                                                                             0x2904
#define regCP_MEC_RS64_CNTL_BASE_IDX                                                                    1
#define regCP_MEC_MIE_LO                                                                                0x2905
#define regCP_MEC_MIE_LO_BASE_IDX                                                                       1
#define regCP_MEC_MIE_HI                                                                                0x2906
#define regCP_MEC_MIE_HI_BASE_IDX                                                                       1
#define regCP_MEC_RS64_INTERRUPT                                                                        0x2907
#define regCP_MEC_RS64_INTERRUPT_BASE_IDX                                                               1
#define regCP_MEC_RS64_INSTR_PNTR                                                                       0x2908
#define regCP_MEC_RS64_INSTR_PNTR_BASE_IDX                                                              1
#define regCP_MEC_MIP_LO                                                                                0x2909
#define regCP_MEC_MIP_LO_BASE_IDX                                                                       1
#define regCP_MEC_MIP_HI                                                                                0x290a
#define regCP_MEC_MIP_HI_BASE_IDX                                                                       1
#define regCP_MEC_DC_BASE_CNTL                                                                          0x290b
#define regCP_MEC_DC_BASE_CNTL_BASE_IDX                                                                 1
#define regCP_MEC_DC_OP_CNTL                                                                            0x290c
#define regCP_MEC_DC_OP_CNTL_BASE_IDX                                                                   1
#define regCP_MEC_MTIMECMP_LO                                                                           0x290d
#define regCP_MEC_MTIMECMP_LO_BASE_IDX                                                                  1
#define regCP_MEC_MTIMECMP_HI                                                                           0x290e
#define regCP_MEC_MTIMECMP_HI_BASE_IDX                                                                  1
#define regCP_MEC_GP0_LO                                                                                0x2910
#define regCP_MEC_GP0_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP0_HI                                                                                0x2911
#define regCP_MEC_GP0_HI_BASE_IDX                                                                       1
#define regCP_MEC_GP1_LO                                                                                0x2912
#define regCP_MEC_GP1_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP1_HI                                                                                0x2913
#define regCP_MEC_GP1_HI_BASE_IDX                                                                       1
#define regCP_MEC_GP2_LO                                                                                0x2914
#define regCP_MEC_GP2_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP2_HI                                                                                0x2915
#define regCP_MEC_GP2_HI_BASE_IDX                                                                       1
#define regCP_MEC_GP3_LO                                                                                0x2916
#define regCP_MEC_GP3_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP3_HI                                                                                0x2917
#define regCP_MEC_GP3_HI_BASE_IDX                                                                       1
#define regCP_MEC_GP4_LO                                                                                0x2918
#define regCP_MEC_GP4_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP4_HI                                                                                0x2919
#define regCP_MEC_GP4_HI_BASE_IDX                                                                       1
#define regCP_MEC_GP5_LO                                                                                0x291a
#define regCP_MEC_GP5_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP5_HI                                                                                0x291b
#define regCP_MEC_GP5_HI_BASE_IDX                                                                       1
#define regCP_MEC_GP6_LO                                                                                0x291c
#define regCP_MEC_GP6_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP6_HI                                                                                0x291d
#define regCP_MEC_GP6_HI_BASE_IDX                                                                       1
#define regCP_MEC_GP7_LO                                                                                0x291e
#define regCP_MEC_GP7_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP7_HI                                                                                0x291f
#define regCP_MEC_GP7_HI_BASE_IDX                                                                       1
#define regCP_MEC_GP8_LO                                                                                0x2920
#define regCP_MEC_GP8_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP8_HI                                                                                0x2921
#define regCP_MEC_GP8_HI_BASE_IDX                                                                       1
#define regCP_MEC_GP9_LO                                                                                0x2922
#define regCP_MEC_GP9_LO_BASE_IDX                                                                       1
#define regCP_MEC_GP9_HI                                                                                0x2923
#define regCP_MEC_GP9_HI_BASE_IDX                                                                       1
#define regCP_MEC_LOCAL_BASE0_LO                                                                        0x2927
#define regCP_MEC_LOCAL_BASE0_LO_BASE_IDX                                                               1
#define regCP_MEC_LOCAL_BASE0_HI                                                                        0x2928
#define regCP_MEC_LOCAL_BASE0_HI_BASE_IDX                                                               1
#define regCP_MEC_LOCAL_MASK0_LO                                                                        0x2929
#define regCP_MEC_LOCAL_MASK0_LO_BASE_IDX                                                               1
#define regCP_MEC_LOCAL_MASK0_HI                                                                        0x292a
#define regCP_MEC_LOCAL_MASK0_HI_BASE_IDX                                                               1
#define regCP_MEC_LOCAL_APERTURE                                                                        0x292b
#define regCP_MEC_LOCAL_APERTURE_BASE_IDX                                                               1
#define regCP_MEC_LOCAL_INSTR_BASE_LO                                                                   0x292c
#define regCP_MEC_LOCAL_INSTR_BASE_LO_BASE_IDX                                                          1
#define regCP_MEC_LOCAL_INSTR_BASE_HI                                                                   0x292d
#define regCP_MEC_LOCAL_INSTR_BASE_HI_BASE_IDX                                                          1
#define regCP_MEC_LOCAL_INSTR_MASK_LO                                                                   0x292e
#define regCP_MEC_LOCAL_INSTR_MASK_LO_BASE_IDX                                                          1
#define regCP_MEC_LOCAL_INSTR_MASK_HI                                                                   0x292f
#define regCP_MEC_LOCAL_INSTR_MASK_HI_BASE_IDX                                                          1
#define regCP_MEC_LOCAL_INSTR_APERTURE                                                                  0x2930
#define regCP_MEC_LOCAL_INSTR_APERTURE_BASE_IDX                                                         1
#define regCP_MEC_LOCAL_SCRATCH_APERTURE                                                                0x2931
#define regCP_MEC_LOCAL_SCRATCH_APERTURE_BASE_IDX                                                       1
#define regCP_MEC_LOCAL_SCRATCH_BASE_LO                                                                 0x2932
#define regCP_MEC_LOCAL_SCRATCH_BASE_LO_BASE_IDX                                                        1
#define regCP_MEC_LOCAL_SCRATCH_BASE_HI                                                                 0x2933
#define regCP_MEC_LOCAL_SCRATCH_BASE_HI_BASE_IDX                                                        1
#define regCP_MEC_RS64_PERFCOUNT_CNTL                                                                   0x2934
#define regCP_MEC_RS64_PERFCOUNT_CNTL_BASE_IDX                                                          1
#define regCP_MEC_RS64_PENDING_INTERRUPT                                                                0x2935
#define regCP_MEC_RS64_PENDING_INTERRUPT_BASE_IDX                                                       1
#define regCP_MEC_RS64_EXCEPTION_STATUS                                                                 0x2937
#define regCP_MEC_RS64_EXCEPTION_STATUS_BASE_IDX                                                        1
#define regCP_MEC_RS64_PRGRM_CNTR_START_HI                                                              0x2938
#define regCP_MEC_RS64_PRGRM_CNTR_START_HI_BASE_IDX                                                     1
#define regCP_MEC_RS64_INTERRUPT_DATA_16                                                                0x293a
#define regCP_MEC_RS64_INTERRUPT_DATA_16_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_17                                                                0x293b
#define regCP_MEC_RS64_INTERRUPT_DATA_17_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_18                                                                0x293c
#define regCP_MEC_RS64_INTERRUPT_DATA_18_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_19                                                                0x293d
#define regCP_MEC_RS64_INTERRUPT_DATA_19_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_20                                                                0x293e
#define regCP_MEC_RS64_INTERRUPT_DATA_20_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_21                                                                0x293f
#define regCP_MEC_RS64_INTERRUPT_DATA_21_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_22                                                                0x2940
#define regCP_MEC_RS64_INTERRUPT_DATA_22_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_23                                                                0x2941
#define regCP_MEC_RS64_INTERRUPT_DATA_23_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_24                                                                0x2942
#define regCP_MEC_RS64_INTERRUPT_DATA_24_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_25                                                                0x2943
#define regCP_MEC_RS64_INTERRUPT_DATA_25_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_26                                                                0x2944
#define regCP_MEC_RS64_INTERRUPT_DATA_26_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_27                                                                0x2945
#define regCP_MEC_RS64_INTERRUPT_DATA_27_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_28                                                                0x2946
#define regCP_MEC_RS64_INTERRUPT_DATA_28_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_29                                                                0x2947
#define regCP_MEC_RS64_INTERRUPT_DATA_29_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_30                                                                0x2948
#define regCP_MEC_RS64_INTERRUPT_DATA_30_BASE_IDX                                                       1
#define regCP_MEC_RS64_INTERRUPT_DATA_31                                                                0x2949
#define regCP_MEC_RS64_INTERRUPT_DATA_31_BASE_IDX                                                       1
#define regCP_MEC_DC_APERTURE0_BASE                                                                     0x294a
#define regCP_MEC_DC_APERTURE0_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE0_MASK                                                                     0x294b
#define regCP_MEC_DC_APERTURE0_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE0_CNTL                                                                     0x294c
#define regCP_MEC_DC_APERTURE0_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE1_BASE                                                                     0x294d
#define regCP_MEC_DC_APERTURE1_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE1_MASK                                                                     0x294e
#define regCP_MEC_DC_APERTURE1_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE1_CNTL                                                                     0x294f
#define regCP_MEC_DC_APERTURE1_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE2_BASE                                                                     0x2950
#define regCP_MEC_DC_APERTURE2_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE2_MASK                                                                     0x2951
#define regCP_MEC_DC_APERTURE2_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE2_CNTL                                                                     0x2952
#define regCP_MEC_DC_APERTURE2_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE3_BASE                                                                     0x2953
#define regCP_MEC_DC_APERTURE3_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE3_MASK                                                                     0x2954
#define regCP_MEC_DC_APERTURE3_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE3_CNTL                                                                     0x2955
#define regCP_MEC_DC_APERTURE3_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE4_BASE                                                                     0x2956
#define regCP_MEC_DC_APERTURE4_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE4_MASK                                                                     0x2957
#define regCP_MEC_DC_APERTURE4_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE4_CNTL                                                                     0x2958
#define regCP_MEC_DC_APERTURE4_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE5_BASE                                                                     0x2959
#define regCP_MEC_DC_APERTURE5_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE5_MASK                                                                     0x295a
#define regCP_MEC_DC_APERTURE5_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE5_CNTL                                                                     0x295b
#define regCP_MEC_DC_APERTURE5_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE6_BASE                                                                     0x295c
#define regCP_MEC_DC_APERTURE6_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE6_MASK                                                                     0x295d
#define regCP_MEC_DC_APERTURE6_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE6_CNTL                                                                     0x295e
#define regCP_MEC_DC_APERTURE6_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE7_BASE                                                                     0x295f
#define regCP_MEC_DC_APERTURE7_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE7_MASK                                                                     0x2960
#define regCP_MEC_DC_APERTURE7_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE7_CNTL                                                                     0x2961
#define regCP_MEC_DC_APERTURE7_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE8_BASE                                                                     0x2962
#define regCP_MEC_DC_APERTURE8_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE8_MASK                                                                     0x2963
#define regCP_MEC_DC_APERTURE8_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE8_CNTL                                                                     0x2964
#define regCP_MEC_DC_APERTURE8_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE9_BASE                                                                     0x2965
#define regCP_MEC_DC_APERTURE9_BASE_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE9_MASK                                                                     0x2966
#define regCP_MEC_DC_APERTURE9_MASK_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE9_CNTL                                                                     0x2967
#define regCP_MEC_DC_APERTURE9_CNTL_BASE_IDX                                                            1
#define regCP_MEC_DC_APERTURE10_BASE                                                                    0x2968
#define regCP_MEC_DC_APERTURE10_BASE_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE10_MASK                                                                    0x2969
#define regCP_MEC_DC_APERTURE10_MASK_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE10_CNTL                                                                    0x296a
#define regCP_MEC_DC_APERTURE10_CNTL_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE11_BASE                                                                    0x296b
#define regCP_MEC_DC_APERTURE11_BASE_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE11_MASK                                                                    0x296c
#define regCP_MEC_DC_APERTURE11_MASK_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE11_CNTL                                                                    0x296d
#define regCP_MEC_DC_APERTURE11_CNTL_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE12_BASE                                                                    0x296e
#define regCP_MEC_DC_APERTURE12_BASE_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE12_MASK                                                                    0x296f
#define regCP_MEC_DC_APERTURE12_MASK_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE12_CNTL                                                                    0x2970
#define regCP_MEC_DC_APERTURE12_CNTL_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE13_BASE                                                                    0x2971
#define regCP_MEC_DC_APERTURE13_BASE_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE13_MASK                                                                    0x2972
#define regCP_MEC_DC_APERTURE13_MASK_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE13_CNTL                                                                    0x2973
#define regCP_MEC_DC_APERTURE13_CNTL_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE14_BASE                                                                    0x2974
#define regCP_MEC_DC_APERTURE14_BASE_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE14_MASK                                                                    0x2975
#define regCP_MEC_DC_APERTURE14_MASK_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE14_CNTL                                                                    0x2976
#define regCP_MEC_DC_APERTURE14_CNTL_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE15_BASE                                                                    0x2977
#define regCP_MEC_DC_APERTURE15_BASE_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE15_MASK                                                                    0x2978
#define regCP_MEC_DC_APERTURE15_MASK_BASE_IDX                                                           1
#define regCP_MEC_DC_APERTURE15_CNTL                                                                    0x2979
#define regCP_MEC_DC_APERTURE15_CNTL_BASE_IDX                                                           1
#define regCP_CPC_IC_OP_CNTL                                                                            0x297a
#define regCP_CPC_IC_OP_CNTL_BASE_IDX                                                                   1
#define regCP_GFX_RS64_INTERRUPT0                                                                       0x2a01
#define regCP_GFX_RS64_INTERRUPT0_BASE_IDX                                                              1
#define regCP_GFX_RS64_INTR_EN0                                                                         0x2a02
#define regCP_GFX_RS64_INTR_EN0_BASE_IDX                                                                1
#define regCP_GFX_RS64_INTR_EN1                                                                         0x2a03
#define regCP_GFX_RS64_INTR_EN1_BASE_IDX                                                                1
#define regCP_GFX_RS64_DC_BASE_CNTL                                                                     0x2a08
#define regCP_GFX_RS64_DC_BASE_CNTL_BASE_IDX                                                            1
#define regCP_GFX_RS64_DC_OP_CNTL                                                                       0x2a09
#define regCP_GFX_RS64_DC_OP_CNTL_BASE_IDX                                                              1
#define regCP_GFX_RS64_LOCAL_BASE0_LO                                                                   0x2a0a
#define regCP_GFX_RS64_LOCAL_BASE0_LO_BASE_IDX                                                          1
#define regCP_GFX_RS64_LOCAL_BASE0_HI                                                                   0x2a0b
#define regCP_GFX_RS64_LOCAL_BASE0_HI_BASE_IDX                                                          1
#define regCP_GFX_RS64_LOCAL_MASK0_LO                                                                   0x2a0c
#define regCP_GFX_RS64_LOCAL_MASK0_LO_BASE_IDX                                                          1
#define regCP_GFX_RS64_LOCAL_MASK0_HI                                                                   0x2a0d
#define regCP_GFX_RS64_LOCAL_MASK0_HI_BASE_IDX                                                          1
#define regCP_GFX_RS64_LOCAL_APERTURE                                                                   0x2a0e
#define regCP_GFX_RS64_LOCAL_APERTURE_BASE_IDX                                                          1
#define regCP_GFX_RS64_LOCAL_INSTR_BASE_LO                                                              0x2a0f
#define regCP_GFX_RS64_LOCAL_INSTR_BASE_LO_BASE_IDX                                                     1
#define regCP_GFX_RS64_LOCAL_INSTR_BASE_HI                                                              0x2a10
#define regCP_GFX_RS64_LOCAL_INSTR_BASE_HI_BASE_IDX                                                     1
#define regCP_GFX_RS64_LOCAL_INSTR_MASK_LO                                                              0x2a11
#define regCP_GFX_RS64_LOCAL_INSTR_MASK_LO_BASE_IDX                                                     1
#define regCP_GFX_RS64_LOCAL_INSTR_MASK_HI                                                              0x2a12
#define regCP_GFX_RS64_LOCAL_INSTR_MASK_HI_BASE_IDX                                                     1
#define regCP_GFX_RS64_LOCAL_INSTR_APERTURE                                                             0x2a13
#define regCP_GFX_RS64_LOCAL_INSTR_APERTURE_BASE_IDX                                                    1
#define regCP_GFX_RS64_LOCAL_SCRATCH_APERTURE                                                           0x2a14
#define regCP_GFX_RS64_LOCAL_SCRATCH_APERTURE_BASE_IDX                                                  1
#define regCP_GFX_RS64_LOCAL_SCRATCH_BASE_LO                                                            0x2a15
#define regCP_GFX_RS64_LOCAL_SCRATCH_BASE_LO_BASE_IDX                                                   1
#define regCP_GFX_RS64_LOCAL_SCRATCH_BASE_HI                                                            0x2a16
#define regCP_GFX_RS64_LOCAL_SCRATCH_BASE_HI_BASE_IDX                                                   1
#define regCP_PFP_RS64_EXCEPTION_STATUS                                                                 0x2a19
#define regCP_PFP_RS64_EXCEPTION_STATUS_BASE_IDX                                                        1
#define regCP_GFX_RS64_PERFCOUNT_CNTL0                                                                  0x2a1a
#define regCP_GFX_RS64_PERFCOUNT_CNTL0_BASE_IDX                                                         1
#define regCP_GFX_RS64_PERFCOUNT_CNTL1                                                                  0x2a1b
#define regCP_GFX_RS64_PERFCOUNT_CNTL1_BASE_IDX                                                         1
#define regCP_GFX_RS64_MIP_LO0                                                                          0x2a1c
#define regCP_GFX_RS64_MIP_LO0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_MIP_LO1                                                                          0x2a1d
#define regCP_GFX_RS64_MIP_LO1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_MIP_HI0                                                                          0x2a1e
#define regCP_GFX_RS64_MIP_HI0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_MIP_HI1                                                                          0x2a1f
#define regCP_GFX_RS64_MIP_HI1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_MTIMECMP_LO0                                                                     0x2a20
#define regCP_GFX_RS64_MTIMECMP_LO0_BASE_IDX                                                            1
#define regCP_GFX_RS64_MTIMECMP_LO1                                                                     0x2a21
#define regCP_GFX_RS64_MTIMECMP_LO1_BASE_IDX                                                            1
#define regCP_GFX_RS64_MTIMECMP_HI0                                                                     0x2a22
#define regCP_GFX_RS64_MTIMECMP_HI0_BASE_IDX                                                            1
#define regCP_GFX_RS64_MTIMECMP_HI1                                                                     0x2a23
#define regCP_GFX_RS64_MTIMECMP_HI1_BASE_IDX                                                            1
#define regCP_GFX_RS64_GP0_LO0                                                                          0x2a24
#define regCP_GFX_RS64_GP0_LO0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP0_LO1                                                                          0x2a25
#define regCP_GFX_RS64_GP0_LO1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP0_HI0                                                                          0x2a26
#define regCP_GFX_RS64_GP0_HI0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP0_HI1                                                                          0x2a27
#define regCP_GFX_RS64_GP0_HI1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP1_LO0                                                                          0x2a28
#define regCP_GFX_RS64_GP1_LO0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP1_LO1                                                                          0x2a29
#define regCP_GFX_RS64_GP1_LO1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP1_HI0                                                                          0x2a2a
#define regCP_GFX_RS64_GP1_HI0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP1_HI1                                                                          0x2a2b
#define regCP_GFX_RS64_GP1_HI1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP2_LO0                                                                          0x2a2c
#define regCP_GFX_RS64_GP2_LO0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP2_LO1                                                                          0x2a2d
#define regCP_GFX_RS64_GP2_LO1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP2_HI0                                                                          0x2a2e
#define regCP_GFX_RS64_GP2_HI0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP2_HI1                                                                          0x2a2f
#define regCP_GFX_RS64_GP2_HI1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP3_LO0                                                                          0x2a30
#define regCP_GFX_RS64_GP3_LO0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP3_LO1                                                                          0x2a31
#define regCP_GFX_RS64_GP3_LO1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP3_HI0                                                                          0x2a32
#define regCP_GFX_RS64_GP3_HI0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP3_HI1                                                                          0x2a33
#define regCP_GFX_RS64_GP3_HI1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP4_LO0                                                                          0x2a34
#define regCP_GFX_RS64_GP4_LO0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP4_LO1                                                                          0x2a35
#define regCP_GFX_RS64_GP4_LO1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP4_HI0                                                                          0x2a36
#define regCP_GFX_RS64_GP4_HI0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP4_HI1                                                                          0x2a37
#define regCP_GFX_RS64_GP4_HI1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP5_LO0                                                                          0x2a38
#define regCP_GFX_RS64_GP5_LO0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP5_LO1                                                                          0x2a39
#define regCP_GFX_RS64_GP5_LO1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP5_HI0                                                                          0x2a3a
#define regCP_GFX_RS64_GP5_HI0_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP5_HI1                                                                          0x2a3b
#define regCP_GFX_RS64_GP5_HI1_BASE_IDX                                                                 1
#define regCP_GFX_RS64_GP6_LO                                                                           0x2a3c
#define regCP_GFX_RS64_GP6_LO_BASE_IDX                                                                  1
#define regCP_GFX_RS64_GP6_HI                                                                           0x2a3d
#define regCP_GFX_RS64_GP6_HI_BASE_IDX                                                                  1
#define regCP_GFX_RS64_GP7_LO                                                                           0x2a3e
#define regCP_GFX_RS64_GP7_LO_BASE_IDX                                                                  1
#define regCP_GFX_RS64_GP7_HI                                                                           0x2a3f
#define regCP_GFX_RS64_GP7_HI_BASE_IDX                                                                  1
#define regCP_GFX_RS64_GP8_LO                                                                           0x2a40
#define regCP_GFX_RS64_GP8_LO_BASE_IDX                                                                  1
#define regCP_GFX_RS64_GP8_HI                                                                           0x2a41
#define regCP_GFX_RS64_GP8_HI_BASE_IDX                                                                  1
#define regCP_GFX_RS64_GP9_LO                                                                           0x2a42
#define regCP_GFX_RS64_GP9_LO_BASE_IDX                                                                  1
#define regCP_GFX_RS64_GP9_HI                                                                           0x2a43
#define regCP_GFX_RS64_GP9_HI_BASE_IDX                                                                  1
#define regCP_GFX_RS64_INSTR_PNTR0                                                                      0x2a44
#define regCP_GFX_RS64_INSTR_PNTR0_BASE_IDX                                                             1
#define regCP_GFX_RS64_INSTR_PNTR1                                                                      0x2a45
#define regCP_GFX_RS64_INSTR_PNTR1_BASE_IDX                                                             1
#define regCP_GFX_RS64_PENDING_INTERRUPT0                                                               0x2a46
#define regCP_GFX_RS64_PENDING_INTERRUPT0_BASE_IDX                                                      1
#define regCP_GFX_RS64_PENDING_INTERRUPT1                                                               0x2a47
#define regCP_GFX_RS64_PENDING_INTERRUPT1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE0_BASE0                                                               0x2a49
#define regCP_GFX_RS64_DC_APERTURE0_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE0_MASK0                                                               0x2a4a
#define regCP_GFX_RS64_DC_APERTURE0_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE0_CNTL0                                                               0x2a4b
#define regCP_GFX_RS64_DC_APERTURE0_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE1_BASE0                                                               0x2a4c
#define regCP_GFX_RS64_DC_APERTURE1_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE1_MASK0                                                               0x2a4d
#define regCP_GFX_RS64_DC_APERTURE1_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE1_CNTL0                                                               0x2a4e
#define regCP_GFX_RS64_DC_APERTURE1_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE2_BASE0                                                               0x2a4f
#define regCP_GFX_RS64_DC_APERTURE2_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE2_MASK0                                                               0x2a50
#define regCP_GFX_RS64_DC_APERTURE2_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE2_CNTL0                                                               0x2a51
#define regCP_GFX_RS64_DC_APERTURE2_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE3_BASE0                                                               0x2a52
#define regCP_GFX_RS64_DC_APERTURE3_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE3_MASK0                                                               0x2a53
#define regCP_GFX_RS64_DC_APERTURE3_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE3_CNTL0                                                               0x2a54
#define regCP_GFX_RS64_DC_APERTURE3_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE4_BASE0                                                               0x2a55
#define regCP_GFX_RS64_DC_APERTURE4_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE4_MASK0                                                               0x2a56
#define regCP_GFX_RS64_DC_APERTURE4_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE4_CNTL0                                                               0x2a57
#define regCP_GFX_RS64_DC_APERTURE4_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE5_BASE0                                                               0x2a58
#define regCP_GFX_RS64_DC_APERTURE5_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE5_MASK0                                                               0x2a59
#define regCP_GFX_RS64_DC_APERTURE5_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE5_CNTL0                                                               0x2a5a
#define regCP_GFX_RS64_DC_APERTURE5_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE6_BASE0                                                               0x2a5b
#define regCP_GFX_RS64_DC_APERTURE6_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE6_MASK0                                                               0x2a5c
#define regCP_GFX_RS64_DC_APERTURE6_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE6_CNTL0                                                               0x2a5d
#define regCP_GFX_RS64_DC_APERTURE6_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE7_BASE0                                                               0x2a5e
#define regCP_GFX_RS64_DC_APERTURE7_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE7_MASK0                                                               0x2a5f
#define regCP_GFX_RS64_DC_APERTURE7_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE7_CNTL0                                                               0x2a60
#define regCP_GFX_RS64_DC_APERTURE7_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE8_BASE0                                                               0x2a61
#define regCP_GFX_RS64_DC_APERTURE8_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE8_MASK0                                                               0x2a62
#define regCP_GFX_RS64_DC_APERTURE8_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE8_CNTL0                                                               0x2a63
#define regCP_GFX_RS64_DC_APERTURE8_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE9_BASE0                                                               0x2a64
#define regCP_GFX_RS64_DC_APERTURE9_BASE0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE9_MASK0                                                               0x2a65
#define regCP_GFX_RS64_DC_APERTURE9_MASK0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE9_CNTL0                                                               0x2a66
#define regCP_GFX_RS64_DC_APERTURE9_CNTL0_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE10_BASE0                                                              0x2a67
#define regCP_GFX_RS64_DC_APERTURE10_BASE0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE10_MASK0                                                              0x2a68
#define regCP_GFX_RS64_DC_APERTURE10_MASK0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE10_CNTL0                                                              0x2a69
#define regCP_GFX_RS64_DC_APERTURE10_CNTL0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE11_BASE0                                                              0x2a6a
#define regCP_GFX_RS64_DC_APERTURE11_BASE0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE11_MASK0                                                              0x2a6b
#define regCP_GFX_RS64_DC_APERTURE11_MASK0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE11_CNTL0                                                              0x2a6c
#define regCP_GFX_RS64_DC_APERTURE11_CNTL0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE12_BASE0                                                              0x2a6d
#define regCP_GFX_RS64_DC_APERTURE12_BASE0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE12_MASK0                                                              0x2a6e
#define regCP_GFX_RS64_DC_APERTURE12_MASK0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE12_CNTL0                                                              0x2a6f
#define regCP_GFX_RS64_DC_APERTURE12_CNTL0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE13_BASE0                                                              0x2a70
#define regCP_GFX_RS64_DC_APERTURE13_BASE0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE13_MASK0                                                              0x2a71
#define regCP_GFX_RS64_DC_APERTURE13_MASK0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE13_CNTL0                                                              0x2a72
#define regCP_GFX_RS64_DC_APERTURE13_CNTL0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE14_BASE0                                                              0x2a73
#define regCP_GFX_RS64_DC_APERTURE14_BASE0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE14_MASK0                                                              0x2a74
#define regCP_GFX_RS64_DC_APERTURE14_MASK0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE14_CNTL0                                                              0x2a75
#define regCP_GFX_RS64_DC_APERTURE14_CNTL0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE15_BASE0                                                              0x2a76
#define regCP_GFX_RS64_DC_APERTURE15_BASE0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE15_MASK0                                                              0x2a77
#define regCP_GFX_RS64_DC_APERTURE15_MASK0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE15_CNTL0                                                              0x2a78
#define regCP_GFX_RS64_DC_APERTURE15_CNTL0_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE0_BASE1                                                               0x2a79
#define regCP_GFX_RS64_DC_APERTURE0_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE0_MASK1                                                               0x2a7a
#define regCP_GFX_RS64_DC_APERTURE0_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE0_CNTL1                                                               0x2a7b
#define regCP_GFX_RS64_DC_APERTURE0_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE1_BASE1                                                               0x2a7c
#define regCP_GFX_RS64_DC_APERTURE1_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE1_MASK1                                                               0x2a7d
#define regCP_GFX_RS64_DC_APERTURE1_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE1_CNTL1                                                               0x2a7e
#define regCP_GFX_RS64_DC_APERTURE1_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE2_BASE1                                                               0x2a7f
#define regCP_GFX_RS64_DC_APERTURE2_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE2_MASK1                                                               0x2a80
#define regCP_GFX_RS64_DC_APERTURE2_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE2_CNTL1                                                               0x2a81
#define regCP_GFX_RS64_DC_APERTURE2_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE3_BASE1                                                               0x2a82
#define regCP_GFX_RS64_DC_APERTURE3_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE3_MASK1                                                               0x2a83
#define regCP_GFX_RS64_DC_APERTURE3_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE3_CNTL1                                                               0x2a84
#define regCP_GFX_RS64_DC_APERTURE3_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE4_BASE1                                                               0x2a85
#define regCP_GFX_RS64_DC_APERTURE4_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE4_MASK1                                                               0x2a86
#define regCP_GFX_RS64_DC_APERTURE4_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE4_CNTL1                                                               0x2a87
#define regCP_GFX_RS64_DC_APERTURE4_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE5_BASE1                                                               0x2a88
#define regCP_GFX_RS64_DC_APERTURE5_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE5_MASK1                                                               0x2a89
#define regCP_GFX_RS64_DC_APERTURE5_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE5_CNTL1                                                               0x2a8a
#define regCP_GFX_RS64_DC_APERTURE5_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE6_BASE1                                                               0x2a8b
#define regCP_GFX_RS64_DC_APERTURE6_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE6_MASK1                                                               0x2a8c
#define regCP_GFX_RS64_DC_APERTURE6_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE6_CNTL1                                                               0x2a8d
#define regCP_GFX_RS64_DC_APERTURE6_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE7_BASE1                                                               0x2a8e
#define regCP_GFX_RS64_DC_APERTURE7_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE7_MASK1                                                               0x2a8f
#define regCP_GFX_RS64_DC_APERTURE7_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE7_CNTL1                                                               0x2a90
#define regCP_GFX_RS64_DC_APERTURE7_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE8_BASE1                                                               0x2a91
#define regCP_GFX_RS64_DC_APERTURE8_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE8_MASK1                                                               0x2a92
#define regCP_GFX_RS64_DC_APERTURE8_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE8_CNTL1                                                               0x2a93
#define regCP_GFX_RS64_DC_APERTURE8_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE9_BASE1                                                               0x2a94
#define regCP_GFX_RS64_DC_APERTURE9_BASE1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE9_MASK1                                                               0x2a95
#define regCP_GFX_RS64_DC_APERTURE9_MASK1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE9_CNTL1                                                               0x2a96
#define regCP_GFX_RS64_DC_APERTURE9_CNTL1_BASE_IDX                                                      1
#define regCP_GFX_RS64_DC_APERTURE10_BASE1                                                              0x2a97
#define regCP_GFX_RS64_DC_APERTURE10_BASE1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE10_MASK1                                                              0x2a98
#define regCP_GFX_RS64_DC_APERTURE10_MASK1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE10_CNTL1                                                              0x2a99
#define regCP_GFX_RS64_DC_APERTURE10_CNTL1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE11_BASE1                                                              0x2a9a
#define regCP_GFX_RS64_DC_APERTURE11_BASE1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE11_MASK1                                                              0x2a9b
#define regCP_GFX_RS64_DC_APERTURE11_MASK1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE11_CNTL1                                                              0x2a9c
#define regCP_GFX_RS64_DC_APERTURE11_CNTL1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE12_BASE1                                                              0x2a9d
#define regCP_GFX_RS64_DC_APERTURE12_BASE1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE12_MASK1                                                              0x2a9e
#define regCP_GFX_RS64_DC_APERTURE12_MASK1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE12_CNTL1                                                              0x2a9f
#define regCP_GFX_RS64_DC_APERTURE12_CNTL1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE13_BASE1                                                              0x2aa0
#define regCP_GFX_RS64_DC_APERTURE13_BASE1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE13_MASK1                                                              0x2aa1
#define regCP_GFX_RS64_DC_APERTURE13_MASK1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE13_CNTL1                                                              0x2aa2
#define regCP_GFX_RS64_DC_APERTURE13_CNTL1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE14_BASE1                                                              0x2aa3
#define regCP_GFX_RS64_DC_APERTURE14_BASE1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE14_MASK1                                                              0x2aa4
#define regCP_GFX_RS64_DC_APERTURE14_MASK1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE14_CNTL1                                                              0x2aa5
#define regCP_GFX_RS64_DC_APERTURE14_CNTL1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE15_BASE1                                                              0x2aa6
#define regCP_GFX_RS64_DC_APERTURE15_BASE1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE15_MASK1                                                              0x2aa7
#define regCP_GFX_RS64_DC_APERTURE15_MASK1_BASE_IDX                                                     1
#define regCP_GFX_RS64_DC_APERTURE15_CNTL1                                                              0x2aa8
#define regCP_GFX_RS64_DC_APERTURE15_CNTL1_BASE_IDX                                                     1
#define regCP_ME_RS64_EXCEPTION_STATUS                                                                  0x2aaa
#define regCP_ME_RS64_EXCEPTION_STATUS_BASE_IDX                                                         1
#define regCP_GFX_RS64_INTERRUPT1                                                                       0x2aac
#define regCP_GFX_RS64_INTERRUPT1_BASE_IDX                                                              1


// addressBlock: gc_gfx_cpwd_cpwd_chdec
// base address: 0x33600
#define regCH_ARB_CTRL                                                                                  0x2d80
#define regCH_ARB_CTRL_BASE_IDX                                                                         1
#define regCH_DRAM_BURST_MASK                                                                           0x2d82
#define regCH_DRAM_BURST_MASK_BASE_IDX                                                                  1
#define regCH_ARB_STATUS                                                                                0x2d83
#define regCH_ARB_STATUS_BASE_IDX                                                                       1
#define regCH_DRAM_BURST_CTRL                                                                           0x2d84
#define regCH_DRAM_BURST_CTRL_BASE_IDX                                                                  1
#define regCHA_CHC_CREDITS                                                                              0x2d88
#define regCHA_CHC_CREDITS_BASE_IDX                                                                     1
#define regCHA_CLIENT_FREE_DELAY                                                                        0x2d89
#define regCHA_CLIENT_FREE_DELAY_BASE_IDX                                                               1
#define regCHA_COMPRESSION_MODE                                                                         0x2d8a
#define regCHA_COMPRESSION_MODE_BASE_IDX                                                                1
#define regCHA_COMPRESSOR_OVERRIDE                                                                      0x2d8b
#define regCHA_COMPRESSOR_OVERRIDE_BASE_IDX                                                             1
#define regCHI_CHR_REP_FGCG_OVERRIDE                                                                    0x2d8c
#define regCHI_CHR_REP_FGCG_OVERRIDE_BASE_IDX                                                           1
#define regCHC_CTRL                                                                                     0x2dc0
#define regCHC_CTRL_BASE_IDX                                                                            1
#define regCHC_STATUS                                                                                   0x2dc1
#define regCHC_STATUS_BASE_IDX                                                                          1
#define regCHC_CTRL2                                                                                    0x2dc2
#define regCHC_CTRL2_BASE_IDX                                                                           1
#define regCHC_STATUS2                                                                                  0x2dc3
#define regCHC_STATUS2_BASE_IDX                                                                         1


// addressBlock: gc_gfx_cpwd_cpwd_gl2dec
// base address: 0x33800
#define regGL2C_CTRL                                                                                    0x2e00
#define regGL2C_CTRL_BASE_IDX                                                                           1
#define regGL2C_CTRL2                                                                                   0x2e01
#define regGL2C_CTRL2_BASE_IDX                                                                          1
#define regGL2C_STATUS                                                                                  0x2e02
#define regGL2C_STATUS_BASE_IDX                                                                         1
#define regGL2C_ADDR_MATCH_MASK                                                                         0x2e03
#define regGL2C_ADDR_MATCH_MASK_BASE_IDX                                                                1
#define regGL2C_ADDR_MATCH_SIZE                                                                         0x2e04
#define regGL2C_ADDR_MATCH_SIZE_BASE_IDX                                                                1
#define regGL2C_WBINVL2                                                                                 0x2e05
#define regGL2C_WBINVL2_BASE_IDX                                                                        1
#define regGL2C_SOFT_RESET                                                                              0x2e06
#define regGL2C_SOFT_RESET_BASE_IDX                                                                     1
#define regGL2C_CTRL3                                                                                   0x2e0c
#define regGL2C_CTRL3_BASE_IDX                                                                          1
#define regGL2C_EA_CREDITS_CTRL                                                                         0x2e14
#define regGL2C_EA_CREDITS_CTRL_BASE_IDX                                                                1
#define regGL2C_CTRL4                                                                                   0x2e17
#define regGL2C_CTRL4_BASE_IDX                                                                          1
#define regGL2C_DISCARD_STALL_CTRL                                                                      0x2e18
#define regGL2C_DISCARD_STALL_CTRL_BASE_IDX                                                             1
#define regGL2C_CTRL5                                                                                   0x2e19
#define regGL2C_CTRL5_BASE_IDX                                                                          1
#define regGL2A_ADDR_MATCH_CTRL                                                                         0x2e20
#define regGL2A_ADDR_MATCH_CTRL_BASE_IDX                                                                1
#define regGL2A_ADDR_MATCH_MASK                                                                         0x2e21
#define regGL2A_ADDR_MATCH_MASK_BASE_IDX                                                                1
#define regGL2A_ADDR_MATCH_SIZE                                                                         0x2e22
#define regGL2A_ADDR_MATCH_SIZE_BASE_IDX                                                                1
#define regGL2A_CTRL                                                                                    0x2e24
#define regGL2A_CTRL_BASE_IDX                                                                           1
#define regGL2A_CTRL2                                                                                   0x2e25
#define regGL2A_CTRL2_BASE_IDX                                                                          1
#define regGL2A_CHANNEL_HASH_CTRL                                                                       0x2e26
#define regGL2A_CHANNEL_HASH_CTRL_BASE_IDX                                                              1
#define regGL2A_DISABLE                                                                                 0x2e29
#define regGL2A_DISABLE_BASE_IDX                                                                        1
#define regGL2A_RESP_THROTTLE_CTRL                                                                      0x2e2a
#define regGL2A_RESP_THROTTLE_CTRL_BASE_IDX                                                             1


// addressBlock: gc_gfx_cpwd_cpwd_perfddec
// base address: 0x34000
#define regCPG_PERFCOUNTER1_LO                                                                          0x3000
#define regCPG_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regCPG_PERFCOUNTER1_HI                                                                          0x3001
#define regCPG_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regCPG_PERFCOUNTER0_LO                                                                          0x3002
#define regCPG_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regCPG_PERFCOUNTER0_HI                                                                          0x3003
#define regCPG_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regCPC_PERFCOUNTER1_LO                                                                          0x3004
#define regCPC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regCPC_PERFCOUNTER1_HI                                                                          0x3005
#define regCPC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regCPC_PERFCOUNTER0_LO                                                                          0x3006
#define regCPC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regCPC_PERFCOUNTER0_HI                                                                          0x3007
#define regCPC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regCPF_PERFCOUNTER1_LO                                                                          0x3008
#define regCPF_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regCPF_PERFCOUNTER1_HI                                                                          0x3009
#define regCPF_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regCPF_PERFCOUNTER0_LO                                                                          0x300a
#define regCPF_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regCPF_PERFCOUNTER0_HI                                                                          0x300b
#define regCPF_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regCPF_LATENCY_STATS_DATA                                                                       0x300c
#define regCPF_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define regCPG_LATENCY_STATS_DATA                                                                       0x300d
#define regCPG_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define regCPC_LATENCY_STATS_DATA                                                                       0x300e
#define regCPC_LATENCY_STATS_DATA_BASE_IDX                                                              1
#define regGRBM_PERFCOUNTER0_LO                                                                         0x3040
#define regGRBM_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define regGRBM_PERFCOUNTER0_HI                                                                         0x3041
#define regGRBM_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define regGRBM_PERFCOUNTER1_LO                                                                         0x3043
#define regGRBM_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define regGRBM_PERFCOUNTER1_HI                                                                         0x3044
#define regGRBM_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define regGE1_PERFCOUNTER0_LO                                                                          0x30a4
#define regGE1_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regGE1_PERFCOUNTER0_HI                                                                          0x30a5
#define regGE1_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regGE1_PERFCOUNTER1_LO                                                                          0x30a6
#define regGE1_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regGE1_PERFCOUNTER1_HI                                                                          0x30a7
#define regGE1_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regGE1_PERFCOUNTER2_LO                                                                          0x30a8
#define regGE1_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regGE1_PERFCOUNTER2_HI                                                                          0x30a9
#define regGE1_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regGE1_PERFCOUNTER3_LO                                                                          0x30aa
#define regGE1_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regGE1_PERFCOUNTER3_HI                                                                          0x30ab
#define regGE1_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define regGE2_DIST_PERFCOUNTER0_LO                                                                     0x30ac
#define regGE2_DIST_PERFCOUNTER0_LO_BASE_IDX                                                            1
#define regGE2_DIST_PERFCOUNTER0_HI                                                                     0x30ad
#define regGE2_DIST_PERFCOUNTER0_HI_BASE_IDX                                                            1
#define regGE2_DIST_PERFCOUNTER1_LO                                                                     0x30ae
#define regGE2_DIST_PERFCOUNTER1_LO_BASE_IDX                                                            1
#define regGE2_DIST_PERFCOUNTER1_HI                                                                     0x30af
#define regGE2_DIST_PERFCOUNTER1_HI_BASE_IDX                                                            1
#define regGE2_DIST_PERFCOUNTER2_LO                                                                     0x30b0
#define regGE2_DIST_PERFCOUNTER2_LO_BASE_IDX                                                            1
#define regGE2_DIST_PERFCOUNTER2_HI                                                                     0x30b1
#define regGE2_DIST_PERFCOUNTER2_HI_BASE_IDX                                                            1
#define regGE2_DIST_PERFCOUNTER3_LO                                                                     0x30b2
#define regGE2_DIST_PERFCOUNTER3_LO_BASE_IDX                                                            1
#define regGE2_DIST_PERFCOUNTER3_HI                                                                     0x30b3
#define regGE2_DIST_PERFCOUNTER3_HI_BASE_IDX                                                            1
#define regGC_EA_CPWD_PERFCOUNTER0_LO                                                                   0x3260
#define regGC_EA_CPWD_PERFCOUNTER0_LO_BASE_IDX                                                          1
#define regGC_EA_CPWD_PERFCOUNTER0_HI                                                                   0x3261
#define regGC_EA_CPWD_PERFCOUNTER0_HI_BASE_IDX                                                          1
#define regGC_EA_CPWD_PERFCOUNTER1_LO                                                                   0x3262
#define regGC_EA_CPWD_PERFCOUNTER1_LO_BASE_IDX                                                          1
#define regGC_EA_CPWD_PERFCOUNTER1_HI                                                                   0x3263
#define regGC_EA_CPWD_PERFCOUNTER1_HI_BASE_IDX                                                          1
#define regGC_EA_SE_PERFCOUNTER0_LO                                                                     0x3270
#define regGC_EA_SE_PERFCOUNTER0_LO_BASE_IDX                                                            1
#define regGC_EA_SE_PERFCOUNTER0_HI                                                                     0x3271
#define regGC_EA_SE_PERFCOUNTER0_HI_BASE_IDX                                                            1
#define regGC_EA_SE_PERFCOUNTER1_LO                                                                     0x3272
#define regGC_EA_SE_PERFCOUNTER1_LO_BASE_IDX                                                            1
#define regGC_EA_SE_PERFCOUNTER1_HI                                                                     0x3273
#define regGC_EA_SE_PERFCOUNTER1_HI_BASE_IDX                                                            1
#define regGL2C_PERFCOUNTER0_LO                                                                         0x3380
#define regGL2C_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define regGL2C_PERFCOUNTER0_HI                                                                         0x3381
#define regGL2C_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define regGL2C_PERFCOUNTER1_LO                                                                         0x3382
#define regGL2C_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define regGL2C_PERFCOUNTER1_HI                                                                         0x3383
#define regGL2C_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define regGL2C_PERFCOUNTER2_LO                                                                         0x3384
#define regGL2C_PERFCOUNTER2_LO_BASE_IDX                                                                1
#define regGL2C_PERFCOUNTER2_HI                                                                         0x3385
#define regGL2C_PERFCOUNTER2_HI_BASE_IDX                                                                1
#define regGL2C_PERFCOUNTER3_LO                                                                         0x3386
#define regGL2C_PERFCOUNTER3_LO_BASE_IDX                                                                1
#define regGL2C_PERFCOUNTER3_HI                                                                         0x3387
#define regGL2C_PERFCOUNTER3_HI_BASE_IDX                                                                1
#define regGL2A_PERFCOUNTER0_LO                                                                         0x3390
#define regGL2A_PERFCOUNTER0_LO_BASE_IDX                                                                1
#define regGL2A_PERFCOUNTER0_HI                                                                         0x3391
#define regGL2A_PERFCOUNTER0_HI_BASE_IDX                                                                1
#define regGL2A_PERFCOUNTER1_LO                                                                         0x3392
#define regGL2A_PERFCOUNTER1_LO_BASE_IDX                                                                1
#define regGL2A_PERFCOUNTER1_HI                                                                         0x3393
#define regGL2A_PERFCOUNTER1_HI_BASE_IDX                                                                1
#define regGL2A_PERFCOUNTER2_LO                                                                         0x3394
#define regGL2A_PERFCOUNTER2_LO_BASE_IDX                                                                1
#define regGL2A_PERFCOUNTER2_HI                                                                         0x3395
#define regGL2A_PERFCOUNTER2_HI_BASE_IDX                                                                1
#define regGL2A_PERFCOUNTER3_LO                                                                         0x3396
#define regGL2A_PERFCOUNTER3_LO_BASE_IDX                                                                1
#define regGL2A_PERFCOUNTER3_HI                                                                         0x3397
#define regGL2A_PERFCOUNTER3_HI_BASE_IDX                                                                1
#define regCHC_PERFCOUNTER0_LO                                                                          0x33c0
#define regCHC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regCHC_PERFCOUNTER0_HI                                                                          0x33c1
#define regCHC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regCHC_PERFCOUNTER1_LO                                                                          0x33c2
#define regCHC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regCHC_PERFCOUNTER1_HI                                                                          0x33c3
#define regCHC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regCHC_PERFCOUNTER2_LO                                                                          0x33c4
#define regCHC_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regCHC_PERFCOUNTER2_HI                                                                          0x33c5
#define regCHC_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regCHC_PERFCOUNTER3_LO                                                                          0x33c6
#define regCHC_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regCHC_PERFCOUNTER3_HI                                                                          0x33c7
#define regCHC_PERFCOUNTER3_HI_BASE_IDX                                                                 1
#define regRLC_PERFCOUNTER0_LO                                                                          0x3480
#define regRLC_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regRLC_PERFCOUNTER0_HI                                                                          0x3481
#define regRLC_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regRLC_PERFCOUNTER1_LO                                                                          0x3482
#define regRLC_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regRLC_PERFCOUNTER1_HI                                                                          0x3483
#define regRLC_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regGCR_PERFCOUNTER0_LO                                                                          0x3520
#define regGCR_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regGCR_PERFCOUNTER0_HI                                                                          0x3521
#define regGCR_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regGCR_PERFCOUNTER1_LO                                                                          0x3522
#define regGCR_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regGCR_PERFCOUNTER1_HI                                                                          0x3523
#define regGCR_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regCHA_PERFCOUNTER0_LO                                                                          0x3600
#define regCHA_PERFCOUNTER0_LO_BASE_IDX                                                                 1
#define regCHA_PERFCOUNTER0_HI                                                                          0x3601
#define regCHA_PERFCOUNTER0_HI_BASE_IDX                                                                 1
#define regCHA_PERFCOUNTER1_LO                                                                          0x3602
#define regCHA_PERFCOUNTER1_LO_BASE_IDX                                                                 1
#define regCHA_PERFCOUNTER1_HI                                                                          0x3603
#define regCHA_PERFCOUNTER1_HI_BASE_IDX                                                                 1
#define regCHA_PERFCOUNTER2_LO                                                                          0x3604
#define regCHA_PERFCOUNTER2_LO_BASE_IDX                                                                 1
#define regCHA_PERFCOUNTER2_HI                                                                          0x3605
#define regCHA_PERFCOUNTER2_HI_BASE_IDX                                                                 1
#define regCHA_PERFCOUNTER3_LO                                                                          0x3606
#define regCHA_PERFCOUNTER3_LO_BASE_IDX                                                                 1
#define regCHA_PERFCOUNTER3_HI                                                                          0x3607
#define regCHA_PERFCOUNTER3_HI_BASE_IDX                                                                 1


// addressBlock: gc_gfx_cpwd_cpwd_perfsdec
// base address: 0x36000
#define regCPG_PERFCOUNTER1_SELECT                                                                      0x3800
#define regCPG_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regCPG_PERFCOUNTER0_SELECT1                                                                     0x3801
#define regCPG_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regCPG_PERFCOUNTER0_SELECT                                                                      0x3802
#define regCPG_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regCPC_PERFCOUNTER1_SELECT                                                                      0x3803
#define regCPC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regCPC_PERFCOUNTER0_SELECT1                                                                     0x3804
#define regCPC_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regCPF_PERFCOUNTER1_SELECT                                                                      0x3805
#define regCPF_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regCPF_PERFCOUNTER0_SELECT1                                                                     0x3806
#define regCPF_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regCPF_PERFCOUNTER0_SELECT                                                                      0x3807
#define regCPF_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regCP_CP_PERFMON_CNTL                                                                           0x3808
#define regCP_CP_PERFMON_CNTL_BASE_IDX                                                                  1
#define regCPC_PERFCOUNTER0_SELECT                                                                      0x3809
#define regCPC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regCPF_TC_PERF_COUNTER_WINDOW_SELECT                                                            0x380a
#define regCPF_TC_PERF_COUNTER_WINDOW_SELECT_BASE_IDX                                                   1
#define regCPG_TC_PERF_COUNTER_WINDOW_SELECT                                                            0x380b
#define regCPG_TC_PERF_COUNTER_WINDOW_SELECT_BASE_IDX                                                   1
#define regCPF_LATENCY_STATS_SELECT                                                                     0x380c
#define regCPF_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define regCPG_LATENCY_STATS_SELECT                                                                     0x380d
#define regCPG_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define regCPC_LATENCY_STATS_SELECT                                                                     0x380e
#define regCPC_LATENCY_STATS_SELECT_BASE_IDX                                                            1
#define regCPC_TC_PERF_COUNTER_WINDOW_SELECT                                                            0x380f
#define regCPC_TC_PERF_COUNTER_WINDOW_SELECT_BASE_IDX                                                   1
#define regCP_DRAW_OBJECT                                                                               0x3810
#define regCP_DRAW_OBJECT_BASE_IDX                                                                      1
#define regCP_DRAW_OBJECT_COUNTER                                                                       0x3811
#define regCP_DRAW_OBJECT_COUNTER_BASE_IDX                                                              1
#define regCP_DRAW_WINDOW_MASK_HI                                                                       0x3812
#define regCP_DRAW_WINDOW_MASK_HI_BASE_IDX                                                              1
#define regCP_DRAW_WINDOW_HI                                                                            0x3813
#define regCP_DRAW_WINDOW_HI_BASE_IDX                                                                   1
#define regCP_DRAW_WINDOW_LO                                                                            0x3814
#define regCP_DRAW_WINDOW_LO_BASE_IDX                                                                   1
#define regCP_DRAW_WINDOW_CNTL                                                                          0x3815
#define regCP_DRAW_WINDOW_CNTL_BASE_IDX                                                                 1
#define regGRBM_PERFCOUNTER0_SELECT                                                                     0x3840
#define regGRBM_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define regGRBM_PERFCOUNTER1_SELECT                                                                     0x3841
#define regGRBM_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define regGRBM_PERFCOUNTER0_SELECT_HI                                                                  0x384d
#define regGRBM_PERFCOUNTER0_SELECT_HI_BASE_IDX                                                         1
#define regGRBM_PERFCOUNTER1_SELECT_HI                                                                  0x384e
#define regGRBM_PERFCOUNTER1_SELECT_HI_BASE_IDX                                                         1
#define regGE1_PERFCOUNTER0_SELECT                                                                      0x38a4
#define regGE1_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regGE1_PERFCOUNTER0_SELECT1                                                                     0x38a5
#define regGE1_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regGE1_PERFCOUNTER1_SELECT                                                                      0x38a6
#define regGE1_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regGE1_PERFCOUNTER1_SELECT1                                                                     0x38a7
#define regGE1_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define regGE1_PERFCOUNTER2_SELECT                                                                      0x38a8
#define regGE1_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regGE1_PERFCOUNTER2_SELECT1                                                                     0x38a9
#define regGE1_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define regGE1_PERFCOUNTER3_SELECT                                                                      0x38aa
#define regGE1_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regGE1_PERFCOUNTER3_SELECT1                                                                     0x38ab
#define regGE1_PERFCOUNTER3_SELECT1_BASE_IDX                                                            1
#define regGE2_DIST_PERFCOUNTER0_SELECT                                                                 0x38ac
#define regGE2_DIST_PERFCOUNTER0_SELECT_BASE_IDX                                                        1
#define regGE2_DIST_PERFCOUNTER0_SELECT1                                                                0x38ad
#define regGE2_DIST_PERFCOUNTER0_SELECT1_BASE_IDX                                                       1
#define regGE2_DIST_PERFCOUNTER1_SELECT                                                                 0x38ae
#define regGE2_DIST_PERFCOUNTER1_SELECT_BASE_IDX                                                        1
#define regGE2_DIST_PERFCOUNTER1_SELECT1                                                                0x38af
#define regGE2_DIST_PERFCOUNTER1_SELECT1_BASE_IDX                                                       1
#define regGE2_DIST_PERFCOUNTER2_SELECT                                                                 0x38b0
#define regGE2_DIST_PERFCOUNTER2_SELECT_BASE_IDX                                                        1
#define regGE2_DIST_PERFCOUNTER2_SELECT1                                                                0x38b1
#define regGE2_DIST_PERFCOUNTER2_SELECT1_BASE_IDX                                                       1
#define regGE2_DIST_PERFCOUNTER3_SELECT                                                                 0x38b2
#define regGE2_DIST_PERFCOUNTER3_SELECT_BASE_IDX                                                        1
#define regGE2_DIST_PERFCOUNTER3_SELECT1                                                                0x38b3
#define regGE2_DIST_PERFCOUNTER3_SELECT1_BASE_IDX                                                       1
#define regGC_EA_CPWD_PERFCOUNTER0_SELECT                                                               0x3a00
#define regGC_EA_CPWD_PERFCOUNTER0_SELECT_BASE_IDX                                                      1
#define regGC_EA_CPWD_PERFCOUNTER0_SELECT1                                                              0x3a01
#define regGC_EA_CPWD_PERFCOUNTER0_SELECT1_BASE_IDX                                                     1
#define regGC_EA_CPWD_PERFCOUNTER1_SELECT                                                               0x3a02
#define regGC_EA_CPWD_PERFCOUNTER1_SELECT_BASE_IDX                                                      1
#define regGC_EA_SE_PERFCOUNTER0_SELECT                                                                 0x3a20
#define regGC_EA_SE_PERFCOUNTER0_SELECT_BASE_IDX                                                        1
#define regGC_EA_SE_PERFCOUNTER0_SELECT1                                                                0x3a21
#define regGC_EA_SE_PERFCOUNTER0_SELECT1_BASE_IDX                                                       1
#define regGC_EA_SE_PERFCOUNTER1_SELECT                                                                 0x3a22
#define regGC_EA_SE_PERFCOUNTER1_SELECT_BASE_IDX                                                        1
#define regGL2C_PERFCOUNTER0_SELECT                                                                     0x3b80
#define regGL2C_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define regGL2C_PERFCOUNTER0_SELECT1                                                                    0x3b81
#define regGL2C_PERFCOUNTER0_SELECT1_BASE_IDX                                                           1
#define regGL2C_PERFCOUNTER1_SELECT                                                                     0x3b82
#define regGL2C_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define regGL2C_PERFCOUNTER1_SELECT1                                                                    0x3b83
#define regGL2C_PERFCOUNTER1_SELECT1_BASE_IDX                                                           1
#define regGL2C_PERFCOUNTER2_SELECT                                                                     0x3b84
#define regGL2C_PERFCOUNTER2_SELECT_BASE_IDX                                                            1
#define regGL2C_PERFCOUNTER2_SELECT1                                                                    0x3b85
#define regGL2C_PERFCOUNTER2_SELECT1_BASE_IDX                                                           1
#define regGL2C_PERFCOUNTER3_SELECT                                                                     0x3b86
#define regGL2C_PERFCOUNTER3_SELECT_BASE_IDX                                                            1
#define regGL2C_PERFCOUNTER3_SELECT1                                                                    0x3b87
#define regGL2C_PERFCOUNTER3_SELECT1_BASE_IDX                                                           1
#define regGL2A_PERFCOUNTER0_SELECT                                                                     0x3b90
#define regGL2A_PERFCOUNTER0_SELECT_BASE_IDX                                                            1
#define regGL2A_PERFCOUNTER0_SELECT1                                                                    0x3b91
#define regGL2A_PERFCOUNTER0_SELECT1_BASE_IDX                                                           1
#define regGL2A_PERFCOUNTER1_SELECT                                                                     0x3b92
#define regGL2A_PERFCOUNTER1_SELECT_BASE_IDX                                                            1
#define regGL2A_PERFCOUNTER1_SELECT1                                                                    0x3b93
#define regGL2A_PERFCOUNTER1_SELECT1_BASE_IDX                                                           1
#define regGL2A_PERFCOUNTER2_SELECT                                                                     0x3b94
#define regGL2A_PERFCOUNTER2_SELECT_BASE_IDX                                                            1
#define regGL2A_PERFCOUNTER2_SELECT1                                                                    0x3b95
#define regGL2A_PERFCOUNTER2_SELECT1_BASE_IDX                                                           1
#define regGL2A_PERFCOUNTER3_SELECT                                                                     0x3b96
#define regGL2A_PERFCOUNTER3_SELECT_BASE_IDX                                                            1
#define regGL2A_PERFCOUNTER3_SELECT1                                                                    0x3b97
#define regGL2A_PERFCOUNTER3_SELECT1_BASE_IDX                                                           1
#define regCHC_PERFCOUNTER0_SELECT                                                                      0x3bc0
#define regCHC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regCHC_PERFCOUNTER0_SELECT1                                                                     0x3bc1
#define regCHC_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regCHC_PERFCOUNTER1_SELECT                                                                      0x3bc2
#define regCHC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regCHC_PERFCOUNTER1_SELECT1                                                                     0x3bc3
#define regCHC_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define regCHC_PERFCOUNTER2_SELECT                                                                      0x3bc4
#define regCHC_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regCHC_PERFCOUNTER2_SELECT1                                                                     0x3bc5
#define regCHC_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define regCHC_PERFCOUNTER3_SELECT                                                                      0x3bc6
#define regCHC_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regCHC_PERFCOUNTER3_SELECT1                                                                     0x3bc7
#define regCHC_PERFCOUNTER3_SELECT1_BASE_IDX                                                            1
#define regRLC_SPM_PERFMON_CNTL                                                                         0x3c80
#define regRLC_SPM_PERFMON_CNTL_BASE_IDX                                                                1
#define regRLC_SPM_PERFMON_RING_BASE_LO                                                                 0x3c81
#define regRLC_SPM_PERFMON_RING_BASE_LO_BASE_IDX                                                        1
#define regRLC_SPM_PERFMON_RING_BASE_HI                                                                 0x3c82
#define regRLC_SPM_PERFMON_RING_BASE_HI_BASE_IDX                                                        1
#define regRLC_SPM_PERFMON_RING_SIZE                                                                    0x3c83
#define regRLC_SPM_PERFMON_RING_SIZE_BASE_IDX                                                           1
#define regRLC_SPM_RING_WRPTR                                                                           0x3c84
#define regRLC_SPM_RING_WRPTR_BASE_IDX                                                                  1
#define regRLC_SPM_RING_RDPTR                                                                           0x3c85
#define regRLC_SPM_RING_RDPTR_BASE_IDX                                                                  1
#define regRLC_SPM_SEGMENT_THRESHOLD                                                                    0x3c86
#define regRLC_SPM_SEGMENT_THRESHOLD_BASE_IDX                                                           1
#define regRLC_SPM_PERFMON_SEGMENT_SIZE                                                                 0x3c87
#define regRLC_SPM_PERFMON_SEGMENT_SIZE_BASE_IDX                                                        1
#define regRLC_SPM_GLOBAL_MUXSEL_ADDR                                                                   0x3c88
#define regRLC_SPM_GLOBAL_MUXSEL_ADDR_BASE_IDX                                                          1
#define regRLC_SPM_GLOBAL_MUXSEL_DATA                                                                   0x3c89
#define regRLC_SPM_GLOBAL_MUXSEL_DATA_BASE_IDX                                                          1
#define regRLC_SPM_SE_MUXSEL_ADDR                                                                       0x3c8a
#define regRLC_SPM_SE_MUXSEL_ADDR_BASE_IDX                                                              1
#define regRLC_SPM_SE_MUXSEL_DATA                                                                       0x3c8b
#define regRLC_SPM_SE_MUXSEL_DATA_BASE_IDX                                                              1
#define regRLC_SPM_ACCUM_DATARAM_ADDR                                                                   0x3c92
#define regRLC_SPM_ACCUM_DATARAM_ADDR_BASE_IDX                                                          1
#define regRLC_SPM_ACCUM_DATARAM_DATA                                                                   0x3c93
#define regRLC_SPM_ACCUM_DATARAM_DATA_BASE_IDX                                                          1
#define regRLC_SPM_ACCUM_SWA_DATARAM_ADDR                                                               0x3c94
#define regRLC_SPM_ACCUM_SWA_DATARAM_ADDR_BASE_IDX                                                      1
#define regRLC_SPM_ACCUM_SWA_DATARAM_DATA                                                               0x3c95
#define regRLC_SPM_ACCUM_SWA_DATARAM_DATA_BASE_IDX                                                      1
#define regRLC_SPM_ACCUM_CTRLRAM_ADDR                                                                   0x3c96
#define regRLC_SPM_ACCUM_CTRLRAM_ADDR_BASE_IDX                                                          1
#define regRLC_SPM_ACCUM_CTRLRAM_DATA                                                                   0x3c97
#define regRLC_SPM_ACCUM_CTRLRAM_DATA_BASE_IDX                                                          1
#define regRLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET                                                            0x3c98
#define regRLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET_BASE_IDX                                                   1
#define regRLC_SPM_ACCUM_STATUS                                                                         0x3c99
#define regRLC_SPM_ACCUM_STATUS_BASE_IDX                                                                1
#define regRLC_SPM_ACCUM_CTRL                                                                           0x3c9a
#define regRLC_SPM_ACCUM_CTRL_BASE_IDX                                                                  1
#define regRLC_SPM_ACCUM_MODE                                                                           0x3c9b
#define regRLC_SPM_ACCUM_MODE_BASE_IDX                                                                  1
#define regRLC_SPM_ACCUM_THRESHOLD                                                                      0x3c9c
#define regRLC_SPM_ACCUM_THRESHOLD_BASE_IDX                                                             1
#define regRLC_SPM_ACCUM_SAMPLES_REQUESTED                                                              0x3c9d
#define regRLC_SPM_ACCUM_SAMPLES_REQUESTED_BASE_IDX                                                     1
#define regRLC_SPM_ACCUM_DATARAM_WRCOUNT                                                                0x3c9e
#define regRLC_SPM_ACCUM_DATARAM_WRCOUNT_BASE_IDX                                                       1
#define regRLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS                                                     0x3c9f
#define regRLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS_BASE_IDX                                            1
#define regRLC_SPM_PAUSE                                                                                0x3ca2
#define regRLC_SPM_PAUSE_BASE_IDX                                                                       1
#define regRLC_SPM_STATUS                                                                               0x3ca3
#define regRLC_SPM_STATUS_BASE_IDX                                                                      1
#define regRLC_SPM_GFXCLOCK_LOWCOUNT                                                                    0x3ca4
#define regRLC_SPM_GFXCLOCK_LOWCOUNT_BASE_IDX                                                           1
#define regRLC_SPM_GFXCLOCK_HIGHCOUNT                                                                   0x3ca5
#define regRLC_SPM_GFXCLOCK_HIGHCOUNT_BASE_IDX                                                          1
#define regRLC_SPM_GTS_TRIGGER_VALUE_LO                                                                 0x3ca6
#define regRLC_SPM_GTS_TRIGGER_VALUE_LO_BASE_IDX                                                        1
#define regRLC_SPM_GTS_TRIGGER_VALUE_HI                                                                 0x3ca7
#define regRLC_SPM_GTS_TRIGGER_VALUE_HI_BASE_IDX                                                        1
#define regRLC_SPM_MODE                                                                                 0x3cad
#define regRLC_SPM_MODE_BASE_IDX                                                                        1
#define regRLC_SPM_RSPM_REQ_DATA                                                                        0x3cae
#define regRLC_SPM_RSPM_REQ_DATA_BASE_IDX                                                               1
#define regRLC_SPM_RSPM_REQ_OP                                                                          0x3cb0
#define regRLC_SPM_RSPM_REQ_OP_BASE_IDX                                                                 1
#define regRLC_SPM_RSPM_RET_DATA                                                                        0x3cb1
#define regRLC_SPM_RSPM_RET_DATA_BASE_IDX                                                               1
#define regRLC_SPM_RSPM_RET_OP                                                                          0x3cb2
#define regRLC_SPM_RSPM_RET_OP_BASE_IDX                                                                 1
#define regRLC_SPM_SE_RSPM_REQ_DATA                                                                     0x3cb3
#define regRLC_SPM_SE_RSPM_REQ_DATA_BASE_IDX                                                            1
#define regRLC_SPM_SE_RSPM_REQ_OP                                                                       0x3cb5
#define regRLC_SPM_SE_RSPM_REQ_OP_BASE_IDX                                                              1
#define regRLC_SPM_SE_RSPM_RET_DATA                                                                     0x3cb6
#define regRLC_SPM_SE_RSPM_RET_DATA_BASE_IDX                                                            1
#define regRLC_SPM_SE_RSPM_RET_OP                                                                       0x3cb7
#define regRLC_SPM_SE_RSPM_RET_OP_BASE_IDX                                                              1
#define regRLC_SPM_RSPM_CMD                                                                             0x3cb8
#define regRLC_SPM_RSPM_CMD_BASE_IDX                                                                    1
#define regRLC_SPM_RSPM_CMD_ACK                                                                         0x3cb9
#define regRLC_SPM_RSPM_CMD_ACK_BASE_IDX                                                                1
#define regRLC_SPM_SPARE                                                                                0x3cbf
#define regRLC_SPM_SPARE_BASE_IDX                                                                       1
#define regRLC_PERFMON_CNTL                                                                             0x3cc0
#define regRLC_PERFMON_CNTL_BASE_IDX                                                                    1
#define regRLC_PERFCOUNTER0_SELECT                                                                      0x3cc1
#define regRLC_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regRLC_PERFCOUNTER1_SELECT                                                                      0x3cc2
#define regRLC_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regGCR_PERFCOUNTER0_SELECT                                                                      0x3d60
#define regGCR_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regGCR_PERFCOUNTER0_SELECT1                                                                     0x3d61
#define regGCR_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regGCR_PERFCOUNTER1_SELECT                                                                      0x3d62
#define regGCR_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regGCR_PERFCOUNTER1_SELECT1                                                                     0x3d63
#define regGCR_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define regCHA_PERFCOUNTER0_SELECT                                                                      0x3de0
#define regCHA_PERFCOUNTER0_SELECT_BASE_IDX                                                             1
#define regCHA_PERFCOUNTER0_SELECT1                                                                     0x3de1
#define regCHA_PERFCOUNTER0_SELECT1_BASE_IDX                                                            1
#define regCHA_PERFCOUNTER1_SELECT                                                                      0x3de2
#define regCHA_PERFCOUNTER1_SELECT_BASE_IDX                                                             1
#define regCHA_PERFCOUNTER1_SELECT1                                                                     0x3de3
#define regCHA_PERFCOUNTER1_SELECT1_BASE_IDX                                                            1
#define regCHA_PERFCOUNTER2_SELECT                                                                      0x3de4
#define regCHA_PERFCOUNTER2_SELECT_BASE_IDX                                                             1
#define regCHA_PERFCOUNTER2_SELECT1                                                                     0x3de5
#define regCHA_PERFCOUNTER2_SELECT1_BASE_IDX                                                            1
#define regCHA_PERFCOUNTER3_SELECT                                                                      0x3de6
#define regCHA_PERFCOUNTER3_SELECT_BASE_IDX                                                             1
#define regCHA_PERFCOUNTER3_SELECT1                                                                     0x3de7
#define regCHA_PERFCOUNTER3_SELECT1_BASE_IDX                                                            1


// addressBlock: gc_gfx_cpwd_gdfll_gdfll_gdfll_reg_blk
// base address: 0x3a000
#define regGDFLL_EDC_HYSTERESIS_CNTL                                                                    0x483e
#define regGDFLL_EDC_HYSTERESIS_CNTL_BASE_IDX                                                           1
#define regGDFLL_EDC_HYSTERESIS_STAT                                                                    0x483f
#define regGDFLL_EDC_HYSTERESIS_STAT_BASE_IDX                                                           1


// addressBlock: gc_gfx_cpwd_gdfll_xvmin_xvmin_xvmin_reg_blk
// base address: 0x3a014
#define regXVMIN_XVMIN_WR_DATA                                                                          0x4806
#define regXVMIN_XVMIN_WR_DATA_BASE_IDX                                                                 1


// addressBlock: gc_gfx_cpwd_grtavfs_grtavfs_grtavfs_reg_blk
// base address: 0x3a600
#define regGRTAVFS_RTAVFS_REG_ADDR                                                                      0x4980
#define regGRTAVFS_RTAVFS_REG_ADDR_BASE_IDX                                                             1
#define regGRTAVFS_RTAVFS_WR_DATA                                                                       0x4981
#define regGRTAVFS_RTAVFS_WR_DATA_BASE_IDX                                                              1
#define regGRTAVFS_GENERAL_0                                                                            0x4982
#define regGRTAVFS_GENERAL_0_BASE_IDX                                                                   1
#define regGRTAVFS_RTAVFS_RD_DATA                                                                       0x4983
#define regGRTAVFS_RTAVFS_RD_DATA_BASE_IDX                                                              1
#define regGRTAVFS_RTAVFS_REG_CTRL                                                                      0x4984
#define regGRTAVFS_RTAVFS_REG_CTRL_BASE_IDX                                                             1
#define regGRTAVFS_RTAVFS_REG_STATUS                                                                    0x4985
#define regGRTAVFS_RTAVFS_REG_STATUS_BASE_IDX                                                           1
#define regGRTAVFS_TARG_FREQ                                                                            0x4986
#define regGRTAVFS_TARG_FREQ_BASE_IDX                                                                   1
#define regGRTAVFS_TARG_VOLT                                                                            0x4987
#define regGRTAVFS_TARG_VOLT_BASE_IDX                                                                   1
#define regGRTAVFS_SOFT_RESET                                                                           0x498c
#define regGRTAVFS_SOFT_RESET_BASE_IDX                                                                  1
#define regGRTAVFS_PSM_CNTL                                                                             0x498d
#define regGRTAVFS_PSM_CNTL_BASE_IDX                                                                    1
#define regGRTAVFS_CLK_CNTL                                                                             0x498e
#define regGRTAVFS_CLK_CNTL_BASE_IDX                                                                    1
#define regGFX_ICG_GRTAVFS_CTRL                                                                         0x498f
#define regGFX_ICG_GRTAVFS_CTRL_BASE_IDX                                                                1


// addressBlock: gc_gfx_cpwd_grtavfs_rtavfs_rtavfs_rtavfs_reg_blk
// base address: 0x3a600
#define regRTAVFS_RTAVFS_REG_ADDR                                                                       0x4980
#define regRTAVFS_RTAVFS_REG_ADDR_BASE_IDX                                                              1
#define regRTAVFS_RTAVFS_WR_DATA                                                                        0x4981
#define regRTAVFS_RTAVFS_WR_DATA_BASE_IDX                                                               1


// addressBlock: gc_gfx_cpwd_cpwd_hypdec
// base address: 0x3e000
#define regRLC_SDMA0_STATUS                                                                             0x5b18
#define regRLC_SDMA0_STATUS_BASE_IDX                                                                    1
#define regRLC_SDMA1_STATUS                                                                             0x5b19
#define regRLC_SDMA1_STATUS_BASE_IDX                                                                    1
#define regRLC_SDMA2_STATUS                                                                             0x5b1a
#define regRLC_SDMA2_STATUS_BASE_IDX                                                                    1
#define regRLC_SDMA3_STATUS                                                                             0x5b1b
#define regRLC_SDMA3_STATUS_BASE_IDX                                                                    1
#define regRLC_SDMA0_BUSY_STATUS                                                                        0x5b1c
#define regRLC_SDMA0_BUSY_STATUS_BASE_IDX                                                               1
#define regRLC_SDMA1_BUSY_STATUS                                                                        0x5b1d
#define regRLC_SDMA1_BUSY_STATUS_BASE_IDX                                                               1
#define regRLC_SDMA2_BUSY_STATUS                                                                        0x5b1e
#define regRLC_SDMA2_BUSY_STATUS_BASE_IDX                                                               1
#define regRLC_SDMA3_BUSY_STATUS                                                                        0x5b1f
#define regRLC_SDMA3_BUSY_STATUS_BASE_IDX                                                               1
#define regRLC_HYP_SEMAPHORE_0                                                                          0x5b2e
#define regRLC_HYP_SEMAPHORE_0_BASE_IDX                                                                 1
#define regRLC_HYP_SEMAPHORE_1                                                                          0x5b2f
#define regRLC_HYP_SEMAPHORE_1_BASE_IDX                                                                 1
#define regRLC_BUSY_CLK_CNTL                                                                            0x5b30
#define regRLC_BUSY_CLK_CNTL_BASE_IDX                                                                   1
#define regRLC_CLK_CNTL                                                                                 0x5b31
#define regRLC_CLK_CNTL_BASE_IDX                                                                        1
#define regRLC_IH_COOKIE                                                                                0x5b41
#define regRLC_IH_COOKIE_BASE_IDX                                                                       1
#define regRLC_IH_COOKIE_CNTL                                                                           0x5b42
#define regRLC_IH_COOKIE_CNTL_BASE_IDX                                                                  1
#define regRLC_HYP_RLCG_UCODE_CHKSUM                                                                    0x5b43
#define regRLC_HYP_RLCG_UCODE_CHKSUM_BASE_IDX                                                           1
#define regRLC_HYP_SEMAPHORE_2                                                                          0x5b52
#define regRLC_HYP_SEMAPHORE_2_BASE_IDX                                                                 1
#define regRLC_HYP_SEMAPHORE_3                                                                          0x5b53
#define regRLC_HYP_SEMAPHORE_3_BASE_IDX                                                                 1
#define regRLC_GPM_UCODE_ADDR                                                                           0x5b60
#define regRLC_GPM_UCODE_ADDR_BASE_IDX                                                                  1
#define regRLC_GPM_UCODE_DATA                                                                           0x5b61
#define regRLC_GPM_UCODE_DATA_BASE_IDX                                                                  1
#define regRLC_GPM_IRAM_ADDR                                                                            0x5b62
#define regRLC_GPM_IRAM_ADDR_BASE_IDX                                                                   1
#define regRLC_GPM_IRAM_DATA                                                                            0x5b63
#define regRLC_GPM_IRAM_DATA_BASE_IDX                                                                   1
#define regRLC_LX6_DRAM_ADDR                                                                            0x5b68
#define regRLC_LX6_DRAM_ADDR_BASE_IDX                                                                   1
#define regRLC_LX6_DRAM_DATA                                                                            0x5b69
#define regRLC_LX6_DRAM_DATA_BASE_IDX                                                                   1
#define regRLC_LX6_IRAM_ADDR                                                                            0x5b6a
#define regRLC_LX6_IRAM_ADDR_BASE_IDX                                                                   1
#define regRLC_LX6_IRAM_DATA                                                                            0x5b6b
#define regRLC_LX6_IRAM_DATA_BASE_IDX                                                                   1
#define regRLC_GPM_SCRATCH_ADDR                                                                         0x5b6e
#define regRLC_GPM_SCRATCH_ADDR_BASE_IDX                                                                1
#define regRLC_GPM_SCRATCH_DATA                                                                         0x5b6f
#define regRLC_GPM_SCRATCH_DATA_BASE_IDX                                                                1
#define regRLC_SRM_DRAM_ADDR                                                                            0x5b71
#define regRLC_SRM_DRAM_ADDR_BASE_IDX                                                                   1
#define regRLC_SRM_DRAM_DATA                                                                            0x5b72
#define regRLC_SRM_DRAM_DATA_BASE_IDX                                                                   1
#define regRLC_SRM_ARAM_ADDR                                                                            0x5b73
#define regRLC_SRM_ARAM_ADDR_BASE_IDX                                                                   1
#define regRLC_SRM_ARAM_DATA                                                                            0x5b74
#define regRLC_SRM_ARAM_DATA_BASE_IDX                                                                   1
#define regRLC_GTS_OFFSET_LSB                                                                           0x5b79
#define regRLC_GTS_OFFSET_LSB_BASE_IDX                                                                  1
#define regRLC_GTS_OFFSET_MSB                                                                           0x5b7a
#define regRLC_GTS_OFFSET_MSB_BASE_IDX                                                                  1
#define regRLC_GTS_OFFSET_SNAP_LSB                                                                      0x5b7b
#define regRLC_GTS_OFFSET_SNAP_LSB_BASE_IDX                                                             1
#define regRLC_GTS_OFFSET_SNAP_MSB                                                                      0x5b7c
#define regRLC_GTS_OFFSET_SNAP_MSB_BASE_IDX                                                             1
#define regGL2_PIPE_STEER_0                                                                             0x5b80
#define regGL2_PIPE_STEER_0_BASE_IDX                                                                    1
#define regGL2_PIPE_STEER_1                                                                             0x5b81
#define regGL2_PIPE_STEER_1_BASE_IDX                                                                    1
#define regGL2_PIPE_STEER_2                                                                             0x5b82
#define regGL2_PIPE_STEER_2_BASE_IDX                                                                    1
#define regGL2_PIPE_STEER_3                                                                             0x5b83
#define regGL2_PIPE_STEER_3_BASE_IDX                                                                    1
#define regCH_PIPE_STEER                                                                                0x5b88
#define regCH_PIPE_STEER_BASE_IDX                                                                       1
#define regGC_USER_FULL_SA_UNIT_DISABLE                                                                 0x5b91
#define regGC_USER_FULL_SA_UNIT_DISABLE_BASE_IDX                                                        1
#define regGRBM_GC_USER_SA_UNIT_DISABLE                                                                 0x5b92
#define regGRBM_GC_USER_SA_UNIT_DISABLE_BASE_IDX                                                        1
#define regGC_USER_GL2C_DISABLE_0                                                                       0x5b98
#define regGC_USER_GL2C_DISABLE_0_BASE_IDX                                                              1
#define regGC_USER_GL2C_DISABLE_1                                                                       0x5b99
#define regGC_USER_GL2C_DISABLE_1_BASE_IDX                                                              1


// addressBlock: gc_gfx_cpwd_cpwd_cphypdec
// base address: 0x3e000
#define regCP_HYP_CONTEXT_RANGE_BASE                                                                    0x580a
#define regCP_HYP_CONTEXT_RANGE_BASE_BASE_IDX                                                           1
#define regCP_HYP_CONTEXT_RANGE_END                                                                     0x580b
#define regCP_HYP_CONTEXT_RANGE_END_BASE_IDX                                                            1
#define regCP_HYP_PFP_UCODE_ADDR                                                                        0x5814
#define regCP_HYP_PFP_UCODE_ADDR_BASE_IDX                                                               1
#define regCP_PFP_UCODE_ADDR                                                                            0x5814
#define regCP_PFP_UCODE_ADDR_BASE_IDX                                                                   1
#define regCP_HYP_PFP_UCODE_DATA                                                                        0x5815
#define regCP_HYP_PFP_UCODE_DATA_BASE_IDX                                                               1
#define regCP_PFP_UCODE_DATA                                                                            0x5815
#define regCP_PFP_UCODE_DATA_BASE_IDX                                                                   1
#define regCP_HYP_ME_UCODE_ADDR                                                                         0x5816
#define regCP_HYP_ME_UCODE_ADDR_BASE_IDX                                                                1
#define regCP_ME_RAM_RADDR                                                                              0x5816
#define regCP_ME_RAM_RADDR_BASE_IDX                                                                     1
#define regCP_ME_RAM_WADDR                                                                              0x5816
#define regCP_ME_RAM_WADDR_BASE_IDX                                                                     1
#define regCP_HYP_ME_UCODE_DATA                                                                         0x5817
#define regCP_HYP_ME_UCODE_DATA_BASE_IDX                                                                1
#define regCP_ME_RAM_DATA                                                                               0x5817
#define regCP_ME_RAM_DATA_BASE_IDX                                                                      1
#define regCP_HYP_MEC1_UCODE_ADDR                                                                       0x581a
#define regCP_HYP_MEC1_UCODE_ADDR_BASE_IDX                                                              1
#define regCP_MEC_ME1_UCODE_ADDR                                                                        0x581a
#define regCP_MEC_ME1_UCODE_ADDR_BASE_IDX                                                               1
#define regCP_HYP_MEC1_UCODE_DATA                                                                       0x581b
#define regCP_HYP_MEC1_UCODE_DATA_BASE_IDX                                                              1
#define regCP_MEC_ME1_UCODE_DATA                                                                        0x581b
#define regCP_MEC_ME1_UCODE_DATA_BASE_IDX                                                               1
#define regCP_HYP_PFP_UCODE_CHKSUM                                                                      0x581e
#define regCP_HYP_PFP_UCODE_CHKSUM_BASE_IDX                                                             1
#define regCP_HYP_ME_UCODE_CHKSUM                                                                       0x5820
#define regCP_HYP_ME_UCODE_CHKSUM_BASE_IDX                                                              1
#define regCP_HYP_MEC_ME1_UCODE_CHKSUM                                                                  0x5821
#define regCP_HYP_MEC_ME1_UCODE_CHKSUM_BASE_IDX                                                         1
#define regCP_PFP_IC_BASE_LO                                                                            0x5840
#define regCP_PFP_IC_BASE_LO_BASE_IDX                                                                   1
#define regCP_PFP_IC_BASE_HI                                                                            0x5841
#define regCP_PFP_IC_BASE_HI_BASE_IDX                                                                   1
#define regCP_PFP_IC_BASE_CNTL                                                                          0x5842
#define regCP_PFP_IC_BASE_CNTL_BASE_IDX                                                                 1
#define regCP_PFP_IC_OP_CNTL                                                                            0x5843
#define regCP_PFP_IC_OP_CNTL_BASE_IDX                                                                   1
#define regCP_ME_IC_BASE_LO                                                                             0x5844
#define regCP_ME_IC_BASE_LO_BASE_IDX                                                                    1
#define regCP_ME_IC_BASE_HI                                                                             0x5845
#define regCP_ME_IC_BASE_HI_BASE_IDX                                                                    1
#define regCP_ME_IC_BASE_CNTL                                                                           0x5846
#define regCP_ME_IC_BASE_CNTL_BASE_IDX                                                                  1
#define regCP_ME_IC_OP_CNTL                                                                             0x5847
#define regCP_ME_IC_OP_CNTL_BASE_IDX                                                                    1
#define regCP_CPC_IC_BASE_LO                                                                            0x584c
#define regCP_CPC_IC_BASE_LO_BASE_IDX                                                                   1
#define regCP_CPC_IC_BASE_HI                                                                            0x584d
#define regCP_CPC_IC_BASE_HI_BASE_IDX                                                                   1
#define regCP_CPC_IC_BASE_CNTL                                                                          0x584e
#define regCP_CPC_IC_BASE_CNTL_BASE_IDX                                                                 1
#define regCP_MES_IC_BASE_LO                                                                            0x5850
#define regCP_MES_IC_BASE_LO_BASE_IDX                                                                   1
#define regCP_MES_MIBASE_LO                                                                             0x5850
#define regCP_MES_MIBASE_LO_BASE_IDX                                                                    1
#define regCP_MES_IC_BASE_HI                                                                            0x5851
#define regCP_MES_IC_BASE_HI_BASE_IDX                                                                   1
#define regCP_MES_MIBASE_HI                                                                             0x5851
#define regCP_MES_MIBASE_HI_BASE_IDX                                                                    1
#define regCP_MES_IC_BASE_CNTL                                                                          0x5852
#define regCP_MES_IC_BASE_CNTL_BASE_IDX                                                                 1
#define regCP_MES_DC_BASE_LO                                                                            0x5854
#define regCP_MES_DC_BASE_LO_BASE_IDX                                                                   1
#define regCP_MES_MDBASE_LO                                                                             0x5854
#define regCP_MES_MDBASE_LO_BASE_IDX                                                                    1
#define regCP_MES_DC_BASE_HI                                                                            0x5855
#define regCP_MES_DC_BASE_HI_BASE_IDX                                                                   1
#define regCP_MES_MDBASE_HI                                                                             0x5855
#define regCP_MES_MDBASE_HI_BASE_IDX                                                                    1
#define regCP_MES_MIBOUND_LO                                                                            0x585b
#define regCP_MES_MIBOUND_LO_BASE_IDX                                                                   1
#define regCP_MES_MIBOUND_HI                                                                            0x585c
#define regCP_MES_MIBOUND_HI_BASE_IDX                                                                   1
#define regCP_MES_MDBOUND_LO                                                                            0x585d
#define regCP_MES_MDBOUND_LO_BASE_IDX                                                                   1
#define regCP_MES_MDBOUND_HI                                                                            0x585e
#define regCP_MES_MDBOUND_HI_BASE_IDX                                                                   1
#define regCP_HYP_PFP_UCODE_VERS                                                                        0x5861
#define regCP_HYP_PFP_UCODE_VERS_BASE_IDX                                                               1
#define regCP_HYP_ME_UCODE_VERS                                                                         0x5862
#define regCP_HYP_ME_UCODE_VERS_BASE_IDX                                                                1
#define regCP_GFX_RS64_DC_BASE0_LO                                                                      0x5863
#define regCP_GFX_RS64_DC_BASE0_LO_BASE_IDX                                                             1
#define regCP_GFX_RS64_DC_BASE1_LO                                                                      0x5864
#define regCP_GFX_RS64_DC_BASE1_LO_BASE_IDX                                                             1
#define regCP_GFX_RS64_DC_BASE0_HI                                                                      0x5865
#define regCP_GFX_RS64_DC_BASE0_HI_BASE_IDX                                                             1
#define regCP_GFX_RS64_DC_BASE1_HI                                                                      0x5866
#define regCP_GFX_RS64_DC_BASE1_HI_BASE_IDX                                                             1
#define regCP_GFX_RS64_MIBOUND_LO                                                                       0x586c
#define regCP_GFX_RS64_MIBOUND_LO_BASE_IDX                                                              1
#define regCP_GFX_RS64_MIBOUND_HI                                                                       0x586d
#define regCP_GFX_RS64_MIBOUND_HI_BASE_IDX                                                              1
#define regCP_MEC_DC_BASE_LO                                                                            0x5870
#define regCP_MEC_DC_BASE_LO_BASE_IDX                                                                   1
#define regCP_MEC_MDBASE_LO                                                                             0x5870
#define regCP_MEC_MDBASE_LO_BASE_IDX                                                                    1
#define regCP_MEC_DC_BASE_HI                                                                            0x5871
#define regCP_MEC_DC_BASE_HI_BASE_IDX                                                                   1
#define regCP_MEC_MDBASE_HI                                                                             0x5871
#define regCP_MEC_MDBASE_HI_BASE_IDX                                                                    1
#define regCP_MEC_MIBOUND_LO                                                                            0x5872
#define regCP_MEC_MIBOUND_LO_BASE_IDX                                                                   1
#define regCP_MEC_MIBOUND_HI                                                                            0x5873
#define regCP_MEC_MIBOUND_HI_BASE_IDX                                                                   1
#define regCP_MEC_MDBOUND_LO                                                                            0x5874
#define regCP_MEC_MDBOUND_LO_BASE_IDX                                                                   1
#define regCP_MEC_MDBOUND_HI                                                                            0x5875
#define regCP_MEC_MDBOUND_HI_BASE_IDX                                                                   1


// addressBlock: gc_gfx_cpwd_cpwd_grbm_hypdec
// base address: 0x3e800
#define regGRBM_GFX_INDEX_SR_SELECT                                                                     0x5a00
#define regGRBM_GFX_INDEX_SR_SELECT_BASE_IDX                                                            1
#define regGRBM_GFX_INDEX_SR_DATA                                                                       0x5a01
#define regGRBM_GFX_INDEX_SR_DATA_BASE_IDX                                                              1
#define regGRBM_GFX_CNTL_SR_SELECT                                                                      0x5a02
#define regGRBM_GFX_CNTL_SR_SELECT_BASE_IDX                                                             1
#define regGRBM_GFX_CNTL_SR_DATA                                                                        0x5a03
#define regGRBM_GFX_CNTL_SR_DATA_BASE_IDX                                                               1
#define regGC_IH_COOKIE_0_PTR                                                                           0x5a07
#define regGC_IH_COOKIE_0_PTR_BASE_IDX                                                                  1
#define regGRBM_SE_REMAP_CNTL                                                                           0x5a08
#define regGRBM_SE_REMAP_CNTL_BASE_IDX                                                                  1
#define regGRBM_GRBM_SA_REMAP_CNTL                                                                      0x5a09
#define regGRBM_GRBM_SA_REMAP_CNTL_BASE_IDX                                                             1


// addressBlock: gc_gfx_cpwd_cpwd_rlcdec
// base address: 0x3b000
#define regRLC_CNTL                                                                                     0x4c00
#define regRLC_CNTL_BASE_IDX                                                                            1
#define regRLC_F32_UCODE_VERSION                                                                        0x4c03
#define regRLC_F32_UCODE_VERSION_BASE_IDX                                                               1
#define regRLC_STAT                                                                                     0x4c04
#define regRLC_STAT_BASE_IDX                                                                            1
#define regRLC_ACTIVE_MASK                                                                              0x4c05
#define regRLC_ACTIVE_MASK_BASE_IDX                                                                     1
#define regRLC_GFX_SE_STATUS                                                                            0x4c06
#define regRLC_GFX_SE_STATUS_BASE_IDX                                                                   1
#define regRLC_REFCLOCK_TIMESTAMP_LSB                                                                   0x4c0c
#define regRLC_REFCLOCK_TIMESTAMP_LSB_BASE_IDX                                                          1
#define regRLC_REFCLOCK_TIMESTAMP_MSB                                                                   0x4c0d
#define regRLC_REFCLOCK_TIMESTAMP_MSB_BASE_IDX                                                          1
#define regRLC_GPM_TIMER_INT_0                                                                          0x4c0e
#define regRLC_GPM_TIMER_INT_0_BASE_IDX                                                                 1
#define regRLC_GPM_TIMER_INT_1                                                                          0x4c0f
#define regRLC_GPM_TIMER_INT_1_BASE_IDX                                                                 1
#define regRLC_GPM_TIMER_INT_2                                                                          0x4c10
#define regRLC_GPM_TIMER_INT_2_BASE_IDX                                                                 1
#define regRLC_GPM_TIMER_INT_3                                                                          0x4c11
#define regRLC_GPM_TIMER_INT_3_BASE_IDX                                                                 1
#define regRLC_GPM_TIMER_INT_4                                                                          0x4c12
#define regRLC_GPM_TIMER_INT_4_BASE_IDX                                                                 1
#define regRLC_GPM_TIMER_CTRL                                                                           0x4c13
#define regRLC_GPM_TIMER_CTRL_BASE_IDX                                                                  1
#define regRLC_GPM_TIMER_STAT                                                                           0x4c14
#define regRLC_GPM_TIMER_STAT_BASE_IDX                                                                  1
#define regRLC_GPM_LEGACY_INT_STAT                                                                      0x4c16
#define regRLC_GPM_LEGACY_INT_STAT_BASE_IDX                                                             1
#define regRLC_GPM_LEGACY_INT_CLEAR                                                                     0x4c17
#define regRLC_GPM_LEGACY_INT_CLEAR_BASE_IDX                                                            1
#define regRLC_INT_STAT                                                                                 0x4c18
#define regRLC_INT_STAT_BASE_IDX                                                                        1
#define regRLC_MGCG_CTRL                                                                                0x4c1a
#define regRLC_MGCG_CTRL_BASE_IDX                                                                       1
#define regRLC_JUMP_TABLE_RESTORE                                                                       0x4c1e
#define regRLC_JUMP_TABLE_RESTORE_BASE_IDX                                                              1
#define regRLC_PG_DELAY_2                                                                               0x4c1f
#define regRLC_PG_DELAY_2_BASE_IDX                                                                      1
#define regRLC_GPU_CLOCK_COUNT_LSB                                                                      0x4c24
#define regRLC_GPU_CLOCK_COUNT_LSB_BASE_IDX                                                             1
#define regRLC_GPU_CLOCK_COUNT_MSB                                                                      0x4c25
#define regRLC_GPU_CLOCK_COUNT_MSB_BASE_IDX                                                             1
#define regRLC_CAPTURE_GPU_CLOCK_COUNT                                                                  0x4c26
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_BASE_IDX                                                         1
#define regRLC_UCODE_CNTL                                                                               0x4c27
#define regRLC_UCODE_CNTL_BASE_IDX                                                                      1
#define regRLC_GPM_THREAD_RESET                                                                         0x4c28
#define regRLC_GPM_THREAD_RESET_BASE_IDX                                                                1
#define regRLC_GPM_CP_DMA_COMPLETE_T0                                                                   0x4c29
#define regRLC_GPM_CP_DMA_COMPLETE_T0_BASE_IDX                                                          1
#define regRLC_GPM_CP_DMA_COMPLETE_T1                                                                   0x4c2a
#define regRLC_GPM_CP_DMA_COMPLETE_T1_BASE_IDX                                                          1
#define regRLC_GPM_THREAD_INVALIDATE_CACHE                                                              0x4c2b
#define regRLC_GPM_THREAD_INVALIDATE_CACHE_BASE_IDX                                                     1
#define regRLC_CLK_COUNT_GFXCLK_LSB                                                                     0x4c30
#define regRLC_CLK_COUNT_GFXCLK_LSB_BASE_IDX                                                            1
#define regRLC_CLK_COUNT_GFXCLK_MSB                                                                     0x4c31
#define regRLC_CLK_COUNT_GFXCLK_MSB_BASE_IDX                                                            1
#define regRLC_CLK_COUNT_REFCLK_LSB                                                                     0x4c32
#define regRLC_CLK_COUNT_REFCLK_LSB_BASE_IDX                                                            1
#define regRLC_CLK_COUNT_REFCLK_MSB                                                                     0x4c33
#define regRLC_CLK_COUNT_REFCLK_MSB_BASE_IDX                                                            1
#define regRLC_CLK_COUNT_CTRL                                                                           0x4c34
#define regRLC_CLK_COUNT_CTRL_BASE_IDX                                                                  1
#define regRLC_CLK_COUNT_STAT                                                                           0x4c35
#define regRLC_CLK_COUNT_STAT_BASE_IDX                                                                  1
#define regRLC_RLCG_DOORBELL_CNTL                                                                       0x4c36
#define regRLC_RLCG_DOORBELL_CNTL_BASE_IDX                                                              1
#define regRLC_RLCG_DOORBELL_STAT                                                                       0x4c37
#define regRLC_RLCG_DOORBELL_STAT_BASE_IDX                                                              1
#define regRLC_RLCG_DOORBELL_0_DATA_LO                                                                  0x4c38
#define regRLC_RLCG_DOORBELL_0_DATA_LO_BASE_IDX                                                         1
#define regRLC_RLCG_DOORBELL_0_DATA_HI                                                                  0x4c39
#define regRLC_RLCG_DOORBELL_0_DATA_HI_BASE_IDX                                                         1
#define regRLC_RLCG_DOORBELL_1_DATA_LO                                                                  0x4c3a
#define regRLC_RLCG_DOORBELL_1_DATA_LO_BASE_IDX                                                         1
#define regRLC_RLCG_DOORBELL_1_DATA_HI                                                                  0x4c3b
#define regRLC_RLCG_DOORBELL_1_DATA_HI_BASE_IDX                                                         1
#define regRLC_RLCG_DOORBELL_2_DATA_LO                                                                  0x4c3c
#define regRLC_RLCG_DOORBELL_2_DATA_LO_BASE_IDX                                                         1
#define regRLC_RLCG_DOORBELL_2_DATA_HI                                                                  0x4c3d
#define regRLC_RLCG_DOORBELL_2_DATA_HI_BASE_IDX                                                         1
#define regRLC_RLCG_DOORBELL_3_DATA_LO                                                                  0x4c3e
#define regRLC_RLCG_DOORBELL_3_DATA_LO_BASE_IDX                                                         1
#define regRLC_RLCG_DOORBELL_3_DATA_HI                                                                  0x4c3f
#define regRLC_RLCG_DOORBELL_3_DATA_HI_BASE_IDX                                                         1
#define regRLC_GPU_CLOCK_32_RES_SEL                                                                     0x4c41
#define regRLC_GPU_CLOCK_32_RES_SEL_BASE_IDX                                                            1
#define regRLC_GPU_CLOCK_32                                                                             0x4c42
#define regRLC_GPU_CLOCK_32_BASE_IDX                                                                    1
#define regRLC_PG_CNTL                                                                                  0x4c43
#define regRLC_PG_CNTL_BASE_IDX                                                                         1
#define regRLC_GPM_THREAD_PRIORITY                                                                      0x4c44
#define regRLC_GPM_THREAD_PRIORITY_BASE_IDX                                                             1
#define regRLC_GPM_THREAD_ENABLE                                                                        0x4c45
#define regRLC_GPM_THREAD_ENABLE_BASE_IDX                                                               1
#define regRLC_RLCG_DOORBELL_RANGE                                                                      0x4c47
#define regRLC_RLCG_DOORBELL_RANGE_BASE_IDX                                                             1
#define regRLC_CGTT_MGCG_OVERRIDE                                                                       0x4c48
#define regRLC_CGTT_MGCG_OVERRIDE_BASE_IDX                                                              1
#define regRLC_CGCG_CGLS_CTRL                                                                           0x4c49
#define regRLC_CGCG_CGLS_CTRL_BASE_IDX                                                                  1
#define regRLC_CGCG_RAMP_CTRL                                                                           0x4c4a
#define regRLC_CGCG_RAMP_CTRL_BASE_IDX                                                                  1
#define regRLC_DYN_PG_STATUS                                                                            0x4c4b
#define regRLC_DYN_PG_STATUS_BASE_IDX                                                                   1
#define regRLC_DYN_PG_REQUEST                                                                           0x4c4c
#define regRLC_DYN_PG_REQUEST_BASE_IDX                                                                  1
#define regRLC_PG_DELAY                                                                                 0x4c4d
#define regRLC_PG_DELAY_BASE_IDX                                                                        1
#define regRLC_PG_ALWAYS_ON_WGP_MASK                                                                    0x4c53
#define regRLC_PG_ALWAYS_ON_WGP_MASK_BASE_IDX                                                           1
#define regRLC_MAX_PG_WGP                                                                               0x4c54
#define regRLC_MAX_PG_WGP_BASE_IDX                                                                      1
#define regRLC_AUTO_PG_CTRL                                                                             0x4c55
#define regRLC_AUTO_PG_CTRL_BASE_IDX                                                                    1
#define regRLC_SERDES_RD_INDEX                                                                          0x4c59
#define regRLC_SERDES_RD_INDEX_BASE_IDX                                                                 1
#define regRLC_SERDES_RD_DATA_0                                                                         0x4c5a
#define regRLC_SERDES_RD_DATA_0_BASE_IDX                                                                1
#define regRLC_SERDES_RD_DATA_1                                                                         0x4c5b
#define regRLC_SERDES_RD_DATA_1_BASE_IDX                                                                1
#define regRLC_SERDES_RD_DATA_2                                                                         0x4c5c
#define regRLC_SERDES_RD_DATA_2_BASE_IDX                                                                1
#define regRLC_SERDES_RD_DATA_3                                                                         0x4c5d
#define regRLC_SERDES_RD_DATA_3_BASE_IDX                                                                1
#define regRLC_SERDES_MASK                                                                              0x4c5e
#define regRLC_SERDES_MASK_BASE_IDX                                                                     1
#define regRLC_SERDES_CTRL                                                                              0x4c5f
#define regRLC_SERDES_CTRL_BASE_IDX                                                                     1
#define regRLC_SERDES_DATA                                                                              0x4c60
#define regRLC_SERDES_DATA_BASE_IDX                                                                     1
#define regRLC_SERDES_BUSY                                                                              0x4c61
#define regRLC_SERDES_BUSY_BASE_IDX                                                                     1
#define regRLC_GPM_GENERAL_0                                                                            0x4c63
#define regRLC_GPM_GENERAL_0_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_1                                                                            0x4c64
#define regRLC_GPM_GENERAL_1_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_2                                                                            0x4c65
#define regRLC_GPM_GENERAL_2_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_3                                                                            0x4c66
#define regRLC_GPM_GENERAL_3_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_4                                                                            0x4c67
#define regRLC_GPM_GENERAL_4_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_5                                                                            0x4c68
#define regRLC_GPM_GENERAL_5_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_6                                                                            0x4c69
#define regRLC_GPM_GENERAL_6_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_7                                                                            0x4c6a
#define regRLC_GPM_GENERAL_7_BASE_IDX                                                                   1
#define regRLC_STATIC_PG_STATUS                                                                         0x4c6e
#define regRLC_STATIC_PG_STATUS_BASE_IDX                                                                1
#define regRLC_GPM_GENERAL_16                                                                           0x4c76
#define regRLC_GPM_GENERAL_16_BASE_IDX                                                                  1
#define regRLC_PG_DELAY_3                                                                               0x4c78
#define regRLC_PG_DELAY_3_BASE_IDX                                                                      1
#define regRLC_GPR_REG1                                                                                 0x4c79
#define regRLC_GPR_REG1_BASE_IDX                                                                        1
#define regRLC_GPR_REG2                                                                                 0x4c7a
#define regRLC_GPR_REG2_BASE_IDX                                                                        1
#define regRLC_GPM_INT_DISABLE_TH0                                                                      0x4c7c
#define regRLC_GPM_INT_DISABLE_TH0_BASE_IDX                                                             1
#define regRLC_GPM_LEGACY_INT_DISABLE                                                                   0x4c7d
#define regRLC_GPM_LEGACY_INT_DISABLE_BASE_IDX                                                          1
#define regRLC_GPM_INT_FORCE_TH0                                                                        0x4c7e
#define regRLC_GPM_INT_FORCE_TH0_BASE_IDX                                                               1
#define regRLC_SRM_CNTL                                                                                 0x4c80
#define regRLC_SRM_CNTL_BASE_IDX                                                                        1
#define regRLC_SRM_GPM_COMMAND_STATUS                                                                   0x4c88
#define regRLC_SRM_GPM_COMMAND_STATUS_BASE_IDX                                                          1
#define regRLC_SRM_INDEX_CNTL_ADDR_0                                                                    0x4c8b
#define regRLC_SRM_INDEX_CNTL_ADDR_0_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_1                                                                    0x4c8c
#define regRLC_SRM_INDEX_CNTL_ADDR_1_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_2                                                                    0x4c8d
#define regRLC_SRM_INDEX_CNTL_ADDR_2_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_3                                                                    0x4c8e
#define regRLC_SRM_INDEX_CNTL_ADDR_3_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_4                                                                    0x4c8f
#define regRLC_SRM_INDEX_CNTL_ADDR_4_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_5                                                                    0x4c90
#define regRLC_SRM_INDEX_CNTL_ADDR_5_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_6                                                                    0x4c91
#define regRLC_SRM_INDEX_CNTL_ADDR_6_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_ADDR_7                                                                    0x4c92
#define regRLC_SRM_INDEX_CNTL_ADDR_7_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_0                                                                    0x4c93
#define regRLC_SRM_INDEX_CNTL_DATA_0_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_1                                                                    0x4c94
#define regRLC_SRM_INDEX_CNTL_DATA_1_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_2                                                                    0x4c95
#define regRLC_SRM_INDEX_CNTL_DATA_2_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_3                                                                    0x4c96
#define regRLC_SRM_INDEX_CNTL_DATA_3_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_4                                                                    0x4c97
#define regRLC_SRM_INDEX_CNTL_DATA_4_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_5                                                                    0x4c98
#define regRLC_SRM_INDEX_CNTL_DATA_5_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_6                                                                    0x4c99
#define regRLC_SRM_INDEX_CNTL_DATA_6_BASE_IDX                                                           1
#define regRLC_SRM_INDEX_CNTL_DATA_7                                                                    0x4c9a
#define regRLC_SRM_INDEX_CNTL_DATA_7_BASE_IDX                                                           1
#define regRLC_SRM_STAT                                                                                 0x4c9b
#define regRLC_SRM_STAT_BASE_IDX                                                                        1
#define regRLC_LX6_UTCL1_ERROR_2                                                                        0x4ca8
#define regRLC_LX6_UTCL1_ERROR_2_BASE_IDX                                                               1
#define regRLC_GPM_GENERAL_8                                                                            0x4cad
#define regRLC_GPM_GENERAL_8_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_9                                                                            0x4cae
#define regRLC_GPM_GENERAL_9_BASE_IDX                                                                   1
#define regRLC_GPM_GENERAL_10                                                                           0x4caf
#define regRLC_GPM_GENERAL_10_BASE_IDX                                                                  1
#define regRLC_GPM_GENERAL_11                                                                           0x4cb0
#define regRLC_GPM_GENERAL_11_BASE_IDX                                                                  1
#define regRLC_GPM_GENERAL_12                                                                           0x4cb1
#define regRLC_GPM_GENERAL_12_BASE_IDX                                                                  1
#define regRLC_GPM_UTCL1_CNTL_0                                                                         0x4cb2
#define regRLC_GPM_UTCL1_CNTL_0_BASE_IDX                                                                1
#define regRLC_SPM_UTCL1_CNTL                                                                           0x4cb5
#define regRLC_SPM_UTCL1_CNTL_BASE_IDX                                                                  1
#define regRLC_UTCL1_STATUS_2                                                                           0x4cb6
#define regRLC_UTCL1_STATUS_2_BASE_IDX                                                                  1
#define regRLC_SPM_UTCL1_ERROR_1                                                                        0x4cbc
#define regRLC_SPM_UTCL1_ERROR_1_BASE_IDX                                                               1
#define regRLC_SPM_UTCL1_ERROR_2                                                                        0x4cbd
#define regRLC_SPM_UTCL1_ERROR_2_BASE_IDX                                                               1
#define regRLC_GPM_UTCL1_TH0_ERROR_1                                                                    0x4cbe
#define regRLC_GPM_UTCL1_TH0_ERROR_1_BASE_IDX                                                           1
#define regRLC_GPM_UTCL1_TH0_ERROR_2                                                                    0x4cc0
#define regRLC_GPM_UTCL1_TH0_ERROR_2_BASE_IDX                                                           1
#define regRLC_CGCG_CGLS_CTRL_3D                                                                        0x4cc5
#define regRLC_CGCG_CGLS_CTRL_3D_BASE_IDX                                                               1
#define regRLC_CGCG_RAMP_CTRL_3D                                                                        0x4cc6
#define regRLC_CGCG_RAMP_CTRL_3D_BASE_IDX                                                               1
#define regRLC_SEMAPHORE_0                                                                              0x4cc7
#define regRLC_SEMAPHORE_0_BASE_IDX                                                                     1
#define regRLC_SEMAPHORE_1                                                                              0x4cc8
#define regRLC_SEMAPHORE_1_BASE_IDX                                                                     1
#define regRLC_SEMAPHORE_2                                                                              0x4cc9
#define regRLC_SEMAPHORE_2_BASE_IDX                                                                     1
#define regRLC_SEMAPHORE_3                                                                              0x4cca
#define regRLC_SEMAPHORE_3_BASE_IDX                                                                     1
#define regRLC_SRM_UTCL1_CNTL                                                                           0x4ccc
#define regRLC_SRM_UTCL1_CNTL_BASE_IDX                                                                  1
#define regRLC_SRM_UTCL1_ERROR_1                                                                        0x4ccd
#define regRLC_SRM_UTCL1_ERROR_1_BASE_IDX                                                               1
#define regRLC_SRM_UTCL1_ERROR_2                                                                        0x4cce
#define regRLC_SRM_UTCL1_ERROR_2_BASE_IDX                                                               1
#define regRLC_UTCL1_STATUS                                                                             0x4cd4
#define regRLC_UTCL1_STATUS_BASE_IDX                                                                    1
#define regRLC_R2I_CNTL_0                                                                               0x4cd5
#define regRLC_R2I_CNTL_0_BASE_IDX                                                                      1
#define regRLC_R2I_CNTL_1                                                                               0x4cd6
#define regRLC_R2I_CNTL_1_BASE_IDX                                                                      1
#define regRLC_R2I_CNTL_2                                                                               0x4cd7
#define regRLC_R2I_CNTL_2_BASE_IDX                                                                      1
#define regRLC_R2I_CNTL_3                                                                               0x4cd8
#define regRLC_R2I_CNTL_3_BASE_IDX                                                                      1
#define regRLC_GPM_INT_STAT_TH0                                                                         0x4cdc
#define regRLC_GPM_INT_STAT_TH0_BASE_IDX                                                                1
#define regRLC_GPM_GENERAL_13                                                                           0x4cdd
#define regRLC_GPM_GENERAL_13_BASE_IDX                                                                  1
#define regRLC_GPM_GENERAL_14                                                                           0x4cde
#define regRLC_GPM_GENERAL_14_BASE_IDX                                                                  1
#define regRLC_GPM_GENERAL_15                                                                           0x4cdf
#define regRLC_GPM_GENERAL_15_BASE_IDX                                                                  1
#define regRLC_LX6_UTCL1_ERROR_1                                                                        0x4ce3
#define regRLC_LX6_UTCL1_ERROR_1_BASE_IDX                                                               1
#define regRLC_LX6_UTCL1_CNTL                                                                           0x4ce4
#define regRLC_LX6_UTCL1_CNTL_BASE_IDX                                                                  1
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_1                                                                0x4cea
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_1_BASE_IDX                                                       1
#define regRLC_GPU_CLOCK_COUNT_LSB_2                                                                    0x4ceb
#define regRLC_GPU_CLOCK_COUNT_LSB_2_BASE_IDX                                                           1
#define regRLC_GPU_CLOCK_COUNT_MSB_2                                                                    0x4cec
#define regRLC_GPU_CLOCK_COUNT_MSB_2_BASE_IDX                                                           1
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_2                                                                0x4cef
#define regRLC_CAPTURE_GPU_CLOCK_COUNT_2_BASE_IDX                                                       1
#define regRLC_GPU_CLOCK_COUNT_LSB_1                                                                    0x4cfb
#define regRLC_GPU_CLOCK_COUNT_LSB_1_BASE_IDX                                                           1
#define regRLC_GPU_CLOCK_COUNT_MSB_1                                                                    0x4cfc
#define regRLC_GPU_CLOCK_COUNT_MSB_1_BASE_IDX                                                           1
#define regRLC_RLCV_SPARE_INT                                                                           0x4d00
#define regRLC_RLCV_SPARE_INT_BASE_IDX                                                                  1
#define regRLC_SMU_CLK_REQ                                                                              0x4d08
#define regRLC_SMU_CLK_REQ_BASE_IDX                                                                     1
#define regRLC_SPARE                                                                                    0x4d0b
#define regRLC_SPARE_BASE_IDX                                                                           1
#define regRLC_SPP_CTRL                                                                                 0x4d0c
#define regRLC_SPP_CTRL_BASE_IDX                                                                        1
#define regRLC_SPP_SHADER_PROFILE_EN                                                                    0x4d0d
#define regRLC_SPP_SHADER_PROFILE_EN_BASE_IDX                                                           1
#define regRLC_SPP_SSF_CAPTURE_EN                                                                       0x4d0e
#define regRLC_SPP_SSF_CAPTURE_EN_BASE_IDX                                                              1
#define regRLC_SPP_SSF_THRESHOLD_0                                                                      0x4d0f
#define regRLC_SPP_SSF_THRESHOLD_0_BASE_IDX                                                             1
#define regRLC_SPP_SSF_THRESHOLD_1                                                                      0x4d10
#define regRLC_SPP_SSF_THRESHOLD_1_BASE_IDX                                                             1
#define regRLC_SPP_SSF_THRESHOLD_2                                                                      0x4d11
#define regRLC_SPP_SSF_THRESHOLD_2_BASE_IDX                                                             1
#define regRLC_SPP_INFLIGHT_RD_ADDR                                                                     0x4d12
#define regRLC_SPP_INFLIGHT_RD_ADDR_BASE_IDX                                                            1
#define regRLC_SPP_INFLIGHT_RD_DATA                                                                     0x4d13
#define regRLC_SPP_INFLIGHT_RD_DATA_BASE_IDX                                                            1
#define regRLC_SPP_PROF_INFO_1                                                                          0x4d18
#define regRLC_SPP_PROF_INFO_1_BASE_IDX                                                                 1
#define regRLC_SPP_PROF_INFO_2                                                                          0x4d19
#define regRLC_SPP_PROF_INFO_2_BASE_IDX                                                                 1
#define regRLC_SPP_GLOBAL_SH_ID                                                                         0x4d1a
#define regRLC_SPP_GLOBAL_SH_ID_BASE_IDX                                                                1
#define regRLC_SPP_GLOBAL_SH_ID_VALID                                                                   0x4d1b
#define regRLC_SPP_GLOBAL_SH_ID_VALID_BASE_IDX                                                          1
#define regRLC_SPP_STATUS                                                                               0x4d1c
#define regRLC_SPP_STATUS_BASE_IDX                                                                      1
#define regRLC_SPP_PVT_STAT_0                                                                           0x4d1d
#define regRLC_SPP_PVT_STAT_0_BASE_IDX                                                                  1
#define regRLC_SPP_PVT_STAT_1                                                                           0x4d1e
#define regRLC_SPP_PVT_STAT_1_BASE_IDX                                                                  1
#define regRLC_SPP_PVT_STAT_2                                                                           0x4d1f
#define regRLC_SPP_PVT_STAT_2_BASE_IDX                                                                  1
#define regRLC_SPP_PVT_STAT_3                                                                           0x4d20
#define regRLC_SPP_PVT_STAT_3_BASE_IDX                                                                  1
#define regRLC_SPP_PVT_LEVEL_MAX                                                                        0x4d21
#define regRLC_SPP_PVT_LEVEL_MAX_BASE_IDX                                                               1
#define regRLC_SPP_STALL_STATE_UPDATE                                                                   0x4d22
#define regRLC_SPP_STALL_STATE_UPDATE_BASE_IDX                                                          1
#define regRLC_SPP_PBB_INFO                                                                             0x4d23
#define regRLC_SPP_PBB_INFO_BASE_IDX                                                                    1
#define regRLC_SPP_RESET                                                                                0x4d24
#define regRLC_SPP_RESET_BASE_IDX                                                                       1
#define regRLC_CAC_MASK_CNTL                                                                            0x4d45
#define regRLC_CAC_MASK_CNTL_BASE_IDX                                                                   1
#define regRLC_POWER_RESIDENCY_CNTR_CTRL                                                                0x4d48
#define regRLC_POWER_RESIDENCY_CNTR_CTRL_BASE_IDX                                                       1
#define regRLC_CLK_RESIDENCY_CNTR_CTRL                                                                  0x4d49
#define regRLC_CLK_RESIDENCY_CNTR_CTRL_BASE_IDX                                                         1
#define regRLC_DS_RESIDENCY_CNTR_CTRL                                                                   0x4d4a
#define regRLC_DS_RESIDENCY_CNTR_CTRL_BASE_IDX                                                          1
#define regRLC_ULV_RESIDENCY_CNTR_CTRL                                                                  0x4d4b
#define regRLC_ULV_RESIDENCY_CNTR_CTRL_BASE_IDX                                                         1
#define regRLC_PCC_RESIDENCY_CNTR_CTRL                                                                  0x4d4c
#define regRLC_PCC_RESIDENCY_CNTR_CTRL_BASE_IDX                                                         1
#define regRLC_GENERAL_RESIDENCY_CNTR_CTRL                                                              0x4d4d
#define regRLC_GENERAL_RESIDENCY_CNTR_CTRL_BASE_IDX                                                     1
#define regRLC_POWER_RESIDENCY_EVENT_CNTR                                                               0x4d50
#define regRLC_POWER_RESIDENCY_EVENT_CNTR_BASE_IDX                                                      1
#define regRLC_CLK_RESIDENCY_EVENT_CNTR                                                                 0x4d51
#define regRLC_CLK_RESIDENCY_EVENT_CNTR_BASE_IDX                                                        1
#define regRLC_DS_RESIDENCY_EVENT_CNTR                                                                  0x4d52
#define regRLC_DS_RESIDENCY_EVENT_CNTR_BASE_IDX                                                         1
#define regRLC_ULV_RESIDENCY_EVENT_CNTR                                                                 0x4d53
#define regRLC_ULV_RESIDENCY_EVENT_CNTR_BASE_IDX                                                        1
#define regRLC_PCC_RESIDENCY_EVENT_CNTR                                                                 0x4d54
#define regRLC_PCC_RESIDENCY_EVENT_CNTR_BASE_IDX                                                        1
#define regRLC_GENERAL_RESIDENCY_EVENT_CNTR                                                             0x4d55
#define regRLC_GENERAL_RESIDENCY_EVENT_CNTR_BASE_IDX                                                    1
#define regRLC_POWER_RESIDENCY_REF_CNTR                                                                 0x4d58
#define regRLC_POWER_RESIDENCY_REF_CNTR_BASE_IDX                                                        1
#define regRLC_CLK_RESIDENCY_REF_CNTR                                                                   0x4d59
#define regRLC_CLK_RESIDENCY_REF_CNTR_BASE_IDX                                                          1
#define regRLC_DS_RESIDENCY_REF_CNTR                                                                    0x4d5a
#define regRLC_DS_RESIDENCY_REF_CNTR_BASE_IDX                                                           1
#define regRLC_ULV_RESIDENCY_REF_CNTR                                                                   0x4d5b
#define regRLC_ULV_RESIDENCY_REF_CNTR_BASE_IDX                                                          1
#define regRLC_PCC_RESIDENCY_REF_CNTR                                                                   0x4d5c
#define regRLC_PCC_RESIDENCY_REF_CNTR_BASE_IDX                                                          1
#define regRLC_GENERAL_RESIDENCY_REF_CNTR                                                               0x4d5d
#define regRLC_GENERAL_RESIDENCY_REF_CNTR_BASE_IDX                                                      1
#define regRLC_GFX_IH_CLIENT_CTRL                                                                       0x4d5e
#define regRLC_GFX_IH_CLIENT_CTRL_BASE_IDX                                                              1
#define regRLC_GFX_IH_ARBITER_STAT                                                                      0x4d5f
#define regRLC_GFX_IH_ARBITER_STAT_BASE_IDX                                                             1
#define regRLC_GFX_IH_CLIENT_SE_STAT_L                                                                  0x4d60
#define regRLC_GFX_IH_CLIENT_SE_STAT_L_BASE_IDX                                                         1
#define regRLC_GFX_IH_CLIENT_SE_STAT_H                                                                  0x4d61
#define regRLC_GFX_IH_CLIENT_SE_STAT_H_BASE_IDX                                                         1
#define regRLC_GFX_IH_CLIENT_SDMA_STAT                                                                  0x4d62
#define regRLC_GFX_IH_CLIENT_SDMA_STAT_BASE_IDX                                                         1
#define regRLC_GFX_IH_CLIENT_OTHER_STAT                                                                 0x4d63
#define regRLC_GFX_IH_CLIENT_OTHER_STAT_BASE_IDX                                                        1
#define regRLC_SPM_GLOBAL_DELAY_IND_ADDR                                                                0x4d64
#define regRLC_SPM_GLOBAL_DELAY_IND_ADDR_BASE_IDX                                                       1
#define regRLC_SPM_GLOBAL_DELAY_IND_DATA                                                                0x4d65
#define regRLC_SPM_GLOBAL_DELAY_IND_DATA_BASE_IDX                                                       1
#define regRLC_SPM_SE_DELAY_IND_ADDR                                                                    0x4d66
#define regRLC_SPM_SE_DELAY_IND_ADDR_BASE_IDX                                                           1
#define regRLC_SPM_SE_DELAY_IND_DATA                                                                    0x4d67
#define regRLC_SPM_SE_DELAY_IND_DATA_BASE_IDX                                                           1
#define regRLC_SPM_SE_BLK_EN_MASK_IND_ADDR                                                              0x4d6a
#define regRLC_SPM_SE_BLK_EN_MASK_IND_ADDR_BASE_IDX                                                     1
#define regRLC_SPM_SE_BLK_EN_MASK_IND_DATA                                                              0x4d6b
#define regRLC_SPM_SE_BLK_EN_MASK_IND_DATA_BASE_IDX                                                     1
#define regRLC_LX6_CNTL                                                                                 0x4d80
#define regRLC_LX6_CNTL_BASE_IDX                                                                        1
#define regRLC_LX6_STATUS                                                                               0x4d81
#define regRLC_LX6_STATUS_BASE_IDX                                                                      1
#define regRLC_LX6_FW_STATUS                                                                            0x4dcb
#define regRLC_LX6_FW_STATUS_BASE_IDX                                                                   1
#define regRLC_LX6_FW_VERSION                                                                           0x4dcc
#define regRLC_LX6_FW_VERSION_BASE_IDX                                                                  1
#define regRLC_XT_CORE_STATUS                                                                           0x4dd4
#define regRLC_XT_CORE_STATUS_BASE_IDX                                                                  1
#define regRLC_XT_CORE_INTERRUPT                                                                        0x4dd5
#define regRLC_XT_CORE_INTERRUPT_BASE_IDX                                                               1
#define regRLC_XT_CORE_FAULT_INFO                                                                       0x4dd6
#define regRLC_XT_CORE_FAULT_INFO_BASE_IDX                                                              1
#define regRLC_XT_CORE_ALT_RESET_VEC                                                                    0x4dd7
#define regRLC_XT_CORE_ALT_RESET_VEC_BASE_IDX                                                           1
#define regRLC_XT_CORE_RESERVED                                                                         0x4dd8
#define regRLC_XT_CORE_RESERVED_BASE_IDX                                                                1
#define regRLC_XT_INT_VEC_FORCE                                                                         0x4dd9
#define regRLC_XT_INT_VEC_FORCE_BASE_IDX                                                                1
#define regRLC_XT_INT_VEC_CLEAR                                                                         0x4dda
#define regRLC_XT_INT_VEC_CLEAR_BASE_IDX                                                                1
#define regRLC_XT_INT_VEC_MUX_SEL                                                                       0x4ddb
#define regRLC_XT_INT_VEC_MUX_SEL_BASE_IDX                                                              1
#define regRLC_XT_INT_VEC_MUX_INT_SEL                                                                   0x4ddc
#define regRLC_XT_INT_VEC_MUX_INT_SEL_BASE_IDX                                                          1
#define regRLC_GPU_CLOCK_COUNT_SPM_LSB                                                                  0x4de4
#define regRLC_GPU_CLOCK_COUNT_SPM_LSB_BASE_IDX                                                         1
#define regRLC_GPU_CLOCK_COUNT_SPM_MSB                                                                  0x4de5
#define regRLC_GPU_CLOCK_COUNT_SPM_MSB_BASE_IDX                                                         1
#define regRLC_SPM_THREAD_TRACE_CTRL                                                                    0x4de6
#define regRLC_SPM_THREAD_TRACE_CTRL_BASE_IDX                                                           1
#define regRLC_SPP_CAM_ADDR                                                                             0x4de8
#define regRLC_SPP_CAM_ADDR_BASE_IDX                                                                    1
#define regRLC_SPP_CAM_DATA                                                                             0x4de9
#define regRLC_SPP_CAM_DATA_BASE_IDX                                                                    1
#define regRLC_SPP_CAM_EXT_ADDR                                                                         0x4dea
#define regRLC_SPP_CAM_EXT_ADDR_BASE_IDX                                                                1
#define regRLC_SPP_CAM_EXT_DATA                                                                         0x4deb
#define regRLC_SPP_CAM_EXT_DATA_BASE_IDX                                                                1
#define regRLC_CPAXI_DOORBELL_MON_CTRL                                                                  0x4df1
#define regRLC_CPAXI_DOORBELL_MON_CTRL_BASE_IDX                                                         1
#define regRLC_CPAXI_DOORBELL_MON_STAT                                                                  0x4df2
#define regRLC_CPAXI_DOORBELL_MON_STAT_BASE_IDX                                                         1
#define regRLC_CPAXI_DOORBELL_MON_DATA_LSB                                                              0x4df3
#define regRLC_CPAXI_DOORBELL_MON_DATA_LSB_BASE_IDX                                                     1
#define regRLC_CPAXI_DOORBELL_MON_DATA_MSB                                                              0x4df4
#define regRLC_CPAXI_DOORBELL_MON_DATA_MSB_BASE_IDX                                                     1
#define regRLC_XT_DOORBELL_RANGE                                                                        0x4df5
#define regRLC_XT_DOORBELL_RANGE_BASE_IDX                                                               1
#define regRLC_XT_DOORBELL_CNTL                                                                         0x4df6
#define regRLC_XT_DOORBELL_CNTL_BASE_IDX                                                                1
#define regRLC_XT_DOORBELL_STAT                                                                         0x4df7
#define regRLC_XT_DOORBELL_STAT_BASE_IDX                                                                1
#define regRLC_XT_DOORBELL_0_DATA_LO                                                                    0x4df8
#define regRLC_XT_DOORBELL_0_DATA_LO_BASE_IDX                                                           1
#define regRLC_XT_DOORBELL_0_DATA_HI                                                                    0x4df9
#define regRLC_XT_DOORBELL_0_DATA_HI_BASE_IDX                                                           1
#define regRLC_XT_DOORBELL_1_DATA_LO                                                                    0x4dfa
#define regRLC_XT_DOORBELL_1_DATA_LO_BASE_IDX                                                           1
#define regRLC_XT_DOORBELL_1_DATA_HI                                                                    0x4dfb
#define regRLC_XT_DOORBELL_1_DATA_HI_BASE_IDX                                                           1
#define regRLC_XT_DOORBELL_2_DATA_LO                                                                    0x4dfc
#define regRLC_XT_DOORBELL_2_DATA_LO_BASE_IDX                                                           1
#define regRLC_XT_DOORBELL_2_DATA_HI                                                                    0x4dfd
#define regRLC_XT_DOORBELL_2_DATA_HI_BASE_IDX                                                           1
#define regRLC_XT_DOORBELL_3_DATA_LO                                                                    0x4dfe
#define regRLC_XT_DOORBELL_3_DATA_LO_BASE_IDX                                                           1
#define regRLC_XT_DOORBELL_3_DATA_HI                                                                    0x4dff
#define regRLC_XT_DOORBELL_3_DATA_HI_BASE_IDX                                                           1
#define regRLC_MEM_SLP_CNTL                                                                             0x4e00
#define regRLC_MEM_SLP_CNTL_BASE_IDX                                                                    1
#define regRLC_RLCV_SAFE_MODE                                                                           0x4e02
#define regRLC_RLCV_SAFE_MODE_BASE_IDX                                                                  1
#define regRLC_SMU_SAFE_MODE                                                                            0x4e03
#define regRLC_SMU_SAFE_MODE_BASE_IDX                                                                   1
#define regRLC_RLCV_COMMAND                                                                             0x4e04
#define regRLC_RLCV_COMMAND_BASE_IDX                                                                    1
#define regRLC_SMU_MESSAGE                                                                              0x4e05
#define regRLC_SMU_MESSAGE_BASE_IDX                                                                     1
#define regRLC_SMU_MESSAGE_1                                                                            0x4e06
#define regRLC_SMU_MESSAGE_1_BASE_IDX                                                                   1
#define regRLC_SMU_MESSAGE_2                                                                            0x4e07
#define regRLC_SMU_MESSAGE_2_BASE_IDX                                                                   1
#define regRLC_SRM_GPM_COMMAND                                                                          0x4e08
#define regRLC_SRM_GPM_COMMAND_BASE_IDX                                                                 1
#define regRLC_SRM_GPM_ABORT                                                                            0x4e09
#define regRLC_SRM_GPM_ABORT_BASE_IDX                                                                   1
#define regRLC_SMU_COMMAND                                                                              0x4e0a
#define regRLC_SMU_COMMAND_BASE_IDX                                                                     1
#define regRLC_SMU_ARGUMENT_1                                                                           0x4e0b
#define regRLC_SMU_ARGUMENT_1_BASE_IDX                                                                  1
#define regRLC_SMU_ARGUMENT_2                                                                           0x4e0c
#define regRLC_SMU_ARGUMENT_2_BASE_IDX                                                                  1
#define regRLC_SMU_ARGUMENT_3                                                                           0x4e0d
#define regRLC_SMU_ARGUMENT_3_BASE_IDX                                                                  1
#define regRLC_SMU_ARGUMENT_4                                                                           0x4e0e
#define regRLC_SMU_ARGUMENT_4_BASE_IDX                                                                  1
#define regRLC_SMU_ARGUMENT_5                                                                           0x4e0f
#define regRLC_SMU_ARGUMENT_5_BASE_IDX                                                                  1
#define regRLC_IMU_BOOTLOAD_ADDR_HI                                                                     0x4e10
#define regRLC_IMU_BOOTLOAD_ADDR_HI_BASE_IDX                                                            1
#define regRLC_IMU_BOOTLOAD_ADDR_LO                                                                     0x4e11
#define regRLC_IMU_BOOTLOAD_ADDR_LO_BASE_IDX                                                            1
#define regRLC_IMU_BOOTLOAD_SIZE                                                                        0x4e12
#define regRLC_IMU_BOOTLOAD_SIZE_BASE_IDX                                                               1
#define regRLC_IMU_MISC                                                                                 0x4e16
#define regRLC_IMU_MISC_BASE_IDX                                                                        1
#define regRLC_IMU_RESET_VECTOR                                                                         0x4e17
#define regRLC_IMU_RESET_VECTOR_BASE_IDX                                                                1


// addressBlock: gc_gfx_cpwd_cpwd_rlcsdec
// base address: 0x3b980
#define regRLC_RLCS_DEC_START                                                                           0x4e60
#define regRLC_RLCS_DEC_START_BASE_IDX                                                                  1
#define regRLC_RLCS_DEC_DUMP_ADDR                                                                       0x4e61
#define regRLC_RLCS_DEC_DUMP_ADDR_BASE_IDX                                                              1
#define regRLC_RLCS_EXCEPTION_REG_1                                                                     0x4e62
#define regRLC_RLCS_EXCEPTION_REG_1_BASE_IDX                                                            1
#define regRLC_RLCS_EXCEPTION_REG_2                                                                     0x4e63
#define regRLC_RLCS_EXCEPTION_REG_2_BASE_IDX                                                            1
#define regRLC_RLCS_EXCEPTION_REG_3                                                                     0x4e64
#define regRLC_RLCS_EXCEPTION_REG_3_BASE_IDX                                                            1
#define regRLC_RLCS_EXCEPTION_REG_4                                                                     0x4e65
#define regRLC_RLCS_EXCEPTION_REG_4_BASE_IDX                                                            1
#define regRLC_RLCS_CGCG_REQUEST                                                                        0x4e67
#define regRLC_RLCS_CGCG_REQUEST_BASE_IDX                                                               1
#define regRLC_RLCS_CGCG_STATUS                                                                         0x4e68
#define regRLC_RLCS_CGCG_STATUS_BASE_IDX                                                                1
#define regRLC_RLCS_SOC_DS_CNTL                                                                         0x4e69
#define regRLC_RLCS_SOC_DS_CNTL_BASE_IDX                                                                1
#define regRLC_RLCS_GFX_DS_CNTL                                                                         0x4e6a
#define regRLC_RLCS_GFX_DS_CNTL_BASE_IDX                                                                1
#define regRLC_RLCS_GFX_DS_ALLOW_MASK_CNTL                                                              0x4e6b
#define regRLC_RLCS_GFX_DS_ALLOW_MASK_CNTL_BASE_IDX                                                     1
#define regRLC_GPM_STAT                                                                                 0x4e6c
#define regRLC_GPM_STAT_BASE_IDX                                                                        1
#define regRLC_RLCS_GPM_STAT                                                                            0x4e6c
#define regRLC_RLCS_GPM_STAT_BASE_IDX                                                                   1
#define regRLC_RLCS_ABORTED_PD_SEQUENCE                                                                 0x4e6d
#define regRLC_RLCS_ABORTED_PD_SEQUENCE_BASE_IDX                                                        1
#define regRLC_RLCS_GPM_STAT_2                                                                          0x4e6e
#define regRLC_RLCS_GPM_STAT_2_BASE_IDX                                                                 1
#define regRLC_RLCS_GRBM_SOFT_RESET                                                                     0x4e6f
#define regRLC_RLCS_GRBM_SOFT_RESET_BASE_IDX                                                            1
#define regRLC_RLCS_PG_CHANGE_STATUS                                                                    0x4e70
#define regRLC_RLCS_PG_CHANGE_STATUS_BASE_IDX                                                           1
#define regRLC_RLCS_PG_CHANGE_READ                                                                      0x4e71
#define regRLC_RLCS_PG_CHANGE_READ_BASE_IDX                                                             1
#define regRLC_RLCS_IH_SEMAPHORE                                                                        0x4e72
#define regRLC_RLCS_IH_SEMAPHORE_BASE_IDX                                                               1
#define regRLC_RLCS_IH_COOKIE_SEMAPHORE                                                                 0x4e73
#define regRLC_RLCS_IH_COOKIE_SEMAPHORE_BASE_IDX                                                        1
#define regRLC_RLCS_CP_INT_CTRL_1                                                                       0x4e74
#define regRLC_RLCS_CP_INT_CTRL_1_BASE_IDX                                                              1
#define regRLC_RLCS_CP_INT_CTRL_2                                                                       0x4e75
#define regRLC_RLCS_CP_INT_CTRL_2_BASE_IDX                                                              1
#define regRLC_RLCS_CP_INT_INFO_1                                                                       0x4e76
#define regRLC_RLCS_CP_INT_INFO_1_BASE_IDX                                                              1
#define regRLC_RLCS_CP_INT_INFO_2                                                                       0x4e77
#define regRLC_RLCS_CP_INT_INFO_2_BASE_IDX                                                              1
#define regRLC_RLCS_SPM_INT_CTRL                                                                        0x4e78
#define regRLC_RLCS_SPM_INT_CTRL_BASE_IDX                                                               1
#define regRLC_RLCS_SPM_INT_INFO_1                                                                      0x4e79
#define regRLC_RLCS_SPM_INT_INFO_1_BASE_IDX                                                             1
#define regRLC_RLCS_SPM_INT_INFO_2                                                                      0x4e7a
#define regRLC_RLCS_SPM_INT_INFO_2_BASE_IDX                                                             1
#define regRLC_RLCS_DSM_TRIG                                                                            0x4e7b
#define regRLC_RLCS_BOOTLOAD_STATUS                                                                     0x4e7c
#define regRLC_RLCS_BOOTLOAD_STATUS_BASE_IDX                                                            1
#define regRLC_RLCS_GRBM_IDLE_BUSY_STAT                                                                 0x4e7d
#define regRLC_RLCS_GRBM_IDLE_BUSY_STAT_BASE_IDX                                                        1
#define regRLC_RLCS_GRBM_IDLE_BUSY_INT_CNTL                                                             0x4e7e
#define regRLC_RLCS_GRBM_IDLE_BUSY_INT_CNTL_BASE_IDX                                                    1
#define regRLC_RLCS_CMP_IDLE_CNTL                                                                       0x4e7f
#define regRLC_RLCS_CMP_IDLE_CNTL_BASE_IDX                                                              1
#define regRLC_RLCS_GENERAL_0                                                                           0x4e80
#define regRLC_RLCS_GENERAL_0_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_1                                                                           0x4e81
#define regRLC_RLCS_GENERAL_1_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_2                                                                           0x4e82
#define regRLC_RLCS_GENERAL_2_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_3                                                                           0x4e83
#define regRLC_RLCS_GENERAL_3_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_4                                                                           0x4e84
#define regRLC_RLCS_GENERAL_4_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_5                                                                           0x4e85
#define regRLC_RLCS_GENERAL_5_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_6                                                                           0x4e86
#define regRLC_RLCS_GENERAL_6_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_7                                                                           0x4e87
#define regRLC_RLCS_GENERAL_7_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_8                                                                           0x4e88
#define regRLC_RLCS_GENERAL_8_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_9                                                                           0x4e89
#define regRLC_RLCS_GENERAL_9_BASE_IDX                                                                  1
#define regRLC_RLCS_GENERAL_10                                                                          0x4e8a
#define regRLC_RLCS_GENERAL_10_BASE_IDX                                                                 1
#define regRLC_RLCS_GENERAL_11                                                                          0x4e8b
#define regRLC_RLCS_GENERAL_11_BASE_IDX                                                                 1
#define regRLC_RLCS_GENERAL_12                                                                          0x4e8c
#define regRLC_RLCS_GENERAL_12_BASE_IDX                                                                 1
#define regRLC_RLCS_GENERAL_13                                                                          0x4e8d
#define regRLC_RLCS_GENERAL_13_BASE_IDX                                                                 1
#define regRLC_RLCS_GENERAL_14                                                                          0x4e8e
#define regRLC_RLCS_GENERAL_14_BASE_IDX                                                                 1
#define regRLC_RLCS_GENERAL_15                                                                          0x4e8f
#define regRLC_RLCS_GENERAL_15_BASE_IDX                                                                 1
#define regRLC_RLCS_GENERAL_16                                                                          0x4e90
#define regRLC_RLCS_GENERAL_16_BASE_IDX                                                                 1
#define regRLC_RLCS_AUXILIARY_REG_1                                                                     0x4ebd
#define regRLC_RLCS_AUXILIARY_REG_1_BASE_IDX                                                            1
#define regRLC_RLCS_AUXILIARY_REG_2                                                                     0x4ebe
#define regRLC_RLCS_AUXILIARY_REG_2_BASE_IDX                                                            1
#define regRLC_RLCS_AUXILIARY_REG_3                                                                     0x4ebf
#define regRLC_RLCS_AUXILIARY_REG_3_BASE_IDX                                                            1
#define regRLC_RLCS_AUXILIARY_REG_4                                                                     0x4ec0
#define regRLC_RLCS_AUXILIARY_REG_4_BASE_IDX                                                            1
#define regRLC_RLCS_SPM_SQTT_MODE                                                                       0x4ec1
#define regRLC_RLCS_SPM_SQTT_MODE_BASE_IDX                                                              1
#define regRLC_RLCS_CP_DMA_SRCID_OVER                                                                   0x4ec2
#define regRLC_RLCS_CP_DMA_SRCID_OVER_BASE_IDX                                                          1
#define regRLC_RLCS_BOOTLOAD_ID_STATUS1                                                                 0x4ec3
#define regRLC_RLCS_BOOTLOAD_ID_STATUS1_BASE_IDX                                                        1
#define regRLC_RLCS_BOOTLOAD_ID_STATUS2                                                                 0x4ec4
#define regRLC_RLCS_BOOTLOAD_ID_STATUS2_BASE_IDX                                                        1
#define regRLC_RLCS_IMU_VIDCHG_CNTL                                                                     0x4ec5
#define regRLC_RLCS_IMU_VIDCHG_CNTL_BASE_IDX                                                            1
#define regRLC_RLCS_KMD_LOG_CNTL1                                                                       0x4ec6
#define regRLC_RLCS_KMD_LOG_CNTL1_BASE_IDX                                                              1
#define regRLC_RLCS_KMD_LOG_CNTL2                                                                       0x4ec7
#define regRLC_RLCS_KMD_LOG_CNTL2_BASE_IDX                                                              1
#define regRLC_RLCS_GPM_LEGACY_INT_STAT                                                                 0x4ec8
#define regRLC_RLCS_GPM_LEGACY_INT_STAT_BASE_IDX                                                        1
#define regRLC_RLCS_GPM_LEGACY_INT_DISABLE                                                              0x4ec9
#define regRLC_RLCS_GPM_LEGACY_INT_DISABLE_BASE_IDX                                                     1
#define regRLC_RLCS_GCR_DATA_0                                                                          0x4ed0
#define regRLC_RLCS_GCR_DATA_0_BASE_IDX                                                                 1
#define regRLC_RLCS_GCR_DATA_1                                                                          0x4ed1
#define regRLC_RLCS_GCR_DATA_1_BASE_IDX                                                                 1
#define regRLC_RLCS_GCR_DATA_2                                                                          0x4ed2
#define regRLC_RLCS_GCR_DATA_2_BASE_IDX                                                                 1
#define regRLC_RLCS_GCR_DATA_3                                                                          0x4ed3
#define regRLC_RLCS_GCR_DATA_3_BASE_IDX                                                                 1
#define regRLC_RLCS_GCR_STATUS                                                                          0x4ed4
#define regRLC_RLCS_GCR_STATUS_BASE_IDX                                                                 1
#define regRLC_RLCS_PERFMON_CLK_CNTL_UCODE                                                              0x4ed5
#define regRLC_RLCS_PERFMON_CLK_CNTL_UCODE_BASE_IDX                                                     1
#define regRLC_RLCS_UTCL2_CNTL                                                                          0x4ed6
#define regRLC_RLCS_UTCL2_CNTL_BASE_IDX                                                                 1
#define regRLC_RLCS_IMU_RLC_MSG_DATA0                                                                   0x4ed7
#define regRLC_RLCS_IMU_RLC_MSG_DATA0_BASE_IDX                                                          1
#define regRLC_RLCS_IMU_RLC_MSG_DATA1                                                                   0x4ed8
#define regRLC_RLCS_IMU_RLC_MSG_DATA1_BASE_IDX                                                          1
#define regRLC_RLCS_IMU_RLC_MSG_DATA2                                                                   0x4ed9
#define regRLC_RLCS_IMU_RLC_MSG_DATA2_BASE_IDX                                                          1
#define regRLC_RLCS_IMU_RLC_MSG_DATA3                                                                   0x4eda
#define regRLC_RLCS_IMU_RLC_MSG_DATA3_BASE_IDX                                                          1
#define regRLC_RLCS_IMU_RLC_MSG_DATA4                                                                   0x4edb
#define regRLC_RLCS_IMU_RLC_MSG_DATA4_BASE_IDX                                                          1
#define regRLC_RLCS_IMU_RLC_MSG_CONTROL                                                                 0x4edc
#define regRLC_RLCS_IMU_RLC_MSG_CONTROL_BASE_IDX                                                        1
#define regRLC_RLCS_IMU_RLC_MSG_CNTL                                                                    0x4edd
#define regRLC_RLCS_IMU_RLC_MSG_CNTL_BASE_IDX                                                           1
#define regRLC_RLCS_RLC_IMU_MSG_DATA0                                                                   0x4ede
#define regRLC_RLCS_RLC_IMU_MSG_DATA0_BASE_IDX                                                          1
#define regRLC_RLCS_RLC_IMU_MSG_CONTROL                                                                 0x4edf
#define regRLC_RLCS_RLC_IMU_MSG_CONTROL_BASE_IDX                                                        1
#define regRLC_RLCS_RLC_IMU_MSG_CNTL                                                                    0x4ee0
#define regRLC_RLCS_RLC_IMU_MSG_CNTL_BASE_IDX                                                           1
#define regRLC_RLCS_IMU_RLC_TELEMETRY_DATA_0                                                            0x4ee1
#define regRLC_RLCS_IMU_RLC_TELEMETRY_DATA_0_BASE_IDX                                                   1
#define regRLC_RLCS_IMU_RLC_TELEMETRY_DATA_1                                                            0x4ee2
#define regRLC_RLCS_IMU_RLC_TELEMETRY_DATA_1_BASE_IDX                                                   1
#define regRLC_RLCS_IMU_RLC_MUTEX_CNTL                                                                  0x4ee3
#define regRLC_RLCS_IMU_RLC_MUTEX_CNTL_BASE_IDX                                                         1
#define regRLC_RLCS_IMU_RLC_STATUS                                                                      0x4ee4
#define regRLC_RLCS_IMU_RLC_STATUS_BASE_IDX                                                             1
#define regRLC_RLCS_RLC_IMU_STATUS                                                                      0x4ee5
#define regRLC_RLCS_RLC_IMU_STATUS_BASE_IDX                                                             1
#define regRLC_RLCS_IMU_RAM_DATA_1                                                                      0x4ee6
#define regRLC_RLCS_IMU_RAM_DATA_1_BASE_IDX                                                             1
#define regRLC_RLCS_IMU_RAM_ADDR_1_LSB                                                                  0x4ee7
#define regRLC_RLCS_IMU_RAM_ADDR_1_LSB_BASE_IDX                                                         1
#define regRLC_RLCS_IMU_RAM_ADDR_1_MSB                                                                  0x4ee8
#define regRLC_RLCS_IMU_RAM_ADDR_1_MSB_BASE_IDX                                                         1
#define regRLC_RLCS_IMU_RAM_DATA_0                                                                      0x4ee9
#define regRLC_RLCS_IMU_RAM_DATA_0_BASE_IDX                                                             1
#define regRLC_RLCS_IMU_RAM_ADDR_0_LSB                                                                  0x4eea
#define regRLC_RLCS_IMU_RAM_ADDR_0_LSB_BASE_IDX                                                         1
#define regRLC_RLCS_IMU_RAM_ADDR_0_MSB                                                                  0x4eeb
#define regRLC_RLCS_IMU_RAM_ADDR_0_MSB_BASE_IDX                                                         1
#define regRLC_RLCS_IMU_RAM_CNTL                                                                        0x4eec
#define regRLC_RLCS_IMU_RAM_CNTL_BASE_IDX                                                               1
#define regRLC_RLCS_IMU_GFX_DOORBELL_FENCE                                                              0x4eed
#define regRLC_RLCS_IMU_GFX_DOORBELL_FENCE_BASE_IDX                                                     1
#define regRLC_RLCS_SDMA_INT_CNTL_1                                                                     0x4eef
#define regRLC_RLCS_SDMA_INT_CNTL_1_BASE_IDX                                                            1
#define regRLC_RLCS_SDMA_INT_CNTL_2                                                                     0x4ef0
#define regRLC_RLCS_SDMA_INT_CNTL_2_BASE_IDX                                                            1
#define regRLC_RLCS_SDMA_INT_STAT                                                                       0x4ef1
#define regRLC_RLCS_SDMA_INT_STAT_BASE_IDX                                                              1
#define regRLC_RLCS_SDMA_INT_INFO                                                                       0x4ef2
#define regRLC_RLCS_SDMA_INT_INFO_BASE_IDX                                                              1
#define regRLC_RLCS_GFX_MEM_POWER_CTRL_0                                                                0x4ef3
#define regRLC_RLCS_GFX_MEM_POWER_CTRL_0_BASE_IDX                                                       1
#define regRLC_RLCS_GFX_MEM_POWER_CTRL_1                                                                0x4ef4
#define regRLC_RLCS_GFX_MEM_POWER_CTRL_1_BASE_IDX                                                       1
#define regRLC_RLCS_GFX_MEM_POWER_CTRL_2                                                                0x4ef5
#define regRLC_RLCS_GFX_MEM_POWER_CTRL_2_BASE_IDX                                                       1
#define regRLC_RLCS_SE_PWR_CTRL                                                                         0x4eff
#define regRLC_RLCS_SE_PWR_CTRL_BASE_IDX                                                                1
#define regRLC_RLCS_UTCL2_BUSY_CNTL                                                                     0x4f72
#define regRLC_RLCS_UTCL2_BUSY_CNTL_BASE_IDX                                                            1
#define regRLC_RLCS_UTCL2_BUSY_STAT                                                                     0x4f73
#define regRLC_RLCS_UTCL2_BUSY_STAT_BASE_IDX                                                            1
#define regRLC_RLCS_DEC_END                                                                             0x4fff
#define regRLC_RLCS_DEC_END_BASE_IDX                                                                    1


// addressBlock: gc_gfx_cpwd_cpwd_pfvfdec_rlc
// base address: 0x2a600
#define regRLC_SAFE_MODE                                                                                0x0980
#define regRLC_SAFE_MODE_BASE_IDX                                                                       1
#define regRLC_SPM_SAMPLE_CNT                                                                           0x0981
#define regRLC_SPM_SAMPLE_CNT_BASE_IDX                                                                  1
#define regRLC_SPM_MC_CNTL                                                                              0x0982
#define regRLC_SPM_MC_CNTL_BASE_IDX                                                                     1
#define regRLC_SPM_INT_CNTL                                                                             0x0983
#define regRLC_SPM_INT_CNTL_BASE_IDX                                                                    1
#define regRLC_SPM_INT_STATUS                                                                           0x0984
#define regRLC_SPM_INT_STATUS_BASE_IDX                                                                  1
#define regRLC_SPM_INT_INFO_1                                                                           0x0985
#define regRLC_SPM_INT_INFO_1_BASE_IDX                                                                  1
#define regRLC_SPM_INT_INFO_2                                                                           0x0986
#define regRLC_SPM_INT_INFO_2_BASE_IDX                                                                  1
#define regRLC_CSIB_ADDR_LO                                                                             0x0987
#define regRLC_CSIB_ADDR_LO_BASE_IDX                                                                    1
#define regRLC_CSIB_ADDR_HI                                                                             0x0988
#define regRLC_CSIB_ADDR_HI_BASE_IDX                                                                    1
#define regRLC_CSIB_LENGTH                                                                              0x0989
#define regRLC_CSIB_LENGTH_BASE_IDX                                                                     1
#define regRLC_CP_SCHEDULERS                                                                            0x098a
#define regRLC_CP_SCHEDULERS_BASE_IDX                                                                   1
#define regRLC_CP_EOF_INT                                                                               0x098b
#define regRLC_CP_EOF_INT_BASE_IDX                                                                      1
#define regRLC_CP_EOF_INT_CNTL                                                                          0x098c
#define regRLC_CP_EOF_INT_CNTL_BASE_IDX                                                                 1
#define regRLC_SPARE_INT_0                                                                              0x098d
#define regRLC_SPARE_INT_0_BASE_IDX                                                                     1
#define regRLC_SPARE_INT_1                                                                              0x098e
#define regRLC_SPARE_INT_1_BASE_IDX                                                                     1
#define regRLC_SPARE_INT_2                                                                              0x098f
#define regRLC_SPARE_INT_2_BASE_IDX                                                                     1
#define regRLC_RLCV_SPARE_INT_1                                                                         0x0992
#define regRLC_RLCV_SPARE_INT_1_BASE_IDX                                                                1


// addressBlock: gc_gfx_cpwd_cpwd_pwrdec
// base address: 0x3c000
#define regCC_GC_GL2C_DISABLE_0                                                                         0x5007
#define regCC_GC_GL2C_DISABLE_0_BASE_IDX                                                                1
#define regCC_GC_GL2C_DISABLE_1                                                                         0x5008
#define regCC_GC_GL2C_DISABLE_1_BASE_IDX                                                                1
#define regCGTT_IA_CLK_CTRL                                                                             0x5085
#define regCGTT_IA_CLK_CTRL_BASE_IDX                                                                    1
#define regCGTT_WD_CLK_CTRL                                                                             0x5086
#define regCGTT_WD_CLK_CTRL_BASE_IDX                                                                    1
#define regGFX_ICG_GL2A_CTRL                                                                            0x50ac
#define regGFX_ICG_GL2A_CTRL_BASE_IDX                                                                   1
#define regCGTT_CP_CLK_CTRL                                                                             0x50b0
#define regCGTT_CP_CLK_CTRL_BASE_IDX                                                                    1
#define regCGTT_CPF_CLK_CTRL                                                                            0x50b1
#define regCGTT_CPF_CLK_CTRL_BASE_IDX                                                                   1
#define regCGTT_CPC_CLK_CTRL                                                                            0x50b2
#define regCGTT_CPC_CLK_CTRL_BASE_IDX                                                                   1
#define regCGTT_RLC_CLK_CTRL                                                                            0x50b5
#define regCGTT_RLC_CLK_CTRL_BASE_IDX                                                                   1
#define regGFX_ICG_GCR_CTRL                                                                             0x50c2
#define regGFX_ICG_GCR_CTRL_BASE_IDX                                                                    1
#define regGC_EA_CPWD_ICG_CTRL                                                                          0x50c4
#define regGC_EA_CPWD_ICG_CTRL_BASE_IDX                                                                 1
#define regGFX_ICG_GC_CAC_CLK_CTRL                                                                      0x50d8
#define regGFX_ICG_GC_CAC_CLK_CTRL_BASE_IDX                                                             1
#define regGFX_ICG_GRBM_CTRL                                                                            0x50e0
#define regGFX_ICG_GRBM_CTRL_BASE_IDX                                                                   1
#define regGFX_ICG_GL2C_CTRL                                                                            0x50fc
#define regGFX_ICG_GL2C_CTRL_BASE_IDX                                                                   1
#define regGFX_ICG_GL2C_CTRL1                                                                           0x50fd
#define regGFX_ICG_GL2C_CTRL1_BASE_IDX                                                                  1


// addressBlock: gc_gfx_cpwd_cpwd_pspdec
// base address: 0x3f000
#define regCP_MES_DM_INDEX_ADDR                                                                         0x5c00
#define regCP_MES_DM_INDEX_ADDR_BASE_IDX                                                                1
#define regCP_MES_DM_INDEX_DATA                                                                         0x5c01
#define regCP_MES_DM_INDEX_DATA_BASE_IDX                                                                1
#define regCP_MEC_DM_INDEX_ADDR                                                                         0x5c02
#define regCP_MEC_DM_INDEX_ADDR_BASE_IDX                                                                1
#define regCP_MEC_DM_INDEX_DATA                                                                         0x5c03
#define regCP_MEC_DM_INDEX_DATA_BASE_IDX                                                                1
#define regCP_GFX_RS64_DM_INDEX_ADDR                                                                    0x5c04
#define regCP_GFX_RS64_DM_INDEX_ADDR_BASE_IDX                                                           1
#define regCP_GFX_RS64_DM_INDEX_DATA                                                                    0x5c05
#define regCP_GFX_RS64_DM_INDEX_DATA_BASE_IDX                                                           1
#define regCPG_PSP_DEBUG                                                                                0x5c10
#define regCPG_PSP_DEBUG_BASE_IDX                                                                       1
#define regCPC_PSP_DEBUG                                                                                0x5c11
#define regCPC_PSP_DEBUG_BASE_IDX                                                                       1
#define regGC_EA_CPWD_SECURE_CTRL                                                                       0x5c40
#define regGC_EA_CPWD_SECURE_CTRL_BASE_IDX                                                              1
#define regGC_EA_CPWD_SDP_SECLEVEL_NONIO_MAP0                                                           0x5c41
#define regGC_EA_CPWD_SDP_SECLEVEL_NONIO_MAP0_BASE_IDX                                                  1
#define regGC_EA_CPWD_SDP_SECLEVEL_NONIO_MAP1                                                           0x5c42
#define regGC_EA_CPWD_SDP_SECLEVEL_NONIO_MAP1_BASE_IDX                                                  1
#define regGC_EA_CPWD_SDP_SECLEVEL_IO_MAP0                                                              0x5c43
#define regGC_EA_CPWD_SDP_SECLEVEL_IO_MAP0_BASE_IDX                                                     1
#define regGC_EA_CPWD_SDP_SECLEVEL_IO_MAP1                                                              0x5c44
#define regGC_EA_CPWD_SDP_SECLEVEL_IO_MAP1_BASE_IDX                                                     1
#define regGRBM_SEC_CNTL                                                                                0x5e0d
#define regGRBM_SEC_CNTL_BASE_IDX                                                                       1
#define regGRBM_CAM_INDEX                                                                               0x5e10
#define regGRBM_CAM_INDEX_BASE_IDX                                                                      1
#define regGRBM_CAM_DATA                                                                                0x5e11
#define regGRBM_CAM_DATA_BASE_IDX                                                                       1
#define regGRBM_CAM_DATA_UPPER                                                                          0x5e12
#define regGRBM_CAM_DATA_UPPER_BASE_IDX                                                                 1
#define regRLC_REG_SEC_INT_STATUS                                                                       0x5f3d
#define regRLC_REG_SEC_INT_STATUS_BASE_IDX                                                              1
#define regRLC_UTC_BYPASS_CNTL                                                                          0x5f42
#define regRLC_UTC_BYPASS_CNTL_BASE_IDX                                                                 1


// addressBlock: gc_gfx_cpwd_cpwd_ch_pwrdec
// base address: 0x3c3b0
#define regCHI_CHR_MGCG_OVERRIDE                                                                        0x50ec
#define regCHI_CHR_MGCG_OVERRIDE_BASE_IDX                                                               1
#define regICG_CHA_CTRL                                                                                 0x50ed
#define regICG_CHA_CTRL_BASE_IDX                                                                        1
#define regICG_CHC_CLK_CTRL                                                                             0x50ee
#define regICG_CHC_CLK_CTRL_BASE_IDX                                                                    1


// addressBlock: gc_gfx_cpwd_gfx_imu_cpwd_gfx_imudec
// base address: 0x38000
#define regGFX_IMU_C2PMSG_16                                                                            0x4010
#define regGFX_IMU_C2PMSG_16_BASE_IDX                                                                   1
#define regGFX_IMU_C2PMSG_ACCESS_CTRL0                                                                  0x4040
#define regGFX_IMU_C2PMSG_ACCESS_CTRL0_BASE_IDX                                                         1
#define regGFX_IMU_C2PMSG_ACCESS_CTRL1                                                                  0x4041
#define regGFX_IMU_C2PMSG_ACCESS_CTRL1_BASE_IDX                                                         1
#define regGFX_IMU_SCRATCH_10                                                                           0x4072
#define regGFX_IMU_SCRATCH_10_BASE_IDX                                                                  1
#define regGFX_IMU_RLC_RAM_INDEX                                                                        0x40ac
#define regGFX_IMU_RLC_RAM_INDEX_BASE_IDX                                                               1
#define regGFX_IMU_RLC_RAM_ADDR_HIGH                                                                    0x40ad
#define regGFX_IMU_RLC_RAM_ADDR_HIGH_BASE_IDX                                                           1
#define regGFX_IMU_RLC_RAM_ADDR_LOW                                                                     0x40ae
#define regGFX_IMU_RLC_RAM_ADDR_LOW_BASE_IDX                                                            1
#define regGFX_IMU_RLC_RAM_DATA                                                                         0x40af
#define regGFX_IMU_RLC_RAM_DATA_BASE_IDX                                                                1
#define regGFX_IMU_CORE_CTRL                                                                            0x40b6
#define regGFX_IMU_CORE_CTRL_BASE_IDX                                                                   1
#define regGFX_IMU_GFX_RESET_CTRL                                                                       0x40bc
#define regGFX_IMU_GFX_RESET_CTRL_BASE_IDX                                                              1
#define regGFX_IMU_D_RAM_ADDR                                                                           0x40fc
#define regGFX_IMU_D_RAM_ADDR_BASE_IDX                                                                  1
#define regGFX_IMU_D_RAM_DATA                                                                           0x40fd
#define regGFX_IMU_D_RAM_DATA_BASE_IDX                                                                  1


// addressBlock: gc_gfx_cpwd_gfx_imu_cpwd_gfx_imu_pspdec
// base address: 0x3fe00
#define regGFX_IMU_RLC_BOOTLOADER_ADDR_HI                                                               0x5f81
#define regGFX_IMU_RLC_BOOTLOADER_ADDR_HI_BASE_IDX                                                      1
#define regGFX_IMU_RLC_BOOTLOADER_ADDR_LO                                                               0x5f82
#define regGFX_IMU_RLC_BOOTLOADER_ADDR_LO_BASE_IDX                                                      1
#define regGFX_IMU_RLC_BOOTLOADER_SIZE                                                                  0x5f83
#define regGFX_IMU_RLC_BOOTLOADER_SIZE_BASE_IDX                                                         1
#define regGFX_IMU_I_RAM_ADDR                                                                           0x5f90
#define regGFX_IMU_I_RAM_ADDR_BASE_IDX                                                                  1
#define regGFX_IMU_I_RAM_DATA                                                                           0x5f91
#define regGFX_IMU_I_RAM_DATA_BASE_IDX                                                                  1


// addressBlock: gc_gfx_se_gfx_se_grbmhdec
// base address: 0x8180
#define regGRBMH_CNTL                                                                                   0x0e00
#define regGRBMH_CNTL_BASE_IDX                                                                          0
#define regGRBMH_INTF_CNTL                                                                              0x0e01
#define regGRBMH_INTF_CNTL_BASE_IDX                                                                     0
#define regGRBMH_STATUS                                                                                 0x0e02
#define regGRBMH_STATUS_BASE_IDX                                                                        0
#define regGRBMH_FGCG0_TARG                                                                             0x0e04
#define regGRBMH_FGCG0_TARG_BASE_IDX                                                                    0
#define regGRBMH_SOFT_RESET                                                                             0x0e05
#define regGRBMH_SOFT_RESET_BASE_IDX                                                                    0
#define regGRBMH_READ_ERROR                                                                             0x0e06
#define regGRBMH_READ_ERROR_BASE_IDX                                                                    0
#define regGRBMH_GFX_CLKEN_CNTL                                                                         0x0e0d
#define regGRBMH_GFX_CLKEN_CNTL_BASE_IDX                                                                0
#define regGRBMH_FGCG2_MISC                                                                             0x0e0e
#define regGRBMH_FGCG2_MISC_BASE_IDX                                                                    0
#define regGRBMH_FGCG1_TARGVF                                                                           0x0e0f
#define regGRBMH_FGCG1_TARGVF_BASE_IDX                                                                  0
#define regGRBMH_NOWHERE                                                                                0x0e10
#define regGRBMH_NOWHERE_BASE_IDX                                                                       0
#define regGRBMH_INVALID_PIPE                                                                           0x0e12
#define regGRBMH_INVALID_PIPE_BASE_IDX                                                                  0
#define regGRBMH_SYNC                                                                                   0x0e13
#define regGRBMH_SYNC_BASE_IDX                                                                          0


// addressBlock: gc_gfx_se_gfx_se_padec
// base address: 0x8800
#define regGRBMH_CC_GC_SA_UNIT_DISABLE                                                                  0x0fe9
#define regGRBMH_CC_GC_SA_UNIT_DISABLE_BASE_IDX                                                         0
#define regCC_GC_SA_UNIT_DISABLE_1                                                                      0x0fe9
#define regCC_GC_SA_UNIT_DISABLE_1_BASE_IDX                                                             0
#define regGE_RATE_CNTL_1                                                                               0x0ff4
#define regGE_RATE_CNTL_1_BASE_IDX                                                                      0
#define regGE_RATE_CNTL_2                                                                               0x0ff5
#define regGE_RATE_CNTL_2_BASE_IDX                                                                      0
#define regCC_GC_SHADER_ARRAY_CONFIG                                                                    0x100f
#define regCC_GC_SHADER_ARRAY_CONFIG_BASE_IDX                                                           0
#define regGE_SE_CNTL_STATUS                                                                            0x1011
#define regGE_SE_CNTL_STATUS_BASE_IDX                                                                   0
#define regGE_SPI_IF_SAFE_REG                                                                           0x1018
#define regGE_SPI_IF_SAFE_REG_BASE_IDX                                                                  0
#define regGE_PA_IF_SAFE_REG                                                                            0x1019
#define regGE_PA_IF_SAFE_REG_BASE_IDX                                                                   0
#define regPA_SU_DEBUG_CNTL                                                                             0x1020
#define regPA_SU_DEBUG_CNTL_BASE_IDX                                                                    0
#define regPA_CL_CNTL_STATUS                                                                            0x1024
#define regPA_CL_CNTL_STATUS_BASE_IDX                                                                   0
#define regPA_CL_ENHANCE                                                                                0x1025
#define regPA_CL_ENHANCE_BASE_IDX                                                                       0
#define regPA_CL_RESET_DEBUG                                                                            0x1026
#define regPA_CL_RESET_DEBUG_BASE_IDX                                                                   0
#define regPA_SU_CNTL_STATUS                                                                            0x1034
#define regPA_SU_CNTL_STATUS_BASE_IDX                                                                   0
#define regPA_SC_FIFO_DEPTH_CNTL                                                                        0x1035
#define regPA_SC_FIFO_DEPTH_CNTL_BASE_IDX                                                               0
#define regPA_PH_DEBUG_CNTL                                                                             0x1082
#define regPA_PH_DEBUG_CNTL_BASE_IDX                                                                    0
#define regPA_SC_DEBUG_CNTL                                                                             0x1096
#define regPA_SC_DEBUG_CNTL_BASE_IDX                                                                    0


// addressBlock: gc_gfx_se_gfx_se_sqdec
// base address: 0x8c00
#define regSQ_CONFIG                                                                                    0x10a0
#define regSQ_CONFIG_BASE_IDX                                                                           0
#define regSQC_CONFIG                                                                                   0x10a1
#define regSQC_CONFIG_BASE_IDX                                                                          0
#define regLDS_CONFIG                                                                                   0x10a2
#define regLDS_CONFIG_BASE_IDX                                                                          0
#define regSQ_RANDOM_WAVE_PRI                                                                           0x10a3
#define regSQ_RANDOM_WAVE_PRI_BASE_IDX                                                                  0
#define regSQG_STATUS                                                                                   0x10a4
#define regSQG_STATUS_BASE_IDX                                                                          0
#define regSQ_FIFO_SIZES                                                                                0x10a5
#define regSQ_FIFO_SIZES_BASE_IDX                                                                       0
#define regSQ_DSM_CNTL                                                                                  0x10a6
#define regSQ_DSM_CNTL_BASE_IDX                                                                         0
#define regSQ_DSM_CNTL2                                                                                 0x10a7
#define regSQ_DSM_CNTL2_BASE_IDX                                                                        0
#define regSQG_THREAD_TRACE_CONFIG                                                                      0x10aa
#define regSQG_THREAD_TRACE_CONFIG_BASE_IDX                                                             0
#define regSP_CONFIG                                                                                    0x10ab
#define regSP_CONFIG_BASE_IDX                                                                           0
#define regSQ_ARB_CONFIG                                                                                0x10ac
#define regSQ_ARB_CONFIG_BASE_IDX                                                                       0
#define regSQ_DYN_VGPR                                                                                  0x10ad
#define regSQ_DYN_VGPR_BASE_IDX                                                                         0
#define regSQ_DEBUG_HOST_TRAP_STATUS                                                                    0x10b6
#define regSQ_DEBUG_HOST_TRAP_STATUS_BASE_IDX                                                           0
#define regSQG_GL1X_CTRL                                                                                0x10b8
#define regSQG_GL1X_CTRL_BASE_IDX                                                                       0
#define regSQG_GL1X_STATUS                                                                              0x10b9
#define regSQG_GL1X_STATUS_BASE_IDX                                                                     0
#define regSQG_CONFIG                                                                                   0x10ba
#define regSQG_CONFIG_BASE_IDX                                                                          0
#define regSQ_PERF_SNAPSHOT_CTRL                                                                        0x10bb
#define regSQ_PERF_SNAPSHOT_CTRL_BASE_IDX                                                               0
#define regCC_GC_SHADER_RATE_CONFIG                                                                     0x10bc
#define regCC_GC_SHADER_RATE_CONFIG_BASE_IDX                                                            0
#define regCC_GC_SHADER_RATE_CONFIG_1                                                                   0x10bc
#define regCC_GC_SHADER_RATE_CONFIG_1_BASE_IDX                                                          0
#define regSQ_INTERRUPT_AUTO_MASK                                                                       0x10be
#define regSQ_INTERRUPT_AUTO_MASK_BASE_IDX                                                              0
#define regSQ_INTERRUPT_MSG_CTRL                                                                        0x10bf
#define regSQ_INTERRUPT_MSG_CTRL_BASE_IDX                                                               0
#define regSQ_WATCH0_ADDR_H                                                                             0x10d0
#define regSQ_WATCH0_ADDR_H_BASE_IDX                                                                    0
#define regSQ_WATCH0_ADDR_L                                                                             0x10d1
#define regSQ_WATCH0_ADDR_L_BASE_IDX                                                                    0
#define regSQ_WATCH0_CNTL                                                                               0x10d2
#define regSQ_WATCH0_CNTL_BASE_IDX                                                                      0
#define regSQ_WATCH1_ADDR_H                                                                             0x10d3
#define regSQ_WATCH1_ADDR_H_BASE_IDX                                                                    0
#define regSQ_WATCH1_ADDR_L                                                                             0x10d4
#define regSQ_WATCH1_ADDR_L_BASE_IDX                                                                    0
#define regSQ_WATCH1_CNTL                                                                               0x10d5
#define regSQ_WATCH1_CNTL_BASE_IDX                                                                      0
#define regSQ_WATCH2_ADDR_H                                                                             0x10d6
#define regSQ_WATCH2_ADDR_H_BASE_IDX                                                                    0
#define regSQ_WATCH2_ADDR_L                                                                             0x10d7
#define regSQ_WATCH2_ADDR_L_BASE_IDX                                                                    0
#define regSQ_WATCH2_CNTL                                                                               0x10d8
#define regSQ_WATCH2_CNTL_BASE_IDX                                                                      0
#define regSQ_WATCH3_ADDR_H                                                                             0x10d9
#define regSQ_WATCH3_ADDR_H_BASE_IDX                                                                    0
#define regSQ_WATCH3_ADDR_L                                                                             0x10da
#define regSQ_WATCH3_ADDR_L_BASE_IDX                                                                    0
#define regSQ_WATCH3_CNTL                                                                               0x10db
#define regSQ_WATCH3_CNTL_BASE_IDX                                                                      0
#define regSQ_IND_INDEX                                                                                 0x1118
#define regSQ_IND_INDEX_BASE_IDX                                                                        0
#define regSQ_IND_DATA                                                                                  0x1119
#define regSQ_IND_DATA_BASE_IDX                                                                         0
#define regSQ_CMD                                                                                       0x111b
#define regSQ_CMD_BASE_IDX                                                                              0
#define regSQC_MISC_CONFIG                                                                              0x1179
#define regSQC_MISC_CONFIG_BASE_IDX                                                                     0


// addressBlock: gc_gfx_se_gfx_se_shsdec
// base address: 0x9000
#define regSX_DEBUG_BUSY                                                                                0x11b4
#define regSX_DEBUG_BUSY_BASE_IDX                                                                       0
#define regSX_DEBUG_BUSY_2                                                                              0x11b5
#define regSX_DEBUG_BUSY_2_BASE_IDX                                                                     0
#define regSX_DEBUG_BUSY_3                                                                              0x11b6
#define regSX_DEBUG_BUSY_3_BASE_IDX                                                                     0
#define regSX_DEBUG_BUSY_4                                                                              0x11b7
#define regSX_DEBUG_BUSY_4_BASE_IDX                                                                     0
#define regSX_DEBUG_1                                                                                   0x11b8
#define regSX_DEBUG_1_BASE_IDX                                                                          0
#define regSX_DEBUG_BUSY_5                                                                              0x11b9
#define regSX_DEBUG_BUSY_5_BASE_IDX                                                                     0
#define regSX_DEBUG_BUSY_6                                                                              0x11ba
#define regSX_DEBUG_BUSY_6_BASE_IDX                                                                     0
#define regSX_DEBUG_BUSY_7                                                                              0x11bb
#define regSX_DEBUG_BUSY_7_BASE_IDX                                                                     0
#define regSX_DEBUG_BUSY_8                                                                              0x11bc
#define regSX_DEBUG_BUSY_8_BASE_IDX                                                                     0
#define regSX_DEBUG_BUSY_9                                                                              0x11bd
#define regSX_DEBUG_BUSY_9_BASE_IDX                                                                     0
#define regSX_DEBUG_BUSY_10                                                                             0x11be
#define regSX_DEBUG_BUSY_10_BASE_IDX                                                                    0
#define regSPI_PS_MAX_WAVE_ID                                                                           0x11da
#define regSPI_PS_MAX_WAVE_ID_BASE_IDX                                                                  0
#define regSPI_SCRATCH_ADDR_STATUS                                                                      0x11db
#define regSPI_SCRATCH_ADDR_STATUS_BASE_IDX                                                             0
#define regSPI_GFX_CNTL                                                                                 0x11dc
#define regSPI_GFX_CNTL_BASE_IDX                                                                        0
#define regSPI_DEBUG_CNTL_2                                                                             0x11de
#define regSPI_DEBUG_CNTL_2_BASE_IDX                                                                    0
#define regSPI_DEBUG_CNTL_3                                                                             0x11df
#define regSPI_DEBUG_CNTL_3_BASE_IDX                                                                    0
#define regSPI_DEBUG_CNTL                                                                               0x11e1
#define regSPI_DEBUG_CNTL_BASE_IDX                                                                      0
#define regSPI_DEBUG_READ                                                                               0x11e2
#define regSPI_DEBUG_READ_BASE_IDX                                                                      0
#define regSPI_DSM_CNTL                                                                                 0x11e3
#define regSPI_DSM_CNTL_BASE_IDX                                                                        0
#define regSPI_DSM_CNTL2                                                                                0x11e4
#define regSPI_DSM_CNTL2_BASE_IDX                                                                       0
#define regSPI_EDC_CNT                                                                                  0x11e5
#define regSPI_EDC_CNT_BASE_IDX                                                                         0
#define regSPIRA_DEBUG_READ                                                                             0x11e6
#define regSPIRA_DEBUG_READ_BASE_IDX                                                                    0
#define regSPI_DEBUG_BUSY                                                                               0x11f0
#define regSPI_DEBUG_BUSY_BASE_IDX                                                                      0
#define regSPI_CONFIG_PS_CU_EN                                                                          0x11f2
#define regSPI_CONFIG_PS_CU_EN_BASE_IDX                                                                 0
#define regSPI_CONFIG_CU_MASK_GFX0                                                                      0x11f3
#define regSPI_CONFIG_CU_MASK_GFX0_BASE_IDX                                                             0
#define regSPI_CONFIG_CU_MASK_HP3D0                                                                     0x11f4
#define regSPI_CONFIG_CU_MASK_HP3D0_BASE_IDX                                                            0
#define regSPI_CONFIG_CU_MASK_GFX1                                                                      0x11f5
#define regSPI_CONFIG_CU_MASK_GFX1_BASE_IDX                                                             0
#define regSPI_CONFIG_CU_MASK_HP3D1                                                                     0x11f6
#define regSPI_CONFIG_CU_MASK_HP3D1_BASE_IDX                                                            0
#define regSPI_CONFIG_CU_MASK_CS0                                                                       0x11f7
#define regSPI_CONFIG_CU_MASK_CS0_BASE_IDX                                                              0
#define regSPI_CONFIG_CU_MASK_CS1                                                                       0x11f8
#define regSPI_CONFIG_CU_MASK_CS1_BASE_IDX                                                              0
#define regSPI_CONFIG_CU_MASK_CS2                                                                       0x11f9
#define regSPI_CONFIG_CU_MASK_CS2_BASE_IDX                                                              0
#define regSPI_CONFIG_CU_MASK_CS3                                                                       0x11fa
#define regSPI_CONFIG_CU_MASK_CS3_BASE_IDX                                                              0
#define regSPI_CONFIG_CU_MASK_CS4                                                                       0x11fb
#define regSPI_CONFIG_CU_MASK_CS4_BASE_IDX                                                              0
#define regSPI_CONFIG_CU_MASK_CS5                                                                       0x11fc
#define regSPI_CONFIG_CU_MASK_CS5_BASE_IDX                                                              0
#define regSPI_CONFIG_CU_MASK_CS6                                                                       0x11fd
#define regSPI_CONFIG_CU_MASK_CS6_BASE_IDX                                                              0
#define regSPI_CONFIG_CU_MASK_CS7                                                                       0x11fe
#define regSPI_CONFIG_CU_MASK_CS7_BASE_IDX                                                              0
#define regSPI_WF_LIFETIME_CNTL                                                                         0x124a
#define regSPI_WF_LIFETIME_CNTL_BASE_IDX                                                                0
#define regSPI_WF_LIFETIME_LIMIT_0                                                                      0x124b
#define regSPI_WF_LIFETIME_LIMIT_0_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_2                                                                      0x124d
#define regSPI_WF_LIFETIME_LIMIT_2_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_LIMIT_3                                                                      0x124e
#define regSPI_WF_LIFETIME_LIMIT_3_BASE_IDX                                                             0
#define regSPI_WF_LIFETIME_STATUS_0                                                                     0x1255
#define regSPI_WF_LIFETIME_STATUS_0_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_2                                                                     0x1257
#define regSPI_WF_LIFETIME_STATUS_2_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_4                                                                     0x1259
#define regSPI_WF_LIFETIME_STATUS_4_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_6                                                                     0x125b
#define regSPI_WF_LIFETIME_STATUS_6_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_7                                                                     0x125c
#define regSPI_WF_LIFETIME_STATUS_7_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_9                                                                     0x125e
#define regSPI_WF_LIFETIME_STATUS_9_BASE_IDX                                                            0
#define regSPI_WF_LIFETIME_STATUS_11                                                                    0x1260
#define regSPI_WF_LIFETIME_STATUS_11_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_13                                                                    0x1262
#define regSPI_WF_LIFETIME_STATUS_13_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_14                                                                    0x1263
#define regSPI_WF_LIFETIME_STATUS_14_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_15                                                                    0x1264
#define regSPI_WF_LIFETIME_STATUS_15_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_16                                                                    0x1265
#define regSPI_WF_LIFETIME_STATUS_16_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_17                                                                    0x1266
#define regSPI_WF_LIFETIME_STATUS_17_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_18                                                                    0x1267
#define regSPI_WF_LIFETIME_STATUS_18_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_19                                                                    0x1268
#define regSPI_WF_LIFETIME_STATUS_19_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_STATUS_20                                                                    0x1269
#define regSPI_WF_LIFETIME_STATUS_20_BASE_IDX                                                           0
#define regSPI_WF_LIFETIME_DEBUG                                                                        0x126a
#define regSPI_WF_LIFETIME_DEBUG_BASE_IDX                                                               0
#define regSPI_WF_LIFETIME_STATUS_21                                                                    0x126b
#define regSPI_WF_LIFETIME_STATUS_21_BASE_IDX                                                           0
#define regSPI_WGP_WORK_PENDING                                                                         0x126c
#define regSPI_WGP_WORK_PENDING_BASE_IDX                                                                0
#define regSPI_CREST_MODE                                                                               0x126d
#define regSPI_CREST_MODE_BASE_IDX                                                                      0
#define regSPI_SLAVE_DEBUG_BUSY                                                                         0x1273
#define regSPI_SLAVE_DEBUG_BUSY_BASE_IDX                                                                0
#define regSPI_LB_CTR_CTRL                                                                              0x1274
#define regSPI_LB_CTR_CTRL_BASE_IDX                                                                     0
#define regSPI_LB_WGP_MASK                                                                              0x1275
#define regSPI_LB_WGP_MASK_BASE_IDX                                                                     0
#define regSPI_LB_DATA_REG                                                                              0x1276
#define regSPI_LB_DATA_REG_BASE_IDX                                                                     0
#define regSPI_PG_ENABLE_STATIC_WGP_MASK                                                                0x1277
#define regSPI_PG_ENABLE_STATIC_WGP_MASK_BASE_IDX                                                       0
#define regSPI_GDS_CREDITS                                                                              0x1278
#define regSPI_GDS_CREDITS_BASE_IDX                                                                     0
#define regSPI_SX_EXPORT_BUFFER_SIZES                                                                   0x1279
#define regSPI_SX_EXPORT_BUFFER_SIZES_BASE_IDX                                                          0
#define regSPI_SX_SCOREBOARD_BUFFER_SIZES                                                               0x127a
#define regSPI_SX_SCOREBOARD_BUFFER_SIZES_BASE_IDX                                                      0
#define regSPI_CSQ_WF_ACTIVE_STATUS                                                                     0x127b
#define regSPI_CSQ_WF_ACTIVE_STATUS_BASE_IDX                                                            0
#define regSPI_CSQ_WF_ACTIVE_COUNT_0                                                                    0x127c
#define regSPI_CSQ_WF_ACTIVE_COUNT_0_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_1                                                                    0x127d
#define regSPI_CSQ_WF_ACTIVE_COUNT_1_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_2                                                                    0x127e
#define regSPI_CSQ_WF_ACTIVE_COUNT_2_BASE_IDX                                                           0
#define regSPI_CSQ_WF_ACTIVE_COUNT_3                                                                    0x127f
#define regSPI_CSQ_WF_ACTIVE_COUNT_3_BASE_IDX                                                           0
#define regSPI_LB_DATA_WAVES                                                                            0x1284
#define regSPI_LB_DATA_WAVES_BASE_IDX                                                                   0
#define regSPI_LB_DATA_PERWGP_WAVE_HSGS                                                                 0x1285
#define regSPI_LB_DATA_PERWGP_WAVE_HSGS_BASE_IDX                                                        0
#define regSPI_LB_DATA_PERWGP_WAVE_PS                                                                   0x1286
#define regSPI_LB_DATA_PERWGP_WAVE_PS_BASE_IDX                                                          0
#define regSPI_LB_DATA_PERWGP_WAVE_CS                                                                   0x1287
#define regSPI_LB_DATA_PERWGP_WAVE_CS_BASE_IDX                                                          0
#define regSPI_WF_ACTIVE_COUNT_GFX                                                                      0x1288
#define regSPI_WF_ACTIVE_COUNT_GFX_BASE_IDX                                                             0
#define regSPI_WF_ACTIVE_COUNT_HPG                                                                      0x1289
#define regSPI_WF_ACTIVE_COUNT_HPG_BASE_IDX                                                             0
#define regSPIS_DEBUG_READ                                                                              0x128a
#define regSPIS_DEBUG_READ_BASE_IDX                                                                     0
#define regBCI_DEBUG_READ                                                                               0x128b
#define regBCI_DEBUG_READ_BASE_IDX                                                                      0
#define regSPI_P0_TRAP_SCREEN_PSBA_LO                                                                   0x128c
#define regSPI_P0_TRAP_SCREEN_PSBA_LO_BASE_IDX                                                          0
#define regSPI_P0_TRAP_SCREEN_PSBA_HI                                                                   0x128d
#define regSPI_P0_TRAP_SCREEN_PSBA_HI_BASE_IDX                                                          0
#define regSPI_P0_TRAP_SCREEN_PSMA_LO                                                                   0x128e
#define regSPI_P0_TRAP_SCREEN_PSMA_LO_BASE_IDX                                                          0
#define regSPI_P0_TRAP_SCREEN_PSMA_HI                                                                   0x128f
#define regSPI_P0_TRAP_SCREEN_PSMA_HI_BASE_IDX                                                          0
#define regSPI_P0_TRAP_SCREEN_GPR_MIN                                                                   0x1290
#define regSPI_P0_TRAP_SCREEN_GPR_MIN_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_PSBA_LO                                                                   0x1291
#define regSPI_P1_TRAP_SCREEN_PSBA_LO_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_PSBA_HI                                                                   0x1292
#define regSPI_P1_TRAP_SCREEN_PSBA_HI_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_PSMA_LO                                                                   0x1293
#define regSPI_P1_TRAP_SCREEN_PSMA_LO_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_PSMA_HI                                                                   0x1294
#define regSPI_P1_TRAP_SCREEN_PSMA_HI_BASE_IDX                                                          0
#define regSPI_P1_TRAP_SCREEN_GPR_MIN                                                                   0x1295
#define regSPI_P1_TRAP_SCREEN_GPR_MIN_BASE_IDX                                                          0
#define regSPI_GFX_CRAWLER_CONFIG                                                                       0x1296
#define regSPI_GFX_CRAWLER_CONFIG_BASE_IDX                                                              0
#define regSPI_CS_CRAWLER_CONFIG                                                                        0x1297
#define regSPI_CS_CRAWLER_CONFIG_BASE_IDX                                                               0


// addressBlock: gc_gfx_se_gfx_se_tpdec
// base address: 0x9400
#define regTD_CNTL                                                                                      0x12c5
#define regTD_CNTL_BASE_IDX                                                                             0
#define regTD_STATUS                                                                                    0x12c6
#define regTD_STATUS_BASE_IDX                                                                           0
#define regTD_POWER_CNTL                                                                                0x12ca
#define regTD_POWER_CNTL_BASE_IDX                                                                       0
#define regTD_CNTL2                                                                                     0x12cb
#define regTD_CNTL2_BASE_IDX                                                                            0
#define regTD_DSM_CNTL                                                                                  0x12cf
#define regTD_DSM_CNTL_BASE_IDX                                                                         0
#define regTD_DSM_CNTL2                                                                                 0x12d0
#define regTD_DSM_CNTL2_BASE_IDX                                                                        0
#define regTD_SCRATCH                                                                                   0x12d3
#define regTD_SCRATCH_BASE_IDX                                                                          0
#define regTA_CNTL                                                                                      0x12e1
#define regTA_CNTL_BASE_IDX                                                                             0
#define regTA_CNTL_AUX                                                                                  0x12e2
#define regTA_CNTL_AUX_BASE_IDX                                                                         0
#define regTA_CNTL2                                                                                     0x12e5
#define regTA_CNTL2_BASE_IDX                                                                            0
#define regTA_STATUS                                                                                    0x12e8
#define regTA_STATUS_BASE_IDX                                                                           0
#define regTA_SCRATCH                                                                                   0x1304
#define regTA_SCRATCH_BASE_IDX                                                                          0


// addressBlock: gc_gfx_se_gfx_se_rbdec
// base address: 0x9800
#define regDB_DEBUG                                                                                     0x13ac
#define regDB_DEBUG_BASE_IDX                                                                            0
#define regDB_DEBUG2                                                                                    0x13ad
#define regDB_DEBUG2_BASE_IDX                                                                           0
#define regDB_DEBUG3                                                                                    0x13ae
#define regDB_DEBUG3_BASE_IDX                                                                           0
#define regDB_DEBUG4                                                                                    0x13af
#define regDB_DEBUG4_BASE_IDX                                                                           0
#define regDB_CREDIT_LIMIT                                                                              0x13b4
#define regDB_CREDIT_LIMIT_BASE_IDX                                                                     0
#define regDB_WATERMARKS                                                                                0x13b5
#define regDB_WATERMARKS_BASE_IDX                                                                       0
#define regDB_FREE_CACHELINES                                                                           0x13b7
#define regDB_FREE_CACHELINES_BASE_IDX                                                                  0
#define regDB_FIFO_DEPTH1                                                                               0x13b8
#define regDB_FIFO_DEPTH1_BASE_IDX                                                                      0
#define regDB_FIFO_DEPTH2                                                                               0x13b9
#define regDB_FIFO_DEPTH2_BASE_IDX                                                                      0
#define regDB_RING_CONTROL                                                                              0x13bb
#define regDB_RING_CONTROL_BASE_IDX                                                                     0
#define regDB_MEM_ARB_WATERMARKS                                                                        0x13bc
#define regDB_MEM_ARB_WATERMARKS_BASE_IDX                                                               0
#define regDB_FIFO_DEPTH3                                                                               0x13bd
#define regDB_FIFO_DEPTH3_BASE_IDX                                                                      0
#define regDB_DEBUG6                                                                                    0x13be
#define regDB_DEBUG6_BASE_IDX                                                                           0
#define regDB_EXCEPTION_CONTROL                                                                         0x13bf
#define regDB_EXCEPTION_CONTROL_BASE_IDX                                                                0
#define regDB_DEBUG7                                                                                    0x13d0
#define regDB_DEBUG7_BASE_IDX                                                                           0
#define regDB_DEBUG5                                                                                    0x13d1
#define regDB_DEBUG5_BASE_IDX                                                                           0
#define regDB_MEM_CONFIG                                                                                0x13d2
#define regDB_MEM_CONFIG_BASE_IDX                                                                       0
#define regDB_ARB_CONFIG                                                                                0x13d3
#define regDB_ARB_CONFIG_BASE_IDX                                                                       0
#define regDB_DFD_INDIRECT_SEL                                                                          0x13d4
#define regDB_DFD_INDIRECT_SEL_BASE_IDX                                                                 0
#define regDB_DFD_INDIRECT_DAT                                                                          0x13d5
#define regDB_DFD_INDIRECT_DAT_BASE_IDX                                                                 0
#define regDB_SUMMARIZER_TIMEOUTS                                                                       0x13d6
#define regDB_SUMMARIZER_TIMEOUTS_BASE_IDX                                                              0
#define regDB_FGCG_SRAMS_CLK_CTRL                                                                       0x13d7
#define regDB_FGCG_SRAMS_CLK_CTRL_BASE_IDX                                                              0
#define regDB_FGCG_INTERFACES_CLK_CTRL                                                                  0x13d8
#define regDB_FGCG_INTERFACES_CLK_CTRL_BASE_IDX                                                         0
#define regDB_FIFO_DEPTH4                                                                               0x13d9
#define regDB_FIFO_DEPTH4_BASE_IDX                                                                      0
#define regCC_RB_BACKEND_DISABLE                                                                        0x13dd
#define regCC_RB_BACKEND_DISABLE_BASE_IDX                                                               0
#define regGB_ADDR_CONFIG                                                                               0x13de
#define regGB_ADDR_CONFIG_BASE_IDX                                                                      0
#define regGB_ADDR_CONFIG_1                                                                             0x13de
#define regGB_ADDR_CONFIG_1_BASE_IDX                                                                    0
#define regGB_BACKEND_MAP                                                                               0x13df
#define regGB_BACKEND_MAP_BASE_IDX                                                                      0
#define regGB_GPU_ID                                                                                    0x13e0
#define regGB_GPU_ID_BASE_IDX                                                                           0
#define regGB_ADDR_CONFIG_READ                                                                          0x13e2
#define regGB_ADDR_CONFIG_READ_BASE_IDX                                                                 0
#define regCB_HW_CONTROL_4                                                                              0x1422
#define regCB_HW_CONTROL_4_BASE_IDX                                                                     0
#define regCB_HW_CONTROL_3                                                                              0x1423
#define regCB_HW_CONTROL_3_BASE_IDX                                                                     0
#define regCB_HW_CONTROL                                                                                0x1424
#define regCB_HW_CONTROL_BASE_IDX                                                                       0
#define regCB_HW_CONTROL_1                                                                              0x1425
#define regCB_HW_CONTROL_1_BASE_IDX                                                                     0
#define regCB_HW_CONTROL_2                                                                              0x1426
#define regCB_HW_CONTROL_2_BASE_IDX                                                                     0
#define regCB_HW_MEM_ARBITER_CTL                                                                        0x1428
#define regCB_HW_MEM_ARBITER_CTL_BASE_IDX                                                               0
#define regCB_FGCG_SRAM_OVERRIDE                                                                        0x142a
#define regCB_FGCG_SRAM_OVERRIDE_BASE_IDX                                                               0
#define regCB_CACHE_EVICT_POINTS                                                                        0x142e
#define regCB_CACHE_EVICT_POINTS_BASE_IDX                                                               0


// addressBlock: gc_gfx_se_gfx_se_spipdec2
// base address: 0x9c80
#define regSPI_PQEV_CTRL                                                                                0x14c0
#define regSPI_PQEV_CTRL_BASE_IDX                                                                       0
#define regSPI_EXP_THROTTLE_CTRL                                                                        0x14c3
#define regSPI_EXP_THROTTLE_CTRL_BASE_IDX                                                               0


// addressBlock: gc_gfx_se_rmi_gfx_se_rmidec
// base address: 0x2e200
#define regRMI_GENERAL_CNTL                                                                             0x1880
#define regRMI_GENERAL_CNTL_BASE_IDX                                                                    1
#define regRMI_GENERAL_CNTL1                                                                            0x1881
#define regRMI_GENERAL_CNTL1_BASE_IDX                                                                   1
#define regRMI_GENERAL_STATUS                                                                           0x1882
#define regRMI_GENERAL_STATUS_BASE_IDX                                                                  1
#define regRMI_SUBBLOCK_STATUS0                                                                         0x1883
#define regRMI_SUBBLOCK_STATUS0_BASE_IDX                                                                1
#define regRMI_SUBBLOCK_STATUS1                                                                         0x1884
#define regRMI_SUBBLOCK_STATUS1_BASE_IDX                                                                1
#define regRMI_SUBBLOCK_STATUS2                                                                         0x1885
#define regRMI_SUBBLOCK_STATUS2_BASE_IDX                                                                1
#define regRMI_SUBBLOCK_STATUS3                                                                         0x1886
#define regRMI_SUBBLOCK_STATUS3_BASE_IDX                                                                1
#define regRMI_XBAR_CONFIG                                                                              0x1887
#define regRMI_XBAR_CONFIG_BASE_IDX                                                                     1
#define regRMI_PROBE_POP_LOGIC_CNTL                                                                     0x1888
#define regRMI_PROBE_POP_LOGIC_CNTL_BASE_IDX                                                            1
#define regRMI_UTC_XNACK_N_MISC_CNTL                                                                    0x1889
#define regRMI_UTC_XNACK_N_MISC_CNTL_BASE_IDX                                                           1
#define regRMI_DEMUX_CNTL                                                                               0x188a
#define regRMI_DEMUX_CNTL_BASE_IDX                                                                      1
#define regRMI_UTCL1_CNTL1                                                                              0x188b
#define regRMI_UTCL1_CNTL1_BASE_IDX                                                                     1
#define regRMI_UTCL1_CNTL2                                                                              0x188c
#define regRMI_UTCL1_CNTL2_BASE_IDX                                                                     1
#define regRMI_UTC_UNIT_CONFIG                                                                          0x188d
#define regRMI_UTC_UNIT_CONFIG_BASE_IDX                                                                 1
#define regRMI_TCIW_FORMATTER0_CNTL                                                                     0x188e
#define regRMI_TCIW_FORMATTER0_CNTL_BASE_IDX                                                            1
#define regRMI_TCIW_FORMATTER1_CNTL                                                                     0x188f
#define regRMI_TCIW_FORMATTER1_CNTL_BASE_IDX                                                            1
#define regRMI_SCOREBOARD_CNTL                                                                          0x1890
#define regRMI_SCOREBOARD_CNTL_BASE_IDX                                                                 1
#define regRMI_SCOREBOARD_STATUS0                                                                       0x1891
#define regRMI_SCOREBOARD_STATUS0_BASE_IDX                                                              1
#define regRMI_SCOREBOARD_STATUS1                                                                       0x1892
#define regRMI_SCOREBOARD_STATUS1_BASE_IDX                                                              1
#define regRMI_SCOREBOARD_STATUS2                                                                       0x1893
#define regRMI_SCOREBOARD_STATUS2_BASE_IDX                                                              1
#define regRMI_XBAR_ARBITER_CONFIG                                                                      0x1894
#define regRMI_XBAR_ARBITER_CONFIG_BASE_IDX                                                             1
#define regRMI_XBAR_ARBITER_CONFIG_1                                                                    0x1895
#define regRMI_XBAR_ARBITER_CONFIG_1_BASE_IDX                                                           1
#define regRMI_CLOCK_CNTRL                                                                              0x1896
#define regRMI_CLOCK_CNTRL_BASE_IDX                                                                     1
#define regRMI_UTCL1_STATUS                                                                             0x1897
#define regRMI_UTCL1_STATUS_BASE_IDX                                                                    1
#define regRMI_RB_GLX_CID_MAP                                                                           0x1898
#define regRMI_RB_GLX_CID_MAP_BASE_IDX                                                                  1
#define regRMI_XNACK_DEBUG                                                                              0x189e
#define regRMI_XNACK_DEBUG_BASE_IDX                                                                     1
#define regRMI_SPARE                                                                                    0x189f
#define regRMI_SPARE_BASE_IDX                                                                           1
#define regRMI_SPARE_1                                                                                  0x18a0
#define regRMI_SPARE_1_BASE_IDX                                                                         1
#define regRMI_SPARE_2                                                                                  0x18a1
#define regRMI_SPARE_2_BASE_IDX                                                                         1
#define regCC_RMI_REDUNDANCY                                                                            0x18a2
#define regCC_RMI_REDUNDANCY_BASE_IDX                                                                   1


// addressBlock: gc_gfx_se_gfx_se_utcl1dec
// base address: 0x9fb0
#define regUTCL1_CTRL_1                                                                                 0x158c
#define regUTCL1_CTRL_1_BASE_IDX                                                                        0
#define regUTCL1_HASH_CTRL                                                                              0x158e
#define regUTCL1_HASH_CTRL_BASE_IDX                                                                     0
#define regUTCL1_ALOG                                                                                   0x158f
#define regUTCL1_ALOG_BASE_IDX                                                                          0
#define regUTCL1_STATUS                                                                                 0x1594
#define regUTCL1_STATUS_BASE_IDX                                                                        0


// addressBlock: gc_gfx_se_gfx_se_shdec
// base address: 0xb000
#define regSPI_SHADER_PGM_CHKSUM_PS                                                                     0x19a5
#define regSPI_SHADER_PGM_CHKSUM_PS_BASE_IDX                                                            0
#define regSPI_SHADER_PGM_RSRC3_PS                                                                      0x19a6
#define regSPI_SHADER_PGM_RSRC3_PS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC4_PS                                                                      0x19a7
#define regSPI_SHADER_PGM_RSRC4_PS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_LO_PS                                                                         0x19a8
#define regSPI_SHADER_PGM_LO_PS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_PS                                                                         0x19a9
#define regSPI_SHADER_PGM_HI_PS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC1_PS                                                                      0x19aa
#define regSPI_SHADER_PGM_RSRC1_PS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC2_PS                                                                      0x19ab
#define regSPI_SHADER_PGM_RSRC2_PS_BASE_IDX                                                             0
#define regSPI_SHADER_USER_DATA_PS_0                                                                    0x19ac
#define regSPI_SHADER_USER_DATA_PS_0_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_1                                                                    0x19ad
#define regSPI_SHADER_USER_DATA_PS_1_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_2                                                                    0x19ae
#define regSPI_SHADER_USER_DATA_PS_2_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_3                                                                    0x19af
#define regSPI_SHADER_USER_DATA_PS_3_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_4                                                                    0x19b0
#define regSPI_SHADER_USER_DATA_PS_4_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_5                                                                    0x19b1
#define regSPI_SHADER_USER_DATA_PS_5_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_6                                                                    0x19b2
#define regSPI_SHADER_USER_DATA_PS_6_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_7                                                                    0x19b3
#define regSPI_SHADER_USER_DATA_PS_7_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_8                                                                    0x19b4
#define regSPI_SHADER_USER_DATA_PS_8_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_9                                                                    0x19b5
#define regSPI_SHADER_USER_DATA_PS_9_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_PS_10                                                                   0x19b6
#define regSPI_SHADER_USER_DATA_PS_10_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_11                                                                   0x19b7
#define regSPI_SHADER_USER_DATA_PS_11_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_12                                                                   0x19b8
#define regSPI_SHADER_USER_DATA_PS_12_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_13                                                                   0x19b9
#define regSPI_SHADER_USER_DATA_PS_13_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_14                                                                   0x19ba
#define regSPI_SHADER_USER_DATA_PS_14_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_15                                                                   0x19bb
#define regSPI_SHADER_USER_DATA_PS_15_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_16                                                                   0x19bc
#define regSPI_SHADER_USER_DATA_PS_16_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_17                                                                   0x19bd
#define regSPI_SHADER_USER_DATA_PS_17_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_18                                                                   0x19be
#define regSPI_SHADER_USER_DATA_PS_18_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_19                                                                   0x19bf
#define regSPI_SHADER_USER_DATA_PS_19_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_20                                                                   0x19c0
#define regSPI_SHADER_USER_DATA_PS_20_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_21                                                                   0x19c1
#define regSPI_SHADER_USER_DATA_PS_21_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_22                                                                   0x19c2
#define regSPI_SHADER_USER_DATA_PS_22_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_23                                                                   0x19c3
#define regSPI_SHADER_USER_DATA_PS_23_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_24                                                                   0x19c4
#define regSPI_SHADER_USER_DATA_PS_24_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_25                                                                   0x19c5
#define regSPI_SHADER_USER_DATA_PS_25_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_26                                                                   0x19c6
#define regSPI_SHADER_USER_DATA_PS_26_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_27                                                                   0x19c7
#define regSPI_SHADER_USER_DATA_PS_27_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_28                                                                   0x19c8
#define regSPI_SHADER_USER_DATA_PS_28_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_29                                                                   0x19c9
#define regSPI_SHADER_USER_DATA_PS_29_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_30                                                                   0x19ca
#define regSPI_SHADER_USER_DATA_PS_30_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_PS_31                                                                   0x19cb
#define regSPI_SHADER_USER_DATA_PS_31_BASE_IDX                                                          0
#define regSPI_SHADER_REQ_CTRL_PS                                                                       0x19d0
#define regSPI_SHADER_REQ_CTRL_PS_BASE_IDX                                                              0
#define regSPI_SHADER_GS_OUT_CONFIG_PS                                                                  0x19d1
#define regSPI_SHADER_GS_OUT_CONFIG_PS_BASE_IDX                                                         0
#define regSPI_SHADER_USER_ACCUM_PS_0                                                                   0x19d2
#define regSPI_SHADER_USER_ACCUM_PS_0_BASE_IDX                                                          0
#define regSPI_SHADER_USER_ACCUM_PS_1                                                                   0x19d3
#define regSPI_SHADER_USER_ACCUM_PS_1_BASE_IDX                                                          0
#define regSPI_SHADER_USER_ACCUM_PS_2                                                                   0x19d4
#define regSPI_SHADER_USER_ACCUM_PS_2_BASE_IDX                                                          0
#define regSPI_SHADER_USER_ACCUM_PS_3                                                                   0x19d5
#define regSPI_SHADER_USER_ACCUM_PS_3_BASE_IDX                                                          0
#define regSPI_SHADER_PGM_CHKSUM_GS                                                                     0x1a20
#define regSPI_SHADER_PGM_CHKSUM_GS_BASE_IDX                                                            0
#define regSPI_SHADER_USER_DATA_ADDR_LO_GS                                                              0x1a22
#define regSPI_SHADER_USER_DATA_ADDR_LO_GS_BASE_IDX                                                     0
#define regSPI_SHADER_USER_DATA_ADDR_HI_GS                                                              0x1a23
#define regSPI_SHADER_USER_DATA_ADDR_HI_GS_BASE_IDX                                                     0
#define regSPI_SHADER_PGM_LO_GS                                                                         0x1a24
#define regSPI_SHADER_PGM_LO_GS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_GS                                                                         0x1a25
#define regSPI_SHADER_PGM_HI_GS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_ES                                                                         0x1a26
#define regSPI_SHADER_PGM_HI_ES_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC3_GS                                                                      0x1a27
#define regSPI_SHADER_PGM_RSRC3_GS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC4_GS                                                                      0x1a28
#define regSPI_SHADER_PGM_RSRC4_GS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_LO_ES                                                                         0x1a29
#define regSPI_SHADER_PGM_LO_ES_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC1_GS                                                                      0x1a2a
#define regSPI_SHADER_PGM_RSRC1_GS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC2_GS                                                                      0x1a2b
#define regSPI_SHADER_PGM_RSRC2_GS_BASE_IDX                                                             0
#define regSPI_SHADER_USER_DATA_GS_0                                                                    0x1a2c
#define regSPI_SHADER_USER_DATA_GS_0_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_1                                                                    0x1a2d
#define regSPI_SHADER_USER_DATA_GS_1_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_2                                                                    0x1a2e
#define regSPI_SHADER_USER_DATA_GS_2_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_3                                                                    0x1a2f
#define regSPI_SHADER_USER_DATA_GS_3_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_4                                                                    0x1a30
#define regSPI_SHADER_USER_DATA_GS_4_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_5                                                                    0x1a31
#define regSPI_SHADER_USER_DATA_GS_5_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_6                                                                    0x1a32
#define regSPI_SHADER_USER_DATA_GS_6_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_7                                                                    0x1a33
#define regSPI_SHADER_USER_DATA_GS_7_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_8                                                                    0x1a34
#define regSPI_SHADER_USER_DATA_GS_8_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_9                                                                    0x1a35
#define regSPI_SHADER_USER_DATA_GS_9_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_GS_10                                                                   0x1a36
#define regSPI_SHADER_USER_DATA_GS_10_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_11                                                                   0x1a37
#define regSPI_SHADER_USER_DATA_GS_11_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_12                                                                   0x1a38
#define regSPI_SHADER_USER_DATA_GS_12_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_13                                                                   0x1a39
#define regSPI_SHADER_USER_DATA_GS_13_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_14                                                                   0x1a3a
#define regSPI_SHADER_USER_DATA_GS_14_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_15                                                                   0x1a3b
#define regSPI_SHADER_USER_DATA_GS_15_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_16                                                                   0x1a3c
#define regSPI_SHADER_USER_DATA_GS_16_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_17                                                                   0x1a3d
#define regSPI_SHADER_USER_DATA_GS_17_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_18                                                                   0x1a3e
#define regSPI_SHADER_USER_DATA_GS_18_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_19                                                                   0x1a3f
#define regSPI_SHADER_USER_DATA_GS_19_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_20                                                                   0x1a40
#define regSPI_SHADER_USER_DATA_GS_20_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_21                                                                   0x1a41
#define regSPI_SHADER_USER_DATA_GS_21_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_22                                                                   0x1a42
#define regSPI_SHADER_USER_DATA_GS_22_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_23                                                                   0x1a43
#define regSPI_SHADER_USER_DATA_GS_23_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_24                                                                   0x1a44
#define regSPI_SHADER_USER_DATA_GS_24_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_25                                                                   0x1a45
#define regSPI_SHADER_USER_DATA_GS_25_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_26                                                                   0x1a46
#define regSPI_SHADER_USER_DATA_GS_26_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_27                                                                   0x1a47
#define regSPI_SHADER_USER_DATA_GS_27_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_28                                                                   0x1a48
#define regSPI_SHADER_USER_DATA_GS_28_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_29                                                                   0x1a49
#define regSPI_SHADER_USER_DATA_GS_29_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_30                                                                   0x1a4a
#define regSPI_SHADER_USER_DATA_GS_30_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_GS_31                                                                   0x1a4b
#define regSPI_SHADER_USER_DATA_GS_31_BASE_IDX                                                          0
#define regSPI_SHADER_GS_MESHLET_DIM                                                                    0x1a4c
#define regSPI_SHADER_GS_MESHLET_DIM_BASE_IDX                                                           0
#define regSPI_SHADER_GS_MESHLET_EXP_ALLOC                                                              0x1a4d
#define regSPI_SHADER_GS_MESHLET_EXP_ALLOC_BASE_IDX                                                     0
#define regSPI_SHADER_GS_MESHLET_CTRL                                                                   0x1a4e
#define regSPI_SHADER_GS_MESHLET_CTRL_BASE_IDX                                                          0
#define regSPI_SHADER_REQ_CTRL_ESGS                                                                     0x1a50
#define regSPI_SHADER_REQ_CTRL_ESGS_BASE_IDX                                                            0
#define regSPI_SHADER_GS_OUT_CONFIG_PS_GS                                                               0x1a51
#define regSPI_SHADER_GS_OUT_CONFIG_PS_GS_BASE_IDX                                                      0
#define regSPI_SHADER_USER_ACCUM_ESGS_0                                                                 0x1a52
#define regSPI_SHADER_USER_ACCUM_ESGS_0_BASE_IDX                                                        0
#define regSPI_SHADER_USER_ACCUM_ESGS_1                                                                 0x1a53
#define regSPI_SHADER_USER_ACCUM_ESGS_1_BASE_IDX                                                        0
#define regSPI_SHADER_USER_ACCUM_ESGS_2                                                                 0x1a54
#define regSPI_SHADER_USER_ACCUM_ESGS_2_BASE_IDX                                                        0
#define regSPI_SHADER_USER_ACCUM_ESGS_3                                                                 0x1a55
#define regSPI_SHADER_USER_ACCUM_ESGS_3_BASE_IDX                                                        0
#define regSPI_SHADER_PGM_CHKSUM_HS                                                                     0x1aa0
#define regSPI_SHADER_PGM_CHKSUM_HS_BASE_IDX                                                            0
#define regSPI_SHADER_USER_DATA_ADDR_LO_HS                                                              0x1aa2
#define regSPI_SHADER_USER_DATA_ADDR_LO_HS_BASE_IDX                                                     0
#define regSPI_SHADER_USER_DATA_ADDR_HI_HS                                                              0x1aa3
#define regSPI_SHADER_USER_DATA_ADDR_HI_HS_BASE_IDX                                                     0
#define regSPI_SHADER_PGM_LO_HS                                                                         0x1aa4
#define regSPI_SHADER_PGM_LO_HS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_HS                                                                         0x1aa5
#define regSPI_SHADER_PGM_HI_HS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_HI_LS                                                                         0x1aa6
#define regSPI_SHADER_PGM_HI_LS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC3_HS                                                                      0x1aa7
#define regSPI_SHADER_PGM_RSRC3_HS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC4_HS                                                                      0x1aa8
#define regSPI_SHADER_PGM_RSRC4_HS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_LO_LS                                                                         0x1aa9
#define regSPI_SHADER_PGM_LO_LS_BASE_IDX                                                                0
#define regSPI_SHADER_PGM_RSRC1_HS                                                                      0x1aaa
#define regSPI_SHADER_PGM_RSRC1_HS_BASE_IDX                                                             0
#define regSPI_SHADER_PGM_RSRC2_HS                                                                      0x1aab
#define regSPI_SHADER_PGM_RSRC2_HS_BASE_IDX                                                             0
#define regSPI_SHADER_USER_DATA_HS_0                                                                    0x1aac
#define regSPI_SHADER_USER_DATA_HS_0_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_1                                                                    0x1aad
#define regSPI_SHADER_USER_DATA_HS_1_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_2                                                                    0x1aae
#define regSPI_SHADER_USER_DATA_HS_2_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_3                                                                    0x1aaf
#define regSPI_SHADER_USER_DATA_HS_3_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_4                                                                    0x1ab0
#define regSPI_SHADER_USER_DATA_HS_4_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_5                                                                    0x1ab1
#define regSPI_SHADER_USER_DATA_HS_5_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_6                                                                    0x1ab2
#define regSPI_SHADER_USER_DATA_HS_6_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_7                                                                    0x1ab3
#define regSPI_SHADER_USER_DATA_HS_7_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_8                                                                    0x1ab4
#define regSPI_SHADER_USER_DATA_HS_8_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_9                                                                    0x1ab5
#define regSPI_SHADER_USER_DATA_HS_9_BASE_IDX                                                           0
#define regSPI_SHADER_USER_DATA_HS_10                                                                   0x1ab6
#define regSPI_SHADER_USER_DATA_HS_10_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_11                                                                   0x1ab7
#define regSPI_SHADER_USER_DATA_HS_11_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_12                                                                   0x1ab8
#define regSPI_SHADER_USER_DATA_HS_12_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_13                                                                   0x1ab9
#define regSPI_SHADER_USER_DATA_HS_13_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_14                                                                   0x1aba
#define regSPI_SHADER_USER_DATA_HS_14_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_15                                                                   0x1abb
#define regSPI_SHADER_USER_DATA_HS_15_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_16                                                                   0x1abc
#define regSPI_SHADER_USER_DATA_HS_16_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_17                                                                   0x1abd
#define regSPI_SHADER_USER_DATA_HS_17_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_18                                                                   0x1abe
#define regSPI_SHADER_USER_DATA_HS_18_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_19                                                                   0x1abf
#define regSPI_SHADER_USER_DATA_HS_19_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_20                                                                   0x1ac0
#define regSPI_SHADER_USER_DATA_HS_20_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_21                                                                   0x1ac1
#define regSPI_SHADER_USER_DATA_HS_21_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_22                                                                   0x1ac2
#define regSPI_SHADER_USER_DATA_HS_22_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_23                                                                   0x1ac3
#define regSPI_SHADER_USER_DATA_HS_23_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_24                                                                   0x1ac4
#define regSPI_SHADER_USER_DATA_HS_24_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_25                                                                   0x1ac5
#define regSPI_SHADER_USER_DATA_HS_25_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_26                                                                   0x1ac6
#define regSPI_SHADER_USER_DATA_HS_26_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_27                                                                   0x1ac7
#define regSPI_SHADER_USER_DATA_HS_27_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_28                                                                   0x1ac8
#define regSPI_SHADER_USER_DATA_HS_28_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_29                                                                   0x1ac9
#define regSPI_SHADER_USER_DATA_HS_29_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_30                                                                   0x1aca
#define regSPI_SHADER_USER_DATA_HS_30_BASE_IDX                                                          0
#define regSPI_SHADER_USER_DATA_HS_31                                                                   0x1acb
#define regSPI_SHADER_USER_DATA_HS_31_BASE_IDX                                                          0
#define regSPI_SHADER_REQ_CTRL_LSHS                                                                     0x1ad0
#define regSPI_SHADER_REQ_CTRL_LSHS_BASE_IDX                                                            0
#define regSPI_SHADER_USER_ACCUM_LSHS_0                                                                 0x1ad2
#define regSPI_SHADER_USER_ACCUM_LSHS_0_BASE_IDX                                                        0
#define regSPI_SHADER_USER_ACCUM_LSHS_1                                                                 0x1ad3
#define regSPI_SHADER_USER_ACCUM_LSHS_1_BASE_IDX                                                        0
#define regSPI_SHADER_USER_ACCUM_LSHS_2                                                                 0x1ad4
#define regSPI_SHADER_USER_ACCUM_LSHS_2_BASE_IDX                                                        0
#define regSPI_SHADER_USER_ACCUM_LSHS_3                                                                 0x1ad5
#define regSPI_SHADER_USER_ACCUM_LSHS_3_BASE_IDX                                                        0


// addressBlock: gc_gfx_se_gfx_se_spipdec
// base address: 0xc700
#define regSPI_ARB_PRIORITY                                                                             0x1f60
#define regSPI_ARB_PRIORITY_BASE_IDX                                                                    0
#define regSPI_ARB_CYCLES_0                                                                             0x1f61
#define regSPI_ARB_CYCLES_0_BASE_IDX                                                                    0
#define regSPI_ARB_CYCLES_1                                                                             0x1f62
#define regSPI_ARB_CYCLES_1_BASE_IDX                                                                    0
#define regSPI_WCL_PIPE_PERCENT_GFX                                                                     0x1f67
#define regSPI_WCL_PIPE_PERCENT_GFX_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_HP3D                                                                    0x1f68
#define regSPI_WCL_PIPE_PERCENT_HP3D_BASE_IDX                                                           0
#define regSPI_WCL_PIPE_PERCENT_CS0                                                                     0x1f69
#define regSPI_WCL_PIPE_PERCENT_CS0_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS1                                                                     0x1f6a
#define regSPI_WCL_PIPE_PERCENT_CS1_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS2                                                                     0x1f6b
#define regSPI_WCL_PIPE_PERCENT_CS2_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS3                                                                     0x1f6c
#define regSPI_WCL_PIPE_PERCENT_CS3_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS4                                                                     0x1f6d
#define regSPI_WCL_PIPE_PERCENT_CS4_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS5                                                                     0x1f6e
#define regSPI_WCL_PIPE_PERCENT_CS5_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS6                                                                     0x1f6f
#define regSPI_WCL_PIPE_PERCENT_CS6_BASE_IDX                                                            0
#define regSPI_WCL_PIPE_PERCENT_CS7                                                                     0x1f70
#define regSPI_WCL_PIPE_PERCENT_CS7_BASE_IDX                                                            0
#define regSPI_USER_ACCUM_VMID_CNTL                                                                     0x1f71
#define regSPI_USER_ACCUM_VMID_CNTL_BASE_IDX                                                            0
#define regSPI_GDBG_PER_VMID_CNTL                                                                       0x1f72
#define regSPI_GDBG_PER_VMID_CNTL_BASE_IDX                                                              0
#define regSPI_COMPUTE_QUEUE_RESET                                                                      0x1f73
#define regSPI_COMPUTE_QUEUE_RESET_BASE_IDX                                                             0
#define regSPI_COMPUTE_WF_CTX_SAVE                                                                      0x1f74
#define regSPI_COMPUTE_WF_CTX_SAVE_BASE_IDX                                                             0
#define regSPI_SAVE_RESTORE_STATUS                                                                      0x1f75
#define regSPI_SAVE_RESTORE_STATUS_BASE_IDX                                                             0


// addressBlock: gc_gfx_se_gfx_se_tcpdec
// base address: 0xca80
#define regTCP_WATCH0_ADDR_H                                                                            0x2048
#define regTCP_WATCH0_ADDR_H_BASE_IDX                                                                   0
#define regTCP_WATCH0_ADDR_L                                                                            0x2049
#define regTCP_WATCH0_ADDR_L_BASE_IDX                                                                   0
#define regTCP_WATCH0_CNTL                                                                              0x204a
#define regTCP_WATCH0_CNTL_BASE_IDX                                                                     0
#define regTCP_WATCH1_ADDR_H                                                                            0x204b
#define regTCP_WATCH1_ADDR_H_BASE_IDX                                                                   0
#define regTCP_WATCH1_ADDR_L                                                                            0x204c
#define regTCP_WATCH1_ADDR_L_BASE_IDX                                                                   0
#define regTCP_WATCH1_CNTL                                                                              0x204d
#define regTCP_WATCH1_CNTL_BASE_IDX                                                                     0
#define regTCP_WATCH2_ADDR_H                                                                            0x204e
#define regTCP_WATCH2_ADDR_H_BASE_IDX                                                                   0
#define regTCP_WATCH2_ADDR_L                                                                            0x204f
#define regTCP_WATCH2_ADDR_L_BASE_IDX                                                                   0
#define regTCP_WATCH2_CNTL                                                                              0x2050
#define regTCP_WATCH2_CNTL_BASE_IDX                                                                     0
#define regTCP_WATCH3_ADDR_H                                                                            0x2051
#define regTCP_WATCH3_ADDR_H_BASE_IDX                                                                   0
#define regTCP_WATCH3_ADDR_L                                                                            0x2052
#define regTCP_WATCH3_ADDR_L_BASE_IDX                                                                   0
#define regTCP_WATCH3_CNTL                                                                              0x2053
#define regTCP_WATCH3_CNTL_BASE_IDX                                                                     0


// addressBlock: gc_gfx_se_gfx_se_rasdec
// base address: 0xce00
#define regRAS_SIGNATURE_CONTROL                                                                        0x2120
#define regRAS_SIGNATURE_CONTROL_BASE_IDX                                                               0
#define regRAS_SIGNATURE_MASK                                                                           0x2121
#define regRAS_SIGNATURE_MASK_BASE_IDX                                                                  0
#define regRAS_SX_SIGNATURE0                                                                            0x2122
#define regRAS_SX_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_SX_SIGNATURE1                                                                            0x2123
#define regRAS_SX_SIGNATURE1_BASE_IDX                                                                   0
#define regRAS_SX_SIGNATURE2                                                                            0x2124
#define regRAS_SX_SIGNATURE2_BASE_IDX                                                                   0
#define regRAS_SX_SIGNATURE3                                                                            0x2125
#define regRAS_SX_SIGNATURE3_BASE_IDX                                                                   0
#define regRAS_DB_SIGNATURE0                                                                            0x212b
#define regRAS_DB_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_PA_SIGNATURE0                                                                            0x212c
#define regRAS_PA_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE0                                                                            0x212f
#define regRAS_SC_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE1                                                                            0x2130
#define regRAS_SC_SIGNATURE1_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE2                                                                            0x2131
#define regRAS_SC_SIGNATURE2_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE3                                                                            0x2132
#define regRAS_SC_SIGNATURE3_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE4                                                                            0x2133
#define regRAS_SC_SIGNATURE4_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE5                                                                            0x2134
#define regRAS_SC_SIGNATURE5_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE6                                                                            0x2135
#define regRAS_SC_SIGNATURE6_BASE_IDX                                                                   0
#define regRAS_SC_SIGNATURE7                                                                            0x2136
#define regRAS_SC_SIGNATURE7_BASE_IDX                                                                   0
#define regRAS_SPI_SIGNATURE0                                                                           0x2139
#define regRAS_SPI_SIGNATURE0_BASE_IDX                                                                  0
#define regRAS_SPI_SIGNATURE1                                                                           0x213a
#define regRAS_SPI_SIGNATURE1_BASE_IDX                                                                  0
#define regRAS_CB_SIGNATURE0                                                                            0x213d
#define regRAS_CB_SIGNATURE0_BASE_IDX                                                                   0
#define regRAS_BCI_SIGNATURE0                                                                           0x213e
#define regRAS_BCI_SIGNATURE0_BASE_IDX                                                                  0
#define regRAS_BCI_SIGNATURE1                                                                           0x213f
#define regRAS_BCI_SIGNATURE1_BASE_IDX                                                                  0
#define regRAS_GE_SIGNATURE1                                                                            0x214d
#define regRAS_GE_SIGNATURE1_BASE_IDX                                                                   0


// addressBlock: gc_gfx_se_gfx_se_gfxdec0
// base address: 0x28000
#define regDB_RENDER_CONTROL                                                                            0x0000
#define regDB_RENDER_CONTROL_BASE_IDX                                                                   1
#define regDB_DEPTH_VIEW                                                                                0x0001
#define regDB_DEPTH_VIEW_BASE_IDX                                                                       1
#define regDB_DEPTH_VIEW1                                                                               0x0002
#define regDB_DEPTH_VIEW1_BASE_IDX                                                                      1
#define regDB_RENDER_OVERRIDE                                                                           0x0003
#define regDB_RENDER_OVERRIDE_BASE_IDX                                                                  1
#define regDB_RENDER_OVERRIDE2                                                                          0x0004
#define regDB_RENDER_OVERRIDE2_BASE_IDX                                                                 1
#define regDB_DEPTH_SIZE_XY                                                                             0x0005
#define regDB_DEPTH_SIZE_XY_BASE_IDX                                                                    1
#define regDB_Z_INFO                                                                                    0x0006
#define regDB_Z_INFO_BASE_IDX                                                                           1
#define regDB_STENCIL_INFO                                                                              0x0007
#define regDB_STENCIL_INFO_BASE_IDX                                                                     1
#define regDB_Z_READ_BASE                                                                               0x0008
#define regDB_Z_READ_BASE_BASE_IDX                                                                      1
#define regDB_Z_READ_BASE_HI                                                                            0x0009
#define regDB_Z_READ_BASE_HI_BASE_IDX                                                                   1
#define regDB_Z_WRITE_BASE                                                                              0x000a
#define regDB_Z_WRITE_BASE_BASE_IDX                                                                     1
#define regDB_Z_WRITE_BASE_HI                                                                           0x000b
#define regDB_Z_WRITE_BASE_HI_BASE_IDX                                                                  1
#define regDB_STENCIL_READ_BASE                                                                         0x000c
#define regDB_STENCIL_READ_BASE_BASE_IDX                                                                1
#define regDB_STENCIL_READ_BASE_HI                                                                      0x000d
#define regDB_STENCIL_READ_BASE_HI_BASE_IDX                                                             1
#define regDB_STENCIL_WRITE_BASE                                                                        0x000e
#define regDB_STENCIL_WRITE_BASE_BASE_IDX                                                               1
#define regDB_STENCIL_WRITE_BASE_HI                                                                     0x000f
#define regDB_STENCIL_WRITE_BASE_HI_BASE_IDX                                                            1
#define regDB_GL1_INTERFACE_CONTROL                                                                     0x0010
#define regDB_GL1_INTERFACE_CONTROL_BASE_IDX                                                            1
#define regDB_MEM_TEMPORAL                                                                              0x0012
#define regDB_MEM_TEMPORAL_BASE_IDX                                                                     1
#define regDB_DEPTH_BOUNDS_MIN                                                                          0x0014
#define regDB_DEPTH_BOUNDS_MIN_BASE_IDX                                                                 1
#define regDB_DEPTH_BOUNDS_MAX                                                                          0x0015
#define regDB_DEPTH_BOUNDS_MAX_BASE_IDX                                                                 1
#define regDB_COUNT_CONTROL                                                                             0x0018
#define regDB_COUNT_CONTROL_BASE_IDX                                                                    1
#define regDB_VIEWPORT_CONTROL                                                                          0x0019
#define regDB_VIEWPORT_CONTROL_BASE_IDX                                                                 1
#define regDB_SPI_VRS_CENTER_LOCATION                                                                   0x001a
#define regDB_SPI_VRS_CENTER_LOCATION_BASE_IDX                                                          1
#define regDB_SHADER_CONTROL                                                                            0x001b
#define regDB_SHADER_CONTROL_BASE_IDX                                                                   1
#define regDB_DEPTH_CONTROL                                                                             0x001c
#define regDB_DEPTH_CONTROL_BASE_IDX                                                                    1
#define regDB_STENCIL_CONTROL                                                                           0x001d
#define regDB_STENCIL_CONTROL_BASE_IDX                                                                  1
#define regDB_EQAA                                                                                      0x001e
#define regDB_EQAA_BASE_IDX                                                                             1
#define regDB_ALPHA_TO_MASK                                                                             0x001f
#define regDB_ALPHA_TO_MASK_BASE_IDX                                                                    1
#define regTA_BC_BASE_ADDR                                                                              0x0020
#define regTA_BC_BASE_ADDR_BASE_IDX                                                                     1
#define regTA_BC_BASE_ADDR_HI                                                                           0x0021
#define regTA_BC_BASE_ADDR_HI_BASE_IDX                                                                  1
#define regDB_STENCIL_REF                                                                               0x0022
#define regDB_STENCIL_REF_BASE_IDX                                                                      1
#define regDB_STENCIL_OPVAL                                                                             0x0023
#define regDB_STENCIL_OPVAL_BASE_IDX                                                                    1
#define regDB_STENCIL_READ_MASK                                                                         0x0024
#define regDB_STENCIL_READ_MASK_BASE_IDX                                                                1
#define regDB_STENCIL_WRITE_MASK                                                                        0x0025
#define regDB_STENCIL_WRITE_MASK_BASE_IDX                                                               1
#define regSC_MEM_TEMPORAL                                                                              0x003e
#define regSC_MEM_TEMPORAL_BASE_IDX                                                                     1
#define regSC_MEM_SPEC_READ                                                                             0x003f
#define regSC_MEM_SPEC_READ_BASE_IDX                                                                    1
#define regPA_SC_VPORT_0_TL                                                                             0x0040
#define regPA_SC_VPORT_0_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_0_BR                                                                             0x0041
#define regPA_SC_VPORT_0_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_1_TL                                                                             0x0042
#define regPA_SC_VPORT_1_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_1_BR                                                                             0x0043
#define regPA_SC_VPORT_1_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_2_TL                                                                             0x0044
#define regPA_SC_VPORT_2_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_2_BR                                                                             0x0045
#define regPA_SC_VPORT_2_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_3_TL                                                                             0x0046
#define regPA_SC_VPORT_3_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_3_BR                                                                             0x0047
#define regPA_SC_VPORT_3_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_4_TL                                                                             0x0048
#define regPA_SC_VPORT_4_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_4_BR                                                                             0x0049
#define regPA_SC_VPORT_4_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_5_TL                                                                             0x004a
#define regPA_SC_VPORT_5_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_5_BR                                                                             0x004b
#define regPA_SC_VPORT_5_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_6_TL                                                                             0x004c
#define regPA_SC_VPORT_6_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_6_BR                                                                             0x004d
#define regPA_SC_VPORT_6_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_7_TL                                                                             0x004e
#define regPA_SC_VPORT_7_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_7_BR                                                                             0x004f
#define regPA_SC_VPORT_7_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_8_TL                                                                             0x0050
#define regPA_SC_VPORT_8_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_8_BR                                                                             0x0051
#define regPA_SC_VPORT_8_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_9_TL                                                                             0x0052
#define regPA_SC_VPORT_9_TL_BASE_IDX                                                                    1
#define regPA_SC_VPORT_9_BR                                                                             0x0053
#define regPA_SC_VPORT_9_BR_BASE_IDX                                                                    1
#define regPA_SC_VPORT_10_TL                                                                            0x0054
#define regPA_SC_VPORT_10_TL_BASE_IDX                                                                   1
#define regPA_SC_VPORT_10_BR                                                                            0x0055
#define regPA_SC_VPORT_10_BR_BASE_IDX                                                                   1
#define regPA_SC_VPORT_11_TL                                                                            0x0056
#define regPA_SC_VPORT_11_TL_BASE_IDX                                                                   1
#define regPA_SC_VPORT_11_BR                                                                            0x0057
#define regPA_SC_VPORT_11_BR_BASE_IDX                                                                   1
#define regPA_SC_VPORT_12_TL                                                                            0x0058
#define regPA_SC_VPORT_12_TL_BASE_IDX                                                                   1
#define regPA_SC_VPORT_12_BR                                                                            0x0059
#define regPA_SC_VPORT_12_BR_BASE_IDX                                                                   1
#define regPA_SC_VPORT_13_TL                                                                            0x005a
#define regPA_SC_VPORT_13_TL_BASE_IDX                                                                   1
#define regPA_SC_VPORT_13_BR                                                                            0x005b
#define regPA_SC_VPORT_13_BR_BASE_IDX                                                                   1
#define regPA_SC_VPORT_14_TL                                                                            0x005c
#define regPA_SC_VPORT_14_TL_BASE_IDX                                                                   1
#define regPA_SC_VPORT_14_BR                                                                            0x005d
#define regPA_SC_VPORT_14_BR_BASE_IDX                                                                   1
#define regPA_SC_VPORT_15_TL                                                                            0x005e
#define regPA_SC_VPORT_15_TL_BASE_IDX                                                                   1
#define regPA_SC_VPORT_15_BR                                                                            0x005f
#define regPA_SC_VPORT_15_BR_BASE_IDX                                                                   1
#define regPA_SC_SCREEN_SCISSOR_TL                                                                      0x0060
#define regPA_SC_SCREEN_SCISSOR_TL_BASE_IDX                                                             1
#define regPA_SC_SCREEN_SCISSOR_BR                                                                      0x0061
#define regPA_SC_SCREEN_SCISSOR_BR_BASE_IDX                                                             1
#define regPA_SC_WINDOW_OFFSET                                                                          0x0080
#define regPA_SC_WINDOW_OFFSET_BASE_IDX                                                                 1
#define regPA_SC_WINDOW_SCISSOR_TL                                                                      0x0081
#define regPA_SC_WINDOW_SCISSOR_TL_BASE_IDX                                                             1
#define regPA_SC_WINDOW_SCISSOR_BR                                                                      0x0082
#define regPA_SC_WINDOW_SCISSOR_BR_BASE_IDX                                                             1
#define regPA_SC_CLIPRECT_RULE                                                                          0x0083
#define regPA_SC_CLIPRECT_RULE_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_0_TL                                                                          0x0084
#define regPA_SC_CLIPRECT_0_TL_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_0_BR                                                                          0x0085
#define regPA_SC_CLIPRECT_0_BR_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_1_TL                                                                          0x0086
#define regPA_SC_CLIPRECT_1_TL_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_1_BR                                                                          0x0087
#define regPA_SC_CLIPRECT_1_BR_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_2_TL                                                                          0x0088
#define regPA_SC_CLIPRECT_2_TL_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_2_BR                                                                          0x0089
#define regPA_SC_CLIPRECT_2_BR_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_3_TL                                                                          0x008a
#define regPA_SC_CLIPRECT_3_TL_BASE_IDX                                                                 1
#define regPA_SC_CLIPRECT_3_BR                                                                          0x008b
#define regPA_SC_CLIPRECT_3_BR_BASE_IDX                                                                 1
#define regPA_SC_EDGERULE                                                                               0x008c
#define regPA_SC_EDGERULE_BASE_IDX                                                                      1
#define regPA_SU_HARDWARE_SCREEN_OFFSET                                                                 0x008d
#define regPA_SU_HARDWARE_SCREEN_OFFSET_BASE_IDX                                                        1
#define regPA_SC_GENERIC_SCISSOR_TL                                                                     0x0090
#define regPA_SC_GENERIC_SCISSOR_TL_BASE_IDX                                                            1
#define regPA_SC_GENERIC_SCISSOR_BR                                                                     0x0091
#define regPA_SC_GENERIC_SCISSOR_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_0_TL                                                                     0x0094
#define regPA_SC_VPORT_SCISSOR_0_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_0_BR                                                                     0x0095
#define regPA_SC_VPORT_SCISSOR_0_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_1_TL                                                                     0x0096
#define regPA_SC_VPORT_SCISSOR_1_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_1_BR                                                                     0x0097
#define regPA_SC_VPORT_SCISSOR_1_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_2_TL                                                                     0x0098
#define regPA_SC_VPORT_SCISSOR_2_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_2_BR                                                                     0x0099
#define regPA_SC_VPORT_SCISSOR_2_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_3_TL                                                                     0x009a
#define regPA_SC_VPORT_SCISSOR_3_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_3_BR                                                                     0x009b
#define regPA_SC_VPORT_SCISSOR_3_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_4_TL                                                                     0x009c
#define regPA_SC_VPORT_SCISSOR_4_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_4_BR                                                                     0x009d
#define regPA_SC_VPORT_SCISSOR_4_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_5_TL                                                                     0x009e
#define regPA_SC_VPORT_SCISSOR_5_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_5_BR                                                                     0x009f
#define regPA_SC_VPORT_SCISSOR_5_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_6_TL                                                                     0x00a0
#define regPA_SC_VPORT_SCISSOR_6_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_6_BR                                                                     0x00a1
#define regPA_SC_VPORT_SCISSOR_6_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_7_TL                                                                     0x00a2
#define regPA_SC_VPORT_SCISSOR_7_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_7_BR                                                                     0x00a3
#define regPA_SC_VPORT_SCISSOR_7_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_8_TL                                                                     0x00a4
#define regPA_SC_VPORT_SCISSOR_8_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_8_BR                                                                     0x00a5
#define regPA_SC_VPORT_SCISSOR_8_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_9_TL                                                                     0x00a6
#define regPA_SC_VPORT_SCISSOR_9_TL_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_9_BR                                                                     0x00a7
#define regPA_SC_VPORT_SCISSOR_9_BR_BASE_IDX                                                            1
#define regPA_SC_VPORT_SCISSOR_10_TL                                                                    0x00a8
#define regPA_SC_VPORT_SCISSOR_10_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_10_BR                                                                    0x00a9
#define regPA_SC_VPORT_SCISSOR_10_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_11_TL                                                                    0x00aa
#define regPA_SC_VPORT_SCISSOR_11_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_11_BR                                                                    0x00ab
#define regPA_SC_VPORT_SCISSOR_11_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_12_TL                                                                    0x00ac
#define regPA_SC_VPORT_SCISSOR_12_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_12_BR                                                                    0x00ad
#define regPA_SC_VPORT_SCISSOR_12_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_13_TL                                                                    0x00ae
#define regPA_SC_VPORT_SCISSOR_13_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_13_BR                                                                    0x00af
#define regPA_SC_VPORT_SCISSOR_13_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_14_TL                                                                    0x00b0
#define regPA_SC_VPORT_SCISSOR_14_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_14_BR                                                                    0x00b1
#define regPA_SC_VPORT_SCISSOR_14_BR_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_15_TL                                                                    0x00b2
#define regPA_SC_VPORT_SCISSOR_15_TL_BASE_IDX                                                           1
#define regPA_SC_VPORT_SCISSOR_15_BR                                                                    0x00b3
#define regPA_SC_VPORT_SCISSOR_15_BR_BASE_IDX                                                           1
#define regPA_CL_UCP_0_X                                                                                0x00b4
#define regPA_CL_UCP_0_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_0_Y                                                                                0x00b5
#define regPA_CL_UCP_0_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_0_Z                                                                                0x00b6
#define regPA_CL_UCP_0_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_0_W                                                                                0x00b7
#define regPA_CL_UCP_0_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_1_X                                                                                0x00b8
#define regPA_CL_UCP_1_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_1_Y                                                                                0x00b9
#define regPA_CL_UCP_1_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_1_Z                                                                                0x00ba
#define regPA_CL_UCP_1_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_1_W                                                                                0x00bb
#define regPA_CL_UCP_1_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_2_X                                                                                0x00bc
#define regPA_CL_UCP_2_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_2_Y                                                                                0x00bd
#define regPA_CL_UCP_2_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_2_Z                                                                                0x00be
#define regPA_CL_UCP_2_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_2_W                                                                                0x00bf
#define regPA_CL_UCP_2_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_3_X                                                                                0x00c0
#define regPA_CL_UCP_3_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_3_Y                                                                                0x00c1
#define regPA_CL_UCP_3_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_3_Z                                                                                0x00c2
#define regPA_CL_UCP_3_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_3_W                                                                                0x00c3
#define regPA_CL_UCP_3_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_4_X                                                                                0x00c4
#define regPA_CL_UCP_4_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_4_Y                                                                                0x00c5
#define regPA_CL_UCP_4_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_4_Z                                                                                0x00c6
#define regPA_CL_UCP_4_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_4_W                                                                                0x00c7
#define regPA_CL_UCP_4_W_BASE_IDX                                                                       1
#define regPA_CL_UCP_5_X                                                                                0x00c8
#define regPA_CL_UCP_5_X_BASE_IDX                                                                       1
#define regPA_CL_UCP_5_Y                                                                                0x00c9
#define regPA_CL_UCP_5_Y_BASE_IDX                                                                       1
#define regPA_CL_UCP_5_Z                                                                                0x00ca
#define regPA_CL_UCP_5_Z_BASE_IDX                                                                       1
#define regPA_CL_UCP_5_W                                                                                0x00cb
#define regPA_CL_UCP_5_W_BASE_IDX                                                                       1
#define regPA_CL_PROG_NEAR_CLIP_Z                                                                       0x00cc
#define regPA_CL_PROG_NEAR_CLIP_Z_BASE_IDX                                                              1
#define regPA_RATE_CNTL                                                                                 0x00cd
#define regPA_RATE_CNTL_BASE_IDX                                                                        1
#define regPA_SC_RASTER_CONFIG                                                                          0x00d4
#define regPA_SC_RASTER_CONFIG_BASE_IDX                                                                 1
#define regPA_SC_RASTER_CONFIG_1                                                                        0x00d5
#define regPA_SC_RASTER_CONFIG_1_BASE_IDX                                                               1
#define regPA_SC_SCREEN_EXTENT_CONTROL                                                                  0x00d6
#define regPA_SC_SCREEN_EXTENT_CONTROL_BASE_IDX                                                         1
#define regPA_SC_TILE_STEERING_OVERRIDE                                                                 0x00d7
#define regPA_SC_TILE_STEERING_OVERRIDE_BASE_IDX                                                        1
#define regCB_CP_PIPEID                                                                                 0x00d9
#define regCB_CP_PIPEID_BASE_IDX                                                                        1
#define regCB_CP_VMID                                                                                   0x00da
#define regCB_CP_VMID_BASE_IDX                                                                          1
#define regPA_SC_CLIPRECT_0_EXT                                                                         0x00dd
#define regPA_SC_CLIPRECT_0_EXT_BASE_IDX                                                                1
#define regPA_SC_CLIPRECT_1_EXT                                                                         0x00de
#define regPA_SC_CLIPRECT_1_EXT_BASE_IDX                                                                1
#define regPA_SC_CLIPRECT_2_EXT                                                                         0x00df
#define regPA_SC_CLIPRECT_2_EXT_BASE_IDX                                                                1
#define regPA_SC_CLIPRECT_3_EXT                                                                         0x00e0
#define regPA_SC_CLIPRECT_3_EXT_BASE_IDX                                                                1
#define regPA_SC_VRS_OVERRIDE_CNTL                                                                      0x00f4
#define regPA_SC_VRS_OVERRIDE_CNTL_BASE_IDX                                                             1
#define regPA_SC_VRS_RATE_FEEDBACK_BASE                                                                 0x00f5
#define regPA_SC_VRS_RATE_FEEDBACK_BASE_BASE_IDX                                                        1
#define regPA_SC_VRS_RATE_FEEDBACK_BASE_EXT                                                             0x00f6
#define regPA_SC_VRS_RATE_FEEDBACK_BASE_EXT_BASE_IDX                                                    1
#define regPA_SC_VRS_RATE_FEEDBACK_SIZE_XY                                                              0x00f7
#define regPA_SC_VRS_RATE_FEEDBACK_SIZE_XY_BASE_IDX                                                     1
#define regPA_SC_VRS_INFO                                                                               0x00f8
#define regPA_SC_VRS_INFO_BASE_IDX                                                                      1
#define regPA_SC_VRS_RATE_BASE                                                                          0x00fc
#define regPA_SC_VRS_RATE_BASE_BASE_IDX                                                                 1
#define regPA_SC_VRS_RATE_BASE_EXT                                                                      0x00fd
#define regPA_SC_VRS_RATE_BASE_EXT_BASE_IDX                                                             1
#define regPA_SC_VRS_RATE_SIZE_XY                                                                       0x00fe
#define regPA_SC_VRS_RATE_SIZE_XY_BASE_IDX                                                              1
#define regCB_RMI_GL2_CACHE_CONTROL                                                                     0x0104
#define regCB_RMI_GL2_CACHE_CONTROL_BASE_IDX                                                            1
#define regCB_BLEND_RED                                                                                 0x0105
#define regCB_BLEND_RED_BASE_IDX                                                                        1
#define regCB_BLEND_GREEN                                                                               0x0106
#define regCB_BLEND_GREEN_BASE_IDX                                                                      1
#define regCB_BLEND_BLUE                                                                                0x0107
#define regCB_BLEND_BLUE_BASE_IDX                                                                       1
#define regCB_BLEND_ALPHA                                                                               0x0108
#define regCB_BLEND_ALPHA_BASE_IDX                                                                      1
#define regPA_CL_GB_VERT_CLIP_ADJ                                                                       0x010b
#define regPA_CL_GB_VERT_CLIP_ADJ_BASE_IDX                                                              1
#define regPA_CL_GB_VERT_DISC_ADJ                                                                       0x010c
#define regPA_CL_GB_VERT_DISC_ADJ_BASE_IDX                                                              1
#define regPA_CL_GB_HORZ_CLIP_ADJ                                                                       0x010d
#define regPA_CL_GB_HORZ_CLIP_ADJ_BASE_IDX                                                              1
#define regPA_CL_GB_HORZ_DISC_ADJ                                                                       0x010e
#define regPA_CL_GB_HORZ_DISC_ADJ_BASE_IDX                                                              1
#define regPA_CL_VPORT_XSCALE                                                                           0x010f
#define regPA_CL_VPORT_XSCALE_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XOFFSET                                                                          0x0110
#define regPA_CL_VPORT_XOFFSET_BASE_IDX                                                                 1
#define regPA_CL_VPORT_YSCALE                                                                           0x0111
#define regPA_CL_VPORT_YSCALE_BASE_IDX                                                                  1
#define regPA_CL_VPORT_YOFFSET                                                                          0x0112
#define regPA_CL_VPORT_YOFFSET_BASE_IDX                                                                 1
#define regPA_CL_VPORT_ZSCALE                                                                           0x0113
#define regPA_CL_VPORT_ZSCALE_BASE_IDX                                                                  1
#define regPA_CL_VPORT_ZOFFSET                                                                          0x0114
#define regPA_CL_VPORT_ZOFFSET_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMIN_0                                                                           0x0115
#define regPA_SC_VPORT_ZMIN_0_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_0                                                                           0x0116
#define regPA_SC_VPORT_ZMAX_0_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_1                                                                         0x0117
#define regPA_CL_VPORT_XSCALE_1_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_1                                                                        0x0118
#define regPA_CL_VPORT_XOFFSET_1_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_1                                                                         0x0119
#define regPA_CL_VPORT_YSCALE_1_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_1                                                                        0x011a
#define regPA_CL_VPORT_YOFFSET_1_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_1                                                                         0x011b
#define regPA_CL_VPORT_ZSCALE_1_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_1                                                                        0x011c
#define regPA_CL_VPORT_ZOFFSET_1_BASE_IDX                                                               1
#define regPA_SC_VPORT_ZMIN_1                                                                           0x011d
#define regPA_SC_VPORT_ZMIN_1_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_1                                                                           0x011e
#define regPA_SC_VPORT_ZMAX_1_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_2                                                                         0x011f
#define regPA_CL_VPORT_XSCALE_2_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_2                                                                        0x0120
#define regPA_CL_VPORT_XOFFSET_2_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_2                                                                         0x0121
#define regPA_CL_VPORT_YSCALE_2_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_2                                                                        0x0122
#define regPA_CL_VPORT_YOFFSET_2_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_2                                                                         0x0123
#define regPA_CL_VPORT_ZSCALE_2_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_2                                                                        0x0124
#define regPA_CL_VPORT_ZOFFSET_2_BASE_IDX                                                               1
#define regPA_SC_VPORT_ZMIN_2                                                                           0x0125
#define regPA_SC_VPORT_ZMIN_2_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_2                                                                           0x0126
#define regPA_SC_VPORT_ZMAX_2_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_3                                                                         0x0127
#define regPA_CL_VPORT_XSCALE_3_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_3                                                                        0x0128
#define regPA_CL_VPORT_XOFFSET_3_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_3                                                                         0x0129
#define regPA_CL_VPORT_YSCALE_3_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_3                                                                        0x012a
#define regPA_CL_VPORT_YOFFSET_3_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_3                                                                         0x012b
#define regPA_CL_VPORT_ZSCALE_3_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_3                                                                        0x012c
#define regPA_CL_VPORT_ZOFFSET_3_BASE_IDX                                                               1
#define regPA_SC_VPORT_ZMIN_3                                                                           0x012d
#define regPA_SC_VPORT_ZMIN_3_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_3                                                                           0x012e
#define regPA_SC_VPORT_ZMAX_3_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_4                                                                         0x012f
#define regPA_CL_VPORT_XSCALE_4_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_4                                                                        0x0130
#define regPA_CL_VPORT_XOFFSET_4_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_4                                                                         0x0131
#define regPA_CL_VPORT_YSCALE_4_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_4                                                                        0x0132
#define regPA_CL_VPORT_YOFFSET_4_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_4                                                                         0x0133
#define regPA_CL_VPORT_ZSCALE_4_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_4                                                                        0x0134
#define regPA_CL_VPORT_ZOFFSET_4_BASE_IDX                                                               1
#define regPA_SC_VPORT_ZMIN_4                                                                           0x0135
#define regPA_SC_VPORT_ZMIN_4_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_4                                                                           0x0136
#define regPA_SC_VPORT_ZMAX_4_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_5                                                                         0x0137
#define regPA_CL_VPORT_XSCALE_5_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_5                                                                        0x0138
#define regPA_CL_VPORT_XOFFSET_5_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_5                                                                         0x0139
#define regPA_CL_VPORT_YSCALE_5_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_5                                                                        0x013a
#define regPA_CL_VPORT_YOFFSET_5_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_5                                                                         0x013b
#define regPA_CL_VPORT_ZSCALE_5_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_5                                                                        0x013c
#define regPA_CL_VPORT_ZOFFSET_5_BASE_IDX                                                               1
#define regPA_SC_VPORT_ZMIN_5                                                                           0x013d
#define regPA_SC_VPORT_ZMIN_5_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_5                                                                           0x013e
#define regPA_SC_VPORT_ZMAX_5_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_6                                                                         0x013f
#define regPA_CL_VPORT_XSCALE_6_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_6                                                                        0x0140
#define regPA_CL_VPORT_XOFFSET_6_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_6                                                                         0x0141
#define regPA_CL_VPORT_YSCALE_6_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_6                                                                        0x0142
#define regPA_CL_VPORT_YOFFSET_6_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_6                                                                         0x0143
#define regPA_CL_VPORT_ZSCALE_6_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_6                                                                        0x0144
#define regPA_CL_VPORT_ZOFFSET_6_BASE_IDX                                                               1
#define regPA_SC_VPORT_ZMIN_6                                                                           0x0145
#define regPA_SC_VPORT_ZMIN_6_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_6                                                                           0x0146
#define regPA_SC_VPORT_ZMAX_6_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_7                                                                         0x0147
#define regPA_CL_VPORT_XSCALE_7_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_7                                                                        0x0148
#define regPA_CL_VPORT_XOFFSET_7_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_7                                                                         0x0149
#define regPA_CL_VPORT_YSCALE_7_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_7                                                                        0x014a
#define regPA_CL_VPORT_YOFFSET_7_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_7                                                                         0x014b
#define regPA_CL_VPORT_ZSCALE_7_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_7                                                                        0x014c
#define regPA_CL_VPORT_ZOFFSET_7_BASE_IDX                                                               1
#define regPA_SC_VPORT_ZMIN_7                                                                           0x014d
#define regPA_SC_VPORT_ZMIN_7_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_7                                                                           0x014e
#define regPA_SC_VPORT_ZMAX_7_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_8                                                                         0x014f
#define regPA_CL_VPORT_XSCALE_8_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_8                                                                        0x0150
#define regPA_CL_VPORT_XOFFSET_8_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_8                                                                         0x0151
#define regPA_CL_VPORT_YSCALE_8_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_8                                                                        0x0152
#define regPA_CL_VPORT_YOFFSET_8_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_8                                                                         0x0153
#define regPA_CL_VPORT_ZSCALE_8_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_8                                                                        0x0154
#define regPA_CL_VPORT_ZOFFSET_8_BASE_IDX                                                               1
#define regPA_SC_VPORT_ZMIN_8                                                                           0x0155
#define regPA_SC_VPORT_ZMIN_8_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_8                                                                           0x0156
#define regPA_SC_VPORT_ZMAX_8_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_9                                                                         0x0157
#define regPA_CL_VPORT_XSCALE_9_BASE_IDX                                                                1
#define regPA_CL_VPORT_XOFFSET_9                                                                        0x0158
#define regPA_CL_VPORT_XOFFSET_9_BASE_IDX                                                               1
#define regPA_CL_VPORT_YSCALE_9                                                                         0x0159
#define regPA_CL_VPORT_YSCALE_9_BASE_IDX                                                                1
#define regPA_CL_VPORT_YOFFSET_9                                                                        0x015a
#define regPA_CL_VPORT_YOFFSET_9_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZSCALE_9                                                                         0x015b
#define regPA_CL_VPORT_ZSCALE_9_BASE_IDX                                                                1
#define regPA_CL_VPORT_ZOFFSET_9                                                                        0x015c
#define regPA_CL_VPORT_ZOFFSET_9_BASE_IDX                                                               1
#define regPA_SC_VPORT_ZMIN_9                                                                           0x015d
#define regPA_SC_VPORT_ZMIN_9_BASE_IDX                                                                  1
#define regPA_SC_VPORT_ZMAX_9                                                                           0x015e
#define regPA_SC_VPORT_ZMAX_9_BASE_IDX                                                                  1
#define regPA_CL_VPORT_XSCALE_10                                                                        0x015f
#define regPA_CL_VPORT_XSCALE_10_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_10                                                                       0x0160
#define regPA_CL_VPORT_XOFFSET_10_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_10                                                                        0x0161
#define regPA_CL_VPORT_YSCALE_10_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_10                                                                       0x0162
#define regPA_CL_VPORT_YOFFSET_10_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_10                                                                        0x0163
#define regPA_CL_VPORT_ZSCALE_10_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_10                                                                       0x0164
#define regPA_CL_VPORT_ZOFFSET_10_BASE_IDX                                                              1
#define regPA_SC_VPORT_ZMIN_10                                                                          0x0165
#define regPA_SC_VPORT_ZMIN_10_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_10                                                                          0x0166
#define regPA_SC_VPORT_ZMAX_10_BASE_IDX                                                                 1
#define regPA_CL_VPORT_XSCALE_11                                                                        0x0167
#define regPA_CL_VPORT_XSCALE_11_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_11                                                                       0x0168
#define regPA_CL_VPORT_XOFFSET_11_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_11                                                                        0x0169
#define regPA_CL_VPORT_YSCALE_11_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_11                                                                       0x016a
#define regPA_CL_VPORT_YOFFSET_11_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_11                                                                        0x016b
#define regPA_CL_VPORT_ZSCALE_11_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_11                                                                       0x016c
#define regPA_CL_VPORT_ZOFFSET_11_BASE_IDX                                                              1
#define regPA_SC_VPORT_ZMIN_11                                                                          0x016d
#define regPA_SC_VPORT_ZMIN_11_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_11                                                                          0x016e
#define regPA_SC_VPORT_ZMAX_11_BASE_IDX                                                                 1
#define regPA_CL_VPORT_XSCALE_12                                                                        0x016f
#define regPA_CL_VPORT_XSCALE_12_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_12                                                                       0x0170
#define regPA_CL_VPORT_XOFFSET_12_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_12                                                                        0x0171
#define regPA_CL_VPORT_YSCALE_12_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_12                                                                       0x0172
#define regPA_CL_VPORT_YOFFSET_12_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_12                                                                        0x0173
#define regPA_CL_VPORT_ZSCALE_12_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_12                                                                       0x0174
#define regPA_CL_VPORT_ZOFFSET_12_BASE_IDX                                                              1
#define regPA_SC_VPORT_ZMIN_12                                                                          0x0175
#define regPA_SC_VPORT_ZMIN_12_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_12                                                                          0x0176
#define regPA_SC_VPORT_ZMAX_12_BASE_IDX                                                                 1
#define regPA_CL_VPORT_XSCALE_13                                                                        0x0177
#define regPA_CL_VPORT_XSCALE_13_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_13                                                                       0x0178
#define regPA_CL_VPORT_XOFFSET_13_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_13                                                                        0x0179
#define regPA_CL_VPORT_YSCALE_13_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_13                                                                       0x017a
#define regPA_CL_VPORT_YOFFSET_13_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_13                                                                        0x017b
#define regPA_CL_VPORT_ZSCALE_13_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_13                                                                       0x017c
#define regPA_CL_VPORT_ZOFFSET_13_BASE_IDX                                                              1
#define regPA_SC_VPORT_ZMIN_13                                                                          0x017d
#define regPA_SC_VPORT_ZMIN_13_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_13                                                                          0x017e
#define regPA_SC_VPORT_ZMAX_13_BASE_IDX                                                                 1
#define regPA_CL_VPORT_XSCALE_14                                                                        0x017f
#define regPA_CL_VPORT_XSCALE_14_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_14                                                                       0x0180
#define regPA_CL_VPORT_XOFFSET_14_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_14                                                                        0x0181
#define regPA_CL_VPORT_YSCALE_14_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_14                                                                       0x0182
#define regPA_CL_VPORT_YOFFSET_14_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_14                                                                        0x0183
#define regPA_CL_VPORT_ZSCALE_14_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_14                                                                       0x0184
#define regPA_CL_VPORT_ZOFFSET_14_BASE_IDX                                                              1
#define regPA_SC_VPORT_ZMIN_14                                                                          0x0185
#define regPA_SC_VPORT_ZMIN_14_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_14                                                                          0x0186
#define regPA_SC_VPORT_ZMAX_14_BASE_IDX                                                                 1
#define regPA_CL_VPORT_XSCALE_15                                                                        0x0187
#define regPA_CL_VPORT_XSCALE_15_BASE_IDX                                                               1
#define regPA_CL_VPORT_XOFFSET_15                                                                       0x0188
#define regPA_CL_VPORT_XOFFSET_15_BASE_IDX                                                              1
#define regPA_CL_VPORT_YSCALE_15                                                                        0x0189
#define regPA_CL_VPORT_YSCALE_15_BASE_IDX                                                               1
#define regPA_CL_VPORT_YOFFSET_15                                                                       0x018a
#define regPA_CL_VPORT_YOFFSET_15_BASE_IDX                                                              1
#define regPA_CL_VPORT_ZSCALE_15                                                                        0x018b
#define regPA_CL_VPORT_ZSCALE_15_BASE_IDX                                                               1
#define regPA_CL_VPORT_ZOFFSET_15                                                                       0x018c
#define regPA_CL_VPORT_ZOFFSET_15_BASE_IDX                                                              1
#define regPA_SC_VPORT_ZMIN_15                                                                          0x018d
#define regPA_SC_VPORT_ZMIN_15_BASE_IDX                                                                 1
#define regPA_SC_VPORT_ZMAX_15                                                                          0x018e
#define regPA_SC_VPORT_ZMAX_15_BASE_IDX                                                                 1
#define regSPI_PS_IN_CONTROL                                                                            0x0190
#define regSPI_PS_IN_CONTROL_BASE_IDX                                                                   1
#define regSPI_INTERP_CONTROL_0                                                                         0x0191
#define regSPI_INTERP_CONTROL_0_BASE_IDX                                                                1
#define regSPI_SHADER_IDX_FORMAT                                                                        0x0192
#define regSPI_SHADER_IDX_FORMAT_BASE_IDX                                                               1
#define regSPI_SHADER_POS_FORMAT                                                                        0x0193
#define regSPI_SHADER_POS_FORMAT_BASE_IDX                                                               1
#define regSPI_SHADER_Z_FORMAT                                                                          0x0194
#define regSPI_SHADER_Z_FORMAT_BASE_IDX                                                                 1
#define regSPI_SHADER_COL_FORMAT                                                                        0x0195
#define regSPI_SHADER_COL_FORMAT_BASE_IDX                                                               1
#define regSPI_BARYC_CNTL                                                                               0x0196
#define regSPI_BARYC_CNTL_BASE_IDX                                                                      1
#define regSPI_PS_INPUT_ENA                                                                             0x0197
#define regSPI_PS_INPUT_ENA_BASE_IDX                                                                    1
#define regSPI_PS_INPUT_ADDR                                                                            0x0198
#define regSPI_PS_INPUT_ADDR_BASE_IDX                                                                   1
#define regSPI_PS_INPUT_CNTL_0                                                                          0x0199
#define regSPI_PS_INPUT_CNTL_0_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_1                                                                          0x019a
#define regSPI_PS_INPUT_CNTL_1_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_2                                                                          0x019b
#define regSPI_PS_INPUT_CNTL_2_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_3                                                                          0x019c
#define regSPI_PS_INPUT_CNTL_3_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_4                                                                          0x019d
#define regSPI_PS_INPUT_CNTL_4_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_5                                                                          0x019e
#define regSPI_PS_INPUT_CNTL_5_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_6                                                                          0x019f
#define regSPI_PS_INPUT_CNTL_6_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_7                                                                          0x01a0
#define regSPI_PS_INPUT_CNTL_7_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_8                                                                          0x01a1
#define regSPI_PS_INPUT_CNTL_8_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_9                                                                          0x01a2
#define regSPI_PS_INPUT_CNTL_9_BASE_IDX                                                                 1
#define regSPI_PS_INPUT_CNTL_10                                                                         0x01a3
#define regSPI_PS_INPUT_CNTL_10_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_11                                                                         0x01a4
#define regSPI_PS_INPUT_CNTL_11_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_12                                                                         0x01a5
#define regSPI_PS_INPUT_CNTL_12_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_13                                                                         0x01a6
#define regSPI_PS_INPUT_CNTL_13_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_14                                                                         0x01a7
#define regSPI_PS_INPUT_CNTL_14_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_15                                                                         0x01a8
#define regSPI_PS_INPUT_CNTL_15_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_16                                                                         0x01a9
#define regSPI_PS_INPUT_CNTL_16_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_17                                                                         0x01aa
#define regSPI_PS_INPUT_CNTL_17_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_18                                                                         0x01ab
#define regSPI_PS_INPUT_CNTL_18_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_19                                                                         0x01ac
#define regSPI_PS_INPUT_CNTL_19_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_20                                                                         0x01ad
#define regSPI_PS_INPUT_CNTL_20_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_21                                                                         0x01ae
#define regSPI_PS_INPUT_CNTL_21_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_22                                                                         0x01af
#define regSPI_PS_INPUT_CNTL_22_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_23                                                                         0x01b0
#define regSPI_PS_INPUT_CNTL_23_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_24                                                                         0x01b1
#define regSPI_PS_INPUT_CNTL_24_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_25                                                                         0x01b2
#define regSPI_PS_INPUT_CNTL_25_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_26                                                                         0x01b3
#define regSPI_PS_INPUT_CNTL_26_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_27                                                                         0x01b4
#define regSPI_PS_INPUT_CNTL_27_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_28                                                                         0x01b5
#define regSPI_PS_INPUT_CNTL_28_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_29                                                                         0x01b6
#define regSPI_PS_INPUT_CNTL_29_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_30                                                                         0x01b7
#define regSPI_PS_INPUT_CNTL_30_BASE_IDX                                                                1
#define regSPI_PS_INPUT_CNTL_31                                                                         0x01b8
#define regSPI_PS_INPUT_CNTL_31_BASE_IDX                                                                1
#define regSPI_BARYC_SSAA_CNTL                                                                          0x01b9
#define regSPI_BARYC_SSAA_CNTL_BASE_IDX                                                                 1
#define regSPI_TMPRING_SIZE                                                                             0x01ba
#define regSPI_TMPRING_SIZE_BASE_IDX                                                                    1
#define regSPI_GFX_SCRATCH_BASE_LO                                                                      0x01bb
#define regSPI_GFX_SCRATCH_BASE_LO_BASE_IDX                                                             1
#define regSPI_GFX_SCRATCH_BASE_HI                                                                      0x01bc
#define regSPI_GFX_SCRATCH_BASE_HI_BASE_IDX                                                             1
#define regSX_PS_DOWNCONVERT_CONTROL                                                                    0x01d4
#define regSX_PS_DOWNCONVERT_CONTROL_BASE_IDX                                                           1
#define regSX_PS_DOWNCONVERT                                                                            0x01d5
#define regSX_PS_DOWNCONVERT_BASE_IDX                                                                   1
#define regSX_BLEND_OPT_EPSILON                                                                         0x01d6
#define regSX_BLEND_OPT_EPSILON_BASE_IDX                                                                1
#define regSX_BLEND_OPT_CONTROL                                                                         0x01d7
#define regSX_BLEND_OPT_CONTROL_BASE_IDX                                                                1
#define regSX_MRT0_BLEND_OPT                                                                            0x01d8
#define regSX_MRT0_BLEND_OPT_BASE_IDX                                                                   1
#define regSX_MRT1_BLEND_OPT                                                                            0x01d9
#define regSX_MRT1_BLEND_OPT_BASE_IDX                                                                   1
#define regSX_MRT2_BLEND_OPT                                                                            0x01da
#define regSX_MRT2_BLEND_OPT_BASE_IDX                                                                   1
#define regSX_MRT3_BLEND_OPT                                                                            0x01db
#define regSX_MRT3_BLEND_OPT_BASE_IDX                                                                   1
#define regSX_MRT4_BLEND_OPT                                                                            0x01dc
#define regSX_MRT4_BLEND_OPT_BASE_IDX                                                                   1
#define regSX_MRT5_BLEND_OPT                                                                            0x01dd
#define regSX_MRT5_BLEND_OPT_BASE_IDX                                                                   1
#define regSX_MRT6_BLEND_OPT                                                                            0x01de
#define regSX_MRT6_BLEND_OPT_BASE_IDX                                                                   1
#define regSX_MRT7_BLEND_OPT                                                                            0x01df
#define regSX_MRT7_BLEND_OPT_BASE_IDX                                                                   1
#define regCB_BLEND0_CONTROL                                                                            0x01e0
#define regCB_BLEND0_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND1_CONTROL                                                                            0x01e1
#define regCB_BLEND1_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND2_CONTROL                                                                            0x01e2
#define regCB_BLEND2_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND3_CONTROL                                                                            0x01e3
#define regCB_BLEND3_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND4_CONTROL                                                                            0x01e4
#define regCB_BLEND4_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND5_CONTROL                                                                            0x01e5
#define regCB_BLEND5_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND6_CONTROL                                                                            0x01e6
#define regCB_BLEND6_CONTROL_BASE_IDX                                                                   1
#define regCB_BLEND7_CONTROL                                                                            0x01e7
#define regCB_BLEND7_CONTROL_BASE_IDX                                                                   1
#define regPA_CL_POINT_X_RAD                                                                            0x01f5
#define regPA_CL_POINT_X_RAD_BASE_IDX                                                                   1
#define regPA_CL_POINT_Y_RAD                                                                            0x01f6
#define regPA_CL_POINT_Y_RAD_BASE_IDX                                                                   1
#define regPA_CL_POINT_SIZE                                                                             0x01f7
#define regPA_CL_POINT_SIZE_BASE_IDX                                                                    1
#define regPA_CL_POINT_CULL_RAD                                                                         0x01f8
#define regPA_CL_POINT_CULL_RAD_BASE_IDX                                                                1
#define regGE_MAX_OUTPUT_PER_SUBGROUP                                                                   0x01ff
#define regGE_MAX_OUTPUT_PER_SUBGROUP_BASE_IDX                                                          1
#define regPA_CL_CLIP_CNTL                                                                              0x0204
#define regPA_CL_CLIP_CNTL_BASE_IDX                                                                     1
#define regPA_CL_VTE_CNTL                                                                               0x0205
#define regPA_CL_VTE_CNTL_BASE_IDX                                                                      1
#define regPA_CL_VS_OUT_CNTL                                                                            0x0206
#define regPA_CL_VS_OUT_CNTL_BASE_IDX                                                                   1
#define regPA_SU_SC_MODE_CNTL                                                                           0x0207
#define regPA_SU_SC_MODE_CNTL_BASE_IDX                                                                  1
#define regPA_CL_NANINF_CNTL                                                                            0x0208
#define regPA_CL_NANINF_CNTL_BASE_IDX                                                                   1
#define regPA_SU_LINE_STIPPLE_CNTL                                                                      0x0209
#define regPA_SU_LINE_STIPPLE_CNTL_BASE_IDX                                                             1
#define regPA_SU_LINE_STIPPLE_SCALE                                                                     0x020a
#define regPA_SU_LINE_STIPPLE_SCALE_BASE_IDX                                                            1
#define regPA_SU_PRIM_FILTER_CNTL                                                                       0x020b
#define regPA_SU_PRIM_FILTER_CNTL_BASE_IDX                                                              1
#define regPA_SU_SMALL_PRIM_FILTER_CNTL                                                                 0x020c
#define regPA_SU_SMALL_PRIM_FILTER_CNTL_BASE_IDX                                                        1
#define regPA_CL_NGG_CNTL                                                                               0x020e
#define regPA_CL_NGG_CNTL_BASE_IDX                                                                      1
#define regPA_SU_OVER_RASTERIZATION_CNTL                                                                0x020f
#define regPA_SU_OVER_RASTERIZATION_CNTL_BASE_IDX                                                       1
#define regPA_STEREO_CNTL                                                                               0x0210
#define regPA_STEREO_CNTL_BASE_IDX                                                                      1
#define regPA_STATE_STEREO_X                                                                            0x0211
#define regPA_STATE_STEREO_X_BASE_IDX                                                                   1
#define regPA_CL_VRS_CNTL                                                                               0x0212
#define regPA_CL_VRS_CNTL_BASE_IDX                                                                      1
#define regCB_TARGET_MASK                                                                               0x0214
#define regCB_TARGET_MASK_BASE_IDX                                                                      1
#define regCB_SHADER_MASK                                                                               0x0215
#define regCB_SHADER_MASK_BASE_IDX                                                                      1
#define regCB_COLOR_CONTROL                                                                             0x0216
#define regCB_COLOR_CONTROL_BASE_IDX                                                                    1
#define regPA_SU_POINT_SIZE                                                                             0x0280
#define regPA_SU_POINT_SIZE_BASE_IDX                                                                    1
#define regPA_SU_POINT_MINMAX                                                                           0x0281
#define regPA_SU_POINT_MINMAX_BASE_IDX                                                                  1
#define regPA_SU_LINE_CNTL                                                                              0x0282
#define regPA_SU_LINE_CNTL_BASE_IDX                                                                     1
#define regPA_SC_LINE_STIPPLE                                                                           0x0283
#define regPA_SC_LINE_STIPPLE_BASE_IDX                                                                  1
#define regPA_SC_LINE_STIPPLE_RESET                                                                     0x0291
#define regPA_SC_LINE_STIPPLE_RESET_BASE_IDX                                                            1
#define regPA_SC_MODE_CNTL_0                                                                            0x0292
#define regPA_SC_MODE_CNTL_0_BASE_IDX                                                                   1
#define regPA_SC_MODE_CNTL_1                                                                            0x0293
#define regPA_SC_MODE_CNTL_1_BASE_IDX                                                                   1
#define regGE_SE_ENHANCE                                                                                0x0294
#define regGE_SE_ENHANCE_BASE_IDX                                                                       1
#define regVGT_REUSE_OFF                                                                                0x02a7
#define regVGT_REUSE_OFF_BASE_IDX                                                                       1
#define regVGT_DRAW_PAYLOAD_CNTL                                                                        0x02a8
#define regVGT_DRAW_PAYLOAD_CNTL_BASE_IDX                                                               1
#define regDB_HTILE_SURFACE                                                                             0x02af
#define regDB_HTILE_SURFACE_BASE_IDX                                                                    1
#define regDB_SRESULTS_COMPARE_STATE0                                                                   0x02b0
#define regDB_SRESULTS_COMPARE_STATE0_BASE_IDX                                                          1
#define regDB_SRESULTS_COMPARE_STATE1                                                                   0x02b1
#define regDB_SRESULTS_COMPARE_STATE1_BASE_IDX                                                          1
#define regVGT_GS_MAX_VERT_OUT                                                                          0x02ce
#define regVGT_GS_MAX_VERT_OUT_BASE_IDX                                                                 1
#define regVGT_GS_INSTANCE_CNT                                                                          0x02cf
#define regVGT_GS_INSTANCE_CNT_BASE_IDX                                                                 1
#define regGE_NGG_SUBGRP_CNTL                                                                           0x02d3
#define regGE_NGG_SUBGRP_CNTL_BASE_IDX                                                                  1
#define regPA_SU_POLY_OFFSET_DB_FMT_CNTL                                                                0x02de
#define regPA_SU_POLY_OFFSET_DB_FMT_CNTL_BASE_IDX                                                       1
#define regPA_SU_POLY_OFFSET_CLAMP                                                                      0x02df
#define regPA_SU_POLY_OFFSET_CLAMP_BASE_IDX                                                             1
#define regPA_SU_POLY_OFFSET_FRONT_SCALE                                                                0x02e0
#define regPA_SU_POLY_OFFSET_FRONT_SCALE_BASE_IDX                                                       1
#define regPA_SU_POLY_OFFSET_FRONT_OFFSET                                                               0x02e1
#define regPA_SU_POLY_OFFSET_FRONT_OFFSET_BASE_IDX                                                      1
#define regPA_SU_POLY_OFFSET_BACK_SCALE                                                                 0x02e2
#define regPA_SU_POLY_OFFSET_BACK_SCALE_BASE_IDX                                                        1
#define regPA_SU_POLY_OFFSET_BACK_OFFSET                                                                0x02e3
#define regPA_SU_POLY_OFFSET_BACK_OFFSET_BASE_IDX                                                       1
#define regPA_SC_HIZ_INFO                                                                               0x02e5
#define regPA_SC_HIZ_INFO_BASE_IDX                                                                      1
#define regPA_SC_HIS_INFO                                                                               0x02e6
#define regPA_SC_HIS_INFO_BASE_IDX                                                                      1
#define regPA_SC_HIZ_BASE                                                                               0x02e7
#define regPA_SC_HIZ_BASE_BASE_IDX                                                                      1
#define regPA_SC_HIZ_BASE_EXT                                                                           0x02e8
#define regPA_SC_HIZ_BASE_EXT_BASE_IDX                                                                  1
#define regPA_SC_HIZ_SIZE_XY                                                                            0x02e9
#define regPA_SC_HIZ_SIZE_XY_BASE_IDX                                                                   1
#define regPA_SC_HIS_BASE                                                                               0x02ea
#define regPA_SC_HIS_BASE_BASE_IDX                                                                      1
#define regPA_SC_HIS_BASE_EXT                                                                           0x02eb
#define regPA_SC_HIS_BASE_EXT_BASE_IDX                                                                  1
#define regPA_SC_HIS_SIZE_XY                                                                            0x02ec
#define regPA_SC_HIS_SIZE_XY_BASE_IDX                                                                   1
#define regPA_SC_BINNER_OUTPUT_TIMEOUT_CNTL                                                             0x02ed
#define regPA_SC_BINNER_OUTPUT_TIMEOUT_CNTL_BASE_IDX                                                    1
#define regPA_SC_BINNER_DYNAMIC_BATCH_LIMIT                                                             0x02ee
#define regPA_SC_BINNER_DYNAMIC_BATCH_LIMIT_BASE_IDX                                                    1
#define regPA_SC_HISZ_CONTROL                                                                           0x02ef
#define regPA_SC_HISZ_CONTROL_BASE_IDX                                                                  1
#define regPA_SC_HISZ_RENDER_OVERRIDE                                                                   0x02f0
#define regPA_SC_HISZ_RENDER_OVERRIDE_BASE_IDX                                                          1
#define regPA_SC_LINE_CNTL                                                                              0x02f7
#define regPA_SC_LINE_CNTL_BASE_IDX                                                                     1
#define regPA_SC_AA_CONFIG                                                                              0x02f8
#define regPA_SC_AA_CONFIG_BASE_IDX                                                                     1
#define regPA_SU_VTX_CNTL                                                                               0x02f9
#define regPA_SU_VTX_CNTL_BASE_IDX                                                                      1
#define regPA_SC_CENTROID_PRIORITY_0                                                                    0x02fc
#define regPA_SC_CENTROID_PRIORITY_0_BASE_IDX                                                           1
#define regPA_SC_CENTROID_PRIORITY_1                                                                    0x02fd
#define regPA_SC_CENTROID_PRIORITY_1_BASE_IDX                                                           1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0                                                            0x02fe
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1                                                            0x02ff
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2                                                            0x0300
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3                                                            0x0301
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0                                                            0x0302
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1                                                            0x0303
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2                                                            0x0304
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3                                                            0x0305
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0                                                            0x0306
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1                                                            0x0307
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2                                                            0x0308
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3                                                            0x0309
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0                                                            0x030a
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1                                                            0x030b
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2                                                            0x030c
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2_BASE_IDX                                                   1
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3                                                            0x030d
#define regPA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3_BASE_IDX                                                   1
#define regPA_SC_AA_MASK_X0Y0_X1Y0                                                                      0x030e
#define regPA_SC_AA_MASK_X0Y0_X1Y0_BASE_IDX                                                             1
#define regPA_SC_AA_MASK_X0Y1_X1Y1                                                                      0x030f
#define regPA_SC_AA_MASK_X0Y1_X1Y1_BASE_IDX                                                             1
#define regPA_SC_BINNER_OUTPUT_TIMEOUT_COUNTER                                                          0x0310
#define regPA_SC_BINNER_OUTPUT_TIMEOUT_COUNTER_BASE_IDX                                                 1
#define regPA_SC_BINNER_CNTL_0                                                                          0x0311
#define regPA_SC_BINNER_CNTL_0_BASE_IDX                                                                 1
#define regPA_SC_BINNER_CNTL_1                                                                          0x0312
#define regPA_SC_BINNER_CNTL_1_BASE_IDX                                                                 1
#define regPA_SC_BINNER_CNTL_2                                                                          0x0313
#define regPA_SC_BINNER_CNTL_2_BASE_IDX                                                                 1
#define regPA_SC_NGG_MODE_CNTL                                                                          0x0314
#define regPA_SC_NGG_MODE_CNTL_BASE_IDX                                                                 1
#define regPA_SC_CONSERVATIVE_RASTERIZATION_CNTL                                                        0x0315
#define regPA_SC_CONSERVATIVE_RASTERIZATION_CNTL_BASE_IDX                                               1
#define regPA_SC_SHADER_CONTROL                                                                         0x0316
#define regPA_SC_SHADER_CONTROL_BASE_IDX                                                                1
#define regPA_SC_SAMPLE_PROPERTIES                                                                      0x0317
#define regPA_SC_SAMPLE_PROPERTIES_BASE_IDX                                                             1
#define regCB_COLOR0_BASE                                                                               0x0318
#define regCB_COLOR0_BASE_BASE_IDX                                                                      1
#define regCB_COLOR0_VIEW                                                                               0x0319
#define regCB_COLOR0_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR0_VIEW2                                                                              0x031a
#define regCB_COLOR0_VIEW2_BASE_IDX                                                                     1
#define regCB_COLOR0_ATTRIB                                                                             0x031b
#define regCB_COLOR0_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR0_FDCC_CONTROL                                                                       0x031c
#define regCB_COLOR0_FDCC_CONTROL_BASE_IDX                                                              1
#define regCB_COLOR0_ATTRIB2                                                                            0x031e
#define regCB_COLOR0_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR0_ATTRIB3                                                                            0x031f
#define regCB_COLOR0_ATTRIB3_BASE_IDX                                                                   1
#define regCB_COLOR1_BASE                                                                               0x0321
#define regCB_COLOR1_BASE_BASE_IDX                                                                      1
#define regCB_COLOR1_VIEW                                                                               0x0322
#define regCB_COLOR1_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR1_VIEW2                                                                              0x0323
#define regCB_COLOR1_VIEW2_BASE_IDX                                                                     1
#define regCB_COLOR1_ATTRIB                                                                             0x0324
#define regCB_COLOR1_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR1_FDCC_CONTROL                                                                       0x0325
#define regCB_COLOR1_FDCC_CONTROL_BASE_IDX                                                              1
#define regCB_COLOR1_ATTRIB2                                                                            0x0327
#define regCB_COLOR1_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR1_ATTRIB3                                                                            0x0328
#define regCB_COLOR1_ATTRIB3_BASE_IDX                                                                   1
#define regCB_COLOR2_BASE                                                                               0x032a
#define regCB_COLOR2_BASE_BASE_IDX                                                                      1
#define regCB_COLOR2_VIEW                                                                               0x032b
#define regCB_COLOR2_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR2_VIEW2                                                                              0x032c
#define regCB_COLOR2_VIEW2_BASE_IDX                                                                     1
#define regCB_COLOR2_ATTRIB                                                                             0x032d
#define regCB_COLOR2_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR2_FDCC_CONTROL                                                                       0x032e
#define regCB_COLOR2_FDCC_CONTROL_BASE_IDX                                                              1
#define regCB_COLOR2_ATTRIB2                                                                            0x0330
#define regCB_COLOR2_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR2_ATTRIB3                                                                            0x0331
#define regCB_COLOR2_ATTRIB3_BASE_IDX                                                                   1
#define regCB_COLOR3_BASE                                                                               0x0333
#define regCB_COLOR3_BASE_BASE_IDX                                                                      1
#define regCB_COLOR3_VIEW                                                                               0x0334
#define regCB_COLOR3_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR3_VIEW2                                                                              0x0335
#define regCB_COLOR3_VIEW2_BASE_IDX                                                                     1
#define regCB_COLOR3_ATTRIB                                                                             0x0336
#define regCB_COLOR3_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR3_FDCC_CONTROL                                                                       0x0337
#define regCB_COLOR3_FDCC_CONTROL_BASE_IDX                                                              1
#define regCB_COLOR3_ATTRIB2                                                                            0x0339
#define regCB_COLOR3_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR3_ATTRIB3                                                                            0x033a
#define regCB_COLOR3_ATTRIB3_BASE_IDX                                                                   1
#define regCB_COLOR4_BASE                                                                               0x033c
#define regCB_COLOR4_BASE_BASE_IDX                                                                      1
#define regCB_COLOR4_VIEW                                                                               0x033d
#define regCB_COLOR4_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR4_VIEW2                                                                              0x033e
#define regCB_COLOR4_VIEW2_BASE_IDX                                                                     1
#define regCB_COLOR4_ATTRIB                                                                             0x033f
#define regCB_COLOR4_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR4_FDCC_CONTROL                                                                       0x0340
#define regCB_COLOR4_FDCC_CONTROL_BASE_IDX                                                              1
#define regCB_COLOR4_ATTRIB2                                                                            0x0342
#define regCB_COLOR4_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR4_ATTRIB3                                                                            0x0343
#define regCB_COLOR4_ATTRIB3_BASE_IDX                                                                   1
#define regCB_COLOR5_BASE                                                                               0x0345
#define regCB_COLOR5_BASE_BASE_IDX                                                                      1
#define regCB_COLOR5_VIEW                                                                               0x0346
#define regCB_COLOR5_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR5_VIEW2                                                                              0x0347
#define regCB_COLOR5_VIEW2_BASE_IDX                                                                     1
#define regCB_COLOR5_ATTRIB                                                                             0x0348
#define regCB_COLOR5_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR5_FDCC_CONTROL                                                                       0x0349
#define regCB_COLOR5_FDCC_CONTROL_BASE_IDX                                                              1
#define regCB_COLOR5_ATTRIB2                                                                            0x034b
#define regCB_COLOR5_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR5_ATTRIB3                                                                            0x034c
#define regCB_COLOR5_ATTRIB3_BASE_IDX                                                                   1
#define regCB_COLOR6_BASE                                                                               0x034e
#define regCB_COLOR6_BASE_BASE_IDX                                                                      1
#define regCB_COLOR6_VIEW                                                                               0x034f
#define regCB_COLOR6_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR6_VIEW2                                                                              0x0350
#define regCB_COLOR6_VIEW2_BASE_IDX                                                                     1
#define regCB_COLOR6_ATTRIB                                                                             0x0351
#define regCB_COLOR6_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR6_FDCC_CONTROL                                                                       0x0352
#define regCB_COLOR6_FDCC_CONTROL_BASE_IDX                                                              1
#define regCB_COLOR6_ATTRIB2                                                                            0x0354
#define regCB_COLOR6_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR6_ATTRIB3                                                                            0x0355
#define regCB_COLOR6_ATTRIB3_BASE_IDX                                                                   1
#define regCB_COLOR7_BASE                                                                               0x0357
#define regCB_COLOR7_BASE_BASE_IDX                                                                      1
#define regCB_COLOR7_VIEW                                                                               0x0358
#define regCB_COLOR7_VIEW_BASE_IDX                                                                      1
#define regCB_COLOR7_VIEW2                                                                              0x0359
#define regCB_COLOR7_VIEW2_BASE_IDX                                                                     1
#define regCB_COLOR7_ATTRIB                                                                             0x035a
#define regCB_COLOR7_ATTRIB_BASE_IDX                                                                    1
#define regCB_COLOR7_FDCC_CONTROL                                                                       0x035b
#define regCB_COLOR7_FDCC_CONTROL_BASE_IDX                                                              1
#define regCB_COLOR7_ATTRIB2                                                                            0x035d
#define regCB_COLOR7_ATTRIB2_BASE_IDX                                                                   1
#define regCB_COLOR7_ATTRIB3                                                                            0x035e
#define regCB_COLOR7_ATTRIB3_BASE_IDX                                                                   1
#define regCB_COLOR0_BASE_EXT                                                                           0x0390
#define regCB_COLOR0_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR1_BASE_EXT                                                                           0x0391
#define regCB_COLOR1_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR2_BASE_EXT                                                                           0x0392
#define regCB_COLOR2_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR3_BASE_EXT                                                                           0x0393
#define regCB_COLOR3_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR4_BASE_EXT                                                                           0x0394
#define regCB_COLOR4_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR5_BASE_EXT                                                                           0x0395
#define regCB_COLOR5_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR6_BASE_EXT                                                                           0x0396
#define regCB_COLOR6_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR7_BASE_EXT                                                                           0x0397
#define regCB_COLOR7_BASE_EXT_BASE_IDX                                                                  1
#define regCB_COLOR0_INFO                                                                               0x03b0
#define regCB_COLOR0_INFO_BASE_IDX                                                                      1
#define regCB_COLOR1_INFO                                                                               0x03b1
#define regCB_COLOR1_INFO_BASE_IDX                                                                      1
#define regCB_COLOR2_INFO                                                                               0x03b2
#define regCB_COLOR2_INFO_BASE_IDX                                                                      1
#define regCB_COLOR3_INFO                                                                               0x03b3
#define regCB_COLOR3_INFO_BASE_IDX                                                                      1
#define regCB_COLOR4_INFO                                                                               0x03b4
#define regCB_COLOR4_INFO_BASE_IDX                                                                      1
#define regCB_COLOR5_INFO                                                                               0x03b5
#define regCB_COLOR5_INFO_BASE_IDX                                                                      1
#define regCB_COLOR6_INFO                                                                               0x03b6
#define regCB_COLOR6_INFO_BASE_IDX                                                                      1
#define regCB_COLOR7_INFO                                                                               0x03b7
#define regCB_COLOR7_INFO_BASE_IDX                                                                      1
#define regCB_MEM0_INFO                                                                                 0x03c0
#define regCB_MEM0_INFO_BASE_IDX                                                                        1
#define regCB_MEM1_INFO                                                                                 0x03c1
#define regCB_MEM1_INFO_BASE_IDX                                                                        1
#define regCB_MEM2_INFO                                                                                 0x03c2
#define regCB_MEM2_INFO_BASE_IDX                                                                        1
#define regCB_MEM3_INFO                                                                                 0x03c3
#define regCB_MEM3_INFO_BASE_IDX                                                                        1
#define regCB_MEM4_INFO                                                                                 0x03c4
#define regCB_MEM4_INFO_BASE_IDX                                                                        1
#define regCB_MEM5_INFO                                                                                 0x03c5
#define regCB_MEM5_INFO_BASE_IDX                                                                        1
#define regCB_MEM6_INFO                                                                                 0x03c6
#define regCB_MEM6_INFO_BASE_IDX                                                                        1
#define regCB_MEM7_INFO                                                                                 0x03c7
#define regCB_MEM7_INFO_BASE_IDX                                                                        1


// addressBlock: gc_gfx_se_gfx_se_pfvf_padec
// base address: 0x2a500
#define regPA_SC_VRS_SURFACE_CNTL                                                                       0x0940
#define regPA_SC_VRS_SURFACE_CNTL_BASE_IDX                                                              1
#define regPA_SC_ENHANCE                                                                                0x0941
#define regPA_SC_ENHANCE_BASE_IDX                                                                       1
#define regPA_SC_ENHANCE_1                                                                              0x0942
#define regPA_SC_ENHANCE_1_BASE_IDX                                                                     1
#define regPA_SC_ENHANCE_2                                                                              0x0943
#define regPA_SC_ENHANCE_2_BASE_IDX                                                                     1
#define regPA_SC_ENHANCE_3                                                                              0x0944
#define regPA_SC_ENHANCE_3_BASE_IDX                                                                     1
#define regPA_SC_BINNER_CNTL_OVERRIDE                                                                   0x0946
#define regPA_SC_BINNER_CNTL_OVERRIDE_BASE_IDX                                                          1
#define regPA_SC_PBB_OVERRIDE_FLAG                                                                      0x0947
#define regPA_SC_PBB_OVERRIDE_FLAG_BASE_IDX                                                             1
#define regPA_SC_DSM_CNTL                                                                               0x0948
#define regPA_SC_DSM_CNTL_BASE_IDX                                                                      1
#define regPA_SC_TILE_STEERING_CREST_OVERRIDE                                                           0x0949
#define regPA_SC_TILE_STEERING_CREST_OVERRIDE_BASE_IDX                                                  1
#define regPA_SC_FIFO_SIZE                                                                              0x094a
#define regPA_SC_FIFO_SIZE_BASE_IDX                                                                     1
#define regPA_SC_IF_FIFO_SIZE                                                                           0x094b
#define regPA_SC_IF_FIFO_SIZE_BASE_IDX                                                                  1
#define regPA_SC_PACKER_WAVE_ID_CNTL                                                                    0x094c
#define regPA_SC_PACKER_WAVE_ID_CNTL_BASE_IDX                                                           1
#define regPA_SC_ATM_CNTL                                                                               0x094d
#define regPA_SC_ATM_CNTL_BASE_IDX                                                                      1
#define regPA_SC_PKR_WAVE_TABLE_CNTL                                                                    0x094e
#define regPA_SC_PKR_WAVE_TABLE_CNTL_BASE_IDX                                                           1
#define regPA_SC_FORCE_EOV_MAX_CNTS                                                                     0x094f
#define regPA_SC_FORCE_EOV_MAX_CNTS_BASE_IDX                                                            1
#define regPA_SC_BINNER_EVENT_CNTL_0                                                                    0x0950
#define regPA_SC_BINNER_EVENT_CNTL_0_BASE_IDX                                                           1
#define regPA_SC_BINNER_EVENT_CNTL_1                                                                    0x0951
#define regPA_SC_BINNER_EVENT_CNTL_1_BASE_IDX                                                           1
#define regPA_SC_BINNER_EVENT_CNTL_2                                                                    0x0952
#define regPA_SC_BINNER_EVENT_CNTL_2_BASE_IDX                                                           1
#define regPA_SC_BINNER_EVENT_CNTL_3                                                                    0x0953
#define regPA_SC_BINNER_EVENT_CNTL_3_BASE_IDX                                                           1
#define regPA_SC_BINNER_TIMEOUT_COUNTER                                                                 0x0954
#define regPA_SC_BINNER_TIMEOUT_COUNTER_BASE_IDX                                                        1
#define regPA_SC_BINNER_PERF_CNTL_0                                                                     0x0955
#define regPA_SC_BINNER_PERF_CNTL_0_BASE_IDX                                                            1
#define regPA_SC_BINNER_PERF_CNTL_1                                                                     0x0956
#define regPA_SC_BINNER_PERF_CNTL_1_BASE_IDX                                                            1
#define regPA_SC_BINNER_PERF_CNTL_2                                                                     0x0957
#define regPA_SC_BINNER_PERF_CNTL_2_BASE_IDX                                                            1
#define regPA_SC_BINNER_PERF_CNTL_3                                                                     0x0958
#define regPA_SC_BINNER_PERF_CNTL_3_BASE_IDX                                                            1
#define regPA_SC_P3D_TRAP_SCREEN_HV_LOCK                                                                0x095b
#define regPA_SC_P3D_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                       1
#define regPA_SC_HP3D_TRAP_SCREEN_HV_LOCK                                                               0x095c
#define regPA_SC_HP3D_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                      1
#define regPA_SC_TRAP_SCREEN_HV_LOCK                                                                    0x095d
#define regPA_SC_TRAP_SCREEN_HV_LOCK_BASE_IDX                                                           1
#define regPA_PH_INTERFACE_FIFO_SIZE                                                                    0x095e
#define regPA_PH_INTERFACE_FIFO_SIZE_BASE_IDX                                                           1
#define regPA_PH_ENHANCE                                                                                0x095f
#define regPA_PH_ENHANCE_BASE_IDX                                                                       1
#define regPA_SC_VRS_SURFACE_CNTL_1                                                                     0x0960
#define regPA_SC_VRS_SURFACE_CNTL_1_BASE_IDX                                                            1
#define regPA_SC_HIZ_SURFACE_CNTL                                                                       0x0961
#define regPA_SC_HIZ_SURFACE_CNTL_BASE_IDX                                                              1
#define regPA_SC_HIS_SURFACE_CNTL                                                                       0x0962
#define regPA_SC_HIS_SURFACE_CNTL_BASE_IDX                                                              1
#define regPA_SC_HIZ_DEBUG                                                                              0x0963
#define regPA_SC_HIZ_DEBUG_BASE_IDX                                                                     1
#define regPA_SC_HIS_DEBUG                                                                              0x0964
#define regPA_SC_HIS_DEBUG_BASE_IDX                                                                     1
#define regSC_MEM_SCOPE                                                                                 0x0965
#define regSC_MEM_SCOPE_BASE_IDX                                                                        1


// addressBlock: gc_gfx_se_gfx_se_pfvf_sqdec
// base address: 0x2a780
#define regSQ_RUNTIME_CONFIG                                                                            0x09e0
#define regSQ_RUNTIME_CONFIG_BASE_IDX                                                                   1
#define regSQ_DEBUG_STS_GLOBAL                                                                          0x09e1
#define regSQ_DEBUG_STS_GLOBAL_BASE_IDX                                                                 1
#define regSQ_DEBUG_STS_GLOBAL2                                                                         0x09e2
#define regSQ_DEBUG_STS_GLOBAL2_BASE_IDX                                                                1
#define regSH_MEM_BASES                                                                                 0x09e3
#define regSH_MEM_BASES_BASE_IDX                                                                        1
#define regSH_MEM_CONFIG                                                                                0x09e4
#define regSH_MEM_CONFIG_BASE_IDX                                                                       1
#define regSQ_DEBUG                                                                                     0x09e5
#define regSQ_DEBUG_BASE_IDX                                                                            1
#define regSQ_SHADER_TBA_LO                                                                             0x09e6
#define regSQ_SHADER_TBA_LO_BASE_IDX                                                                    1
#define regSQ_SHADER_TBA_HI                                                                             0x09e7
#define regSQ_SHADER_TBA_HI_BASE_IDX                                                                    1
#define regSQ_SHADER_TMA_LO                                                                             0x09e8
#define regSQ_SHADER_TMA_LO_BASE_IDX                                                                    1
#define regSQ_SHADER_TMA_HI                                                                             0x09e9
#define regSQ_SHADER_TMA_HI_BASE_IDX                                                                    1


// addressBlock: gc_gfx_se_gfx_se_pfonly_spidec
// base address: 0x2e500
#define regSPI_CDBG_SYS_GFX                                                                             0x1940
#define regSPI_CDBG_SYS_GFX_BASE_IDX                                                                    1
#define regSPI_CDBG_SYS_HP3D                                                                            0x1941
#define regSPI_CDBG_SYS_HP3D_BASE_IDX                                                                   1
#define regSPI_CDBG_SYS_CS0                                                                             0x1942
#define regSPI_CDBG_SYS_CS0_BASE_IDX                                                                    1
#define regSPI_GDBG_WAVE_CNTL                                                                           0x1943
#define regSPI_GDBG_WAVE_CNTL_BASE_IDX                                                                  1
#define regSPI_GDBG_TRAP_CONFIG                                                                         0x1944
#define regSPI_GDBG_TRAP_CONFIG_BASE_IDX                                                                1
#define regSPI_GDBG_WAVE_CNTL3                                                                          0x1945
#define regSPI_GDBG_WAVE_CNTL3_BASE_IDX                                                                 1
#define regSPI_RESET_DEBUG                                                                              0x1946
#define regSPI_RESET_DEBUG_BASE_IDX                                                                     1
#define regGDS_COMPUTE_MAX_WAVE_ID                                                                      0x1947
#define regGDS_COMPUTE_MAX_WAVE_ID_BASE_IDX                                                             1
#define regSPI_ARB_CNTL_0                                                                               0x1949
#define regSPI_ARB_CNTL_0_BASE_IDX                                                                      1
#define regSPI_FEATURE_CTRL                                                                             0x194a
#define regSPI_FEATURE_CTRL_BASE_IDX                                                                    1
#define regSPI_SHADER_RSRC_LIMIT_CTRL                                                                   0x194b
#define regSPI_SHADER_RSRC_LIMIT_CTRL_BASE_IDX                                                          1
#define regPC_CONFIG_CNTL_0                                                                             0x194c
#define regPC_CONFIG_CNTL_0_BASE_IDX                                                                    1
#define regPC_CONFIG_CNTL_1                                                                             0x194d
#define regPC_CONFIG_CNTL_1_BASE_IDX                                                                    1
#define regSPI_COMPUTE_WF_CTX_SAVE_STATUS                                                               0x194e
#define regSPI_COMPUTE_WF_CTX_SAVE_STATUS_BASE_IDX                                                      1


// addressBlock: gc_gfx_se_gfx_se_pfonly_utcl1dec
// base address: 0x2e600
#define regUTCL1_CTRL_0                                                                                 0x1980
#define regUTCL1_CTRL_0_BASE_IDX                                                                        1
#define regUTCL1_UTCL0_INVREQ_DISABLE                                                                   0x1981
#define regUTCL1_UTCL0_INVREQ_DISABLE_BASE_IDX                                                          1
#define regUTCL1_CTRL_2                                                                                 0x1982
#define regUTCL1_CTRL_2_BASE_IDX                                                                        1
#define regUTCL1_FIFO_SIZING                                                                            0x1983
#define regUTCL1_FIFO_SIZING_BASE_IDX                                                                   1
#define regGCRD_SA0_TARGETS_DISABLE                                                                     0x1984
#define regGCRD_SA0_TARGETS_DISABLE_BASE_IDX                                                            1
#define regGCRD_SA1_TARGETS_DISABLE                                                                     0x1985
#define regGCRD_SA1_TARGETS_DISABLE_BASE_IDX                                                            1
#define regGCRD_CREDIT_SAFE                                                                             0x1986
#define regGCRD_CREDIT_SAFE_BASE_IDX                                                                    1
#define regUTCL1_IDENTITY_MODE0                                                                         0x1987
#define regUTCL1_IDENTITY_MODE0_BASE_IDX                                                                1
#define regUTCL1_IDENTITY_MODE1                                                                         0x1988
#define regUTCL1_IDENTITY_MODE1_BASE_IDX                                                                1
#define regUTCL1_IDENTITY_MODE2                                                                         0x1989
#define regUTCL1_IDENTITY_MODE2_BASE_IDX                                                                1
#define regUTCL1_IDENTITY_MODE3                                                                         0x198a
#define regUTCL1_IDENTITY_MODE3_BASE_IDX                                                                1
#define regUTCL1_IDENTITY_MODE4                                                                         0x198b
#define regUTCL1_IDENTITY_MODE4_BASE_IDX                                                                1
#define regUTCL1_IDENTITY_MODE5                                                                         0x198c
#define regUTCL1_IDENTITY_MODE5_BASE_IDX                                                                1
#define regUTCL1_IDENTITY_MODE6                                                                         0x198d
#define regUTCL1_IDENTITY_MODE6_BASE_IDX                                                                1
#define regUTCL1_IDENTITY_MODE7                                                                         0x198e
#define regUTCL1_IDENTITY_MODE7_BASE_IDX                                                                1


// addressBlock: gc_gfx_se_gfx_se_pfonly_tcpdec
// base address: 0x2e680
#define regTCP_INVALIDATE                                                                               0x19a0
#define regTCP_INVALIDATE_BASE_IDX                                                                      1
#define regTCP_STATUS                                                                                   0x19a1
#define regTCP_STATUS_BASE_IDX                                                                          1
#define regTCP_CNTL                                                                                     0x19a2
#define regTCP_CNTL_BASE_IDX                                                                            1
#define regTCP_CNTL2                                                                                    0x19a3
#define regTCP_CNTL2_BASE_IDX                                                                           1
#define regTCP_CREDIT                                                                                   0x19a4
#define regTCP_CREDIT_BASE_IDX                                                                          1
#define regTCP_COMPRESSION_CNTL                                                                         0x19a7
#define regTCP_COMPRESSION_CNTL_BASE_IDX                                                                1
#define regTCP_ARB                                                                                      0x19a8
#define regTCP_ARB_BASE_IDX                                                                             1


// addressBlock: gc_gfx_se_gfx_se_pfonly2_spidec
// base address: 0x2f000
#define regSPI_RESOURCE_RESERVE_CU_0                                                                    0x1c00
#define regSPI_RESOURCE_RESERVE_CU_0_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_1                                                                    0x1c01
#define regSPI_RESOURCE_RESERVE_CU_1_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_2                                                                    0x1c02
#define regSPI_RESOURCE_RESERVE_CU_2_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_3                                                                    0x1c03
#define regSPI_RESOURCE_RESERVE_CU_3_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_4                                                                    0x1c04
#define regSPI_RESOURCE_RESERVE_CU_4_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_5                                                                    0x1c05
#define regSPI_RESOURCE_RESERVE_CU_5_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_6                                                                    0x1c06
#define regSPI_RESOURCE_RESERVE_CU_6_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_7                                                                    0x1c07
#define regSPI_RESOURCE_RESERVE_CU_7_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_8                                                                    0x1c08
#define regSPI_RESOURCE_RESERVE_CU_8_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_9                                                                    0x1c09
#define regSPI_RESOURCE_RESERVE_CU_9_BASE_IDX                                                           1
#define regSPI_RESOURCE_RESERVE_CU_10                                                                   0x1c0a
#define regSPI_RESOURCE_RESERVE_CU_10_BASE_IDX                                                          1
#define regSPI_RESOURCE_RESERVE_CU_11                                                                   0x1c0b
#define regSPI_RESOURCE_RESERVE_CU_11_BASE_IDX                                                          1
#define regSPI_RESOURCE_RESERVE_CU_12                                                                   0x1c0c
#define regSPI_RESOURCE_RESERVE_CU_12_BASE_IDX                                                          1
#define regSPI_RESOURCE_RESERVE_CU_13                                                                   0x1c0d
#define regSPI_RESOURCE_RESERVE_CU_13_BASE_IDX                                                          1
#define regSPI_RESOURCE_RESERVE_CU_14                                                                   0x1c0e
#define regSPI_RESOURCE_RESERVE_CU_14_BASE_IDX                                                          1
#define regSPI_RESOURCE_RESERVE_CU_15                                                                   0x1c0f
#define regSPI_RESOURCE_RESERVE_CU_15_BASE_IDX                                                          1
#define regSPI_RESOURCE_RESERVE_EN_CU_0                                                                 0x1c10
#define regSPI_RESOURCE_RESERVE_EN_CU_0_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_1                                                                 0x1c11
#define regSPI_RESOURCE_RESERVE_EN_CU_1_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_2                                                                 0x1c12
#define regSPI_RESOURCE_RESERVE_EN_CU_2_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_3                                                                 0x1c13
#define regSPI_RESOURCE_RESERVE_EN_CU_3_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_4                                                                 0x1c14
#define regSPI_RESOURCE_RESERVE_EN_CU_4_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_5                                                                 0x1c15
#define regSPI_RESOURCE_RESERVE_EN_CU_5_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_6                                                                 0x1c16
#define regSPI_RESOURCE_RESERVE_EN_CU_6_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_7                                                                 0x1c17
#define regSPI_RESOURCE_RESERVE_EN_CU_7_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_8                                                                 0x1c18
#define regSPI_RESOURCE_RESERVE_EN_CU_8_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_9                                                                 0x1c19
#define regSPI_RESOURCE_RESERVE_EN_CU_9_BASE_IDX                                                        1
#define regSPI_RESOURCE_RESERVE_EN_CU_10                                                                0x1c1a
#define regSPI_RESOURCE_RESERVE_EN_CU_10_BASE_IDX                                                       1
#define regSPI_RESOURCE_RESERVE_EN_CU_11                                                                0x1c1b
#define regSPI_RESOURCE_RESERVE_EN_CU_11_BASE_IDX                                                       1
#define regSPI_RESOURCE_RESERVE_EN_CU_12                                                                0x1c1c
#define regSPI_RESOURCE_RESERVE_EN_CU_12_BASE_IDX                                                       1
#define regSPI_RESOURCE_RESERVE_EN_CU_13                                                                0x1c1d
#define regSPI_RESOURCE_RESERVE_EN_CU_13_BASE_IDX                                                       1
#define regSPI_RESOURCE_RESERVE_EN_CU_14                                                                0x1c1e
#define regSPI_RESOURCE_RESERVE_EN_CU_14_BASE_IDX                                                       1
#define regSPI_RESOURCE_RESERVE_EN_CU_15                                                                0x1c1f
#define regSPI_RESOURCE_RESERVE_EN_CU_15_BASE_IDX                                                       1


// addressBlock: gc_gfx_se_gfx_se_gfxudec
// base address: 0x30000
#define regVGT_TF_RING_SIZE                                                                             0x224e
#define regVGT_TF_RING_SIZE_BASE_IDX                                                                    1
#define regVGT_HS_OFFCHIP_PARAM                                                                         0x224f
#define regVGT_HS_OFFCHIP_PARAM_BASE_IDX                                                                1
#define regGE_POS_RING_BASE                                                                             0x2268
#define regGE_POS_RING_BASE_BASE_IDX                                                                    1
#define regGE_POS_RING_SIZE                                                                             0x2269
#define regGE_POS_RING_SIZE_BASE_IDX                                                                    1
#define regGE_PRIM_RING_BASE                                                                            0x226a
#define regGE_PRIM_RING_BASE_BASE_IDX                                                                   1
#define regGE_PRIM_RING_SIZE                                                                            0x226b
#define regGE_PRIM_RING_SIZE_BASE_IDX                                                                   1
#define regPA_SU_LINE_STIPPLE_VALUE                                                                     0x2280
#define regPA_SU_LINE_STIPPLE_VALUE_BASE_IDX                                                            1
#define regPA_SC_LINE_STIPPLE_STATE                                                                     0x2281
#define regPA_SC_LINE_STIPPLE_STATE_BASE_IDX                                                            1
#define regPA_SC_SCREEN_EXTENT_MIN_0                                                                    0x2284
#define regPA_SC_SCREEN_EXTENT_MIN_0_BASE_IDX                                                           1
#define regPA_SC_SCREEN_EXTENT_MAX_0                                                                    0x2285
#define regPA_SC_SCREEN_EXTENT_MAX_0_BASE_IDX                                                           1
#define regPA_SC_SCREEN_EXTENT_MIN_1                                                                    0x2286
#define regPA_SC_SCREEN_EXTENT_MIN_1_BASE_IDX                                                           1
#define regPA_SC_SCREEN_EXTENT_MAX_1                                                                    0x228b
#define regPA_SC_SCREEN_EXTENT_MAX_1_BASE_IDX                                                           1
#define regPA_SC_P3D_TRAP_SCREEN_HV_EN                                                                  0x22a0
#define regPA_SC_P3D_TRAP_SCREEN_HV_EN_BASE_IDX                                                         1
#define regPA_SC_P3D_TRAP_SCREEN_H                                                                      0x22a1
#define regPA_SC_P3D_TRAP_SCREEN_H_BASE_IDX                                                             1
#define regPA_SC_P3D_TRAP_SCREEN_V                                                                      0x22a2
#define regPA_SC_P3D_TRAP_SCREEN_V_BASE_IDX                                                             1
#define regPA_SC_P3D_TRAP_SCREEN_OCCURRENCE                                                             0x22a3
#define regPA_SC_P3D_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                    1
#define regPA_SC_P3D_TRAP_SCREEN_COUNT                                                                  0x22a4
#define regPA_SC_P3D_TRAP_SCREEN_COUNT_BASE_IDX                                                         1
#define regPA_SC_HP3D_TRAP_SCREEN_HV_EN                                                                 0x22a8
#define regPA_SC_HP3D_TRAP_SCREEN_HV_EN_BASE_IDX                                                        1
#define regPA_SC_HP3D_TRAP_SCREEN_H                                                                     0x22a9
#define regPA_SC_HP3D_TRAP_SCREEN_H_BASE_IDX                                                            1
#define regPA_SC_HP3D_TRAP_SCREEN_V                                                                     0x22aa
#define regPA_SC_HP3D_TRAP_SCREEN_V_BASE_IDX                                                            1
#define regPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE                                                            0x22ab
#define regPA_SC_HP3D_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                   1
#define regPA_SC_HP3D_TRAP_SCREEN_COUNT                                                                 0x22ac
#define regPA_SC_HP3D_TRAP_SCREEN_COUNT_BASE_IDX                                                        1
#define regPA_SC_TRAP_SCREEN_HV_EN                                                                      0x22b0
#define regPA_SC_TRAP_SCREEN_HV_EN_BASE_IDX                                                             1
#define regPA_SC_TRAP_SCREEN_H                                                                          0x22b1
#define regPA_SC_TRAP_SCREEN_H_BASE_IDX                                                                 1
#define regPA_SC_TRAP_SCREEN_V                                                                          0x22b2
#define regPA_SC_TRAP_SCREEN_V_BASE_IDX                                                                 1
#define regPA_SC_TRAP_SCREEN_OCCURRENCE                                                                 0x22b3
#define regPA_SC_TRAP_SCREEN_OCCURRENCE_BASE_IDX                                                        1
#define regPA_SC_TRAP_SCREEN_COUNT                                                                      0x22b4
#define regPA_SC_TRAP_SCREEN_COUNT_BASE_IDX                                                             1
#define regSQ_THREAD_TRACE_USERDATA_0                                                                   0x2340
#define regSQ_THREAD_TRACE_USERDATA_0_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_1                                                                   0x2341
#define regSQ_THREAD_TRACE_USERDATA_1_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_2                                                                   0x2342
#define regSQ_THREAD_TRACE_USERDATA_2_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_3                                                                   0x2343
#define regSQ_THREAD_TRACE_USERDATA_3_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_4                                                                   0x2344
#define regSQ_THREAD_TRACE_USERDATA_4_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_5                                                                   0x2345
#define regSQ_THREAD_TRACE_USERDATA_5_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_6                                                                   0x2346
#define regSQ_THREAD_TRACE_USERDATA_6_BASE_IDX                                                          1
#define regSQ_THREAD_TRACE_USERDATA_7                                                                   