/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "mediainfodialog.h"
#include "ui_mediainfodialog.h"

#include <QDebug>
#include <QScrollBar>
#include <QMouseEvent>

#include "global/global.h"
#include "global/globalsignal.h"
#include "global/xatom-helper.h"

MediaInfoDialog::MediaInfoDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::MediaInfoDialog)
{
    ui->setupUi(this);
    setFixedSize(376, 352);

    ui->btn_icon->setFixedSize(QSize(26,26));
    ui->btn_icon->setIconSize(QSize(26,26));
    ui->btn_icon->setIcon(QIcon::fromTheme("kylin-video"));
    ui->btn_icon->setStyleSheet("QPushButton{border:0px;background:transparent;}"
                                "QPushButton::hover{border:0px;background:transparent;}"
                                "QPushButton::pressed{border:0px;background:transparent;}");

    // ui->textBrowser->setVerticalScrollBarPolicy(Qt::ScrollBarAlwaysOff);

    installEventFilter(this);

    MotifWmHints hints1;
    hints1.flags = MWM_HINTS_FUNCTIONS | MWM_HINTS_DECORATIONS;
    hints1.functions = MWM_FUNC_ALL;
    hints1.decorations = MWM_DECOR_BORDER;
    XAtomHelper::getInstance()->setWindowMotifHint(winId(), hints1);
}

MediaInfoDialog::~MediaInfoDialog()
{
    delete ui;
}

void MediaInfoDialog::setData(QString data)
{
    ui->textBrowser->setText(data);
}

void MediaInfoDialog::ukuiMove()
{
    UKUIDecorationManager::getInstance()->moveWindow(this->windowHandle());
}

void MediaInfoDialog::on_pushButton_clicked()
{
    hide();
}

bool MediaInfoDialog::eventFilter(QObject *watched, QEvent *event)
{
    if(Global::isWayland)
    {
        if(watched == this)
        {
            if (event->type() == QEvent::MouseButtonPress){
                auto mouseEvent = static_cast<QMouseEvent *>(event);
                if (mouseEvent->buttons() & Qt::LeftButton) {
                    ukuiMove();
                }
            }
        }
    }
    return false;
}

void MediaInfoDialog::showEvent(QShowEvent *event)
{
    // 背景模糊
    KWindowEffects::enableBlurBehind(winId(), true);
    return QDialog::showEvent(event);
}
