/*
 * Kylin-video
 *
 * Copyright (C) 2021, Tianjin KYLIN Information Technology Co., Ltd.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *
 * Authors: Liu Cong <liucong1@kylinos.cn>
 *
 */

#include "paths.h"
#include <QLibraryInfo>
#include <QLocale>
#include <QFile>
#include <QRegExp>
#include <QDir>
#include <QDebug>

QString Paths::app_path = "";
QString Paths::config_path = "";
QString Paths::log_path = "";

void Paths::setAppPath(QString path) {
    app_path = path;
}

QString Paths::previewPath()
{
    QString fulldir = configPath() + "/preview";
    QDir dir(fulldir);
    if (!dir.exists()) {
        dir.mkdir(fulldir);
    }
    return fulldir;
}

QString Paths::appPath() {
	return app_path;
}

QString Paths::translationPath()
{
    QString path;
    if (QDir("/usr/share/kylin-video/translations").exists()) {
        path = "/usr/share/kylin-video/translations";
        return path;
    }
    else {
        return appPath() + "/translations";
    }
}

QString Paths::shortcutsPath() {
    return appPath() + "/shortcuts";
}

QString Paths::qtTranslationPath() {
    return QLibraryInfo::location(QLibraryInfo::TranslationsPath);// /usr/share/qt5/translations
}

void Paths::setConfigPath(QString path) {
	config_path = path;
    QDir dir(config_path);
    if(!dir.exists())
    {
        dir.mkdir(config_path);
    }
}

void Paths::setLogPath(QString path)
{
    log_path = log_path;
    QDir dir(config_path);
    if(!dir.exists())
    {
        dir.mkdir(log_path);
    }
}

QString Paths::configPath() {
    if (!config_path.isEmpty()) {
        return config_path;
    } else {
        QDir dir(QDir::homePath() + "/.config/kylin-video");
        if(!dir.exists())
        {
            dir.mkdir(QDir::homePath() + "/.config/kylin-video");
        }
        return QDir::homePath() + "/.config/kylin-video";
    }
}

QString Paths::iniPath() {
    return configPath();
}

QString Paths::logPath()
{
    if (!log_path.isEmpty()) {
        return log_path;
    } else {
        QDir dir(QDir::homePath() + "/.cache/kylin-video");
        if(!dir.exists())
        {
            bool ret = dir.mkpath(QDir::homePath() + "/.cache/kylin-video");
            if(!ret)
            {
                qDebug() << "log path create error!";
            }
        }
        return QDir::homePath() + "/.cache/kylin-video";
    }
}

QString Paths::subtitleStyleFile() {
    return configPath() + "/styles.ass";
}
