// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrock

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrock/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a guardrail to block topics and to filter out harmful content.
//
//   - Specify a name and optional description .
//
//   - Specify messages for when the guardrail successfully blocks a prompt or a
//     model response in the blockedInputMessaging and blockedOutputsMessaging fields.
//
//   - Specify topics for the guardrail to deny in the topicPolicyConfig object.
//     Each [GuardrailTopicConfig]object in the topicsConfig list pertains to one topic.
//
//   - Give a name and description so that the guardrail can properly identify the
//     topic.
//
//   - Specify DENY in the type field.
//
//   - (Optional) Provide up to five prompts that you would categorize as
//     belonging to the topic in the examples list.
//
//   - Specify filter strengths for the harmful categories defined in Amazon
//     Bedrock in the contentPolicyConfig object. Each [GuardrailContentFilterConfig]object in the filtersConfig
//     list pertains to a harmful category. For more information, see [Content filters]. For more
//     information about the fields in a content filter, see [GuardrailContentFilterConfig].
//
//   - Specify the category in the type field.
//
//   - Specify the strength of the filter for prompts in the inputStrength field
//     and for model responses in the strength field of the [GuardrailContentFilterConfig].
//
//   - (Optional) For security, include the ARN of a KMS key in the kmsKeyId field.
//
//   - (Optional) Attach any tags to the guardrail in the tags object. For more
//     information, see [Tag resources].
//
// [GuardrailContentFilterConfig]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailContentFilterConfig.html
// [Content filters]: https://docs.aws.amazon.com/bedrock/latest/userguide/guardrails-filters
// [Tag resources]: https://docs.aws.amazon.com/bedrock/latest/userguide/tagging
// [GuardrailTopicConfig]: https://docs.aws.amazon.com/bedrock/latest/APIReference/API_GuardrailTopicConfig.html
func (c *Client) CreateGuardrail(ctx context.Context, params *CreateGuardrailInput, optFns ...func(*Options)) (*CreateGuardrailOutput, error) {
	if params == nil {
		params = &CreateGuardrailInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateGuardrail", params, optFns, c.addOperationCreateGuardrailMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateGuardrailOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateGuardrailInput struct {

	// The message to return when the guardrail blocks a prompt.
	//
	// This member is required.
	BlockedInputMessaging *string

	// The message to return when the guardrail blocks a model response.
	//
	// This member is required.
	BlockedOutputsMessaging *string

	// The name to give the guardrail.
	//
	// This member is required.
	Name *string

	// A unique, case-sensitive identifier to ensure that the API request completes no
	// more than once. If this token matches a previous request, Amazon Bedrock ignores
	// the request, but does not return an error. For more information, see [Ensuring idempotency]in the
	// Amazon S3 User Guide.
	//
	// [Ensuring idempotency]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html
	ClientRequestToken *string

	// The content filter policies to configure for the guardrail.
	ContentPolicyConfig *types.GuardrailContentPolicyConfig

	// A description of the guardrail.
	Description *string

	// The ARN of the KMS key that you use to encrypt the guardrail.
	KmsKeyId *string

	// The sensitive information policy to configure for the guardrail.
	SensitiveInformationPolicyConfig *types.GuardrailSensitiveInformationPolicyConfig

	// The tags that you want to attach to the guardrail.
	Tags []types.Tag

	// The topic policies to configure for the guardrail.
	TopicPolicyConfig *types.GuardrailTopicPolicyConfig

	// The word policy you configure for the guardrail.
	WordPolicyConfig *types.GuardrailWordPolicyConfig

	noSmithyDocumentSerde
}

type CreateGuardrailOutput struct {

	// The time at which the guardrail was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The ARN of the guardrail that was created.
	//
	// This member is required.
	GuardrailArn *string

	// The unique identifier of the guardrail that was created.
	//
	// This member is required.
	GuardrailId *string

	// The version of the guardrail that was created. This value should be 1.
	//
	// This member is required.
	Version *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateGuardrailMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateGuardrail{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateGuardrail{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateGuardrail"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opCreateGuardrailMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpCreateGuardrailValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateGuardrail(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpCreateGuardrail struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpCreateGuardrail) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpCreateGuardrail) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*CreateGuardrailInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *CreateGuardrailInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opCreateGuardrailMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpCreateGuardrail{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opCreateGuardrail(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateGuardrail",
	}
}
