//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armvideoanalyzer

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// PipelineJobsClient contains the methods for the PipelineJobs group.
// Don't use this type directly, use NewPipelineJobsClient() instead.
type PipelineJobsClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewPipelineJobsClient creates a new instance of PipelineJobsClient with the specified values.
// subscriptionID - The ID of the target subscription.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewPipelineJobsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*PipelineJobsClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &PipelineJobsClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCancel - Cancels a pipeline job with the given name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Azure Video Analyzer account name.
// pipelineJobName - The pipeline job name.
// options - PipelineJobsClientBeginCancelOptions contains the optional parameters for the PipelineJobsClient.BeginCancel
// method.
func (client *PipelineJobsClient) BeginCancel(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, options *PipelineJobsClientBeginCancelOptions) (*runtime.Poller[PipelineJobsClientCancelResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.cancel(ctx, resourceGroupName, accountName, pipelineJobName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[PipelineJobsClientCancelResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[PipelineJobsClientCancelResponse](options.ResumeToken, client.pl, nil)
	}
}

// Cancel - Cancels a pipeline job with the given name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
func (client *PipelineJobsClient) cancel(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, options *PipelineJobsClientBeginCancelOptions) (*http.Response, error) {
	req, err := client.cancelCreateRequest(ctx, resourceGroupName, accountName, pipelineJobName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// cancelCreateRequest creates the Cancel request.
func (client *PipelineJobsClient) cancelCreateRequest(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, options *PipelineJobsClientBeginCancelOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineJobs/{pipelineJobName}/cancel"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if pipelineJobName == "" {
		return nil, errors.New("parameter pipelineJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{pipelineJobName}", url.PathEscape(pipelineJobName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// CreateOrUpdate - Creates a new pipeline job or updates an existing one, with the given name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Azure Video Analyzer account name.
// pipelineJobName - The pipeline job name.
// parameters - The request parameters
// options - PipelineJobsClientCreateOrUpdateOptions contains the optional parameters for the PipelineJobsClient.CreateOrUpdate
// method.
func (client *PipelineJobsClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, parameters PipelineJob, options *PipelineJobsClientCreateOrUpdateOptions) (PipelineJobsClientCreateOrUpdateResponse, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, accountName, pipelineJobName, parameters, options)
	if err != nil {
		return PipelineJobsClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PipelineJobsClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusCreated) {
		return PipelineJobsClientCreateOrUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.createOrUpdateHandleResponse(resp)
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *PipelineJobsClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, parameters PipelineJob, options *PipelineJobsClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineJobs/{pipelineJobName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if pipelineJobName == "" {
		return nil, errors.New("parameter pipelineJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{pipelineJobName}", url.PathEscape(pipelineJobName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *PipelineJobsClient) createOrUpdateHandleResponse(resp *http.Response) (PipelineJobsClientCreateOrUpdateResponse, error) {
	result := PipelineJobsClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PipelineJob); err != nil {
		return PipelineJobsClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// Delete - Deletes a pipeline job with the given name.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Azure Video Analyzer account name.
// pipelineJobName - The pipeline job name.
// options - PipelineJobsClientDeleteOptions contains the optional parameters for the PipelineJobsClient.Delete method.
func (client *PipelineJobsClient) Delete(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, options *PipelineJobsClientDeleteOptions) (PipelineJobsClientDeleteResponse, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, accountName, pipelineJobName, options)
	if err != nil {
		return PipelineJobsClientDeleteResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PipelineJobsClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusNoContent) {
		return PipelineJobsClientDeleteResponse{}, runtime.NewResponseError(resp)
	}
	return PipelineJobsClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *PipelineJobsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, options *PipelineJobsClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineJobs/{pipelineJobName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if pipelineJobName == "" {
		return nil, errors.New("parameter pipelineJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{pipelineJobName}", url.PathEscape(pipelineJobName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Retrieves a specific pipeline job by name. If a pipeline job with that name has been previously created, the call
// will return the JSON representation of that instance.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Azure Video Analyzer account name.
// pipelineJobName - The pipeline job name.
// options - PipelineJobsClientGetOptions contains the optional parameters for the PipelineJobsClient.Get method.
func (client *PipelineJobsClient) Get(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, options *PipelineJobsClientGetOptions) (PipelineJobsClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, accountName, pipelineJobName, options)
	if err != nil {
		return PipelineJobsClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PipelineJobsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PipelineJobsClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *PipelineJobsClient) getCreateRequest(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, options *PipelineJobsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineJobs/{pipelineJobName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if pipelineJobName == "" {
		return nil, errors.New("parameter pipelineJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{pipelineJobName}", url.PathEscape(pipelineJobName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *PipelineJobsClient) getHandleResponse(resp *http.Response) (PipelineJobsClientGetResponse, error) {
	result := PipelineJobsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PipelineJob); err != nil {
		return PipelineJobsClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - Retrieves a list of all live pipelines that have been created, along with their JSON representations.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Azure Video Analyzer account name.
// options - PipelineJobsClientListOptions contains the optional parameters for the PipelineJobsClient.List method.
func (client *PipelineJobsClient) NewListPager(resourceGroupName string, accountName string, options *PipelineJobsClientListOptions) *runtime.Pager[PipelineJobsClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[PipelineJobsClientListResponse]{
		More: func(page PipelineJobsClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *PipelineJobsClientListResponse) (PipelineJobsClientListResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listCreateRequest(ctx, resourceGroupName, accountName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return PipelineJobsClientListResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return PipelineJobsClientListResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return PipelineJobsClientListResponse{}, runtime.NewResponseError(resp)
			}
			return client.listHandleResponse(resp)
		},
	})
}

// listCreateRequest creates the List request.
func (client *PipelineJobsClient) listCreateRequest(ctx context.Context, resourceGroupName string, accountName string, options *PipelineJobsClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineJobs"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	if options != nil && options.Filter != nil {
		reqQP.Set("$filter", *options.Filter)
	}
	if options != nil && options.Top != nil {
		reqQP.Set("$top", strconv.FormatInt(int64(*options.Top), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *PipelineJobsClient) listHandleResponse(resp *http.Response) (PipelineJobsClientListResponse, error) {
	result := PipelineJobsClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PipelineJobCollection); err != nil {
		return PipelineJobsClientListResponse{}, err
	}
	return result, nil
}

// Update - Updates an existing pipeline job with the given name. Properties that can be updated include: description.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2021-11-01-preview
// resourceGroupName - The name of the resource group. The name is case insensitive.
// accountName - The Azure Video Analyzer account name.
// pipelineJobName - The pipeline job name.
// parameters - The request parameters
// options - PipelineJobsClientUpdateOptions contains the optional parameters for the PipelineJobsClient.Update method.
func (client *PipelineJobsClient) Update(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, parameters PipelineJobUpdate, options *PipelineJobsClientUpdateOptions) (PipelineJobsClientUpdateResponse, error) {
	req, err := client.updateCreateRequest(ctx, resourceGroupName, accountName, pipelineJobName, parameters, options)
	if err != nil {
		return PipelineJobsClientUpdateResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return PipelineJobsClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return PipelineJobsClientUpdateResponse{}, runtime.NewResponseError(resp)
	}
	return client.updateHandleResponse(resp)
}

// updateCreateRequest creates the Update request.
func (client *PipelineJobsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, accountName string, pipelineJobName string, parameters PipelineJobUpdate, options *PipelineJobsClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Media/videoAnalyzers/{accountName}/pipelineJobs/{pipelineJobName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if accountName == "" {
		return nil, errors.New("parameter accountName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{accountName}", url.PathEscape(accountName))
	if pipelineJobName == "" {
		return nil, errors.New("parameter pipelineJobName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{pipelineJobName}", url.PathEscape(pipelineJobName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2021-11-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// updateHandleResponse handles the Update response.
func (client *PipelineJobsClient) updateHandleResponse(resp *http.Response) (PipelineJobsClientUpdateResponse, error) {
	result := PipelineJobsClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.PipelineJob); err != nil {
		return PipelineJobsClientUpdateResponse{}, err
	}
	return result, nil
}
