//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armsqlvirtualmachine

import "time"

// AdditionalFeaturesServerConfigurations - Additional SQL Server feature settings.
type AdditionalFeaturesServerConfigurations struct {
	// Enable or disable R services (SQL 2016 onwards).
	IsRServicesEnabled *bool `json:"isRServicesEnabled,omitempty"`
}

// AgConfiguration - Availability group configuration.
type AgConfiguration struct {
	// Replica configurations.
	Replicas []*AgReplica `json:"replicas,omitempty"`
}

// AgReplica - Availability group replica configuration.
type AgReplica struct {
	// Replica commit mode in availability group.
	Commit *Commit `json:"commit,omitempty"`

	// Replica failover mode in availability group.
	Failover *Failover `json:"failover,omitempty"`

	// Replica readable secondary mode in availability group.
	ReadableSecondary *ReadableSecondary `json:"readableSecondary,omitempty"`

	// Replica Role in availability group.
	Role *Role `json:"role,omitempty"`

	// Sql VirtualMachine Instance Id.
	SQLVirtualMachineInstanceID *string `json:"sqlVirtualMachineInstanceId,omitempty"`
}

// AssessmentSettings - Configure assessment for databases in your SQL virtual machine.
type AssessmentSettings struct {
	// Enable or disable assessment feature on SQL virtual machine.
	Enable *bool `json:"enable,omitempty"`

	// Run assessment immediately on SQL virtual machine.
	RunImmediately *bool `json:"runImmediately,omitempty"`

	// Schedule for Assessment.
	Schedule *Schedule `json:"schedule,omitempty"`
}

// AutoBackupSettings - Configure backups for databases in your SQL virtual machine.
type AutoBackupSettings struct {
	// Backup schedule type.
	BackupScheduleType *BackupScheduleType `json:"backupScheduleType,omitempty"`

	// Include or exclude system databases from auto backup.
	BackupSystemDbs *bool `json:"backupSystemDbs,omitempty"`

	// Days of the week for the backups when FullBackupFrequency is set to Weekly.
	DaysOfWeek []*AutoBackupDaysOfWeek `json:"daysOfWeek,omitempty"`

	// Enable or disable autobackup on SQL virtual machine.
	Enable *bool `json:"enable,omitempty"`

	// Enable or disable encryption for backup on SQL virtual machine.
	EnableEncryption *bool `json:"enableEncryption,omitempty"`

	// Frequency of full backups. In both cases, full backups begin during the next scheduled time window.
	FullBackupFrequency *FullBackupFrequencyType `json:"fullBackupFrequency,omitempty"`

	// Start time of a given day during which full backups can take place. 0-23 hours.
	FullBackupStartTime *int32 `json:"fullBackupStartTime,omitempty"`

	// Duration of the time window of a given day during which full backups can take place. 1-23 hours.
	FullBackupWindowHours *int32 `json:"fullBackupWindowHours,omitempty"`

	// Frequency of log backups. 5-60 minutes.
	LogBackupFrequency *int32 `json:"logBackupFrequency,omitempty"`

	// Password for encryption on backup.
	Password *string `json:"password,omitempty"`

	// Retention period of backup: 1-90 days.
	RetentionPeriod *int32 `json:"retentionPeriod,omitempty"`

	// Storage account key where backup will be taken to.
	StorageAccessKey *string `json:"storageAccessKey,omitempty"`

	// Storage account url where backup will be taken to.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`

	// Storage container name where backup will be taken to.
	StorageContainerName *string `json:"storageContainerName,omitempty"`
}

// AutoPatchingSettings - Set a patching window during which Windows and SQL patches will be applied.
type AutoPatchingSettings struct {
	// Day of week to apply the patch on.
	DayOfWeek *DayOfWeek `json:"dayOfWeek,omitempty"`

	// Enable or disable autopatching on SQL virtual machine.
	Enable *bool `json:"enable,omitempty"`

	// Duration of patching.
	MaintenanceWindowDuration *int32 `json:"maintenanceWindowDuration,omitempty"`

	// Hour of the day when patching is initiated. Local VM time.
	MaintenanceWindowStartingHour *int32 `json:"maintenanceWindowStartingHour,omitempty"`
}

// AvailabilityGroupListener - A SQL Server availability group listener.
type AvailabilityGroupListener struct {
	// Resource properties.
	Properties *AvailabilityGroupListenerProperties `json:"properties,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// AvailabilityGroupListenerListResult - A list of availability group listeners.
type AvailabilityGroupListenerListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*AvailabilityGroupListener `json:"value,omitempty" azure:"ro"`
}

// AvailabilityGroupListenerProperties - The properties of an availability group listener.
type AvailabilityGroupListenerProperties struct {
	// Availability Group configuration.
	AvailabilityGroupConfiguration *AgConfiguration `json:"availabilityGroupConfiguration,omitempty"`

	// Name of the availability group.
	AvailabilityGroupName *string `json:"availabilityGroupName,omitempty"`

	// Create a default availability group if it does not exist.
	CreateDefaultAvailabilityGroupIfNotExist *bool `json:"createDefaultAvailabilityGroupIfNotExist,omitempty"`

	// List of load balancer configurations for an availability group listener.
	LoadBalancerConfigurations []*LoadBalancerConfiguration `json:"loadBalancerConfigurations,omitempty"`

	// List of multi subnet IP configurations for an AG listener.
	MultiSubnetIPConfigurations []*MultiSubnetIPConfiguration `json:"multiSubnetIpConfigurations,omitempty"`

	// Listener port.
	Port *int32 `json:"port,omitempty"`

	// READ-ONLY; Provisioning state to track the async operation status.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// AvailabilityGroupListenersClientBeginCreateOrUpdateOptions contains the optional parameters for the AvailabilityGroupListenersClient.BeginCreateOrUpdate
// method.
type AvailabilityGroupListenersClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AvailabilityGroupListenersClientBeginDeleteOptions contains the optional parameters for the AvailabilityGroupListenersClient.BeginDelete
// method.
type AvailabilityGroupListenersClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// AvailabilityGroupListenersClientGetOptions contains the optional parameters for the AvailabilityGroupListenersClient.Get
// method.
type AvailabilityGroupListenersClientGetOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// AvailabilityGroupListenersClientListByGroupOptions contains the optional parameters for the AvailabilityGroupListenersClient.ListByGroup
// method.
type AvailabilityGroupListenersClientListByGroupOptions struct {
	// placeholder for future optional parameters
}

// Group - A SQL virtual machine group.
type Group struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Resource properties.
	Properties *GroupProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// GroupListResult - A list of SQL virtual machine groups.
type GroupListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*Group `json:"value,omitempty" azure:"ro"`
}

// GroupProperties - The properties of a SQL virtual machine group.
type GroupProperties struct {
	// SQL image offer. Examples may include SQL2016-WS2016, SQL2017-WS2016.
	SQLImageOffer *string `json:"sqlImageOffer,omitempty"`

	// SQL image sku.
	SQLImageSKU *SQLVMGroupImageSKU `json:"sqlImageSku,omitempty"`

	// Cluster Active Directory domain profile.
	WsfcDomainProfile *WsfcDomainProfile `json:"wsfcDomainProfile,omitempty"`

	// READ-ONLY; Cluster type.
	ClusterConfiguration *ClusterConfiguration `json:"clusterConfiguration,omitempty" azure:"ro"`

	// READ-ONLY; Type of cluster manager: Windows Server Failover Cluster (WSFC), implied by the scale type of the group and
	// the OS type.
	ClusterManagerType *ClusterManagerType `json:"clusterManagerType,omitempty" azure:"ro"`

	// READ-ONLY; Provisioning state to track the async operation status.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`

	// READ-ONLY; Scale type.
	ScaleType *ScaleType `json:"scaleType,omitempty" azure:"ro"`
}

// GroupUpdate - An update to a SQL virtual machine group.
type GroupUpdate struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// GroupsClientBeginCreateOrUpdateOptions contains the optional parameters for the GroupsClient.BeginCreateOrUpdate method.
type GroupsClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GroupsClientBeginDeleteOptions contains the optional parameters for the GroupsClient.BeginDelete method.
type GroupsClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GroupsClientBeginUpdateOptions contains the optional parameters for the GroupsClient.BeginUpdate method.
type GroupsClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// GroupsClientGetOptions contains the optional parameters for the GroupsClient.Get method.
type GroupsClientGetOptions struct {
	// placeholder for future optional parameters
}

// GroupsClientListByResourceGroupOptions contains the optional parameters for the GroupsClient.ListByResourceGroup method.
type GroupsClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// GroupsClientListOptions contains the optional parameters for the GroupsClient.List method.
type GroupsClientListOptions struct {
	// placeholder for future optional parameters
}

// KeyVaultCredentialSettings - Configure your SQL virtual machine to be able to connect to the Azure Key Vault service.
type KeyVaultCredentialSettings struct {
	// Azure Key Vault url.
	AzureKeyVaultURL *string `json:"azureKeyVaultUrl,omitempty"`

	// Credential name.
	CredentialName *string `json:"credentialName,omitempty"`

	// Enable or disable key vault credential setting.
	Enable *bool `json:"enable,omitempty"`

	// Service principal name to access key vault.
	ServicePrincipalName *string `json:"servicePrincipalName,omitempty"`

	// Service principal name secret to access key vault.
	ServicePrincipalSecret *string `json:"servicePrincipalSecret,omitempty"`
}

// ListResult - A list of SQL virtual machines.
type ListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*SQLVirtualMachine `json:"value,omitempty" azure:"ro"`
}

// LoadBalancerConfiguration - A load balancer configuration for an availability group listener.
type LoadBalancerConfiguration struct {
	// Resource id of the load balancer.
	LoadBalancerResourceID *string `json:"loadBalancerResourceId,omitempty"`

	// Private IP address.
	PrivateIPAddress *PrivateIPAddress `json:"privateIpAddress,omitempty"`

	// Probe port.
	ProbePort *int32 `json:"probePort,omitempty"`

	// Resource id of the public IP.
	PublicIPAddressResourceID *string `json:"publicIpAddressResourceId,omitempty"`

	// List of the SQL virtual machine instance resource id's that are enrolled into the availability group listener.
	SQLVirtualMachineInstances []*string `json:"sqlVirtualMachineInstances,omitempty"`
}

// MultiSubnetIPConfiguration - Multi subnet ip configuration for an availability group listener.
type MultiSubnetIPConfiguration struct {
	// REQUIRED; Private IP address.
	PrivateIPAddress *PrivateIPAddress `json:"privateIpAddress,omitempty"`

	// REQUIRED; SQL virtual machine instance resource id that are enrolled into the availability group listener.
	SQLVirtualMachineInstance *string `json:"sqlVirtualMachineInstance,omitempty"`
}

// Operation - SQL REST API operation definition.
type Operation struct {
	// READ-ONLY; The localized display information for this particular operation / action.
	Display *OperationDisplay `json:"display,omitempty" azure:"ro"`

	// READ-ONLY; The name of the operation being performed on this particular object.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The intended executor of the operation.
	Origin *OperationOrigin `json:"origin,omitempty" azure:"ro"`

	// READ-ONLY; Additional descriptions for the operation.
	Properties map[string]interface{} `json:"properties,omitempty" azure:"ro"`
}

// OperationDisplay - Display metadata associated with the operation.
type OperationDisplay struct {
	// READ-ONLY; The localized friendly description for the operation.
	Description *string `json:"description,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly name for the operation.
	Operation *string `json:"operation,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource provider name.
	Provider *string `json:"provider,omitempty" azure:"ro"`

	// READ-ONLY; The localized friendly form of the resource type related to this action/operation.
	Resource *string `json:"resource,omitempty" azure:"ro"`
}

// OperationListResult - Result of the request to list SQL operations.
type OperationListResult struct {
	// READ-ONLY; Link to retrieve next page of results.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`

	// READ-ONLY; Array of results.
	Value []*Operation `json:"value,omitempty" azure:"ro"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// PrivateIPAddress - A private IP address bound to the availability group listener.
type PrivateIPAddress struct {
	// Private IP address bound to the availability group listener.
	IPAddress *string `json:"ipAddress,omitempty"`

	// Subnet used to include private IP.
	SubnetResourceID *string `json:"subnetResourceId,omitempty"`
}

// Properties - The SQL virtual machine properties.
type Properties struct {
	// Assessment Settings.
	AssessmentSettings *AssessmentSettings `json:"assessmentSettings,omitempty"`

	// Auto backup settings for SQL Server.
	AutoBackupSettings *AutoBackupSettings `json:"autoBackupSettings,omitempty"`

	// Auto patching settings for applying critical security updates to SQL virtual machine.
	AutoPatchingSettings *AutoPatchingSettings `json:"autoPatchingSettings,omitempty"`

	// Enable automatic upgrade of Sql IaaS extension Agent.
	EnableAutomaticUpgrade *bool `json:"enableAutomaticUpgrade,omitempty"`

	// Key vault credential settings.
	KeyVaultCredentialSettings *KeyVaultCredentialSettings `json:"keyVaultCredentialSettings,omitempty"`

	// SQL IaaS Agent least privilege mode.
	LeastPrivilegeMode *LeastPrivilegeMode `json:"leastPrivilegeMode,omitempty"`

	// SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016.
	SQLImageOffer *string `json:"sqlImageOffer,omitempty"`

	// SQL Server edition type.
	SQLImageSKU *SQLImageSKU `json:"sqlImageSku,omitempty"`

	// SQL Server Management type.
	SQLManagement *SQLManagementMode `json:"sqlManagement,omitempty"`

	// SQL Server license type.
	SQLServerLicenseType *SQLServerLicenseType `json:"sqlServerLicenseType,omitempty"`

	// ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of.
	SQLVirtualMachineGroupResourceID *string `json:"sqlVirtualMachineGroupResourceId,omitempty"`

	// SQL Server configuration management settings.
	ServerConfigurationsManagementSettings *ServerConfigurationsManagementSettings `json:"serverConfigurationsManagementSettings,omitempty"`

	// Storage Configuration Settings.
	StorageConfigurationSettings *StorageConfigurationSettings `json:"storageConfigurationSettings,omitempty"`

	// ARM Resource id of underlying virtual machine created from SQL marketplace image.
	VirtualMachineResourceID *string `json:"virtualMachineResourceId,omitempty"`

	// Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
	WsfcDomainCredentials *WsfcDomainCredentials `json:"wsfcDomainCredentials,omitempty"`

	// Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
	WsfcStaticIP *string `json:"wsfcStaticIp,omitempty"`

	// READ-ONLY; Provisioning state to track the async operation status.
	ProvisioningState *string `json:"provisioningState,omitempty" azure:"ro"`
}

// ResourceIdentity - Azure Active Directory identity configuration for a resource.
type ResourceIdentity struct {
	// The identity type. Set this to 'SystemAssigned' in order to automatically create and assign an Azure Active Directory principal
	// for the resource.
	Type *IdentityType `json:"type,omitempty"`

	// READ-ONLY; The Azure Active Directory principal id.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The Azure Active Directory tenant id.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// SQLConnectivityUpdateSettings - Set the access level and network port settings for SQL Server.
type SQLConnectivityUpdateSettings struct {
	// SQL Server connectivity option.
	ConnectivityType *ConnectivityType `json:"connectivityType,omitempty"`

	// SQL Server port.
	Port *int32 `json:"port,omitempty"`

	// SQL Server sysadmin login password.
	SQLAuthUpdatePassword *string `json:"sqlAuthUpdatePassword,omitempty"`

	// SQL Server sysadmin login to create.
	SQLAuthUpdateUserName *string `json:"sqlAuthUpdateUserName,omitempty"`
}

// SQLInstanceSettings - Set the server/instance-level settings for SQL Server.
type SQLInstanceSettings struct {
	// SQL Server Collation.
	Collation *string `json:"collation,omitempty"`

	// SQL Server IFI.
	IsIfiEnabled *bool `json:"isIfiEnabled,omitempty"`

	// SQL Server LPIM.
	IsLpimEnabled *bool `json:"isLpimEnabled,omitempty"`

	// SQL Server Optimize for Adhoc workloads.
	IsOptimizeForAdHocWorkloadsEnabled *bool `json:"isOptimizeForAdHocWorkloadsEnabled,omitempty"`

	// SQL Server MAXDOP.
	MaxDop *int32 `json:"maxDop,omitempty"`

	// SQL Server maximum memory.
	MaxServerMemoryMB *int32 `json:"maxServerMemoryMB,omitempty"`

	// SQL Server minimum memory.
	MinServerMemoryMB *int32 `json:"minServerMemoryMB,omitempty"`
}

// SQLStorageSettings - Set disk storage settings for SQL Server.
type SQLStorageSettings struct {
	// SQL Server default file path
	DefaultFilePath *string `json:"defaultFilePath,omitempty"`

	// Logical Unit Numbers for the disks.
	Luns []*int32 `json:"luns,omitempty"`
}

// SQLStorageUpdateSettings - Set disk storage settings for SQL Server.
type SQLStorageUpdateSettings struct {
	// Disk configuration to apply to SQL Server.
	DiskConfigurationType *DiskConfigurationType `json:"diskConfigurationType,omitempty"`

	// Virtual machine disk count.
	DiskCount *int32 `json:"diskCount,omitempty"`

	// Device id of the first disk to be updated.
	StartingDeviceID *int32 `json:"startingDeviceId,omitempty"`
}

// SQLTempDbSettings - Set tempDb storage settings for SQL Server.
type SQLTempDbSettings struct {
	// SQL Server tempdb data file count
	DataFileCount *int32 `json:"dataFileCount,omitempty"`

	// SQL Server tempdb data file size
	DataFileSize *int32 `json:"dataFileSize,omitempty"`

	// SQL Server tempdb data file autoGrowth size
	DataGrowth *int32 `json:"dataGrowth,omitempty"`

	// SQL Server default file path
	DefaultFilePath *string `json:"defaultFilePath,omitempty"`

	// SQL Server tempdb log file size
	LogFileSize *int32 `json:"logFileSize,omitempty"`

	// SQL Server tempdb log file autoGrowth size
	LogGrowth *int32 `json:"logGrowth,omitempty"`

	// Logical Unit Numbers for the disks.
	Luns []*int32 `json:"luns,omitempty"`

	// SQL Server tempdb persist folder choice
	PersistFolder *bool `json:"persistFolder,omitempty"`

	// SQL Server tempdb persist folder location
	PersistFolderPath *string `json:"persistFolderPath,omitempty"`
}

// SQLVirtualMachine - A SQL virtual machine.
type SQLVirtualMachine struct {
	// REQUIRED; Resource location.
	Location *string `json:"location,omitempty"`

	// Azure Active Directory identity of the server.
	Identity *ResourceIdentity `json:"identity,omitempty"`

	// Resource properties.
	Properties *Properties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Resource ID.
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; Resource name.
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; Metadata pertaining to creation and last modification of the resource.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; Resource type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// SQLVirtualMachinesClientBeginCreateOrUpdateOptions contains the optional parameters for the SQLVirtualMachinesClient.BeginCreateOrUpdate
// method.
type SQLVirtualMachinesClientBeginCreateOrUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLVirtualMachinesClientBeginDeleteOptions contains the optional parameters for the SQLVirtualMachinesClient.BeginDelete
// method.
type SQLVirtualMachinesClientBeginDeleteOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLVirtualMachinesClientBeginRedeployOptions contains the optional parameters for the SQLVirtualMachinesClient.BeginRedeploy
// method.
type SQLVirtualMachinesClientBeginRedeployOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLVirtualMachinesClientBeginStartAssessmentOptions contains the optional parameters for the SQLVirtualMachinesClient.BeginStartAssessment
// method.
type SQLVirtualMachinesClientBeginStartAssessmentOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLVirtualMachinesClientBeginUpdateOptions contains the optional parameters for the SQLVirtualMachinesClient.BeginUpdate
// method.
type SQLVirtualMachinesClientBeginUpdateOptions struct {
	// Resumes the LRO from the provided token.
	ResumeToken string
}

// SQLVirtualMachinesClientGetOptions contains the optional parameters for the SQLVirtualMachinesClient.Get method.
type SQLVirtualMachinesClientGetOptions struct {
	// The child resources to include in the response.
	Expand *string
}

// SQLVirtualMachinesClientListByResourceGroupOptions contains the optional parameters for the SQLVirtualMachinesClient.ListByResourceGroup
// method.
type SQLVirtualMachinesClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// SQLVirtualMachinesClientListBySQLVMGroupOptions contains the optional parameters for the SQLVirtualMachinesClient.ListBySQLVMGroup
// method.
type SQLVirtualMachinesClientListBySQLVMGroupOptions struct {
	// placeholder for future optional parameters
}

// SQLVirtualMachinesClientListOptions contains the optional parameters for the SQLVirtualMachinesClient.List method.
type SQLVirtualMachinesClientListOptions struct {
	// placeholder for future optional parameters
}

// SQLWorkloadTypeUpdateSettings - Set workload type to optimize storage for SQL Server.
type SQLWorkloadTypeUpdateSettings struct {
	// SQL Server workload type.
	SQLWorkloadType *SQLWorkloadType `json:"sqlWorkloadType,omitempty"`
}

// Schedule - Set assessment schedule for SQL Server.
type Schedule struct {
	// Day of the week to run assessment.
	DayOfWeek *AssessmentDayOfWeek `json:"dayOfWeek,omitempty"`

	// Enable or disable assessment schedule on SQL virtual machine.
	Enable *bool `json:"enable,omitempty"`

	// Occurrence of the DayOfWeek day within a month to schedule assessment. Takes values: 1,2,3,4 and -1. Use -1 for last DayOfWeek
	// day of the month
	MonthlyOccurrence *int32 `json:"monthlyOccurrence,omitempty"`

	// Time of the day in HH:mm format. Eg. 17:30
	StartTime *string `json:"startTime,omitempty"`

	// Number of weeks to schedule between 2 assessment runs. Takes value from 1-6
	WeeklyInterval *int32 `json:"weeklyInterval,omitempty"`
}

// ServerConfigurationsManagementSettings - Set the connectivity, storage and workload settings.
type ServerConfigurationsManagementSettings struct {
	// Additional SQL feature settings.
	AdditionalFeaturesServerConfigurations *AdditionalFeaturesServerConfigurations `json:"additionalFeaturesServerConfigurations,omitempty"`

	// SQL connectivity type settings.
	SQLConnectivityUpdateSettings *SQLConnectivityUpdateSettings `json:"sqlConnectivityUpdateSettings,omitempty"`

	// SQL Instance settings.
	SQLInstanceSettings *SQLInstanceSettings `json:"sqlInstanceSettings,omitempty"`

	// SQL storage update settings.
	SQLStorageUpdateSettings *SQLStorageUpdateSettings `json:"sqlStorageUpdateSettings,omitempty"`

	// SQL workload type settings.
	SQLWorkloadTypeUpdateSettings *SQLWorkloadTypeUpdateSettings `json:"sqlWorkloadTypeUpdateSettings,omitempty"`
}

// StorageConfigurationSettings - Storage Configurations for SQL Data, Log and TempDb.
type StorageConfigurationSettings struct {
	// Disk configuration to apply to SQL Server.
	DiskConfigurationType *DiskConfigurationType `json:"diskConfigurationType,omitempty"`

	// SQL Server Data Storage Settings.
	SQLDataSettings *SQLStorageSettings `json:"sqlDataSettings,omitempty"`

	// SQL Server Log Storage Settings.
	SQLLogSettings *SQLStorageSettings `json:"sqlLogSettings,omitempty"`

	// SQL Server SystemDb Storage on DataPool if true.
	SQLSystemDbOnDataDisk *bool `json:"sqlSystemDbOnDataDisk,omitempty"`

	// SQL Server TempDb Storage Settings.
	SQLTempDbSettings *SQLTempDbSettings `json:"sqlTempDbSettings,omitempty"`

	// Storage workload type.
	StorageWorkloadType *StorageWorkloadType `json:"storageWorkloadType,omitempty"`
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// Update - An update to a SQL virtual machine.
type Update struct {
	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// WsfcDomainCredentials - Domain credentials for setting up Windows Server Failover Cluster for SQL availability group.
type WsfcDomainCredentials struct {
	// Cluster bootstrap account password.
	ClusterBootstrapAccountPassword *string `json:"clusterBootstrapAccountPassword,omitempty"`

	// Cluster operator account password.
	ClusterOperatorAccountPassword *string `json:"clusterOperatorAccountPassword,omitempty"`

	// SQL service account password.
	SQLServiceAccountPassword *string `json:"sqlServiceAccountPassword,omitempty"`
}

// WsfcDomainProfile - Active Directory account details to operate Windows Server Failover Cluster.
type WsfcDomainProfile struct {
	// Account name used for creating cluster (at minimum needs permissions to 'Create Computer Objects' in domain).
	ClusterBootstrapAccount *string `json:"clusterBootstrapAccount,omitempty"`

	// Account name used for operating cluster i.e. will be part of administrators group on all the participating virtual machines
	// in the cluster.
	ClusterOperatorAccount *string `json:"clusterOperatorAccount,omitempty"`

	// Cluster subnet type.
	ClusterSubnetType *ClusterSubnetType `json:"clusterSubnetType,omitempty"`

	// Fully qualified name of the domain.
	DomainFqdn *string `json:"domainFqdn,omitempty"`

	// Optional path for fileshare witness.
	FileShareWitnessPath *string `json:"fileShareWitnessPath,omitempty"`

	// Organizational Unit path in which the nodes and cluster will be present.
	OuPath *string `json:"ouPath,omitempty"`

	// Account name under which SQL service will run on all participating SQL virtual machines in the cluster.
	SQLServiceAccount *string `json:"sqlServiceAccount,omitempty"`

	// Primary key of the witness storage account.
	StorageAccountPrimaryKey *string `json:"storageAccountPrimaryKey,omitempty"`

	// Fully qualified ARM resource id of the witness storage account.
	StorageAccountURL *string `json:"storageAccountUrl,omitempty"`
}
