const char *ASC_lookup (int code)
{ static const struct { int code; const char *msg; } _table [] = {
    { 0x0000, "NO ADDITIONAL SENSE INFORMATION" },
    { 0x0006, "I/O PROCESS TERMINATED" },
    { 0x0011, "AUDIO PLAY OPERATION IN PROGRESS" },
    { 0x0012, "AUDIO PLAY OPERATION PAUSED" },
    { 0x0013, "AUDIO PLAY OPERATION SUCCESSFULLY COMPLETED" },
    { 0x0014, "AUDIO PLAY OPERATION STOPPED DUE TO ERROR" },
    { 0x0015, "NO CURRENT AUDIO STATUS TO RETURN" },
    { 0x0016, "OPERATION IN PROGRESS" },
    { 0x0017, "CLEANING REQUESTED" },
    { 0x0200, "NO SEEK COMPLETE" },
    { 0x0400, "LOGICAL UNIT NOT READY, CAUSE NOT REPORTABLE" },
    { 0x0401, "LOGICAL UNIT IS IN PROCESS OF BECOMING READY" },
    { 0x0402, "LOGICAL UNIT NOT READY, INITIALIZING CMD. REQUIRED" },
    { 0x0403, "LOGICAL UNIT NOT READY, MANUAL INTERVENTION REQUIRED" },
    { 0x0404, "LOGICAL UNIT NOT READY, FORMAT IN PROGRESS" },
    { 0x0407, "LOGICAL UNIT NOT READY, OPERATION IN PROGRESS" },
    { 0x0408, "LOGICAL UNIT NOT READY, LONG WRITE IN PROGRESS" },
    { 0x0409, "LOGICAL UNIT NOT READY, SELF-TEST IN PROGRESS" },
    { 0x0500, "LOGICAL UNIT DOES NOT RESPOND TO SELECTION" },
    { 0x0600, "NO REFERENCE POSITION FOUND" },
    { 0x0700, "MULTIPLE PERIPHERAL DEVICES SELECTED" },
    { 0x0800, "LOGICAL UNIT COMMUNICATION FAILURE" },
    { 0x0801, "LOGICAL UNIT COMMUNICATION TIMEOUT" },
    { 0x0802, "LOGICAL UNIT COMMUNICATION PARITY ERROR" },
    { 0x0803, "LOGICAL UNIT COMMUNICATION CRC ERROR (ULTRA-DMA/32)" },
    { 0x0900, "TRACK FOLLOWING ERROR" },
    { 0x0901, "TRACKING SERVO FAILURE" },
    { 0x0902, "FOCUS SERVO FAILURE" },
    { 0x0903, "SPINDLE SERVO FAILURE" },
    { 0x0904, "HEAD SELECT FAULT" },
    { 0x0A00, "ERROR LOG OVERFLOW" },
    { 0x0B00, "WARNING" },
    { 0x0B01, "WARNING - SPECIFIED TEMPERATURE EXCEEDED" },
    { 0x0B02, "WARNING - ENCLOSURE DEGRADED" },
    { 0x0B03, "WARNING - BACKGROUND SELF-TEST FAILED" },
    { 0x0B04, "WARNING - BACKGROUND PRE-SCAN DETECTED MEDIUM ERROR" },
    { 0x0B05, "WARNING - BACKGROUND MEDIUM SCAN DETECTED MEDIUM ERROR" },
    { 0x0C00, "WRITE ERROR" },
    { 0x0C01, "WRITE ERROR - RECOVERED WITH AUTO-REALLOCATION" },
    { 0x0C02, "WRITE ERROR - AUTO-REALLOCATION FAILED" },
    { 0x0C03, "WRITE ERROR - RECOMMEND REASSIGNMENT" },
    { 0x0C07, "WRITE ERROR - RECOVERY NEEDED" },
    { 0x0C08, "WRITE ERROR - RECOVERY FAILED" },
    { 0x0C09, "WRITE ERROR - LOSS OF STREAMING" },
    { 0x0C0A, "WRITE ERROR - PADDING BLOCKS ADDED" },
    { 0x0C0F, "DEFECTS IN ERROR WINDOW" },
    { 0x1100, "UNRECOVERED READ ERROR" },
    { 0x1101, "READ RETRIES EXHAUSTED" },
    { 0x1102, "ERROR TOO LONG TO CORRECT" },
    { 0x1105, "L-EC UNCORRECTABLE ERROR" },
    { 0x1106, "CIRC UNRECOVERED ERROR" },
    { 0x110F, "ERROR READING UPC/EAN NUMBER" },
    { 0x1110, "ERROR READING ISRC NUMBER" },
    { 0x1111, "READ ERROR - LOSS OF STREAMING" },
    { 0x1500, "RANDOM POSITIONING ERROR" },
    { 0x1501, "MECHANICAL POSITIONING ERROR" },
    { 0x1502, "POSITIONING ERROR DETECTED BY READ OF MEDIUM" },
    { 0x1700, "RECOVERED DATA WITH NO ERROR CORRECTION APPLIED" },
    { 0x1701, "RECOVERED DATA WITH RETRIES" },
    { 0x1702, "RECOVERED DATA WITH POSITIVE HEAD OFFSET" },
    { 0x1703, "RECOVERED DATA WITH NEGATIVE HEAD OFFSET" },
    { 0x1704, "RECOVERED DATA WITH RETRIES AND/OR CIRC APPLIED" },
    { 0x1705, "RECOVERED DATA USING PREVIOUS SECTOR ID" },
    { 0x1707, "RECOVERED DATA WITHOUT ECC - RECOMMEND REASSIGNMENT" },
    { 0x1708, "RECOVERED DATA WITHOUT ECC - RECOMMEND REWRITE" },
    { 0x1709, "RECOVERED DATA WITHOUT ECC - DATA REWRITTEN" },
    { 0x1800, "RECOVERED DATA WITH ERROR CORRECTION APPLIED" },
    { 0x1801, "RECOVERED DATA WITH ERROR CORR. & RETRIES APPLIED" },
    { 0x1802, "RECOVERED DATA - DATA AUTO-REALLOCATED" },
    { 0x1803, "RECOVERED DATA WITH CIRC" },
    { 0x1804, "RECOVERED DATA WITH L-EC" },
    { 0x1805, "RECOVERED DATA - RECOMMEND REASSIGNMENT" },
    { 0x1806, "RECOVERED DATA - RECOMMEND REWRITE" },
    { 0x1808, "RECOVERED DATA WITH LINKING" },
    { 0x1A00, "PARAMETER LIST LENGTH ERROR" },
    { 0x1B00, "SYNCHRONOUS DATA TRANSFER ERROR" },
    { 0x1D00, "MISCOMPARE DURING VERIFY OPERATION" },
    { 0x2000, "INVALID COMMAND OPERATION CODE" },
    { 0x2100, "LOGICAL BLOCK ADDRESS OUT OF RANGE" },
    { 0x2101, "INVALID ELEMENT ADDRESS" },
    { 0x2102, "INVALID ADDRESS FOR WRITE" },
    { 0x2103, "INVALID WRITE CROSSING LAYER JUMP" },
    { 0x2200, "ILLEGAL FUNCTION" },
    { 0x2400, "INVALID FIELD IN CDB" },
    { 0x2500, "LOGICAL UNIT NOT SUPPORTED" },
    { 0x2600, "INVALID FIELD IN PARAMETER LIST" },
    { 0x2601, "PARAMETER NOT SUPPORTED" },
    { 0x2602, "PARAMETER VALUE INVALID" },
    { 0x2603, "THRESHOLD PARAMETERS NOT SUPPORTED" },
    { 0x2604, "INVALID RELEASE OF PERSISTENT RESERVATION" },
    { 0x2700, "WRITE PROTECTED" },
    { 0x2701, "HARDWARE WRITE PROTECTED" },
    { 0x2702, "LOGICAL UNIT SOFTWARE WRITE PROTECTED" },
    { 0x2703, "ASSOCIATED WRITE PROTECT" },
    { 0x2704, "PERSISTENT WRITE PROTECT" },
    { 0x2705, "PERMANENT WRITE PROTECT" },
    { 0x2706, "CONDITIONAL WRITE PROTECT" },
    { 0x2800, "NOT READY TO READY CHANGE, MEDIUM MAY HAVE CHANGED" },
    { 0x2801, "IMPORT OR EXPORT ELEMENT ACCESSED" },
    { 0x2802, "FORMAT-LAYER MAY HAVE CHANGED" },
    { 0x2900, "POWER ON, RESET, OR BUS DEVICE RESET OCCURRED" },
    { 0x2901, "POWER ON OCCURRED" },
    { 0x2902, "BUS RESET OCCURRED" },
    { 0x2903, "BUS DEVICE RESET FUNCTION OCCURRED" },
    { 0x2904, "DEVICE INTERNAL RESET" },
    { 0x2A00, "PARAMETERS CHANGED" },
    { 0x2A01, "MODE PARAMETERS CHANGED" },
    { 0x2A02, "LOG PARAMETERS CHANGED" },
    { 0x2A03, "RESERVATIONS PREEMPTED" },
    { 0x2B00, "COPY CANNOT EXECUTE SINCE INITIATOR CANNOT DISCONNECT" },
    { 0x2C00, "COMMAND SEQUENCE ERROR" },
    { 0x2C03, "CURRENT PROGRAM AREA IS NOT EMPTY" },
    { 0x2C04, "CURRENT PROGRAM AREA IS EMPTY" },
    { 0x2E00, "INSUFFICIENT TIME FOR OPERATION" },
    { 0x2F00, "COMMANDS CLEARED BY ANOTHER INITIATOR" },
    { 0x3000, "INCOMPATIBLE MEDIUM INSTALLED" },
    { 0x3001, "CANNOT READ MEDIUM - UNKNOWN FORMAT" },
    { 0x3002, "CANNOT READ MEDIUM - INCOMPATIBLE FORMAT" },
    { 0x3003, "CLEANING CARTRIDGE INSTALLED" },
    { 0x3004, "CANNOT WRITE MEDIUM - UNKNOWN FORMAT" },
    { 0x3005, "CANNOT WRITE MEDIUM - INCOMPATIBLE FORMAT" },
    { 0x3006, "CANNOT FORMAT MEDIUM - INCOMPATIBLE MEDIUM" },
    { 0x3007, "CLEANING FAILURE" },
    { 0x3008, "CANNOT WRITE - APPLICATION CODE MISMATCH" },
    { 0x3009, "CURRENT SESSION NOT FIXATED FOR APPEND" },
    { 0x3010, "MEDIUM NOT FORMATTED" },
    { 0x3011, "CANNOT WRITE MEDIUM - UNSUPPORTED MEDIUM VERSION" },
    { 0x3100, "MEDIUM FORMAT CORRUPTED" },
    { 0x3101, "FORMAT COMMAND FAILED" },
    { 0x3102, "ZONED FORMATTING FAILED DUE TO SPARE LINKING" },
    { 0x3200, "NO DEFECT SPARE LOCATION AVAILABLE" },
    { 0x3400, "ENCLOSURE FAILURE" },
    { 0x3500, "ENCLOSURE SERVICES FAILURE" },
    { 0x3501, "UNSUPPORTED ENCLOSURE FUNCTION" },
    { 0x3502, "ENCLOSURE SERVICES UNAVAILABLE" },
    { 0x3503, "ENCLOSURE SERVICES TRANSFER FAILURE" },
    { 0x3504, "RNCLOSURE SERVICES TRANSFER REFUSED" },
    { 0x3505, "ENCLOSURE SERVICES CHECKSUM ERROR" },
    { 0x3700, "ROUNDED PARAMETER" },
    { 0x3900, "SAVING PARAMETERS NOT SUPPORTED" },
    { 0x3A00, "MEDIUM NOT PRESENT" },
    { 0x3A01, "MEDIUM NOT PRESENT - TRAY CLOSED" },
    { 0x3A02, "MEDIUM NOT PRESENT - TRAY OPEN" },
    { 0x3A03, "MEDIUM NOT PRESENT - LOADABLE" },
    { 0x3B0D, "MEDIUM DESTINATION ELEMENT FULL" },
    { 0x3B0E, "MEDIUM SOURCE ELEMENT EMPTY" },
    { 0x3B0F, "END OF MEDIUM REACHED" },
    { 0x3B11, "MEDIUM MAGAZINE NOT ACCESSIBLE" },
    { 0x3B12, "MEDIUM MAGAZINE REMOVED" },
    { 0x3B13, "MEDIUM MAGAZINE INSERTED" },
    { 0x3B14, "MEDIUM MAGAZINE LOCKED" },
    { 0x3B15, "MEDIUM MAGAZINE UNLOCKED" },
    { 0x3B16, "MECHANICAL POSITIONING OR CHANGER ERROR" },
    { 0x3D00, "INVALID BITS IN IDENTIFY MESSAGE" },
    { 0x3E00, "LOGICAL UNIT HAS NOT SELF-CONFIGURED YET" },
    { 0x3E01, "LOGICAL UNIT FAILURE" },
    { 0x3E02, "TIMEOUT ON LOGICAL UNIT" },
    { 0x3F00, "TARGET OPERATING CONDITIONS HAVE CHANGED" },
    { 0x3F01, "MICROCODE HAS BEEN CHANGED" },
    { 0x3F02, "CHANGED OPERATING DEFINITION" },
    { 0x3F03, "INQUIRY DATA HAS CHANGED" },
    { 0x4300, "MESSAGE ERROR" },
    { 0x4400, "INTERNAL TARGET FAILURE" },
    { 0x4500, "SELECT OR RESELECT FAILURE" },
    { 0x4600, "UNSUCCESSFUL SOFT RESET" },
    { 0x4700, "SCSI PARITY ERROR" },
    { 0x4800, "INITIATOR DETECTED ERROR MESSAGE RECEIVED" },
    { 0x4900, "INVALID MESSAGE ERROR" },
    { 0x4A00, "COMMAND PHASE ERROR" },
    { 0x4B00, "DATA PHASE ERROR" },
    { 0x4C00, "LOGICAL UNIT FAILED SELF-CONFIGURATION" },
    { 0x4E00, "OVERLAPPED COMMANDS ATTEMPTED" },
    { 0x5100, "ERASE FAILURE" },
    { 0x5101, "ERASE FAILURE - INCOMPLETE ERASE OPERATION DETECTED" },
    { 0x5300, "MEDIA LOAD OR EJECT FAILED" },
    { 0x5302, "MEDIUM REMOVAL PREVENTED" },
    { 0x5500, "SYSTEM RESOURCE FAILURE" },
    { 0x5700, "UNABLE TO RECOVER TABLE-OF-CONTENTS" },
    { 0x5A00, "OPERATOR REQUEST OR STATE CHANGE INPUT" },
    { 0x5A01, "OPERATOR MEDIUM REMOVAL REQUEST" },
    { 0x5A02, "OPERATOR SELECTED WRITE PROTECT" },
    { 0x5A03, "OPERATOR SELECTED WRITE PERMIT" },
    { 0x5B00, "LOG EXCEPTION" },
    { 0x5B01, "THRESHOLD CONDITION MET" },
    { 0x5B02, "LOG COUNTER AT MAXIMUM" },
    { 0x5B03, "LOG LIST CODES EXHAUSTED" },
    { 0x5D00, "FAILURE PREDICTION THRESHOLD EXCEEDED" },
    { 0x5D01, "MEDIA FAILURE PREDICTION THRESHOLD EXCEEDED" },
    { 0x5D02, "LOGICAL UNIT FAILURE PREDICTION THRESHOLD EXCEEDED" },
    { 0x5D03, "SPARE AREA EXHAUSTION FAILURE PREDICTION THRESHOLD EXCEEDED" },
    { 0x5DFF, "FAILURE PREDICTION THRESHOLD EXCEEDED (FALSE)" },
    { 0x5E00, "LOW POWER CONDITION ON" },
    { 0x5E01, "IDLE CONDITION ACTIVATED BY TIMER" },
    { 0x5E02, "STANDBY CONDITION ACTIVATED BY TIMER" },
    { 0x5E03, "IDLE CONDITION ACTIVATED BY COMMAND" },
    { 0x5E04, "STANDBY CONDITION ACTIVATED BY COMMAND" },
    { 0x6300, "END OF USER AREA ENCOUNTERED ON THIS TRACK" },
    { 0x6301, "PACKET DOES NOT FIT IN AVAILABLE SPACE" },
    { 0x6400, "ILLEGAL MODE FOR THIS TRACK" },
    { 0x6401, "INVALID PACKET SIZE" },
    { 0x6500, "VOLTAGE FAULT" },
    { 0x6F00, "COPY PROTECTION KEY EXCHANGE FAILURE - AUTHENTICATION FAILURE" },
    { 0x6F01, "COPY PROTECTION KEY EXCHANGE FAILURE - KEY NOT PRESENT" },
    { 0x6F02, "COPY PROTECTION KEY EXCHANGE FAILURE - KEY NOT ESTABLISHED" },
    { 0x6F03, "READ OF SCRAMBLED SECTOR WITHOUT AUTHENTICATION" },
    { 0x6F04, "MEDIA REGION CODE IS MISMATCHED TO LOGICAL UNIT REGION" },
    { 0x6F05, "LOGICAL UNIT REGION MUST BE PERMANENT/REGION RESET COUNT ERROR" },
    { 0x6F06, "INSUFFICIENT BLOCK COUNT FOR BINDING NONCE RECORDING" },
    { 0x6F07, "CONFLICT IN BINDING NONCE RECORDING" },
    { 0x7200, "SESSION FIXATION ERROR" },
    { 0x7201, "SESSION FIXATION ERROR WRITING LEAD-IN" },
    { 0x7202, "SESSION FIXATION ERROR WRITING LEAD-OUT" },
    { 0x7203, "SESSION FIXATION ERROR - INCOMPLETE TRACK IN SESSION" },
    { 0x7204, "EMPTY OR PARTIALLY WRITTEN RESERVED TRACK" },
    { 0x7205, "NO MORE TRACK RESERVATIONS ALLOWED" },
    { 0x7206, "RMZ EXTENSION IS NOT ALLOWED" },
    { 0x7207, "NO MORE TEST ZONE EXTENSIONS ARE ALLOWED" },
    { 0x7300, "CD CONTROL ERROR" },
    { 0x7301, "POWER CALIBRATION AREA ALMOST FULL" },
    { 0x7302, "POWER CALIBRATION AREA IS FULL" },
    { 0x7303, "POWER CALIBRATION AREA ERROR" },
    { 0x7304, "PROGRAM MEMORY AREA UPDATE FAILURE" },
    { 0x7305, "PROGRAM MEMORY AREA IS FULL" },
    { 0x7306, "RMA/PMA IS ALMOST FULL" },
    { 0x7310, "CURRENT POWER CALIBRATION AREA IS ALMOST FULL" },
    { 0x7311, "CURRENT POWER CALIBRATION AREA IS FULL" },
    { 0x7317, "RDZ IS FULL" },
    { 0xFFFF, NULL }
  };
  int sz = sizeof(_table)/sizeof(_table[0])/2,i=sz;

    code &= 0xFFFF;

    while (sz)
    {	if (_table[i].code == code)	return _table[i].msg;

	if (_table[i].code > code)
	{   if (sz/=2)	i -= sz;
	    else	while (_table[--i].code > code);
	}
	else
	{   if (sz/=2)	i += sz;
	    else	while (_table[++i].code < code);
	}
    }

  return _table[i].code==code ? _table[i].msg : NULL;
}
