/*   -*- buffer-read-only: t -*- vi: set ro:
 *
 *  DO NOT EDIT THIS FILE   (opts.c)
 *
 *  It has been AutoGen-ed
 *  From the definitions    opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 42:2:17 templates.
 *
 *  AutoOpts is a copyrighted work.  This source file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the complexity author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The complexity program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2011-2020 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the GNU General Public License,
 *  version 3 or later <http://gnu.org/licenses/gpl.html>
 *
 *  complexity is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  complexity is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef __doxygen__
#define OPTION_CODE_COMPILE 1
#include "opts.h"
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef  __cplusplus
extern "C" {
#endif
extern FILE * option_usage_fp;
#define zCopyright      (complexity_opt_strs+0)
#define zLicenseDescrip (complexity_opt_strs+275)

/*
 *  global included definitions
 */
score_t penalty  = DEFAULT_PENALTY;
FILE *  trace_fp = NULL;
int     score_ct = 0;
char const assert_fail_fmt[] =
	"COMPLEX ASSERTION FAILURE in %s line %u:  %s\n";

#ifndef NULL
#  define NULL 0
#endif

/**
 *  static const strings for complexity options
 */
static char const complexity_opt_strs[2611] =
/*     0 */ "complexity (GNU Complexity) 1.13\n"
            "Copyright (C) 2011-2020 Bruce Korb, all rights reserved.\n"
            "This is free software. It is licensed for use, modification and\n"
            "redistribution under the terms of the GNU General Public License,\n"
            "version 3 or later <http://gnu.org/licenses/gpl.html>\n\0"
/*   275 */ "complexity is free software: you can redistribute it and/or modify it under\n"
            "the terms of the GNU General Public License as published by the Free\n"
            "Software Foundation, either version 3 of the License, or (at your option)\n"
            "any later version.\n\n"
            "complexity is distributed in the hope that it will be useful, but WITHOUT\n"
            "ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or\n"
            "FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for\n"
            "more details.\n\n"
            "You should have received a copy of the GNU General Public License along\n"
            "with this program.  If not, see <http://www.gnu.org/licenses/>.\n\0"
/*   884 */ "Reporting threshold\0"
/*   904 */ "THRESHOLD\0"
/*   914 */ "threshold\0"
/*   924 */ "zero exit threshold\0"
/*   944 */ "HORRID_THRESHOLD\0"
/*   961 */ "horrid-threshold\0"
/*   978 */ "score multiplier for nested code\0"
/*  1011 */ "NESTING_PENALTY\0"
/*  1027 */ "nesting-penalty\0"
/*  1043 */ "score multiplier for nested expressions\0"
/*  1083 */ "DEMI_NESTING_PENALTY\0"
/*  1104 */ "demi-nesting-penalty\0"
/*  1125 */ "complexity scaling factor\0"
/*  1151 */ "SCALE\0"
/*  1157 */ "scale\0"
/*  1163 */ "Display histogram of complexity numbers\0"
/*  1203 */ "HISTOGRAM\0"
/*  1213 */ "no-histogram\0"
/*  1226 */ "no\0"
/*  1229 */ "Display the score for each procedure\0"
/*  1266 */ "SCORES\0"
/*  1273 */ "no-scores\0"
/*  1283 */ "procedure name to be ignored\0"
/*  1312 */ "IGNORE\0"
/*  1319 */ "ignore\0"
/*  1326 */ "do not print scoring header\0"
/*  1354 */ "NO_HEADER\0"
/*  1364 */ "no-header\0"
/*  1374 */ "Run the source(s) through unifdef(1BSD)\0"
/*  1414 */ "UNIFDEF\0"
/*  1422 */ "unifdef\0"
/*  1430 */ "Specify the unifdef program\0"
/*  1458 */ "UNIF_EXE\0"
/*  1467 */ "unif-exe\0"
/*  1476 */ "file of file list\0"
/*  1494 */ "INPUT\0"
/*  1500 */ "input\0"
/*  1506 */ "trace output file\0"
/*  1524 */ "TRACE\0"
/*  1530 */ "trace\0"
/*  1536 */ "display extended usage information and exit\0"
/*  1580 */ "help\0"
/*  1585 */ "extended usage information passed thru pager\0"
/*  1630 */ "more-help\0"
/*  1640 */ "output version information and exit\0"
/*  1676 */ "version\0"
/*  1684 */ "save the option state to a config file\0"
/*  1723 */ "save-opts\0"
/*  1733 */ "load options from a config file\0"
/*  1765 */ "LOAD_OPTS\0"
/*  1775 */ "no-load-opts\0"
/*  1788 */ "COMPLEXITY\0"
/*  1799 */ "complexity (GNU Complexity) - Measure complexity of C source\n"
            "Usage:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]... \\\n"
            "\t\t[ <file-name> ... ]\n\0"
/*  1942 */ "$@/complex.conf\0"
/*  1958 */ "$HOME\0"
/*  1964 */ "$PROJECT_ROOT/complex.conf\0"
/*  1991 */ ".\0"
/*  1993 */ ".complexityrc\0"
/*  2007 */ "bkorb@gnu.org\0"
/*  2021 */ "Compute the complexity of source code not just with a path-through-the-code\n"
            "count, but also amplifying line counts by logic level nesting.\n\n"
            "If no arguments are provided, input arguments are read from stdin,\n"
            "one per line; blank and '#'-prefixed lines are comments.\n"
            "'stdin' may not be a terminal (tty).\n\0"
/*  2323 */ "'complexity' ignores all cpp preprocessor directives - calculating the\n"
            "complexity of the appearance of the code, rather than the complexity after\n"
            "the preprocessor manipulates the code.  'getchar(3)', for example, will\n"
            "expand into quite complicated code.\n\0"
/*  2578 */ "complexity (GNU Complexity) 1.13";

/**
 *  threshold option description:
 */
/** Descriptive text for the threshold option */
#define THRESHOLD_DESC      (complexity_opt_strs+884)
/** Upper-cased name for the threshold option */
#define THRESHOLD_NAME      (complexity_opt_strs+904)
/** Name string for the threshold option */
#define THRESHOLD_name      (complexity_opt_strs+914)
/** The compiled in default value for the threshold option argument */
#define THRESHOLD_DFT_ARG   ((char const*)30)
/** Compiled in flag settings for the threshold option */
#define THRESHOLD_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/**
 *  horrid-threshold option description:
 */
/** Descriptive text for the horrid-threshold option */
#define HORRID_THRESHOLD_DESC      (complexity_opt_strs+924)
/** Upper-cased name for the horrid-threshold option */
#define HORRID_THRESHOLD_NAME      (complexity_opt_strs+944)
/** Name string for the horrid-threshold option */
#define HORRID_THRESHOLD_name      (complexity_opt_strs+961)
/** The compiled in default value for the horrid-threshold option argument */
#define HORRID_THRESHOLD_DFT_ARG   ((char const*)100)
/** Compiled in flag settings for the horrid-threshold option */
#define HORRID_THRESHOLD_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/**
 *  nesting-penalty option description:
 */
/** Descriptive text for the nesting-penalty option */
#define NESTING_PENALTY_DESC      (complexity_opt_strs+978)
/** Upper-cased name for the nesting-penalty option */
#define NESTING_PENALTY_NAME      (complexity_opt_strs+1011)
/** Name string for the nesting-penalty option */
#define NESTING_PENALTY_name      (complexity_opt_strs+1027)
/** Compiled in flag settings for the nesting-penalty option */
#define NESTING_PENALTY_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  demi-nesting-penalty option description:
 */
/** Descriptive text for the demi-nesting-penalty option */
#define DEMI_NESTING_PENALTY_DESC      (complexity_opt_strs+1043)
/** Upper-cased name for the demi-nesting-penalty option */
#define DEMI_NESTING_PENALTY_NAME      (complexity_opt_strs+1083)
/** Name string for the demi-nesting-penalty option */
#define DEMI_NESTING_PENALTY_name      (complexity_opt_strs+1104)
/** Compiled in flag settings for the demi-nesting-penalty option */
#define DEMI_NESTING_PENALTY_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  scale option description:
 */
/** Descriptive text for the scale option */
#define SCALE_DESC      (complexity_opt_strs+1125)
/** Upper-cased name for the scale option */
#define SCALE_NAME      (complexity_opt_strs+1151)
/** Name string for the scale option */
#define SCALE_name      (complexity_opt_strs+1157)
/** Compiled in flag settings for the scale option */
#define SCALE_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/**
 *  histogram option description:
 */
/** Descriptive text for the histogram option */
#define HISTOGRAM_DESC      (complexity_opt_strs+1163)
/** Upper-cased name for the histogram option */
#define HISTOGRAM_NAME      (complexity_opt_strs+1203)
/** disablement name for the histogram option */
#define NOT_HISTOGRAM_name  (complexity_opt_strs+1213)
/** disablement prefix for the histogram option */
#define NOT_HISTOGRAM_PFX   (complexity_opt_strs+1226)
/** Name string for the histogram option */
#define HISTOGRAM_name      (NOT_HISTOGRAM_name + 3)
/** Compiled in flag settings for the histogram option */
#define HISTOGRAM_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT)

/**
 *  scores option description:
 */
/** Descriptive text for the scores option */
#define SCORES_DESC      (complexity_opt_strs+1229)
/** Upper-cased name for the scores option */
#define SCORES_NAME      (complexity_opt_strs+1266)
/** disablement name for the scores option */
#define NOT_SCORES_name  (complexity_opt_strs+1273)
/** disablement prefix for the scores option */
#define NOT_SCORES_PFX   (complexity_opt_strs+1226)
/** Name string for the scores option */
#define SCORES_name      (NOT_SCORES_name + 3)
/** Compiled in flag settings for the scores option */
#define SCORES_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT)

/**
 *  ignore option description:
 */
/** Descriptive text for the ignore option */
#define IGNORE_DESC      (complexity_opt_strs+1283)
/** Upper-cased name for the ignore option */
#define IGNORE_NAME      (complexity_opt_strs+1312)
/** Name string for the ignore option */
#define IGNORE_name      (complexity_opt_strs+1319)
/** Compiled in flag settings for the ignore option */
#define IGNORE_FLAGS     (OPTST_DISABLED | OPTST_STACKED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  no-header option description:
 */
/** Descriptive text for the no-header option */
#define NO_HEADER_DESC      (complexity_opt_strs+1326)
/** Upper-cased name for the no-header option */
#define NO_HEADER_NAME      (complexity_opt_strs+1354)
/** Name string for the no-header option */
#define NO_HEADER_name      (complexity_opt_strs+1364)
/** Compiled in flag settings for the no-header option */
#define NO_HEADER_FLAGS     (OPTST_DISABLED | OPTST_NO_INIT)

/**
 *  unifdef option description:
 */
/** Descriptive text for the unifdef option */
#define UNIFDEF_DESC      (complexity_opt_strs+1374)
/** Upper-cased name for the unifdef option */
#define UNIFDEF_NAME      (complexity_opt_strs+1414)
/** Name string for the unifdef option */
#define UNIFDEF_name      (complexity_opt_strs+1422)
/** Compiled in flag settings for the unifdef option */
#define UNIFDEF_FLAGS     (OPTST_DISABLED | OPTST_STACKED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  unif-exe option description:
 */
/** Descriptive text for the unif-exe option */
#define UNIF_EXE_DESC      (complexity_opt_strs+1430)
/** Upper-cased name for the unif-exe option */
#define UNIF_EXE_NAME      (complexity_opt_strs+1458)
/** Name string for the unif-exe option */
#define UNIF_EXE_name      (complexity_opt_strs+1467)
/** Compiled in flag settings for the unif-exe option */
#define UNIF_EXE_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  input option description:
 */
/** Descriptive text for the input option */
#define INPUT_DESC      (complexity_opt_strs+1476)
/** Upper-cased name for the input option */
#define INPUT_NAME      (complexity_opt_strs+1494)
/** Name string for the input option */
#define INPUT_name      (complexity_opt_strs+1500)
/** Compiled in flag settings for the input option */
#define INPUT_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/**
 *  trace option description:
 */
/** Descriptive text for the trace option */
#define TRACE_DESC      (complexity_opt_strs+1506)
/** Upper-cased name for the trace option */
#define TRACE_NAME      (complexity_opt_strs+1524)
/** Name string for the trace option */
#define TRACE_name      (complexity_opt_strs+1530)
/** Compiled in flag settings for the trace option */
#define TRACE_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Help/More_Help/Version option descriptions:
 */
#define HELP_DESC       (complexity_opt_strs+1536)
#define HELP_name       (complexity_opt_strs+1580)
#ifdef HAVE_WORKING_FORK
#define MORE_HELP_DESC  (complexity_opt_strs+1585)
#define MORE_HELP_name  (complexity_opt_strs+1630)
#define MORE_HELP_FLAGS (OPTST_IMM | OPTST_NO_INIT)
#else
#define MORE_HELP_DESC  HELP_DESC
#define MORE_HELP_name  HELP_name
#define MORE_HELP_FLAGS (OPTST_OMITTED | OPTST_NO_INIT)
#endif
#ifdef NO_OPTIONAL_OPT_ARGS
#  define VER_FLAGS     (OPTST_IMM | OPTST_NO_INIT)
#else
#  define VER_FLAGS     (OPTST_SET_ARGTYPE(OPARG_TYPE_STRING) | \
                         OPTST_ARG_OPTIONAL | OPTST_IMM | OPTST_NO_INIT)
#endif
#define VER_DESC        (complexity_opt_strs+1640)
#define VER_name        (complexity_opt_strs+1676)
#define SAVE_OPTS_DESC  (complexity_opt_strs+1684)
#define SAVE_OPTS_name  (complexity_opt_strs+1723)
#define LOAD_OPTS_DESC     (complexity_opt_strs+1733)
#define LOAD_OPTS_NAME     (complexity_opt_strs+1765)
#define NO_LOAD_OPTS_name  (complexity_opt_strs+1775)
#define LOAD_OPTS_pfx      (complexity_opt_strs+1226)
#define LOAD_OPTS_name     (NO_LOAD_OPTS_name + 3)
/**
 *  Declare option callback procedures
 */
extern tOptProc
    optionBooleanVal,   optionNestedVal,    optionNumericVal,
    optionPagedUsage,   optionPrintVersion, optionResetOpt,
    optionStackArg,     optionTimeDate,     optionTimeVal,
    optionUnstackArg,   optionVendorOption;
static tOptProc
    doOptInput, doOptTrace, doUsageOpt;
#define VER_PROC        optionPrintVersion

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 *  Define the complexity Option Descriptions.
 * This is an array of OPTION_CT entries, one for each
 * option that the complexity program responds to.
 */
static tOptDesc optDesc[OPTION_CT] = {
  {  /* entry idx, value */ 0, VALUE_OPT_THRESHOLD,
     /* equiv idx, value */ 0, VALUE_OPT_THRESHOLD,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ THRESHOLD_FLAGS, 0,
     /* last opt argumnt */ { THRESHOLD_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionNumericVal,
     /* desc, NAME, name */ THRESHOLD_DESC, THRESHOLD_NAME, THRESHOLD_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_HORRID_THRESHOLD,
     /* equiv idx, value */ 1, VALUE_OPT_HORRID_THRESHOLD,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ HORRID_THRESHOLD_FLAGS, 0,
     /* last opt argumnt */ { HORRID_THRESHOLD_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionNumericVal,
     /* desc, NAME, name */ HORRID_THRESHOLD_DESC, HORRID_THRESHOLD_NAME, HORRID_THRESHOLD_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 2, VALUE_OPT_NESTING_PENALTY,
     /* equiv idx, value */ 2, VALUE_OPT_NESTING_PENALTY,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ NESTING_PENALTY_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --nesting-penalty */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ NESTING_PENALTY_DESC, NESTING_PENALTY_NAME, NESTING_PENALTY_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 3, VALUE_OPT_DEMI_NESTING_PENALTY,
     /* equiv idx, value */ 3, VALUE_OPT_DEMI_NESTING_PENALTY,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DEMI_NESTING_PENALTY_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --demi-nesting-penalty */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ DEMI_NESTING_PENALTY_DESC, DEMI_NESTING_PENALTY_NAME, DEMI_NESTING_PENALTY_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 4, VALUE_OPT_SCALE,
     /* equiv idx, value */ 4, VALUE_OPT_SCALE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SCALE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --scale */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionNumericVal,
     /* desc, NAME, name */ SCALE_DESC, SCALE_NAME, SCALE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 5, VALUE_OPT_HISTOGRAM,
     /* equiv idx, value */ 5, VALUE_OPT_HISTOGRAM,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ HISTOGRAM_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --histogram */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ HISTOGRAM_DESC, HISTOGRAM_NAME, HISTOGRAM_name,
     /* disablement strs */ NOT_HISTOGRAM_name, NOT_HISTOGRAM_PFX },

  {  /* entry idx, value */ 6, VALUE_OPT_SCORES,
     /* equiv idx, value */ 6, VALUE_OPT_SCORES,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ SCORES_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --scores */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ SCORES_DESC, SCORES_NAME, SCORES_name,
     /* disablement strs */ NOT_SCORES_name, NOT_SCORES_PFX },

  {  /* entry idx, value */ 7, VALUE_OPT_IGNORE,
     /* equiv idx, value */ 7, VALUE_OPT_IGNORE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ IGNORE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --ignore */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionStackArg,
     /* desc, NAME, name */ IGNORE_DESC, IGNORE_NAME, IGNORE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 8, VALUE_OPT_NO_HEADER,
     /* equiv idx, value */ 8, VALUE_OPT_NO_HEADER,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ NO_HEADER_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --no-header */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ NO_HEADER_DESC, NO_HEADER_NAME, NO_HEADER_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 9, VALUE_OPT_UNIFDEF,
     /* equiv idx, value */ 9, VALUE_OPT_UNIFDEF,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ UNIFDEF_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --unifdef */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionStackArg,
     /* desc, NAME, name */ UNIFDEF_DESC, UNIFDEF_NAME, UNIFDEF_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 10, VALUE_OPT_UNIF_EXE,
     /* equiv idx, value */ 10, VALUE_OPT_UNIF_EXE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ UNIF_EXE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --unif-exe */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ UNIF_EXE_DESC, UNIF_EXE_NAME, UNIF_EXE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 11, VALUE_OPT_INPUT,
     /* equiv idx, value */ 11, VALUE_OPT_INPUT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ INPUT_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --input */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptInput,
     /* desc, NAME, name */ INPUT_DESC, INPUT_NAME, INPUT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 12, VALUE_OPT_TRACE,
     /* equiv idx, value */ 12, VALUE_OPT_TRACE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ TRACE_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --trace */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doOptTrace,
     /* desc, NAME, name */ TRACE_DESC, TRACE_NAME, TRACE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_VERSION, VALUE_OPT_VERSION,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_VERSION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VER_FLAGS, AOUSE_VERSION,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ VER_PROC,
     /* desc, NAME, name */ VER_DESC, NULL, VER_name,
     /* disablement strs */ NULL, NULL },



  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM | OPTST_NO_INIT, AOUSE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ HELP_DESC, NULL, HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_MORE_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MORE_HELP_FLAGS, AOUSE_MORE_HELP,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ MORE_HELP_DESC, NULL, MORE_HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_SAVE_OPTS, VALUE_OPT_SAVE_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_SAVE_OPTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
                       | OPTST_ARG_OPTIONAL | OPTST_NO_INIT, AOUSE_SAVE_OPTS,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ SAVE_OPTS_DESC, NULL, SAVE_OPTS_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_LOAD_OPTS, VALUE_OPT_LOAD_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_LOAD_OPTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
			  | OPTST_DISABLE_IMM, AOUSE_LOAD_OPTS,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionLoadOpt,
     /* desc, NAME, name */ LOAD_OPTS_DESC, LOAD_OPTS_NAME, LOAD_OPTS_name,
     /* disablement strs */ NO_LOAD_OPTS_name, LOAD_OPTS_pfx }
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/** Reference to the upper cased version of complexity. */
#define zPROGNAME       (complexity_opt_strs+1788)
/** Reference to the title line for complexity usage. */
#define zUsageTitle     (complexity_opt_strs+1799)
/** complexity configuration file name. */
#define zRcName         (complexity_opt_strs+1993)
/** Directories to search for complexity config files. */
static char const * const apzHomeList[5] = {
    complexity_opt_strs+1942,
    complexity_opt_strs+1958,
    complexity_opt_strs+1964,
    complexity_opt_strs+1991,
    NULL };
/** The complexity program bug email address. */
#define zBugsAddr       (complexity_opt_strs+2007)
/** Clarification/explanation of what complexity does. */
#define zExplain        (complexity_opt_strs+2021)
/** Extra detail explaining what complexity does. */
#define zDetail         (complexity_opt_strs+2323)
/** The full version string for complexity. */
#define zFullVersion    (complexity_opt_strs+2578)
/* extracted from optcode.tlib near line 342 */

#if defined(ENABLE_NLS)
# define OPTPROC_BASE OPTPROC_TRANSLATE
  static tOptionXlateProc translate_option_strings;
#else
# define OPTPROC_BASE OPTPROC_NONE
# define translate_option_strings NULL
#endif /* ENABLE_NLS */

#define complexity_full_usage (NULL)
#define complexity_short_usage (NULL)

#endif /* not defined __doxygen__ */

/*
 *  Create the static procedure(s) declared above.
 */
/**
 * The callout function that invokes the optionUsage function.
 *
 * @param[in] opts the AutoOpts option description structure
 * @param[in] od   the descriptor for the "help" (usage) option.
 * @noreturn
 */
static void
doUsageOpt(tOptions * opts, tOptDesc * od)
{
    int ex_code;
    ex_code = COMPLEXITY_EXIT_SUCCESS;
    optionUsage(&complexityOptions, ex_code);
    /* NOTREACHED */
    exit(COMPLEXITY_EXIT_FAILURE);
    (void)opts;
    (void)od;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the input option.
 * Instead of either a command line list of input files or reading
 * them from standard input, read the list of files from this file.
 * @param[in] pOptions the complexity options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptInput(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from opts.def, line 317 */
    FILE * fp = freopen(pOptDesc->optArg.argString, "r", stdin);
    if (fp != stdin) {
        fprintf(stderr, "fs error %d (%s) reopening %s as stdin\n",
                errno, strerror(errno), pOptDesc->optArg.argString);
        exit(COMPLEXITY_EXIT_BAD_FILE);
    }
    (void)pOptions;
}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/**
 * Code to handle the trace option.
 * Print intermediate scores to a trace file.
 * @param[in] pOptions the complexity options data structure
 * @param[in,out] pOptDesc the option descriptor for this option.
 */
static void
doOptTrace(tOptions* pOptions, tOptDesc* pOptDesc)
{
    /*
     * Be sure the flag-code[0] handles special values for the options pointer
     * viz. (poptions <= OPTPROC_EMIT_LIMIT) *and also* the special flag bit
     * ((poptdesc->fOptState & OPTST_RESET) != 0) telling the option to
     * reset its state.
     */
    /* extracted from opts.def, line 337 */
    trace_fp = fopen(pOptDesc->optArg.argString, "w");
    if (trace_fp == NULL) {
        fprintf(stderr, "fs error %d (%s) opening %s for tracing\n",
                errno, strerror(errno), pOptDesc->optArg.argString);
        exit(COMPLEXITY_EXIT_BAD_FILE);
    }
    (void)pOptions;
}
/* extracted from optmain.tlib near line 116 */


extern int complex_eval(char const * fname);
/* extracted from optmain.tlib near line 204 */

/**
 * validate file name and dispach callout procedure.
 * This procedure is generated by AutoOpts.
 * It will make sure that the input file name refers to a file
 * that exists.
 *
 * @param fname the name of the file to process
 * @returns program exit code flag
 */
static complexity_exit_code_t
validate_fname(char const * fname)
{
    static char const * err_str = NULL;

    if (err_str == NULL)
        err_str = _("fs error %d (%s) %s-ing %s\n");
    {
        struct stat sb;
        if (stat(fname, &sb) < 0) {
            fprintf(stderr, err_str, errno, strerror(errno), "stat",
                    fname);
            return COMPLEXITY_EXIT_BAD_FILE;
        }
    }
/* extracted from optmain.tlib near line 291 */


    return complex_eval(fname);
}
/* extracted from optmain.tlib near line 131 */

/**
 * strip (destructively) the leading and trailing white space.
 * Trailing white space is trimmed with a NUL byte.
 * The returned address is that of the first character after the
 * leading white space.  Characters are not moved.
 *
 * @param[in,out] pz_s source text pointer
 * @returns pointer to the same text buffer, but after skipping over the
 * leading white space characters.
 */
static char *
trim_input_line(char * src_str)
{
    while ((unsigned int)isspace(*src_str))
        src_str++;

    {
        char * end = src_str + strlen(src_str);
        while ((end > src_str) && isspace((unsigned int)end[-1]))
            end--;
        *end = '\0';
    }

    switch (*src_str) {
    case '\0':
    case '#':
        return NULL;
    default:
        return src_str;
    }
}

/**
 * Generated main procedure.  This will call the validate_fname procedure
 * for every operand on the command line.  If there are no operands, then stdin
 * is read for a list of file names to process.  stdin must not be a terminal.
 * It must be a pipe or a file.
 *
 * @param[in] argc argument count
 * @param[in] argv argument vector
 * @returns program exit code
 */
int
main(int argc, char ** argv)
{
    int res     = 0;
    int proc_ct = 0;
    int arg_ix  = optionProcess(&complexityOptions, argc, argv);
    
/* extracted from opts.def near line 87 */

    initialize(argc, argv);
/* extracted from optmain.tlib near line 160 */

    /*
     *  IF the input list is from the command line...
     */
    if (arg_ix < argc) {
        for (; arg_ix < argc; arg_ix++) {
            char * arg = argv[arg_ix];
            res |= validate_fname(arg);
            proc_ct++;
        }
    }
    /*
     *  Input list from tty input
     */
    else if (isatty(STDIN_FILENO)) {
        fputs(_("complexity ERROR: input list is a tty\n"), stderr);
        USAGE(COMPLEXITY_EXIT_BAD_FILE);
        /* NOTREACHED */
    }

    /*
     *  Input list from a pipe or file or some such
     */
    else {
        long pg_size = sysconf(_SC_PAGESIZE);
        char * buf   = malloc((size_t)pg_size);
        if (buf == NULL) {
            fputs(_("complexity ERROR: no memory for input list\n"), stderr);
            return COMPLEXITY_EXIT_NOMEM;
        }

        for (;;) {
            char * pz = fgets(buf, (ssize_t)pg_size, stdin);
            if (pz == NULL)
                break;

            pz = trim_input_line(pz);
            if (pz == NULL)
                continue;
            res |= validate_fname(pz);
            proc_ct++;
        }

        if (proc_ct == 0)
            fputs(_("complexity Warning:  no input lines were read\n"), stderr);
        free(buf);
    }

    
/* extracted from opts.def near line 89 */

    if (score_ct == 0) {
        printf("No procedures were scored\n");
        exit(res | COMPLEXITY_EXIT_NO_DATA);
    }
    do_summary(res);
    return res;
}
/* extracted from optmain.tlib near line 1250 */

/**
 * Print a fatal error message and die, \a va_list style.
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ap         the argument list for the message
 * @noreturn
 */
noreturn extern void
vdie(int exit_code, char const * fmt, va_list ap)
{
    char const * die_leader = _("complexity fatal error:\n");
    fputs(die_leader, stderr);
    vfprintf(stderr, fmt, ap);
    fflush(stderr);
    exit(exit_code);
}

/**
 * Print a fatal error message and die, var-arg style.
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ...        the list of arguments for the message
 * @noreturn
 */
noreturn extern void
die(int exit_code, char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vdie(exit_code, fmt, ap);
}

/**
 * Print a file system error fatal error message and die.
 *
 * @param[in] exit_code  the value to call exit(3) with.
 * @param[in] op         the operation that failed.
 * @param[in] fname      the file name the operation was on.
 * @noreturn
 */
noreturn extern void
fserr(int exit_code, char const * op, char const * fname)
{
    char const * fserr_fmt = _("fserr %d (%s) performing '%s' on %s\n");
    die(exit_code, fserr_fmt, errno, strerror(errno), op, fname);
}

/**
 * The directory containing the data associated with complexity.
 */
#ifndef  PKGDATADIR
# define PKGDATADIR ""
#endif

/**
 * Information about the person or institution that packaged complexity
 * for the current distribution.
 */
#ifndef  WITH_PACKAGER
# define complexity_packager_info NULL
#else
/** Packager information for complexity. */
static char const complexity_packager_info[] =
    "Packaged by " WITH_PACKAGER

# ifdef WITH_PACKAGER_VERSION
        " ("WITH_PACKAGER_VERSION")"
# endif

# ifdef WITH_PACKAGER_BUG_REPORTS
    "\nReport complexity bugs to " WITH_PACKAGER_BUG_REPORTS
# endif
    "\n";
#endif
#ifndef __doxygen__

#endif /* __doxygen__ */
/**
 * The option definitions for complexity.  The one structure that
 * binds them all.
 */
tOptions complexityOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT
    + OPTPROC_NEGATIONS
    + OPTPROC_ENVIRON
    + OPTPROC_GNUUSAGE ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zLicenseDescrip,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage, /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP, /* more-help option index */
      INDEX_OPT_SAVE_OPTS, /* save option index */
      NO_EQUIVALENT, /* '-#' option index */
      NO_EQUIVALENT /* index of default opt */
    },
    18 /* full option count */, 13 /* user option count */,
    complexity_full_usage, complexity_short_usage,
    NULL, NULL,
    PKGDATADIR, complexity_packager_info
};

#if ENABLE_NLS
/**
 * This code is designed to translate translatable option text for the
 * complexity program.  These translations happen upon entry
 * to optionProcess().
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#ifdef HAVE_DCGETTEXT
# include <gettext.h>
#endif
#include <autoopts/usage-txt.h>

static char * AO_gettext(char const * pz);
static void   coerce_it(void ** s);

/**
 * AutoGen specific wrapper function for gettext.  It relies on the macro _()
 * to convert from English to the target language, then strdup-duplicates the
 * result string.  It tries the "libopts" domain first, then whatever has been
 * set via the \a textdomain(3) call.
 *
 * @param[in] pz the input text used as a lookup key.
 * @returns the translated text (if there is one),
 *   or the original text (if not).
 */
static char *
AO_gettext(char const * pz)
{
    char * res;
    if (pz == NULL)
        return NULL;
#ifdef HAVE_DCGETTEXT
    /*
     * While processing the option_xlateable_txt data, try to use the
     * "libopts" domain.  Once we switch to the option descriptor data,
     * do *not* use that domain.
     */
    if (option_xlateable_txt.field_ct != 0) {
        res = dgettext("libopts", pz);
        if (res == pz)
            res = (char *)VOIDP(_(pz));
    } else
        res = (char *)VOIDP(_(pz));
#else
    res = (char *)VOIDP(_(pz));
#endif
    if (res == pz)
        return res;
    res = strdup(res);
    if (res == NULL) {
        fputs(_("No memory for duping translated strings\n"), stderr);
        exit(COMPLEXITY_EXIT_NOMEM);
    }
    return res;
}

/**
 * All the pointers we use are marked "* const", but they are stored in
 * writable memory.  Coerce the mutability and set the pointer.
 */
static void coerce_it(void ** s) { *s = AO_gettext(*s);
}

/**
 * Translate all the translatable strings in the complexityOptions
 * structure defined above.  This is done only once.
 */
static void
translate_option_strings(void)
{
    tOptions * const opts = &complexityOptions;

    /*
     *  Guard against re-translation.  It won't work.  The strings will have
     *  been changed by the first pass through this code.  One shot only.
     */
    if (option_xlateable_txt.field_ct != 0) {
        /*
         *  Do the translations.  The first pointer follows the field count
         *  field.  The field count field is the size of a pointer.
         */
        char ** ppz = (char**)VOIDP(&(option_xlateable_txt));
        int     ix  = option_xlateable_txt.field_ct;

        do {
            ppz++; /* skip over field_ct */
            *ppz = AO_gettext(*ppz);
        } while (--ix > 0);
        /* prevent re-translation and disable "libopts" domain lookup */
        option_xlateable_txt.field_ct = 0;

        coerce_it(VOIDP(&(opts->pzCopyright)));
        coerce_it(VOIDP(&(opts->pzCopyNotice)));
        coerce_it(VOIDP(&(opts->pzFullVersion)));
        coerce_it(VOIDP(&(opts->pzUsageTitle)));
        coerce_it(VOIDP(&(opts->pzExplain)));
        coerce_it(VOIDP(&(opts->pzDetail)));
        {
            tOptDesc * od = opts->pOptDesc;
            for (ix = opts->optCt; ix > 0; ix--, od++)
                coerce_it(VOIDP(&(od->pzText)));
        }
    }
}
#endif /* ENABLE_NLS */

#ifdef DO_NOT_COMPILE_THIS_CODE_IT_IS_FOR_GETTEXT
/** I18N function strictly for xgettext.  Do not compile. */
static void bogus_function(void) {
  /* TRANSLATORS:

     The following dummy function was crated solely so that xgettext can
     extract the correct strings.  These strings are actually referenced
     by a field name in the complexityOptions structure noted in the
     comments below.  The literal text is defined in complexity_opt_strs.

     NOTE: the strings below are segmented with respect to the source string
     complexity_opt_strs.  The strings above are handed off for translation
     at run time a paragraph at a time.  Consequently, they are presented here
     for translation a paragraph at a time.

     ALSO: often the description for an option will reference another option
     by name.  These are set off with apostrophe quotes (I hope).  Do not
     translate option names.
   */
  /* referenced via complexityOptions.pzCopyright */
  puts(_("complexity (GNU Complexity) 1.13\n\
Copyright (C) 2011-2020 Bruce Korb, all rights reserved.\n\
This is free software. It is licensed for use, modification and\n\
redistribution under the terms of the GNU General Public License,\n\
version 3 or later <http://gnu.org/licenses/gpl.html>\n"));

  /* referenced via complexityOptions.pzCopyNotice */
  puts(_("complexity is free software: you can redistribute it and/or modify it under\n\
the terms of the GNU General Public License as published by the Free\n\
Software Foundation, either version 3 of the License, or (at your option)\n\
any later version.\n\n"));
  puts(_("complexity is distributed in the hope that it will be useful, but WITHOUT\n\
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or\n\
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for\n\
more details.\n\n"));
  puts(_("You should have received a copy of the GNU General Public License along\n\
with this program.  If not, see <http://www.gnu.org/licenses/>.\n"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("Reporting threshold"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("zero exit threshold"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("score multiplier for nested code"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("score multiplier for nested expressions"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("complexity scaling factor"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("Display histogram of complexity numbers"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("Display the score for each procedure"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("procedure name to be ignored"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("do not print scoring header"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("Run the source(s) through unifdef(1BSD)"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("Specify the unifdef program"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("file of file list"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("trace output file"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("display extended usage information and exit"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("extended usage information passed thru pager"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("output version information and exit"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("save the option state to a config file"));

  /* referenced via complexityOptions.pOptDesc->pzText */
  puts(_("load options from a config file"));

  /* referenced via complexityOptions.pzUsageTitle */
  puts(_("complexity (GNU Complexity) - Measure complexity of C source\n\
Usage:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]... \\\n\
\t\t[ <file-name> ... ]\n"));

  /* referenced via complexityOptions.pzExplain */
  puts(_("Compute the complexity of source code not just with a path-through-the-code\n\
count, but also amplifying line counts by logic level nesting.\n\n"));
  puts(_("If no arguments are provided, input arguments are read from stdin,\n\
one per line; blank and '#'-prefixed lines are comments.\n\
'stdin' may not be a terminal (tty).\n"));

  /* referenced via complexityOptions.pzDetail */
  puts(_("'complexity' ignores all cpp preprocessor directives - calculating the\n\
complexity of the appearance of the code, rather than the complexity after\n\
the preprocessor manipulates the code.  'getchar(3)', for example, will\n\
expand into quite complicated code.\n"));

  /* referenced via complexityOptions.pzFullVersion */
  puts(_("complexity (GNU Complexity) 1.13"));

  /* referenced via complexityOptions.pzFullUsage */
  puts(_("<<<NOT-FOUND>>>"));

  /* referenced via complexityOptions.pzShortUsage */
  puts(_("<<<NOT-FOUND>>>"));
  /* LIBOPTS-MESSAGES: */
#line 62 "../autoopts.c"
  puts(_("allocation of %d bytes failed\n"));
#line 84 "../autoopts.c"
  puts(_("allocation of %d bytes failed\n"));
#line 49 "../init.c"
  puts(_("AutoOpts function called without option descriptor\n"));
#line 82 "../init.c"
  puts(_("\tThis exceeds the compiled library version:  "));
#line 80 "../init.c"
  puts(_("Automated Options Processing Error!\n"
       "\t%s called AutoOpts function with structure version %d:%d:%d.\n"));
#line 73 "../autoopts.c"
  puts(_("realloc of %d bytes at 0x%p failed\n"));
#line 84 "../init.c"
  puts(_("\tThis is less than the minimum library version:  "));
#line 122 "../version.c"
  puts(_("Automated Options version %s\n"
       "\tCopyright (C) 1999-2020 by Bruce Korb - all rights reserved\n"));
#line 49 "../makeshell.c"
  puts(_("(AutoOpts bug):  %s.\n"));
#line 90 "../reset.c"
  puts(_("optionResetOpt() called, but reset-option not configured"));
#line 241 "../usage.c"
  puts(_("could not locate the 'help' option"));
#line 325 "../autoopts.c"
  puts(_("optionProcess() was called with invalid data"));
#line 697 "../usage.c"
  puts(_("invalid argument type specified"));
#line 569 "../find.c"
  puts(_("defaulted to option with optional arg"));
#line 76 "../alias.c"
  puts(_("aliasing option is out of range."));
#line 210 "../enum.c"
  puts(_("%s error:  the keyword '%s' is ambiguous for %s\n"));
#line 79 "../find.c"
  puts(_("  The following options match:\n"));
#line 264 "../find.c"
  puts(_("%s: ambiguous option name: %s (matches %d options)\n"));
#line 162 "../check.c"
  puts(_("%s: Command line arguments required\n"));
#line 43 "../alias.c"
  puts(_("%d %s%s options allowed\n"));
#line 56 "../makeshell.c"
  puts(_("%s error %d (%s) calling %s for '%s'\n"));
#line 268 "../makeshell.c"
  puts(_("interprocess pipe"));
#line 172 "../version.c"
  puts(_("error: version option argument '%c' invalid.  Use:\n"
       "\t'v' - version only\n"
       "\t'c' - version and copyright\n"
       "\t'n' - version and full copyright notice\n"));
#line 59 "../check.c"
  puts(_("%s error:  the '%s' and '%s' options conflict\n"));
#line 188 "../find.c"
  puts(_("%s: The '%s' option has been disabled."));
#line 401 "../find.c"
  puts(_("%s: The '%s' option has been disabled."));
#line 38 "../alias.c"
  puts(_("-equivalence"));
#line 440 "../find.c"
  puts(_("%s: illegal option -- %c\n"));
#line 110 "../reset.c"
  puts(_("%s: illegal option -- %c\n"));
#line 242 "../find.c"
  puts(_("%s: illegal option -- %s\n"));
#line 741 "../find.c"
  puts(_("%s: illegal option -- %s\n"));
#line 118 "../reset.c"
  puts(_("%s: illegal option -- %s\n"));
#line 306 "../find.c"
  puts(_("%s: unknown vendor extension option -- %s\n"));
#line 135 "../enum.c"
  puts(_("  or an integer from %d through %d\n"));
#line 145 "../enum.c"
  puts(_("  or an integer from %d through %d\n"));
#line 696 "../usage.c"
  puts(_("%s error:  invalid option descriptor for %s\n"));
#line 1030 "../usage.c"
  puts(_("%s error:  invalid option descriptor for %s\n"));
#line 356 "../find.c"
  puts(_("%s: invalid option name: %s\n"));
#line 498 "../find.c"
  puts(_("%s: The '%s' option requires an argument.\n"));
#line 145 "../autoopts.c"
  puts(_("(AutoOpts bug):  Equivalenced option '%s' was equivalenced to both\n"
       "\t'%s' and '%s'."));
#line 95 "../check.c"
  puts(_("%s error:  The %s option is required\n"));
#line 603 "../find.c"
  puts(_("%s: The '%s' option cannot have an argument.\n"));
#line 152 "../check.c"
  puts(_("%s: Command line arguments are not allowed.\n"));
#line 568 "../save.c"
  puts(_("error %d (%s) creating %s\n"));
#line 210 "../enum.c"
  puts(_("%s error:  '%s' does not match any %s keywords.\n"));
#line 93 "../reset.c"
  puts(_("%s error: The '%s' option requires an argument.\n"));
#line 122 "../save.c"
  puts(_("error %d (%s) stat-ing %s\n"));
#line 175 "../save.c"
  puts(_("error %d (%s) stat-ing %s\n"));
#line 143 "../restore.c"
  puts(_("%s error: no saved option state\n"));
#line 220 "../autoopts.c"
  puts(_("'%s' is not a command line option.\n"));
#line 113 "../time.c"
  puts(_("%s error:  '%s' is not a recognizable date/time.\n"));
#line 50 "../time.c"
  puts(_("%s error:  '%s' is not a recognizable time duration.\n"));
#line 93 "../check.c"
  puts(_("%s error:  The %s option must appear %d times.\n"));
#line 162 "../numeric.c"
  puts(_("%s error:  '%s' is not a recognizable number.\n"));
#line 176 "../enum.c"
  puts(_("%s error:  %s exceeds %s keyword count\n"));
#line 279 "../usage.c"
  puts(_("Try '%s %s' for more information.\n"));
#line 45 "../alias.c"
  puts(_("one %s%s option allowed\n"));
#line 170 "../makeshell.c"
  puts(_("standard output"));
#line 905 "../makeshell.c"
  puts(_("standard output"));
#line 223 "../usage.c"
  puts(_("standard output"));
#line 364 "../usage.c"
  puts(_("standard output"));
#line 574 "../usage.c"
  puts(_("standard output"));
#line 179 "../version.c"
  puts(_("standard output"));
#line 223 "../usage.c"
  puts(_("standard error"));
#line 364 "../usage.c"
  puts(_("standard error"));
#line 574 "../usage.c"
  puts(_("standard error"));
#line 179 "../version.c"
  puts(_("standard error"));
#line 170 "../makeshell.c"
  puts(_("write"));
#line 905 "../makeshell.c"
  puts(_("write"));
#line 222 "../usage.c"
  puts(_("write"));
#line 363 "../usage.c"
  puts(_("write"));
#line 573 "../usage.c"
  puts(_("write"));
#line 178 "../version.c"
  puts(_("write"));
#line 60 "../numeric.c"
  puts(_("%s error:  %s option value %ld is out of range.\n"));
#line 45 "../check.c"
  puts(_("%s error:  %s option requires the %s option\n"));
#line 121 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 174 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 193 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
#line 567 "../save.c"
  puts(_("%s warning:  cannot save options - %s not regular file\n"));
  /* END-LIBOPTS-MESSAGES */

  /* USAGE-TEXT: */
#line 822 "../usage.c"
  puts(_("\t\t\t\t- an alternate for '%s'\n"));
#line 1097 "../usage.c"
  puts(_("Version, usage and configuration options:"));
#line 873 "../usage.c"
  puts(_("\t\t\t\t- default option for unnamed options\n"));
#line 786 "../usage.c"
  puts(_("\t\t\t\t- disabled as '--%s'\n"));
#line 1066 "../usage.c"
  puts(_(" --- %-14s %s\n"));
#line 1064 "../usage.c"
  puts(_("This option has been disabled"));
#line 813 "../usage.c"
  puts(_("\t\t\t\t- enabled by default\n"));
#line 40 "../alias.c"
  puts(_("%s error:  only "));
#line 1143 "../usage.c"
  puts(_(" - examining environment variables named %s_*\n"));
#line 168 "../file.c"
  puts(_("\t\t\t\t- file must not pre-exist\n"));
#line 172 "../file.c"
  puts(_("\t\t\t\t- file must pre-exist\n"));
#line 329 "../usage.c"
  puts(_("Options are specified by doubled hyphens and their name or by a single\n"
       "hyphen and the flag character.\n"));
#line 882 "../makeshell.c"
  puts(_("\n"
       "= = = = = = = =\n\n"
       "This incarnation of genshell will produce\n"
       "a shell script to parse the options for %s:\n\n"));
#line 142 "../enum.c"
  puts(_("  or an integer mask with any of the lower %d bits set\n"));
#line 846 "../usage.c"
  puts(_("\t\t\t\t- is a set membership option\n"));
#line 867 "../usage.c"
  puts(_("\t\t\t\t- must appear between %d and %d times\n"));
#line 331 "../usage.c"
  puts(_("Options are specified by single or double hyphens and their name.\n"));
#line 853 "../usage.c"
  puts(_("\t\t\t\t- may appear multiple times\n"));
#line 840 "../usage.c"
  puts(_("\t\t\t\t- may not be preset\n"));
#line 1258 "../usage.c"
  puts(_("   Arg Option-Name    Description\n"));
#line 1194 "../usage.c"
  puts(_("  Flg Arg Option-Name    Description\n"));
#line 1252 "../usage.c"
  puts(_("  Flg Arg Option-Name    Description\n"));
#line 1253 "../usage.c"
  puts(_(" %3s %s"));
#line 1259 "../usage.c"
  puts(_(" %3s %s"));
#line 336 "../usage.c"
  puts(_("The '-#<number>' option may omit the hash char\n"));
#line 332 "../usage.c"
  puts(_("All arguments are named options.\n"));
#line 920 "../usage.c"
  puts(_(" - reading file %s"));
#line 358 "../usage.c"
  puts(_("\n"
       "Please send bug reports to:  <%s>\n"));
#line 101 "../version.c"
  puts(_("\n"
       "Please send bug reports to:  <%s>\n"));
#line 130 "../version.c"
  puts(_("\n"
       "Please send bug reports to:  <%s>\n"));
#line 852 "../usage.c"
  puts(_("\t\t\t\t- may NOT appear - preset only\n"));
#line 893 "../usage.c"
  puts(_("\n"
       "The following option preset mechanisms are supported:\n"));
#line 1141 "../usage.c"
  puts(_("\n"
       "The following option preset mechanisms are supported:\n"));
#line 631 "../usage.c"
  puts(_("prohibits these options:\n"));
#line 626 "../usage.c"
  puts(_("prohibits the option '%s'\n"));
#line 81 "../numeric.c"
  puts(_("%s%ld to %ld"));
#line 79 "../numeric.c"
  puts(_("%sgreater than or equal to %ld"));
#line 75 "../numeric.c"
  puts(_("%s%ld exactly"));
#line 68 "../numeric.c"
  puts(_("%sit must lie in one of the ranges:\n"));
#line 68 "../numeric.c"
  puts(_("%sit must be in the range:\n"));
#line 88 "../numeric.c"
  puts(_(", or\n"));
#line 66 "../numeric.c"
  puts(_("%sis scalable with a suffix: k/K/m/M/g/G/t/T\n"));
#line 77 "../numeric.c"
  puts(_("%sless than or equal to %ld"));
#line 339 "../usage.c"
  puts(_("Operands and options may be intermixed.  They will be reordered.\n"));
#line 601 "../usage.c"
  puts(_("requires the option '%s'\n"));
#line 604 "../usage.c"
  puts(_("requires these options:\n"));
#line 1270 "../usage.c"
  puts(_("   Arg Option-Name   Req?  Description\n"));
#line 1264 "../usage.c"
  puts(_("  Flg Arg Option-Name   Req?  Description\n"));
#line 143 "../enum.c"
  puts(_("or you may use a numeric representation.  Preceding these with a '!'\n"
       "will clear the bits, specifying 'none' will clear all bits, and 'all'\n"
       "will set them all.  Multiple entries may be passed as an option\n"
       "argument list.\n"));
#line 859 "../usage.c"
  puts(_("\t\t\t\t- may appear up to %d times\n"));
#line 52 "../enum.c"
  puts(_("The valid \"%s\" option keywords are:\n"));
#line 1101 "../usage.c"
  puts(_("The next option supports vendor supported extra options:"));
#line 722 "../usage.c"
  puts(_("These additional options are:"));
  /* END-USAGE-TEXT */
}
#endif /* uncompilable code */
#ifdef  __cplusplus
}
#endif
/* opts.c ends here */
/* sum: opts.def = 25387.13 */
