/*
 * Copyright (C) 2025 The Phosh Developers
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 * Enums and flags that are also used in GSettings
 */

#pragma once

/**
 * LcbChannelMode:
 * @LCB_CHANNEL_MODE_NONE: Don't try to set any channels
 * @LCB_CHANNEL_MODE_COUNTRY: Update channel list based on country
 *
 * How to set the channel list
 */
typedef enum {
  LCB_CHANNEL_MODE_NONE  = 0,
  LCB_CHANNEL_MODE_COUNTRY  = 1,
} LcbChannelMode;

/**
 * LcbSeverityLevels:
 * @LCB_SEVERITY_LEVEL_UNKNOWN: Alert level is unknown
 * @LCB_SEVERITY_LEVEL_PRESIDENTIAL: Presidential alerts, corresponds to EU-ALERT level 1
 * @LCB_SEVERITY_LEVEL_EXTREME: Extreme threat, corresponds to EU-ALERT level 2
 * @LCB_SEVERITY_LEVEL_SEVERE: Severe threat, corresponds to EU-ALERT level 3
 * @LCB_SEVERITY_LEVEL_PUBLIC_SAFETY: Public safety
 * @LCB_SEVERITY_LEVEL_AMBER: Child Abduction Emergency
 * @LCB_SEVERITY_LEVEL_TEST: Test alerts
 *
 * The severity levels to set
 */
typedef enum {
  LCB_SEVERITY_LEVEL_UNKNOWN        = 0,
  LCB_SEVERITY_LEVEL_PRESIDENTIAL   = (1 << 0),
  LCB_SEVERITY_LEVEL_EXTREME        = (1 << 1),
  LCB_SEVERITY_LEVEL_SEVERE         = (1 << 2),
  LCB_SEVERITY_LEVEL_PUBLIC_SAFETY  = (1 << 3),
  LCB_SEVERITY_LEVEL_AMBER          = (1 << 4),
  LCB_SEVERITY_LEVEL_TEST           = (1 << 5),
} LcbSeverityLevel;
