include(manual.h)dnl
HEADER(work_queue_graph_log)

SECTION(NAME)
BOLD(work_queue_graph_log) - plots Work Queue statistics logs.

SECTION(SYNOPSIS)
CODE(BOLD(work_queue_graph_log [options] work-queue-log))

SECTION(DESCRIPTION)

BOLD(work_queue_graph_log) is a script to plot some of the statistics from a
Work Queue log, as generated by CODE(work_queue_specify_log) from the C and Perl Work Queue APIs, or by
CODE(q.specify_log) from the Python Work Queue API. It assumes the availability of
CODE(gnuplot).

BOLD(work_queue_graph_log) generates four plots, all with CODE(timestamp) as
the independent variable:

CODE(time):
    timestamp, total_send_time, total_receive_time, total_transfer_time, and total_manager_time. (The last two generated by the script, not in the log.)

CODE(time-log):
    log-scale version of CODE(times), plus total_execute_time.

CODE(tasks):
    total_tasks_waiting, total_tasks_running, total_workers_connected, total_workers_busy, and total_cores

CODE(tasks-log):
    log-scale version of CODE(tasks), plus total_complete_tasks.

SECTION(OPTIONS)
OPTIONS_BEGIN
OPTION_PAIR(-o,prefix-output)Generate prefix-output.{time,time-log,tasks,tasks-log}.<output-format>. Default is <work-queue-log>.
OPTION_PAIR(-c,gnuplot-path)Specify the location of the gnuplot executable. Default is gnuplot.
OPTION_PAIR(-r,range)Range of time to plot, in time units (see -u) from the start of execution. Of the form: min:max, min:, or :max.
OPTION_PAIR(-T,output-format)Set output format. Default is png. If "text", then the gnuplot scripts are written instead of the images.
OPTION_PAIR(-u,time-unit)Time scale to output. One of s,m,h or d, for seconds, minutes (default), hours or days.
OPTION_ITEM(`-h')Show help text.
OPTIONS_END

SECTION(EXAMPLES)

General use:

LONGCODE_BEGIN
% work_queue_graph_log mylog
% ls mylog*.png
mylog.tasks.png mylog.tasks-log.png mylog.time.png mylog.time-log.png
LONGCODE_END

Plot up to the eleventh hour:

LONGCODE_BEGIN
% work_queue_graph_log -u h -r :11 mylog

LONGCODE_END
Generate script text:

LONGCODE_BEGIN
% work_queue_graph_log -Ttext mylog
% ls mylog*.gnuplot
mylog.tasks.png.gnuplot mylog.tasks-log.png.gnuplot mylog.time.png.gnuplot mylog.time-log.png.gnuplot
LONGCODE_END

Specify gnuplot path:

LONGCODE_BEGIN
% work_queue_graph_log -c/some/dir/bin/gnuplot mylog
LONGCODE_END

SECTION(BUGS)

LIST_BEGIN
LIST_ITEM(Some formats need a special setup for their gnuplot output terminal. `-T' blindly passes the output format, which may cause gnuplot to fail.)
LIST_END

SECTION(COPYRIGHT)

COPYRIGHT_BOILERPLATE

FOOTER
