# base16384
> **Note**: This project used the awesome cross-platform binary compiling tool [cosmopolitan](https://github.com/jart/cosmopolitan)

> Alternatives: [Go](https://github.com/fumiama/go-base16384), [Python](https://github.com/synodriver/pybase16384), [Android](https://github.com/fumiama/android-base16384), [TypeScript](https://github.com/shigma/base16384.js), [Lua(binding)](https://github.com/synodriver/lua-base16384), [Lua(pure)](https://github.com/Yiwen-Chan/base16384), [C#](https://github.com/lc6464/Base16384Coder-Console)

Encode binary file to printable utf16be, and vice versa.

## Description 说明
Use 16384 Chinene characters (from \u4E00 to \u8DFF) as the "alphabet", just like what base64 did.

使用16384个汉字(从`\u4E00`到`\u8DFF`)作为字符表，就像base64用64个字符作为字符表一样。

If length of the data has a remainder after moduled by 7, we will use \u3Dxx to log it with xx ranging from 01 to 06.

使用`\u3Dxx`附加在末尾以表示编码时数据不满7位的个数，其范围在01~06。

## Benefits 优点
Save more space and since the code 0x0000 is encoded to "一", finding zero space seems to be easier.

相较base64节省更多空间，更容易发现二进制文件的规律。

## Usage 使用说明

### Install from Debian sid 从Debian sid安装
```bash
sudo apt install base16384/unstable
```

### Install from my PPA in Ubuntu 从我的PPA安装
```bash
sudo add-apt-repository ppa:fumiama/ppa
sudo apt-get update
sudo apt-get install base16384
```

### Build from source code 编译

Clone this repo first.

首先克隆该仓库。

```bash
git clone https://github.com/fumiama/base16384.git
cd base16384
```

Then use `cmake` to build.

然后使用`cmake`进行构建。

```bash
mkdir build
cd build
cmake ..
make
make install
```

Now you can encode/decode a file by commands below.

现在可以使用命令对文件进行编码/解码。

```kotlin
Usage: -[e|d] <inputfile> <outputfile>
        -e encode
        -d decode
        <inputfile>  pass - to read from stdin
        <outputfile> pass - to write to stdout
```

## Examples 用例
The text below is the encoding of the base16384.exe itself(MacOS Mojave version). It is clear to see the strucutre of the binary file.

下面的文本是使用base16384程序编码自身(MacOS Mojave版本)的结果。可见文件结构十分清晰。

臾糟蘜一乀縀倀倀一仰一亰佀丈戀渀一一乤一丒一丁浟成扴捩卒懀一一一一一一一一一一伀一一一一一一一一一一一一一一一一一一一丙一丂済一旗荄捡戀一一一一一一一丁一一亀一一一一一一一一丠一一一丅一一戀一侀一一一丗菷徕虴一一一一一丅譽扅搕一一一一一七渍一丐一仼冀一一一蘃帀丐一一一一一一一市一一一一一一一佽浳欝搧娀一一一一也旕剕潐一一一一一丷俀一伀一吀一一一不繰一乀一一一一一一嘄丠一一丆一一一一旗蔷忕灟栙擇侕耀一叵譑単挀一一一一一仰欀一帀丂縀一一一丼啀一嘀一一一一一一乀倀一一一一一一丅譽煳欜璖螜一一一丁浟挑掅帀一一一一一複帀丄一丌帐一一一峁舀一一一一一一一丈一一一一一一一一也旘蓶蟍舀一一一一丗菵引晔一一一一一丂乼一乀一俠一一一一渟一乐一一一一一一一一一一一一一一一叵试籷桛瑅讥籦槀一佽浔彖區一一一一一亘嗀一刀一栀一一一並俰一倀一一一一一一一一一一一一一一一最一嚀刀也旑刕弄一一一一一一倀一伀一丁亀一一一亀一一一一帀一一一儀一丰一丄一一一一旗蓦罽腹楘瓶罽繴檀叵謑佔幀一一一一一一渀一帀一嘀一一一一嘀一娀一一一一一丁渀一帀一一一一一丅譽畯欀一一一一一丁浟弐捄刀一一一一一倈一丄一丆一一一一亂一七一一一一一一丘一丄帀一一一一一也旛吕词蝭暛蓅证色丗菴弅扁一一一一一丂亀一乀一倀一一一一渠一丰一一一一一一俀一乐一一一一一一叵讍絭楛蓠一一一一佽浄幕刐一一一一一亠嘀一刀一儀倀一一一一一刀一一一一一一刀一一一一一一一一最一劀一也旓劔蜭卄恕一一一一儂一伀一丁一一一一什一一一僀匀一一一伀一丐一一一一一一嚀丈什一一儀一嘀一亃一丰一一一一一一仠縀为一一渱一娀一丂一丁渀一同渀乸一丢兀一瘁一亰一乐一一一一一一一一丂縀一夀一估一一一一一一一一一一一一一一一嶃娀两一一一一一一一一一一一尀一倀一丌一丂试腲姛咖嚽特椙一一一一侰一丘一与碹仔沖煑桒礅敽蒎籬耀一倀一丁一一丸堀七溠丄一一縀一一劀炠一丐一一一一一一亠一渆一丁縔一一一一一一一一儀一仠一丆一一倀一丟禐刀一市试腲姛咖嚽穩暔薗寑獭妐烦忥穩暀一一一垀一乀一丸儐一帀一傐一丐一丏仄一堀一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一丅挢埥怘諴澧侓園朤焇瘠买暜焇瘟繾帠唆嬄腀一一矁煃仸崇趃豁敱嬢嬕壀一伡焌炒丝嗿澃老瘼両毃滰予崀噝绠誀怏丈数蘼个净倗樶桃糿跿误跿跞跿跾槿跿螿跿跛跿跃翴丁捈灹曔槾凸佝耤瀴嬹一丄澌劁怀檏趂凇貺绘崟蛫倠詿膬冃翽皟焇蘟繺俐嗢埁繾常嶃蘩耣幀栏丁数葩八跿跴巿跿廿跿譟跿跕跿跽跿跿枋滱谐一一丆桁捈灹戕欅摁捐捅嬢俬琀一伦執恢淆栌购凡檀一么烁廑刀乌烊剓嗙瑁滏胐谗瀀一劈稗謐一勈竡宅跃虎瘀一慡浠谓笀一劘嗸伀刀仸薀一专嚞櫇萱縺嬐舀亅縃蛮訄一婿苈痚蠁一下爈一丐暜伔翉蠨绐丁嚃谿绸慜伀丒暜弥燆怚樉媑垒怰沂伐俰灰樞牿俸亀檈艳匀一丂畡侍企瘼凾凸佃虱訄一怣廛刄一怘繈匠俈跸嘼稛眇乀丄瀶荈跿跴耧痨权帀倗丏潖帐丁媋歪勘旘嶈愀帀伔翭析昳誴嶄喿跿謢嬵元渀伲埿蠼廀丁垉翓晟訾化跿跴瀴诵兀与瑨一专晞菔楈煍淠舀乌灹貌戰一恢橔瀗丏漆縐丂跾一丄耧賨窃一僿贀一勈痻皥儀丄耴荚刄丄瀴歃刀一詼亾乀一僫諿净勈痝媉衺噐縀么潰仸恰一专嚟氧呈灶禓漤怀蠈乐丁噣訮渐一么灷苈痧癝儀丄瀗乵簒囓萰嬀为呀縀仫朠訰熬嚃胁岰小儊滰羋跸一专嚟覠漌一姿言一愢淮湐娀专囒蓤崀专嚞欒埶愢沨畧皹伀丄澏纺乀一伲埯愢涞燘夀丒噜俒杌灹苈痛盲僀丄瀇劘一丅笅橁敐揤卽毃怣懛爰一衝跿跽嚍嵃绐七睫跿跴瀴講兀与獿跿跒囓蔬娀为挿跿赟跿践燻跿搿緿譫跿跖緿跽狿跿葢蘼涄一一丁璐捒嚞挅敁掐捔卑慈湻垀一么灼芘痱璃巋廸斌一丒嚰捴尀专嚲演翿枠膲舾叽一丄瀬华冀丄耬繍潽滸帔伀专晟訾刈乀丄琇贁丄一谷褀一勈疜翶婰岂嘬一潰仸蘜倀丌淴耧貺乀一僤倀一刘甁匱聺嵀瘀么滾巰谓稁一劈甍劉豰涑贇眝开涘産俸仠谟溧侃繄愜倀觾凥娄瀴詃怀樄性谩羓囒捴尐专嚞妡猈一劆巂蠁一丄耧界灼沉嘨一怡樀谑漁一劈畽媉趺嚠瘀仩敀帀伢宵怿跿謲埧蠦溠丂叀凡掀刀乌烟梄萗贏瀒縐丁匱襙瘳窴嶄仿跿謢嬵廂縀伢域蠉纠丁垉羓晟显叻趿跴瀴謫僀与爀伀专晞菔楈煍慀稀乌灹貏稤一恢橔瀗丏漄渐丁媉觺尐爀乌灻臟蘀一歁貍嘤一裁沀舨一愣懗縴一愣恘戴帀凇艀丂谁一下瘀丐专嚟謲埩蠭庐丁嚉绡殰谒戀一勈疿皐偀丈巠譵廓嚞趢儉一噜俑佈灶抌善湈粀一一伀一劀啅噣苐橠幜讍擀犌嗤湁瀁仾穡琮凇虀一一七翴丂埇愢泮瀰圀专嚟谧汌灸禑刀尀蠁买丁噣訮渐一乌灹苈症瘱偀丄瀗丏潖巿跽嚍嵗亠七瘴偀丄瀇劘一丅笅橁敐揤卽毃怣懞訤一裸劈苵嘊一岽欢嬽揂渀冯屈煏庠瘀仫罙滱謐一捒嚞挢凬划囗旂贆一与炘嘀丒妍竒蓗溷澴嬣蕭谒咔藃瘃一劈畁囁蠏芌嗨恈煁两渇噈滱伅蔍琮凇虀一一丙眅挢埥幕舕杍嚃褆嘿訐嶅蓀一伢埳怣敝烼吀一岄戠一愢藝漲奵蘒嚴娠嶾帀昿澐嶄猀一倏虥歃抈篬幈烜美渻裿跒嚴婡璃尋敆笢孵萯繠一仨亂一伢奍萓傟猢蛛嬭筸奸楃怽蓞伢埐怰沃謣俺劒囓縉嚺坲芒濴濤紓嚟伣藪怢欄焇瘿怰涡圠係怀歴澧翨什丄渇豈煏殠爀丱縺屰樀丱縒嘼幡楁斐揵蔍嚋泄劈篌曨姿巿謢奃吙瘳溴嶅楿跿趯摈煏彐爀仨篁縀伢嬽娂帀冢礇一劈苴紉一岉訜一怣懒蘤一蠤繰丁嚍嵒源七皇俀七嗿瘾俀三偂庐爤圉偂庐爒暝嬡燆愚欉媑垒恰沢伄俲弢欌喠流繾渤切偆煁子一一彊樤場刖滰巸巠卷垒囐蒴刀丒吰怅嘁耿谄吏嘆裄刘崀囫傐昼渓礄幠言睕嚉蝐捴卙佔拐帟堏哹凢什刀乌曽犘茸佈滾幫蘜一丐榐樀一愃苼猦凁跒妹媑垒園朢弲埈怽谴犧彉艺抐啅埁血犘崄佉滾幇圭嚃豁犀謿罈滱練瀧繈诸节留囑覒丝朣修互囐懔一一劂痁嘁谒嘼両娹萃虫瘄一恣幏嬢净倒冟渾咩乀七啈翀恮帀一一丿致瓼一一巳言义紀勠伸乎专瑠詾刀一一传崸訍佴瀧腈繺縤纇奈灼抌喤剌噾技略嚉諒娞稚俣一巳謠埋繻溈喛贿一劀畹威螒廳燄苃怠言匢凂俓冟基翫伌樃啉厅芃虁刄一凭滁欢城怰泠圢凡仒娞刹嘉詐昿瘄嶄芀一传嶾攅縔瀧汈繹湨喘丿一劀甹嚃蛀芌喌扈灶技病侃貀滸悐一丒任蝰攂怢毤焇琌湹渀丼么偳犈嶌嵈繸翄瀧杈偼战巨兴沒任蝰攃怢毤焇琔湹渀一嵈偳犈嶌嵈繸耤瀧杈偼战巨剴戒任蝰攄怢毤瀇瓀一丄焇琚怂櫤瀏焿怰氲眢埙怂洔吏蠅欉技賹戗佒嚝朢俦縀一伣俦嚒亜蜢凢巒娞囁嘉誒嚝匢衎专渄蘁尀怀檤琤拃恘訄唙刃趏托潐凿弢樅笅橁斐揵蔗虷结嚜漢几贒囕凱嚉艒娞爉嚃繀暜簏焁怡欠谓蠁一妠刀一怊檤渇案滰緼旵紅濁渀仇蓅赛给舘一缸痕牖舆一婎埵朝竁渀儓災摉椠昀仄蚟排蓄吀丱尧荤莰侀丌徉譙八繠七剢浖幚蘘一枋滱谐一一一詽一缸涖觿勢浖淼攗拸缐惗楋剢祤心舀一丱吢戃忄繉攽嘋匥蓶穌創臒伱忝綏剁坺诌愄歳芁穑蕯狄繋攽嘣匭蓵橄剷秒缐恞絋匭茵穆嚴仑缐旧詓臄繑歏甑伭殴穆墶弜嵀一七勢址嶜撵臗亱惝絋厥櫵繌抗槛缐惞絏厥櫵繬抗槜罱攽樣叅蓿橚斯跅祺跼攗拾缸牐凧勁涟藏媁嚃羂婌号拀怠訠嘾匫跿跴瀴担一一伢叛凡坐一仄虾擬贓災摲機敓仅譝窜憋莑匁帀一仅赛織昔一缸瓐儣叭櫴帬憉譙啔繐七叭蓴詞描弄缸痕犕圅一婞敯櫅襺謼斕臑侱尧荤猻佀丌斗槜罽攽刣勢浖恓刔一罽殼脗珫聱泞紧勢浖归帔一罽歌礓灵丰婌叹贄諒傜圤蟁凡戯臿跩籿巿贗譯佧乀一翶怣彌戀一丒噝稾匿跿跾絈崟业嶿跽櫻跿菏緿赢賿跶姯跿榾跿讘簏嗡一一一枤劆崙匱縠嗀淸譵嵑任蜐嗿幣戏谏蘅毋犈舷漁一劆娒佈乲巾倏哺裆昼槣礔滱緄哠伀一岰琏哶幮习一乕怢汔卝佖幕戕彎埰繾俼喠欁訢樜嗤冃蘾傜漊嬌丠訟琗圏瀢渀丁婣聑愞弦蠀耿穿褟資恮縀一一丿巴瓸一一巏言义緀丌凼崀一剓喴崟开丄瘼蛰唻芘苒案灼拂啥嚉諓借嬢嬌瑒嚟嬣俣伓借笠埋怰池标琀跏縄渧汊凎崓庉垃罀折崐啍屳嗫猐俀彡樇扟矴一丄拇筅婹剀唁厅縃虎嘀一悢臎谵嶲繺廨嶄再儮昜唣賿跐皀纉侃谀廸惸一丒囘賋趱跢櫬喸咁螿一丂埋繺罈嶌儉諐皅纈佁滾丠谒愀一嚜複簌湹紀一仁衇亟匊噌嚀爘巠兴氒妻姾翿穿跿謠俻灷稞虒俦言一伢埙怰沒堏漏偼戨漰瀃幠趀忑坈灶抌喤梁虰一丁囁裊瘾嫼埋庢参嘑侃谁敂漢螲跬添嗾翿怀櫴瀧蝈繺怨喇一一劌喼纃蟏纜謊噼嚁掴危佝幗爕護冐媿緿誣賿跊巯跼篾跿胟觿贽趿跿誔调一已挀儀丿联嘌一跉所娀仿坑渰七败怀縀凼獊什丏誕娃一已挸儀丿聕丌一跉挠娀仿坕丰七败掀縀凼獘什丏誕栃一已捰儀专囑蓴倀丐挿誗嬂一圆渀一为汯跿赨區一冧櫿跿蒂刀一衴緿跽瘮一与産跿跚冰一仩綿跿计嘀一岛懿跿栕帀七瞪跿跶澌一为栏跿赨槀一冦擿跿蒇舀一衣巿跽皉一与琋跿跚坰一仩氿跿订猀一岖觿跿栬渀七睤跿跶焄一为掯跿赨莀一冥廿跿艶提湦桛呒俍睺杈呗埉絲岈万殈乆槜呖蚁絵欜啗庁瑩椙怆揉聯檎瀀俉瀀徛蔆掸湩榜啗庁瑩椙怆揉聯檎瀀佝聩欙怆枥穥嘙攧垽耺嘀勷侕簠桛甇提湦桛呒侕聲槜熢丁孡樈咖蟁荴嘙璖羔湥檜瓷囨渀捜萖殔蠠奖著羑欠崚擧俕艦桛呓蚀詯歝唇揑瑩椙懠两筥嘙擦宽牥丂惖庁牥曛葆戀圼桛甇揑瑩椙懢亁繡櫜耂芁良嘜瑖厐湦檛蓒俍艤桛渀狱絵欜啗徙睬杏瀇侅腳嘋怇徼湷檚敆抁良嘜蕆徽荴东蔆掹爠欚擖拨渥椝擗娨一一一一一一一樀一一一丸一一一一挀一一一万侁幀娈伀凃滐縬堉倁繠成儂乀仰蘴娋傂庀一一一巳言一丿臰一一跏縀一仿巀一一一专渄蘁尀憇一一一一冀一一一一刀一唀一丈一三一一一一偀一丂一一一丁艖乐喀嬀丏一一言一寑縀一一七縀一什一丰丆三一嘀一一崀一佀侀三丘七舁縀妀娀乄庰帅漁什帀一一一一一一一一一一一一一一一一一乌啀一刀一掇帀丄一丘俐一伀一咡舀丁一万年一乀一俸欀一帀丂嘝一丐一互啀一刀一甇帀丄一丩濐一伀一夁舀丁一下癴一乀一儐欀一帀七尝一丐一付啀一刀一蚇帀丄一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一一丁劈湠刀一久也旗蔷徑睮樀北嘢幀旗菷寑牯歝唀偁乤汛呅词艵暗萦玹牥檀圇嚀彀旘蓆讍祟柙敇徥筥两万嚠彀旙斆珐亐东焁匁浦柙敆娂帀檎伔佽瑯標擠偀乲帄戅讙繵欘縉丁聈剐叶柉獡最圀俉帑帗葧毉睴杀圀俉昑帗蓖莅縀爀唦久也楝擦莅縀爀唦湅也槜呖蘂帀檜伔佽繥檜瓷嘂帀檞伔佽繲桛畆昂帀檠丑匁浰歝唰偀乲瀀弔佽聥毚擦市帀檤丑匁浳欘敂弥屏弑慣市帀檦丑匁浵榙著後亐一一一佟丁帀捽筨旙斆掍荴杗蒆掅牥檀冶掹焀巙呖威畧杝号寑潲欗蓗娂栁楘撖蘂洁亀一一偯朙帄羉荦丬縐三洀挀塀刀偬杛渆垙睬杀圀刌仠哀一垽牥丝吧掘亮乀严訁言础帀垱獮丢縖枥穥严帐娃渜一縍乴七丠倰丌亠堀丰净瘀什夂稀儀縍帀娂湁丁下儅一一一一一蘆蘀参縅瘁挌上帊一剀蘀丘丁上縸一吀乀佰开丆一市樚一侀丐仄唀丁渀刀亀一丼伐一一一伀一你一丏傀上亀一乀一乸一七縐七业一丐一並一一訄一渄帀丄一丌縀一崁一吀蘀丁一七言一凂渀僀渐一帀丁唀一仰刀亰區一刀一懀一丼伀临仠一伀一叀一丏乀与临一乀一侠一七縐一渔一丐一乶一一訄一樅一丄一丟一一伀一帀一一一丈昀一乀一刀一一一丂开一丐一伀一一一一瘀一丄一乀一一一一塠一丁一丐一一一一傴一一帀丄一一一一亴一一刀丁一一一一丮縀一伀一帀一一一丌嘀一乀一刀一一一七堀一丐一伀一一一一舀一丄一乀一一一一宀一丁一丐一一一一典一一帀丄一一一一仦一一刀丁一一一一主渀一伀一帀一一一丏帀一乀一刀一一一七言一丐一伀一一一一傀帀丄一乀一一一一传刀丁一丐一一一一临一七渀一崀一伀一丑一丁嘀一勀一乐一丅帀一搀一佰一丘一丁爀一咀一乬一万一一一丐亰一丌一丁舀一兀一丸一七縀一帀一伐一丒一丁娀一匀一乔一丅渀一攀一侀一丙一丁瘀一哀一买一丈丅譽筨旙斆掍荴杗蒆掅牥檀叶徕煢歙清讑獣槙呐佽牥曛葆捽瑩椙帅讑獣槙呕讱獮丗葖融灵枀叶掹煯朙帅讕籣槙呕讙睬杀叶掹煯朙揶羕簀旙著彽腴晜畅讵脀旛搖玸也旗蔷徑睮樀叵譽腴望蕗忀也曛哶宭浧杝商玵猀旙斆珐也枙著後也枛蔆掸也果啗後也果瑖厐也枝蔦珑猀旛擖叀也楝擦莅縀旛蔆掸也標攧垽耀旜唦玹艦丗蔇揑脀旜瑗殥籤丗蔷待舤恓狴弔萴丗蕖螝獴曀呇玱牟櫝啖坽灩榙呗嘀一一一㴃