/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.Connection;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.MarshalException;
import Ice.NoEndpointException;
import IceInternal.BasicStream;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.Reference;
import IceInternal.RoutableReference;
import IceInternal.RouterInfo;
import java.util.Hashtable;

public class DirectReference
extends RoutableReference {
    private Endpoint[] _endpoints;

    public DirectReference(Instance instance, Communicator communicator, Identity identity, Hashtable hashtable, String string, int n, boolean bl, Endpoint[] endpointArray, RouterInfo routerInfo) {
        super(instance, communicator, identity, hashtable, string, n, bl, routerInfo);
        this._endpoints = endpointArray;
    }

    public Endpoint[] getEndpoints() {
        return this._endpoints;
    }

    public final Reference changeEndpoints(Endpoint[] endpointArray) {
        if (this.compare(endpointArray, this._endpoints)) {
            return this;
        }
        DirectReference directReference = (DirectReference)this.getInstance().referenceFactory().copy(this);
        directReference._endpoints = endpointArray;
        return directReference;
    }

    public Reference changeLocator(LocatorPrx locatorPrx) {
        if (locatorPrx != null) {
            LocatorInfo locatorInfo = this.getInstance().locatorManager().get(locatorPrx);
            return this.getInstance().referenceFactory().create(this.getIdentity(), this.getContext(), this.getFacet(), this.getMode(), this.getSecure(), "", null, locatorInfo);
        }
        return this;
    }

    public Reference changeTimeout(int n) {
        DirectReference directReference = (DirectReference)this.getInstance().referenceFactory().copy(this);
        Endpoint[] endpointArray = new Endpoint[this._endpoints.length];
        for (int i = 0; i < this._endpoints.length; ++i) {
            endpointArray[i] = this._endpoints[i].timeout(n);
        }
        directReference._endpoints = endpointArray;
        return directReference;
    }

    public void streamWrite(BasicStream basicStream) throws MarshalException {
        super.streamWrite(basicStream);
        basicStream.writeSize(this._endpoints.length);
        if (this._endpoints.length > 0) {
            for (int i = 0; i < this._endpoints.length; ++i) {
                this._endpoints[i].streamWrite(basicStream);
            }
        } else {
            basicStream.writeString("");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        for (int i = 0; i < this._endpoints.length; ++i) {
            String string = ((Object)this._endpoints[i]).toString();
            if (string == null || string.length() <= 0) continue;
            stringBuffer.append(':');
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public Connection getConnection() {
        Endpoint[] endpointArray;
        Endpoint[] endpointArray2 = super.getRoutedEndpoints();
        if (endpointArray2.length == 0) {
            endpointArray2 = this._endpoints;
        }
        if ((endpointArray = this.filterEndpoints(endpointArray2)).length == 0) {
            NoEndpointException noEndpointException = new NoEndpointException();
            noEndpointException.proxy = this.toString();
            throw noEndpointException;
        }
        OutgoingConnectionFactory outgoingConnectionFactory = this.getInstance().outgoingConnectionFactory();
        Connection connection = outgoingConnectionFactory.create(endpointArray);
        if (this.getRouterInfo() != null) {
            connection.setAdapter(this.getRouterInfo().getAdapter());
        }
        return connection;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DirectReference)) {
            return false;
        }
        DirectReference directReference = (DirectReference)object;
        if (!super.equals(directReference)) {
            return false;
        }
        return this.compare(this._endpoints, directReference._endpoints);
    }

    protected DirectReference() {
    }

    protected void shallowCopy(DirectReference directReference) {
        super.shallowCopy(directReference);
        directReference._endpoints = this._endpoints;
    }

    public Object ice_clone() {
        DirectReference directReference = new DirectReference();
        this.shallowCopy(directReference);
        return directReference;
    }
}

