/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectFailedException;
import Ice.ConnectTimeoutException;
import Ice.ConnectionRefusedException;
import Ice.Logger;
import Ice.SocketException;
import IceInternal.InetSocketAddress;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.TraceLevels;
import IceInternal.Transceiver;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;

final class Connector {
    private Instance _instance;
    private TraceLevels _traceLevels;
    private Logger _logger;
    private InetSocketAddress _addr;

    public Transceiver connect(int n) {
        Object object;
        Object object2;
        if (this._traceLevels.network >= 2) {
            object2 = "trying to establish tcp connection to " + this.toString();
            this._logger.trace(this._traceLevels.networkCat, (String)object2);
        }
        object2 = null;
        try {
            if (n >= 0) {
                object = new ConnectThread(this._addr);
                ((Thread)object).start();
                object2 = ((ConnectThread)object).getFd(n == 0 ? 1 : n);
                if (object2 == null) {
                    throw new ConnectTimeoutException();
                }
            } else {
                object2 = new Socket(this._addr.getAddress(), this._addr.getPort());
            }
        }
        catch (ConnectException connectException) {
            if (object2 != null) {
                try {
                    ((Socket)object2).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ConnectFailedException connectFailedException = Network.connectionRefused(connectException) ? new ConnectionRefusedException() : new ConnectFailedException();
            connectFailedException.initCause(connectException);
            throw connectFailedException;
        }
        catch (IOException iOException) {
            if (object2 != null) {
                try {
                    ((Socket)object2).close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            SocketException socketException = new SocketException();
            socketException.initCause(iOException);
            throw socketException;
        }
        catch (RuntimeException runtimeException) {
            if (object2 != null) {
                try {
                    ((Socket)object2).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw runtimeException;
        }
        if (this._traceLevels.network >= 1) {
            object = "tcp connection established\n" + Network.fdToString((Socket)object2);
            this._logger.trace(this._traceLevels.networkCat, (String)object);
        }
        return new Transceiver(this._instance, (Socket)object2);
    }

    public String toString() {
        return Network.addrToString(this._addr);
    }

    Connector(Instance instance, String string, int n) {
        this._instance = instance;
        this._traceLevels = instance.traceLevels();
        this._logger = instance.logger();
        this._addr = Network.getAddress(string, n);
    }

    private static class ConnectThread
    extends Thread {
        private InetSocketAddress _addr;
        private Socket _fd;
        private IOException _ex;

        ConnectThread(InetSocketAddress inetSocketAddress) {
            this._addr = inetSocketAddress;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Socket socket = new Socket(this._addr.getAddress(), this._addr.getPort());
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    this._fd = socket;
                    this.notifyAll();
                }
            }
            catch (IOException iOException) {
                ConnectThread connectThread = this;
                synchronized (connectThread) {
                    this._ex = iOException;
                    this.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Socket getFd(int n) throws IOException {
            Socket socket = null;
            ConnectThread connectThread = this;
            synchronized (connectThread) {
                while (this._fd == null && this._ex == null) {
                    try {
                        this.wait(n);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
                if (this._ex != null) {
                    throw this._ex;
                }
                socket = this._fd;
                this._fd = null;
            }
            return socket;
        }
    }
}

