/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.Identity;
import Ice.IdentityParseException;
import Ice.ObjectPrx;
import Ice.Properties;
import Ice.StringHolder;
import Ice.StringSeqHolder;
import IceInternal.Instance;
import IceInternal.Network;
import IceUtil.StringUtil;
import IceUtil.UUID;

public final class Util {
    private static Properties _defaultProperties = null;
    private static String _localAddress = null;

    public static Properties createProperties() {
        return new Properties();
    }

    public static Properties createProperties(StringSeqHolder stringSeqHolder) {
        return new Properties(stringSeqHolder);
    }

    public static Properties createProperties(String[] stringArray) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.createProperties(stringSeqHolder);
    }

    public static Properties getDefaultProperties() {
        if (_defaultProperties == null) {
            _defaultProperties = Util.createProperties();
        }
        return _defaultProperties;
    }

    public static Properties getDefaultProperties(StringSeqHolder stringSeqHolder) {
        if (_defaultProperties == null) {
            _defaultProperties = Util.createProperties(stringSeqHolder);
        }
        return _defaultProperties;
    }

    public static Properties getDefaultProperties(String[] stringArray) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.getDefaultProperties(stringSeqHolder);
    }

    public static Communicator initialize(StringSeqHolder stringSeqHolder) {
        Properties properties = Util.getDefaultProperties(stringSeqHolder);
        return Util.initializeWithProperties(stringSeqHolder, properties);
    }

    public static Communicator initialize(String[] stringArray) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.initialize(stringSeqHolder);
    }

    public static Communicator initializeWithProperties(StringSeqHolder stringSeqHolder, Properties properties) {
        stringSeqHolder.value = properties.parseIceCommandLineOptions(stringSeqHolder.value);
        Communicator communicator = new Communicator(properties);
        communicator.finishSetup(stringSeqHolder);
        return communicator;
    }

    public static Communicator initializeWithProperties(String[] stringArray, Properties properties) {
        StringSeqHolder stringSeqHolder = new StringSeqHolder(stringArray);
        return Util.initializeWithProperties(stringSeqHolder, properties);
    }

    public static Instance getInstance(Communicator communicator) {
        return communicator.getInstance();
    }

    public static Identity stringToIdentity(String string) {
        Identity identity = new Identity();
        int n = -1;
        int n2 = 0;
        while ((n2 = string.indexOf(47, n2)) != -1) {
            if (n2 == 0 || string.charAt(n2 - 1) != '\\') {
                if (n == -1) {
                    n = n2;
                } else {
                    IdentityParseException identityParseException = new IdentityParseException();
                    identityParseException.str = string;
                    throw identityParseException;
                }
            }
            ++n2;
        }
        if (n == -1) {
            StringHolder stringHolder = new StringHolder();
            if (!StringUtil.unescapeString(string, 0, string.length(), stringHolder)) {
                IdentityParseException identityParseException = new IdentityParseException();
                identityParseException.str = string;
                throw identityParseException;
            }
            identity.category = "";
            identity.name = stringHolder.value;
        } else {
            StringHolder stringHolder = new StringHolder();
            if (!StringUtil.unescapeString(string, 0, n, stringHolder)) {
                IdentityParseException identityParseException = new IdentityParseException();
                identityParseException.str = string;
                throw identityParseException;
            }
            identity.category = stringHolder.value;
            if (n + 1 < string.length()) {
                if (!StringUtil.unescapeString(string, n + 1, string.length(), stringHolder)) {
                    IdentityParseException identityParseException = new IdentityParseException();
                    identityParseException.str = string;
                    throw identityParseException;
                }
                identity.name = stringHolder.value;
            } else {
                identity.name = "";
            }
        }
        return identity;
    }

    public static String identityToString(Identity identity) {
        if (identity.category.length() == 0) {
            return StringUtil.escapeString(identity.name, "/");
        }
        return StringUtil.escapeString(identity.category, "/") + '/' + StringUtil.escapeString(identity.name, "/");
    }

    public static synchronized String generateUUID() {
        if (_localAddress == null) {
            byte[] byArray = Network.getLocalAddress();
            _localAddress = "";
            for (int i = 0; i < byArray.length; ++i) {
                if (i > 0) {
                    _localAddress = _localAddress + ":";
                }
                int n = byArray[i] < 0 ? byArray[i] + 256 : byArray[i];
                _localAddress = _localAddress + Integer.toHexString(n);
            }
        }
        return _localAddress + ":" + UUID.create();
    }

    public static int proxyIdentityCompare(ObjectPrx objectPrx, ObjectPrx objectPrx2) {
        if (objectPrx == null && objectPrx2 == null) {
            return 0;
        }
        if (objectPrx == null && objectPrx2 != null) {
            return -1;
        }
        if (objectPrx != null && objectPrx2 == null) {
            return 1;
        }
        Identity identity = objectPrx.ice_getIdentity();
        Identity identity2 = objectPrx2.ice_getIdentity();
        int n = identity.name.compareTo(identity2.name);
        if (n != 0) {
            return n;
        }
        return identity.category.compareTo(identity2.category);
    }

    public static int proxyIdentityAndFacetCompare(ObjectPrx objectPrx, ObjectPrx objectPrx2) {
        if (objectPrx == null && objectPrx2 == null) {
            return 0;
        }
        if (objectPrx == null && objectPrx2 != null) {
            return -1;
        }
        if (objectPrx != null && objectPrx2 == null) {
            return 1;
        }
        Identity identity = objectPrx.ice_getIdentity();
        Identity identity2 = objectPrx2.ice_getIdentity();
        int n = identity.name.compareTo(identity2.name);
        if (n != 0) {
            return n;
        }
        n = identity.category.compareTo(identity2.category);
        if (n != 0) {
            return n;
        }
        String string = objectPrx.ice_getFacet();
        String string2 = objectPrx2.ice_getFacet();
        if (string == null && string2 == null) {
            return 0;
        }
        if (string == null) {
            return -1;
        }
        if (string2 == null) {
            return 1;
        }
        return string.compareTo(string2);
    }
}

