/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Communicator;
import Ice.Connection;
import Ice.FeatureNotSupportedException;
import Ice.Identity;
import Ice.LocatorPrx;
import Ice.RouterPrx;
import Ice.Util;
import IceInternal.BasicStream;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceUtil.Debug;
import IceUtil.StringUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public abstract class Reference {
    private Instance _instance;
    private Communicator _communicator;
    private int _mode;
    private boolean _secure;
    private Identity _identity;
    private Hashtable _context;
    private static Hashtable _emptyContext = new Hashtable();
    private String _facet;
    protected int _hashValue;
    protected boolean _hashInitialized;

    public final int getMode() {
        return this._mode;
    }

    public final boolean getSecure() {
        return this._secure;
    }

    public final Identity getIdentity() {
        return this._identity;
    }

    public final String getFacet() {
        return this._facet;
    }

    public final Instance getInstance() {
        return this._instance;
    }

    public final Hashtable getContext() {
        return this._context;
    }

    public abstract Endpoint[] getEndpoints();

    public final Reference changeMode(int n) {
        if (n == this._mode) {
            return this;
        }
        Reference reference = this._instance.referenceFactory().copy(this);
        reference._mode = n;
        return reference;
    }

    public abstract Reference changeRouter(RouterPrx var1);

    public abstract Reference changeLocator(LocatorPrx var1);

    public abstract Reference changeTimeout(int var1);

    public synchronized int hashCode() {
        int n;
        if (this._hashInitialized) {
            return this._hashValue;
        }
        int n2 = this._mode;
        int n3 = this._identity.name.length();
        for (n = 0; n < n3; ++n) {
            n2 = 5 * n2 + this._identity.name.charAt(n);
        }
        n3 = this._identity.category.length();
        for (n = 0; n < n3; ++n) {
            n2 = 5 * n2 + this._identity.category.charAt(n);
        }
        n3 = this._facet.length();
        for (n = 0; n < n3; ++n) {
            n2 = 5 * n2 + this._facet.charAt(n);
        }
        this._hashValue = n2 = 5 * n2 + (this.getSecure() ? 1 : 0);
        this._hashInitialized = true;
        return n2;
    }

    public void streamWrite(BasicStream basicStream) {
        if (this._facet.length() == 0) {
            basicStream.writeStringSeq(null);
        } else {
            String[] stringArray = new String[]{this._facet};
            basicStream.writeStringSeq(stringArray);
        }
        basicStream.writeByte((byte)this._mode);
        basicStream.writeBool(this.getSecure());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = Util.identityToString(this._identity);
        if (StringUtil.findFirstOf(string, " \t\n\r:@") != -1) {
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
        } else {
            stringBuffer.append(string);
        }
        if (this._facet.length() > 0) {
            stringBuffer.append(" -f ");
            String string2 = StringUtil.escapeString(this._facet, "");
            if (StringUtil.findFirstOf(string2, " \t\n\r:@") != -1) {
                stringBuffer.append('\"');
                stringBuffer.append(string2);
                stringBuffer.append('\"');
            } else {
                stringBuffer.append(string2);
            }
        }
        switch (this._mode) {
            case 0: {
                stringBuffer.append(" -t");
                break;
            }
            case 1: {
                stringBuffer.append(" -o");
                break;
            }
            case 2: {
                stringBuffer.append(" -O");
                break;
            }
            case 3: {
                stringBuffer.append(" -d");
                break;
            }
            case 4: {
                stringBuffer.append(" -D");
            }
        }
        if (this.getSecure()) {
            stringBuffer.append(" -s");
        }
        return stringBuffer.toString();
    }

    public abstract Connection getConnection();

    public boolean equals(Object object) {
        Reference reference = (Reference)object;
        if (this._mode != reference._mode) {
            return false;
        }
        if (this._secure != reference._secure) {
            return false;
        }
        if (!this._identity.equals(reference._identity)) {
            return false;
        }
        if (!IceUtil.Hashtable.equals(this._context, reference._context)) {
            return false;
        }
        return this._facet.equals(reference._facet);
    }

    protected void shallowCopy(Reference reference) {
        reference._instance = this._instance;
        reference._mode = this._mode;
        reference._identity = this._identity;
        reference._context = this._context;
        reference._facet = this._facet;
        reference._hashInitialized = false;
    }

    public Object ice_clone() {
        Debug.Assert(false);
        return null;
    }

    protected Reference() {
    }

    protected Reference(Instance instance, Communicator communicator, Identity identity, Hashtable hashtable, String string, int n, boolean bl) {
        this._instance = instance;
        this._communicator = communicator;
        this._mode = n;
        this._secure = bl;
        this._identity = identity;
        this._context = hashtable == null ? _emptyContext : hashtable;
        this._facet = string;
        this._hashInitialized = false;
    }

    protected Endpoint[] filterEndpoints(Endpoint[] endpointArray) {
        Vector<Endpoint> vector = new Vector<Endpoint>();
        if (this.getSecure() || this.getMode() == 3 || this.getMode() == 4) {
            FeatureNotSupportedException featureNotSupportedException = new FeatureNotSupportedException();
            if (this.getSecure()) {
                featureNotSupportedException.unsupportedFeature = "ssl";
            } else if (this.getMode() == 3) {
                featureNotSupportedException.unsupportedFeature = "datagram";
            } else if (this.getMode() == 4) {
                featureNotSupportedException.unsupportedFeature = "batch datagram";
            }
            throw featureNotSupportedException;
        }
        for (int i = 0; i < endpointArray.length; ++i) {
            if (endpointArray[i].unknown()) continue;
            vector.addElement(endpointArray[i]);
        }
        Random random = new Random();
        Endpoint[] endpointArray2 = new Endpoint[vector.size()];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            int n = Math.abs(random.nextInt() % vector.size());
            while (endpointArray2[n] != null) {
                n = Math.abs(random.nextInt() % vector.size());
            }
            endpointArray2[n] = (Endpoint)enumeration.nextElement();
        }
        return endpointArray2;
    }

    protected boolean compare(Endpoint[] endpointArray, Endpoint[] endpointArray2) {
        if (endpointArray == endpointArray2) {
            return true;
        }
        if (endpointArray.length == endpointArray2.length) {
            for (int i = 0; i < endpointArray.length; ++i) {
                if (((Object)endpointArray[i]).equals(endpointArray2[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

