/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointParseException;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.Endpoint;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceUtil.StringUtil;

final class TcpEndpoint
implements Endpoint {
    private Instance _instance;
    private String _host;
    private int _port;
    private int _timeout;
    private int _hashCode;
    private byte[] _ip;
    private boolean _parsed = false;

    public TcpEndpoint(Instance instance, String string, int n, int n2) {
        this._instance = instance;
        this._host = string;
        this._port = n;
        this._timeout = n2;
        this.calcHashValue();
    }

    public TcpEndpoint(Instance instance, String string) {
        this._instance = instance;
        this._host = null;
        this._port = 0;
        this._timeout = -1;
        String[] stringArray = StringUtil.split(string, " \t\n\r");
        int n = 0;
        block10: while (n < stringArray.length) {
            Object object;
            String string2;
            if (stringArray[n].length() == 0) {
                ++n;
                continue;
            }
            if ((string2 = stringArray[n++]).length() != 2 || string2.charAt(0) != '-') {
                object = new EndpointParseException();
                ((EndpointParseException)object).str = "tcp " + string;
                throw object;
            }
            object = null;
            if (n < stringArray.length && stringArray[n].charAt(0) != '-') {
                object = stringArray[n++];
            }
            switch (string2.charAt(1)) {
                case 'h': {
                    if (object == null) {
                        EndpointParseException endpointParseException = new EndpointParseException();
                        endpointParseException.str = "tcp " + string;
                        throw endpointParseException;
                    }
                    this._host = object;
                    continue block10;
                }
                case 'p': {
                    if (object == null) {
                        EndpointParseException endpointParseException = new EndpointParseException();
                        endpointParseException.str = "tcp " + string;
                        throw endpointParseException;
                    }
                    try {
                        this._port = Integer.parseInt((String)object);
                    }
                    catch (NumberFormatException numberFormatException) {
                        EndpointParseException endpointParseException = new EndpointParseException();
                        endpointParseException.str = "tcp " + string;
                        throw endpointParseException;
                    }
                    if (this._port >= 0 && this._port <= 65535) continue block10;
                    EndpointParseException endpointParseException = new EndpointParseException();
                    endpointParseException.str = "tcp " + string;
                    throw endpointParseException;
                }
                case 't': {
                    if (object == null) {
                        EndpointParseException endpointParseException = new EndpointParseException();
                        endpointParseException.str = "tcp " + string;
                        throw endpointParseException;
                    }
                    try {
                        this._timeout = Integer.parseInt((String)object);
                        continue block10;
                    }
                    catch (NumberFormatException numberFormatException) {
                        EndpointParseException endpointParseException = new EndpointParseException();
                        endpointParseException.str = "tcp " + string;
                        throw endpointParseException;
                    }
                }
                case 'z': {
                    continue block10;
                }
            }
            EndpointParseException endpointParseException = new EndpointParseException();
            endpointParseException.str = "tcp " + string;
            throw endpointParseException;
        }
        if (this._host == null) {
            this._host = this._instance.defaultsAndOverrides().defaultHost;
        }
        this.calcHashValue();
    }

    public TcpEndpoint(BasicStream basicStream) {
        this._instance = basicStream.instance();
        basicStream.startReadEncaps();
        this._host = basicStream.readString();
        this._port = basicStream.readInt();
        this._timeout = basicStream.readInt();
        boolean bl = basicStream.readBool();
        basicStream.endReadEncaps();
        this.calcHashValue();
    }

    public void streamWrite(BasicStream basicStream) {
        basicStream.writeShort((short)1);
        basicStream.startWriteEncaps();
        basicStream.writeString(this._host);
        basicStream.writeInt(this._port);
        basicStream.writeInt(this._timeout);
        basicStream.writeBool(false);
        basicStream.endWriteEncaps();
    }

    public String toString() {
        String string = "tcp -h " + this._host + " -p " + this._port;
        if (this._timeout != -1) {
            string = string + " -t " + this._timeout;
        }
        return string;
    }

    public int timeout() {
        return this._timeout;
    }

    public Endpoint timeout(int n) {
        if (n == this._timeout) {
            return this;
        }
        return new TcpEndpoint(this._instance, this._host, this._port, n);
    }

    public boolean unknown() {
        return false;
    }

    public Transceiver clientTransceiver() {
        return null;
    }

    public Connector connector() {
        return new Connector(this._instance, this._host, this._port);
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object object) {
        return this.compareTo(object) == 0;
    }

    public int compareTo(Object object) {
        byte[] byArray;
        TcpEndpoint tcpEndpoint = null;
        try {
            tcpEndpoint = (TcpEndpoint)object;
        }
        catch (ClassCastException classCastException) {
            return 1;
        }
        if (this == tcpEndpoint) {
            return 0;
        }
        if (this._port < tcpEndpoint._port) {
            return -1;
        }
        if (tcpEndpoint._port < this._port) {
            return 1;
        }
        if (this._timeout < tcpEndpoint._timeout) {
            return -1;
        }
        if (tcpEndpoint._timeout < this._timeout) {
            return 1;
        }
        byte[] byArray2 = this.IPAddr();
        if (byArray2 != null && (byArray = tcpEndpoint.IPAddr()) != null) {
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray2[i] < byArray[i]) {
                    return -1;
                }
                if (byArray[i] >= byArray2[i]) continue;
                return 1;
            }
        }
        return this._host.compareTo(tcpEndpoint._host);
    }

    private byte[] IPAddr() {
        if (this._ip == null && !this._parsed) {
            this._parsed = true;
            this._ip = Network.addrStringToIP(this._host);
        }
        return this._ip;
    }

    private void calcHashValue() {
        this._hashCode = this._host.hashCode();
        this._hashCode = 5 * this._hashCode + this._port;
        this._hashCode = 5 * this._hashCode + this._timeout;
    }
}

