# **********************************************************************
#
# Copyright (c) 2003-2005 ZeroC, Inc. All rights reserved.
#
# This copy of Ice is licensed to you under the terms described in the
# ICE_LICENSE file included in this distribution.
#
# **********************************************************************

# Ice version 3.1.1
# Generated from file `Observer.ice'

import Ice, IcePy, __builtin__
import Glacier2_Session_ice
import IceGrid_Exception_ice
import IceGrid_Descriptor_ice
import IceGrid_Admin_ice

# Included module Ice
_M_Ice = Ice.openModule('Ice')

# Included module Glacier2
_M_Glacier2 = Ice.openModule('Glacier2')

# Included module IceGrid
_M_IceGrid = Ice.openModule('IceGrid')

# Start of module IceGrid
__name__ = 'IceGrid'

if not _M_IceGrid.__dict__.has_key('ServerDynamicInfo'):
    _M_IceGrid.ServerDynamicInfo = Ice.createTempClass()
    class ServerDynamicInfo(object):
        def __init__(self, id='', state=_M_IceGrid.ServerState.Inactive, pid=0, enabled=False):
            self.id = id
            self.state = state
            self.pid = pid
            self.enabled = enabled

        def __hash__(self):
            _h = 0
            _h = 5 * _h + __builtin__.hash(self.id)
            _h = 5 * _h + __builtin__.hash(self.state)
            _h = 5 * _h + __builtin__.hash(self.pid)
            _h = 5 * _h + __builtin__.hash(self.enabled)
            return _h % 0x7fffffff

        def __eq__(self, other):
            if not self.id == other.id:
                return False
            if not self.state == other.state:
                return False
            if not self.pid == other.pid:
                return False
            if not self.enabled == other.enabled:
                return False
            return True

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_ServerDynamicInfo)

        __repr__ = __str__

    _M_IceGrid._t_ServerDynamicInfo = IcePy.defineStruct('::IceGrid::ServerDynamicInfo', ServerDynamicInfo, (
        ("id", IcePy._t_string),
        ("state", _M_IceGrid._t_ServerState),
        ("pid", IcePy._t_int),
        ("enabled", IcePy._t_bool)
    ))

    _M_IceGrid.ServerDynamicInfo = ServerDynamicInfo
    del ServerDynamicInfo

if not _M_IceGrid.__dict__.has_key('_t_ServerDynamicInfoSeq'):
    _M_IceGrid._t_ServerDynamicInfoSeq = IcePy.defineSequence('::IceGrid::ServerDynamicInfoSeq', _M_IceGrid._t_ServerDynamicInfo)

if not _M_IceGrid.__dict__.has_key('AdapterDynamicInfo'):
    _M_IceGrid.AdapterDynamicInfo = Ice.createTempClass()
    class AdapterDynamicInfo(object):
        def __init__(self, id='', proxy=None):
            self.id = id
            self.proxy = proxy

        def __hash__(self):
            _h = 0
            _h = 5 * _h + __builtin__.hash(self.id)
            _h = 5 * _h + __builtin__.hash(self.proxy)
            return _h % 0x7fffffff

        def __eq__(self, other):
            if not self.id == other.id:
                return False
            if not self.proxy == other.proxy:
                return False
            return True

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_AdapterDynamicInfo)

        __repr__ = __str__

    _M_IceGrid._t_AdapterDynamicInfo = IcePy.defineStruct('::IceGrid::AdapterDynamicInfo', AdapterDynamicInfo, (
        ("id", IcePy._t_string),
        ("proxy", IcePy._t_ObjectPrx)
    ))

    _M_IceGrid.AdapterDynamicInfo = AdapterDynamicInfo
    del AdapterDynamicInfo

if not _M_IceGrid.__dict__.has_key('_t_AdapterDynamicInfoSeq'):
    _M_IceGrid._t_AdapterDynamicInfoSeq = IcePy.defineSequence('::IceGrid::AdapterDynamicInfoSeq', _M_IceGrid._t_AdapterDynamicInfo)

if not _M_IceGrid.__dict__.has_key('NodeDynamicInfo'):
    _M_IceGrid.NodeDynamicInfo = Ice.createTempClass()
    class NodeDynamicInfo(object):
        def __init__(self, name='', info=_M_IceGrid.NodeInfo(), servers=None, adapters=None):
            self.name = name
            self.info = info
            self.servers = servers
            self.adapters = adapters

        def __hash__(self):
            _h = 0
            _h = 5 * _h + __builtin__.hash(self.name)
            _h = 5 * _h + __builtin__.hash(self.info)
            if self.servers:
                for _i0 in self.servers:
                    _h = 5 * _h + __builtin__.hash(_i0)
            if self.adapters:
                for _i1 in self.adapters:
                    _h = 5 * _h + __builtin__.hash(_i1)
            return _h % 0x7fffffff

        def __eq__(self, other):
            if not self.name == other.name:
                return False
            if not self.info == other.info:
                return False
            if not self.servers == other.servers:
                return False
            if not self.adapters == other.adapters:
                return False
            return True

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_NodeDynamicInfo)

        __repr__ = __str__

    _M_IceGrid._t_NodeDynamicInfo = IcePy.defineStruct('::IceGrid::NodeDynamicInfo', NodeDynamicInfo, (
        ("name", IcePy._t_string),
        ("info", _M_IceGrid._t_NodeInfo),
        ("servers", _M_IceGrid._t_ServerDynamicInfoSeq),
        ("adapters", _M_IceGrid._t_AdapterDynamicInfoSeq)
    ))

    _M_IceGrid.NodeDynamicInfo = NodeDynamicInfo
    del NodeDynamicInfo

if not _M_IceGrid.__dict__.has_key('_t_NodeDynamicInfoSeq'):
    _M_IceGrid._t_NodeDynamicInfoSeq = IcePy.defineSequence('::IceGrid::NodeDynamicInfoSeq', _M_IceGrid._t_NodeDynamicInfo)

if not _M_IceGrid.__dict__.has_key('NodeObserver'):
    _M_IceGrid.NodeObserver = Ice.createTempClass()
    class NodeObserver(Ice.Object):
        def __init__(self):
            if __builtin__.type(self) == _M_IceGrid.NodeObserver:
                raise RuntimeError('IceGrid.NodeObserver is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::NodeObserver')

        def ice_id(self, current=None):
            return '::IceGrid::NodeObserver'

        #
        # Operation signatures.
        #
        # def init(self, nodes, current=None):
        # def nodeUp(self, node, current=None):
        # def nodeDown(self, name, current=None):
        # def updateServer(self, node, updatedInfo, current=None):
        # def updateAdapter(self, node, updatedInfo, current=None):

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_NodeObserver)

        __repr__ = __str__

    _M_IceGrid.NodeObserverPrx = Ice.createTempClass()
    class NodeObserverPrx(Ice.ObjectPrx):

        def init(self, nodes, _ctx=None):
            return _M_IceGrid.NodeObserver._op_init.invoke(self, (nodes, ), _ctx)

        def init_async(self, _cb, nodes, _ctx=None):
            return _M_IceGrid.NodeObserver._op_init.invokeAsync(self, _cb, (nodes, ), _ctx)

        def nodeUp(self, node, _ctx=None):
            return _M_IceGrid.NodeObserver._op_nodeUp.invoke(self, (node, ), _ctx)

        def nodeDown(self, name, _ctx=None):
            return _M_IceGrid.NodeObserver._op_nodeDown.invoke(self, (name, ), _ctx)

        def updateServer(self, node, updatedInfo, _ctx=None):
            return _M_IceGrid.NodeObserver._op_updateServer.invoke(self, (node, updatedInfo), _ctx)

        def updateAdapter(self, node, updatedInfo, _ctx=None):
            return _M_IceGrid.NodeObserver._op_updateAdapter.invoke(self, (node, updatedInfo), _ctx)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.NodeObserverPrx.ice_checkedCast(proxy, '::IceGrid::NodeObserver', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=''):
            return _M_IceGrid.NodeObserverPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

    _M_IceGrid._t_NodeObserverPrx = IcePy.defineProxy('::IceGrid::NodeObserver', NodeObserverPrx)

    _M_IceGrid._t_NodeObserver = IcePy.defineClass('::IceGrid::NodeObserver', NodeObserver, True, None, (), ())
    NodeObserver.ice_type = _M_IceGrid._t_NodeObserver

    NodeObserver._op_init = IcePy.Operation('init', Ice.OperationMode.Normal, False, (_M_IceGrid._t_NodeDynamicInfoSeq,), (), None, ())
    NodeObserver._op_nodeUp = IcePy.Operation('nodeUp', Ice.OperationMode.Normal, False, (_M_IceGrid._t_NodeDynamicInfo,), (), None, ())
    NodeObserver._op_nodeDown = IcePy.Operation('nodeDown', Ice.OperationMode.Normal, False, (IcePy._t_string,), (), None, ())
    NodeObserver._op_updateServer = IcePy.Operation('updateServer', Ice.OperationMode.Normal, False, (IcePy._t_string, _M_IceGrid._t_ServerDynamicInfo), (), None, ())
    NodeObserver._op_updateAdapter = IcePy.Operation('updateAdapter', Ice.OperationMode.Normal, False, (IcePy._t_string, _M_IceGrid._t_AdapterDynamicInfo), (), None, ())

    _M_IceGrid.NodeObserver = NodeObserver
    del NodeObserver

    _M_IceGrid.NodeObserverPrx = NodeObserverPrx
    del NodeObserverPrx

if not _M_IceGrid.__dict__.has_key('RegistryObserver'):
    _M_IceGrid.RegistryObserver = Ice.createTempClass()
    class RegistryObserver(Ice.Object):
        def __init__(self):
            if __builtin__.type(self) == _M_IceGrid.RegistryObserver:
                raise RuntimeError('IceGrid.RegistryObserver is an abstract class')

        def ice_ids(self, current=None):
            return ('::Ice::Object', '::IceGrid::RegistryObserver')

        def ice_id(self, current=None):
            return '::IceGrid::RegistryObserver'

        #
        # Operation signatures.
        #
        # def init(self, serial, applications, adpts, objects, current=None):
        # def applicationAdded(self, serial, desc, current=None):
        # def applicationRemoved(self, serial, name, current=None):
        # def applicationUpdated(self, serial, desc, current=None):
        # def adapterAdded(self, serial, info, current=None):
        # def adapterUpdated(self, serial, info, current=None):
        # def adapterRemoved(self, serial, id, current=None):
        # def objectAdded(self, serial, info, current=None):
        # def objectUpdated(self, serial, info, current=None):
        # def objectRemoved(self, serial, id, current=None):

        def __str__(self):
            return IcePy.stringify(self, _M_IceGrid._t_RegistryObserver)

        __repr__ = __str__

    _M_IceGrid.RegistryObserverPrx = Ice.createTempClass()
    class RegistryObserverPrx(Ice.ObjectPrx):

        def init(self, serial, applications, adpts, objects, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_init.invoke(self, (serial, applications, adpts, objects), _ctx)

        def init_async(self, _cb, serial, applications, adpts, objects, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_init.invokeAsync(self, _cb, (serial, applications, adpts, objects), _ctx)

        def applicationAdded(self, serial, desc, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_applicationAdded.invoke(self, (serial, desc), _ctx)

        def applicationRemoved(self, serial, name, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_applicationRemoved.invoke(self, (serial, name), _ctx)

        def applicationUpdated(self, serial, desc, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_applicationUpdated.invoke(self, (serial, desc), _ctx)

        def adapterAdded(self, serial, info, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_adapterAdded.invoke(self, (serial, info), _ctx)

        def adapterUpdated(self, serial, info, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_adapterUpdated.invoke(self, (serial, info), _ctx)

        def adapterRemoved(self, serial, id, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_adapterRemoved.invoke(self, (serial, id), _ctx)

        def objectAdded(self, serial, info, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_objectAdded.invoke(self, (serial, info), _ctx)

        def objectUpdated(self, serial, info, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_objectUpdated.invoke(self, (serial, info), _ctx)

        def objectRemoved(self, serial, id, _ctx=None):
            return _M_IceGrid.RegistryObserver._op_objectRemoved.invoke(self, (serial, id), _ctx)

        def checkedCast(proxy, facetOrCtx=None, _ctx=None):
            return _M_IceGrid.RegistryObserverPrx.ice_checkedCast(proxy, '::IceGrid::RegistryObserver', facetOrCtx, _ctx)
        checkedCast = staticmethod(checkedCast)

        def uncheckedCast(proxy, facet=''):
            return _M_IceGrid.RegistryObserverPrx.ice_uncheckedCast(proxy, facet)
        uncheckedCast = staticmethod(uncheckedCast)

    _M_IceGrid._t_RegistryObserverPrx = IcePy.defineProxy('::IceGrid::RegistryObserver', RegistryObserverPrx)

    _M_IceGrid._t_RegistryObserver = IcePy.defineClass('::IceGrid::RegistryObserver', RegistryObserver, True, None, (), ())
    RegistryObserver.ice_type = _M_IceGrid._t_RegistryObserver

    RegistryObserver._op_init = IcePy.Operation('init', Ice.OperationMode.Normal, False, (IcePy._t_int, _M_IceGrid._t_ApplicationDescriptorSeq, _M_IceGrid._t_AdapterInfoSeq, _M_IceGrid._t_ObjectInfoSeq), (), None, ())
    RegistryObserver._op_applicationAdded = IcePy.Operation('applicationAdded', Ice.OperationMode.Normal, False, (IcePy._t_int, _M_IceGrid._t_ApplicationDescriptor), (), None, ())
    RegistryObserver._op_applicationRemoved = IcePy.Operation('applicationRemoved', Ice.OperationMode.Normal, False, (IcePy._t_int, IcePy._t_string), (), None, ())
    RegistryObserver._op_applicationUpdated = IcePy.Operation('applicationUpdated', Ice.OperationMode.Normal, False, (IcePy._t_int, _M_IceGrid._t_ApplicationUpdateDescriptor), (), None, ())
    RegistryObserver._op_adapterAdded = IcePy.Operation('adapterAdded', Ice.OperationMode.Normal, False, (IcePy._t_int, _M_IceGrid._t_AdapterInfo), (), None, ())
    RegistryObserver._op_adapterUpdated = IcePy.Operation('adapterUpdated', Ice.OperationMode.Normal, False, (IcePy._t_int, _M_IceGrid._t_AdapterInfo), (), None, ())
    RegistryObserver._op_adapterRemoved = IcePy.Operation('adapterRemoved', Ice.OperationMode.Normal, False, (IcePy._t_int, IcePy._t_string), (), None, ())
    RegistryObserver._op_objectAdded = IcePy.Operation('objectAdded', Ice.OperationMode.Normal, False, (IcePy._t_int, _M_IceGrid._t_ObjectInfo), (), None, ())
    RegistryObserver._op_objectUpdated = IcePy.Operation('objectUpdated', Ice.OperationMode.Normal, False, (IcePy._t_int, _M_IceGrid._t_ObjectInfo), (), None, ())
    RegistryObserver._op_objectRemoved = IcePy.Operation('objectRemoved', Ice.OperationMode.Normal, False, (IcePy._t_int, _M_Ice._t_Identity), (), None, ())

    _M_IceGrid.RegistryObserver = RegistryObserver
    del RegistryObserver

    _M_IceGrid.RegistryObserverPrx = RegistryObserverPrx
    del RegistryObserverPrx

# End of module IceGrid

Ice.sliceChecksums["::IceGrid::AdapterDynamicInfo"] = "b371e9a58f115e6ebfbcda735fee57f7"
Ice.sliceChecksums["::IceGrid::AdapterDynamicInfoSeq"] = "54465843167a2f93fa96d13b7f41ea32"
Ice.sliceChecksums["::IceGrid::NodeDynamicInfo"] = "8ebccc05aebaf7f307269d121bceb6a"
Ice.sliceChecksums["::IceGrid::NodeDynamicInfoSeq"] = "f61633c5e3992f718dba78b7f165c2"
Ice.sliceChecksums["::IceGrid::NodeObserver"] = "be913410ec8dddf8b7388c65333c67"
Ice.sliceChecksums["::IceGrid::RegistryObserver"] = "d2a4bf819f4e8821257f56d083dffc7"
Ice.sliceChecksums["::IceGrid::ServerDynamicInfo"] = "fd4b9177ca54ae4688b51fa51d6870"
Ice.sliceChecksums["::IceGrid::ServerDynamicInfoSeq"] = "e3fda58997d5cd946e78cae739174cb"
