/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.EndpointSelectionType;
import Ice.Identity;
import Ice.LocalException;
import Ice.NoEndpointException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.RouterPrx;
import IceInternal.EndpointI;
import IceInternal.Instance;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;

public abstract class RoutableReference
extends Reference {
    private static EndpointComparator _endpointComparator;
    private boolean _secure;
    private RouterInfo _routerInfo;
    private boolean _collocationOptimization;
    private boolean _cacheConnection;
    private EndpointSelectionType _endpointSelection;
    private String _connectionId = "";
    private boolean _overrideCompress;
    private boolean _compress;
    private boolean _overrideTimeout;
    private int _timeout;
    static final /* synthetic */ boolean $assertionsDisabled;

    public final RouterInfo getRouterInfo() {
        return this._routerInfo;
    }

    public final EndpointI[] getRoutedEndpoints() {
        if (this._routerInfo != null) {
            ObjectPrx clientProxy = this._routerInfo.getClientProxy();
            return ((ObjectPrxHelperBase)clientProxy).__reference().getEndpoints();
        }
        return new EndpointI[0];
    }

    public final boolean getSecure() {
        return this._secure;
    }

    public final boolean getCollocationOptimization() {
        return this._collocationOptimization;
    }

    public final boolean getCacheConnection() {
        return this._cacheConnection;
    }

    public final EndpointSelectionType getEndpointSelection() {
        return this._endpointSelection;
    }

    public Reference changeSecure(boolean newSecure) {
        if (newSecure == this._secure) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._secure = newSecure;
        return r;
    }

    public Reference changeRouter(RouterPrx newRouter) {
        RouterInfo newRouterInfo = this.getInstance().routerManager().get(newRouter);
        if (newRouterInfo != null && this._routerInfo != null && newRouterInfo.equals(this._routerInfo)) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._routerInfo = newRouterInfo;
        return r;
    }

    public Reference changeCollocationOptimization(boolean newCollocationOptimization) {
        if (newCollocationOptimization == this._collocationOptimization) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._collocationOptimization = newCollocationOptimization;
        return r;
    }

    public final Reference changeCacheConnection(boolean newCache) {
        if (newCache == this._cacheConnection) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._cacheConnection = newCache;
        return r;
    }

    public final Reference changeEndpointSelection(EndpointSelectionType newType) {
        if (newType == this._endpointSelection) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._endpointSelection = newType;
        return r;
    }

    public Reference changeCompress(boolean newCompress) {
        if (this._overrideCompress && this._compress == newCompress) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._compress = newCompress;
        r._overrideCompress = true;
        return r;
    }

    public Reference changeTimeout(int newTimeout) {
        if (this._overrideTimeout && this._timeout == newTimeout) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._timeout = newTimeout;
        r._overrideTimeout = true;
        return r;
    }

    public Reference changeConnectionId(String id) {
        if (this._connectionId.equals(id)) {
            return this;
        }
        RoutableReference r = (RoutableReference)this.getInstance().referenceFactory().copy(this);
        r._connectionId = id;
        return r;
    }

    public synchronized int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        RoutableReference rhs = (RoutableReference)obj;
        if (this._secure != rhs._secure) {
            return false;
        }
        if (this._collocationOptimization != rhs._collocationOptimization) {
            return false;
        }
        if (this._cacheConnection != rhs._cacheConnection) {
            return false;
        }
        if (this._endpointSelection != rhs._endpointSelection) {
            return false;
        }
        if (!this._connectionId.equals(rhs._connectionId)) {
            return false;
        }
        if (this._overrideCompress != rhs._overrideCompress) {
            return false;
        }
        if (this._overrideCompress && this._compress != rhs._compress) {
            return false;
        }
        if (this._overrideTimeout != rhs._overrideTimeout) {
            return false;
        }
        if (this._overrideTimeout && this._timeout != rhs._timeout) {
            return false;
        }
        return this._routerInfo == null ? rhs._routerInfo == null : this._routerInfo.equals(rhs._routerInfo);
    }

    protected RoutableReference(Instance inst, Communicator com, Identity ident, Map ctx, String fac, int md, boolean sec, RouterInfo rtrInfo, boolean collocationOpt) {
        super(inst, com, ident, ctx, fac, md);
        this._secure = sec;
        this._routerInfo = rtrInfo;
        this._collocationOptimization = collocationOpt;
        this._cacheConnection = true;
        this._endpointSelection = EndpointSelectionType.Random;
        this._overrideCompress = false;
        this._compress = false;
        this._overrideTimeout = false;
        this._timeout = -1;
    }

    protected void applyOverrides(EndpointI[] endpts) {
        for (int i = 0; i < endpts.length; ++i) {
            endpts[i] = endpts[i].connectionId(this._connectionId);
            if (this._overrideCompress) {
                endpts[i] = endpts[i].compress(this._compress);
            }
            if (!this._overrideTimeout) continue;
            endpts[i] = endpts[i].timeout(this._timeout);
        }
    }

    protected ConnectionI createConnection(EndpointI[] allEndpoints, BooleanHolder compress) {
        EndpointI endpoint;
        ArrayList<EndpointI> endpoints = new ArrayList<EndpointI>();
        for (int i = 0; i < allEndpoints.length; ++i) {
            if (allEndpoints[i].unknown()) continue;
            endpoints.add(allEndpoints[i]);
        }
        switch (this.getMode()) {
            case 0: 
            case 1: 
            case 2: {
                Iterator i = endpoints.iterator();
                while (i.hasNext()) {
                    endpoint = (EndpointI)i.next();
                    if (!endpoint.datagram()) continue;
                    i.remove();
                }
                break;
            }
            case 3: 
            case 4: {
                Iterator i = endpoints.iterator();
                while (i.hasNext()) {
                    endpoint = (EndpointI)i.next();
                    if (endpoint.datagram()) continue;
                    i.remove();
                }
                break;
            }
        }
        switch (this.getEndpointSelection().value()) {
            case 0: {
                Collections.shuffle(endpoints);
                break;
            }
            case 1: {
                break;
            }
            default: {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                break;
            }
        }
        if (this.getSecure()) {
            Iterator i = endpoints.iterator();
            while (i.hasNext()) {
                endpoint = (EndpointI)i.next();
                if (endpoint.secure()) continue;
                i.remove();
            }
        } else {
            Collections.sort(endpoints, _endpointComparator);
        }
        if (endpoints.size() == 0) {
            NoEndpointException ex = new NoEndpointException();
            ex.proxy = this.toString();
            throw ex;
        }
        OutgoingConnectionFactory factory = this.getInstance().outgoingConnectionFactory();
        if (this.getCacheConnection() || endpoints.size() == 1) {
            return factory.create(endpoints.toArray(new EndpointI[endpoints.size()]), false, compress);
        }
        LocalException exception = null;
        EndpointI[] endpoint2 = new EndpointI[1];
        Iterator i = endpoints.iterator();
        while (i.hasNext()) {
            try {
                endpoint2[0] = (EndpointI)i.next();
                return factory.create(endpoint2, i.hasNext(), compress);
            }
            catch (LocalException ex) {
                exception = ex;
            }
        }
        if (!$assertionsDisabled && exception == null) {
            throw new AssertionError();
        }
        throw exception;
    }

    static {
        $assertionsDisabled = !RoutableReference.class.desiredAssertionStatus();
        _endpointComparator = new EndpointComparator();
    }

    static class EndpointComparator
    implements Comparator {
        EndpointComparator() {
        }

        public int compare(Object l, Object r) {
            EndpointI le = (EndpointI)l;
            EndpointI re = (EndpointI)r;
            boolean ls = le.secure();
            boolean rs = re.secure();
            if (ls && rs || !ls && !rs) {
                return 0;
            }
            if (!ls && rs) {
                return -1;
            }
            return 1;
        }
    }
}

