/*
 * Decompiled with CFR 0.152.
 */
package Freeze;

import Freeze.DatabaseException;
import Freeze.NotFoundException;
import Freeze.SharedDb;
import Ice.Communicator;
import Ice.Properties;
import com.sleepycat.db.CheckpointConfig;
import com.sleepycat.db.Environment;
import com.sleepycat.db.EnvironmentConfig;
import com.sleepycat.db.ErrorHandler;
import com.sleepycat.db.LockDetectMode;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

class SharedDbEnv
implements ErrorHandler,
Runnable {
    private MapKey _key;
    private Environment _dbEnv;
    private boolean _ownDbEnv;
    private SharedDb _catalog;
    private int _refCount = 0;
    private boolean _done = false;
    private int _trace = 0;
    private long _checkpointPeriod = 0L;
    private int _kbyte = 0;
    private Thread _thread;
    private static Map _map;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedDbEnv get(Communicator communicator, String envName, Environment dbEnv) {
        SharedDbEnv result;
        MapKey key = new MapKey(envName, communicator);
        Map map = _map;
        synchronized (map) {
            result = (SharedDbEnv)_map.get(key);
            if (result == null) {
                try {
                    result = new SharedDbEnv(key, dbEnv);
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = SharedDbEnv.errorPrefix(envName) + "creation: " + dx.getMessage();
                    throw ex;
                }
                SharedDbEnv previousValue = _map.put(key, result);
                if (!$assertionsDisabled && previousValue != null) {
                    throw new AssertionError();
                }
            } else {
                ++result._refCount;
            }
        }
        result.init();
        return result;
    }

    public String getEnvName() {
        return this._key.envName;
    }

    public Communicator getCommunicator() {
        return this._key.communicator;
    }

    public Environment getEnv() {
        return this._dbEnv;
    }

    public SharedDb getCatalog() {
        return this._catalog;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Map map = _map;
        synchronized (map) {
            if (--this._refCount == 0) {
                Object value = _map.remove(this._key);
                if (!$assertionsDisabled && value != this) {
                    throw new AssertionError();
                }
                SharedDbEnv sharedDbEnv = this;
                synchronized (sharedDbEnv) {
                    this._done = true;
                    this.notify();
                }
                while (true) {
                    if (this._thread == null) {
                        continue;
                    }
                    try {
                        this._thread.join();
                        this._thread = null;
                    }
                    catch (InterruptedException ex) {
                        continue;
                    }
                    break;
                }
                if (this._catalog != null) {
                    this._catalog.close();
                    this._catalog = null;
                }
                if (this._trace >= 1) {
                    this._key.communicator.getLogger().trace("Freeze.DbEnv", "closing database environment \"" + this._key.envName + "\"");
                }
                try {
                    this._dbEnv.close();
                }
                catch (com.sleepycat.db.DatabaseException dx) {
                    DatabaseException ex = new DatabaseException();
                    ex.initCause(dx);
                    ex.message = SharedDbEnv.errorPrefix(this._key.envName) + "close: " + dx.getMessage();
                    throw ex;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            SharedDbEnv sharedDbEnv = this;
            synchronized (sharedDbEnv) {
                while (!this._done) {
                    try {
                        this.wait(this._checkpointPeriod);
                        break;
                    }
                    catch (InterruptedException ex) {
                    }
                }
                if (this._done) {
                    return;
                }
            }
            if (this._trace >= 2) {
                this._key.communicator.getLogger().trace("Freeze.DbEnv", "checkpointing environment \"" + this._key.envName + "\"");
            }
            try {
                CheckpointConfig config = new CheckpointConfig();
                config.setKBytes(this._kbyte);
                this._dbEnv.checkpoint(config);
                continue;
            }
            catch (com.sleepycat.db.DatabaseException dx) {
                this._key.communicator.getLogger().warning("checkpoint on DbEnv \"" + this._key.envName + "\" raised DbException: " + dx.getMessage());
                continue;
            }
            break;
        }
    }

    public void error(Environment env, String errorPrefix, String message) {
        this._key.communicator.getLogger().error("Freeze database error in DbEnv \"" + this._key.envName + "\": " + message);
    }

    protected void finalize() {
        if (!$assertionsDisabled && this._refCount != 0) {
            throw new AssertionError();
        }
    }

    private SharedDbEnv(MapKey key, Environment dbEnv) throws com.sleepycat.db.DatabaseException {
        this._key = key;
        this._dbEnv = dbEnv;
        this._ownDbEnv = dbEnv == null;
        Properties properties = key.communicator.getProperties();
        this._trace = properties.getPropertyAsInt("Freeze.Trace.DbEnv");
        if (this._ownDbEnv) {
            EnvironmentConfig config = new EnvironmentConfig();
            config.setErrorHandler((ErrorHandler)this);
            config.setInitializeLocking(true);
            config.setInitializeLogging(true);
            config.setInitializeCache(true);
            config.setAllowCreate(true);
            config.setTransactional(true);
            config.setLockDetectMode(LockDetectMode.YOUNGEST);
            String propertyPrefix = "Freeze.DbEnv." + this._key.envName;
            if (properties.getPropertyAsInt(propertyPrefix + ".DbRecoverFatal") != 0) {
                config.setRunFatalRecovery(true);
            } else {
                config.setRunRecovery(true);
            }
            if (properties.getPropertyAsIntWithDefault(propertyPrefix + ".DbPrivate", 1) != 0) {
                config.setPrivate(true);
            }
            if (properties.getPropertyAsIntWithDefault(propertyPrefix + ".OldLogsAutoDelete", 1) != 0) {
                config.setLogAutoRemove(true);
            }
            if (this._trace >= 1) {
                this._key.communicator.getLogger().trace("Freeze.DbEnv", "opening database environment \"" + this._key.envName + "\"");
            }
            try {
                String dbHome = properties.getPropertyWithDefault(propertyPrefix + ".DbHome", this._key.envName);
                File home = new File(dbHome);
                this._dbEnv = new Environment(home, config);
            }
            catch (FileNotFoundException dx) {
                NotFoundException ex = new NotFoundException();
                ex.initCause(dx);
                ex.message = SharedDbEnv.errorPrefix(this._key.envName) + "open: " + dx.getMessage();
                throw ex;
            }
            this._checkpointPeriod = properties.getPropertyAsIntWithDefault(propertyPrefix + ".CheckpointPeriod", 120) * 1000;
            this._kbyte = properties.getPropertyAsIntWithDefault(propertyPrefix + ".PeriodicCheckpointMinSize", 0);
            String programName = properties.getProperty("Ice.ProgramName");
            String threadName = programName.length() > 0 ? programName + "-" : "";
            threadName = threadName + "FreezeCheckpointThread(" + this._key.envName + ")";
            if (this._checkpointPeriod > 0L) {
                this._thread = new Thread((Runnable)this, threadName);
                this._thread.start();
            }
        }
        this._refCount = 1;
    }

    private synchronized void init() {
        if (this._catalog == null) {
            this._catalog = SharedDb.openCatalog(this);
        }
    }

    private static String errorPrefix(String envName) {
        return "DbEnv(\"" + envName + "\"): ";
    }

    static {
        $assertionsDisabled = !SharedDbEnv.class.desiredAssertionStatus();
        _map = new HashMap();
    }

    private static class MapKey {
        final String envName;
        final Communicator communicator;

        MapKey(String envName, Communicator communicator) {
            this.envName = envName;
            this.communicator = communicator;
        }

        public boolean equals(Object o) {
            try {
                MapKey k = (MapKey)o;
                return this.communicator == k.communicator && this.envName.equals(k.envName);
            }
            catch (ClassCastException ex) {
                this.communicator.getLogger().trace("Freeze.DbEnv", "equals cast failed");
                return false;
            }
        }

        public int hashCode() {
            return this.envName.hashCode() ^ this.communicator.hashCode();
        }
    }
}

