/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.DNSException;
import Ice.EndpointParseException;
import Ice.UnsupportedEncodingException;
import Ice.UnsupportedProtocolException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.Connector;
import IceInternal.EndpointI;
import IceInternal.EndpointIHolder;
import IceInternal.Instance;
import IceInternal.Network;
import IceInternal.Transceiver;
import IceInternal.UdpTransceiver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Iterator;

final class UdpEndpointI
extends EndpointI {
    private Instance _instance;
    private String _host;
    private int _port;
    private byte _protocolMajor;
    private byte _protocolMinor;
    private byte _encodingMajor;
    private byte _encodingMinor;
    private boolean _connect;
    private String _connectionId = "";
    private boolean _compress;
    private boolean _publish;
    private int _hashCode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public UdpEndpointI(Instance instance, String ho, int po, boolean conn, String conId, boolean co, boolean pub) {
        this._instance = instance;
        this._host = ho;
        this._port = po;
        this._protocolMajor = 1;
        this._protocolMinor = 0;
        this._encodingMajor = 1;
        this._encodingMinor = 0;
        this._connect = conn;
        this._connectionId = conId;
        this._compress = co;
        this._publish = pub;
        this.calcHashValue();
    }

    public UdpEndpointI(Instance instance, String str) {
        this._instance = instance;
        this._host = null;
        this._port = 0;
        this._protocolMajor = 1;
        this._protocolMinor = 0;
        this._encodingMajor = 1;
        this._encodingMinor = 0;
        this._connect = false;
        this._compress = false;
        this._publish = true;
        String[] arr = str.split("[ \t\n\r]+");
        int i = 0;
        block14: while (i < arr.length) {
            String option;
            if (arr[i].length() == 0) {
                ++i;
                continue;
            }
            if ((option = arr[i++]).length() != 2 || option.charAt(0) != '-') {
                throw new EndpointParseException("udp " + str);
            }
            String argument = null;
            if (i < arr.length && arr[i].charAt(0) != '-') {
                argument = arr[i++];
            }
            switch (option.charAt(1)) {
                case 'v': {
                    int minVersion;
                    int majVersion;
                    if (argument == null) {
                        throw new EndpointParseException("udp " + str);
                    }
                    int pos = argument.indexOf(46);
                    if (pos == -1) {
                        throw new EndpointParseException("udp " + str);
                    }
                    String majStr = argument.substring(0, pos);
                    String minStr = argument.substring(pos + 1, argument.length());
                    try {
                        majVersion = Integer.parseInt(majStr);
                        minVersion = Integer.parseInt(minStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("udp " + str);
                    }
                    if (majVersion < 1 || majVersion > 255 || minVersion < 0 || minVersion > 255) {
                        throw new EndpointParseException("udp " + str);
                    }
                    if (majVersion != 1) {
                        UnsupportedProtocolException e = new UnsupportedProtocolException();
                        e.badMajor = majVersion < 0 ? majVersion + 255 : majVersion;
                        e.badMinor = minVersion < 0 ? minVersion + 255 : minVersion;
                        e.major = 1;
                        e.minor = 0;
                        throw e;
                    }
                    this._protocolMajor = (byte)majVersion;
                    this._protocolMinor = (byte)minVersion;
                    continue block14;
                }
                case 'e': {
                    int minVersion;
                    int majVersion;
                    if (argument == null) {
                        throw new EndpointParseException("udp " + str);
                    }
                    int pos = argument.indexOf(46);
                    if (pos == -1) {
                        throw new EndpointParseException("udp " + str);
                    }
                    String majStr = argument.substring(0, pos);
                    String minStr = argument.substring(pos + 1, argument.length());
                    try {
                        majVersion = Integer.parseInt(majStr);
                        minVersion = Integer.parseInt(minStr);
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("udp " + str);
                    }
                    if (majVersion < 1 || majVersion > 255 || minVersion < 0 || minVersion > 255) {
                        throw new EndpointParseException("udp " + str);
                    }
                    if (majVersion != 1) {
                        UnsupportedEncodingException e = new UnsupportedEncodingException();
                        e.badMajor = majVersion < 0 ? majVersion + 255 : majVersion;
                        e.badMinor = minVersion < 0 ? minVersion + 255 : minVersion;
                        e.major = 1;
                        e.minor = 0;
                        throw e;
                    }
                    this._encodingMajor = (byte)majVersion;
                    this._encodingMinor = (byte)minVersion;
                    continue block14;
                }
                case 'h': {
                    if (argument == null) {
                        throw new EndpointParseException("udp " + str);
                    }
                    this._host = argument;
                    continue block14;
                }
                case 'p': {
                    if (argument == null) {
                        throw new EndpointParseException("udp " + str);
                    }
                    try {
                        this._port = Integer.parseInt(argument);
                    }
                    catch (NumberFormatException ex) {
                        throw new EndpointParseException("udp " + str);
                    }
                    if (this._port >= 0 && this._port <= 65535) continue block14;
                    throw new EndpointParseException("udp " + str);
                }
                case 'c': {
                    if (argument != null) {
                        throw new EndpointParseException("udp " + str);
                    }
                    this._connect = true;
                    continue block14;
                }
                case 'z': {
                    if (argument != null) {
                        throw new EndpointParseException("udp " + str);
                    }
                    this._compress = true;
                    continue block14;
                }
            }
            throw new EndpointParseException("udp " + str);
        }
        if (this._host == null) {
            this._host = instance.defaultsAndOverrides().defaultHost;
            if (this._host == null) {
                this._host = "0.0.0.0";
            }
        } else if (this._host.equals("*")) {
            this._host = "0.0.0.0";
        }
        this.calcHashValue();
    }

    public UdpEndpointI(BasicStream s) {
        this._instance = s.instance();
        s.startReadEncaps();
        this._host = s.readString();
        this._port = s.readInt();
        this._protocolMajor = s.readByte();
        this._protocolMinor = s.readByte();
        this._encodingMajor = s.readByte();
        this._encodingMinor = s.readByte();
        if (this._protocolMajor != 1) {
            UnsupportedProtocolException e = new UnsupportedProtocolException();
            e.badMajor = this._protocolMajor < 0 ? this._protocolMajor + 255 : this._protocolMajor;
            e.badMinor = this._protocolMinor < 0 ? this._protocolMinor + 255 : this._protocolMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        if (this._encodingMajor != 1) {
            UnsupportedEncodingException e = new UnsupportedEncodingException();
            e.badMajor = this._encodingMajor < 0 ? this._encodingMajor + 255 : this._encodingMajor;
            e.badMinor = this._encodingMinor < 0 ? this._encodingMinor + 255 : this._encodingMinor;
            e.major = 1;
            e.minor = 0;
            throw e;
        }
        this._connect = false;
        this._compress = s.readBool();
        s.endReadEncaps();
        this._publish = true;
        this.calcHashValue();
    }

    public void streamWrite(BasicStream s) {
        s.writeShort((short)3);
        s.startWriteEncaps();
        s.writeString(this._host);
        s.writeInt(this._port);
        s.writeByte(this._protocolMajor);
        s.writeByte(this._protocolMinor);
        s.writeByte(this._encodingMajor);
        s.writeByte(this._encodingMinor);
        s.writeBool(this._compress);
        s.endWriteEncaps();
    }

    public String _toString() {
        String s = "udp";
        if (this._protocolMajor != 1 || this._protocolMinor != 0) {
            s = s + " -v " + (this._protocolMajor < 0 ? this._protocolMajor + 255 : this._protocolMajor) + "." + (this._protocolMinor < 0 ? this._protocolMinor + 255 : this._protocolMinor);
        }
        if (this._encodingMajor != 1 || this._encodingMinor != 0) {
            s = s + " -e " + (this._encodingMajor < 0 ? this._encodingMajor + 255 : this._encodingMajor) + "." + (this._encodingMinor < 0 ? this._encodingMinor + 255 : this._encodingMinor);
        }
        s = s + " -h " + this._host + " -p " + this._port;
        if (this._connect) {
            s = s + " -c";
        }
        if (this._compress) {
            s = s + " -z";
        }
        return s;
    }

    public int timeout() {
        return -1;
    }

    public boolean compress() {
        return this._compress;
    }

    public EndpointI compress(boolean compress) {
        if (compress == this._compress) {
            return this;
        }
        return new UdpEndpointI(this._instance, this._host, this._port, this._connect, this._connectionId, compress, this._publish);
    }

    public EndpointI connectionId(String connectionId) {
        if (connectionId == this._connectionId) {
            return this;
        }
        return new UdpEndpointI(this._instance, this._host, this._port, this._connect, connectionId, this._compress, this._publish);
    }

    public EndpointI timeout(int timeout) {
        return this;
    }

    public boolean datagram() {
        return true;
    }

    public boolean secure() {
        return false;
    }

    public boolean unknown() {
        return false;
    }

    public Transceiver clientTransceiver() {
        return new UdpTransceiver(this._instance, this._host, this._port);
    }

    public Transceiver serverTransceiver(EndpointIHolder endpoint) {
        UdpTransceiver p = new UdpTransceiver(this._instance, this._host, this._port, this._connect);
        endpoint.value = new UdpEndpointI(this._instance, this._host, p.effectivePort(), this._connect, this._connectionId, this._compress, this._publish);
        return p;
    }

    public Connector connector() {
        return null;
    }

    public Acceptor acceptor(EndpointIHolder endpoint, String adapterName) {
        endpoint.value = this;
        return null;
    }

    public ArrayList expand(boolean includeLoopback) {
        ArrayList<UdpEndpointI> endps = new ArrayList<UdpEndpointI>();
        if (this._host.equals("0.0.0.0")) {
            ArrayList hosts = Network.getLocalHosts();
            Iterator iter = hosts.iterator();
            while (iter.hasNext()) {
                String host = (String)iter.next();
                if (!includeLoopback && hosts.size() != 1 && host.equals("127.0.0.1")) continue;
                endps.add(new UdpEndpointI(this._instance, host, this._port, this._connect, this._connectionId, this._compress, hosts.size() == 1 || !host.equals("127.0.0.1")));
            }
        } else {
            endps.add(this);
        }
        return endps;
    }

    public boolean publish() {
        return this._publish;
    }

    public boolean equivalent(Transceiver transceiver) {
        UdpTransceiver udpTransceiver = null;
        try {
            udpTransceiver = (UdpTransceiver)transceiver;
        }
        catch (ClassCastException ex) {
            return false;
        }
        return udpTransceiver.equivalent(this._host, this._port);
    }

    public boolean equivalent(Acceptor acceptor) {
        return false;
    }

    public int hashCode() {
        return this._hashCode;
    }

    public boolean equals(Object obj) {
        return this.compareTo(obj) == 0;
    }

    public int compareTo(Object obj) {
        UdpEndpointI p = null;
        try {
            p = (UdpEndpointI)obj;
        }
        catch (ClassCastException ex) {
            return 1;
        }
        if (this == p) {
            return 0;
        }
        if (this._port < p._port) {
            return -1;
        }
        if (p._port < this._port) {
            return 1;
        }
        if (!this._connect && p._connect) {
            return -1;
        }
        if (!p._connect && this._connect) {
            return 1;
        }
        if (!this._connectionId.equals(p._connectionId)) {
            return this._connectionId.compareTo(p._connectionId);
        }
        if (!this._compress && p._compress) {
            return -1;
        }
        if (!p._compress && this._compress) {
            return 1;
        }
        if (this._protocolMajor < p._protocolMajor) {
            return -1;
        }
        if (p._protocolMajor < this._protocolMajor) {
            return 1;
        }
        if (this._protocolMinor < p._protocolMinor) {
            return -1;
        }
        if (p._protocolMinor < this._protocolMinor) {
            return 1;
        }
        if (this._encodingMajor < p._encodingMajor) {
            return -1;
        }
        if (p._encodingMajor < this._encodingMajor) {
            return 1;
        }
        if (this._encodingMinor < p._encodingMinor) {
            return -1;
        }
        if (p._encodingMinor < this._encodingMinor) {
            return 1;
        }
        if (!this._host.equals(p._host)) {
            InetSocketAddress laddr = null;
            try {
                laddr = Network.getAddress(this._host, this._port);
            }
            catch (DNSException ex) {
                // empty catch block
            }
            InetSocketAddress raddr = null;
            try {
                raddr = Network.getAddress(p._host, p._port);
            }
            catch (DNSException ex) {
                // empty catch block
            }
            if (laddr == null && raddr != null) {
                return -1;
            }
            if (raddr == null && laddr != null) {
                return 1;
            }
            if (laddr != null && raddr != null) {
                byte[] larr = laddr.getAddress().getAddress();
                byte[] rarr = raddr.getAddress().getAddress();
                if (!$assertionsDisabled && larr.length != rarr.length) {
                    throw new AssertionError();
                }
                for (int i = 0; i < larr.length; ++i) {
                    if (larr[i] < rarr[i]) {
                        return -1;
                    }
                    if (rarr[i] >= larr[i]) continue;
                    return 1;
                }
            }
        }
        return 0;
    }

    private void calcHashValue() {
        try {
            InetAddress addr = InetAddress.getByName(this._host);
            this._hashCode = addr.getHostAddress().hashCode();
        }
        catch (UnknownHostException ex) {
            this._hashCode = this._host.hashCode();
        }
        this._hashCode = 5 * this._hashCode + this._port;
        this._hashCode = 5 * this._hashCode + (this._connect ? 1 : 0);
        this._hashCode = 5 * this._hashCode + this._connectionId.hashCode();
        this._hashCode = 5 * this._hashCode + (this._compress ? 1 : 0);
    }

    static {
        $assertionsDisabled = !UdpEndpointI.class.desiredAssertionStatus();
    }
}

