/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.Identity;
import Ice.Util;
import IceGrid.AdapterInfo;
import IceGrid.ObjectDescriptor;
import IceGrid.ObjectInfo;
import IceGrid.PropertyDescriptor;
import IceGridGUI.Utils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

public class TableField
extends JTable {
    private DefaultTableModel _model;
    private Vector _columnNames;

    public TableField(String headKey, String headValue) {
        this._columnNames = new Vector(2);
        this._columnNames.add(headKey);
        this._columnNames.add(headValue);
        this.init();
    }

    public TableField(String headKey, String headValue1, String headValue2) {
        this._columnNames = new Vector(3);
        this._columnNames.add(headKey);
        this._columnNames.add(headValue1);
        this._columnNames.add(headValue2);
        this.init();
    }

    private void init() {
        this._model = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setModel(this._model);
        this.setCellSelectionEnabled(false);
        this.setOpaque(false);
        this.setPreferredScrollableViewportSize(this.getPreferredSize());
    }

    public void setProperties(List properties, Utils.Resolver resolver) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Iterator p = properties.iterator();
        while (p.hasNext()) {
            PropertyDescriptor pd = (PropertyDescriptor)p.next();
            map.put(resolver.substitute(pd.name), resolver.substitute(pd.value));
        }
        this.setSortedMap(map);
    }

    public void setObjects(List objects, Utils.Resolver resolver) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Iterator p = objects.iterator();
        while (p.hasNext()) {
            ObjectDescriptor od = (ObjectDescriptor)p.next();
            Identity id = new Identity(resolver.substitute(od.id.name), resolver.substitute(od.id.category));
            map.put(Util.identityToString(id), resolver.substitute(od.type));
        }
        this.setSortedMap(map);
    }

    public void setObjects(SortedMap objects) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Iterator p = objects.values().iterator();
        while (p.hasNext()) {
            ObjectInfo oi = (ObjectInfo)p.next();
            map.put(oi.proxy.toString(), oi.type);
        }
        this.setSortedMap(map);
    }

    public void setEnvs(List envs, Utils.Resolver resolver) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Iterator p = envs.iterator();
        while (p.hasNext()) {
            String env = resolver.substitute((String)p.next());
            int equal = env.indexOf(61);
            if (equal == -1 || equal == env.length() - 1) {
                map.put(env, "");
                continue;
            }
            map.put(env.substring(0, equal), env.substring(equal + 1));
        }
        this.setSortedMap(map);
    }

    public void setAdapters(SortedMap adapters) {
        Vector vector = new Vector(adapters.size());
        Iterator p = adapters.entrySet().iterator();
        while (p.hasNext()) {
            Vector<String> row = new Vector<String>(3);
            Map.Entry entry = p.next();
            row.add((String)entry.getKey());
            AdapterInfo ai = (AdapterInfo)entry.getValue();
            if (ai.proxy == null) {
                row.add("");
            } else {
                String str = ai.proxy.toString();
                int index = str.indexOf(58);
                if (index == -1 || index == str.length() - 1) {
                    row.add("");
                } else {
                    row.add(str.substring(index + 1));
                }
            }
            row.add(ai.replicaGroupId);
            vector.add(row);
        }
        this._model.setDataVector(vector, this._columnNames);
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(false);
    }

    public void setSortedMap(SortedMap map) {
        Vector vector = new Vector(map.size());
        Iterator p = map.entrySet().iterator();
        while (p.hasNext()) {
            Vector<String> row = new Vector<String>(2);
            Map.Entry entry = p.next();
            row.add((String)entry.getKey());
            row.add((String)entry.getValue());
            vector.add(row);
        }
        this._model.setDataVector(vector, this._columnNames);
        DefaultTableCellRenderer cr = (DefaultTableCellRenderer)this.getDefaultRenderer(String.class);
        cr.setOpaque(false);
    }
}

