/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.IceBoxDescriptor;
import IceGrid.ServerDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.PlainServer;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.ServerTemplate;
import IceGridGUI.Application.ServiceInstance;
import IceGridGUI.Application.Templates;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JPopupMenu;

class ServerTemplates
extends Templates {
    private Map _descriptors;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static Map copyDescriptors(Map descriptors) {
        HashMap copy = new HashMap();
        Iterator p = descriptors.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            copy.put(entry.getKey(), ServerTemplate.copyDescriptor((TemplateDescriptor)entry.getValue()));
        }
        return copy;
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[10] = true;
        actions[11] = true;
        Object clipboard = this.getCoordinator().getClipboard();
        if (clipboard != null && clipboard instanceof TemplateDescriptor) {
            TemplateDescriptor d = (TemplateDescriptor)clipboard;
            actions[14] = d.descriptor instanceof ServerDescriptor;
        }
        return actions;
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(10));
            _popup.add(actions.get(11));
        }
        actions.setTarget(this);
        return _popup;
    }

    public void newTemplateServer() {
        this.newServerTemplate(new TemplateDescriptor(PlainServer.newServerDescriptor(), new LinkedList(), new TreeMap()));
    }

    public void newTemplateServerIceBox() {
        this.newServerTemplate(new TemplateDescriptor(PlainServer.newIceBoxDescriptor(), new LinkedList(), new TreeMap()));
    }

    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        TemplateDescriptor td = (TemplateDescriptor)descriptor;
        this.newServerTemplate(td);
    }

    ServerTemplates(Root parent, Map descriptors) throws UpdateFailedException {
        super(parent, "Server templates");
        this._descriptors = descriptors;
        Iterator p = this._descriptors.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            this.insertChild(new ServerTemplate(false, this, (String)entry.getKey(), (TemplateDescriptor)entry.getValue()), false);
        }
    }

    Utils.Resolver getResolver() {
        return null;
    }

    Map getUpdates() {
        HashMap<String, Object> updates = new HashMap<String, Object>();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            ServerTemplate t = (ServerTemplate)p.next();
            if (!t.getEditable().isNew() && !t.getEditable().isModified()) continue;
            updates.put(t.getId(), t.getDescriptor());
        }
        return updates;
    }

    void commit() {
        this._editable.commit();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            ServerTemplate st = (ServerTemplate)p.next();
            st.commit();
        }
    }

    List findServiceInstances(String template) {
        LinkedList result = new LinkedList();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            ServerTemplate t = (ServerTemplate)p.next();
            result.addAll(t.findServiceInstances(template));
        }
        return result;
    }

    void removeServiceInstances(String template) {
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            ServerTemplate t = (ServerTemplate)p.next();
            t.removeServiceInstances(template);
        }
    }

    void newServerTemplate(TemplateDescriptor descriptor) {
        ServerTemplate t;
        block2: {
            String id = descriptor.descriptor instanceof IceBoxDescriptor ? this.makeNewChildId("NewIceBoxTemplate") : this.makeNewChildId("NewServerTemplate");
            t = new ServerTemplate(this, id, descriptor);
            try {
                this.insertChild(t, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(t);
    }

    void tryAdd(String newId, TemplateDescriptor descriptor) throws UpdateFailedException {
        this.insertChild(new ServerTemplate(true, this, newId, descriptor), true);
        this._descriptors.put(newId, descriptor);
    }

    void update(Map updates, String[] removeTemplates, Set serviceTemplates) throws UpdateFailedException {
        Root root = this.getRoot();
        this.removeChildren(removeTemplates);
        Vector<ServerTemplate> newChildren = new Vector<ServerTemplate>();
        Vector<ServerTemplate> updatedChildren = new Vector<ServerTemplate>();
        Iterator p = updates.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            String name = (String)entry.getKey();
            TemplateDescriptor templateDescriptor = (TemplateDescriptor)entry.getValue();
            ServerTemplate child = (ServerTemplate)this.findChild(name);
            if (child == null) {
                newChildren.add(new ServerTemplate(false, this, name, templateDescriptor));
                continue;
            }
            child.rebuild(templateDescriptor);
            updatedChildren.add(child);
        }
        p = serviceTemplates.iterator();
        while (p.hasNext()) {
            List serviceInstances = this.findServiceInstances((String)((Object)p.next()));
            Iterator q = serviceInstances.iterator();
            while (q.hasNext()) {
                ServiceInstance service = (ServiceInstance)q.next();
                ServerTemplate serverTemplate = (ServerTemplate)service.getParent();
                if (updatedChildren.contains(serverTemplate) || newChildren.contains(serverTemplate)) continue;
                serverTemplate.rebuild();
                updatedChildren.add(serverTemplate);
            }
        }
        this.childrenChanged(updatedChildren);
        this.insertChildren(newChildren, true);
    }

    void removeDescriptor(String id) {
        this._descriptors.remove(id);
    }

    Object getDescriptor() {
        return this._descriptors;
    }

    static {
        $assertionsDisabled = !ServerTemplates.class.desiredAssertionStatus();
    }
}

