/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.ReplicaGroupDescriptor;
import IceGridGUI.Application.ListTreeNode;
import IceGridGUI.Application.ReplicaGroup;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JPopupMenu;

class ReplicaGroups
extends ListTreeNode {
    private List _descriptors;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static List copyDescriptors(List descriptors) {
        LinkedList<ReplicaGroupDescriptor> copy = new LinkedList<ReplicaGroupDescriptor>();
        Iterator p = descriptors.iterator();
        while (p.hasNext()) {
            copy.add(ReplicaGroup.copyDescriptor((ReplicaGroupDescriptor)p.next()));
        }
        return copy;
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor != null) {
            actions[14] = descriptor instanceof ReplicaGroupDescriptor;
        }
        actions[4] = true;
        return actions;
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(4));
        }
        actions.setTarget(this);
        return _popup;
    }

    public void newReplicaGroup() {
        ReplicaGroupDescriptor descriptor = new ReplicaGroupDescriptor(this.makeNewChildId("NewReplicaGroup"), null, new LinkedList(), "");
        this.newReplicaGroup(descriptor);
    }

    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        ReplicaGroupDescriptor d = ReplicaGroup.copyDescriptor((ReplicaGroupDescriptor)descriptor);
        d.id = this.makeNewChildId(d.id);
        this.newReplicaGroup(d);
    }

    ReplicaGroups(TreeNode parent, List desc) throws UpdateFailedException {
        super(false, parent, "Replica Groups");
        this._descriptors = desc;
        Iterator p = this._descriptors.iterator();
        while (p.hasNext()) {
            ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)p.next();
            this.insertChild(new ReplicaGroup(false, this, descriptor), false);
        }
    }

    LinkedList getUpdates() {
        LinkedList<Object> updates = new LinkedList<Object>();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            ReplicaGroup ra = (ReplicaGroup)p.next();
            if (!ra.getEditable().isNew() && !ra.getEditable().isModified()) continue;
            updates.add(ra.getDescriptor());
        }
        return updates;
    }

    void commit() {
        this._editable.commit();
        Iterator p = this._children.iterator();
        while (p.hasNext()) {
            ReplicaGroup rg = (ReplicaGroup)p.next();
            rg.commit();
        }
    }

    void update(List descriptors, String[] removeReplicaGroups) {
        this._descriptors = descriptors;
        this.removeChildren(removeReplicaGroups);
        LinkedList<ReplicaGroup> updatedChildren = new LinkedList<ReplicaGroup>();
        Iterator p = descriptors.iterator();
        while (p.hasNext()) {
            ReplicaGroupDescriptor descriptor = (ReplicaGroupDescriptor)p.next();
            ReplicaGroup child = (ReplicaGroup)this.findChild(descriptor.id);
            if (child == null) {
                try {
                    this.insertChild(new ReplicaGroup(false, this, descriptor), true);
                    continue;
                }
                catch (UpdateFailedException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    continue;
                }
            }
            child.rebuild(descriptor);
            updatedChildren.add(child);
        }
        this.childrenChanged(updatedChildren);
    }

    Object getDescriptor() {
        return this._descriptors;
    }

    void removeDescriptor(Object descriptor) {
        Iterator p = this._descriptors.iterator();
        while (p.hasNext()) {
            if (descriptor != p.next()) continue;
            p.remove();
            break;
        }
    }

    void tryAdd(ReplicaGroupDescriptor descriptor, boolean addDescriptor) throws UpdateFailedException {
        this.insertChild(new ReplicaGroup(true, this, descriptor), true);
        if (addDescriptor) {
            this._descriptors.add(descriptor);
        }
    }

    private void newReplicaGroup(ReplicaGroupDescriptor descriptor) {
        ReplicaGroup replicaGroup;
        block2: {
            replicaGroup = new ReplicaGroup((TreeNode)this, descriptor);
            try {
                this.insertChild(replicaGroup, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(replicaGroup);
    }

    static {
        $assertionsDisabled = !ReplicaGroups.class.desiredAssertionStatus();
    }
}

