/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.PropertySetDescriptor;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.PropertySetEditor;
import IceGridGUI.Application.PropertySetParent;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class PropertySet
extends TreeNode {
    private PropertySetDescriptor _descriptor;
    private final boolean _ephemeral;
    private final Editable _editable;
    private PropertySetEditor _editor;
    private static DefaultTreeCellRenderer _cellRenderer;

    public static PropertySetDescriptor copyDescriptor(PropertySetDescriptor d) {
        PropertySetDescriptor psd = (PropertySetDescriptor)d.clone();
        psd.properties = new LinkedList(psd.properties);
        return psd;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            _cellRenderer.setLeafIcon(Utils.getIcon("/icons/16x16/property_set.png"));
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = true;
        if (((TreeNode)this._parent).getAvailableActions()[14]) {
            actions[14] = true;
        }
        actions[15] = true;
        if (!this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
        }
        return actions;
    }

    public void copy() {
        this.getCoordinator().setClipboard(PropertySet.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public void paste() {
        ((TreeNode)this._parent).paste();
    }

    public void destroy() {
        PropertySetParent parent = (PropertySetParent)((Object)this._parent);
        parent.removePropertySet(this);
        if (!this._ephemeral) {
            parent.removeDescriptor(this._id);
            parent.getEditable().removeElement(this._id, this._editable, PropertySet.class);
            this.getRoot().updated();
        }
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (PropertySetEditor)this.getRoot().getEditor(PropertySetEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new PropertySetEditor();
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    Object getDescriptor() {
        return this._descriptor;
    }

    void commit() {
        this._editable.commit();
    }

    Editable getEditable() {
        return this._editable;
    }

    PropertySet(boolean brandNew, TreeNode parent, String id, PropertySetDescriptor descriptor) {
        super(parent, id);
        this._ephemeral = false;
        this._editable = new Editable(brandNew);
        this.rebuild(descriptor);
    }

    PropertySet(TreeNode parent, String id, PropertySetDescriptor descriptor) {
        super(parent, id);
        this._ephemeral = true;
        this._editable = null;
        this.rebuild(descriptor);
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            PropertySet.writePropertySet(writer, this._id, this._descriptor, null);
        }
    }

    void rebuild(PropertySetDescriptor descriptor) {
        this._descriptor = descriptor;
    }
}

